/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import groovy.util.Node;
import groovy.util.NodeList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.Cast;
import org.gradle.plugins.ide.eclipse.model.AccessRule;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public abstract class AbstractClasspathEntry
implements ClasspathEntry {
    private static final String NATIVE_LIBRARY_ATTRIBUTE = "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    public static final String COMPONENT_NON_DEPENDENCY_ATTRIBUTE = "org.eclipse.jst.component.nondependency";
    public static final String COMPONENT_DEPENDENCY_ATTRIBUTE = "org.eclipse.jst.component.dependency";
    protected String path;
    protected boolean exported;
    protected Set<AccessRule> accessRules;
    protected final Map<String, Object> entryAttributes;

    public AbstractClasspathEntry(Node node) {
        this.path = this.normalizePath((String)node.attribute((Object)"path"));
        this.exported = this.isNodeExported(node);
        this.accessRules = this.readAccessRules(node);
        this.entryAttributes = this.readEntryAttributes(node);
        Preconditions.checkNotNull((Object)this.path);
        Preconditions.checkNotNull(this.accessRules);
    }

    private boolean isNodeExported(Node node) {
        Object value = node.attribute((Object)"exported");
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean((String)value);
    }

    public AbstractClasspathEntry(String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = this.normalizePath(path);
        this.exported = false;
        this.accessRules = new LinkedHashSet<AccessRule>();
        this.entryAttributes = new LinkedHashMap<String, Object>();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    public Set<AccessRule> getAccessRules() {
        return this.accessRules;
    }

    public void setAccessRules(Set<AccessRule> accessRules) {
        this.accessRules = accessRules;
    }

    public Map<String, Object> getEntryAttributes() {
        return this.entryAttributes;
    }

    public String getNativeLibraryLocation() {
        return (String)this.entryAttributes.get(NATIVE_LIBRARY_ATTRIBUTE);
    }

    public void setNativeLibraryLocation(String location) {
        this.entryAttributes.put(NATIVE_LIBRARY_ATTRIBUTE, location);
    }

    @Override
    public void appendNode(Node node) {
        this.addClasspathEntry(node, (Map<String, ?>)ImmutableMap.of());
    }

    protected Node addClasspathEntry(Node node, Map<String, ?> attributes) {
        ImmutableMap.Builder allAttributes = ImmutableMap.builder();
        attributes.forEach((key, value) -> {
            if (value != null && !String.valueOf(value).isEmpty()) {
                allAttributes.put(key, value);
            }
        });
        allAttributes.put((Object)"kind", (Object)this.getKind());
        allAttributes.put((Object)"path", (Object)this.path);
        if (this.exported && !(this instanceof SourceFolder)) {
            allAttributes.put((Object)"exported", (Object)true);
        }
        Node entryNode = node.appendNode((Object)"classpathentry", (Map)allAttributes.build());
        this.writeAccessRules(entryNode);
        this.writeEntryAttributes(entryNode);
        return entryNode;
    }

    protected String normalizePath(String path) {
        return PathUtil.normalizePath(path);
    }

    private Set<AccessRule> readAccessRules(Node node) {
        LinkedHashSet<AccessRule> accessRules = new LinkedHashSet<AccessRule>();
        NodeList accessRulesNodes = (NodeList)node.get("accessrules");
        for (Object accessRulesNode : accessRulesNodes) {
            NodeList accessRuleNodes = (NodeList)((Node)accessRulesNode).get("accessrule");
            for (Object accessRuleNode : accessRuleNodes) {
                Node ruleNode = (Node)accessRuleNode;
                accessRules.add(new AccessRule((String)ruleNode.attribute((Object)"kind"), (String)ruleNode.attribute((Object)"pattern")));
            }
        }
        return accessRules;
    }

    private void writeAccessRules(Node node) {
        if (this.accessRules == null || this.accessRules.isEmpty()) {
            return;
        }
        Node accessRulesNode = AbstractClasspathEntry.getAttributesNode(node, "accessrules");
        for (AccessRule rule : this.accessRules) {
            accessRulesNode.appendNode((Object)"accessrule", (Map)ImmutableMap.of((Object)"kind", (Object)rule.getKind(), (Object)"pattern", (Object)rule.getPattern()));
        }
    }

    private Map<String, Object> readEntryAttributes(Node node) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        NodeList attributesNodes = (NodeList)node.get("attributes");
        for (Object attributesEntry : attributesNodes) {
            NodeList attributeNodes = (NodeList)((Node)attributesEntry).get("attribute");
            for (Object attributeEntry : attributeNodes) {
                Node attributeNode = (Node)attributeEntry;
                attributes.put((String)attributeNode.attribute((Object)"name"), attributeNode.attribute((Object)"value"));
            }
        }
        return attributes;
    }

    public void writeEntryAttributes(Node node) {
        Map<String, Object> effectiveEntryAttrs = this.getEffectiveEntryAttrs();
        if (effectiveEntryAttrs.isEmpty()) {
            return;
        }
        Node attributesNode = AbstractClasspathEntry.getAttributesNode(node, "attributes");
        effectiveEntryAttrs.forEach((key, value) -> {
            if (value instanceof Iterable) {
                ((Iterable)Cast.uncheckedCast((Object)value)).forEach(valueElement -> attributesNode.appendNode((Object)"attribute", (Map)ImmutableMap.of((Object)"name", (Object)key, (Object)"value", (Object)valueElement)));
            } else {
                attributesNode.appendNode((Object)"attribute", (Map)ImmutableMap.of((Object)"name", (Object)key, (Object)"value", (Object)value));
            }
        });
    }

    private Map<String, Object> getEffectiveEntryAttrs() {
        return this.entryAttributes.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
    }

    private static Node getAttributesNode(Node node, String attributes) {
        NodeList attributesNodes = (NodeList)node.get(attributes);
        if (attributesNodes.isEmpty()) {
            return node.appendNode((Object)attributes);
        }
        return (Node)attributesNodes.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClasspathEntry that = (AbstractClasspathEntry)o;
        return this.exported == that.exported && Objects.equal((Object)this.path, (Object)that.path) && Objects.equal(this.accessRules, that.accessRules) && Objects.equal((Object)this.getNativeLibraryLocation(), (Object)that.getNativeLibraryLocation());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.exported, this.accessRules, this.getNativeLibraryLocation()});
    }

    public String toString() {
        return "{path='" + this.path + "', nativeLibraryLocation='" + this.getNativeLibraryLocation() + "', exported=" + this.exported + ", accessRules=" + this.accessRules + "}";
    }
}

