/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.StaticRecMutex;

private import glib.c.functions;
public  import glib.c.types;


/**
 * A #GStaticRecMutex works like a #GStaticMutex, but it can be locked
 * multiple times by one thread. If you enter it n times, you have to
 * unlock it n times again to let other threads lock it. An exception
 * is the function g_static_rec_mutex_unlock_full(): that allows you to
 * unlock a #GStaticRecMutex completely returning the depth, (i.e. the
 * number of times this mutex was locked). The depth can later be used
 * to restore the state of the #GStaticRecMutex by calling
 * g_static_rec_mutex_lock_full(). In GLib 2.32, #GStaticRecMutex has
 * been deprecated in favor of #GRecMutex.
 * 
 * Even though #GStaticRecMutex is not opaque, it should only be used
 * with the following functions.
 * 
 * All of the g_static_rec_mutex_* functions can be used even if
 * g_thread_init() has not been called. Then they do nothing, apart
 * from g_static_rec_mutex_trylock(), which does nothing but returning
 * %TRUE.
 */
public class StaticRecMutex
{
	/** the main Gtk struct */
	protected GStaticRecMutex* gStaticRecMutex;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GStaticRecMutex* getStaticRecMutexStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gStaticRecMutex;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gStaticRecMutex;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GStaticRecMutex* gStaticRecMutex, bool ownedRef = false)
	{
		this.gStaticRecMutex = gStaticRecMutex;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			g_static_rec_mutex_free(gStaticRecMutex);
	}


	/**
	 * Releases all resources allocated to a #GStaticRecMutex.
	 *
	 * You don't have to call this functions for a #GStaticRecMutex with an
	 * unbounded lifetime, i.e. objects declared 'static', but if you have
	 * a #GStaticRecMutex as a member of a structure and the structure is
	 * freed, you should also free the #GStaticRecMutex.
	 *
	 * Deprecated: Use g_rec_mutex_clear()
	 */
	public void free()
	{
		g_static_rec_mutex_free(gStaticRecMutex);
		ownedRef = false;
	}

	/**
	 * A #GStaticRecMutex must be initialized with this function before it
	 * can be used. Alternatively you can initialize it with
	 * %G_STATIC_REC_MUTEX_INIT.
	 *
	 * Deprecated: Use g_rec_mutex_init()
	 */
	public void init()
	{
		g_static_rec_mutex_init(gStaticRecMutex);
	}

	/**
	 * Locks @mutex. If @mutex is already locked by another thread, the
	 * current thread will block until @mutex is unlocked by the other
	 * thread. If @mutex is already locked by the calling thread, this
	 * functions increases the depth of @mutex and returns immediately.
	 *
	 * Deprecated: Use g_rec_mutex_lock()
	 */
	public void lock()
	{
		g_static_rec_mutex_lock(gStaticRecMutex);
	}

	/**
	 * Works like calling g_static_rec_mutex_lock() for @mutex @depth times.
	 *
	 * Deprecated: Use g_rec_mutex_lock()
	 *
	 * Params:
	 *     depth = number of times this mutex has to be unlocked to be
	 *         completely unlocked.
	 */
	public void lockFull(uint depth)
	{
		g_static_rec_mutex_lock_full(gStaticRecMutex, depth);
	}

	/**
	 * Tries to lock @mutex. If @mutex is already locked by another thread,
	 * it immediately returns %FALSE. Otherwise it locks @mutex and returns
	 * %TRUE. If @mutex is already locked by the calling thread, this
	 * functions increases the depth of @mutex and immediately returns
	 * %TRUE.
	 *
	 * Deprecated: Use g_rec_mutex_trylock()
	 *
	 * Returns: %TRUE, if @mutex could be locked.
	 */
	public bool trylock()
	{
		return g_static_rec_mutex_trylock(gStaticRecMutex) != 0;
	}

	/**
	 * Unlocks @mutex. Another thread will be allowed to lock @mutex only
	 * when it has been unlocked as many times as it had been locked
	 * before. If @mutex is completely unlocked and another thread is
	 * blocked in a g_static_rec_mutex_lock() call for @mutex, it will be
	 * woken and can lock @mutex itself.
	 *
	 * Deprecated: Use g_rec_mutex_unlock()
	 */
	public void unlock()
	{
		g_static_rec_mutex_unlock(gStaticRecMutex);
	}

	/**
	 * Completely unlocks @mutex. If another thread is blocked in a
	 * g_static_rec_mutex_lock() call for @mutex, it will be woken and can
	 * lock @mutex itself. This function returns the number of times that
	 * @mutex has been locked by the current thread. To restore the state
	 * before the call to g_static_rec_mutex_unlock_full() you can call
	 * g_static_rec_mutex_lock_full() with the depth returned by this
	 * function.
	 *
	 * Deprecated: Use g_rec_mutex_unlock()
	 *
	 * Returns: number of times @mutex has been locked by the current
	 *     thread.
	 */
	public uint unlockFull()
	{
		return g_static_rec_mutex_unlock_full(gStaticRecMutex);
	}
}
