/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;

public class CompositeButtonModel
extends DefaultButtonModel {
    protected ButtonModel primaryModel;
    protected ButtonModel[] secondaryModels;

    public CompositeButtonModel(ButtonModel primaryModel, ButtonModel ... secondaryModels) {
        this.primaryModel = primaryModel;
        this.secondaryModels = secondaryModels;
    }

    public CompositeButtonModel(ButtonModel primaryModel, AbstractButton ... secondaryButtons) {
        this.primaryModel = primaryModel;
        LinkedList<ButtonModel> bmList = new LinkedList<ButtonModel>();
        for (AbstractButton secondary : secondaryButtons) {
            if (secondary == null) continue;
            bmList.add(secondary.getModel());
        }
        this.secondaryModels = bmList.toArray(new ButtonModel[0]);
    }

    @Override
    public boolean isRollover() {
        if (this.primaryModel != null && this.primaryModel.isRollover()) {
            return true;
        }
        for (ButtonModel secondary : this.secondaryModels) {
            if (secondary == null || !secondary.isRollover()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArmed() {
        return this.primaryModel != null && this.primaryModel.isArmed();
    }

    @Override
    public boolean isEnabled() {
        return this.primaryModel != null && this.primaryModel.isEnabled();
    }

    @Override
    public boolean isPressed() {
        return this.primaryModel != null && this.primaryModel.isPressed();
    }

    @Override
    public boolean isSelected() {
        return this.primaryModel != null && this.primaryModel.isSelected();
    }
}

