/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.action;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.performanceanalyzer.action.PerformanceAnalyzerActionListener;
import org.opensearch.performanceanalyzer.action.RequestType;
import org.opensearch.performanceanalyzer.commons.util.Util;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.tasks.Task;

public class PerformanceAnalyzerActionFilter
implements ActionFilter {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerActionFilter.class);
    private static AtomicLong uniqueID = new AtomicLong(0L);
    private final PerformanceAnalyzerController controller;

    @Inject
    public PerformanceAnalyzerActionFilter(PerformanceAnalyzerController controller) {
        this.controller = controller;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        if (this.controller.isPerformanceAnalyzerEnabled() && (this.controller.getCollectorsRunModeValue() == Util.CollectorMode.DUAL.getValue() || this.controller.getCollectorsRunModeValue() == Util.CollectorMode.RCA.getValue())) {
            if (request instanceof BulkRequest) {
                PerformanceAnalyzerActionListener newListener = new PerformanceAnalyzerActionListener();
                String id = String.valueOf(uniqueID.getAndIncrement());
                long startTime = System.currentTimeMillis();
                BulkRequest bulk = (BulkRequest)request;
                newListener.set(RequestType.bulk, id, listener);
                newListener.saveMetricValues(PerformanceAnalyzerActionListener.generateStartMetrics(startTime, "", bulk.requests().size()), startTime, new String[]{RequestType.bulk.toString(), id, "start"});
                chain.proceed(task, action, request, newListener);
                return;
            }
            if (request instanceof SearchRequest) {
                PerformanceAnalyzerActionListener newListener = new PerformanceAnalyzerActionListener();
                String id = String.valueOf(uniqueID.getAndIncrement());
                long startTime = System.currentTimeMillis();
                SearchRequest search = (SearchRequest)request;
                newListener.set(RequestType.search, id, listener);
                newListener.saveMetricValues(PerformanceAnalyzerActionListener.generateStartMetrics(startTime, String.join((CharSequence)",", search.indices()), 0), startTime, new String[]{RequestType.search.toString(), id, "start"});
                chain.proceed(task, action, request, newListener);
                return;
            }
        }
        chain.proceed(task, action, request, listener);
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

