/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.model.SetClusterPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ClusterPropertiesApi {

    public static class ListClusterProperties
    extends SolrRequest<ListClusterPropertiesResponse> {
        public ListClusterProperties() {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/properties");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListClusterPropertiesResponse createResponse(SolrClient client) {
            return new ListClusterPropertiesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListClusterPropertiesResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.ListClusterPropertiesResponse> {
        public ListClusterPropertiesResponse() {
            super(org.apache.solr.client.api.model.ListClusterPropertiesResponse.class);
        }
    }

    public static class GetClusterProperty
    extends SolrRequest<GetClusterPropertyResponse> {
        private final String propertyName;

        public GetClusterProperty(String propertyName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/properties/{propertyName}".replace("{propertyName}", propertyName));
            this.propertyName = propertyName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetClusterPropertyResponse createResponse(SolrClient client) {
            return new GetClusterPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetClusterPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public GetClusterPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class DeleteClusterProperty
    extends SolrRequest<DeleteClusterPropertyResponse> {
        private final String propertyName;

        public DeleteClusterProperty(String propertyName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/cluster/properties/{propertyName}".replace("{propertyName}", propertyName));
            this.propertyName = propertyName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected DeleteClusterPropertyResponse createResponse(SolrClient client) {
            return new DeleteClusterPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteClusterPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteClusterPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CreateOrUpdateNestedClusterProperty
    extends SolrRequest<CreateOrUpdateNestedClusterPropertyResponse> {
        private final Map<String, Object> requestBody = new HashMap<String, Object>();

        public CreateOrUpdateNestedClusterProperty() {
            super(SolrRequest.METHOD.valueOf("PUT"), "/cluster/properties");
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CreateOrUpdateNestedClusterPropertyResponse createResponse(SolrClient client) {
            return new CreateOrUpdateNestedClusterPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateOrUpdateNestedClusterPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateOrUpdateNestedClusterPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CreateOrUpdateClusterProperty
    extends SolrRequest<CreateOrUpdateClusterPropertyResponse> {
        private final SetClusterPropertyRequestBody requestBody;
        private final String propertyName;

        public CreateOrUpdateClusterProperty(String propertyName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/cluster/properties/{propertyName}".replace("{propertyName}", propertyName));
            this.propertyName = propertyName;
            this.requestBody = new SetClusterPropertyRequestBody();
        }

        public void setValue(String value) {
            this.requestBody.value = value;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CreateOrUpdateClusterPropertyResponse createResponse(SolrClient client) {
            return new CreateOrUpdateClusterPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateOrUpdateClusterPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateOrUpdateClusterPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

