// This file is part of VSTGUI. It is subject to the license terms
// in the LICENSE file found in the top-level directory of this
// distribution and at http://github.com/steinbergmedia/vstgui/LICENSE

#pragma once

#include "../../../include/ipreference.h"
#include <sqlite3.h>

//------------------------------------------------------------------------
namespace VSTGUI {
namespace Standalone {
namespace Platform {
namespace GDK {

//------------------------------------------------------------------------
class Preference : public IPreference
{
public:
	Preference ();
	~Preference () noexcept;

	bool set (const UTF8String& key, const UTF8String& value) override;
	Optional<UTF8String> get (const UTF8String& key) override;

private:
	bool prepare ();

	sqlite3* db{nullptr};
};

//------------------------------------------------------------------------
} // GDK
} // Platform
} // Standalone
} // VSTGUI
