=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsWorkbookApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_workbook_delete_decrypt_document
#
# Decrypt document.
# 
# @param string $name The document name. (required)
# @param WorkbookEncryptionRequest $encryption Encryption settings, only password can be specified. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'encryption' => {
        data_type => 'WorkbookEncryptionRequest',
        description => 'Encryption settings, only password can be specified.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_decrypt_document' } = { 
    	summary => 'Decrypt document.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_delete_decrypt_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_decrypt_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/encryption';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'encryption'}) {
        $_body_data = $args{'encryption'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_document_unprotect_from_changes
#
# Unprotect document from changes.
# 
# @param string $name The document name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_document_unprotect_from_changes' } = { 
    	summary => 'Unprotect document from changes.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_delete_document_unprotect_from_changes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_document_unprotect_from_changes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/writeProtection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_unprotect_document
#
# Unprotect document.
# 
# @param string $name The document name. (required)
# @param WorkbookProtectionRequest $protection Protection settings, only password can be specified. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'protection' => {
        data_type => 'WorkbookProtectionRequest',
        description => 'Protection settings, only password can be specified.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_unprotect_document' } = { 
    	summary => 'Unprotect document.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_delete_unprotect_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_unprotect_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/protection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'protection'}) {
        $_body_data = $args{'protection'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_workbook_name
#
# Clean workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_workbook_name' } = { 
    	summary => 'Clean workbook&#39;s names.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_delete_workbook_name {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_workbook_name");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_delete_workbook_name");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_workbook_names
#
# Clean workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_workbook_names' } = { 
    	summary => 'Clean workbook&#39;s names.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_delete_workbook_names {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_workbook_names");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook
#
# Read workbook info or export.
# 
# @param string $name The document name. (required)
# @param string $password The document password. (optional)
# @param string $format The exported file format. (optional)
# @param boolean $is_auto_fit Set document rows to be autofit. (optional, default to false)
# @param boolean $only_save_table Only save table data. (optional, default to false)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
# @param string $out_path The document output folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'is_auto_fit' => {
        data_type => 'boolean',
        description => 'Set document rows to be autofit.',
        required => '0',
    },
    'only_save_table' => {
        data_type => 'boolean',
        description => 'Only save table data.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'The document output folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook' } = { 
    	summary => 'Read workbook info or export.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_get_workbook {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'is_auto_fit'}) {
        $query_params->{'isAutoFit'} = $self->{api_client}->to_query_value($args{'is_auto_fit'});
    }

    # query params
    if ( exists $args{'only_save_table'}) {
        $query_params->{'onlySaveTable'} = $self->{api_client}->to_query_value($args{'only_save_table'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_default_style
#
# Read workbook default style info.
# 
# @param string $name The workbook name. (required)
# @param string $folder The document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_default_style' } = { 
    	summary => 'Read workbook default style info.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_workbook_get_workbook_default_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_default_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/defaultstyle';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_name
#
# Read workbook's name.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_name' } = { 
    	summary => 'Read workbook&#39;s name.',
        params => $params,
        returns => 'NameResponse',
        };
}
# @return NameResponse
#
sub cells_workbook_get_workbook_name {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_name");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_get_workbook_name");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NameResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_name_value
#
# Get workbook's name value.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_name_value' } = { 
    	summary => 'Get workbook&#39;s name value.',
        params => $params,
        returns => 'RangeValueResponse',
        };
}
# @return RangeValueResponse
#
sub cells_workbook_get_workbook_name_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_name_value");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_get_workbook_name_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}/value';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangeValueResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_names
#
# Read workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_names' } = { 
    	summary => 'Read workbook&#39;s names.',
        params => $params,
        returns => 'NamesResponse',
        };
}
# @return NamesResponse
#
sub cells_workbook_get_workbook_names {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_names");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NamesResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_settings
#
# Get Workbook Settings DTO
# 
# @param string $name Document name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_settings' } = { 
    	summary => 'Get Workbook Settings DTO',
        params => $params,
        returns => 'WorkbookSettingsResponse',
        };
}
# @return WorkbookSettingsResponse
#
sub cells_workbook_get_workbook_settings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_settings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/settings';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookSettingsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_text_items
#
# Read workbook's text items.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_text_items' } = { 
    	summary => 'Read workbook&#39;s text items.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_workbook_get_workbook_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_text_items");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_autofit_workbook_rows
#
# Autofit workbook rows.
# 
# @param string $name Document name. (required)
# @param AutoFitterOptions $auto_fitter_options Auto Fitter Options. (optional)
# @param int $start_row Start row. (optional)
# @param int $end_row End row. (optional)
# @param boolean $only_auto Only auto. (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => 'Auto Fitter Options.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'Start row.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'End row.',
        required => '0',
    },
    'only_auto' => {
        data_type => 'boolean',
        description => 'Only auto.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_autofit_workbook_rows' } = { 
    	summary => 'Autofit workbook rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_autofit_workbook_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_autofit_workbook_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/autofitrows';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'only_auto'}) {
        $query_params->{'onlyAuto'} = $self->{api_client}->to_query_value($args{'only_auto'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_encrypt_document
#
# Encript document.
# 
# @param string $name The document name. (required)
# @param WorkbookEncryptionRequest $encryption Encryption parameters. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'encryption' => {
        data_type => 'WorkbookEncryptionRequest',
        description => 'Encryption parameters.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_encrypt_document' } = { 
    	summary => 'Encript document.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_encrypt_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_encrypt_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/encryption';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'encryption'}) {
        $_body_data = $args{'encryption'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_import_data
#
# 
# 
# @param string $name  (required)
# @param String $importdata  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'importdata' => {
        data_type => 'String',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_import_data' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_import_data {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_import_data");
    }

    # verify the required parameter 'importdata' is set
    unless (exists $args{'importdata'}) {
      croak("Missing the required parameter 'importdata' when calling cells_workbook_post_import_data");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/importdata';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'importdata'}) {
        $_body_data = $args{'importdata'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_protect_document
#
# Protect document.
# 
# @param string $name The document name. (required)
# @param WorkbookProtectionRequest $protection The protection settings. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'protection' => {
        data_type => 'WorkbookProtectionRequest',
        description => 'The protection settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_protect_document' } = { 
    	summary => 'Protect document.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_protect_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_protect_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/protection';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'protection'}) {
        $_body_data = $args{'protection'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_calculate_formula
#
# Calculate all formulas in workbook.
# 
# @param string $name Document name. (required)
# @param CalculationOptions $options Calculation Options. (optional)
# @param boolean $ignore_error ignore Error. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'options' => {
        data_type => 'CalculationOptions',
        description => 'Calculation Options.',
        required => '0',
    },
    'ignore_error' => {
        data_type => 'boolean',
        description => 'ignore Error.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_calculate_formula' } = { 
    	summary => 'Calculate all formulas in workbook.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_workbook_calculate_formula {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_calculate_formula");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/calculateformula';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'ignore_error'}) {
        $query_params->{'ignoreError'} = $self->{api_client}->to_query_value($args{'ignore_error'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_get_smart_marker_result
#
# Smart marker processing result.
# 
# @param string $name The workbook name. (required)
# @param string $xml_file The xml file full path, if empty the data is read from request body. (optional)
# @param string $folder The workbook folder full path. (optional)
# @param string $storage storage name. (optional)
# @param string $out_path Path to save result (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'xml_file' => {
        data_type => 'string',
        description => 'The xml file full path, if empty the data is read from request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder full path.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_get_smart_marker_result' } = { 
    	summary => 'Smart marker processing result.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_post_workbook_get_smart_marker_result {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_get_smart_marker_result");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/smartmarker';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'xml_file'}) {
        $query_params->{'xmlFile'} = $self->{api_client}->to_query_value($args{'xml_file'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_settings
#
# Update Workbook setting 
# 
# @param string $name Document name. (required)
# @param WorkbookSettings $settings Workbook Setting DTO (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'settings' => {
        data_type => 'WorkbookSettings',
        description => 'Workbook Setting DTO',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_settings' } = { 
    	summary => 'Update Workbook setting ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_post_workbook_settings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_settings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/settings';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'settings'}) {
        $_body_data = $args{'settings'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_split
#
# Split workbook.
# 
# @param string $name The workbook name. (required)
# @param string $format Split format. (optional)
# @param int $from Start worksheet index. (optional, default to 0)
# @param int $to End worksheet index. (optional, default to 0)
# @param int $horizontal_resolution Image horizontal resolution. (optional, default to 0)
# @param int $vertical_resolution Image vertical resolution. (optional, default to 0)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Split format.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'Start worksheet index.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'End worksheet index.',
        required => '0',
    },
    'horizontal_resolution' => {
        data_type => 'int',
        description => 'Image horizontal resolution.',
        required => '0',
    },
    'vertical_resolution' => {
        data_type => 'int',
        description => 'Image vertical resolution.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_split' } = { 
    	summary => 'Split workbook.',
        params => $params,
        returns => 'SplitResultResponse',
        };
}
# @return SplitResultResponse
#
sub cells_workbook_post_workbook_split {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_split");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/split';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if ( exists $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if ( exists $args{'horizontal_resolution'}) {
        $query_params->{'horizontalResolution'} = $self->{api_client}->to_query_value($args{'horizontal_resolution'});
    }

    # query params
    if ( exists $args{'vertical_resolution'}) {
        $query_params->{'verticalResolution'} = $self->{api_client}->to_query_value($args{'vertical_resolution'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SplitResultResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_merge
#
# Merge workbooks.
# 
# @param string $name Workbook name. (required)
# @param string $merge_with The workbook to merge with. (required)
# @param string $folder Source workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'merge_with' => {
        data_type => 'string',
        description => 'The workbook to merge with.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Source workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_merge' } = { 
    	summary => 'Merge workbooks.',
        params => $params,
        returns => 'WorkbookResponse',
        };
}
# @return WorkbookResponse
#
sub cells_workbook_post_workbooks_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_merge");
    }

    # verify the required parameter 'merge_with' is set
    unless (exists $args{'merge_with'}) {
      croak("Missing the required parameter 'merge_with' when calling cells_workbook_post_workbooks_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'merge_with'}) {
        $query_params->{'mergeWith'} = $self->{api_client}->to_query_value($args{'merge_with'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_text_replace
#
# Replace text.
# 
# @param string $name Document name. (required)
# @param string $old_value The old value. (required)
# @param string $new_value The new value. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'The old value.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'The new value.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_text_replace' } = { 
    	summary => 'Replace text.',
        params => $params,
        returns => 'WorkbookReplaceResponse',
        };
}
# @return WorkbookReplaceResponse
#
sub cells_workbook_post_workbooks_text_replace {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_text_replace");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling cells_workbook_post_workbooks_text_replace");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling cells_workbook_post_workbooks_text_replace");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if ( exists $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookReplaceResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_text_search
#
# Search text.
# 
# @param string $name Document name. (required)
# @param string $text Text sample. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text sample.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_text_search' } = { 
    	summary => 'Search text.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_workbook_post_workbooks_text_search {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_text_search");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'}) {
      croak("Missing the required parameter 'text' when calling cells_workbook_post_workbooks_text_search");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/findText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_put_convert_workbook
#
# Convert workbook from request content to some format.
# 
# @param string $workbook  (required)
# @param string $format The format to convert. (optional)
# @param string $password The workbook password. (optional)
# @param string $out_path Path to save result (optional)
{
    my $params = {
    'workbook' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The format to convert.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The workbook password.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_convert_workbook' } = { 
    	summary => 'Convert workbook from request content to some format.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_put_convert_workbook {
    my ($self, %args) = @_;

    # verify the required parameter 'workbook' is set
    unless (exists $args{'workbook'}) {
      croak("Missing the required parameter 'workbook' when calling cells_workbook_put_convert_workbook");
    }

    # parse inputs
    my $_resource_path = '/cells/convert';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    my $_body_data;
    # body params
    if ( exists $args{'workbook'}) {
        $_body_data = $args{'workbook'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_put_document_protect_from_changes
#
# Protect document from changes.
# 
# @param string $name Document name. (required)
# @param PasswordRequest $password Modification password. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'PasswordRequest',
        description => 'Modification password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_document_protect_from_changes' } = { 
    	summary => 'Protect document from changes.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_workbook_put_document_protect_from_changes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_put_document_protect_from_changes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/writeProtection';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'password'}) {
        $_body_data = $args{'password'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_workbook_put_workbook_create
#
# Create new workbook using deferent methods.
# 
# @param string $name The new document name. (required)
# @param string $template_file The template file, if the data not provided default workbook is created. (optional)
# @param string $data_file Smart marker data file, if the data not provided the request content is checked for the data. (optional)
# @param string $folder The new document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The new document name.',
        required => '1',
    },
    'template_file' => {
        data_type => 'string',
        description => 'The template file, if the data not provided default workbook is created.',
        required => '0',
    },
    'data_file' => {
        data_type => 'string',
        description => 'Smart marker data file, if the data not provided the request content is checked for the data.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The new document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_workbook_create' } = { 
    	summary => 'Create new workbook using deferent methods.',
        params => $params,
        returns => 'WorkbookResponse',
        };
}
# @return WorkbookResponse
#
sub cells_workbook_put_workbook_create {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_put_workbook_create");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'template_file'}) {
        $query_params->{'templateFile'} = $self->{api_client}->to_query_value($args{'template_file'});
    }

    # query params
    if ( exists $args{'data_file'}) {
        $query_params->{'dataFile'} = $self->{api_client}->to_query_value($args{'data_file'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookResponse', $response);
    return $_response_object;
}

1;
