#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Test::MockModule;
use Test::Exception;

use Git::Wrapper::More;

# debug
# close(STDERR);
# my $hide_stderr;
# open( STDERR, ">>", \$hide_stderr );

{
    my $label = 'Happy Path';

    my $mgw = Test::MockModule->new('Git::Wrapper');
    $mgw->mock(
        'config',
        sub {
            my $self = shift;
            return 'origin';
        },
    );
    $mgw->mock(
        'merge_base',
        sub {
            my $self = shift;
            return '73603e09df6d97e58544068d93e5d9185e3548fc';
        },
    );
    $mgw->mock(
        'log',
        sub {
            my $self = shift;
            return ( 'commit ef46317efb1765d01d67c0d5ba1af878f0ab2404
Author: Marco Ferrufino <marco@cpanel.net>
Date:   Tue Jun 25 23:06:55 2019 -0500

    Complete _run_cmd.t
    
    But it really needs to be golfd',

'commit 15b23dd768b880cf3eadcaa2b77c698b724d393e
Author: Marco Ferrufino <marco@cpanel.net>
Date:   Tue Jun 25 21:27:57 2019 -0500

    Adding tests: show & _run_cmd',

'commit 0bcbd0b1254ade84cfb081da46a3e4fc5a77002a
Author: Marco Ferrufino <marco@cpanel.net>
Date:   Tue Jun 25 16:02:04 2019 -0500

    Use ternaries
    
    This might be reverted for clarity reasons' );
        },
    );

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir', verbose => 1 );

    # TODO almost testing 1=1. This was needed since logfiles uses
    #  RUN('log'..), which was difficult to complete the mocking
    my $mgwm = Test::MockModule->new('Git::Wrapper::More');
    $mgwm->mock(
        'logfiles',
        sub {
            my $self = shift;
            return ('/file/one.pm', '/file/two.pm');
        },
    );

    my @ret = $gwm->diffbranchesmergecommit('dummy_branch', 'master');
    like( $ret[0], qr/one/, 'finds file one' );
    like( $ret[1], qr/two/, 'finds file two' );
}

done_testing();

exit;

__END__
