#! /usr/bin/env raku

use JSON::Fast;
use LibUUID;

use HTTP::API::MusicBrainz;

my $api = HTTP::API::MusicBrainz.new();

my %perfect-match = $api.search-artist('zz top').grep({ $_<score> == 100 }).?first;

if (!%perfect-match) {
	die "No perfect match for zz top";
}

#say "Matched %perfect-match<name> [%perfect-match<id>]!";

my %artist = $api.lookup-artist(UUID.new('a81259a0-a2f5-464b-866e-71220f2739f1'), :release-groups);

my @releases = %artist<release-groups>.list.grep({ $_<primary-type> eq 'Album' }).sort({ $_<title> });

for @releases -> %release {
	say %release<title>;
}
