# Generated by default/object.tt
package Paws::SSMIncidents::SsmAutomation;
  use Moose;
  has DocumentName => (is => 'ro', isa => 'Str', request_name => 'documentName', traits => ['NameInRequest'], required => 1);
  has DocumentVersion => (is => 'ro', isa => 'Str', request_name => 'documentVersion', traits => ['NameInRequest']);
  has Parameters => (is => 'ro', isa => 'Paws::SSMIncidents::SsmParameters', request_name => 'parameters', traits => ['NameInRequest']);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest'], required => 1);
  has TargetAccount => (is => 'ro', isa => 'Str', request_name => 'targetAccount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::SsmAutomation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::SsmAutomation object:

  $service_obj->Method(Att1 => { DocumentName => $value, ..., TargetAccount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::SsmAutomation object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentName

=head1 DESCRIPTION

Details about the Systems Manager automation document that will be used
as a runbook during an incident.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DocumentName => Str

The automation document's name.


=head2 DocumentVersion => Str

The automation document's version to use when running.


=head2 Parameters => L<Paws::SSMIncidents::SsmParameters>

The key-value pair parameters to use when running the automation
document.


=head2 B<REQUIRED> RoleArn => Str

The Amazon Resource Name (ARN) of the role that the automation document
will assume when running commands.


=head2 TargetAccount => Str

The account that the automation document will be run in. This can be in
either the management account or an application account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

