/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;

public class PositionableUtils {
    public static Rectangle2D convert(Positionable positionable) {
        Point2D point2D = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public static boolean contains(Positionable positionable, Point2D point2D) {
        Point2D point2D2 = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        if (point2D.getX() < point2D2.getX()) {
            return false;
        }
        if (point2D.getX() > point2D2.getX() + d) {
            return false;
        }
        if (point2D.getY() < point2D2.getY()) {
            return false;
        }
        return !(point2D.getY() > point2D2.getY() + d2);
    }

    public static boolean intersect(Positionable positionable, Positionable positionable2) {
        Rectangle2D rectangle2D = PositionableUtils.convert(positionable);
        Rectangle2D rectangle2D2 = PositionableUtils.convert(positionable2);
        return rectangle2D.intersects(rectangle2D2);
    }

    public static Positionable addMargin(final Positionable positionable, final double d, final double d2) {
        return new Positionable(){

            public Point2D getPosition() {
                Point2D point2D = positionable.getPosition();
                return new Point2D.Double(point2D.getX() - d, point2D.getY() - d2);
            }

            public Dimension2D getSize() {
                return Dimension2DDouble.delta(positionable.getSize(), 2.0 * d, 2.0 * d2);
            }

            public void moveSvek(double d3, double d22) {
                positionable.moveSvek(d3, d22);
            }
        };
    }

    static Rectangle2D move(Rectangle2D rectangle2D, double d, double d2) {
        return new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public static Point2D getCenter(Positionable positionable) {
        Point2D point2D = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        return new Point2D.Double(point2D.getX() + dimension2D.getWidth() / 2.0, point2D.getY() + dimension2D.getHeight() / 2.0);
    }

    public static Positionable move(Positionable positionable, double d, double d2) {
        Point2D point2D = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        return new PositionableImpl(point2D.getX() + d, point2D.getY() + d2, dimension2D);
    }

    public static Positionable moveAwayFrom(Positionable positionable, Positionable positionable2) {
        double d;
        double d2;
        Point2D point2D = PositionableUtils.getCenter(positionable);
        Point2D point2D2 = PositionableUtils.getCenter(positionable2);
        double d3 = point2D2.getX() - point2D.getX();
        if (!PositionableUtils.doesIntersectWithThisCoef(positionable, positionable2, d3, d2 = point2D2.getY() - point2D.getY(), d = 0.0)) {
            throw new IllegalArgumentException();
        }
        double d4 = 0.1;
        while (PositionableUtils.doesIntersectWithThisCoef(positionable, positionable2, d3, d2, d4)) {
            d4 *= 2.0;
        }
        for (int i = 0; i < 5; ++i) {
            assert (PositionableUtils.doesIntersectWithThisCoef(positionable, positionable2, d3, d2, d));
            assert (!PositionableUtils.doesIntersectWithThisCoef(positionable, positionable2, d3, d2, d4));
            double d5 = (d + d4) / 2.0;
            if (PositionableUtils.doesIntersectWithThisCoef(positionable, positionable2, d3, d2, d5)) {
                d = d5;
                continue;
            }
            d4 = d5;
        }
        double d6 = (d + d4) / 2.0;
        return PositionableUtils.move(positionable2, d3 * d6, d2 * d6);
    }

    private static boolean doesIntersectWithThisCoef(Positionable positionable, Positionable positionable2, double d, double d2, double d3) {
        Positionable positionable3 = PositionableUtils.move(positionable2, d * d3, d2 * d3);
        return PositionableUtils.intersect(positionable, positionable3);
    }
}

