/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementButton
extends AbstractElementText
implements Element {
    private final double stroke = 2.5;
    private final double marginX = 2.0;
    private final double marginY = 2.0;

    public ElementButton(String string, UFont uFont, ISkinSimple iSkinSimple) {
        super(string, uFont, true, iSkinSimple);
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimensionAt(stringBounder, d + 2.5 + 2.0);
        dimension2D = Dimension2DDouble.delta(dimension2D, 4.0, 4.0);
        return Dimension2DDouble.delta(dimension2D, 5.0);
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), 0.0, 0.0);
        uGraphic = uGraphic.apply(new UStroke(2.5));
        uGraphic.apply(new UChangeBackColor(HtmlColorUtils.getColorIfValid("#EEEEEE"))).apply(new UTranslate(2.5, 2.5)).draw(new URectangle(dimension2D2.getWidth() - 5.0, dimension2D2.getHeight() - 5.0, 10.0, 10.0));
        Dimension2D dimension2D3 = this.getPureTextDimension(uGraphic.getStringBounder());
        this.drawText(uGraphic, (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0, 4.5);
    }
}

