/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;

    public DriverTextG2d(EnsureVisible ensureVisible) {
        this.visible = ensureVisible;
    }

    private static void printFont() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Log.info("Available fonts: " + stringArray[i]);
        }
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        int n;
        Object object;
        Object object2;
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont().scaled(uParam.getScale());
        Dimension2D dimension2D = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(graphics2D), uFont, uText.getText());
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (object2 = colorMapper.getMappedColor(fontConfiguration.getExtendedColor())) != null) {
            graphics2D.setColor((Color)object2);
            graphics2D.setBackground((Color)object2);
            graphics2D.fill(new Rectangle2D.Double(d, d2 - dimension2D.getHeight() + 1.5, dimension2D.getWidth(), dimension2D.getHeight()));
        }
        this.visible.ensureVisible(d, d2 - dimension2D.getHeight() + 1.5);
        this.visible.ensureVisible(d + dimension2D.getWidth(), d2 + 1.5);
        graphics2D.setFont(uFont.getFont());
        graphics2D.setColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        graphics2D.drawString(uText.getText(), (float)d, (float)d2);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            object2 = fontConfiguration.getExtendedColor();
            if (object2 != null) {
                graphics2D.setColor(colorMapper.getMappedColor((HtmlColor)object2));
            }
            object = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(graphics2D), uFont, uText.getText());
            n = (int)(d2 + 2.5);
            graphics2D.setStroke(new BasicStroke(1.3f));
            graphics2D.drawLine((int)d, n, (int)(d + ((Dimension2D)object).getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            object2 = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(graphics2D), uFont, uText.getText());
            int n2 = (int)(d2 + 2.5) - 1;
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            int n3 = (int)d;
            while ((double)n3 < d + ((Dimension2D)object2).getWidth() - 5.0) {
                graphics2D.drawLine(n3, n2 - 0, n3 + 3, n2 + 1);
                graphics2D.drawLine(n3 + 3, n2 + 1, n3 + 6, n2 - 0);
                n3 += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            object2 = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(graphics2D), uFont, uText.getText());
            object = graphics2D.getFontMetrics(uFont.getFont());
            n = (int)(d2 - (double)((FontMetrics)object).getDescent() - 0.5);
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawLine((int)d, n, (int)(d + ((Dimension2D)object2).getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont uFont, String string) {
        Dimension2D dimension2D = stringBounder.calculateDimension(uFont, string);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        return new Dimension2DDouble(dimension2D.getWidth(), d);
    }
}

