/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import org.stathissideris.ascii2image.text.AbstractCell;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class AbstractionGrid {
    private static final boolean DEBUG = false;
    private TextGrid grid;

    public static AbstractionGrid makeUsingBuffer(TextGrid textGrid) {
        if (textGrid.getWidth() % 3 != 0 || textGrid.getHeight() % 3 != 0) {
            throw new IllegalArgumentException("Passed TextGrid must have dimensions that are divisible by 3.");
        }
        AbstractionGrid abstractionGrid = new AbstractionGrid(textGrid.getWidth() / 3, textGrid.getHeight() / 3);
        abstractionGrid.setInternalBuffer(textGrid);
        return abstractionGrid;
    }

    public AbstractionGrid(TextGrid textGrid, CellSet cellSet) {
        this(textGrid.getWidth(), textGrid.getHeight());
        for (TextGrid.Cell cell : cellSet) {
            if (textGrid.isBlank(cell)) continue;
            if (textGrid.isCross(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCross());
                continue;
            }
            if (textGrid.isT(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeT());
                continue;
            }
            if (textGrid.isK(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeK());
                continue;
            }
            if (textGrid.isInverseT(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeInverseT());
                continue;
            }
            if (textGrid.isInverseK(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeInverseK());
                continue;
            }
            if (textGrid.isCorner1(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner1());
                continue;
            }
            if (textGrid.isCorner2(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner2());
                continue;
            }
            if (textGrid.isCorner3(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner3());
                continue;
            }
            if (textGrid.isCorner4(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCorner4());
                continue;
            }
            if (textGrid.isHorizontalLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeHorizontalLine());
                continue;
            }
            if (textGrid.isVerticalLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeVerticalLine());
                continue;
            }
            if (textGrid.isCrossOnLine(cell)) {
                this.set(cell.x, cell.y, AbstractCell.makeCross());
                continue;
            }
            if (!textGrid.isStarOnLine(cell)) continue;
            this.set(cell.x, cell.y, AbstractCell.makeStar());
        }
    }

    private AbstractionGrid(int n, int n2) {
        this.grid = new TextGrid(n * 3, n2 * 3);
    }

    public TextGrid getCopyOfInternalBuffer() {
        return new TextGrid(this.grid);
    }

    private void setInternalBuffer(TextGrid textGrid) {
        this.grid = textGrid;
    }

    public int getWidth() {
        return this.grid.getWidth() / 3;
    }

    public int getHeight() {
        return this.grid.getHeight() / 3;
    }

    public TextGrid getAsTextGrid() {
        TextGrid textGrid = new TextGrid(this.getWidth(), this.getHeight());
        for (int i = 0; i < this.grid.getHeight(); ++i) {
            for (int j = 0; j < this.grid.getWidth(); ++j) {
                TextGrid textGrid2 = this.grid;
                textGrid2.getClass();
                TextGrid.Cell cell = new TextGrid.Cell(textGrid2, j, i);
                if (this.grid.isBlank(cell)) continue;
                textGrid.set(j / 3, i / 3, '*');
            }
        }
        return textGrid;
    }

    public ArrayList getDistinctShapes() {
        ArrayList<CellSet> arrayList = new ArrayList<CellSet>();
        CellSet cellSet = this.grid.getAllNonBlank();
        ArrayList arrayList2 = cellSet.breakIntoDistinctBoundaries();
        for (CellSet cellSet2 : arrayList2) {
            AbstractionGrid abstractionGrid = new AbstractionGrid(this.getWidth(), this.getHeight());
            abstractionGrid.fillCells(cellSet2);
            arrayList.add(abstractionGrid.getAsTextGrid().getAllNonBlank());
        }
        return arrayList;
    }

    protected void fillCells(CellSet cellSet) {
        this.grid.fillCellsWith(cellSet, '*');
    }

    public void set(int n, int n2, AbstractCell abstractCell) {
        n *= 3;
        n2 *= 3;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (abstractCell.rows[j][i] != 1) continue;
                this.grid.set(n + j, n2 + i, '*');
            }
        }
    }
}

