/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.TextGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellSet
implements Iterable<TextGrid.Cell> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    public static final int TYPE_CLOSED = 0;
    public static final int TYPE_OPEN = 1;
    public static final int TYPE_MIXED = 2;
    public static final int TYPE_HAS_CLOSED_AREA = 3;
    public static final int TYPE_UNDETERMINED = 4;
    Set<TextGrid.Cell> internalSet = new HashSet<TextGrid.Cell>();
    private int type = 4;
    private boolean typeIsValid = false;
    private static final Object FAKE = new Object();

    public CellSet() {
    }

    public CellSet(CellSet cellSet) {
        this.addAll(cellSet);
    }

    @Override
    public Iterator<TextGrid.Cell> iterator() {
        return this.internalSet.iterator();
    }

    public Object add(TextGrid.Cell cell) {
        return this.internalSet.add(cell);
    }

    public void addAll(CellSet cellSet) {
        this.internalSet.addAll(cellSet.internalSet);
    }

    void clear() {
        this.internalSet.clear();
    }

    public int size() {
        return this.internalSet.size();
    }

    public TextGrid.Cell getFirst() {
        return this.internalSet.iterator().next();
    }

    public void printAsGrid() {
        TextGrid textGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        textGrid.fillCellsWith(this, '*');
        textGrid.printDebug();
    }

    public void printDebug() {
        Iterator<TextGrid.Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            TextGrid.Cell cell = iterator.next();
            System.out.print(cell);
            if (!iterator.hasNext()) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    public String getCellsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<TextGrid.Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        TextGrid textGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        textGrid.fillCellsWith(this, '*');
        return textGrid.getDebugString();
    }

    public static CellSet copyCellSet(CellSet cellSet) {
        TextGrid textGrid = new TextGrid();
        CellSet cellSet2 = new CellSet();
        for (TextGrid.Cell cell : cellSet) {
            TextGrid textGrid2 = textGrid;
            textGrid2.getClass();
            TextGrid.Cell cell2 = new TextGrid.Cell(textGrid2, cell);
            cellSet2.add(cell2);
        }
        return cellSet2;
    }

    public int getType(TextGrid textGrid) {
        if (this.typeIsValid) {
            return this.type;
        }
        this.typeIsValid = true;
        if (this.size() == 1) {
            this.type = 1;
            return 1;
        }
        int n = this.getTypeAccordingToTraceMethod(textGrid);
        if (n == 1) {
            this.type = 1;
            return 1;
        }
        if (n == 0) {
            this.type = 0;
            return 0;
        }
        if (n == 4) {
            int n2 = this.getTypeAccordingToFillMethod(textGrid);
            if (n2 == 3) {
                this.type = 2;
                return 2;
            }
            if (n2 == 1) {
                this.type = 1;
                return 1;
            }
        }
        this.type = 4;
        return 4;
    }

    private int getTypeAccordingToTraceMethod(TextGrid textGrid) {
        TextGrid.Cell cell3;
        if (this.size() < 2) {
            return 1;
        }
        TextGrid textGrid2 = TextGrid.makeSameSizeAs(textGrid);
        textGrid.copyCellsTo(this, textGrid2);
        TextGrid.Cell cell2 = null;
        for (TextGrid.Cell cell3 : this) {
            if (!textGrid2.isLinesEnd(cell3)) continue;
            cell2 = cell3;
        }
        if (cell2 == null) {
            cell2 = this.getFirst();
        }
        Object object = cell2;
        cell3 = null;
        CellSet cellSet = textGrid2.followCell((TextGrid.Cell)object);
        if (cellSet.size() == 0) {
            return 1;
        }
        cell3 = cellSet.getFirst();
        while (!cell3.equals(cell2)) {
            cellSet = textGrid2.followCell(cell3, (TextGrid.Cell)object);
            if (cellSet.size() == 0) {
                return 1;
            }
            if (cellSet.size() == 1) {
                object = cell3;
                cell3 = cellSet.getFirst();
                continue;
            }
            if (cellSet.size() <= 1) continue;
            return 4;
        }
        return 0;
    }

    private int getTypeAccordingToFillMethod(TextGrid textGrid) {
        if (this.size() == 0) {
            return 1;
        }
        CellSet cellSet = CellSet.copyCellSet(this);
        cellSet.translate(-this.getMinX() + 1, -this.getMinY() + 1);
        TextGrid textGrid2 = textGrid.getSubGrid(this.getMinX() - 1, this.getMinY() - 1, this.getWidth() + 3, this.getHeight() + 3);
        AbstractionGrid abstractionGrid = new AbstractionGrid(textGrid2, cellSet);
        TextGrid textGrid3 = abstractionGrid.getCopyOfInternalBuffer();
        Object var6_6 = null;
        Object var7_7 = null;
        int n = textGrid3.getWidth();
        int n2 = textGrid3.getHeight();
        TextGrid.Cell cell = null;
        block0: for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                TextGrid textGrid4 = textGrid3;
                textGrid4.getClass();
                TextGrid.Cell cell2 = new TextGrid.Cell(textGrid4, j, i);
                if (!textGrid3.isBlank(cell2)) continue;
                cell = cell2;
                continue block0;
            }
        }
        if (cell == null) {
            System.err.println("Unexpected error: fill method cannot fill anywhere");
            return 4;
        }
        textGrid3.fillContinuousArea(cell, '*');
        if (textGrid3.hasBlankCells()) {
            return 3;
        }
        return 1;
    }

    public void translate(int n, int n2) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell : this) {
            cell.x += n;
            cell.y += n2;
        }
    }

    public TextGrid.Cell find(TextGrid.Cell cell) {
        for (TextGrid.Cell cell2 : this) {
            if (!cell2.equals(cell)) continue;
            return cell2;
        }
        return null;
    }

    public boolean contains(TextGrid.Cell cell) {
        if (cell == null) {
            return false;
        }
        return this.internalSet.contains(cell);
    }

    public void addSet(CellSet cellSet) {
        this.typeIsValid = false;
        this.addAll(cellSet);
    }

    public boolean hasCommonCells(CellSet cellSet) {
        for (TextGrid.Cell cell : this) {
            if (!cellSet.contains(cell)) continue;
            return true;
        }
        return false;
    }

    public TextGrid.Cell find(int n, int n2) {
        for (TextGrid.Cell cell : this) {
            if (cell.x != n || cell.y != n2) continue;
            return cell;
        }
        return null;
    }

    public CellSet getFilledEquivalent(TextGrid textGrid) {
        if (this.getType(textGrid) == 1) {
            return new CellSet(this);
        }
        TextGrid textGrid2 = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        textGrid2.fillCellsWith(this, '*');
        TextGrid.Cell cell = null;
        boolean bl = false;
        for (int i = 0; i < textGrid2.getHeight() && !bl; ++i) {
            for (int j = 0; j < textGrid2.getWidth() && !bl; ++j) {
                TextGrid textGrid3 = textGrid2;
                textGrid3.getClass();
                cell = new TextGrid.Cell(textGrid3, j, i);
                if (textGrid2.isBlank(cell) || !textGrid2.isBlank(cell.getEast()) || !textGrid2.isBlank(cell.getWest())) continue;
                bl = true;
            }
        }
        if (cell != null) {
            if (textGrid2.isOutOfBounds(cell = cell.getEast())) {
                return new CellSet(this);
            }
            textGrid2.fillContinuousArea(cell, '*');
            return textGrid2.getAllNonBlank();
        }
        System.err.println("Unexpected error, cannot find the filled equivalent of CellSet");
        return null;
    }

    public TextGrid.Cell findCellNextTo(TextGrid.Cell cell) {
        for (TextGrid.Cell cell2 : this) {
            if (!cell2.isNextTo(cell)) continue;
            return cell2;
        }
        return null;
    }

    public CellSet findCellsNextTo(TextGrid.Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        CellSet cellSet = new CellSet();
        for (TextGrid.Cell cell2 : this) {
            if (!cell2.isNextTo(cell)) continue;
            cellSet.add(cell2);
        }
        return cellSet;
    }

    public void appendSet(CellSet cellSet) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell : cellSet) {
            if (this.find(cell) != null) continue;
            this.add(cell);
        }
    }

    public void subtractSet(CellSet cellSet) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell : cellSet) {
            TextGrid.Cell cell2 = this.find(cell);
            if (cell2 == null) continue;
            this.remove(cell2);
        }
    }

    public int getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public int getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public int getMaxX() {
        int n = 0;
        for (TextGrid.Cell cell : this) {
            if (cell.x <= n) continue;
            n = cell.x;
        }
        return n;
    }

    public int getMinX() {
        int n = Integer.MAX_VALUE;
        for (TextGrid.Cell cell : this) {
            if (cell.x >= n) continue;
            n = cell.x;
        }
        return n;
    }

    public int getMaxY() {
        int n = 0;
        for (TextGrid.Cell cell : this) {
            if (cell.y <= n) continue;
            n = cell.y;
        }
        return n;
    }

    public int getMinY() {
        int n = Integer.MAX_VALUE;
        for (TextGrid.Cell cell : this) {
            if (cell.y >= n) continue;
            n = cell.y;
        }
        return n;
    }

    public Object remove(TextGrid.Cell cell) {
        this.typeIsValid = false;
        if ((cell = this.find(cell)) != null) {
            return this.internalSet.remove(cell);
        }
        return null;
    }

    public boolean equals(Object object) {
        CellSet cellSet = (CellSet)object;
        return ((Object)this.internalSet).equals(cellSet.internalSet);
    }

    public static ArrayList removeDuplicateSets(ArrayList arrayList) {
        ArrayList<CellSet> arrayList2 = new ArrayList<CellSet>();
        for (CellSet cellSet : arrayList) {
            boolean bl = true;
            for (CellSet cellSet2 : arrayList2) {
                if (!cellSet.equals(cellSet2)) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList2.add(cellSet);
        }
        return arrayList2;
    }

    public ArrayList breakIntoDistinctBoundaries(TextGrid textGrid) {
        AbstractionGrid abstractionGrid = new AbstractionGrid(textGrid, this);
        ArrayList arrayList = abstractionGrid.getDistinctShapes();
        return arrayList;
    }

    public ArrayList breakIntoDistinctBoundaries() {
        ArrayList<CellSet> arrayList = new ArrayList<CellSet>();
        TextGrid textGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        textGrid.fillCellsWith(this, '*');
        for (TextGrid.Cell cell : this) {
            if (textGrid.isBlank(cell.x, cell.y)) continue;
            CellSet cellSet = textGrid.fillContinuousArea(cell.x, cell.y, ' ');
            arrayList.add(cellSet);
        }
        return arrayList;
    }

    public ArrayList breakTrulyMixedBoundaries(TextGrid textGrid) {
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CellSet cellSet = new CellSet();
        TextGrid textGrid2 = TextGrid.makeSameSizeAs(textGrid);
        textGrid.copyCellsTo(this, textGrid2);
        for (Object object22 : this) {
            if (!textGrid2.isLinesEnd((TextGrid.Cell)object22) || cellSet.contains((TextGrid.Cell)object22)) continue;
            CellSet cellSet2 = new CellSet();
            cellSet2.add((TextGrid.Cell)object22);
            Object object = object22;
            TextGrid.Cell cell = null;
            CellSet cellSet3 = textGrid2.followCell((TextGrid.Cell)object);
            if (cellSet3.size() == 0) {
                throw new IllegalArgumentException("This shape is either open but multipart or has only one cell, and cannot be processed by this method");
            }
            cell = cellSet3.getFirst();
            cellSet2.add(cell);
            boolean bl = false;
            if (textGrid2.isLinesEnd(cell)) {
                cellSet.add(cell);
                bl = true;
            }
            while (!bl) {
                cellSet3 = textGrid2.followCell(cell, (TextGrid.Cell)object);
                if (cellSet3.size() == 1) {
                    cellSet2.add(cell);
                    object = cell;
                    cell = cellSet3.getFirst();
                    if (!textGrid2.isLinesEnd(cell)) continue;
                    cellSet.add(cell);
                    bl = true;
                    continue;
                }
                if (cellSet3.size() <= 1) continue;
                bl = true;
            }
            arrayList.add(cellSet2);
        }
        object22 = new CellSet(this);
        for (CellSet cellSet4 : arrayList) {
            ((CellSet)object22).subtractSet(cellSet4);
        }
        arrayList.add(object22);
        return arrayList;
    }

    public TextGrid makeIntoGrid() {
        TextGrid textGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        textGrid.fillCellsWith(this, '*');
        return textGrid;
    }

    public CellSet makeScaledOneThirdEquivalent() {
        TextGrid textGrid = this.makeIntoGrid();
        textGrid.fillCellsWith(this, '*');
        TextGrid textGrid2 = new TextGrid((this.getMaxX() + 2) / 3, (this.getMaxY() + 2) / 3);
        for (int i = 0; i < textGrid.getHeight(); ++i) {
            for (int j = 0; j < textGrid.getWidth(); ++j) {
                TextGrid textGrid3 = textGrid;
                textGrid3.getClass();
                TextGrid.Cell cell = new TextGrid.Cell(textGrid3, j, i);
                if (textGrid.isBlank(cell)) continue;
                textGrid2.set(j / 3, i / 3, '*');
            }
        }
        return textGrid2.getAllNonBlank();
    }
}

