#!perl -T

use 5.006;
use strict;
use warnings;
use Test::More;

plan tests => 18;

use Math::AnyNum qw(:overload);

# Harmonic numbers
{
    my @results = qw(
      0/1
      1/1
      3/2
      11/6
      25/12
      137/60
      49/20
      363/140
      761/280
      7129/2520
      7381/2520
      );

    #
    ## harmfrac()
    #
    foreach my $i (0 .. $#results) {
        is(Math::AnyNum->new($i)->harmfrac->as_frac, $results[$i]);
    }

    is((-1)->harmfrac, NaN);
    is(7001->harmfrac->as_frac,
'10820561388613610091527468800463903439612798821527801887688328136891728691394803791418533822117927378483114640960411479082128060727621101487839131381984681732666998807350617259735261336064607255293429583751526232600096693651443940414200568744175277643664792544553236340519751120623674503950206278411556830396962716480468225360742185190707935701469890749967114802547795969527141532401209158276139615786805094167799636843678285147136099956021300660521153604726438902104639380646908873829698531649996638868658506577860953678601262259228581624987256426847041295360588976260035521531261709576171547700424321968602657686623547497417285848817121798988625322389383487459925172958777302940889236720415466275307960938669209193792918889162838489186563186357133481966435090814390623925548460057929311122905415773632333804016225088485304854714325944426639921582357020089830007809591633291874504247444172828782940756224547044782716641171780381917919474014985586442992520531998394248120174839736458506400537828450109006665138162034759764351873003370610970530736334795310237372599193878272384893542971989057838389481485420083664380932726680519397116054221678712157051498444618632230551120257659628009071435122988035808828534878174560049452705015407100168701383213412923485451533761787137160371956785911754443183719335497825682100437385571086254770373126961306259950137362931046912749486464790794336910012152999365257052962864684073895186331047002092943780141788317104801977656369555017603314414549685704545963504000705023194322454513370898938663807866714517041119046004501801857154611421522947295014461632288482098414004985837496051898190292941272516259743516618098262770234251463260499274652848419071283769868976795551875264313552326507633046729429137646392859003024027144965219556786509585831580005363748010486424808418849028565670640220758331623139298477755108689208083323084630856108099221574718937175778209998228570914368234827663189676378850572223822722226601824830147381136983509849507597109315494637629734778422906113788900120555200651120839423248190351061006243106078432468700593647701242444014136650663058219678504044463244366234032652770444535650272637306085636341944681285586730292810131739423805730947584739377019408766188399135556105178908658853296685025311235773890417103684883643746410568516711680242618037316811977510173619252073699020662890079770356505928976588369251036628186411160042379811804883644246099143652927892888737919468709961541033544599284161460288556586640275783692051713278767497919683270208045520040723407504900577327910152626433569311132332933700256080489635024634505667316133701163726003633071167753428830289051700188400216237404541620820982213942440247625646736345122882270028646630663217647960693043035292175020485646619763784532330755378852734575507772615673088028615072067032368349202483181997544099354929648572746601341523757790330293827280977501145774661947635279254651271067420746588253924516000088083277568818728751671319936380723817001144622948139062414954335002264206074167283444979516351154686124659328000664169884983130429049/1147328171281998751621180797467473783496450901955154851007844653984548377587747300361647679481993179140190496667386552406578844219539815970065382394634948987304404008579908531721445735096156139500977013688167196279749214076209297150259141420294029495035939554907003021982449213253002052696469737473970686888079139639368915839450047924384574754017607147562215233809070685366869332905880235781637388591014856195341472027771806815779344543245333662289608974914359734512892482176715907042148509471753782880403025341016464354038759793110079711333141697557454588199114715921481443222585960990692147849623739763570998424224241373023868825310252898774304564270897132110338500285923362744992839823043296032561521033286080176878234124968382276733451569865043317930668713969870818610751244296618598119941897599649306584375134979756783558802677248132292945425336284932374397844768582649344279631896610801603190622949146881164056334950349513579118177547311416533527480888060390988014958306284223476876845558838275146085206762527269328000274857137963869087628424269539763897746151384792059064544689873745137191868039311718448888202475447176456106886804414494618958388129494549478534519569369571281138066195837165105320240910004055452951442720653310885855855739765456504790812403146658395555594387084396597478763918946959153944270705304790841783434394277734893546038254609759465637192622113051157086411096424222683509482990792798656143418083988931059381179067150484386978183979489215177805629926587205008077456018478959356948439863212477610599823573521594127577448641555249309941671185174290959586621070573058164954154368034245009642163382682524994164727379819769785203015267557487654059015278831224172487535912226440701805137286267657095659282893560589778226333875332425661511029866933875935778278877679302616450548201511480783989454500924895197463058146301767051522154451500074877064777095361516497589072085166278494049603967740145328967885771352007386185259065469049367443287773227886717140454879098851476675242050468574314780793224263864454308343906615730256328574939791911291041632956040701788393274674116186829196668086411272576409370766649817137092755074850856124479254812853143574982421871534799833203219732230609382511318782022562252255709585200714566011290481495725384955772892622253996369057343449044955351642330619169032089284403994385774590086402792495617653268749816133714792325558717047493736202169638674481240918441020267476719759876287125505237396455824518405799632229228219964450090304987809577440313714554832108297332653821893263793107921894453744873174799790687664039818260219377329484597279431366662680602545037102341847037708681651981589652381675511758196706906663521218957297899545807120664389404996304301722351724410136738863007813060207383363148179918945627076260281934007790811597130895166696559843257559990826615227859480251274863657638438881011063082565288960329663973568976436366073554669025528239546524166218497187808692910245806498355531253744595337349720750090255458228323257315437438072567374838201520856483625716462874505043850252800000'
      );

    #
    ## harmreal()
    #
    is((-42)->harmreal, NaN);
    is(0->harmreal,     0);
    is(1->harmreal,     1);
    like(1e6->harmreal,   qr/^14\.39272672286572/);
    like(12.34->harmreal, qr/^3\.13003/);
}
