package AnyEvent::ProcessPool::Util;
$AnyEvent::ProcessPool::Util::VERSION = '0.01';
# ABSTRACT: A multi-process pool for Perl

use strict;
use warnings;
use v5.10;
use parent 'Exporter';

use Data::UUID::MT;

our @EXPORT_OK = qw(
  next_id
);

sub next_id {
  state $ug = Data::UUID::MT->new(version => 4);
  state $ids = $ug->iterator;
  return $ids->();
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

AnyEvent::ProcessPool::Util - A multi-process pool for Perl

=head1 VERSION

version 0.01

=head1 AUTHOR

Jeff Ober <sysread@fastmail.fm>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Jeff Ober.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
