# Generated by default/object.tt
package Paws::WAFV2::ManagedRuleGroupStatement;
  use Moose;
  has ExcludedRules => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::ExcludedRule]');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has ScopeDownStatement => (is => 'ro', isa => 'Paws::WAFV2::Statement');
  has VendorName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::ManagedRuleGroupStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::ManagedRuleGroupStatement object:

  $service_obj->Method(Att1 => { ExcludedRules => $value, ..., VendorName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::ManagedRuleGroupStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->ExcludedRules

=head1 DESCRIPTION

A rule statement used to run the rules that are defined in a managed
rule group. To use this, provide the vendor name and the name of the
rule group in this statement. You can retrieve the required names by
calling ListAvailableManagedRuleGroups.

You cannot nest a C<ManagedRuleGroupStatement>, for example for use
inside a C<NotStatement> or C<OrStatement>. It can only be referenced
as a top-level statement within a rule.

=head1 ATTRIBUTES


=head2 ExcludedRules => ArrayRef[L<Paws::WAFV2::ExcludedRule>]

The rules whose actions are set to C<COUNT> by the web ACL, regardless
of the action that is set on the rule. This effectively excludes the
rule from acting on web requests.


=head2 B<REQUIRED> Name => Str

The name of the managed rule group. You use this, along with the vendor
name, to identify the rule group.


=head2 ScopeDownStatement => L<Paws::WAFV2::Statement>

An optional nested statement that narrows the scope of the web requests
that are evaluated by the managed rule group. Requests are only
evaluated by the rule group if they match the scope-down statement. You
can use any nestable Statement in the scope-down statement, and you can
nest statements at any level, the same as you can for a rule statement.


=head2 B<REQUIRED> VendorName => Str

The name of the managed rule group vendor. You use this, along with the
rule group name, to identify the rule group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

