# Generated by default/object.tt
package Paws::IoTWireless::WirelessGatewayEventLogOption;
  use Moose;
  has Event => (is => 'ro', isa => 'Str', required => 1);
  has LogLevel => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::WirelessGatewayEventLogOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::WirelessGatewayEventLogOption object:

  $service_obj->Method(Att1 => { Event => $value, ..., LogLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::WirelessGatewayEventLogOption object:

  $result = $service_obj->Method(...);
  $result->Att1->Event

=head1 DESCRIPTION

The log option for a wireless gateway event. Can be used to set log
level for a specific wireless gateway event. For a LoRaWAN gateway, the
possible events for a log message are: CUPS_Request, Certificate.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Event => Str




=head2 B<REQUIRED> LogLevel => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

