# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153519;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              00|
              2(?:
                1|
                395
              )
            )|
            9[56]
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0|
              23(?:
                [0-8]|
                9[0-46-9]
              )
            )|
            78123|
            [1-9]123
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            10(?:
              1(?:
                0|
                23
              )|
              9[56]
            )|
            2[0-57-9](?:
              1(?:
                00|
                23
              )|
              9[56]
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                1[124-9]|
                2[179]|
                [35][1-9]|
                6[47-9]|
                7\\d|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                078|
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[1-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                3\\d|
                4[13]|
                5[1-5]|
                7[0-79]|
                9[0-35-9]
              )
            )123
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0(?:
                [02-8]|
                1(?:
                  [013-9]|
                  2[0-24-9]
                )|
                9[0-47-9]
              )|
              [1-9]
            )|
            2(?:
              [0-57-9](?:
                [02-8]|
                1(?:
                  0[1-9]|
                  [13-9]|
                  2[0-24-9]
                )|
                9[0-47-9]
              )|
              6
            )|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              1[03]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              8[1-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              0(?:
                [0-689]|
                7[0-79]
              )|
              1[01459]|
              2[0-489]|
              [46]|
              50|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]|
              78|
              94
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                1[124-9]|
                2[179]|
                [35][1-9]|
                6[47-9]|
                7\\d|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                078|
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[1-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                3\\d|
                4[13]|
                5[1-5]|
                7[0-79]|
                9[0-35-9]
              )
            )(?:
              [02-9]|
              1(?:
                [013-9]|
                2[0-24-9]
              )
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0[02-8]|
              [1-9]
            )|
            2(?:
              [0-57-9][0-8]|
              6
            )|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              10|
              2[0-57-9]
            )9[0-47-9]|
            (?:
              101|
              58|
              85[23]10
            )[1-9]|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            2(?:
              [02-57-9]\\d{3}|
              1(?:
                [18](?:
                  0[1-9]|
                  [1-9]\\d
                )|
                [2-79]\\d\\d
              )
            )|
            (?:
              41[03]|
              8078|
              9(?:
                78|
                94
              )
            )\\d\\d
          )\\d{5}|
          (?:
            10|
            2[0-57-9]
          )(?:
            1(?:
              00|
              23
            )\\d\\d|
            95\\d{3,4}
          )|
          (?:
            41[03]|
            9(?:
              78|
              94
            )
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          8078123|
          (?:
            43[35]|
            754|
            851
          )\\d{7,8}|
          (?:
            43[35]|
            754|
            851
          )(?:
            1(?:
              00\\d|
              23
            )\\d|
            95\\d{3,4}
          )|
          (?:
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [13-9]\\d{6}|
              2(?:
                [0-24-9]\\d{5}|
                3\\d(?:
                  \\d{4}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[24-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              3\\d|
              4[13]|
              5[1-5]|
              7[0-79]|
              9[0-35-9]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [13-9]\\d{5}|
              2(?:
                [0-24-9]\\d{4}|
                3\\d(?:
                  \\d{3}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            2(?:
              [02-57-9]\\d{3}|
              1(?:
                [18](?:
                  0[1-9]|
                  [1-9]\\d
                )|
                [2-79]\\d\\d
              )
            )|
            (?:
              41[03]|
              8078|
              9(?:
                78|
                94
              )
            )\\d\\d
          )\\d{5}|
          (?:
            10|
            2[0-57-9]
          )(?:
            1(?:
              00|
              23
            )\\d\\d|
            95\\d{3,4}
          )|
          (?:
            41[03]|
            9(?:
              78|
              94
            )
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          8078123|
          (?:
            43[35]|
            754|
            851
          )\\d{7,8}|
          (?:
            43[35]|
            754|
            851
          )(?:
            1(?:
              00\\d|
              23
            )\\d|
            95\\d{3,4}
          )|
          (?:
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [13-9]\\d{6}|
              2(?:
                [0-24-9]\\d{5}|
                3\\d(?:
                  \\d{4}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[24-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              3\\d|
              4[13]|
              5[1-5]|
              7[0-79]|
              9[0-35-9]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [13-9]\\d{5}|
              2(?:
                [0-24-9]\\d{4}|
                3\\d(?:
                  \\d{3}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            [59][0-35-9]|
            6[25-7]|
            7[0-35-8]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          10(?:
            10\\d{4}|
            96\\d{3,4}
          )|
          400\\d{7}|
          950\\d{7,8}|
          (?:
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{zh} = {"861395249", "江苏省无锡市",
"861535124", "四川省绵阳市",
"86147791", "江西省南昌市",
"861825441", "山东省临沂市",
"861538435", "广东省珠海市",
"861810001", "北京市",
"861384985", "河南省许昌市",
"861868802", "广东省汕头市",
"86159873", "云南省红河哈尼族彝族自治州",
"861804067", "湖北省随州市",
"861313527", "湖南省永州市",
"861771286", "江苏省南京市",
"861882196", "湖南省常德市",
"86159801", "福建省福州市",
"861881451", "黑龙江省哈尔滨市",
"861350565", "安徽省合肥市",
"861709353", "河南省南阳市",
"861806824", "江苏省宿迁市",
"86135447", "广东省东莞市",
"861528640", "贵州省铜仁地区",
"861826874", "浙江省舟山市",
"861552696", "吉林省白山市",
"861556083", "内蒙古包头市",
"861537139", "江苏省宿迁市",
"861865995", "福建省南平市",
"861776830", "江苏省无锡市",
"861877124", "湖北省恩施土家族苗族自治州",
"861808995", "西藏昌都地区",
"861894839", "广东省云浮市",
"861509760", "河北省廊坊市",
"861336925", "陕西省汉中市",
"861453919", "广东省江门市",
"861562462", "内蒙古锡林郭勒盟",
"861368854", "贵州省黔南布依族苗族自治州",
"861708565", "安徽省安庆市",
"861373251", "浙江省衢州市",
"861810510", "江苏省盐城市",
"861300981", "黑龙江省大庆市",
"861341541", "广东省中山市",
"861509492", "山东省威海市",
"861774025", "四川省内江市",
"861562790", "广东省汕尾市",
"861309186", "黑龙江省哈尔滨市",
"86177491", "陕西省西安市",
"861801618", "四川省宜宾市",
"861869609", "湖北省咸宁市",
"861361744", "湖南省张家界市",
"861515293", "江苏省镇江市",
"861839932", "新疆吐鲁番地区",
"861599731", "湖北省襄樊市",
"86132105", "山东省济南市",
"861772911", "陕西省延安市",
"86136451", "江苏省南京市",
"86138504", "福建省漳州市",
"861818898", "湖南省常德市",
"86187551", "安徽省合肥市",
"861362511", "江苏省常州市",
"861534625", "河南省鹤壁市",
"86132779", "湖北省武汉市",
"861844580", "黑龙江省伊春市",
"861550826", "四川省广安市",
"861596383", "山东省日照市",
"861318629", "陕西省安康市",
"861768196", "浙江省湖州市",
"86136002", "广东省东莞市",
"861533634", "山东省莱芜市",
"861705384", "内蒙古呼和浩特市",
"861829763", "安徽省宿州市",
"861873629", "河南省洛阳市",
"861594941", "内蒙古呼和浩特市",
"861806938", "浙江省衢州市",
"861768384", "湖北省荆门市",
"861458355", "山东省济南市",
"861314560", "安徽省宿州市",
"861823070", "贵州省黔东南苗族侗族自治州",
"861890325", "河北省唐山市",
"861536544", "江苏省徐州市",
"861321782", "广西来宾市",
"861536498", "山西省运城市",
"861396641", "安徽省安庆市",
"86152475", "内蒙古通辽市",
"861311773", "广西桂林市",
"861773034", "安徽省阜阳市",
"861452865", "青海省果洛藏族自治州",
"861593090", "河北省邯郸市",
"861817048", "江西省赣州市",
"86155831", "四川省宜宾市",
"861589268", "四川省雅安市",
"861814020", "四川省成都市",
"861867847", "山东省临沂市",
"861327112", "河南省信阳市",
"861320368", "湖南省益阳市",
"861375475", "山东省淄博市",
"86153964", "福建省泉州市",
"861500395", "河南省漯河市",
"861303560", "四川省自贡市",
"861535237", "甘肃省武威市",
"861576943", "甘肃省平凉市",
"86188616", "江苏省无锡市",
"861477170", "湖北省鄂州市",
"861352961", "云南省临沧市",
"86132650", "广东省广州市",
"861509108", "陕西省宝鸡市",
"861315590", "江西省上饶市",
"861889595", "云南省昆明市",
"861450237", "河北省沧州市",
"861823260", "河北省承德市",
"861459563", "陕西省渭南市",
"861555327", "山东省聊城市",
"86185762", "广东省中山市",
"861772087", "福建省厦门市",
"86189688", "浙江省温州市",
"86138058", "浙江省宁波市",
"861841997", "甘肃省陇南市",
"861589078", "河南省安阳市",
"861778041", "四川省广元市",
"86147062", "江苏省苏州市",
"86137059", "福建省福州市",
"861300017", "山东省济南市",
"861300737", "湖南省益阳市",
"861334789", "江苏省常州市",
"861319822", "四川省广元市",
"86155666", "辽宁省朝阳市",
"861314439", "吉林省白山市",
"861471801", "广东省梅州市",
"861866308", "山东省滨州市",
"861804567", "黑龙江省黑河市",
"861859945", "新疆乌鲁木齐市",
"861769613", "山西省大同市",
"861454338", "内蒙古巴彦淖尔市",
"86159851", "贵州省贵阳市",
"86180125", "江苏省盐城市",
"861350065", "内蒙古通辽市",
"861580857", "贵州省毕节地区",
"861768967", "福建省泉州市",
"861352956", "云南省曲靖市",
"861850525", "江苏省镇江市",
"861472611", "四川省遂宁市",
"861337102", "山东省泰安市",
"861380663", "浙江省宁波市",
"861813567", "河南省郑州市",
"86184545", "山东省烟台市",
"861772900", "陕西省西安市",
"861700344", "广东省深圳市",
"861570418", "辽宁省阜新市",
"861528928", "陕西省西安市",
"861362500", "福建省厦门市",
"861556583", "河南省商丘市",
"861508978", "广东省潮州市",
"861572720", "湖北省宜昌市",
"861533840", "广东省佛山市",
"861597435", "湖南省岳阳市",
"861837154", "湖北省咸宁市",
"86151748", "内蒙古赤峰市",
"86134642", "辽宁省朝阳市",
"861810010", "天津市",
"861810730", "湖南省岳阳市",
"861452647", "江苏省泰州市",
"861861358", "山西省吕梁市",
"861516536", "山东省潍坊市",
"861867665", "广东省深圳市",
"861860683", "浙江省嘉兴市",
"861323694", "辽宁省大连市",
"861514198", "辽宁省葫芦岛市",
"861503198", "河北省保定市",
"861880704", "江西省抚州市",
"86153701", "江苏省苏州市",
"861399790", "湖北省荆门市",
"861589896", "山东省烟台市",
"861867194", "湖北省襄樊市",
"86633", "山东省日照市",
"861342534", "广东省汕头市",
"861882477", "广东省汕头市",
"861317158", "河北省石家庄市",
"861362731", "湖南省长沙市",
"861511492", "陕西省榆林市",
"86136401", "广东省韶关市",
"86187573", "浙江省嘉兴市",
"86138554", "安徽省淮南市",
"861311186", "四川省成都市",
"86187501", "福建省福州市",
"861513249", "河北省石家庄市",
"861322180", "浙江省杭州市",
"861537925", "甘肃省庆阳市",
"861566625", "山东省泰安市",
"861787771", "湖南省怀化市",
"861554816", "内蒙古乌兰察布市",
"861894707", "内蒙古鄂尔多斯市",
"861599511", "江苏省扬州市",
"861324267", "广东省珠海市",
"861524582", "黑龙江省齐齐哈尔市",
"861317716", "湖北省荆门市",
"861311394", "广东省中山市",
"861847607", "广东省湛江市",
"861317036", "湖南省郴州市",
"861458681", "湖南省常德市",
"861471989", "新疆乌鲁木齐市",
"861339614", "湖北省宜昌市",
"861337544", "山东省德州市",
"861882967", "陕西省宝鸡市",
"86133418", "上海市",
"86157070", "江西省上饶市",
"861334879", "湖南省邵阳市",
"86177954", "宁夏固原市",
"861530615", "江苏省无锡市",
"86155565", "安徽省阜阳市",
"861361486", "内蒙古赤峰市",
"86177092", "陕西省西安市",
"861309773", "广西桂林市",
"861814352", "贵州省遵义市",
"861562203", "广东省茂名市",
"861367458", "黑龙江省伊春市",
"86136994", "四川省成都市",
"861329723", "湖北省黄石市",
"861302085", "河北省石家庄市",
"861786932", "云南省楚雄彝族自治州",
"86156171", "河南省新乡市",
"861817548", "安徽省六安市",
"861534458", "黑龙江省鸡西市",
"861390365", "黑龙江省哈尔滨市",
"861770735", "湖南省郴州市",
"861399972", "新疆伊犁哈萨克自治州",
"86152679", "浙江省金华市",
"861390686", "浙江省台州市",
"86156103", "山东省泰安市",
"861817494", "广西河池市",
"861886769", "浙江省嘉兴市",
"861303060", "安徽省淮北市",
"861314060", "河南省信阳市",
"861820328", "河北省衡水市",
"86189677", "浙江省温州市",
"861820481", "内蒙古兴安盟",
"861800378", "河南省开封市",
"861351836", "四川省遂宁市",
"861470357", "山西省临汾市",
"861816319", "湖北省十堰市",
"861890242", "广东省佛山市",
"861881466", "黑龙江省齐齐哈尔市",
"861321872", "江苏省泰州市",
"861303270", "湖北省宜昌市",
"86138612", "江苏省常州市",
"861524159", "辽宁省丹东市",
"861314304", "河北省石家庄市",
"861589578", "江苏省连云港市",
"861812905", "新疆阿勒泰地区",
"861859450", "福建省宁德市",
"861328495", "黑龙江省绥化市",
"861362987", "河南省商丘市",
"861303304", "安徽省芜湖市",
"861300809", "山西省大同市",
"86132600", "北京市",
"861315090", "内蒙古呼伦贝尔市",
"861889095", "新疆喀什地区",
"861459063", "广东省肇庆市",
"861523841", "河南省三门峡市",
"861368941", "甘肃省天水市",
"861373076", "四川省内江市",
"861778126", "四川省自贡市",
"861479184", "陕西省西安市",
"861322329", "河北省邢台市",
"86152750", "山东省菏泽市",
"861819862", "贵州省贵阳市",
"861589193", "云南省文山壮族苗族自治州",
"861580436", "吉林省白城市",
"86186027", "湖北省武汉市",
"861454114", "安徽省阜阳市",
"861366789", "广西玉林市",
"861340777", "广西河池市",
"861572388", "广西河池市",
"861531477", "浙江省绍兴市",
"861572421", "浙江省温州市",
"861338795", "江西省宜春市",
"861362569", "安徽省芜湖市",
"861321833", "江苏省淮安市",
"861378810", "广西防城港市",
"861354968", "湖南省长沙市",
"86139849", "贵州省遵义市",
"861804810", "四川省广安市",
"861342815", "广东省茂名市",
"861760998", "新疆喀什地区",
"861556668", "辽宁省葫芦岛市",
"861872012", "江西省赣州市",
"861527008", "江西省上饶市",
"861570342", "山西省大同市",
"86155521", "山东省聊城市",
"861587128", "湖北省孝感市",
"861535907", "福建省龙岩市",
"861396337", "山东省东营市",
"861470628", "江苏省南通市",
"861776767", "新疆巴音郭楞蒙古自治州",
"861820657", "山东省滨州市",
"861883435", "山西省晋城市",
"861361845", "湖南省郴州市",
"861370444", "吉林省吉林市",
"861310827", "四川省巴中市",
"861332633", "山东省日照市",
"861592948", "陕西省西安市",
"861532976", "贵州省铜仁地区",
"861339423", "辽宁省抚顺市",
"861779048", "四川省南充市",
"86180693", "浙江省台州市",
"861770640", "浙江省杭州市",
"861860568", "安徽省阜阳市",
"861362430", "吉林省长春市",
"861309732", "江西省赣州市",
"861538337", "河北省沧州市",
"861510722", "湖北省武汉市",
"861500783", "广西桂林市",
"861369620", "四川省南充市",
"86158926", "四川省绵阳市",
"86156645", "山东省枣庄市",
"861558318", "四川省广元市",
"861561538", "山东省泰安市",
"861816356", "湖北省襄樊市",
"861399933", "新疆石河子市",
"861830781", "广西南宁市",
"861590982", "辽宁省沈阳市",
"861399491", "山西省朔州市",
"861705152", "安徽省合肥市",
"861810431", "吉林省长春市",
"861846978", "云南省大理白族自治州",
"861810993", "新疆石河子市",
"861355998", "福建省龙岩市",
"861768152", "浙江省绍兴市",
"861459232", "四川省成都市",
"861311512", "江苏省苏州市",
"861829696", "江西省抚州市",
"86152743", "湖南省湘西土家族苗族自治州",
"861869936", "新疆昌吉回族自治州",
"861816014", "四川省内江市",
"86185875", "广西南宁市",
"861816734", "浙江省绍兴市",
"861563363", "河北省唐山市",
"861526586", "山东省东营市",
"861820780", "广西防城港市",
"861556812", "吉林省白山市",
"86138388", "河南省洛阳市",
"861537518", "安徽省安庆市",
"86151615", "江苏省无锡市",
"861372306", "河南省驻马店市",
"86182431", "吉林省长春市",
"861846468", "山东省东营市",
"861340346", "山西省太原市",
"86139316", "河北省廊坊市",
"861347643", "湖北省襄樊市",
"861515401", "山东省威海市",
"861472898", "西藏拉萨市",
"861336018", "广东省阳江市",
"861336738", "湖南省娄底市",
"861511971", "广东省茂名市",
"861503532", "山西省阳泉市",
"861509456", "黑龙江省伊春市",
"86180161", "四川省德阳市",
"861786463", "山东省滨州市",
"861774918", "陕西省渭南市",
"861313942", "甘肃省定西市",
"861316488", "福建省厦门市",
"861356305", "山东省滨州市",
"861822564", "安徽省六安市",
"86137389", "浙江省金华市",
"861393410", "山西省运城市",
"861818600", "湖北省黄石市",
"861339254", "广东省珠海市",
"86133567", "山东省潍坊市",
"861813989", "甘肃省定西市",
"861886531", "山东省济南市",
"861302264", "浙江省衢州市",
"861773404", "河北省石家庄市",
"86177725", "河北省秦皇岛市",
"861345847", "四川省宜宾市",
"861535580", "浙江省舟山市",
"861879074", "河南省三门峡市",
"861450580", "辽宁省阜新市",
"861378989", "山东省淄博市",
"861351681", "浙江省杭州市",
"861887590", "广东省深圳市",
"861453471", "黑龙江省哈尔滨市",
"861830937", "甘肃省白银市",
"861317759", "江西省鹰潭市",
"86186386", "河南省郑州市",
"861850918", "陕西省榆林市",
"861300860", "云南省红河哈尼族彝族自治州",
"861388999", "广东省东莞市",
"861452764", "广西贺州市",
"861536349", "广东省惠州市",
"861890427", "辽宁省盘锦市",
"861351355", "山西省长治市",
"861357668", "江西省赣州市",
"861894417", "江苏省无锡市",
"861317406", "江苏省无锡市",
"86189563", "安徽省宣城市",
"861830871", "云南省昆明市",
"86150846", "黑龙江省哈尔滨市",
"861888840", "广西钦州市",
"861862529", "江苏省常州市",
"861802137", "江苏省徐州市",
"861815685", "安徽省阜阳市",
"861857940", "广西柳州市",
"861380088", "北京市",
"861390977", "青海省海西蒙古族藏族自治州",
"861362069", "山西省运城市",
"86158957", "江苏省扬州市",
"861370098", "四川省泸州市",
"861880414", "辽宁省本溪市",
"861470940", "甘肃省临夏回族自治州",
"861565110", "江苏省苏州市",
"861358549", "江苏省徐州市",
"861311599", "福建省泉州市",
"861478905", "西藏昌都地区",
"86151110", "湖南省长沙市",
"861525081", "江苏省无锡市",
"86137980", "广东省广州市",
"861860278", "湖北省黄冈市",
"861894281", "四川省自贡市",
"861324489", "广东省深圳市",
"861384974", "河南省信阳市",
"861379690", "黑龙江省双鸭山市",
"861345194", "江苏省南京市",
"86189228", "广东省深圳市",
"861825740", "浙江省宁波市",
"86183430", "吉林省长春市",
"861839463", "甘肃省陇南市",
"861363204", "广东省潮州市",
"861824442", "四川省南充市",
"861309512", "新疆伊犁哈萨克自治州",
"861522945", "陕西省安康市",
"861840338", "河北省邯郸市",
"861363370", "河南省商丘市",
"861360528", "江苏省镇江市",
"86180280", "广东省广州市",
"861804801", "四川省巴中市",
"861378801", "广西南宁市",
"861362676", "浙江省嘉兴市",
"861814396", "河南省驻马店市",
"861311732", "湖南省湘潭市",
"861567188", "湖北省恩施土家族苗族自治州",
"861530540", "山东省菏泽市",
"861593326", "河北省廊坊市",
"861472669", "四川省甘孜藏族自治州",
"861885036", "福建省福州市",
"861534803", "甘肃省平凉市",
"861821148", "广东省广州市",
"861803184", "河北省石家庄市",
"861876283", "江苏省常州市",
"861594755", "内蒙古赤峰市",
"861885158", "江苏省无锡市",
"861509461", "黑龙江省大兴安岭地区",
"861787636", "广东省梅州市",
"861700549", "山东省青岛市",
"861362279", "广东省惠州市",
"861780333", "河北省秦皇岛市",
"861509709", "甘肃省庆阳市",
"861539920", "陕西省铜川市",
"861532451", "安徽省阜阳市",
"861331482", "内蒙古兴安盟",
"86183139", "云南省昆明市",
"861303509", "安徽省合肥市",
"861580006", "广东省佛山市",
"861328397", "河南省信阳市",
"86150319", "河北省邢台市",
"861520541", "山东省济南市",
"86181961", "新疆昌吉回族自治州",
"861892673", "广东省茂名市",
"861537738", "湖南省娄底市",
"861356537", "新疆喀什地区",
"861881687", "广东省中山市",
"861512191", "宁夏银川市",
"861816514", "陕西省渭南市",
"861788529", "贵州省黔东南苗族侗族自治州",
"86189312", "河北省保定市",
"861839973", "新疆克孜勒苏柯尔克孜自治州",
"861768375", "湖北省鄂州市",
"86147629", "江苏省南京市",
"861777618", "广西河池市",
"861822064", "陕西省汉中市",
"861321558", "安徽省阜阳市",
"861705375", "广西南宁市",
"861327586", "安徽省合肥市",
"861303817", "四川省内江市",
"861336518", "江苏省盐城市",
"861557717", "广西崇左市",
"861557037", "江西省南昌市",
"861364738", "湖南省娄底市",
"861353647", "广东省汕尾市",
"861379224", "山东省德州市",
"861389757", "青海省海西蒙古族藏族自治州",
"861361667", "浙江省台州市",
"861588256", "四川省广安市",
"861535080", "河北省衡水市",
"8615701", "北京市",
"861370786", "广西南宁市",
"861887090", "江西省新余市",
"86178580", "浙江省温州市",
"861452331", "河南省信阳市",
"86156140", "河北省邯郸市",
"861459688", "新疆石河子市",
"861512957", "陕西省铜川市",
"861886031", "河南省许昌市",
"861337349", "河北省邢台市",
"86136382", "重庆市",
"86187667", "山东省东营市",
"861595942", "福建省莆田市",
"861352992", "云南省大理白族自治州",
"861800820", "四川省泸州市",
"861564349", "吉林省长春市",
"86159060", "福建省泉州市",
"861871130", "湖南省湘潭市",
"86156597", "福建省福州市",
"861391240", "江苏省南通市",
"86138377", "河南省南阳市",
"861470455", "黑龙江省绥化市",
"86150897", "广东省清远市",
"86151516", "江苏省苏州市",
"861393401", "山西省吕梁市",
"861390467", "黑龙江省牡丹江市",
"861380796", "江西省吉安市",
"861877080", "江西省鹰潭市",
"861590890", "山东省烟台市",
"861761435", "吉林省通化市",
"861571355", "山西省长治市",
"861563459", "山东省潍坊市",
"861330892", "西藏日喀则地区",
"861898998", "西藏拉萨市",
"861318051", "河北省邯郸市",
"861533499", "内蒙古巴彦淖尔市",
"861572770", "江西省萍乡市",
"861530797", "江西省赣州市",
"861459454", "陕西省商洛市",
"861531242", "江苏省徐州市",
"861565928", "福建省厦门市",
"86155980", "内蒙古呼和浩特市",
"861313077", "辽宁省铁岭市",
"861840830", "四川省凉山彝族自治州",
"861592506", "云南省昭通市",
"861338257", "江苏省泰州市",
"86188524", "江苏省苏州市",
"861850575", "浙江省绍兴市",
"86183621", "江苏省南通市",
"861305297", "江苏省泰州市",
"861566675", "山东省济宁市",
"861330335", "河北省秦皇岛市",
"861479606", "广西玉林市",
"861569796", "江西省吉安市",
"861313267", "广西钦州市",
"861860804", "四川省成都市",
"861302180", "河北省石家庄市",
"861458122", "安徽省安庆市",
"861342996", "湖北省十堰市",
"861890152", "江苏省无锡市",
"861834698", "黑龙江省伊春市",
"861304267", "辽宁省锦州市",
"861306438", "四川省自贡市",
"861843411", "山西省太原市",
"861518825", "河南省信阳市",
"861350708", "江西省南昌市",
"861860415", "辽宁省丹东市",
"861314165", "江苏省南京市",
"86185549", "山东省青岛市",
"861833146", "河北省衡水市",
"861871814", "广东省梅州市",
"861806784", "浙江省绍兴市",
"861333061", "四川省巴中市",
"861843287", "河北省沧州市",
"861303694", "广西梧州市",
"86134647", "辽宁省营口市",
"861454767", "山东省济宁市",
"86138483", "内蒙古乌海市",
"86131905", "内蒙古呼和浩特市",
"861859303", "甘肃省酒泉市",
"861862374", "河南省安阳市",
"861364975", "青海省果洛藏族自治州",
"861523198", "河北省保定市",
"861875975", "福建省漳州市",
"86150679", "浙江省金华市",
"861323060", "河北省保定市",
"861590398", "河南省三门峡市",
"861886842", "浙江省杭州市",
"861567829", "广西柳州市",
"861364465", "黑龙江省绥化市",
"861390542", "山东省青岛市",
"861811652", "四川省攀枝花市",
"861800328", "河北省衡水市",
"86189672", "浙江省湖州市",
"86180114", "四川省成都市",
"861820378", "河南省开封市",
"861569088", "河南省郑州市",
"861332622", "山东省莱芜市",
"861537465", "内蒙古巴彦淖尔市",
"861530483", "黑龙江省牡丹江市",
"861846515", "宁夏中卫市",
"861333556", "安徽省安庆市",
"861339432", "吉林省吉林市",
"86181698", "广东省佛山市",
"86170841", "辽宁省大连市",
"861896935", "浙江省金华市",
"861539334", "甘肃省平凉市",
"861329773", "广西桂林市",
"861506112", "江苏省常州市",
"861377037", "江苏省淮安市",
"861309723", "江西省景德镇市",
"861319782", "江西省抚州市",
"861322085", "山东省青岛市",
"861560680", "浙江省舟山市",
"86158181", "广东省广州市",
"861510733", "湖南省株洲市",
"861812343", "四川省广元市",
"861781434", "内蒙古兴安盟",
"861760382", "河南省开封市",
"861778176", "四川省甘孜藏族自治州",
"861322379", "河南省开封市",
"861819749", "青海省果洛藏族自治州",
"861550786", "广西南宁市",
"86150750", "河北省邯郸市",
"861376899", "广西玉林市",
"861582982", "陕西省榆林市",
"86186022", "天津市",
"861709411", "广东省深圳市",
"861818026", "四川省广安市",
"861873566", "山西省运城市",
"861848586", "贵州省六盘水市",
"861572992", "新疆塔城地区",
"861335455", "黑龙江省绥化市",
"861301872", "广东省中山市",
"861323270", "广东省湛江市",
"861707535", "山东省烟台市",
"861890589", "浙江省金华市",
"86151284", "河北省廊坊市",
"861831608", "广东省阳江市",
"86138617", "江苏省无锡市",
"861521727", "广东省汕头市",
"861308495", "广西贵港市",
"861874495", "贵州省黔西南布依族苗族自治州",
"861580948", "甘肃省陇南市",
"861599105", "陕西省安康市",
"861365495", "辽宁省沈阳市",
"86130600", "四川省成都市",
"861320809", "浙江省宁波市",
"86139575", "浙江省绍兴市",
"861352388", "河南省信阳市",
"861312405", "河南省焦作市",
"861359950", "福建省厦门市",
"861598975", "广东省珠海市",
"86135442", "广东省深圳市",
"861806874", "江苏省徐州市",
"861535443", "河北省保定市",
"861843400", "山西省忻州市",
"861586413", "山东省济宁市",
"861477075", "江西省吉安市",
"861815624", "安徽省宿州市",
"861862487", "河南省洛阳市",
"861848798", "云南省临沧市",
"861805441", "山东省潍坊市",
"861816602", "江西省宜春市",
"861369506", "福建省南平市",
"86186421", "辽宁省朝阳市",
"861376668", "黑龙江省双鸭山市",
"861350342", "河南省平顶山市",
"861817639", "广西梧州市",
"861304577", "浙江省温州市",
"861763313", "河北省张家口市",
"861877443", "湖南省娄底市",
"861579726", "湖北省黄石市",
"861550598", "福建省三明市",
"861779906", "新疆阿勒泰地区",
"861876940", "山东省烟台市",
"861824067", "河南省新乡市",
"861313577", "湖北省荆州市",
"861880673", "浙江省嘉兴市",
"861335628", "山东省滨州市",
"861504082", "辽宁省抚顺市",
"861573865", "河南省新乡市",
"861837998", "江西省南昌市",
"861582890", "四川省巴中市",
"861382467", "广东省云浮市",
"861533412", "湖北省黄冈市",
"861813227", "河北省唐山市",
"861534675", "甘肃省武威市",
"861388754", "云南省文山壮族苗族自治州",
"861804227", "浙江省湖州市",
"861330819", "四川省成都市",
"86158260", "重庆市",
"861333314", "河北省承德市",
"861825097", "福建省南平市",
"861593195", "河北省邢台市",
"861325854", "黑龙江省双鸭山市",
"861317994", "新疆昌吉回族自治州",
"861336975", "青海省海东地区",
"861329394", "山西省吕梁市",
"861899472", "江苏省泰州市",
"861896380", "新疆乌鲁木齐市",
"861593664", "河南省漯河市",
"861774075", "西藏昌都地区",
"861572880", "广东省汕尾市",
"861575998", "福建省南平市",
"861708342", "山西省大同市",
"861803125", "河北省秦皇岛市",
"861330507", "福建省泉州市",
"861333561", "安徽省淮北市",
"861320981", "山西省太原市",
"861529492", "河南省驻马店市",
"86135863", "浙江省嘉兴市",
"861316654", "河北省唐山市",
"861872604", "安徽省马鞍山市",
"86188028", "四川省成都市",
"861311723", "湖北省襄樊市",
"861390042", "辽宁省鞍山市",
"861336465", "吉林省辽源市",
"86150475", "内蒙古通辽市",
"861539409", "甘肃省武威市",
"861890375", "河南省平顶山市",
"861376812", "广西柳州市",
"861899962", "新疆巴音郭楞蒙古自治州",
"861539761", "四川省成都市",
"861840644", "山西省临汾市",
"861823020", "河北省邯郸市",
"86184692", "云南省昭通市",
"861576717", "广东省中山市",
"861395159", "江苏省宿迁市",
"86151375", "河南省平顶山市",
"861780322", "河北省保定市",
"861353117", "广东省汕头市",
"861520395", "河南省漯河市",
"861375425", "浙江省丽水市",
"86177633", "山东省日照市",
"861323560", "湖北省荆州市",
"861501887", "广东省惠州市",
"86182620", "江苏省苏州市",
"861330980", "辽宁省鞍山市",
"86139676", "浙江省台州市",
"861815290", "新疆克拉玛依市",
"861510513", "江苏省连云港市",
"86181914", "陕西省西安市",
"861780550", "安徽省滁州市",
"86130779", "江西省南昌市",
"861318679", "浙江省舟山市",
"861322585", "安徽省合肥市",
"861550876", "云南省文山壮族苗族自治州",
"86187029", "陕西省西安市",
"861569588", "浙江省杭州市",
"861333056", "云南省楚雄彝族自治州",
"86155389", "河南省焦作市",
"861572919", "河南省南阳市",
"86136007", "福建省泉州市",
"861373141", "河北省承德市",
"861587889", "广西柳州市",
"86158717", "湖北省武汉市",
"861802369", "广东省韶关市",
"861323439", "吉林省白山市",
"861372763", "广东省梅州市",
"86147067", "广东省广州市",
"861320737", "湖南省益阳市",
"861893231", "江苏省淮安市",
"86136026", "广东省深圳市",
"861597169", "湖北省恩施土家族苗族自治州",
"861329883", "吉林省松原市",
"861869399", "甘肃省兰州市",
"861571681", "河北省邯郸市",
"861802285", "广东省广州市",
"86150700", "江西省南昌市",
"861372652", "广东省汕头市",
"861856080", "山东省济南市",
"861319872", "四川省乐山市",
"86134595", "福建省泉州市",
"861853393", "河北省邯郸市",
"861381476", "江苏省常州市",
"861821862", "广东省揭阳市",
"861803260", "河北省廊坊市",
"86130650", "山东省济南市",
"861812187", "四川省成都市",
"861309604", "四川省绵阳市",
"861890089", "广东省清远市",
"861589028", "河南省三门峡市",
"861876455", "山东省滨州市",
"86185767", "广东省深圳市",
"861505081", "江苏省淮安市",
"861558567", "吉林省通化市",
"861358282", "河北省保定市",
"861890893", "西藏山南地区",
"861570065", "四川省自贡市",
"861313489", "内蒙古包头市",
"861319833", "四川省宜宾市",
"861333739", "湖南省邵阳市",
"861860705", "江西省宜春市",
"861304489", "湖北省荆门市",
"861510882", "云南省文山壮族苗族自治州",
"861572956", "宁夏石嘴山市",
"861863504", "山西省忻州市",
"861330437", "吉林省辽源市",
"861450185", "山西省长治市",
"861856124", "山东省东营市",
"861871307", "河北省沧州市",
"861333019", "江西省宜春市",
"861520873", "云南省红河哈尼族彝族自治州",
"861815413", "安徽省宿州市",
"86131724", "广东省深圳市",
"861855102", "江苏省连云港市",
"861862579", "河南省洛阳市",
"861831890", "广东省惠州市",
"861399547", "宁夏银川市",
"861760154", "江苏省南京市",
"86152846", "贵州省毕节地区",
"861840767", "广东省广州市",
"861350418", "辽宁省沈阳市",
"861586624", "山东省枣庄市",
"861329099", "河南省信阳市",
"861477084", "江西省宜春市",
"861843469", "山西省忻州市",
"861598984", "广东省汕头市",
"86158952", "江苏省徐州市",
"861860317", "河北省沧州市",
"861806885", "江苏省盐城市",
"861556955", "新疆喀什地区",
"861376583", "贵州省贵阳市",
"861512848", "河北省保定市",
"861395116", "江苏省泰州市",
"861533348", "山西省临汾市",
"861369436", "吉林省白城市",
"861363552", "安徽省蚌埠市",
"861362626", "江苏省镇江市",
"861529709", "青海省西宁市",
"861330153", "江苏省无锡市",
"861529461", "河南省郑州市",
"861588146", "四川省德阳市",
"861478343", "河南省安阳市",
"861571457", "黑龙江省鸡西市",
"861539970", "湖南省益阳市",
"861773952", "河南省焦作市",
"861326765", "广东省江门市",
"861346968", "宁夏银川市",
"86807", "西藏索县",
"861336984", "新疆克孜勒苏柯尔克孜自治州",
"861367684", "浙江省金华市",
"861811696", "新疆吐鲁番地区",
"861858646", "贵州省六盘水市",
"861378442", "河北省保定市",
"861372212", "内蒙古包头市",
"861770978", "青海省西宁市",
"861534684", "甘肃省庆阳市",
"86139258", "广东省东莞市",
"861839316", "甘肃省天水市",
"861597768", "广西南宁市",
"861822453", "河南省郑州市",
"861822690", "安徽省亳州市",
"861312535", "江西省吉安市",
"861808816", "云南省德宏傣族景颇族自治州",
"86182280", "四川省成都市",
"861502945", "陕西省安康市",
"861893910", "河南省许昌市",
"861858249", "四川省成都市",
"861852419", "辽宁省辽阳市",
"861360578", "浙江省宁波市",
"861363320", "河北省邯郸市",
"861813442", "河南省洛阳市",
"861355154", "四川省内江市",
"861454830", "广东省广州市",
"86183469", "黑龙江省佳木斯市",
"861705325", "广东省广州市",
"861379300", "山东省菏泽市",
"861870866", "贵州省六盘水市",
"861768325", "四川省绵阳市",
"861323817", "辽宁省鞍山市",
"861770468", "福建省厦门市",
"861839923", "新疆和田地区",
"861802064", "福建省宁德市",
"861301558", "河南省洛阳市",
"86153911", "内蒙古呼和浩特市",
"861830543", "山东省滨州市",
"861862651", "吉林省吉林市",
"861302524", "广东省汕头市",
"86186465", "黑龙江省哈尔滨市",
"861869094", "新疆博尔塔拉蒙古自治州",
"861327642", "山东省青岛市",
"861308397", "浙江省杭州市",
"861369857", "贵州省毕节地区",
"86152319", "河北省邢台市",
"861500541", "山东省济南市",
"861848199", "四川省巴中市",
"861323509", "福建省龙岩市",
"861539792", "江西省九江市",
"861319058", "内蒙古乌海市",
"861384838", "内蒙古兴安盟",
"861365397", "河南省郑州市",
"861586290", "江苏省连云港市",
"861335357", "山西省临汾市",
"86189317", "河北省沧州市",
"861587231", "湖北省襄樊市",
"861539460", "江苏省徐州市",
"861529971", "新疆阿勒泰地区",
"861509921", "新疆伊犁哈萨克自治州",
"861310493", "广东省湛江市",
"861569752", "广东省惠州市",
"861855544", "安徽省六安市",
"861571836", "广东省潮州市",
"861319136", "内蒙古鄂尔多斯市",
"86150892", "广东省惠州市",
"861364367", "山西省阳泉市",
"861821891", "广东省阳江市",
"86138372", "河南省安阳市",
"861359183", "辽宁省大连市",
"861814209", "浙江省嘉兴市",
"86152897", "海南省海口市",
"861800870", "云南省昭通市",
"861889341", "甘肃省庆阳市",
"861865113", "江苏省苏州市",
"86170870", "广西桂林市",
"861561649", "湖南省常德市",
"861899157", "陕西省宝鸡市",
"861557943", "江西省宜春市",
"861885248", "江苏省无锡市",
"861360896", "山东省青岛市",
"86317", "河北省沧州市",
"861879524", "宁夏固原市",
"86183566", "安徽省池州市",
"861709530", "江苏省盐城市",
"861561246", "河北省承德市",
"86187662", "山东省青岛市",
"86155009", "海南省海口市",
"86136387", "云南省楚雄彝族自治州",
"861880632", "山东省枣庄市",
"861556440", "山东省德州市",
"861330856", "贵州省铜仁地区",
"861821258", "贵州省毕节地区",
"861479070", "安徽省安庆市",
"861818390", "云南省普洱市",
"861359776", "湖北省恩施土家族苗族自治州",
"861591937", "广东省惠州市",
"86151624", "江苏省苏州市",
"861850584", "浙江省宁波市",
"861357955", "新疆吐鲁番地区",
"86852", "贵州省遵义市",
"861800657", "浙江省台州市",
"861570565", "安徽省马鞍山市",
"861373390", "河南省平顶山市",
"861333807", "江苏省南通市",
"861330861", "湖北省荆州市",
"861538768", "四川省阿坝藏族羌族自治州",
"861871535", "安徽省淮南市",
"861531427", "山东省淄博市",
"861811212", "江苏省扬州市",
"861372696", "广东省清远市",
"861399047", "四川省甘孜藏族自治州",
"861824810", "内蒙古呼和浩特市",
"86147414", "辽宁省阜新市",
"86152910", "陕西省西安市",
"861325755", "河北省石家庄市",
"861890967", "安徽省亳州市",
"861533702", "甘肃省庆阳市",
"861893901", "河南省洛阳市",
"861329599", "河南省信阳市",
"861372299", "河北省石家庄市",
"861333092", "四川省乐山市",
"86130036", "浙江省杭州市",
"861518603", "贵州省铜仁地区",
"861862385", "河南省商丘市",
"861806775", "浙江省丽水市",
"861312307", "福建省龙岩市",
"861870851", "贵州省贵阳市",
"86177714", "湖北省武汉市",
"861504758", "内蒙古赤峰市",
"861529837", "江苏省南京市",
"861532926", "贵州省铜仁地区",
"861339473", "内蒙古乌海市",
"86182693", "广西玉林市",
"861310877", "云南省玉溪市",
"861510772", "广西柳州市",
"861369670", "安徽省宿州市",
"861329012", "山东省泰安市",
"861819148", "陕西省宝鸡市",
"861566684", "山东省菏泽市",
"86133313", "河北省石家庄市",
"861520783", "广西桂林市",
"861863360", "河北省廊坊市",
"861329732", "湖南省湘潭市",
"861558277", "山西省吕梁市",
"861786923", "云南省德宏傣族景颇族自治州",
"861370826", "四川省资阳市",
"861869448", "陕西省安康市",
"861302953", "内蒙古乌兰察布市",
"861510990", "新疆和田地区",
"861322074", "山东省潍坊市",
"861511921", "广东省韶关市",
"86183665", "山东省潍坊市",
"861523532", "山西省阳泉市",
"86186795", "江西省宜春市",
"861339963", "安徽省宣城市",
"861869594", "河南省新乡市",
"861387290", "湖北省荆门市",
"861324942", "广东省佛山市",
"86186669", "广东省珠海市",
"86183799", "江西省上饶市",
"86136378", "重庆市",
"86182161", "湖南省常德市",
"861839554", "安徽省宣城市",
"861802564", "广东省汕头市",
"861301058", "广东省江门市",
"86158598", "福建省三明市",
"86150743", "湖南省湘西土家族苗族自治州",
"861530145", "江苏省扬州市",
"861800780", "广西南宁市",
"86181331", "安徽省阜阳市",
"861506586", "山东省淄博市",
"86180431", "吉林省长春市",
"86137831", "河南省洛阳市",
"861831982", "广东省潮州市",
"861319558", "安徽省阜阳市",
"861526642", "山东省枣庄市",
"861776114", "四川省巴中市",
"861377280", "陕西省汉中市",
"861802311", "广东省河源市",
"861829306", "甘肃省定西市",
"861356943", "河南省新乡市",
"86188376", "河南省信阳市",
"861320860", "吉林省松原市",
"861331949", "江西省赣州市",
"861394917", "河南省信阳市",
"861339502", "福建省厦门市",
"861572961", "四川省南充市",
"861817906", "江西省赣州市",
"86184879", "云南省西双版纳傣族自治州",
"861336367", "河北省沧州市",
"86438", "吉林省松原市",
"861454644", "云南省昭通市",
"86183281", "四川省眉山市",
"861354381", "广东省中山市",
"861890477", "内蒙古鄂尔多斯市",
"861504813", "内蒙古呼伦贝尔市",
"861508515", "贵州省黔南布依族苗族自治州",
"861380914", "陕西省咸阳市",
"861892704", "广东省河源市",
"861768242", "浙江省金华市",
"86137666", "黑龙江省牡丹江市",
"861539039", "四川省凉山彝族自治州",
"861453388", "内蒙古阿拉善盟",
"861879024", "河南省焦作市",
"861513813", "河南省驻马店市",
"861700638", "山东省青岛市",
"861824989", "黑龙江省伊春市",
"861333813", "江苏省扬州市",
"86150687", "浙江省杭州市",
"861520079", "湖南省湘西土家族苗族自治州",
"861809977", "新疆巴音郭楞蒙古自治州",
"861384859", "内蒙古锡林郭勒盟",
"861581681", "广东省东莞市",
"861319039", "辽宁省葫芦岛市",
"861812197", "四川省泸州市",
"861375906", "云南省玉溪市",
"861581172", "广东省清远市",
"86152682", "浙江省湖州市",
"861479958", "新疆博尔塔拉蒙古自治州",
"86151562", "安徽省安庆市",
"861890099", "辽宁省大连市",
"86177921", "陕西省榆林市",
"86157717", "陕西省西安市",
"861834232", "辽宁省盘锦市",
"861883066", "河北省石家庄市",
"861820547", "山东省济宁市",
"861301539", "山西省大同市",
"86183517", "江苏省苏州市",
"861381343", "江苏省盐城市",
"861587899", "广西北海市",
"861355319", "山东省济南市",
"86182786", "广西百色市",
"861345070", "广东省梅州市",
"861329893", "西藏山南地区",
"861344290", "陕西省渭南市",
"861571691", "河北省石家庄市",
"861511949", "广东省阳江市",
"861869389", "甘肃省陇南市",
"861473686", "云南省德宏傣族景颇族自治州",
"861869075", "贵州省贵阳市",
"861847474", "湖南省怀化市",
"86130778", "广东省深圳市",
"861770322", "河北省保定市",
"861539558", "安徽省阜阳市",
"861322595", "福建省泉州市",
"8613452", "重庆市",
"86178633", "山东省日照市",
"861363086", "河北省保定市",
"861819420", "甘肃省武威市",
"861453449", "辽宁省葫芦岛市",
"86187028", "四川省成都市",
"861569598", "福建省三明市",
"861840932", "甘肃省定西市",
"861882604", "广东省中山市",
"86130111", "北京市",
"861391431", "江苏省常州市",
"861310145", "福建省泉州市",
"861335842", "福建省泉州市",
"861890512", "江苏省连云港市",
"861318100", "山东省滨州市",
"86155388", "河南省洛阳市",
"861360631", "山东省威海市",
"861301792", "浙江省丽水市",
"86188029", "陕西省西安市",
"861804336", "吉林省延边朝鲜族自治州",
"861520269", "宁夏银川市",
"861346545", "山东省烟台市",
"861582919", "陕西省渭南市",
"861458310", "江西省萍乡市",
"861312313", "福建省泉州市",
"86139937", "甘肃省酒泉市",
"86156343", "山东省威海市",
"861519963", "新疆克拉玛依市",
"861507416", "湖南省郴州市",
"861770550", "安徽省滁州市",
"861847143", "湖北省孝感市",
"861330990", "新疆克拉玛依市",
"861520666", "山东省济南市",
"86189366", "江苏省连云港市",
"861760319", "河北省邢台市",
"861317984", "新疆乌鲁木齐市",
"86151313", "河北省邢台市",
"861329384", "山西省吕梁市",
"861477399", "湖南省常德市",
"861330772", "广西柳州市",
"861896390", "湖北省恩施土家族苗族自治州",
"861301970", "黑龙江省哈尔滨市",
"861530877", "云南省玉溪市",
"861572890", "西藏拉萨市",
"86159241", "浙江省杭州市",
"861810555", "安徽省马鞍山市",
"861320433", "吉林省延边朝鲜族自治州",
"861321920", "四川省遂宁市",
"86150413", "辽宁省抚顺市",
"861700261", "广东省江门市",
"861529482", "河南省信阳市",
"861831956", "广东省广州市",
"8615921", "上海市",
"861866688", "广东省东莞市",
"861305400", "湖南省郴州市",
"861582880", "四川省内江市",
"861857293", "湖北省荆州市",
"861532307", "广东省惠州市",
"861568272", "甘肃省武威市",
"861394562", "黑龙江省大庆市",
"861360445", "吉林省通化市",
"86135926", "河南省郑州市",
"861376901", "云南省丽江市",
"861853894", "河南省郑州市",
"861506552", "山东省聊城市",
"861850399", "河南省漯河市",
"861313702", "河南省商丘市",
"861395592", "安徽省铜陵市",
"861505062", "江苏省南通市",
"861705604", "广东省深圳市",
"861358261", "河北省石家庄市",
"861345125", "湖北省十堰市",
"861569876", "辽宁省朝阳市",
"861550588", "浙江省杭州市",
"861318768", "云南省大理白族自治州",
"861596603", "山东省泰安市",
"861535376", "陕西省咸阳市",
"861595348", "山东省济宁市",
"861510861", "云南省德宏傣族景颇族自治州",
"861304702", "广东省阳江市",
"86135907", "广东省中山市",
"861577910", "江西省抚州市",
"861832457", "黑龙江省伊春市",
"861352398", "河南省三门峡市",
"861354140", "四川省宜宾市",
"861886940", "云南省昭通市",
"861811831", "江苏省徐州市",
"861809467", "浙江省绍兴市",
"861778793", "云南省普洱市",
"861386668", "安徽省合肥市",
"861557674", "湖南省衡阳市",
"861766010", "山东省济南市",
"86133624", "浙江省宁波市",
"861454202", "河南省郑州市",
"861589726", "青海省海南藏族自治州",
"86138521", "江苏省徐州市",
"861509949", "新疆巴音郭楞蒙古自治州",
"861867209", "湖北省宜昌市",
"861470531", "山东省济南市",
"861510856", "贵州省铜仁地区",
"861572982", "四川省攀枝花市",
"861815407", "安徽省阜阳市",
"861329967", "广西玉林市",
"861890599", "福建省南平市",
"861501502", "广东省江门市",
"861318111", "山东省威海市",
"861308485", "陕西省延安市",
"861867606", "广东省河源市",
"861520579", "浙江省金华市",
"861874485", "贵州省铜仁地区",
"861882723", "湖北省鄂州市",
"861319539", "安徽省六安市",
"861365485", "内蒙古兴安盟",
"861500529", "江苏省镇江市",
"861760392", "河南省鹤壁市",
"86130787", "云南省昆明市",
"861345570", "山东省东营市",
"861458301", "江西省鹰潭市",
"861454463", "陕西省西安市",
"861550796", "江西省吉安市",
"861570948", "甘肃省天水市",
"861862873", "吉林省松原市",
"861582992", "陕西省西安市",
"861376889", "广西柳州市",
"861301039", "福建省厦门市",
"861355835", "广西玉林市",
"86155377", "河南省南阳市",
"861369708", "江西省南昌市",
"861301719", "湖南省长沙市",
"861569098", "内蒙古包头市",
"861539136", "云南省昆明市",
"861530493", "辽宁省营口市",
"861340614", "山东省东营市",
"861341793", "广东省珠海市",
"861337371", "河南省安阳市",
"861530931", "甘肃省兰州市",
"861890732", "湖南省湘潭市",
"86156080", "四川省成都市",
"86181699", "广东省惠州市",
"86181765", "广西玉林市",
"861306416", "江西省九江市",
"861392444", "广东省揭阳市",
"861350006", "广东省深圳市",
"861869575", "福建省漳州市",
"861478745", "云南省昆明市",
"861700659", "山东省青岛市",
"861470700", "江西省南昌市",
"861539058", "甘肃省嘉峪关市",
"861560690", "福建省厦门市",
"861322095", "山东省聊城市",
"861560453", "黑龙江省牡丹江市",
"861319792", "江西省九江市",
"861586537", "山东省济宁市",
"86150678", "浙江省温州市",
"861857700", "广西防城港市",
"861590421", "辽宁省朝阳市",
"861760835", "四川省雅安市",
"861591490", "广东省梅州市",
"861392173", "江苏省泰州市",
"861591653", "广东省梅州市",
"861889329", "甘肃省酒泉市",
"861559757", "青海省海南藏族自治州",
"861590388", "河南省新乡市",
"861359852", "河南省焦作市",
"861800491", "辽宁省朝阳市",
"861800933", "甘肃省平凉市",
"861346045", "河南省郑州市",
"861591762", "广东省清远市",
"861831961", "广东省惠州市",
"861471855", "广东省河源市",
"861821470", "安徽省滁州市",
"86790", "江西省新余市",
"86185548", "山东省青岛市",
"861888267", "四川省广安市",
"861810055", "福建省厦门市",
"861303684", "广西梧州市",
"861843297", "河北省承德市",
"86178046", "黑龙江省哈尔滨市",
"861321648", "浙江省台州市",
"861596724", "浙江省湖州市",
"861833344", "河北省沧州市",
"861830849", "四川省绵阳市",
"861881405", "广东省惠州市",
"86136941", "辽宁省沈阳市",
"861505903", "福建省三明市",
"861821960", "甘肃省临夏回族自治州",
"861831471", "湖北省襄樊市",
"86137483", "内蒙古乌海市",
"86180883", "云南省临沧市",
"861327370", "河南省商丘市",
"861520930", "甘肃省临夏回族自治州",
"8613691", "北京市",
"861319970", "新疆昌吉回族自治州",
"861878348", "四川省广元市",
"861835901", "福建省莆田市",
"861595702", "浙江省衢州市",
"861569786", "江西省吉安市",
"861501473", "广东省佛山市",
"861893583", "新疆克拉玛依市",
"861313348", "山西省吕梁市",
"86185922", "陕西省西安市",
"86183933", "甘肃省天水市",
"861332848", "福建省龙岩市",
"861550088", "宁夏银川市",
"861454973", "浙江省嘉兴市",
"861556128", "内蒙古包头市",
"86135957", "贵州省毕节地区",
"861568562", "贵州省遵义市",
"861811467", "江苏省泰州市",
"861368287", "广东省汕头市",
"861505562", "安徽省蚌埠市",
"861879190", "陕西省西安市",
"861871926", "广东省广州市",
"861700571", "浙江省杭州市",
"86147272", "重庆市",
"861377413", "湖北省随州市",
"861850312", "河北省保定市",
"861368411", "四川省资阳市",
"861362241", "广东省阳江市",
"861329477", "内蒙古鄂尔多斯市",
"861554974", "湖北省随州市",
"861510437", "吉林省辽源市",
"861552042", "四川省南充市",
"861330882", "云南省德宏傣族景颇族自治州",
"861309427", "湖北省十堰市",
"861889180", "陕西省咸阳市",
"861827252", "河南省鹤壁市",
"861539833", "云南省昭通市",
"861305411", "湖南省株洲市",
"861562820", "新疆阿克苏地区",
"861533489", "内蒙古巴彦淖尔市",
"861341487", "广东省湛江市",
"861588549", "贵州省黔西南布依族苗族自治州",
"861865107", "江苏省南通市",
"861390306", "广东省广州市",
"861899860", "广东省清远市",
"861338724", "湖北省襄樊市",
"86437", "吉林省辽源市",
"861893812", "广东省云浮市",
"861771504", "江苏省南通市",
"861763307", "河北省邯郸市",
"861454932", "江苏省连云港市",
"861778666", "湖北省荆州市",
"861816244", "湖北省黄冈市",
"861594979", "山东省泰安市",
"86156300", "河北省邯郸市",
"861844747", "内蒙古乌兰察布市",
"86187376", "河南省信阳市",
"861361904", "四川省泸州市",
"861308143", "山东省潍坊市",
"861350670", "浙江省衢州市",
"86158496", "内蒙古赤峰市",
"861453398", "内蒙古巴彦淖尔市",
"861566220", "吉林省长春市",
"861707926", "浙江省舟山市",
"861539872", "云南省大理白族自治州",
"861889953", "新疆石河子市",
"861365474", "内蒙古乌兰察布市",
"861328424", "辽宁省沈阳市",
"861889024", "湖南省长沙市",
"861760514", "江苏省扬州市",
"861385218", "江苏省扬州市",
"861308474", "内蒙古乌兰察布市",
"86184878", "云南省文山壮族苗族自治州",
"861874474", "贵州省安顺市",
"861528322", "四川省资阳市",
"861586407", "山东省烟台市",
"86135712", "陕西省榆林市",
"861370914", "陕西省西安市",
"861339777", "广西南宁市",
"861867260", "湖北省荆门市",
"861823847", "河南省周口市",
"861800790", "江西省新余市",
"86157598", "福建省泉州市",
"861355361", "广东省韶关市",
"861590720", "湖北省宜昌市",
"861380826", "四川省遂宁市",
"861324634", "广东省佛山市",
"861591791", "广东省汕头市",
"861831992", "广东省惠州市",
"861538679", "山西省运城市",
"861817425", "湖南省怀化市",
"861800462", "黑龙江省齐齐哈尔市",
"861330513", "江苏省连云港市",
"861572608", "山东省德州市",
"861501432", "广东省汕头市",
"861360776", "广西百色市",
"86133375", "海南省海口市",
"861329152", "浙江省嘉兴市",
"861387280", "湖北省十堰市",
"86183798", "江西省赣州市",
"861778079", "四川省宜宾市",
"86136379", "重庆市",
"861319761", "广西南宁市",
"861319409", "福建省厦门市",
"861301334", "云南省曲靖市",
"861597566", "广东省阳江市",
"861556729", "吉林省松原市",
"861341930", "四川省广安市",
"861340423", "江苏省苏州市",
"86158599", "福建省南平市",
"861346610", "云南省曲靖市",
"861595499", "山东省烟台市",
"861351301", "河北省廊坊市",
"861803958", "河南省洛阳市",
"861890773", "广西桂林市",
"861880851", "贵州省贵阳市",
"861396551", "安徽省黄山市",
"861868429", "吉林省四平市",
"861814958", "福建省泉州市",
"861301756", "河南省平顶山市",
"86150256", "重庆市",
"861537994", "甘肃省临夏回族自治州",
"861504561", "黑龙江省黑河市",
"861566694", "山东省泰安市",
"861520793", "江西省上饶市",
"861771142", "四川省泸州市",
"861840202", "广东省广州市",
"861821909", "广东省阳江市",
"861333082", "四川省达州市",
"86155504", "山东省济南市",
"861339346", "山西省晋城市",
"861478951", "湖南省岳阳市",
"861510819", "四川省泸州市",
"861862395", "河南省漯河市",
"861829542", "宁夏石嘴山市",
"861878412", "四川省宜宾市",
"861776923", "湖南省怀化市",
"861364994", "新疆和田地区",
"861475722", "浙江省金华市",
"861313412", "辽宁省鞍山市",
"861303675", "湖南省张家界市",
"861576703", "广东省茂名市",
"861334954", "黑龙江省佳木斯市",
"861800972", "青海省海东地区",
"861809686", "新疆和田地区",
"861874846", "内蒙古呼伦贝尔市",
"861308846", "内蒙古巴彦淖尔市",
"861835593", "安徽省亳州市",
"861813855", "广东省潮州市",
"861779218", "陕西省汉中市",
"861365964", "广西梧州市",
"861533577", "湖北省随州市",
"861341579", "广东省肇庆市",
"861587583", "广东省肇庆市",
"861580565", "安徽省合肥市",
"861532814", "四川省攀枝花市",
"861309242", "江苏省常州市",
"861368710", "湖北省襄樊市",
"861329589", "浙江省金华市",
"861378855", "广西玉林市",
"861818380", "云南省临沧市",
"861538551", "安徽省合肥市",
"861850448", "吉林省延边朝鲜族自治州",
"861594701", "内蒙古呼和浩特市",
"86181721", "广西柳州市",
"861315443", "四川省广元市",
"861850594", "福建省莆田市",
"861505591", "安徽省淮南市",
"861895146", "江苏省徐州市",
"86158447", "吉林省辽源市",
"861881535", "山东省烟台市",
"861371745", "广东省佛山市",
"861568591", "贵州省毕节地区",
"861707313", "河北省保定市",
"861360347", "河南省漯河市",
"861700616", "江苏省苏州市",
"861532405", "河北省唐山市",
"861571753", "湖南省株洲市",
"861333159", "吉林省白山市",
"861766645", "广东省佛山市",
"86158766", "广东省珠海市",
"861894947", "安徽省滁州市",
"861831919", "广东省东莞市",
"861478844", "河南省洛阳市",
"86181872", "云南省大理白族自治州",
"861537248", "浙江省衢州市",
"861597276", "湖北省随州市",
"861827699", "广西河池市",
"861528050", "福建省南平市",
"86137372", "广西柳州市",
"861334841", "福建省宁德市",
"861597679", "广东省汕尾市",
"86156350", "山西省忻州市",
"861373935", "甘肃省金昌市",
"861821881", "广东省深圳市",
"861470410", "辽宁省铁岭市",
"86188662", "山东省青岛市",
"861359193", "辽宁省辽阳市",
"861350436", "吉林省白城市",
"861870632", "山东省枣庄市",
"861567841", "广西玉林市",
"86185716", "湖北省武汉市",
"86318", "河北省衡水市",
"861875248", "江苏省泰州市",
"861760734", "湖南省衡阳市",
"86189898", "浙江省杭州市",
"861822757", "四川省雅安市",
"861367220", "江西省南昌市",
"861395138", "江苏省南通市",
"861889524", "宁夏固原市",
"861364248", "广东省河源市",
"861818935", "甘肃省武威市",
"861538566", "安徽省池州市",
"861520374", "河南省许昌市",
"861330733", "湖南省株洲市",
"86138565", "安徽省合肥市",
"861308387", "河南省安阳市",
"86152318", "河北省邯郸市",
"861539782", "江西省九江市",
"861365387", "河南省洛阳市",
"861301761", "河南省漯河市",
"861500324", "河北省承德市",
"861301409", "安徽省阜阳市",
"861523879", "河南省周口市",
"861396566", "安徽省宣城市",
"861815305", "河南省驻马店市",
"861890394", "河南省周口市",
"861880866", "湖北省随州市",
"861528245", "四川省乐山市",
"861859317", "云南省曲靖市",
"861320472", "内蒙古包头市",
"861519432", "山东省枣庄市",
"861514829", "内蒙古兴安盟",
"861339887", "云南省迪庆藏族自治州",
"861317465", "福建省莆田市",
"861300422", "浙江省嘉兴市",
"861310483", "广东省汕头市",
"86183468", "黑龙江省佳木斯市",
"861568233", "四川省泸州市",
"861318169", "山东省潍坊市",
"861323458", "黑龙江省伊春市",
"861771360", "四川省成都市",
"861452557", "山东省青岛市",
"861355734", "广西梧州市",
"861859705", "青海省果洛藏族自治州",
"861368979", "吉林省吉林市",
"861302341", "江苏省南京市",
"861325929", "陕西省汉中市",
"861869084", "新疆克孜勒苏柯尔克孜自治州",
"861840463", "黑龙江省七台河市",
"86130434", "广东省深圳市",
"861865838", "浙江省温州市",
"861811686", "新疆伊犁哈萨克自治州",
"861593443", "山西省晋中市",
"861811365", "四川省眉山市",
"861359896", "河南省许昌市",
"86150206", "山东省聊城市",
"86139259", "广东省佛山市",
"861534694", "甘肃省庆阳市",
"861504061", "辽宁省大连市",
"861783952", "河南省漯河市",
"861459308", "四川省绵阳市",
"861822680", "安徽省滁州市",
"861368469", "黑龙江省双鸭山市",
"861368701", "江西省鹰潭市",
"861811289", "江苏省常州市",
"861478476", "内蒙古赤峰市",
"861525447", "山东省淄博市",
"861840973", "青海省海东地区",
"861594710", "内蒙古呼伦贝尔市",
"861338825", "四川省眉山市",
"861337654", "广东省揭阳市",
"861588344", "四川省德阳市",
"861775274", "湖南省郴州市",
"861319756", "广西百色市",
"861334523", "山东省淄博市",
"861333582", "浙江省湖州市",
"861329375", "山西省长治市",
"86155554", "安徽省合肥市",
"861320962", "宁夏石嘴山市",
"861319118", "山西省吕梁市",
"861309325", "湖北省恩施土家族苗族自治州",
"861571818", "广东省佛山市",
"861780978", "青海省西宁市",
"861812745", "广东省清远市",
"861510335", "河北省秦皇岛市",
"861317975", "江苏省扬州市",
"861336994", "新疆昌吉回族自治州",
"861350857", "贵州省毕节地区",
"861808053", "四川省成都市",
"861368530", "山东省菏泽市",
"861831880", "广东省河源市",
"861575602", "安徽省铜陵市",
"861582956", "陕西省商洛市",
"86134783", "辽宁省沈阳市",
"861305530", "福建省莆田市",
"861557685", "湖南省张家界市",
"861351310", "河北省邯郸市",
"861329089", "福建省福州市",
"861477094", "江西省宜春市",
"861550663", "山东省烟台市",
"861778930", "甘肃省临夏回族自治州",
"861598994", "广东省东莞市",
"861515940", "福建省宁德市",
"861806895", "江苏省南通市",
"861760356", "山西省晋城市",
"861595412", "山东省济南市",
"861505091", "江苏省连云港市",
"861504271", "辽宁省营口市",
"861386583", "安徽省滁州市",
"861310797", "福建省莆田市",
"861565155", "江苏省盐城市",
"861890883", "云南省临沧市",
"861313499", "内蒙古锡林郭勒盟",
"861878499", "四川省自贡市",
"861304499", "江西省萍乡市",
"861899737", "青海省海西蒙古族藏族自治州",
"861583331", "河北省石家庄市",
"861320503", "福建省福州市",
"861450195", "山西省朔州市",
"861887185", "湖北省武汉市",
"861327828", "吉林省白城市",
"861576624", "广东省湛江市",
"861351753", "广西桂林市",
"86132787", "云南省曲靖市",
"861336759", "广西北海市",
"86130782", "广东省湛江市",
"861454316", "黑龙江省鹤岗市",
"8618450", "福建省福州市",
"861879095", "河南省濮阳市",
"861351662", "广东省佛山市",
"861871466", "黑龙江省鹤岗市",
"86155372", "河南省安阳市",
"861321719", "湖北省十堰市",
"861839830", "四川省达州市",
"861479665", "江西省吉安市",
"861366799", "江西省萍乡市",
"861309967", "云南省保山市",
"861389808", "辽宁省朝阳市",
"861529949", "新疆乌鲁木齐市",
"861800047", "河北省沧州市",
"861570436", "吉林省白城市",
"861335410", "辽宁省铁岭市",
"861332957", "黑龙江省鸡西市",
"861859683", "福建省福州市",
"861328485", "内蒙古鄂尔多斯市",
"861500579", "浙江省金华市",
"861365613", "江苏省镇江市",
"861362997", "新疆克拉玛依市",
"861510243", "辽宁省丹东市",
"861788126", "新疆塔城地区",
"861520529", "江苏省镇江市",
"861308613", "江西省上饶市",
"861315080", "内蒙古乌兰察布市",
"861889085", "新疆博尔塔拉蒙古自治州",
"861889379", "甘肃省兰州市",
"86152678", "浙江省宁波市",
"861590471", "内蒙古呼和浩特市",
"861390696", "福建省漳州市",
"861534817", "四川省成都市",
"861776932", "湖南省长沙市",
"861475733", "浙江省宁波市",
"861820933", "甘肃省平凉市",
"86139367", "黑龙江省大庆市",
"861348296", "河北省邢台市",
"861820491", "内蒙古鄂尔多斯市",
"861810150", "江苏省常州市",
"86189936", "甘肃省张掖市",
"861801470", "江苏省南京市",
"861366532", "山东省青岛市",
"861835729", "浙江省湖州市",
"861534509", "福建省龙岩市",
"861566009", "河南省周口市",
"861860945", "甘肃省金昌市",
"861896611", "浙江省台州市",
"86133419", "上海市",
"861868900", "西藏拉萨市",
"861331456", "黑龙江省黑河市",
"861521963", "广东省揭阳市",
"861598759", "云南省迪庆藏族自治州",
"861337321", "河北省石家庄市",
"861347464", "陕西省西安市",
"861361496", "辽宁省锦州市",
"861561671", "湖南省衡阳市",
"861362151", "江苏省无锡市",
"861317738", "湖北省鄂州市",
"861780735", "湖南省郴州市",
"861845270", "江苏省南通市",
"861554838", "内蒙古赤峰市",
"861700843", "四川省成都市",
"861869525", "宁夏银川市",
"861302095", "浙江省台州市",
"861317018", "安徽省六安市",
"861870704", "江西省抚州市",
"861500930", "甘肃省临夏回族自治州",
"861312451", "黑龙江省哈尔滨市",
"86182883", "云南省临沧市",
"861894572", "黑龙江省黑河市",
"861358146", "湖北省孝感市",
"861319920", "黑龙江省双鸭山市",
"861500651", "山东省济南市",
"861521473", "浙江省金华市",
"861303803", "山西省晋中市",
"861324348", "河南省驻马店市",
"861476288", "江苏省南京市",
"861557703", "广西来宾市",
"86185927", "陕西省西安市",
"861310540", "山东省菏泽市",
"861760602", "福建省泉州市",
"861891931", "甘肃省兰州市",
"861358521", "江苏省南通市",
"86792", "江西省九江市",
"861593907", "河南省商丘市",
"86151749", "内蒙古包头市",
"861830762", "广东省河源市",
"861590961", "宁夏银川市",
"8618019", "上海市",
"86170894", "广东省珠海市",
"861860693", "福建省福州市",
"861860450", "黑龙江省哈尔滨市",
"861514188", "辽宁省铁岭市",
"861323684", "辽宁省鞍山市",
"861705773", "河北省石家庄市",
"861831421", "云南省普洱市",
"861862541", "河南省洛阳市",
"861503188", "河北省唐山市",
"861771612", "四川省成都市",
"861770155", "江苏省苏州市",
"86188573", "浙江省嘉兴市",
"861399780", "湖北省十堰市",
"86137554", "江西省吉安市",
"861801960", "江苏省盐城市",
"861327552", "安徽省蚌埠市",
"86186454", "黑龙江省佳木斯市",
"861525903", "福建省龙岩市",
"861570857", "贵州省毕节地区",
"861309477", "浙江省台州市",
"861561559", "山东省临沂市",
"861329427", "湖北省黄冈市",
"861571310", "河北省邯郸市",
"86147277", "陕西省西安市",
"861322637", "广东省阳江市",
"861338774", "广西贺州市",
"861709941", "浙江省舟山市",
"861524739", "内蒙古鄂尔多斯市",
"861700146", "江苏省南通市",
"861524019", "安徽省合肥市",
"86135952", "贵州省遵义市",
"861858271", "四川省广安市",
"861560300", "广东省广州市",
"86145969", "新疆乌鲁木齐市",
"861373778", "广西钦州市",
"861871976", "甘肃省张掖市",
"861453982", "广东省深圳市",
"861459800", "湖北省襄樊市",
"86135094", "重庆市",
"861580418", "辽宁省阜新市",
"861525562", "安徽省合肥市",
"86455", "黑龙江省绥化市",
"86159815", "吉林省四平市",
"86180786", "广西百色市",
"861338393", "河南省濮阳市",
"861316349", "黑龙江省佳木斯市",
"861334799", "江苏省盐城市",
"861570670", "浙江省嘉兴市",
"861898014", "四川省绵阳市",
"86187616", "江苏省南京市",
"861875759", "浙江省杭州市",
"861573806", "河南省南阳市",
"861315580", "江西省南昌市",
"86150682", "浙江省温州市",
"861868911", "西藏拉萨市",
"861829977", "新疆巴音郭楞蒙古自治州",
"861887237", "湖北省荆门市",
"86189689", "浙江省温州市",
"86157712", "内蒙古包头市",
"86138059", "福建省泉州市",
"861800547", "山东省济宁市",
"861841987", "甘肃省定西市",
"861550914", "陕西省商洛市",
"86151567", "安徽省阜阳市",
"861762527", "江苏省宿迁市",
"861321792", "江西省九江市",
"861533942", "甘肃省酒泉市",
"861536488", "山西省晋中市",
"861334532", "新疆巴音郭楞蒙古自治州",
"86186991", "新疆乌鲁木齐市",
"861593080", "河北省邯郸市",
"861882883", "四川省攀枝花市",
"861331971", "新疆博尔塔拉蒙古自治州",
"861774609", "福建省福州市",
"861321460", "黑龙江省哈尔滨市",
"861521897", "广东省汕头市",
"861312466", "贵州省黔南布依族苗族自治州",
"861346362", "河北省廊坊市",
"861557290", "湖北省武汉市",
"86139932", "甘肃省定西市",
"861453890", "云南省大理白族自治州",
"861819470", "青海省黄南藏族自治州",
"86132778", "广西南宁市",
"861770372", "河南省安阳市",
"861302595", "广西桂林市",
"861317518", "浙江省宁波市",
"86132111", "广东省佛山市",
"861838117", "四川省眉山市",
"861801239", "江苏省无锡市",
"86182395", "河南省漯河市",
"861590956", "宁夏中卫市",
"861376729", "江西省新余市",
"86145360", "江苏省南京市",
"861768394", "湖北省十堰市",
"861369565", "安徽省合肥市",
"861806323", "山东省济宁市",
"861531512", "山东省济南市",
"861819960", "新疆阿勒泰地区",
"861524092", "云南省临沧市",
"861571301", "河北省石家庄市",
"861310040", "广西南宁市",
"861515283", "江苏省淮安市",
"861560564", "安徽省六安市",
"861319648", "江苏省扬州市",
"861818888", "广东省广州市",
"861394345", "吉林省白城市",
"861858561", "贵州省铜仁地区",
"86183363", "河南省郑州市",
"861318337", "河南省信阳市",
"861330722", "湖北省仙桃市",
"86137504", "广东省汕头市",
"86188551", "安徽省合肥市",
"861560311", "河北省石家庄市",
"861598406", "四川省广元市",
"861839644", "福建省宁德市",
"861331709", "江西省萍乡市",
"861321970", "四川省乐山市",
"861861534", "山东省德州市",
"861338884", "云南省昆明市",
"861331461", "黑龙江省哈尔滨市",
"861858314", "四川省宜宾市",
"861300991", "黑龙江省绥化市",
"861509482", "山东省日照市",
"861383898", "河南省南阳市",
"861572449", "辽宁省阜新市",
"861817746", "广西贺州市",
"861301920", "吉林省长春市",
"861530827", "四川省德阳市",
"861768883", "广东省深圳市",
"861705883", "广东省中山市",
"86145881", "广东省东莞市",
"861871451", "黑龙江省哈尔滨市",
"861310255", "河北省邢台市",
"861554553", "黑龙江省绥化市",
"861589776", "湖北省黄石市",
"861561059", "山东省潍坊市",
"861865985", "福建省三明市",
"861781689", "浙江省杭州市",
"861374985", "河南省许昌市",
"861885139", "江苏省宿迁市",
"861569826", "山东省潍坊市",
"86185956", "河南省郑州市",
"861555639", "安徽省阜阳市",
"861576685", "广东省湛江市",
"861843854", "河南省安阳市",
"861535326", "陕西省安康市",
"86135902", "广东省深圳市",
"861454554", "新疆博尔塔拉蒙古自治州",
"861300157", "山东省临沂市",
"861324702", "江西省九江市",
"861311477", "广西钦州市",
"861894262", "河北省石家庄市",
"861840359", "山西省运城市",
"861882186", "湖南省岳阳市",
"861553380", "河北省衡水市",
"861775690", "安徽省滁州市",
"861551630", "河南省三门峡市",
"861367304", "河南省安阳市",
"861352982", "云南省红河哈尼族彝族自治州",
"861551951", "贵州省六盘水市",
"86188667", "山东省潍坊市",
"861335531", "山东省济南市",
"861567402", "湖南省常德市",
"861590880", "云南省昆明市",
"861877090", "江西省新余市",
"861380786", "广西百色市",
"8615801", "北京市",
"861472778", "陕西省商洛市",
"861566439", "河南省三门峡市",
"8614776", "广东省广州市",
"861334402", "重庆市",
"861534270", "湖北省十堰市",
"861535090", "辽宁省锦州市",
"861815943", "福建省莆田市",
"861597226", "湖北省襄樊市",
"86181877", "云南省玉溪市",
"861807699", "西藏拉萨市",
"861780834", "四川省凉山彝族自治州",
"861370796", "江西省吉安市",
"861811104", "四川省自贡市",
"861597629", "广东省韶关市",
"861587741", "陕西省延安市",
"861508050", "福建省南平市",
"861534304", "湖南省衡阳市",
"861850660", "广东省汕尾市",
"861565050", "山东省烟台市",
"86155617", "黑龙江省鸡西市",
"861303458", "山东省威海市",
"861518147", "四川省南充市",
"861551197", "河北省邢台市",
"861860766", "广东省云浮市",
"861316044", "江苏省盐城市",
"861778529", "贵州省铜仁地区",
"861534060", "山西省朔州市",
"861327596", "福建省漳州市",
"861566560", "安徽省合肥市",
"861570006", "浙江省杭州市",
"861840316", "河北省廊坊市",
"861335700", "浙江省衢州市",
"861856747", "河南省新乡市",
"861314458", "黑龙江省伊春市",
"86183138", "云南省昆明市",
"861500374", "河南省许昌市",
"861804912", "陕西省榆林市",
"861307934", "甘肃省定西市",
"86150318", "河北省衡水市",
"861378912", "湖南省郴州市",
"861836048", "江苏省苏州市",
"861891201", "江苏省徐州市",
"86135181", "四川省成都市",
"861379757", "湖北省襄樊市",
"861885018", "福建省厦门市",
"861520324", "河北省承德市",
"861321761", "广东省河源市",
"861375494", "山西省大同市",
"861508245", "四川省宜宾市",
"861893440", "贵州省遵义市",
"861500200", "广东省广州市",
"861512181", "宁夏银川市",
"861768512", "贵州省遵义市",
"861346391", "河北省邢台市",
"861787618", "广东省梅州市",
"861813912", "新疆阿克苏地区",
"861320422", "辽宁省鞍山市",
"861834454", "广东省阳江市",
"861705512", "浙江省温州市",
"861517544", "河北省邯郸市",
"86130164", "湖北省武汉市",
"861334573", "浙江省嘉兴市",
"861519614", "四川省广元市",
"861562481", "内蒙古呼和浩特市",
"861814386", "西藏那曲地区",
"861814665", "江西省宜春市",
"861361452", "黑龙江省齐齐哈尔市",
"861567198", "湖北省鄂州市",
"861537716", "湖北省咸宁市",
"861338875", "云南省保山市",
"861899368", "甘肃省甘南藏族自治州",
"861580708", "江西省景德镇市",
"861331760", "广西防城港市",
"861803194", "河北省石家庄市",
"861317925", "吉林省吉林市",
"861357901", "新疆巴音郭楞蒙古自治州",
"861780928", "陕西省西安市",
"861809042", "四川省甘孜藏族自治州",
"86151651", "山东省济南市",
"861805230", "江苏省连云港市",
"861537158", "江苏省泰州市",
"861875158", "江苏省无锡市",
"861777636", "广西玉林市",
"86152206", "广东省惠州市",
"861770333", "河北省秦皇岛市",
"861364158", "江苏省泰州市",
"861524061", "广西玉林市",
"861390652", "浙江省杭州市",
"861336536", "山东省潍坊市",
"861858592", "贵州省黔西南布依族苗族自治州",
"861840923", "陕西省渭南市",
"861364036", "广东省揭阳市",
"861811542", "江苏省常州市",
"861841430", "内蒙古呼伦贝尔市",
"861478426", "河南省周口市",
"861325701", "江西省鹰潭市",
"861893955", "河南省漯河市",
"861364716", "湖北省荆州市",
"861819909", "新疆阿克苏地区",
"861313840", "广东省汕头市",
"861524271", "辽宁省抚顺市",
"861528155", "四川省甘孜藏族自治州",
"861370088", "河南省郑州市",
"861525091", "江苏省徐州市",
"861354610", "山西省忻州市",
"861590919", "陕西省铜川市",
"861576674", "广东省湛江市",
"861894291", "湖北省武汉市",
"861324499", "广东省东莞市",
"861335168", "黑龙江省哈尔滨市",
"861379680", "黑龙江省哈尔滨市",
"86189229", "广东省东莞市",
"861870805", "西藏昌都地区",
"861374974", "河南省信阳市",
"861340002", "江苏省无锡市",
"861865974", "福建省泉州市",
"861894858", "广东省惠州市",
"861325530", "山东省菏泽市",
"861826895", "浙江省衢州市",
"861380098", "青海省西宁市",
"861870414", "辽宁省本溪市",
"861871750", "陕西省延安市",
"86138980", "辽宁省鞍山市",
"861554107", "辽宁省朝阳市",
"861308424", "河南省开封市",
"861328474", "内蒙古兴安盟",
"861500487", "内蒙古赤峰市",
"861365424", "辽宁省大连市",
"861771252", "江苏省盐城市",
"861534439", "吉林省通化市",
"8614749", "广东省广州市",
"861339727", "湖北省孝感市",
"861862605", "江苏省无锡市",
"861876531", "山东省济南市",
"86135717", "陕西省宝鸡市",
"861589445", "云南省西双版纳傣族自治州",
"861528372", "四川省阿坝藏族羌族自治州",
"861813999", "甘肃省兰州市",
"861873641", "河南省漯河市",
"861891210", "江苏省镇江市",
"861366402", "内蒙古包头市",
"861328143", "四川省南充市",
"861450590", "辽宁省铁岭市",
"861318641", "江苏省南京市",
"861887580", "浙江省温州市",
"861367439", "吉林省白山市",
"861819881", "广东省潮州市",
"861315237", "陕西省渭南市",
"861779746", "青海省海西蒙古族藏族自治州",
"861332162", "广西柳州市",
"861898835", "云南省红河哈尼族彝族自治州",
"861309152", "黑龙江省黑河市",
"861894533", "黑龙江省牡丹江市",
"861818179", "四川省广安市",
"861360726", "湖北省荆门市",
"861321334", "河南省周口市",
"861373179", "河北省秦皇岛市",
"861556779", "吉林省松原市",
"861316498", "浙江省宁波市",
"861316544", "山东省淄博市",
"861534560", "安徽省合肥市",
"861778029", "四川省成都市",
"861327096", "江苏省苏州市",
"86137388", "浙江省宁波市",
"86134886", "北京市",
"861558336", "四川省达州市",
"861857842", "广东省佛山市",
"861524138", "辽宁省营口市",
"861367560", "安徽省合肥市",
"861705012", "天津市",
"861866454", "广东省广州市",
"861561516", "山东省东营市",
"861820790", "江西省新余市",
"86134235", "广东省茂名市",
"861878634", "贵州省遵义市",
"861304634", "广东省中山市",
"861836548", "江西省宜春市",
"861538629", "湖南省永州市",
"861380876", "云南省大理白族自治州",
"861867020", "湖南省湘潭市",
"861590770", "广西防城港市",
"861814847", "四川省泸州市",
"861820462", "黑龙江省齐齐哈尔市",
"86151673", "浙江省嘉兴市",
"861776973", "浙江省绍兴市",
"861308253", "江苏省连云港市",
"861831720", "河南省南阳市",
"86135260", "河南省信阳市",
"86151601", "福建省宁德市",
"86177335", "河北省秦皇岛市",
"861399481", "山西省吕梁市",
"861830791", "江西省南昌市",
"861590992", "新疆伊犁哈萨克自治州",
"861334073", "四川省广元市",
"861366573", "浙江省湖州市",
"861860751", "广东省韶关市",
"861323675", "辽宁省铁岭市",
"861810983", "辽宁省朝阳市",
"861777470", "广西桂林市",
"86185813", "重庆市",
"861328846", "广东省广州市",
"861816154", "宁夏固原市",
"861355988", "福建省三明市",
"861303625", "江西省上饶市",
"861820972", "青海省海东地区",
"861829686", "江西省赣州市",
"861381235", "江苏省镇江市",
"861811042", "安徽省淮北市",
"861364536", "山东省潍坊市",
"861458753", "广东省梅州市",
"861890723", "湖北省黄石市",
"861454359", "山东省聊城市",
"861567073", "河南省洛阳市",
"861453608", "江苏省无锡市",
"861840554", "安徽省淮南市",
"861336716", "湖北省荆州市",
"86158863", "湖南省株洲市",
"861321756", "广东省珠海市",
"861556901", "新疆和田地区",
"86152256", "河南省南阳市",
"861458662", "湖南省邵阳市",
"861347985", "江西省萍乡市",
"861340963", "湖北省随州市",
"861336158", "山东省淄博市",
"861882599", "广东省江门市",
"861524561", "黑龙江省哈尔滨市",
"861500793", "江西省上饶市",
"861331419", "辽宁省辽阳市",
"861317139", "内蒙古兴安盟",
"861598036", "福建省莆田市",
"861370588", "浙江省温州市",
"861311089", "福建省福州市",
"861589631", "江苏省宿迁市",
"861563864", "河南省三门峡市",
"861589950", "广东省惠州市",
"86158442", "吉林省吉林市",
"861560369", "黑龙江省大庆市",
"861357910", "新疆阿克苏地区",
"861835128", "江苏省盐城市",
"861850936", "甘肃省张掖市",
"861572398", "广西桂林市",
"861533527", "江苏省苏州市",
"861873435", "山西省忻州市",
"861858519", "贵州省贵阳市",
"861380444", "吉林省吉林市",
"86139848", "贵州省贵阳市",
"861325710", "湖北省襄樊市",
"861882012", "广东省广州市",
"861318435", "浙江省台州市",
"861526878", "浙江省丽水市",
"861377674", "江苏省淮安市",
"861882732", "湖北省咸宁市",
"861580342", "山西省大同市",
"861309589", "浙江省金华市",
"861315124", "江苏省徐州市",
"861325030", "广东省广州市",
"861310147", "福建省宁德市",
"861760709", "江西省南昌市",
"861760461", "黑龙江省哈尔滨市",
"86159544", "山东省潍坊市",
"861556633", "辽宁省营口市",
"861551326", "山西省太原市",
"861453498", "内蒙古赤峰市",
"861819878", "广东省阳江市",
"861847579", "广东省湛江市",
"861869077", "贵州省安顺市",
"861322597", "福建省南平市",
"861453544", "江苏省无锡市",
"861531236", "江苏省镇江市",
"861365374", "河南省许昌市",
"861771719", "河北省衡水市",
"861570912", "陕西省榆林市",
"861308374", "河南省许昌市",
"861554279", "辽宁省盘锦市",
"861339874", "云南省曲靖市",
"861830669", "广东省深圳市",
"86131121", "广东省揭阳市",
"861528422", "河北省保定市",
"861346547", "山东省济宁市",
"861354491", "广东省珠海市",
"861308200", "河北省邢台市",
"861388160", "四川省雅安市",
"861399968", "新疆哈密地区",
"861561563", "山东省淄博市",
"86186305", "河北省唐山市",
"861769873", "河南省信阳市",
"861459119", "广西桂林市",
"861370659", "浙江省嘉兴市",
"861343190", "广东省珠海市",
"861458531", "河南省濮阳市",
"861820545", "山东省烟台市",
"861314986", "辽宁省大连市",
"861355709", "广西北海市",
"861472871", "贵州省铜仁地区",
"861355461", "湖北省荆州市",
"86183309", "河北省邢台市",
"861809975", "新疆和田地区",
"861812195", "四川省成都市",
"861807118", "湖北省孝感市",
"861800362", "黑龙江省齐齐哈尔市",
"861370256", "广东省佛山市",
"861309658", "山西省大同市",
"86182973", "安徽省亳州市",
"86138224", "广东省江门市",
"86138841", "甘肃省庆阳市",
"861558948", "山东省聊城市",
"861511998", "广东省汕头市",
"861470301", "河北省邯郸市",
"86182901", "广西桂林市",
"861589903", "新疆巴音郭楞蒙古自治州",
"861844966", "新疆博尔塔拉蒙古自治州",
"861832940", "陕西省西安市",
"861860533", "山东省淄博市",
"861587848", "广西百色市",
"861340323", "河北省张家口市",
"861327909", "新疆阿克苏地区",
"861336763", "广西桂林市",
"861351401", "福建省泉州市",
"861777552", "四川省成都市",
"861351769", "广西玉林市",
"861366692", "福建省莆田市",
"861390536", "山东省潍坊市",
"861367952", "广东省清远市",
"861868329", "四川省成都市",
"861348539", "山西省忻州市",
"861822941", "湖南省岳阳市",
"861398919", "四川省南充市",
"861345127", "湖北省十堰市",
"861399478", "山西省临汾市",
"861513414", "辽宁省本溪市",
"861339446", "吉林省白城市",
"861801096", "安徽省阜阳市",
"861884873", "云南省文山壮族苗族自治州",
"861534952", "宁夏石嘴山市",
"861894751", "内蒙古通辽市",
"861304312", "河北省保定市",
"86189275", "广东省广州市",
"861807334", "湖南省株洲市",
"86133198", "新疆乌鲁木齐市",
"861832455", "黑龙江省伊春市",
"861533084", "辽宁省鞍山市",
"861772190", "四川省绵阳市",
"861313312", "山西省大同市",
"861476519", "河北省石家庄市",
"861846991", "云南省文山壮族苗族自治州",
"861809465", "浙江省绍兴市",
"861846433", "山东省淄博市",
"861564992", "河南省商丘市",
"861332812", "江苏省扬州市",
"86147613", "江苏省连云港市",
"861530875", "云南省保山市",
"861503908", "河南省郑州市",
"861334619", "浙江省杭州市",
"861810557", "安徽省宿州市",
"861383490", "山西省晋城市",
"861334216", "辽宁省丹东市",
"861477348", "湖南省湘西土家族苗族自治州",
"861348792", "湖南省常德市",
"861565962", "福建省三明市",
"861526881", "浙江省杭州市",
"861514908", "内蒙古赤峰市",
"86158162", "广东省清远市",
"861508962", "广东省茂名市",
"86150323", "河北省秦皇岛市",
"86134811", "广西南宁市",
"861361260", "广东省佛山市",
"861315343", "山东省枣庄市",
"861876662", "山东省东营市",
"861760971", "青海省西宁市",
"861598763", "云南省大理白族自治州",
"861521959", "广东省湛江市",
"861325808", "山东省潍坊市",
"86158437", "吉林省辽源市",
"861775411", "安徽省芜湖市",
"861585949", "福建省泉州市",
"861835622", "安徽省芜湖市",
"861373480", "内蒙古包头市",
"861532305", "广东省梅州市",
"861360447", "吉林省吉林市",
"861306359", "江苏省南通市",
"861370571", "浙江省杭州市",
"86151423", "辽宁省大连市",
"861478747", "云南省昆明市",
"861879441", "甘肃省白银市",
"861322097", "山东省德州市",
"86130921", "江苏省盐城市",
"861586535", "山东省烟台市",
"86184183", "甘肃省兰州市",
"861813506", "山西省忻州市",
"861768906", "西藏那曲地区",
"861569049", "河北省邢台市",
"861337880", "云南省昆明市",
"861821828", "广东省东莞市",
"86145903", "广东省深圳市",
"861470310", "河北省邯郸市",
"861346047", "河南省新乡市",
"861564880", "内蒙古赤峰市",
"861471857", "广东省肇庆市",
"861350336", "河北省保定市",
"861472781", "陕西省榆林市",
"861330629", "江苏省南通市",
"861817242", "广西南宁市",
"86147478", "内蒙古巴彦淖尔市",
"86135510", "四川省成都市",
"861760837", "四川省阿坝藏族羌族自治州",
"861555599", "安徽省阜阳市",
"861771539", "江苏省苏州市",
"861874487", "贵州省铜仁地区",
"861520474", "内蒙古乌兰察布市",
"861888120", "四川省攀枝花市",
"861308487", "陕西省汉中市",
"861580989", "辽宁省葫芦岛市",
"861319434", "吉林省四平市",
"86183359", "山西省运城市",
"861301309", "安徽省合肥市",
"861317289", "广东省汕尾市",
"861500424", "辽宁省大连市",
"861781782", "广东省广州市",
"861365487", "内蒙古包头市",
"861589272", "四川省眉山市",
"861320372", "河南省郑州市",
"86186355", "山西省长治市",
"861561063", "山东省潍坊市",
"861855421", "山东省泰安市",
"861890494", "辽宁省本溪市",
"861339784", "广西梧州市",
"861815405", "安徽省阜阳市",
"861329965", "广西玉林市",
"861830576", "浙江省台州市",
"861890548", "山东省泰安市",
"861335818", "江苏省常州市",
"86177778", "北京市",
"861536770", "湖南省益阳市",
"861509998", "广东省广州市",
"861317686", "山东省青岛市",
"861323358", "山西省吕梁市",
"861355837", "广西钦州市",
"86131344", "吉林省长春市",
"861839438", "甘肃省庆阳市",
"861324609", "广东省汕头市",
"861570999", "新疆伊犁哈萨克自治州",
"861510641", "山东省淄博市",
"861302441", "江苏省常州市",
"861831654", "广东省佛山市",
"861708336", "河北省石家庄市",
"861847666", "广东省湛江市",
"861390036", "黑龙江省哈尔滨市",
"861811465", "江苏省徐州市",
"861370261", "广东省佛山市",
"861362859", "贵州省黔西南布依族苗族自治州",
"861368285", "广东省汕头市",
"861348039", "广东省汕尾市",
"86182764", "广西梧州市",
"861459408", "云南省昭通市",
"86156168", "湖南省郴州市",
"861348719", "湖北省孝感市",
"861355456", "湖北省荆州市",
"861771970", "陕西省汉中市",
"861580810", "四川省攀枝花市",
"861807409", "浙江省嘉兴市",
"86136314", "广东省广州市",
"861850702", "江西省九江市",
"861390158", "江苏省南京市",
"861334692", "河南省三门峡市",
"861332899", "福建省泉州市",
"861478376", "河南省信阳市",
"861361570", "浙江省衢州市",
"861821934", "广东省佛山市",
"861708754", "江西省抚州市",
"861341485", "广东省湛江市",
"861865105", "江苏省扬州市",
"861477702", "广西南宁市",
"861520964", "宁夏固原市",
"861476019", "福建省泉州市",
"861800140", "江苏省淮安市",
"861588598", "贵州省黔西南布依族苗族自治州",
"861591526", "广东省茂名市",
"861536992", "河北省衡水市",
"861562478", "内蒙古巴彦淖尔市",
"861801596", "江苏省镇江市",
"861329475", "内蒙古通辽市",
"861775400", "安徽省淮南市",
"861510435", "吉林省通化市",
"861309425", "湖北省武汉市",
"861897010", "江西省赣州市",
"861398992", "西藏日喀则地区",
"86183900", "湖南省岳阳市",
"861892159", "江苏省镇江市",
"861321296", "黑龙江省齐齐哈尔市",
"861881407", "广东省梅州市",
"861351410", "辽宁省铁岭市",
"861350754", "福建省龙岩市",
"861760456", "黑龙江省黑河市",
"861337919", "陕西省铜川市",
"861888265", "四川省广安市",
"861843295", "河北省秦皇岛市",
"861810057", "福建省莆田市",
"861860858", "贵州省六盘水市",
"861564919", "河南省信阳市",
"861313399", "江西省萍乡市",
"861476592", "重庆市",
"861370071", "河南省安阳市",
"861308793", "广西桂林市",
"861583431", "山西省朔州市",
"861335662", "山东省东营市",
"861304399", "河南省郑州市",
"861552518", "山西省长治市",
"861365793", "江西省上饶市",
"861327881", "湖南省永州市",
"861839508", "宁夏银川市",
"861817427", "湖南省常德市",
"861573150", "四川省成都市",
"861598696", "广东省惠州市",
"861341846", "广东省深圳市",
"861476056", "宁夏吴忠市",
"861853483", "山西省晋中市",
"861808626", "湖北省随州市",
"86138870", "云南省昭通市",
"861476138", "江苏省苏州市",
"861823845", "河南省周口市",
"861474596", "黑龙江省双鸭山市",
"861865626", "安徽省蚌埠市",
"861598299", "四川省达州市",
"861863833", "河南省南阳市",
"861348756", "湖南省长沙市",
"861381443", "江苏省徐州市",
"861576926", "陕西省汉中市",
"86132580", "山东省济宁市",
"861319504", "宁夏固原市",
"861362816", "四川省攀枝花市",
"86185034", "山西省晋中市",
"861459161", "广西南宁市",
"861450966", "新疆克孜勒苏柯尔克孜自治州",
"861535966", "福建省漳州市",
"861317831", "福建省漳州市",
"86131660", "上海市",
"86155201", "重庆市",
"861554731", "内蒙古包头市",
"861879740", "湖南省湘潭市",
"86189558", "安徽省阜阳市",
"861869489", "浙江省金华市",
"861389530", "宁夏银川市",
"861776706", "浙江省杭州市",
"861844745", "内蒙古乌兰察布市",
"861824948", "黑龙江省鸡西市",
"861830611", "江苏省常州市",
"861787586", "广东省梅州市",
"861564956", "河南省驻马店市",
"861453349", "辽宁省大连市",
"861369442", "吉林省吉林市",
"86178643", "山东省淄博市",
"86145816", "浙江省台州市",
"861302740", "湖南省常德市",
"861534996", "新疆阿勒泰地区",
"861771409", "江苏省苏州市",
"861588132", "四川省自贡市",
"861806473", "浙江省嘉兴市",
"861569344", "甘肃省兰州市",
"861811984", "安徽省淮北市",
"861586405", "山东省烟台市",
"861536471", "山西省太原市",
"861550843", "四川省泸州市",
"861367996", "新疆博尔塔拉蒙古自治州",
"861332083", "四川省达州市",
"861393133", "河北省张家口市",
"861452240", "浙江省杭州市",
"861554500", "黑龙江省哈尔滨市",
"861389701", "青海省海北藏族自治州",
"86158809", "福建省泉州市",
"861366259", "广东省深圳市",
"861339775", "广西玉林市",
"861772341", "四川省巴中市",
"861500613", "江苏省苏州市",
"861777596", "湖南省永州市",
"861328529", "江苏省宿迁市",
"861312413", "辽宁省抚顺市",
"861318243", "江苏省常州市",
"86156333", "河北省唐山市",
"861365579", "浙江省金华市",
"861760419", "辽宁省辽阳市",
"861813436", "河北省唐山市",
"861308579", "广东省汕头市",
"861337956", "陕西省榆林市",
"861475566", "安徽省池州市",
"861366656", "浙江省丽水市",
"861775701", "浙江省衢州市",
"861888084", "四川省绵阳市",
"861329484", "内蒙古通辽市",
"861327239", "湖南省郴州市",
"861813857", "广东省韶关市",
"86187681", "浙江省杭州市",
"861863058", "河北省衡水市",
"861896653", "陕西省渭南市",
"861346922", "湖南省郴州市",
"861380282", "广东省湛江市",
"861533575", "湖北省孝感市",
"861327636", "山东省潍坊市",
"86189004", "北京市",
"861580567", "安徽省亳州市",
"861589233", "四川省资阳市",
"861530774", "广西梧州市",
"861305300", "安徽省宿州市",
"861820610", "江苏省镇江市",
"861371747", "广东省佛山市",
"861881537", "山东省济宁市",
"861866621", "广东省深圳市",
"861360345", "河南省郑州市",
"861345904", "福建省厦门市",
"861532407", "河北省张家口市",
"861313094", "辽宁省盘锦市",
"86158784", "广西梧州市",
"861304094", "湖北省荆州市",
"861334661", "河南省商丘市",
"86151199", "广东省清远市",
"86155894", "山东省菏泽市",
"861806963", "浙江省绍兴市",
"861571842", "广东省深圳市",
"861319142", "内蒙古呼和浩特市",
"861818871", "广东省佛山市",
"861850499", "内蒙古呼和浩特市",
"861829018", "广西钦州市",
"86133266", "广东省珠海市",
"861365651", "浙江省温州市",
"861476561", "湖北省武汉市",
"861348334", "河北省张家口市",
"86187265", "安徽省阜阳市",
"861365930", "甘肃省临夏回族自治州",
"861831214", "广东省河源市",
"86181987", "广东省惠州市",
"861308651", "四川省广元市",
"861819189", "陕西省西安市",
"861550146", "江苏省苏州市",
"861308930", "吉林省延边朝鲜族自治州",
"861504704", "内蒙古呼伦贝尔市",
"861559941", "贵州省黔南布依族苗族自治州",
"861550521", "江苏省宿迁市",
"861518540", "贵州省安顺市",
"861826254", "江苏省常州市",
"861535476", "吉林省松原市",
"861566167", "内蒙古通辽市",
"861303677", "湖南省永州市",
"861459538", "西藏拉萨市",
"861323627", "江苏省盐城市",
"861395623", "安徽省马鞍山市",
"861351711", "湖北省武汉市",
"86132186", "江苏省常州市",
"861880646", "山东省潍坊市",
"861862397", "河南省信阳市",
"861762584", "江苏省徐州市",
"861893848", "广东省茂名市",
"861874269", "新疆博尔塔拉蒙古自治州",
"861377926", "新疆昌吉回族自治州",
"861815307", "河南省焦作市",
"861308269", "山东省菏泽市",
"861859315", "云南省曲靖市",
"861528247", "四川省泸州市",
"861339885", "云南省昆明市",
"861778143", "四川省凉山彝族自治州",
"861308385", "河南省安阳市",
"86183089", "海南省海口市",
"86470", "内蒙古呼伦贝尔市",
"86151760", "河北省邯郸市",
"861476556", "浙江省杭州市",
"861301504", "内蒙古包头市",
"861454363", "山东省青岛市",
"861859707", "青海省海西蒙古族藏族自治州",
"861458401", "河南省商丘市",
"861389710", "青海省海北藏族自治州",
"861458769", "广东省东莞市",
"861700914", "陕西省西安市",
"861385242", "江苏省宿迁市",
"86189508", "福建省龙岩市",
"861314850", "广东省中山市",
"861340959", "宁夏银川市",
"861303850", "陕西省铜川市",
"861760760", "广东省中山市",
"861380638", "山东省烟台市",
"86152428", "辽宁省鞍山市",
"861351168", "江苏省镇江市",
"861452555", "山东省青岛市",
"861592442", "内蒙古包头市",
"861537696", "山东省烟台市",
"861813670", "江苏省常州市",
"861530393", "河南省濮阳市",
"861782024", "广东省云浮市",
"861512910", "陕西省西安市",
"861567259", "湖北省荆州市",
"861319360", "河南省周口市",
"861766647", "广东省中山市",
"861894945", "安徽省安庆市",
"861567656", "广西来宾市",
"861560353", "山西省阳泉市",
"861804670", "江西省南昌市",
"861561688", "湖南省长沙市",
"861809984", "新疆喀什地区",
"861889429", "甘肃省陇南市",
"861590488", "内蒙古呼和浩特市",
"861875299", "江苏省苏州市",
"861771334", "黑龙江省佳木斯市",
"861822755", "四川省雅安市",
"861355760", "广西南宁市",
"861874079", "陕西省铜川市",
"861818937", "甘肃省酒泉市",
"861590321", "河北省石家庄市",
"861334656", "广东省肇庆市",
"861373937", "甘肃省酒泉市",
"861846472", "山东省济宁市",
"861358914", "山东省济南市",
"861533120", "河南省郑州市",
"861800391", "河南省焦作市",
"861364696", "福建省南平市",
"861332583", "浙江省嘉兴市",
"861554000", "内蒙古兴安盟",
"861329746", "湖南省永州市",
"861334259", "湖南省邵阳市",
"861841924", "甘肃省定西市",
"861396722", "浙江省舟山市",
"86185538", "山东省泰安市",
"861512889", "河北省邯郸市",
"861301142", "河北省沧州市",
"861806897", "江苏省南通市",
"861863558", "山西省太原市",
"861769832", "河南省安阳市",
"861324936", "广东省惠州市",
"861599113", "陕西省渭南市",
"86131165", "浙江省台州市",
"86151217", "贵州省六盘水市",
"861350855", "贵州省黔东南苗族侗族自治州",
"86189992", "新疆乌鲁木齐市",
"861564961", "河南省新乡市",
"86156296", "湖北省黄冈市",
"861503682", "河南省周口市",
"861557687", "湖南省张家界市",
"861894450", "黑龙江省哈尔滨市",
"861894693", "广东省汕尾市",
"861475551", "安徽省合肥市",
"861304594", "福建省莆田市",
"861337961", "贵州省黔南布依族苗族自治州",
"86181978", "新疆和田地区",
"861327470", "内蒙古呼伦贝尔市",
"861527202", "湖北省黄冈市",
"861899735", "青海省西宁市",
"861887187", "湖北省武汉市",
"861450197", "山西省朔州市",
"861304448", "山西省吕梁市",
"861829518", "宁夏银川市",
"861833173", "河北省廊坊市",
"861878448", "四川省内江市",
"861306923", "吉林省延边朝鲜族自治州",
"861316982", "广东省江门市",
"861860572", "浙江省湖州市",
"86183262", "安徽省六安市",
"861306054", "广东省潮州市",
"861310795", "福建省莆田市",
"861351700", "江西省南昌市",
"861526636", "山东省潍坊市",
"861476271", "江苏省徐州市",
"861313594", "湖北省咸宁市",
"861565157", "江苏省无锡市",
"861550021", "吉林省白山市",
"861368564", "安徽省六安市",
"861816949", "湖南省邵阳市",
"861775030", "福建省福州市",
"861858288", "四川省成都市",
"861525445", "山东省淄博市",
"861846503", "宁夏吴忠市",
"861583510", "山西省太原市",
"861811367", "四川省眉山市",
"861818781", "云南省昆明市",
"861850412", "辽宁省鞍山市",
"861329377", "山西省临汾市",
"861370616", "江苏省无锡市",
"861305311", "安徽省蚌埠市",
"861450951", "江苏省连云港市",
"861768236", "浙江省宁波市",
"861309327", "湖北省随州市",
"861317977", "江苏省扬州市",
"861459156", "广西北海市",
"861474788", "内蒙古呼和浩特市",
"861351531", "山东省济南市",
"861820601", "福建省莆田市",
"861807039", "江西省南昌市",
"861450630", "黑龙江省佳木斯市",
"861898921", "四川省宜宾市",
"861510337", "河北省沧州市",
"861812747", "广东省清远市",
"861538722", "湖北省孝感市",
"861338827", "四川省乐山市",
"861786508", "山东省临沂市",
"861533389", "河南省周口市",
"861348409", "浙江省金华市",
"861459718", "山东省枣庄市",
"861530884", "云南省昆明市",
"861768639", "山东省滨州市",
"86180187", "广东省深圳市",
"861390406", "辽宁省锦州市",
"861348761", "湖南省邵阳市",
"861565991", "福建省南平市",
"861808364", "贵州省遵义市",
"86136325", "广东省深圳市",
"861330276", "广东省揭阳市",
"861821878", "广东省梅州市",
"861395632", "安徽省滁州市",
"861839864", "四川省乐山市",
"861330679", "浙江省金华市",
"861870056", "陕西省商洛市",
"861817589", "湖南省长沙市",
"861534815", "四川省宜宾市",
"86133329", "广东省深圳市",
"861856966", "湖南省邵阳市",
"861780737", "湖南省益阳市",
"861334302", "河北省保定市",
"861377750", "浙江省金华市",
"861869527", "宁夏银川市",
"861809139", "陕西省西安市",
"861457056", "新疆伊犁哈萨克自治州",
"861318980", "广东省湛江市",
"861884041", "陕西省延安市",
"861302097", "浙江省台州市",
"86137251", "广东省广州市",
"861568776", "云南省昆明市",
"86132921", "河北省邢台市",
"861534404", "内蒙古鄂尔多斯市",
"861394886", "内蒙古赤峰市",
"861860947", "甘肃省嘉峪关市",
"861319868", "四川省绵阳市",
"861347569", "山东省潍坊市",
"861366748", "湖南省常德市",
"861837492", "湖南省岳阳市",
"861303358", "江苏省泰州市",
"86135858", "上海市",
"861304609", "山东省淄博市",
"861320550", "安徽省滁州市",
"861479667", "江西省萍乡市",
"861302802", "山西省临汾市",
"861840416", "辽宁省锦州市",
"861322441", "吉林省四平市",
"861314358", "广东省佛山市",
"861516042", "福建省泉州市",
"861879097", "河南省濮阳市",
"86180951", "宁夏银川市",
"861362995", "新疆昌吉回族自治州",
"861312674", "内蒙古兴安盟",
"861328487", "内蒙古通辽市",
"861500474", "内蒙古乌兰察布市",
"861520424", "辽宁省朝阳市",
"861899978", "新疆阿勒泰地区",
"861839946", "新疆喀什地区",
"861317542", "浙江省金华市",
"861347430", "陕西省汉中市",
"861889087", "新疆昌吉回族自治州",
"861865000", "福建省厦门市",
"861536720", "湖南省湘西土家族苗族自治州",
"861309965", "云南省普洱市",
"861830526", "江苏省泰州市",
"861893340", "广东省中山市",
"86181101", "北京市",
"861346933", "湖南省怀化市",
"861880813", "四川省乐山市",
"861332955", "黑龙江省佳木斯市",
"861454706", "浙江省台州市",
"861800045", "河北省唐山市",
"861529998", "新疆昌吉回族自治州",
"861396513", "安徽省合肥市",
"861589222", "四川省自贡市",
"861320322", "湖南省湘潭市",
"861500964", "宁夏固原市",
"861361352", "山西省大同市",
"861562428", "山东省德州市",
"861531548", "山东省泰安市",
"861340794", "江西省抚州市",
"86156438", "吉林省松原市",
"861785854", "浙江省绍兴市",
"861384863", "内蒙古包头市",
"861531494", "浙江省嘉兴市",
"861570855", "贵州省黔东南苗族侗族自治州",
"861319612", "吉林省松原市",
"861309475", "浙江省舟山市",
"861834736", "内蒙古通辽市",
"861803486", "新疆阿勒泰地区",
"861331392", "福建省龙岩市",
"861329425", "湖北省襄樊市",
"861812590", "广东省湛江市",
"861322635", "河北省石家庄市",
"861855961", "福建省漳州市",
"861770433", "吉林省延边朝鲜族自治州",
"861771920", "河南省郑州市",
"86180764", "广西玉林市",
"861770991", "新疆乌鲁木齐市",
"861362643", "山东省淄博市",
"861817152", "湖北省襄樊市",
"861330551", "安徽省合肥市",
"861397201", "湖北省宜昌市",
"861361520", "江苏省南通市",
"861332440", "吉林省吉林市",
"861478326", "河南省焦作市",
"861588123", "四川省雅安市",
"861360591", "福建省龙岩市",
"861571700", "江西省南昌市",
"861370021", "陕西省延安市",
"861880758", "广东省肇庆市",
"861376672", "黑龙江省伊春市",
"861471948", "甘肃省酒泉市",
"861324399", "辽宁省葫芦岛市",
"861328793", "山东省菏泽市",
"861870561", "安徽省淮北市",
"861853040", "河南省驻马店市",
"861864883", "广西玉林市",
"861301296", "山东省菏泽市",
"861770157", "江苏省苏州市",
"861318819", "辽宁省朝阳市",
"861575108", "江苏省徐州市",
"861520253", "青海省海东地区",
"861571531", "山东省济南市",
"861519959", "新疆石河子市",
"861870314", "河北省承德市",
"861593905", "河南省商丘市",
"861308324", "安徽省宣城市",
"861534339", "湖南省邵阳市",
"861870556", "安徽省安庆市",
"861521895", "广东省汕头市",
"861365324", "河北省承德市",
"861538733", "湖南省株洲市",
"861576750", "广东省茂名市",
"861328374", "河南省许昌市",
"861811139", "四川省广安市",
"861508422", "辽宁省朝阳市",
"861762525", "江苏省苏州市",
"861328200", "浙江省杭州市",
"861898760", "云南省文山壮族苗族自治州",
"861473018", "河北省衡水市",
"861339824", "四川省乐山市",
"861837419", "湖南省永州市",
"861566404", "河南省郑州市",
"861778613", "湖北省武汉市",
"861838115", "四川省眉山市",
"861569282", "四川省南充市",
"861369567", "安徽省芜湖市",
"86137273", "广东省佛山市",
"861366302", "河南省洛阳市",
"861847529", "广东省阳江市",
"86593", "福建省宁德市",
"861302597", "广西梧州市",
"861367339", "河南省郑州市",
"861374731", "内蒙古乌海市",
"861595609", "安徽省滁州市",
"86137201", "湖北省武汉市",
"861808731", "云南省红河哈尼族彝族自治州",
"861551376", "山西省晋中市",
"861560979", "青海省海西蒙古族藏族自治州",
"861516542", "山东省青岛市",
"861316398", "福建省漳州市",
"861334748", "陕西省榆林市",
"861306932", "河南省开封市",
"861340373", "河南省新乡市",
"861321434", "吉林省四平市",
"861337720", "广西柳州市",
"86135808", "广东省东莞市",
"861509154", "陕西省西安市",
"861836186", "江苏省盐城市",
"861567748", "广西贺州市",
"86181151", "江苏省南京市",
"861769823", "河南省新乡市",
"861800545", "山东省烟台市",
"861841985", "甘肃省陇南市",
"861803744", "河南省商丘市",
"861330566", "安徽省池州市",
"86134245", "广东省中山市",
"861323986", "新疆阿克苏地区",
"861887235", "湖北省武汉市",
"861317042", "湖南省湘潭市",
"861829975", "新疆乌鲁木齐市",
"861893162", "河北省邯郸市",
"861865987", "福建省三明市",
"86177345", "河北省石家庄市",
"861777204", "广西钦州市",
"861532943", "贵州省安顺市",
"861324312", "河南省南阳市",
"861560530", "山东省菏泽市",
"861374987", "河南省许昌市",
"861524414", "山东省泰安市",
"861889900", "新疆阿勒泰地区",
"861310257", "河北省邢台市",
"861390994", "新疆昌吉回族自治州",
"861454459", "江西省萍乡市",
"861339938", "甘肃省天水市",
"861873892", "河南省平顶山市",
"861551747", "河南省商丘市",
"861553871", "河南省郑州市",
"861311475", "广西玉林市",
"861301612", "湖南省郴州市",
"861300155", "山东省潍坊市",
"86180494", "陕西省西安市",
"861327721", "湖北省黄冈市",
"861576687", "广东省惠州市",
"861318892", "山东省枣庄市",
"861351842", "四川省凉山彝族自治州",
"861868379", "四川省成都市",
"861802941", "广东省江门市",
"861760921", "陕西省延安市",
"861700752", "广东省惠州市",
"86152323", "河北省秦皇岛市",
"861331319", "河北省邢台市",
"861890236", "广东省肇庆市",
"861769126", "陕西省汉中市",
"861342106", "广东省潮州市",
"861394347", "吉林省四平市",
"861370146", "江苏省南京市",
"861501959", "广东省汕尾市",
"861319699", "江苏省淮安市",
"861858704", "云南省德宏傣族景颇族自治州",
"861379941", "福建省福州市",
"861890639", "山东省青岛市",
"861471620", "广东省佛山市",
"861700663", "山东省烟台市",
"861587191", "湖北省武汉市",
"861370521", "江苏省徐州市",
"861707366", "河南省南阳市",
"861326359", "黑龙江省大庆市",
"861560701", "江西省鹰潭市",
"86158432", "吉林省吉林市",
"861560469", "黑龙江省双鸭山市",
"861577181", "陕西省延安市",
"861523908", "河南省驻马店市",
"861568183", "四川省广安市",
"861572498", "浙江省杭州市",
"861381580", "江苏省扬州市",
"861572544", "山东省德州市",
"861380344", "山西省忻州市",
"861530825", "四川省德阳市",
"861318335", "河南省平顶山市",
"86158167", "广东省汕头市",
"861528962", "广西柳州市",
"86151328", "河北省衡水市",
"861551664", "河南省濮阳市",
"861595660", "安徽省池州市",
"861808430", "贵州省安顺市",
"86183710", "湖北省襄樊市",
"861454416", "福建省泉州市",
"861856745", "河南省信阳市",
"861502281", "新疆哈密地区",
"861323850", "贵州省安顺市",
"861518145", "四川省绵阳市",
"86150428", "辽宁省朝阳市",
"861479486", "内蒙古赤峰市",
"861508247", "四川省南充市",
"861898461", "贵州省黔东南苗族侗族自治州",
"861898709", "云南省昆明市",
"861505631", "安徽省宣城市",
"861780860", "贵州省毕节地区",
"861335310", "吉林省长春市",
"861373043", "河北省张家口市",
"861872746", "湖北省孝感市",
"861568631", "陕西省渭南市",
"861328666", "广东省深圳市",
"861538990", "新疆阿勒泰地区",
"861576451", "黑龙江省哈尔滨市",
"861850634", "山东省莱芜市",
"86472", "内蒙古包头市",
"861475629", "河北省邢台市",
"861321504", "福建省福州市",
"861369810", "四川省达州市",
"861308029", "内蒙古鄂尔多斯市",
"861590371", "河南省郑州市",
"861874029", "辽宁省葫芦岛市",
"861534714", "湖北省恩施土家族苗族自治州",
"861829984", "新疆巴音郭楞蒙古自治州",
"861801204", "江苏省徐州市",
"861347511", "山东省威海市",
"861820391", "河南省焦作市",
"861841974", "甘肃省天水市",
"861470818", "四川省甘孜藏族自治州",
"861817196", "湖北省武汉市",
"861533170", "云南省德宏傣族景颇族自治州",
"861846422", "山东省青岛市",
"861309746", "云南省曲靖市",
"86189946", "江苏省泰州市",
"861857818", "广东省清远市",
"861768048", "湖南省岳阳市",
"861337388", "浙江省宁波市",
"861782074", "广东省深圳市",
"861459649", "甘肃省白银市",
"861331356", "山西省晋城市",
"861813620", "江苏省泰州市",
"861367714", "湖北省黄石市",
"86159480", "吉林省长春市",
"861350999", "广东省云浮市",
"861361396", "河南省驻马店市",
"861459246", "四川省攀枝花市",
"861550261", "辽宁省沈阳市",
"861312351", "广西南宁市",
"861324594", "内蒙古赤峰市",
"861861509", "山东省潍坊市",
"861575456", "黑龙江省黑河市",
"861324448", "吉林省松原市",
"861331734", "湖南省衡阳市",
"861327420", "辽宁省铁岭市",
"861870807", "西藏那曲地区",
"861360062", "浙江省宁波市",
"861528157", "四川省甘孜藏族自治州",
"861318861", "辽宁省辽阳市",
"861510768", "广东省潮州市",
"86183267", "安徽省阜阳市",
"861506636", "山东省潍坊市",
"861860522", "江苏省扬州市",
"861340332", "河北省保定市",
"86153391", "陕西省西安市",
"861306973", "黑龙江省齐齐哈尔市",
"861826897", "浙江省衢州市",
"86151739", "湖南省邵阳市",
"86151212", "贵州省遵义市",
"861889969", "新疆巴音郭楞蒙古自治州",
"86993", "新疆石河子市",
"861321142", "广西来宾市",
"861860350", "山西省忻州市",
"861554105", "辽宁省朝阳市",
"86152999", "新疆石河子市",
"861830390", "河南省焦作市",
"861313936", "甘肃省张掖市",
"861831488", "浙江省杭州市",
"861831321", "云南省西双版纳傣族自治州",
"861815697", "安徽省马鞍山市",
"861538772", "江西省九江市",
"861317927", "吉林省吉林市",
"86159189", "广东省汕头市",
"861800601", "福建省厦门市",
"86134864", "浙江省宁波市",
"861571410", "辽宁省铁岭市",
"861570754", "广东省汕头市",
"861700588", "浙江省温州市",
"861377466", "福建省厦门市",
"86180182", "江苏省常州市",
"861814667", "江西省赣州市",
"861528433", "河北省保定市",
"86147351", "山西省太原市",
"86139024", "广东省深圳市",
"861567149", "湖北省襄樊市",
"861457092", "江苏省连云港市",
"861338877", "云南省玉溪市",
"861779589", "陕西省渭南市",
"86145713", "上海市",
"861893957", "河南省郑州市",
"861813294", "河北省邢台市",
"861325564", "山东省威海市",
"86157116", "上海市",
"861550071", "青海省黄南藏族自治州",
"861363891", "西藏拉萨市",
"861556622", "辽宁省沈阳市",
"861344687", "云南省昆明市",
"861817893", "江西省上饶市",
"861882048", "广东省深圳市",
"861333851", "福建省莆田市",
"861815130", "江苏省徐州市",
"861825024", "福建省漳州市",
"861580318", "河北省衡水市",
"861530603", "福建省三明市",
"861347500", "山东省菏泽市",
"86130580", "广东省深圳市",
"86158248", "河南省郑州市",
"86136880", "四川省成都市",
"861338931", "甘肃省兰州市",
"861338650", "浙江省杭州市",
"861368453", "黑龙江省牡丹江市",
"861898837", "云南省怒江傈僳族自治州",
"861865279", "江苏省扬州市",
"861817477", "广西柳州市",
"861374279", "江西省南昌市",
"861350912", "陕西省榆林市",
"861808279", "云南省普洱市",
"861319252", "广东省汕尾市",
"861814845", "四川省宜宾市",
"861890906", "四川省遂宁市",
"861700796", "江西省赣州市",
"861866559", "广东省广州市",
"861834059", "辽宁省朝阳市",
"861808676", "江苏省扬州市",
"861862607", "江苏省无锡市",
"861824436", "四川省泸州市",
"861339725", "湖北省黄冈市",
"861855770", "浙江省温州市",
"861808069", "四川省达州市",
"861550659", "山东省烟台市",
"861536421", "湖南省长沙市",
"861346790", "湖南省湘潭市",
"861318856", "辽宁省盘锦市",
"86189810", "四川省德阳市",
"861589447", "云南省普洱市",
"861783509", "山西省临汾市",
"861865069", "福建省漳州市",
"861536388", "广东省惠州市",
"861308529", "湖北省襄樊市",
"861339208", "广东省江门市",
"861520613", "江苏省苏州市",
"861575709", "浙江省衢州市",
"861394950", "河南省安阳市",
"861575461", "黑龙江省哈尔滨市",
"861347731", "湖北省十堰市",
"861521794", "广东省广州市",
"86139942", "山西省太原市",
"861333944", "黑龙江省佳木斯市",
"861365529", "江苏省镇江市",
"861328579", "浙江省金华市",
"861312366", "贵州省铜仁地区",
"861566034", "新疆阿克苏地区",
"86139263", "广东省阳江市",
"861534534", "山东省德州市",
"861378948", "内蒙古巴彦淖尔市",
"861596931", "云南省玉溪市",
"861358796", "浙江省温州市",
"861311746", "湖南省永州市",
"861367534", "山东省德州市",
"861313660", "黑龙江省齐齐哈尔市",
"86139528", "江苏省镇江市",
"861315235", "陕西省渭南市",
"861770472", "内蒙古包头市",
"861369801", "江西省上饶市",
"861787642", "广东省梅州市",
"861768548", "山东省烟台市",
"861813948", "新疆和田地区",
"861806423", "湖北省宜昌市",
"861880159", "江苏省南京市",
"861457019", "山东省聊城市",
"861800610", "江苏省镇江市",
"861571401", "辽宁省沈阳市",
"86131639", "福建省泉州市",
"861333163", "吉林省延边朝鲜族自治州",
"861571769", "河北省邢台市",
"861866671", "广东省湛江市",
"861332741", "山西省太原市",
"861373821", "浙江省湖州市",
"861770962", "安徽省蚌埠市",
"86132965", "湖北省武汉市",
"861325274", "辽宁省抚顺市",
"861818821", "贵州省黔西南布依族苗族自治州",
"861809738", "青海省海东地区",
"861560287", "广东省珠海市",
"861809018", "四川省泸州市",
"861854503", "黑龙江省佳木斯市",
"861360562", "安徽省铜陵市",
"861477840", "广东省东莞市",
"861538882", "云南省德宏傣族景颇族自治州",
"861318437", "浙江省台州市",
"861309484", "浙江省湖州市",
"861560411", "辽宁省大连市",
"86182711", "湖北省荆门市",
"861870019", "陕西省西安市",
"861530724", "湖北省咸宁市",
"861533525", "江苏省苏州市",
"861598306", "四川省遂宁市",
"86136361", "湖北省十堰市",
"861346972", "湖北省恩施土家族苗族自治州",
"861873437", "山西省忻州市",
"861503046", "河北省廊坊市",
"861527054", "江西省上饶市",
"861870739", "湖南省邵阳市",
"861380549", "山东省临沂市",
"861858414", "四川省绵阳市",
"86182178", "海南省海口市",
"861774840", "四川省南充市",
"861323677", "辽宁省盘锦市",
"86147373", "广东省广州市",
"861357622", "江西省九江市",
"861877426", "湖南省郴州市",
"861829367", "甘肃省天水市",
"861579743", "湖北省荆州市",
"861303627", "江西省宜春市",
"861880582", "浙江省湖州市",
"861770503", "福建省宁德市",
"861539689", "江苏省盐城市",
"86130186", "广东省东莞市",
"861848771", "云南省玉溪市",
"861872484", "云南省玉溪市",
"861318153", "山东省烟台市",
"861347987", "江西省九江市",
"861882548", "广东省梅州市",
"861576466", "黑龙江省大庆市",
"86181982", "贵州省贵阳市",
"861479744", "山西省吕梁市",
"861328651", "广东省肇庆市",
"861381237", "江苏省镇江市",
"861535426", "河北省廊坊市",
"861779089", "辽宁省大连市",
"861450426", "辽宁省锦州市",
"861592989", "陕西省西安市",
"861325064", "广东省汕头市",
"861898456", "贵州省贵阳市",
"861870592", "福建省厦门市",
"861550571", "浙江省杭州市",
"861380521", "江苏省徐州市",
"861572488", "江苏省南京市",
"861774027", "四川省南充市",
"86159591", "福建省福州市",
"861315426", "辽宁省大连市",
"861895123", "江苏省常州市",
"861380146", "江苏省南通市",
"861336927", "陕西省延安市",
"861708567", "安徽省阜阳市",
"861576130", "贵州省黔东南苗族侗族自治州",
"861389941", "新疆阿勒泰地区",
"861865151", "江苏省无锡市",
"861707164", "河南省鹤壁市",
"861818849", "四川省自贡市",
"86186640", "广东省东莞市",
"861836893", "甘肃省平凉市",
"861534627", "河南省鹤壁市",
"861808151", "四川省达州市",
"861319689", "江苏省宿迁市",
"861371580", "广东省潮州市",
"861587672", "广东省梅州市",
"861332729", "湖南省邵阳市",
"861776864", "江苏省镇江市",
"861319286", "广东省韶关市",
"861302900", "吉林省长春市",
"861370344", "河南省漯河市",
"861582544", "浙江省温州市",
"861505578", "安徽省芜湖市",
"861320110", "新疆伊犁哈萨克自治州",
"861804065", "湖北省恩施土家族苗族自治州",
"861577957", "江西省南昌市",
"861339323", "河北省石家庄市",
"861509014", "河南省南阳市",
"861879900", "新疆塔城地区",
"861550282", "四川省成都市",
"861313525", "湖南省怀化市",
"861350567", "安徽省阜阳市",
"861511361", "广东省湛江市",
"861310724", "湖南省衡阳市",
"86180915", "陕西省安康市",
"861328873", "广东省云浮市",
"861304525", "黑龙江省伊春市",
"861576697", "广东省湛江市",
"861874823", "内蒙古兴安盟",
"861538437", "广东省汕尾市",
"861318882", "山东省济宁市",
"861334046", "福建省泉州市",
"861308823", "四川省内江市",
"861366546", "山东省东营市",
"861384987", "河南省许昌市",
"861559979", "新疆昌吉回族自治州",
"861362330", "河北省石家庄市",
"86156635", "黑龙江省哈尔滨市",
"86138894", "辽宁省大连市",
"861454508", "湖南省长沙市",
"861865997", "福建省南平市",
"86150374", "河南省许昌市",
"86132046", "黑龙江省哈尔滨市",
"861830728", "湖北省武汉市",
"86130761", "广东省河源市",
"861816456", "浙江省台州市",
"861808997", "西藏日喀则地区",
"861810331", "河北省石家庄市",
"861523661", "河南省新乡市",
"861390984", "辽宁省大连市",
"861358132", "湖北省荆门市",
"861893633", "江苏省盐城市",
"861772085", "福建省莆田市",
"86152733", "湖南省株洲市",
"861779773", "河南省郑州市",
"861841995", "甘肃省天水市",
"86151993", "新疆喀什地区",
"861535235", "甘肃省庆阳市",
"86182441", "吉林省白城市",
"861323996", "新疆巴音郭楞蒙古自治州",
"861591778", "广东省惠州市",
"861398449", "贵州省黔西南布依族苗族自治州",
"861828241", "四川省雅安市",
"861822411", "四川省巴中市",
"861555325", "山东省聊城市",
"861889597", "云南省昆明市",
"861356814", "四川省泸州市",
"861340446", "吉林省松原市",
"861450235", "河北省沧州市",
"861314534", "山东省德州市",
"861532366", "广东省汕头市",
"861339916", "陕西省汉中市",
"861316388", "福建省福州市",
"861896543", "福建省宁德市",
"861538856", "山西省晋城市",
"86662", "广东省阳江市",
"861300015", "山东省淄博市",
"861300735", "湖南省郴州市",
"86135809", "广东省东莞市",
"86131104", "陕西省西安市",
"86178782", "广西柳州市",
"86155870", "云南省昆明市",
"861569292", "四川省乐山市",
"861823234", "河北省张家口市",
"861539252", "山西省大同市",
"861700132", "湖北省武汉市",
"861513866", "河南省郑州市",
"861880556", "安徽省安庆市",
"86181610", "四川省绵阳市",
"86138273", "广东省潮州市",
"86182924", "陕西省西安市",
"861809406", "福建省泉州市",
"861452867", "青海省海西蒙古族藏族自治州",
"861365541", "山东省济南市",
"861375477", "山东省淄博市",
"861308541", "湖南省张家界市",
"86184050", "福建省厦门市",
"861500397", "河南省信阳市",
"861559530", "宁夏银川市",
"861458357", "山东省济南市",
"861308126", "辽宁省丹东市",
"861536449", "湖南省邵阳市",
"861890327", "河北省沧州市",
"861360917", "陕西省宝鸡市",
"861707943", "河南省驻马店市",
"861881674", "广东省深圳市",
"861328176", "四川省广安市",
"861317306", "山东省枣庄市",
"861879911", "新疆哈密地区",
"86156536", "山东省潍坊市",
"861880561", "安徽省淮北市",
"861479452", "黑龙江省齐齐哈尔市",
"861513851", "河南省濮阳市",
"861320101", "新疆昌吉回族自治州",
"861831349", "云南省德宏傣族景颇族自治州",
"861503149", "河北省石家庄市",
"861815466", "广西玉林市",
"861380021", "上海市",
"861597437", "湖南省株洲市",
"861870758", "广东省肇庆市",
"861514149", "辽宁省铁岭市",
"86153986", "云南省昆明市",
"861452645", "江苏省常州市",
"861867667", "广东省深圳市",
"861324265", "广东省汕尾市",
"861894705", "内蒙古通辽市",
"861880314", "河北省承德市",
"861476249", "江苏省宿迁市",
"861894228", "江西省赣州市",
"861882475", "广东省汕头市",
"861897240", "湖北省恩施土家族苗族自治州",
"861457116", "湖北省黄冈市",
"861832401", "新疆乌鲁木齐市",
"861809759", "新疆博尔塔拉蒙古自治州",
"861537927", "甘肃省张掖市",
"861566627", "山东省日照市",
"861581531", "广东省汕头市",
"861318772", "云南省玉溪市",
"861768965", "福建省莆田市",
"861478124", "四川省阿坝藏族羌族自治州",
"861580855", "贵州省黔东南苗族侗族自治州",
"861810764", "广东省揭阳市",
"861334546", "新疆石河子市",
"86150661", "山东省济南市",
"861394578", "黑龙江省双鸭山市",
"861850527", "江苏省宿迁市",
"861842020", "广东省河源市",
"861533936", "甘肃省张掖市",
"861813565", "河南省洛阳市",
"861804565", "黑龙江省哈尔滨市",
"861816971", "广西贵港市",
"861363470", "内蒙古呼伦贝尔市",
"861334121", "山东省济宁市",
"861859947", "新疆巴音郭楞蒙古自治州",
"861597153", "湖北省黄石市",
"861360581", "浙江省杭州市",
"861840438", "吉林省松原市",
"86155684", "吉林省吉林市",
"861350067", "内蒙古鄂尔多斯市",
"86133739", "河南省郑州市",
"861374863", "山东省青岛市",
"861593426", "山西省忻州市",
"861567121", "湖北省十堰市",
"86181115", "四川省成都市",
"86156439", "吉林省吉林市",
"861302911", "吉林省长春市",
"861780433", "吉林省延边朝鲜族自治州",
"861780991", "新疆乌鲁木齐市",
"861331382", "福建省泉州市",
"861348822", "陕西省西安市",
"861532351", "广东省东莞市",
"86130491", "广东省佛山市",
"861362985", "河南省焦作市",
"861328497", "黑龙江省鸡西市",
"861475641", "河北省石家庄市",
"86183149", "浙江省金华市",
"861889097", "新疆阿克苏地区",
"861888206", "四川省凉山彝族自治州",
"861511356", "广东省湛江市",
"861812907", "新疆阿克苏地区",
"861375196", "广东省梅州市",
"861529988", "新疆吐鲁番地区",
"86186145", "黑龙江省绥化市",
"861575482", "内蒙古兴安盟",
"86132633", "北京市",
"861863648", "山西省晋城市",
"86189065", "浙江省台州市",
"86135859", "上海市",
"861507644", "河北省保定市",
"861303034", "河南省三门峡市",
"861389854", "辽宁省阜新市",
"861363960", "河南省商丘市",
"861816461", "云南省昆明市",
"86150193", "广东省清远市",
"861817012", "江西省赣州市",
"861816709", "浙江省舟山市",
"861304170", "江苏省常州市",
"86184825", "四川省遂宁市",
"861302087", "河北省张家口市",
"861395944", "福建省宁德市",
"861351940", "甘肃省兰州市",
"861882965", "陕西省安康市",
"861873990", "河南省郑州市",
"86156130", "河北省邯郸市",
"861394896", "内蒙古赤峰市",
"861811406", "江苏省无锡市",
"861530617", "江苏省无锡市",
"861550638", "山东省烟台市",
"861581168", "广东省珠海市",
"861470355", "山西省长治市",
"861889802", "西藏日喀则地区",
"861815976", "福建省龙岩市",
"861390367", "黑龙江省牡丹江市",
"861808166", "四川省自贡市",
"861770737", "湖南省益阳市",
"86170059", "福建省厦门市",
"861555242", "山东省淄博市",
"861308041", "河北省石家庄市",
"86138251", "广东省广州市",
"86133328", "广东省广州市",
"861817599", "湖南省长沙市",
"86184861", "贵州省安顺市",
"861518201", "四川省广安市",
"861816108", "四川省宜宾市",
"86135162", "天津市",
"861538335", "河北省唐山市",
"861310825", "四川省遂宁市",
"861335122", "黑龙江省齐齐哈尔市",
"861779099", "辽宁省沈阳市",
"861350801", "四川省德阳市",
"86189021", "天津市",
"861881351", "广东省惠州市",
"861589743", "湖南省湘西土家族苗族自治州",
"861780503", "江苏省连云港市",
"861870582", "浙江省湖州市",
"86135437", "广东省东莞市",
"861355949", "福建省厦门市",
"861352371", "河南省郑州市",
"861880592", "福建省厦门市",
"861539699", "江苏省连云港市",
"861847823", "湖南省娄底市",
"861872548", "云南省曲靖市",
"861453654", "江苏省盐城市",
"86170980", "浙江省杭州市",
"861309548", "安徽省铜陵市",
"86152614", "江苏省南京市",
"86184636", "山东省潍坊市",
"861708801", "四川省成都市",
"861309494", "江苏省淮安市",
"861342817", "广东省茂名市",
"861583240", "河北省承德市",
"861340775", "广西河池市",
"861320978", "青海省西宁市",
"86183453", "黑龙江省哈尔滨市",
"861531475", "浙江省绍兴市",
"86186603", "山东省威海市",
"861855982", "福建省厦门市",
"861362464", "黑龙江省七台河市",
"861338797", "江西省赣州市",
"86186671", "浙江省杭州市",
"861300928", "辽宁省葫芦岛市",
"86182179", "海南省海口市",
"861519938", "新疆石河子市",
"861323952", "宁夏石嘴山市",
"861535905", "福建省泉州市",
"861396335", "山东省东营市",
"861776765", "新疆巴音郭楞蒙古自治州",
"861361847", "湖南省长沙市",
"861820655", "山东省滨州市",
"861883437", "山西省晋城市",
"861458940", "广东省清远市",
"861880739", "湖南省邵阳市",
"861370549", "山东省临沂市",
"861379929", "福建省厦门市",
"861817773", "广西南宁市",
"861324084", "内蒙古呼伦贝尔市",
"861561742", "河南省郑州市",
"86151920", "山东省青岛市",
"861760949", "甘肃省白银市",
"861883856", "河南省许昌市",
"861479177", "陕西省榆林市",
"861537042", "江苏省无锡市",
"861847541", "广东省阳江市",
"861809158", "陕西省西安市",
"861585461", "山东省济宁市",
"861333632", "山东省枣庄市",
"861345845", "四川省广元市",
"86139529", "江苏省镇江市",
"86139407", "辽宁省营口市",
"861510566", "安徽省池州市",
"861830935", "甘肃省武威市",
"861809716", "青海省玉树藏族自治州",
"861569571", "浙江省杭州市",
"861847126", "湖北省荆州市",
"861890425", "辽宁省丹东市",
"861888660", "四川省成都市",
"861777642", "广西玉林市",
"861357848", "云南省丽江市",
"861536398", "广东省珠海市",
"861354820", "四川省攀枝花市",
"861514748", "内蒙古乌兰察布市",
"86182705", "江西省宜春市",
"861320468", "黑龙江省鹤岗市",
"861336542", "山东省青岛市",
"86184380", "河南省周口市",
"861521784", "广东省惠州市",
"86155841", "吉林省长春市",
"861452501", "山东省济南市",
"861867744", "广西梧州市",
"861780472", "内蒙古包头市",
"861381326", "江苏省徐州市",
"861529602", "广西桂林市",
"861555427", "山东省枣庄市",
"861586976", "湖南省益阳市",
"861598542", "贵州省黔南布依族苗族自治州",
"861386633", "安徽省淮南市",
"86156857", "贵州省毕节地区",
"86182470", "内蒙古呼伦贝尔市",
"86158249", "河南省洛阳市",
"86152552", "安徽省蚌埠市",
"86139426", "辽宁省大连市",
"861356307", "山东省滨州市",
"861338483", "内蒙古阿拉善盟",
"861392261", "广东省清远市",
"861452730", "湖南省岳阳市",
"861318733", "湖南省衡阳市",
"861372158", "贵州省毕节地区",
"861571678", "河南省驻马店市",
"86150625", "江苏省苏州市",
"861318013", "河北省秦皇岛市",
"861522947", "陕西省宝鸡市",
"86188013", "北京市",
"861779599", "陕西省榆林市",
"861302969", "浙江省温州市",
"861339959", "安徽省黄山市",
"861454438", "江苏省淮安市",
"861537104", "江苏省南京市",
"861369999", "新疆乌鲁木齐市",
"861817883", "广西柳州市",
"861344697", "青海省海南藏族自治州",
"861580754", "广东省汕头市",
"861394852", "内蒙古包头市",
"86184535", "山东省烟台市",
"861872048", "江西省景德镇市",
"861591179", "云南省西双版纳傣族自治州",
"861570318", "河北省衡水市",
"861577162", "陕西省榆林市",
"86159188", "广东省广州市",
"861392256", "广东省清远市",
"861871943", "广东省佛山市",
"861594757", "内蒙古乌兰察布市",
"861457082", "江苏省南京市",
"861880092", "四川省遂宁市",
"86151738", "湖南省娄底市",
"86134632", "河北省保定市",
"86150120", "云南省临沧市",
"861592912", "陕西省榆林市",
"86183403", "辽宁省沈阳市",
"861779732", "青海省黄南藏族自治州",
"86186653", "广东省深圳市",
"861390975", "青海省果洛藏族自治州",
"861893181", "河北省衡水市",
"861779012", "四川省德阳市",
"86183471", "内蒙古呼和浩特市",
"861518210", "四川省内江市",
"861893672", "江苏省连云港市",
"861300640", "四川省乐山市",
"861344130", "江苏省淮安市",
"861510551", "安徽省合肥市",
"861894415", "江苏省无锡市",
"861830380", "河南省安阳市",
"861351357", "山西省临汾市",
"861350810", "四川省绵阳市",
"861862424", "辽宁省抚顺市",
"861815687", "安徽省阜阳市",
"861800968", "安徽省阜阳市",
"861802135", "江苏省徐州市",
"861831544", "山东省潍坊市",
"86132714", "河南省平顶山市",
"861501938", "广东省河源市",
"861511392", "广东省汕头市",
"861558342", "四川省成都市",
"861768746", "广西百色市",
"861539612", "福建省福州市",
"861375152", "广东省佛山市",
"861478907", "西藏阿里地区",
"86186364", "山西省吕梁市",
"861879969", "新疆昌吉回族自治州",
"861458628", "湖北省咸宁市",
"861311548", "黑龙江省鹤岗市",
"861894804", "广东省清远市",
"861559400", "甘肃省平凉市",
"861512955", "陕西省渭南市",
"861337398", "河南省三门峡市",
"861332128", "甘肃省兰州市",
"861569071", "河南省平顶山市",
"861809536", "宁夏固原市",
"861884029", "陕西省西安市",
"861367358", "河南省周口市",
"86150526", "江苏省淮安市",
"861879479", "甘肃省兰州市",
"861478580", "贵州省安顺市",
"861350989", "广东省潮州市",
"86156826", "甘肃省张掖市",
"861506618", "山东省青岛市",
"861328832", "河北省廊坊市",
"861532674", "内蒙古兴安盟",
"86182755", "贵州省遵义市",
"861336042", "广东省惠州市",
"861811036", "安徽省宣城市",
"861364542", "山东省青岛市",
"861829994", "新疆哈密地区",
"861534358", "山西省吕梁市",
"86145400", "北京市",
"861533609", "甘肃省陇南市",
"861761437", "吉林省辽源市",
"861886301", "山东省聊城市",
"861313918", "青海省海西蒙古族藏族自治州",
"861820428", "辽宁省葫芦岛市",
"861774942", "河南省漯河市",
"861470457", "黑龙江省大兴安岭地区",
"86133076", "海南省海口市",
"861564398", "吉林省白山市",
"861800478", "内蒙古巴彦淖尔市",
"861855890", "福建省龙岩市",
"861881685", "广东省深圳市",
"861832293", "江西省宜春市",
"861539868", "云南省昭通市",
"861816419", "湖北省十堰市",
"861881366", "广东省湛江市",
"861859350", "福建省莆田市",
"861857133", "湖北省恩施土家族苗族自治州",
"861502858", "河北省秦皇岛市",
"861314404", "广东省中山市",
"861303404", "安徽省合肥市",
"86130725", "江苏省南京市",
"861538980", "内蒙古呼和浩特市",
"861521874", "广东省深圳市",
"861328395", "河南省漯河市",
"861836089", "江苏省淮安市",
"86185560", "江苏省盐城市",
"861508368", "江西省鹰潭市",
"86151329", "河北省邢台市",
"861850942", "甘肃省定西市",
"861557715", "广西崇左市",
"861302479", "浙江省台州市",
"861586451", "山东省济南市",
"861557035", "江西省南昌市",
"861329639", "山东省青岛市",
"86158510", "江苏省盐城市",
"861834408", "广东省广州市",
"861389755", "青海省果洛藏族自治州",
"861353645", "广东省汕尾市",
"861322429", "辽宁省葫芦岛市",
"861452510", "山东省淄博市",
"861768377", "湖北省随州市",
"861376340", "黑龙江省哈尔滨市",
"86150507", "江苏省扬州市",
"861859522", "山东省济宁市",
"861882746", "湖北省黄冈市",
"86150429", "辽宁省葫芦岛市",
"861303815", "四川省资阳市",
"861580336", "河北省廊坊市",
"861479496", "内蒙古赤峰市",
"861705377", "北京市",
"861304265", "辽宁省本溪市",
"861313389", "江西省景德镇市",
"861568028", "四川省宜宾市",
"861834649", "黑龙江省牡丹江市",
"861518827", "河南省信阳市",
"861330337", "河北省沧州市",
"861318722", "湖南省湘潭市",
"861874783", "内蒙古通辽市",
"861566677", "山东省济南市",
"861558284", "山西省晋城市",
"861304389", "辽宁省葫芦岛市",
"861313265", "广西玉林市",
"861365783", "广西桂林市",
"861315951", "吉林省长春市",
"861315630", "山东省威海市",
"8618422", "天津市",
"861829759", "安徽省滁州市",
"861454765", "山东省聊城市",
"86875", "云南省保山市",
"861321286", "黑龙江省黑河市",
"861840864", "宁夏固原市",
"861364977", "青海省海南藏族自治州",
"861815313", "贵州省安顺市",
"861830888", "云南省丽江市",
"861350318", "河北省衡水市",
"861303167", "山东省潍坊市",
"86939", "甘肃省陇南市",
"86152836", "四川省宜宾市",
"861875977", "福建省漳州市",
"861321689", "浙江省丽水市",
"861314167", "江苏省南京市",
"861860417", "辽宁省营口市",
"861458283", "福建省宁德市",
"86394", "河南省周口市",
"861843285", "河北省唐山市",
"861338040", "广东省汕头市",
"861380071", "湖北省襄樊市",
"861821642", "湖南省长沙市",
"861533594", "湖北省咸宁市",
"861530795", "江西省宜春市",
"861459559", "青海省海西蒙古族藏族自治州",
"861567171", "湖北省黄冈市",
"861588588", "贵州省毕节地区",
"861533448", "云南省玉溪市",
"861536982", "河北省沧州市",
"861571357", "山西省临汾市",
"861529361", "甘肃省张掖市",
"861898949", "浙江省杭州市",
"861380261", "广东省江门市",
"861807558", "湖南省怀化市",
"861840946", "甘肃省定西市",
"861596040", "福建省泉州市",
"861322911", "河北省石家庄市",
"861885652", "安徽省芜湖市",
"86132491", "广东省广州市",
"861335836", "福建省龙岩市",
"861570810", "四川省遂宁市",
"861850577", "浙江省温州市",
"861333623", "山东省日照市",
"861804342", "吉林省吉林市",
"861304075", "浙江省台州市",
"861305295", "江苏省泰州市",
"86152661", "山东省威海市",
"86151581", "浙江省杭州市",
"861572214", "贵州省贵阳市",
"861334682", "河南省濮阳市",
"861813342", "安徽省马鞍山市",
"861708318", "河北省沧州市",
"861338255", "江苏省泰州市",
"861550049", "吉林省白山市",
"861332889", "福建省泉州市",
"861816921", "湖南省郴州市",
"861390738", "湖南省娄底市",
"861777112", "湖北省襄樊市",
"861770368", "黑龙江省鹤岗市",
"861503656", "河南省洛阳市",
"861376848", "广西河池市",
"861527644", "新疆喀什地区",
"861881703", "湖南省岳阳市",
"861521725", "广东省东莞市",
"861874497", "贵州省黔西南布依族苗族自治州",
"861580999", "新疆伊犁哈萨克自治州",
"861316956", "广东省惠州市",
"861308497", "广西钦州市",
"861599107", "陕西省宝鸡市",
"861317299", "广东省韶关市",
"86183358", "山西省吕梁市",
"861781792", "广东省清远市",
"861365497", "辽宁省沈阳市",
"86147576", "浙江省台州市",
"861890484", "黑龙江省牡丹江市",
"861767129", "湖北省荆门市",
"861707537", "山东省济宁市",
"861339794", "江西省抚州市",
"861332910", "安徽省淮南市",
"861335457", "黑龙江省大兴安岭地区",
"861310393", "河南省濮阳市",
"861517471", "内蒙古乌海市",
"861317696", "山东省临沂市",
"861509988", "广东省佛山市",
"861364467", "黑龙江省伊春市",
"861590349", "山西省朔州市",
"861534850", "贵州省遵义市",
"861847832", "湖南省岳阳市",
"861889441", "甘肃省临夏回族自治州",
"861472791", "陕西省延安市",
"861328041", "山东省滨州市",
"86147479", "内蒙古鄂尔多斯市",
"861367850", "贵州省贵阳市",
"861322087", "山东省青岛市",
"861377035", "江苏省淮安市",
"861537467", "内蒙古乌兰察布市",
"86159983", "辽宁省沈阳市",
"861335133", "黑龙江省牡丹江市",
"861846517", "宁夏固原市",
"861556340", "山东省莱芜市",
"86185829", "四川省宜宾市",
"861896937", "浙江省金华市",
"861337890", "湖南省岳阳市",
"861534677", "甘肃省甘南藏族自治州",
"861804225", "浙江省绍兴市",
"861818490", "西藏昌都地区",
"861895444", "山东省淄博市",
"861818653", "湖北省咸宁市",
"861825095", "福建省南平市",
"86157162", "江苏省苏州市",
"861311906", "新疆阿勒泰地区",
"861570801", "西藏拉萨市",
"861573867", "河南省新乡市",
"861332779", "江苏省泰州市",
"861476082", "江苏省泰州市",
"861587622", "广东省河源市",
"861373490", "四川省眉山市",
"86139381", "河南省焦作市",
"861382465", "广东省云浮市",
"861859533", "河南省驻马店市",
"861813225", "河北省唐山市",
"861340824", "四川省乐山市",
"861551237", "河北省承德市",
"861315476", "内蒙古赤峰市",
"861575949", "福建省泉州市",
"861774077", "西藏阿里地区",
"861886753", "浙江省杭州市",
"861338540", "山东省菏泽市",
"861330505", "福建省泉州市",
"861572371", "广西南宁市",
"861333704", "内蒙古通辽市",
"861593197", "河北省邢台市",
"861336977", "青海省海西蒙古族藏族自治州",
"861348782", "湖南省益阳市",
"861886662", "山东省青岛市",
"86151266", "云南省昭通市",
"861830778", "广西河池市",
"861890746", "湖南省永州市",
"861563923", "河南省鹤壁市",
"861807058", "江西省赣州市",
"86152374", "河南省许昌市",
"861539142", "云南省曲靖市",
"861848749", "云南省大理白族自治州",
"861801086", "安徽省合肥市",
"861477077", "江西省抚州市",
"861596540", "山东省滨州市",
"861876836", "浙江省湖州市",
"861776438", "安徽省蚌埠市",
"861862485", "河南省洛阳市",
"861385723", "浙江省舟山市",
"861514661", "黑龙江省哈尔滨市",
"861787552", "广东省东莞市",
"861503661", "河南省新乡市",
"861533094", "辽宁省辽阳市",
"861772180", "四川省南充市",
"861312407", "福建省厦门市",
"861846981", "云南省玉溪市",
"861459059", "广东省肇庆市",
"861705658", "湖北省武汉市",
"861598977", "广东省珠海市",
"861807136", "湖北省十堰市",
"86186311", "河北省石家庄市",
"861564982", "河南省许昌市",
"861310774", "浙江省杭州市",
"861595389", "山东省威海市",
"861824065", "河南省新乡市",
"861313575", "湖北省荆州市",
"861550549", "山东省临沂市",
"861529734", "河北省张家口市",
"861339373", "河南省郑州市",
"86182915", "陕西省安康市",
"861773694", "河北省石家庄市",
"861304575", "浙江省绍兴市",
"861365873", "云南省红河哈尼族彝族自治州",
"861869348", "甘肃省酒泉市",
"861538243", "浙江省宁波市",
"861802287", "广东省广州市",
"861532413", "河北省张家口市",
"861380256", "广东省深圳市",
"861529356", "甘肃省天水市",
"861522072", "广东省惠州市",
"86660", "广东省汕尾市",
"861323534", "山东省德州市",
"861380659", "浙江省台州市",
"861863970", "河南省信阳市",
"861320735", "湖南省郴州市",
"861340938", "河南省许昌市",
"861479904", "新疆克孜勒苏柯尔克孜自治州",
"86150733", "湖南省株洲市",
"861563316", "河北省廊坊市",
"861326644", "广东省湛江市",
"86139860", "湖北省武汉市",
"861360743", "湖南省长沙市",
"861876457", "山东省东营市",
"861343180", "广东省梅州市",
"861865241", "江苏省连云港市",
"861303996", "黑龙江省哈尔滨市",
"861506148", "江苏省镇江市",
"861315844", "四川省德阳市",
"86134020", "上海市",
"86183308", "河北省衡水市",
"86189213", "江苏省无锡市",
"861812185", "四川省德阳市",
"861576715", "广东省肇庆市",
"861353115", "广东省汕头市",
"86156790", "江西省新余市",
"86153660", "江苏省南京市",
"861537831", "四川省资阳市",
"861315966", "吉林省吉林市",
"861829406", "甘肃省庆阳市",
"861328541", "山东省济南市",
"861379411", "广东省汕头市",
"861520397", "河南省信阳市",
"861375427", "浙江省丽水市",
"861501885", "广东省珠海市",
"861777199", "湖北省黄冈市",
"861881624", "江苏省徐州市",
"861334238", "辽宁省盘锦市",
"861336467", "吉林省松原市",
"861354328", "广东省深圳市",
"861536890", "云南省西双版纳傣族自治州",
"861890377", "河南省南阳市",
"861308176", "辽宁省辽阳市",
"861595120", "江苏省常州市",
"861567238", "湖北省咸宁市",
"861838150", "四川省乐山市",
"86178787", "广西钦州市",
"861781719", "广东省揭阳市",
"861453488", "内蒙古呼伦贝尔市",
"861868190", "陕西省榆林市",
"861814234", "陕西省汉中市",
"861351678", "浙江省宁波市",
"861805190", "江苏省苏州市",
"861322587", "安徽省亳州市",
"861580912", "陕西省榆林市",
"861332901", "安徽省合肥市",
"86136283", "重庆市",
"86134805", "广东省惠州市",
"861560854", "贵州省黔南布依族苗族自治州",
"861571455", "黑龙江省绥化市",
"861591129", "云南省普洱市",
"86185436", "吉林省白城市",
"861331244", "贵州省黔东南苗族侗族自治州",
"861887630", "福建省漳州市",
"861326767", "广东省江门市",
"861454946", "福建省泉州市",
"861515662", "安徽省淮南市",
"86136623", "广东省广州市",
"86147141", "广东省广州市",
"861817604", "广西钦州市",
"861533399", "河南省许昌市",
"861508981", "广东省江门市",
"861459354", "贵州省遵义市",
"861565981", "福建省厦门市",
"861839706", "青海省玉树藏族自治州",
"861373791", "广西南宁市",
"861322969", "广东省汕尾市",
"861556191", "黑龙江省伊春市",
"861502947", "陕西省宝鸡市",
"8614711", "四川省成都市",
"861811248", "江苏省无锡市",
"861858298", "四川省广元市",
"861562250", "广东省东莞市",
"861769269", "河北省邢台市",
"861824284", "辽宁省辽阳市",
"861380616", "江苏省无锡市",
"861786459", "山东省济宁市",
"861337608", "江苏省南京市",
"861366908", "湖北省咸宁市",
"861348558", "安徽省阜阳市",
"861312537", "江西省赣州市",
"861860707", "江西省赣州市",
"861521938", "广东省揭阳市",
"86181979", "新疆伊犁哈萨克自治州",
"861863409", "河北省衡水市",
"861330435", "吉林省四平市",
"86130714", "广东省江门市",
"861317652", "山东省青岛市",
"861450187", "山西省长治市",
"861871305", "河北省沧州市",
"861781118", "宁夏固原市",
"861558565", "吉林省通化市",
"861316992", "广东省深圳市",
"861306338", "安徽省阜阳市",
"86139001", "上海市",
"861458678", "湖南省益阳市",
"861317763", "江西省景德镇市",
"861781756", "广东省珠海市",
"861313584", "湖北省恩施土家族苗族自治州",
"861570067", "四川省自贡市",
"861512899", "河北省保定市",
"86185539", "山东省临沂市",
"861358123", "湖北省黄冈市",
"861556957", "新疆喀什地区",
"861501446", "广东省清远市",
"861860315", "河北省唐山市",
"861806887", "江苏省盐城市",
"86152120", "安徽省滁州市",
"86185985", "重庆市",
"861320640", "山东省济南市",
"86134637", "河北省沧州市",
"861329048", "河北省邯郸市",
"861862474", "河南省新乡市",
"861819112", "陕西省西安市",
"861399545", "宁夏吴忠市",
"861840765", "广东省佛山市",
"861820968", "宁夏银川市",
"861503692", "河南省驻马店市",
"861454864", "河南省开封市",
"861894683", "青海省海西蒙古族藏族自治州",
"861809994", "新疆昌吉回族自治州",
"861812174", "江苏省泰州市",
"861590544", "山东省德州市",
"86180755", "湖南省郴州市",
"861590498", "辽宁省阜新市",
"861555384", "山东省东营市",
"861591380", "广东省东莞市",
"861330641", "山东省济南市",
"861388670", "湖北省宜昌市",
"861802030", "江苏省无锡市",
"861362553", "安徽省芜湖市",
"861800428", "辽宁省大连市",
"861364365", "山西省运城市",
"861772024", "湖北省孝感市",
"861332593", "浙江省嘉兴市",
"861599924", "新疆喀什地区",
"861820478", "内蒙古巴彦淖尔市",
"861772953", "陕西省延安市",
"861339332", "河北省保定市",
"861537686", "山东省菏泽市",
"861316770", "安徽省安庆市",
"861530383", "河南省郑州市",
"86189406", "辽宁省锦州市",
"861332178", "广西贵港市",
"861392146", "江苏省南通市",
"861584547", "黑龙江省鹤岗市",
"861829536", "宁夏吴忠市",
"861378109", "河南省平顶山市",
"861804109", "辽宁省沈阳市",
"861532624", "辽宁省阜新市",
"86139452", "黑龙江省齐齐哈尔市",
"86152526", "江苏省泰州市",
"861471708", "甘肃省武威市",
"861539434", "浙江省嘉兴市",
"861899155", "陕西省安康市",
"861812443", "广东省揭阳市",
"861874832", "内蒙古阿拉善盟",
"861526618", "山东省枣庄市",
"861308832", "四川省自贡市",
"861879429", "甘肃省定西市",
"861872639", "安徽省合肥市",
"861561698", "湖南省邵阳市",
"861322479", "内蒙古兴安盟",
"861760482", "内蒙古兴安盟",
"861510629", "江苏省南通市",
"86189427", "辽宁省盘锦市",
"861302429", "浙江省杭州市",
"86189509", "福建省三明市",
"861705327", "广东省广州市",
"861522291", "安徽省合肥市",
"86150502", "江苏省苏州市",
"861323815", "辽宁省丹东市",
"861768327", "四川省绵阳市",
"86152429", "辽宁省葫芦岛市",
"86152507", "江苏省宿迁市",
"861862846", "陕西省咸阳市",
"861346820", "山东省临沂市",
"861523302", "河北省张家口市",
"861335355", "山西省长治市",
"861475100", "江苏省苏州市",
"861705218", "江苏省无锡市",
"861370638", "山东省莱芜市",
"861522858", "四川省攀枝花市",
"861881413", "广东省广州市",
"861855449", "山东省烟台市",
"861369855", "贵州省毕节地区",
"861308395", "浙江省杭州市",
"861554166", "辽宁省朝阳市",
"861895132", "江苏省南通市",
"86132725", "重庆市",
"861323404", "辽宁省沈阳市",
"861365395", "河南省漯河市",
"861459736", "湖南省常德市",
"861843274", "河北省邯郸市",
"861352321", "河南省焦作市",
"861806777", "浙江省温州市",
"861569843", "山西省阳泉市",
"861312305", "福建省三明市",
"861316919", "广东省茂名市",
"861332231", "辽宁省营口市",
"861535343", "陕西省渭南市",
"86188265", "广东省深圳市",
"861884930", "河北省张家口市",
"861862387", "河南省商丘市",
"861312717", "山东省潍坊市",
"86155215", "广东省中山市",
"861334908", "安徽省阜阳市",
"861558275", "山西省吕梁市",
"861868341", "四川省凉山彝族自治州",
"861802979", "广东省潮州市",
"861870646", "山东省潍坊市",
"861529835", "江苏省南京市",
"86156723", "湖北省恩施土家族苗族自治州",
"861327862", "云南省保山市",
"861335681", "山东省威海市",
"861852734", "湖北省武汉市",
"861550344", "山西省太原市",
"861335172", "黑龙江省齐齐哈尔市",
"861310875", "云南省保山市",
"86183584", "浙江省宁波市",
"861588752", "云南省楚雄彝族自治州",
"86139051", "江苏省南京市",
"861357957", "新疆克孜勒苏柯尔克孜自治州",
"861303952", "内蒙古呼和浩特市",
"861363721", "安徽省宣城市",
"86188681", "浙江省杭州市",
"861370282", "广东省佛山市",
"861533312", "河北省保定市",
"861801112", "四川省绵阳市",
"861570567", "安徽省阜阳市",
"86151198", "广东省肇庆市",
"86186934", "甘肃省庆阳市",
"861591935", "广东省惠州市",
"861314952", "黑龙江省齐齐哈尔市",
"861519446", "河南省信阳市",
"861850489", "内蒙古锡林郭勒盟",
"861329548", "山东省泰安市",
"861888094", "四川省泸州市",
"861372248", "河北省邯郸市",
"861378418", "河北省衡水市",
"86159172", "广东省中山市",
"861399045", "四川省甘孜藏族自治州",
"861329494", "云南省昆明市",
"861890965", "安徽省蚌埠市",
"861325757", "广东省佛山市",
"861860839", "四川省广元市",
"861871537", "安徽省淮南市",
"861300978", "黑龙江省佳木斯市",
"861343524", "广东省湛江市",
"86157784", "广西梧州市",
"861813418", "河北省沧州市",
"861320928", "陕西省延安市",
"861361958", "宁夏银川市",
"861781761", "广东省清远市",
"861332093", "四川省眉山市",
"86176865", "山东省东营市",
"86158808", "福建省泉州市",
"861539309", "甘肃省天水市",
"861890475", "内蒙古通辽市",
"861501784", "广东省汕头市",
"861336289", "浙江省杭州市",
"861780422", "辽宁省锦州市",
"861508809", "广东省广州市",
"861300468", "浙江省衢州市",
"861331998", "新疆喀什地区",
"861394915", "河南省信阳市",
"861348833", "陕西省西安市",
"861576814", "广东省深圳市",
"861327618", "江苏省镇江市",
"861787596", "广东省揭阳市",
"861560941", "甘肃省兰州市",
"861534986", "安徽省六安市",
"861569521", "江苏省南京市",
"86539", "山东省临沂市",
"861829716", "青海省玉树藏族自治州",
"86189456", "黑龙江省哈尔滨市",
"861508517", "贵州省黔南布依族苗族自治州",
"861811994", "安徽省马鞍山市",
"861858944", "西藏林芝地区",
"861379469", "广东省韶关市",
"861320834", "四川省凉山彝族自治州",
"86769", "广东省东莞市",
"86180470", "内蒙古呼伦贝尔市",
"861839459", "甘肃省兰州市",
"86150552", "安徽省蚌埠市",
"86137870", "湖南省长沙市",
"86153121", "江苏省苏州市",
"86152557", "安徽省宿州市",
"861572654", "山东省聊城市",
"86156852", "贵州省遵义市",
"86152625", "江苏省苏州市",
"86181370", "河南省商丘市",
"861325680", "山东省威海市",
"861571628", "江苏省南通市",
"861583150", "河北省唐山市",
"861869499", "江苏省南京市",
"86189559", "安徽省黄山市",
"861836242", "江苏省扬州市",
"861459516", "云南省保山市",
"861598686", "广东省汕头市",
"861322230", "江苏省扬州市",
"861889740", "湖南省常德市",
"861853650", "山西省朔州市",
"861472653", "四川省内江市",
"861311639", "贵州省黔西南布依族苗族自治州",
"861530147", "江苏省南通市",
"861589081", "河南省驻马店市",
"861586926", "浙江省金华市",
"861474586", "黑龙江省齐齐哈尔市",
"861769930", "新疆喀什地区",
"861472799", "陕西省汉中市",
"861565067", "安徽省宿州市",
"861889449", "甘肃省兰州市",
"86189401", "辽宁省沈阳市",
"861398597", "贵州省黔西南布依族苗族自治州",
"861850657", "浙江省杭州市",
"861532932", "贵州省遵义市",
"861590341", "山西省太原市",
"861537315", "河北省唐山市",
"861307955", "宁夏吴忠市",
"86170836", "河南省洛阳市",
"861328049", "山东省济宁市",
"861329726", "湖北省随州市",
"86152521", "江苏省徐州市",
"861834435", "广东省惠州市",
"861803785", "河南省驻马店市",
"86153157", "山东省聊城市",
"861364707", "江西省赣州市",
"861800584", "浙江省宁波市",
"861841944", "甘肃省兰州市",
"861801340", "江苏省无锡市",
"861562206", "广东省湛江市",
"861309776", "广西百色市",
"861875707", "浙江省温州市",
"861533140", "云南省文山壮族苗族自治州",
"861361483", "内蒙古阿拉善盟",
"861768078", "湖南省邵阳市",
"861802760", "广东省茂名市",
"861390683", "浙江省嘉兴市",
"861705078", "浙江省宁波市",
"861782044", "广东省中山市",
"861344765", "安徽省合肥市",
"861364315", "河北省唐山市",
"861351833", "四川省广元市",
"861862914", "陕西省西安市",
"861807678", "广西桂林市",
"861802492", "广东省佛山市",
"861766627", "广东省珠海市",
"861397194", "湖北省孝感市",
"861337802", "湖南省湘潭市",
"861894925", "安徽省阜阳市",
"861317858", "广东省湛江市",
"861385222", "江苏省徐州市",
"861367057", "广东省揭阳市",
"861780855", "贵州省黔东南苗族侗族自治州",
"861705268", "上海市",
"861568965", "山东省日照市",
"861881463", "黑龙江省牡丹江市",
"861459066", "广东省云浮市",
"86147197", "四川省成都市",
"86135036", "黑龙江省哈尔滨市",
"861337097", "山东省聊城市",
"861767121", "湖北省黄石市",
"861508277", "四川省南充市",
"861778123", "四川省乐山市",
"861373073", "四川省资阳市",
"861872776", "湖北省咸宁市",
"861536597", "江苏省镇江市",
"861517479", "内蒙古兴安盟",
"861781700", "广东省佛山市",
"861514898", "内蒙古阿拉善盟",
"861580991", "新疆乌鲁木齐市",
"861566557", "安徽省宿州市",
"861580433", "吉林省延边朝鲜族自治州",
"861581920", "广东省韶关市",
"861323865", "云南省保山市",
"861317291", "广东省清远市",
"861828082", "四川省南充市",
"861322919", "广东省揭阳市",
"861309347", "安徽省宣城市",
"861477780", "广西南宁市",
"861529369", "甘肃省平凉市",
"861812727", "广东省阳江市",
"861898941", "浙江省金华市",
"86188585", "浙江省绍兴市",
"861380269", "广东省中山市",
"861538742", "湖南省常德市",
"861769616", "山西省晋中市",
"861326305", "江西省宜春市",
"86134867", "浙江省温州市",
"861380666", "浙江省宁波市",
"86156788", "广西南宁市",
"861572585", "山东省泰安市",
"861529285", "新疆乌鲁木齐市",
"861527537", "山东省济宁市",
"861352953", "云南省德宏傣族景颇族自治州",
"861338847", "浙江省丽水市",
"86139027", "广东省汕头市",
"861567179", "湖北省随州市",
"861459551", "青海省西宁市",
"861788914", "西藏拉萨市",
"861573560", "山西省晋城市",
"86133488", "四川省成都市",
"86185431", "吉林省长春市",
"861816929", "湖南省怀化市",
"861361797", "江西省赣州市",
"861550041", "吉林省四平市",
"861332881", "福建省漳州市",
"861515612", "安徽省马鞍山市",
"861707644", "山东省青岛市",
"861331757", "湖北省宜昌市",
"861874638", "黑龙江省哈尔滨市",
"861882078", "广东省广州市",
"861308638", "四川省遂宁市",
"861850780", "广西崇左市",
"861805044", "福建省福州市",
"86182875", "云南省保山市",
"861556586", "河南省周口市",
"861365638", "山东省聊城市",
"861597308", "湖南省娄底市",
"86187938", "甘肃省天水市",
"86155743", "湖南省长沙市",
"861516533", "山东省淄博市",
"861860686", "浙江省宁波市",
"861304381", "辽宁省辽阳市",
"861860365", "黑龙江省哈尔滨市",
"861878428", "四川省南充市",
"861475718", "浙江省宁波市",
"861829751", "安徽省芜湖市",
"86130238", "福建省福州市",
"861315959", "吉林省白城市",
"861589893", "山东省潍坊市",
"861840715", "湖北省咸宁市",
"861313428", "辽宁省大连市",
"861820918", "陕西省西安市",
"861454814", "广东省广州市",
"861313381", "江西省南昌市",
"861321681", "浙江省杭州市",
"861380079", "江西省新余市",
"861311183", "四川省雅安市",
"861570737", "湖南省益阳市",
"861454405", "福建省宁德市",
"861317033", "湖南省衡阳市",
"861317713", "湖北省恩施土家族苗族自治州",
"861840307", "河北省沧州市",
"861554813", "内蒙古包头市",
"86150059", "福建省福州市",
"861768193", "浙江省金华市",
"861313655", "浙江省台州市",
"861336707", "江西省赣州市",
"861777191", "湖北省十堰市",
"861707830", "云南省昭通市",
"861589477", "新疆昌吉回族自治州",
"861596386", "山东省东营市",
"861550823", "四川省达州市",
"861810952", "宁夏石嘴山市",
"861537839", "四川省南充市",
"86188330", "河北省邯郸市",
"861365282", "广东省潮州市",
"861829766", "安徽省宿州市",
"861776130", "四川省成都市",
"861508567", "贵州省黔东南苗族侗族自治州",
"861333974", "湖北省荆州市",
"861874282", "新疆喀什地区",
"861328549", "山东省临沂市",
"861379419", "广东省中山市",
"861362632", "山东省枣庄市",
"861336315", "河北省唐山市",
"861378978", "内蒙古巴彦淖尔市",
"861561980", "陕西省汉中市",
"861507164", "湖北省随州市",
"861311776", "广西百色市",
"861781711", "广东省佛山市",
"861844725", "内蒙古包头市",
"861824928", "黑龙江省齐齐哈尔市",
"861332909", "安徽省黄山市",
"861898854", "广东省佛山市",
"861787672", "广东省湛江市",
"861394965", "河南省焦作市",
"861705578", "浙江省宁波市",
"861458782", "湖南省永州市",
"861813978", "甘肃省酒泉市",
"861576864", "广东省惠州市",
"861459566", "陕西省宝鸡市",
"861517230", "湖北省十堰市",
"861373198", "安徽省马鞍山市",
"861587370", "湖南省益阳市",
"861380930", "甘肃省白银市",
"861337597", "福建省三明市",
"861556798", "吉林省白山市",
"861380651", "浙江省杭州市",
"861576946", "甘肃省金昌市",
"861598315", "四川省自贡市",
"861310904", "新疆伊犁哈萨克自治州",
"861367557", "安徽省宿州市",
"86183023", "重庆市",
"86185032", "河北省石家庄市",
"861516291", "江苏省宿迁市",
"861472712", "浙江省杭州市",
"86158345", "吉林省通化市",
"861534557", "安徽省宿州市",
"861566057", "河南省新乡市",
"861865249", "江苏省无锡市",
"861598707", "云南省玉溪市",
"86147219", "上海市",
"861393868", "河南省安阳市",
"86153126", "江苏省徐州市",
"861808249", "甘肃省庆阳市",
"861830908", "新疆克孜勒苏柯尔克孜自治州",
"861823825", "河南省信阳市",
"861352524", "河南省三门峡市",
"861323647", "江苏省镇江市",
"861572085", "江苏省常州市",
"86187720", "湖北省恩施土家族苗族自治州",
"861503669", "河南省商丘市",
"861452694", "陕西省商洛市",
"861518352", "四川省雅安市",
"861459051", "广东省深圳市",
"861452165", "河北省衡水市",
"861771283", "江苏省镇江市",
"861881202", "河北省保定市",
"86130070", "山西省太原市",
"861882193", "湖南省衡阳市",
"861867147", "湖北省襄樊市",
"861327812", "吉林省四平市",
"861351558", "安徽省阜阳市",
"861824834", "内蒙古通辽市",
"861514669", "黑龙江省齐齐哈尔市",
"861318454", "江西省赣州市",
"861396308", "山东省滨州市",
"861535938", "福建省泉州市",
"861512862", "河北省承德市",
"8615730", "重庆市",
"861556086", "内蒙古赤峰市",
"861552450", "辽宁省沈阳市",
"861552693", "吉林省白山市",
"861805498", "福建省龙岩市",
"861479774", "广西梧州市",
"861868544", "贵州省贵阳市",
"86145020", "河北省秦皇岛市",
"86136688", "山东省青岛市",
"861311347", "广东省汕头市",
"861838458", "四川省广元市",
"861550541", "山东省济南市",
"861806237", "湖北省宜昌市",
"861570809", "西藏昌都地区",
"861360325", "河北省唐山市",
"86158782", "广西柳州市",
"861561507", "山东省聊城市",
"861840535", "山东省烟台市",
"861371727", "广东省江门市",
"861853209", "河北省邯郸市",
"861890915", "陕西省安康市",
"861597742", "广西桂林市",
"861332771", "江苏省南京市",
"861319122", "山西省大同市",
"861309183", "黑龙江省牡丹江市",
"861571822", "广东省深圳市",
"861325244", "浙江省宁波市",
"861850870", "云南省昭通市",
"861373402", "山西省太原市",
"86155892", "山东省枣庄市",
"861813468", "安徽省安庆市",
"861558015", "湖南省怀化市",
"86188686", "浙江省宁波市",
"861515296", "江苏省泰州市",
"861477870", "广东省佛山市",
"861509808", "湖北省十堰市",
"861533362", "山西省大同市",
"861570517", "江苏省苏州市",
"861558735", "山东省烟台市",
"861801162", "四川省绵阳市",
"861575941", "福建省福州市",
"861515699", "安徽省合肥市",
"86189618", "江苏省无锡市",
"861538308", "河北省衡水市",
"86145805", "江苏省盐城市",
"86189002", "福建省福州市",
"861572379", "广西北海市",
"861346942", "湖南省长沙市",
"861522299", "安徽省黄山市",
"861575755", "浙江省台州市",
"86151180", "广东省深圳市",
"861366778", "广西河池市",
"86137910", "山东省济南市",
"861832648", "安徽省六安市",
"861892676", "广东省深圳市",
"861580003", "广东省广州市",
"861508810", "广东省珠海市",
"86130442", "广东省广州市",
"86147571", "浙江省杭州市",
"861332960", "贵州省贵阳市",
"861322471", "内蒙古包头市",
"861558640", "湖北省襄樊市",
"86132447", "广东省深圳市",
"861550605", "吉林省长春市",
"861345894", "四川省乐山市",
"861302421", "浙江省嘉兴市",
"861516072", "福建省厦门市",
"861309950", "宁夏银川市",
"861320565", "安徽省马鞍山市",
"861893204", "贵州省黔南布依族苗族自治州",
"86189745", "湖南省怀化市",
"861333985", "湖北省十堰市",
"861390068", "浙江省嘉兴市",
"86837", "四川省阿坝藏族羌族自治州",
"861323764", "江西省南昌市",
"861867795", "广西南宁市",
"861317572", "浙江省衢州市",
"8613996", "重庆市",
"861888140", "四川省内江市",
"861899948", "新疆塔城地区",
"861839976", "新疆乌鲁木齐市",
"861770318", "河北省衡水市",
"861777162", "湖北省荆州市",
"861300342", "江苏省南京市",
"861890528", "江苏省镇江市",
"861893370", "广东省韶关市",
"861386828", "浙江省湖州市",
"861458558", "山东省日照市",
"861855441", "山东省菏泽市",
"861800075", "江西省宜春市",
"861579732", "湖北省宜昌市",
"861800389", "河南省焦作市",
"861370783", "广西桂林市",
"861340187", "江苏省宿迁市",
"861390278", "广东省梅州市",
"861821848", "广东省潮州市",
"861588253", "四川省遂宁市",
"861814884", "广东省云浮市",
"861554082", "内蒙古兴安盟",
"861889398", "甘肃省天水市",
"86136228", "广东省广州市",
"861330649", "山东省滨州市",
"861471468", "广东省江门市",
"861364417", "辽宁省营口市",
"861478727", "云南省普洱市",
"861879421", "甘肃省兰州市",
"861860977", "青海省海西蒙古族藏族自治州",
"861569029", "河北省沧州市",
"86180210", "上海市",
"861380793", "江西省上饶市",
"861378101", "河南省三门峡市",
"861454715", "浙江省绍兴市",
"861589152", "陕西省商洛市",
"861527280", "湖北省孝感市",
"861840814", "四川省广安市",
"861376642", "江西省宜春市",
"861317403", "江苏省盐城市",
"86152831", "四川省宜宾市",
"861860467", "黑龙江省鸡西市",
"86155475", "内蒙古通辽市",
"86132599", "陕西省西安市",
"861863401", "河北省唐山市",
"861479785", "江西省宜春市",
"861351782", "广西柳州市",
"861590637", "山东省枣庄市",
"861853070", "河南省新乡市",
"861511224", "广东省广州市",
"861454307", "黑龙江省哈尔滨市",
"86150389", "河南省许昌市",
"861512891", "河北省邯郸市",
"861859652", "福建省泉州市",
"861785837", "浙江省湖州市",
"86151489", "内蒙古兴安盟",
"861572074", "江苏省南通市",
"86189382", "广东省东莞市",
"86135779", "云南省普洱市",
"861533391", "河南省焦作市",
"861380487", "黑龙江省七台河市",
"861508989", "广东省广州市",
"86155700", "江西省赣州市",
"861871830", "广东省韶关市",
"861565989", "福建省福州市",
"861588424", "四川省资阳市",
"86152666", "山东省临沂市",
"861839466", "甘肃省兰州市",
"86151586", "浙江省温州市",
"861563351", "河北省衡水市",
"861847638", "广东省湛江市",
"861894738", "内蒙古巴彦淖尔市",
"861591121", "云南省大理白族自治州",
"861876286", "江苏省苏州市",
"861786451", "山东省枣庄市",
"861885033", "福建省厦门市",
"861534806", "甘肃省张掖市",
"861593323", "河北省保定市",
"861814393", "河南省濮阳市",
"86182762", "广西柳州市",
"861362673", "浙江省嘉兴市",
"861853260", "河北省廊坊市",
"861556199", "黑龙江省鸡西市",
"861370497", "辽宁省营口市",
"86135650", "新疆巴音郭楞蒙古自治州",
"861876689", "山东省潍坊市",
"861373799", "广西河池市",
"861332470", "广西防城港市",
"86136312", "广东省珠海市",
"861780336", "河北省廊坊市",
"86132496", "广东省广州市",
"861570860", "贵州省贵阳市",
"86139135", "江苏省苏州市",
"861787633", "广东省肇庆市",
"861563685", "黑龙江省鸡西市",
"861526583", "山东省日照市",
"861563366", "河北省石家庄市",
"861869491", "江苏省苏州市",
"861707767", "云南省玉溪市",
"861869933", "新疆石河子市",
"86138222", "广东省广州市",
"86147553", "安徽省芜湖市",
"861839451", "甘肃省兰州市",
"861515252", "江苏省徐州市",
"861347646", "湖北省鄂州市",
"861334778", "江苏省泰州市",
"861340343", "山西省太原市",
"86137846", "河北省唐山市",
"861598417", "四川省自贡市",
"861372303", "河南省南阳市",
"861592247", "安徽省宿州市",
"861323331", "山西省晋城市",
"861311631", "贵州省贵阳市",
"861589089", "河南省南阳市",
"861567778", "广西钦州市",
"861820525", "江苏省扬州市",
"86134348", "广东省佛山市",
"861803774", "河南省商丘市",
"861800575", "浙江省绍兴市",
"861390568", "安徽省阜阳市",
"861317072", "云南省曲靖市",
"861786466", "山东省莱芜市",
"861892430", "广东省广州市",
"861508801", "广东省佛山市",
"861336281", "浙江省舟山市",
"86145093", "江苏省无锡市",
"861328344", "河北省邯郸市",
"861781769", "广东省东莞市",
"861346527", "山东省东营市",
"861317262", "广东省肇庆市",
"86159928", "广东省东莞市",
"861580962", "宁夏石嘴山市",
"861768852", "广东省江门市",
"861539301", "甘肃省临夏回族自治州",
"861528442", "云南省玉溪市",
"861320275", "广东省肇庆市",
"861576765", "广东省广州市",
"861509137", "陕西省西安市",
"86159542", "山东省青岛市",
"861569529", "江苏省南京市",
"861321457", "黑龙江省大兴安岭地区",
"861379461", "广东省佛山市",
"861535208", "甘肃省庆阳市",
"861353694", "广东省汕头市",
"86186849", "湖南省长沙市",
"861336417", "辽宁省营口市",
"86187793", "江西省上饶市",
"86188257", "广东省东莞市",
"861898755", "云南省昆明市",
"861884571", "黑龙江省大兴安岭地区",
"861560949", "甘肃省白银市",
"86181819", "四川省成都市",
"861379971", "福建省漳州市",
"861850481", "内蒙古呼和浩特市",
"861368382", "河南省郑州市",
"861363729", "安徽省合肥市",
"861505484", "山东省潍坊市",
"861360427", "辽宁省盘锦市",
"86155679", "吉林省白城市",
"861573509", "山西省忻州市",
"861886612", "山东省济南市",
"861568484", "新疆伊犁哈萨克自治州",
"861860831", "四川省宜宾市",
"861373032", "河北省张家口市",
"861572574", "山东省淄博市",
"861380374", "河南省许昌市",
"86152565", "安徽省合肥市",
"86138318", "河北省衡水市",
"861556112", "内蒙古鄂尔多斯市",
"86151685", "浙江省宁波市",
"861818712", "云南省昆明市",
"861573817", "河南省平顶山市",
"86158164", "广东省惠州市",
"861517900", "江西省上饶市",
"861818032", "四川省内江市",
"861388245", "四川省凉山彝族自治州",
"861529300", "甘肃省临夏回族自治州",
"861580472", "内蒙古包头市",
"861700495", "北京市",
"861477328", "湖南省永州市",
"861894518", "黑龙江省双鸭山市",
"861300160", "山东省烟台市",
"861532973", "贵州省安顺市",
"861339426", "辽宁省丹东市",
"861844938", "新疆昌吉回族自治州",
"861332636", "山东省潍坊市",
"861500786", "广西百色市",
"86155750", "湖南省岳阳市",
"861352329", "河南省许昌市",
"861863410", "河北省邯郸市",
"861316911", "广东省湛江市",
"861332239", "辽宁省葫芦岛市",
"86130041", "上海市",
"86151261", "云南省红河哈尼族彝族自治州",
"86135600", "广东省广州市",
"861399936", "新疆昌吉回族自治州",
"86176857", "山东省青岛市",
"86132766", "江苏省南京市",
"861311445", "湖北省宜昌市",
"861514611", "黑龙江省哈尔滨市",
"861335689", "山东省青岛市",
"861829693", "江西省萍乡市",
"861345147", "河北省石家庄市",
"86180497", "上海市",
"861810996", "新疆巴音郭楞蒙古自治州",
"861868349", "四川省凉山彝族自治州",
"86186316", "河北省廊坊市",
"861867257", "湖北省荆州市",
"861322720", "湖北省咸宁市",
"861888610", "贵州省贵阳市",
"861527164", "湖北省黄冈市",
"861593332", "河北省保定市",
"861369472", "内蒙古包头市",
"861569200", "广东省广州市",
"861311726", "湖北省随州市",
"861378928", "湖南省怀化市",
"861813928", "新疆石河子市",
"861320418", "辽宁省阜新市",
"861527695", "新疆喀什地区",
"861594998", "山东省日照市",
"861705528", "四川省成都市",
"86155846", "吉林省延边朝鲜族自治州",
"861585287", "江苏省扬州市",
"861768528", "贵州省六盘水市",
"861787622", "广东省深圳市",
"861393434", "山西省临汾市",
"861536441", "湖南省湘西土家族苗族自治州",
"861550873", "云南省红河哈尼族彝族自治州",
"861820084", "广东省河源市",
"861816030", "新疆喀什地区",
"861575297", "云南省昆明市",
"861339745", "湖南省怀化市",
"861452270", "山西省忻州市",
"861558110", "湖南省常德市",
"861333924", "安徽省宣城市",
"861365549", "山东省临沂市",
"86139944", "山西省大同市",
"861328282", "浙江省杭州市",
"861384739", "内蒙古包头市",
"861452304", "河南省安阳市",
"861308549", "湖南省娄底市",
"861333053", "云南省昆明市",
"861324655", "广东省佛山市",
"861528567", "贵州省毕节地区",
"861854801", "内蒙古巴彦淖尔市",
"861325154", "黑龙江省佳木斯市",
"86139421", "辽宁省朝阳市",
"861372766", "广东省汕头市",
"86147737", "湖南省益阳市",
"861822419", "四川省雅安市",
"861538698", "山西省吕梁市",
"861398441", "贵州省贵阳市",
"861471515", "广东省东莞市",
"861823875", "河南省新乡市",
"861572180", "云南省曲靖市",
"861568658", "陕西省铜川市",
"861329886", "吉林省通化市",
"861505658", "安徽省合肥市",
"861318063", "吉林省四平市",
"861356765", "浙江省舟山市",
"861853396", "河北省邯郸市",
"861381473", "江苏省南通市",
"861778098", "四川省达州市",
"861559709", "青海省海南藏族自治州",
"861453085", "安徽省蚌埠市",
"861853184", "河北省廊坊市",
"861479724", "山西省大同市",
"86181984", "广东省惠州市",
"861333838", "福建省龙岩市",
"86159123", "云南省文山壮族苗族自治州",
"861306537", "辽宁省辽阳市",
"861586416", "山东省德州市",
"86187368", "河南省商丘市",
"861511369", "广东省肇庆市",
"861881554", "安徽省淮南市",
"861595478", "山东省济南市",
"861535446", "河北省唐山市",
"86155319", "河北省邢台市",
"861523669", "河南省洛阳市",
"861579723", "湖北省恩施土家族苗族自治州",
"861357642", "江西省景德镇市",
"861810339", "河北省邢台市",
"861763316", "河北省廊坊市",
"861512749", "河北省保定市",
"861877446", "湖南省娄底市",
"861303647", "四川省达州市",
"86170733", "河北省唐山市",
"86184866", "贵州省六盘水市",
"861369503", "福建省厦门市",
"86138678", "浙江省宁波市",
"861378834", "广西梧州市",
"861880676", "浙江省台州市",
"861889982", "广东省江门市",
"861779903", "新疆和田地区",
"861833387", "河北省唐山市",
"861880069", "江苏省无锡市",
"861526440", "山东省菏泽市",
"861477820", "广东省梅州市",
"861389949", "新疆克孜勒苏柯尔克孜自治州",
"861506899", "浙江省绍兴市",
"86137750", "江苏省常州市",
"861380529", "江苏省镇江市",
"86189007", "湖南省长沙市",
"86156772", "广西柳州市",
"861334935", "黑龙江省绥化市",
"861530744", "湖南省张家界市",
"861341444", "广东省东莞市",
"861533545", "山东省烟台市",
"861332721", "湖南省长沙市",
"861826237", "江苏省盐城市",
"861824468", "河北省唐山市",
"86184631", "山东省威海市",
"861369962", "四川省绵阳市",
"86158787", "广西南宁市",
"861360375", "河南省平顶山市",
"861342867", "广东省深圳市",
"861865159", "江苏省盐城市",
"86155897", "山东省济宁市",
"861312338", "福建省厦门市",
"861362414", "辽宁省本溪市",
"86186676", "浙江省台州市",
"861302992", "黑龙江省绥化市",
"861319681", "江苏省徐州市",
"861780912", "陕西省榆林市",
"861571872", "云南省大理白族自治州",
"861319172", "河北省邯郸市",
"861818841", "四川省绵阳市",
"861355755", "广西玉林市",
"861452439", "辽宁省阜新市",
"861524995", "安徽省阜阳市",
"861705028", "江苏省南京市",
"86155910", "陕西省咸阳市",
"861813640", "江苏省苏州市",
"861392200", "广东省阳江市",
"861334380", "河南省新乡市",
"861390415", "辽宁省丹东市",
"861459629", "甘肃省张掖市",
"861384807", "内蒙古呼伦贝尔市",
"861768028", "湖南省衡阳市",
"86133003", "天津市",
"861873902", "河南省南阳市",
"861584702", "内蒙古呼伦贝尔市",
"861370605", "福建省莆田市",
"861804640", "福建省福州市",
"86133071", "湖北省武汉市",
"861319355", "河南省濮阳市",
"86855", "贵州省黔东南苗族侗族自治州",
"861773431", "河北省邯郸市",
"861308049", "河北省保定市",
"861333553", "安徽省芜湖市",
"861347758", "湖北省荆门市",
"861530486", "黑龙江省大庆市",
"861528067", "福建省宁德市",
"86188960", "重庆市",
"861510736", "湖南省常德市",
"861812346", "四川省成都市",
"861820584", "浙江省宁波市",
"861360152", "江苏省无锡市",
"861309726", "江西省九江市",
"861326695", "广东省东莞市",
"86150521", "江苏省无锡市",
"861846442", "山东省聊城市",
"861506668", "山东省济南市",
"861329776", "广西百色市",
"861300284", "四川省遂宁市",
"861840697", "云南省保山市",
"861314865", "广东省云浮市",
"861359732", "广西桂林市",
"861517429", "辽宁省葫芦岛市",
"861550783", "广西桂林市",
"861508227", "四川省凉山彝族自治州",
"861778173", "四川省广安市",
"86157105", "辽宁省沈阳市",
"861873563", "山西省晋城市",
"861452560", "贵州省黔南布依族苗族自治州",
"861475649", "河北省邢台市",
"86138413", "辽宁省抚顺市",
"861760755", "广东省深圳市",
"861303865", "云南省玉溪市",
"861816701", "浙江省金华市",
"861315332", "山东省枣庄市",
"861816469", "云南省楚雄彝族自治州",
"861856725", "河南省南阳市",
"861535784", "安徽省阜阳市",
"861368998", "新疆克拉玛依市",
"861848583", "贵州省毕节地区",
"861386552", "安徽省蚌埠市",
"861569487", "河北省石家庄市",
"861338958", "宁夏银川市",
"861890852", "贵州省遵义市",
"861558101", "湖南省长沙市",
"86147192", "甘肃省平凉市",
"861508318", "河南省周口市",
"861518125", "四川省攀枝花市",
"861344008", "四川省遂宁市",
"86183579", "浙江省金华市",
"861880430", "吉林省长春市",
"861360589", "浙江省金华市",
"861565134", "江苏省徐州市",
"861518070", "贵州省贵阳市",
"861306037", "陕西省西安市",
"861519187", "陕西省宝鸡市",
"861556642", "辽宁省鞍山市",
"861334129", "山东省潍坊市",
"861816979", "广西北海市",
"861577112", "湖北省孝感市",
"861533250", "陕西省汉中市",
"86158778", "云南省曲靖市",
"861825044", "福建省泉州市",
"86180875", "云南省保山市",
"86137475", "内蒙古通辽市",
"86186575", "浙江省绍兴市",
"861571782", "湖北省荆门市",
"861810404", "辽宁省本溪市",
"861780999", "新疆伊犁哈萨克自治州",
"86134862", "浙江省台州市",
"861302919", "吉林省通化市",
"861317947", "江苏省镇江市",
"861532359", "广东省肇庆市",
"86139022", "广东省广州市",
"861567129", "湖北省襄樊市",
"861553532", "山西省阳泉市",
"861835112", "江苏省苏州市",
"861709988", "广东省深圳市",
"861330408", "辽宁省大连市",
"861538869", "陕西省咸阳市",
"861521905", "广东省肇庆市",
"86157779", "广西北海市",
"86137700", "江苏省盐城市",
"861504859", "内蒙古巴彦淖尔市",
"861301681", "江苏省镇江市",
"861569793", "江西省上饶市",
"861310452", "黑龙江省齐齐哈尔市",
"861380029", "陕西省西安市",
"861514141", "辽宁省本溪市",
"861301172", "山东省济南市",
"86151214", "贵州省黔东南苗族侗族自治州",
"861337635", "山东省聊城市",
"861880569", "安徽省合肥市",
"861510354", "山西省晋中市",
"861893596", "新疆塔城地区",
"861503141", "河北省沧州市",
"861862588", "河南省焦作市",
"86152059", "福建省莆田市",
"861320109", "新疆石河子市",
"861831341", "云南省玉溪市",
"861513859", "河南省商丘市",
"861342993", "湖北省孝感市",
"861324428", "吉林省松原市",
"861592962", "陕西省西安市",
"86183476", "内蒙古赤峰市",
"86132238", "河南省驻马店市",
"861779062", "黑龙江省齐齐哈尔市",
"861304478", "河南省开封市",
"861581539", "广东省惠州市",
"861833143", "河北省承德市",
"861869922", "新疆伊犁哈萨克自治州",
"861809751", "新疆阿勒泰地区",
"861518260", "四川省自贡市",
"861550497", "辽宁省营口市",
"861860542", "山东省聊城市",
"861894465", "黑龙江省哈尔滨市",
"861599414", "河南省安阳市",
"861313478", "内蒙古巴彦淖尔市",
"86157650", "黑龙江省齐齐哈尔市",
"861476241", "江苏省淮安市",
"861859306", "甘肃省白银市",
"861350860", "湖北省宜昌市",
"86136672", "湖北省武汉市",
"861800918", "陕西省西安市",
"861800525", "江苏省扬州市",
"861769843", "河南省商丘市",
"861803724", "河南省周口市",
"86134159", "广东省东莞市",
"861529690", "宁夏银川市",
"861339966", "安徽省池州市",
"861846227", "山东省聊城市",
"861820575", "浙江省绍兴市",
"861370823", "四川省成都市",
"861302956", "内蒙古包头市",
"861300065", "山东省潍坊市",
"86185125", "江苏省南京市",
"861317022", "安徽省蚌埠市",
"861767908", "江西省南昌市",
"86152980", "四川省乐山市",
"861854567", "黑龙江省黑河市",
"861773730", "河南省郑州市",
"861567205", "湖北省恩施土家族苗族自治州",
"861809945", "新疆巴音郭楞蒙古自治州",
"861520098", "湖南省永州市",
"861506583", "山东省泰安市",
"86138227", "广东省中山市",
"86131233", "福建省漳州市",
"861576008", "四川省宜宾市",
"861533610", "陕西省咸阳市",
"861870997", "新疆阿克苏地区",
"861334728", "湖南省娄底市",
"861392269", "广东省汕尾市",
"861356864", "四川省攀枝花市",
"861303331", "云南省普洱市",
"861337740", "广西来宾市",
"861452817", "四川省南充市",
"861770567", "安徽省阜阳市",
"861569579", "浙江省金华市",
"861356946", "河南省许昌市",
"861829303", "甘肃省临夏回族自治州",
"861376798", "江西省南昌市",
"861310177", "河南省南阳市",
"861535775", "安徽省马鞍山市",
"861585469", "山东省枣庄市",
"861847549", "广东省茂名市",
"861869047", "陕西省榆林市",
"861318688", "浙江省宁波市",
"86188252", "广东省深圳市",
"861453574", "福建省厦门市",
"86133383", "福建省漳州市",
"86182549", "山东省临沂市",
"861360967", "广东省东莞市",
"861591238", "云南省玉溪市",
"861890268", "广东省汕尾市",
"861320708", "江西省南昌市",
"861365344", "山西省运城市",
"861843602", "河南省驻马店市",
"861504816", "内蒙古包头市",
"861452509", "山东省威海市",
"861320225", "广东省深圳市",
"861855597", "安徽省宣城市",
"861513816", "河南省三门峡市",
"861339844", "四川省广元市",
"861300275", "山东省烟台市",
"861346577", "山东省济宁市",
"861762545", "江苏省盐城市",
"861879956", "新疆和田地区",
"86159190", "广东省佛山市",
"86156865", "陕西省汉中市",
"861529224", "湖南省株洲市",
"861380324", "河北省秦皇岛市",
"861778132", "四川省宜宾市",
"86150565", "安徽省滁州市",
"861362704", "江西省赣州市",
"861359773", "湖北省黄石市",
"861571558", "安徽省阜阳市",
"861580422", "辽宁省辽阳市",
"86157643", "吉林省长春市",
"861776814", "江苏省南京市",
"861509300", "河南省南阳市",
"861850378", "河南省开封市",
"8613530", "广东省深圳市",
"861372693", "广东省湛江市",
"861379921", "福建省泉州市",
"86159596", "福建省漳州市",
"861760941", "甘肃省甘南藏族自治州",
"86158434", "吉林省四平市",
"861880731", "湖南省长沙市",
"861360477", "内蒙古鄂尔多斯市",
"861370541", "山东省济南市",
"861471640", "广东省广州市",
"861350809", "四川省南充市",
"861779091", "辽宁省大连市",
"861518606", "贵州省毕节地区",
"861772654", "四川省德阳市",
"861361040", "广东省惠州市",
"861881359", "广东省汕尾市",
"86130766", "广东省清远市",
"861518209", "四川省巴中市",
"861351822", "四川省乐山市",
"86182497", "黑龙江省哈尔滨市",
"861330538", "山东省泰安市",
"861862752", "湖南省岳阳市",
"86180492", "陕西省西安市",
"861327741", "湖北省黄冈市",
"861832460", "黑龙江省哈尔滨市",
"861804015", "辽宁省朝阳市",
"861532923", "贵州省安顺市",
"861339476", "内蒙古赤峰市",
"861399448", "山西省阳泉市",
"861399594", "湖北省黄冈市",
"861378735", "湖南省郴州市",
"861511311", "广东省汕头市",
"86139795", "江西省宜春市",
"861880500", "福建省福州市",
"861826580", "山东省菏泽市",
"861786926", "云南省丽江市",
"861355941", "福建省泉州市",
"861813735", "河南省濮阳市",
"861520786", "广西百色市",
"86189378", "河南省开封市",
"86139669", "安徽省安庆市",
"861810534", "山东省德州市",
"861569930", "新疆昌吉回族自治州",
"861352379", "河南省洛阳市",
"861836081", "江苏省无锡市",
"861839926", "新疆和田地区",
"861760854", "贵州省黔南布依族苗族自治州",
"861300565", "广东省阳江市",
"861317522", "浙江省湖州市",
"861870863", "贵州省铜仁地区",
"861877885", "广西桂林市",
"861375581", "江西省赣州市",
"86186258", "河南省安阳市",
"861800025", "江西省宜春市",
"861816411", "湖北省武汉市",
"861471834", "广东省河源市",
"861363910", "贵州省贵阳市",
"861806185", "江苏省南京市",
"861589242", "四川省达州市",
"861320342", "山西省大同市",
"861536740", "湖南省岳阳市",
"861454697", "广东省湛江市",
"861820075", "广东省惠州市",
"861893320", "广东省珠海市",
"861890578", "浙江省丽水市",
"861830546", "山东省东营市",
"861512148", "贵州省毕节地区",
"861314764", "吉林省长春市",
"861816287", "湖北省黄冈市",
"861858995", "广西柳州市",
"861569385", "甘肃省兰州市",
"861893552", "青海省海东地区",
"861341132", "广东省阳江市",
"861319133", "内蒙古呼伦贝尔市",
"861347082", "安徽省宿州市",
"861310496", "广东省肇庆市",
"861571833", "广东省东莞市",
"861586459", "山东省潍坊市",
"861535885", "江苏省扬州市",
"861510182", "甘肃省定西市",
"861322421", "辽宁省朝阳市",
"861329950", "宁夏银川市",
"86187847", "四川省南充市",
"861329631", "山东省威海市",
"861350981", "广东省东莞市",
"861879471", "甘肃省酒泉市",
"86132863", "广东省中山市",
"861478777", "云南省玉溪市",
"861884021", "陕西省延安市",
"86188202", "广东省深圳市",
"861853175", "河北省唐山市",
"861559760", "青海省玉树藏族自治州",
"861390317", "河北省沧州市",
"861865116", "江苏省泰州市",
"861569079", "河南省新乡市",
"861860927", "陕西省宝鸡市",
"861454130", "河北省邯郸市",
"861355854", "四川省达州市",
"86138256", "广东省珠海市",
"86157036", "内蒙古赤峰市",
"86187133", "河北省张家口市",
"861557946", "江西省赣州市",
"861360893", "山东省济南市",
"86170998", "广东省汕头市",
"86133040", "辽宁省沈阳市",
"861801848", "江苏省徐州市",
"861882915", "陕西省安康市",
"861330853", "贵州省安顺市",
"861390705", "江西省宜春市",
"861319457", "黑龙江省大兴安岭地区",
"861886309", "山东省滨州市",
"861561243", "河北省廊坊市",
"861533601", "甘肃省天水市",
"861890896", "西藏那曲地区",
"86152389", "河南省三门峡市",
"861324215", "广东省江门市",
"861856938", "湖南省永州市",
"861880364", "河南省信阳市",
"861599704", "青海省海南藏族自治州",
"861510559", "安徽省黄山市",
"86189387", "广东省中山市",
"861520876", "云南省文山壮族苗族自治州",
"861352585", "河南省三门峡市",
"861572953", "宁夏吴忠市",
"861319836", "四川省眉山市",
"861879961", "新疆博尔塔拉蒙古自治州",
"86185620", "山东省东营市",
"86156531", "山东省聊城市",
"861821957", "广东省云浮市",
"861880511", "江苏省盐城市",
"861550395", "河南省漯河市",
"861511300", "广东省佛山市",
"861863842", "河南省商丘市",
"861815416", "安徽省淮南市",
"861471928", "甘肃省白银市",
"861853020", "河南省新乡市",
"861395113", "江苏省苏州市",
"8613535", "广东省广州市",
"86153981", "安徽省阜阳市",
"861376586", "贵州省毕节地区",
"86130599", "浙江省湖州市",
"861888250", "四川省成都市",
"86136899", "新疆昌吉回族自治州",
"861836917", "山东省威海市",
"86137743", "上海市",
"861362623", "江苏省无锡市",
"861560482", "黑龙江省齐齐哈尔市",
"861369991", "新疆吐鲁番地区",
"86131396", "新疆乌鲁木齐市",
"86182767", "广西柳州市",
"861899857", "广东省肇庆市",
"861369433", "吉林省延边朝鲜族自治州",
"86159695", "云南省昆明市",
"86180762", "贵州省遵义市",
"861779591", "陕西省西安市",
"86159769", "广东省珠海市",
"861302961", "新疆石河子市",
"861360384", "河南省郑州市",
"86136317", "广东省东莞市",
"861588143", "四川省绵阳市",
"861478346", "河南省南阳市",
"861332420", "辽宁省大连市",
"86176802", "湖南省长沙市",
"861339951", "安徽省合肥市",
"861361540", "山东省菏泽市",
"861330156", "江苏省苏州市",
"861339630", "山东省威海市",
"86130496", "广东省广州市",
"861822456", "河南省新乡市",
"861768915", "西藏昌都地区",
"86184398", "河南省郑州市",
"861588474", "四川省宜宾市",
"861839313", "甘肃省陇南市",
"861810034", "山西省太原市",
"861531528", "山东省泰安市",
"861562448", "山东省淄博市",
"861810714", "湖北省黄石市",
"861568218", "四川省南充市",
"861858643", "贵州省安顺市",
"861550832", "四川省资阳市",
"861811450", "江苏省无锡市",
"861393142", "河北省承德市",
"861591171", "云南省昆明市",
"861350737", "湖南省益阳市",
"861509564", "甘肃省张掖市",
"861526741", "浙江省金华市",
"86139465", "黑龙江省七台河市",
"861808813", "云南省昆明市",
"861350017", "广东省惠州市",
"861312554", "辽宁省本溪市",
"861870569", "安徽省合肥市",
"86130717", "河南省平顶山市",
"861324391", "辽宁省锦州市",
"861786535", "山东省烟台市",
"86132712", "河南省许昌市",
"861558322", "四川省内江市",
"861550487", "内蒙古鄂尔多斯市",
"861840750", "广东省江门市",
"861505906", "福建省龙岩市",
"861311528", "江苏省常州市",
"861358424", "江苏省无锡市",
"86186362", "山西省晋中市",
"861519630", "四川省甘孜藏族自治州",
"861501476", "广东省东莞市",
"861360732", "湖南省湘潭市",
"861459337", "四川省内江市",
"861331064", "山东省日照市",
"861301691", "江苏省连云港市",
"861300620", "江西省南昌市",
"861519951", "新疆阿勒泰地区",
"86158650", "山东省菏泽市",
"861569783", "江西省上饶市",
"861512420", "辽宁省营口市",
"861809568", "安徽省宿州市",
"861360012", "广东省潮州市",
"861320670", "黑龙江省黑河市",
"861318811", "辽宁省锦州市",
"861329078", "福建省厦门市",
"861862444", "辽宁省大连市",
"861571539", "山东省临沂市",
"861510038", "河北省衡水市",
"861893586", "新疆伊犁哈萨克自治州",
"861862598", "河南省洛阳市",
"861558550", "吉林省白城市",
"86153396", "安徽省六安市",
"86138475", "内蒙古通辽市",
"861562265", "广东省云浮市",
"86157111", "北京市",
"861331274", "云南省大理白族自治州",
"861359152", "辽宁省丹东市",
"861871923", "广东省阳江市",
"861870430", "吉林省长春市",
"86151895", "江苏省淮安市",
"861372568", "广东省河源市",
"861587112", "湖北省十堰市",
"861709998", "广东省深圳市",
"861331300", "河北省邯郸市",
"861470612", "江苏省常州市",
"861812502", "广东省茂名市",
"86157778", "广西河池市",
"861539836", "云南省昭通市",
"861360599", "福建省三明市",
"861502977", "陕西省汉中市",
"861881338", "广东省东莞市",
"861519197", "陕西省西安市",
"861397209", "湖北省襄樊市",
"86156010", "北京市",
"861571460", "黑龙江省哈尔滨市",
"861803617", "江苏省南通市",
"861377416", "湖北省襄樊市",
"86158779", "云南省昆明市",
"861563280", "河北省唐山市",
"861770999", "新疆伊犁哈萨克自治州",
"861390303", "广东省东莞市",
"861814617", "福建省龙岩市",
"861330559", "安徽省黄山市",
"861853847", "河南省洛阳市",
"861571792", "江西省九江市",
"861895485", "山东省泰安市",
"86147356", "山西省晋城市",
"86137413", "辽宁省抚顺市",
"861310667", "广东省佛山市",
"86180813", "四川省乐山市",
"861353625", "广东省惠州市",
"861322449", "吉林省白山市",
"86186513", "江苏省南通市",
"861571970", "青海省海北藏族自治州",
"861539457", "福建省三明市",
"861368988", "吉林省吉林市",
"861510853", "贵州省安顺市",
"861335360", "河南省商丘市",
"86189424", "广东省佛山市",
"861569497", "河北省沧州市",
"861867603", "广东省中山市",
"861304601", "山东省济南市",
"861369860", "山东省济南市",
"861551614", "河南省濮阳市",
"861862876", "吉林省四平市",
"861550793", "江西省上饶市",
"861454466", "陕西省宝鸡市",
"861387438", "湖南省永州市",
"861590574", "浙江省宁波市",
"861857868", "广东省揭阳市",
"861388640", "湖北省黄冈市",
"861817581", "湖南省怀化市",
"861347314", "河北省承德市",
"861315885", "四川省乐山市",
"861341796", "广东省云浮市",
"861889880", "广东省佛山市",
"86139583", "浙江省宁波市",
"861530496", "辽宁省本溪市",
"861539133", "云南省昆明市",
"861336022", "广东省江门市",
"861330671", "浙江省杭州市",
"861364522", "江苏省徐州市",
"861560456", "黑龙江省黑河市",
"861815008", "福建省厦门市",
"861350003", "广东省广州市",
"861899160", "陕西省汉中市",
"861774922", "陕西省西安市",
"861306413", "江西省南昌市",
"861534764", "广东省潮州市",
"86187960", "江苏省镇江市",
"861332148", "吉林省松原市",
"861392176", "江苏省徐州市",
"861591656", "广东省佛山市",
"861597688", "广东省深圳市",
"861839715", "青海省海东地区",
"861316740", "湖南省株洲市",
"861334390", "河南省平顶山市",
"861347561", "山东省淄博市",
"861335004", "四川省德阳市",
"861470868", "贵州省安顺市",
"861800936", "甘肃省张掖市",
"861884049", "陕西省渭南市",
"861364350", "山西省忻州市",
"861879890", "西藏拉萨市",
"86138750", "湖南省常德市",
"86183587", "浙江省温州市",
"861370529", "江苏省镇江市",
"861587199", "湖北省荆门市",
"861890631", "山东省威海市",
"861560461", "黑龙江省哈尔滨市",
"861560709", "江西省新余市",
"861326351", "黑龙江省哈尔滨市",
"86182716", "湖北省黄石市",
"861811568", "江苏省苏州市",
"861870069", "陕西省铜川市",
"861331311", "河北省石家庄市",
"861760929", "陕西省铜川市",
"861320436", "吉林省白城市",
"861302982", "黑龙江省大庆市",
"861519476", "河北省保定市",
"861501630", "广东省汕尾市",
"86136366", "上海市",
"861379949", "福建省泉州市",
"861800660", "浙江省嘉兴市",
"86150617", "江苏省无锡市",
"861329578", "浙江省丽水市",
"861372278", "河北省石家庄市",
"86152008", "湖南省长沙市",
"861510538", "山东省泰安市",
"861558050", "湖南省湘西土家族苗族自治州",
"861831953", "广东省湛江市",
"861309528", "云南省楚雄彝族自治州",
"86152612", "江苏省宿迁市",
"861770912", "陕西省榆林市",
"861812897", "广东省阳江市",
"861341588", "广东省东莞市",
"861331564", "河北省廊坊市",
"86158600", "福建省莆田市",
"861577189", "陕西省铜川市",
"86157787", "广西钦州市",
"861708472", "内蒙古呼和浩特市",
"861588495", "四川省巴中市",
"861524330", "河北省廊坊市",
"861360512", "江苏省连云港市",
"861569873", "辽宁省阜新市",
"861843244", "河北省石家庄市",
"861806747", "浙江省温州市",
"86138679", "浙江省金华市",
"861372068", "陕西省榆林市",
"861871554", "安徽省淮南市",
"861597232", "湖北省孝感市",
"861812002", "江苏省徐州市",
"861829705", "青海省海南藏族自治州",
"861355929", "福建省漳州市",
"861325734", "湖南省衡阳市",
"861535373", "陕西省西安市",
"861596606", "山东省济南市",
"861353458", "广东省佛山市",
"861325014", "广东省佛山市",
"861327729", "湖北省襄樊市",
"86135164", "安徽省六安市",
"861558245", "山西省长治市",
"861868371", "四川省成都市",
"861350472", "吉林省延边朝鲜族自治州",
"861550200", "广东省深圳市",
"861802949", "广东省云浮市",
"861360099", "福建省龙岩市",
"861454451", "江西省南昌市",
"861310845", "四川省遂宁市",
"86187369", "河南省开封市",
"861335142", "黑龙江省齐齐哈尔市",
"86137678", "江西省景德镇市",
"861787848", "广西柳州市",
"861550374", "河南省许昌市",
"86155318", "河北省衡水市",
"861357934", "新疆喀什地区",
"861598350", "四川省雅安市",
"861375903", "云南省普洱市",
"861810627", "江苏省南通市",
"8615928", "四川省成都市",
"861891234", "江苏省常州市",
"861778088", "四川省眉山市",
"861333816", "江苏省常州市",
"861453095", "山西省太原市",
"861573684", "河南省许昌市",
"861883063", "河北省廊坊市",
"86158155", "广东省深圳市",
"861869820", "辽宁省铁岭市",
"861586438", "山东省聊城市",
"861555447", "山东省威海市",
"861763338", "河北省衡水市",
"86151383", "河南省周口市",
"861889770", "广西钦州市",
"861381346", "江苏省徐州市",
"861538688", "山西省太原市",
"861473683", "云南省楚雄彝族自治州",
"861376052", "广东省江门市",
"861329896", "西藏那曲地区",
"861590264", "贵州省安顺市",
"861820094", "广东省佛山市",
"861363083", "河北省石家庄市",
"861396688", "安徽省亳州市",
"861354840", "四川省甘孜藏族自治州",
"861575287", "云南省昆明市",
"861811131", "四川省甘孜藏族自治州",
"861837411", "湖南省娄底市",
"861890445", "吉林省通化市",
"86153233", "广东省广州市",
"861878610", "贵州省贵阳市",
"861304610", "广东省汕尾市",
"861478432", "河南省许昌市",
"861534331", "湖南省长沙市",
"861806376", "福建省龙岩市",
"861336522", "江苏省泰州市",
"861520752", "广东省惠州市",
"861808739", "云南省红河哈尼族彝族自治州",
"861560971", "青海省西宁市",
"861367331", "河南省安阳市",
"861374739", "河南省周口市",
"861595601", "安徽省宿州市",
"861847521", "广东省梅州市",
"861336350", "山西省忻州市",
"861572637", "山东省枣庄市",
"861520663", "山东省日照市",
"861527685", "新疆乌鲁木齐市",
"861594988", "山东省烟台市",
"861579427", "江苏省南京市",
"861585297", "江苏省泰州市",
"861847146", "湖北省荆州市",
"861366390", "河南省新乡市",
"861507413", "湖南省长沙市",
"861320857", "贵州省毕节地区",
"861312316", "福建省福州市",
"86181500", "福建省福州市",
"86184399", "河南省郑州市",
"861359893", "河南省驻马店市",
"861593446", "山西省运城市",
"861533478", "内蒙古巴彦淖尔市",
"86182044", "吉林省松原市",
"861811683", "新疆博尔塔拉蒙古自治州",
"861810358", "山西省吕梁市",
"861338260", "江苏省盐城市",
"861840976", "青海省海北藏族自治州",
"86185786", "广东省广州市",
"861478473", "内蒙古鄂尔多斯市",
"861348842", "陕西省渭南市",
"861325319", "河北省承德市",
"861457000", "山东省菏泽市",
"861800609", "福建省南平市",
"861334526", "山东省潍坊市",
"861850547", "山东省济宁市",
"861378372", "河南省安阳市",
"861842040", "广东省东莞市",
"861333859", "福建省泉州市",
"861500914", "陕西省商洛市",
"861319753", "广西贺州市",
"861560492", "辽宁省鞍山市",
"861804372", "吉林省吉林市",
"86147086", "贵州省遵义市",
"861478144", "四川省广元市",
"861899418", "江苏省南通市",
"861304045", "新疆巴音郭楞蒙古自治州",
"861330354", "山西省晋中市",
"86155682", "吉林省吉林市",
"861319662", "江苏省苏州市",
"861360394", "河南省周口市",
"861363899", "西藏拉萨市",
"861530452", "黑龙江省齐齐哈尔市",
"861859927", "新疆阿克苏地区",
"861550666", "山东省烟台市",
"861476229", "江苏省淮安市",
"861510408", "辽宁省大连市",
"861318869", "辽宁省铁岭市",
"861302608", "安徽省马鞍山市",
"861507290", "湖北省十堰市",
"861582953", "陕西省西安市",
"861454750", "浙江省台州市",
"861808056", "四川省成都市",
"861312359", "广西北海市",
"861550269", "辽宁省葫芦岛市",
"86130598", "浙江省舟山市",
"861537947", "甘肃省武威市",
"861566647", "山东省东营市",
"861808138", "四川省宜宾市",
"861760353", "山西省阳泉市",
"86136898", "吉林省长春市",
"861364947", "广西南宁市",
"861831329", "云南省普洱市",
"86152388", "河南省周口市",
"861890886", "云南省怒江傈僳族自治州",
"861563537", "山西省太原市",
"8615962", "江苏省苏州市",
"86184817", "四川省南充市",
"861571334", "河北省承德市",
"861452625", "江苏省南通市",
"861889961", "新疆石河子市",
"861459435", "西藏昌都地区",
"861870511", "江苏省盐城市",
"861320506", "福建省泉州市",
"861380041", "辽宁省铁岭市",
"861338070", "广东省清远市",
"861893199", "河北省石家庄市",
"861597273", "湖北省荆州市",
"861820399", "河南省郑州市",
"861707554", "安徽省芜湖市",
"861360883", "云南省红河哈尼族彝族自治州",
"861780067", "内蒙古包头市",
"861367865", "山东省烟台市",
"861335434", "吉林省四平市",
"86158036", "重庆市",
"86132926", "河北省廊坊市",
"861569832", "山西省太原市",
"861571756", "湖南省常德市",
"86189970", "青海省西宁市",
"861590379", "河南省洛阳市",
"861874021", "辽宁省辽阳市",
"861839405", "甘肃省临夏回族自治州",
"861308021", "内蒙古包头市",
"861319818", "四川省南充市",
"86187202", "江西省九江市",
"861347519", "山东省德州市",
"861535332", "陕西省铜川市",
"861350991", "广东省茂名市",
"861808314", "贵州省安顺市",
"861872915", "陕西省安康市",
"861350433", "吉林省长春市",
"861898530", "贵州省安顺市",
"861359196", "辽宁省葫芦岛市",
"861351920", "宁夏银川市",
"861815438", "湖北省黄冈市",
"861848910", "西藏拉萨市",
"861538563", "安徽省宣城市",
"861835788", "浙江省丽水市",
"86181127", "江苏省苏州市",
"861459641", "甘肃省天水市",
"861507624", "河北省唐山市",
"861816297", "湖北省宜昌市",
"861575030", "云南省普洱市",
"861508855", "浙江省温州市",
"861502289", "新疆伊犁哈萨克自治州",
"861858985", "广西玉林市",
"861569395", "甘肃省白银市",
"861387008", "江西省南昌市",
"861522542", "河南省洛阳市",
"86145864", "湖北省武汉市",
"861376878", "广西玉林市",
"861330736", "湖南省常德市",
"861347092", "安徽省淮北市",
"861310486", "广东省广州市",
"86181106", "安徽省六安市",
"861510192", "甘肃省金昌市",
"861880863", "湖北省武汉市",
"861322398", "河南省濮阳市",
"861396563", "安徽省滁州市",
"861539355", "甘肃省金昌市",
"861350157", "广东省深圳市",
"861576459", "黑龙江省大庆市",
"86151071", "湖北省武汉市",
"861503380", "河北省保定市",
"861780277", "湖北省黄冈市",
"861877895", "广西玉林市",
"86134713", "广西桂林市",
"861568236", "四川省巴中市",
"861475621", "河北省保定市",
"861520588", "浙江省丽水市",
"86186259", "河南省新乡市",
"861501745", "广东省珠海市",
"861505639", "安徽省蚌埠市",
"861898701", "云南省昭通市",
"861840466", "黑龙江省哈尔滨市",
"861898469", "贵州省黔西南布依族苗族自治州",
"861806195", "江苏省连云港市",
"86183255", "安徽省马鞍山市",
"861454687", "广东省东莞市",
"861346348", "河北省承德市",
"861596570", "山东省济宁市",
"861539681", "江苏省徐州市",
"861830748", "湖南省永州市",
"861890776", "广西百色市",
"86152377", "河南省南阳市",
"861824050", "河南省信阳市",
"86138892", "辽宁省沈阳市",
"861399584", "湖北省鄂州市",
"861301662", "广东省佛山市",
"86150372", "河南省安阳市",
"86151472", "内蒙古包头市",
"86181550", "安徽省滁州市",
"86189379", "河南省洛阳市",
"86135782", "云南省德宏傣族景颇族自治州",
"861520796", "江西省吉安市",
"861863455", "山西省长治市",
"861301753", "河南省新乡市",
"861313545", "安徽省滁州市",
"861779081", "辽宁省沈阳市",
"861776926", "湖南省永州市",
"861310744", "湖南省张家界市",
"861550579", "浙江省金华市",
"861391952", "甘肃省平凉市",
"861339343", "山西省太原市",
"861840451", "黑龙江省哈尔滨市",
"861592981", "陕西省延安市",
"861308843", "内蒙古赤峰市",
"861874843", "内蒙古乌兰察布市",
"861809683", "新疆昌吉回族自治州",
"861359967", "福建省漳州市",
"861576706", "广东省汕头市",
"861328659", "广东省清远市",
"861304545", "黑龙江省鹤岗市",
"861587586", "广东省茂名市",
"861895474", "山东省烟台市",
"861818829", "贵州省六盘水市",
"861534647", "河南省平顶山市",
"861329852", "湖南省湘潭市",
"861835596", "安徽省黄山市",
"861582524", "云南省红河哈尼族彝族自治州",
"861370324", "河北省唐山市",
"861571761", "河北省张家口市",
"861457011", "山东省临沂市",
"861571409", "辽宁省辽阳市",
"861528912", "西藏日喀则地区",
"861397260", "湖北省宜昌市",
"861595045", "江苏省南京市",
"861332749", "山西省朔州市",
"861373829", "浙江省嘉兴市",
"861525548", "安徽省阜阳市",
"861866679", "广东省肇庆市",
"861315446", "四川省绵阳市",
"861306290", "江苏省镇江市",
"861774047", "河南省商丘市",
"861363812", "贵州省铜仁地区",
"861380541", "山东省济南市",
"861870731", "湖南省长沙市",
"861338570", "浙江省衢州市",
"861504838", "内蒙古赤峰市",
"861336947", "甘肃省酒泉市",
"861700613", "江苏省南京市",
"861855900", "福建省三明市",
"861707316", "河北省唐山市",
"861382450", "广东省佛山市",
"861560419", "辽宁省辽阳市",
"861895143", "江苏省扬州市",
"861347739", "湖北省荆门市",
"861805654", "安徽省合肥市",
"861575469", "黑龙江省双鸭山市",
"861308521", "湖北省黄冈市",
"861575701", "浙江省杭州市",
"861868654", "吉林省长春市",
"86187252", "云南省保山市",
"86182922", "陕西省榆林市",
"861328571", "浙江省杭州市",
"861347019", "辽宁省盘锦市",
"861867825", "山东省枣庄市",
"861369517", "广东省佛山市",
"861365521", "江苏省徐州市",
"861707923", "浙江省嘉兴市",
"861855587", "安徽省六安市",
"861778752", "云南省保山市",
"861865061", "福建省漳州市",
"861357370", "山东省威海市",
"861783501", "山西省忻州市",
"861550930", "甘肃省临夏回族自治州",
"861536429", "湖南省郴州市",
"861890347", "山西省临汾市",
"861775921", "福建省厦门市",
"861550651", "山东省聊城市",
"861308146", "山东省聊城市",
"861301818", "四川省自贡市",
"861369809", "江西省南昌市",
"861323557", "湖北省咸宁市",
"861880151", "江苏省无锡市",
"861889956", "新疆伊犁哈萨克自治州",
"861452458", "黑龙江省伊春市",
"861376788", "江西省萍乡市",
"861335309", "广东省汕头市",
"861596939", "云南省丽江市",
"861318698", "浙江省杭州市",
"861898030", "四川省南充市",
"86182548", "山东省泰安市",
"861473068", "河北省石家庄市",
"861869378", "甘肃省兰州市",
"861814257", "四川省自贡市",
"861857252", "湖北省十堰市",
"86131102", "重庆市",
"861522042", "广东省东莞市",
"861870987", "安徽省亳州市",
"861524974", "河南省新乡市",
"861820312", "河北省保定市",
"861305602", "江苏省淮安市",
"861380823", "四川省成都市",
"861338939", "甘肃省陇南市",
"861529680", "广西桂林市",
"861899109", "陕西省榆林市",
"86130094", "辽宁省大连市",
"86183205", "广东省揭阳市",
"861866551", "广东省汕头市",
"861834051", "辽宁省葫芦岛市",
"861880997", "新疆阿克苏地区",
"86180906", "四川省凉山彝族自治州",
"861577878", "广西玉林市",
"861837530", "安徽省芜湖市",
"861360773", "广西桂林市",
"86137227", "河北省沧州市",
"861315874", "四川省广元市",
"861865271", "江苏省泰州市",
"861340426", "江苏省无锡市",
"861555345", "山东省烟台市",
"861590585", "浙江省绍兴市",
"861597563", "广东省广州市",
"861375091", "浙江省温州市",
"861309578", "浙江省丽水市",
"86152617", "江苏省淮安市",
"861515286", "江苏省宿迁市",
"861453637", "江苏省无锡市",
"861820660", "广东省汕尾市",
"861776750", "新疆阿克苏地区",
"86159174", "广东省广州市",
"861383402", "山西省大同市",
"86150612", "江苏省淮安市",
"861329528", "江苏省宿迁市",
"861526889", "浙江省台州市",
"861388468", "山东省德州市",
"86189619", "江苏省盐城市",
"861334611", "浙江省台州市",
"861340745", "湖南省怀化市",
"861708422", "云南省临沧市",
"861320948", "甘肃省嘉峪关市",
"861348700", "湖北省随州市",
"86157782", "广西柳州市",
"861829068", "新疆昌吉回族自治州",
"86159885", "浙江省金华市",
"861585941", "福建省福州市",
"861775419", "安徽省合肥市",
"861311078", "福建省福州市",
"861370579", "浙江省金华市",
"86183582", "浙江省宁波市",
"861306351", "江苏省徐州市",
"861361877", "云南省玉溪市",
"861300436", "江苏省镇江市",
"861817743", "广西梧州市",
"86187686", "贵州省六盘水市",
"86139991", "新疆乌鲁木齐市",
"861760979", "青海省海西蒙古族藏族自治州",
"861476000", "福建省厦门市",
"861521951", "广东省清远市",
"861322982", "广东省清远市",
"861521630", "山东省威海市",
"861598403", "四川省泸州市",
"861372317", "河南省焦作市",
"861453190", "山西省晋中市",
"861350422", "辽宁省葫芦岛市",
"861805488", "福建省三明市",
"861398911", "四川省内江市",
"861768886", "广东省广州市",
"861822949", "湖南省长沙市",
"86132181", "江苏省苏州市",
"861351761", "广西南宁市",
"86136689", "广东省广州市",
"861351409", "福建省福州市",
"86188720", "湖北省十堰市",
"861530234", "广东省佛山市",
"861589773", "湖北省孝感市",
"861554556", "黑龙江省哈尔滨市",
"861599298", "广东省韶关市",
"861452684", "陕西省渭南市",
"861572095", "江西省九江市",
"861583060", "河北省廊坊市",
"86135434", "广东省广州市",
"861831264", "广东省中山市",
"861809705", "青海省海东地区",
"861569823", "山东省日照市",
"861846999", "云南省普洱市",
"861532830", "四川省泸州市",
"861894759", "内蒙古呼伦贝尔市",
"861829278", "陕西省商洛市",
"861882183", "湖南省衡阳市",
"861535323", "陕西省商洛市",
"861355701", "广西南宁市",
"861338396", "河南省驻马店市",
"861472879", "贵州省黔西南布依族苗族自治州",
"861889720", "青海省西宁市",
"861760530", "山东省菏泽市",
"861516417", "辽宁省锦州市",
"86147218", "上海市",
"861573803", "河南省濮阳市",
"861459111", "广西来宾市",
"861458539", "河南省漯河市",
"861564587", "黑龙江省伊春市",
"861370651", "浙江省杭州市",
"86152483", "内蒙古通辽市",
"861471550", "广东省汕头市",
"861359325", "山西省长治市",
"861327901", "新疆喀什地区",
"861373188", "安徽省宣城市",
"86150554", "安徽省安庆市",
"861337587", "浙江省温州市",
"861571648", "河南省郑州市",
"861473804", "河南省洛阳市",
"861869870", "辽宁省大连市",
"861818188", "四川省泸州市",
"861470309", "河北省廊坊市",
"861847571", "广东省佛山市",
"861345875", "四川省眉山市",
"86187330", "河北省沧州市",
"861500752", "广东省惠州市",
"861537072", "江苏省泰州市",
"861312463", "贵州省安顺市",
"861301310", "安徽省马鞍山市",
"861507685", "河北省衡水市",
"861341914", "四川省南充市",
"861300857", "陕西省延安市",
"861458792", "湖南省张家界市",
"861760469", "黑龙江省双鸭山市",
"861760701", "江西省鹰潭市",
"861882886", "四川省甘孜藏族自治州",
"861833607", "河南省新乡市",
"861800094", "广东省揭阳市",
"861816755", "新疆塔城地区",
"861830661", "广东省佛山市",
"861354499", "广东省江门市",
"861705183", "重庆市",
"861335252", "黑龙江省齐齐哈尔市",
"861336572", "安徽省蚌埠市",
"861806326", "山东省潍坊市",
"861771711", "河北省石家庄市",
"861365292", "广东省佛山市",
"861590953", "宁夏吴忠市",
"861885839", "浙江省舟山市",
"861554271", "辽宁省鞍山市",
"861874292", "新疆石河子市",
"861398900", "西藏拉萨市",
"861594734", "内蒙古通辽市",
"861390945", "甘肃省武威市",
"861337911", "陕西省延安市",
"861521476", "浙江省台州市",
"861303806", "山西省长治市",
"861358143", "湖北省襄樊市",
"861893642", "江苏省南通市",
"861829568", "宁夏银川市",
"861892151", "江苏省无锡市",
"86189415", "辽宁省丹东市",
"861329028", "山东省德州市",
"861399525", "宁夏吴忠市",
"861557706", "广西来宾市",
"861860696", "福建省泉州市",
"861705776", "北京市",
"861304391", "河南省焦作市",
"861882347", "广东省佛山市",
"861558372", "四川省内江市",
"861580737", "湖南省益阳市",
"86132717", "河南省驻马店市",
"861476500", "北京市",
"86133586", "辽宁省鞍山市",
"86130712", "湖北省武汉市",
"86130239", "福建省厦门市",
"861525906", "福建省宁德市",
"86186367", "山西省临汾市",
"861897509", "湖南省怀化市",
"861358474", "江苏省南通市",
"861564911", "河南省郑州市",
"861896532", "福建省三明市",
"861311578", "浙江省丽水市",
"861370079", "河南省洛阳市",
"86156291", "湖北省武汉市",
"861313391", "江西省南昌市",
"861771168", "湖南省娄底市",
"861850462", "黑龙江省鸡西市",
"86133489", "四川省成都市",
"861807401", "浙江省绍兴市",
"861522977", "陕西省宝鸡市",
"861370385", "河南省漯河市",
"861582585", "甘肃省平凉市",
"861361787", "广西南宁市",
"861332891", "福建省三明市",
"861348031", "广东省揭阳市",
"861362851", "贵州省贵阳市",
"861850790", "江西省新余市",
"861812254", "广东省河源市",
"861370269", "广东省湛江市",
"861700143", "江苏省徐州市",
"861334600", "浙江省嘉兴市",
"86187939", "甘肃省陇南市",
"861591149", "云南省丽江市",
"861700474", "内蒙古包头市",
"861305514", "湖南省湘潭市",
"861362298", "广东省韶关市",
"861351334", "河北省秦皇岛市",
"861567600", "广西防城港市",
"86156789", "广西崇左市",
"861476011", "福建省莆田市",
"861529295", "新疆和田地区",
"861572595", "山东省临沂市",
"861380395", "河南省漯河市",
"861583560", "山西省晋城市",
"861332258", "西藏拉萨市",
"861810850", "贵州省贵阳市",
"861551432", "河南省信阳市",
"861309268", "江苏省镇江市",
"861454313", "黑龙江省七台河市",
"861855429", "山东省威海市",
"861470434", "吉林省四平市",
"861700964", "安徽省合肥市",
"861357788", "云南省大理白族自治州",
"861458039", "江苏省徐州市",
"861346840", "山东省淄博市",
"861351756", "广西百色市",
"86155256", "山西省忻州市",
"861598072", "福建省福州市",
"861853958", "河南省洛阳市",
"861761454", "黑龙江省佳木斯市",
"861770855", "贵州省黔东南苗族侗族自治州",
"861301301", "安徽省滁州市",
"861828092", "四川省内江市",
"861317281", "广东省揭阳市",
"861871463", "黑龙江省鹤岗市",
"861850972", "青海省海东地区",
"861308219", "河北省沧州市",
"861302449", "江苏省盐城市",
"861570991", "新疆乌鲁木齐市",
"861859686", "福建省厦门市",
"861510649", "山东省临沂市",
"861571920", "陕西省西安市",
"861570433", "吉林省延边朝鲜族自治州",
"861859365", "福建省莆田市",
"86182813", "四川省自贡市",
"861353675", "广东省河源市",
"861322890", "西藏拉萨市",
"861317417", "江苏省常州市",
"861308616", "江西省吉安市",
"861788123", "新疆哈密地区",
"86132260", "广东省珠海市",
"861510246", "辽宁省辽阳市",
"861882776", "江西省吉安市",
"861365616", "江苏省无锡市",
"861376370", "黑龙江省黑河市",
"86150504", "江苏省苏州市",
"861475736", "浙江省嘉兴市",
"861504985", "内蒙古鄂尔多斯市",
"861569041", "河北省石家庄市",
"861390450", "黑龙江省哈尔滨市",
"861390693", "福建省福州市",
"861355710", "广西防城港市",
"861885707", "浙江省舟山市",
"861879449", "甘肃省庆阳市",
"861869780", "青海省海北藏族自治州",
"861802482", "广东省惠州市",
"861358964", "山东省枣庄市",
"861532644", "吉林省通化市",
"86139454", "黑龙江省佳木斯市",
"861348293", "河北省秦皇岛市",
"861459100", "广西防城港市",
"86159393", "河南省濮阳市",
"861397184", "湖北省荆门市",
"861820936", "甘肃省张掖市",
"861472789", "陕西省商洛市",
"861336072", "广东省清远市",
"861364572", "浙江省湖州市",
"861327910", "陕西省咸阳市",
"861398587", "贵州省毕节地区",
"861521966", "广东省云浮市",
"861331453", "黑龙江省牡丹江市",
"861555591", "安徽省宿州市",
"861775108", "江苏省宿迁市",
"861771531", "江苏省无锡市",
"861512960", "陕西省榆林市",
"861590524", "江苏省宿迁市",
"861599944", "新疆乌鲁木齐市",
"861800594", "福建省莆田市",
"861876252", "江苏省盐城市",
"861700846", "浙江省绍兴市",
"861593208", "河北省唐山市",
"86133180", "广东省汕头市",
"861772044", "湖北省武汉市",
"861361493", "辽宁省抚顺市",
"861550529", "江苏省无锡市",
"861308256", "江苏省扬州市",
"861304362", "江苏省无锡市",
"861776976", "浙江省金华市",
"861318308", "河南省洛阳市",
"861829683", "江西省景德镇市",
"861328843", "广东省佛山市",
"861313362", "江西省鹰潭市",
"861476569", "江西省南昌市",
"861324545", "山东省东营市",
"861810986", "辽宁省盘锦市",
"861559949", "贵州省铜仁地区",
"861334076", "四川省南充市",
"861308659", "四川省泸州市",
"861819181", "陕西省渭南市",
"861366576", "浙江省台州市",
"861336713", "湖北省黄冈市",
"86150377", "河南省南阳市",
"861351719", "湖北省武汉市",
"86138897", "辽宁省鞍山市",
"861890726", "湖北省恩施土家族苗族自治州",
"861567076", "河南省安阳市",
"86152372", "河南省安阳市",
"861596520", "山东省德州市",
"861458756", "广东省珠海市",
"861539122", "内蒙古乌兰察布市",
"861378050", "河北省唐山市",
"861364533", "山东省淄博市",
"861500796", "江西省吉安市",
"861806590", "福建省三明市",
"861458118", "安徽省阜阳市",
"861340966", "湖北省随州市",
"86135787", "吉林省长春市",
"86151477", "内蒙古鄂尔多斯市",
"861321753", "广东省梅州市",
"861835934", "福建省龙岩市",
"861598033", "福建省泉州市",
"861338520", "湖北省武汉市",
"86134816", "广西百色市",
"861857142", "湖北省宜昌市",
"86131520", "陕西省西安市",
"861552068", "四川省资阳市",
"861300006", "江苏省南京市",
"86138319", "河北省邢台市",
"861536969", "河北省秦皇岛市",
"861775709", "浙江省衢州市",
"861327231", "湖南省衡阳市",
"861766034", "山东省东营市",
"861573458", "黑龙江省伊春市",
"861700485", "广东省深圳市",
"861339905", "新疆阿克苏地区",
"861315938", "福建省三明市",
"861332862", "福建省南平市",
"86181818", "四川省广安市",
"861342240", "广东省惠州市",
"861538454", "陕西省西安市",
"861334669", "河南省许昌市",
"861570472", "内蒙古包头市",
"861309852", "贵州省遵义市",
"861850491", "内蒙古呼和浩特市",
"861368392", "河南省南阳市",
"861818879", "广东省惠州市",
"861850933", "甘肃省平凉市",
"861568548", "贵州省六盘水市",
"861866629", "广东省深圳市",
"861338352", "山西省大同市",
"86155678", "吉林省通化市",
"861508912", "广东省汕头市",
"861568494", "湖南省长沙市",
"861807700", "广西南宁市",
"861582574", "浙江省嘉兴市",
"861370374", "河南省许昌市",
"861303557", "贵州省铜仁地区",
"861887208", "湖北省孝感市",
"861771401", "江苏省常州市",
"861570962", "宁夏石嘴山市",
"861595140", "江苏省镇江市",
"861518194", "四川省遂宁市",
"86131126", "广东省惠州市",
"861830619", "江苏省无锡市",
"86186848", "湖南省长沙市",
"861336858", "贵州省六盘水市",
"86795", "江西省宜春市",
"861314557", "安徽省宿州市",
"861375447", "河北省沧州市",
"861365571", "浙江省杭州市",
"86187257", "重庆市",
"86182927", "陕西省宝鸡市",
"86188793", "江西省上饶市",
"861554592", "黑龙江省鹤岗市",
"861308571", "广东省清远市",
"861530904", "四川省阿坝藏族羌族自治州",
"861760411", "辽宁省大连市",
"861871932", "广东省佛山市",
"861556052", "内蒙古巴彦淖尔市",
"861536479", "山西省朔州市",
"861775971", "福建省龙岩市",
"861337230", "浙江省嘉兴市",
"861816854", "江苏省泰州市",
"86185883", "广东省深圳市",
"861772349", "四川省成都市",
"861328146", "四川省成都市",
"861366251", "广东省广州市",
"861389709", "青海省海西蒙古族藏族自治州",
"861509680", "云南省怒江傈僳族自治州",
"861360723", "湖北省鄂州市",
"861894536", "黑龙江省绥化市",
"861570503", "内蒙古兴安盟",
"861332618", "浙江省湖州市",
"86134349", "广东省揭阳市",
"861598291", "四川省德阳市",
"861779743", "青海省玉树藏族自治州",
"861458334", "江西省上饶市",
"861315824", "贵州省黔南布依族苗族自治州",
"861773055", "河北省石家庄市",
"86137222", "河北省保定市",
"861561513", "山东省日照市",
"861513974", "河南省商丘市",
"861563695", "黑龙江省齐齐哈尔市",
"861397175", "湖北省黄石市",
"861554739", "内蒙古乌海市",
"861869328", "甘肃省兰州市",
"861317839", "福建省龙岩市",
"861558333", "四川省达州市",
"861352637", "河南省驻马店市",
"861516707", "浙江省衢州市",
"861524053", "江苏省常州市",
"861800312", "河北省保定市",
"861807168", "江苏省宿迁市",
"861537713", "湖北省黄冈市",
"861520914", "陕西省商洛市",
"861476069", "内蒙古鄂尔多斯市",
"861804322", "吉林省吉林市",
"861814383", "西藏山南地区",
"861334576", "浙江省台州市",
"861370487", "黑龙江省黑河市",
"861816941", "湖南省常德市",
"861881830", "广东省韶关市",
"861550029", "吉林省白城市",
"861363440", "吉林省长春市",
"86155687", "吉林省长春市",
"861380497", "辽宁省沈阳市",
"861813550", "山西省长治市",
"861533381", "河南省郑州市",
"861705631", "广西南宁市",
"861811415", "江苏省徐州市",
"861533428", "湖北省黄石市",
"861348769", "湖南省益阳市",
"861768631", "山东省威海市",
"861565999", "福建省福州市",
"861770336", "河北省廊坊市",
"861768950", "西藏拉萨市",
"861777633", "广西柳州市",
"861348401", "浙江省杭州市",
"861580860", "云南省昭通市",
"86180044", "吉林省长春市",
"861364713", "湖北省黄冈市",
"861807031", "江西省上饶市",
"861820609", "福建省厦门市",
"861898929", "四川省绵阳市",
"861397352", "湖南省郴州市",
"861478423", "河南省郑州市",
"861351539", "山东省临沂市",
"861450959", "江苏省宿迁市",
"861336533", "山东省淄博市",
"861840926", "陕西省汉中市",
"86452", "黑龙江省齐齐哈尔市",
"861364033", "广东省广州市",
"861305319", "安徽省阜阳市",
"861564969", "河南省郑州市",
"86185395", "河南省漯河市",
"86184812", "四川省凉山彝族自治州",
"86150388", "河南省平顶山市",
"86135111", "湖南省常德市",
"861311852", "贵州省遵义市",
"861386642", "安徽省马鞍山市",
"86151488", "内蒙古巴彦淖尔市",
"861322608", "广东省中山市",
"861518847", "河南省南阳市",
"861476279", "江苏省南通市",
"861582074", "广东省惠州市",
"86132598", "陕西省西安市",
"861350247", "广东省汕头市",
"861479795", "江西省宜春市",
"861475559", "安徽省宣城市",
"861882445", "广东省河源市",
"861888215", "四川省眉山市",
"861337969", "贵州省黔西南布依族苗族自治州",
"861318742", "云南省昆明市",
"861351792", "江西省九江市",
"86155413", "辽宁省抚顺市",
"861875858", "浙江省杭州市",
"861364858", "贵州省六盘水市",
"861314057", "河南省商丘市",
"861389837", "辽宁省锦州市",
"861556320", "山东省枣庄市",
"861303057", "江西省抚州市",
"861589732", "湖南省湘潭市",
"861316597", "浙江省杭州市",
"86181122", "江苏省南通市",
"861380783", "广西桂林市",
"861567251", "湖北省宜昌市",
"861800399", "河南省许昌市",
"861370793", "江西省上饶市",
"86130926", "江苏省苏州市",
"861597223", "湖北省襄樊市",
"861815946", "福建省龙岩市",
"861334251", "湖南省长沙市",
"861803894", "广东省韶关市",
"86187207", "江西省赣州市",
"86188463", "黑龙江省齐齐哈尔市",
"861531886", "山东省青岛市",
"861554092", "内蒙古兴安盟",
"861882631", "广东省佛山市",
"861889388", "甘肃省庆阳市",
"861590329", "河北省邢台市",
"861874071", "陕西省延安市",
"861537858", "四川省广安市",
"861875291", "江苏省盐城市",
"861889421", "甘肃省天水市",
"861327593", "福建省宁德市",
"861333995", "湖北省黄冈市",
"861826664", "山东省青岛市",
"861860763", "广东省清远市",
"861500588", "浙江省丽水市",
"861521745", "广东省广州市",
"861770754", "广东省汕头市",
"861457105", "江苏省扬州市",
"861555062", "山东省滨州市",
"861826195", "江苏省镇江市",
"86138910", "陕西省咸阳市",
"861525639", "安徽省亳州市",
"861308261", "山东省东营市",
"861874261", "新疆阿克苏地区",
"861860652", "浙江省杭州市",
"861570003", "浙江省衢州市",
"861840313", "河北省张家口市",
"861815864", "浙江省台州市",
"861554807", "内蒙古通辽市",
"861363955", "宁夏吴忠市",
"861317707", "湖北省宜昌市",
"861891452", "江苏省泰州市",
"861340630", "山东省威海市",
"861376828", "广西河池市",
"861340951", "宁夏银川市",
"861458761", "广东省韶关市",
"861327178", "河南省南阳市",
"86838", "四川省德阳市",
"861458409", "河南省郑州市",
"861329915", "陕西省安康市",
"861470004", "福建省福州市",
"861345884", "四川省宜宾市",
"861780318", "河北省衡水市",
"861821128", "广东省梅州市",
"86152201", "广东省深圳市",
"861772982", "四川省成都市",
"861709949", "浙江省嘉兴市",
"861810458", "黑龙江省伊春市",
"861530520", "江苏省徐州市",
"861533378", "河南省开封市",
"86152273", "河北省邢台市",
"861390033", "河北省邯郸市",
"861524011", "安徽省阜阳市",
"861562267", "广东省揭阳市",
"861478373", "河南省新乡市",
"861561551", "山东省济南市",
"861362582", "浙江省湖州市",
"861700529", "江苏省无锡市",
"86181752", "安徽省滁州市",
"861331030", "内蒙古鄂尔多斯市",
"861591523", "广东省佛山市",
"861814615", "福建省漳州市",
"861560392", "河南省鹤壁市",
"861895487", "山东省泰安市",
"86184708", "江西省南昌市",
"861330454", "黑龙江省佳木斯市",
"861853845", "河南省南阳市",
"861502975", "陕西省西安市",
"861858279", "四川省阿坝藏族羌族自治州",
"861360494", "辽宁省大连市",
"861300912", "吉林省长春市",
"86139355", "山西省长治市",
"861519195", "陕西省商洛市",
"861813472", "河南省安阳市",
"861801593", "江苏省南通市",
"861459892", "广东省东莞市",
"861530352", "山西省大同市",
"86151656", "山东省潍坊市",
"861360548", "山东省泰安市",
"86176080", "四川省成都市",
"861550485", "内蒙古通辽市",
"861882562", "广东省珠海市",
"861358529", "江苏省连云港市",
"861891939", "甘肃省陇南市",
"861321293", "黑龙江省哈尔滨市",
"861458699", "山东省莱芜市",
"86151505", "江苏省南京市",
"861500659", "山东省临沂市",
"861312459", "黑龙江省大庆市",
"861479540", "广西梧州市",
"861868770", "云南省昆明市",
"861786537", "山东省济宁市",
"861556960", "甘肃省兰州市",
"861760453", "黑龙江省牡丹江市",
"861760690", "云南省昆明市",
"861570050", "四川省广安市",
"861862549", "河南省安阳市",
"861831429", "云南省大理白族自治州",
"861888820", "山东省德州市",
"861571434", "吉林省四平市",
"86138733", "湖南省株洲市",
"861354660", "山西省忻州市",
"861590969", "宁夏固原市",
"861459335", "四川省内江市",
"861365796", "江西省吉安市",
"861335118", "黑龙江省大庆市",
"861857920", "江西省九江市",
"861308796", "广西南宁市",
"861820499", "内蒙古通辽市",
"861374805", "内蒙古通辽市",
"861596904", "云南省德宏傣族景颇族自治州",
"861590479", "内蒙古锡林郭勒盟",
"861768903", "西藏山南地区",
"861889371", "甘肃省兰州市",
"861315887", "四川省绵阳市",
"861813503", "山西省忻州市",
"861535432", "河北省保定市",
"861369834", "四川省雅安市",
"861350333", "河北省石家庄市",
"861561679", "湖南省益阳市",
"861362159", "江苏省南京市",
"861877432", "湖南省湘西土家族苗族自治州",
"861524987", "安徽省马鞍山市",
"861870974", "青海省海南藏族自治州",
"861896619", "浙江省杭州市",
"861839717", "青海省黄南藏族自治州",
"861534501", "福建省三明市",
"861835721", "浙江省嘉兴市",
"861390858", "贵州省六盘水市",
"86153250", "浙江省温州市",
"861337329", "河北省唐山市",
"861598751", "云南省保山市",
"861569495", "河北省唐山市",
"861818908", "西藏日喀则地区",
"86159975", "湖北省宜昌市",
"861310194", "江苏省南通市",
"861378962", "内蒙古包头市",
"861395105", "江苏省扬州市",
"861366791", "江西省南昌市",
"861321711", "湖北省鄂州市",
"861763508", "山西省晋城市",
"861310665", "广东省佛山市",
"861336751", "广西南宁市",
"861317683", "山东省泰安市",
"861787668", "广东省茂名市",
"861322544", "山东省德州市",
"861830573", "浙江省嘉兴市",
"861353627", "广东省惠州市",
"861539455", "福建省福州市",
"861327672", "浙江省宁波市",
"861561066", "山东省临沂市",
"861705562", "天津市",
"861373908", "湖南省长沙市",
"861534730", "湖南省岳阳市",
"86181823", "重庆市",
"861500571", "浙江省杭州市",
"861520521", "江苏省徐州市",
"861344054", "山东省莱芜市",
"861566510", "江苏省泰州市",
"861847663", "广东省深圳市",
"861529941", "新疆阿勒泰地区",
"86189314", "河北省唐山市",
"861346448", "辽宁省铁岭市",
"86137323", "浙江省台州市",
"86147290", "陕西省咸阳市",
"861860158", "江苏省无锡市",
"861514480", "内蒙古通辽市",
"861532438", "河北省衡水市",
"861885131", "江苏省南通市",
"861781681", "浙江省温州市",
"861336766", "广西百色市",
"86181702", "江西省九江市",
"861351252", "江苏省南京市",
"86152251", "河南省郑州市",
"861458612", "湖北省荆门市",
"861806745", "浙江省温州市",
"861340913", "陕西省渭南市",
"861864726", "内蒙古赤峰市",
"86131756", "浙江省温州市",
"861871459", "黑龙江省牡丹江市",
"861390533", "山东省淄博市",
"861829707", "青海省海西蒙古族藏族自治州",
"861800634", "山东省莱芜市",
"861779028", "四川省成都市",
"861787899", "广西梧州市",
"86139305", "河北省唐山市",
"861801093", "安徽省阜阳市",
"861840351", "山西省太原市",
"861310847", "陕西省渭南市",
"861339443", "吉林省延边朝鲜族自治州",
"861360048", "广东省广州市",
"861868880", "广东省佛山市",
"861331530", "河北省张家口市",
"861819178", "陕西省宝鸡市",
"861846436", "山东省滨州市",
"861802998", "广东省惠州市",
"861805880", "浙江省杭州市",
"861324790", "江西省赣州市",
"861558247", "山西省临汾市",
"861555631", "安徽省宣城市",
"861570322", "河北省保定市",
"86151627", "江苏省南通市",
"861524000", "安徽省滁州市",
"861359746", "湖北省襄樊市",
"861328914", "陕西省商洛市",
"86158633", "山东省日照市",
"861858569", "贵州省黔南布依族苗族自治州",
"861325760", "广东省中山市",
"861571309", "河北省邢台市",
"861370424", "辽宁省本溪市",
"861529854", "江苏省泰州市",
"861470648", "山东省青岛市",
"861334213", "辽宁省抚顺市",
"861598766", "云南省文山壮族苗族自治州",
"861876118", "江苏省常州市",
"861331469", "黑龙江省双鸭山市",
"861315346", "山东省德州市",
"861331701", "江西省鹰潭市",
"861567213", "湖北省十堰市",
"861572441", "辽宁省本溪市",
"861588497", "四川省巴中市",
"861300999", "黑龙江省哈尔滨市",
"86134360", "重庆市",
"861570550", "安徽省滁州市",
"8613888", "云南省昆明市",
"861472682", "四川省绵阳市",
"861560319", "河北省邢台市",
"86147417", "四川省成都市",
"861357960", "新疆昌吉回族自治州",
"861812895", "广东省河源市",
"861774601", "福建省泉州市",
"861556636", "辽宁省营口市",
"861331979", "新疆和田地区",
"861308588", "广东省中山市",
"861321700", "江西省南昌市",
"861874588", "黑龙江省伊春市",
"861365588", "浙江省宁波市",
"86177260", "天津",
"861531233", "江苏省淮安市",
"861592834", "四川省资阳市",
"861772890", "广东省东莞市",
"861454674", "广东省珠海市",
"861890447", "吉林省辽源市",
"861357470", "湖南省益阳市",
"861551323", "山西省忻州市",
"861782880", "四川省自贡市",
"861801231", "江苏省扬州市",
"861453802", "四川省德阳市",
"861527687", "新疆塔城地区",
"861572635", "山东省聊城市",
"861705272", "北京市",
"861585295", "江苏省泰州市",
"861579425", "江苏省苏州市",
"86153200", "天津市",
"861452358", "河南省三门峡市",
"861320855", "贵州省黔东南苗族侗族自治州",
"861476107", "江苏省常州市",
"86182538", "山东省泰安市",
"86134881", "陕西省西安市",
"861304922", "广东省云浮市",
"861453097", "山西省长治市",
"861776413", "湖北省十堰市",
"861869478", "福建省南平市",
"861322044", "甘肃省张掖市",
"861769876", "河南省驻马店市",
"861889214", "陕西省宝鸡市",
"861875751", "浙江省绍兴市",
"861561566", "山东省潍坊市",
"861705062", "陕西省西安市",
"86136275", "海南省海口市",
"861325108", "浙江省衢州市",
"861370253", "广东省中山市",
"861807662", "广西南宁市",
"861334791", "江苏省无锡市",
"861316341", "黑龙江省哈尔滨市",
"861820412", "辽宁省鞍山市",
"861589906", "新疆昌吉回族自治州",
"86147683", "山东省临沂市",
"861855074", "江苏省宿迁市",
"861896692", "陕西省西安市",
"861340326", "河北省保定市",
"861860536", "山东省潍坊市",
"861868919", "西藏拉萨市",
"861534510", "江苏省无锡市",
"861566010", "河南省焦作市",
"861324491", "广东省江门市",
"861599116", "陕西省西安市",
"861590911", "陕西省延安市",
"861830712", "湖北省孝感市",
"861537945", "甘肃省金昌市",
"861566645", "山东省烟台市",
"861894299", "湖北省恩施土家族苗族自治州",
"861324933", "河北省石家庄市",
"86147223", "四川省成都市",
"861314150", "江苏省连云港市",
"86138552", "安徽省蚌埠市",
"86132249", "重庆市",
"861894696", "广东省揭阳市",
"861525099", "江苏省南京市",
"861524279", "辽宁省盘锦市",
"861771662", "贵州省黔南布依族苗族自治州",
"86188506", "福建省南平市",
"861351868", "山东省泰安市",
"861517190", "湖北省宜昌市",
"861452627", "江苏省南通市",
"861833176", "河北省沧州市",
"861459437", "西藏阿里地区",
"861373238", "浙江省湖州市",
"861560734", "湖南省衡阳市",
"861526633", "山东省日照市",
"861364945", "广西玉林市",
"86183019", "上海市",
"861306926", "吉林省松原市",
"86130808", "辽宁省沈阳市",
"86187408", "辽宁省阜新市",
"861357909", "新疆喀什地区",
"86136508", "广东省广州市",
"861700324", "河北省唐山市",
"861572740", "湖南省怀化市",
"861870330", "河北省邯郸市",
"861533820", "广东省惠州市",
"861562489", "内蒙古锡林郭勒盟",
"861528948", "陕西省西安市",
"86185973", "重庆市",
"861846506", "宁夏石嘴山市",
"861580468", "黑龙江省鹤岗市",
"861331400", "辽宁省沈阳市",
"861459153", "广西河池市",
"861768233", "浙江省杭州市",
"861881438", "广东省梅州市",
"861363848", "湖南省娄底市",
"861819901", "新疆伊犁哈萨克自治州",
"86188655", "山东省烟台市",
"861335970", "黑龙江省哈尔滨市",
"861859925", "新疆吐鲁番地区",
"861705233", "广东省东莞市",
"861325709", "江西省南昌市",
"861370613", "江苏省苏州市",
"861571360", "河南省商丘市",
"86188409", "辽宁省大连市",
"861850545", "山东省烟台市",
"86188527", "江苏省扬州市",
"861853744", "河南省信阳市",
"86181533", "湖南省永州市",
"861524069", "广西南宁市",
"861895385", "山东省威海市",
"861304047", "新疆克孜勒苏柯尔克孜自治州",
"861365752", "新疆阿克苏地区",
"861368921", "陕西省延安市",
"861377923", "新疆巴音郭楞蒙古自治州",
"861539357", "甘肃省金昌市",
"861476553", "浙江省杭州市",
"861858987", "广西柳州市",
"86151030", "海南省海口市",
"861508857", "浙江省温州市",
"861335792", "江苏省无锡市",
"861860406", "辽宁省锦州市",
"861512189", "宁夏中卫市",
"861323240", "广东省江门市",
"861346399", "河北省石家庄市",
"861806197", "江苏省无锡市",
"861769132", "陕西省延安市",
"86138614", "江苏省无锡市",
"861454685", "广东省深圳市",
"86151287", "河北省沧州市",
"861458252", "安徽省合肥市",
"861454366", "山东省威海市",
"861398024", "四川省泸州市",
"861317278", "广东省河源市",
"861350155", "广东省深圳市",
"861780275", "湖北省鄂州市",
"861321769", "广东省东莞市",
"861845010", "福建省漳州市",
"861877897", "广西南宁市",
"861891209", "江苏省泰州市",
"861580978", "青海省西宁市",
"861501747", "广东省惠州市",
"861839407", "甘肃省临夏回族自治州",
"861530396", "河南省驻马店市",
"861566431", "河南省鹤壁市",
"861355808", "广西河池市",
"861814540", "黑龙江省七台河市",
"861537450", "湖北省鄂州市",
"861537693", "山东省菏泽市",
"861347414", "陕西省渭南市",
"861390572", "浙江省湖州市",
"861560356", "山西省晋城市",
"861808704", "云南省昆明市",
"861567653", "广西百色市",
"861335539", "山东省临沂市",
"861780065", "内蒙古通辽市",
"861820348", "山西省吕梁市",
"861367867", "山东省济宁市",
"861317068", "云南省红河哈尼族彝族自治州",
"86180117", "广东省广州市",
"861536024", "广东省汕尾市",
"861334653", "广东省韶关市",
"861535002", "江西省九江市",
"861587749", "陕西省安康市",
"861597621", "广东省惠州市",
"86177952", "宁夏石嘴山市",
"861337524", "江苏省盐城市",
"861334762", "广西柳州市",
"861872917", "陕西省宝鸡市",
"861329743", "湖南省湘西土家族苗族自治州",
"86136992", "北京市",
"861364693", "福建省龙岩市",
"861364450", "黑龙江省哈尔滨市",
"86177094", "甘肃省兰州市",
"861332586", "浙江省台州市",
"86189931", "甘肃省兰州市",
"861807691", "西藏拉萨市",
"861332798", "江苏省盐城市",
"861525599", "安徽省黄山市",
"861589639", "江苏省镇江市",
"861571504", "福建省漳州市",
"86188556", "安徽省安庆市",
"861595047", "江苏省南京市",
"861502984", "陕西省榆林市",
"861560361", "黑龙江省哈尔滨市",
"861361724", "湖北省荆门市",
"861589236", "四川省广安市",
"86186947", "福建省泉州市",
"861331411", "辽宁省大连市",
"861327633", "山东省日照市",
"861896656", "陕西省咸阳市",
"861830532", "山东省青岛市",
"861317131", "内蒙古乌海市",
"86138502", "福建省莆田市",
"86182828", "四川省凉山彝族自治州",
"861573850", "河南省郑州市",
"861309581", "浙江省舟山市",
"861774045", "河南省周口市",
"861806966", "浙江省嘉兴市",
"861708372", "河南省安阳市",
"861860759", "广东省湛江市",
"861863457", "山西省临汾市",
"861393833", "河南省濮阳市",
"86185951", "宁夏银川市",
"861550143", "江苏省徐州市",
"861806844", "江苏省苏州市",
"861590900", "新疆乌鲁木齐市",
"86187458", "黑龙江省哈尔滨市",
"861354609", "山西省朔州市",
"861535473", "吉林省四平市",
"861399489", "山西省运城市",
"861830799", "江西省萍乡市",
"86188459", "黑龙江省大庆市",
"861471962", "甘肃省武威市",
"861359965", "福建省漳州市",
"861350372", "河南省安阳市",
"861304547", "黑龙江省双鸭山市",
"861454351", "山东省临沂市",
"861313547", "安徽省亳州市",
"861880643", "山东省淄博市",
"861774250", "湖南省岳阳市",
"86178599", "福建省漳州市",
"86188605", "山东省滨州市",
"861550474", "内蒙古乌兰察布市",
"861395626", "安徽省黄山市",
"861476053", "宁夏吴忠市",
"861853486", "山西省吕梁市",
"86176959", "天津市",
"861341843", "广东省佛山市",
"861471472", "广东省汕尾市",
"861598693", "广东省肇庆市",
"861598450", "四川省雅安市",
"861870985", "安徽省合肥市",
"861778021", "四川省德阳市",
"861515558", "安徽省宣城市",
"86158714", "湖北省武汉市",
"86137999", "福建省福州市",
"861865623", "安徽省铜陵市",
"861550964", "宁夏固原市",
"861818171", "四川省德阳市",
"861814255", "四川省绵阳市",
"861319842", "四川省泸州市",
"861808623", "湖北省宜昌市",
"861362813", "四川省内江市",
"861576054", "四川省绵阳市",
"86138998", "新疆乌鲁木齐市",
"861555347", "山东省聊城市",
"86180781", "广西南宁市",
"861590587", "浙江省温州市",
"861576923", "陕西省渭南市",
"861381446", "江苏省泰州市",
"861390262", "广东省惠州市",
"861538621", "湖南省株洲市",
"861348753", "湖南省郴州市",
"861863836", "河南省洛阳市",
"861820702", "江西省宜春市",
"861776703", "浙江省舟山市",
"861886782", "浙江省丽水市",
"861880995", "新疆吐鲁番地区",
"86185764", "广东省深圳市",
"861450963", "新疆博尔塔拉蒙古自治州",
"861839280", "陕西省渭南市",
"861390072", "江西省吉安市",
"861855585", "安徽省六安市",
"861396621", "安徽省宣城市",
"861876539", "山东省临沂市",
"861564953", "河南省安阳市",
"861877502", "广西梧州市",
"861840674", "广西玉林市",
"86151278", "河北省衡水市",
"861787583", "广东省湛江市",
"861777178", "湖北省武汉市",
"861890345", "山西省长治市",
"861554288", "辽宁省阜新市",
"86153962", "福建省厦门市",
"86132116", "云南省昆明市",
"861534431", "吉林省长春市",
"861806476", "浙江省温州市",
"861814040", "四川省凉山彝族自治州",
"861534993", "新疆乌鲁木齐市",
"86188150", "浙江省温州市",
"861867827", "山东省枣庄市",
"861369515", "广东省佛山市",
"861819889", "广东省广州市",
"861332086", "四川省德阳市",
"861336450", "吉林省长春市",
"861318649", "江苏省镇江市",
"861367431", "吉林省长春市",
"861847588", "广东省茂名市",
"861378991", "湖北省武汉市",
"861337953", "陕西省延安市",
"861366653", "浙江省湖州市",
"861366490", "广东省江门市",
"861475563", "安徽省合肥市",
"86186996", "新疆巴音郭楞蒙古自治州",
"861813991", "甘肃省定西市",
"861873649", "河南省三门峡市",
"861845001", "福建省厦门市",
"861321410", "辽宁省铁岭市",
"861813433", "河北省保定市",
"861323555", "湖北省武汉市",
"861312416", "辽宁省锦州市",
"861318246", "江苏省苏州市",
"86159292", "陕西省咸阳市",
"861450502", "吉林省延边朝鲜族自治州",
"861777593", "湖南省湘西土家族苗族自治州",
"861500616", "江苏省无锡市",
"861516068", "福建省龙岩市",
"861346312", "河北省保定市",
"861313790", "河南省洛阳市",
"861592978", "陕西省咸阳市",
"861532946", "贵州省铜仁地区",
"86475", "内蒙古通辽市",
"861820634", "山东省莱芜市",
"861351504", "福建省泉州市",
"861510869", "云南省曲靖市",
"861893618", "江苏省南通市",
"861318408", "山东省菏泽市",
"861313462", "山西省大同市",
"861873408", "安徽省阜阳市",
"861770670", "浙江省衢州市",
"861358269", "河北省邢台市",
"861819128", "陕西省榆林市",
"861304790", "江西省南昌市",
"86181707", "江西省赣州市",
"861301168", "山东省潍坊市",
"861539678", "江苏省扬州市",
"861838404", "四川省泸州市",
"86150251", "云南省昆明市",
"861572097", "江西省九江市",
"861454290", "辽宁省沈阳市",
"861809707", "青海省西宁市",
"861531447", "山东省烟台市",
"861370143", "江苏省泰州市",
"861340747", "湖南省株洲市",
"861899567", "湖北省襄樊市",
"861769123", "陕西省西安市",
"861342103", "广东省梅州市",
"861700269", "广东省广州市",
"861890233", "广东省广州市",
"86181726", "广西桂林市",
"861896302", "山东省青岛市",
"86147412", "辽宁省鞍山市",
"861453635", "江苏省无锡市",
"861700385", "河南省郑州市",
"861707363", "河南省郑州市",
"861477391", "湖南省邵阳市",
"861700666", "山东省聊城市",
"861538354", "山西省晋中市",
"861831230", "广东省揭阳市",
"861365914", "陕西省西安市",
"861305492", "山东省临沂市",
"861376909", "云南省普洱市",
"861568186", "四川省自贡市",
"86134728", "上海市",
"861850391", "河南省焦作市",
"861377932", "新疆巴音郭楞蒙古自治州",
"861372315", "河南省焦作市",
"861308914", "吉林省长春市",
"86151622", "江苏省徐州市",
"861570372", "河南省安阳市",
"861338452", "黑龙江省齐齐哈尔市",
"861370474", "内蒙古乌兰察布市",
"86138193", "浙江省嘉兴市",
"861513000", "河北省邯郸市",
"861361875", "云南省保山市",
"861391439", "江苏省南通市",
"861538736", "湖南省常德市",
"86138661", "安徽省合肥市",
"861507687", "河北省邢台市",
"861870553", "安徽省芜湖市",
"861760564", "安徽省六安市",
"861300855", "陕西省咸阳市",
"861705222", "江苏省南京市",
"861345877", "四川省凉山彝族自治州",
"86186838", "四川省德阳市",
"861453441", "辽宁省沈阳市",
"861318192", "山东省淄博市",
"861351142", "浙江省衢州市",
"861370964", "广东省茂名市",
"861867210", "湖北省宜昌市",
"861389514", "宁夏固原市",
"861356054", "广东省湛江市",
"861893862", "广东省清远市",
"861328588", "浙江省丽水市",
"861301700", "贵州省铜仁地区",
"861375347", "山西省太原市",
"861760311", "河北省石家庄市",
"861778616", "湖北省黄冈市",
"861551373", "山西省阳泉市",
"86187371", "河南省郑州市",
"861816757", "新疆伊犁哈萨克自治州",
"86158491", "内蒙古呼和浩特市",
"861360639", "山东省青岛市",
"861833605", "河南省商丘市",
"861582911", "陕西省延安市",
"861898808", "云南省昆明市",
"861330902", "四川省德阳市",
"861709482", "浙江省宁波市",
"86187303", "河北省张家口市",
"861520261", "宁夏银川市",
"861890091", "辽宁省沈阳市",
"861577881", "广西河池市",
"861359218", "河南省平顶山市",
"861458434", "河南省许昌市",
"861564585", "黑龙江省鸡西市",
"861470719", "湖北省十堰市",
"86134339", "广东省广州市",
"861808288", "新疆乌鲁木齐市",
"861319711", "湖北省荆门市",
"86138285", "广东省清远市",
"861520071", "湖南省衡阳市",
"861506672", "山东省泰安市",
"861516415", "辽宁省锦州市",
"861384851", "内蒙古呼和浩特市",
"861340376", "河南省信阳市",
"861319031", "辽宁省盘锦市",
"861581689", "广东省深圳市",
"861830954", "宁夏固原市",
"861302044", "内蒙古鄂尔多斯市",
"861769826", "河南省平顶山市",
"861869428", "河北省张家口市",
"861836183", "江苏省泰州市",
"861571699", "河北省邢台市",
"861869381", "甘肃省天水市",
"861511941", "广东省汕尾市",
"861355311", "山东省烟台市",
"861313972", "新疆巴音郭楞蒙古自治州",
"861359327", "山西省长治市",
"861587891", "广西防城港市",
"861827662", "广西钦州市",
"861301531", "山西省运城市",
"861516804", "浙江省丽水市",
"861323983", "新疆阿克苏地区",
"861860994", "新疆昌吉回族自治州",
"861800412", "辽宁省鞍山市",
"861330563", "安徽省宣城市",
"861337585", "浙江省绍兴市",
"861384866", "内蒙古赤峰市",
"861594760", "内蒙古赤峰市",
"86155390", "河南省商丘市",
"861369978", "广东省深圳市",
"861363340", "山西省长治市",
"861522975", "陕西省延安市",
"861370387", "河南省周口市",
"861582587", "甘肃省陇南市",
"861813422", "河北省保定市",
"861834733", "内蒙古赤峰市",
"861803483", "新疆巴音郭楞蒙古自治州",
"861320912", "陕西省榆林市",
"861571868", "贵州省六盘水市",
"861361785", "广西玉林市",
"861319168", "河北省保定市",
"861533328", "河北省唐山市",
"861530570", "浙江省衢州市",
"861362646", "山东省潍坊市",
"861801128", "四川省成都市",
"86150201", "山东省菏泽市",
"861529297", "新疆和田地区",
"861572597", "山东省临沂市",
"861533481", "内蒙古呼伦贝尔市",
"861380397", "河南省商丘市",
"86150273", "湖北省武汉市",
"861770436", "吉林省白城市",
"861362249", "广东省河源市",
"861368419", "四川省宜宾市",
"86181757", "湖南省郴州市",
"861802154", "江苏省南京市",
"861700579", "浙江省金华市",
"861474729", "内蒙古呼和浩特市",
"861305419", "湖南省长沙市",
"861478323", "河南省漯河市",
"861588126", "四川省攀枝花市",
"861586644", "山东省临沂市",
"86158092", "陕西省西安市",
"861831479", "湖北省十堰市",
"861576932", "甘肃省定西市",
"86131722", "广东省江门市",
"861399527", "宁夏银川市",
"861830841", "四川省德阳市",
"861390947", "甘肃省酒泉市",
"861864886", "广西柳州市",
"86158954", "江苏省苏州市",
"861328796", "山东省烟台市",
"86178070", "江西省南昌市",
"861470970", "青海省海北藏族自治州",
"861513500", "山西省忻州市",
"861351360", "山西省太原市",
"861301293", "山东省济宁市",
"861580735", "湖南省郴州市",
"861868720", "云南省昆明市",
"861835909", "福建省三明市",
"861808632", "湖北省黄石市",
"861700651", "江苏省无锡市",
"861879544", "江苏省南通市",
"861389734", "青海省海南藏族自治州",
"861700930", "甘肃省兰州市",
"861470460", "黑龙江省哈尔滨市",
"861561629", "湖南省湘潭市",
"861879498", "甘肃省定西市",
"861557923", "江西省九江市",
"861530939", "甘肃省陇南市",
"861337379", "河南省洛阳市",
"861504987", "内蒙古鄂尔多斯市",
"861470792", "江西省九江市",
"861595972", "福建省龙岩市",
"861560602", "福建省福州市",
"861319700", "湖北省黄石市",
"861538516", "安徽省芜湖市",
"861885705", "浙江省舟山市",
"861568773", "云南省玉溪市",
"861457053", "新疆喀什地区",
"861800499", "辽宁省辽阳市",
"861564379", "吉林省辽源市",
"861354094", "四川省南充市",
"861831969", "广东省广州市",
"86135965", "吉林省延边朝鲜族自治州",
"86138374", "河南省许昌市",
"861856963", "湖南省长沙市",
"861356554", "新疆石河子市",
"86131853", "浙江省嘉兴市",
"861571612", "江苏省常州市",
"861398585", "贵州省铜仁地区",
"861889321", "甘肃省定西市",
"861391304", "江苏省南京市",
"861394883", "内蒙古阿拉善盟",
"861590429", "辽宁省葫芦岛市",
"861520571", "浙江省杭州市",
"861770857", "贵州省毕节地区",
"861318119", "山东省日照市",
"861500521", "江苏省徐州市",
"861319531", "安徽省芜湖市",
"861575808", "云南省昭通市",
"861890591", "福建省福州市",
"861317804", "福建省泉州市",
"861500146", "新疆喀什地区",
"8613910", "北京市",
"861509941", "新疆伊犁哈萨克自治州",
"861867201", "湖北省黄石市",
"861855524", "安徽省宣城市",
"861470539", "山东省临沂市",
"861840413", "辽宁省沈阳市",
"861301031", "上海市",
"861839943", "新疆伊犁哈萨克自治州",
"861301711", "湖南省株洲市",
"861512934", "陕西省延安市",
"861369468", "黑龙江省牡丹江市",
"861396516", "安徽省芜湖市",
"861458309", "江西省新余市",
"861837808", "广西桂林市",
"861859367", "福建省福州市",
"861880816", "四川省雅安市",
"861454703", "浙江省嘉兴市",
"861830523", "江苏省淮安市",
"861353677", "广东省河源市",
"861346936", "湖南省永州市",
"861317415", "江苏省徐州市",
"861302498", "福建省龙岩市",
"86137428", "辽宁省大连市",
"861372281", "河北省衡水市",
"861329581", "浙江省杭州市",
"861339907", "新疆博尔塔拉蒙古自治州",
"86186528", "江苏省镇江市",
"861700487", "广东省广州市",
"861854506", "黑龙江省大庆市",
"861803145", "河北省秦皇岛市",
"86131095", "陕西省西安市",
"86158725", "湖北省宜昌市",
"861341571", "广东省佛山市",
"861533780", "广东省清远市",
"861708550", "安徽省合肥市",
"861361774", "广西梧州市",
"861813247", "河北省唐山市",
"861505599", "安徽省黄山市",
"861834990", "四川省成都市",
"861522984", "陕西省铜川市",
"86138507", "福建省泉州市",
"861864950", "山西省忻州市",
"86159246", "云南省西双版纳傣族自治州",
"86138429", "辽宁省葫芦岛市",
"861538559", "安徽省黄山市",
"861503043", "河北省秦皇岛市",
"86186263", "江苏省无锡市",
"861598303", "四川省泸州市",
"861594709", "内蒙古锡林郭勒盟",
"861770506", "福建省泉州市",
"861350322", "河北省保定市",
"861868421", "吉林省吉林市",
"861579746", "湖北省武汉市",
"861559998", "新疆喀什地区",
"861877423", "湖南省衡阳市",
"861324547", "山东省济南市",
"861330232", "广东省广州市",
"861335648", "广东省东莞市",
"861595491", "山东省济南市",
"861351309", "河北省秦皇岛市",
"861550424", "辽宁省大连市",
"861595933", "福建省宁德市",
"861396559", "安徽省阜阳市",
"86138526", "江苏省泰州市",
"861880859", "贵州省黔西南布依族苗族自治州",
"86135444", "广东省广州市",
"861568012", "四川省绵阳市",
"861576463", "黑龙江省牡丹江市",
"861508620", "贵州省黔东南苗族侗族自治州",
"861318156", "山东省菏泽市",
"861898690", "湖北省十堰市",
"861898453", "贵州省安顺市",
"861350550", "安徽省滁州市",
"861821901", "广东省中山市",
"861318038", "河北省廊坊市",
"861450423", "辽宁省抚顺市",
"861318718", "湖南省邵阳市",
"861535423", "河北省张家口市",
"861510811", "四川省遂宁市",
"861538671", "山西省朔州市",
"861591799", "广东省揭阳市",
"861355369", "广东省茂名市",
"861474128", "辽宁省锦州市",
"861580640", "山东省济南市",
"861857409", "河南省新乡市",
"86138120", "江苏省无锡市",
"861800702", "江西省九江市",
"86157335", "河北省秦皇岛市",
"86182781", "广西南宁市",
"861773057", "河北省保定市",
"861564264", "辽宁省葫芦岛市",
"861398574", "贵州省安顺市",
"861857761", "广西柳州市",
"861831900", "广东省肇庆市",
"861368456", "黑龙江省黑河市",
"861589048", "河南省濮阳市",
"861577470", "内蒙古呼伦贝尔市",
"861352635", "河南省驻马店市",
"861319401", "福建省南平市",
"861319769", "广西北海市",
"861333863", "江苏省南京市",
"861476974", "山东省济南市",
"861516705", "浙江省衢州市",
"861563697", "黑龙江省大庆市",
"861850140", "江苏省南京市",
"861397177", "湖北省黄石市",
"861700793", "江西省九江市",
"861890903", "四川省眉山市",
"861318853", "辽宁省葫芦岛市",
"861560988", "辽宁省沈阳市",
"86182299", "湖南省长沙市",
"86181912", "陕西省西安市",
"861824991", "广西河池市",
"861314555", "安徽省马鞍山市",
"861824433", "四川省乐山市",
"861301410", "甘肃省嘉峪关市",
"861312363", "贵州省安顺市",
"861303555", "贵州省黔南布依族苗族自治州",
"861300754", "河南省郑州市",
"861594971", "山东省烟台市",
"861452850", "甘肃省酒泉市",
"861520616", "江苏省无锡市",
"86189361", "江苏省苏州市",
"86131840", "山东省烟台市",
"86184694", "云南省保山市",
"861777128", "湖北省宜昌市",
"861823040", "河北省邯郸市",
"861840624", "辽宁省盘锦市",
"861339580", "浙江省舟山市",
"861311743", "湖南省湘西土家族苗族自治州",
"861358793", "浙江省湖州市",
"861562942", "湖北省荆门市",
"861390022", "广东省肇庆市",
"861867877", "山东省济南市",
"861375445", "河北省唐山市",
"861806426", "湖北省十堰市",
"861890562", "安徽省铜陵市",
"861535254", "新疆塔城地区",
"861780342", "山西省晋城市",
"861575453", "黑龙江省牡丹江市",
"861575690", "四川省乐山市",
"861394732", "内蒙古乌海市",
"861306976", "黑龙江省佳木斯市",
"861506633", "山东省日照市",
"861329081", "福建省福州市",
"8617801", "北京市",
"861583339", "河北省邢台市",
"86138557", "安徽省宿州市",
"861358200", "河北省石家庄市",
"861888217", "四川省眉山市",
"861882447", "广东省梅州市",
"861304491", "江西省南昌市",
"861350245", "广东省广州市",
"861479797", "江西省赣州市",
"861878491", "四川省广元市",
"86151069", "山东省济南市",
"861580834", "四川省凉山彝族自治州",
"861504279", "辽宁省盘锦市",
"861518845", "河南省南阳市",
"861458142", "浙江省台州市",
"861313933", "甘肃省平凉市",
"861821910", "广东省湛江市",
"861370485", "黑龙江省伊春市",
"861811281", "江苏省镇江市",
"861377463", "福建省南平市",
"861368709", "江西省南昌市",
"861857118", "湖北省襄樊市",
"861361884", "云南省曲靖市",
"861876648", "山东省青岛市",
"86159410", "辽宁省铁岭市",
"861376960", "云南省文山壮族苗族自治州",
"861528436", "河北省廊坊市",
"861899810", "广东省惠州市",
"86188522", "江苏省徐州市",
"861504069", "辽宁省本溪市",
"861350050", "安徽省合肥市",
"86132808", "山东省青岛市",
"861351434", "吉林省四平市",
"86188948", "广西玉林市",
"861587618", "广东省汕头市",
"861811417", "江苏省常州市",
"861380495", "辽宁省大连市",
"861530606", "福建省莆田市",
"861565948", "福建省泉州市",
"861873538", "山西省太原市",
"861817896", "江西省赣州市",
"861508948", "广东省梅州市",
"861575224", "云南省曲靖市",
"86151282", "河北省保定市",
"861470334", "河北省唐山市",
"861826197", "江苏省镇江市",
"861454413", "福建省厦门市",
"861890272", "广东省汕头市",
"861321842", "江苏省扬州市",
"861317705", "湖北省宜昌市",
"861514821", "内蒙古包头市",
"861835239", "江苏省苏州市",
"861363957", "宁夏银川市",
"861479483", "内蒙古鄂尔多斯市",
"861333997", "湖北省黄冈市",
"861521747", "广东省广州市",
"861835636", "安徽省马鞍山市",
"861301401", "安徽省宿州市",
"861523871", "河南省焦作市",
"861314240", "内蒙古包头市",
"861301769", "河南省郑州市",
"861457107", "江苏省镇江市",
"861872743", "湖北省荆州市",
"861453740", "湖南省岳阳市",
"861373046", "河北省保定市",
"861377973", "新疆喀什地区",
"861379382", "山东省泰安市",
"861325921", "陕西省宝鸡市",
"861368971", "吉林省四平市",
"861458504", "河南省信阳市",
"861302349", "江苏省宿迁市",
"861317317", "山东省济宁市",
"861318161", "山东省烟台市",
"861893258", "河北省秦皇岛市",
"861778571", "贵州省毕节地区",
"861328663", "广东省江门市",
"86186024", "辽宁省沈阳市",
"861303055", "江西省新余市",
"861337574", "浙江省宁波市",
"861826630", "山东省威海市",
"861558962", "山东省烟台市",
"861316595", "浙江省杭州市",
"861597671", "广东省河源市",
"86177957", "陕西省西安市",
"861597182", "湖北省恩施土家族苗族自治州",
"861334849", "福建省漳州市",
"861390350", "山西省忻州市",
"861309743", "云南省红河哈尼族彝族自治州",
"861817193", "湖北省黄石市",
"861776674", "四川省凉山彝族自治州",
"861333151", "吉林省延边朝鲜族自治州",
"861815830", "浙江省温州市",
"861389835", "辽宁省锦州市",
"861314055", "河南省濮阳市",
"861831911", "广东省汕头市",
"861591712", "广东省茂名市",
"861331353", "山西省阳泉市",
"861399942", "新疆乌鲁木齐市",
"861330688", "浙江省丽水市",
"861817578", "湖南省常德市",
"86159119", "云南省曲靖市",
"861890062", "江苏省镇江市",
"861319410", "辽宁省铁岭市",
"861564574", "黑龙江省黑河市",
"861536074", "广东省湛江市",
"86189674", "浙江省金华市",
"861821889", "广东省茂名市",
"86187083", "四川省自贡市",
"861459243", "四川省眉山市",
"861339080", "江苏省淮安市",
"861567849", "广西梧州市",
"861361393", "河南省濮阳市",
"86155323", "河北省张家口市",
"861886822", "浙江省湖州市",
"86182117", "河南省信阳市",
"861502738", "湖北省咸宁市",
"861800348", "山西省运城市",
"861390522", "江苏省徐州市",
"861888203", "四川省自贡市",
"861761408", "辽宁省大连市",
"861709419", "广东省汕头市",
"861376891", "广西桂林市",
"861337095", "山东省聊城市",
"861322371", "河南省郑州市",
"861568967", "山东省泰安市",
"86130432", "天津市",
"861367055", "广东省揭阳市",
"86187832", "四川省内江市",
"861375193", "广东省汕尾市",
"861780857", "贵州省毕节地区",
"861539410", "陕西省咸阳市",
"861585808", "浙江省舟山市",
"861511353", "广东省阳江市",
"86132437", "广东省深圳市",
"861819741", "青海省海南藏族自治州",
"861500344", "山西省晋中市",
"861566555", "安徽省马鞍山市",
"861572900", "河南省三门峡市",
"86189735", "湖南省郴州市",
"861375578", "江西省南昌市",
"861323867", "云南省昆明市",
"861770418", "辽宁省阜新市",
"861320801", "浙江省杭州市",
"861864578", "黑龙江省牡丹江市",
"86132162", "浙江省金华市",
"861890581", "浙江省杭州市",
"861508275", "四川省南充市",
"861893470", "广西南宁市",
"861512642", "云南省红河哈尼族彝族自治州",
"861300442", "江苏省常州市",
"861517574", "河北省保定市",
"861536595", "江苏省镇江市",
"861772720", "广东省汕尾市",
"86130167", "江苏省泰州市",
"861834437", "广东省梅州市",
"861567821", "广西来宾市",
"861364705", "江西省宜春市",
"86181185", "江苏省徐州市",
"86183561", "安徽省淮北市",
"861875705", "浙江省温州市",
"861565065", "安徽省安庆市",
"861889544", "安徽省阜阳市",
"861537317", "河北省沧州市",
"86909", "新疆博尔塔拉蒙古自治州",
"861811403", "江苏省南京市",
"861364228", "广东省云浮市",
"861398595", "贵州省黔西南布依族苗族自治州",
"861394893", "内蒙古兴安盟",
"861307957", "宁夏吴忠市",
"861889498", "河北省沧州市",
"861353952", "广东省清远市",
"861452996", "内蒙古鄂尔多斯市",
"861472748", "贵州省黔西南布依族苗族自治州",
"861581612", "广东省湛江市",
"861537228", "浙江省丽水市",
"861364317", "河北省沧州市",
"86181874", "云南省曲靖市",
"861534240", "湖北省黄冈市",
"86159740", "湖南省怀化市",
"861350978", "山西省大同市",
"861894927", "安徽省淮北市",
"861470782", "广西柳州市",
"86157761", "黑龙江省大庆市",
"861775154", "江苏省盐城市",
"86155614", "内蒙古包头市",
"86133282", "福建省福州市",
"86188353", "山西省太原市",
"86137374", "广西梧州市",
"861808163", "四川省凉山彝族自治州",
"861815463", "广西南宁市",
"861840717", "湖北省宜昌市",
"861310606", "浙江省衢州市",
"861551784", "河南省平顶山市",
"861595780", "浙江省丽水市",
"861843419", "山西省朔州市",
"861350468", "黑龙江省鸡西市",
"861576644", "广东省深圳市",
"861860367", "黑龙江省大庆市",
"861327848", "吉林省辽源市",
"861878870", "贵州省黔东南苗族侗族自治州",
"861538538", "安徽省池州市",
"861454407", "福建省南平市",
"861570735", "湖南省郴州市",
"861808944", "甘肃省天水市",
"861865944", "福建省龙岩市",
"861372072", "陕西省西安市",
"861840305", "河北省唐山市",
"861764544", "黑龙江省佳木斯市",
"861457113", "湖北省武汉市",
"861333069", "四川省内江市",
"86147005", "北京市",
"861329562", "安徽省铜陵市",
"861533933", "甘肃省平凉市",
"861334543", "新疆哈密地区",
"861527535", "山东省烟台市",
"861812208", "广东省深圳市",
"861533491", "内蒙古呼伦贝尔市",
"861380387", "河南省南阳市",
"861572587", "山东省东营市",
"861529287", "新疆乌鲁木齐市",
"861343720", "湖北省荆州市",
"861338845", "浙江省金华市",
"861588324", "四川省资阳市",
"861333279", "广东省潮州市",
"861309345", "安徽省合肥市",
"861852469", "辽宁省阜新市",
"861893960", "河南省周口市",
"861318059", "河北省秦皇岛市",
"861326307", "江西省赣州市",
"861597156", "湖北省咸宁市",
"86185470", "内蒙古呼伦贝尔市",
"861591188", "云南省红河哈尼族彝族自治州",
"861563451", "山东省济宁市",
"86181293", "新疆乌鲁木齐市",
"861331755", "湖北省襄樊市",
"861880838", "四川省德阳市",
"861332370", "河南省商丘市",
"861803931", "河南省南阳市",
"861396538", "安徽省马鞍山市",
"861811572", "江苏省徐州市",
"861370397", "河南省商丘市",
"861568477", "山东省泰安市",
"861361795", "江西省宜春市",
"861780436", "吉林省白城市",
"861346918", "湖南省常德市",
"86137285", "广东省佛山市",
"86131967", "江苏省常州市",
"861315254", "广西柳州市",
"861597161", "湖北省荆州市",
"861367555", "安徽省黄山市",
"861779776", "河南省郑州市",
"861818149", "四川省巴中市",
"861893636", "江苏省徐州市",
"861869391", "甘肃省陇南市",
"86181336", "安徽省合肥市",
"861571689", "河北省沧州市",
"86137836", "河南省郑州市",
"861340443", "吉林省白城市",
"861587881", "广西南宁市",
"86180436", "吉林省长春市",
"861470872", "云南省大理白族自治州",
"861839351", "甘肃省天水市",
"861373149", "河北省保定市",
"861893239", "江苏省常州市",
"861776164", "河南省焦作市",
"861860984", "辽宁省大连市",
"861323993", "新疆石河子市",
"861598317", "四川省自贡市",
"861802361", "广东省肇庆市",
"861323431", "吉林省长春市",
"861337595", "福建省泉州市",
"861890081", "广东省湛江市",
"86153840", "浙江省杭州市",
"861857872", "广东省汕尾市",
"861581296", "广东省韶关市",
"861339913", "陕西省渭南市",
"861532363", "广东省珠海市",
"86134338", "广东省汕头市",
"861823827", "河南省信阳市",
"861817445", "湖南省长沙市",
"861534555", "安徽省马鞍山市",
"861566055", "河南省新乡市",
"86182166", "贵州省六盘水市",
"861590740", "湖南省张家界市",
"861892330", "广东省中山市",
"861538853", "山西省阳泉市",
"861896546", "福建省漳州市",
"861576830", "广东省梅州市",
"861328598", "福建省福州市",
"861889044", "湖南省岳阳市",
"861395151", "江苏省无锡市",
"861356338", "山东省东营市",
"861508565", "贵州省黔东南苗族侗族自治州",
"861380964", "广东省东莞市",
"86139640", "山东省济南市",
"86137661", "吉林省通化市",
"861336705", "江西省宜春市",
"861880553", "安徽省芜湖市",
"861313657", "浙江省台州市",
"861513863", "河南省南阳市",
"861354584", "湖北省宜昌市",
"861539769", "四川省广安市",
"861539401", "甘肃省甘南藏族自治州",
"861769914", "新疆喀什地区",
"861709492", "浙江省金华市",
"86188371", "河南省郑州市",
"86159532", "山东省青岛市",
"861816224", "江西省宜春市",
"861572911", "河南省洛阳市",
"86183835", "四川省雅安市",
"861394967", "河南省焦作市",
"861809403", "福建省龙岩市",
"86180985", "安徽省宣城市",
"86186839", "四川省广元市",
"86155998", "新疆喀什地区",
"861336317", "河北省沧州市",
"861707946", "河南省郑州市",
"861844727", "内蒙古赤峰市",
"861318182", "山东省泰安市",
"86180539", "山东省临沂市",
"861308123", "辽宁省鞍山市",
"861318671", "浙江省衢州市",
"861330811", "四川省绵阳市",
"861305482", "山东省莱芜市",
"861315423", "辽宁省抚顺市",
"861368482", "江西省九江市",
"86134729", "河北省唐山市",
"861360327", "河北省沧州市",
"861806235", "湖北省荆州市",
"861840537", "山东省济宁市",
"861824860", "浙江省绍兴市",
"861380143", "江苏省泰州市",
"861561505", "山东省聊城市",
"861852710", "湖北省武汉市",
"861859994", "四川省成都市",
"861895126", "江苏省淮安市",
"86185755", "广东省深圳市",
"861371725", "广东省江门市",
"861890917", "陕西省宝鸡市",
"861836896", "甘肃省白银市",
"861764044", "辽宁省沈阳市",
"861816137", "四川省阿坝藏族羌族自治州",
"86137193", "广东省广州市",
"861320989", "山西省运城市",
"861380474", "内蒙古呼和浩特市",
"861333569", "安徽省黄山市",
"861778638", "湖北省武汉市",
"861558017", "湖南省湘潭市",
"861377644", "江苏省宿迁市",
"861526848", "浙江省绍兴市",
"861319283", "广东省惠州市",
"861529400", "甘肃省张掖市",
"861558737", "山东省烟台市",
"861580372", "河南省安阳市",
"861570515", "江苏省连云港市",
"861452167", "河北省衡水市",
"861780670", "广东省广州市",
"861829522", "宁夏石嘴山市",
"861867145", "湖北省武汉市",
"861809572", "青海省海东地区",
"86155502", "山东省滨州市",
"861339326", "河北省廊坊市",
"861329062", "河北省保定市",
"861843492", "山西省运城市",
"861323645", "江苏省盐城市",
"861334043", "福建省厦门市",
"861308826", "四川省绵阳市",
"861366543", "山东省滨州市",
"861874826", "内蒙古包头市",
"861572087", "江苏省苏州市",
"861820942", "甘肃省定西市",
"861454280", "辽宁省沈阳市",
"861774428", "四川省德阳市",
"861328876", "广东省潮州市",
"86182560", "安徽省合肥市",
"861313780", "河南省开封市",
"861816453", "浙江省丽水市",
"861811072", "安徽省宿州市",
"86130031", "上海市",
"861311345", "河北省邢台市",
"861700832", "浙江省杭州市",
"861771122", "四川省宜宾市",
"861805449", "山东省菏泽市",
"861304780", "广西柳州市",
"861817631", "广西桂林市",
"86181680", "江苏省南京市",
"861330698", "福建省三明市",
"861889349", "甘肃省兰州市",
"86147893", "湖南省衡阳市",
"861555528", "安徽省亳州市",
"86170846", "广东省佛山市",
"861821899", "广东省惠州市",
"861332934", "黑龙江省双鸭山市",
"86159703", "江西省上饶市",
"861339090", "江苏省南京市",
"86159771", "广西南宁市",
"861360658", "浙江省宁波市",
"861592550", "云南省昭通市",
"861801440", "江苏省连云港市",
"86158186", "广东省深圳市",
"861814201", "浙江省杭州市",
"861810694", "福建省福州市",
"861860975", "青海省果洛藏族自治州",
"86139653", "安徽省宿州市",
"861323730", "湖南省岳阳市",
"861869362", "甘肃省张掖市",
"861363672", "陕西省延安市",
"861811033", "安徽省淮北市",
"861597192", "湖北省随州市",
"861391458", "江苏省镇江市",
"861845240", "江苏省苏州市",
"861817183", "湖北省荆州市",
"861802392", "广东省潮州市",
"861807122", "湖北省黄冈市",
"861364415", "辽宁省丹东市",
"861561641", "湖南省邵阳市",
"861478725", "云南省普洱市",
"861827172", "湖北省恩施土家族苗族自治州",
"861570928", "陕西省西安市",
"861857136", "湖北省荆州市",
"861379392", "山东省临沂市",
"861550607", "吉林省松原市",
"861881363", "广东省湛江市",
"861832296", "江西省抚州市",
"86153853", "安徽省宣城市",
"861575757", "浙江省绍兴市",
"861579494", "福建省福州市",
"861832699", "安徽省宿州市",
"861857058", "湖南省岳阳市",
"861770708", "江西省南昌市",
"861528418", "四川省宜宾市",
"861529979", "新疆克拉玛依市",
"861587239", "湖北省武汉市",
"86147530", "山东省菏泽市",
"861893881", "广东省潮州市",
"861509929", "新疆阿克苏地区",
"861800077", "江西省赣州市",
"861479493", "内蒙古鄂尔多斯市",
"861320567", "安徽省亳州市",
"861580333", "河北省张家口市",
"861882743", "湖北省武汉市",
"861323501", "福建省漳州市",
"861500549", "山东省临沂市",
"861587636", "广东省湛江市",
"861333987", "湖北省咸宁市",
"861709461", "浙江省绍兴市",
"861552022", "四川省巴中市",
"861529469", "河南省安阳市",
"86132809", "山东省烟台市",
"861529701", "青海省西宁市",
"86187522", "江苏省盐城市",
"861380485", "黑龙江省伊春市",
"861338744", "湖南省张家界市",
"86183626", "江苏省苏州市",
"861886648", "山东省青岛市",
"861817886", "广西河池市",
"861852411", "辽宁省大连市",
"861858241", "四川省眉山市",
"861370495", "辽宁省丹东市",
"861361894", "西藏林芝地区",
"861332828", "福建省宁德市",
"861452952", "广东省汕头市",
"861822602", "安徽省宿州市",
"861394589", "黑龙江省伊春市",
"86153722", "浙江省湖州市",
"861871946", "广东省广州市",
"861818748", "云南省大理白族自治州",
"86187948", "甘肃省兰州市",
"86155733", "湖南省株洲市",
"861392253", "广东省东莞市",
"861597408", "湖南省永州市",
"861584660", "黑龙江省哈尔滨市",
"861328132", "四川省乐山市",
"861331854", "广东省阳江市",
"861894542", "黑龙江省佳木斯市",
"861860465", "黑龙江省绥化市",
"861333731", "湖南省长沙市",
"861871864", "广东省茂名市",
"861304481", "湖北省孝感市",
"861479787", "江西省赣州市",
"86151068", "山东省聊城市",
"861333011", "江西省南昌市",
"86130248", "福建省泉州市",
"861347944", "江西省抚州市",
"861590635", "山东省聊城市",
"861454717", "浙江省温州市",
"861572230", "青海省西宁市",
"86134163", "广东省广州市",
"86176140", "辽宁省沈阳市",
"861505089", "江苏省镇江市",
"861313481", "内蒙古巴彦淖尔市",
"861310570", "浙江省衢州市",
"861313328", "山西省大同市",
"861831802", "广东省广州市",
"861768743", "广西桂林市",
"861539168", "湖北省十堰市",
"861321628", "浙江省衢州市",
"86170897", "广东省中山市",
"86137625", "湖南省郴州市",
"861301678", "江苏省南通市",
"861853234", "河北省衡水市",
"861322654", "广东省韶关市",
"861454305", "黑龙江省哈尔滨市",
"861872447", "黑龙江省齐齐哈尔市",
"861862571", "河南省周口市",
"86183607", "江苏省淮安市",
"86152870", "云南省昭通市",
"861329091", "河南省三门峡市",
"861843461", "山西省晋城市",
"861570834", "四川省凉山彝族自治州",
"861834819", "河南省驻马店市",
"861510563", "安徽省宣城市",
"861346525", "山东省东营市",
"861779950", "新疆巴音郭楞蒙古自治州",
"86159753", "广东省广州市",
"861339590", "福建省福州市",
"861533972", "甘肃省定西市",
"861354389", "广东省珠海市",
"861320277", "广东省肇庆市",
"861508284", "四川省广元市",
"861331941", "江西省南昌市",
"861369550", "安徽省滁州市",
"86188340", "山西省忻州市",
"861887254", "湖北省宜昌市",
"861809033", "四川省内江市",
"86170910", "北京市",
"861572969", "四川省乐山市",
"861809713", "青海省黄南藏族自治州",
"861539031", "四川省攀枝花市",
"86182298", "湖南省长沙市",
"861898757", "云南省昆明市",
"861560998", "新疆喀什地区",
"861819440", "甘肃省天水市",
"861336415", "辽宁省丹东市",
"861824981", "黑龙江省伊春市",
"861770342", "山西省大同市",
"86139603", "福建省泉州市",
"861576767", "广东省广州市",
"861509135", "陕西省咸阳市",
"861569424", "辽宁省本溪市",
"86870", "云南省昭通市",
"861321455", "黑龙江省绥化市",
"86139671", "浙江省杭州市",
"861530958", "宁夏银川市",
"861510902", "新疆哈密地区",
"861598415", "四川省自贡市",
"861821812", "广东省河源市",
"861592245", "安徽省宿州市",
"861473572", "山西省朔州市",
"861387202", "湖北省黄冈市",
"861381323", "江苏省盐城市",
"861563687", "黑龙江省鸡西市",
"861386636", "安徽省芜湖市",
"86153871", "湖北省武汉市",
"861511929", "广东省茂名市",
"861570640", "山东省菏泽市",
"861586973", "湖南省株洲市",
"861707765", "云南省玉溪市",
"86158335", "河北省唐山市",
"861700783", "广东省汕头市",
"86185042", "辽宁省大连市",
"86153803", "江苏省扬州市",
"861338486", "内蒙古包头市",
"861802319", "广东省汕尾市",
"861597119", "湖北省孝感市",
"86136021", "天津市",
"861318016", "河北省唐山市",
"861820527", "江苏省扬州市",
"861470558", "安徽省阜阳市",
"86151564", "安徽省六安市",
"861800577", "浙江省温州市",
"861318736", "湖南省郴州市",
"861333000", "江西省九江市",
"86186426", "辽宁省大连市",
"861357148", "陕西省汉中市",
"861870859", "贵州省黔西南布依族苗族自治州",
"861780506", "江苏省南通市",
"861898680", "湖北省宜昌市",
"86133622", "浙江省湖州市",
"86184310", "河北省邯郸市",
"861589746", "湖南省永州市",
"861318354", "四川省广元市",
"861809858", "安徽省黄山市",
"861345145", "河北省邯郸市",
"861883038", "河北省秦皇岛市",
"861847826", "湖南省邵阳市",
"861311447", "湖北省襄樊市",
"861360425", "辽宁省大连市",
"861525242", "江苏省宿迁市",
"86157725", "贵州省黔东南苗族侗族自治州",
"861522994", "陕西省汉中市",
"861310070", "湖北省武汉市",
"861869140", "陕西省商洛市",
"86138428", "辽宁省大连市",
"861520638", "山东省日照市",
"861373302", "安徽省六安市",
"86137507", "浙江省嘉兴市",
"861506340", "山东省莱芜市",
"86180829", "云南省昆明市",
"861573815", "河南省平顶山市",
"86137429", "辽宁省葫芦岛市",
"86183657", "山东省聊城市",
"861329591", "福建省福州市",
"86186407", "辽宁省营口市",
"861372291", "河北省邢台市",
"861852400", "辽宁省锦州市",
"861388247", "四川省凉山彝族自治州",
"86186529", "江苏省南京市",
"861700497", "广东省广州市",
"861321940", "四川省南充市",
"86183525", "江苏省无锡市",
"861330869", "湖北省荆门市",
"861533790", "陕西省西安市",
"861817776", "广西钦州市",
"861823877", "河南省新乡市",
"861380253", "广东省广州市",
"861471517", "广东省肇庆市",
"861529353", "甘肃省金昌市",
"861340124", "江苏省泰州市",
"861364568", "安徽省阜阳市",
"861527130", "湖北省咸宁市",
"861532416", "河北省承德市",
"861517024", "江西省南昌市",
"861538246", "浙江省金华市",
"861836528", "安徽省滁州市",
"86180166", "福建省泉州市",
"861867040", "湖南省岳阳市",
"861516450", "黑龙江省佳木斯市",
"861879214", "安徽省合肥市",
"861352969", "云南省玉溪市",
"861453087", "安徽省铜陵市",
"861314431", "吉林省长春市",
"861360746", "湖南省永州市",
"861563313", "河北省张家口市",
"861471809", "广东省茂名市",
"861316524", "山东省德州市",
"861537568", "安徽省芜湖市",
"861356767", "浙江省舟山市",
"86182436", "吉林省白城市",
"861334781", "江苏省南京市",
"86139311", "河北省石家庄市",
"861303993", "黑龙江省大兴安岭地区",
"861527697", "新疆塔城地区",
"861782890", "四川省巴中市",
"861531917", "陕西省宝鸡市",
"861585285", "江苏省扬州市",
"861829403", "甘肃省平凉市",
"861315963", "吉林省延边朝鲜族自治州",
"861594949", "内蒙古鄂尔多斯市",
"861301357", "山东省威海市",
"861452714", "湖北省黄石市",
"861873621", "河南省周口市",
"861318621", "陕西省渭南市",
"861867255", "湖北省荆州市",
"861308173", "辽宁省营口市",
"861884588", "黑龙江省哈尔滨市",
"861350640", "山东省济南市",
"861816300", "湖北省黄冈市",
"86182539", "山东省临沂市",
"861365444", "吉林省四平市",
"861308598", "甘肃省天水市",
"861780294", "陕西省商洛市",
"861528565", "贵州省毕节地区",
"861324657", "河北省石家庄市",
"861593002", "河北省邯郸市",
"861477968", "江西省吉安市",
"861335558", "安徽省阜阳市",
"861339747", "湖南省衡阳市",
"861396649", "安徽省淮南市",
"86186381", "河南省郑州市",
"861386721", "浙江省舟山市",
"861508342", "河南省南阳市",
"861551938", "贵州省铜仁地区",
"861373259", "浙江省嘉兴市",
"861581309", "广东省阳江市",
"861362807", "四川省德阳市",
"861380424", "辽宁省大连市",
"861577148", "内蒙古巴彦淖尔市",
"861818656", "湖北省荆州市",
"861334937", "黑龙江省大兴安岭地区",
"861533547", "山东省济宁市",
"861341549", "广东省佛山市",
"861300989", "黑龙江省牡丹江市",
"861580322", "河北省保定市",
"861859536", "河南省周口市",
"861315144", "江苏省连云港市",
"861853452", "山西省晋城市",
"861309272", "湖北省黄冈市",
"86189283", "广东省惠州市",
"861453911", "广东省广州市",
"86157633", "山东省日照市",
"861311903", "新疆和田地区",
"861580550", "安徽省滁州市",
"861379988", "福建省泉州市",
"861850478", "内蒙古巴彦淖尔市",
"861886756", "浙江省金华市",
"861315473", "内蒙古乌海市",
"861362519", "江苏省泰州市",
"861813860", "广东省汕头市",
"86158444", "吉林省四平市",
"861804860", "四川省绵阳市",
"861869601", "湖北省荆门市",
"861378860", "广西南宁市",
"861835148", "江苏省盐城市",
"861826235", "江苏省盐城市",
"861772919", "陕西省铜川市",
"861342865", "广东省深圳市",
"861360377", "河南省南阳市",
"861459772", "新疆乌鲁木齐市",
"86132031", "湖南省长沙市",
"86180560", "安徽省合肥市",
"861306535", "辽宁省辽阳市",
"861876833", "浙江省嘉兴市",
"861881459", "黑龙江省大庆市",
"861801083", "安徽省宣城市",
"861811022", "安徽省蚌埠市",
"861890743", "湖南省湘西土家族苗族自治州",
"86186860", "内蒙古呼和浩特市",
"861563926", "河南省郑州市",
"8618323", "重庆市",
"861868890", "广东省广州市",
"861809350", "甘肃省金昌市",
"861825449", "山东省枣庄市",
"861802988", "广东省河源市",
"861807133", "湖北省恩施土家族苗族自治州",
"86184759", "广东省湛江市",
"861324780", "江西省南昌市",
"861810009", "上海市",
"861771172", "湖南省益阳市",
"86136213", "北京市",
"86170700", "北京市",
"861311562", "黑龙江省黑河市",
"86155507", "山东省菏泽市",
"861339376", "河南省平顶山市",
"861537131", "江苏省扬州市",
"861833385", "河北省唐山市",
"861780620", "山东省枣庄市",
"861860518", "江苏省连云港市",
"861365876", "云南省文山壮族苗族自治州",
"861303645", "四川省乐山市",
"861536190", "广东省湛江市",
"861800942", "甘肃省白银市",
"861332052", "云南省昆明市",
"861565708", "浙江省舟山市",
"861864528", "黑龙江省佳木斯市",
"861503653", "河南省焦作市",
"861520344", "山西省晋中市",
"861344338", "辽宁省沈阳市",
"861523849", "河南省周口市",
"861760757", "广东省佛山市",
"861521580", "浙江省台州市",
"861303867", "云南省曲靖市",
"861383908", "河南省新乡市",
"861300801", "山西省运城市",
"861840695", "云南省保山市",
"861881706", "湖南省郴州市",
"861524151", "辽宁省锦州市",
"861314867", "广东省阳江市",
"861708928", "广东省湛江市",
"861336568", "安徽省六安市",
"86130162", "海南省海口市",
"861816311", "湖北省襄樊市",
"861772770", "广东省东莞市",
"861893420", "广东省云浮市",
"861315002", "甘肃省兰州市",
"861508225", "四川省凉山彝族自治州",
"861514490", "内蒙古兴安盟",
"861569485", "河北省邢台市",
"861310184", "江苏省南京市",
"861366781", "广西南宁市",
"861316953", "广东省东莞市",
"86138323", "河北省石家庄市",
"86181966", "安徽省蚌埠市",
"861518127", "四川省攀枝花市",
"861317693", "山东省烟台市",
"861317450", "福建省福州市",
"861310396", "河南省驻马店市",
"861368949", "甘肃省张掖市",
"861856727", "河南省南阳市",
"861816564", "广东省江门市",
"86187837", "四川省阿坝藏族羌族自治州",
"861322488", "内蒙古巴彦淖尔市",
"861305949", "广东省肇庆市",
"861322321", "河北省保定市",
"861350928", "广东省广州市",
"861559392", "甘肃省陇南市",
"861370607", "福建省莆田市",
"861537278", "浙江省舟山市",
"861524997", "安徽省蚌埠市",
"86151511", "江苏省宿迁市",
"861452534", "山东省德州市",
"861355757", "广西南宁市",
"861390417", "辽宁省营口市",
"861384805", "内蒙古通辽市",
"861334871", "湖南省长沙市",
"861820489", "内蒙古呼和浩特市",
"861880974", "青海省海南藏族自治州",
"86187143", "黑龙江省齐齐哈尔市",
"861335058", "四川省德阳市",
"861326697", "广东省东莞市",
"861567871", "广西柳州市",
"861348172", "广西防城港市",
"861319357", "河南省濮阳市",
"861308098", "陕西省榆林市",
"861874098", "甘肃省武威市",
"861886761", "浙江省宁波市",
"861598568", "贵州省六盘水市",
"861528065", "福建省宁德市",
"861335136", "黑龙江省黑河市",
"861880464", "黑龙江省七台河市",
"86189690", "浙江省杭州市",
"861508160", "河北省邯郸市",
"861365786", "广西桂林市",
"861399702", "青海省海东地区",
"861337637", "山东省枣庄市",
"861874786", "内蒙古通辽市",
"861308786", "贵州省毕节地区",
"861357618", "江西省宜春市",
"861894467", "黑龙江省鸡西市",
"861550495", "辽宁省大连市",
"861309903", "山西省忻州市",
"861787779", "湖南省长沙市",
"861599519", "江苏省盐城市",
"861815316", "贵州省铜仁地区",
"861321283", "黑龙江省牡丹江市",
"861458689", "湖南省岳阳市",
"861471981", "新疆伊犁哈萨克自治州",
"86150841", "辽宁省锦州市",
"861381332", "江苏省淮安市",
"861878820", "云南省德宏傣族景颇族自治州",
"861304820", "广东省肇庆市",
"861362739", "湖南省邵阳市",
"861458286", "福建省莆田市",
"86137733", "江苏省扬州市",
"861773647", "河北省沧州市",
"861362019", "广东省江门市",
"861760680", "浙江省舟山市",
"861324870", "浙江省宁波市",
"861560382", "河南省新乡市",
"86184709", "江西省南昌市",
"861472619", "四川省成都市",
"861899754", "新疆昌吉回族自治州",
"861311062", "福建省龙岩市",
"86170750", "江苏省南京市",
"861335833", "福建省漳州市",
"861360484", "黑龙江省哈尔滨市",
"861306035", "陕西省咸阳市",
"861840943", "甘肃省白银市",
"861811522", "江苏省宿迁市",
"861332320", "河北省邯郸市",
"861509287", "山东省临沂市",
"861309562", "浙江省嘉兴市",
"861772992", "安徽省宣城市",
"861811350", "四川省广安市",
"861333626", "山东省德州市",
"86155625", "山东省济南市",
"861860738", "湖南省娄底市",
"861332552", "新疆喀什地区",
"861521907", "广东省清远市",
"86155557", "安徽省宿州市",
"861809022", "四川省阿坝藏族羌族自治州",
"861847132", "湖北省黄冈市",
"861388472", "山东省济宁市",
"861362592", "福建省漳州市",
"861829072", "新疆伊犁哈萨克自治州",
"861317945", "江苏省镇江市",
"861593144", "河北省石家庄市",
"861780948", "甘肃省天水市",
"861314510", "江苏省苏州市",
"861869045", "陕西省榆林市",
"86155285", "四川省绵阳市",
"861535777", "安徽省合肥市",
"861317751", "江西省上饶市",
"861332096", "四川省成都市",
"861360965", "广东省肇庆市",
"861453479", "黑龙江省双鸭山市",
"861378981", "山东省济南市",
"86187150", "安徽省合肥市",
"861351689", "浙江省金华市",
"861369372", "河南省安阳市",
"861593432", "山西省忻州市",
"861366480", "内蒙古兴安盟",
"861886539", "山东省临沂市",
"861348836", "陕西省宝鸡市",
"861452815", "四川省绵阳市",
"86155836", "四川省南充市",
"861589218", "福建省南平市",
"861705581", "贵州省贵阳市",
"861806343", "山东省济南市",
"861320318", "湖南省娄底市",
"861569474", "内蒙古乌兰察布市",
"861770565", "安徽省合肥市",
"861335872", "辽宁省阜新市",
"861310175", "河南省平顶山市",
"861303510", "湖北省武汉市",
"861773764", "河南省信阳市",
"86872", "云南省大理白族自治州",
"861859759", "福建省宁德市",
"861320227", "广东省深圳市",
"861514791", "内蒙古巴彦淖尔市",
"861536341", "广东省佛山市",
"861787593", "广东省梅州市",
"86151279", "河北省邢台市",
"861300277", "山东省泰安市",
"861346575", "山东省聊城市",
"861762547", "江苏省淮安市",
"861554298", "辽宁省铁岭市",
"86139934", "甘肃省庆阳市",
"861356830", "四川省眉山市",
"861534983", "安徽省安庆市",
"861388991", "广东省深圳市",
"86150684", "浙江省温州市",
"86138999", "新疆乌鲁木齐市",
"861300067", "浙江省温州市",
"861846708", "青海省西宁市",
"861515409", "山东省莱芜市",
"861854565", "黑龙江省哈尔滨市",
"861567207", "湖北省黄冈市",
"861809947", "新疆乌鲁木齐市",
"861559514", "宁夏吴忠市",
"861800527", "江苏省扬州市",
"86155661", "辽宁省沈阳市",
"86131200", "北京市",
"861846225", "山东省聊城市",
"861820577", "浙江省温州市",
"861555268", "山东省淄博市",
"861839290", "陕西省商洛市",
"861472656", "四川省雅安市",
"86176958", "天津市",
"86135491", "广东省梅州市",
"861598683", "广东省深圳市",
"86188611", "江苏省常州市",
"861870995", "新疆吐鲁番地区",
"861459513", "云南省临沧市",
"861532706", "湖北省孝感市",
"861586923", "浙江省丽水市",
"861474583", "黑龙江省哈尔滨市",
"861511979", "广东省清远市",
"861818692", "湖北省武汉市",
"86188458", "黑龙江省伊春市",
"861829858", "甘肃省张掖市",
"861569846", "山西省长治市",
"861551208", "河北省秦皇岛市",
"861595378", "山东省德州市",
"86178598", "福建省泉州市",
"861535346", "陕西省咸阳市",
"86135904", "广东省深圳市",
"861354170", "四川省德阳市",
"861870643", "山东省滨州市",
"861813737", "河南省郑州市",
"86170743", "吉林省长春市",
"861810439", "吉林省白山市",
"86177599", "福建省南平市",
"86187605", "福建省莆田市",
"86155193", "贵州省毕节地区",
"861804017", "辽宁省朝阳市",
"86187459", "黑龙江省大庆市",
"86136559", "福建省泉州市",
"861830789", "广西河池市",
"861399499", "山西省运城市",
"861804737", "内蒙古鄂尔多斯市",
"86133627", "浙江省温州市",
"861552572", "山西省运城市",
"861378737", "湖南省益阳市",
"861565109", "江苏省宿迁市",
"86159806", "福建省福州市",
"86182829", "四川省达州市",
"861330742", "湖南省常德市",
"86137502", "广东省河源市",
"861572429", "浙江省宁波市",
"86133606", "广东省东莞市",
"86159827", "四川省巴中市",
"861519443", "河南省洛阳市",
"8618461", "河南省郑州市",
"86187556", "安徽省安庆市",
"861341344", "广东省汕头市",
"861839624", "福建省泉州市",
"861362561", "安徽省淮北市",
"861505242", "江苏省无锡市",
"86184641", "山东省德州市",
"861310020", "湖南省岳阳市",
"861332788", "江苏省常州市",
"861311091", "福建省南平市",
"861891958", "青海省海西蒙古族藏族自治州",
"861568242", "四川省南充市",
"861453969", "广东省珠海市",
"861509710", "甘肃省庆阳市",
"861360475", "内蒙古通辽市",
"861810560", "安徽省合肥市",
"861319628", "吉林省四平市",
"861348457", "陕西省咸阳市",
"861569964", "黑龙江省七台河市",
"861500638", "山东省聊城市",
"861312438", "吉林省松原市",
"861362314", "河北省承德市",
"861886039", "河南省郑州市",
"861362556", "安徽省安庆市",
"861337341", "河北省石家庄市",
"861390315", "河北省唐山市",
"861303730", "湖南省岳阳市",
"86156176", "河南省郑州市",
"861599138", "陕西省西安市",
"861452339", "河南省濮阳市",
"861705081", "广东省深圳市",
"861886719", "浙江省金华市",
"861303010", "广东省韶关市",
"861860925", "陕西省渭南市",
"861478775", "云南省玉溪市",
"861869545", "宁夏银川市",
"861771133", "四川省巴中市",
"861392474", "广东省惠州市",
"861332596", "浙江省台州市",
"861557830", "广西南宁市",
"861853177", "河北省唐山市",
"861518904", "江苏省连云港市",
"86187100", "北京市",
"861882917", "陕西省宝鸡市",
"861560154", "江苏省苏州市",
"861393409", "山西省运城市",
"861829533", "宁夏吴忠市",
"861319455", "黑龙江省绥化市",
"861390707", "江西省赣州市",
"861786624", "湖北省襄樊市",
"861392143", "江苏省南京市",
"861530386", "河南省洛阳市",
"861537683", "山东省聊城市",
"861812446", "广东省肇庆市",
"861590802", "山东省潍坊市",
"861800027", "江西省赣州市",
"861512199", "宁夏中卫市",
"86131250", "湖北省武汉市",
"861806187", "江苏省常州市",
"861788521", "贵州省安顺市",
"861820077", "广东省湛江市",
"86185915", "陕西省渭南市",
"861454695", "广东省惠州市",
"861520549", "山东省临沂市",
"861559734", "青海省西宁市",
"861300567", "广东省茂名市",
"861303501", "安徽省蚌埠市",
"861877887", "广西钦州市",
"861559014", "吉林省吉林市",
"861454164", "浙江省宁波市",
"861881416", "广东省江门市",
"861315432", "吉林省吉林市",
"86130784", "广东省佛山市",
"861535887", "江苏省扬州市",
"861345540", "山东省德州市",
"861570978", "青海省西宁市",
"861862843", "陕西省渭南市",
"861459733", "湖南省长沙市",
"861816285", "湖北省黄冈市",
"861569387", "甘肃省兰州市",
"861858997", "广西柳州市",
"861473022", "河北省沧州市",
"861335782", "江苏省南京市",
"86158965", "河南省洛阳市",
"861554163", "辽宁省锦州市",
"86155374", "河南省许昌市",
"861454943", "福建省厦门市",
"861332878", "福建省厦门市",
"861880330", "河北省邯郸市",
"86135954", "贵州省黔南布依族苗族自治州",
"861570468", "黑龙江省鹤岗市",
"861378809", "广西钦州市",
"861804809", "四川省甘孜藏族自治州",
"861839703", "青海省黄南藏族自治州",
"86188408", "辽宁省大连市",
"861899855", "广东省茂名市",
"861308132", "辽宁省抚顺市",
"861882081", "广东省湛江市",
"861509701", "甘肃省金昌市",
"861350735", "湖南省郴州市",
"861362271", "广东省佛山市",
"861700541", "山东省济南市",
"86187527", "江苏省扬州市",
"86136509", "广东省广州市",
"86136427", "广东省广州市",
"861350015", "广东省揭阳市",
"861532459", "安徽省宣城市",
"86159856", "贵州省铜仁地区",
"861768917", "西藏阿里地区",
"861588579", "贵州省铜仁地区",
"861709921", "浙江省衢州市",
"86187655", "山东省德州市",
"861330308", "河北省邯郸市",
"861380613", "江苏省苏州市",
"861472661", "四川省巴中市",
"86136406", "广东省广州市",
"861310352", "山西省大同市",
"861352587", "河南省三门峡市",
"861475800", "浙江省舟山市",
"86170892", "广东省韶关市",
"86187506", "福建省泉州市",
"861321678", "浙江省绍兴市",
"861362061", "山西省太原市",
"861324217", "广东省江门市",
"86183018", "上海市",
"86177766", "广西南宁市",
"86156570", "浙江省衢州市",
"861781753", "广东省梅州市",
"861302654", "山东省东营市",
"86183602", "江苏省宿迁市",
"861317766", "江西省抚州市",
"861830879", "云南省普洱市",
"86137552", "江西省九江市",
"86150870", "云南省昆明市",
"861324481", "广东省广州市",
"861327340", "河北省石家庄市",
"861810060", "江苏省南京市",
"861894289", "四川省德阳市",
"861324328", "河南省新乡市",
"861501443", "广东省湛江市",
"861358126", "湖北省黄冈市",
"861319940", "黑龙江省大庆市",
"861304378", "河南省开封市",
"861894686", "青海省玉树藏族自治州",
"861821955", "广东省阳江市",
"861313378", "江西省宜春市",
"861525089", "江苏省淮安市",
"861311591", "福建省福州市",
"861550397", "河南省驻马店市",
"86153706", "江苏省南通市",
"861819668", "安徽省阜阳市",
"86188433", "吉林省延边朝鲜族自治州",
"861571412", "辽宁省鞍山市",
"861362874", "云南省曲靖市",
"861538770", "江西省鹰潭市",
"86184390", "河南省新乡市",
"86181509", "福建省泉州市",
"861590629", "江苏省南通市",
"861528909", "西藏拉萨市",
"861773917", "河南省焦作市",
"86181427", "辽宁省盘锦市",
"861580741", "湖南省怀化市",
"861306487", "江苏省盐城市",
"861357948", "新疆巴音郭楞蒙古自治州",
"86158741", "湖南省长沙市",
"861800699", "福建省泉州市",
"861457090", "江苏省淮安市",
"861880080", "四川省遂宁市",
"86182322", "河北省承德市",
"861306211", "福建省三明市",
"861785829", "浙江省舟山市",
"861556620", "辽宁省沈阳市",
"861843238", "河北省衡水市",
"86187644", "山东省济南市",
"861815132", "江苏省南通市",
"861830835", "四川省广元市",
"861363809", "贵州省黔东南苗族侗族自治州",
"861372257", "河北省秦皇岛市",
"861329557", "安徽省宿州市",
"861325748", "湖南省长沙市",
"861532549", "浙江省湖州市",
"861561429", "河北省邢台市",
"861510544", "山东省潍坊市",
"861892174", "江苏省泰州市",
"86134408", "上海市",
"861327422", "辽宁省朝阳市",
"861522665", "河北省廊坊市",
"861360060", "浙江省丽水市",
"86185628", "山东省青岛市",
"861350779", "广西北海市",
"861507200", "湖北省荆门市",
"861317615", "山东省聊城市",
"861302698", "广西河池市",
"861863378", "河北省廊坊市",
"861860520", "江苏省扬州市",
"861340330", "河北省邯郸市",
"861519053", "江苏省常州市",
"861861591", "山东省潍坊市",
"861504745", "内蒙古通辽市",
"861300934", "辽宁省锦州市",
"861369668", "安徽省阜阳市",
"861860352", "山西省晋中市",
"861321140", "广西柳州市",
"861320596", "福建省漳州市",
"861819155", "陕西省西安市",
"86178850", "贵州省贵阳市",
"861830392", "河南省鹤壁市",
"861312521", "江西省南昌市",
"861892443", "广东省河源市",
"86180306", "四川省成都市",
"861572169", "山西省运城市",
"86170990", "贵州省贵阳市",
"861869455", "浙江省杭州市",
"86189979", "新疆乌鲁木齐市",
"861560573", "浙江省嘉兴市",
"861846420", "山东省青岛市",
"861362446", "吉林省长春市",
"86152977", "江西省赣州市",
"861452089", "安徽省亳州市",
"861533681", "浙江省舟山市",
"861705331", "广东省深圳市",
"861301045", "江苏省苏州市",
"861355849", "广西北海市",
"861390785", "广西玉林市",
"861839495", "甘肃省陇南市",
"861827203", "湖北省襄樊市",
"861770636", "山东省潍坊市",
"861876399", "山东省济南市",
"861530158", "江苏省南京市",
"861813622", "江苏省扬州市",
"861803683", "江苏省苏州市",
"861350901", "广东省东莞市",
"861341416", "广东省江门市",
"861587708", "广西玉林市",
"861773081", "河南省安阳市",
"861319545", "安徽省合肥市",
"861858426", "四川省广元市",
"861333343", "山西省太原市",
"861814683", "陕西省西安市",
"861366369", "山西省朔州市",
"861761471", "内蒙古呼和浩特市",
"861771547", "江苏省南通市",
"861520459", "黑龙江省大庆市",
"861816207", "山东省潍坊市",
"861595662", "安徽省池州市",
"861569305", "甘肃省兰州市",
"861877414", "湖南省岳阳市",
"861808432", "贵州省黔东南苗族侗族自治州",
"861361947", "云南省玉溪市",
"861844704", "内蒙古呼和浩特市",
"861550413", "辽宁省抚顺市",
"861323852", "贵州省毕节地区",
"861780862", "贵州省毕节地区",
"861508721", "云南省昭通市",
"861300828", "辽宁省辽阳市",
"861569037", "河北省邢台市",
"861335312", "吉林省吉林市",
"86186250", "江苏省苏州市",
"861383921", "河南省鹤壁市",
"861569717", "湖北省武汉市",
"861836001", "江苏省泰州市",
"861565721", "浙江省丽水市",
"861891248", "江苏省无锡市",
"861831276", "广东省中山市",
"861320878", "云南省楚雄彝族自治州",
"861307503", "安徽省亳州市",
"861535414", "河北省承德市",
"861586444", "山东省菏泽市",
"861369812", "四川省绵阳市",
"861586598", "山东省东营市",
"861831679", "广东省梅州市",
"861538992", "新疆哈密地区",
"861898791", "云南省普洱市",
"861450414", "辽宁省本溪市",
"861357620", "江西省九江市",
"8618549", "北京市",
"861363737", "湖南省益阳市",
"861354648", "山西省运城市",
"861880580", "浙江省舟山市",
"861774842", "四川省泸州市",
"861881344", "广东省茂名市",
"861599874", "山东省泰安市",
"861313818", "广东省深圳市",
"861700976", "浙江省嘉兴市",
"861454424", "江苏省扬州市",
"861829894", "甘肃省金昌市",
"86181559", "安徽省黄山市",
"861520706", "江西省吉安市",
"86189370", "河南省商丘市",
"861391236", "江苏省无锡市",
"861830319", "河北省邢台市",
"86135017", "上海市",
"861329057", "河北省邯郸市",
"861350889", "云南省玉溪市",
"861518365", "四川省德阳市",
"861453641", "江苏省镇江市",
"861554423", "河南省洛阳市",
"861576796", "广东省湛江市",
"86138641", "山东省济南市",
"861870590", "福建省福州市",
"861512855", "河北省承德市",
"861303915", "吉林省吉林市",
"861770960", "安徽省滁州市",
"861352337", "河南省焦作市",
"861534726", "湖北省荆州市",
"861519553", "江苏省盐城市",
"861810475", "内蒙古通辽市",
"861800612", "江苏省常州市",
"861588035", "福建省龙岩市",
"861533355", "山西省长治市",
"861592668", "湖北省荆门市",
"861360560", "安徽省合肥市",
"861869628", "湖北省黄石市",
"861558633", "湖北省武汉市",
"861862438", "辽宁省大连市",
"861358976", "山东省烟台市",
"861314915", "陕西省安康市",
"861571499", "新疆喀什地区",
"861362784", "广西梧州市",
"86131402", "重庆市",
"861347473", "内蒙古呼和浩特市",
"861477842", "广东省广州市",
"861348547", "山西省晋中市",
"861521974", "广东省茂名市",
"861538880", "云南省西双版纳傣族自治州",
"86180356", "山西省晋城市",
"861346970", "湖北省武汉市",
"861502958", "陕西省渭南市",
"86132307", "河北省沧州市",
"861367726", "湖北省荆门市",
"86181456", "黑龙江省哈尔滨市",
"861326324", "甘肃省庆阳市",
"86531", "山东省济南市",
"86170817", "上海市",
"86130302", "广东省肇庆市",
"861458634", "湖北省襄樊市",
"861577506", "广东省湛江市",
"861539968", "安徽省阜阳市",
"861332318", "河北省衡水市",
"861346792", "湖南省湘潭市",
"861507793", "安徽省淮南市",
"861871843", "广东省阳江市",
"861452589", "福建省南平市",
"86131051", "山东省青岛市",
"861332134", "甘肃省临夏回族自治州",
"861301545", "山西省晋城市",
"861320788", "广西河池市",
"861528881", "山东省潍坊市",
"861521464", "黑龙江省七台河市",
"86147813", "四川省自贡市",
"86159198", "广东省深圳市",
"861539478", "内蒙古巴彦淖尔市",
"861394952", "河南省安阳市",
"861313662", "黑龙江省齐齐哈尔市",
"861365359", "山西省运城市",
"861319045", "辽宁省本溪市",
"861770470", "内蒙古呼伦贝尔市",
"86151172", "甘肃省兰州市",
"861538919", "陕西省铜川市",
"861308359", "江苏省镇江市",
"861867751", "广西贵港市",
"861705764", "湖南省长沙市",
"861810965", "安徽省蚌埠市",
"861530536", "山东省潍坊市",
"861313753", "河南省平顶山市",
"861363981", "河南省驻马店市",
"861812056", "湖北省武汉市",
"861339859", "贵州省黔西南布依族苗族自治州",
"861820434", "吉林省四平市",
"86134611", "河南省平顶山市",
"861335399", "河南省洛阳市",
"861893418", "广东省汕尾市",
"861787640", "广东省江门市",
"861522847", "四川省泸州市",
"861392305", "广东省江门市",
"861346539", "山东省临沂市",
"861338652", "浙江省杭州市",
"861879869", "贵州省遵义市",
"861370674", "浙江省宁波市",
"861347502", "山东省菏泽市",
"861822789", "四川省乐山市",
"861334369", "河南省南阳市",
"86157134", "河北省唐山市",
"861501838", "广东省汕头市",
"861478519", "贵州省黔西南布依族苗族自治州",
"861800868", "湖北省鄂州市",
"861880907", "新疆阿克苏地区",
"861350910", "陕西省咸阳市",
"861319250", "广东省汕尾市",
"861453435", "辽宁省丹东市",
"861567369", "湖南省益阳市",
"861586098", "福建省南平市",
"86157276", "江西省南昌市",
"861371556", "广东省中山市",
"861470936", "甘肃省白银市",
"861700466", "北京市",
"86152988", "江苏省苏州市",
"861509129", "陕西省延安市",
"861569537", "青海省海西蒙古族藏族自治州",
"861560263", "广东省河源市",
"861390875", "云南省保山市",
"861825016", "福建省福州市",
"861307003", "新疆阿克苏地区",
"861889063", "湖南省湘西土家族苗族自治州",
"86132230", "河南省郑州市",
"861459095", "广东省茂名市",
"861308316", "安徽省安庆市",
"861768647", "山东省潍坊市",
"861376670", "黑龙江省鹤岗市",
"861365316", "河北省廊坊市",
"861328463", "黑龙江省哈尔滨市",
"861538956", "陕西省延安市",
"861324301", "河南省安阳市",
"861853042", "河南省安阳市",
"861807047", "江西省赣州市",
"861345766", "广西桂林市",
"861812739", "广东省韶关市",
"861510349", "山西省朔州市",
"861513844", "河南省南阳市",
"861339816", "四川省成都市",
"86138709", "江西省南昌市",
"861505996", "福建省南平市",
"86157658", "黑龙江省大庆市",
"861589165", "陕西省咸阳市",
"861323896", "辽宁省盘锦市",
"86137708", "江苏省南京市",
"86158659", "山东省德州市",
"86151983", "云南省大理白族自治州",
"861816937", "湖南省益阳市",
"861582051", "广东省中山市",
"861306079", "广东省佛山市",
"861310018", "山西省晋中市",
"861707843", "云南省保山市",
"861360817", "四川省成都市",
"861361350", "山西省忻州市",
"861509728", "甘肃省天水市",
"861310738", "湖南省娄底市",
"861331390", "福建省南平市",
"861340464", "吉林省四平市",
"861330488", "黑龙江省双鸭山市",
"861521985", "广东省汕尾市",
"861812592", "广东省湛江市",
"861825059", "福建省三明市",
"861330321", "河北省石家庄市",
"861350231", "广东省河源市",
"861867945", "江西省南昌市",
"861776143", "四川省德阳市",
"861319610", "吉林省白城市",
"861362775", "广西玉林市",
"861830014", "广东省阳江市",
"861570729", "湖北省十堰市",
"861817150", "湖北省武汉市",
"861827491", "湖南省永州市",
"861830734", "湖南省衡阳市",
"861889273", "四川省广安市",
"861397299", "湖北省随州市",
"86156019", "上海市",
"861571702", "江西省九江市",
"861810484", "内蒙古呼和浩特市",
"86170923", "重庆市",
"861361522", "江苏省南通市",
"861770909", "四川省德阳市",
"861332442", "吉林省吉林市",
"861344796", "重庆市",
"861390393", "河南省濮阳市",
"861535704", "安徽省芜湖市",
"861834524", "黑龙江省鹤岗市",
"861302800", "山西省运城市",
"861320552", "安徽省蚌埠市",
"861776964", "浙江省嘉兴市",
"861313691", "黑龙江省绥化市",
"861453505", "山东省东营市",
"861373949", "四川省成都市",
"861837490", "湖南省岳阳市",
"861777155", "湖北省荆门市",
"861830356", "山西省晋城市",
"861558181", "山西省太原市",
"861516040", "福建省泉州市",
"861334064", "四川省遂宁市",
"86147927", "安徽省阜阳市",
"861475654", "河北省唐山市",
"861366564", "安徽省六安市",
"861304691", "河南省平顶山市",
"861818949", "甘肃省酒泉市",
"861860396", "河南省驻马店市",
"86151049", "内蒙古呼伦贝尔市",
"861569407", "四川省泸州市",
"861763549", "山西省吕梁市",
"861770771", "广西南宁市",
"86178061", "山东省临沂市",
"861314528", "内蒙古呼伦贝尔市",
"861567064", "河南省信阳市",
"861317540", "浙江省金华市",
"861347432", "陕西省汉中市",
"861766639", "广东省江门市",
"861346409", "辽宁省铁岭市",
"861864867", "内蒙古鄂尔多斯市",
"861366311", "河北省石家庄市",
"86159581", "浙江省杭州市",
"861320320", "湖南省湘潭市",
"861323578", "浙江省丽水市",
"861814068", "湖北省武汉市",
"861589220", "四川省自贡市",
"861865002", "福建省厦门市",
"861536722", "湖南省湘西土家族苗族自治州",
"861303528", "湖北省十堰市",
"861893342", "广东省中山市",
"861452477", "黑龙江省哈尔滨市",
"861390884", "云南省昆明市",
"861530406", "辽宁省丹东市",
"861803278", "河北省石家庄市",
"861839397", "甘肃省酒泉市",
"861393389", "河北省保定市",
"861374897", "河南省郑州市",
"861869357", "甘肃省兰州市",
"861808897", "云南省丽江市",
"861563873", "河南省洛阳市",
"861350093", "吉林省白山市",
"86188968", "江苏省苏州市",
"861395630", "安徽省滁州市",
"861351634", "山东省莱芜市",
"861820504", "江苏省镇江市",
"861377752", "浙江省金华市",
"861384887", "内蒙古赤峰市",
"861764063", "辽宁省葫芦岛市",
"861318982", "广东省湛江市",
"861308923", "吉林省四平市",
"86931", "甘肃省兰州市",
"86187969", "江苏省常州市",
"86155918", "陕西省西安市",
"861334300", "河北省邯郸市",
"861874054", "陕西省商洛市",
"861370685", "浙江省绍兴市",
"861776846", "江苏省淮安市",
"86147906", "安徽省安庆市",
"861305661", "四川省眉山市",
"861563497", "山西省太原市",
"861807547", "安徽省淮北市",
"861560799", "江西省萍乡市",
"861865473", "山东省潍坊市",
"861700750", "广东省江门市",
"86138759", "湖南省长沙市",
"861587109", "湖北省十堰市",
"86157608", "海南省海口市",
"861389954", "新疆伊犁哈萨克自治州",
"861319601", "吉林省长春市",
"861870913", "陕西省渭南市",
"861471622", "广东省揭阳市",
"861810377", "河南省南阳市",
"861329103", "江苏省徐州市",
"861530759", "广东省湛江市",
"861305656", "四川省雅安市",
"86158455", "黑龙江省绥化市",
"861812807", "广东省肇庆市",
"861338299", "江苏省镇江市",
"861581267", "广东省潮州市",
"861582551", "浙江省杭州市",
"861306579", "浙江省绍兴市",
"861370351", "山西省太原市",
"861857206", "湖北省襄樊市",
"861381582", "江苏省扬州市",
"861538471", "内蒙古呼和浩特市",
"861338696", "福建省漳州市",
"861528960", "广西柳州市",
"861865144", "江苏省扬州市",
"861588405", "四川省甘孜藏族自治州",
"861826069", "江苏省扬州市",
"86137758", "江苏省徐州市",
"861808144", "四川省广元市",
"86138670", "浙江省丽水市",
"861324310", "河南省漯河市",
"861560532", "山东省青岛市",
"861806626", "浙江省温州市",
"861597956", "江西省抚州市",
"861893160", "河北省邯郸市",
"861552894", "四川省巴中市",
"861826676", "山东省济宁市",
"861806229", "湖北省黄石市",
"861815876", "浙江省嘉兴市",
"861889902", "新疆伊犁哈萨克自治州",
"861787515", "广东省揭阳市",
"861826279", "江苏省连云港市",
"861533133", "西藏拉萨市",
"861596696", "山东省淄博市",
"861855513", "安徽省芜湖市",
"861301610", "湖南省郴州市",
"861500363", "青海省海东地区",
"861394996", "河南省周口市",
"861452893", "云南省红河哈尼族彝族自治州",
"861873890", "河南省平顶山市",
"861803131", "河北省唐山市",
"86131860", "陕西省西安市",
"86187360", "河南省郑州市",
"861318890", "山东省滨州市",
"861351840", "四川省眉山市",
"861833035", "河北省秦皇岛市",
"861518467", "黑龙江省双鸭山市",
"86181213", "上海市",
"861864993", "福建省厦门市",
"861537827", "四川省宜宾市",
"861516540", "山东省菏泽市",
"861334564", "安徽省六安市",
"861344588", "云南省昆明市",
"861810746", "湖南省永州市",
"861372617", "广东省江门市",
"861568167", "四川省巴中市",
"861375431", "浙江省杭州市",
"861708593", "福建省福州市",
"861478561", "贵州省黔南布依族苗族自治州",
"861346334", "河北省承德市",
"861306930", "河南省开封市",
"861582679", "湖北省孝感市",
"861337722", "广西柳州市",
"861390774", "广西梧州市",
"861334311", "河北省石家庄市",
"861899586", "湖北省荆州市",
"861303028", "广东省云浮市",
"861453337", "浙江省衢州市",
"861317040", "湖南省长沙市",
"861478314", "河南省三门峡市",
"861803568", "山西省晋中市",
"86187881", "云南省昆明市",
"861815444", "湖北省襄樊市",
"86130481", "广东省江门市",
"861576752", "广东省汕头市",
"861450623", "黑龙江省齐齐哈尔市",
"861780891", "西藏拉萨市",
"861323268", "广东省湛江市",
"86135464", "山西省太原市",
"861328202", "浙江省杭州市",
"861538961", "陕西省渭南市",
"861898762", "云南省文山壮族苗族自治州",
"861886084", "江苏省南京市",
"861576663", "广东省湛江市",
"861376857", "广西柳州市",
"861508420", "辽宁省朝阳市",
"861893225", "江苏省盐城市",
"861569280", "四川省达州市",
"861335448", "山东省枣庄市",
"861374963", "河南省驻马店市",
"86155694", "新疆喀什地区",
"86147956", "广西南宁市",
"861816871", "江苏省苏州市",
"861317255", "广东省潮州市",
"861868621", "内蒙古赤峰市",
"861870326", "河北省廊坊市",
"861533836", "广东省东莞市",
"861365554", "安徽省淮南市",
"861780258", "江苏省宿迁市",
"861805621", "安徽省铜陵市",
"861770881", "云南省西双版纳傣族自治州",
"861580955", "宁夏中卫市",
"861308554", "安徽省淮南市",
"861366300", "河南省郑州市",
"861815173", "江苏省常州市",
"861351348", "河北省沧州市",
"861318398", "四川省德阳市",
"861308932", "吉林省延边朝鲜族自治州",
"86135012", "北京市",
"861332067", "四川省阿坝藏族羌族自治州",
"861884644", "黑龙江省哈尔滨市",
"861365932", "甘肃省兰州市",
"86135608", "广东省东莞市",
"861572435", "辽宁省铁岭市",
"861518542", "贵州省安顺市",
"861454143", "吉林省延边朝鲜族自治州",
"861772853", "广东省江门市",
"861700926", "山东省潍坊市",
"861454474", "陕西省商洛市",
"861550351", "山西省太原市",
"861311557", "黑龙江省双鸭山市",
"861890647", "山东省东营市",
"861862864", "陕西省汉中市",
"861398013", "四川省绵阳市",
"86130326", "河北省石家庄市",
"86155758", "湖南省长沙市",
"861709546", "江苏省苏州市",
"861554144", "辽宁省铁岭市",
"861868354", "四川省绵阳市",
"861782016", "广东省梅州市",
"861555645", "安徽省合肥市",
"861300096", "新疆乌鲁木齐市",
"86138310", "河北省邯郸市",
"861347423", "陕西省榆林市",
"86182356", "山西省晋城市",
"86131407", "江苏省南京市",
"861590566", "安徽省池州市",
"86183098", "辽宁省沈阳市",
"861585043", "江苏省扬州市",
"861306324", "安徽省宣城市",
"861380280", "广东省广州市",
"861522958", "陕西省咸阳市",
"861339995", "新疆吐鲁番地区",
"86170812", "天津市",
"861326374", "广西梧州市",
"861536733", "湖南省长沙市",
"86132302", "河北省保定市",
"861367776", "广西百色市",
"861551739", "河南省许昌市",
"861346920", "湖南省郴州市",
"861337513", "江苏省徐州市",
"861850769", "广东省东莞市",
"861810425", "辽宁省丹东市",
"861806011", "福建省福州市",
"861323915", "陕西省安康市",
"861305302", "安徽省六安市",
"861594748", "内蒙古巴彦淖尔市",
"861820612", "江苏省常州市",
"861821155", "广东省深圳市",
"861571840", "广东省佛山市",
"861343156", "广东省珠海市",
"861319140", "内蒙古呼和浩特市",
"861776613", "江苏省淮安市",
"861885145", "江苏省宿迁市",
"861807790", "广西玉林市",
"861841916", "甘肃省兰州市",
"861379789", "湖北省荆门市",
"861535288", "内蒙古鄂尔多斯市",
"861369440", "吉林省四平市",
"861302742", "湖南省长沙市",
"861555993", "云南省保山市",
"861887298", "湖北省随州市",
"861328359", "山西省运城市",
"861354719", "四川省广元市",
"861800434", "吉林省四平市",
"861772038", "湖北省荆门市",
"861846239", "山东省菏泽市",
"861772718", "广东省东莞市",
"861856704", "河南省开封市",
"861361533", "山东省淄博市",
"861838883", "云南省临沧市",
"861502847", "河北省邯郸市",
"861599938", "新疆和田地区",
"861588130", "四川省自贡市",
"861339643", "山东省淄博市",
"86139638", "山东省烟台市",
"861452242", "浙江省嘉兴市",
"861554502", "黑龙江省齐齐哈尔市",
"861530994", "新疆昌吉回族自治州",
"861331076", "贵州省铜仁地区",
"861336201", "浙江省衢州市",
"861532638", "吉林省松原市",
"861539381", "云南省西双版纳傣族自治州",
"861560954", "宁夏固原市",
"86159920", "广东省清远市",
"86134340", "广东省东莞市",
"861573152", "四川省成都市",
"861454964", "黑龙江省齐齐哈尔市",
"861700313", "河北省保定市",
"861331266", "云南省红河哈尼族彝族自治州",
"861367347", "河南省信阳市",
"861868016", "广东省中山市",
"86181021", "天津市",
"86150988", "山东省济南市",
"861356663", "浙江省宁波市",
"861390825", "重庆市",
"861509179", "陕西省汉中市",
"861572641", "山东省济南市",
"861343853", "四川省攀枝花市",
"861512999", "陕西省宝鸡市",
"861857448", "湖南省张家界市",
"861801245", "江苏省无锡市",
"861554963", "湖北省孝感市",
"86137694", "云南省红河哈尼族彝族自治州",
"861858197", "四川省成都市",
"861811147", "四川省宜宾市",
"861570178", "甘肃省酒泉市",
"861580583", "浙江省嘉兴市",
"861372383", "湖南省衡阳市",
"861845445", "山东省聊城市",
"861802789", "广东省汕尾市",
"861389532", "宁夏石嘴山市",
"861879742", "湖南省株洲市",
"86176654", "广东省广州市",
"861811894", "江苏省盐城市",
"861785879", "浙江省嘉兴市",
"861459341", "四川省乐山市",
"86185016", "上海市",
"861832027", "广东省湛江市",
"861775032", "福建省福州市",
"861309557", "安徽省宿州市",
"861368748", "广东省揭阳市",
"861808614", "湖北省黄冈市",
"861332567", "新疆克拉玛依市",
"86135658", "新疆乌鲁木齐市",
"861583512", "山西省太原市",
"861565909", "福建省泉州市",
"86181422", "天津市",
"861590679", "浙江省金华市",
"861576914", "陕西省商洛市",
"861394815", "内蒙古通辽市",
"861538720", "湖北省黄冈市",
"861331898", "广东省珠海市",
"861450632", "黑龙江省佳木斯市",
"861348491", "陕西省西安市",
"861850410", "辽宁省铁岭市",
"861820699", "云南省大理白族自治州",
"861708729", "江西省宜春市",
"86177519", "江苏省徐州市",
"86155113", "河北省石家庄市",
"861530248", "广东省广州市",
"861326487", "湖北省孝感市",
"86182327", "河北省沧州市",
"861311057", "福建省南平市",
"86158066", "山东省济南市",
"86180322", "河北省石家庄市",
"861361858", "贵州省贵阳市",
"86147716", "湖北省武汉市",
"861840485", "内蒙古通辽市",
"861769830", "河南省安阳市",
"861592955", "陕西省西安市",
"86130357", "广东省梅州市",
"861396720", "浙江省舟山市",
"861301140", "河北省保定市",
"86132352", "江苏省扬州市",
"861779055", "四川省成都市",
"861454387", "贵州省毕节地区",
"861583099", "河北省石家庄市",
"861503680", "河南省周口市",
"861300596", "广西玉林市",
"861312571", "吉林省吉林市",
"861853831", "河南省郑州市",
"861894452", "黑龙江省齐齐哈尔市",
"861846960", "云南省丽江市",
"86182306", "湖南省邵阳市",
"861521553", "安徽省芜湖市",
"86131457", "广东省广州市",
"86177416", "辽宁省锦州市",
"861773743", "河南省安阳市",
"861829257", "陕西省西安市",
"861350729", "湖北省孝感市",
"861872557", "安徽省宿州市",
"861527200", "湖北省孝感市",
"861327472", "内蒙古包头市",
"861322698", "广东省佛山市",
"861351702", "江西省九江市",
"861316980", "广东省江门市",
"861863481", "山西省运城市",
"861479705", "青海省果洛藏族自治州",
"861337733", "广西桂林市",
"861897186", "湖北省荆门市",
"861860570", "浙江省衢州市",
"861320934", "甘肃省庆阳市",
"861326793", "广东省惠州市",
"861512912", "陕西省榆林市",
"861823683", "河南省许昌市",
"861360694", "福建省厦门市",
"861319362", "河南省周口市",
"861361713", "湖北省黄冈市",
"86159738", "湖南省娄底市",
"861813672", "江苏省常州市",
"861592440", "内蒙古鄂尔多斯市",
"861803415", "河北省唐山市",
"861529935", "新疆巴音郭楞蒙古自治州",
"861813181", "河北省衡水市",
"861519464", "河南省开封市",
"861590551", "安徽省合肥市",
"861804672", "江西省九江市",
"861362938", "甘肃省天水市",
"861334808", "江苏省南通市",
"86180218", "江苏省盐城市",
"861372147", "河南省焦作市",
"861819050", "四川省德阳市",
"861560523", "江苏省淮安市",
"861355762", "广西柳州市",
"861370703", "江西省上饶市",
"861554002", "内蒙古兴安盟",
"86150977", "河北省保定市",
"86136220", "天津市",
"861316819", "广东省阳江市",
"861846470", "山东省济宁市",
"861814804", "四川省泸州市",
"861555867", "浙江省金华市",
"86152972", "青海省海东地区",
"861569943", "新疆和田地区",
"861533122", "山东省济南市",
"861321045", "山东省聊城市",
"861320828", "四川省绵阳市",
"861886025", "河南省新乡市",
"861857094", "湖南省衡阳市",
"861831226", "广东省惠州市",
"861457195", "浙江省绍兴市",
"861452325", "河南省平顶山市",
"861528721", "云南省大理白族自治州",
"861327503", "福建省龙岩市",
"861893284", "河北省张家口市",
"861333905", "安徽省马鞍山市",
"861860939", "甘肃省陇南市",
"861508771", "云南省玉溪市",
"861890865", "湖北省武汉市",
"861570093", "新疆哈密地区",
"861386565", "安徽省马鞍山市",
"861831629", "广东省云浮市",
"861317797", "江西省赣州市",
"861826105", "江苏省泰州市",
"861589509", "江苏省淮安市",
"861571634", "河南省焦作市",
"86138919", "陕西省西安市",
"861385240", "江苏省扬州市",
"861500459", "黑龙江省大庆市",
"861870664", "山东省滨州市",
"861511179", "青海省海东地区",
"861314852", "广东省中山市",
"861476326", "山东省青岛市",
"861761421", "辽宁省朝阳市",
"861389712", "青海省海东地区",
"861760653", "浙江省杭州市",
"861302308", "安徽省合肥市",
"861550685", "广西百色市",
"861471633", "广东省云浮市",
"86188691", "云南省西双版纳傣族自治州",
"861514757", "内蒙古通辽市",
"86135411", "四川省成都市",
"861303852", "陕西省商洛市",
"861760762", "广东省河源市",
"861458499", "山东省烟台市",
"86183594", "福建省泉州市",
"861859958", "福建省莆田市",
"861383492", "山西省晋城市",
"861306529", "辽宁省盘锦市",
"861381249", "江苏省泰州市",
"861332810", "江苏省无锡市",
"861568034", "四川省攀枝花市",
"86182086", "贵州省黔西南布依族苗族自治州",
"861895451", "山东省济南市",
"861508960", "广东省茂名市",
"86189610", "江苏省泰州市",
"861538388", "河北省秦皇岛市",
"861565960", "福建省泉州市",
"861348790", "湖南省常德市",
"861477711", "广西南宁市",
"861876660", "山东省东营市",
"861766548", "广东省深圳市",
"861828473", "四川省泸州市",
"861573384", "河北省张家口市",
"86152183", "广东省茂名市",
"861570889", "云南省丽江市",
"861361262", "广东省佛山市",
"861561587", "山东省济宁市",
"861808423", "贵州省黔南布依族苗族自治州",
"861373482", "内蒙古兴安盟",
"861810327", "河北省沧州市",
"861356796", "浙江省湖州市",
"861598493", "四川省德阳市",
"861309103", "河北省石家庄市",
"86147044", "广东省广州市",
"861835620", "安徽省芜湖市",
"861366690", "福建省莆田市",
"861366453", "黑龙江省牡丹江市",
"861873449", "山西省长治市",
"861813633", "江苏省宿迁市",
"861870747", "湖南省永州市",
"861380537", "山东省济宁市",
"861777550", "四川省乐山市",
"861500416", "辽宁省锦州市",
"861774031", "河北省邯郸市",
"861527269", "湖北省咸宁市",
"861367950", "广东省清远市",
"861336493", "新疆哈密地区",
"861318449", "浙江省金华市",
"861367631", "山东省威海市",
"861351499", "安徽省合肥市",
"86145028", "内蒙古呼和浩特市",
"86136680", "重庆市",
"861511778", "贵州省安顺市",
"861336931", "甘肃省兰州市",
"861304310", "河北省邯郸市",
"86153942", "浙江省杭州市",
"861534631", "河南省濮阳市",
"86187728", "湖北省十堰市",
"861534950", "宁夏银川市",
"861862765", "湖南省衡阳市",
"861564990", "河南省商丘市",
"861840474", "内蒙古乌兰察布市",
"861772192", "四川省南充市",
"86130078", "贵州省贵阳市",
"861313310", "山西省忻州市",
"861303078", "辽宁省铁岭市",
"861340553", "江苏省泰州市",
"861343192", "广东省珠海市",
"861857399", "湖南省湘西土家族苗族自治州",
"861388162", "四川省雅安市",
"861390724", "湖北省咸宁市",
"861338306", "河北省沧州市",
"861355791", "广西南宁市",
"861367445", "吉林省通化市",
"861800360", "黑龙江省哈尔滨市",
"861315298", "山西省吕梁市",
"861840964", "宁夏固原市",
"861364877", "云南省玉溪市",
"86186967", "重庆市",
"861707261", "湖北省咸宁市",
"861327991", "新疆乌鲁木齐市",
"861534445", "湖南省怀化市",
"861327433", "吉林省延边朝鲜族自治州",
"861315851", "四川省南充市",
"861319391", "河南省漯河市",
"86136336", "黑龙江省哈尔滨市",
"861775263", "湖南省湘西土家族苗族自治州",
"861832942", "陕西省榆林市",
"861890331", "河北省石家庄市",
"86134371", "湖北省武汉市",
"861589439", "云南省丽江市",
"861310984", "辽宁省大连市",
"861866574", "广东省广州市",
"86134303", "广东省广州市",
"861816821", "江苏省徐州市",
"861332989", "湖北省随州市",
"861453768", "广西南宁市",
"861524197", "辽宁省辽阳市",
"86187339", "河北省邢台市",
"86151591", "福建省三明市",
"861760791", "江西省南昌市",
"861328554", "安徽省淮南市",
"861870376", "河南省信阳市",
"861327157", "河南省郑州市",
"861570910", "陕西省西安市",
"861596306", "山东省济宁市",
"861335936", "甘肃省张掖市",
"861535673", "浙江省嘉兴市",
"861354761", "四川省攀枝花市",
"86132481", "上海市",
"861840846", "宁夏固原市",
"861772408", "广东省韶关市",
"86135276", "广东省广州市",
"861336787", "广西梧州市",
"861536882", "云南省德宏傣族景颇族自治州",
"861314268", "江苏省南通市",
"861308202", "河北省邢台市",
"861893275", "河北省沧州市",
"86188338", "河北省秦皇岛市",
"861528420", "河北省邯郸市",
"861351412", "辽宁省鞍山市",
"861311103", "山西省晋中市",
"861871616", "四川省宜宾市",
"861579803", "江西省抚州市",
"861398990", "西藏拉萨市",
"861315944", "福建省莆田市",
"861850531", "山东省济南市",
"861300189", "河北省石家庄市",
"861505534", "安徽省芜湖市",
"861840387", "黑龙江省大兴安岭地区",
"861871219", "安徽省安庆市",
"861334137", "湖南省益阳市",
"861577948", "江西省景德镇市",
"861551314", "山西省长治市",
"861568534", "贵州省遵义市",
"861454485", "湖北省宜昌市",
"86130087", "甘肃省兰州市",
"86157945", "上海市",
"861476590", "重庆市",
"861340838", "四川省德阳市",
"861567137", "湖北省荆州市",
"861308463", "浙江省温州市",
"861860606", "福建省福州市",
"861527579", "山东省临沂市",
"861304301", "河南省郑州市",
"861766048", "山东省潍坊市",
"861310367", "河南省南阳市",
"861313301", "山西省太原市",
"861335660", "山东省东营市",
"861511888", "广东省广州市",
"861354756", "四川省南充市",
"861379188", "山东省潍坊市",
"861333235", "辽宁省铁岭市",
"861860209", "广东省东莞市",
"861516145", "江苏省南京市",
"861771972", "陕西省商洛市",
"861580812", "四川省攀枝花市",
"861364650", "浙江省舟山市",
"861573477", "内蒙古鄂尔多斯市",
"861364931", "甘肃省兰州市",
"86133480", "江苏省苏州市",
"861807491", "广西南宁市",
"861570779", "广西北海市",
"861334690", "河南省驻马店市",
"861524966", "河南省郑州市",
"86178797", "江西省赣州市",
"86187930", "甘肃省临夏回族自治州",
"861380037", "河南省商丘市",
"861361572", "浙江省湖州市",
"861811795", "四川省泸州市",
"861858745", "广西百色市",
"861845886", "浙江省杭州市",
"861850700", "江西省南昌市",
"861383419", "山西省朔州市",
"861556506", "河南省郑州市",
"861326385", "广西来宾市",
"861800142", "江苏省泰州市",
"861567690", "广西来宾市",
"861816043", "新疆乌鲁木齐市",
"861536990", "河北省衡水市",
"861477700", "广西南宁市",
"86139154", "江苏省苏州市",
"86181065", "浙江省杭州市",
"861775402", "安徽省安庆市",
"861897012", "江西省赣州市",
"861315866", "四川省德阳市",
"861330371", "河南省郑州市",
"861868059", "广东省中山市",
"861537931", "甘肃省武威市",
"86156780", "广西柳州市",
"861566631", "山东省威海市",
"861572505", "山东省日照市",
"861529205", "湖南省益阳市",
"861561911", "陕西省延安市",
"86354", "山西省晋中市",
"861781780", "广东省佛山市",
"861893565", "青海省果洛藏族自治州",
"861336877", "云南省玉溪市",
"861888122", "四川省攀枝花市",
"861452427", "辽宁省盘锦市",
"861536772", "湖南省益阳市",
"861301391", "江苏省宿迁市",
"861320370", "河南省郑州市",
"861589270", "四川省眉山市",
"861340924", "河南省新乡市",
"86134664", "北京市",
"861894496", "湖南省永州市",
"861303193", "河北省张家口市",
"861458348", "江西省景德镇市",
"861513426", "辽宁省盘锦市",
"86139391", "河南省焦作市",
"861573967", "新疆哈密地区",
"86186332", "河北省保定市",
"861570901", "新疆博尔塔拉蒙古自治州",
"861866074", "山东省济南市",
"861311806", "四川省内江市",
"86134353", "广东省河源市",
"861770721", "湖北省荆门市",
"861324691", "广东省揭阳市",
"861566445", "山东省泰安市",
"861591734", "广东省江门市",
"86147922", "陕西省西安市",
"861314193", "甘肃省天水市",
"86132269", "广东省江门市",
"861814317", "吉林省辽源市",
"861889454", "甘肃省白银市",
"861316861", "广东省惠州市",
"86130574", "江苏省苏州市",
"861874973", "河南省洛阳市",
"861308973", "黑龙江省齐齐哈尔市",
"861841959", "甘肃省庆阳市",
"861881638", "山东省烟台市",
"861315163", "江苏省苏州市",
"861337882", "云南省德宏傣族景颇族自治州",
"861354334", "广东省深圳市",
"861508239", "四川省攀枝花市",
"861325661", "山东省聊城市",
"861803317", "广东省韶关市",
"861370413", "辽宁省抚顺市",
"861564882", "内蒙古赤峰市",
"861470312", "河北省保定市",
"86185272", "湖北省恩施土家族苗族自治州",
"861593298", "江西省抚州市",
"861817240", "广西南宁市",
"861364787", "广西南宁市",
"861800504", "福建省莆田市",
"861557088", "湖南省长沙市",
"861369729", "湖北省宜昌市",
"861773447", "河北省沧州市",
"86151189", "广东省惠州市",
"861770749", "湖南省邵阳市",
"861760480", "内蒙古阿拉善盟",
"86137919", "山东省青岛市",
"861876025", "福建省三明市",
"861301215", "河北省石家庄市",
"861550695", "福建省泉州市",
"86156561", "安徽省淮北市",
"861458489", "山东省淄博市",
"86150861", "贵州省黔南布依族苗族自治州",
"861311117", "山西省临汾市",
"861457185", "浙江省台州市",
"861352566", "河南省南阳市",
"861709748", "广东省佛山市",
"86155175", "河南省郑州市",
"861523300", "河北省衡水市",
"861346822", "山东省莱芜市",
"861514224", "辽宁省鞍山市",
"861507823", "广西百色市",
"861705557", "湖南省长沙市",
"86139986", "辽宁省大连市",
"86187691", "山东省威海市",
"861893294", "河北省石家庄市",
"861475102", "江苏省无锡市",
"861813957", "新疆喀什地区",
"861867705", "广西南宁市",
"861389879", "辽宁省葫芦岛市",
"861378957", "内蒙古鄂尔多斯市",
"861880664", "广东省深圳市",
"861576123", "贵州省黔南布依族苗族自治州",
"861536861", "云南省西双版纳傣族自治州",
"86138918", "陕西省西安市",
"861895130", "江苏省南通市",
"861591382", "广东省东莞市",
"861388672", "湖北省宜昌市",
"861392351", "广东省潮州市",
"86139435", "吉林省通化市",
"861869410", "甘肃省甘南藏族自治州",
"861590768", "广东省潮州市",
"861889308", "甘肃省天水市",
"861779115", "陕西省延安市",
"861811393", "四川省南充市",
"861858343", "四川省广元市",
"86150636", "山东省潍坊市",
"861505627", "安徽省宣城市",
"861326783", "河北省石家庄市",
"861360684", "浙江省宁波市",
"86159739", "湖南省邵阳市",
"861339330", "河北省秦皇岛市",
"861316772", "安徽省合肥市",
"86186916", "陕西省汉中市",
"861478646", "湖南省衡阳市",
"861534578", "浙江省丽水市",
"861874830", "内蒙古阿拉善盟",
"861804191", "辽宁省辽阳市",
"861594546", "黑龙江省哈尔滨市",
"861308830", "四川省资阳市",
"86182737", "湖南省益阳市",
"861362323", "河北省张家口市",
"861343516", "广东省江门市",
"86180732", "湖南省长沙市",
"861317650", "山东省青岛市",
"861573099", "甘肃省庆阳市",
"861317931", "江苏省常州市",
"861351577", "浙江省温州市",
"861510371", "河南省郑州市",
"861535866", "江苏省淮安市",
"861322688", "广东省汕尾市",
"861362916", "陕西省汉中市",
"861569366", "甘肃省张掖市",
"861316990", "广东省深圳市",
"86132590", "陕西省咸阳市",
"86181946", "青海省海东地区",
"861576826", "广东省惠州市",
"861897196", "湖北省孝感市",
"861507541", "河北省石家庄市",
"861840495", "山西省长治市",
"861306041", "陕西省西安市",
"861893620", "江苏省南通市",
"86150380", "河南省郑州市",
"861859939", "新疆伊犁哈萨克自治州",
"861837543", "山东省滨州市",
"861454397", "贵州省毕节地区",
"861475544", "安徽省淮南市",
"861829724", "青海省海南藏族自治州",
"861503690", "河南省驻马店市",
"86151480", "内蒙古呼和浩特市",
"861341946", "四川省巴中市",
"86135770", "云南省昆明市",
"861809774", "新疆克拉玛依市",
"861336145", "山东省潍坊市",
"861819110", "陕西省西安市",
"861337856", "贵州省铜仁地区",
"861887632", "福建省漳州市",
"861348481", "陕西省西安市",
"861515660", "安徽省池州市",
"861559523", "宁夏吴忠市",
"861533301", "山西省太原市",
"861530367", "黑龙江省鸡西市",
"86155709", "湖南省衡阳市",
"861583375", "河北省沧州市",
"861801101", "四川省泸州市",
"861361417", "辽宁省营口市",
"861476237", "江苏省泰州市",
"86177518", "江苏省连云港市",
"861326497", "湖北省武汉市",
"861550943", "甘肃省白银市",
"861504235", "辽宁省抚顺市",
"861818709", "云南省临沧市",
"861459524", "云南省玉溪市",
"86135405", "四川省乐山市",
"861390617", "江苏省无锡市",
"861562252", "广东省东莞市",
"86157066", "广东省茂名市",
"861597449", "湖南省常德市",
"861534896", "西藏那曲地区",
"861831337", "云南省普洱市",
"86184557", "安徽省宿州市",
"861342447", "广东省广州市",
"861803303", "广东省东莞市",
"861373461", "青海省西宁市",
"861370407", "辽宁省营口市",
"861556109", "内蒙古包头市",
"86135659", "新疆乌鲁木齐市",
"861869401", "湖北省恩施土家族苗族自治州",
"861470584", "浙江省宁波市",
"861305546", "福建省泉州市",
"861869769", "安徽省阜阳市",
"861335025", "四川省南充市",
"861534268", "湖北省十堰市",
"861536437", "湖南省张家界市",
"861368546", "山东省东营市",
"861372393", "山东省日照市",
"861580593", "福建省厦门市",
"861778946", "甘肃省陇南市",
"861309117", "河北省衡水市",
"861337861", "广东省东莞市",
"861570583", "浙江省嘉兴市",
"861889742", "湖南省娄底市",
"861373456", "黑龙江省大庆市",
"86156286", "山东省德州市",
"861853652", "山西省晋中市",
"861836240", "江苏省南通市",
"861319215", "广东省汕头市",
"861350955", "福建省宁德市",
"861768057", "湖南省常德市",
"861857584", "广东省肇庆市",
"86150989", "山东省济南市",
"861769932", "新疆和田地区",
"861556418", "山东省烟台市",
"86138694", "山东省枣庄市",
"861705057", "浙江省杭州市",
"861367268", "广东省珠海市",
"861512989", "陕西省渭南市",
"86150535", "山东省烟台市",
"861588687", "新疆和田地区",
"86139639", "山东省青岛市",
"861523564", "山西省晋城市",
"861530984", "辽宁省大连市",
"861782038", "广东省肇庆市",
"861520765", "广东省佛山市",
"861303445", "湖北省鄂州市",
"861861743", "河北省邢台市",
"861300798", "宁夏银川市",
"861898821", "云南省德宏傣族景颇族自治州",
"861539391", "云南省西双版纳傣族自治州",
"861317877", "广东省汕头市",
"861450851", "江苏省扬州市",
"861367078", "广东省梅州市",
"861780420", "辽宁省锦州市",
"861343736", "广东省东莞市",
"861868853", "广东省梅州市",
"861534078", "山西省阳泉市",
"861523311", "河北省石家庄市",
"861842033", "广东省佛山市",
"861809393", "甘肃省甘南藏族自治州",
"861535298", "青海省玉树藏族自治州",
"861887288", "湖北省鄂州市",
"861842713", "湖北省黄冈市",
"861825246", "江苏省南通市",
"86130736", "浙江省杭州市",
"861841938", "甘肃省兰州市",
"861816849", "江苏省徐州市",
"861370280", "广东省阳江市",
"861533310", "河北省邯郸市",
"861801110", "四川省绵阳市",
"861588750", "云南省保山市",
"86181810", "四川省广元市",
"861303950", "内蒙古呼和浩特市",
"861507041", "江西省南昌市",
"861314950", "黑龙江省哈尔滨市",
"86155670", "吉林省长春市",
"861392366", "广东省汕头市",
"861700814", "江苏省南通市",
"86131263", "广东省惠州市",
"861537145", "江苏省苏州市",
"861786613", "甘肃省兰州市",
"861532219", "广东省湛江市",
"861331778", "广西河池市",
"861875145", "江苏省盐城市",
"861516493", "内蒙古通辽市",
"861529390", "甘肃省临夏回族自治州",
"861700405", "广东省东莞市",
"861329764", "湖北省黄石市",
"861532616", "辽宁省大连市",
"8613936", "黑龙江省哈尔滨市",
"861775789", "浙江省舟山市",
"861528148", "四川省德阳市",
"861883398", "河北省秦皇岛市",
"861826241", "江苏省南通市",
"861554346", "吉林省白城市",
"861365644", "山东省淄博市",
"861818837", "四川省内江市",
"861884932", "河北省张家口市",
"861308644", "四川省泸州市",
"86155759", "湖南省长沙市",
"861805038", "福建省南平市",
"861318421", "浙江省杭州市",
"861536856", "云南省楚雄彝族自治州",
"861898543", "贵州省安顺市",
"861894845", "广东省揭阳市",
"861335170", "黑龙江省哈尔滨市",
"86135455", "湖北省黄石市",
"861521816", "广东省阳江市",
"861327860", "云南省保山市",
"861334757", "广西贵港市",
"861472709", "浙江省绍兴市",
"861532256", "广东省汕头市",
"861380413", "辽宁省抚顺市",
"861398507", "贵州省黔南布依族苗族自治州",
"861593288", "江西省萍乡市",
"86133188", "广东省广州市",
"86186853", "贵州省安顺市",
"861329647", "山东省东营市",
"861879454", "甘肃省临夏回族自治州",
"86134832", "河北省保定市",
"861828887", "云南省丽江市",
"861534852", "贵州省遵义市",
"861356173", "山东省莱芜市",
"86180553", "安徽省芜湖市",
"861884973", "云南省楚雄彝族自治州",
"861847830", "湖南省岳阳市",
"861532659", "黑龙江省大庆市",
"861364797", "江西省赣州市",
"861328338", "河北省承德市",
"861340816", "四川省绵阳市",
"861885787", "浙江省杭州市",
"86182484", "浙江省杭州市",
"861367852", "贵州省遵义市",
"861354058", "四川省南充市",
"861567757", "广西玉林市",
"8615790", "天津市",
"861556342", "山东省莱芜市",
"861337892", "湖南省怀化市",
"861470575", "浙江省绍兴市",
"861894486", "江苏省宿迁市",
"861502520", "云南省红河哈尼族彝族自治州",
"861303183", "河北省衡水市",
"861376284", "湖南省娄底市",
"861777110", "湖北省襄樊市",
"861325908", "陕西省渭南市",
"861819468", "青海省果洛藏族自治州",
"861521859", "广东省云浮市",
"861760871", "云南省昆明市",
"861761449", "吉林省白山市",
"861458267", "安徽省芜湖市",
"861867415", "湖北省荆州市",
"86177746", "湖南省永州市",
"861781790", "广东省汕头市",
"861831641", "广东省惠州市",
"86132523", "浙江省嘉兴市",
"861805119", "江苏省宿迁市",
"861339464", "黑龙江省大庆市",
"861301428", "宁夏银川市",
"861580901", "新疆塔城地区",
"861321478", "内蒙古巴彦淖尔市",
"86184374", "河南省许昌市",
"861530975", "青海省海东地区",
"861524343", "河北省唐山市",
"861308767", "陕西省咸阳市",
"861332912", "安徽省铜陵市",
"861589106", "陕西省汉中市",
"861337335", "河北省秦皇岛市",
"86177797", "江西省赣州市",
"861326395", "江西省宜春市",
"861370037", "河北省沧州市",
"861322063", "山东省日照市",
"861361315", "河北省唐山市",
"861536980", "河北省沧州市",
"861354833", "四川省内江市",
"861891925", "甘肃省庆阳市",
"861821640", "湖南省长沙市",
"861373419", "山西省朔州市",
"861517013", "江西省新余市",
"861339974", "新疆阿勒泰地区",
"861501995", "广东省东莞市",
"861885650", "安徽省芜湖市",
"861818419", "贵州省黔西南布依族苗族自治州",
"86136757", "浙江省绍兴市",
"861570812", "四川省攀枝花市",
"861321968", "四川省乐山市",
"861802573", "广东省潮州市",
"861580779", "广西北海市",
"861537483", "内蒙古阿拉善盟",
"861596042", "福建省泉州市",
"861361707", "江西省赣州市",
"861844944", "新疆和田地区",
"86156607", "广东省广州市",
"861392674", "广东省茂名市",
"861571527", "江苏省扬州市",
"861364483", "内蒙古包头市",
"861802198", "江苏省常州市",
"861532571", "浙江省杭州市",
"861819978", "新疆哈密地区",
"861807481", "广西南宁市",
"861370305", "广东省阳江市",
"861804340", "吉林省四平市",
"861560829", "四川省巴中市",
"861459329", "四川省泸州市",
"861334680", "河南省鹤壁市",
"861813340", "安徽省芜湖市",
"861356876", "四川省雅安市",
"861845896", "浙江省衢州市",
"861316513", "山东省济南市",
"86135741", "湖南省长沙市",
"861855243", "江苏省无锡市",
"861587948", "江西省景德镇市",
"861452723", "湖北省黄冈市",
"861881219", "河北省邢台市",
"861310248", "河北省廊坊市",
"86156626", "山东省济南市",
"86158945", "云南省大理白族自治州",
"861315632", "山东省枣庄市",
"861318720", "湖南省衡阳市",
"861558848", "山东省枣庄市",
"861700535", "山东省烟台市",
"861475349", "山东省青岛市",
"861809875", "安徽省六安市",
"86186722", "湖北省随州市",
"861379573", "四川省资阳市",
"861327517", "江苏省淮安市",
"861829825", "安徽省芜湖市",
"861338042", "广东省云浮市",
"861840397", "河南省信阳市",
"86150050", "福建省福州市",
"86186803", "广东省深圳市",
"86180571", "浙江省杭州市",
"861768103", "安徽省宣城市",
"861453551", "安徽省芜湖市",
"861314347", "广东省惠州市",
"861777101", "湖北省襄樊市",
"861336797", "江西省赣州市",
"861880376", "河南省信阳市",
"86186871", "云南省昆明市",
"86184836", "四川省成都市",
"861536892", "云南省西双版纳傣族自治州",
"86170763", "山东省潍坊市",
"861303347", "山西省吕梁市",
"861810639", "山东省青岛市",
"861523369", "河北省廊坊市",
"861366757", "新疆和田地区",
"861843149", "河北省邢台市",
"861821834", "广东省广州市",
"861838152", "四川省乐山市",
"861354558", "湖北省咸宁市",
"8615222", "天津市",
"861332999", "湖北省咸宁市",
"861458577", "山东省菏泽市",
"861595122", "江苏省常州市",
"86187338", "河北省保定市",
"861524187", "辽宁省阜新市",
"86131838", "四川省成都市",
"861805192", "江苏省徐州市",
"861580910", "陕西省咸阳市",
"861760781", "广西崇左市",
"861868192", "陕西省榆林市",
"861356098", "广东省梅州市",
"861362959", "宁夏银川市",
"861317210", "广东省广州市",
"861373108", "河北省石家庄市",
"861337507", "福建省三明市",
"861899934", "新疆昌吉回族自治州",
"861319428", "辽宁省大连市",
"861500438", "吉林省松原市",
"861319381", "河南省南阳市",
"861863972", "河南省许昌市",
"861776607", "江苏省南京市",
"861536335", "广东省潮州市",
"861360675", "浙江省绍兴市",
"861390257", "广东省湛江市",
"861522070", "广东省惠州市",
"861845268", "江苏省苏州市",
"861818108", "四川省南充市",
"861572629", "山东省滨州市",
"861598797", "云南省普洱市",
"861860958", "宁夏银川市",
"86147210", "上海市",
"861519643", "四川省乐山市",
"861343182", "广东省梅州市",
"861520946", "甘肃省金昌市",
"861337819", "四川省达州市",
"861839424", "甘肃省定西市",
"86189394", "河南省周口市",
"861529141", "陕西省西安市",
"861355781", "广西南宁市",
"861857265", "湖北省荆门市",
"861801468", "江苏省盐城市",
"861808727", "云南省昆明市",
"861830998", "新疆喀什地区",
"861315288", "山西省晋中市",
"861509576", "甘肃省陇南市",
"861869031", "新疆乌鲁木齐市",
"861323726", "湖北省随州市",
"86136707", "广东省潮州市",
"861760937", "甘肃省酒泉市",
"861822954", "湖南省湘西土家族苗族自治州",
"861388633", "湖北省鄂州市",
"86187729", "湖北省十堰市",
"861539140", "云南省文山壮族苗族自治州",
"861596542", "山东省青岛市",
"861557876", "广西河池市",
"861883449", "山西省运城市",
"861838589", "贵州省铜仁地区",
"861370537", "山东省济宁市",
"861314776", "吉林省吉林市",
"861322563", "安徽省宣城市",
"861564980", "河南省许昌市",
"861787550", "广东省深圳市",
"861772182", "四川省南充市",
"861821928", "广东省佛山市",
"861805408", "安徽省安庆市",
"86150825", "四川省遂宁市",
"86189151", "江苏省淮安市",
"861768806", "广东省揭阳市",
"861519995", "新疆伊犁哈萨克自治州",
"861868408", "四川省宜宾市",
"861705806", "天津市",
"861453276", "山西省晋城市",
"861847644", "广东省中山市",
"861770148", "江苏省南通市",
"86156657", "山东省济南市",
"861894744", "内蒙古兴安盟",
"861336483", "新疆塔城地区",
"86145029", "山西省晋中市",
"861351489", "内蒙古包头市",
"861582005", "山东省烟台市",
"86177132", "河北省保定市",
"86185067", "浙江省嘉兴市",
"861815914", "福建省漳州市",
"861573394", "河北省承德市",
"861561597", "山东省济宁市",
"861818492", "西藏日喀则地区",
"861853696", "山西省忻州市",
"861476080", "江苏省盐城市",
"861587620", "广东省河源市",
"861584648", "黑龙江省牡丹江市",
"861531557", "山东省济南市",
"861532261", "广东省汕头市",
"861343559", "广东省潮州市",
"86153426", "湖北省咸宁市",
"861355937", "福建省泉州市",
"861700307", "广东省惠州市",
"861338542", "山东省青岛市",
"86155641", "山东省济南市",
"861857120", "湖北省襄樊市",
"861335918", "陕西省西安市",
"861526809", "浙江省衢州市",
"861329865", "湖南省长沙市",
"861886660", "山东省菏泽市",
"861372785", "广东省珠海市",
"861583384", "河北省衡水市",
"86158017", "上海市",
"861899828", "广东省茂名市",
"861538398", "河北省秦皇岛市",
"861379073", "广东省中山市",
"861348780", "湖南省益阳市",
"86158134", "广东省佛山市",
"861812813", "广东省珠海市",
"861586088", "福建省三明市",
"861529600", "广西桂林市",
"86134150", "广东省汕头市",
"861852576", "辽宁省葫芦岛市",
"861596977", "山东省德州市",
"86152989", "海南省海口市",
"861598540", "贵州省黔南布依族苗族自治州",
"861520008", "河北省保定市",
"861567295", "湖北省十堰市",
"861889869", "广东省广州市",
"86152535", "山东省烟台市",
"861380674", "浙江省绍兴市",
"861515448", "山东省潍坊市",
"861325546", "山东省东营市",
"861391218", "江苏省连云港市",
"861335075", "四川省乐山市",
"861452732", "湖南省湘潭市",
"86775", "广西玉林市",
"861870907", "新疆吐鲁番地区",
"861822799", "四川省广安市",
"861875255", "江苏省扬州市",
"861584761", "内蒙古赤峰市",
"861364255", "广东省清远市",
"861576098", "陕西省延安市",
"861347777", "湖北省咸宁市",
"86136917", "广东省深圳市",
"861771378", "四川省成都市",
"861503311", "河北省石家庄市",
"861333951", "黑龙江省哈尔滨市",
"861537040", "江苏省无锡市",
"861333630", "山东省威海市",
"86131996", "黑龙江省齐齐哈尔市",
"86182540", "山东省菏泽市",
"861805246", "江苏省无锡市",
"861363433", "吉林省延边朝鲜族自治州",
"861376225", "湖南省株洲市",
"861335389", "河南省驻马店市",
"861862416", "辽宁省锦州市",
"861707049", "浙江省衢州市",
"861338977", "青海省海西蒙古族藏族自治州",
"861500765", "广东省东莞市",
"861452599", "福建省南平市",
"861354822", "四川省眉山市",
"861320798", "江西省景德镇市",
"861528891", "山东省泰安市",
"861888662", "四川省成都市",
"861777640", "广西河池市",
"861867568", "广东省茂名市",
"861780470", "内蒙古呼伦贝尔市",
"86159199", "广东省深圳市",
"861855507", "安徽省宿州市",
"861336540", "山东省菏泽市",
"861317827", "福建省厦门市",
"861898871", "广东省东莞市",
"861817645", "广西玉林市",
"861338467", "黑龙江省鸡西市",
"861362794", "江西省抚州市",
"86147875", "云南省临沧市",
"861583242", "河北省承德市",
"861331728", "湖北省十堰市",
"861581499", "广东省韶关市",
"861309764", "山西省朔州市",
"86153860", "湖南省衡阳市",
"8615623", "湖北省武汉市",
"861377876", "四川省雅安市",
"861550537", "山东省济宁市",
"861332754", "山西省晋中市",
"861855980", "福建省厦门市",
"861340643", "山东省烟台市",
"861347346", "河北省唐山市",
"861458942", "广东省清远市",
"861323950", "宁夏银川市",
"861527041", "江西省宜春市",
"86134605", "河南省许昌市",
"861323631", "江苏省连云港市",
"861563666", "黑龙江省双鸭山市",
"86177800", "四川省成都市",
"861561740", "河南省郑州市",
"861571489", "内蒙古包头市",
"861888818", "江苏省苏州市",
"861592901", "陕西省榆林市",
"861350899", "山东省临沂市",
"861518696", "贵州省贵阳市",
"861318471", "河北省邯郸市",
"861576786", "广东省茂名市",
"8613761", "上海市",
"861870580", "浙江省舟山市",
"861551249", "河北省承德市",
"861459074", "广东省河源市",
"86134556", "山东省潍坊市",
"861335120", "黑龙江省哈尔滨市",
"861575937", "福建省莆田市",
"861859175", "陕西省西安市",
"861501816", "广东省韶关市",
"861508148", "河北省衡水市",
"861866637", "广东省佛山市",
"861825156", "江苏省无锡市",
"861310759", "青海省西宁市",
"861399504", "宁夏固原市",
"861880590", "福建省福州市",
"861313457", "黑龙江省大兴安岭地区",
"861565148", "江苏省盐城市",
"861470918", "陕西省西安市",
"861559073", "吉林省松原市",
"86181558", "安徽省阜阳市",
"861825038", "福建省龙岩市",
"861304457", "福建省福州市",
"861859352", "福建省宁德市",
"861896949", "浙江省衢州市",
"861855892", "福建省三明市",
"861454607", "青海省海西蒙古族藏族自治州",
"861867278", "湖北省武汉市",
"861824957", "黑龙江省大庆市",
"86953", "宁夏吴忠市",
"861898781", "云南省楚雄彝族自治州",
"861538982", "内蒙古呼和浩特市",
"861389829", "辽宁省葫芦岛市",
"861479766", "青海省玉树藏族自治州",
"861763521", "山西省大同市",
"861576598", "黑龙江省大庆市",
"861850940", "甘肃省临夏回族自治州",
"861376342", "黑龙江省哈尔滨市",
"861325046", "广东省江门市",
"861859520", "山东省济宁市",
"861335575", "浙江省绍兴市",
"861373921", "安徽省滁州市",
"86152861", "贵州省遵义市",
"861452512", "山东省德州市",
"861310406", "黑龙江省双鸭山市",
"861843619", "河南省南阳市",
"861350668", "浙江省宁波市",
"861559402", "甘肃省陇南市",
"861780636", "山东省潍坊市",
"861505677", "安徽省阜阳市",
"861707549", "福建省泉州市",
"86180737", "湖南省益阳市",
"861362373", "河南省新乡市",
"86182732", "湖南省长沙市",
"861478582", "贵州省安顺市",
"861835708", "浙江省衢州市",
"861566028", "湖南省邵阳市",
"861534528", "江苏省盐城市",
"861577708", "广西北海市",
"861819735", "青海省海北藏族自治州",
"861364540", "山东省菏泽市",
"861336040", "广东省惠州市",
"861819015", "四川省遂宁市",
"861393448", "山西省阳泉市",
"861533691", "浙江省金华市",
"861452099", "安徽省马鞍山市",
"86152636", "山东省潍坊市",
"861390795", "江西省宜春市",
"861839485", "甘肃省庆阳市",
"861774940", "河南省安阳市",
"861779010", "四川省德阳市",
"861893670", "江苏省连云港市",
"861518212", "四川省内江市",
"861300642", "四川省乐山市",
"861550717", "湖北省黄冈市",
"86152380", "河南省郑州市",
"86130147", "河南省洛阳市",
"861592910", "陕西省咸阳市",
"861595457", "山东省聊城市",
"861779730", "青海省海东地区",
"861320586", "浙江省台州市",
"861312344", "广西贵港市",
"861350812", "四川省绵阳市",
"861552875", "四川省乐山市",
"861333966", "贵州省铜仁地区",
"861830382", "河南省安阳市",
"861344132", "江苏省南京市",
"861770618", "江苏省无锡市",
"861848517", "贵州省遵义市",
"86134409", "上海市",
"861539610", "福建省福州市",
"861375150", "广东省佛山市",
"86185629", "山东省东营市",
"861311764", "广西贺州市",
"861510321", "河北省石家庄市",
"861351527", "江苏省常州市",
"861510488", "内蒙古呼伦贝尔市",
"861550305", "河北省承德市",
"861309331", "安徽省滁州市",
"861511390", "广东省汕头市",
"861302688", "广东省广州市",
"861558340", "四川省成都市",
"861530738", "湖南省娄底市",
"861709619", "山东省青岛市",
"861576876", "广东省深圳市",
"861338831", "四川省攀枝花市",
"86136890", "四川省成都市",
"861587006", "江西省景德镇市",
"86134655", "山东省烟台市",
"861527541", "山东省济南市",
"86130590", "黑龙江省大庆市",
"861569413", "辽宁省抚顺市",
"861863047", "河北省秦皇岛市",
"861813848", "广东省佛山市",
"86157741", "湖南省永州市",
"861595133", "江苏省南通市",
"861459574", "陕西省安康市",
"86134506", "广东省东莞市",
"861564243", "辽宁省朝阳市",
"86187433", "吉林省延边朝鲜族自治州",
"861804848", "四川省成都市",
"861773233", "河北省唐山市",
"86159760", "广东省中山市",
"861559198", "陕西省商洛市",
"861378848", "广西柳州市",
"86184552", "安徽省蚌埠市",
"861570741", "湖南省怀化市",
"861783917", "河南省安阳市",
"861577160", "陕西省榆林市",
"861583325", "河北省唐山市",
"861333844", "福建省福州市",
"861850455", "黑龙江省绥化市",
"861394850", "内蒙古呼伦贝尔市",
"861330349", "山西省朔州市",
"861348378", "河北省保定市",
"861306497", "江苏省连云港市",
"861457080", "江苏省泰州市",
"861800689", "浙江省金华市",
"861880090", "四川省遂宁市",
"861337243", "浙江省嘉兴市",
"86183541", "山东省济南市",
"86188644", "河南省濮阳市",
"861569290", "四川省泸州市",
"861476185", "江苏省无锡市",
"861470025", "安徽省宿州市",
"8615022", "天津市",
"861458527", "河南省鹤壁市",
"861335584", "浙江省宁波市",
"861311647", "贵州省毕节地区",
"86185791", "江西省南昌市",
"861358697", "浙江省金华市",
"861890557", "安徽省宿州市",
"861845028", "福建省厦门市",
"861539250", "山西省忻州市",
"861770891", "西藏拉萨市",
"861700130", "安徽省合肥市",
"861594908", "江苏省扬州市",
"861880326", "河北省廊坊市",
"861855861", "福建省福州市",
"86182571", "浙江省杭州市",
"861350583", "浙江省嘉兴市",
"861452186", "吉林省延边朝鲜族自治州",
"861357565", "浙江省衢州市",
"861770258", "江苏省徐州市",
"861396608", "安徽省蚌埠市",
"861575207", "云南省西双版纳傣族自治州",
"861884554", "黑龙江省绥化市",
"861570955", "宁夏中卫市",
"861503369", "河北省沧州市",
"861384963", "河南省驻马店市",
"861452394", "西藏林芝地区",
"861886094", "江苏省南京市",
"861857025", "湖南省邵阳市",
"861592231", "安徽省芜湖市",
"861323347", "山西省临汾市",
"861572066", "江苏省苏州市",
"86159423", "辽宁省沈阳市",
"861500864", "宁夏固原市",
"861839474", "甘肃省酒泉市",
"861899596", "湖北省随州市",
"861509141", "陕西省延安市",
"861358130", "湖北省武汉市",
"861533753", "福建省宁德市",
"861500946", "甘肃省兰州市",
"861572679", "西藏拉萨市",
"861821468", "云南省保山市",
"861374777", "内蒙古鄂尔多斯市",
"861310536", "山东省潍坊市",
"861808777", "云南省玉溪市",
"861539045", "四川省达州市",
"861700697", "广东省江门市",
"861319478", "四川省资阳市",
"861559799", "贵州省黔西南布依族苗族自治州",
"861520438", "吉林省松原市",
"861375983", "陕西省咸阳市",
"861344444", "北京市",
"861885827", "浙江省杭州市",
"86181275", "广东省江门市",
"861889811", "河南省开封市",
"861331935", "江西省宜春市",
"861512134", "贵州省安顺市",
"86153051", "江苏省南京市",
"861839143", "陕西省渭南市",
"861471848", "广东省肇庆市",
"861803751", "河南省郑州市",
"861879902", "新疆阿勒泰地区",
"861562434", "山东省德州市",
"861453226", "浙江省金华市",
"861550280", "四川省成都市",
"86152825", "四川省遂宁市",
"86553", "安徽省芜湖市",
"861320112", "新疆伊犁哈萨克自治州",
"861860847", "湖南省益阳市",
"861327368", "河北省邢台市",
"861394986", "河南省漯河市",
"861810048", "吉林省长春市",
"861452883", "云南省临沧市",
"861871549", "安徽省宣城市",
"861353599", "广东省清远市",
"861318880", "山东省济宁市",
"86137670", "江西省南昌市",
"861453629", "江苏省泰州市",
"86155310", "河北省邯郸市",
"861362332", "河北省保定市",
"861367915", "陕西省安康市",
"861571077", "广东省深圳市",
"861892195", "江苏省苏州市",
"86156652", "山东省枣庄市",
"86153402", "上海市",
"861856866", "河南省开封市",
"861534915", "陕西省安康市",
"861829785", "安徽省合肥市",
"861303726", "江西省九江市",
"8618488", "云南省昆明市",
"861323776", "广西百色市",
"86136702", "广东省深圳市",
"861821978", "甘肃省金昌市",
"861302563", "广东省湛江市",
"861339553", "安徽省芜湖市",
"861314726", "湖北省恩施土家族苗族自治州",
"861557826", "广西来宾市",
"861338289", "江苏省无锡市",
"861880913", "陕西省渭南市",
"86177843", "重庆市",
"861390147", "江苏省南通市",
"861839846", "四川省南充市",
"861899878", "广东省中山市",
"861338365", "河北省秦皇岛市",
"86137759", "江苏省徐州市",
"861345131", "内蒙古呼和浩特市",
"861577109", "湖北省十堰市",
"861362895", "西藏昌都地区",
"861835109", "江苏省宿迁市",
"861560789", "广西北海市",
"86138758", "湖南省长沙市",
"86185062", "江苏省苏州市",
"861302902", "吉林省四平市",
"861533818", "广东省珠海市",
"861572551", "山东省烟台市",
"861380351", "江西省南昌市",
"861571267", "浙江省台州市",
"861371582", "广东省潮州市",
"861587670", "广东省梅州市",
"861384897", "内蒙古赤峰市",
"861802841", "广东省湛江市",
"861351942", "甘肃省甘南藏族自治州",
"861308338", "安徽省亳州市",
"861812159", "江苏省苏州市",
"861479945", "新疆巴音郭楞蒙古自治州",
"86187968", "江苏省苏州市",
"861524905", "陕西省渭南市",
"861315414", "辽宁省本溪市",
"861365338", "河北省石家庄市",
"861470525", "江苏省扬州市",
"861553971", "河南省洛阳市",
"861873992", "河南省郑州市",
"86185461", "黑龙江省哈尔滨市",
"861339838", "四川省绵阳市",
"861890057", "安徽省宿州市",
"861390894", "西藏林芝地区",
"861889800", "西藏拉萨市",
"861359817", "河南省洛阳市",
"86137175", "北京市",
"861529266", "新疆和田地区",
"861355821", "广西南宁市",
"861380366", "黑龙江省佳木斯市",
"861839387", "甘肃省白银市",
"861886448", "河南省信阳市",
"86158411", "辽宁省大连市",
"861393399", "河北省张家口市",
"861555240", "山东省东营市",
"861374887", "河南省郑州市",
"861529669", "山西省朔州市",
"861350083", "吉林省白城市",
"861808887", "广东省揭阳市",
"861532843", "四川省南充市",
"861309647", "四川省广元市",
"86188969", "江苏省苏州市",
"861815088", "福建省厦门市",
"86182553", "安徽省芜湖市",
"861509026", "河南省许昌市",
"861322454", "黑龙江省佳木斯市",
"861310036", "湖南省娄底市",
"86136823", "广东省深圳市",
"861513343", "河北省廊坊市",
"861872647", "安徽省合肥市",
"861310716", "湖南省永州市",
"861529076", "河南省平顶山市",
"861780771", "广西南宁市",
"861321428", "辽宁省大连市",
"861328767", "山东省潍坊市",
"861310158", "黑龙江省哈尔滨市",
"861584539", "黑龙江省七台河市",
"86183176", "河南省平顶山市",
"86134143", "广东省东莞市",
"86153001", "北京市",
"861778508", "贵州省六盘水市",
"861304172", "江苏省常州市",
"861860665", "浙江省温州市",
"861867683", "广东省广州市",
"861501859", "广东省湛江市",
"861304681", "广东省汕头市",
"861363962", "河南省焦作市",
"861817010", "江西省赣州市",
"86130268", "广东省东莞市",
"861590435", "吉林省通化市",
"861521643", "山东省淄博市",
"861760821", "四川省资阳市",
"861560879", "云南省普洱市",
"861842022", "广东省阳江市",
"861819928", "新疆昌吉回族自治州",
"861532521", "浙江省绍兴市",
"861364615", "江苏省无锡市",
"861397289", "湖北省荆门市",
"86156018", "上海市",
"861810494", "辽宁省本溪市",
"861355543", "黑龙江省佳木斯市",
"861895405", "山东省济宁市",
"861381519", "江苏省镇江市",
"861777015", "江西省鹰潭市",
"861356826", "四川省绵阳市",
"861363472", "内蒙古包头市",
"861785841", "浙江省杭州市",
"861810548", "山东省泰安市",
"861803766", "河南省周口市",
"861339924", "陕西省商洛市",
"861302063", "山东省枣庄市",
"861339053", "辽宁省大连市",
"86186706", "湖南省常德市",
"861360458", "黑龙江省双鸭山市",
"86177792", "江西省九江市",
"861537615", "山东省济南市",
"861590641", "浙江省丽水市",
"861331380", "福建省三明市",
"861899788", "新疆石河子市",
"861330498", "辽宁省阜新市",
"861850357", "山西省临汾市",
"861580729", "湖北省孝感市",
"861521995", "广东省中山市",
"86157770", "广西防城港市",
"861348820", "陕西省安康市",
"861583427", "山西省忻州市",
"86184733", "湖南省长沙市",
"861827217", "湖北省黄石市",
"86170866", "山东省烟台市",
"86136752", "江苏省连云港市",
"861301968", "辽宁省本溪市",
"861330544", "山东省德州市",
"861479450", "黑龙江省哈尔滨市",
"861709661", "浙江省嘉兴市",
"861312549", "辽宁省大连市",
"86137709", "江苏省南京市",
"861760543", "山东省滨州市",
"86158658", "山东省菏泽市",
"861569703", "云南省红河哈尼族彝族自治州",
"861302273", "山东省烟台市",
"86152050", "福建省福州市",
"861893506", "山西省运城市",
"861769923", "新疆巴音郭楞蒙古自治州",
"861502939", "陕西省铜川市",
"861452773", "广西桂林市",
"861572051", "安徽省合肥市",
"861832499", "安徽省安庆市",
"86135066", "浙江省温州市",
"861816213", "江西省上饶市",
"861862459", "辽宁省营口市",
"861859396", "广西玉林市",
"861318770", "云南省昆明市",
"861550407", "辽宁省营口市",
"86138708", "江西省南昌市",
"861553461", "山西省晋城市",
"861897242", "湖北省恩施土家族苗族自治州",
"861855856", "福建省泉州市",
"861779117", "陕西省安康市",
"861308946", "吉林省吉林市",
"861800872", "云南省大理白族自治州",
"86147436", "广东省广州市",
"861330608", "福建省三明市",
"861380313", "河北省张家口市",
"861803291", "河北省石家庄市",
"86134842", "浙江省宁波市",
"861364894", "西藏林芝地区",
"861593221", "河北省石家庄市",
"861776823", "江苏省盐城市",
"861510919", "陕西省铜川市",
"86181229", "广东省东莞市",
"861875894", "浙江省金华市",
"861518536", "贵州省安顺市",
"861387219", "湖北省咸宁市",
"861821809", "广东省中山市",
"861880630", "山东省威海市",
"861889156", "陕西省渭南市",
"861505625", "安徽省合肥市",
"861471741", "江西省南昌市",
"861880951", "宁夏银川市",
"861556442", "山东省德州市",
"861803858", "广东省梅州市",
"861533293", "内蒙古包头市",
"861567854", "广西贵港市",
"861550697", "福建省龙岩市",
"861876027", "福建省三明市",
"861301217", "河北省唐山市",
"861313678", "黑龙江省双鸭山市",
"861524174", "辽宁省盘锦市",
"861599614", "江苏省连云港市",
"861894386", "吉林省吉林市",
"861379302", "山东省菏泽市",
"86186157", "四川省成都市",
"861770798", "江西省景德镇市",
"861327640", "山东省济南市",
"86159651", "山东省烟台市",
"861579404", "广东省广州市",
"861773445", "河北省廊坊市",
"861378955", "内蒙古通辽市",
"861302354", "江苏省淮安市",
"861780788", "广西河池市",
"86139773", "广西桂林市",
"86147985", "重庆市",
"86177736", "湖南省常德市",
"861539790", "江西省新余市",
"86147539", "山东省临沂市",
"861532914", "贵州省黔南布依族苗族自治州",
"861308864", "浙江省台州市",
"861301481", "广西贵港市",
"861569750", "广东省江门市",
"861311115", "山西省长治市",
"861457187", "浙江省台州市",
"861301328", "河北省唐山市",
"861365864", "山东省济南市",
"861323591", "福建省福州市",
"861899909", "新疆喀什地区",
"861705555", "河南省郑州市",
"861867707", "广西南宁市",
"861539462", "江苏省淮安市",
"861815261", "湖南省岳阳市",
"861813955", "新疆喀什地区",
"861361415", "辽宁省丹东市",
"861302736", "湖南省常德市",
"861363550", "安徽省滁州市",
"861326495", "湖北省荆门市",
"861370814", "四川省凉山彝族自治州",
"861373319", "河南省郑州市",
"861504237", "辽宁省抚顺市",
"86132800", "山东省济宁市",
"861529791", "江西省南昌市",
"86156264", "广东省广州市",
"861773950", "河南省南阳市",
"86138812", "四川省广元市",
"861530365", "黑龙江省哈尔滨市",
"861530686", "浙江省台州市",
"861889853", "广东省广州市",
"861814033", "四川省宜宾市",
"861899771", "新疆伊犁哈萨克自治州",
"861583377", "河北省沧州市",
"861539972", "湖南省益阳市",
"861824899", "江苏省宿迁市",
"861342445", "广东省广州市",
"861452236", "浙江省嘉兴市",
"861822692", "安徽省合肥市",
"861811201", "江苏省徐州市",
"86158486", "内蒙古包头市",
"861378440", "河北省石家庄市",
"861368789", "广西玉林市",
"861372210", "内蒙古呼伦贝尔市",
"861807428", "浙江省丽水市",
"861816076", "江西省吉安市",
"861452639", "江苏省淮安市",
"861363322", "河北省保定市",
"861454832", "广东省广州市",
"861597498", "云南省玉溪市",
"861813440", "河南省郑州市",
"861366941", "广西南宁市",
"861390615", "江苏省无锡市",
"861459429", "云南省怒江傈僳族自治州",
"861337641", "山东省济南市",
"861893912", "河南省许昌市",
"86159418", "辽宁省阜新市",
"86158589", "浙江省金华市",
"86135731", "山东省济南市",
"86158935", "河南省南阳市",
"861358280", "河北省秦皇岛市",
"86183788", "广西南宁市",
"861816669", "陕西省榆林市",
"861351575", "浙江省绍兴市",
"861377638", "江苏省常州市",
"861510880", "云南省文山壮族苗族自治州",
"861538044", "江苏省南京市",
"861895943", "福建省宁德市",
"861855100", "江苏省连云港市",
"861831892", "广东省惠州市",
"861380926", "广东省东莞市",
"861336147", "山东省聊城市",
"86152879", "云南省曲靖市",
"86157588", "云南省文山壮族苗族自治州",
"861389546", "宁夏石嘴山市",
"861840497", "山西省晋中市",
"861346689", "山西省晋中市",
"861575179", "江苏省常州市",
"861454395", "贵州省黔东南苗族侗族自治州",
"861339500", "福建省福州市",
"861317875", "广东省汕头市",
"861571918", "陕西省西安市",
"861314447", "广东省汕尾市",
"861880476", "内蒙古赤峰市",
"861775046", "福建省三明市",
"861320862", "吉林省松原市",
"861523469", "山西省长治市",
"861300749", "湖南省长沙市",
"861520767", "广东省云浮市",
"861303447", "湖北省黄冈市",
"86184846", "贵州省毕节地区",
"861870343", "山西省太原市",
"861366854", "贵州省黔南布依族苗族自治州",
"86188349", "山西省朔州市",
"861384916", "河南省开封市",
"861840873", "云南省红河哈尼族彝族自治州",
"861450646", "黑龙江省伊春市",
"861816898", "江苏省苏州市",
"86133801", "广东省东莞市",
"861768240", "浙江省台州市",
"86187348", "山西省太原市",
"861560908", "四川省泸州市",
"861760728", "湖北省十堰市",
"861450249", "河北省石家庄市",
"861359996", "福建省福州市",
"861395124", "江苏省宿迁市",
"861535249", "甘肃省张掖市",
"861523530", "山西省阳泉市",
"86157084", "四川省成都市",
"86159673", "浙江省嘉兴市",
"861324940", "广东省佛山市",
"861387292", "湖北省荆门市",
"861362614", "江苏省宿迁市",
"86159601", "福建省福州市",
"861500338", "河北省衡水市",
"861319481", "四川省广安市",
"861510992", "新疆伊犁哈萨克自治州",
"86185324", "河北省衡水市",
"861867839", "山东省济南市",
"861309115", "河北省沧州市",
"861347208", "河北省承德市",
"861890983", "辽宁省沈阳市",
"861824668", "黑龙江省齐齐哈尔市",
"861339731", "湖南省长沙市",
"861335027", "四川省南充市",
"861536435", "湖南省娄底市",
"861768055", "湖南省郴州市",
"86138128", "江苏省苏州市",
"861800782", "广西来宾市",
"861323091", "河北省秦皇岛市",
"861705055", "北京市",
"861355728", "广西河池市",
"861708191", "福建省莆田市",
"861526640", "山东省菏泽市",
"861377282", "陕西省汉中市",
"86134793", "江西省上饶市",
"861533168", "云南省大理白族自治州",
"861315221", "陕西省宝鸡市",
"861319217", "广东省汕头市",
"861831980", "广东省韶关市",
"86139751", "湖南省长沙市",
"861350957", "福建省宁德市",
"861818835", "四川省广元市",
"86189888", "广东省广州市",
"861333090", "四川省绵阳市",
"861814533", "黑龙江省齐齐哈尔市",
"861536641", "江苏省扬州市",
"86188816", "四川省绵阳市",
"861880844", "四川省广安市",
"861821981", "甘肃省兰州市",
"86184319", "河北省邢台市",
"861396544", "安徽省合肥市",
"861539203", "福建省厦门市",
"861533531", "山东省济南市",
"86155866", "湖北省恩施土家族苗族自治州",
"861334941", "黑龙江省哈尔滨市",
"861770586", "浙江省台州市",
"86183777", "广西钦州市",
"86180005", "四川省成都市",
"861863362", "河北省保定市",
"861815659", "安徽省马鞍山市",
"861831819", "广东省梅州市",
"861329730", "湖南省岳阳市",
"861894847", "广东省梅州市",
"861369672", "安徽省淮南市",
"861510770", "广西防城港市",
"86177142", "江苏省苏州市",
"861360986", "辽宁省大连市",
"861329010", "山东省济南市",
"861351389", "河南省郑州市",
"861865938", "福建省宁德市",
"86136818", "上海市",
"861537147", "江苏省苏州市",
"861818392", "云南省普洱市",
"861808938", "甘肃省兰州市",
"861573548", "山西省晋中市",
"861368879", "云南省丽江市",
"861598383", "四川省德阳市",
"861373392", "河南省平顶山市",
"861764538", "黑龙江省鹤岗市",
"861372201", "内蒙古呼伦贝尔市",
"861323233", "广东省梅州市",
"861329501", "福建省福州市",
"861389046", "四川省绵阳市",
"861811210", "江苏省镇江市",
"86186520", "江苏省南京市",
"86155631", "山东省济宁市",
"861700407", "广东省佛山市",
"861880966", "宁夏吴忠市",
"861505458", "山东省聊城市",
"861879516", "宁夏石嘴山市",
"86137420", "辽宁省辽阳市",
"861538544", "安徽省黄山市",
"861875147", "江苏省扬州市",
"861533700", "甘肃省酒泉市",
"861327834", "吉林省延边朝鲜族自治州",
"861538498", "新疆喀什地区",
"861576638", "广东省湛江市",
"861398641", "湖北省鄂州市",
"861843263", "河北省张家口市",
"861479033", "安徽省六安市",
"861888293", "四川省阿坝藏族羌族自治州",
"861815219", "甘肃省陇南市",
"861760380", "河南省鹤壁市",
"861458265", "安徽省芜湖市",
"861479713", "山西省忻州市",
"861867417", "湖北省十堰市",
"861376801", "广西南宁市",
"86137763", "江苏省苏州市",
"861582980", "陕西省咸阳市",
"861458389", "福建省龙岩市",
"861837888", "广西河池市",
"86176403", "辽宁省大连市",
"861831856", "广东省韶关市",
"861320258", "广东省揭阳市",
"861454783", "山东省淄博市",
"861313283", "广西桂林市",
"861579714", "湖北省襄樊市",
"861572990", "新疆伊犁哈萨克自治州",
"861308765", "陕西省铜川市",
"861337337", "河北省沧州市",
"861530977", "青海省海西蒙古族藏族自治州",
"861301870", "广东省清远市",
"861323272", "广东省湛江市",
"861521241", "安徽省合肥市",
"86750", "广东省江门市",
"861586571", "山东省济宁市",
"861302559", "广东省肇庆市",
"861898778", "云南省昆明市",
"861304283", "湖北省襄樊市",
"861339569", "安徽省合肥市",
"861557049", "湖北省孝感市",
"861392451", "广东省中山市",
"861329645", "山东省烟台市",
"861323062", "河北省保定市",
"861828885", "云南省丽江市",
"861353639", "广东省湛江市",
"861364795", "江西省宜春市",
"86139445", "吉林省通化市",
"861822656", "安徽省蚌埠市",
"861889408", "甘肃省酒泉市",
"861334755", "广西玉林市",
"86150646", "山东省潍坊市",
"861886840", "浙江省杭州市",
"861811650", "四川省甘孜藏族自治州",
"861811493", "江苏省扬州市",
"861390540", "山东省菏泽市",
"861333326", "河北省廊坊市",
"861858174", "四川省南充市",
"861510961", "宁夏银川市",
"861332620", "山东省菏泽市",
"861470577", "浙江省温州市",
"861339430", "吉林省长春市",
"861800558", "安徽省阜阳市",
"861362423", "辽宁省抚顺市",
"861331543", "河北省保定市",
"861560682", "浙江省湖州市",
"861319780", "江西省鹰潭市",
"86182747", "湖南省衡阳市",
"861885785", "浙江省温州市",
"861369633", "山东省日照市",
"861356549", "新疆和田地区",
"861506110", "江苏省常州市",
"861510471", "内蒙古呼和浩特市",
"861310696", "广东省江门市",
"861379149", "山东省菏泽市",
"861302182", "河北省秦皇岛市",
"861558899", "山东省青岛市",
"86132462", "广东省佛山市",
"861700537", "山东省济宁市",
"861322621", "广东省梅州市",
"86130467", "江苏省南通市",
"861329431", "吉林省长春市",
"86187867", "贵州省贵阳市",
"86182796", "江西省吉安市",
"861569466", "云南省昆明市",
"861773776", "河南省南阳市",
"861458120", "安徽省安庆市",
"861587999", "江西省景德镇市",
"861863391", "河北省石家庄市",
"86181936", "甘肃省张掖市",
"861890150", "江苏省常州市",
"861840395", "河南省漯河市",
"86132137", "河南省南阳市",
"861577989", "江西省赣州市",
"861300148", "河北省沧州市",
"861826113", "江苏省宿迁市",
"86152692", "山东省青岛市",
"861566743", "陕西省宝鸡市",
"861375806", "浙江省嘉兴市",
"861520644", "山东省枣庄市",
"861384959", "河南省焦作市",
"861809877", "安徽省六安市",
"861864806", "内蒙古兴安盟",
"861397018", "江西省鹰潭市",
"86150697", "山东省济宁市",
"861333913", "安徽省宣城市",
"861327515", "江苏省盐城市",
"861829827", "安徽省宣城市",
"86185576", "浙江省宁波市",
"861501997", "广东省东莞市",
"861330890", "西藏拉萨市",
"861331821", "广东省佛山市",
"861533769", "浙江省金华市",
"861519863", "云南省文山壮族苗族自治州",
"861530467", "黑龙江省七台河市",
"861528086", "福建省泉州市",
"861533401", "湖北省恩施土家族苗族自治州",
"861326397", "江西省赣州市",
"861883044", "河北省承德市",
"861531240", "江苏省南京市",
"861361317", "河北省沧州市",
"861370035", "河北省唐山市",
"861358537", "江苏省徐州市",
"861572772", "江西省新余市",
"861891927", "甘肃省庆阳市",
"86133060", "福建省厦门市",
"861818361", "云南省临沧市",
"861361228", "广东省江门市",
"86155398", "河南省三门峡市",
"861338518", "贵州省黔南布依族苗族自治州",
"861840832", "四川省内江市",
"861332294", "广东省云浮市",
"86188971", "青海省西宁市",
"861361705", "江西省宜春市",
"86132843", "河北省保定市",
"861802149", "江苏省镇江市",
"861362254", "广东省珠海市",
"861571525", "江苏省扬州市",
"861370307", "广东省佛山市",
"861590243", "辽宁省葫芦岛市",
"86181485", "广东省深圳市",
"86188903", "湖南省长沙市",
"861803403", "河北省张家口市",
"861776605", "江苏省南京市",
"861556227", "山东省济宁市",
"861869301", "甘肃省临夏回族自治州",
"861390255", "广东省江门市",
"861360677", "浙江省温州市",
"861536337", "广东省潮州市",
"861323903", "新疆石河子市",
"861372650", "广东省汕头市",
"861835801", "浙江省金华市",
"861319870", "四川省眉山市",
"861337505", "福建省莆田市",
"86137493", "河南省新乡市",
"861803262", "河北省廊坊市",
"861821860", "广东省茂名市",
"861857267", "湖北省荆门市",
"861302059", "山东省聊城市",
"861382483", "广东省湛江市",
"861830949", "甘肃省陇南市",
"861808725", "云南省昆明市",
"861339069", "江苏省盐城市",
"861345839", "四川省资阳市",
"86156845", "山东省威海市",
"861598795", "云南省丽江市",
"861808208", "江苏省镇江市",
"861839529", "宁夏银川市",
"86150545", "山东省烟台市",
"861818356", "云南省曲靖市",
"861303345", "山西省朔州市",
"861575778", "浙江省温州市",
"861339279", "广东省佛山市",
"861899960", "新疆巴音郭楞蒙古自治州",
"861823022", "河北省邯郸市",
"861376810", "广西防城港市",
"86139649", "山东省济宁市",
"861328508", "福建省漳州市",
"861569451", "黑龙江省哈尔滨市",
"861390040", "内蒙古呼和浩特市",
"861539933", "陕西省渭南市",
"861323562", "湖北省宜昌市",
"861330982", "辽宁省沈阳市",
"861539491", "云南省大理白族自治州",
"861815292", "新疆克拉玛依市",
"861339676", "浙江省台州市",
"861824083", "陕西省渭南市",
"861780320", "河北省邯郸市",
"861336795", "江西省宜春市",
"861317774", "江西省赣州市",
"861871826", "广东省揭阳市",
"861809931", "新疆塔城地区",
"861331043", "贵州省安顺市",
"861809493", "新疆塔城地区",
"861771381", "四川省南充市",
"861780552", "安徽省蚌埠市",
"86180530", "山东省菏泽市",
"86132061", "重庆市",
"861458575", "山东省菏泽市",
"861454873", "四川省南充市",
"86186830", "四川省泸州市",
"861524185", "辽宁省阜新市",
"861332948", "黑龙江省伊春市",
"86130746", "浙江省温州市",
"861812163", "江苏省连云港市",
"861533410", "湖北省随州市",
"861531555", "山东省济南市",
"861504080", "辽宁省抚顺市",
"861584699", "黑龙江省佳木斯市",
"861505106", "江苏省盐城市",
"861355935", "福建省福州市",
"861813741", "河南省洛阳市",
"861582892", "四川省巴中市",
"861378741", "湖南省长沙市",
"861700717", "湖北省荆州市",
"861862973", "吉林省松原市",
"861513080", "河北省沧州市",
"86132792", "陕西省西安市",
"861367743", "湖南省邵阳市",
"861889119", "陕西省铜川市",
"86131932", "重庆市",
"86130797", "吉林省吉林市",
"861561595", "山东省烟台市",
"86180274", "广东省广州市",
"861342183", "广东省深圳市",
"861534743", "广东省广州市",
"861372787", "广东省珠海市",
"861538349", "山西省朔州市",
"86180136", "江苏省苏州市",
"861899470", "江苏省泰州市",
"861836806", "浙江省舟山市",
"861559619", "陕西省延安市",
"861708340", "山西省大同市",
"861700305", "广东省佛山市",
"861529490", "河南省驻马店市",
"861896382", "新疆石河子市",
"861329867", "湖南省永州市",
"861572882", "广东省揭阳市",
"861510956", "宁夏中卫市",
"861509849", "山东省烟台市",
"861831861", "广东省阳江市",
"861880745", "湖南省怀化市",
"86151815", "四川省凉山彝族自治州",
"861370535", "山东省烟台市",
"861373014", "河北省承德市",
"861359952", "福建省厦门市",
"861818014", "四川省自贡市",
"861760935", "甘肃省武威市",
"861454176", "浙江省台州市",
"861843402", "山西省太原市",
"86185675", "河南省新乡市",
"861560238", "广东省广州市",
"861818734", "云南省临沧市",
"861350340", "河南省商丘市",
"861585669", "安徽省淮南市",
"861318488", "广东省汕尾市",
"861318321", "河南省漯河市",
"86182569", "安徽省合肥市",
"861816600", "江西省抚州市",
"861582007", "山东省济宁市",
"86137974", "湖北省荆州市",
"86188953", "安徽省芜湖市",
"861351584", "浙江省宁波市",
"861886634", "山东省莱芜市",
"861530831", "四川省绵阳市",
"86159567", "安徽省亳州市",
"861519997", "新疆伊犁哈萨克自治州",
"861301657", "江苏省淮安市",
"861876942", "山东省烟台市",
"861772223", "广东省河源市",
"861338738", "湖南省娄底市",
"861595628", "安徽省宣城市",
"861819809", "甘肃省天水市",
"861332006", "江西省吉安市",
"861847508", "广东省汕尾市",
"861376227", "湖南省株洲市",
"861450582", "辽宁省阜新市",
"861887592", "广东省深圳市",
"861760778", "广西河池市",
"861805698", "安徽省六安市",
"861535582", "浙江省湖州市",
"86155493", "湖北省宜昌市",
"861787503", "广东省广州市",
"86151270", "河北省邯郸市",
"861553356", "河北省唐山市",
"861880426", "辽宁省大连市",
"861855505", "安徽省马鞍山市",
"86135663", "浙江省宁波市",
"861780828", "四川省广元市",
"86189721", "湖北省荆州市",
"861300862", "云南省楚雄彝族自治州",
"861317825", "福建省厦门市",
"861514701", "内蒙古通辽市",
"861500767", "广东省东莞市",
"861338975", "青海省西宁市",
"861320749", "湖南省长沙市",
"861815146", "江苏省徐州市",
"861452494", "内蒙古包头市",
"861388901", "西藏拉萨市",
"86188158", "广西玉林市",
"861452548", "山东省泰安市",
"861554208", "辽宁省朝阳市",
"861315061", "云南省红河哈尼族彝族自治州",
"861355778", "广西河池市",
"861593561", "山西省太原市",
"861588413", "四川省宜宾市",
"861839374", "甘肃省天水市",
"861567297", "湖北省随州市",
"861556810", "吉林省白山市",
"861820782", "广西柳州市",
"861316551", "河北省邯郸市",
"86138990", "新疆巴音郭楞蒙古自治州",
"861810773", "广西桂林市",
"861315271", "山西省朔州市",
"861808874", "黑龙江省哈尔滨市",
"861776783", "吉林省延边朝鲜族自治州",
"861596975", "山东省德州市",
"86131209", "上海市",
"861887019", "江西省鹰潭市",
"861584504", "黑龙江省哈尔滨市",
"861875257", "江苏省徐州市",
"861319378", "河南省开封市",
"861593314", "河北省承德市",
"861870905", "新疆昌吉回族自治州",
"861503530", "山西省阳泉市",
"861576049", "四川省南充市",
"861364257", "广东省韶关市",
"861347775", "湖北省黄石市",
"861813668", "江苏省南京市",
"861327978", "新疆巴音郭楞蒙古自治州",
"861520338", "河北省衡水市",
"861822748", "四川省甘孜藏族自治州",
"861804668", "江西省赣州市",
"861335077", "四川省达州市",
"861393412", "山西省大同市",
"861818602", "湖北省黄冈市",
"861514530", "黑龙江省齐齐哈尔市",
"861866441", "广东省中山市",
"861313940", "甘肃省兰州市",
"86183772", "广西柳州市",
"861826643", "山东省淄博市",
"861860744", "湖南省张家界市",
"861551298", "河北省衡水市",
"861816141", "四川省内江市",
"861556989", "甘肃省陇南市",
"861859177", "陕西省西安市",
"861575935", "福建省莆田市",
"861327468", "黑龙江省佳木斯市",
"861362432", "吉林省吉林市",
"861877159", "湖北省黄冈市",
"861309730", "江西省赣州市",
"861780934", "甘肃省庆阳市",
"861593138", "河北省衡水市",
"861369622", "四川省南充市",
"861350848", "湖南省长沙市",
"861510720", "湖北省宜昌市",
"861770642", "浙江省杭州市",
"861815843", "浙江省杭州市",
"861590980", "辽宁省鞍山市",
"86178352", "山西省大同市",
"861304455", "福建省泉州市",
"861535159", "江苏省泰州市",
"861399409", "山西省忻州市",
"86136550", "福建省福州市",
"861517566", "河北省廊坊市",
"861866635", "广东省佛山市",
"861768150", "浙江省绍兴市",
"861459230", "四川省成都市",
"861313455", "黑龙江省绥化市",
"861399761", "湖北省荆州市",
"861311510", "江苏省苏州市",
"861840541", "山东省济南市",
"86157572", "浙江省湖州市",
"861322516", "江苏省徐州市",
"86187450", "黑龙江省哈尔滨市",
"861705150", "上海市",
"861379216", "山东省淄博市",
"861550535", "山东省烟台市",
"861309501", "新疆乌鲁木齐市",
"861708848", "江西省景德镇市",
"86182820", "四川省南充市",
"86139876", "云南省昆明市",
"86151534", "山东省德州市",
"861471583", "广东省惠州市",
"861338465", "黑龙江省哈尔滨市",
"86135191", "陕西省西安市",
"861817647", "广西玉林市",
"861378812", "广西柳州市",
"861804812", "四川省乐山市",
"86185315", "河北省唐山市",
"861368829", "四川省宜宾市",
"861453733", "湖南省株洲市",
"861570340", "山西省忻州市",
"861305829", "广东省汕头市",
"861571584", "浙江省绍兴市",
"86155974", "青海省西宁市",
"861872010", "江西省赣州市",
"86158365", "河南省许昌市",
"861315556", "安徽省安庆市",
"861887092", "江西省九江市",
"861308438", "四川省德阳市",
"86147166", "广东省广州市",
"861365438", "吉林省松原市",
"861535082", "河北省衡水市",
"861384794", "内蒙古兴安盟",
"86155763", "湖南省娄底市",
"861707598", "福建省莆田市",
"861332506", "山东省东营市",
"861595940", "福建省莆田市",
"861551944", "贵州省遵义市",
"86691", "云南省西双版纳傣族自治州",
"86136127", "广东省东莞市",
"861505675", "安徽省阜阳市",
"861555103", "安徽省滁州市",
"861707444", "浙江省嘉兴市",
"861391242", "江苏省南通市",
"861707173", "江西省吉安市",
"861587754", "陕西省榆林市",
"861328946", "陕西省延安市",
"861800822", "四川省泸州市",
"861810883", "云南省临沧市",
"861352990", "云南省玉溪市",
"861315561", "安徽省淮北市",
"861359714", "广西柳州市",
"861775171", "江苏省苏州市",
"861390797", "江西省赣州市",
"861839487", "甘肃省庆阳市",
"861871132", "湖南省湘潭市",
"861877082", "江西省九江市",
"861819737", "青海省海西蒙古族藏族自治州",
"86188713", "湖北省黄冈市",
"861593271", "河北省沧州市",
"861776873", "江苏省泰州市",
"861808784", "云南省昆明市",
"861819017", "四川省遂宁市",
"861454605", "青海省果洛藏族自治州",
"861322354", "山西省晋中市",
"861824955", "黑龙江省大庆市",
"861891289", "江苏省南通市",
"861321328", "河南省安阳市",
"861321481", "内蒙古通辽市",
"861301378", "江苏省苏州市",
"861316051", "广东省阳江市",
"861303591", "云南省红河哈尼族彝族自治州",
"861850836", "四川省甘孜藏族自治州",
"86132014", "陕西省西安市",
"86186152", "山东省济南市",
"86183244", "浙江省杭州市",
"86183821", "四川省成都市",
"86134133", "广东省茂名市",
"861335577", "浙江省温州市",
"861399756", "湖北省荆州市",
"861313628", "浙江省舟山市",
"861834441", "广东省云浮市",
"861477836", "广东省梅州市",
"861860486", "内蒙古赤峰市",
"861782869", "四川省乐山市",
"861304628", "广东省茂名市",
"861760888", "云南省丽江市",
"86151038", "河南省驻马店市",
"861869753", "安徽省淮南市",
"861807478", "广西河池市",
"861816026", "新疆阿克苏地区",
"861804899", "四川省凉山彝族自治州",
"861532588", "浙江省杭州市",
"861559149", "陕西省安康市",
"861325789", "广西玉林市",
"861824440", "四川省凉山彝族自治州",
"861827381", "湖南省娄底市",
"861783915", "河南省许昌市",
"861707876", "云南省丽江市",
"861309510", "新疆克拉玛依市",
"861895305", "山东省东营市",
"861316566", "湖北省孝感市",
"861810394", "河南省周口市",
"861839793", "江西省上饶市",
"861390483", "黑龙江省牡丹江市",
"861459479", "陕西省西安市",
"861813899", "广东省江门市",
"861363372", "河南省安阳市",
"861593556", "山西省运城市",
"86136500", "广东省东莞市",
"861398169", "四川省巴中市",
"861306495", "江苏省连云港市",
"861517066", "江西省吉安市",
"861872001", "江西省宜春市",
"86139334", "河北省唐山市",
"861311730", "湖南省岳阳市",
"86187400", "辽宁省沈阳市",
"861360358", "山西省太原市",
"861530542", "山东省青岛市",
"861361683", "浙江省嘉兴市",
"861583327", "河北省沧州市",
"861539922", "陕西省宝鸡市",
"8614748", "广东省广州市",
"86156476", "内蒙古赤峰市",
"861850457", "黑龙江省大兴安岭地区",
"861330398", "河南省三门峡市",
"861331480", "内蒙古呼伦贝尔市",
"86138817", "四川省成都市",
"861562409", "山东省济宁市",
"86184743", "湖南省湘西土家族苗族自治州",
"861472988", "陕西省西安市",
"861380976", "广东省茂名市",
"861888842", "广西柳州市",
"861552877", "四川省乐山市",
"86153575", "安徽省宣城市",
"861580633", "山东省日照市",
"861479350", "甘肃省陇南市",
"861517276", "湖北省随州市",
"86147560", "河北省邯郸市",
"861575129", "江苏省镇江市",
"86150879", "云南省普洱市",
"861550715", "湖北省荆州市",
"861857942", "广西柳州市",
"86156579", "浙江省金华市",
"86134896", "福建省漳州市",
"861595455", "山东省聊城市",
"861835134", "江苏省徐州市",
"86137398", "河北省唐山市",
"861315056", "云南省楚雄彝族自治州",
"861470942", "甘肃省定西市",
"861565112", "江苏省苏州市",
"86130025", "江苏省南京市",
"861805869", "浙江省绍兴市",
"861837129", "湖北省武汉市",
"861848515", "贵州省遵义市",
"861379692", "黑龙江省鸡西市",
"861825742", "浙江省宁波市",
"861351525", "江苏省常州市",
"86187775", "广西玉林市",
"861311501", "江苏省南京市",
"861315138", "江苏省连云港市",
"861571084", "广东省深圳市",
"86181898", "海南省海口市",
"861453513", "山东省济南市",
"861322059", "山东省济南市",
"861315592", "江西省上饶市",
"861808775", "云南省昆明市",
"86158144", "广东省深圳市",
"861823262", "河北省承德市",
"861589986", "广东省深圳市",
"861586021", "福建省漳州市",
"861700695", "广东省东莞市",
"861477172", "湖北省孝感市",
"861539047", "四川省凉山彝族自治州",
"861848928", "西藏山南地区",
"861853036", "河南省三门峡市",
"861590861", "湖北省武汉市",
"86152545", "山东省烟台市",
"861471899", "西藏拉萨市",
"861360627", "江苏省南通市",
"861314903", "广东省清远市",
"861519241", "山东省济宁市",
"861303903", "吉林省四平市",
"861593519", "山西省吕梁市",
"861325188", "吉林省松原市",
"861319820", "四川省自贡市",
"861850681", "浙江省杭州市",
"861500830", "四川省雅安市",
"861331937", "江西省景德镇市",
"861885825", "浙江省宁波市",
"86159313", "河北省张家口市",
"861556067", "内蒙古呼伦贝尔市",
"861887271", "湖北省黄冈市",
"861844582", "黑龙江省伊春市",
"861534081", "山西省晋中市",
"861871876", "广东省阳江市",
"861315019", "甘肃省酒泉市",
"86130061", "湖北省武汉市",
"861363333", "河北省秦皇岛市",
"86151241", "辽宁省鞍山市",
"861476187", "江苏省南京市",
"86151824", "四川省绵阳市",
"86155129", "河北省承德市",
"861454823", "广东省江门市",
"86182530", "山东省菏泽市",
"861470027", "安徽省宿州市",
"861458525", "河南省鹤壁市",
"861311645", "贵州省黔东南苗族侗族自治州",
"861358695", "浙江省金华市",
"861890555", "安徽省马鞍山市",
"861335489", "内蒙古呼和浩特市",
"861562970", "湖北省黄石市",
"861359339", "山西省吕梁市",
"861780204", "广东省中山市",
"861323345", "山西省长治市",
"86177268", "新疆乌鲁木齐市",
"861857027", "湖南省郴州市",
"861823072", "贵州省黔东南苗族侗族自治州",
"861314562", "安徽省铜陵市",
"861308508", "安徽省淮南市",
"861599144", "陕西省安康市",
"861709841", "浙江省杭州市",
"861321780", "广西南宁市",
"861357567", "浙江省衢州市",
"861833413", "贵州省安顺市",
"861503287", "河北省邯郸市",
"861536768", "湖南省张家界市",
"861783528", "山西省吕梁市",
"861317724", "湖北省襄樊市",
"861554824", "内蒙古兴安盟",
"861303562", "四川省广元市",
"861593092", "河北省保定市",
"861339626", "山东省德州市",
"861327110", "河南省商丘市",
"861804083", "新疆石河子市",
"861814022", "四川省成都市",
"861570957", "宁夏银川市",
"861332436", "吉林省白城市",
"861575205", "云南省西双版纳傣族自治州",
"86182136", "云南省红河哈尼族彝族自治州",
"861509762", "河北省廊坊市",
"861562460", "内蒙古锡林郭勒盟",
"86189495", "安徽省芜湖市",
"861338367", "河北省廊坊市",
"861362897", "西藏阿里地区",
"861786666", "山东省聊城市",
"861331781", "广西南宁市",
"861509490", "山东省威海市",
"861562792", "广东省汕尾市",
"861311431", "湖北省荆州市",
"861358943", "山东省东营市",
"861311993", "新疆石河子市",
"861532663", "黑龙江省鸡西市",
"86184679", "贵州省贵阳市",
"861529849", "江苏省扬州市",
"861337111", "山东省枣庄市",
"861390145", "江苏省扬州市",
"861810512", "江苏省连云港市",
"861839651", "福建省福州市",
"861771968", "陕西省西安市",
"861347446", "陕西省西安市",
"861839930", "新疆伊犁哈萨克自治州",
"86156211", "山东省青岛市",
"86137866", "湖南省常德市",
"861571265", "浙江省台州市",
"86130792", "辽宁省沈阳市",
"861361568", "安徽省阜阳市",
"861824741", "内蒙古乌兰察布市",
"861862923", "陕西省渭南市",
"86138923", "陕西省渭南市",
"86186869", "黑龙江省齐齐哈尔市",
"861571075", "广东省深圳市",
"861700943", "江苏省徐州市",
"861318371", "四川省攀枝花市",
"861892197", "江苏省苏州市",
"861871598", "河北省张家口市",
"861810099", "新疆乌鲁木齐市",
"86170709", "河北省石家庄市",
"861321657", "浙江省舟山市",
"861868800", "广东省汕头市",
"861860845", "湖南省怀化市",
"86183865", "贵州省六盘水市",
"861871444", "黑龙江省牡丹江市",
"861843841", "河南省焦作市",
"861454541", "新疆巴音郭楞蒙古自治州",
"86137631", "广东省东莞市",
"861528642", "贵州省铜仁地区",
"861776832", "江苏省无锡市",
"861534917", "陕西省宝鸡市",
"861512708", "河北省石家庄市",
"861829787", "安徽省六安市",
"861508586", "贵州省六盘水市",
"861454126", "河北省廊坊市",
"861304357", "福建省三明市",
"861897218", "湖北省武汉市",
"861379656", "黑龙江省绥化市",
"861475608", "河北省廊坊市",
"861859452", "福建省宁德市",
"861383998", "河南省开封市",
"861328765", "山东省潍坊市",
"861890240", "广东省广州市",
"861321870", "江苏省泰州市",
"861303272", "湖北省宜昌市",
"861322559", "安徽省黄山市",
"861872645", "安徽省芜湖市",
"861501241", "广东省广州市",
"86752", "广东省惠州市",
"861898728", "云南省昆明市",
"861586521", "山东省滨州市",
"861860667", "浙江省温州市",
"861856249", "山东省临沂市",
"861555057", "山东省聊城市",
"861831243", "广东省揭阳市",
"861590437", "吉林省辽源市",
"861317603", "山东省枣庄市",
"861887561", "河北省秦皇岛市",
"861310306", "河北省廊坊市",
"861819860", "贵州省贵阳市",
"861560546", "山东省东营市",
"861769706", "青海省玉树藏族自治州",
"861341114", "广东省韶关市",
"861470527", "江苏省扬州市",
"861820558", "安徽省阜阳市",
"861890055", "安徽省马鞍山市",
"861843954", "河南省新乡市",
"861384895", "内蒙古通辽市",
"86158321", "河北省石家庄市",
"861347784", "湖北省宜昌市",
"861786930", "云南省楚雄彝族自治州",
"861337768", "广东省潮州市",
"861479947", "新疆喀什地区",
"861524907", "陕西省宝鸡市",
"861534581", "浙江省杭州市",
"861814350", "贵州省贵阳市",
"861566081", "河南省安阳市",
"86182742", "湖南省株洲市",
"861362473", "内蒙古阿拉善盟",
"861569926", "新疆巴音郭楞蒙古自治州",
"861808885", "广东省梅州市",
"861374885", "河南省郑州市",
"861309645", "四川省德阳市",
"861303062", "安徽省池州市",
"861399970", "新疆伊犁哈萨克自治州",
"861804583", "黑龙江省大庆市",
"861333376", "河南省信阳市",
"86145891", "广东省江门市",
"861359815", "河南省洛阳市",
"861839385", "甘肃省白银市",
"861314062", "河南省许昌市",
"86152646", "山东省潍坊市",
"861308008", "吉林省松原市",
"861810732", "湖南省长沙市",
"861553319", "河北省邢台市",
"861806113", "江苏省徐州市",
"86189699", "浙江省杭州市",
"861810012", "浙江省宁波市",
"861829877", "甘肃省白银市",
"86184475", "内蒙古呼和浩特市",
"861868811", "广东省中山市",
"86150692", "山东省德州市",
"861312444", "河南省濮阳市",
"861500644", "山东省日照市",
"861312598", "黑龙江省哈尔滨市",
"861399792", "湖北省荆门市",
"86152697", "山东省济宁市",
"86187862", "贵州省遵义市",
"861573906", "新疆塔城地区",
"861322182", "浙江省杭州市",
"861361068", "山西省临汾市",
"861522496", "河南省周口市",
"861322671", "广东省佛山市",
"861511490", "陕西省西安市",
"86132467", "广东省深圳市",
"86139911", "陕西省西安市",
"861309431", "云南省曲靖市",
"861302621", "江西省南昌市",
"861510421", "辽宁省朝阳市",
"86180796", "江西省吉安市",
"861892476", "广东省汕头市",
"861773726", "河南省安阳市",
"861524580", "黑龙江省齐齐哈尔市",
"86157731", "湖南省长沙市",
"861895407", "山东省济宁市",
"86184700", "江西省南昌市",
"861810599", "福建省南平市",
"861777017", "江西省鹰潭市",
"861590856", "贵州省铜仁地区",
"86182385", "河南省安阳市",
"861397367", "湖南省益阳市",
"861364617", "江苏省无锡市",
"86187443", "吉林省延边朝鲜族自治州",
"861337100", "山东省泰安市",
"861872431", "黑龙江省黑河市",
"861399539", "宁夏银川市",
"861872993", "陕西省渭南市",
"861850355", "山西省长治市",
"861537617", "山东省济南市",
"861565086", "安徽省阜阳市",
"861583425", "山西省朔州市",
"861521997", "广东省阳江市",
"861333747", "湖北省荆门市",
"861827215", "湖北省黄冈市",
"861508086", "湖南省湘西土家族苗族自治州",
"861348478", "内蒙古巴彦淖尔市",
"861882983", "陕西省渭南市",
"861772902", "陕西省渭南市",
"861887138", "湖北省武汉市",
"861330449", "吉林省白山市",
"86186981", "天津市",
"86135588", "四川省成都市",
"861572722", "湖北省随州市",
"861533842", "广东省佛山市",
"86188634", "山东省莱芜市",
"86145204", "天津市",
"86183531", "山东省济南市",
"861355179", "四川省巴中市",
"861760576", "浙江省台州市",
"861354612", "山西省运城市",
"86132240", "重庆市",
"861324401", "吉林省吉林市",
"861313842", "广东省汕头市",
"861774818", "四川省达州市",
"861504747", "内蒙古通辽市",
"861328363", "山西省阳泉市",
"861365416", "辽宁省锦州市",
"861894209", "湖南省永州市",
"861324769", "广东省广州市",
"861302649", "四川省绵阳市",
"861379682", "黑龙江省哈尔滨市",
"861522667", "河北省廊坊市",
"861570633", "山东省日照市",
"861317617", "山东省济宁市",
"861855226", "江苏省南京市",
"861472998", "陕西省西安市",
"861819157", "陕西省西安市",
"861452746", "湖南省永州市",
"861325532", "山东省青岛市",
"861517100", "湖北省襄樊市",
"86188775", "广西玉林市",
"861340000", "江苏省无锡市",
"86138398", "河南省三门峡市",
"861587134", "湖北省孝感市",
"861470634", "山东省莱芜市",
"86150878", "云南省临沧市",
"861871752", "陕西省延安市",
"86156578", "浙江省宁波市",
"861838906", "西藏那曲地区",
"861306485", "江苏省盐城市",
"861360034", "广东省中山市",
"861331762", "广西柳州市",
"861800648", "山东省青岛市",
"861361450", "黑龙江省哈尔滨市",
"861361693", "福建省三明市",
"861330421", "辽宁省朝阳市",
"861809040", "四川省攀枝花市",
"861330388", "河南省洛阳市",
"861315813", "贵州省安顺市",
"861340364", "山西省大同市",
"861805232", "江苏省连云港市",
"861300960", "新疆昌吉回族自治州",
"861850818", "四川省达州市",
"861343869", "四川省雅安市",
"861773915", "河南省焦作市",
"86186396", "河南省驻马店市",
"861819991", "新疆乌鲁木齐市",
"861879649", "江苏省宿迁市",
"861830837", "四川省广元市",
"86182412", "辽宁省鞍山市",
"861372255", "河北省秦皇岛市",
"861378889", "福建省福州市",
"861329555", "安徽省马鞍山市",
"861325799", "江西省萍乡市",
"861802171", "江苏省扬州市",
"861804889", "四川省成都市",
"861561524", "山东省济南市",
"86180417", "辽宁省营口市",
"861477818", "广东省茂名市",
"861532444", "安徽省淮南市",
"86181317", "河北省沧州市",
"861858590", "贵州省黔西南布依族苗族自治州",
"861811540", "江苏省无锡市",
"861839783", "江西省上饶市",
"86188400", "辽宁省沈阳市",
"861390493", "辽宁省抚顺市",
"861390650", "浙江省杭州市",
"861841432", "内蒙古包头市",
"861524913", "陕西省渭南市",
"861390931", "甘肃省兰州市",
"861529043", "河南省郑州市",
"861844561", "黑龙江省黑河市",
"861361945", "云南省保山市",
"861566562", "安徽省铜陵市",
"861534062", "山西省忻州市",
"861830456", "黑龙江省黑河市",
"861816728", "浙江省温州市",
"861860496", "辽宁省锦州市",
"861335702", "浙江省衢州市",
"861771545", "江苏省常州市",
"861520554", "安徽省淮南市",
"86134202", "广东省中山市",
"861816205", "山东省济宁市",
"861569307", "甘肃省兰州市",
"86151039", "甘肃省陇南市",
"861521279", "安徽省合肥市",
"861772869", "广东省湛江市",
"861586549", "山东省日照市",
"861501229", "云南省昭通市",
"861804910", "陕西省西安市",
"861450519", "吉林省通化市",
"861378910", "湖南省郴州市",
"861320420", "辽宁省铁岭市",
"861813910", "新疆阿克苏地区",
"861705510", "北京市",
"861893442", "贵州省安顺市",
"861569715", "湖北省武汉市",
"861500202", "广东省广州市",
"861768510", "贵州省贵阳市",
"861598724", "云南省楚雄彝族自治州",
"861355898", "四川省攀枝花市",
"861301047", "浙江省温州市",
"861352980", "云南省红河哈尼族彝族自治州",
"861810893", "西藏山南地区",
"861775692", "安徽省宣城市",
"861551632", "河南省三门峡市",
"861393489", "山西省运城市",
"861839497", "甘肃省陇南市",
"861390787", "广西钦州市",
"861359358", "山西省运城市",
"861590882", "云南省德宏傣族景颇族自治州",
"861877092", "江西省九江市",
"86185351", "山西省太原市",
"861700674", "浙江省温州市",
"861869457", "浙江省杭州市",
"861808794", "云南省昆明市",
"861374794", "河南省信阳市",
"861567400", "湖南省岳阳市",
"861319547", "安徽省淮南市",
"861850753", "广东省梅州市",
"861356571", "新疆吐鲁番地区",
"861560149", "江苏省常州市",
"861534272", "湖北省荆门市",
"861334400", "河南省平顶山市",
"86187713", "湖北省随州市",
"861535092", "辽宁省抚顺市",
"861364603", "福建省厦门市",
"861850662", "广东省阳江市",
"861370466", "黑龙江省大庆市",
"861518984", "江苏省南京市",
"861565052", "山东省日照市",
"86180683", "江苏省无锡市",
"861532876", "四川省眉山市",
"861315116", "江苏省苏州市",
"861508052", "福建省南平市",
"861310927", "陕西省安康市",
"861378779", "湖南省长沙市",
"861571448", "吉林省松原市",
"861808373", "江苏省宿迁市",
"861525509", "安徽省蚌埠市",
"861332708", "内蒙古巴彦淖尔市",
"861314917", "陕西省宝鸡市",
"861571594", "福建省福州市",
"861303917", "吉林省吉林市",
"861352335", "河南省焦作市",
"861357912", "新疆阿克苏地区",
"861588037", "福建省龙岩市",
"861810477", "内蒙古鄂尔多斯市",
"861839873", "四川省自贡市",
"861589952", "广东省惠州市",
"861813779", "河南省郑州市",
"861533357", "山西省临汾市",
"861529821", "四川省南充市",
"861370451", "黑龙江省哈尔滨市",
"861471593", "广东省汕头市",
"861580340", "山西省太原市",
"861882730", "湖北省咸宁市",
"861538371", "河北省石家庄市",
"861325032", "广东省广州市",
"861325712", "湖北省孝感市",
"861516617", "山东省日照市",
"861882010", "广东省广州市",
"861348545", "山西省吕梁市",
"861887159", "湖北省宜昌市",
"861831722", "河南省南阳市",
"861324410", "陕西省西安市",
"861770934", "甘肃省庆阳市",
"861590990", "新疆克拉玛依市",
"861355076", "四川省自贡市",
"861840324", "河北省承德市",
"861830709", "江西省萍乡市",
"861363735", "湖南省郴州市",
"86150887", "浙江省杭州市",
"861777472", "广西柳州市",
"861820970", "青海省海北藏族自治州",
"861360534", "山东省德州市",
"861830461", "黑龙江省哈尔滨市",
"86156587", "浙江省温州市",
"86152882", "云南省昆明市",
"861801433", "江苏省常州市",
"861454529", "广西北海市",
"861453856", "甘肃省平凉市",
"861822046", "陕西省汉中市",
"86136392", "贵州省遵义市",
"861323743", "湖南省湘西土家族苗族自治州",
"861340011", "河北省石家庄市",
"861551288", "河北省沧州市",
"861882501", "广东省中山市",
"861520316", "河北省廊坊市",
"861811040", "安徽省合肥市",
"86188450", "黑龙江省哈尔滨市",
"86189331", "广东省江门市",
"861340731", "湖南省长沙市",
"861760669", "广东省东莞市",
"861512857", "河北省承德市",
"86158572", "浙江省湖州市",
"861527613", "新疆喀什地区",
"861531431", "山东省东营市",
"861556999", "甘肃省兰州市",
"861845233", "江苏省扬州市",
"86177352", "山西省大同市",
"861329055", "河北省唐山市",
"861458660", "湖南省邵阳市",
"861518367", "四川省德阳市",
"861309150", "黑龙江省鹤岗市",
"861500973", "青海省黄南藏族自治州",
"861384874", "内蒙古巴彦淖尔市",
"861332160", "广西南宁市",
"86134252", "广东省清远市",
"861375331", "山西省阳泉市",
"861877019", "江西省抚州市",
"861537724", "湖北省恩施土家族苗族自治州",
"861316768", "安徽省亳州市",
"861598603", "广东省河源市",
"861572243", "江苏省南通市",
"861392307", "广东省江门市",
"861346434", "辽宁省鞍山市",
"861529543", "江苏省无锡市",
"861534562", "安徽省铜陵市",
"861532786", "湖北省武汉市",
"861388668", "湖北省宜昌市",
"861334411", "北京市",
"861367562", "安徽省合肥市",
"861705010", "广东省广州市",
"861820792", "江西省九江市",
"861569535", "青海省果洛藏族自治州",
"861821247", "贵州省铜仁地区",
"861390877", "云南省玉溪市",
"861836764", "浙江省嘉兴市",
"861857840", "广东省佛山市",
"861303081", "福建省莆田市",
"861880905", "新疆昌吉回族自治州",
"861535019", "江西省萍乡市",
"861478414", "河南省商丘市",
"861867022", "湖南省湘潭市",
"861590772", "广西柳州市",
"861830971", "青海省西宁市",
"861453437", "辽宁省盘锦市",
"861820460", "黑龙江省哈尔滨市",
"861776793", "吉林省延边朝鲜族自治州",
"861364724", "湖北省荆门市",
"861322538", "山东省泰安市",
"86131208", "上海市",
"861771250", "江苏省盐城市",
"861339241", "广东省深圳市",
"861452484", "内蒙古乌兰察布市",
"861534903", "甘肃省白银市",
"861528370", "四川省阿坝藏族羌族自治州",
"861301547", "山西省太原市",
"861562833", "内蒙古巴彦淖尔市",
"861521569", "安徽省合肥市",
"86187158", "四川省泸州市",
"861351609", "辽宁省沈阳市",
"861820539", "山东省临沂市",
"861335348", "山西省运城市",
"86180290", "广东省东莞市",
"861828916", "西藏那曲地区",
"861891212", "江苏省扬州市",
"861450592", "辽宁省朝阳市",
"861319047", "辽宁省本溪市",
"861777503", "安徽省合肥市",
"861887582", "浙江省温州市",
"861870426", "辽宁省盘锦市",
"861369848", "江西省景德镇市",
"861810967", "安徽省阜阳市",
"861805688", "安徽省合肥市",
"861770828", "广东省中山市",
"861366400", "内蒙古通辽市",
"861813901", "新疆昌吉回族自治州",
"861705501", "广东省汕头市",
"861531501", "山东省青岛市",
"861535138", "四川省成都市",
"861565096", "青海省西宁市",
"861571312", "河北省保定市",
"86188443", "吉林省延边朝鲜族自治州",
"861521987", "广东省潮州市",
"861882431", "广东省深圳市",
"861362777", "广西钦州市",
"861508096", "湖南省岳阳市",
"861899749", "青海省海西蒙古族藏族自治州",
"861882993", "广东省惠州市",
"861889621", "云南省临沧市",
"86158731", "湖南省长沙市",
"861898026", "四川省乐山市",
"861360815", "四川省自贡市",
"861819003", "四川省泸州市",
"86184687", "江苏省南京市",
"861810589", "浙江省金华市",
"861559546", "宁夏中卫市",
"861337679", "广东省汕头市",
"86170758", "安徽省合肥市",
"86187634", "山东省莱芜市",
"861560302", "广东省深圳市",
"861397248", "湖北省十堰市",
"861525560", "安徽省合肥市",
"86131575", "浙江省绍兴市",
"861550926", "陕西省安康市",
"861872983", "陕西省渭南市",
"861453980", "广东省深圳市",
"861458609", "湖北省随州市",
"861522486", "河南省南阳市",
"861807045", "江西省宜春市",
"86155812", "湖南省娄底市",
"86176089", "海南省海口市",
"861500932", "甘肃省定西市",
"861837526", "贵州省黔东南苗族侗族自治州",
"861319922", "黑龙江省双鸭山市",
"861309983", "云南省楚雄彝族自治州",
"861894570", "黑龙江省大兴安岭地区",
"861459097", "广东省梅州市",
"861458206", "安徽省黄山市",
"861310542", "山东省青岛市",
"861837141", "湖北省黄石市",
"861760600", "福建省泉州市",
"861768645", "山东省青岛市",
"861863478", "山西省吕梁市",
"861858913", "西藏山南地区",
"861337066", "山东省临沂市",
"861860452", "黑龙江省齐齐哈尔市",
"861816935", "湖南省郴州市",
"861536566", "江苏省盐城市",
"86189698", "浙江省宁波市",
"861847416", "湖南省娄底市",
"861575141", "江苏省镇江市",
"861830760", "广东省中山市",
"861801962", "江苏省盐城市",
"861327550", "安徽省滁州市",
"86188862", "贵州省遵义市",
"86132271", "湖北省孝感市",
"861589167", "陕西省汉中市",
"861308706", "河南省平顶山市",
"861312588", "吉林省吉林市",
"86132203", "重庆市",
"86135486", "湖南省长沙市",
"861590733", "湖南省株洲市",
"861771610", "四川省成都市",
"86151776", "广西梧州市",
"861365706", "江西省吉安市",
"861399782", "湖北省十堰市",
"861576843", "广东省惠州市",
"86133038", "河南省郑州市",
"861808895", "云南省文山壮族苗族自治州",
"861815049", "福建省泉州市",
"861374895", "河南省郑州市",
"86157321", "河北省石家庄市",
"861869355", "甘肃省金昌市",
"861333174", "吉林省长春市",
"861776930", "湖南省岳阳市",
"861378593", "河北省秦皇岛市",
"861820761", "广东省东莞市",
"861810152", "江苏省无锡市",
"861380697", "福建省三明市",
"861362346", "山西省太原市",
"861337551", "山东省德州市",
"861801472", "江苏省南京市",
"861533628", "陕西省安康市",
"861325263", "吉林省长春市",
"861886489", "山东省聊城市",
"861366530", "山东省菏泽市",
"861895703", "浙江省衢州市",
"861839395", "甘肃省武威市",
"861768993", "福建省漳州市",
"861370687", "浙江省温州市",
"861838639", "贵州省黔西南布依族苗族自治州",
"86156255", "广东省东莞市",
"861868902", "西藏日喀则地区",
"861384885", "内蒙古通辽市",
"86153259", "浙江省金华市",
"861521731", "广东省广州市",
"86139905", "四川省内江市",
"861566091", "河南省商丘市",
"861534591", "福建省三明市",
"861378178", "河南省南阳市",
"861366701", "江西省鹰潭市",
"861520359", "山西省运城市",
"861366469", "黑龙江省双鸭山市",
"861569405", "四川省巴中市",
"861818998", "西藏日喀则地区",
"861374332", "吉林省长春市",
"861507846", "广西柳州市",
"861834429", "广东省深圳市",
"861839832", "四川省内江市",
"861373998", "内蒙古呼和浩特市",
"861777157", "湖北省荆门市",
"861351660", "广东省佛山市",
"861453507", "山东省济南市",
"861550313", "河北省张家口市",
"861778554", "贵州省六盘水市",
"861864865", "内蒙古乌兰察布市",
"861335412", "辽宁省鞍山市",
"861569814", "山东省青岛市",
"861887116", "湖北省武汉市",
"861452475", "黑龙江省双鸭山市",
"861868563", "贵州省遵义市",
"861315082", "内蒙古乌兰察布市",
"861586344", "山东省青岛市",
"861453819", "四川省南充市",
"861535314", "陕西省西安市",
"861450314", "河北省承德市",
"861346504", "山东省菏泽市",
"861360339", "河北省石家庄市",
"861351936", "甘肃省张掖市",
"861881598", "福建省泉州市",
"861536679", "江苏省徐州市",
"861787517", "广东省河源市",
"861819503", "宁夏吴忠市",
"861813231", "河北省邯郸市",
"861454324", "内蒙古乌海市",
"861853018", "河南省焦作市",
"861536276", "广东省清远市",
"861804231", "浙江省杭州市",
"86180223", "广东省广州市",
"861898141", "四川省内江市",
"861853738", "河南省开封市",
"861830419", "辽宁省辽阳市",
"861353484", "广东省江门市",
"86186868", "黑龙江省哈尔滨市",
"861534233", "湖北省武汉市",
"861833037", "河北省秦皇岛市",
"861558729", "云南省大理白族自治州",
"86180568", "安徽省亳州市",
"861518465", "黑龙江省鹤岗市",
"861324700", "江西省南昌市",
"861528934", "陕西省西安市",
"8615250", "江苏省苏州市",
"861894260", "河北省邯郸市",
"861810089", "云南省昆明市",
"861553382", "河北省衡水市",
"86170708", "广东省广州市",
"86138631", "山东省威海市",
"861334979", "湖北省十堰市",
"861310042", "广西柳州市",
"861373244", "浙江省金华市",
"861531510", "山东省济南市",
"861819962", "新疆阿勒泰地区",
"861568220", "四川省广元市",
"861893134", "河北省秦皇岛市",
"861379908", "福建省龙岩市",
"861337566", "山东省枣庄市",
"861524090", "云南省临沧市",
"861810375", "河南省平顶山市",
"86159375", "河南省平顶山市",
"861820756", "广东省珠海市",
"861305841", "广东省广州市",
"861807545", "安徽省淮南市",
"861841963", "甘肃省平凉市",
"861377843", "四川省德阳市",
"861571399", "河南省驻马店市",
"861560748", "湖南省长沙市",
"861818244", "陕西省西安市",
"861769508", "宁夏银川市",
"861342528", "广东省肇庆市",
"861300909", "吉林省延边朝鲜族自治州",
"861324531", "山东省济南市",
"861590513", "江苏省连云港市",
"86189914", "陕西省商洛市",
"861575026", "云南省普洱市",
"861588407", "四川省阿坝藏族羌族自治州",
"86137923", "山东省济宁市",
"861330720", "湖北省宜昌市",
"861331791", "江西省南昌市",
"861347373", "河北省沧州市",
"861509480", "山东省泰安市",
"861812805", "广东省肇庆市",
"861301922", "吉林省长春市",
"861311983", "广东省汕尾市",
"861338248", "江苏省南通市",
"861332418", "辽宁省阜新市",
"861581265", "广东省潮州市",
"86184678", "贵州省贵阳市",
"861321972", "四川省乐山市",
"86185482", "内蒙古兴安盟",
"861813093", "新疆和田地区",
"861533940", "甘肃省武威市",
"861300771", "青海省西宁市",
"86177269", "甘肃省兰州市",
"861334530", "新疆塔城地区",
"861320721", "湖北省宜昌市",
"861893227", "江苏省盐城市",
"861774691", "河南省南阳市",
"861376855", "广西玉林市",
"861321790", "江西省新余市",
"861868273", "四川省成都市",
"861346360", "河北省廊坊市",
"861877271", "湖北省荆门市",
"861593082", "河北省衡水市",
"861805273", "江苏省常州市",
"861772800", "广东省东莞市",
"861367091", "广东省佛山市",
"861804093", "新疆和田地区",
"861599346", "河南省驻马店市",
"861539378", "河南省许昌市",
"861321462", "黑龙江省齐齐哈尔市",
"861770370", "河南省商丘市",
"861317257", "广东省潮州市",
"861705867", "广东省深圳市",
"861450271", "内蒙古呼和浩特市",
"86139955", "湖北省武汉市",
"861453892", "云南省大理白族自治州",
"861535271", "新疆伊犁哈萨克自治州",
"861819472", "青海省海西蒙古族藏族自治州",
"861504664", "黑龙江省绥化市",
"861534091", "山西省临汾市",
"861308459", "河北省承德市",
"861580957", "宁夏银川市",
"861513664", "河南省商丘市",
"86155128", "河北省邢台市",
"861820334", "河北省衡水市",
"86178268", "浙江省杭州市",
"861535061", "河北省保定市",
"861334701", "内蒙古呼伦贝尔市",
"861537825", "四川省巴中市",
"861570672", "浙江省嘉兴市",
"861568165", "四川省巴中市",
"861325198", "浙江省丽水市",
"861372615", "广东省江门市",
"861453335", "浙江省衢州市",
"861315582", "江西省南昌市",
"861305523", "福建省厦门市",
"861567701", "广西南宁市",
"861589996", "广东省广州市",
"861325573", "浙江省嘉兴市",
"861700366", "广东省东莞市",
"861844739", "内蒙古巴彦淖尔市",
"861778923", "陕西省安康市",
"861571936", "甘肃省金昌市",
"861852480", "辽宁省辽阳市",
"861509821", "山东省菏泽市",
"861339997", "新疆阿克苏地区",
"861310831", "四川省宜宾市",
"86185734", "湖南省衡阳市",
"861555647", "安徽省合肥市",
"861309240", "江苏省无锡市",
"861368712", "湖北省孝感市",
"861538321", "河北省石家庄市",
"861369957", "江西省上饶市",
"861538488", "内蒙古鄂尔多斯市",
"86136819", "上海市",
"861885147", "江苏省淮安市",
"861808323", "贵州省铜仁地区",
"861586638", "山东省烟台市",
"861505509", "安徽省淮北市",
"861598393", "四川省广元市",
"861813729", "河南省安阳市",
"861810427", "辽宁省盘锦市",
"861323917", "陕西省宝鸡市",
"861332275", "广东省揭阳市",
"86133815", "上海市",
"861870966", "宁夏中卫市",
"861561264", "河北省廊坊市",
"86138420", "辽宁省沈阳市",
"861889516", "宁夏固原市",
"861821157", "广东省广州市",
"861572437", "辽宁省盘锦市",
"861802046", "江苏省盐城市",
"86130416", "上海市",
"861303743", "湖南省湘西土家族苗族自治州",
"861330956", "宁夏石嘴山市",
"86187816", "四川省绵阳市",
"86158577", "浙江省温州市",
"861366353", "山西省阳泉市",
"861770596", "福建省漳州市",
"861346612", "云南省曲靖市",
"861500316", "河北省廊坊市",
"861302161", "山东省烟台市",
"861771140", "四川省绵阳市",
"861561074", "山东省德州市",
"86159615", "江苏省无锡市",
"86177357", "山西省临汾市",
"861351399", "河南省驻马店市",
"861318349", "四川省攀枝花市",
"861557843", "广西南宁市",
"861332065", "四川省宜宾市",
"861595401", "山东省日照市",
"86131316", "河北省廊坊市",
"861878410", "四川省宜宾市",
"861829540", "宁夏银川市",
"861475720", "浙江省台州市",
"86189889", "广东省广州市",
"861840200", "广东省广州市",
"861333080", "四川省自贡市",
"86155923", "陕西省渭南市",
"861454579", "四川省攀枝花市",
"861800970", "青海省海北藏族自治州",
"86156582", "浙江省宁波市",
"861866911", "云南省昆明市",
"861311555", "黑龙江省哈尔滨市",
"861890645", "山东省烟台市",
"861313410", "辽宁省铁岭市",
"861780586", "浙江省台州市",
"86184318", "河北省衡水市",
"861821991", "甘肃省兰州市",
"86150882", "浙江省金华市",
"861840374", "河南省许昌市",
"861800792", "江西省九江市",
"861512948", "陕西省西安市",
"86138129", "江苏省苏州市",
"861839541", "陕西省渭南市",
"861390827", "重庆市",
"861338406", "河南省平顶山市",
"861591709", "广东省阳江市",
"861801247", "江苏省无锡市",
"861800460", "黑龙江省哈尔滨市",
"861367345", "河南省信阳市",
"861364774", "广西梧州市",
"861302538", "广东省云浮市",
"861590722", "湖北省武汉市",
"861831990", "广东省梅州市",
"861520973", "青海省黄南藏族自治州",
"86189704", "江西省抚州市",
"861845447", "山东省聊城市",
"861327333", "河北省衡水市",
"86134257", "广东省佛山市",
"861329150", "浙江省嘉兴市",
"861387282", "湖北省十堰市",
"861320636", "山东省青岛市",
"861519676", "四川省南充市",
"861501430", "广东省汕头市",
"861319491", "四川省自贡市",
"86892", "西藏日喀则地区\、仲巴县",
"861500923", "陕西省渭南市",
"861572856", "广东省深圳市",
"861858664", "贵州省铜仁地区",
"861341932", "四川省攀枝花市",
"861320239", "广东省佛山市",
"861890993", "新疆石河子市",
"861509543", "甘肃省兰州市",
"86180011", "北京市",
"861890431", "吉林省长春市",
"861811145", "四川省乐山市",
"861858195", "四川省成都市",
"861560661", "浙江省宁波市",
"861887646", "福建省泉州市",
"861800539", "山东省临沂市",
"861454930", "江苏省常州市",
"861880343", "山西省阳泉市",
"861454651", "云南省昆明市",
"861834587", "黑龙江省伊春市",
"86187349", "山西省朔州市",
"861582013", "广东省潮州市",
"861893810", "广东省河源市",
"861502845", "河北省邯郸市",
"86182290", "陕西省西安市",
"861374916", "河南省开封市",
"861519069", "江苏省徐州市",
"861887249", "湖北省荆州市",
"86135144", "吉林省长春市",
"861770878", "云南省楚雄彝族自治州",
"861566222", "吉林省长春市",
"861359986", "福建省莆田市",
"861350672", "浙江省湖州市",
"861870476", "内蒙古赤峰市",
"861358703", "浙江省衢州市",
"861336884", "云南省昆明市",
"861346868", "陕西省汉中市",
"861508204", "四川省内江市",
"861596406", "山东省滨州市",
"861539870", "云南省昭通市",
"861879538", "宁夏银川市",
"861557146", "湖北省荆州市",
"861867262", "湖北省荆门市",
"86183854", "贵州省安顺市",
"861528320", "四川省资阳市",
"86188348", "山西省太原市",
"861576616", "广东省深圳市",
"861305532", "福建省泉州市",
"861351312", "河北省保定市",
"861368532", "山东省青岛市",
"861831882", "广东省惠州市",
"861454269", "西藏拉萨市",
"861575600", "安徽省铜陵市",
"861583048", "河北省衡水市",
"86152878", "云南省曲靖市",
"861592957", "陕西省延安市",
"861595410", "山东省济南市",
"861840487", "内蒙古乌兰察布市",
"86157589", "云南省德宏傣族景颇族自治州",
"861891306", "江苏省苏州市",
"861707914", "浙江省宁波市",
"861778932", "甘肃省临夏回族自治州",
"861454666", "广东省深圳市",
"861515942", "福建省宁德市",
"861454385", "贵州省黔东南苗族侗族自治州",
"861779057", "四川省阿坝藏族羌族自治州",
"861889736", "青海省果洛藏族自治州",
"86151060", "福建省泉州市",
"86158588", "浙江省温州市",
"861322246", "江苏省徐州市",
"861328416", "辽宁省锦州市",
"861365363", "山西省运城市",
"861878769", "云南省迪庆藏族自治州",
"861304769", "江苏省宿迁市",
"861889016", "湖南省邵阳市",
"861304401", "山东省泰安市",
"861760526", "江苏省宿迁市",
"86183789", "广西玉林市",
"861479707", "青海省海西蒙古族藏族自治州",
"861308363", "河南省洛阳市",
"861872555", "安徽省马鞍山市",
"861313401", "江西省九江市",
"861310467", "黑龙江省鸡西市",
"861345033", "广东省韶关市",
"861339863", "河北省保定市",
"861322649", "广东省珠海市",
"86186785", "山东省菏泽市",
"86159516", "江苏省南京市",
"861313769", "河南省周口市",
"861302853", "陕西省渭南市",
"861309555", "安徽省马鞍山市",
"861783950", "河南省漯河市",
"861824889", "江苏省苏州市",
"86137812", "河南省周口市",
"861561574", "山东省泰安市",
"861822682", "安徽省滁州市",
"86180412", "辽宁省鞍山市",
"861802121", "江苏省镇江市",
"861332565", "新疆伊犁哈萨克自治州",
"861368799", "江西省萍乡市",
"86182417", "辽宁省营口市",
"861364393", "河南省濮阳市",
"861597321", "湖南省湘潭市",
"861591456", "广东省佛山市",
"861380814", "四川省攀枝花市",
"861597488", "云南省昭通市",
"861334353", "湖北省宜昌市",
"86181312", "河北省保定市",
"86159419", "辽宁省辽阳市",
"861567353", "湖南省郴州市",
"861855066", "江苏省盐城市",
"861326485", "湖北省孝感市",
"86183291", "浙江省杭州市",
"861311055", "福建省莆田市",
"861594712", "内蒙古包头市",
"86153367", "浙江省绍兴市",
"861820648", "山东省潍坊市",
"861560259", "广东省中山市",
"861896361", "江苏省南京市",
"861572861", "广东省湛江市",
"861394817", "内蒙古鄂尔多斯市",
"861786541", "山东省济南市",
"861331849", "广东省珠海市",
"861333580", "浙江省舟山市",
"861530696", "福建省泉州市",
"861320960", "宁夏银川市",
"861356843", "四川省绵阳市",
"861330471", "内蒙古呼和浩特市",
"86135321", "广东省惠州市",
"861780798", "江西省景德镇市",
"861893801", "广东省汕头市",
"861890867", "湖北省襄樊市",
"861336774", "广西贺州市",
"861317795", "江西省宜春市",
"861386567", "安徽省蚌埠市",
"861302038", "辽宁省阜新市",
"861826107", "江苏省宿迁市",
"861539780", "江西省南昌市",
"86147538", "山东省泰安市",
"861886027", "河南省驻马店市",
"861519430", "山东省青岛市",
"861302156", "山东省东营市",
"861501676", "广东省东莞市",
"861301491", "广西南宁市",
"861839041", "湖南省益阳市",
"861300420", "浙江省嘉兴市",
"861452327", "河南省平顶山市",
"861457197", "浙江省衢州市",
"861521626", "江西省抚州市",
"861323581", "浙江省杭州市",
"861330961", "安徽省淮北市",
"861333907", "安徽省宿州市",
"861320470", "内蒙古呼伦贝尔市",
"861884864", "贵州省毕节地区",
"861550687", "广西防城港市",
"861771362", "四川省成都市",
"861840793", "江西省上饶市",
"861514755", "内蒙古通辽市",
"861855551", "安徽省合肥市",
"86186342", "山西省晋中市",
"861458594", "山东省泰安市",
"86189754", "湖南省衡阳市",
"861500554", "安徽省淮南市",
"861770788", "广西河池市",
"86134207", "广东省佛山市",
"861344071", "湖北省武汉市",
"861558178", "山西省太原市",
"861889354", "甘肃省武威市",
"861814417", "福建省宁德市",
"861363101", "广东省潮州市",
"86181563", "安徽省宣城市",
"861884946", "河北省廊坊市",
"861356146", "山东省聊城市",
"86182683", "浙江省嘉兴市",
"861800039", "河北省邢台市",
"861532826", "四川省巴中市",
"861528052", "福建省南平市",
"861370313", "河北省张家口市",
"86134226", "广东省江门市",
"861582513", "云南省玉溪市",
"861533283", "内蒙古兴安盟",
"861803417", "河北省沧州市",
"861587277", "湖北省咸宁市",
"861529937", "新疆巴音郭楞蒙古自治州",
"861879156", "陕西省安康市",
"86159110", "北京市",
"861870630", "山东省青岛市",
"861870951", "宁夏银川市",
"86183804", "四川省成都市",
"861598774", "云南省玉溪市",
"861470412", "辽宁省鞍山市",
"861321047", "山东省枣庄市",
"861367222", "江西省南昌市",
"861372145", "河南省焦作市",
"86181228", "广东省东莞市",
"861875884", "浙江省宁波市",
"861557021", "江西省九江市",
"861505060", "江苏省南通市",
"86158191", "广东省阳江市",
"861318498", "河北省沧州市",
"86182568", "安徽省阜阳市",
"861313700", "河南省商丘市",
"861318544", "浙江省嘉兴市",
"861395590", "安徽省铜陵市",
"861351594", "福建省漳州市",
"861873544", "山西省晋中市",
"861380535", "山东省烟台市",
"861870745", "湖南省怀化市",
"861508934", "广东省惠州市",
"861304700", "广东省潮州市",
"861577912", "江西省抚州市",
"86181688", "江苏省无锡市",
"861816179", "陕西省铜川市",
"861334929", "安徽省合肥市",
"8615680", "四川省成都市",
"861452658", "江西省景德镇市",
"861565934", "福建省宁德市",
"861862767", "湖南省衡阳市",
"861876634", "山东省莱芜市",
"861454374", "山东省德州市",
"861595031", "江苏省盐城市",
"861840579", "浙江省金华市",
"861898576", "贵州省黔南布依族苗族自治州",
"861354142", "四川省雅安市",
"861838548", "贵州省黔南布依族苗族自治州",
"861550451", "黑龙江省哈尔滨市",
"861886942", "云南省昭通市",
"861805454", "山东省临沂市",
"861766012", "山东省济南市",
"861454200", "河南省郑州市",
"86134686", "陕西省西安市",
"861767709", "广西北海市",
"861556336", "山东省济南市",
"86177230", "重庆市",
"861868454", "湖南省株洲市",
"86138974", "青海省西宁市",
"86135365", "广东省珠海市",
"861320909", "新疆博尔塔拉蒙古自治州",
"861304531", "黑龙江省牡丹江市",
"861340626", "山东省济宁市",
"861867533", "广东省梅州市",
"861580848", "四川省泸州市",
"861330770", "广西防城港市",
"861879119", "陕西省铜川市",
"86185487", "内蒙古鄂尔多斯市",
"861340229", "山东省德州市",
"861321922", "四川省遂宁市",
"861529480", "河南省信阳市",
"861477301", "湖南省长沙市",
"861896392", "湖北省恩施土家族苗族自治州",
"861301972", "黑龙江省哈尔滨市",
"861572892", "西藏日喀则地区",
"861326474", "湖北省武汉市",
"861313531", "湖南省长沙市",
"861810325", "河北省唐山市",
"861377256", "陕西省咸阳市",
"861764059", "辽宁省盘锦市",
"861568270", "甘肃省平凉市",
"861394560", "黑龙江省大庆市",
"861584689", "黑龙江省大庆市",
"861305402", "湖南省常德市",
"861582882", "四川省内江市",
"861325841", "四川省南充市",
"861506550", "山东省威海市",
"861800756", "广东省珠海市",
"861377659", "江苏省连云港市",
"861363468", "黑龙江省鹤岗市",
"861561585", "山东省烟台市",
"861861776", "河北省保定市",
"861809483", "新疆克拉玛依市",
"861535221", "甘肃省天水市",
"861814839", "内蒙古呼和浩特市",
"861889059", "湖南省娄底市",
"861771391", "四川省广元市",
"861555331", "山东省淄博市",
"861328459", "黑龙江省大庆市",
"861770320", "河北省邯郸市",
"861335840", "福建省三明市",
"861890510", "江苏省盐城市",
"861318102", "山东省滨州市",
"861800334", "河北省秦皇岛市",
"861502744", "河北省石家庄市",
"861840930", "甘肃省临夏回族自治州",
"86155990", "江苏省苏州市",
"861596036", "福建省厦门市",
"861524195", "辽宁省辽阳市",
"861363978", "青海省西宁市",
"861528878", "山东省烟台市",
"86139648", "山东省青岛市",
"861320771", "广西南宁市",
"861458312", "江西省萍乡市",
"861893277", "河北省沧州市",
"861301790", "浙江省湖州市",
"861539328", "甘肃省陇南市",
"861327155", "河南省郑州市",
"861539481", "云南省德宏傣族景颇族自治州",
"861330992", "新疆伊犁哈萨克自治州",
"861824093", "新疆石河子市",
"861336785", "广西玉林市",
"861770552", "安徽省蚌埠市",
"861367447", "吉林省白城市",
"861700413", "辽宁省鞍山市",
"861368573", "浙江省宁波市",
"86134330", "广东省东莞市",
"861325523", "江苏省南通市",
"861382493", "广东省清远市",
"861581170", "广东省湛江市",
"861364875", "云南省保山市",
"86158354", "山西省晋中市",
"86138493", "河南省新乡市",
"861818154", "四川省乐山市",
"861560619", "江苏省无锡市",
"861315646", "山东省潍坊市",
"861825063", "福建省泉州市",
"861834230", "辽宁省盘锦市",
"86177574", "浙江省宁波市",
"86151873", "云南省红河哈尼族彝族自治州",
"86151801", "江西省南昌市",
"861871914", "广东省广州市",
"861571609", "福建省南平市",
"861470348", "山西省吕梁市",
"861860904", "新疆喀什地区",
"86189925", "陕西省安康市",
"861895674", "安徽省阜阳市",
"861534447", "湖南省郴州市",
"861338716", "湖北省咸宁市",
"861345072", "广东省梅州市",
"861587801", "广西玉林市",
"861572819", "广东省广州市",
"86155399", "河南省南阳市",
"861380035", "山西省忻州市",
"861811797", "四川省泸州市",
"861858747", "广西梧州市",
"861337629", "江苏省常州市",
"861332284", "广东省佛山市",
"861505560", "安徽省蚌埠市",
"861516147", "江苏省南京市",
"861550976", "青海省玉树藏族自治州",
"861350633", "山东省日照市",
"861879192", "陕西省榆林市",
"861776529", "广东省深圳市",
"861573475", "内蒙古通辽市",
"861568560", "贵州省贵阳市",
"86187971", "青海省西宁市",
"861348391", "河北省保定市",
"861330880", "云南省昆明市",
"861552040", "四川省南充市",
"861889182", "陕西省榆林市",
"861779103", "陕西省渭南市",
"861827250", "河南省鹤壁市",
"861564226", "辽宁省朝阳市",
"86187903", "河南省驻马店市",
"861572507", "山东省济宁市",
"861850310", "河北省邯郸市",
"861529207", "湖南省益阳市",
"86184682", "云南省昆明市",
"861326387", "广西来宾市",
"861899862", "广东省云浮市",
"86185478", "内蒙古巴彦淖尔市",
"861562822", "新疆昌吉回族自治州",
"861335634", "山东省莱芜市",
"861840666", "广东省深圳市",
"861840385", "黑龙江省黑河市",
"861527143", "湖北省十堰市",
"861334135", "湖南省郴州市",
"861454487", "湖北省荆州市",
"861345403", "浙江省衢州市",
"86130271", "湖北省武汉市",
"861576659", "广东省惠州市",
"861304031", "吉林省白城市",
"861821962", "甘肃省定西市",
"86134585", "四川省成都市",
"861389149", "陕西省咸阳市",
"861867713", "广西崇左市",
"86188867", "贵州省毕节地区",
"86176710", "湖北省黄冈市",
"861304711", "湖北省荆州市",
"861319972", "新疆巴音郭楞蒙古自治州",
"8613940", "辽宁省沈阳市",
"861595700", "浙江省衢州市",
"861310686", "广东省东莞市",
"861808959", "四川省攀枝花市",
"861897548", "湖南省邵阳市",
"861310365", "河南省平顶山市",
"861374959", "河南省焦作市",
"861301203", "河北省沧州市",
"861329983", "青海省海东地区",
"861479281", "安徽省阜阳市",
"861327372", "河南省新乡市",
"861520932", "甘肃省定西市",
"861333237", "辽宁省盘锦市",
"861567135", "湖北省荆州市",
"86181677", "新疆昌吉回族自治州",
"861764559", "黑龙江省伊春市",
"86145221", "浙江省宁波市",
"86145844", "山东省青岛市",
"861454211", "河南省安阳市",
"861587989", "江西省宜春市",
"861341973", "河南省驻马店市",
"861879408", "甘肃省陇南市",
"861596536", "山东省潍坊市",
"861803315", "广东省肇庆市",
"861890730", "湖南省岳阳市",
"861501731", "广东省中山市",
"861319790", "江西省新余市",
"861814315", "吉林省通化市",
"861560692", "福建省厦门市",
"861889559", "安徽省马鞍山市",
"861530763", "广东省清远市",
"861470702", "江西省九江市",
"861773078", "陕西省榆林市",
"861591492", "广东省梅州市",
"861856739", "河南省新乡市",
"861800761", "广东省阳江市",
"861846204", "山东省青岛市",
"861558910", "山东省临沂市",
"861800409", "辽宁省大连市",
"861364785", "广西玉林市",
"861857702", "广西防城港市",
"861593249", "河北省石家庄市",
"861305263", "辽宁省朝阳市",
"861806974", "浙江省绍兴市",
"861591760", "广东省清远市",
"861821472", "安徽省黄山市",
"861359850", "河南省焦作市",
"861593646", "河南省安阳市",
"861594573", "黑龙江省牡丹江市",
"861377261", "陕西省咸阳市",
"861811483", "江苏省徐州市",
"861775149", "江苏省无锡市",
"861518139", "四川省广元市",
"861452425", "辽宁省大连市",
"861320881", "云南省西双版纳傣族自治州",
"861313293", "广西桂林市",
"861381944", "浙江省宁波市",
"861501500", "广东省中山市",
"86151851", "贵州省贵阳市",
"861572980", "四川省德阳市",
"861336875", "云南省保山市",
"861890501", "福建省福州市",
"861304293", "甘肃省庆阳市",
"861893567", "青海省海西蒙古族藏族自治州",
"861305073", "辽宁省阜新市",
"861325954", "宁夏固原市",
"861338536", "山东省潍坊市",
"861500359", "山西省运城市",
"861566447", "山东省泰安市",
"861888283", "四川省雅安市",
"861853984", "河南省焦作市",
"861330919", "陕西省铜川市",
"861761488", "内蒙古呼和浩特市",
"861345572", "山东省东营市",
"861760390", "河南省焦作市",
"861773268", "河北省秦皇岛市",
"861302408", "安徽省蚌埠市",
"861514854", "内蒙古锡林郭勒盟",
"861582990", "陕西省西安市",
"861573965", "新疆哈密地区",
"861458399", "福建省南平市",
"861834479", "江苏省宿迁市",
"861887241", "湖北省荆门市",
"86156309", "河北省邢台市",
"861519061", "江苏省泰州市",
"861771448", "江苏省扬州市",
"861871846", "广东省揭阳市",
"861771594", "江苏省盐城市",
"861507796", "安徽省淮南市",
"861454659", "云南省临沧市",
"861800531", "山东省济南市",
"861452852", "甘肃省酒泉市",
"861332928", "安徽省淮南市",
"861361994", "新疆乌鲁木齐市",
"861512155", "贵州省黔西南布依族苗族自治州",
"861301412", "甘肃省张掖市",
"861326914", "甘肃省临夏回族自治州",
"86153305", "重庆市",
"8613868", "浙江省温州市",
"861339582", "浙江省湖州市",
"861811958", "安徽省宿州市",
"861562940", "湖北省恩施土家族苗族自治州",
"861530533", "山东省淄博市",
"861539267", "山西省阳泉市",
"861390020", "广东省广州市",
"861823042", "河北省保定市",
"861890560", "安徽省合肥市",
"861780340", "山西省晋城市",
"861586497", "山东省临沂市",
"86177365", "河北省唐山市",
"861392438", "广东省茂名市",
"861812053", "湖北省十堰市",
"86135230", "河南省郑州市",
"861313756", "河南省开封市",
"861808745", "云南省昆明市",
"861570934", "甘肃省庆阳市",
"86158147", "广东省深圳市",
"861800700", "江西省南昌市",
"861539077", "江西省上饶市",
"861580642", "山东省青岛市",
"861839549", "陕西省西安市",
"861857933", "江西省上饶市",
"861577472", "内蒙古包头市",
"861572698", "浙江省丽水市",
"861857491", "湖南省常德市",
"861591701", "广东省佛山市",
"861700463", "上海市",
"861890439", "吉林省白山市",
"861470933", "甘肃省兰州市",
"861371553", "广东省佛山市",
"861320231", "广东省惠州市",
"861582688", "湖北省武汉市",
"861560669", "浙江省宁波市",
"861307006", "新疆克孜勒苏柯尔克孜自治州",
"861825013", "福建省龙岩市",
"86157352", "山西省大同市",
"86158590", "福建省福州市",
"861560266", "广东省惠州市",
"861850142", "江苏省泰州市",
"86151806", "江西省九江市",
"861319499", "四川省成都市",
"861344579", "山东省青岛市",
"861559778", "贵州省黔南布依族苗族自治州",
"861571045", "陕西省安康市",
"861700973", "浙江省嘉兴市",
"861330230", "广东省广州市",
"861812838", "广东省茂名市",
"861350320", "河北省石家庄市",
"861351391", "河南省濮阳市",
"861318341", "四川省达州市",
"861595409", "山东省青岛市",
"861510597", "福建省厦门市",
"861566604", "山东省聊城市",
"861520703", "江西省上饶市",
"86134681", "山东省临沂市",
"861302169", "山东省青岛市",
"861871474", "黑龙江省齐齐哈尔市",
"861860875", "云南省保山市",
"861826288", "江苏省镇江市",
"86158196", "广东省揭阳市",
"861769535", "宁夏中卫市",
"861554426", "河南省三门峡市",
"861508622", "贵州省黔东南苗族侗族自治州",
"861454571", "四川省达州市",
"861364904", "四川省泸州市",
"861332834", "福建省漳州市",
"861821999", "甘肃省陇南市",
"861391233", "江苏省常州市",
"861568010", "四川省德阳市",
"861880725", "湖北省黄冈市",
"861866919", "云南省西双版纳傣族自治州",
"86147883", "河南省安阳市",
"861350552", "安徽省蚌埠市",
"861898692", "湖北省武汉市",
"861576793", "广东省江门市",
"861558239", "山西省临汾市",
"861304334", "吉林省长春市",
"861519556", "江苏省扬州市",
"861333887", "江苏省泰州市",
"861534723", "湖北省武汉市",
"861538329", "河北省石家庄市",
"86152918", "陕西省西安市",
"861310839", "四川省广元市",
"861358973", "山东省滨州市",
"861558636", "湖北省宜昌市",
"861533782", "湖北省武汉市",
"861313334", "山西省忻州市",
"861834992", "四川省成都市",
"861850504", "福建省宁德市",
"861813721", "河南省焦作市",
"861347476", "内蒙古赤峰市",
"861879169", "陕西省渭南市",
"861708552", "安徽省合肥市",
"86159279", "湖北省荆州市",
"861853228", "河北省张家口市",
"86180272", "广东省广州市",
"861329458", "山西省吕梁市",
"861577503", "广东省茂名市",
"861505501", "安徽省滁州市",
"861864952", "山西省晋中市",
"86132794", "陕西省西安市",
"861367723", "湖北省荆门市",
"861570828", "四川省自贡市",
"861344269", "黑龙江省佳木斯市",
"861827609", "广西梧州市",
"861800031", "河北省石家庄市",
"861597180", "湖北省恩施土家族苗族自治州",
"861560576", "浙江省台州市",
"861390352", "山西省大同市",
"861856069", "山东省潍坊市",
"861558960", "山东省烟台市",
"861826632", "山东省枣庄市",
"861827206", "湖北省襄樊市",
"861363109", "广东省清远市",
"861832968", "陕西省西安市",
"861815832", "浙江省温州市",
"861770633", "山东省日照市",
"861590454", "黑龙江省佳木斯市",
"86180744", "湖南省张家界市",
"86156359", "山西省运城市",
"861591710", "广东省茂名市",
"861559888", "内蒙古巴彦淖尔市",
"861555034", "山东省淄博市",
"861809958", "新疆巴音郭楞蒙古自治州",
"861362443", "吉林省延边朝鲜族自治州",
"861479977", "新疆昌吉回族自治州",
"861356529", "新疆塔城地区",
"861319412", "辽宁省鞍山市",
"861890060", "江苏省苏州市",
"861399940", "新疆乌鲁木齐市",
"861803686", "江苏省无锡市",
"861388148", "四川省凉山彝族自治州",
"861557029", "江西省萍乡市",
"861322435", "吉林省通化市",
"861814365", "吉林省吉林市",
"861870959", "宁夏银川市",
"86170878", "江苏省徐州市",
"861886820", "浙江省湖州市",
"861814686", "陕西省汉中市",
"861858423", "四川省南充市",
"861390520", "江苏省徐州市",
"861333346", "山西省太原市",
"861393378", "河北省张家口市",
"861569438", "吉林省松原市",
"861341413", "广东省广州市",
"861595118", "江苏省苏州市",
"861839049", "湖南省郴州市",
"861301499", "广西南宁市",
"861330969", "安徽省合肥市",
"861890270", "广东省汕头市",
"861323589", "浙江省金华市",
"861709781", "浙江省台州市",
"861321840", "江苏省徐州市",
"861314242", "内蒙古包头市",
"861884035", "陕西省安康市",
"861550416", "辽宁省锦州市",
"861815395", "甘肃省兰州市",
"861890304", "广东省汕头市",
"861539577", "浙江省温州市",
"861831273", "广东省湛江市",
"861453742", "湖南省常德市",
"86151856", "贵州省黔东南苗族侗族自治州",
"861344079", "湖北省武汉市",
"861379380", "山东省泰安市",
"861893517", "山西省吕梁市",
"861855559", "安徽省黄山市",
"86139250", "广东省广州市",
"861530858", "贵州省六盘水市",
"86187976", "湖南省永州市",
"861597329", "湖南省邵阳市",
"861361248", "广东省佛山市",
"861899812", "广东省惠州市",
"861571545", "山东省烟台市",
"861376962", "云南省文山壮族苗族自治州",
"861824881", "江苏省无锡市",
"861816908", "宁夏银川市",
"861560898", "西藏拉萨市",
"861769307", "甘肃省酒泉市",
"861347197", "广西梧州市",
"861368791", "江西省南昌市",
"861862537", "河南省平顶山市",
"861786549", "山东省临沂市",
"861348594", "安徽省宣城市",
"861572869", "广东省珠海市",
"861560251", "广东省茂名市",
"861896369", "江苏省苏州市",
"861330479", "内蒙古锡林郭勒盟",
"861350052", "安徽省芜湖市",
"861333777", "江苏省镇江市",
"861331841", "广东省中山市",
"861348448", "陕西省榆林市",
"86181623", "湖北省武汉市",
"861891947", "甘肃省酒泉市",
"861336904", "新疆伊犁哈萨克自治州",
"86145207", "上海市",
"861355149", "四川省巴中市",
"861530291", "广东省湛江市",
"86188637", "山东省济宁市",
"861310315", "河北省唐山市",
"861881397", "广东省梅州市",
"8617743", "吉林省长春市",
"861575692", "四川省雅安市",
"86145226", "浙江省台州市",
"861519056", "江苏省苏州市",
"861584836", "内蒙古通辽市",
"861394730", "内蒙古乌海市",
"86152694", "山东省德州市",
"861454261", "西藏拉萨市",
"861313761", "河南省信阳市",
"861310707", "湖南省益阳市",
"861399455", "山西省晋中市",
"861313409", "江西省萍乡市",
"86132464", "广东省广州市",
"861358202", "河北省石家庄市",
"861458140", "浙江省台州市",
"861892446", "广东省肇庆市",
"861806414", "湖北省襄樊市",
"861832478", "安徽省阜阳市",
"861821912", "广东省茂名市",
"861860785", "广西贵港市",
"861304409", "山东省济宁市",
"861709937", "浙江省丽水市",
"861479467", "黑龙江省鸡西市",
"861878761", "云南省文山壮族苗族自治州",
"861320593", "福建省宁德市",
"861587517", "广东省阳江市",
"86130658", "浙江省宁波市",
"861355748", "广西河池市",
"861529188", "陕西省榆林市",
"861839344", "甘肃省天水市",
"86136341", "浙江省杭州市",
"861810743", "湖南省湘西土家族苗族自治州",
"861864996", "福建省泉州市",
"861342658", "江西省九江市",
"861506670", "山东省潍坊市",
"861318637", "陕西省宝鸡市",
"86180016", "上海市",
"861309684", "贵州省黔南布依族苗族自治州",
"861560611", "江苏省常州市",
"861319348", "河南省鹤壁市",
"861899583", "湖北省荆州市",
"861822778", "四川省攀枝花市",
"86183333", "河北省张家口市",
"861587809", "广西梧州市",
"861800410", "辽宁省铁岭市",
"861571601", "福建省三明市",
"86150708", "江西省南昌市",
"861335047", "四川省巴中市",
"861707387", "河南省许昌市",
"861876547", "山东省济宁市",
"861827660", "广西梧州市",
"861313970", "新疆昌吉回族自治州",
"861329803", "内蒙古赤峰市",
"861379205", "山东省东营市",
"861322505", "福建省三明市",
"861705220", "云南省昆明市",
"861450626", "黑龙江省牡丹江市",
"861880938", "甘肃省天水市",
"861379728", "湖北省荆州市",
"861535229", "甘肃省白银市",
"861318190", "山东省淄博市",
"861351140", "浙江省衢州市",
"861395144", "江苏省扬州市",
"861867212", "湖北省荆州市",
"861364234", "广东省深圳市",
"861576666", "广东省湛江市",
"861569508", "宁夏银川市",
"861882694", "广东省珠海市",
"861328451", "黑龙江省哈尔滨市",
"861450229", "河北省保定市",
"861760748", "湖南省怀化市",
"861555339", "山东省日照市",
"86135357", "广东省佛山市",
"861314427", "广东省汕头市",
"861872684", "安徽省淮北市",
"861893860", "广东省清远市",
"86188020", "广东省广州市",
"861301702", "贵州省黔南布依族苗族自治州",
"861877229", "湖北省黄石市",
"861552194", "广东省揭阳市",
"861320779", "广西北海市",
"861815176", "江苏省镇江市",
"861501807", "广东省惠州市",
"861330900", "四川省自贡市",
"861323477", "内蒙古鄂尔多斯市",
"861709480", "浙江省宁波市",
"861338945", "甘肃省金昌市",
"861300729", "江西省九江市",
"861552665", "吉林省长春市",
"861452578", "福建省泉州市",
"861870323", "河北省张家口市",
"861533833", "广东省佛山市",
"861303427", "浙江省嘉兴市",
"861708878", "广东省茂名市",
"861477309", "湖南省邵阳市",
"861865476", "山东省德州市",
"86158523", "江苏省徐州市",
"861340221", "山东省济南市",
"86151537", "山东省济宁市",
"861313539", "湖南省邵阳市",
"861853415", "山西省临汾市",
"861330587", "浙江省温州市",
"861329106", "甘肃省白银市",
"861320901", "新疆塔城地区",
"861304539", "黑龙江省大庆市",
"861817677", "广西梧州市",
"861896300", "山东省德州市",
"861870916", "陕西省汉中市",
"861879111", "陕西省延安市",
"861875127", "江苏省淮安市",
"861537127", "江苏省扬州市",
"861532397", "广东省珠海市",
"861857203", "湖北省随州市",
"861505867", "浙江省金华市",
"861377930", "新疆巴音郭楞蒙古自治州",
"861325849", "四川省广安市",
"861570370", "河南省商丘市",
"861780957", "宁夏吴忠市",
"861568867", "山东省威海市",
"861305653", "四川省广安市",
"861305490", "山东省临沂市",
"861831232", "广东省揭阳市",
"861363708", "安徽省合肥市",
"861764051", "辽宁省阜新市",
"86158268", "湖北省孝感市",
"861513002", "河北省邯郸市",
"86176205", "广东省东莞市",
"861338450", "黑龙江省哈尔滨市",
"861584681", "黑龙江省哈尔滨市",
"861338693", "福建省龙岩市",
"861860774", "广西梧州市",
"861597024", "江西省吉安市",
"861518278", "四川省巴中市",
"861313792", "河南省焦作市",
"86145330", "浙江省杭州市",
"861597953", "江西省宜春市",
"861806623", "浙江省金华市",
"861588338", "四川省乐山市",
"861334921", "安徽省芜湖市",
"861816171", "陕西省延安市",
"861855516", "安徽省马鞍山市",
"861533136", "四川省凉山彝族自治州",
"861596693", "山东省青岛市",
"861350878", "云南省楚雄彝族自治州",
"861304792", "江西省九江市",
"861705165", "山东省青岛市",
"861313460", "山西省忻州市",
"861807094", "广西南宁市",
"861815873", "浙江省绍兴市",
"861770672", "浙江省湖州市",
"861767701", "广西南宁市",
"86187811", "四川省绵阳市",
"861452896", "云南省昆明市",
"86130411", "北京市",
"861778703", "云南省西双版纳傣族自治州",
"861394993", "河南省商丘市",
"861500685", "山东省东营市",
"861880824", "四川省达州市",
"861824636", "黑龙江省佳木斯市",
"861595039", "江苏省淮安市",
"861454292", "辽宁省大连市",
"861332735", "湖南省郴州市",
"861550459", "黑龙江省大庆市",
"861332015", "江西省宜春市",
"861840571", "浙江省杭州市",
"86131311", "河北省石家庄市",
"861589647", "江苏省无锡市",
"861830353", "山西省阳泉市",
"861452268", "浙江省丽水市",
"861831688", "广东省湛江市",
"861884814", "内蒙古赤峰市",
"861815497", "新疆喀什地区",
"861890509", "福建省南平市",
"86130012", "北京市",
"861587017", "贵州省安顺市",
"861599185", "陕西省西安市",
"861320889", "云南省昆明市",
"86130608", "广东省广州市",
"86151913", "陕西省渭南市",
"861860393", "河南省濮阳市",
"861323384", "河南省新乡市",
"86132017", "陕西省西安市",
"861301348", "云南省玉溪市",
"861587737", "陕西省宝鸡市",
"861890817", "四川省成都市",
"861311684", "浙江省衢州市",
"86150758", "河北省衡水市",
"861335547", "山东省济宁市",
"861302768", "河南省漯河市",
"861876047", "福建省漳州市",
"861834471", "江苏省镇江市",
"861339758", "湖南省娄底市",
"861458391", "福建省三明市",
"861773425", "河北省保定市",
"861500351", "山西省太原市",
"861369798", "江西省景德镇市",
"861327620", "江苏省盐城市",
"86188855", "贵州省黔东南苗族侗族自治州",
"861330911", "陕西省延安市",
"861889551", "安徽省阜阳市",
"861344487", "云南省昭通市",
"861501739", "广东省湛江市",
"861569008", "河北省承德市",
"861530403", "辽宁省大连市",
"861700932", "甘肃省兰州市",
"861470462", "黑龙江省齐齐哈尔市",
"861822888", "四川省巴中市",
"861595970", "福建省龙岩市",
"86145939", "贵州省贵阳市",
"861319702", "湖北省黄石市",
"861322005", "陕西省渭南市",
"861560600", "福建省厦门市",
"861505645", "安徽省芜湖市",
"861563876", "河南省许昌市",
"861350096", "吉林省四平市",
"861470790", "江西省新余市",
"861816238", "湖北省荆门市",
"861814467", "广东省珠海市",
"861518131", "四川省自贡市",
"861308926", "吉林省松原市",
"861764066", "辽宁省鞍山市",
"861776843", "江苏省南通市",
"861593241", "河北省承德市",
"861803467", "甘肃省临夏回族自治州",
"861800401", "辽宁省沈阳市",
"861571610", "江苏省镇江市",
"86134221", "广东省广州市",
"861800769", "广东省东莞市",
"861389141", "陕西省商洛市",
"861328466", "黑龙江省大庆市",
"861538953", "陕西省商洛市",
"861576930", "甘肃省庆阳市",
"861304039", "吉林省白山市",
"861365313", "河北省张家口市",
"86177321", "河北省石家庄市",
"861304719", "湖北省恩施土家族苗族自治州",
"861850434", "吉林省四平市",
"861538024", "江苏省镇江市",
"861308313", "安徽省宣城市",
"861889066", "湖南省怀化市",
"861310417", "辽宁省营口市",
"861502617", "新疆昌吉回族自治州",
"861505993", "福建省龙岩市",
"861898661", "湖北省咸宁市",
"861313719", "河南省安阳市",
"861339813", "四川省自贡市",
"861375167", "广东省揭阳市",
"861313039", "辽宁省本溪市",
"861345763", "广西玉林市",
"861859383", "贵州省安顺市",
"861871485", "安徽省淮南市",
"861764551", "黑龙江省绥化市",
"861835991", "福建省福州市",
"861351362", "山西省太原市",
"861513502", "山西省忻州市",
"861323893", "辽宁省辽阳市",
"861860884", "云南省红河哈尼族彝族自治州",
"86176255", "江苏省苏州市",
"861470972", "青海省海东地区",
"861778624", "湖北省黄石市",
"861454219", "河南省驻马店市",
"861374951", "河南省焦作市",
"861808951", "四川省成都市",
"861551464", "河南省驻马店市",
"861808630", "湖北省黄石市",
"861350788", "广西南宁市",
"861479289", "安徽省亳州市",
"86137295", "广东省汕尾市",
"861856987", "河南省郑州市",
"86183296", "陕西省汉中市",
"861818295", "云南省保山市",
"861707846", "云南省德宏傣族景颇族自治州",
"861594762", "内蒙古包头市",
"861776521", "广东省珠海市",
"861597524", "广东省揭阳市",
"861394867", "内蒙古鄂尔多斯市",
"861572811", "广东省深圳市",
"861776146", "四川省攀枝花市",
"861363342", "山西省大同市",
"861533558", "内蒙古呼和浩特市",
"861774434", "四川省成都市",
"861366921", "陕西省延安市",
"861337621", "江苏省无锡市",
"861320910", "陕西省咸阳市",
"861369086", "广东省梅州市",
"861813420", "河北省邯郸市",
"861835157", "江苏省无锡市",
"861889276", "四川省内江市",
"86156262", "广东省广州市",
"861332515", "山东省烟台市",
"861530572", "浙江省湖州市",
"861390396", "河南省驻马店市",
"861344793", "西藏拉萨市",
"861537452", "湖北省黄石市",
"861814542", "黑龙江省伊春市",
"861367394", "河南省周口市",
"861302435", "江苏省镇江市",
"861823365", "河北省沧州市",
"861510635", "山东省聊城市",
"861361716", "湖北省荆州市",
"861823686", "河南省焦作市",
"861326796", "广东省珠海市",
"861309625", "四川省眉山市",
"861337354", "河北省保定市",
"86155183", "河南省驻马店市",
"861390570", "浙江省衢州市",
"861393481", "山西省大同市",
"86177935", "甘肃省武威市",
"861562678", "广东省汕头市",
"86157326", "河北省廊坊市",
"861370706", "江西省吉安市",
"861560526", "江苏省泰州市",
"861535000", "江西省南昌市",
"861470547", "山东省济宁市",
"861364452", "黑龙江省齐齐哈尔市",
"861479927", "新疆乌鲁木齐市",
"861356579", "新疆阿勒泰地区",
"861560141", "江苏省盐城市",
"861569946", "新疆喀什地区",
"861811386", "四川省攀枝花市",
"86182744", "湖南省邵阳市",
"861705009", "广东省广州市",
"861334760", "广西南宁市",
"86156148", "河北省衡水市",
"861459608", "宁夏中卫市",
"861534394", "河南省周口市",
"861829958", "新疆阿克苏地区",
"861344029", "江苏省扬州市",
"861569864", "山西省忻州市",
"861327506", "福建省三明市",
"861856229", "山东省泰安市",
"861365750", "新疆喀什地区",
"861831223", "广东省梅州市",
"86138043", "吉林省长春市",
"861335790", "江苏省无锡市",
"861844569", "黑龙江省哈尔滨市",
"861570096", "新疆伊犁哈萨克自治州",
"861769130", "陕西省榆林市",
"861321499", "内蒙古呼伦贝尔市",
"861760656", "浙江省宁波市",
"861375404", "内蒙古乌兰察布市",
"861458250", "安徽省合肥市",
"861303589", "广东省阳江市",
"861530947", "甘肃省酒泉市",
"861323242", "广东省江门市",
"861845012", "福建省漳州市",
"861586541", "山东省滨州市",
"861898748", "云南省昆明市",
"861838776", "云南省玉溪市",
"861772861", "广东省惠州市",
"861760259", "江苏省淮安市",
"861517408", "辽宁省锦州市",
"861395614", "安徽省六安市",
"861450511", "吉林省四平市",
"861501221", "云南省曲靖市",
"861333727", "湖南省益阳市",
"861580798", "江西省景德镇市",
"861330429", "辽宁省葫芦岛市",
"861343861", "四川省眉山市",
"861538585", "安徽省蚌埠市",
"861567108", "湖北省荆门市",
"86188632", "山东省枣庄市",
"861331402", "辽宁省沈阳市",
"861883074", "河北省沧州市",
"86145202", "北京市",
"861572742", "湖南省邵阳市",
"861870332", "河北省保定市",
"861533822", "广东省汕头市",
"861335972", "黑龙江省哈尔滨市",
"861571362", "河南省商丘市",
"861390939", "甘肃省陇南市",
"861325791", "江西省南昌市",
"86158736", "湖南省常德市",
"861802179", "江苏省淮安市",
"861804881", "四川省乐山市",
"861819999", "新疆乌鲁木齐市",
"861367883", "山东省淄博市",
"861360865", "河南省洛阳市",
"861879641", "江苏省泰州市",
"86180288", "广东省广州市",
"861302641", "陕西省渭南市",
"861314152", "江苏省连云港市",
"86151118", "重庆市",
"861830710", "湖北省襄樊市",
"86137988", "广东省东莞市",
"861773746", "河南省洛阳市",
"861861494", "河南省焦作市",
"86189220", "广东省江门市",
"861521556", "安徽省安庆市",
"861589117", "陕西省榆林市",
"86132276", "湖北省荆州市",
"86183438", "吉林省松原市",
"86134013", "江苏省常州市",
"861324761", "广东省深圳市",
"861300593", "广西柳州市",
"861894201", "湖南省衡阳市",
"86135481", "四川省成都市",
"861357157", "陕西省铜川市",
"861771660", "贵州省黔西南布依族苗族自治州",
"86151771", "广西南宁市",
"861324409", "吉林省四平市",
"861861548", "山东省菏泽市",
"861890694", "福建省漳州市",
"861880885", "云南省迪庆藏族自治州",
"861517192", "湖北省宜昌市",
"861311458", "黑龙江省伊春市",
"861300178", "山东省济宁市",
"8615310", "重庆市",
"861897183", "湖北省荆门市",
"861809847", "安徽省马鞍山市",
"861337736", "广西贵港市",
"86138535", "山东省烟台市",
"861319634", "陕西省宝鸡市",
"86138989", "辽宁省葫芦岛市",
"86150694", "山东省威海市",
"861365687", "浙江省温州市",
"861877500", "广西防城港市",
"861599124", "陕西省咸阳市",
"861555996", "云南省曲靖市",
"861705817", "广东省东莞市",
"861339249", "广东省广州市",
"861390070", "江西省南昌市",
"861521561", "安徽省淮北市",
"861857047", "湖南省衡阳市",
"861768817", "广东省珠海市",
"861339646", "山东省潍坊市",
"861361536", "山东省潍坊市",
"861838886", "云南省曲靖市",
"861814042", "四川省凉山彝族自治州",
"861783548", "山西省长治市",
"861317744", "湖北省咸宁市",
"861893368", "广东省汕头市",
"861336452", "吉林省吉林市",
"861331073", "贵州省安顺市",
"861773484", "河南省洛阳市",
"861899955", "新疆昌吉回族自治州",
"861705509", "福建省厦门市",
"861813909", "新疆巴音郭楞蒙古自治州",
"861450500", "吉林省延边朝鲜族自治州",
"861820531", "山东省济南市",
"861458545", "河南省三门峡市",
"861378909", "湖南省株洲市",
"861351601", "辽宁省朝阳市",
"861346310", "河北省邯郸市",
"861366492", "广东省江门市",
"861332978", "湖北省荆门市",
"861306914", "吉林省长春市",
"861321412", "辽宁省鞍山市",
"861772437", "广东省河源市",
"861331263", "云南省曲靖市",
"861700316", "河北省唐山市",
"861360647", "山东省潍坊市",
"861471470", "广东省河源市",
"861821855", "广东省肇庆市",
"861598452", "四川省雅安市",
"861319840", "四川省自贡市",
"861868733", "云南省昆明市",
"861343856", "四川省达州市",
"861877011", "江西省鹰潭市",
"861356666", "浙江省台州市",
"86157357", "山西省临汾市",
"861868013", "广东省揭阳市",
"861356385", "山东省菏泽市",
"861830979", "青海省海西蒙古族藏族自治州",
"861390260", "广东省东莞市",
"861539027", "四川省绵阳市",
"861820700", "江西省南昌市",
"86138380", "河南省郑州市",
"861535011", "江西省南昌市",
"86158142", "广东省东莞市",
"861372194", "山东省潍坊市",
"861505115", "江苏省连云港市",
"861839282", "陕西省渭南市",
"861334419", "上海市",
"861886780", "浙江省丽水市",
"86170882", "海南省海口市",
"861303089", "福建省厦门市",
"861391447", "江苏省南京市",
"861372386", "湖南省长沙市",
"861580586", "浙江省台州市",
"861830469", "黑龙江省双鸭山市",
"86135269", "河南省洛阳市",
"861880775", "广西玉林市",
"861590902", "新疆哈密地区",
"861830701", "江西省南昌市",
"861454521", "广西南宁市",
"861518415", "辽宁省营口市",
"861454146", "吉林省白城市",
"861566883", "辽宁省丹东市",
"86178084", "贵州省铜仁地区",
"861887151", "湖北省咸宁市",
"86138636", "山东省潍坊市",
"861872458", "黑龙江省伊春市",
"861453698", "陕西省渭南市",
"861350370", "河南省商丘市",
"861787567", "广东省广州市",
"86137977", "湖北省襄樊市",
"861700923", "山东省济南市",
"861772856", "广东省湛江市",
"861471960", "甘肃省武威市",
"861340019", "河北省邢台市",
"861860825", "四川省遂宁市",
"861709543", "江苏省南京市",
"861853068", "河南省南阳市",
"861398016", "四川省广元市",
"861500703", "江西省上饶市",
"861531439", "山东省枣庄市",
"861774252", "湖南省长沙市",
"861760661", "广东省东莞市",
"861340739", "湖南省邵阳市",
"86159564", "安徽省六安市",
"86151753", "河北省保定市",
"861590563", "安徽省宣城市",
"86186638", "山东省烟台市",
"861347426", "陕西省咸阳市",
"861300093", "辽宁省营口市",
"861858897", "广东省深圳市",
"861782013", "广东省肇庆市",
"86182272", "四川省宜宾市",
"861309458", "四川省宜宾市",
"861830530", "山东省菏泽市",
"861570878", "云南省楚雄彝族自治州",
"861367773", "广西桂林市",
"861450987", "新疆阿勒泰地区",
"861536736", "湖南省常德市",
"861378771", "湖南省衡阳市",
"86138861", "湖北省武汉市",
"861581215", "云南省西双版纳傣族自治州",
"861535987", "福建省厦门市",
"86130794", "辽宁省营口市",
"861332468", "陕西省铜川市",
"861521138", "湖南省衡阳市",
"861585046", "江苏省镇江市",
"861538379", "河北省石家庄市",
"861877987", "江西省南昌市",
"861534773", "广西桂林市",
"861324334", "河南省许昌市",
"861842018", "广东省肇庆市",
"861337516", "江苏省苏州市",
"861529829", "四川省泸州市",
"861708370", "河南省商丘市",
"861841913", "甘肃省定西市",
"86131671", "上海市",
"861370459", "黑龙江省大庆市",
"861343153", "广东省东莞市",
"861776616", "江苏省无锡市",
"861892208", "广东省湛江市",
"861524144", "辽宁省本溪市",
"861313648", "浙江省台州市",
"861479104", "陕西省榆林市",
"86152758", "山东省聊城市",
"861517038", "江西省上饶市",
"861834421", "广东省阳江市",
"861879005", "河南省信阳市",
"86183242", "浙江省温州市",
"861378960", "内蒙古呼伦贝尔市",
"86183963", "福建省龙岩市",
"861366461", "黑龙江省哈尔滨市",
"861327670", "浙江省宁波市",
"861520351", "山西省太原市",
"861366709", "江西省南昌市",
"861705560", "吉林省长春市",
"861569765", "广东省揭阳市",
"861304648", "山东省潍坊市",
"861773475", "河南省洛阳市",
"861878648", "贵州省毕节地区",
"861311803", "四川省泸州市",
"861453811", "四川省成都市",
"861833644", "河南省新乡市",
"86189293", "广东省深圳市",
"861566512", "江苏省连云港市",
"861506948", "山东省枣庄市",
"861534732", "湖南省湘潭市",
"861303196", "河北省张家口市",
"86138000", "北京市",
"861894493", "湖南省怀化市",
"861314196", "湖南省邵阳市",
"86132608", "江苏省南京市",
"861316538", "山东省泰安市",
"861334837", "福建省厦门市",
"86132012", "新疆乌鲁木齐市",
"861514482", "内蒙古兴安盟",
"861321348", "河南省濮阳市",
"861362907", "四川省巴中市",
"861877569", "广西南宁市",
"861886481", "山东省泰安市",
"861337559", "山东省淄博市",
"861308976", "黑龙江省黑河市",
"861874976", "河南省焦作市",
"861390606", "福建省漳州市",
"861370416", "辽宁省锦州市",
"861535430", "河北省邯郸市",
"861815041", "福建省漳州市",
"861315166", "江苏省苏州市",
"861820769", "广东省东莞市",
"861353915", "广东省梅州市",
"86156710", "湖北省宜昌市",
"86157078", "海南省海口市",
"861521739", "广东省佛山市",
"86138825", "四川省遂宁市",
"861566099", "河南省南阳市",
"861534599", "福建省泉州市",
"86133410", "北京市",
"861877430", "湖南省湘西土家族苗族自治州",
"861564559", "黑龙江省七台河市",
"861835247", "江苏省无锡市",
"86185356", "山西省晋城市",
"861707424", "浙江省杭州市",
"861361406", "辽宁省锦州市",
"861778674", "湖北省随州市",
"861303893", "陕西省西安市",
"861380438", "吉林省松原市",
"861837149", "湖北省武汉市",
"861870794", "江西省抚州市",
"861873595", "山西省临汾市",
"861579806", "江西省萍乡市",
"861871613", "四川省泸州市",
"861882560", "广东省阳江市",
"86901", "新疆塔城地区",
"861458601", "湖北省恩施土家族苗族自治州",
"861556962", "甘肃省定西市",
"861351545", "山东省烟台市",
"861471909", "甘肃省张掖市",
"861760692", "云南省德宏傣族景颇族自治州",
"861894787", "内蒙古鄂尔多斯市",
"861868772", "云南省昆明市",
"861479542", "广西梧州市",
"861847687", "广东省深圳市",
"861354662", "山西省晋城市",
"861538074", "江苏省泰州市",
"861860603", "福建省泉州市",
"861308466", "浙江省金华市",
"861570052", "四川省广安市",
"861336177", "江西省赣州市",
"861888822", "山东省德州市",
"861857922", "江西省九江市",
"861354753", "四川省广安市",
"861575149", "江苏省淮安市",
"861880784", "广西梧州市",
"861317667", "山东省济南市",
"86186391", "河南省焦作市",
"861530522", "江苏省徐州市",
"861564671", "山东省济宁市",
"86136115", "江苏省南京市",
"861477868", "广东省茂名市",
"86139332", "河北省保定市",
"861772980", "四川省泸州市",
"861556503", "河南省商丘市",
"86133119", "上海市",
"861531509", "山东省临沂市",
"861845883", "浙江省温州市",
"861590688", "浙江省丽水市",
"861899741", "青海省西宁市",
"861583347", "河北省唐山市",
"861524963", "河南省安阳市",
"861882439", "广东省深圳市",
"861362580", "浙江省衢州市",
"861700359", "山西省临汾市",
"861776571", "广东省珠海市",
"86181735", "湖南省郴州市",
"861331032", "内蒙古鄂尔多斯市",
"861816046", "新疆喀什地区",
"861560390", "河南省郑州市",
"861363565", "安徽省合肥市",
"861537496", "内蒙古通辽市",
"861813470", "河南省周口市",
"861459890", "广东省东莞市",
"861785888", "浙江省宁波市",
"861337671", "广东省湛江市",
"861530350", "山西省忻州市",
"861810581", "浙江省杭州市",
"861340314", "河北省承德市",
"861315863", "四川省宜宾市",
"861300910", "吉林省长春市",
"861531817", "山东省济宁市",
"861850868", "湖北省孝感市",
"861338303", "河北省石家庄市",
"861842925", "陕西省安康市",
"861705060", "江苏省苏州市",
"861334709", "内蒙古包头市",
"861304920", "广东省云浮市",
"861340556", "江苏省扬州市",
"861802778", "广东省茂名市",
"861478464", "黑龙江省七台河市",
"861535069", "河北省廊坊市",
"861708934", "广东省湛江市",
"861820410", "辽宁省铁岭市",
"86152708", "江西省南昌市",
"861879505", "宁夏中卫市",
"861309803", "陕西省安康市",
"861807660", "广西南宁市",
"861316038", "江苏省南通市",
"86132658", "广东省深圳市",
"861509188", "陕西省榆林市",
"861775266", "湖南省邵阳市",
"861366837", "四川省乐山市",
"861896690", "陕西省西安市",
"861327436", "吉林省白城市",
"861391345", "江苏省徐州市",
"861567709", "广西桂林市",
"861566012", "河南省新乡市",
"861599907", "新疆昌吉回族自治州",
"861534512", "江苏省苏州市",
"86189680", "浙江省杭州市",
"86138050", "福建省福州市",
"861780848", "贵州省毕节地区",
"861877279", "湖北省十堰市",
"861317845", "广东省清远市",
"861367099", "广东省湛江市",
"861321702", "江西省九江市",
"86180628", "湖北省黄冈市",
"861303477", "内蒙古鄂尔多斯市",
"861452528", "山东省东营市",
"861870373", "河南省新乡市",
"861300779", "青海省西宁市",
"861357472", "湖南省益阳市",
"861772892", "广东省东莞市",
"861810917", "陕西省宝鸡市",
"861323427", "辽宁省盘锦市",
"861815126", "江苏省淮安市",
"861320729", "湖北省荆州市",
"861774699", "河南省许昌市",
"861840843", "宁夏吴忠市",
"861453800", "四川省德阳市",
"861782882", "四川省自贡市",
"861705270", "浙江省杭州市",
"861371985", "广东省阳江市",
"861535676", "浙江省台州市",
"861596303", "山东省济宁市",
"861335933", "甘肃省平凉市",
"861450279", "内蒙古锡林郭勒盟",
"861768304", "四川省遂宁市",
"86145369", "陕西省西安市",
"861308451", "河北省沧州市",
"861534099", "山西省运城市",
"861705304", "广东省深圳市",
"86136610", "北京市",
"861379778", "湖北省黄石市",
"861535279", "新疆伊犁哈萨克自治州",
"861305849", "广东省汕头市",
"861318095", "吉林省辽源市",
"86155972", "青海省海东地区",
"861315151", "江苏省扬州市",
"861570320", "河北省邯郸市",
"86131640", "天津市",
"861524002", "安徽省合肥市",
"861571391", "河南省焦作市",
"861473665", "云南省昭通市",
"861325762", "广东省河源市",
"861882060", "广东省东莞市",
"861808426", "贵州省贵阳市",
"86151532", "山东省青岛市",
"861828476", "四川省遂宁市",
"861314967", "黑龙江省鸡西市",
"861883085", "河北省邯郸市",
"861324539", "山东省临沂市",
"861300901", "吉林省长春市",
"86184894", "西藏拉萨市",
"861303967", "黑龙江省伊春市",
"861357962", "新疆昌吉回族自治州",
"861309106", "河北省唐山市",
"861570552", "安徽省蚌埠市",
"861598496", "四川省凉山彝族自治州",
"861331799", "江西省萍乡市",
"861398671", "湖北省荆州市",
"861356793", "浙江省宁波市",
"861472680", "四川省绵阳市",
"861804239", "浙江省舟山市",
"861327857", "吉林省辽源市",
"861500413", "辽宁省抚顺市",
"861315997", "黑龙江省佳木斯市",
"861351250", "江苏省南京市",
"861813636", "江苏省徐州市",
"861898149", "四川省达州市",
"861366456", "黑龙江省黑河市",
"861520685", "山东省滨州市",
"861586605", "山东省济宁市",
"86157574", "浙江省宁波市",
"861536671", "江苏省泰州市",
"861360331", "河北省石家庄市",
"861336496", "新疆伊犁哈萨克自治州",
"861458610", "湖北省荆门市",
"861396574", "安徽省阜阳市",
"861813239", "河北省保定市",
"861880874", "云南省曲靖市",
"861334971", "湖北省武汉市",
"861810081", "四川省成都市",
"861882304", "广东省梅州市",
"86469", "黑龙江省双鸭山市",
"861518228", "四川省乐山市",
"861860724", "湖北省咸宁市",
"86183774", "广西梧州市",
"861826623", "山东省青岛市",
"861324792", "江西省九江市",
"861771206", "江苏省淮安市",
"861830411", "辽宁省大连市",
"861331532", "河北省张家口市",
"861868882", "广东省深圳市",
"861350828", "四川省广安市",
"861827094", "江西省抚州市",
"861338705", "江西省宜春市",
"861580878", "云南省楚雄彝族自治州",
"861330740", "湖南省岳阳市",
"861868437", "吉林省辽源市",
"861877997", "江西省吉安市",
"86137861", "湖南省长沙市",
"86180461", "福建省漳州市",
"86156216", "山东省潍坊市",
"86189912", "陕西省西安市",
"86176023", "重庆市",
"861361518", "江苏省泰州市",
"861309509", "新疆石河子市",
"86150919", "海南省海口市",
"861474567", "黑龙江省七台河市",
"86139840", "贵州省贵阳市",
"86181361", "江苏省苏州市",
"861568240", "四川省南充市",
"861509712", "甘肃省庆阳市",
"86182131", "云南省曲靖市",
"86186639", "山东省青岛市",
"861338317", "河北省沧州市",
"861508957", "广东省阳江市",
"861505240", "江苏省泰州市",
"861310022", "湖南省永州市",
"861760908", "新疆克孜勒苏柯尔克孜自治州",
"861786616", "甘肃省庆阳市",
"861560728", "湖北省十堰市",
"861450997", "新疆阿克苏地区",
"861368821", "四川省泸州市",
"861532613", "辽宁省沈阳市",
"861535997", "福建省泉州市",
"861786219", "山东省菏泽市",
"861309817", "陕西省铜川市",
"861810562", "安徽省铜陵市",
"86183635", "山东省聊城市",
"861305821", "广东省韶关市",
"861453688", "陕西省宝鸡市",
"861554343", "吉林省吉林市",
"86177084", "湖南省长沙市",
"861351478", "内蒙古巴彦淖尔市",
"861805153", "江苏省苏州市",
"861596317", "山东省聊城市",
"861318574", "浙江省宁波市",
"861872817", "四川省雅安市",
"861700338", "河北省保定市",
"861778164", "四川省自贡市",
"861870775", "广西玉林市",
"861556981", "甘肃省天水市",
"861816149", "四川省阿坝藏族羌族自治州",
"861861377", "河南省南阳市",
"861399769", "湖北省宜昌市",
"861454344", "山东省淄博市",
"86135268", "河南省郑州市",
"861806298", "湖北省宜昌市",
"861881424", "广东省中山市",
"861367967", "四川省泸州市",
"861399401", "山西省临汾市",
"861898546", "贵州省铜仁地区",
"861536853", "云南省楚雄彝族自治州",
"861354172", "四川省绵阳市",
"861551859", "河南省信阳市",
"861840549", "山东省临沂市",
"861882458", "广东省深圳市",
"861317177", "河北省邯郸市",
"861521813", "广东省汕尾市",
"86153640", "湖南省长沙市",
"861552570", "山西省运城市",
"86138977", "青海省海东地区",
"861315279", "山西省运城市",
"861368543", "山东省滨州市",
"861367477", "内蒙古包头市",
"861305543", "福建省厦门市",
"861887011", "江西省赣州市",
"861372184", "河南省南阳市",
"86158357", "山西省临汾市",
"86177577", "浙江省温州市",
"861778943", "甘肃省白银市",
"861839292", "陕西省商洛市",
"861303099", "福建省泉州市",
"861857378", "湖南省株洲市",
"861316559", "河北省保定市",
"861372396", "山东省烟台市",
"861580596", "福建省泉州市",
"861373453", "黑龙江省佳木斯市",
"861800357", "山西省临汾市",
"861866449", "广东省汕头市",
"861570586", "浙江省台州市",
"861398038", "四川省资阳市",
"861576041", "四川省乐山市",
"86137380", "浙江省杭州市",
"861328535", "山东省烟台市",
"861818690", "湖北省武汉市",
"861537845", "四川省眉山市",
"861861746", "河北省秦皇岛市",
"861808235", "江苏省泰州市",
"861369370", "河南省商丘市",
"861593430", "山西省忻州市",
"861521758", "广东省惠州市",
"861357517", "湖南省常德市",
"861859825", "广东省深圳市",
"861303512", "湖北省武汉市",
"861335870", "辽宁省辽阳市",
"861819801", "甘肃省兰州市",
"861363948", "山东省德州市",
"861366482", "内蒙古兴安盟",
"861536038", "广东省云浮市",
"861842716", "湖北省荆门市",
"861388909", "西藏拉萨市",
"861320741", "湖南省长沙市",
"861503461", "山西省晋城市",
"861337538", "山东省泰安市",
"861358114", "山东省泰安市",
"861842036", "广东省阳江市",
"861373137", "河北省衡水市",
"861315069", "云南省昭通市",
"861343733", "广东省江门市",
"861868856", "广东省中山市",
"86151246", "黑龙江省哈尔滨市",
"861818137", "四川省成都市",
"86130066", "广东省深圳市",
"861356832", "四川省自贡市",
"861825243", "江苏省徐州市",
"861514709", "内蒙古呼伦贝尔市",
"861862685", "浙江省杭州市",
"861396595", "安徽省滁州市",
"861527173", "湖北省荆州市",
"861890684", "浙江省宁波市",
"861311817", "四川省绵阳市",
"861335657", "广东省江门市",
"861535863", "江苏省泰州市",
"861310350", "山西省忻州市",
"86139916", "陕西省渭南市",
"861517671", "河北省唐山市",
"861361738", "湖南省娄底市",
"861506065", "福建省福州市",
"861897193", "湖北省十堰市",
"861576823", "广东省湛江市",
"861308697", "贵州省六盘水市",
"86180791", "江西省南昌市",
"86188864", "贵州省黔南布依族苗族自治州",
"861569363", "甘肃省白银市",
"86138988", "辽宁省沈阳市",
"861365697", "福建省南平市",
"861362913", "陕西省渭南市",
"8615522", "天津市",
"861837546", "山东省东营市",
"861897578", "湖南省永州市",
"86137535", "山西省临汾市",
"861319942", "黑龙江省鸡西市",
"861327342", "河北省石家庄市",
"861370008", "辽宁省大连市",
"861311509", "江苏省无锡市",
"861807025", "江西省赣州市",
"86155814", "湖南省永州市",
"861810062", "江苏省南京市",
"86151119", "重庆市",
"86186435", "吉林省通化市",
"861345104", "湖北省黄石市",
"86145847", "山东省青岛市",
"861861484", "内蒙古包头市",
"861705625", "吉林省长春市",
"861870885", "云南省普洱市",
"86181674", "新疆喀什地区",
"86183439", "吉林省白山市",
"861805861", "浙江省嘉兴市",
"861341943", "四川省乐山市",
"86187632", "山东省枣庄市",
"861813891", "广东省佛山市",
"86186986", "辽宁省大连市",
"861459471", "陕西省安康市",
"861880332", "河北省保定市",
"861337853", "贵州省安顺市",
"861804891", "四川省绵阳市",
"861559141", "陕西省商洛市",
"861325781", "广西柳州市",
"861308130", "辽宁省抚顺市",
"861333254", "湖南省衡阳市",
"861570798", "江西省景德镇市",
"861550946", "甘肃省张掖市",
"861827389", "湖南省岳阳市",
"861318074", "吉林省长春市",
"86180289", "广东省东莞市",
"86183536", "山东省潍坊市",
"861534893", "西藏山南地区",
"86157736", "湖南省常德市",
"861580788", "广西河池市",
"861562401", "山东省日照市",
"861804258", "浙江省金华市",
"861471618", "广东省潮州市",
"861813258", "河北省保定市",
"861872009", "江西省南昌市",
"861803306", "广东省深圳市",
"861398161", "四川省雅安市",
"861321489", "内蒙古巴彦淖尔市",
"861860617", "江苏省徐州市",
"861891281", "江苏省镇江市",
"861593069", "河北省邢台市",
"861303599", "云南省西双版纳傣族自治州",
"86183130", "云南省德宏傣族景颇族自治州",
"861476938", "云南省普洱市",
"861316059", "广东省清远市",
"861328307", "河南省信阳市",
"86150310", "河北省邯郸市",
"86151410", "辽宁省铁岭市",
"861586324", "山东省菏泽市",
"861877166", "湖北省孝感市",
"86158307", "河北省邯郸市",
"861782861", "四川省广安市",
"861398538", "贵州省六盘水市",
"861507826", "广西柳州市",
"861871607", "河北省唐山市",
"861889435", "甘肃省金昌市",
"861352563", "河南省濮阳市",
"86147620", "江苏省无锡市",
"861345542", "山东省东营市",
"861335780", "江苏省南京市",
"861576126", "贵州省黔东南苗族侗族自治州",
"861834449", "广东省韶关市",
"861473020", "河北省沧州市",
"86153145", "浙江省宁波市",
"861303012", "广东省韶关市",
"861303732", "湖南省湘潭市",
"861357737", "云南省曲靖市",
"861557832", "广西南宁市",
"861858346", "四川省眉山市",
"861591755", "广东省湛江市",
"86156149", "河北省唐山市",
"86152641", "山东省济南市",
"861534384", "河南省商丘市",
"861337156", "山东省淄博市",
"861478643", "湖南省张家界市",
"861367384", "河南省商丘市",
"861593279", "河北省邯郸市",
"861815029", "福建省莆田市",
"86159069", "云南省临沧市",
"861326786", "广东省湛江市",
"861590800", "山东省潍坊市",
"861343513", "广东省韶关市",
"86158326", "河北省廊坊市",
"86180062", "江苏省苏州市",
"861806944", "浙江省杭州市",
"861362326", "河北省廊坊市",
"861775179", "江苏省南京市",
"861315569", "安徽省安庆市",
"861533648", "山东省青岛市",
"861594543", "黑龙江省佳木斯市",
"86182067", "云南省昆明市",
"861821134", "广东省茂名市",
"86158574", "浙江省宁波市",
"861811020", "安徽省蚌埠市",
"861576605", "广东省茂名市",
"861810091", "陕西省西安市",
"861388636", "湖北省孝感市",
"861390958", "宁夏银川市",
"861303773", "四川省攀枝花市",
"86153671", "湖南省长沙市",
"86156453", "黑龙江省牡丹江市",
"861861475", "内蒙古鄂尔多斯市",
"861870874", "云南省曲靖市",
"861323723", "湖北省黄石市",
"861324782", "江西省九江市",
"861561044", "山东省潍坊市",
"861771170", "湖南省湘西土家族苗族自治州",
"861311560", "黑龙江省哈尔滨市",
"861322566", "安徽省池州市",
"861809352", "甘肃省金昌市",
"861314773", "吉林省吉林市",
"861596415", "山东省德州市",
"86177354", "山西省晋中市",
"861318379", "四川省绵阳市",
"861369934", "新疆巴音郭楞蒙古自治州",
"861453273", "山西省太原市",
"861705803", "上海市",
"861315987", "黑龙江省哈尔滨市",
"861566152", "内蒙古赤峰市",
"861768803", "广东省东莞市",
"861327418", "辽宁省阜新市",
"861536192", "广东省湛江市",
"86152884", "云南省昆明市",
"861454549", "新疆伊犁哈萨克自治州",
"861800940", "甘肃省兰州市",
"861843849", "河南省开封市",
"861332050", "云南省昆明市",
"861808905", "西藏昌都地区",
"861336486", "新疆阿勒泰地区",
"861860257", "江苏省常州市",
"861890675", "浙江省绍兴市",
"861529841", "江苏省无锡市",
"861309270", "湖北省鄂州市",
"861331789", "广西北海市",
"861580320", "河北省邯郸市",
"861581391", "广东省汕尾市",
"861853450", "山西省晋城市",
"861813862", "广东省韶关市",
"86139871", "云南省昆明市",
"861571428", "辽宁省葫芦岛市",
"861580552", "安徽省蚌埠市",
"861844997", "新疆石河子市",
"86135196", "甘肃省兰州市",
"861338415", "辽宁省丹东市",
"861379076", "广东省惠州市",
"861839659", "福建省南平市",
"861459770", "新疆克拉玛依市",
"86147037", "四川省成都市",
"861804862", "四川省德阳市",
"861378862", "广西柳州市",
"861868007", "广东省东莞市",
"861818808", "贵州省六盘水市",
"861880373", "河南省新乡市",
"861768106", "安徽省阜阳市",
"861782892", "四川省巴中市",
"861335481", "内蒙古呼伦贝尔市",
"86189726", "湖北省孝感市",
"86132770", "湖北省武汉市",
"861371995", "广东省梅州市",
"861819567", "青海省玉树藏族自治州",
"861335328", "吉林省吉林市",
"861859724", "青海省海南藏族自治州",
"861887279", "湖北省恩施土家族苗族自治州",
"861376368", "黑龙江省鹤岗市",
"861829939", "新疆伊犁哈萨克自治州",
"861816302", "湖北省黄冈市",
"86170033", "河北省石家庄市",
"861315011", "甘肃省定西市",
"861534089", "山西省临汾市",
"861319027", "辽宁省阜新市",
"861350642", "山东省青岛市",
"861369828", "四川省南充市",
"86188245", "广东省东莞市",
"86135590", "福建省泉州市",
"861389778", "青海省海南藏族自治州",
"861347235", "河北省廊坊市",
"861301527", "内蒙古鄂尔多斯市",
"861508340", "河南省南阳市",
"861709849", "浙江省温州市",
"861593000", "河北省邯郸市",
"861335217", "辽宁省丹东市",
"86183857", "贵州省黔东南苗族侗族自治州",
"861565340", "山东省德州市",
"861386247", "江苏省南通市",
"86132659", "广东省广州市",
"861593364", "河北省廊坊市",
"861889505", "宁夏中卫市",
"86133822", "江苏省无锡市",
"861512978", "陕西省咸阳市",
"86135833", "山东省淄博市",
"861316354", "黑龙江省大庆市",
"861527132", "湖北省随州市",
"861367375", "河南省平顶山市",
"861841907", "甘肃省酒泉市",
"861364744", "湖南省长沙市",
"861560935", "甘肃省武威市",
"86177191", "河南省驻马店市",
"861322051", "山东省东营市",
"86132405", "广东省东莞市",
"861329694", "内蒙古乌兰察布市",
"861586029", "福建省福州市",
"861867042", "湖南省常德市",
"86134254", "广东省中山市",
"861520943", "甘肃省白银市",
"86189707", "江西省赣州市",
"861534375", "河南省平顶山市",
"861537744", "湖南省张家界市",
"861570199", "新疆伊犁哈萨克自治州",
"861782007", "广东省梅州市",
"86137050", "福建省福州市",
"861850689", "浙江省嘉兴市",
"861519646", "四川省眉山市",
"861509573", "甘肃省陇南市",
"861471891", "西藏拉萨市",
"86152709", "江西省南昌市",
"861519249", "山东省青岛市",
"861887069", "江西省鹰潭市",
"861811175", "四川省阿坝藏族羌族自治州",
"861800455", "黑龙江省绥化市",
"861517016", "江西省赣州市",
"861561544", "山东省德州市",
"861311060", "福建省龙岩市",
"861458968", "广东省汕尾市",
"861539634", "福建省漳州市",
"861399531", "宁夏银川市",
"861322066", "山东省临沂市",
"861354836", "四川省泸州市",
"86182414", "辽宁省本溪市",
"861560380", "河南省新乡市",
"861872439", "黑龙江省绥化市",
"861320955", "宁夏中卫市",
"861537486", "内蒙古锡林郭勒盟",
"861340758", "江苏省常州市",
"861785898", "浙江省金华市",
"861811520", "江苏省连云港市",
"861802576", "广东省汕尾市",
"861810591", "福建省福州市",
"86156471", "内蒙古呼和浩特市",
"861332322", "河北省保定市",
"86153653", "江苏省苏州市",
"86133771", "广西南宁市",
"861800628", "江苏省南通市",
"861775888", "黑龙江省哈尔滨市",
"861599090", "山东省济南市",
"861779034", "四川省绵阳市",
"861332550", "新疆巴音郭楞蒙古自治州",
"861364486", "内蒙古赤峰市",
"861355171", "四川省资阳市",
"861772990", "安徽省淮南市",
"861592934", "陕西省延安市",
"86133703", "天津市",
"861309560", "浙江省嘉兴市",
"861829070", "新疆伊犁哈萨克自治州",
"86133118", "上海市",
"86770", "广西防城港市",
"861845893", "浙江省台州市",
"861316516", "山东省青岛市",
"861590698", "云南省保山市",
"861356873", "四川省遂宁市",
"861847130", "湖北省黄冈市",
"861809020", "四川省巴中市",
"861330441", "吉林省吉林市",
"861388470", "山东省潍坊市",
"861362590", "福建省漳州市",
"861508162", "河北省邯郸市",
"861868819", "广东省珠海市",
"861452726", "湖北省武汉市",
"861855246", "江苏省盐城市",
"861370438", "吉林省延边朝鲜族自治州",
"861880794", "江西省抚州市",
"861453563", "贵州省遵义市",
"861553311", "河北省石家庄市",
"861504727", "内蒙古巴彦淖尔市",
"861379576", "四川省绵阳市",
"861381330", "江苏省淮安市",
"861870784", "广西梧州市",
"861868507", "贵州省黔南布依族苗族自治州",
"861322679", "广东省肇庆市",
"861324872", "浙江省宁波市",
"861894797", "内蒙古乌海市",
"861510429", "辽宁省葫芦岛市",
"861302629", "江西省宜春市",
"861878822", "云南省德宏傣族景颇族自治州",
"861309439", "云南省临沧市",
"861304822", "广东省肇庆市",
"86134891", "福建省福州市",
"861847697", "广东省湛江市",
"861311304", "广东省深圳市",
"861380416", "辽宁省锦州市",
"861532253", "广东省湛江市",
"861534589", "浙江省金华市",
"861319527", "贵州省毕节地区",
"861566089", "河南省商丘市",
"861559390", "甘肃省陇南市",
"861500537", "山东省济宁市",
"86139722", "湖北省襄樊市",
"861592828", "四川省泸州市",
"861310947", "甘肃省酒泉市",
"861356176", "山东省泰安市",
"861587247", "湖北省宜昌市",
"861301027", "山东省莱芜市",
"86147161", "广东省东莞市",
"86181325", "河北省唐山市",
"861817404", "江西省南昌市",
"861321077", "山东省枣庄市",
"861340813", "四川省自贡市",
"86183807", "四川省南充市",
"86152670", "浙江省杭州市",
"861571655", "河南省平顶山市",
"86137825", "河南省新乡市",
"861348170", "广西防城港市",
"861501249", "广东省深圳市",
"861336744", "湖南省张家界市",
"86183826", "四川省广安市",
"861862674", "吉林省吉林市",
"861521582", "浙江省台州市",
"861321267", "湖南省娄底市",
"861322551", "安徽省合肥市",
"86132455", "浙江省宁波市",
"861303186", "河北省秦皇岛市",
"861586529", "山东省济南市",
"861894483", "江苏省泰州市",
"86132609", "江苏省南京市",
"861315000", "甘肃省张掖市",
"861893422", "广东省湛江市",
"86136101", "广东省广州市",
"861514492", "内蒙古兴安盟",
"861328405", "黑龙江省绥化市",
"861772772", "广东省东莞市",
"861863206", "河北省衡水市",
"861529954", "新疆哈密地区",
"86152759", "山东省淄博市",
"861524346", "河北省秦皇岛市",
"86134204", "广东省中山市",
"861589103", "陕西省渭南市",
"861856241", "山东省济宁市",
"861863609", "山西省晋中市",
"861330635", "山东省聊城市",
"861328814", "广东省惠州市",
"861317452", "福建省福州市",
"861379898", "广东省珠海市",
"86137000", "辽宁省沈阳市",
"861344041", "辽宁省鞍山市",
"861889337", "甘肃省酒泉市",
"86136978", "山东省烟台市",
"861807075", "广西钦州市",
"861830755", "广东省深圳市",
"861894540", "黑龙江省佳木斯市",
"861863448", "山西省吕梁市",
"861310572", "浙江省湖州市",
"861333963", "贵州省安顺市",
"861572232", "青海省海西蒙古族藏族自治州",
"861705675", "山西省太原市",
"861860795", "江西省宜春市",
"861327565", "安徽省合肥市",
"861320583", "浙江省嘉兴市",
"861313558", "安徽省阜阳市",
"861881387", "广东省汕头市",
"861575171", "江苏省淮安市",
"861831800", "广东省汕尾市",
"861527123", "湖北省武汉市",
"861596568", "山东省菏泽市",
"861569416", "辽宁省锦州市",
"861328697", "广东省湛江市",
"86182791", "江西省南昌市",
"861587003", "江西省南昌市",
"861304558", "安徽省宣城市",
"861576873", "广东省惠州市",
"86181931", "甘肃省兰州市",
"861338568", "安徽省六安市",
"861564246", "辽宁省葫芦岛市",
"861348584", "安徽省宿州市",
"861595136", "江苏省宿迁市",
"861899779", "新疆阿勒泰地区",
"861552020", "四川省巴中市",
"861362747", "湖南省邵阳市",
"86159030", "河南省新乡市",
"861550438", "吉林省松原市",
"861773236", "河北省张家口市",
"861525555", "安徽省合肥市",
"861529799", "江西省萍乡市",
"861373311", "河南省南阳市",
"861366949", "广西玉林市",
"861337649", "山东省滨州市",
"861858727", "云南省曲靖市",
"861459421", "云南省普洱市",
"861452950", "广东省汕头市",
"861459388", "贵州省黔西南布依族苗族自治州",
"861822600", "安徽省宿州市",
"861452631", "江苏省盐城市",
"86187637", "山东省临沂市",
"861530417", "辽宁省营口市",
"861807265", "浙江省舟山市",
"861474318", "吉林省松原市",
"861584662", "黑龙江省哈尔滨市",
"861824891", "江苏省淮安市",
"861337246", "浙江省温州市",
"861397278", "湖北省黄石市",
"861328130", "四川省乐山市",
"861370765", "河南省新乡市",
"861560888", "云南省丽江市",
"861368781", "广西南宁市",
"861811209", "江苏省泰州市",
"861874035", "陕西省西安市",
"861308035", "山西省长治市",
"861882675", "广东省汕头市",
"861474134", "辽宁省沈阳市",
"861365715", "湖北省荆门市",
"86183460", "黑龙江省哈尔滨市",
"861379390", "山东省临沂市",
"861566427", "河南省南阳市",
"861308715", "内蒙古通辽市",
"861847405", "湖南省怀化市",
"861869004", "陕西省宝鸡市",
"861345365", "山西省临汾市",
"861365307", "广东省阳江市",
"861301489", "广西柳州市",
"861308307", "安徽省淮南市",
"861815269", "湖南省常德市",
"861479763", "青海省海东地区",
"861452445", "黑龙江省绥化市",
"861458215", "安徽省池州市",
"86152310", "河北省邯郸市",
"861323599", "福建省南平市",
"861899901", "新疆巴音郭楞蒙古自治州",
"86158302", "河北省保定市",
"861339807", "西藏阿里地区",
"861310403", "黑龙江省齐齐哈尔市",
"86155825", "山西省长治市",
"861815385", "湖南省郴州市",
"861847814", "湖南省常德市",
"861325043", "广东省云浮市",
"86189533", "山东省淄博市",
"861510911", "陕西省西安市",
"861780633", "山东省日照市",
"861593229", "河北省邢台市",
"861815079", "福建省福州市",
"861305937", "广东省肇庆市",
"861333144", "吉林省通化市",
"861821801", "广东省广州市",
"861387211", "湖北省黄石市",
"861368937", "甘肃省陇南市",
"861377497", "山东省菏泽市",
"861339092", "江苏省南京市",
"86182062", "江苏省苏州市",
"86170879", "江苏省泰州市",
"861592552", "云南省昭通市",
"861362376", "河南省信阳市",
"861801442", "江苏省连云港市",
"861515547", "安徽省宿州市",
"861803299", "河北省邢台市",
"861880959", "宁夏银川市",
"861363670", "陕西省西安市",
"861471749", "江西省赣州市",
"861597190", "湖北省十堰市",
"861840638", "山东省泰安市",
"8614732", "四川省成都市",
"86133913", "上海市",
"861323732", "湖南省湘潭市",
"861869360", "甘肃省张掖市",
"861827170", "湖北省武汉市",
"86156358", "山西省吕梁市",
"861804148", "辽宁省沈阳市",
"861475635", "河北省承德市",
"86150641", "山东省济南市",
"861845242", "江苏省常州市",
"861802390", "广东省潮州市",
"861807120", "湖北省黄冈市",
"86155000", "吉林省长春市",
"86185553", "安徽省芜湖市",
"861310072", "湖北省武汉市",
"86180131", "江苏省苏州市",
"861810345", "山西省长治市",
"86159278", "湖北省荆州市",
"861528957", "广西玉林市",
"861525240", "江苏省淮安市",
"861327065", "湖南省郴州市",
"861807575", "湖南省长沙市",
"861373300", "安徽省六安市",
"861869142", "陕西省商洛市",
"861368871", "云南省昆明市",
"861377873", "四川省遂宁市",
"861560778", "广西河池市",
"861818274", "黑龙江省哈尔滨市",
"861852402", "辽宁省辽阳市",
"86189917", "陕西省宝鸡市",
"861333897", "江苏省徐州市",
"861304058", "新疆塔城地区",
"861398649", "湖北省孝感市",
"861506342", "山东省莱芜市",
"861347343", "河北省石家庄市",
"861580828", "四川省凉山彝族自治州",
"861822611", "安徽省亳州市",
"861340646", "山东省潍坊市",
"861363857", "贵州省毕节地区",
"861304136", "吉林省长春市",
"861313058", "辽宁省营口市",
"861372209", "内蒙古锡林郭勒盟",
"861700767", "广东省茂名市",
"861329509", "福建省南平市",
"861533792", "宁夏银川市",
"861321942", "四川省内江市",
"861340249", "河北省石家庄市",
"861889169", "陕西省安康市",
"861306444", "河南省安阳市",
"86151292", "陕西省西安市",
"861338278", "江苏省南京市",
"861563663", "黑龙江省绥化市",
"861826298", "江苏省常州市",
"861518693", "贵州省黔东南苗族侗族自治州",
"861536649", "江苏省盐城市",
"861821989", "甘肃省陇南市",
"861881474", "黑龙江省佳木斯市",
"861333002", "江西省九江市",
"861595558", "安徽省阜阳市",
"861338068", "广东省惠州市",
"861501813", "广东省阳江市",
"86138972", "青海省西宁市",
"861898682", "湖北省宜昌市",
"861457208", "四川省绵阳市",
"861312397", "浙江省温州市",
"861576783", "广东省深圳市",
"861831811", "广东省江门市",
"861848418", "贵州省安顺市",
"861389935", "新疆哈密地区",
"861815651", "安徽省合肥市",
"86136987", "云南省昆明市",
"861825153", "江苏省宿迁市",
"861351381", "河南省焦作市",
"861510587", "浙江省温州市",
"861861327", "四川省资阳市",
"861334949", "黑龙江省大庆市",
"861559076", "吉林省辽源市",
"861533539", "山东省临沂市",
"861870725", "湖北省黄冈市",
"861339739", "湖南省邵阳市",
"861821810", "广东省韶关市",
"861470328", "河北省衡水市",
"861473570", "山西省临汾市",
"861852573", "辽宁省葫芦岛市",
"861582698", "湖北省黄石市",
"861857217", "湖北省武汉市",
"861387200", "湖北省黄冈市",
"861518945", "江苏省徐州市",
"861510900", "新疆乌鲁木齐市",
"861339019", "辽宁省本溪市",
"861812816", "广东省清远市",
"861820357", "山西省临汾市",
"861384745", "内蒙古通辽市",
"861580934", "甘肃省陇南市",
"86186660", "广东省广州市",
"861867831", "山东省滨州市",
"861365535", "山东省烟台市",
"861534427", "内蒙古巴彦淖尔市",
"861570642", "山东省青岛市",
"861319489", "四川省成都市",
"861367427", "辽宁省沈阳市",
"861325543", "山东省滨州市",
"861315229", "陕西省铜川市",
"861306876", "河北省石家庄市",
"861594937", "广西桂林市",
"861568150", "四川省资阳市",
"861572688", "浙江省温州市",
"861857481", "湖南省娄底市",
"861708199", "福建省漳州市",
"861323099", "河北省邢台市",
"86177572", "浙江省湖州市",
"861339592", "福建省南平市",
"861817996", "江西省赣州市",
"861533970", "甘肃省临夏回族自治州",
"861300741", "湖南省长沙市",
"86184870", "云南省红河哈尼族彝族自治州",
"861779952", "新疆阿克苏地区",
"861778037", "四川省阿坝藏族羌族自治州",
"861558618", "湖北省荆门市",
"861862413", "辽宁省抚顺市",
"86132066", "黑龙江省哈尔滨市",
"861369552", "安徽省蚌埠市",
"861881846", "广东省清远市",
"861363436", "吉林省白城市",
"861539348", "甘肃省酒泉市",
"86130741", "辽宁省大连市",
"861450241", "河北省邢台市",
"861770340", "山西省太原市",
"86156308", "河北省保定市",
"861538637", "湖南省益阳市",
"861771584", "江苏省扬州市",
"861535241", "甘肃省甘南藏族自治州",
"861819442", "甘肃省张掖市",
"86155050", "安徽省安庆市",
"861361984", "河南省郑州市",
"861315105", "江苏省南京市",
"861898908", "西藏拉萨市",
"861820628", "江苏省南通市",
"861708798", "江苏省淮安市",
"86151975", "湖南省郴州市",
"861329560", "安徽省合肥市",
"86158481", "内蒙古呼和浩特市",
"861343722", "湖北省荆州市",
"861800678", "浙江省杭州市",
"86772", "广西柳州市",
"861331829", "广东省中山市",
"861344783", "广西钦州市",
"861390665", "浙江省温州市",
"861809070", "四川省阿坝藏族羌族自治州",
"861348389", "河北省承德市",
"861356823", "四川省德阳市",
"861533409", "湖北省孝感市",
"861786521", "山东省济宁市",
"861530707", "江西省赣州市",
"861533761", "浙江省杭州市",
"861893962", "河南省周口市",
"861355546", "黑龙江省鸡西市",
"86189823", "四川省攀枝花市",
"861361465", "黑龙江省大庆市",
"861802141", "江苏省南京市",
"861370864", "云南省大理白族自治州",
"86155535", "山东省烟台市",
"861818285", "黑龙江省绥化市",
"861339056", "辽宁省沈阳市",
"861807584", "湖南省湘西土家族苗族自治州",
"861302066", "山东省临沂市",
"86155989", "内蒙古兴安盟",
"861532474", "河南省郑州市",
"861803763", "河南省周口市",
"861506418", "山东省泰安市",
"86137814", "河南省商丘市",
"86181314", "河北省承德市",
"861300955", "内蒙古包头市",
"861588554", "贵州省贵阳市",
"861832045", "广东省惠州市",
"861818369", "云南省德宏傣族景颇族自治州",
"861373285", "吉林省通化市",
"861332372", "河南省安阳市",
"861530315", "河北省唐山市",
"861811570", "江苏省淮安市",
"861871495", "安徽省黄山市",
"861302276", "山东省莱芜市",
"861595782", "浙江省丽水市",
"861569706", "云南省昆明市",
"861760546", "山东省东营市",
"861863399", "河北省唐山市",
"861587991", "江西省鹰潭市",
"861558891", "山东省临沂市",
"861878872", "贵州省黔东南苗族侗族自治州",
"861379141", "山东省枣庄市",
"861510479", "内蒙古锡林郭勒盟",
"861350798", "江西省景德镇市",
"861769926", "新疆伊犁哈萨克自治州",
"861329439", "吉林省白山市",
"861766081", "山东省德州市",
"861893503", "山西省忻州市",
"861322629", "广东省茂名市",
"861830854", "贵州省黔南布依族苗族自治州",
"86135736", "山东省潍坊市",
"861384951", "河南省焦作市",
"861372070", "陕西省咸阳市",
"861452776", "广西百色市",
"86138295", "广东省汕头市",
"861558258", "山西省晋城市",
"8618092", "陕西省西安市",
"86185540", "山东省烟台市",
"861855853", "福建省三明市",
"861816619", "湖南省长沙市",
"861360057", "浙江省台州市",
"861859393", "广西桂林市",
"861310858", "云南省昭通市",
"861577981", "江西省景德镇市",
"86183802", "四川省成都市",
"861889768", "广西钦州市",
"86150670", "浙江省金华市",
"86159505", "江苏省南京市",
"861301077", "湖北省武汉市",
"861811939", "甘肃省陇南市",
"861353631", "广东省惠州市",
"861700644", "四川省成都市",
"861353950", "广东省清远市",
"861392459", "广东省深圳市",
"861372125", "安徽省宿州市",
"86182425", "辽宁省丹东市",
"861895114", "江苏省泰州市",
"861356541", "新疆乌鲁木齐市",
"86139727", "湖北省黄冈市",
"86147431", "吉林省长春市",
"861319577", "青海省西宁市",
"861380363", "黑龙江省齐齐哈尔市",
"861581610", "广东省湛江市",
"861520537", "山东省济宁市",
"861534242", "湖北省黄冈市",
"861822898", "四川省泸州市",
"861363506", "广西梧州市",
"861510969", "宁夏固原市",
"861454638", "宁夏中卫市",
"861532846", "四川省宜宾市",
"861470780", "广西柳州市",
"861311694", "云南省丽江市",
"861361975", "青海省果洛藏族自治州",
"86150759", "河北省邢台市",
"861529073", "河南省漯河市",
"861310713", "湖南省湘西土家族苗族自治州",
"86177731", "湖南省长沙市",
"861339314", "河北省承德市",
"861513346", "河北省唐山市",
"861458428", "河南省新乡市",
"861310033", "湖南省株洲市",
"861890458", "黑龙江省伊春市",
"86139706", "江西省吉安市",
"861458381", "福建省漳州市",
"861532964", "贵州省黔南布依族苗族自治州",
"861509023", "河南省濮阳市",
"861771575", "四川省成都市",
"861308814", "四川省达州市",
"861376809", "广西北海市",
"86189752", "湖南省湘潭市",
"861365814", "四川省眉山市",
"861539412", "陕西省榆林市",
"861301267", "山东省枣庄市",
"861831698", "广东省广州市",
"861521249", "安徽省六安市",
"861339561", "安徽省淮北市",
"861869434", "甘肃省兰州市",
"861572902", "河南省三门峡市",
"861815487", "新疆博尔塔拉蒙古自治州",
"86187855", "贵州省黔东南苗族侗族自治州",
"861521646", "山东省潍坊市",
"861599195", "陕西省安康市",
"86130609", "广东省广州市",
"861308405", "安徽省淮北市",
"861512640", "云南省红河哈尼族彝族自治州",
"861893472", "广西南宁市",
"861452347", "河南省焦作市",
"861300440", "江苏省常州市",
"861452886", "云南省怒江傈僳族自治州",
"861394983", "河南省许昌市",
"861809570", "青海省海北藏族自治州",
"861780672", "广东省珠海市",
"861453223", "浙江省绍兴市",
"861829520", "宁夏银川市",
"861355046", "四川省巴中市",
"861820940", "甘肃省临夏回族自治州",
"861856863", "河南省新乡市",
"861828905", "西藏昌都地区",
"861454282", "辽宁省大连市",
"861848708", "云南省昆明市",
"861831869", "广东省清远市",
"86150884", "浙江省宁波市",
"861843490", "山西省运城市",
"861329060", "河北省邯郸市",
"86156584", "浙江省宁波市",
"861500164", "新疆石河子市",
"861476885", "山东省滨州市",
"861533334", "河北省秦皇岛市",
"861323773", "广西桂林市",
"861705684", "福建省厦门市",
"861832545", "山东省烟台市",
"861313782", "河南省开封市",
"861386157", "江苏省淮安市",
"861811070", "安徽省宿州市",
"861530839", "四川省资阳市",
"861318329", "河南省商丘市",
"861557823", "广西柳州市",
"86188811", "四川省绵阳市",
"861585661", "安徽省池州市",
"861304782", "广西柳州市",
"861314723", "湖北省黄石市",
"861339556", "安徽省安庆市",
"861513887", "河南省安阳市",
"861700830", "江苏省南通市",
"861302566", "广东省茂名市",
"86150175", "广东省广州市",
"861368480", "江西省赣州市",
"861378749", "湖南省邵阳市",
"861571478", "内蒙古巴彦淖尔市",
"861804749", "内蒙古呼和浩特市",
"86155636", "山东省临沂市",
"861880916", "陕西省汉中市",
"861837908", "江西省宜春市",
"861305480", "山东省莱芜市",
"861885127", "江苏省镇江市",
"861852712", "湖北省荆州市",
"86157523", "云南省西双版纳傣族自治州",
"861839843", "四川省遂宁市",
"861822669", "安徽省宣城市",
"861813749", "河南省许昌市",
"861824862", "浙江省绍兴市",
"861810447", "吉林省吉林市",
"861580204", "广东省广州市",
"86185732", "湖南省湘潭市",
"861360557", "安徽省宿州市",
"86183723", "湖北省宜昌市",
"861593105", "河北省石家庄市",
"861509841", "山东省聊城市",
"861519159", "陕西省商洛市",
"861317904", "吉林省长春市",
"861330597", "福建省泉州市",
"861575908", "福建省三明市",
"861538341", "山西省太原市",
"861583528", "山西省运城市",
"861580370", "河南省商丘市",
"861529402", "甘肃省张掖市",
"861775205", "甘肃省平凉市",
"861770957", "宁夏吴忠市",
"861348575", "安徽省滁州市",
"861559611", "陕西省榆林市",
"861539499", "云南省文山壮族苗族自治州",
"86159627", "江苏省南通市",
"861453454", "安徽省合肥市",
"861586666", "山东省滨州市",
"861586385", "山东省临沂市",
"86183852", "贵州省遵义市",
"861339271", "广东省东莞市",
"861709490", "浙江省宁波市",
"861569459", "黑龙江省大庆市",
"861870938", "甘肃省天水市",
"861335378", "河南省开封市",
"861571968", "甘肃省天水市",
"861320812", "四川省南充市",
"861860147", "江苏省无锡市",
"861452183", "吉林省吉林市",
"861350586", "浙江省台州市",
"861880323", "河北省张家口市",
"86130770", "湖南省株洲市",
"861318180", "山东省泰安市",
"861319077", "内蒙古呼伦贝尔市",
"861809939", "新疆阿克苏地区",
"86155380", "河南省郑州市",
"86187020", "广东省广州市",
"861572063", "江苏省常州市",
"86135142", "辽宁省沈阳市",
"861887229", "湖北省荆州市",
"861500943", "甘肃省白银市",
"861533756", "福建省漳州市",
"861835809", "浙江省舟山市",
"861899593", "湖北省十堰市",
"861534325", "湖南省怀化市",
"86189702", "江西省九江市",
"861384844", "内蒙古乌兰察布市",
"86150709", "江西省南昌市",
"861572273", "江苏省宿迁市",
"861533118", "辽宁省沈阳市",
"861707397", "河南省信阳市",
"861855538", "安徽省六安市",
"861319267", "广东省佛山市",
"861470870", "云南省昭通市",
"861820455", "黑龙江省绥化市",
"861310533", "山东省淄博市",
"86139756", "湖南省常德市",
"861529198", "陕西省西安市",
"86130659", "浙江省金华市",
"861332155", "吉林省四平市",
"861375986", "陕西省咸阳市",
"86133827", "江苏省扬州市",
"861886547", "山东省济宁市",
"861857870", "广东省汕尾市",
"86159606", "福建省漳州市",
"861309165", "黑龙江省佳木斯市",
"861390847", "湖南省长沙市",
"861839521", "宁夏银川市",
"861830941", "甘肃省甘南藏族自治州",
"861892332", "广东省中山市",
"861590742", "湖南省湘西土家族苗族自治州",
"861302051", "山东省菏泽市",
"861576832", "广东省惠州市",
"861839146", "陕西省汉中市",
"861899178", "陕西省延安市",
"861345831", "四川省绵阳市",
"861847535", "广东省汕尾市",
"861591297", "云南省普洱市",
"861367325", "河北省唐山市",
"86187805", "四川省绵阳市",
"861524784", "内蒙古巴彦淖尔市",
"861870777", "广西钦州市",
"861361042", "广东省惠州市",
"861814536", "黑龙江省鹤岗市",
"861839914", "新疆和田地区",
"861861375", "河南省平顶山市",
"861592909", "陕西省安康市",
"861832462", "黑龙江省伊春市",
"861318479", "河北省唐山市",
"861351820", "四川省成都市",
"861596315", "山东省泰安市",
"861872815", "四川省雅安市",
"861862750", "湖南省岳阳市",
"861350891", "山东省威海市",
"861317175", "河北省邢台市",
"861350258", "广东省汕尾市",
"861319918", "黑龙江省鸡西市",
"861770583", "浙江省嘉兴市",
"861880502", "福建省福州市",
"861479759", "青海省海西蒙古族藏族自治州",
"861539206", "福建省南平市",
"861872404", "江苏省无锡市",
"861569932", "新疆石河子市",
"861518858", "河南省信阳市",
"861310751", "青海省海东地区",
"861367965", "四川省眉山市",
"861700008", "上海市",
"861881529", "浙江省宁波市",
"861826582", "山东省菏泽市",
"861309404", "新疆石河子市",
"861582038", "广东省肇庆市",
"861778130", "四川省阿坝藏族羌族自治州",
"861338707", "江西省赣州市",
"86139126", "江苏省苏州市",
"861374124", "广东省广州市",
"861868435", "吉林省通化市",
"861877995", "江西省吉安市",
"861509302", "河南省南阳市",
"861533868", "贵州省毕节地区",
"861394557", "黑龙江省七台河市",
"861580420", "辽宁省辽阳市",
"861865124", "江苏省宿迁市",
"861598386", "四川省达州市",
"861879513", "宁夏吴忠市",
"861880963", "宁夏吴忠市",
"861450995", "新疆吐鲁番地区",
"861571481", "内蒙古呼和浩特市",
"861535995", "福建省南平市",
"861571328", "河北省衡水市",
"861389043", "四川省宜宾市",
"861309815", "陕西省宝鸡市",
"861867139", "湖北省黄石市",
"861471642", "广东省广州市",
"86151929", "山东省临沂市",
"861338315", "河北省唐山市",
"861323639", "江苏省镇江市",
"861508955", "广东省茂名市",
"861380554", "安徽省淮南市",
"861527049", "江西省吉安市",
"86147047", "广东省广州市",
"86182576", "浙江省台州市",
"861859827", "广东省深圳市",
"86139520", "江苏省南京市",
"861775043", "福建省厦门市",
"861363999", "新疆巴音郭楞蒙古自治州",
"861880473", "内蒙古乌海市",
"861707041", "浙江省湖州市",
"861335428", "辽宁省大连市",
"86155692", "新疆伊犁哈萨克自治州",
"861335381", "河南省开封市",
"861550644", "山东省聊城市",
"861503319", "河北省邢台市",
"861384913", "河南省开封市",
"861808237", "江苏省连云港市",
"861870346", "山西省太原市",
"861865237", "江苏省泰州市",
"861500814", "四川省自贡市",
"861333959", "黑龙江省大庆市",
"86170043", "吉林省长春市",
"861535643", "浙江省湖州市",
"861818135", "四川省成都市",
"861843600", "河南省周口市",
"86189818", "四川省成都市",
"861898879", "广东省深圳市",
"861815424", "安徽省池州市",
"861862687", "浙江省杭州市",
"861345518", "山东省德州市",
"861450643", "黑龙江省大庆市",
"861840876", "云南省文山壮族苗族自治州",
"86188886", "浙江省宁波市",
"861452591", "福建省福州市",
"861359993", "福建省泉州市",
"861575789", "浙江省嘉兴市",
"861528899", "山东省潍坊市",
"86184389", "河南省南阳市",
"861373135", "河北省衡水市",
"861507638", "河北省保定市",
"861303048", "内蒙古包头市",
"861529692", "宁夏石嘴山市",
"861889861", "广东省深圳市",
"86135843", "江苏省常州市",
"861773732", "河南省濮阳市",
"861367475", "内蒙古呼和浩特市",
"861314048", "河南省洛阳市",
"861890986", "辽宁省大连市",
"86152398", "河南省三门峡市",
"861317020", "安徽省淮南市",
"86183153", "安徽省芜湖市",
"861584769", "内蒙古包头市",
"861328537", "山东省济宁市",
"861822791", "四川省资阳市",
"86182479", "内蒙古锡林郭勒盟",
"86130588", "浙江省台州市",
"861537847", "四川省乐山市",
"86158240", "浙江省台州市",
"861337742", "广西来宾市",
"861800355", "山西省长治市",
"861533612", "陕西省渭南市",
"86186773", "广西桂林市",
"86186701", "江西省鹰潭市",
"861570749", "湖南省长沙市",
"861560480", "黑龙江省哈尔滨市",
"861302733", "湖南省株洲市",
"861332422", "辽宁省鞍山市",
"861537665", "山东省枣庄市",
"861530683", "浙江省嘉兴市",
"861889856", "广东省深圳市",
"861814036", "四川省绵阳市",
"861361542", "山东省青岛市",
"86178794", "江西省南昌市",
"861339632", "山东省枣庄市",
"86170861", "山东省青岛市",
"861301918", "吉林省延边朝鲜族自治州",
"861509748", "河北省石家庄市",
"861800681", "浙江省杭州市",
"861816073", "江西省上饶市",
"861393140", "河北省承德市",
"861700508", "福建省厦门市",
"861550830", "四川省泸州市",
"86139157", "江苏省苏州市",
"861334154", "吉林省吉林市",
"861452233", "浙江省湖州市",
"861330341", "山西省太原市",
"861308695", "贵州省黔东南苗族侗族自治州",
"86147915", "陕西省安康市",
"861874695", "黑龙江省绥化市",
"86150129", "广东省深圳市",
"861528668", "贵州省六盘水市",
"861315974", "吉林省长春市",
"861365695", "福建省宁德市",
"861396597", "安徽省滁州市",
"861370338", "河北省唐山市",
"861308164", "山东省烟台市",
"861582538", "宁夏银川市",
"86189122", "江苏省南通市",
"861335655", "广东省江门市",
"861311815", "四川省广元市",
"861831408", "云南省临沧市",
"861506067", "福建省福州市",
"861338839", "四川省宜宾市",
"861863840", "河南省商丘市",
"861380923", "广东省珠海市",
"861705627", "河北省石家庄市",
"861870887", "云南省迪庆藏族自治州",
"861380054", "山东省滨州市",
"861527549", "山东省临沂市",
"861511302", "广东省佛山市",
"861895946", "福建省龙岩市",
"861517223", "湖北省孝感市",
"861835978", "福建省福州市",
"861888252", "四川省成都市",
"861894894", "广东省清远市",
"861766078", "山东省东营市",
"861853022", "河南省新乡市",
"861309339", "安徽省阜阳市",
"861389543", "宁夏吴忠市",
"861807027", "江西省赣州市",
"861510329", "河北省邢台市",
"861337308", "河北省衡水市",
"861572516", "山东省莱芜市",
"861380316", "河北省廊坊市",
"86158416", "辽宁省锦州市",
"861591757", "广东省湛江市",
"86130577", "浙江省温州市",
"861308943", "吉林省延边朝鲜族自治州",
"861529619", "广西玉林市",
"861518533", "贵州省遵义市",
"861454132", "河北省保定市",
"861559762", "青海省玉树藏族自治州",
"861707541", "福建省厦门市",
"861776826", "江苏省徐州市",
"861357735", "云南省曲靖市",
"86159488", "吉林省松原市",
"861452091", "安徽省淮北市",
"861801284", "江苏省镇江市",
"86153027", "广东省深圳市",
"861823248", "河北省廊坊市",
"861459654", "青海省海南藏族自治州",
"86135792", "新疆乌鲁木齐市",
"861315464", "四川省自贡市",
"861829904", "新疆吐鲁番地区",
"86145409", "上海市",
"861577468", "黑龙江省鹤岗市",
"861533296", "内蒙古赤峰市",
"861563659", "黑龙江省七台河市",
"861345018", "广东省肇庆市",
"861889153", "陕西省渭南市",
"86185466", "黑龙江省大庆市",
"861894383", "吉林省吉林市",
"861389821", "辽宁省营口市",
"861314548", "山东省莱芜市",
"861898789", "云南省昆明市",
"861317520", "浙江省湖州市",
"861860615", "江苏省南通市",
"861896941", "浙江省宁波市",
"861536742", "湖南省长沙市",
"86157518", "江苏省南京市",
"86185569", "江苏省苏州市",
"861893322", "广东省广州市",
"861303548", "安徽省铜陵市",
"861363912", "贵州省贵阳市",
"86134667", "北京市",
"861320340", "山西省忻州市",
"861589240", "四川省达州市",
"861328305", "河南省平顶山市",
"86158519", "江苏省常州市",
"861837879", "广西玉林市",
"86182675", "浙江省绍兴市",
"861893550", "青海省海北藏族自治州",
"861341130", "广东省阳江市",
"861834544", "黑龙江省大庆市",
"86151320", "河北省邯郸市",
"861866044", "山东省淄博市",
"861843611", "河南省商丘市",
"86183718", "湖北省恩施土家族苗族自治州",
"861763529", "山西省运城市",
"861329952", "宁夏石嘴山市",
"86150420", "辽宁省铁岭市",
"861375458", "河北省衡水市",
"861786914", "云南省红河哈尼族彝族自治州",
"861871605", "河北省唐山市",
"861347080", "安徽省阜阳市",
"861889437", "甘肃省天水市",
"86183171", "上海市",
"861510180", "甘肃省定西市",
"861477822", "广东省湛江市",
"861868337", "四川省成都市",
"861505103", "江苏省宿迁市",
"861526442", "山东省潍坊市",
"861577101", "湖北省武汉市",
"861345139", "内蒙古兴安盟",
"861530568", "安徽省阜阳市",
"861506801", "浙江省舟山市",
"861311534", "黑龙江省佳木斯市",
"861367746", "湖南省常德市",
"861862976", "吉林省白山市",
"86186649", "广东省深圳市",
"861338417", "辽宁省营口市",
"861369960", "四川省绵阳市",
"861858784", "广西柳州市",
"861836803", "浙江省杭州市",
"86182141", "云南省玉溪市",
"861868005", "广东省东莞市",
"86737", "湖南省益阳市",
"861572559", "山东省聊城市",
"861342186", "广东省汕头市",
"861380359", "江西省上饶市",
"861529259", "新疆昌吉回族自治州",
"861534746", "广东省惠州市",
"861594778", "内蒙古通辽市",
"861302990", "黑龙江省大庆市",
"861869648", "湖北省武汉市",
"861510953", "宁夏吴忠市",
"861309714", "江西省吉安市",
"861560781", "广西南宁市",
"861780910", "陕西省西安市",
"861835101", "江苏省泰州市",
"861571870", "云南省西双版纳傣族自治州",
"861368888", "广东省广州市",
"861319170", "河北省邯郸市",
"86183645", "山东省烟台市",
"861844995", "新疆伊犁哈萨克自治州",
"861347124", "广西柳州市",
"861351378", "河南省开封市",
"861453621", "江苏省盐城市",
"861554443", "河南省商丘市",
"861353591", "广东省茂名市",
"861470968", "宁夏银川市",
"861700438", "江苏省苏州市",
"861884674", "黑龙江省鸡西市",
"861596417", "山东省德州市",
"861576607", "广东省肇庆市",
"861861477", "内蒙古鄂尔多斯市",
"861871541", "安徽省安庆市",
"861454173", "浙江省嘉兴市",
"861881324", "广东省中山市",
"861808907", "西藏阿里地区",
"861454444", "江西省抚州市",
"861357640", "江西省景德镇市",
"86133928", "广东省深圳市",
"861354628", "山西省吕梁市",
"861890677", "浙江省温州市",
"861889980", "广东省珠海市",
"86153630", "广东省佛山市",
"861772226", "广东省广州市",
"86139593", "福建省宁德市",
"861882358", "广东省东莞市",
"861315985", "黑龙江省哈尔滨市",
"86134551", "山东省济南市",
"861560937", "甘肃省酒泉市",
"861367377", "河南省南阳市",
"861841905", "甘肃省临夏回族自治州",
"861836106", "江苏省盐城市",
"861889507", "宁夏银川市",
"861572671", "西藏拉萨市",
"861857478", "湖南省长沙市",
"861572182", "云南省曲靖市",
"861509149", "陕西省榆林市",
"861323906", "新疆巴音郭楞蒙古自治州",
"86137697", "云南省曲靖市",
"86170825", "江苏省南通市",
"861382486", "广东省茂名市",
"861803759", "河南省平顶山市",
"861800457", "黑龙江省大兴安岭地区",
"861811177", "四川省广元市",
"86135800", "广东省茂名市",
"861559791", "贵州省铜仁地区",
"861818353", "云南省迪庆藏族自治州",
"861534377", "河南省南阳市",
"861889819", "河南省南阳市",
"861782005", "广东省河源市",
"861569202", "广东省广州市",
"861369470", "内蒙古呼伦贝尔市",
"861593330", "河北省邯郸市",
"861322722", "湖北省随州市",
"861319025", "辽宁省朝阳市",
"86151174", "贵州省六盘水市",
"861770899", "西藏拉萨市",
"86155879", "湖北省宜昌市",
"861867518", "广东省佛山市",
"861888612", "贵州省贵阳市",
"861787620", "广东省河源市",
"86181619", "陕西省西安市",
"861824086", "陕西省汉中市",
"861339673", "浙江省嘉兴市",
"861371997", "广东省梅州市",
"861502877", "河北省衡水市",
"861539936", "陕西省安康市",
"861819565", "青海省玉树藏族自治州",
"861301525", "内蒙古包头市",
"86184059", "福建省漳州市",
"861452272", "山西省晋中市",
"861709898", "广东省深圳市",
"861500307", "新疆喀什地区",
"861809496", "新疆喀什地区",
"861335215", "辽宁省本溪市",
"861705358", "广东省深圳市",
"861331046", "贵州省铜仁地区",
"861386245", "江苏省镇江市",
"861816032", "新疆喀什地区",
"861871823", "广东省揭阳市",
"861328280", "浙江省杭州市",
"86131991", "黑龙江省佳木斯市",
"861454876", "四川省泸州市",
"861855869", "福建省泉州市",
"861862466", "辽宁省阜新市",
"861518403", "辽宁省大连市",
"861347237", "河北省张家口市",
"86132731", "河北省石家庄市",
"861320191", "陕西省咸阳市",
"86150493", "内蒙古包头市",
"861585573", "安徽省宿州市",
"861502931", "陕西省延安市",
"861311714", "湖北省恩施土家族苗族自治州",
"861310693", "广东省揭阳市",
"861310450", "黑龙江省哈尔滨市",
"861301170", "山东省济南市",
"861709669", "浙江省杭州市",
"861312541", "辽宁省沈阳市",
"861317184", "河北省唐山市",
"86151393", "河南省濮阳市",
"861773773", "河南省洛阳市",
"861569463", "云南省临沧市",
"861826116", "江苏省常州市",
"861779060", "黑龙江省齐齐哈尔市",
"861869920", "新疆伊犁哈萨克自治州",
"861518262", "四川省自贡市",
"86186445", "上海市",
"861894795", "内蒙古呼和浩特市",
"861510524", "江苏省宿迁市",
"861553469", "山西省长治市",
"861847695", "广东省中山市",
"861592960", "陕西省宝鸡市",
"86183449", "福建省福州市",
"86130663", "广东省广州市",
"861504725", "内蒙古赤峰市",
"861864803", "内蒙古鄂尔多斯市",
"86145837", "山东省济南市",
"861333916", "安徽省池州市",
"861350862", "湖北省荆州市",
"861847164", "湖北省襄樊市",
"861837188", "湖北省随州市",
"861860540", "山东省菏泽市",
"861770668", "浙江省宁波市",
"861566746", "陕西省汉中市",
"861572059", "安徽省黄山市",
"861832491", "安徽省宿州市",
"861528083", "福建省龙岩市",
"861320957", "宁夏中卫市",
"861533252", "陕西省汉中市",
"861577110", "湖北省襄樊市",
"861519866", "云南省丽江市",
"861381511", "江苏省无锡市",
"86187642", "山东省青岛市",
"861880432", "吉林省吉林市",
"861459371", "贵州省铜仁地区",
"861518072", "贵州省贵阳市",
"861556640", "辽宁省大连市",
"861785849", "浙江省金华市",
"861368778", "广西河池市",
"861571780", "湖北省鄂州市",
"861325728", "湖北省武汉市",
"861532529", "浙江省嘉兴市",
"861560871", "云南省昆明市",
"861397281", "湖北省咸宁市",
"86183546", "山东省东营市",
"86156430", "吉林省长春市",
"86134573", "广西桂林市",
"861381364", "江苏省南通市",
"861580721", "湖北省荆州市",
"861590649", "浙江省温州市",
"861803406", "河北省廊坊市",
"861590246", "辽宁省辽阳市",
"861553530", "山西省阳泉市",
"861835110", "江苏省苏州市",
"861479716", "山西省太原市",
"86157797", "江西省赣州市",
"861321389", "河南省信阳市",
"861888296", "四川省甘孜藏族自治州",
"861479036", "安徽省合肥市",
"861328407", "黑龙江省佳木斯市",
"861359730", "广西桂林市",
"861584531", "黑龙江省牡丹江市",
"861843266", "河北省廊坊市",
"861300848", "陕西省宝鸡市",
"86183140", "云南省红河哈尼族彝族自治州",
"861892254", "广东省东莞市",
"861454786", "山东省潍坊市",
"861479158", "陕西省西安市",
"861831853", "广东省韶关市",
"861321265", "湖南省怀化市",
"861452562", "贵州省遵义市",
"861865080", "福建省厦门市",
"861780779", "广西北海市",
"861350618", "江苏省无锡市",
"86135850", "江苏省无锡市",
"861501851", "广东省深圳市",
"86176607", "山东省潍坊市",
"861330637", "山东省枣庄市",
"861760829", "四川省成都市",
"861315330", "山东省威海市",
"861313286", "广西百色市",
"861889335", "甘肃省陇南市",
"861386550", "安徽省滁州市",
"861361927", "陕西省宝鸡市",
"861890850", "贵州省贵阳市",
"861313689", "黑龙江省牡丹江市",
"86180315", "河北省唐山市",
"861514734", "内蒙古赤峰市",
"861310945", "甘肃省金昌市",
"861587245", "湖北省宜昌市",
"861813642", "江苏省苏州市",
"861392202", "广东省阳江市",
"861553979", "河南省平顶山市",
"861812151", "江苏省无锡市",
"861804642", "福建省厦门市",
"861811496", "江苏省宿迁市",
"861333323", "河北省张家口市",
"861802849", "广东省惠州市",
"86152631", "山东省威海市",
"861319525", "贵州省黔东南苗族侗族自治州",
"861873900", "河南省南阳市",
"861584700", "内蒙古呼伦贝尔市",
"861500535", "山东省烟台市",
"86156139", "河北省邢台市",
"861822653", "安徽省芜湖市",
"861529661", "山西省太原市",
"861571657", "河南省信阳市",
"86170050", "福建省福州市",
"861355829", "广西北海市",
"86150974", "河北省保定市",
"861369636", "山东省潍坊市",
"861321075", "山东省潍坊市",
"861360150", "江苏省常州市",
"861393391", "河北省秦皇岛市",
"861331546", "河北省石家庄市",
"861846440", "山东省聊城市",
"861362426", "辽宁省大连市",
"861707873", "云南省红河哈尼族彝族自治州",
"861816954", "宁夏固原市",
"86139152", "江苏省无锡市",
"861564698", "新疆吐鲁番地区",
"861525557", "安徽省宿州市",
"861816023", "新疆吐鲁番地区",
"861869756", "安徽省宿州市",
"861871832", "广东省肇庆市",
"861348489", "陕西省汉中市",
"861534658", "河南省郑州市",
"86973", "青海省黄南藏族自治州",
"861839796", "江西省吉安市",
"861390486", "黑龙江省大庆市",
"86188783", "广西桂林市",
"861801109", "四川省凉山彝族自治州",
"861316563", "湖北省十堰市",
"861533309", "山西省运城市",
"861362745", "湖南省怀化市",
"86155545", "山东省菏泽市",
"861361686", "浙江省台州市",
"861858208", "四川省雅安市",
"861336958", "宁夏银川市",
"86159071", "湖北省武汉市",
"861370767", "河南省濮阳市",
"861823036", "河北省承德市",
"86159003", "天津市",
"861556101", "内蒙古呼和浩特市",
"861517063", "江西省赣州市",
"861373469", "青海省海西蒙古族藏族自治州",
"861858725", "云南省昆明市",
"861774058", "湖北省襄樊市",
"861570862", "贵州省遵义市",
"861818701", "云南省昆明市",
"861853262", "河北省张家口市",
"861321918", "四川省达州市",
"861597441", "湖南省张家界市",
"861530415", "辽宁省丹东市",
"861807267", "浙江省丽水市",
"861332472", "广西柳州市",
"861337698", "福建省厦门市",
"861517273", "湖北省咸宁市",
"861589150", "陕西省咸阳市",
"861705677", "云南省昆明市",
"861860797", "江西省赣州市",
"861507549", "河北省承德市",
"86181970", "青海省西宁市",
"861580636", "山东省潍坊市",
"861527282", "湖北省孝感市",
"861327567", "安徽省亳州市",
"861380973", "广东省湛江市",
"861376640", "江西省宜春市",
"861807077", "广西钦州市",
"861830757", "广东省佛山市",
"861510379", "河南省洛阳市",
"861317939", "江苏省镇江市",
"861351780", "广西柳州市",
"861573091", "甘肃省甘南藏族自治州",
"861853072", "河南省新乡市",
"861766028", "山东省淄博市",
"861328695", "广东省湛江市",
"861315924", "福建省三明市",
"861583081", "河北省沧州市",
"86135746", "湖南省永州市",
"861315053", "云南省曲靖市",
"86156621", "吉林省吉林市",
"86185530", "山东省菏泽市",
"86152129", "安徽省安庆市",
"861881385", "广东省惠州市",
"861859931", "新疆塔城地区",
"861859650", "福建省泉州市",
"86189127", "江苏省苏州市",
"861306049", "陕西省宝鸡市",
"861821284", "贵州省六盘水市",
"86155033", "河北省唐山市",
"861579730", "湖北省宜昌市",
"86153022", "广东省广州市",
"861809904", "新疆石河子市",
"861567244", "湖北省黄冈市",
"861515545", "安徽省宿州市",
"861554080", "内蒙古巴彦淖尔市",
"861392359", "广东省汕尾市",
"86184565", "安徽省合肥市",
"861555106", "安徽省马鞍山市",
"861305935", "广东省肇庆市",
"861368935", "甘肃省武威市",
"861377495", "山东省德州市",
"861814248", "陕西省西安市",
"861570618", "江苏省无锡市",
"861332503", "山东省东营市",
"86130572", "江苏省无锡市",
"861810886", "云南省德宏傣族景颇族自治州",
"861475637", "河北省秦皇岛市",
"86132577", "广西南宁市",
"861328943", "陕西省宝鸡市",
"861707176", "江西省鹰潭市",
"861380463", "黑龙江省哈尔滨市",
"861776876", "江苏省镇江市",
"861561608", "湖南省张家界市",
"86145948", "陕西省西安市",
"861471798", "山西省忻州市",
"861876478", "山东省济宁市",
"861508812", "广东省江门市",
"86180675", "浙江省宁波市",
"861847407", "湖南省怀化市",
"86189500", "福建省厦门市",
"861890358", "山西省吕梁市",
"861458481", "山东省青岛市",
"861345367", "山西省临汾市",
"861458328", "江西省吉安市",
"861805169", "江苏省盐城市",
"861339414", "辽宁省本溪市",
"861308037", "山西省临汾市",
"86147924", "安徽省阜阳市",
"861882677", "广东省汕头市",
"861558642", "湖北省恩施土家族苗族自治州",
"861850833", "四川省乐山市",
"86152420", "辽宁省沈阳市",
"861874037", "陕西省宝鸡市",
"861365717", "湖北省宜昌市",
"861309952", "宁夏石嘴山市",
"861369721", "湖北省襄樊市",
"861516070", "福建省厦门市",
"861770741", "湖南省长沙市",
"861308717", "内蒙古通辽市",
"861332962", "贵州省遵义市",
"861315838", "贵州省六盘水市",
"861319084", "内蒙古鄂尔多斯市",
"861566425", "河南省南阳市",
"861317570", "浙江省衢州市",
"861477833", "广东省惠州市",
"861339805", "西藏昌都地区",
"861389871", "辽宁省盘锦市",
"861888142", "四川省内江市",
"861777160", "湖北省武汉市",
"861399753", "湖北省咸宁市",
"861762504", "江苏省宿迁市",
"861815387", "湖南省郴州市",
"861536869", "云南省德宏傣族景颇族自治州",
"861323548", "湖北省孝感市",
"861365305", "广东省茂名市",
"86151768", "河北省石家庄市",
"861524938", "甘肃省天水市",
"861340944", "河南省商丘市",
"861300340", "江苏省南京市",
"861308305", "安徽省合肥市",
"861893372", "广东省韶关市",
"861458217", "安徽省池州市",
"861452447", "黑龙江省牡丹江市",
"861323494", "黑龙江省齐齐哈尔市",
"861860483", "内蒙古阿拉善盟",
"861566658", "山东省烟台市",
"86189156", "江苏省苏州市",
"861537958", "宁夏中卫市",
"8618883", "重庆市",
"861316063", "广东省潮州市",
"861826646", "山东省潍坊市",
"861814994", "新疆昌吉回族自治州",
"861300162", "山东省烟台市",
"861863412", "河北省邯郸市",
"861803994", "河南省商丘市",
"861815846", "浙江省宁波市",
"861826249", "江苏省盐城市",
"861861325", "四川省巴中市",
"861533434", "云南省德宏傣族景颇族自治州",
"86755", "广东省深圳市",
"861870727", "湖北省襄樊市",
"861880254", "广东省茂名市",
"861389937", "新疆塔城地区",
"861322513", "江苏省南通市",
"861379213", "山东省泰安市",
"861318429", "浙江省温州市",
"861364958", "宁夏中卫市",
"861517563", "河北省唐山市",
"861776098", "四川省自贡市",
"861510585", "浙江省绍兴市",
"861471586", "广东省江门市",
"861807577", "湖南省永州市",
"861571378", "河南省开封市",
"861368380", "河南省郑州市",
"861335968", "黑龙江省牡丹江市",
"86136721", "天津市",
"861886610", "山东省济南市",
"861810347", "山西省临汾市",
"861376928", "云南省楚雄彝族自治州",
"861528955", "广西南宁市",
"861363855", "贵州省黔东南苗族侗族自治州",
"861815964", "福建省三明市",
"861700765", "广东省茂名市",
"861340298", "陕西省西安市",
"861556110", "内蒙古呼和浩特市",
"861775781", "浙江省丽水市",
"861453736", "湖南省怀化市",
"861373030", "河北省张家口市",
"861818030", "四川省泸州市",
"861865174", "江苏省盐城市",
"861580470", "内蒙古呼伦贝尔市",
"861529302", "甘肃省临夏回族自治州",
"861532211", "广东省江门市",
"861850558", "安徽省阜阳市",
"861398698", "湖北省荆门市",
"861808174", "四川省攀枝花市",
"861333895", "江苏省盐城市",
"86153421", "天津市",
"861818710", "云南省昆明市",
"861517902", "江西省上饶市",
"861389781", "辽宁省营口市",
"861450859", "江苏省盐城市",
"861539399", "云南省曲靖市",
"861898829", "云南省昆明市",
"861815474", "广西南宁市",
"861535859", "江苏省镇江市",
"861453354", "辽宁省鞍山市",
"861332003", "江西省上饶市",
"861331908", "新疆克孜勒苏柯尔克孜自治州",
"861580960", "宁夏银川市",
"861768850", "广东省江门市",
"861528440", "云南省昆明市",
"8617623", "重庆市",
"861317260", "广东省肇庆市",
"861778035", "四川省雅安市",
"86180576", "浙江省台州市",
"861335478", "内蒙古巴彦淖尔市",
"861880423", "辽宁省鞍山市",
"861816841", "江苏省南京市",
"861553353", "河北省秦皇岛市",
"861787506", "广东省梅州市",
"861811904", "新疆阿勒泰地区",
"86184831", "四川省宜宾市",
"861523319", "河北省邢台市",
"86133123", "贵州省遵义市",
"861350148", "广东省广州市",
"861538635", "湖南省郴州市",
"861815143", "江苏省扬州市",
"861325179", "吉林省松原市",
"861810776", "广西百色市",
"861337869", "广东省广州市",
"861365537", "山东省济宁市",
"861588416", "四川省泸州市",
"86180479", "内蒙古锡林郭勒盟",
"861319584", "甘肃省庆阳市",
"861534425", "内蒙古兴安盟",
"86181379", "河南省洛阳市",
"861869761", "安徽省亳州市",
"86131668", "吉林省长春市",
"861857215", "湖北省武汉市",
"861801418", "江苏省无锡市",
"86189550", "安徽省滁州市",
"861776786", "吉林省吉林市",
"861869409", "湖北省宜昌市",
"861515250", "江苏省徐州市",
"861518947", "江苏省徐州市",
"861820355", "山西省长治市",
"861390744", "湖南省张家界市",
"861376834", "广西柳州市",
"86151498", "内蒙古巴彦淖尔市",
"861301084", "陕西省西安市",
"861512981", "陕西省渭南市",
"861317070", "云南省曲靖市",
"861532793", "湖北省襄樊市",
"86157025", "山西省晋中市",
"861892432", "广东省广州市",
"861367425", "辽宁省沈阳市",
"86150398", "河南省三门峡市",
"86185385", "河南省郑州市",
"861510574", "浙江省宁波市",
"861806116", "江苏省扬州市",
"861892144", "江苏省南京市",
"861329534", "山东省德州市",
"861372234", "河北省邯郸市",
"861881211", "河北省石家庄市",
"861871497", "安徽省铜陵市",
"861863348", "河北省石家庄市",
"86132663", "广东省佛山市",
"86152493", "甘肃省平凉市",
"861346628", "云南省红河哈尼族彝族自治州",
"86183908", "湖南省长沙市",
"861522493", "河南省驻马店市",
"861360055", "浙江省嘉兴市",
"861773723", "河南省濮阳市",
"86181941", "甘肃省甘南藏族自治州",
"861892473", "广东省惠州市",
"861818411", "贵州省贵阳市",
"861390667", "浙江省温州市",
"861590853", "贵州省安顺市",
"861477782", "广西南宁市",
"861533504", "江苏省宿迁市",
"861580771", "广西南宁市",
"861538740", "湖南省岳阳市",
"861530705", "江西省宜春市",
"861357978", "新疆塔城地区",
"861315107", "江苏省南京市",
"861872996", "陕西省西安市",
"86159040", "辽宁省沈阳市",
"86180324", "河北省石家庄市",
"861708749", "湖南省邵阳市",
"861373411", "山西省临汾市",
"861882986", "陕西省汉中市",
"861508083", "湖南省娄底市",
"861832047", "广东省梅州市",
"861515610", "安徽省马鞍山市",
"861300957", "内蒙古鄂尔多斯市",
"861459321", "四川省广安市",
"861530317", "河北省沧州市",
"861373287", "吉林省通化市",
"86187647", "山东省潍坊市",
"861565083", "安徽省宿州市",
"861573562", "山西省太原市",
"861361467", "黑龙江省七台河市",
"861818287", "黑龙江省大兴安岭地区",
"861560821", "四川省成都市",
"861807489", "广西河池市",
"861850782", "广西来宾市",
"861532579", "浙江省金华市",
"861368728", "湖北省襄樊市",
"861761441", "吉林省长春市",
"861771577", "四川省自贡市",
"861521851", "广东省清远市",
"861760879", "云南省普洱市",
"86139981", "辽宁省沈阳市",
"86187696", "山东省滨州市",
"861385220", "江苏省扬州市",
"861379653", "黑龙江省黑河市",
"861880614", "江苏省常州市",
"861361977", "青海省海西蒙古族藏族自治州",
"86183592", "福建省厦门市",
"86159895", "广东省深圳市",
"861599197", "陕西省宝鸡市",
"861781702", "广东省湛江市",
"86157792", "江西省九江市",
"861831246", "广东省深圳市",
"861320848", "黑龙江省大庆市",
"861308407", "安徽省蚌埠市",
"861452345", "河南省焦作市",
"861580909", "新疆博尔塔拉蒙古自治州",
"861586474", "山东省青岛市",
"861310303", "河北省张家口市",
"861828080", "四川省南充市",
"86156566", "安徽省池州市",
"861317606", "山东省潍坊市",
"86189543", "山东省滨州市",
"861805111", "江苏省苏州市",
"86150866", "重庆市",
"861831649", "广东省佛山市",
"861339704", "江西省九江市",
"861581922", "广东省韶关市",
"861566218", "吉林省延边朝鲜族自治州",
"861815485", "新疆阿克苏地区",
"861372127", "安徽省宿州市",
"861769703", "青海省黄南藏族自治州",
"86178658", "山东省聊城市",
"861532651", "黑龙江省七台河市",
"861560543", "山东省滨州市",
"86186911", "陕西省延安市",
"861532930", "贵州省贵阳市",
"861362476", "内蒙古赤峰市",
"861858938", "云南省曲靖市",
"86147470", "内蒙古呼伦贝尔市",
"86152974", "河北省邢台市",
"861801342", "江苏省无锡市",
"86135518", "四川省成都市",
"861569923", "新疆昌吉回族自治州",
"861533142", "云南省文山壮族苗族自治州",
"861472701", "浙江省金华市",
"861301075", "广东省深圳市",
"861804586", "黑龙江省双鸭山市",
"86182315", "河北省唐山市",
"861802762", "广东省江门市",
"86136699", "新疆乌鲁木齐市",
"86132191", "四川省南充市",
"86136765", "浙江省温州市",
"861337800", "湖南省岳阳市",
"861319575", "青海省西宁市",
"86177659", "广东省珠海市",
"861520535", "山东省烟台市",
"861802490", "广东省佛山市",
"86150631", "山东省威海市",
"861333373", "河南省新乡市",
"861594728", "内蒙古巴彦淖尔市",
"861343551", "广东省河源市",
"861786663", "山东省青岛市",
"861597740", "广西桂林市",
"861509259", "山东省威海市",
"861810445", "吉林省通化市",
"861373400", "山西省太原市",
"861532666", "黑龙江省哈尔滨市",
"861322990", "河北省唐山市",
"861311996", "新疆巴音郭楞蒙古自治州",
"861358946", "山东省聊城市",
"861325888", "吉林省长春市",
"861319120", "山西省忻州市",
"861378798", "湖南省岳阳市",
"861329034", "山东省菏泽市",
"861571820", "广东省中山市",
"861850872", "云南省曲靖市",
"861885125", "江苏省连云港市",
"861330595", "福建省泉州市",
"861801160", "四川省绵阳市",
"861333794", "江苏省徐州市",
"861770955", "宁夏中卫市",
"861348577", "安徽省滁州市",
"861388788", "云南省楚雄彝族自治州",
"861775207", "甘肃省庆阳市",
"861347443", "陕西省延安市",
"86184521", "江苏省南京市",
"861477872", "广东省湛江市",
"861772066", "福建省宁德市",
"86152763", "新疆伊犁哈萨克自治州",
"861514988", "内蒙古通辽市",
"861526801", "浙江省舟山市",
"86170814", "上海市",
"861862926", "陕西省西安市",
"861346940", "湖南省益阳市",
"86132304", "河北省石家庄市",
"86183958", "浙江省宁波市",
"861360555", "安徽省马鞍山市",
"861593107", "河北省石家庄市",
"861306344", "安徽省合肥市",
"861828907", "西藏山南地区",
"861354678", "山西省朔州市",
"861890627", "江苏省南通市",
"861811234", "江苏省常州市",
"861838581", "贵州省黔东南苗族侗族自治州",
"861518350", "四川省雅安市",
"861883441", "山西省忻州市",
"861700946", "江苏省苏州市",
"861881374", "广东省汕尾市",
"861512860", "河北省承德市",
"861881200", "河北省邯郸市",
"861327810", "吉林省长春市",
"861331238", "贵州省黔南布依族苗族自治州",
"861884624", "黑龙江省鸡西市",
"86159383", "河南省商丘市",
"861351481", "内蒙古呼和浩特市",
"861453671", "陕西省榆林市",
"861552452", "辽宁省沈阳市",
"861351328", "河北省保定市",
"861476887", "山东省滨州市",
"861832547", "山东省济宁市",
"861508583", "贵州省铜仁地区",
"861454123", "河北省张家口市",
"861556978", "甘肃省酒泉市",
"861386155", "江苏省淮安市",
"861868768", "云南省文山壮族苗族自治州",
"861587372", "湖南省益阳市",
"861769624", "山西省运城市",
"861380932", "甘肃省定西市",
"861470428", "辽宁省葫芦岛市",
"86156281", "新疆伊犁哈萨克自治州",
"861589983", "广东省佛山市",
"861707395", "河南省漯河市",
"861820457", "黑龙江省大庆市",
"861319265", "广东省佛山市",
"861370644", "山东省济南市",
"86573", "浙江省嘉兴市",
"861472710", "浙江省杭州市",
"861556468", "山东省枣庄市",
"861853033", "河南省濮阳市",
"861534327", "湖南省怀化市",
"861319389", "河南省信阳市",
"86176652", "广东省深圳市",
"861314906", "广东省韶关市",
"861847537", "广东省汕头市",
"861367327", "河北省沧州市",
"861591295", "云南省普洱市",
"861857428", "河南省驻马店市",
"861332157", "吉林省白城市",
"861886545", "山东省烟台市",
"861355789", "广西北海市",
"861303906", "吉林省白城市",
"861529149", "陕西省西安市",
"861337811", "四川省成都市",
"861390845", "湖南省长沙市",
"861309167", "黑龙江省大庆市",
"861871873", "广东省佛山市",
"861843141", "河北省石家庄市",
"861810631", "山东省威海市",
"861810950", "宁夏银川市",
"861569554", "安徽省淮南市",
"86153669", "江苏省宿迁市",
"86156799", "江西省萍乡市",
"861707832", "云南省昭通市",
"861539594", "福建省莆田市",
"861776132", "四川省凉山彝族自治州",
"861874280", "新疆喀什地区",
"861777109", "湖北省黄石市",
"861454826", "广东省揭阳市",
"86130731", "河北省石家庄市",
"861365280", "广东省潮州市",
"861363336", "河北省唐山市",
"861539448", "福建省厦门市",
"861586387", "山东省临沂市",
"861760789", "广西南宁市",
"861561982", "陕西省汉中市",
"86187595", "福建省泉州市",
"861362630", "山东省威海市",
"861362951", "宁夏银川市",
"861813086", "新疆乌鲁木齐市",
"861590538", "山东省泰安市",
"86177455", "黑龙江省大庆市",
"861332433", "吉林省延边朝鲜族自治州",
"861458780", "湖南省怀化市",
"861804086", "新疆吐鲁番地区",
"861332991", "湖北省孝感市",
"861339623", "山东省日照市",
"861787670", "广东省河源市",
"861860145", "江苏省苏州市",
"86133499", "湖北省武汉市",
"861833416", "贵州省毕节地区",
"861839444", "甘肃省天水市",
"861598606", "广东省佛山市",
"86151499", "内蒙古通辽市",
"861301094", "辽宁省大连市",
"861509682", "云南省昭通市",
"861572649", "山东省滨州市",
"861500976", "青海省玉树藏族自治州",
"861512991", "陕西省渭南市",
"861509171", "陕西省宝鸡市",
"86134376", "广东省惠州市",
"861532783", "湖北省武汉市",
"861539075", "江西省上饶市",
"86138879", "云南省普洱市",
"861572246", "江苏省泰州市",
"861529546", "江苏省徐州市",
"861319448", "福建省龙岩市",
"86158025", "湖南省长沙市",
"86180478", "内蒙古巴彦淖尔市",
"86183343", "浙江省杭州市",
"861319594", "甘肃省酒泉市",
"86181378", "河南省郑州市",
"86131669", "吉林省吉林市",
"861890534", "山东省德州市",
"861800310", "河北省邯郸市",
"861776796", "吉林省四平市",
"861840914", "陕西省商洛市",
"861846231", "山东省临沂市",
"861595142", "江苏省南通市",
"861570960", "宁夏银川市",
"86132486", "浙江省宁波市",
"861354711", "四川省绵阳市",
"86135271", "广东省中山市",
"861512157", "贵州省黔西南布依族苗族自治州",
"861562836", "广东省东莞市",
"861534906", "甘肃省酒泉市",
"861328351", "山西省太原市",
"86158800", "福建省福州市",
"861554590", "黑龙江省鹤岗市",
"861539389", "云南省楚雄彝族自治州",
"861828913", "西藏山南地区",
"861586495", "山东省淄博市",
"86150817", "河北省邯郸市",
"861337232", "浙江省嘉兴市",
"861323377", "河南省信阳市",
"861539265", "山西省大同市",
"861871930", "广东省云浮市",
"86156517", "江苏省南京市",
"861336209", "浙江省丽水市",
"861870423", "辽宁省盘锦市",
"861777506", "安徽省宿州市",
"861508889", "浙江省舟山市",
"861477761", "广西玉林市",
"861330264", "广东省东莞市",
"861808376", "江苏省扬州市",
"861338522", "湖北省仙桃市",
"86151547", "山东省济宁市",
"861857140", "湖北省荆州市",
"861581378", "广东省江门市",
"861839876", "四川省广元市",
"861398688", "湖北省十堰市",
"861333885", "江苏省扬州市",
"861309850", "贵州省贵阳市",
"861570470", "内蒙古呼伦贝尔市",
"861471596", "广东省深圳市",
"861368390", "河南省南阳市",
"861313004", "辽宁省大连市",
"861856974", "湖南省湘西土家族苗族自治州",
"861332860", "福建省南平市",
"861342242", "广东省惠州市",
"86182081", "四川省成都市",
"861806019", "福建省龙岩市",
"861850761", "广东省河源市",
"861850409", "辽宁省大连市",
"861508910", "广东省汕头市",
"861807702", "广西南宁市",
"86151190", "广东省惠州市",
"861338350", "山西省忻州市",
"861304360", "江苏省无锡市",
"861355073", "四川省宜宾市",
"861810078", "江西省南昌市",
"861588438", "四川省乐山市",
"86145340", "辽宁省沈阳市",
"861860877", "云南省玉溪市",
"861453853", "甘肃省定西市",
"861571047", "陕西省宝鸡市",
"861801436", "江苏省南通市",
"861847624", "广东省广州市",
"861510595", "福建省厦门市",
"861776088", "安徽省安庆市",
"861313360", "江西省上饶市",
"861596522", "山东省德州市",
"861520313", "河北省张家口市",
"861378052", "河北省保定市",
"861539120", "内蒙古包头市",
"861394331", "吉林省四平市",
"861323746", "湖南省永州市",
"86139233", "广东省中山市",
"861822043", "陕西省渭南市",
"861814984", "新疆巴音郭楞蒙古自治州",
"86177276", "广东省广州市",
"861769537", "宁夏银川市",
"861821948", "广东省茂名市",
"861536688", "江苏省扬州市",
"861806592", "福建省厦门市",
"861880727", "湖北省襄樊市",
"861550359", "山西省运城市",
"861845236", "江苏省南京市",
"861884037", "陕西省渭南市",
"861831621", "广东省肇庆市",
"861869058", "陕西省榆林市",
"861830690", "云南省西双版纳傣族自治州",
"861830453", "黑龙江省牡丹江市",
"86139396", "河南省驻马店市",
"861539575", "浙江省绍兴市",
"861815397", "甘肃省兰州市",
"86151695", "山东省潍坊市",
"861529046", "河南省安阳市",
"861528729", "云南省曲靖市",
"86151769", "河北省石家庄市",
"861301594", "福建省厦门市",
"86184372", "河南省安阳市",
"861555060", "山东省滨州市",
"861860931", "甘肃省兰州市",
"861508779", "云南省昭通市",
"861301448", "江西省宜春市",
"861860493", "辽宁省沈阳市",
"861860650", "浙江省杭州市",
"861323484", "内蒙古鄂尔多斯市",
"861891450", "江苏省泰州市",
"861458491", "山东省淄博市",
"861340632", "山东省枣庄市",
"861823018", "河北省衡水市",
"861501623", "广东省河源市",
"861511171", "青海省西宁市",
"861500451", "黑龙江省哈尔滨市",
"861761429", "辽宁省葫芦岛市",
"861319094", "内蒙古赤峰市",
"861351972", "青海省海东地区",
"86182482", "内蒙古兴安盟",
"861590559", "安徽省黄山市",
"861810896", "西藏那曲地区",
"861580618", "江苏省无锡市",
"861530303", "广东省清远市",
"861479975", "新疆昌吉回族自治州",
"86181387", "广东省广州市",
"86145949", "陕西省西安市",
"861471788", "山西省长治市",
"861589730", "湖南省岳阳市",
"861354531", "湖北省襄樊市",
"861813189", "河北省承德市",
"861707374", "河南省许昌市",
"861814367", "吉林省辽源市",
"861316811", "广东省梅州市",
"861850756", "广东省珠海市",
"861886478", "河南省焦作市",
"86158850", "贵州省贵阳市",
"861554090", "内蒙古巴彦淖尔市",
"861315113", "江苏省扬州市",
"861591274", "云南省玉溪市",
"861555270", "山东省滨州市",
"861532873", "四川省内江市",
"861370463", "黑龙江省牡丹江市",
"861322437", "吉林省辽源市",
"861365413", "辽宁省抚顺市",
"861312579", "吉林省白山市",
"861853839", "河南省信阳市",
"86150990", "新疆乌鲁木齐市",
"861772169", "江苏省常州市",
"861328366", "山西省晋中市",
"861354168", "四川省自贡市",
"861760573", "浙江省嘉兴市",
"86152128", "安徽省六安市",
"861310317", "河北省沧州市",
"86170972", "广东省深圳市",
"861570636", "山东省潍坊市",
"861311850", "贵州省贵阳市",
"861386640", "安徽省马鞍山市",
"861509238", "山东省临沂市",
"861860787", "广西柳州市",
"861452743", "湖南省湘西土家族苗族自治州",
"861479465", "黑龙江省鸡西市",
"861863489", "山西省吕梁市",
"861709935", "浙江省丽水市",
"861399457", "山西省晋中市",
"861310705", "湖南省郴州市",
"861318740", "云南省昆明市",
"861351790", "江西省新余市",
"861869833", "福建省漳州市",
"861313504", "湖南省衡阳市",
"861350721", "湖北省荆州市",
"861787708", "广西河池市",
"861361696", "福建省三明市",
"861571547", "山东省济宁市",
"861804320", "吉林省吉林市",
"861769305", "甘肃省武威市",
"861347195", "广西梧州市",
"86187783", "广西桂林市",
"861862535", "河南省信阳市",
"861838903", "西藏山南地区",
"86180613", "江苏省连云港市",
"861810578", "浙江省丽水市",
"861459349", "四川省凉山彝族自治州",
"861315816", "贵州省黔南布依族苗族自治州",
"861881832", "广东省河源市",
"861363442", "吉林省吉林市",
"861337688", "浙江省宁波市",
"861891945", "甘肃省武威市",
"861355198", "四川省甘孜藏族自治州",
"861768952", "西藏日喀则地区",
"86139347", "山西省大同市",
"86156933", "甘肃省平凉市",
"861820691", "云南省西双版纳傣族自治州",
"861580862", "云南省昭通市",
"861813552", "山西省长治市",
"861348499", "陕西省汉中市",
"861524916", "陕西省汉中市",
"861397350", "湖南省郴州市",
"861590671", "浙江省杭州市",
"861565901", "福建省龙岩市",
"86153583", "江苏省宿迁市",
"861839786", "江西省吉安市",
"861390496", "辽宁省锦州市",
"861330574", "浙江省宁波市",
"86145083", "江苏省镇江市",
"861817684", "广西钦州市",
"861333775", "江苏省镇江市",
"861771348", "四川省内江市",
"861760799", "江西省萍乡市",
"861501414", "广东省深圳市",
"86177012", "北京市",
"861537070", "江苏省泰州市",
"861500750", "广东省江门市",
"861813096", "新疆阿克苏地区",
"861599343", "河南省商丘市",
"861379207", "山东省东营市",
"861322507", "福建省厦门市",
"861804096", "新疆伊犁哈萨克自治州",
"861458790", "湖南省张家界市",
"861332981", "湖北省宜昌市",
"861805276", "江苏省镇江市",
"861816829", "江苏省扬州市",
"86133498", "湖北省武汉市",
"861301312", "安徽省黄山市",
"861338947", "甘肃省酒泉市",
"861335250", "黑龙江省哈尔滨市",
"861501805", "广东省湛江市",
"861323475", "内蒙古通辽市",
"861555009", "山东省日照市",
"861552667", "吉林省长春市",
"86156798", "江西省景德镇市",
"861303425", "浙江省金华市",
"861314425", "广东省汕头市",
"861539584", "浙江省杭州市",
"861354769", "四川省眉山市",
"861874290", "新疆伊犁哈萨克自治州",
"861336570", "安徽省滁州市",
"86188595", "福建省泉州市",
"861392338", "广东省珠海市",
"861365290", "广东省佛山市",
"861836220", "江苏省苏州市",
"861760532", "山东省青岛市",
"861377474", "福建省漳州市",
"86189984", "广东省广州市",
"86151123", "广东省深圳市",
"861889722", "青海省海东地区",
"86134028", "四川省成都市",
"861587515", "广东省阳江市",
"86183300", "河北省邯郸市",
"861471552", "广东省惠州市",
"861355799", "广西南宁市",
"86138692", "山东省德州市",
"861380644", "山东省青岛市",
"861335045", "四川省甘孜藏族自治州",
"861707385", "河南省许昌市",
"861589993", "广东省东莞市",
"861325576", "浙江省台州市",
"861700363", "广东省深圳市",
"861890339", "河北省石家庄市",
"86158462", "黑龙江省齐齐哈尔市",
"861893834", "广东省揭阳市",
"861876545", "山东省烟台市",
"861305526", "福建省福州市",
"86181026", "广东省广州市",
"861315859", "四川省内江市",
"861868066", "广东省深圳市",
"861327999", "新疆伊犁哈萨克自治州",
"861778926", "陕西省延安市",
"861869872", "辽宁省大连市",
"861527261", "湖北省荆州市",
"86131421", "湖南省长沙市",
"861819506", "宁夏固原市",
"861705167", "山西省太原市",
"861453192", "山西省晋中市",
"861351491", "安徽省芜湖市",
"861367639", "山东省临沂市",
"861318441", "浙江省杭州市",
"861336939", "甘肃省陇南市",
"861595309", "山东省日照市",
"861350420", "辽宁省辽阳市",
"861351933", "甘肃省平凉市",
"861536273", "广东省中山市",
"86130321", "上海市",
"861551279", "河北省沧州市",
"861332737", "湖南省益阳市",
"861554326", "吉林省松原市",
"861534236", "湖北省黄冈市",
"861332017", "江西省赣州市",
"861550554", "安徽省淮南市",
"861589645", "江苏省南京市",
"861528128", "四川省雅安市",
"861583062", "河北省廊坊市",
"861846901", "云南省迪庆藏族自治州",
"86145303", "天津市",
"861308624", "青海省海北藏族自治州",
"861515968", "福建省漳州市",
"861500687", "山东省东营市",
"861532832", "四川省泸州市",
"861328674", "广东省河源市",
"86145371", "湖北省武汉市",
"861895459", "山东省烟台市",
"861776752", "新疆阿克苏地区",
"861337563", "山东省泰安市",
"861853417", "山西省晋中市",
"861330585", "浙江省绍兴市",
"861383400", "山西省忻州市",
"861817675", "广西河池市",
"861325251", "吉林省松原市",
"861878434", "四川省内江市",
"861304434", "吉林省四平市",
"861333784", "江苏省宿迁市",
"861503998", "河南省安阳市",
"861875125", "江苏省连云港市",
"861820662", "广东省阳江市",
"861306521", "辽宁省铁岭市",
"861893928", "河南省鹤壁市",
"861377846", "四川省南充市",
"86183959", "浙江省金华市",
"861841966", "甘肃省张掖市",
"861313434", "吉林省四平市",
"861363318", "河北省衡水市",
"861708420", "云南省临沧市",
"861820753", "广东省梅州市",
"861381241", "江苏省宿迁市",
"861348702", "湖北省黄冈市",
"86182351", "山西省太原市",
"86147187", "海南省海口市",
"861537125", "江苏省扬州市",
"861476002", "福建省厦门市",
"861505865", "浙江省金华市",
"861329358", "山西省吕梁市",
"861521632", "山东省枣庄市",
"861322980", "广东省清远市",
"861477719", "广西北海市",
"861325898", "山东省聊城市",
"861311986", "广东省佛山市",
"861780955", "宁夏中卫市",
"861378788", "湖南省常德市",
"861570881", "云南省昭通市",
"861317958", "江苏省连云港市",
"861378596", "河北省邢台市",
"861390452", "黑龙江省齐齐哈尔市",
"861322007", "陕西省宝鸡市",
"861841951", "甘肃省兰州市",
"861355712", "广西柳州市",
"861505647", "安徽省芜湖市",
"86136698", "广东省东莞市",
"861508231", "四川省甘孜藏族自治州",
"861325669", "山东省济南市",
"861316869", "广东省珠海市",
"861768996", "福建省泉州市",
"861459102", "广西防城港市",
"86180734", "湖南省衡阳市",
"861590354", "山西省晋中市",
"861869782", "青海省海西蒙古族藏族自治州",
"861802480", "广东省中山市",
"861594526", "黑龙江省黑河市",
"861325266", "吉林省通化市",
"861362343", "山西省临汾市",
"861512962", "陕西省西安市",
"861364570", "浙江省衢州市",
"861336070", "广东省湛江市",
"86178659", "山东省淄博市",
"861803465", "甘肃省陇南市",
"861327912", "陕西省榆林市",
"86156468", "山东省济南市",
"8615982", "四川省成都市",
"861876250", "江苏省盐城市",
"861587015", "贵州省安顺市",
"861599187", "陕西省商洛市",
"861346842", "山东省淄博市",
"861507843", "广西玉林市",
"861870614", "江苏省常州市",
"86183350", "山西省忻州市",
"861598070", "福建省福州市",
"861527659", "新疆和田地区",
"861587735", "陕西省安康市",
"861575841", "云南省临沧市",
"861561919", "陕西省铜川市",
"861828090", "四川省内江市",
"861550316", "河北省廊坊市",
"861867248", "湖北省鄂州市",
"861589867", "山东省菏泽市",
"86188696", "云南省楚雄彝族自治州",
"861815495", "新疆喀什地区",
"861503244", "河北省沧州市",
"86178770", "广西南宁市",
"861322892", "西藏日喀则地区",
"861576474", "内蒙古乌兰察布市",
"861773427", "河北省保定市",
"861887113", "湖北省随州市",
"86155882", "山东省枣庄市",
"861770729", "湖北省武汉市",
"861850970", "青海省海北藏族自治州",
"861571922", "陕西省榆林市",
"861335545", "山东省烟台市",
"861890815", "四川省凉山彝族自治州",
"86150923", "山东省淄博市",
"86131022", "天津市",
"86158792", "江西省九江市",
"861876045", "福建省漳州市",
"861570909", "新疆博尔塔拉蒙古自治州",
"861576964", "宁夏固原市",
"861352538", "河南省平顶山市",
"861882996", "广东省佛山市",
"861508093", "湖南省邵阳市",
"861863077", "河北省唐山市",
"861394865", "内蒙古通辽市",
"861383411", "山西省太原市",
"861850460", "黑龙江省哈尔滨市",
"861565093", "青海省海东地区",
"861459544", "青海省海南藏族自治州",
"861334602", "浙江省绍兴市",
"861856985", "河南省郑州市",
"861819006", "四川省德阳市",
"861332809", "江苏省南通市",
"861570771", "广西南宁市",
"861807499", "广西梧州市",
"861364939", "甘肃省陇南市",
"861850792", "江西省九江市",
"861898023", "四川省自贡市",
"86147711", "广东省广州市",
"861804878", "四川省眉山市",
"861378878", "广西柳州市",
"86145353", "山东省东营市",
"861567602", "广西防城港市",
"861896701", "浙江省衢州市",
"861348348", "河北省唐山市",
"861559543", "宁夏吴忠市",
"861537939", "甘肃省陇南市",
"861566639", "山东省临沂市",
"8614774", "广东省广州市",
"861330379", "河南省洛阳市",
"861810852", "贵州省遵义市",
"861872986", "陕西省西安市",
"861835155", "江苏省盐城市",
"861551430", "河南省濮阳市",
"861550923", "陕西省榆林市",
"861374664", "黑龙江省绥化市",
"861332517", "山东省济宁市",
"861583562", "山西省晋城市",
"861893640", "江苏省宿迁市",
"861502615", "新疆昌吉回族自治州",
"861309986", "云南省曲靖市",
"861310415", "辽宁省丹东市",
"861871211", "安徽省宿州市",
"861837523", "贵州省黔南布依族苗族自治州",
"861300181", "河北省唐山市",
"861398902", "西藏日喀则地区",
"86183909", "湖南省长沙市",
"861522483", "河南省平顶山市",
"861375165", "广东省揭阳市",
"861830808", "西藏昌都地区",
"861337063", "山东省日照市",
"861858916", "西藏那曲地区",
"861829744", "安徽省六安市",
"861850539", "山东省临沂市",
"861458203", "安徽省淮北市",
"861476502", "北京市",
"861313309", "山西省运城市",
"861847413", "湖南省益阳市",
"861536563", "江苏省泰州市",
"861558370", "四川省阿坝藏族羌族自治州",
"861310804", "陕西省宝鸡市",
"861365703", "江西省上饶市",
"861576846", "广东省惠州市",
"861896530", "福建省三明市",
"861303658", "四川省乐山市",
"861871487", "安徽省马鞍山市",
"86182373", "河南省新乡市",
"861590736", "湖南省常德市",
"861806314", "山东省威海市",
"861308703", "河南省南阳市",
"861304309", "福建省漳州市",
"861527571", "山东省德州市",
"86177411", "辽宁省大连市",
"86158518", "江苏省南京市",
"86132365", "江苏省南京市",
"861834488", "江苏省徐州市",
"861522540", "河南省洛阳市",
"86183719", "湖北省十堰市",
"861761479", "内蒙古锡林郭勒盟",
"861520451", "黑龙江省哈尔滨市",
"861521623", "江西省吉安市",
"861366361", "山西省太原市",
"86159586", "浙江省台州市",
"86186715", "湖北省咸宁市",
"861347090", "安徽省黄山市",
"861510190", "甘肃省庆阳市",
"861501673", "广东省深圳市",
"861302153", "山东省潍坊市",
"861852908", "广东省深圳市",
"861314484", "广东省深圳市",
"861840796", "江西省吉安市",
"861898799", "云南省昆明市",
"861503382", "河北省保定市",
"861831671", "广东省揭阳市",
"861383929", "河南省濮阳市",
"861321594", "福建省厦门市",
"861508729", "云南省大理白族自治州",
"86185568", "江苏省苏州市",
"861334014", "江西省吉安市",
"861530945", "甘肃省金昌市",
"86184377", "河南省南阳市",
"861303484", "湖南省娄底市",
"861334734", "湖南省衡阳市",
"861452081", "安徽省合肥市",
"861533689", "浙江省杭州市",
"861569830", "山西省太原市",
"861355841", "广西南宁市",
"86145408", "上海市",
"86139785", "广西玉林市",
"861572161", "山西省朔州市",
"861533286", "内蒙古鄂尔多斯市",
"861535330", "陕西省商洛市",
"861582516", "云南省楚雄彝族自治州",
"861329677", "浙江省嘉兴市",
"861370316", "河北省廊坊市",
"861510637", "山东省济宁市",
"861532823", "四川省绵阳市",
"861302437", "湖南省邵阳市",
"861823367", "河北省沧州市",
"861356143", "山东省潍坊市",
"861309627", "四川省雅安市",
"861884943", "河北省张家口市",
"861305611", "江苏省宿迁市",
"861479925", "新疆伊犁哈萨克自治州",
"861773089", "河南省新乡市",
"86180482", "内蒙古兴安盟",
"861848912", "西藏日喀则地区",
"861898532", "贵州省安顺市",
"861879153", "陕西省渭南市",
"861351922", "宁夏石嘴山市",
"861876391", "山东省德州市",
"86181382", "广东省深圳市",
"861470545", "山东省烟台市",
"861350909", "广东省梅州市",
"861861599", "山东省东营市",
"861356964", "河南省鹤壁市",
"861380338", "河北省秦皇岛市",
"861572538", "山东省泰安市",
"861589115", "陕西省榆林市",
"861310278", "河北省衡水市",
"861324504", "湖南省常德市",
"861507292", "湖北省鄂州市",
"861357155", "陕西省铜川市",
"861891303", "江苏省南京市",
"861894884", "广东省韶关市",
"861454663", "广东省江门市",
"861350771", "广西南宁市",
"861809845", "安徽省宣城市",
"861308366", "河南省郑州市",
"861889013", "湖南省郴州市",
"861760523", "江苏省泰州市",
"861365366", "山西省太原市",
"86151730", "湖南省岳阳市",
"86150128", "广东省深圳市",
"861365685", "浙江省绍兴市",
"861312529", "江西省萍乡市",
"861889733", "青海省海东地区",
"861328413", "辽宁省抚顺市",
"861322243", "江苏省南京市",
"861370923", "陕西省渭南市",
"861302856", "陕西省西安市",
"861338072", "广东省韶关市",
"861880887", "云南省迪庆藏族自治州",
"86170977", "浙江省金华市",
"861370054", "山西省太原市",
"861339866", "河北省承德市",
"861345036", "广东省广州市",
"86159180", "广东省佛山市",
"861364396", "河南省驻马店市",
"861830064", "河南省焦作市",
"861800691", "福建省福州市",
"86177794", "江西省抚州市",
"861339944", "甘肃省张掖市",
"861333725", "湖南省怀化市",
"861330524", "江苏省宿迁市",
"861457002", "山东省淄博市",
"861334356", "湖北省襄樊市",
"861338262", "江苏省盐城市",
"861580749", "湖南省永州市",
"861528901", "西藏拉萨市",
"861591453", "广东省广州市",
"861538587", "安徽省芜湖市",
"861348840", "陕西省咸阳市",
"86181745", "湖南省怀化市",
"861844974", "新疆巴音郭楞蒙古自治州",
"861360867", "河南省郑州市",
"861700459", "黑龙江省大庆市",
"861363801", "贵州省黔南布依族苗族自治州",
"861378370", "河南省商丘市",
"861842042", "广东省梅州市",
"861560653", "浙江省杭州市",
"861804370", "吉林省辽源市",
"861560490", "辽宁省铁岭市",
"861561421", "河北省保定市",
"861567356", "湖南省邵阳市",
"861532541", "浙江省衢州市",
"861785821", "浙江省衢州市",
"861530450", "黑龙江省哈尔滨市",
"861530693", "福建省漳州市",
"861356846", "四川省巴中市",
"86182613", "江苏省连云港市",
"861306219", "福建省宁德市",
"861810528", "江苏省镇江市",
"861319660", "江苏省苏州市",
"861804204", "浙江省杭州市",
"861452917", "广东省汕尾市",
"86136889", "广东省东莞市",
"861338403", "河南省郑州市",
"861334361", "河南省焦作市",
"861822781", "四川省眉山市",
"86182478", "内蒙古巴彦淖尔市",
"861356387", "山东省菏泽市",
"861471828", "广东省梅州市",
"861820310", "河北省邯郸市",
"861346531", "山东省济南市",
"861305600", "江苏省淮安市",
"861772435", "广东省广州市",
"86133885", "浙江省温州市",
"861857250", "湖北省十堰市",
"861821857", "广东省深圳市",
"861360645", "山东省烟台市",
"861879861", "贵州省贵阳市",
"861522040", "广东省东莞市",
"861505117", "江苏省连云港市",
"861321094", "山东省烟台市",
"861509121", "陕西省延安市",
"861572853", "广东省深圳市",
"861837532", "安徽省芜湖市",
"861334514", "山东省烟台市",
"861519673", "四川省内江市",
"861391445", "江苏省南京市",
"861320633", "山东省日照市",
"861529682", "广西玉林市",
"861327336", "河北省秦皇岛市",
"861520976", "青海省玉树藏族自治州",
"86189397", "上海市",
"861539025", "四川省绵阳市",
"861478511", "贵州省贵阳市",
"861509546", "甘肃省定西市",
"861479139", "陕西省榆林市",
"861890996", "新疆巴音郭楞蒙古自治州",
"861374913", "河南省开封市",
"861582016", "广东省河源市",
"86189819", "四川省成都市",
"861880346", "山西省晋城市",
"86147951", "广西玉林市",
"861887643", "福建省厦门市",
"861832657", "安徽省马鞍山市",
"861357372", "山东省威海市",
"861452581", "福建省厦门市",
"861550932", "甘肃省定西市",
"86152817", "四川省南充市",
"861705815", "广东省深圳市",
"861870473", "内蒙古乌海市",
"861359983", "福建省宁德市",
"861339298", "广东省珠海市",
"861528889", "山东省德州市",
"861778750", "云南省保山市",
"861323327", "山西省晋城市",
"86184388", "河南省南阳市",
"861768815", "广东省深圳市",
"86150812", "河北省保定市",
"861857045", "湖南省怀化市",
"861458547", "河南省三门峡市",
"861339851", "贵州省贵阳市",
"861390234", "广东省韶关市",
"861323218", "广东省茂名市",
"861596403", "山东省潍坊市",
"861335391", "河南省焦作市",
"861538911", "陕西省延安市",
"861576613", "广东省揭阳市",
"861348634", "浙江省嘉兴市",
"86159685", "浙江省绍兴市",
"861365351", "山西省太原市",
"861899957", "新疆伊犁哈萨克自治州",
"861557143", "湖北省十堰市",
"861898032", "四川省广安市",
"86131386", "广东省广州市",
"861308351", "江苏省无锡市",
"861329850", "湖南省岳阳市",
"861856924", "湖南省益阳市",
"861450985", "新疆阿勒泰地区",
"861571491", "新疆克孜勒苏柯尔克孜自治州",
"861581217", "云南省大理白族自治州",
"861535985", "福建省泉州市",
"861571933", "甘肃省兰州市",
"86131630", "天津市",
"861325390", "河南省漯河市",
"861397262", "湖北省武汉市",
"861528910", "西藏拉萨市",
"86151928", "山东省临沂市",
"861858895", "广东省深圳市",
"861572718", "湖北省恩施土家族苗族自治州",
"86151542", "山东省青岛市",
"861338572", "浙江省湖州市",
"861808326", "贵州省黔西南布依族苗族自治州",
"861306292", "江苏省镇江市",
"861370554", "安徽省淮南市",
"861363810", "贵州省铜仁地区",
"861889513", "宁夏吴忠市",
"861877985", "江西省宜春市",
"861870963", "宁夏吴忠市",
"861760954", "宁夏固原市",
"861839826", "四川省雅安市",
"861598396", "四川省巴中市",
"861382452", "广东省佛山市",
"861855902", "福建省厦门市",
"861824052", "河南省信阳市",
"861500313", "河北省张家口市",
"861301660", "广东省佛山市",
"861770593", "福建省宁德市",
"86136704", "广东省汕头市",
"861366356", "山西省晋城市",
"861596572", "山东省济宁市",
"861303746", "湖南省永州市",
"861330953", "宁夏吴忠市",
"861802043", "江苏省常州市",
"861880777", "广西钦州市",
"861840588", "浙江省丽水市",
"861507219", "湖北省鄂州市",
"861830564", "安徽省六安市",
"86170988", "广东省广州市",
"861557846", "广西南宁市",
"861518417", "辽宁省营口市",
"861860827", "四川省巴中市",
"861391950", "甘肃省平凉市",
"861871529", "安徽省芜湖市",
"861810028", "广东省深圳市",
"861531534", "山东省德州市",
"86156654", "安徽省合肥市",
"86153404", "重庆市",
"861830311", "河北省石家庄市",
"861787565", "广东省阳江市",
"861780583", "浙江省嘉兴市",
"861847674", "广东省深圳市",
"861350881", "云南省曲靖市",
"861453649", "江苏省南通市",
"861388642", "湖北省黄冈市",
"861367548", "山东省泰安市",
"861596533", "山东省淄博市",
"861889882", "广东省广州市",
"8618640", "辽宁省沈阳市",
"861364520", "江苏省徐州市",
"861336020", "广东省江门市",
"861353917", "广东省梅州市",
"861378934", "湖南省张家界市",
"861813934", "新疆哈密地区",
"861899162", "陕西省汉中市",
"861774920", "陕西省榆林市",
"861705534", "广东省中山市",
"86184008", "西藏拉萨市",
"861530766", "广东省云浮市",
"86133320", "天津市",
"861768534", "贵州省贵阳市",
"861393428", "山西省阳泉市",
"861305669", "四川省成都市",
"861525647", "安徽省阜阳市",
"861334392", "河南省鹤壁市",
"861316742", "湖南省株洲市",
"86182734", "湖南省衡阳市",
"861811486", "江苏省无锡市",
"861333938", "黑龙江省伊春市",
"861566048", "山东省威海市",
"861593643", "河南省南阳市",
"86131006", "湖北省武汉市",
"861534548", "山东省日照市",
"861594576", "黑龙江省哈尔滨市",
"861879892", "西藏日喀则地区",
"861364352", "山西省大同市",
"86181994", "新疆阿克苏地区",
"86156138", "河北省唐山市",
"861305266", "辽宁省葫芦岛市",
"861818941", "甘肃省武威市",
"861571972", "青海省海东地区",
"861304699", "福建省泉州市",
"861558189", "山西省吕梁市",
"861335362", "河南省商丘市",
"86155887", "山东省济宁市",
"861770779", "广西北海市",
"861313296", "广西百色市",
"861569767", "广东省汕尾市",
"861763541", "山西省晋中市",
"861773477", "河南省新乡市",
"861535464", "吉林省四平市",
"861305076", "辽宁省辽阳市",
"86158797", "江西省赣州市",
"861369862", "山东省济南市",
"861879007", "河南省信阳市",
"86152923", "新疆阿克苏地区",
"861304296", "甘肃省嘉峪关市",
"861859540", "河南省焦作市",
"861313699", "黑龙江省佳木斯市",
"861373941", "四川省资阳市",
"861366319", "河北省邢台市",
"861888286", "四川省凉山彝族自治州",
"861334835", "福建省龙岩市",
"861321399", "河南省开封市",
"861362905", "四川省南充市",
"861338533", "山东省淄博市",
"861864304", "吉林省白城市",
"861896929", "浙江省湖州市",
"861529908", "新疆乌鲁木齐市",
"86134515", "江苏省苏州市",
"861865090", "福建省泉州市",
"861346401", "辽宁省沈阳市",
"861340704", "江西省抚州市",
"861825051", "福建省莆田市",
"861330329", "河北省石家庄市",
"86374", "河南省许昌市",
"861479738", "山西省临汾市",
"861531404", "山东省威海市",
"861583345", "河北省唐山市",
"861333824", "福建省三明市",
"861882534", "广东省江门市",
"861350239", "广东省汕尾市",
"861479018", "安徽省宣城市",
"861331302", "河北省保定市",
"861337223", "江苏省徐州市",
"861587110", "湖北省十堰市",
"861470610", "江苏省镇江市",
"861812500", "广东省茂名市",
"86188642", "河南省驻马店市",
"86895", "西藏昌都地区",
"861359150", "辽宁省丹东市",
"86159225", "重庆市",
"861350636", "山东省东营市",
"861870432", "吉林省吉林市",
"861550973", "青海省黄南藏族自治州",
"861571462", "黑龙江省齐齐哈尔市",
"861779106", "陕西省汉中市",
"861594898", "吉林省辽源市",
"861597479", "云南省楚雄彝族自治州",
"861378828", "广西河池市",
"861571790", "江西省新余市",
"861535974", "福建省福州市",
"86184554", "安徽省淮南市",
"86158746", "湖南省永州市",
"861570721", "湖北省襄樊市",
"861824878", "江苏省南京市",
"861397291", "湖北省荆门市",
"861563282", "河北省唐山市",
"861363567", "安徽省亳州市",
"861450974", "新疆哈密地区",
"86181401", "四川省成都市",
"861351547", "山东省济宁市",
"861510341", "山西省太原市",
"861345406", "浙江省舟山市",
"861558320", "四川省成都市",
"861527146", "湖北省宜昌市",
"861894785", "内蒙古乌兰察布市",
"861847685", "广东省深圳市",
"861840663", "广东省佛山市",
"86180373", "河南省郑州市",
"861861394", "湖南省常德市",
"861324309", "河南省洛阳市",
"861837198", "湖北省武汉市",
"86180301", "福建省厦门市",
"861840752", "广东省惠州市",
"861360010", "广东省惠州市",
"861329986", "青海省玉树藏族自治州",
"861575198", "甘肃省平凉市",
"861803925", "河南省三门峡市",
"861320672", "黑龙江省齐齐哈尔市",
"861360730", "湖南省岳阳市",
"861301206", "河北省保定市",
"861780668", "广东省茂名市",
"861476254", "江苏省苏州市",
"86132144", "吉林省长春市",
"861306071", "广东省梅州市",
"861582059", "广东省珠海市",
"861317665", "山东省济南市",
"861300622", "江西省鹰潭市",
"861310683", "广东省珠海市",
"861512422", "辽宁省营口市",
"861311358", "内蒙古赤峰市",
"86138545", "山东省烟台市",
"86185290", "广东省揭阳市",
"861341976", "河南省开封市",
"861558552", "吉林省白城市",
"861312324", "河南省郑州市",
"861317194", "河北省廊坊市",
"861336175", "江西省宜春市",
"861809744", "青海省西宁市",
"861369618", "四川省广安市",
"861768714", "云南省曲靖市",
"861303475", "内蒙古通辽市",
"861538969", "陕西省咸阳市",
"861705034", "贵州省贵阳市",
"861810915", "陕西省安康市",
"861323425", "辽宁省丹东市",
"861809486", "新疆吐鲁番地区",
"861768034", "湖南省衡阳市",
"861354842", "四川省绵阳市",
"861861773", "河北省沧州市",
"861478430", "河南省许昌市",
"861563638", "黑龙江省牡丹江市",
"861596033", "福建省龙岩市",
"861336520", "江苏省泰州市",
"86134616", "河南省濮阳市",
"861317847", "广东省清远市",
"861893468", "湖北省咸宁市",
"861878612", "贵州省贵阳市",
"861780899", "西藏山南地区",
"861304612", "广东省汕尾市",
"86177017", "上海市",
"861566548", "安徽省宿州市",
"861868629", "内蒙古赤峰市",
"86131056", "浙江省台州市",
"861336352", "山西省大同市",
"861520750", "广东省江门市",
"86155878", "湖北省仙桃市",
"861770889", "云南省丽江市",
"861536454", "山西省晋中市",
"861824096", "新疆乌鲁木齐市",
"86181618", "陕西省西安市",
"861371987", "广东省阳江市",
"861816879", "江苏省徐州市",
"861366392", "河南省鹤壁市",
"861800818", "四川省达州市",
"861478569", "贵州省遵义市",
"86158467", "黑龙江省牡丹江市",
"861879507", "宁夏银川市",
"86157203", "河北省沧州市",
"861325526", "江苏省南京市",
"861598352", "四川省雅安市",
"861382496", "广东省阳江市",
"861559781", "贵州省黔东南苗族侗族自治州",
"861850648", "山东省青岛市",
"861869822", "辽宁省朝阳市",
"861842927", "陕西省宝鸡市",
"861594669", "黑龙江省鸡西市",
"861398454", "贵州省遵义市",
"861825066", "福建省漳州市",
"861315643", "山东省淄博市",
"861889772", "广西柳州市",
"861599905", "新疆博尔塔拉蒙古自治州",
"86158132", "广东省清远市",
"861334319", "河北省邢台市",
"86138697", "山东省菏泽市",
"861338713", "湖北省十堰市",
"861366835", "四川省内江市",
"861376050", "广东省江门市",
"861572192", "陕西省榆林市",
"861504959", "内蒙古鄂尔多斯市",
"861391347", "江苏省徐州市",
"861597230", "湖北省鄂州市",
"861586607", "山东省济宁市",
"861565128", "江苏省镇江市",
"861812000", "江苏省无锡市",
"861806221", "湖北省黄冈市",
"861830369", "河南省洛阳市",
"861881541", "广西玉林市",
"861454588", "甘肃省兰州市",
"861826271", "江苏省淮安市",
"86138646", "山东省潍坊市",
"861327855", "吉林省通化市",
"861365674", "浙江省宁波市",
"861315995", "黑龙江省鸡西市",
"86136925", "广东省茂名市",
"861390904", "四川省阿坝藏族羌族自治州",
"861882034", "广东省东莞市",
"861520687", "山东省滨州市",
"861308674", "广西百色市",
"861898573", "贵州省安顺市",
"861550202", "广东省深圳市",
"861350470", "吉林省长春市",
"861363067", "吉林省延边朝鲜族自治州",
"861335140", "黑龙江省哈尔滨市",
"861551229", "河北省衡水市",
"861304868", "江苏省连云港市",
"861878868", "贵州省六盘水市",
"861556333", "山东省日照市",
"861803139", "河北省张家口市",
"86186648", "广东省广州市",
"861319609", "吉林省吉林市",
"861530751", "广东省韶关市",
"861890952", "宁夏石嘴山市",
"861340623", "山东省滨州市",
"861867536", "广东省梅州市",
"86180351", "山西省太原市",
"861501632", "广东省汕尾市",
"86181451", "黑龙江省哈尔滨市",
"861302980", "黑龙江省哈尔滨市",
"861318097", "吉林省四平市",
"861560791", "江西省南昌市",
"861309358", "安徽省宿州市",
"861539918", "陕西省西安市",
"861305898", "浙江省金华市",
"861473667", "云南省文山壮族苗族自治州",
"861332368", "河南省南阳市",
"861826061", "江苏省镇江市",
"861324434", "吉林省四平市",
"861558052", "湖南省湘西土家族苗族自治州",
"861331748", "湖南省长沙市",
"861770910", "陕西省西安市",
"861538479", "内蒙古锡林郭勒盟",
"861523998", "河南省濮阳市",
"861800662", "浙江省湖州市",
"861377253", "陕西省西安市",
"861572408", "广东省河源市",
"861818854", "贵州省黔南布依族苗族自治州",
"86185683", "河南省洛阳市",
"861338291", "江苏省宿迁市",
"861708470", "内蒙古呼和浩特市",
"861592618", "湖北省十堰市",
"861524332", "河北省廊坊市",
"861360510", "江苏省盐城市",
"86738", "湖南省娄底市",
"861800753", "广东省梅州市",
"861306571", "浙江省杭州市",
"861314965", "黑龙江省大庆市",
"861370359", "山西省运城市",
"861582559", "浙江省宁波市",
"861883087", "河北省邯郸市",
"861359989", "福建省莆田市",
"861524585", "黑龙江省哈尔滨市",
"861870479", "内蒙古锡林郭勒盟",
"861507791", "安徽省合肥市",
"861871841", "广东省广州市",
"861519066", "江苏省徐州市",
"861887246", "湖北省襄樊市",
"861528883", "山东省潍坊市",
"861374919", "河南省郑州市",
"861511495", "陕西省安康市",
"861318777", "云南省曲靖市",
"861887649", "福建省泉州市",
"861566622", "山东省青岛市",
"861537922", "甘肃省定西市",
"861800536", "山东省潍坊市",
"861576619", "广东省深圳市",
"861590974", "青海省海南藏族自治州",
"861809478", "浙江省杭州市",
"861508604", "贵州省贵阳市",
"861867753", "广西贵港市",
"861557149", "湖北省咸宁市",
"861364922", "陕西省榆林市",
"861479457", "黑龙江省大兴安岭地区",
"861820994", "新疆昌吉回族自治州",
"861313751", "河南省平顶山市",
"861597432", "湖南省湘西土家族苗族自治州",
"861867662", "广东省广州市",
"861596409", "山东省临沂市",
"861311834", "四川省眉山市",
"86187975", "湖南省怀化市",
"861530868", "湖北省鄂州市",
"861338409", "河南省焦作市",
"861591706", "广东省河源市",
"861827210", "湖北省孝感市",
"861583420", "山西省晋城市",
"861348827", "陕西省西安市",
"86182838", "四川省德阳市",
"861850350", "山西省忻州市",
"861331387", "福建省泉州市",
"861305588", "福建省漳州市",
"86135674", "浙江省宁波市",
"861858264", "四川省广安市",
"86157314", "河北省承德市",
"861831838", "广东省清远市",
"861320236", "广东省佛山市",
"861850522", "江苏省扬州市",
"861519679", "四川省南充市",
"861859942", "新疆伊犁哈萨克自治州",
"861572859", "广东省阳江市",
"861560261", "广东省东莞市",
"861350062", "内蒙古包头市",
"86147347", "广东省广州市",
"861307001", "新疆巴音郭楞蒙古自治州",
"861320639", "山东省青岛市",
"861819865", "贵州省黔南布依族苗族自治州",
"861351396", "河南省驻马店市",
"861318346", "四川省自贡市",
"861770599", "福建省南平市",
"86188913", "陕西省渭南市",
"861817017", "江西省鹰潭市",
"861500319", "河北省邢台市",
"861802049", "江苏省镇江市",
"861330959", "宁夏银川市",
"86155242", "辽宁省沈阳市",
"861780589", "浙江省金华市",
"861328492", "黑龙江省七台河市",
"861453643", "江苏省苏州市",
"861889092", "新疆伊犁哈萨克自治州",
"861454576", "四川省资阳市",
"861872640", "安徽省阜阳市",
"861855569", "安徽省合肥市",
"861325914", "陕西省商洛市",
"861554421", "河南省洛阳市",
"861328760", "山东省泰安市",
"861812902", "新疆哈密地区",
"861832958", "陕西省西安市",
"861590464", "黑龙江省七台河市",
"861300048", "北京市",
"861839380", "甘肃省甘南藏族自治州",
"861519551", "江苏省淮安市",
"861889807", "西藏阿里地区",
"861359810", "河南省安阳市",
"861860634", "山东省莱芜市",
"861399975", "新疆塔城地区",
"861770732", "湖南省长沙市",
"861831924", "广东省广州市",
"861390362", "黑龙江省齐齐哈尔市",
"86152098", "安徽省合肥市",
"861309640", "四川省乐山市",
"861558631", "湖北省武汉市",
"861856059", "山东省聊城市",
"861571939", "甘肃省酒泉市",
"861808880", "广东省惠州市",
"861555247", "山东省临沂市",
"861374880", "黑龙江省牡丹江市",
"861870969", "宁夏吴忠市",
"861814355", "贵州省贵阳市",
"861889519", "宁夏银川市",
"861347471", "内蒙古呼和浩特市",
"861813726", "河南省周口市",
"861302082", "河北省保定市",
"861786935", "云南省临沧市",
"861384890", "内蒙古呼伦贝尔市",
"861890050", "安徽省滁州市",
"86138460", "黑龙江省鸡西市",
"861311928", "陕西省榆林市",
"861561664", "湖南省衡阳市",
"861505506", "安徽省阜阳市",
"861530612", "江苏省常州市",
"861891434", "江苏省常州市",
"861596334", "山东省临沂市",
"861335904", "安徽省安庆市",
"861884949", "河北省邢台市",
"861800036", "河北省廊坊市",
"861534622", "河南省信阳市",
"861356149", "山东省聊城市",
"861560571", "浙江省杭州市",
"861532829", "四川省巴中市",
"86188537", "山东省济宁市",
"861811478", "江苏省徐州市",
"861587677", "广东省汕尾市",
"861800158", "江苏省南京市",
"861571260", "浙江省嘉兴市",
"861533683", "浙江省舟山市",
"861705333", "广东省深圳市",
"861594588", "黑龙江省佳木斯市",
"861839935", "新疆喀什地区",
"861827201", "湖北省武汉市",
"861390140", "江苏省淮安市",
"861329468", "山西省临汾市",
"861815908", "福建省福州市",
"861803681", "江苏省苏州市",
"861350903", "广东省揭阳市",
"86183972", "湖南省郴州市",
"861774022", "四川省成都市",
"861331474", "内蒙古兴安盟",
"861773083", "河南省信阳市",
"86181268", "广东省广州市",
"861333341", "山西省太原市",
"861879159", "陕西省商洛市",
"861814681", "陕西省宝鸡市",
"861708562", "安徽省合肥市",
"861336922", "陕西省汉中市",
"86131484", "浙江省杭州市",
"861805414", "甘肃省武威市",
"861865992", "福建省泉州市",
"861766052", "山东省威海市",
"861521629", "江西省吉安市",
"861888278", "四川省巴中市",
"861761473", "内蒙古乌海市",
"86155774", "广西桂林市",
"861501679", "广东省东莞市",
"861302159", "山东省枣庄市",
"861808992", "西藏日喀则地区",
"861818338", "四川省泸州市",
"861868414", "贵州省遵义市",
"861312841", "广东省潮州市",
"86135361", "广东省江门市",
"861373338", "河北省保定市",
"861550411", "辽宁省大连市",
"861508723", "云南省楚雄彝族自治州",
"861868805", "广东省潮州市",
"861383923", "河南省鹤壁市",
"861860840", "湖南省长沙市",
"861338334", "河北省唐山市",
"861350562", "安徽省蚌埠市",
"861565723", "浙江省丽水市",
"86152594", "福建省泉州市",
"861550287", "四川省资阳市",
"861307501", "安徽省亳州市",
"861452618", "江苏省苏州市",
"86158195", "广东省揭阳市",
"861305088", "辽宁省盘锦市",
"861309834", "湖北省武汉市",
"861571070", "广东省广州市",
"861384982", "河南省三门峡市",
"861898793", "云南省普洱市",
"861318887", "山东省济南市",
"861538432", "广东省珠海市",
"86189921", "陕西省延安市",
"861885820", "浙江省湖州市",
"861319825", "四川省泸州市",
"861591459", "广东省佛山市",
"861580743", "湖南省湘西土家族苗族自治州",
"861368796", "江西省吉安市",
"861824886", "江苏省镇江市",
"861331846", "广东省东莞市",
"861306213", "福建省莆田市",
"861358137", "湖北省十堰市",
"861530699", "福建省福州市",
"861560256", "广东省佛山市",
"86151805", "江西省宜春市",
"861871954", "甘肃省甘南藏族自治州",
"861556034", "内蒙古鄂尔多斯市",
"86170080", "重庆市",
"861700690", "福建省厦门市",
"861808770", "云南省玉溪市",
"861889592", "云南省保山市",
"861855069", "江苏省连云港市",
"861818114", "四川省德阳市",
"861454669", "广东省深圳市",
"861327115", "河南省开封市",
"861891309", "江苏省苏州市",
"861375472", "山东省临沂市",
"861575200", "云南省昆明市",
"861452862", "青海省海东地区",
"861329978", "青海省西宁市",
"861510938", "甘肃省天水市",
"861500392", "河南省鹤壁市",
"861309928", "甘肃省白银市",
"861770512", "江苏省连云港市",
"861331964", "湖南省张家界市",
"861890322", "河北省保定市",
"861321785", "广西玉林市",
"861341988", "河南省新乡市",
"861454266", "西藏那曲地区",
"861458352", "山东省东营市",
"861519051", "江苏省常州市",
"861861593", "山东省烟台市",
"861855279", "江苏省徐州市",
"861323340", "山西省忻州市",
"861300494", "福建省南平市",
"861311640", "贵州省安顺市",
"861358690", "浙江省宁波市",
"86138790", "江西省新余市",
"861890550", "安徽省滁州市",
"861458520", "河南省焦作市",
"861322646", "广东省江门市",
"86151020", "广东省广州市",
"861569297", "四川省德阳市",
"861313766", "河南省周口市",
"861760529", "江苏省常州市",
"861700137", "重庆市",
"861889019", "湖南省邵阳市",
"861539257", "山西省临汾市",
"861322249", "江苏省南通市",
"861328419", "辽宁省辽阳市",
"861889739", "青海省海西蒙古族藏族自治州",
"861312523", "江西省上饶市",
"861892441", "广东省清远市",
"861864991", "福建省漳州市",
"861394857", "内蒙古鄂尔多斯市",
"861315649", "山东省滨州市",
"861533568", "内蒙古巴彦淖尔市",
"861331485", "内蒙古包头市",
"86186299", "吉林省吉林市",
"861577167", "陕西省宝鸡市",
"861586908", "浙江省衢州市",
"861708591", "福建省福州市",
"861478563", "贵州省黔南布依族苗族自治州",
"86183295", "陕西省安康市",
"861560616", "江苏省无锡市",
"861311735", "湖南省郴州市",
"861880097", "四川省巴中市",
"861457087", "江苏省常州市",
"861594752", "内蒙古包头市",
"861306490", "江苏省淮安市",
"86180996", "新疆乌鲁木齐市",
"861338719", "湖北省荆州市",
"86131192", "陕西省延安市",
"861334313", "河北省张家口市",
"861522942", "陕西省榆林市",
"861524074", "广西河池市",
"861824445", "四川省内江市",
"861783910", "河南省商丘市",
"861309515", "新疆喀什地区",
"86158623", "江苏省苏州市",
"86151637", "山东省济宁市",
"861571606", "福建省龙岩市",
"861511397", "广东省肇庆市",
"861558347", "四川省凉山彝族自治州",
"861596039", "福建省厦门市",
"86186781", "山东省淄博市",
"861351520", "江苏省南通市",
"861450621", "黑龙江省齐齐哈尔市",
"861375157", "广东省惠州市",
"861780893", "西藏山南地区",
"861539617", "福建省三明市",
"861848510", "贵州省贵阳市",
"861538963", "陕西省渭南市",
"861328456", "黑龙江省黑河市",
"861478902", "西藏日喀则地区",
"861576661", "广东省惠州市",
"861861779", "河北省保定市",
"861814836", "内蒙古呼和浩特市",
"861374961", "河南省驻马店市",
"861779737", "青海省海南藏族自治州",
"861592917", "陕西省延安市",
"861550710", "湖北省鄂州市",
"861893677", "江苏省淮安市",
"861779017", "四川省凉山彝族自治州",
"861840898", "西藏日喀则地区",
"861816873", "江苏省苏州市",
"861518558", "贵州省黔东南苗族侗族自治州",
"86137296", "广东省清远市",
"86170959", "福建省福州市",
"861559638", "陕西省商洛市",
"861868623", "内蒙古鄂尔多斯市",
"861351352", "山西省大同市",
"861770883", "云南省临沧市",
"861815682", "安徽省合肥市",
"86176256", "江苏省苏州市",
"86155438", "吉林省松原市",
"861815171", "江苏省无锡市",
"861364547", "山东省济宁市",
"861336047", "广东省东莞市",
"861340226", "山东省潍坊市",
"861865471", "山东省潍坊市",
"861828421", "四川省南充市",
"861761432", "吉林省吉林市",
"86137247", "广东省湛江市",
"861774947", "河南省濮阳市",
"861319603", "吉林省长春市",
"861879116", "陕西省汉中市",
"861870911", "陕西省延安市",
"861352995", "云南省红河哈尼族彝族自治州",
"861320906", "新疆阿勒泰地区",
"861340629", "山东省济宁市",
"86178899", "海南省海口市",
"861329101", "江苏省徐州市",
"861470452", "黑龙江省齐齐哈尔市",
"861505670", "安徽省宿州市",
"861595945", "福建省厦门市",
"861582553", "浙江省杭州市",
"861370353", "山西省阳泉市",
"861800759", "广东省湛江市",
"86177898", "海南省海口市",
"861538473", "内蒙古乌海市",
"861584686", "黑龙江省黑河市",
"861377259", "陕西省咸阳市",
"861764056", "辽宁省朝阳市",
"86136858", "浙江省宁波市",
"861816176", "陕西省汉中市",
"861334926", "安徽省安庆市",
"861850947", "甘肃省嘉峪关市",
"861770394", "河南省周口市",
"861590330", "河北省邯郸市",
"86182528", "江苏省南通市",
"861452258", "浙江省金华市",
"861768372", "湖北省荆州市",
"86159408", "辽宁省大连市",
"861705372", "海南省海口市",
"861859527", "山东省济南市",
"861533131", "云南省昆明市",
"861855511", "安徽省合肥市",
"86184359", "山西省运城市",
"86132810", "四川省成都市",
"861301724", "湖南省常德市",
"86145489", "广东省深圳市",
"861321774", "广西梧州市",
"861876234", "江苏省泰州市",
"861803133", "河北省唐山市",
"86188856", "贵州省铜仁地区",
"861452891", "云南省西双版纳傣族自治州",
"861556339", "山东省临沂市",
"861767706", "广西百色市",
"86182263", "安徽省阜阳市",
"861345818", "四川省达州市",
"861357404", "湖南省岳阳市",
"861840576", "浙江省台州市",
"861898579", "贵州省黔南布依族苗族自治州",
"86182942", "甘肃省天水市",
"861302758", "河南省焦作市",
"861824950", "黑龙江省哈尔滨市",
"861339768", "湖南省株洲市",
"861454600", "青海省西宁市",
"86130054", "广东省深圳市",
"861705155", "河南省郑州市",
"861459235", "四川省资阳市",
"861880597", "福建省龙岩市",
"861313450", "黑龙江省哈尔滨市",
"861313693", "黑龙江省黑河市",
"861311515", "江苏省连云港市",
"861866630", "广东省揭阳市",
"86138723", "湖北省荆州市",
"861558183", "山西省太原市",
"861304693", "福建省宁德市",
"861304450", "福建省漳州市",
"86130992", "甘肃省兰州市",
"861590985", "辽宁省大连市",
"861533068", "吉林省通化市",
"861770773", "广西桂林市",
"86131737", "浙江省台州市",
"861458396", "福建省南平市",
"86159611", "江苏省常州市",
"861834476", "江苏省盐城市",
"861894448", "江苏省扬州市",
"86181196", "安徽省合肥市",
"861550469", "黑龙江省双鸭山市",
"861510725", "湖北省黄冈市",
"861550701", "江西省鹰潭市",
"861513524", "山西省大同市",
"861309735", "江西省萍乡市",
"861330916", "陕西省汉中市",
"861504524", "黑龙江省齐齐哈尔市",
"861575930", "福建省宁德市",
"861458184", "浙江省湖州市",
"861335127", "黑龙江省哈尔滨市",
"861366313", "河北省张家口市",
"861870587", "浙江省温州市",
"861338539", "山东省临沂市",
"861773668", "广西桂林市",
"861500356", "山西省晋城市",
"861323957", "宁夏中卫市",
"86133811", "北京市",
"861883432", "山西省长治市",
"861361842", "湖南省邵阳市",
"861889556", "安徽省马鞍山市",
"861561747", "河南省新乡市",
"861596539", "山东省临沂市",
"861350091", "吉林省延边朝鲜族自治州",
"861563871", "河南省驻马店市",
"861570345", "山西省长治市",
"861764061", "辽宁省锦州市",
"861593649", "河南省安阳市",
"861308921", "吉林省辽源市",
"861397039", "江西省景德镇市",
"861518136", "四川省广元市",
"86187292", "陕西省西安市",
"861342812", "广东省湛江市",
"86176206", "广东省佛山市",
"861338460", "黑龙江省哈尔滨市",
"861800406", "辽宁省锦州市",
"86182024", "辽宁省沈阳市",
"861533278", "内蒙古巴彦淖尔市",
"861593246", "河北省邯郸市",
"861700808", "江苏省南通市",
"861550530", "山东省菏泽市",
"861305663", "四川省乐山市",
"861338792", "江西省九江市",
"861777647", "广西桂林市",
"861889061", "湖南省娄底市",
"861576656", "广东省惠州市",
"861303848", "陕西省宝鸡市",
"861328461", "黑龙江省哈尔滨市",
"861321884", "江苏省淮安市",
"861389146", "陕西省渭南市",
"861324303", "河南省焦作市",
"861338970", "青海省海北藏族自治州",
"861317820", "福建省泉州市",
"861336547", "山东省济宁市",
"861855500", "安徽省滁州市",
"861840669", "广东省中山市",
"861780477", "内蒙古鄂尔多斯市",
"86181833", "四川省乐山市",
"861587986", "江西省鹰潭市",
"861333637", "山东省枣庄市",
"861537047", "江苏省南通市",
"861379344", "山东省日照市",
"86136808", "广东省惠州市",
"861764556", "黑龙江省黑河市",
"861502489", "内蒙古巴彦淖尔市",
"861310689", "广东省东莞市",
"861582053", "广东省中山市",
"861808956", "四川省广元市",
"861374956", "河南省平顶山市",
"861342668", "江西省南昌市",
"861776526", "广东省广州市",
"861356302", "山东省聊城市",
"861332684", "广东省江门市",
"861313945", "甘肃省武威市",
"861707841", "云南省保山市",
"861550979", "青海省海西蒙古族藏族自治州",
"861347770", "湖北省孝感市",
"861337626", "江苏省常州市",
"861815238", "宁夏中卫市",
"861556404", "山东省济宁市",
"861330323", "河北省石家庄市",
"861329110", "江苏省南通市",
"861776141", "四川省成都市",
"861572816", "广东省惠州市",
"861350233", "广东省梅州市",
"86147868", "湖南省湘西土家族苗族自治州",
"861802344", "广东省中山市",
"861500734", "湖南省衡阳市",
"861870900", "新疆伊犁哈萨克自治州",
"861596970", "山东省济南市",
"861827493", "湖南省永州市",
"86138852", "贵州省遵义市",
"861889271", "四川省广安市",
"86181590", "福建省莆田市",
"861564229", "辽宁省朝阳市",
"861826990", "安徽省池州市",
"861335234", "辽宁省辽阳市",
"861556815", "吉林省辽源市",
"861390391", "河南省焦作市",
"861309468", "浙江省丽水市",
"861326791", "广东省惠州市",
"86183977", "湖南省衡阳市",
"861774072", "西藏日喀则地区",
"861823681", "河南省许昌市",
"861361711", "湖北省鄂州市",
"861529495", "河南省周口市",
"861813183", "河北省衡水市",
"861708345", "山西省长治市",
"861700300", "广东省广州市",
"861348787", "湖南省郴州市",
"861336972", "青海省海东地区",
"861362498", "辽宁省大连市",
"861393486", "山西省运城市",
"861593192", "河北省唐山市",
"861590553", "安徽省芜湖市",
"861533804", "广东省东莞市",
"861899475", "江苏省常州市",
"861331424", "辽宁省沈阳市",
"861886667", "山东省东营市",
"861362544", "山东省烟台市",
"861532879", "四川省甘孜藏族自治州",
"86188532", "山东省青岛市",
"86159371", "河南省郑州市",
"861561590", "山东省菏泽市",
"861315119", "江苏省苏州市",
"861358064", "广东省肇庆市",
"861534672", "甘肃省定西市",
"861560521", "江苏省徐州市",
"861370469", "黑龙江省佳木斯市",
"861370701", "江西省鹰潭市",
"86159303", "河北省张家口市",
"861355930", "福建省龙岩市",
"861573862", "河南省周口市",
"861504085", "辽宁省朝阳市",
"861533415", "湖北省荆州市",
"861569941", "新疆阿克苏地区",
"861531550", "山东省青岛市",
"861560146", "江苏省南通市",
"861587627", "广东省江门市",
"861811428", "江苏省连云港市",
"861476087", "江苏省常州市",
"861528723", "云南省曲靖市",
"86156894", "山东省青岛市",
"86138635", "山东省聊城市",
"861860499", "辽宁省辽阳市",
"861327501", "福建省福州市",
"861508773", "云南省玉溪市",
"86150594", "福建省福州市",
"861570091", "新疆博尔塔拉蒙古自治州",
"861830459", "黑龙江省大庆市",
"861325088", "浙江省温州市",
"861816605", "江西省赣州市",
"861350345", "河南省郑州市",
"861477072", "江西省南昌市",
"861539147", "云南省玉溪市",
"861760930", "甘肃省临夏回族自治州",
"861888228", "四川省成都市",
"861761423", "辽宁省抚顺市",
"861760651", "浙江省杭州市",
"861872468", "黑龙江省鹤岗市",
"861501226", "云南省昭通市",
"861312402", "福建省福州市",
"861450516", "吉林省通化市",
"861787557", "广东省广州市",
"861458939", "广东省清远市",
"861564987", "河南省郑州市",
"861370530", "山东省菏泽市",
"861772866", "广东省河源市",
"861471950", "甘肃省酒泉市",
"861598972", "广东省汕头市",
"861586546", "山东省东营市",
"861778014", "四川省自贡市",
"861343866", "四川省内江市",
"861593408", "山西省晋中市",
"861876452", "山东省菏泽市",
"861459343", "四川省乐山市",
"861598790", "云南省昭通市",
"861868632", "吉林省吉林市",
"861808720", "云南省大理白族自治州",
"861838909", "西藏山南地区",
"861821865", "广东省深圳市",
"861348493", "陕西省西安市",
"861372655", "广东省韶关市",
"861319875", "四川省达州市",
"861337500", "福建省福州市",
"861802282", "广东省茂名市",
"861522077", "广东省江门市",
"861390250", "广东省湛江市",
"861776600", "江苏省扬州市",
"861879646", "江苏省淮安市",
"86170719", "福建省福州市",
"861804886", "四川省自贡市",
"861325796", "江西省吉安市",
"861524180", "辽宁省沈阳市",
"86156273", "广东省惠州市",
"86186034", "山西省太原市",
"861370979", "青海省海西蒙古族藏族自治州",
"861302646", "陕西省渭南市",
"861857234", "湖北省恩施土家族苗族自治州",
"861458570", "山东省济宁市",
"861853833", "河南省濮阳市",
"861312573", "吉林省延边朝鲜族自治州",
"861365419", "辽宁省辽阳市",
"861894206", "湖南省常德市",
"861324766", "广东省广州市",
"861760579", "浙江省金华市",
"861521551", "安徽省合肥市",
"861580917", "陕西省宝鸡市",
"861773741", "河南省郑州市",
"861780325", "河北省唐山市",
"861336790", "江西省新余市",
"861317328", "山东省滨州市",
"861329928", "广西河池市",
"861375422", "浙江省湖州市",
"861520392", "河南省鹤壁市",
"861855626", "江苏省宿迁市",
"861336462", "吉林省吉林市",
"861390045", "福建省福州市",
"861320548", "山东省东营市",
"861899965", "新疆和田地区",
"861855229", "江苏省南通市",
"861376815", "广西玉林市",
"861320494", "湖南省娄底市",
"861863483", "山西省运城市",
"861452749", "湖南省长沙市",
"861303340", "山西省忻州市",
"861337731", "广西桂林市",
"861890372", "河南省安阳市",
"861594914", "江苏省盐城市",
"861327510", "江苏省无锡市",
"861364972", "青海省海东地区",
"861521566", "安徽省池州市",
"861809428", "江苏省苏州市",
"86132275", "湖北省襄樊市",
"861875972", "福建省三明市",
"861555991", "云南省昆明市",
"861829478", "甘肃省甘南藏族自治州",
"86994", "新疆昌吉回族自治州",
"861590924", "陕西省榆林市",
"861362044", "广东省湛江市",
"86159664", "山东省烟台市",
"861800994", "新疆昌吉回族自治州",
"861860412", "辽宁省鞍山市",
"861314162", "湖南省湘西土家族苗族自治州",
"861838881", "云南省丽江市",
"861361531", "山东省济南市",
"861840390", "河南省焦作市",
"861339641", "山东省济南市",
"861599498", "广东省潮州市",
"861890155", "江苏省苏州市",
"861530434", "吉林省四平市",
"861458125", "安徽省六安市",
"86138536", "山东省潍坊市",
"861518822", "河南省南阳市",
"861870429", "辽宁省葫芦岛市",
"861336203", "浙江省衢州市",
"861476587", "青海省西宁市",
"861828919", "西藏拉萨市",
"861539383", "云南省西双版纳傣族自治州",
"861566672", "山东省东营市",
"861330332", "河北省保定市",
"861318727", "湖南省郴州市",
"861311468", "黑龙江省鹤岗市",
"861510784", "广西梧州市",
"861351606", "辽宁省锦州市",
"861820536", "山东省潍坊市",
"861850572", "浙江省湖州市",
"861700311", "河北省石家庄市",
"861325588", "浙江省台州市",
"861532789", "湖北省恩施土家族苗族自治州",
"861571520", "江苏省徐州市",
"86131571", "浙江省杭州市",
"861361700", "江西省南昌市",
"86138439", "吉林省白山市",
"861356661", "浙江省宁波市",
"861877016", "江西省鹰潭市",
"86147342", "重庆市",
"861327001", "江苏省扬州市",
"861343851", "四川省自贡市",
"861813347", "安徽省宣城市",
"861572643", "山东省淄博市",
"861334687", "河南省漯河市",
"86158735", "湖南省郴州市",
"861554961", "湖北省孝感市",
"861821647", "湖南省娄底市",
"86183988", "四川省达州市",
"861700564", "浙江省温州市",
"861536987", "河北省衡水市",
"861535016", "江西省上饶市",
"86135931", "山西省太原市",
"861370030", "河北省邯郸市",
"861531245", "江苏省苏州市",
"861379638", "黑龙江省双鸭山市",
"861580581", "浙江省杭州市",
"861372381", "湖南省娄底市",
"861571352", "山西省太原市",
"86186538", "山东省泰安市",
"86137438", "吉林省松原市",
"86180838", "云南省昆明市",
"861330895", "西藏昌都地区",
"861308492", "广西柳州市",
"861887038", "江西省景德镇市",
"861368914", "陕西省商洛市",
"861874492", "贵州省毕节地区",
"861453859", "甘肃省酒泉市",
"861454526", "广西百色市",
"861830706", "江西省吉安市",
"861365492", "辽宁省大连市",
"861781797", "广东省韶关市",
"86155247", "辽宁省大连市",
"861308760", "陕西省渭南市",
"861335452", "黑龙江省齐齐哈尔市",
"861355079", "四川省遂宁市",
"861301875", "广东省中山市",
"861707532", "山东省青岛市",
"861569854", "山西省临汾市",
"861572995", "新疆伊犁哈萨克自治州",
"861508394", "江西省赣州市",
"861887156", "湖北省襄樊市",
"861772298", "广东省阳江市",
"861454141", "吉林省长春市",
"861881188", "广东省深圳市",
"861772851", "广东省惠州市",
"861582985", "陕西省安康市",
"861550353", "山西省阳泉市",
"861777117", "湖北省黄石市",
"86184710", "湖北省襄樊市",
"861782288", "贵州省六盘水市",
"861520319", "河北省邢台市",
"861590838", "四川省达州市",
"861353148", "广东省韶关市",
"861760666", "广东省佛山市",
"861576748", "广东省广州市",
"861760385", "河南省郑州市",
"861458260", "安徽省马鞍山市",
"861398011", "四川省德阳市",
"861557259", "湖北省荆门市",
"861822049", "陕西省铜川市",
"861506115", "江苏省盐城市",
"861347388", "河北省石家庄市",
"86139901", "四川省绵阳市",
"861347421", "陕西省宝鸡市",
"861537790", "福建省福州市",
"861885780", "浙江省丽水市",
"861322082", "山东省威海市",
"86177936", "甘肃省张掖市",
"861319785", "江西省宜春市",
"861585041", "江苏省连云港市",
"861846512", "宁夏石嘴山市",
"861339435", "吉林省通化市",
"861332625", "山东省聊城市",
"861537462", "内蒙古呼伦贝尔市",
"861378776", "湖南省郴州市",
"86156251", "广东省广州市",
"861536731", "湖南省长沙市",
"861896932", "浙江省嘉兴市",
"861311978", "青海省西宁市",
"861811655", "四川省雅安市",
"861390545", "山东省烟台市",
"861337511", "江苏省徐州市",
"861364462", "黑龙江省齐齐哈尔市",
"861886845", "浙江省金华市",
"861334750", "广西南宁市",
"861315408", "陕西省铜川市",
"86157325", "河北省唐山市",
"861364790", "江西省抚州市",
"86138130", "江苏省南京市",
"861776611", "江苏省淮安市",
"861847837", "湖南省湘西土家族苗族自治州",
"861349", "北京市",
"861564364", "吉林省长春市",
"861828880", "云南省怒江傈僳族自治州",
"861329640", "山东省济南市",
"861399518", "宁夏银川市",
"861561913", "陕西省渭南市",
"861510775", "广西玉林市",
"861329015", "山东省潍坊市",
"861470904", "新疆和田地区",
"861834426", "广东省湛江市",
"861576149", "贵州省六盘水市",
"861329735", "湖南省郴州市",
"861527762", "广西玉林市",
"861507849", "广西柳州市",
"861335177", "黑龙江省鸡西市",
"861520356", "山西省晋城市",
"86189335", "广东省惠州市",
"861504574", "黑龙江省双鸭山市",
"861366466", "黑龙江省大庆市",
"861303191", "河北省邢台市",
"861888804", "江苏省无锡市",
"861806772", "浙江省台州市",
"861570903", "新疆和田地区",
"861453816", "四川省绵阳市",
"861770723", "湖北省武汉市",
"861887119", "湖北省武汉市",
"86130997", "青海省西宁市",
"861333095", "四川省眉山市",
"861862382", "河南省安阳市",
"861857904", "江西省南昌市",
"861818830", "四川省成都市",
"861314191", "江苏省盐城市",
"861786888", "陕西省西安市",
"86137774", "浙江省杭州市",
"861316863", "广东省惠州市",
"86187297", "陕西省宝鸡市",
"861325752", "广东省惠州市",
"861874971", "河南省洛阳市",
"861308971", "黑龙江省哈尔滨市",
"861554992", "湖北省咸宁市",
"861362349", "山西省朔州市",
"861533705", "甘肃省陇南市",
"861530504", "福建省厦门市",
"861886486", "山东省聊城市",
"861597254", "湖北省黄石市",
"86180024", "辽宁省沈阳市",
"861871532", "安徽省芜湖市",
"861553338", "河北省石家庄市",
"861315161", "江苏省扬州市",
"861325663", "山东省菏泽市",
"861815046", "福建省泉州市",
"861533228", "陕西省宝鸡市",
"861370411", "辽宁省大连市",
"861811215", "江苏省连云港市",
"861303957", "内蒙古包头市",
"861357952", "新疆克拉玛依市",
"861588757", "云南省丽江市",
"861570562", "安徽省铜陵市",
"861801117", "四川省遂宁市",
"861533317", "河北省沧州市",
"861370287", "广东省湛江市",
"861776898", "江苏省徐州市",
"861314957", "黑龙江省齐齐哈尔市",
"861311101", "山西省晋中市",
"861315538", "安徽省六安市",
"861579801", "江西省抚州市",
"861337069", "山东省淄博市",
"861458209", "安徽省黄山市",
"861850533", "山东省淄博市",
"861760374", "河南省许昌市",
"86594", "福建省莆田市",
"861837529", "贵州省黔东南苗族侗族自治州",
"861768245", "浙江省宁波市",
"861522489", "河南省南阳市",
"861458606", "湖北省鄂州市",
"861577534", "四川省成都市",
"861508512", "贵州省遵义市",
"861365709", "江西省南昌市",
"861308461", "浙江省温州市",
"861304303", "河南省平顶山市",
"861308709", "河南省驻马店市",
"861323848", "内蒙古兴安盟",
"861771210", "江苏省镇江市",
"861536569", "江苏省盐城市",
"861780427", "辽宁省盘锦市",
"861847419", "湖南省娄底市",
"861313303", "山西省朔州市",
"86185305", "河南省安阳市",
"861339505", "福建省厦门市",
"861317870", "广东省梅州市",
"861478454", "黑龙江省佳木斯市",
"861391204", "江苏省徐州市",
"861831985", "广东省惠州市",
"86138857", "贵州省毕节地区",
"861836247", "江苏省淮安市",
"861898029", "四川省巴中市",
"861364933", "甘肃省平凉市",
"861526645", "山东省聊城市",
"861807493", "广西南宁市",
"861508099", "湖南省岳阳市",
"861530142", "江苏省泰州市",
"861899746", "青海省玉树藏族自治州",
"861705050", "福建省厦门市",
"861565099", "青海省西宁市",
"861768050", "湖南省益阳市",
"86133245", "陕西省西安市",
"861536430", "湖南省益阳市",
"861550929", "陕西省安康市",
"861858180", "四川省达州市",
"861816041", "新疆乌鲁木齐市",
"861775659", "安徽省合肥市",
"861309110", "河北省邯郸市",
"861520014", "河北省邯郸市",
"861319774", "广西梧州市",
"861520734", "湖南省衡阳市",
"861330373", "河南省新乡市",
"861566633", "山东省日照市",
"861324945", "广东省深圳市",
"861593038", "河北省衡水市",
"861810586", "浙江省台州市",
"861559549", "宁夏中卫市",
"861537933", "甘肃省武威市",
"861337676", "广东省潮州市",
"861810798", "江西省景德镇市",
"861502942", "陕西省榆林市",
"861340551", "江苏省淮安市",
"861524024", "江苏省南京市",
"861813445", "河南省平顶山市",
"861390610", "江苏省镇江市",
"861355793", "广西桂林市",
"861562518", "广东省揭阳市",
"861378445", "河北省承德市",
"86151632", "山东省枣庄市",
"861372215", "内蒙古通辽市",
"861503130", "河北省承德市",
"861342440", "广东省深圳市",
"861312532", "江西省抚州市",
"86136116", "上海市",
"861477858", "广东省梅州市",
"861399738", "青海省西宁市",
"861831330", "云南省文山壮族苗族自治州",
"861327993", "新疆石河子市",
"861707263", "湖北省咸宁市",
"861330794", "江西省抚州市",
"861899484", "江苏省盐城市",
"861327431", "吉林省长春市",
"861530360", "黑龙江省哈尔滨市",
"861315853", "四川省雅安市",
"861500988", "辽宁省沈阳市",
"861515667", "安徽省阜阳市",
"861326762", "广东省中山市",
"861850858", "贵州省六盘水市",
"861775261", "湖南省湘西土家族苗族自治州",
"861773955", "河南省漯河市",
"861319393", "河南省漯河市",
"861700369", "广东省惠州市",
"861890333", "河北省秦皇岛市",
"861589999", "广东省广州市",
"86181736", "湖南省常德市",
"861326490", "湖北省宜昌市",
"86182996", "新疆喀什地区",
"861360754", "福建省莆田市",
"861361410", "辽宁省铁岭市",
"861363555", "安徽省马鞍山市",
"861816823", "江苏省徐州市",
"861806882", "江苏省南京市",
"861454390", "贵州省贵阳市",
"861556952", "新疆吐鲁番地区",
"861452148", "河北省邢台市",
"861881879", "广东省深圳市",
"861599349", "河南省驻马店市",
"86177229", "广东省惠州市",
"861819117", "陕西省汉中市",
"861855105", "江苏省无锡市",
"861760793", "江西省上饶市",
"86188703", "江西省上饶市",
"86188771", "广西南宁市",
"861503697", "河南省洛阳市",
"861825623", "安徽省六安市",
"861510885", "云南省丽江市",
"861354763", "四川省攀枝花市",
"861535671", "浙江省杭州市",
"861860702", "江西省九江市",
"861351570", "浙江省衢州市",
"861450182", "山西省吕梁市",
"861317657", "山东省淄博市",
"861358285", "河北省唐山市",
"861308456", "河北省邢台市",
"861316997", "广东省佛山市",
"86187119", "湖南省邵阳市",
"861570062", "四川省成都市",
"861770604", "福建省泉州市",
"86155168", "河南省驻马店市",
"861571396", "河南省驻马店市",
"861525670", "安徽省合肥市",
"861339337", "河北省沧州市",
"861565012", "山东省威海市",
"861820759", "广东省湛江市",
"86189580", "浙江省杭州市",
"861880635", "山东省聊城市",
"861505620", "安徽省铜陵市",
"861315038", "新疆博尔塔拉蒙古自治州",
"861319884", "四川省宜宾市",
"861337569", "山东省临沂市",
"861895453", "山东省济南市",
"861308837", "四川省凉山彝族自治州",
"861477713", "广西桂林市",
"86137242", "广东省深圳市",
"861828471", "四川省泸州市",
"861865421", "安徽省蚌埠市",
"86185355", "山西省长治市",
"861808388", "云南省普洱市",
"861808421", "贵州省遵义市",
"861340679", "山东省德州市",
"8618389", "海南省海口市",
"86134329", "广东省茂名市",
"861338648", "山东省青岛市",
"861598491", "四川省德阳市",
"86138826", "四川省广安市",
"861886744", "湖南省岳阳市",
"861309101", "河北省石家庄市",
"861575029", "云南省普洱市",
"861300906", "吉林省白城市",
"861366451", "黑龙江省哈尔滨市",
"861813950", "新疆伊犁哈萨克自治州",
"86130810", "河北省石家庄市",
"861321724", "湖北省荆门市",
"861523307", "河北省沧州市",
"861705550", "上海市",
"86187410", "辽宁省铁岭市",
"861813631", "江苏省宿迁市",
"861569755", "广东省深圳市",
"861311110", "山西省忻州市",
"86136510", "北京市",
"861774033", "河北省邯郸市",
"861536279", "广东省珠海市",
"861301774", "浙江省衢州市",
"861539795", "江西省宜春市",
"861895137", "江苏省宿迁市",
"861535559", "浙江省舟山市",
"86180263", "广东省广州市",
"861336491", "新疆昌吉回族自治州",
"861351939", "甘肃省陇南市",
"861360336", "河北省廊坊市",
"861804631", "福建省厦门市",
"861898529", "贵州省黔东南苗族侗族自治州",
"861536676", "江苏省徐州市",
"861336933", "甘肃省平凉市",
"861378950", "内蒙古呼伦贝尔市",
"861367633", "山东省日照市",
"86180528", "江苏省镇江市",
"861760487", "内蒙古鄂尔多斯市",
"861773440", "河北省石家庄市",
"86186828", "四川省达州市",
"861327645", "山东省烟台市",
"861593538", "山西省阳泉市",
"861534633", "河南省濮阳市",
"861810086", "重庆市",
"861559049", "吉林省松原市",
"861394948", "河南省平顶山市",
"861334976", "湖北省宜昌市",
"861523035", "河北省秦皇岛市",
"861558726", "云南省大理白族自治州",
"861705322", "广东省深圳市",
"861830416", "辽宁省锦州市",
"861768322", "四川省南充市",
"861575041", "内蒙古赤峰市",
"86189092", "陕西省西安市",
"861359855", "河南省信阳市",
"86182860", "贵州省贵阳市",
"861896644", "浙江省舟山市",
"861591765", "广东省东莞市",
"861471852", "广东省河源市",
"861346042", "河南省新乡市",
"861364780", "广西柳州市",
"86153146", "浙江省杭州市",
"86132213", "浙江省嘉兴市",
"86134076", "山东省临沂市",
"861760832", "四川省内江市",
"861817247", "广西钦州市",
"861786611", "甘肃省临夏回族自治州",
"861478742", "云南省曲靖市",
"86177677", "吉林省长春市",
"86158325", "河北省唐山市",
"86137130", "广东省东莞市",
"861516491", "内蒙古通辽市",
"86155802", "湖南省衡阳市",
"861315559", "安徽省黄山市",
"861814310", "吉林省长春市",
"861319795", "江西省宜春市",
"861322092", "山东省烟台市",
"861305826", "广东省汕头市",
"861890735", "湖南省郴州市",
"861803310", "广东省江门市",
"861893534", "山西省长治市",
"861368826", "四川省广安市",
"861325876", "吉林省通化市",
"861582995", "陕西省咸阳市",
"861355832", "广西柳州市",
"861573960", "新疆昌吉回族自治州",
"861826243", "江苏省扬州市",
"861556986", "甘肃省陇南市",
"861760395", "河南省漯河市",
"861593059", "河北省秦皇岛市",
"861308482", "陕西省榆林市",
"861318423", "浙江省杭州市",
"861379219", "山东省淄博市",
"861535718", "安徽省六安市",
"861322519", "江苏省常州市",
"861874482", "贵州省黔东南苗族侗族自治州",
"861336870", "云南省昭通市",
"861898541", "贵州省贵阳市",
"861365482", "内蒙古兴安盟",
"861399406", "山西省忻州市",
"861781787", "广东省韶关市",
"861517569", "河北省廊坊市",
"861535038", "江西省景德镇市",
"861508384", "江西省南昌市",
"861320377", "河南省南阳市",
"861572985", "四川省自贡市",
"861589277", "四川省南充市",
"861501505", "广东省江门市",
"861772288", "广东省广州市",
"861452420", "辽宁省大连市",
"861869403", "湖北省恩施土家族苗族自治州",
"861830008", "广东省惠州市",
"86183989", "四川省巴中市",
"861477707", "广西钦州市",
"861887016", "江西省鹰潭市",
"861567697", "广西钦州市",
"86183535", "山东省烟台市",
"861580591", "福建省厦门市",
"861372391", "山东省德州市",
"86429", "辽宁省葫芦岛市",
"861850315", "河北省唐山市",
"86186539", "山东省临沂市",
"861827255", "河南省安阳市",
"86137439", "吉林省白山市",
"86186985", "浙江省杭州市",
"861330885", "云南省昆明市",
"861315182", "江苏省宿迁市",
"861337863", "广东省佛山市",
"861570581", "浙江省杭州市",
"861310004", "山西省朔州市",
"861573470", "内蒙古呼伦贝尔市",
"861325598", "福建省厦门市",
"86138438", "吉林省松原市",
"861853409", "山西省临汾市",
"86157735", "湖南省郴州市",
"861381454", "江苏省南京市",
"86182381", "河南省南阳市",
"861850707", "江西省赣州市",
"861380030", "山西省忻州市",
"861818202", "湖南省岳阳市",
"861576046", "四川省达州市",
"861334697", "河南省南阳市",
"86145040", "辽宁省沈阳市",
"861861741", "河北省邢台市",
"861569353", "甘肃省金昌市",
"861567130", "湖北省襄樊市",
"861476597", "吉林省长春市",
"861862514", "江苏省苏州市",
"861898823", "云南省德宏傣族景颇族自治州",
"861804078", "新疆乌鲁木齐市",
"861378078", "山东省东营市",
"861539393", "云南省西双版纳傣族自治州",
"861450853", "江苏省扬州市",
"861335667", "山东省济南市",
"861332009", "江西省萍乡市",
"861819806", "甘肃省张掖市",
"861310360", "河南省商丘市",
"861510794", "江西省抚州市",
"861894525", "黑龙江省大庆市",
"861595705", "浙江省舟山市",
"861868851", "广东省韶关市",
"861523313", "河北省张家口市",
"861842031", "广东省湛江市",
"861398997", "西藏阿里地区",
"86133632", "河北省唐山市",
"861320746", "湖南省永州市",
"86184403", "新疆乌鲁木齐市",
"861815149", "江苏省无锡市",
"861333074", "四川省泸州市",
"861881402", "广东省惠州市",
"861842711", "湖北省鄂州市",
"86153197", "陕西省西安市",
"86137536", "山西省晋城市",
"861800984", "辽宁省盘锦市",
"861550854", "贵州省黔南布依族苗族自治州",
"86187740", "湖南省长沙市",
"861840380", "黑龙江省鸡西市",
"861553359", "河北省唐山市",
"861334130", "湖南省岳阳市",
"861810052", "福建省泉州市",
"861599488", "广东省江门市",
"861880429", "辽宁省葫芦岛市",
"86186436", "吉林省白城市",
"861336780", "广西南宁市",
"861317933", "江苏省盐城市",
"861510373", "河南省新乡市",
"861539774", "四川省内江市",
"861575126", "江苏省淮安市",
"861327150", "河南省洛阳市",
"861570917", "陕西省宝鸡市",
"861528427", "河北省沧州市",
"861517279", "湖北省随州市",
"861380979", "广东省汕尾市",
"861320484", "内蒙古鄂尔多斯市",
"86147520", "江苏省苏州市",
"861507543", "河北省张家口市",
"86183380", "河南省濮阳市",
"861346542", "山东省青岛市",
"861524190", "辽宁省本溪市",
"86151245", "黑龙江省哈尔滨市",
"861840935", "甘肃省武威市",
"861820738", "湖南省娄底市",
"861306043", "陕西省渭南市",
"861335845", "福建省南平市",
"861310142", "福建省福州市",
"861837541", "山东省济南市",
"861869072", "贵州省贵阳市",
"861770325", "河北省唐山市",
"861503451", "山西省长治市",
"861829610", "江西省新余市",
"861805866", "浙江省绍兴市",
"861315059", "云南省红河哈尼族彝族自治州",
"861322592", "福建省厦门市",
"861882978", "陕西省西安市",
"861459476", "陕西省咸阳市",
"861813896", "广东省江门市",
"861805944", "福建省莆田市",
"861593559", "山西省运城市",
"861348483", "陕西省榆林市",
"861533303", "山西省阳泉市",
"861316569", "湖北省咸宁市",
"861801103", "四川省泸州市",
"861868944", "广东省广州市",
"861707879", "云南省西双版纳傣族自治州",
"861550941", "甘肃省甘南藏族自治州",
"86170718", "河南省郑州市",
"861816029", "新疆巴音郭楞蒙古自治州",
"861325786", "广西玉林市",
"861559146", "陕西省汉中市",
"861804896", "四川省南充市",
"86181230", "四川省自贡市",
"861834235", "辽宁省葫芦岛市",
"86152541", "山东省济南市",
"861351958", "宁夏银川市",
"861364870", "云南省昭通市",
"861398166", "四川省巴中市",
"861373463", "青海省海东地区",
"861803301", "广东省东莞市",
"861800367", "黑龙江省鸡西市",
"861581175", "广东省云浮市",
"861517069", "江西省吉安市",
"861534957", "宁夏吴忠市",
"86181574", "浙江省宁波市",
"861850839", "四川省广元市",
"861891286", "江苏省南通市",
"861304317", "河北省沧州市",
"861454205", "河南省新乡市",
"861830508", "浙江省湖州市",
"861313317", "山西省临汾市",
"86137635", "黑龙江省齐齐哈尔市",
"861564997", "河南省周口市",
"861454728", "浙江省丽水市",
"861778154", "四川省成都市",
"861882468", "广东省佛山市",
"861777557", "四川省成都市",
"86185934", "湖南省衡阳市",
"861870740", "湖南省永州市",
"861860489", "内蒙古巴彦淖尔市",
"861380530", "山东省菏泽市",
"861507821", "广西百色市",
"86183861", "贵州省毕节地区",
"861366697", "福建省三明市",
"861782866", "四川省绵阳市",
"861399759", "湖北省荆州市",
"861395595", "安徽省黄山市",
"861576121", "贵州省黔南布依族苗族自治州",
"861313705", "河南省洛阳市",
"861367957", "广东省肇庆市",
"861477839", "广东省中山市",
"861345122", "湖北省荆州市",
"861536863", "云南省西双版纳傣族自治州",
"861505065", "江苏省盐城市",
"86155723", "湖北省黄冈市",
"861804578", "黑龙江省七台河市",
"861561580", "山东省菏泽市",
"861392353", "广东省揭阳市",
"861332509", "山东省临沂市",
"861525708", "浙江省舟山市",
"861862734", "湖南省衡阳市",
"861876667", "山东省滨州市",
"861560344", "山西省晋中市",
"86153732", "河北省廊坊市",
"861835627", "安徽省铜陵市",
"86156215", "山东省泰安市",
"861858341", "四川省甘孜藏族自治州",
"861360442", "吉林省长春市",
"861811391", "四川省南充市",
"861810320", "河北省邯郸市",
"861813578", "河南省郑州市",
"861326781", "广东省梅州市",
"861775282", "湖南省岳阳市",
"861332817", "江苏省常州市",
"861529485", "河南省新乡市",
"861810552", "安徽省蚌埠市",
"86183636", "山东省潍坊市",
"861565967", "福建省漳州市",
"861348797", "湖南省邵阳市",
"861362488", "内蒙古巴彦淖尔市",
"86419", "辽宁省辽阳市",
"86187532", "山东省青岛市",
"861362321", "河北省石家庄市",
"861508967", "广东省肇庆市",
"861330775", "广西玉林市",
"861328949", "陕西省榆林市",
"86184453", "黑龙江省牡丹江市",
"861380701", "江西省鹰潭市",
"861333574", "浙江省宁波市",
"86180529", "江苏省盐城市",
"861859702", "青海省海东地区",
"86177312", "河北省保定市",
"86186829", "陕西省西安市",
"861388631", "湖北省鄂州市",
"861810096", "海南省海口市",
"86182402", "辽宁省沈阳市",
"861399158", "陕西省铜川市",
"861535408", "河北省衡水市",
"86183825", "四川省遂宁市",
"86188410", "辽宁省铁岭市",
"86135690", "河南省安阳市",
"861322561", "安徽省淮北市",
"861514750", "内蒙古鄂尔多斯市",
"86181307", "安徽省阜阳市",
"86159522", "江苏省徐州市",
"86132456", "浙江省宁波市",
"861450408", "辽宁省大连市",
"861528242", "四川省达州市",
"86155460", "黑龙江省哈尔滨市",
"861320475", "内蒙古通辽市",
"861454129", "河北省邢台市",
"861508589", "贵州省黔西南布依族苗族自治州",
"861815302", "河南省鹤壁市",
"861300425", "浙江省湖州市",
"861519435", "山东省烟台市",
"861539785", "江西省宜春市",
"861356238", "山东省日照市",
"861844718", "内蒙古巴彦淖尔市",
"861322314", "河北省邯郸市",
"861336481", "新疆伊犁哈萨克自治州",
"861317790", "江西省新余市",
"861581184", "广东省深圳市",
"861529846", "江苏省扬州市",
"861763532", "山西省阳泉市",
"861808398", "新疆巴音郭楞蒙古自治州",
"861818932", "甘肃省定西市",
"861372140", "河南省郑州市",
"861598328", "四川省内江市",
"861846477", "山东省枣庄市",
"861786669", "山东省菏泽市",
"861373932", "甘肃省定西市",
"86134328", "广东省湛江市",
"861532263", "广东省汕头市",
"861870635", "山东省聊城市",
"861471578", "广东省深圳市",
"861592447", "内蒙古通辽市",
"86180426", "辽宁省大连市",
"86137826", "河南省焦作市",
"861876744", "浙江省台州市",
"86138242", "广东省惠州市",
"861571194", "广东省广州市",
"86181326", "河北省石家庄市",
"861766642", "广东省东莞市",
"861315354", "山东省烟台市",
"861347449", "陕西省汉中市",
"861379071", "广东省中山市",
"861595804", "浙江省杭州市",
"861527207", "湖北省咸宁市",
"86187703", "江西省上饶市",
"861335486", "内蒙古包头市",
"861768101", "安徽省宿州市",
"86187771", "广西南宁市",
"861453553", "安徽省芜湖市",
"861450192", "山西省运城市",
"861872550", "安徽省滁州市",
"861887182", "湖北省恩施土家族苗族自治州",
"861777103", "湖北省襄樊市",
"861860577", "浙江省温州市",
"86184440", "吉林省吉林市",
"861316987", "广东省中山市",
"861315016", "甘肃省武威市",
"861871879", "广东省深圳市",
"861565152", "江苏省宿迁市",
"861897862", "广西百色市",
"86187118", "湖南省娄底市",
"86130021", "上海市",
"86155169", "河南省郑州市",
"86177563", "安徽省宣城市",
"86151864", "贵州省黔西南布依族苗族自治州",
"861454380", "贵州省贵阳市",
"861339629", "山东省滨州市",
"861806892", "江苏省宿迁市",
"861301147", "河北省秦皇岛市",
"861332439", "吉林省白山市",
"86188119", "江苏省徐州市",
"861595415", "山东省聊城市",
"861769837", "河南省南阳市",
"86158674", "浙江省宁波市",
"861575605", "安徽省淮北市",
"861760783", "广西桂林市",
"861557682", "湖南省益阳市",
"861359336", "山西省吕梁市",
"861503687", "河南省平顶山市",
"861320965", "宁夏中卫市",
"861327983", "新疆乌鲁木齐市",
"861330784", "广西梧州市",
"861899494", "江苏省徐州市",
"861329372", "山西省大同市",
"861333585", "浙江省绍兴市",
"861850417", "辽宁省营口市",
"861538727", "湖北省恩施土家族苗族自治州",
"861812742", "广东省广州市",
"861510332", "河北省保定市",
"861500998", "新疆喀什地区",
"861317972", "江苏省徐州市",
"861309322", "湖北省荆门市",
"861319383", "河南省南阳市",
"861853039", "河南省鹤壁市",
"861899548", "宁夏中卫市",
"861589989", "广东省深圳市",
"861529474", "河南省信阳市",
"861311050", "福建省福州市",
"861458958", "广东省汕头市",
"86876", "云南省文山壮族苗族自治州",
"861338822", "四川省南充市",
"861322056", "山东省济南市",
"861326480", "湖北省黄冈市",
"861509424", "云南省保山市",
"861502634", "新疆喀什地区",
"861360318", "河北省衡水市",
"861310434", "吉林省四平市",
"861832020", "广东省惠州市",
"861810788", "广西河池市",
"861519641", "四川省乐山市",
"861593516", "山西省吕梁市",
"861355783", "广西桂林市",
"86182051", "江苏省南京市",
"861529143", "陕西省渭南市",
"861811362", "四川省德阳市",
"861332560", "新疆乌鲁木齐市",
"86176910", "陕西省西安市",
"86134739", "河北省石家庄市",
"86134212", "广东省阳江市",
"861471896", "西藏那曲地区",
"861830438", "吉林省松原市",
"861309550", "安徽省滁州市",
"861783955", "河南省南阳市",
"861361678", "浙江省宁波市",
"861811140", "四川省凉山彝族自治州",
"861858190", "四川省自贡市",
"86176897", "海南省海口市",
"861354831", "四川省内江市",
"861399536", "宁夏石嘴山市",
"861322061", "山东省泰安市",
"86135283", "广东省江门市",
"86132406", "广东省东莞市",
"861517011", "江西省鹰潭市",
"861501435", "广东省汕尾市",
"861562716", "广东省湛江市",
"86137857", "河北省沧州市",
"861329155", "浙江省绍兴市",
"861316364", "黑龙江省绥化市",
"861810596", "福建省漳州市",
"861802571", "广东省潮州市",
"86152570", "浙江省衢州市",
"861537481", "内蒙古兴安盟",
"861534340", "山西省太原市",
"86182452", "黑龙江省齐齐哈尔市",
"861590859", "贵州省黔西南布依族苗族自治州",
"861831995", "广东省中山市",
"861894918", "安徽省宿州市",
"861355176", "四川省遂宁市",
"861364481", "内蒙古呼和浩特市",
"861367340", "河南省周口市",
"861532573", "浙江省嘉兴市",
"861453838", "四川省广元市",
"861887059", "江西省萍乡市",
"861364328", "河北省沧州市",
"86158880", "浙江省宁波市",
"861800465", "黑龙江省哈尔滨市",
"861817422", "湖南省邵阳市",
"861807483", "广西桂林市",
"861537217", "浙江省舟山市",
"861588690", "新疆昌吉回族自治州",
"86155790", "江西省宜春市",
"861508089", "湖南省湘西土家族苗族自治州",
"861390478", "内蒙古巴彦淖尔市",
"861330446", "吉林省延边朝鲜族自治州",
"861316511", "山东省济南市",
"861846384", "山东省德州市",
"861565089", "安徽省宿州市",
"861528325", "四川省内江市",
"861855241", "江苏省无锡市",
"861452721", "湖北省荆州市",
"861587534", "广东省广州市",
"861572974", "四川省甘孜藏族自治州",
"861553316", "河北省廊坊市",
"861539875", "云南省保山市",
"86189725", "湖北省宜昌市",
"861893404", "广东省湛江市",
"86132509", "浙江省宁波市",
"861316000", "江苏省淮安市",
"861773729", "河南省三门峡市",
"86132427", "广东省广州市",
"861770427", "辽宁省盘锦市",
"861322271", "江苏省淮安市",
"861369447", "吉林省白城市",
"861379571", "四川省资阳市",
"86187822", "四川省成都市",
"86130422", "天津市",
"861892479", "广东省汕头市",
"861859348", "湖南省邵阳市",
"86131322", "天津市",
"861588137", "四川省宜宾市",
"86188246", "广东省深圳市",
"861502840", "河北省张家口市",
"861573909", "新疆博尔塔拉蒙古自治州",
"861522499", "河南省周口市",
"861454935", "江苏省南通市",
"861881532", "山东省青岛市",
"861371742", "广东省东莞市",
"86147830", "河南省平顶山市",
"861810878", "云南省楚雄彝族自治州",
"861569929", "新疆巴音郭楞蒙古自治州",
"861532402", "河北省唐山市",
"861380411", "辽宁省大连市",
"86187753", "广西南宁市",
"86138774", "广西梧州市",
"861560549", "山东省临沂市",
"861356171", "山东省莱芜市",
"861884971", "云南省楚雄彝族自治州",
"861769709", "青海省海西蒙古族藏族自治州",
"861872050", "江西省宜春市",
"861332304", "河北省石家庄市",
"86158361", "河南省新乡市",
"861571847", "广东省深圳市",
"861786898", "云南省昭通市",
"861330874", "云南省曲靖市",
"861309245", "江苏省连云港市",
"86185311", "河北省石家庄市",
"861333379", "河南省洛阳市",
"86153553", "浙江省金华市",
"861378852", "广西柳州市",
"861554982", "湖北省孝感市",
"861572464", "辽宁省鞍山市",
"861346927", "湖南省岳阳市",
"861813852", "广东省佛山市",
"861580562", "安徽省铜陵市",
"861380287", "广东省惠州市",
"861303181", "河北省廊坊市",
"861311550", "黑龙江省哈尔滨市",
"861890640", "山东省济南市",
"861303672", "湖南省邵阳市",
"861840728", "湖北省武汉市",
"861313415", "辽宁省丹东市",
"861322556", "安徽省安庆市",
"86152176", "广东省广州市",
"861800975", "青海省果洛藏族自治州",
"861760873", "云南省红河哈尼族彝族自治州",
"861840205", "广东省茂名市",
"861390968", "安徽省阜阳市",
"861333085", "四川省德阳市",
"861878415", "四川省广安市",
"861862392", "河南省鹤壁市",
"861829545", "宁夏中卫市",
"861475725", "浙江省温州市",
"861379659", "黑龙江省大庆市",
"861853539", "山西省朔州市",
"861899048", "四川省甘孜藏族自治州",
"861877119", "湖北省恩施土家族苗族自治州",
"861310309", "河北省邢台市",
"861332060", "四川省雅安市",
"861771145", "四川省达州市",
"861831643", "广东省阳江市",
"861516972", "山东省德州市",
"86147593", "福建省宁德市",
"861558528", "贵州省贵阳市",
"861300658", "山东省济南市",
"861580903", "新疆和田地区",
"861856246", "山东省临沂市",
"861524341", "河北省唐山市",
"861800738", "湖南省娄底市",
"86132065", "黑龙江省哈尔滨市",
"861772414", "广东省湛江市",
"861369562", "安徽省宿州市",
"861800018", "江苏省连云港市",
"86189633", "山东省日照市",
"861569287", "四川省凉山彝族自治州",
"861366307", "河南省安阳市",
"86155857", "贵州省毕节地区",
"861302592", "广西南宁市",
"861770375", "河南省平顶山市",
"861869022", "新疆哈密地区",
"861575176", "江苏省南京市",
"861510323", "河北省张家口市",
"861346365", "河北省承德市",
"861389549", "宁夏银川市",
"861309333", "安徽省铜陵市",
"861341998", "河南省信阳市",
"861321795", "江西省宜春市",
"861380929", "广东省汕头市",
"861508427", "辽宁省本溪市",
"861338833", "四川省自贡市",
"861376850", "广西南宁市",
"861527543", "山东省滨州市",
"861334535", "新疆阿克苏地区",
"861533945", "甘肃省金昌市",
"861569411", "辽宁省大连市",
"861528477", "四川省雅安市",
"861768834", "广东省惠州市",
"86156841", "山东省烟台市",
"86156224", "广东省广州市",
"861530689", "浙江省金华市",
"861595131", "江苏省南通市",
"86150541", "山东省济南市",
"861564241", "辽宁省辽阳市",
"861836860", "浙江省衢州市",
"861352974", "云南省曲靖市",
"861857744", "广西梧州市",
"861373316", "河南省郑州市",
"861773231", "河北省石家庄市",
"861317047", "湖南省长沙市",
"861302739", "湖南省邵阳市",
"861570743", "湖南省湘西土家族苗族自治州",
"861453330", "浙江省杭州市",
"861568160", "四川省雅安市",
"861372610", "广东省中山市",
"861534848", "湖南省怀化市",
"861452636", "江苏省徐州市",
"861537820", "四川省成都市",
"861516547", "山东省济宁市",
"861459426", "云南省楚雄彝族自治州",
"861368786", "广西桂林市",
"861816079", "江西省九江市",
"861306937", "河南省新乡市",
"861337241", "浙江省杭州市",
"861824896", "江苏省连云港市",
"861452239", "浙江省嘉兴市",
"86181082", "四川省成都市",
"861470744", "湖南省张家界市",
"861338058", "广东省揭阳市",
"861873897", "河南省开封市",
"861383338", "河北省石家庄市",
"861313278", "广西河池市",
"861324705", "江西省赣州市",
"861301617", "湖南省湘潭市",
"861894265", "河北省石家庄市",
"861305098", "辽宁省葫芦岛市",
"861518460", "黑龙江省七台河市",
"861304278", "湖北省襄樊市",
"861898783", "云南省楚雄彝族自治州",
"861351847", "四川省巴中市",
"861318897", "山东省青岛市",
"861576682", "广东省惠州市",
"861324228", "广东省揭阳市",
"861595568", "安徽省安庆市",
"861894389", "吉林省延边朝鲜族自治州",
"861865982", "福建省泉州市",
"86185603", "山东省淄博市",
"861899906", "新疆阿克苏地区",
"861763523", "山西省大同市",
"861893167", "河北省廊坊市",
"861374982", "河南省三门峡市",
"861324317", "河南省平顶山市",
"861454778", "山东省济南市",
"86151811", "四川省宜宾市",
"861310252", "河北省秦皇岛市",
"861373054", "河北省保定市",
"861387216", "湖北省咸宁市",
"861518539", "贵州省安顺市",
"861821806", "广东省惠州市",
"861581260", "广东省珠海市",
"861812800", "广东省东莞市",
"861509485", "山东省日照市",
"861510916", "陕西省汉中市",
"861882834", "四川省成都市",
"861333524", "山东省潍坊市",
"861330725", "湖北省黄冈市",
"861308949", "吉林省吉林市",
"861362371", "河南省郑州市",
"86187537", "山东省济宁市",
"861313068", "辽宁省阜新市",
"861568708", "云南省昆明市",
"861700757", "广东省佛山市",
"861807540", "安徽省马鞍山市",
"861889159", "陕西省商洛市",
"861394342", "吉林省白山市",
"861596058", "福建省泉州市",
"861524095", "云南省大理白族自治州",
"861813528", "山西省太原市",
"861810370", "河南省商丘市",
"861531515", "山东省烟台市",
"861533693", "浙江省金华市",
"86136162", "江苏省苏州市",
"861768928", "福建省三明市",
"861318002", "河北省张家口市",
"861334307", "河北省沧州市",
"861780732", "湖南省长沙市",
"86155807", "湖南省怀化市",
"861302092", "浙江省温州市",
"861342178", "广东省云浮市",
"861384880", "内蒙古呼伦贝尔市",
"861869522", "宁夏石嘴山市",
"86177672", "浙江省杭州市",
"861860942", "甘肃省酒泉市",
"86157690", "新疆昌吉回族自治州",
"861368876", "云南省丽江市",
"861340641", "山东省济南市",
"86180860", "湖北省武汉市",
"861555368", "山东省聊城市",
"86137460", "黑龙江省牡丹江市",
"861839390", "甘肃省临夏回族自治州",
"86186560", "安徽省合肥市",
"861366535", "山东省烟台市",
"861527043", "江西省宜春市",
"861323633", "江苏省连云港市",
"86130213", "天津市",
"861880969", "宁夏银川市",
"861879519", "宁夏银川市",
"861567307", "湖南省怀化市",
"861776935", "湖南省郴州市",
"861389049", "四川省凉山彝族自治州",
"86139441", "吉林省长春市",
"861374890", "黑龙江省牡丹江市",
"861869350", "甘肃省武威市",
"86187913", "陕西省渭南市",
"861328482", "内蒙古兴安盟",
"861592903", "陕西省渭南市",
"861889082", "新疆巴音郭楞蒙古自治州",
"861317547", "浙江省台州市",
"86139924", "陕西省商洛市",
"861318473", "河北省廊坊市",
"861354542", "湖北省荆州市",
"861838148", "四川省达州市",
"861452470", "黑龙江省大庆市",
"86184088", "云南省临沧市",
"861591008", "山东省济南市",
"861589227", "四川省广元市",
"861864860", "内蒙古包头市",
"861351386", "河南省驻马店市",
"861837497", "湖南省长沙市",
"861351665", "广东省惠州市",
"86155826", "山西省晋城市",
"861302807", "山西省长治市",
"861479662", "江西省吉安市",
"861815656", "安徽省马鞍山市",
"861831816", "广东省茂名市",
"861770589", "浙江省金华市",
"861318144", "山东省枣庄市",
"861569400", "四川省成都市",
"861559071", "吉林省松原市",
"861879092", "河南省漯河市",
"861516047", "福建省莆田市",
"86188975", "广西玉林市",
"861305598", "福建省南平市",
"861812811", "广东省珠海市",
"861453985", "广东省肇庆市",
"861368444", "四川省遂宁市",
"861368598", "福建省龙岩市",
"861817157", "湖北省恩施土家族苗族自治州",
"861595068", "江苏省徐州市",
"861338558", "贵州省六盘水市",
"86180381", "广东省深圳市",
"861867836", "山东省德州市",
"861824268", "辽宁省营口市",
"861778998", "西藏山南地区",
"861589134", "陕西省宝鸡市",
"861361357", "山西省临汾市",
"861360810", "四川省德阳市",
"861852424", "辽宁省沈阳市",
"861859634", "山东省莱芜市",
"861584763", "内蒙古包头市",
"86158314", "河北省承德市",
"861319617", "吉林省通化市",
"86182839", "四川省广元市",
"861581570", "广东省中山市",
"861331397", "福建省福州市",
"861771615", "四川省成都市",
"861770152", "江苏省无锡市",
"86133637", "河北省邢台市",
"861384919", "河南省郑州市",
"861503313", "河北省张家口市",
"861300746", "湖南省衡阳市",
"861333953", "黑龙江省牡丹江市",
"861475784", "浙江省台州市",
"861327555", "安徽省马鞍山市",
"861880479", "内蒙古锡林郭勒盟",
"861775049", "福建省泉州市",
"861830765", "广东省肇庆市",
"861363431", "吉林省长春市",
"861454888", "四川省绵阳市",
"861816930", "湖南省岳阳市",
"861881841", "广东省广州市",
"86153192", "陕西省宝鸡市",
"861359999", "福建省泉州市",
"861813028", "安徽省宣城市",
"861535246", "甘肃省酒泉市",
"861507781", "江苏省徐州市",
"861376677", "黑龙江省大庆市",
"861760605", "福建省漳州市",
"861768640", "山东省济南市",
"861528893", "山东省淄博市",
"861450246", "河北省承德市",
"861825298", "江苏省苏州市",
"861894575", "黑龙江省鹤岗市",
"86159143", "广东省广州市",
"861313568", "湖北省武汉市",
"861824078", "河南省商丘市",
"861450649", "黑龙江省伊春市",
"861807040", "江西省南昌市",
"861378028", "河北省衡水市",
"861898873", "广东省东莞市",
"861596558", "山东省青岛市",
"861804028", "辽宁省朝阳市",
"861812698", "广东省梅州市",
"861364378", "河南省开封市",
"861532523", "浙江省绍兴市",
"861319257", "广东省阳江市",
"861820465", "黑龙江省齐齐哈尔市",
"86139755", "湖南省郴州市",
"861880900", "新疆巴音郭楞蒙古自治州",
"861350917", "陕西省宝鸡市",
"861355541", "黑龙江省牡丹江市",
"861533766", "浙江省台州市",
"861857845", "广东省东莞市",
"86133020", "天津市",
"861810934", "甘肃省庆阳市",
"861528089", "福建省泉州市",
"861705015", "辽宁省沈阳市",
"861569530", "青海省海北藏族自治州",
"861390428", "辽宁省大连市",
"861785843", "浙江省嘉兴市",
"86159459", "黑龙江省哈尔滨市",
"861302061", "山东省德州市",
"861339051", "辽宁省大连市",
"861802146", "江苏省苏州市",
"86130406", "上海市",
"86187806", "四川省宜宾市",
"86131306", "辽宁省锦州市",
"861590643", "浙江省丽水市",
"861898832", "云南省临沧市",
"86182457", "黑龙江省大庆市",
"861537378", "河北省邯郸市",
"861332165", "广西玉林市",
"861330938", "甘肃省天水市",
"86137852", "河北省保定市",
"86150570", "浙江省衢州市",
"86180452", "黑龙江省齐齐哈尔市",
"86147869", "湖南省常德市",
"861309155", "黑龙江省绥化市",
"861845848", "浙江省温州市",
"861822571", "安徽省安庆市",
"861853920", "河南省鹤壁市",
"86187827", "四川省巴中市",
"861587996", "江西省萍乡市",
"861366405", "内蒙古乌兰察布市",
"861709663", "浙江省嘉兴市",
"861760541", "山东省济南市",
"861770477", "内蒙古鄂尔多斯市",
"861569469", "云南省德宏傣族景颇族自治州",
"86136809", "广东省汕尾市",
"861569701", "云南省西双版纳傣族自治州",
"861773779", "河南省郑州市",
"861302271", "山东省淄博市",
"861787647", "广东省茂名市",
"86138333", "河北省张家口市",
"861769921", "新疆昌吉回族自治州",
"861453464", "黑龙江省七台河市",
"861310699", "广东省江门市",
"861708917", "陕西省榆林市",
"861379146", "山东省菏泽市",
"861558896", "山东省莱芜市",
"861572924", "河南省濮阳市",
"861864809", "内蒙古锡林郭勒盟",
"861862602", "江苏省徐州市",
"861375809", "浙江省嘉兴市",
"861452771", "广西南宁市",
"861589442", "云南省德宏傣族景颇族自治州",
"861572053", "安徽省芜湖市",
"861384956", "河南省平顶山市",
"861816211", "江西省南昌市",
"861577986", "江西省赣州市",
"861571958", "宁夏银川市",
"861553463", "山西省晋城市",
"861856718", "河南省南阳市",
"861344238", "辽宁省沈阳市",
"861771255", "江苏省泰州市",
"861882015", "广东省深圳市",
"861318432", "浙江省宁波市",
"861348540", "山西省忻州市",
"861802843", "广东省湛江市",
"861538887", "云南省红河哈尼族彝族自治州",
"861343704", "江西省抚州市",
"861333329", "河北省唐山市",
"861330824", "四川省达州市",
"861822659", "安徽省蚌埠市",
"86136784", "重庆市",
"861580345", "山西省长治市",
"861811250", "江苏省常州市",
"861518334", "四川省眉山市",
"86155635", "山东省聊城市",
"861553973", "河南省洛阳市",
"861588274", "四川省巴中市",
"861338782", "辽宁省朝阳市",
"86159150", "广东省肇庆市",
"86170908", "北京市",
"861873432", "山西省阳泉市",
"861346977", "湖北省荆门市",
"861353636", "广东省湛江市",
"861355823", "广西桂林市",
"861773901", "河南省商丘市",
"861770967", "安徽省阜阳市",
"861352330", "河南省安阳市",
"861356546", "新疆克拉玛依市",
"861532841", "四川省南充市",
"861360567", "安徽省阜阳市",
"86188292", "陕西省西安市",
"861519169", "陕西省商洛市",
"861560282", "广东省中山市",
"86137723", "陕西省榆林市",
"861458386", "福建省龙岩市",
"861347982", "江西省景德镇市",
"861831859", "广东省湛江市",
"861513341", "河北省张家口市",
"861458665", "湖南省郴州市",
"861329050", "河北省邯郸市",
"861511474", "内蒙古乌兰察布市",
"861780773", "广西桂林市",
"861500154", "新疆和田地区",
"861815216", "甘肃省白银市",
"861381232", "江苏省连云港市",
"861811045", "安徽省芜湖市",
"861870597", "福建省龙岩市",
"861572838", "广东省阳江市",
"861323672", "辽宁省营口市",
"861377908", "新疆伊犁哈萨克自治州",
"861339566", "安徽省池州市",
"861880587", "浙江省温州市",
"861820975", "青海省果洛藏族自治州",
"861303622", "江西省鹰潭市",
"861840778", "广西河池市",
"861302556", "广东省肇庆市",
"861363730", "湖南省岳阳市",
"86150176", "广东省佛山市",
"861357627", "江西省南昌市",
"861386167", "江苏省淮安市",
"861590995", "新疆吐鲁番地区",
"861760823", "四川省成都市",
"861521641", "山东省济南市",
"861768515", "贵州省黔东南苗族侗族自治州",
"86184358", "山西省吕梁市",
"86145488", "四川省成都市",
"861508242", "四川省达州市",
"861569710", "湖北省襄樊市",
"861705515", "江苏省无锡市",
"861320425", "辽宁省抚顺市",
"861454179", "浙江省温州市",
"861452881", "云南省文山壮族苗族自治州",
"861813915", "新疆和田地区",
"861560638", "山东省德州市",
"861804915", "陕西省安康市",
"86147981", "吉林省长春市",
"861890468", "黑龙江省鹤岗市",
"86139705", "江西省宜春市",
"861532954", "贵州省黔南布依族苗族自治州",
"86155130", "山西省太原市",
"86177317", "河北省沧州市",
"861816200", "山东省威海市",
"861771540", "江苏省无锡市",
"86180402", "辽宁省沈阳市",
"861301257", "山东省烟台市",
"86159409", "辽宁省大连市",
"861302561", "广东省湛江市",
"86159527", "江苏省扬州市",
"861361940", "云南省德宏傣族景颇族自治州",
"861339551", "安徽省合肥市",
"861585666", "安徽省滁州市",
"86130456", "上海市",
"861585385", "山东省临沂市",
"86187856", "贵州省铜仁地区",
"861575832", "云南省楚雄彝族自治州",
"861880911", "陕西省延安市",
"861392469", "广东省汕尾市",
"86134760", "湖北省武汉市",
"861471528", "广东省惠州市",
"86139470", "内蒙古呼伦贝尔市",
"861864737", "内蒙古呼和浩特市",
"861505109", "江苏省盐城市",
"861345133", "内蒙古赤峰市",
"861814818", "四川省雅安市",
"86138247", "广东省中山市",
"861567405", "湖南省怀化市",
"861510959", "宁夏固原市",
"861509846", "山东省烟台市",
"861836809", "浙江省舟山市",
"861352985", "云南省曲靖市",
"861559616", "陕西省西安市",
"861380353", "江西省南昌市",
"861572553", "山东省烟台市",
"861846427", "山东省滨州市",
"861334814", "江苏省扬州市",
"86178898", "海南省海口市",
"861598378", "四川省南充市",
"861538346", "山西省太原市",
"861321147", "广西贵港市",
"861826892", "浙江省丽水市",
"861840888", "云南省丽江市",
"86170958", "福建省泉州市",
"861339679", "浙江省金华市",
"861830864", "贵州省黔南布依族苗族自治州",
"861340005", "江苏省南京市",
"861339276", "广东省佛山市",
"861770893", "西藏山南地区",
"86393", "河南省濮阳市",
"86155439", "吉林省白城市",
"861855863", "福建省三明市",
"861350581", "浙江省杭州市",
"861360067", "浙江省温州市",
"861870802", "西藏日喀则地区",
"861310868", "云南省昆明市",
"86156684", "山东省济南市",
"86135735", "山东省烟台市",
"861384961", "河南省驻马店市",
"861528152", "四川省阿坝藏族羌族自治州",
"8618322", "天津市",
"86132021", "广东省汕头市",
"86158931", "河南省驻马店市",
"861871829", "广东省佛山市",
"861340337", "河北省沧州市",
"861558268", "山西省临汾市",
"86138296", "广东省汕头市",
"861860527", "江苏省宿迁市",
"861576908", "新疆伊犁哈萨克自治州",
"861811545", "江苏省徐州市",
"861556627", "辽宁省鞍山市",
"86180051", "江苏省南京市",
"861509143", "陕西省渭南市",
"861525284", "江苏省连云港市",
"861832070", "广东省广州市",
"861893952", "河南省郑州市",
"861533751", "福建省福州市",
"861558078", "湖南省邵阳市",
"86151976", "湖南省常德市",
"861372250", "河北省唐山市",
"861329550", "安徽省滁州市",
"861776728", "浙江省丽水市",
"861839526", "宁夏吴忠市",
"861773910", "河南省焦作市",
"86157623", "山东省日照市",
"861317922", "吉林省通化市",
"861538777", "江西省吉安市",
"861818359", "云南省曲靖市",
"861375981", "陕西省汉中市",
"86186298", "吉林省四平市",
"861809045", "四川省遂宁市",
"861520998", "新疆喀什地区",
"861889813", "河南省开封市",
"861363510", "广西梧州市",
"861708581", "福建省泉州市",
"861361455", "黑龙江省绥化市",
"861814662", "江西省南昌市",
"861370854", "贵州省黔南布依族苗族自治州",
"86155536", "山东省潍坊市",
"861345836", "四川省自贡市",
"861839141", "陕西省延安市",
"861338872", "云南省大理白族自治州",
"861457097", "江苏省南通市",
"861306480", "江苏省宿迁市",
"861302056", "山东省德州市",
"861890978", "青海省西宁市",
"861830946", "甘肃省兰州市",
"861803753", "河南省驻马店市",
"861529424", "甘肃省兰州市",
"861822088", "陕西省铜川市",
"86135387", "广东省广州市",
"86181253", "广东省中山市",
"861569808", "山东省东营市",
"861760397", "河南省洛阳市",
"861501819", "广东省珠海市",
"861566440", "山东省德州市",
"861576789", "广东省梅州市",
"861814531", "黑龙江省牡丹江市",
"86152772", "广西柳州市",
"861350896", "山东省潍坊市",
"861536643", "江苏省宿迁市",
"861518699", "贵州省贵阳市",
"861535308", "陕西省渭南市",
"861811972", "安徽省蚌埠市",
"861582997", "陕西省商洛市",
"86150777", "广西玉林市",
"861450308", "河北省衡水市",
"861821983", "甘肃省平凉市",
"861346518", "山东省德州市",
"861539201", "福建省福州市",
"861533533", "山东省淄博市",
"861594638", "黑龙江省哈尔滨市",
"861452878", "宁夏银川市",
"861815402", "安徽省马鞍山市",
"861329962", "广西柳州市",
"861572987", "四川省宜宾市",
"861320375", "河南省南阳市",
"861589275", "四川省南充市",
"861334943", "黑龙江省牡丹江市",
"861375468", "山东省滨州市",
"861501507", "广东省韶关市",
"86184139", "浙江省杭州市",
"86159938", "河南省安阳市",
"861866237", "江苏省扬州市",
"861322414", "辽宁省本溪市",
"86182676", "浙江省台州市",
"86139620", "江苏省盐城市",
"861893560", "青海省海北藏族自治州",
"861781785", "广东省江门市",
"861336428", "辽宁省丹东市",
"861310756", "青海省海西蒙古族藏族自治州",
"861825159", "江苏省徐州市",
"86155592", "新疆伊犁哈萨克自治州",
"861478538", "贵州省黔西南布依族苗族自治州",
"861865498", "山东省临沂市",
"86137718", "江苏省苏州市",
"861573934", "新疆石河子市",
"861803700", "河南省洛阳市",
"861377879", "四川省巴中市",
"861808498", "四川省达州市",
"861817245", "广西玉林市",
"861598381", "四川省德阳市",
"861598428", "四川省内江市",
"861359857", "河南省信阳市",
"86158415", "辽宁省丹东市",
"86130688", "广东省广州市",
"861591767", "广东省东莞市",
"861323231", "广东省梅州市",
"861577458", "黑龙江省伊春市",
"861329503", "河南省平顶山市",
"861372203", "内蒙古呼伦贝尔市",
"861890737", "湖南省益阳市",
"861571486", "内蒙古赤峰市",
"861563669", "黑龙江省双鸭山市",
"861859094", "陕西省安康市",
"861807147", "湖北省黄冈市",
"861538938", "陕西省渭南市",
"861459664", "新疆巴音郭楞蒙古自治州",
"861586532", "山东省青岛市",
"861347349", "河北省邢台市",
"861319797", "江西省赣州市",
"861315454", "黑龙江省佳木斯市",
"861398643", "湖北省随州市",
"861308154", "内蒙古包头市",
"861335386", "河南省周口市",
"861333230", "辽宁省营口市",
"861862419", "辽宁省辽阳市",
"861335665", "山东省济南市",
"861707046", "浙江省金华市",
"861365154", "江苏省淮安市",
"861805249", "江苏省无锡市",
"861595707", "浙江省舟山市",
"861350578", "浙江省宁波市",
"861894527", "黑龙江省大庆市",
"861335194", "黑龙江省鹤岗市",
"86184430", "吉林省长春市",
"86147916", "陕西省汉中市",
"861870341", "山西省太原市",
"861476595", "吉林省长春市",
"86188393", "河南省濮阳市",
"861888262", "四川省内江市",
"861840871", "云南省昆明市",
"861454480", "湖北省十堰市",
"861843292", "河北省保定市",
"861880524", "江苏省宿迁市",
"861889944", "新疆和田地区",
"861815198", "江苏省常州市",
"861398995", "西藏昌都地区",
"861380064", "北京市",
"861452596", "福建省漳州市",
"861329472", "内蒙古包头市",
"861572500", "山东省威海市",
"861529200", "湖南省岳阳市",
"861850317", "河北省沧州市",
"861889866", "广东省湛江市",
"861899394", "甘肃省陇南市",
"861827257", "河南省安阳市",
"861319483", "四川省绵阳市",
"861309422", "湖北省荆州市",
"861330887", "云南省迪庆藏族自治州",
"861501980", "广东省惠州市",
"861510432", "吉林省吉林市",
"861890981", "辽宁省沈阳市",
"861530782", "广西柳州市",
"861865102", "江苏省无锡市",
"861852579", "辽宁省鞍山市",
"861341482", "广东省揭阳市",
"861477705", "广西玉林市",
"861339733", "湖南省株洲市",
"861310334", "河北省承德市",
"861360418", "辽宁省沈阳市",
"861326380", "广西南宁市",
"861708578", "江苏省淮安市",
"861811790", "四川省成都市",
"861858740", "广西防城港市",
"861850705", "江西省宜春市",
"861822796", "四川省广安市",
"861323093", "河北省秦皇岛市",
"861334695", "河南省郑州市",
"861708193", "福建省莆田市",
"861866124", "江苏省常州市",
"861368282", "广东省揭阳市",
"861811462", "江苏省苏州市",
"861315223", "陕西省宝鸡市",
"861573828", "河南省信阳市",
"861532748", "湖北省黄冈市",
"861325549", "山东省临沂市",
"861516140", "江苏省扬州市",
"861803031", "福建省厦门市",
"861346738", "湖南省娄底市",
"861529793", "江西省上饶市",
"86159720", "湖北省武汉市",
"861534440", "湖南省长沙市",
"861814031", "四川省宜宾市",
"861889851", "广东省茂名市",
"861537428", "江西省吉安市",
"861899773", "新疆石河子市",
"861889298", "新疆克拉玛依市",
"86136238", "河南省郑州市",
"861478718", "云南省丽江市",
"861811203", "江苏省徐州市",
"861800365", "黑龙江省哈尔滨市",
"861581177", "广东省云浮市",
"861812192", "四川省南充市",
"861800686", "浙江省台州市",
"861809972", "新疆哈密地区",
"861367440", "吉林省四平市",
"8618930", "上海市",
"861330346", "山西省太原市",
"861390378", "河南省开封市",
"861337643", "山东省淄博市",
"861366943", "广西桂林市",
"861820542", "山东省青岛市",
"861834237", "辽宁省葫芦岛市",
"86130677", "浙江省杭州市",
"861528425", "河北省唐山市",
"861452788", "新疆喀什地区",
"861320589", "浙江省金华市",
"861893270", "河北省邯郸市",
"86137153", "广东省深圳市",
"86147095", "宁夏银川市",
"861333969", "贵州省黔西南布依族苗族自治州",
"86182575", "浙江省绍兴市",
"86158619", "江苏省盐城市",
"861374044", "吉林省长春市",
"861865044", "福建省厦门市",
"861570915", "陕西省安康市",
"861368638", "山东省烟台市",
"861893304", "广东省潮州市",
"861895941", "福建省宁德市",
"861770327", "河北省沧州市",
"861587009", "江西省新余市",
"86157618", "贵州省贵阳市",
"86185669", "广东省东莞市",
"86157002", "四川省绵阳市",
"86135378", "广东省深圳市",
"86134567", "浙江省杭州市",
"861576879", "广东省惠州市",
"86188236", "广东省惠州市",
"861859448", "福建省泉州市",
"861840937", "甘肃省酒泉市",
"86185795", "湖南省永州市",
"861335847", "福建省宁德市",
"86150788", "广西南宁市",
"861835625", "安徽省池州市",
"86139125", "江苏省盐城市",
"861533858", "贵州省六盘水市",
"861803293", "河北省石家庄市",
"861380311", "河北省石家庄市",
"861532302", "广东省梅州市",
"861571744", "湖南省张家界市",
"86155958", "海南省海口市",
"86518", "江苏省连云港市",
"861776821", "江苏省盐城市",
"861780639", "山东省临沂市",
"861707546", "福建省泉州市",
"861876665", "山东省泰安市",
"861563898", "河南省南阳市",
"861565965", "福建省漳州市",
"861328998", "新疆喀什地区",
"861708268", "湖北省武汉市",
"861348795", "湖南省邵阳市",
"861330777", "广西钦州市",
"861508965", "广东省肇庆市",
"861380564", "安徽省六安市",
"861379914", "福建省南平市",
"861452096", "安徽省池州市",
"861471743", "江西省南昌市",
"861332815", "江苏省无锡市",
"861880953", "宁夏吴忠市",
"861530872", "云南省大理白族自治州",
"861529487", "河南省新乡市",
"861533291", "内蒙古呼和浩特市",
"861769514", "宁夏固原市",
"861303128", "新疆喀什地区",
"861313315", "山西省长治市",
"861389826", "辽宁省辽阳市",
"861832452", "黑龙江省齐齐哈尔市",
"861564995", "河南省周口市",
"861809462", "浙江省嘉兴市",
"861708078", "湖南省岳阳市",
"861862760", "湖南省娄底市",
"861534955", "宁夏中卫市",
"861317140", "内蒙古呼和浩特市",
"861304315", "河北省唐山市",
"861809790", "新疆克拉玛依市",
"861454207", "河南省洛阳市",
"861896946", "浙江省衢州市",
"861395597", "安徽省黄山市",
"861310409", "黑龙江省大庆市",
"861843616", "河南省新乡市",
"861367955", "广东省肇庆市",
"861313707", "河南省南阳市",
"861325049", "广东省中山市",
"861505067", "江苏省无锡市",
"861301483", "广西北海市",
"861777555", "四川省绵阳市",
"86152821", "四川省内江市",
"861860584", "浙江省宁波市",
"861323593", "福建省宁德市",
"861316974", "广东省清远市",
"861366695", "福建省三明市",
"861479769", "青海省海南藏族自治州",
"861815263", "湖南省岳阳市",
"861812161", "江苏省连云港市",
"861321040", "山东省滨州市",
"861577106", "湖北省荆门市",
"861846475", "山东省枣庄市",
"86170857", "江苏省连云港市",
"861870637", "山东省临沂市",
"861813743", "河南省驻马店市",
"861839849", "四川省凉山彝族自治州",
"86181416", "辽宁省锦州市",
"86137597", "陕西省宝鸡市",
"86180316", "河北省廊坊市",
"861378743", "湖南省湘西土家族苗族自治州",
"861862971", "吉林省松原市",
"861367741", "湖南省娄底市",
"86186497", "福建省福州市",
"861822752", "四川省内江市",
"861534741", "广东省广州市",
"861894942", "安徽省芜湖市",
"86185022", "天津市",
"861342181", "广东省深圳市",
"861347498", "内蒙古包头市",
"861347544", "山东省青岛市",
"86183033", "河北省邯郸市",
"86153274", "湖北省武汉市",
"861529930", "新疆吐鲁番地区",
"861803410", "河北省邯郸市",
"861592445", "内蒙古乌兰察布市",
"861571667", "河南省洛阳市",
"861835106", "江苏省宿迁市",
"861560786", "广西百色市",
"861522094", "广东省河源市",
"861892264", "广东省肇庆市",
"861479168", "陕西省咸阳市",
"861831863", "广东省广州市",
"861856869", "河南省信阳市",
"86152865", "贵州省毕节地区",
"861452552", "山东省莱芜市",
"861353596", "广东省清远市",
"861453626", "江苏省泰州市",
"861550680", "广西南宁市",
"861394989", "河南省漯河市",
"861559088", "黑龙江省哈尔滨市",
"861871546", "安徽省合肥市",
"861453229", "浙江省衢州市",
"861815032", "福建省龙岩市",
"861314729", "湖北省孝感市",
"861539787", "江西省赣州市",
"861826100", "江苏省苏州市",
"861308382", "河南省新乡市",
"861557829", "广西南宁市",
"861318323", "河南省周口市",
"861386560", "安徽省马鞍山市",
"861890860", "湖北省宜昌市",
"86188320", "河北省邯郸市",
"861320477", "内蒙古鄂尔多斯市",
"861333900", "安徽省滁州市",
"86177422", "天津市",
"861323779", "广西来宾市",
"861530833", "四川省绵阳市",
"861457190", "浙江省台州市",
"861452320", "河南省郑州市",
"861300427", "浙江省湖州市",
"861588929", "广东省深圳市",
"861339882", "云南省德宏傣族景颇族自治州",
"861772221", "广东省潮州市",
"861886020", "河南省商丘市",
"861519437", "山东省泰安市",
"861303729", "江西省九江市",
"861371718", "广东省东莞市",
"861869303", "甘肃省临夏回族自治州",
"861538208", "辽宁省沈阳市",
"86183545", "山东省烟台市",
"861477804", "广东省佛山市",
"861310539", "山东省临沂市",
"861323901", "新疆喀什地区",
"861899599", "湖北省武汉市",
"861320967", "宁夏中卫市",
"861533262", "陕西省榆林市",
"861333587", "浙江省温州市",
"861835803", "浙江省金华市",
"861850415", "辽宁省丹东市",
"861500949", "甘肃省酒泉市",
"861572676", "西藏那曲地区",
"861394810", "内蒙古呼和浩特市",
"86137449", "吉林省长春市",
"861538725", "湖北省十堰市",
"861570528", "江苏省镇江市",
"861387198", "湖北省黄冈市",
"861382481", "广东省湛江市",
"86138448", "吉林省长春市",
"861360708", "江西省南昌市",
"861783957", "河南省南阳市",
"861853309", "河北省石家庄市",
"861854658", "黑龙江省大庆市",
"861525442", "山东省淄博市",
"861360225", "广东省东莞市",
"861559796", "贵州省毕节地区",
"861479700", "青海省西宁市",
"861860575", "浙江省绍兴市",
"86139693", "山东省淄博市",
"86153530", "陕西省宝鸡市",
"861358297", "河北省张家口市",
"861316985", "广东省中山市",
"8615026", "上海市",
"861310792", "福建省福州市",
"861569453", "黑龙江省牡丹江市",
"861539931", "陕西省渭南市",
"861899732", "青海省海东地区",
"861539493", "云南省曲靖市",
"86182208", "陕西省西安市",
"861527205", "湖北省黄石市",
"861824081", "陕西省延安市",
"861773181", "河北省邢台市",
"861575607", "安徽省淮北市",
"861809933", "新疆阿克苏地区",
"861331041", "贵州省遵义市",
"861809491", "新疆乌鲁木齐市",
"861350852", "贵州省遵义市",
"861774804", "四川省泸州市",
"861847154", "湖北省孝感市",
"861771383", "四川省南充市",
"861770658", "浙江省台州市",
"861503685", "河南省平顶山市",
"861572069", "江苏省无锡市",
"86634", "山东省莱芜市",
"861779050", "四川省南充市",
"861332534", "陕西省商洛市",
"86159463", "黑龙江省牡丹江市",
"861301145", "河北省邢台市",
"861880329", "河北省邢台市",
"86186446", "上海市",
"861452189", "吉林省松原市",
"86131011", "重庆市",
"861454871", "四川省成都市",
"861840480", "内蒙古呼伦贝尔市",
"861769835", "河南省周口市",
"86187730", "湖南省岳阳市",
"861595417", "山东省聊城市",
"861592950", "陕西省汉中市",
"861510473", "内蒙古乌海市",
"861781774", "广东省清远市",
"861502936", "陕西省汉中市",
"861539877", "云南省玉溪市",
"861322623", "广东省湛江市",
"86131412", "北京市",
"861893509", "山西省运城市",
"86183697", "山东省济宁市",
"861520482", "内蒙古兴安盟",
"86178810", "新疆喀什地区",
"86186767", "广东省深圳市",
"861329433", "吉林省延边朝鲜族自治州",
"861586402", "山东省济南市",
"861528327", "四川省内江市",
"861339772", "广西柳州市",
"861589284", "四川省乐山市",
"861863393", "河北省石家庄市",
"861312546", "辽宁省大连市",
"86132317", "河北省沧州市",
"861522448", "山东省日照市",
"861855859", "福建省泉州市",
"861588135", "四川省宜宾市",
"86135026", "广东省揭阳市",
"861862456", "辽宁省营口市",
"861866080", "山东省济南市",
"861454937", "江苏省苏州市",
"861859399", "广西北海市",
"861826111", "江苏省宿迁市",
"861832496", "安徽省安庆市",
"861566741", "陕西省宝鸡市",
"861844742", "内蒙古通辽市",
"86151886", "河北省保定市",
"861369445", "吉林省通化市",
"861333911", "安徽省六安市",
"861705368", "广东省深圳市",
"861356829", "四川省甘孜藏族自治州",
"861331823", "广东省河源市",
"861501437", "广东省茂名市",
"86135007", "辽宁省大连市",
"861519861", "云南省怒江傈僳族自治州",
"861381516", "江苏省镇江市",
"861329157", "浙江省金华市",
"861533403", "湖北省荆门市",
"861845440", "山东省淄博市",
"861478408", "河南省濮阳市",
"861397286", "湖北省荆门市",
"861560876", "云南省文山壮族苗族自治州",
"861818363", "云南省红河哈尼族彝族自治州",
"861823842", "河南省南阳市",
"861801240", "江苏省徐州市",
"86152531", "山东省济南市",
"861580726", "湖北省荆门市",
"861390820", "四川省成都市",
"86181240", "广东省深圳市",
"861831997", "广东省东莞市",
"861766618", "广东省佛山市",
"86170826", "湖北省荆门市",
"861803769", "河南省郑州市",
"861800467", "黑龙江省鸡西市",
"861590241", "辽宁省营口市",
"861803401", "河北省石家庄市",
"86177021", "上海市",
"86130563", "江苏省扬州市",
"861843261", "河北省石家庄市",
"861333087", "四川省德阳市",
"861479031", "安徽省六安市",
"861840207", "广东省茂名市",
"861888291", "四川省阿坝藏族羌族自治州",
"861475727", "浙江省温州市",
"861479711", "山西省朔州市",
"861878417", "四川省广安市",
"861829547", "宁夏银川市",
"861853434", "山西省晋中市",
"861376803", "广西桂林市",
"861310719", "湖南省邵阳市",
"861529079", "河南省平顶山市",
"861313417", "辽宁省营口市",
"861509029", "河南省许昌市",
"861310039", "湖南省邵阳市",
"861800977", "青海省海西蒙古族藏族自治州",
"861454781", "山东省济南市",
"861313281", "广西南宁市",
"861882368", "广东省河源市",
"86176120", "广东省广州市",
"861501856", "广东省湛江市",
"861572430", "辽宁省辽阳市",
"861860389", "河南省焦作市",
"861521243", "安徽省合肥市",
"86130228", "陕西省西安市",
"861771147", "四川省宜宾市",
"861304281", "湖北省襄樊市",
"86182258", "安徽省合肥市",
"861812038", "湖北省荆门市",
"861560598", "福建省三明市",
"861885140", "江苏省镇江市",
"861812718", "广东省云浮市",
"861571845", "广东省佛山市",
"861821150", "广东省茂名市",
"86134601", "河南省商丘市",
"861811933", "甘肃省平凉市",
"861810420", "辽宁省鞍山市",
"861323910", "陕西省咸阳市",
"86139280", "广东省珠海市",
"861858441", "贵州省贵阳市",
"861360342", "河南省驻马店市",
"861811491", "江苏省苏州市",
"861812156", "江苏省苏州市",
"861530558", "安徽省阜阳市",
"861346925", "湖南省岳阳市",
"861510963", "宁夏吴忠市",
"861326728", "广东省东莞市",
"86159793", "江西省上饶市",
"86183646", "山东省潍坊市",
"861332714", "内蒙古兴安盟",
"861529666", "山西省晋城市",
"861339990", "新疆克拉玛依市",
"861533572", "湖北省宜昌市",
"861380285", "广东省肇庆市",
"861362421", "辽宁省沈阳市",
"861331541", "河北省保定市",
"861393396", "河北省秦皇岛市",
"86187542", "山东省青岛市",
"861362388", "河南省洛阳市",
"861369631", "山东省威海市",
"861309247", "江苏省宿迁市",
"86147803", "四川省资阳市",
"861555640", "安徽省六安市",
"861591644", "广东省阳江市",
"861380369", "黑龙江省双鸭山市",
"861572569", "山东省枣庄市",
"86136442", "辽宁省大连市",
"861529269", "新疆和田地区",
"861869751", "安徽省蚌埠市",
"861364478", "内蒙古巴彦淖尔市",
"861317045", "湖南省怀化市",
"861887232", "湖北省武汉市",
"861829972", "新疆乌鲁木齐市",
"861827383", "湖南省娄底市",
"86130672", "福建省福州市",
"861860918", "陕西省榆林市",
"861337859", "贵州省黔西南布依族苗族自治州",
"861839791", "江西省南昌市",
"861390481", "黑龙江省哈尔滨市",
"861390328", "河北省衡水市",
"86187123", "安徽省六安市",
"861841982", "甘肃省庆阳市",
"861800542", "山东省青岛市",
"861556106", "内蒙古通辽市",
"861872003", "江西省宜春市",
"861306935", "河南省新乡市",
"86157026", "山西省晋城市",
"86185386", "河南省周口市",
"861359294", "广东省揭阳市",
"861361681", "浙江省杭州市",
"861537478", "内蒙古巴彦淖尔市",
"861532692", "内蒙古包头市",
"861597446", "湖南省湘潭市",
"861802588", "广东省汕头市",
"861534899", "西藏拉萨市",
"861818706", "云南省昆明市",
"86184799", "江西省萍乡市",
"861871908", "广东省惠州市",
"861516545", "山东省烟台市",
"861580950", "宁夏银川市",
"861576829", "广东省茂名市",
"861366305", "河南省南阳市",
"86134562", "浙江省嘉兴市",
"861580631", "山东省威海市",
"861897199", "湖北省鄂州市",
"861379588", "四川省遂宁市",
"86157007", "湖南省长沙市",
"861362919", "陕西省铜川市",
"861705860", "广东省广州市",
"861569369", "甘肃省白银市",
"861317250", "广东省汕头市",
"861770377", "河南省南阳市",
"861838112", "四川省广安市",
"861573096", "甘肃省临夏回族自治州",
"86152788", "广西柳州市",
"861569285", "四川省眉山市",
"861535869", "江苏省淮安市",
"861321797", "江西省赣州市",
"861762522", "江苏省常州市",
"86183879", "云南省普洱市",
"861508425", "辽宁省本溪市",
"861893220", "江苏省南通市",
"861334537", "新疆克孜勒苏柯尔克孜自治州",
"861341949", "四川省内江市",
"861505134", "江苏省盐城市",
"861533947", "甘肃省嘉峪关市",
"861325638", "山东省烟台市",
"86184281", "四川省成都市",
"86180575", "浙江省绍兴市",
"861389598", "黑龙江省齐齐哈尔市",
"86189600", "福建省漳州市",
"861859936", "新疆巴音郭楞蒙古自治州",
"861346367", "河北省承德市",
"861311503", "江苏省南京市",
"86186875", "云南省昆明市",
"861521892", "广东省佛山市",
"861453511", "山东省济南市",
"861362880", "云南省西双版纳傣族自治州",
"861874998", "河南省驻马店市",
"861308998", "黑龙江省哈尔滨市",
"861330727", "湖北省襄樊市",
"861318332", "河南省平顶山市",
"861588400", "四川省凉山彝族自治州",
"861538784", "江西省赣州市",
"86155645", "山东省烟台市",
"861335958", "黑龙江省鹤岗市",
"861530822", "四川省成都市",
"861555101", "安徽省滁州市",
"861509487", "山东省淄博市",
"861707171", "江西省吉安市",
"861524097", "云南省丽江市",
"861343519", "广东省江门市",
"861850568", "安徽省亳州市",
"861531517", "山东省济宁市",
"861594549", "黑龙江省牡丹江市",
"861810881", "云南省昆明市",
"861315563", "安徽省宣城市",
"861775173", "江苏省徐州市",
"861785588", "浙江省金华市",
"861350028", "广东省江门市",
"861700755", "广东省深圳市",
"861815954", "福建省龙岩市",
"861478649", "湖南省永州市",
"861593273", "河北省沧州市",
"861776871", "江苏省泰州市",
"861833030", "河北省唐山市",
"861458486", "山东省淄博市",
"861511374", "广东省潮州市",
"861318895", "山东省青岛市",
"861351845", "四川省宜宾市",
"861566668", "山东省青岛市",
"86189155", "江苏省苏州市",
"861873895", "河南省开封市",
"861537968", "宁夏中卫市",
"861882860", "四川省雅安市",
"86134313", "广东省东莞市",
"861316924", "广东省梅州市",
"86150244", "浙江省杭州市",
"861770746", "湖南省永州市",
"861321483", "内蒙古鄂尔多斯市",
"861369726", "湖北省荆州市",
"861316053", "广东省阳江市",
"861301615", "湖南省益阳市",
"861894267", "河北省廊坊市",
"861311472", "广西柳州市",
"861324707", "江西省赣州市",
"861300152", "山东省滨州市",
"861303593", "云南省怒江傈僳族自治州",
"861514624", "黑龙江省齐齐哈尔市",
"861364968", "云南省昭通市",
"861787510", "广东省韶关市",
"861389876", "辽宁省营口市",
"861834443", "广东省清远市",
"861303178", "山东省淄博市",
"861867628", "广东省东莞市",
"861314178", "内蒙古巴彦淖尔市",
"861893165", "河北省廊坊市",
"861324315", "河南省南阳市",
"861352569", "河南省南阳市",
"861880264", "广东省东莞市",
"861826641", "山东省济南市",
"861309962", "云南省西双版纳傣族自治州",
"861589225", "四川省广元市",
"861816143", "四川省达州市",
"861332952", "黑龙江省齐齐哈尔市",
"861800042", "河北省保定市",
"861452828", "四川省眉山市",
"86155597", "云南省昆明市",
"861336478", "新疆乌鲁木齐市",
"861554349", "吉林省长春市",
"861362992", "新疆乌鲁木齐市",
"86180676", "浙江省金华市",
"861510614", "江苏省常州市",
"861317545", "浙江省台州市",
"861589708", "青海省西宁市",
"861815841", "浙江省杭州市",
"861890368", "黑龙江省佳木斯市",
"861780548", "山东省泰安市",
"861365244", "广东省深圳市",
"861521819", "广东省湛江市",
"861770484", "内蒙古包头市",
"861802088", "福建省福州市",
"86135382", "广东省深圳市",
"86189779", "广西北海市",
"86170790", "浙江省杭州市",
"861516045", "福建省莆田市",
"86150772", "广西柳州市",
"861351667", "广东省惠州市",
"861453500", "山东省青岛市",
"861837495", "湖南省长沙市",
"861777150", "湖北省咸宁市",
"861399763", "湖北省荆州市",
"861816474", "云南省红河哈尼族彝族自治州",
"861840543", "山东省滨州市",
"861811922", "新疆伊犁哈萨克自治州",
"861302805", "山西省晋城市",
"861536859", "云南省普洱市",
"861392369", "广东省河源市",
"86184566", "安徽省池州市",
"861309503", "新疆乌鲁木齐市",
"861846218", "山东省烟台市",
"861370680", "浙江省舟山市",
"861354738", "四川省自贡市",
"861471581", "广东省广州市",
"861334305", "河北省唐山市",
"861864834", "内蒙古阿拉善盟",
"86138080", "四川省成都市",
"861453731", "湖南省长沙市",
"861775786", "浙江省宁波市",
"86189650", "福建省福州市",
"861534812", "四川省自贡市",
"861776937", "湖南省益阳市",
"861532619", "辽宁省抚顺市",
"861334717", "内蒙古包头市",
"861366537", "山东省济宁市",
"861598478", "四川省达州市",
"861532216", "广东省云浮市",
"861830767", "广东省深圳市",
"861593902", "河南省郑州市",
"861880574", "浙江省宁波市",
"861771617", "四川省宜宾市",
"86155449", "河北省保定市",
"861589160", "陕西省铜川市",
"861327557", "安徽省宿州市",
"861787501", "广东省湛江市",
"861350528", "江苏省镇江市",
"861894577", "黑龙江省双鸭山市",
"861816846", "江苏省徐州市",
"861859660", "福建省厦门市",
"861514703", "内蒙古通辽市",
"861825249", "江苏省南通市",
"861376675", "黑龙江省伊春市",
"861388903", "西藏山南地区",
"861343739", "广东省东莞市",
"861315063", "云南省大理白族自治州",
"861760607", "福建省福州市",
"861459090", "广东省韶关市",
"86158941", "新疆伊犁哈萨克自治州",
"861359948", "福建省莆田市",
"861588411", "四川省宜宾市",
"861778949", "甘肃省天水市",
"861316553", "河北省张家口市",
"861810771", "广西南宁市",
"86158424", "辽宁省大连市",
"861453987", "广东省清远市",
"861573878", "河南省漯河市",
"861816964", "广西南宁市",
"861368549", "山东省临沂市",
"861315273", "山西省阳泉市",
"861817155", "湖北省孝感市",
"861776781", "吉林省白山市",
"861869766", "安徽省阜阳市",
"861305549", "福建省南平市",
"861309472", "浙江省温州市",
"861319615", "吉林省通化市",
"861512986", "陕西省汉中市",
"861570852", "贵州省遵义市",
"861362770", "广西防城港市",
"861538874", "云南省曲靖市",
"861322632", "广东省惠州市",
"861521980", "广东省韶关市",
"861375928", "云南省西双版纳傣族自治州",
"861331395", "福建省莆田市",
"861329422", "湖北省十堰市",
"86155546", "山东省东营市",
"861509374", "河南省焦作市",
"861361355", "山西省长治市",
"861866443", "广东省中山市",
"861373459", "黑龙江省大庆市",
"861787645", "广东省河源市",
"861310648", "浙江省台州市",
"861508218", "四川省绵阳市",
"861806111", "江苏省徐州市",
"861502594", "甘肃省庆阳市",
"861453569", "贵州省遵义市",
"861856308", "山东省潍坊市",
"861868813", "广东省中山市",
"861810960", "安徽省滁州市",
"861366407", "内蒙古包头市",
"861315232", "陕西省咸阳市",
"861569564", "安徽省六安市",
"861770475", "内蒙古通辽市",
"861881216", "河北省廊坊市",
"861864515", "黑龙江省鹤岗市",
"861319040", "辽宁省锦州市",
"86177456", "黑龙江省哈尔滨市",
"86183692", "山东省枣庄市",
"861830644", "山东省济南市",
"861322673", "广东省佛山市",
"86138300", "甘肃省白银市",
"861309433", "云南省昭通市",
"861302623", "江西省鹰潭市",
"861771257", "江苏省泰州市",
"861510423", "辽宁省朝阳市",
"861781724", "广东省珠海市",
"86132312", "河北省保定市",
"86170802", "广东省深圳市",
"861301540", "山西省太原市",
"861339722", "湖北省荆州市",
"86187596", "福建省漳州市",
"861857847", "广东省东莞市",
"861580776", "广西百色市",
"861390870", "云南省昭通市",
"861556458", "山东省威海市",
"86177559", "安徽省黄山市",
"86155153", "河南省洛阳市",
"861705017", "山东省青岛市",
"861818416", "贵州省铜仁地区",
"86150531", "山东省济南市",
"861554044", "内蒙古乌兰察布市",
"861373416", "山西省吕梁市",
"86158379", "河南省洛阳市",
"861820467", "黑龙江省鸡西市",
"861319255", "广东省阳江市",
"861872433", "黑龙江省黑河市",
"861814842", "四川省绵阳市",
"86136599", "新疆乌鲁木齐市",
"861453430", "辽宁省鞍山市",
"861872991", "陕西省渭南市",
"861350915", "陕西省安康市",
"86135618", "山东省威海市",
"861845899", "浙江省绍兴市",
"86188498", "云南省昭通市",
"861332167", "广西贵港市",
"86157378", "河南省开封市",
"861459326", "四川省泸州市",
"861882981", "陕西省延安市",
"861356879", "四川省阿坝藏族羌族自治州",
"861309157", "黑龙江省鸡西市",
"861560826", "四川省绵阳市",
"86178558", "浙江省宁波市",
"861392300", "广东省梅州市",
"861383438", "山西省运城市",
"861476341", "山东省莱芜市",
"861512850", "河北省秦皇岛市",
"861811047", "安徽省阜阳市",
"86135451", "湖北省武汉市",
"861870595", "福建省泉州市",
"861521856", "广东省潮州市",
"861761446", "吉林省白城市",
"861351744", "湖南省张家界市",
"861859609", "山东省济南市",
"861318794", "云南省红河哈尼族彝族自治州",
"86132228", "江苏省无锡市",
"861458667", "湖南省郴州市",
"861518360", "四川省甘孜藏族自治州",
"861501243", "广东省广州市",
"861894489", "江苏省宿迁市",
"861586523", "山东省滨州市",
"861831241", "广东省广州市",
"861589109", "陕西省商洛市",
"861386165", "江苏省淮安市",
"861868758", "云南省保山市",
"861590997", "新疆阿克苏地区",
"861352364", "河南省南阳市",
"861809547", "宁夏银川市",
"861805116", "江苏省泰州市",
"86131683", "广东省广州市",
"861317601", "山东省济南市",
"861880585", "浙江省绍兴市",
"861820977", "青海省海西蒙古族藏族自治州",
"861887563", "河北省承德市",
"861386694", "安徽省滁州市",
"861357625", "江西省南昌市",
"861533522", "江苏省无锡市",
"861532656", "黑龙江省双鸭山市",
"861346975", "湖北省恩施土家族苗族自治州",
"861326778", "广东省汕头市",
"861532259", "广东省汕头市",
"861472706", "浙江省绍兴市",
"861538885", "云南省昭通市",
"861882017", "广东省深圳市",
"861516610", "山东省德州市",
"86187547", "山东省济宁市",
"861593688", "河南省三门峡市",
"861566083", "河南省新乡市",
"861534583", "浙江省嘉兴市",
"861580347", "山西省朔州市",
"861362471", "内蒙古呼和浩特市",
"861314910", "陕西省咸阳市",
"861700854", "贵州省黔南布依族苗族自治州",
"861360565", "安徽省合肥市",
"861804581", "黑龙江省鹤岗市",
"861378581", "河北省沧州市",
"861533350", "山西省忻州市",
"861886939", "云南省昆明市",
"861810470", "内蒙古呼伦贝尔市",
"861588030", "福建省莆田市",
"861770965", "安徽省蚌埠市",
"861340819", "四川省达州市",
"861303910", "吉林省长春市",
"86157387", "河南省安阳市",
"861569064", "河南省洛阳市",
"861853699", "山西省忻州市",
"861343556", "广东省潮州市",
"861331783", "广西桂林市",
"861319540", "安徽省亳州市",
"86185027", "湖北省武汉市",
"861509651", "云南省文山壮族苗族自治州",
"861509930", "新疆塔城地区",
"861879704", "青海省海东地区",
"861358941", "山东省滨州市",
"861311991", "新疆乌鲁木齐市",
"861532661", "黑龙江省哈尔滨市",
"861337113", "山东省枣庄市",
"861839653", "福建省福州市",
"861839490", "甘肃省武威市",
"861390780", "广西防城港市",
"86133696", "新疆乌鲁木齐市",
"86136766", "浙江省台州市",
"86170852", "江苏省苏州市",
"861352987", "云南省曲靖市",
"861846425", "山东省滨州市",
"8618862", "江苏省苏州市",
"861567407", "湖南省郴州市",
"86186492", "天津市",
"861824743", "内蒙古乌兰察布市",
"86182316", "河北省廊坊市",
"861869450", "浙江省嘉兴市",
"86138350", "山西省忻州市",
"86139431", "吉林省长春市",
"861862921", "陕西省延安市",
"861526806", "浙江省衢州市",
"86187769", "广西南宁市",
"861804917", "陕西省宝鸡市",
"861700941", "广东省佛山市",
"86155718", "湖北省恩施土家族苗族自治州",
"861353934", "广东省佛山市",
"861883446", "山西省运城市",
"861557879", "广西北海市",
"861318373", "四川省凉山彝族自治州",
"861838586", "贵州省铜仁地区",
"861314779", "吉林省辽源市",
"86159896", "广东省东莞市",
"861768517", "贵州省毕节地区",
"861300477", "浙江省台州市",
"861528484", "四川省自贡市",
"86155171", "河南省郑州市",
"861709521", "江苏省盐城市",
"86187695", "山东省聊城市",
"86177509", "福建省泉州市",
"861705517", "浙江省杭州市",
"861323729", "湖北省荆门市",
"86177427", "辽宁省盘锦市",
"861320427", "辽宁省盘锦市",
"861813917", "新疆和田地区",
"861843843", "河南省漯河市",
"861775132", "江苏省南通市",
"861453676", "陕西省延安市",
"861518142", "四川省广元市",
"861357458", "湖南省怀化市",
"861454543", "新疆哈密地区",
"861569274", "贵州省贵阳市",
"861351486", "内蒙古赤峰市",
"86156565", "安徽省合肥市",
"861767114", "湖北省十堰市",
"86150865", "贵州省黔西南布依族苗族自治州",
"86145069", "上海市",
"861569300", "甘肃省临夏回族自治州",
"861705809", "河北省石家庄市",
"861453279", "山西省阳泉市",
"861856742", "河南省安阳市",
"861768809", "广东省河源市",
"86153569", "浙江省金华市",
"86137908", "广东省汕头市",
"861586023", "福建省漳州市",
"861830830", "四川省泸州市",
"861570578", "浙江省丽水市",
"861811547", "江苏省南京市",
"861556625", "辽宁省鞍山市",
"861767338", "湖南省娄底市",
"86151783", "安徽省蚌埠市",
"861361457", "黑龙江省大兴安岭地区",
"86131290", "广东省佛山市",
"861509579", "甘肃省白银市",
"861314901", "广东省清远市",
"861457095", "江苏省南通市",
"861343271", "广东省清远市",
"861519243", "山东省济宁市",
"861857194", "湖北省黄冈市",
"86138909", "四川省宜宾市",
"861520949", "甘肃省天水市",
"861337816", "四川省绵阳市",
"861538775", "江西省九江市",
"861303901", "吉林省长春市",
"861384654", "黑龙江省黑河市",
"861315688", "山东省青岛市",
"861531860", "山东省淄博市",
"861331497", "福建省泉州市",
"861850683", "浙江省杭州市",
"86182849", "四川省广元市",
"861573552", "山西省太原市",
"861809047", "四川省成都市",
"861806768", "浙江省舟山市",
"861340007", "江苏省南京市",
"861887273", "湖北省黄冈市",
"861534083", "山西省长治市",
"861810636", "山东省潍坊市",
"861843146", "河北省廊坊市",
"861819150", "陕西省渭南市",
"861372047", "陕西省榆林市",
"861523366", "河北省廊坊市",
"861321145", "广西玉林市",
"861363331", "河北省石家庄市",
"861454821", "广东省佛山市",
"861880379", "河南省洛阳市",
"861554102", "辽宁省营口市",
"86170723", "重庆市",
"8633", "河北省秦皇岛市",
"861362956", "宁夏石嘴山市",
"861504740", "内蒙古包头市",
"861588530", "贵州省毕节地区",
"861340335", "河北省唐山市",
"861527778", "广西河池市",
"861860525", "江苏省镇江市",
"861709843", "浙江省金华市",
"861833411", "贵州省安顺市",
"861317610", "山东省菏泽市",
"86180208", "福建省三明市",
"861551408", "河南省焦作市",
"86159133", "广东省中山市",
"861897798", "广西南宁市",
"861522660", "河北省沧州市",
"861332996", "湖北省鄂州市",
"861360065", "浙江省温州市",
"861804081", "新疆乌鲁木齐市",
"861509176", "陕西省西安市",
"861512996", "陕西省安康市",
"861500971", "青海省西宁市",
"861521990", "广东省茂名市",
"861868019", "广东省中山市",
"861348825", "陕西省延安市",
"861375333", "山西省阳泉市",
"861537610", "山东省菏泽市",
"861331385", "福建省厦门市",
"861598601", "广东省河源市",
"861529541", "江苏省无锡市",
"861572241", "江苏省宿迁市",
"861346994", "湖北省黄冈市",
"861855974", "福建省龙岩市",
"861331269", "云南省丽江市",
"861804562", "黑龙江省哈尔滨市",
"861769244", "河北省承德市",
"861777010", "江西省赣州市",
"861802786", "广东省汕尾市",
"861895400", "山东省东营市",
"861303083", "福建省莆田市",
"861830973", "青海省黄南藏族自治州",
"861768962", "福建省南平市",
"861580852", "贵州省遵义市",
"861813562", "河南省漯河市",
"861776791", "吉林省吉林市",
"861364610", "江苏省镇江市",
"861373508", "浙江省衢州市",
"86151647", "内蒙古乌兰察布市",
"861868592", "贵州省遵义市",
"861882472", "广东省中山市",
"861511497", "陕西省宝鸡市",
"861354716", "四川省广元市",
"861535688", "浙江省宁波市",
"861311860", "广东省潮州市",
"861318775", "云南省丽江市",
"861846236", "山东省菏泽市",
"861339243", "广东省深圳市",
"861870574", "浙江省宁波市",
"861524587", "黑龙江省伊春市",
"861324262", "广东省肇庆市",
"861328356", "山西省晋城市",
"861534901", "甘肃省甘南藏族自治州",
"861894702", "内蒙古呼伦贝尔市",
"861562831", "内蒙古呼和浩特市",
"861354158", "四川省泸州市",
"8615791", "北京市",
"861551354", "山西省晋中市",
"861454849", "广东省深圳市",
"861452642", "江苏省常州市",
"86157941", "浙江省杭州市",
"861331079", "贵州省黔西南布依族苗族自治州",
"86159960", "江苏省泰州市",
"861777501", "安徽省六安市",
"861877688", "广西南宁市",
"86155448", "河北省邯郸市",
"861813903", "新疆昌吉回族自治州",
"861479455", "黑龙江省绥化市",
"861705503", "海南省海口市",
"861399977", "新疆博尔塔拉蒙古自治州",
"86131569", "山东省烟台市",
"861367779", "广西北海市",
"861808371", "江苏省泰州市",
"86137237", "广东省深圳市",
"861555245", "山东省烟台市",
"861590569", "安徽省合肥市",
"861470352", "山西省大同市",
"861889805", "西藏昌都地区",
"861782019", "广东省茂名市",
"8613570", "广东省广州市",
"861854548", "黑龙江省伊春市",
"861839871", "四川省自贡市",
"861841919", "甘肃省天水市",
"861882962", "陕西省榆林市",
"861529823", "四川省南充市",
"861470520", "江苏省徐州市",
"861343159", "广东省珠海市",
"861370453", "黑龙江省牡丹江市",
"861370690", "福建省南平市",
"861471591", "广东省梅州市",
"86137080", "四川省成都市",
"861814357", "贵州省毕节地区",
"861479940", "新疆阿克苏地区",
"861889414", "甘肃省天水市",
"861538373", "河北省石家庄市",
"861328734", "山东省泰安市",
"861379098", "广东省湛江市",
"861524900", "陕西省西安市",
"861556560", "河南省焦作市",
"861786937", "云南省临沧市",
"861850766", "广东省云浮市",
"86134284", "广东省东莞市",
"861590430", "吉林省长春市",
"861817015", "江西省鹰潭市",
"86156617", "内蒙古鄂尔多斯市",
"86189778", "广西河池市",
"861860660", "浙江省宁波市",
"861770548", "山东省泰安市",
"861819867", "贵州省黔南布依族苗族自治州",
"861869068", "新疆巴音郭楞蒙古自治州",
"861830463", "黑龙江省哈尔滨市",
"86139395", "河南省漯河市",
"86151696", "山东省潍坊市",
"861801431", "江苏省常州市",
"86183887", "云南省昭通市",
"861357270", "陕西省渭南市",
"861709549", "江苏省无锡市",
"861323741", "湖南省长沙市",
"861340013", "河北省张家口市",
"861556439", "山东省淄博市",
"861340733", "湖南省株洲市",
"861527611", "新疆喀什地区",
"861531433", "山东省东营市",
"86182932", "甘肃省定西市",
"861845231", "江苏省盐城市",
"861362982", "河南省三门峡市",
"861561630", "湖南省衡阳市",
"86180937", "甘肃省酒泉市",
"861700929", "山东省青岛市",
"86181792", "江西省九江市",
"861529041", "河南省郑州市",
"861893684", "江苏省宿迁市",
"861844563", "黑龙江省黑河市",
"861831626", "广东省云浮市",
"861860936", "甘肃省张掖市",
"861571234", "辽宁省沈阳市",
"861829780", "安徽省淮北市",
"861831229", "广东省肇庆市",
"861534910", "陕西省咸阳市",
"861344954", "山东省济南市",
"861894348", "吉林省松原市",
"861506331", "山东省日照市",
"861458496", "山东省烟台市",
"861892190", "江苏省扬州市",
"86139883", "云南省临沧市",
"861318885", "山东省潍坊市",
"861321931", "四川省巴中市",
"861804062", "湖北省黄石市",
"861868807", "广东省汕尾市",
"861500456", "黑龙江省黑河市",
"861511176", "青海省海南藏族自治州",
"861313522", "湖南省永州市",
"86177275", "广东省深圳市",
"861550285", "四川省宜宾市",
"861587675", "广东省汕尾市",
"86153683", "云南省红河哈尼族彝族自治州",
"861810891", "西藏拉萨市",
"861839937", "新疆和田地区",
"861459580", "陕西省咸阳市",
"861360294", "广东省清远市",
"861884998", "云南省临沧市",
"861330254", "广东省茂名市",
"861850751", "广东省韶关市",
"861362890", "西藏拉萨市",
"861356573", "新疆石河子市",
"861316816", "广东省云浮市",
"861338360", "河北省秦皇岛市",
"861538794", "江西省抚州市",
"86186813", "四川省自贡市",
"861364601", "福建省厦门市",
"861321787", "广西柳州市",
"86183878", "云南省楚雄彝族自治州",
"861583096", "河北省石家庄市",
"861324403", "吉林省吉林市",
"861857020", "湖南省湘潭市",
"86150010", "北京市",
"861328361", "山西省太原市",
"861300599", "广西北海市",
"861327117", "河南省周口市",
"861570950", "宁夏银川市",
"861389588", "黑龙江省双鸭山市",
"86132485", "浙江省宁波市",
"861570631", "山东省威海市",
"861357560", "浙江省舟山市",
"861479628", "广西北海市",
"861539255", "山西省长治市",
"861700135", "天津市",
"861322298", "江苏省苏州市",
"861897189", "湖北省恩施土家族苗族自治州",
"861379598", "四川省宜宾市",
"861760424", "辽宁省本溪市",
"861527600", "新疆和田地区",
"861379444", "广东省广州市",
"861470020", "安徽省六安市",
"86152789", "广西北海市",
"861350726", "湖北省荆州市",
"861569295", "四川省绵阳市",
"86151595", "福建省泉州市",
"861476180", "江苏省常州市",
"861300012", "天津市",
"861869568", "福建省厦门市",
"86188123", "云南省曲靖市",
"861300732", "湖南省湘潭市",
"861361691", "福建省龙岩市",
"861330423", "辽宁省抚顺市",
"861532682", "内蒙古兴安盟",
"861331930", "江西省上饶市",
"861315811", "贵州省遵义市",
"861319827", "四川省德阳市",
"861802598", "广东省佛山市",
"861808214", "江苏省宿迁市",
"86184798", "江西省赣州市",
"861539040", "四川省成都市",
"861819993", "新疆石河子市",
"861802173", "江苏省扬州市",
"861535232", "甘肃省定西市",
"861820696", "云南省大理白族自治州",
"861555322", "山东省青岛市",
"861881908", "广东省东莞市",
"86159369", "河南省周口市",
"861450232", "河北省张家口市",
"86181462", "贵州省毕节地区",
"86136717", "上海市",
"861508906", "西藏那曲地区",
"86180362", "江苏省扬州市",
"861772082", "福建省莆田市",
"861358135", "湖北省荆门市",
"86158026", "湖南省长沙市",
"861839781", "江西省南昌市",
"861390491", "辽宁省朝阳市",
"861565906", "福建省泉州市",
"861590676", "浙江省台州市",
"861530648", "山东省青岛市",
"861390933", "甘肃省平凉市",
"861524911", "陕西省延安市",
"861841992", "甘肃省定西市",
"861813091", "新疆乌鲁木齐市",
"861845901", "福建省福州市",
"861300773", "青海省海东地区",
"86177992", "新疆乌鲁木齐市",
"861870379", "河南省洛阳市",
"861550274", "湖北省孝感市",
"861774693", "河南省鹤壁市",
"86136094", "重庆市",
"861320723", "湖北省襄樊市",
"86159202", "广东省东莞市",
"861829217", "陕西省西安市",
"861511395", "广东省江门市",
"861558345", "四川省凉山彝族自治州",
"86180209", "福建省南平市",
"861877273", "湖北省荆门市",
"86136952", "广东省佛山市",
"861318874", "山东省聊城市",
"861805271", "江苏省常州市",
"861367093", "广东省佛山市",
"861375155", "广东省惠州市",
"861539615", "福建省莆田市",
"861332986", "湖北省襄樊市",
"861804091", "新疆乌鲁木齐市",
"86157970", "湖北省武汉市",
"861303668", "四川省成都市",
"861450273", "内蒙古乌海市",
"861894412", "江苏省南京市",
"861802132", "江苏省扬州市",
"861535273", "新疆石河子市",
"861552870", "四川省宜宾市",
"861534093", "山西省吕梁市",
"861365602", "福建省厦门市",
"861592915", "陕西省安康市",
"861390972", "青海省海东地区",
"861840849", "宁夏吴忠市",
"861779735", "青海省海西蒙古族藏族自治州",
"861893675", "江苏省淮安市",
"861596309", "山东省日照市",
"861335939", "甘肃省酒泉市",
"861779015", "四川省凉山彝族自治州",
"861535063", "河北省唐山市",
"861311737", "湖南省益阳市",
"861457085", "江苏省徐州市",
"86185454", "黑龙江省佳木斯市",
"861880095", "四川省巴中市",
"861361818", "四川省乐山市",
"86138908", "四川省南充市",
"861334703", "内蒙古呼伦贝尔市",
"861576954", "宁夏固原市",
"861338309", "河北省邢台市",
"861394855", "内蒙古通辽市",
"861315698", "山东省淄博市",
"861331487", "内蒙古呼和浩特市",
"861850450", "黑龙江省哈尔滨市",
"86182848", "四川省宜宾市",
"861577165", "陕西省安康市",
"861583320", "河北省邯郸市",
"861580578", "浙江省丽水市",
"861309517", "新疆阿克苏地区",
"861824447", "四川省巴中市",
"861305521", "福建省厦门市",
"861808654", "湖北省十堰市",
"861567703", "广西柳州市",
"861325571", "浙江省杭州市",
"861589436", "云南省迪庆藏族自治州",
"86186927", "湖南省益阳市",
"861835694", "安徽省合肥市",
"861778921", "陕西省渭南市",
"861476024", "福建省漳州市",
"861564838", "内蒙古呼伦贝尔市",
"861351496", "安徽省合肥市",
"861318446", "浙江省台州市",
"861335570", "浙江省衢州市",
"861303812", "四川省乐山市",
"861813233", "河北省邯郸市",
"86188695", "云南省昭通市",
"861819501", "宁夏银川市",
"861532908", "贵州省六盘水市",
"861527266", "湖北省咸宁市",
"861357817", "云南省普洱市",
"861859525", "山东省济南市",
"86145068", "上海市",
"861850945", "甘肃省金昌市",
"861500419", "辽宁省辽阳市",
"861804233", "浙江省温州市",
"861389752", "青海省海东地区",
"861898143", "四川省内江市",
"861353642", "广东省湛江市",
"86187768", "广西河池市",
"861328392", "河南省鹤壁市",
"86155719", "湖北省十堰市",
"861534231", "湖北省襄樊市",
"86153223", "广东省广州市",
"861709344", "广东省佛山市",
"861337838", "四川省雅安市",
"861881682", "广东省深圳市",
"86177508", "福建省泉州市",
"861528548", "贵州省黔西南布依族苗族自治州",
"861390790", "江西省新余市",
"861839480", "甘肃省武威市",
"861774945", "河南省信阳市",
"861889704", "青海省海南藏族自治州",
"861352997", "云南省玉溪市",
"861810618", "江苏省无锡市",
"861381246", "江苏省镇江市",
"861364545", "山东省烟台市",
"861390462", "黑龙江省齐齐哈尔市",
"861336045", "广东省东莞市",
"861819010", "四川省巴中市",
"86158387", "河南省南阳市",
"861305843", "广东省广州市",
"861841961", "甘肃省兰州市",
"861377841", "四川省德阳市",
"861583189", "河北省沧州市",
"861306526", "辽宁省盘锦市",
"861819730", "青海省海东地区",
"86156372", "河南省安阳市",
"861590511", "江苏省盐城市",
"861324533", "山东省淄博市",
"861330614", "江苏省常州市",
"861356799", "浙江省湖州市",
"86138592", "福建省漳州市",
"861782061", "广东省佛山市",
"861347371", "河北省沧州市",
"861331793", "江西省上饶市",
"861512952", "陕西省榆林市",
"861570886", "云南省怒江傈僳族自治州",
"861311981", "广东省汕尾市",
"86181850", "贵州省贵阳市",
"86176390", "河南省许昌市",
"861502084", "山东省泰安市",
"861595947", "福建省三明市",
"861596434", "山东省潍坊市",
"861508236", "四川省攀枝花市",
"861561745", "河南省安阳市",
"86188547", "山东省济宁市",
"861841956", "甘肃省张掖市",
"861837964", "江西省抚州市",
"861570347", "山西省临汾市",
"861866664", "广东省潮州市",
"861847988", "江西省景德镇市",
"861820763", "广东省清远市",
"861378591", "河北省秦皇岛市",
"861776762", "新疆昌吉回族自治州",
"861337553", "山东省日照市",
"861325261", "吉林省长春市",
"861343758", "广东省茂名市",
"861323955", "宁夏中卫市",
"861396332", "山东省日照市",
"861895701", "浙江省衢州市",
"861535902", "福建省厦门市",
"861811378", "四川省宜宾市",
"86159252", "云南省普洱市",
"861334624", "山东省威海市",
"861397309", "湖南省怀化市",
"861768991", "福建省宁德市",
"861820652", "山东省枣庄市",
"861329368", "山西省朔州市",
"861531472", "浙江省台州市",
"861803628", "江苏省盐城市",
"861340772", "广西南宁市",
"861522918", "陕西省榆林市",
"861567624", "广西桂林市",
"861823678", "河南省郑州市",
"861317968", "江苏省无锡市",
"861521733", "广东省广州市",
"861331374", "福建省泉州市",
"861817640", "广西桂林市",
"861534593", "福建省莆田市",
"86188190", "广东省深圳市",
"861566093", "河南省商丘市",
"861366703", "江西省上饶市",
"861398924", "四川省凉山彝族自治州",
"861590987", "辽宁省盘锦市",
"861818438", "贵州省六盘水市",
"861373438", "山东省临沂市",
"86134624", "河南省焦作市",
"861705157", "河北省石家庄市",
"861311517", "江苏省扬州市",
"861550311", "河北省石家庄市",
"861459237", "四川省资阳市",
"861880595", "福建省泉州市",
"861386684", "安徽省铜陵市",
"861859170", "陕西省宝鸡市",
"861310822", "四川省德阳市",
"861335125", "黑龙江省绥化市",
"861870585", "浙江省绍兴市",
"861476524", "山西省太原市",
"861524479", "黑龙江省佳木斯市",
"861868561", "贵州省遵义市",
"861338434", "吉林省四平市",
"86147962", "广西柳州市",
"861311809", "四川省自贡市",
"861894499", "湖南省衡阳市",
"861510727", "湖北省襄樊市",
"861538332", "河北省保定市",
"861550564", "安徽省六安市",
"861513429", "辽宁省葫芦岛市",
"861897878", "广西贵港市",
"861309737", "江西省上饶市",
"861845889", "浙江省杭州市",
"86135619", "山东省日照市",
"861531503", "山东省东营市",
"86157379", "河南省洛阳市",
"861364250", "广东省梅州市",
"861471562", "广东省佛山市",
"861383416", "山西省太原市",
"861556509", "河南省郑州市",
"861882433", "广东省东莞市",
"861524969", "河南省郑州市",
"861882991", "广东省佛山市",
"86184517", "江苏省扬州市",
"861875250", "江苏省泰州市",
"861313947", "甘肃省嘉峪关市",
"861536838", "云南省曲靖市",
"861570776", "广西百色市",
"861335070", "四川省眉山市",
"861459124", "广西梧州市",
"861819001", "四川省绵阳市",
"861315869", "四川省德阳市",
"86181025", "广东省广州市",
"86185991", "新疆乌鲁木齐市",
"86177558", "安徽省阜阳市",
"861528048", "福建省泉州市",
"861556817", "吉林省辽源市",
"861362608", "福建省泉州市",
"861567290", "湖北省荆门市",
"86187498", "河南省开封市",
"861805138", "江苏省南通市",
"86130898", "黑龙江省牡丹江市",
"86158378", "河南省开封市",
"86136598", "湖北省武汉市",
"861872981", "陕西省延安市",
"861336545", "山东省烟台市",
"861780475", "内蒙古通辽市",
"861300186", "河北省邯郸市",
"861871216", "安徽省安庆市",
"861317478", "浙江省台州市",
"861560914", "陕西省商洛市",
"861309981", "云南省红河哈尼族彝族自治州",
"861341921", "四川省广元市",
"861777645", "广西柳州市",
"861837143", "湖北省黄石市",
"861575474", "内蒙古乌兰察布市",
"861890422", "辽宁省鞍山市",
"861871619", "四川省宜宾市",
"861858911", "西藏拉萨市",
"861500760", "广东省中山市",
"861354759", "四川省南充市",
"861571904", "新疆哈密地区",
"861376220", "湖南省湘潭市",
"86188596", "福建省漳州市",
"861502584", "甘肃省定西市",
"861575143", "江苏省徐州市",
"861860609", "福建省厦门市",
"861333635", "山东省聊城市",
"861345842", "四川省甘孜藏族自治州",
"861537045", "江苏省南通市",
"861590011", "广东省汕尾市",
"86456", "黑龙江省黑河市",
"86137300", "河北省邯郸市",
"861351177", "江苏省宿迁市",
"861590731", "湖南省长沙市",
"861830932", "甘肃省定西市",
"861576841", "广东省广州市",
"861582000", "山东省济南市",
"861830554", "安徽省淮南市",
"861816607", "江西省赣州市",
"861778108", "四川省凉山彝族自治州",
"861304572", "浙江省湖州市",
"861350347", "河南省焦作市",
"861313572", "湖北省十堰市",
"861824062", "河南省安阳市",
"861301493", "广西柳州市",
"861839043", "湖南省益阳市",
"861519990", "新疆巴音郭楞蒙古自治州",
"861860448", "吉林省吉林市",
"861366366", "山西省晋城市",
"861323583", "浙江省嘉兴市",
"861860594", "福建省莆田市",
"861330963", "安徽省芜湖市",
"861520456", "黑龙江省黑河市",
"861897204", "湖北省宜昌市",
"861327764", "湖北省荆门市",
"861831676", "广东省梅州市",
"861787555", "广东省东莞市",
"861840791", "江西省南昌市",
"8613919", "甘肃省兰州市",
"861358710", "浙江省衢州市",
"861564985", "河南省郑州市",
"861855553", "安徽省芜湖市",
"861539145", "云南省昭通市",
"861391960", "甘肃省庆阳市",
"861355964", "福建省泉州市",
"861831279", "广东省肇庆市",
"861344073", "上海市",
"861862482", "河南省开封市",
"86517", "江苏省淮安市",
"861355846", "广西南宁市",
"86182513", "江苏省南通市",
"861348785", "湖南省郴州市",
"861363103", "广东省潮州市",
"861770639", "山东省青岛市",
"861899477", "江苏省常州市",
"861886665", "山东省烟台市",
"861362449", "吉林省长春市",
"861372780", "广东省茂名市",
"861452086", "安徽省安庆市",
"86156504", "山东省临沂市",
"861329860", "湖南省常德市",
"861344263", "河北省邯郸市",
"861370311", "河北省石家庄市",
"861582511", "云南省曲靖市",
"861533281", "内蒙古呼和浩特市",
"861529497", "河南省周口市",
"861354994", "广东省中山市",
"861572166", "山西省晋城市",
"861708347", "山西省长治市",
"861330502", "福建省福州市",
"861457024", "江西省抚州市",
"861858429", "四川省南充市",
"861870953", "宁夏吴忠市",
"861504087", "辽宁省朝阳市",
"861341419", "广东省江门市",
"861533417", "湖北省荆州市",
"861813222", "河北省保定市",
"861587625", "广东省江门市",
"861476085", "江苏省连云港市",
"861382462", "广东省肇庆市",
"86155959", "海南省海口市",
"861804222", "浙江省金华市",
"861825092", "福建省宁德市",
"861370564", "安徽省六安市",
"861876396", "山东省济南市",
"861557023", "江西省九江市",
"86185668", "广东省佛山市",
"861365514", "江苏省连云港市",
"86189782", "广西来宾市",
"861760474", "内蒙古乌兰察布市",
"861308514", "湖北省武汉市",
"861580915", "陕西省安康市",
"861350776", "广西百色市",
"86138153", "江苏省徐州市",
"86150789", "广西桂林市",
"861562927", "湖北省武汉市",
"861390047", "内蒙古包头市",
"861452798", "新疆克孜勒苏柯尔克孜自治州",
"86159686", "浙江省台州市",
"861365361", "山西省临汾市",
"861320599", "福建省南平市",
"861899967", "新疆阿克苏地区",
"861376817", "广西钦州市",
"861304403", "山东省莱芜市",
"861308361", "河南省许昌市",
"861313403", "江西省抚州市",
"86158618", "江苏省常州市",
"861353112", "广东省湛江市",
"86187885", "云南省昆明市",
"861780327", "河北省沧州市",
"86158002", "广东省广州市",
"861576712", "广东省深圳市",
"861339861", "河北省石家庄市",
"861345031", "广东省韶关市",
"861501882", "广东省中山市",
"861302851", "陕西省西安市",
"86136712", "北京市",
"861330144", "江苏省扬州市",
"861478354", "河南省焦作市",
"861812182", "四川省南充市",
"861857260", "湖北省荆州市",
"861800696", "福建省漳州市",
"861821867", "广东省广州市",
"861364391", "河南省焦作市",
"861597323", "湖南省湘潭市",
"861528906", "西藏那曲地区",
"861334351", "湖北省荆州市",
"861846494", "山东省临沂市",
"861532546", "浙江省湖州市",
"861567351", "湖南省郴州市",
"861810148", "江苏省南通市",
"861561426", "河北省邢台市",
"861843638", "河南省南阳市",
"861536330", "广东省肇庆市",
"861351904", "甘肃省庆阳市",
"861360670", "浙江省杭州市",
"861522075", "广东省江门市",
"861363806", "贵州省黔东南苗族侗族自治州",
"861320732", "湖南省湘潭市",
"86181132", "四川省凉山彝族自治州",
"861896363", "江苏省南京市",
"861822598", "安徽省宿州市",
"861572863", "广东省中山市",
"861786543", "山东省滨州市",
"861319877", "四川省广安市",
"86155300", "河北省邯郸市",
"861372657", "广东省韶关市",
"861356841", "四川省德阳市",
"861828214", "四川省巴中市",
"861330473", "内蒙古乌海市",
"861785826", "浙江省台州市",
"861370274", "广东省佛山市",
"86153011", "北京市",
"861839543", "陕西省渭南市",
"861822786", "四川省乐山市",
"861334366", "河南省三门峡市",
"861338252", "江苏省苏州市",
"861334685", "河南省周口市",
"861856902", "湖南省衡阳市",
"861813345", "安徽省滁州市",
"86151642", "辽宁省鞍山市",
"861879866", "贵州省遵义市",
"861370300", "广东省珠海市",
"861804345", "吉林省四平市",
"861582500", "云南省临沧市",
"861807774", "广西玉林市",
"861305292", "江苏省镇江市",
"861888839", "山东省菏泽市",
"861346536", "山东省潍坊市",
"861511041", "山西省太原市",
"86527", "江苏省宿迁市",
"861520971", "青海省西宁市",
"861327331", "河北省衡水市",
"861825019", "福建省福州市",
"861319493", "四川省宜宾市",
"861500921", "陕西省延安市",
"861501990", "广东省中山市",
"861509126", "陕西省宝鸡市",
"861330897", "西藏阿里地区",
"861319931", "黑龙江省大兴安岭地区",
"861700701", "广东省佛山市",
"86181746", "湖南省永州市",
"861310058", "广西河池市",
"861371559", "广东省中山市",
"861890991", "新疆乌鲁木齐市",
"861530792", "江西省九江市",
"861509541", "甘肃省兰州市",
"861855924", "福建省南平市",
"861891920", "甘肃省天水市",
"861470939", "甘肃省酒泉市",
"861821645", "湖南省娄底市",
"861890433", "吉林省延边朝鲜族自治州",
"861700469", "北京市",
"861478516", "贵州省铜仁地区",
"861361310", "河北省邯郸市",
"861560663", "浙江省温州市",
"861536985", "河北省衡水市",
"861531247", "江苏省镇江市",
"861326390", "江西省宜春市",
"86156554", "安徽省淮南市",
"861880341", "山西省太原市",
"861454653", "云南省保山市",
"861454490", "湖北省孝感市",
"861582011", "广东省韶关市",
"86150854", "贵州省遵义市",
"86158473", "内蒙古赤峰市",
"86187393", "河南省濮阳市",
"861843282", "河北省保定市",
"861330002", "重庆市",
"861356954", "河南省开封市",
"861829820", "安徽省马鞍山市",
"86131893", "广东省肇庆市",
"861454762", "山东省东营市",
"861809870", "安徽省宿州市",
"861452586", "福建省漳州市",
"861335396", "河南省驻马店市",
"861358701", "浙江省衢州市",
"86155909", "黑龙江省佳木斯市",
"861318725", "湖南省郴州市",
"861554654", "黑龙江省绥化市",
"861550808", "四川省广元市",
"861700530", "山东省菏泽市",
"861882422", "广东省东莞市",
"861339856", "贵州省铜仁地区",
"861812059", "湖北省武汉市",
"861313262", "广西柳州市",
"861304262", "辽宁省鞍山市",
"861308356", "江苏省南通市",
"861335184", "黑龙江省大庆市",
"861530539", "山东省临沂市",
"861890157", "江苏省苏州市",
"861318208", "江苏省无锡市",
"861458127", "安徽省六安市",
"861504587", "黑龙江省大庆市",
"861365356", "山西省晋城市",
"861476585", "宁夏银川市",
"861538916", "陕西省汉中市",
"861870524", "江苏省宿迁市",
"861339437", "吉林省辽源市",
"86139786", "广西南宁市",
"861509823", "山东省菏泽市",
"861358979", "山东省烟台市",
"861332627", "山东省德州市",
"861310833", "四川省乐山市",
"861571496", "新疆昌吉回族自治州",
"861470570", "浙江省衢州市",
"861506117", "江苏省盐城市",
"861308734", "湖南省衡阳市",
"861538323", "河北省石家庄市",
"861365734", "湖南省衡阳市",
"861534729", "湖北省黄石市",
"861319787", "江西省宜春市",
"861874014", "辽宁省本溪市",
"861377032", "江苏省南京市",
"861308014", "河南省漯河市",
"861577509", "广东省揭阳市",
"861865488", "山东省潍坊市",
"86137719", "江苏省苏州市",
"86137232", "河南省开封市",
"861306600", "山东省济南市",
"861341108", "广东省汕尾市",
"861847835", "湖南省湘西土家族苗族自治州",
"861808321", "贵州省铜仁地区",
"861367729", "湖北省武汉市",
"861808488", "四川省绵阳市",
"861598391", "四川省广元市",
"861811657", "四川省成都市",
"861390547", "山东省济宁市",
"861458234", "安徽省淮南市",
"861886847", "浙江省金华市",
"86130689", "广东省汕头市",
"86158994", "新疆乌鲁木齐市",
"861530970", "青海省海北藏族自治州",
"861301877", "广东省梅州市",
"861846048", "江西省宜春市",
"861337330", "河北省邯郸市",
"861303741", "湖南省湘西土家族苗族自治州",
"861520709", "江西省萍乡市",
"861572997", "新疆喀什地区",
"861366351", "山西省太原市",
"86159585", "浙江省绍兴市",
"861354248", "广东省清远市",
"86184138", "浙江省杭州市",
"86159939", "河南省商丘市",
"861302163", "山东省威海市",
"86183882", "云南省昆明市",
"86131274", "河北省保定市",
"86132366", "辽宁省沈阳市",
"86181797", "江西省赣州市",
"86180932", "甘肃省定西市",
"861521722", "广东省广州市",
"861700979", "浙江省绍兴市",
"861781795", "广东省深圳市",
"861595403", "山东省威海市",
"861557841", "广西贺州市",
"86182937", "甘肃省酒泉市",
"861867410", "湖北省孝感市",
"861773340", "河北省秦皇岛市",
"861822098", "陕西省商洛市",
"861760387", "河南省郑州市",
"86156612", "内蒙古呼和浩特市",
"861475614", "河北省石家庄市",
"861576799", "广东省惠州市",
"86155350", "山西省忻州市",
"86131136", "广东省深圳市",
"861369578", "浙江省丽水市",
"861350886", "云南省怒江傈僳族自治州",
"861582987", "陕西省宝鸡市",
"861777115", "湖北省黄石市",
"861866913", "云南省临沧市",
"861821993", "甘肃省平凉市",
"861830316", "河北省廊坊市",
"861391239", "江苏省无锡市",
"861823628", "河南省信阳市",
"861536974", "河北省秦皇岛市",
"861502918", "陕西省西安市",
"861309368", "安徽省池州市",
"86184654", "宁夏银川市",
"861700400", "广东省深圳市",
"861803678", "江苏省泰州市",
"861332358", "宁夏银川市",
"861811217", "江苏省连云港市",
"861501733", "广东省中山市",
"861399042", "四川省阿坝藏族羌族自治州",
"86188928", "四川省凉山彝族自治州",
"861362398", "河南省三门峡市",
"861814678", "江西省南昌市",
"861533707", "甘肃省甘南藏族自治州",
"861890962", "安徽省蚌埠市",
"861530761", "广东省中山市",
"861331324", "河北省保定市",
"861875140", "江苏省连云港市",
"861530409", "辽宁省辽阳市",
"861338868", "浙江省绍兴市",
"861591932", "广东省广州市",
"861560588", "浙江省杭州市",
"86188542", "山东省青岛市",
"861537140", "江苏省淮安市",
"861800763", "广东省清远市",
"861314955", "黑龙江省绥化市",
"861370369", "黑龙江省齐齐哈尔市",
"861776849", "江苏省盐城市",
"861305261", "辽宁省朝阳市",
"861303955", "内蒙古包头市",
"86159257", "浙江省丽水市",
"861334674", "河南省信阳市",
"861588755", "云南省德宏傣族景颇族自治州",
"861801115", "四川省广元市",
"861594571", "黑龙江省牡丹江市",
"861811481", "江苏省镇江市",
"861370285", "广东省佛山市",
"861533315", "河北省唐山市",
"86138645", "山东省烟台市",
"861863894", "河南省郑州市",
"861320883", "云南省临沧市",
"861763546", "山西省吕梁市",
"86136926", "广东省茂名市",
"861313291", "广西南宁市",
"861529832", "江苏省宿迁市",
"861310872", "云南省大理白族自治州",
"861335175", "黑龙江省大庆市",
"861871748", "陕西省榆林市",
"861818946", "甘肃省武威市",
"861860399", "河南省许昌市",
"861373946", "四川省成都市",
"861353798", "广东省阳江市",
"86178021", "上海市",
"861897828", "广西河池市",
"861329017", "山东省威海市",
"861894840", "广东省江门市",
"86130229", "陕西省西安市",
"861510777", "广西钦州市",
"861830359", "山西省运城市",
"861576198", "贵州省遵义市",
"861558272", "山西省临汾市",
"861890503", "福建省宁德市",
"861304291", "甘肃省临夏回族自治州",
"86147967", "江西省赣州市",
"861329737", "湖南省益阳市",
"861305071", "辽宁省阜新市",
"861304858", "贵州省遵义市",
"861512404", "辽宁省锦州市",
"861333097", "四川省凉山彝族自治州",
"861888281", "四川省雅安市",
"861312302", "福建省泉州市",
"861766636", "广东省中山市",
"861346406", "辽宁省朝阳市",
"861313858", "广东省汕头市",
"861593308", "河北省保定市",
"861584518", "黑龙江省佳木斯市",
"86155343", "山西省吕梁市",
"861508048", "福建省福州市",
"861825056", "福建省三明市",
"861398464", "贵州省六盘水市",
"861350950", "福建省南平市",
"861831987", "广东省东莞市",
"861319210", "广东省潮州市",
"861836245", "江苏省徐州市",
"861350631", "山东省威海市",
"86132898", "陕西省西安市",
"861526647", "山东省济宁市",
"86184512", "江苏省淮安市",
"861324947", "广东省东莞市",
"86156388", "河南省郑州市",
"861335020", "四川省遂宁市",
"861397296", "湖北省鄂州市",
"861459174", "内蒙古包头市",
"86170963", "黑龙江省哈尔滨市",
"861570726", "湖北省恩施土家族苗族自治州",
"861359342", "山西省吕梁市",
"861837424", "湖南省益阳市",
"861339819", "四川省成都市",
"86186044", "吉林省长春市",
"861505999", "福建省南平市",
"861527141", "湖北省十堰市",
"86134615", "河南省漯河市",
"861376270", "湖南省益阳市",
"861768247", "浙江省绍兴市",
"861893458", "江苏省苏州市",
"861345401", "浙江省衢州市",
"861510346", "山西省太原市",
"861859389", "贵州省黔南布依族苗族自治州",
"861345769", "广西桂林市",
"861365319", "河北省邢台市",
"861771774", "河北省唐山市",
"861304033", "吉林省松原市",
"861538959", "陕西省榆林市",
"86177810", "四川省泸州市",
"861308319", "安徽省合肥市",
"861554214", "辽宁省朝阳市",
"861375550", "江西省萍乡市",
"861304713", "湖北省武汉市",
"861536464", "山西省晋中市",
"861317428", "湖南省娄底市",
"861306076", "广东省佛山市",
"861780425", "辽宁省丹东市",
"861301201", "河北省唐山市",
"861847514", "广东省阳江市",
"861329981", "青海省西宁市",
"861479283", "安徽省阜阳市",
"861339507", "福建省厦门市",
"861394912", "河南省郑州市",
"861323899", "辽宁省鞍山市",
"86131055", "浙江省宁波市",
"861890472", "内蒙古包头市",
"861454213", "河南省平顶山市",
"861520760", "广东省中山市",
"861303440", "湖北省黄石市",
"861589294", "四川省泸州市",
"861341971", "河南省驻马店市",
"861336140", "山东省淄博市",
"861819115", "陕西省汉中市",
"861399542", "宁夏石嘴山市",
"861809481", "新疆巴音郭楞蒙古自治州",
"861855107", "江苏省常州市",
"861323668", "辽宁省本溪市",
"861535223", "甘肃省陇南市",
"861555333", "山东省淄博市",
"861771393", "四川省凉山彝族自治州",
"861829378", "甘肃省甘南藏族自治州",
"861840762", "广东省河源市",
"861503695", "河南省洛阳市",
"861564974", "河南省濮阳市",
"861867168", "湖北省荆州市",
"861860312", "河北省保定市",
"861503164", "河北省保定市",
"861840490", "山西省大同市",
"86138546", "山东省东营市",
"861358287", "河北省唐山市",
"861337974", "新疆喀什地区",
"861558562", "吉林省松原市",
"861316995", "广东省佛山市",
"861320773", "广西桂林市",
"861832744", "湖北省恩施土家族苗族自治州",
"861530334", "河北省秦皇岛市",
"861870329", "河北省邢台市",
"86177997", "新疆乌鲁木齐市",
"861533839", "广东省东莞市",
"86188730", "湖南省岳阳市",
"861330432", "吉林省长春市",
"861510887", "云南省丽江市",
"861318824", "辽宁省本溪市",
"86136957", "浙江省温州市",
"861824091", "新疆伊犁哈萨克自治州",
"861780658", "广东省湛江市",
"861871302", "河北省廊坊市",
"861317655", "山东省淄博市",
"861700411", "辽宁省大连市",
"861387188", "湖北省孝感市",
"86186922", "湖南省长沙市",
"861372217", "内蒙古鄂尔多斯市",
"861368571", "浙江省宁波市",
"861378447", "河北省廊坊市",
"861382491", "广东省清远市",
"861325521", "江苏省无锡市",
"86138449", "吉林省长春市",
"86159226", "重庆市",
"861305571", "福建省南平市",
"861825061", "福建省泉州市",
"86170774", "湖南省长沙市",
"861813447", "河南省漯河市",
"861810749", "湖南省长沙市",
"86185583", "浙江省嘉兴市",
"861504230", "辽宁省盘锦市",
"86158745", "湖南省怀化市",
"861363557", "安徽省宿州市",
"861571452", "黑龙江省齐齐哈尔市",
"861899589", "湖北省宜昌市",
"861580528", "江苏省镇江市",
"861583370", "河北省邢台市",
"86180848", "四川省成都市",
"861515665", "安徽省宿州市",
"86137448", "吉林省长春市",
"861348774", "湖南省株洲市",
"861587803", "广西玉林市",
"861773957", "河南省信阳市",
"861895135", "江苏省徐州市",
"861535454", "吉林省延边朝鲜族自治州",
"861539797", "江西省赣州市",
"861826276", "江苏省连云港市",
"861369852", "贵州省安顺市",
"861596699", "山东省淄博市",
"86181518", "江苏省徐州市",
"861308392", "浙江省湖州市",
"861815879", "浙江省金华市",
"861806226", "湖北省襄樊市",
"861365392", "河南省鹤壁市",
"861568912", "山东省青岛市",
"861867700", "广西防城港市",
"861523305", "河北省秦皇岛市",
"861826679", "山东省济宁市",
"861335352", "山西省大同市",
"861457180", "浙江省杭州市",
"861569757", "广东省佛山市",
"861806629", "浙江省温州市",
"861597959", "江西省抚州市",
"86131820", "江苏省扬州市",
"861595033", "江苏省盐城市",
"86134516", "江苏省苏州市",
"861876020", "福建省宁德市",
"861323812", "辽宁省辽阳市",
"861301210", "河北省邯郸市",
"861550690", "福建省福州市",
"861550453", "黑龙江省牡丹江市",
"861760485", "内蒙古兴安盟",
"861394999", "河南省周口市",
"86155080", "四川省绵阳市",
"861559098", "黑龙江省绥化市",
"861771884", "广东省湛江市",
"861520419", "辽宁省营口市",
"861327647", "山东省东营市",
"86187320", "河北省邯郸市",
"861877454", "湖南省张家界市",
"861507669", "河北省沧州市",
"86138597", "福建省泉州市",
"861899152", "陕西省安康市",
"861304533", "黑龙江省牡丹江市",
"861867531", "广东省汕头市",
"861530756", "广东省珠海市",
"861347488", "内蒙古鄂尔多斯市",
"861359708", "广西河池市",
"861308835", "四川省乐山市",
"86156377", "河南省南阳市",
"861537362", "河北省张家口市",
"861477303", "湖南省株洲市",
"861339335", "河北省秦皇岛市",
"86917", "陕西省宝鸡市",
"861560796", "江西省吉安市",
"861880637", "山东省枣庄市",
"861313533", "湖南省株洲市",
"861364362", "山西省大同市",
"861315308", "山东省菏泽市",
"861338699", "福建省南平市",
"861779110", "陕西省宝鸡市",
"861826066", "江苏省扬州市",
"861325843", "四川省绵阳市",
"861306576", "浙江省绍兴市",
"861857209", "湖北省荆州市",
"861847014", "江西省上饶市",
"86138140", "江苏省南京市",
"861305659", "四川省雅安市",
"86158382", "河南省郑州市",
"861339007", "辽宁省鞍山市",
"861338296", "江苏省连云港市",
"861390840", "湖南省岳阳市",
"861580746", "湖南省永州市",
"861334359", "湖北省十堰市",
"861886540", "山东省菏泽市",
"861823822", "河南省开封市",
"861591290", "云南省楚雄彝族自治州",
"861771234", "江苏省常州市",
"861824883", "江苏省常州市",
"861364399", "河南省南阳市",
"861377791", "浙江省金华市",
"861368793", "江西省上饶市",
"861560253", "广东省珠海市",
"861472715", "浙江省湖州市",
"861356849", "四川省巴中市",
"861306216", "福建省宁德市",
"861813604", "江苏省徐州市",
"861331843", "广东省东莞市",
"861550988", "辽宁省沈阳市",
"861800858", "贵州省六盘水市",
"861470877", "云南省玉溪市",
"861319260", "广东省云浮市",
"861567359", "湖南省邵阳市",
"86157275", "江西省宜春市",
"861707390", "河南省焦作市",
"861598312", "四川省宜宾市",
"861310678", "广东省阳江市",
"86152438", "湖南省娄底市",
"861346450", "辽宁省葫芦岛市",
"861536414", "湖南省长沙市",
"861787675", "广东省揭阳市",
"861847564", "广东省茂名市",
"861860140", "江苏省南京市",
"861585598", "安徽省芜湖市",
"861394962", "河南省新乡市",
"861805105", "江苏省扬州市",
"861458785", "湖南省衡阳市",
"861516084", "新疆吐鲁番地区",
"861309134", "河北省秦皇岛市",
"861336312", "河北省保定市",
"861520030", "湖南省岳阳市",
"861362635", "山东省聊城市",
"861861596", "山东省烟台市",
"861454263", "西藏山南地区",
"861318187", "山东省威海市",
"861844722", "内蒙古包头市",
"861521454", "黑龙江省佳木斯市",
"861313763", "河南省信阳市",
"86131414", "北京市",
"861339869", "河北省承德市",
"861345039", "广东省广州市",
"861317584", "浙江省舟山市",
"86150168", "广东省东莞市",
"861302859", "陕西省西安市",
"861874285", "新疆巴音郭楞蒙古自治州",
"861313652", "浙江省湖州市",
"861365369", "山西省临汾市",
"861301570", "福建省宁德市",
"861768754", "广西梧州市",
"861312526", "江西省吉安市",
"861709497", "浙江省台州市",
"861308369", "河南省郑州市",
"861705754", "海南省海口市",
"861810955", "宁夏中卫市",
"8618210", "北京市",
"861320591", "福建省福州市",
"861800033", "河北省秦皇岛市",
"861360550", "安徽省滁州市",
"861346945", "湖南省长沙市",
"861533289", "内蒙古巴彦淖尔市",
"86170010", "北京市",
"861370319", "河北省邢台市",
"861582519", "云南省红河哈尼族彝族自治州",
"861770631", "山东省威海市",
"861770950", "宁夏银川市",
"861558012", "湖南省岳阳市",
"861533686", "浙江省绍兴市",
"861801165", "四川省泸州市",
"861558732", "山东省济宁市",
"861580377", "河南省南阳市",
"861362441", "吉林省长春市",
"861818814", "贵州省黔南布依族苗族自治州",
"861330590", "福建省福州市",
"86187544", "山东省潍坊市",
"861560424", "辽宁省本溪市",
"861502968", "陕西省延安市",
"861885120", "江苏省常州市",
"861305487", "山东省淄博市",
"86181455", "黑龙江省哈尔滨市",
"861309318", "江苏省常州市",
"861319125", "山西省长治市",
"861571825", "广东省河源市",
"861350906", "广东省汕尾市",
"861368487", "江西省赣州市",
"861373405", "山西省临汾市",
"861810440", "吉林省长春市",
"861858388", "四川省凉山彝族自治州",
"861840532", "山东省青岛市",
"861858421", "四川省南充市",
"861360322", "河北省保定市",
"861890912", "陕西省榆林市",
"861597745", "广西南宁市",
"86181609", "福建省泉州市",
"861773086", "河南省许昌市",
"86180355", "山西省长治市",
"861341411", "广东省广州市",
"861338818", "四川省成都市",
"861386150", "江苏省无锡市",
"86185942", "广东省深圳市",
"861761476", "内蒙古赤峰市",
"86132325", "广东省中山市",
"861771127", "四川省乐山市",
"861700837", "浙江省湖州市",
"861351774", "广西梧州市",
"861570048", "四川省自贡市",
"861829527", "宁夏银川市",
"861327815", "吉林省通化市",
"861831271", "广东省湛江市",
"861452162", "河北省廊坊市",
"861881205", "河北省唐山市",
"86136921", "广东省深圳市",
"861383926", "河南省濮阳市",
"861512865", "河北省廊坊市",
"861809577", "青海省海西蒙古族藏族自治州",
"861508726", "云南省大理白族自治州",
"861572082", "江苏省南京市",
"861840799", "江西省萍乡市",
"861898796", "云南省迪庆藏族自治州",
"861329067", "河北省沧州市",
"86185528", "江苏省徐州市",
"861518355", "四川省南充市",
"861820947", "甘肃省嘉峪关市",
"861700971", "青海省西宁市",
"861815480", "新疆乌鲁木齐市",
"861554574", "黑龙江省鸡西市",
"861828085", "四川省遂宁市",
"86156323", "河北省石家庄市",
"861557849", "广西南宁市",
"861318343", "四川省绵阳市",
"861351393", "河南省濮阳市",
"861898588", "贵州省毕节地区",
"861323862", "云南省曲靖市",
"861300447", "江苏省盐城市",
"861366359", "山西省运城市",
"861512647", "云南省临沧市",
"861452340", "河南省洛阳市",
"861520701", "江西省鹰潭市",
"861303749", "湖南省永州市",
"861454198", "山西省吕梁市",
"861569244", "广东省深圳市",
"861453646", "江苏省苏州市",
"861454573", "四川省广元市",
"861391231", "江苏省常州市",
"86187048", "内蒙古兴安盟",
"86135997", "福建省泉州市",
"861780852", "贵州省遵义市",
"861568962", "山东省日照市",
"861385225", "江苏省淮安市",
"861576791", "广东省深圳市",
"861516584", "山东省淄博市",
"861347524", "山东省枣庄市",
"86153272", "湖北省武汉市",
"861520530", "山东省菏泽市",
"861364312", "河北省保定市",
"861802495", "广东省肇庆市",
"861817418", "广西桂林市",
"861534721", "湖北省黄冈市",
"861894922", "安徽省巢湖市",
"861337805", "湖南省郴州市",
"861344490", "陕西省西安市",
"861319570", "青海省海西蒙古族藏族自治州",
"861470787", "广西钦州市",
"861358971", "山东省滨州市",
"8617791", "陕西省西安市",
"861301070", "山西省太原市",
"861839829", "四川省阿坝藏族羌族自治州",
"861803782", "河南省驻马店市",
"861834432", "广东省广州市",
"861813723", "河南省南阳市",
"861598399", "四川省巴中市",
"86177941", "甘肃省甘南藏族自治州",
"861532935", "贵州省黔东南苗族侗族自治州",
"861345539", "山东省德州市",
"861537312", "河北省保定市",
"861577501", "广东省深圳市",
"861317084", "江西省赣州市",
"861505503", "安徽省滁州市",
"861353957", "广东省珠海市",
"861367721", "湖北省随州市",
"861307952", "宁夏石嘴山市",
"861808329", "贵州省黔西南布依族苗族自治州",
"86138541", "山东省济南市",
"861887243", "湖北省荆门市",
"861555948", "新疆阿克苏地区",
"861528886", "山东省济南市",
"861454402", "福建省厦门市",
"861519063", "江苏省泰州市",
"861372077", "陕西省西安市",
"861369658", "安徽省阜阳市",
"861880349", "山西省朔州市",
"861339698", "浙江省温州市",
"861800533", "山东省淄博市",
"861360050", "浙江省衢州市",
"861361434", "吉林省四平市",
"861582019", "广东省茂名市",
"861883844", "河南省商丘市",
"861819165", "陕西省西安市",
"861861788", "河北省唐山市",
"861530531", "山东省济南市",
"861390634", "山东省莱芜市",
"86181659", "广东省汕头市",
"86180305", "四川省成都市",
"861840712", "湖北省孝感市",
"8613851", "江苏省南京市",
"861867118", "湖北省十堰市",
"861860362", "黑龙江省齐齐哈尔市",
"86181405", "湖北省武汉市",
"861812051", "湖北省宜昌市",
"861831314", "云南省玉溪市",
"861368374", "河南省许昌市",
"861570548", "山东省泰安市",
"861779708", "青海省西宁市",
"861811577", "江苏省无锡市",
"861857931", "江西省上饶市",
"861515615", "安徽省合肥市",
"861591703", "广东省韶关市",
"861529282", "新疆和田地区",
"861700461", "上海市",
"861572582", "山东省淄博市",
"86181770", "广西防城港市",
"861509549", "甘肃省定西市",
"861587150", "湖北省鄂州市",
"861470931", "甘肃省兰州市",
"861320233", "广东省惠州市",
"861890999", "新疆伊犁哈萨克自治州",
"861371551", "广东省佛山市",
"861372267", "河北省邯郸市",
"861329567", "安徽省亳州市",
"86159221", "天津市",
"861538745", "湖南省怀化市",
"861530700", "江西省南昌市",
"861825011", "福建省龙岩市",
"861327339", "河北省秦皇岛市",
"861520979", "青海省海西蒙古族藏族自治州",
"861326302", "江西省九江市",
"861389143", "陕西省西安市",
"861324306", "河南省开封市",
"861898752", "云南省保山市",
"861538951", "陕西省安康市",
"86159681", "浙江省杭州市",
"861365311", "河北省石家庄市",
"861538630", "湖南省永州市",
"861358108", "山东省临沂市",
"861376867", "广西柳州市",
"861770347", "山西省临汾市",
"861308311", "安徽省马鞍山市",
"861850994", "新疆昌吉回族自治州",
"861527149", "湖北省宜昌市",
"861898663", "湖北省咸宁市",
"861505991", "福建省龙岩市",
"861576762", "广东省湛江市",
"861339811", "四川省内江市",
"861345761", "广西玉林市",
"861345409", "浙江省舟山市",
"861317265", "广东省珠海市",
"861778030", "四川省泸州市",
"861764553", "黑龙江省绥化市",
"861365564", "安徽省安庆市",
"861780268", "江苏省盐城市",
"861323891", "辽宁省朝阳市",
"861341979", "河南省开封市",
"861528445", "云南省玉溪市",
"861320272", "广东省东莞市",
"861533977", "甘肃省酒泉市",
"861308564", "浙江省嘉兴市",
"861580965", "宁夏中卫市",
"861768855", "广东省深圳市",
"861828074", "四川省自贡市",
"861301209", "河北省衡水市",
"861374953", "河南省焦作市",
"861536704", "湖南省岳阳市",
"861808953", "四川省广元市",
"861582056", "广东省珠海市",
"861775964", "福建省泉州市",
"86147955", "广西南宁市",
"861808024", "四川省绵阳市",
"861389474", "吉林省辽源市",
"861477994", "江西省赣州市",
"861329989", "青海省海东地区",
"861364448", "吉林省松原市",
"861350639", "山东省青岛市",
"861367420", "辽宁省沈阳市",
"861780078", "青海省西宁市",
"861317075", "云南省大理白族自治州",
"861336094", "广东省汕尾市",
"861776523", "广东省珠海市",
"861820522", "江苏省徐州市",
"861334554", "安徽省淮南市",
"86159265", "湖北省荆州市",
"861572813", "广东省东莞市",
"861350236", "广东省汕尾市",
"861330326", "河北省保定市",
"861594651", "黑龙江省齐齐哈尔市",
"861800572", "浙江省湖州市",
"861337623", "江苏省无锡市",
"86132674", "广东省东莞市",
"861398704", "云南省丽江市",
"861820350", "山西省忻州市",
"861567554", "安徽省淮南市",
"861510907", "新疆阿克苏地区",
"86185838", "四川省眉山市",
"86156999", "北京市",
"861515255", "江苏省淮安市",
"861857210", "湖北省荆州市",
"861396630", "安徽省六安市",
"861387207", "湖北省黄石市",
"861473577", "山西省临汾市",
"861821817", "广东省深圳市",
"861534420", "内蒙古呼伦贝尔市",
"861779109", "陕西省宝鸡市",
"861537448", "甘肃省天水市",
"861563682", "黑龙江省哈尔滨市",
"861537594", "福建省莆田市",
"86134279", "广东省深圳市",
"86153995", "安徽省宿州市",
"861830351", "山西省太原市",
"861510580", "浙江省舟山市",
"86177379", "河南省洛阳市",
"861526534", "山东省德州市",
"861313696", "黑龙江省鸡西市",
"861305079", "辽宁省辽阳市",
"861511344", "广东省河源市",
"861304299", "甘肃省平凉市",
"861558394", "四川省资阳市",
"861770776", "广西百色市",
"86183758", "重庆市",
"861313299", "广西贵港市",
"86131067", "广东省佛山市",
"86150247", "内蒙古包头市",
"861860391", "河南省焦作市",
"861311442", "湖北省黄石市",
"861504471", "内蒙古包头市",
"861304696", "福建省泉州市",
"86152963", "广西南宁市",
"86158559", "安徽省六安市",
"86152242", "山东省聊城市",
"861861320", "四川省成都市",
"861558186", "山西省晋城市",
"861507259", "湖北省孝感市",
"861834473", "江苏省泰州市",
"861303148", "河北省廊坊市",
"861458393", "福建省三明市",
"861321184", "云南省昭通市",
"86157558", "安徽省阜阳市",
"861500353", "山西省阳泉市",
"861327034", "甘肃省白银市",
"861896926", "浙江省湖州市",
"861523644", "河南省信阳市",
"861366316", "河北省廊坊市",
"861327714", "湖北省黄冈市",
"861330913", "陕西省渭南市",
"861888289", "四川省凉山彝族自治州",
"861818715", "云南省昆明市",
"861889553", "安徽省阜阳市",
"861333890", "江苏省淮安市",
"861700492", "上海市",
"861760914", "陕西省商洛市",
"861530401", "辽宁省沈阳市",
"861818035", "四川省雅安市",
"861388242", "四川省巴中市",
"861530769", "广东省东莞市",
"861580475", "内蒙古通辽市",
"861373035", "河北省秦皇岛市",
"861700760", "广东省中山市",
"861556115", "内蒙古鄂尔多斯市",
"86133360", "浙江省杭州市",
"861363850", "贵州省贵阳市",
"861771904", "河南省商丘市",
"861528950", "广西百色市",
"861525247", "江苏省南京市",
"861597844", "河南省郑州市",
"861305269", "辽宁省葫芦岛市",
"861518133", "四川省自贡市",
"861811489", "江苏省无锡市",
"861594579", "黑龙江省哈尔滨市",
"861886615", "山东省济南市",
"86476", "内蒙古赤峰市",
"861305666", "四川省成都市",
"86158456", "黑龙江省齐齐哈尔市",
"861373307", "安徽省宿州市",
"861776841", "江苏省苏州市",
"861593243", "河北省衡水市",
"861571724", "湖北省咸宁市",
"861800403", "辽宁省抚顺市",
"861368385", "河南省洛阳市",
"861869367", "甘肃省嘉峪关市",
"861340223", "山东省菏泽市",
"861380154", "江苏省苏州市",
"861597197", "湖北省武汉市",
"861363677", "陕西省渭南市",
"861867539", "广东省中山市",
"861802397", "广东省茂名市",
"861807127", "湖北省荆州市",
"861320903", "新疆和田地区",
"861827177", "湖北省孝感市",
"861319606", "吉林省吉林市",
"861879113", "陕西省延安市",
"86138234", "广东省佛山市",
"861368930", "甘肃省临夏回族自治州",
"861377490", "山东省东营市",
"861857201", "湖北省黄石市",
"86139781", "广西南宁市",
"861370356", "山西省晋城市",
"861582556", "浙江省宁波市",
"861305930", "广东省云浮市",
"86147905", "安徽省安庆市",
"861554085", "内蒙古包头市",
"861305651", "四川省巴中市",
"861515540", "安徽省淮南市",
"861764053", "辽宁省辽阳市",
"861365064", "广东省汕尾市",
"861579735", "湖北省咸宁市",
"861338691", "福建省莆田市",
"861584683", "黑龙江省双鸭山市",
"861874064", "陕西省西安市",
"861538476", "内蒙古赤峰市",
"861598448", "四川省达州市",
"861300345", "江苏省镇江市",
"861334054", "福建省三明市",
"861366554", "安徽省六安市",
"861308300", "安徽省合肥市",
"86131131", "广东省东莞市",
"861597951", "江西省宜春市",
"861806621", "浙江省金华市",
"861800072", "江西省九江市",
"861334923", "安徽省芜湖市",
"861816173", "陕西省渭南市",
"861365300", "广东省清远市",
"861336448", "吉林省长春市",
"861308274", "山东省济南市",
"861333982", "湖北省襄樊市",
"861867792", "广西南宁市",
"861874274", "新疆塔城地区",
"861596691", "山东省青岛市",
"861320562", "安徽省铜陵市",
"861875094", "福建省厦门市",
"861780578", "浙江省丽水市",
"861365274", "广东省江门市",
"861777165", "湖北省恩施土家族苗族自治州",
"861317575", "浙江省丽水市",
"861336594", "福建省莆田市",
"861339800", "西藏拉萨市",
"861815871", "浙江省杭州市",
"861767703", "广西桂林市",
"861803136", "河北省石家庄市",
"861379397", "山东省东营市",
"861566420", "河南省许昌市",
"861778701", "云南省昆明市",
"861394991", "河南省商丘市",
"861889838", "广东省中山市",
"86139299", "广东省佛山市",
"861516075", "福建省泉州市",
"861550602", "吉林省吉林市",
"86132361", "江苏省泰州市",
"861816444", "安徽省淮南市",
"861575752", "浙江省杭州市",
"861458774", "湖南省湘西土家族苗族自治州",
"86152774", "广西梧州市",
"861787684", "广东省梅州市",
"861840573", "浙江省嘉兴市",
"861530410", "辽宁省铁岭市",
"861340454", "吉林省通化市",
"86183708", "江西省赣州市",
"861855632", "安徽省芜湖市",
"861594666", "黑龙江省鸡西市",
"86151433", "吉林省延边朝鲜族自治州",
"861825069", "福建省漳州市",
"861810741", "湖南省长沙市",
"86158427", "辽宁省盘锦市",
"861519688", "四川省达州市",
"86158509", "江苏省宿迁市",
"861452957", "广东省中山市",
"861858720", "云南省大理白族自治州",
"861573848", "河南省开封市",
"861382499", "广东省阳江市",
"861325529", "江苏省南京市",
"861471604", "广东省东莞市",
"861560613", "江苏省苏州市",
"861328137", "四川省德阳市",
"861478566", "贵州省遵义市",
"86150333", "河北省唐山市",
"86183113", "北京市",
"861850248", "辽宁省锦州市",
"861836670", "山东省枣庄市",
"861327534", "山东省德州市",
"861362740", "湖南省岳阳市",
"861899581", "湖北省咸宁市",
"86153016", "上海市",
"861552027", "四川省达州市",
"861334316", "河北省廊坊市",
"861538844", "四川省成都市",
"861571603", "福建省龙岩市",
"861817160", "湖北省孝感市",
"861329801", "内蒙古赤峰市",
"86157508", "福建省福州市",
"861859655", "福建省泉州市",
"86132880", "广东省汕头市",
"861831807", "广东省揭阳市",
"861880544", "山东省德州市",
"861370734", "湖南省衡阳市",
"861780896", "西藏那曲地区",
"861881380", "广东省江门市",
"861880498", "内蒙古呼伦贝尔市",
"861370014", "辽宁省本溪市",
"861774248", "陕西省渭南市",
"861345118", "湖北省荆门市",
"861814833", "内蒙古鄂尔多斯市",
"861809489", "新疆和田地区",
"861889924", "新疆阿克苏地区",
"861818535", "贵州省遵义市",
"861328453", "黑龙江省牡丹江市",
"861538966", "陕西省宝鸡市",
"861328690", "广东省中山市",
"861816876", "江苏省徐州市",
"861479782", "江西省九江市",
"86158406", "辽宁省大连市",
"861894547", "黑龙江省七台河市",
"86176372", "河南省安阳市",
"861824099", "新疆乌鲁木齐市",
"861351785", "广西玉林市",
"86138570", "浙江省丽水市",
"861376645", "江西省上饶市",
"861589155", "陕西省安康市",
"861770886", "云南省怒江傈僳族自治州",
"861454712", "浙江省湖州市",
"861870321", "河北省石家庄市",
"861533831", "广东省佛山市",
"86156390", "河南省郑州市",
"861868626", "内蒙古鄂尔多斯市",
"861890855", "贵州省黔东南苗族侗族自治州",
"86135992", "福建省泉州市",
"861386555", "安徽省马鞍山市",
"861830703", "江西省上饶市",
"861518122", "四川省雅安市",
"861454523", "广西桂林市",
"861801439", "江苏省南通市",
"86139538", "山东省泰安市",
"861889330", "甘肃省临夏回族自治州",
"861856722", "河南省鹤壁市",
"861315335", "山东省淄博市",
"861887153", "湖北省咸宁市",
"861845239", "江苏省镇江市",
"861550356", "山西省晋城市",
"861303862", "云南省大理白族自治州",
"861321260", "湖南省湘西土家族苗族自治州",
"861339308", "河北省衡水市",
"861554524", "黑龙江省齐齐哈尔市",
"861700921", "山东省济南市",
"861760752", "广东省惠州市",
"861323749", "湖南省长沙市",
"861709541", "江苏省南京市",
"861314862", "广东省梅州市",
"861359735", "广西玉林市",
"861500701", "江西省鹰潭市",
"861315007", "甘肃省天水市",
"861760663", "广东省揭阳市",
"861326692", "广东省东莞市",
"861846445", "山东省莱芜市",
"861590561", "安徽省淮北市",
"861361612", "江苏省常州市",
"861360155", "江苏省苏州市",
"861321070", "山东省滨州市",
"861593507", "山西省晋城市",
"861340688", "山东省德州市",
"861839879", "四川省广元市",
"861300091", "吉林省长春市",
"861301020", "广东省广州市",
"86170854", "安徽省合肥市",
"861782011", "广东省茂名市",
"861808379", "江苏省扬州市",
"861367771", "广西南宁市",
"861319352", "河南省安阳市",
"861348177", "广西柳州市",
"86137594", "云南省昆明市",
"861378773", "湖南省衡阳市",
"861559397", "甘肃省白银市",
"861584705", "内蒙古赤峰市",
"861500530", "山东省菏泽市",
"861534771", "广西南宁市",
"861590314", "河北省承德市",
"861319520", "贵州省贵阳市",
"861873905", "河南省洛阳市",
"86153277", "湖北省黄冈市",
"861850406", "辽宁省锦州市",
"861347574", "山东省聊城市",
"861370602", "福建省宁德市",
"861390412", "辽宁省鞍山市",
"861819060", "四川省宜宾市",
"861841911", "甘肃省定西市",
"861355752", "广西柳州市",
"861587240", "湖北省武汉市",
"861524992", "安徽省池州市",
"861471599", "广东省湛江市",
"861343151", "广东省东莞市",
"861534909", "甘肃省甘南藏族自治州",
"861303618", "湖北省咸宁市",
"861860545", "山东省烟台市",
"861894462", "黑龙江省绥化市",
"861846950", "云南省文山壮族苗族自治州",
"861381337", "江苏省南京市",
"861521563", "安徽省宣城市",
"86182305", "湖南省益阳市",
"86177415", "辽宁省丹东市",
"861871898", "广东省云浮市",
"861504720", "内蒙古包头市",
"861562839", "广东省东莞市",
"861847690", "广东省深圳市",
"861592965", "陕西省商洛市",
"861894790", "内蒙古锡林郭勒盟",
"861869925", "新疆哈密地区",
"861779065", "黑龙江省牡丹江市",
"86186901", "新疆乌鲁木齐市",
"861336206", "浙江省丽水市",
"861777509", "安徽省阜阳市",
"861331071", "贵州省铜仁地区",
"861539194", "安徽省芜湖市",
"861310455", "黑龙江省绥化市",
"861820533", "山东省淄博市",
"861829267", "陕西省西安市",
"861301175", "山东省德州市",
"861351603", "辽宁省沈阳市",
"861569154", "陕西省宝鸡市",
"861539386", "云南省保山市",
"861337632", "山东省枣庄市",
"86135508", "四川省绵阳市",
"861553535", "山西省太原市",
"861772997", "安徽省六安市",
"861835115", "江苏省泰州市",
"861309567", "浙江省绍兴市",
"861550734", "湖南省衡阳市",
"861529549", "江苏省徐州市",
"861572249", "江苏省淮安市",
"861521902", "广东省韶关市",
"861331261", "云南省楚雄彝族自治州",
"861362597", "福建省泉州市",
"861868731", "云南省昆明市",
"861388477", "山东省枣庄市",
"861572646", "山东省潍坊市",
"861500979", "青海省海西蒙古族藏族自治州",
"861847137", "湖北省恩施土家族苗族自治州",
"861809027", "四川省广安市",
"861805011", "福建省厦门市",
"861598609", "广东省佛山市",
"861306302", "福建省漳州市",
"861877013", "江西省宜春市",
"861868011", "广东省汕头市",
"86185015", "江苏省苏州市",
"861829077", "新疆石河子市",
"861305324", "安徽省宣城市",
"861560387", "河南省许昌市",
"861535013", "江西省九江市",
"861898914", "四川省巴中市",
"861311067", "福建省漳州市",
"86158065", "山东省青岛市",
"861325374", "河南省许昌市",
"861848534", "贵州省安顺市",
"861571785", "湖北省襄樊市",
"86147715", "广东省广州市",
"861361868", "湖北省宜昌市",
"861776799", "吉林省白城市",
"861556645", "辽宁省朝阳市",
"861811527", "江苏省宿迁市",
"861577115", "湖北省荆州市",
"861459346", "四川省凉山彝族自治州",
"861315819", "贵州省黔西南布依族苗族自治州",
"861453082", "安徽省合肥市",
"861782000", "广东省茂名市",
"861343863", "四川省广安市",
"861454954", "江苏省徐州市",
"861337288", "辽宁省本溪市",
"861356762", "浙江省丽水市",
"861820858", "贵州省六盘水市",
"861361699", "福建省南平市",
"861471512", "广东省深圳市",
"861564288", "辽宁省锦州市",
"861823872", "河南省商丘市",
"861348496", "陕西省延安市",
"861524919", "陕西省西安市",
"861821220", "贵州省遵义市",
"861839789", "江西省萍乡市",
"861390499", "辽宁省辽阳市",
"861804883", "四川省南充市",
"861325793", "江西省上饶市",
"861801304", "江苏省南京市",
"861533104", "北京市",
"861879643", "江苏省徐州市",
"861367881", "山东省济南市",
"861841900", "甘肃省甘南藏族自治州",
"861570639", "山东省青岛市",
"86152168", "上海市",
"861781744", "广东省广州市",
"861302643", "陕西省延安市",
"86188591", "福建省福州市",
"861324652", "广东省湛江市",
"861328285", "浙江省绍兴市",
"86183694", "山东省临沂市",
"861593007", "河北省邢台市",
"861335210", "辽宁省鞍山市",
"861508347", "河南省信阳市",
"861324763", "广东省深圳市",
"861312576", "吉林省白城市",
"861853836", "河南省洛阳市",
"86132314", "河北省承德市",
"861300591", "广西南宁市",
"861894203", "湖南省湘西土家族苗族自治州",
"861328369", "山西省朔州市",
"861772166", "江苏省常州市",
"861301520", "内蒙古呼和浩特市",
"861339742", "湖南省湘潭市",
"86170804", "广东省深圳市",
"861819560", "青海省西宁市",
"86150438", "吉林省松原市",
"861527692", "新疆哈密地区",
"861522478", "河南省商丘市",
"861787625", "广东省肇庆市",
"861560964", "安徽省六安市",
"861310628", "浙江省丽水市",
"861897181", "湖北省咸宁市",
"861863486", "山西省晋中市",
"861319020", "辽宁省丹东市",
"861329134", "江苏省常州市",
"861501454", "广东省韶关市",
"86151338", "河北省承德市",
"861347074", "安徽省芜湖市",
"861369475", "内蒙古赤峰市",
"861593335", "河北省秦皇岛市",
"861329318", "河北省秦皇岛市",
"861844990", "新疆塔城地区",
"861813186", "河北省邢台市",
"861522968", "陕西省宝鸡市",
"861780915", "陕西省安康市",
"861571875", "云南省保山市",
"861319175", "河北省唐山市",
"861302995", "黑龙江省牡丹江市",
"861378394", "河南省周口市",
"861317918", "吉林省四平市",
"861560474", "内蒙古乌兰察布市",
"861575914", "福建省漳州市",
"861868000", "广东省佛山市",
"861459777", "新疆和田地区",
"861360372", "河南省安阳市",
"86170789", "浙江省温州市",
"86182355", "山西省长治市",
"861590556", "安徽省安庆市",
"861393483", "山西省朔州市",
"861810899", "西藏拉萨市",
"861369965", "四川省广安市",
"861363358", "山西省吕梁市",
"861533542", "山东省青岛市",
"861334932", "黑龙江省七台河市",
"861306748", "福建省泉州市",
"86135558", "辽宁省沈阳市",
"861866614", "广东省珠海市",
"861333398", "河南省三门峡市",
"861853457", "山西省太原市",
"86186951", "宁夏银川市",
"861560143", "江苏省泰州市",
"861580327", "河北省沧州市",
"861850759", "广东省湛江市",
"861392154", "江苏省无锡市",
"861309277", "湖北省黄石市",
"861508776", "云南省昭通市",
"861809527", "宁夏银川市",
"861528726", "云南省西双版纳傣族自治州",
"861315980", "黑龙江省哈尔滨市",
"861831221", "广东省揭阳市",
"86145375", "湖南省长沙市",
"861889985", "广东省深圳市",
"861553035", "河北省唐山市",
"861309067", "内蒙古锡林郭勒盟",
"861529049", "河南省安阳市",
"861357645", "江西省萍乡市",
"861332057", "云南省曲靖市",
"86151729", "湖北省恩施土家族苗族自治州",
"861550514", "江苏省苏州市",
"861800947", "甘肃省嘉峪关市",
"861524880", "内蒙古阿拉善盟",
"861321939", "四川省宜宾市",
"861761426", "辽宁省大连市",
"86185947", "重庆市",
"861340232", "四川省自贡市",
"86137098", "辽宁省沈阳市",
"861811027", "安徽省芜湖市",
"861868364", "四川省德阳市",
"861586543", "山东省滨州市",
"861772863", "广东省江门市",
"86131425", "江苏省常州市",
"861395720", "浙江省舟山市",
"861311567", "黑龙江省大庆市",
"861450513", "吉林省四平市",
"861771177", "湖南省长沙市",
"861501223", "云南省丽江市",
"861862854", "陕西省安康市",
"861390702", "江西省九江市",
"861841969", "甘肃省陇南市",
"861882912", "陕西省榆林市",
"861374574", "黑龙江省大兴安岭地区",
"861325930", "陕西省延安市",
"861377849", "四川省资阳市",
"861571393", "河南省濮阳市",
"861316851", "广东省江门市",
"861895456", "山东省烟台市",
"861556510", "河南省开封市",
"861590807", "山东省日照市",
"861311989", "广东省佛山市",
"861357730", "云南省红河哈尼族彝族自治州",
"861363627", "湖北省恩施土家族苗族自治州",
"861477716", "广西北海市",
"861300903", "吉林省四平市",
"861521232", "安徽省黄山市",
"861398673", "湖北省荆州市",
"86136186", "湖北省武汉市",
"861853172", "河北省沧州市",
"861807177", "湖北省襄樊市",
"861356791", "浙江省宁波市",
"861584804", "内蒙古乌兰察布市",
"861369484", "江西省抚州市",
"861871600", "河北省秦皇岛市",
"861500411", "辽宁省大连市",
"86135384", "广东省东莞市",
"861887892", "广西柳州市",
"861473027", "河北省承德市",
"861336936", "甘肃省张掖市",
"861858992", "广西南宁市",
"861367636", "山东省潍坊市",
"861569382", "甘肃省兰州市",
"86130361", "湖北省武汉市",
"861536673", "江苏省泰州市",
"861360333", "河北省沧州市",
"861847808", "湖南省郴州市",
"861893555", "青海省西宁市",
"861341135", "广东省珠海市",
"861855414", "山东省潍坊市",
"861819509", "宁夏银川市",
"861335787", "江苏省连云港市",
"86150774", "广西梧州市",
"861320345", "山西省长治市",
"861589245", "四川省南充市",
"861806182", "江苏省镇江市",
"861328300", "河南省周口市",
"861334973", "湖北省荆州市",
"861810083", "四川省成都市",
"861800022", "江西省九江市",
"861452848", "甘肃省天水市",
"861355088", "四川省泸州市",
"86188188", "广东省广州市",
"861860610", "江苏省泰州市",
"861826621", "山东省青岛市",
"861820072", "广东省梅州市",
"861534239", "湖北省黄冈市",
"861819817", "贵州省毕节地区",
"861317525", "浙江省绍兴市",
"861300562", "广东省湛江市",
"861830413", "辽宁省抚顺市",
"861365224", "广东省珠海市",
"861869738", "河南省许昌市",
"861877882", "广西柳州市",
"861308224", "辽宁省葫芦岛市",
"861554329", "吉林省松原市",
"86151691", "山东省济南市",
"861581894", "广东省茂名市",
"861355796", "广西玉林市",
"861338301", "河北省石家庄市",
"86151163", "湖南省长沙市",
"86139828", "四川省达州市",
"861839188", "陕西省宝鸡市",
"861380244", "广东省广州市",
"861768912", "西藏日喀则地区",
"861309801", "陕西省安康市",
"861550835", "四川省雅安市",
"861858770", "广西防城港市",
"86158422", "辽宁省鞍山市",
"861315856", "四川省攀枝花市",
"861868069", "广东省深圳市",
"86189510", "江苏省南京市",
"861778929", "陕西省宝鸡市",
"861537660", "山东省烟台市",
"861327996", "新疆巴音郭楞蒙古自治州",
"861319184", "河北省石家庄市",
"861305529", "福建省福州市",
"861560485", "黑龙江省绥化市",
"861308137", "辽宁省本溪市",
"86181066", "浙江省宁波市",
"861890336", "河北省保定市",
"861532778", "湖北省荆州市",
"861325579", "浙江省金华市",
"86152333", "河北省唐山市",
"86176377", "河南省南阳市",
"861350548", "山东省泰安市",
"861804099", "新疆伊犁哈萨克自治州",
"861805279", "江苏省宿迁市",
"861816826", "江苏省扬州市",
"86157946", "天津市",
"861550392", "河南省鹤壁市",
"861870371", "河南省郑州市",
"861813099", "新疆伊犁哈萨克自治州",
"861760796", "江西省吉安市",
"861863845", "河南省南阳市",
"86153628", "广东省东莞市",
"861352582", "河南省安阳市",
"861310357", "山西省临汾市",
"86130880", "四川省成都市",
"861840841", "宁夏银川市",
"86187480", "内蒙古赤峰市",
"861335650", "广东省湛江市",
"861354766", "四川省眉山市",
"861311810", "四川省德阳市",
"861596301", "山东省青岛市",
"861335931", "甘肃省兰州市",
"86136580", "四川省成都市",
"861365690", "福建省三明市",
"861827234", "湖北省随州市",
"861889974", "广东省东莞市",
"861324212", "广东省佛山市",
"861308690", "贵州省安顺市",
"861308453", "河北省秦皇岛市",
"861554180", "辽宁省阜新市",
"861380998", "新疆克孜勒苏柯尔克孜自治州",
"861850536", "山东省潍坊市",
"861303891", "陕西省安康市",
"861373130", "河北省张家口市",
"861320222", "广东省揭阳市",
"861762542", "江苏省苏州市",
"861328564", "安徽省六安市",
"861871611", "四川省泸州市",
"861300272", "山东省烟台市",
"861858919", "西藏拉萨市",
"86131289", "广东省深圳市",
"861458603", "湖北省鄂州市",
"861808074", "四川省广元市",
"861374074", "辽宁省营口市",
"861340902", "山东省日照市",
"861309989", "云南省玉溪市",
"861818130", "四川省凉山彝族自治州",
"861843605", "河南省安阳市",
"861760588", "浙江省杭州市",
"861314258", "江苏省扬州市",
"861535772", "安徽省马鞍山市",
"861304306", "福建省漳州市",
"861860601", "福建省福州市",
"861576849", "广东省茂名市",
"861369377", "河南省南阳市",
"861590739", "湖南省邵阳市",
"86134564", "浙江省台州市",
"861354751", "四川省广安市",
"861313306", "山西省晋城市",
"86135275", "重庆市",
"861335877", "辽宁省丹东市",
"861303258", "江苏省宿迁市",
"861807496", "广西梧州市",
"861364936", "甘肃省张掖市",
"861564673", "山东省济宁市",
"861800350", "山西省忻州市",
"861840954", "宁夏固原市",
"861332806", "江苏省南通市",
"861819009", "四川省德阳市",
"861776198", "江苏省扬州市",
"861556501", "河南省商丘市",
"86158021", "上海市",
"861845881", "浙江省温州市",
"861818697", "湖北省荆门市",
"861882999", "广东省广州市",
"861899743", "青海省黄南藏族自治州",
"861534470", "海南省海口市",
"861524961", "河南省安阳市",
"861776573", "广东省珠海市",
"861317025", "安徽省合肥市",
"861872989", "陕西省商洛市",
"861367470", "内蒙古呼伦贝尔市",
"861809942", "新疆伊犁哈萨克自治州",
"861567202", "湖北省黄石市",
"861337673", "广东省潮州市",
"861566636", "山东省淄博市",
"861810583", "浙江省嘉兴市",
"861800522", "江苏省徐州市",
"861537936", "甘肃省张掖市",
"861315861", "四川省泸州市",
"861390348", "山西省运城市",
"861330376", "河南省信阳市",
"86130674", "福建省福州市",
"861820572", "浙江省湖州市",
"861834423", "广东省阳江市",
"861813732", "河南省开封市",
"861367960", "四川省乐山市",
"861550319", "河北省邢台市",
"861561916", "陕西省汉中市",
"861366463", "黑龙江省牡丹江市",
"861475590", "安徽省淮北市",
"861503644", "河南省周口市",
"861520353", "山西省阳泉市",
"861307034", "新疆吐鲁番地区",
"861804012", "辽宁省大连市",
"861378732", "湖南省湘潭市",
"861552577", "山西省吕梁市",
"861867648", "广东省珠海市",
"8613366", "北京市",
"861317170", "河北省沧州市",
"86189249", "广东省中山市",
"861311801", "四川省宜宾市",
"861872810", "四川省内江市",
"861506534", "山东省德州市",
"861453813", "四川省成都市",
"861351825", "四川省达州市",
"861570906", "新疆阿勒泰地区",
"861596310", "山东省济南市",
"861894491", "湖南省益阳市",
"861861370", "河南省洛阳市",
"86150242", "广东省佛山市",
"861316944", "广东省清远市",
"86131062", "浙江省金华市",
"86150963", "湖南省株洲市",
"861770726", "湖北省黄石市",
"861886483", "山东省泰安市",
"861594529", "黑龙江省鹤岗市",
"861325269", "吉林省白山市",
"861508950", "广东省汕尾市",
"861505247", "江苏省南通市",
"861316866", "广东省珠海市",
"861338310", "河北省邯郸市",
"861768999", "福建省福州市",
"861565950", "福建省泉州市",
"861568247", "四川省乐山市",
"861309810", "陕西省咸阳市",
"861571774", "广西梧州市",
"861535990", "福建省龙岩市",
"861815043", "福建省莆田市",
"861325666", "山东省济南市",
"861378599", "河北省秦皇岛市",
"861350048", "辽宁省阜新市",
"861532888", "四川省南充市",
"861450990", "新疆克拉玛依市",
"861580425", "辽宁省大连市",
"861868430", "吉林省长春市",
"861877990", "江西省萍乡市",
"861330747", "湖南省衡阳市",
"86156428", "辽宁省葫芦岛市",
"861778135", "四川省宜宾市",
"861474560", "黑龙江省黑河市",
"861476544", "山东省济南市",
"861891283", "江苏省镇江市",
"861352314", "河南省商丘市",
"861310842", "四川省广安市",
"861335145", "黑龙江省绥化市",
"861848358", "四川省雅安市",
"86152460", "黑龙江省大庆市",
"861558242", "山西省晋中市",
"86147964", "江西省抚州市",
"861350475", "吉林省吉林市",
"861782863", "四川省广安市",
"86135456", "湖北省荆州市",
"861351257", "江苏省徐州市",
"861315990", "黑龙江省双鸭山市",
"861398944", "浙江省金华市",
"861352561", "河南省濮阳市",
"861327850", "吉林省四平市",
"861473634", "广西防城港市",
"86185402", "辽宁省沈阳市",
"861536866", "云南省德宏傣族景颇族自治州",
"861829702", "青海省海东地区",
"86134622", "河南省新乡市",
"86150130", "广东省广州市",
"86151728", "湖北省恩施土家族苗族自治州",
"861597235", "湖北省黄石市",
"86183310", "河北省保定市",
"861314960", "黑龙江省哈尔滨市",
"86184657", "江西省南昌市",
"86153062", "江苏省苏州市",
"861567644", "广西贺州市",
"861536944", "河北省沧州市",
"861392356", "广东省揭阳市",
"861588492", "四川省广安市",
"861555109", "安徽省马鞍山市",
"86135559", "辽宁省大连市",
"861363714", "安徽省安庆市",
"861708475", "内蒙古包头市",
"861803648", "江苏省常州市",
"861472687", "四川省南充市",
"861333388", "河南省洛阳市",
"861814648", "新疆阿克苏地区",
"861588760", "云南省西双版纳傣族自治州",
"861770915", "陕西省安康市",
"86156193", "陕西省西安市",
"861478641", "湖南省张家界市",
"861329754", "湖北省孝感市",
"861570327", "河北省石家庄市",
"861525860", "浙江省台州市",
"861776879", "江苏省镇江市",
"861302985", "黑龙江省哈尔滨市",
"86181017", "上海市",
"861813384", "河北省石家庄市",
"861343511", "广东省韶关市",
"861707179", "江西省鹰潭市",
"86170788", "浙江省杭州市",
"861594541", "黑龙江省佳木斯市",
"861810889", "云南省德宏傣族景颇族自治州",
"86177451", "黑龙江省哈尔滨市",
"861527171", "湖北省鄂州市",
"861705277", "广东省广州市",
"861527682", "新疆乌鲁木齐市",
"86150439", "吉林省白山市",
"861535861", "江苏省镇江市",
"861510376", "河南省信阳市",
"861317936", "江苏省泰州市",
"861517673", "河北省唐山市",
"861507546", "河北省廊坊市",
"861897191", "湖北省十堰市",
"861580639", "山东省青岛市",
"861576821", "广东省惠州市",
"861520755", "广东省深圳市",
"86151339", "河北省唐山市",
"86187591", "福建省福州市",
"861569361", "甘肃省张掖市",
"86189432", "吉林省吉林市",
"861362911", "陕西省延安市",
"861508268", "四川省广安市",
"86153791", "甘肃省定西市",
"861306046", "陕西省汉中市",
"86130735", "山西省太原市",
"861336525", "江苏省宿迁市",
"861478435", "河南省开封市",
"861810910", "陕西省西安市",
"861323420", "辽宁省铁岭市",
"861805863", "浙江省嘉兴市",
"861341941", "四川省乐山市",
"861569514", "江苏省扬州市",
"861890442", "吉林省吉林市",
"861521800", "广东省河源市",
"861503202", "河北省邯郸市",
"861303470", "内蒙古锡林郭勒盟",
"861801106", "四川省德阳市",
"861515877", "浙江省衢州市",
"861376055", "广东省揭阳市",
"861533306", "山西省运城市",
"861896697", "陕西省榆林市",
"861508078", "湖南省湘潭市",
"861348486", "陕西省咸阳市",
"861366830", "四川省德阳市",
"861813893", "广东省佛山市",
"861337851", "贵州省贵阳市",
"861459473", "陕西省铜川市",
"861390489", "黑龙江省大庆市",
"861839799", "江西省萍乡市",
"861559143", "陕西省商洛市",
"861325783", "广西来宾市",
"861804893", "四川省乐山市",
"861865595", "安徽省合肥市",
"861869759", "安徽省宿州市",
"861599900", "新疆巴音郭楞蒙古自治州",
"861534258", "湖北省鄂州市",
"86145313", "天津市",
"861534891", "西藏拉萨市",
"861453092", "山西省阳泉市",
"861705067", "上海市",
"86153289", "四川省达州市",
"86150536", "山东省潍坊市",
"861807667", "广西钦州市",
"861337298", "辽宁省丹东市",
"861459144", "广西百色市",
"861373466", "青海省西宁市",
"861398163", "四川省雅安市",
"861361689", "浙江省金华市",
"861820417", "辽宁省营口市",
"861368541", "山东省济南市",
"861378477", "河北省廊坊市",
"86151930", "甘肃省白银市",
"861560397", "河南省三门峡市",
"861342828", "广东省江门市",
"861887013", "江西省赣州市",
"861305541", "福建省福州市",
"86152790", "江西省新余市",
"861571795", "江西省宜春市",
"861869406", "湖北省武汉市",
"861776789", "吉林省长春市",
"861895482", "山东省枣庄市",
"861337866", "广东省深圳市",
"861778941", "甘肃省甘南藏族自治州",
"861300917", "吉林省吉林市",
"861588419", "四川省泸州市",
"861325176", "吉林省白城市",
"861810779", "广西北海市",
"861530357", "山西省临汾市",
"86170777", "上海市",
"861813477", "河南省商丘市",
"86155570", "浙江省宁波市",
"86185452", "黑龙江省黑河市",
"861772987", "四川省成都市",
"861359155", "辽宁省抚顺市",
"861373451", "黑龙江省双鸭山市",
"861812505", "广东省云浮市",
"861470615", "江苏省无锡市",
"861598170", "新疆石河子市",
"861589978", "广东省深圳市",
"861362587", "浙江省温州市",
"861576043", "四川省绵阳市",
"861583340", "河北省邯郸市",
"861562262", "广东省肇庆市",
"86157065", "海南省海口市",
"861348744", "湖南省张家界市",
"861773934", "河南省濮阳市",
"861336170", "江西省新余市",
"861569356", "甘肃省金昌市",
"86181945", "青海省西宁市",
"861539184", "安徽省安庆市",
"861317660", "山东省东营市",
"86184607", "江西省南昌市",
"861360735", "湖南省郴州市",
"861564944", "河南省开封市",
"861819803", "甘肃省平凉市",
"86135427", "广东省惠州市",
"861450856", "江苏省盐城市",
"86135509", "四川省攀枝花市",
"861539396", "云南省大理白族自治州",
"861898826", "云南省红河哈尼族彝族自治州",
"861881898", "广东省云浮市",
"861337944", "陕西省渭南市",
"861882567", "广东省揭阳市",
"861503463", "山西省晋城市",
"861320743", "湖南省湘西土家族苗族自治州",
"86136092", "陕西省西安市",
"861871888", "广东省广州市",
"861523316", "河北省廊坊市",
"861343731", "广东省江门市",
"861847680", "广东省湛江市",
"861787509", "广东省广州市",
"861894780", "内蒙古巴彦淖尔市",
"861558325", "四川省资阳市",
"861825241", "江苏省徐州市",
"86133163", "广东省惠州市",
"861786532", "山东省青岛市",
"86133691", "陕西省渭南市",
"861877437", "湖南省常德市",
"861590758", "广东省肇庆市",
"86156374", "河南省许昌市",
"86150635", "山东省聊城市",
"861839712", "青海省海东地区",
"86182311", "河北省石家庄市",
"86139436", "吉林省白城市",
"861471589", "广东省揭阳市",
"86177473", "内蒙古乌海市",
"86183919", "陕西省商洛市",
"861569734", "湖南省衡阳市",
"861774925", "陕西省汉中市",
"861569014", "河北省廊坊市",
"861393877", "河南省许昌市",
"861453739", "湖南省常德市",
"861368823", "四川省南充市",
"86153461", "河南省焦作市",
"861532611", "辽宁省沈阳市",
"861364525", "江苏省扬州市",
"861336025", "广东省肇庆市",
"86186915", "陕西省安康市",
"861535437", "河北省沧州市",
"861315882", "四川省自贡市",
"861305823", "广东省韶关市",
"861554341", "吉林省长春市",
"86180640", "湖北省武汉市",
"861826246", "江苏省徐州市",
"861815849", "浙江省宁波市",
"861374095", "宁夏银川市",
"861528528", "贵州省黔东南苗族侗族自治州",
"861826649", "山东省滨州市",
"861362900", "四川省内江市",
"861334830", "福建省莆田市",
"861556983", "甘肃省天水市",
"861531989", "陕西省铜川市",
"861884808", "内蒙古兴安盟",
"861378967", "内蒙古鄂尔多斯市",
"861399403", "山西省临汾市",
"861536851", "云南省文山壮族苗族自治州",
"86159891", "广东省广州市",
"861318426", "浙江省温州市",
"86139539", "山东省临沂市",
"861353622", "广东省江门市",
"861521811", "广东省梅州市",
"861705567", "云南省昆明市",
"86139985", "辽宁省大连市",
"861327677", "浙江省温州市",
"861850518", "江苏省连云港市",
"861532251", "广东省湛江市",
"86153425", "湖北省孝感市",
"861362479", "内蒙古兴安盟",
"861877980", "江西省景德镇市",
"86158810", "四川省成都市",
"861818750", "云南省昆明市",
"86156429", "辽宁省葫芦岛市",
"861363815", "贵州省毕节地区",
"861556150", "黑龙江省七台河市",
"86156507", "北京市",
"86152802", "福建省厦门市",
"861708377", "河南省南阳市",
"861562858", "西藏日喀则地区",
"861811840", "江苏省镇江市",
"861858890", "广东省阳江市",
"861512057", "甘肃省天水市",
"861599230", "广东省肇庆市",
"861340811", "四川省绵阳市",
"861528915", "西藏昌都地区",
"861595042", "江苏省无锡市",
"861535980", "福建省莆田市",
"861329855", "湖南省张家界市",
"86185860", "内蒙古呼和浩特市",
"861804589", "黑龙江省双鸭山市",
"861450980", "新疆塔城地区",
"861532898", "四川省攀枝花市",
"86136725", "广东省云浮市",
"861830537", "山东省济宁市",
"86189248", "广东省佛山市",
"861471967", "甘肃省庆阳市",
"861364918", "陕西省咸阳市",
"861322553", "安徽省芜湖市",
"861787560", "广东省珠海市",
"861304542", "黑龙江省佳木斯市",
"861350377", "河南省南阳市",
"861894481", "江苏省泰州市",
"861860478", "内蒙古巴彦淖尔市",
"861313542", "安徽省六安市",
"861760876", "云南省文山壮族苗族自治州",
"861391955", "甘肃省陇南市",
"861863452", "山西省晋中市",
"861831646", "广东省云浮市",
"861301194", "河北省廊坊市",
"861317609", "山东省临沂市",
"861589101", "陕西省延安市",
"861831249", "广东省深圳市",
"861566618", "山东省菏泽市",
"861537918", "甘肃省平凉市",
"861856243", "山东省济宁市",
"861580906", "新疆阿勒泰地区",
"861521698", "广东省江门市",
"861301665", "广东省汕头市",
"861894217", "湖北省十堰市",
"861708746", "湖南省邵阳市",
"861555342", "山东省烟台市",
"86133338", "河南省郑州市",
"86157021", "上海市",
"861872999", "陕西省铜川市",
"861820707", "江西省赣州市",
"86185381", "河南省郑州市",
"861804152", "辽宁省丹东市",
"861399533", "宁夏吴忠市",
"861390267", "广东省汕尾市",
"861845258", "江苏省徐州市",
"861539020", "四川省乐山市",
"861590582", "浙江省湖州市",
"861530628", "江苏省南通市",
"861810593", "福建省宁德市",
"861391440", "江苏省泰州市",
"861886787", "浙江省宁波市",
"861562713", "广东省惠州市",
"861471477", "广东省清远市",
"861807486", "广西百色市",
"861522045", "广东省汕头市",
"861360640", "山东省济南市",
"861532576", "浙江省台州市",
"861592548", "云南省临沧市",
"861801458", "江苏省镇江市",
"861355173", "四川省泸州市",
"861772430", "广东省东莞市",
"86180653", "福建省泉州市",
"861820315", "河北省唐山市",
"86156120", "河北省邯郸市",
"861860968", "安徽省亳州市",
"861809634", "四川省巴中市",
"861845891", "浙江省舟山市",
"861356871", "四川省遂宁市",
"861330443", "吉林省延边朝鲜族自治州",
"861882989", "陕西省西安市",
"861319847", "四川省乐山市",
"861760598", "福建省三明市",
"861520854", "贵州省黔南布依族苗族自治州",
"861760444", "吉林省四平市",
"861370998", "新疆喀什地区",
"861346317", "河北省沧州市",
"86132623", "浙江省温州市",
"861806119", "江苏省镇江市",
"86187177", "上海市",
"861450507", "吉林省吉林市",
"861553313", "河北省张家口市",
"861380988", "广东省深圳市",
"861768810", "广东省中山市",
"861857040", "湖南省岳阳市",
"861390077", "广西南宁市",
"861705810", "山东省济南市",
"861877507", "广西玉林市",
"86131288", "广东省深圳市",
"861867822", "山东省淄博市",
"861880371", "河南省郑州市",
"861459432", "西藏日喀则地区",
"861777106", "湖北省黄石市",
"86153629", "广东省中山市",
"861454829", "广东省汕尾市",
"861363339", "河北省张家口市",
"86156557", "安徽省宿州市",
"861452622", "江苏省苏州市",
"861335483", "内蒙古阿拉善盟",
"86150857", "贵州省毕节地区",
"861365680", "浙江省舟山市",
"861850738", "湖南省娄底市",
"861315013", "甘肃省庆阳市",
"86156625", "山东省潍坊市",
"861874680", "黑龙江省鹤岗市",
"861809840", "安徽省滁州市",
"86158946", "新疆乌鲁木齐市",
"861551768", "河南省濮阳市",
"861830717", "湖北省宜昌市",
"861879974", "新疆石河子市",
"861833419", "贵州省毕节地区",
"861350484", "黑龙江省哈尔滨市",
"861477738", "广西河池市",
"861804089", "新疆伊犁哈萨克自治州",
"861771667", "贵州省毕节地区",
"861357150", "陕西省渭南市",
"861813089", "新疆乌鲁木齐市",
"861589110", "陕西省咸阳市",
"861760786", "广西百色市",
"861370244", "广东省佛山市",
"861319386", "河南省信阳市",
"861319665", "江苏省盐城市",
"861774018", "四川省成都市",
"861516609", "山东省滨州市",
"861321958", "四川省内江市",
"861530455", "黑龙江省绥化市",
"86155541", "山东省济南市",
"861385948", "福建省南平市",
"861319194", "河北省沧州市",
"861302974", "黑龙江省齐齐哈尔市",
"861378375", "河南省平顶山市",
"861367618", "广东省江门市",
"861804375", "吉林省辽源市",
"861322053", "山东省临沂市",
"861560495", "辽宁省丹东市",
"861304042", "浙江省宁波市",
"861348845", "陕西省汉中市",
"861529146", "陕西省汉中市",
"861303909", "吉林省延边朝鲜族自治州",
"861355786", "广西南宁市",
"861520941", "甘肃省甘南藏族自治州",
"861333720", "湖南省岳阳市",
"86139829", "四川省资阳市",
"861509571", "甘肃省天水市",
"861839198", "陕西省咸阳市",
"861471893", "西藏山南地区",
"861816914", "宁夏固原市",
"861708484", "河南省平顶山市",
"861531277", "江苏省泰州市",
"86134069", "山东省济南市",
"861314909", "广东省清远市",
"861806192", "江苏省苏州市",
"861530940", "甘肃省平凉市",
"861810093", "甘肃省兰州市",
"861772279", "广东省梅州市",
"861301847", "广东省珠海市",
"861303771", "四川省攀枝花市",
"861355098", "四川省广安市",
"861458257", "安徽省蚌埠市",
"861323721", "湖北省黄冈市",
"861769137", "陕西省宝鸡市",
"861709529", "江苏省盐城市",
"861700949", "重庆市",
"86131277", "上海市",
"86181794", "江西省抚州市",
"86182934", "甘肃省庆阳市",
"861314771", "吉林省长春市",
"861501742", "广东省佛山市",
"861877892", "广西柳州市",
"861535892", "江苏省扬州市",
"861453271", "山西省朔州市",
"861595104", "江苏省扬州市",
"861705801", "北京市",
"861347095", "安徽省马鞍山市",
"861770528", "江苏省镇江市",
"861365757", "新疆阿克苏地区",
"861369548", "山东省泰安市",
"861539352", "甘肃省武威市",
"861768801", "广东省汕头市",
"861508852", "浙江省绍兴市",
"861569392", "甘肃省白银市",
"861858982", "广西柳州市",
"861522545", "河南省开封市",
"86177745", "湖南省怀化市",
"861302464", "浙江省金华市",
"86180671", "浙江省宁波市",
"861890318", "河北省衡水市",
"861779948", "新疆喀什地区",
"86180603", "福建省宁德市",
"861339454", "黑龙江省佳木斯市",
"861335797", "江苏省淮安市",
"861358949", "山东省淄博市",
"861311999", "新疆伊犁哈萨克自治州",
"861535007", "江西省赣州市",
"861470540", "山东省菏泽市",
"861879464", "甘肃省平凉市",
"861529843", "江苏省无锡市",
"861532669", "黑龙江省佳木斯市",
"861872912", "陕西省榆林市",
"86176980", "河南省郑州市",
"861334767", "广西贵港市",
"861479920", "新疆阿克苏地区",
"861581393", "广东省汕尾市",
"86184561", "安徽省淮北市",
"861322838", "四川省乐山市",
"861839402", "甘肃省兰州市",
"861772069", "福建省南平市",
"861836284", "江苏省连云港市",
"861535335", "陕西省安康市",
"861583191", "河北省邢台市",
"861862929", "陕西省西安市",
"861390577", "浙江省温州市",
"861569835", "山西省晋中市",
"86152723", "湖北省荆州市",
"861367862", "山东省德州市",
"861380392", "河南省鹤壁市",
"861572592", "山东省济宁市",
"861529292", "新疆喀什地区",
"861852571", "辽宁省盘锦市",
"861890989", "辽宁省葫芦岛市",
"861589928", "新疆伊犁哈萨克自治州",
"86185457", "黑龙江省大庆市",
"861551435", "河南省郑州市",
"861835150", "江苏省无锡市",
"86130283", "重庆市",
"861865190", "江苏省南京市",
"861867833", "山东省滨州市",
"86134505", "广东省佛山市",
"861580548", "山东省泰安市",
"861570484", "内蒙古兴安盟",
"86150790", "江西省南昌市",
"861325541", "山东省济南市",
"861378427", "河北省保定市",
"861856980", "河南省信阳市",
"861320917", "陕西省宝鸡市",
"861813427", "河北省沧州市",
"861370382", "河南省郑州市",
"86170772", "江西省赣州市",
"861582582", "甘肃省定西市",
"861857483", "湖南省娄底市",
"861850465", "黑龙江省哈尔滨市",
"861584766", "内蒙古呼和浩特市",
"861394860", "内蒙古呼伦贝尔市",
"861870349", "山西省朔州市",
"861861798", "河北省石家庄市",
"861333956", "黑龙江省鸡西市",
"861300743", "湖南省长沙市",
"861503316", "河北省廊坊市",
"861826038", "江苏省连云港市",
"86181658", "广东省茂名市",
"861873844", "河南省洛阳市",
"861896535", "福建省南平市",
"86136097", "广东省广州市",
"86156733", "湖南省株洲市",
"86139560", "安徽省合肥市",
"861865637", "安徽省合肥市",
"861318844", "辽宁省铁岭市",
"861351894", "西藏林芝地区",
"861862411", "辽宁省大连市",
"861819684", "新疆喀什地区",
"861808637", "湖北省宜昌市",
"861831758", "河南省新乡市",
"86186441", "天津市",
"861450243", "河北省承德市",
"86187983", "贵州省毕节地区",
"861528896", "山东省青岛市",
"861399522", "宁夏石嘴山市",
"861535243", "甘肃省临夏回族自治州",
"861576937", "甘肃省陇南市",
"861312728", "山东省泰安市",
"861898876", "广东省深圳市",
"861339688", "浙江省丽水市",
"861375160", "广东省阳江市",
"861840879", "云南省普洱市",
"861311754", "湖南省衡阳市",
"861502610", "新疆哈密地区",
"861893645", "江苏省南通市",
"86184602", "江西省吉安市",
"861310410", "辽宁省铁岭市",
"861857797", "广西南宁市",
"861876255", "江苏省淮安市",
"861598389", "四川省达州市",
"861317094", "江西省抚州市",
"861364575", "浙江省绍兴市",
"861571617", "江苏省无锡市",
"861336075", "广东省茂名市",
"86158384", "河南省南阳市",
"861803460", "甘肃省庆阳市",
"861368873", "云南省文山壮族苗族自治州",
"861377871", "四川省遂宁市",
"861323636", "江苏省镇江市",
"861527046", "江西省吉安市",
"861802485", "广东省清远市",
"861347341", "河北省石家庄市",
"86152635", "山东省聊城市",
"86181411", "辽宁省大连市",
"861470797", "江西省赣州市",
"86180311", "河北省石家庄市",
"861504982", "内蒙古巴彦淖尔市",
"861585088", "江苏省泰州市",
"861560607", "福建省福州市",
"861563661", "黑龙江省绥化市",
"861595977", "福建省南平市",
"861708658", "山东省烟台市",
"861318476", "河北省衡水市",
"861518691", "贵州省黔东南苗族侗族自治州",
"861876040", "福建省福州市",
"861592906", "陕西省延安市",
"86187049", "内蒙古巴彦淖尔市",
"861335540", "山东省菏泽市",
"861890810", "四川省德阳市",
"861501811", "广东省肇庆市",
"861859362", "福建省福州市",
"861850975", "青海省果洛藏族自治州",
"861814539", "黑龙江省大兴安岭地区",
"861576781", "广东省惠州市",
"861353672", "广东省梅州市",
"86182640", "山东省菏泽市",
"861831813", "广东省茂名市",
"861898444", "贵州省六盘水市",
"861806246", "湖北省荆门市",
"861815653", "安徽省合肥市",
"861815490", "新疆乌鲁木齐市",
"861770852", "贵州省遵义市",
"861856819", "河南省濮阳市",
"861828095", "四川省广安市",
"861351383", "河南省安阳市",
"861825151", "江苏省宿迁市",
"861350658", "浙江省金华市",
"861898598", "贵州省黔西南布依族苗族自治州",
"861587730", "陕西省汉中市",
"861375708", "浙江省湖州市",
"861539209", "福建省泉州市",
"861454188", "山西省忻州市",
"861598075", "福建省厦门市",
"861587010", "贵州省遵义市",
"86188048", "内蒙古兴安盟",
"861882318", "广东省深圳市",
"86134555", "山东省烟台市",
"861589640", "江苏省泰州市",
"861572092", "江西省上饶市",
"861840789", "江西省萍乡市",
"861898786", "云南省昆明市",
"86134627", "河南省商丘市",
"861843487", "山西省运城市",
"86185529", "江苏省徐州市",
"861809702", "青海省海东地区",
"86177026", "广东省东莞市",
"86151360", "河南省商丘市",
"861479761", "青海省海北藏族自治州",
"861763526", "山西省临汾市",
"861899903", "新疆哈密地区",
"861350425", "辽宁省大连市",
"861310401", "黑龙江省哈尔滨市",
"861313467", "山西省临汾市",
"86150460", "黑龙江省哈尔滨市",
"861837876", "广西南宁市",
"861897848", "广西梧州市",
"861596457", "山东省潍坊市",
"861325041", "广东省湛江市",
"861309754", "山西省大同市",
"861510913", "陕西省渭南市",
"861305497", "山东省济宁市",
"861780631", "山东省威海市",
"861776829", "江苏省淮安市",
"861780950", "宁夏银川市",
"861570377", "河南省南阳市",
"861322985", "广东省珠海市",
"861821803", "广东省东莞市",
"86183641", "山东省济南市",
"861377937", "新疆哈密地区",
"861387213", "湖北省黄石市",
"86188544", "山东省临沂市",
"861537120", "江苏省盐城市",
"861505860", "浙江省台州市",
"861338457", "黑龙江省大兴安岭地区",
"861811348", "四川省广安市",
"86147876", "云南省文山壮族苗族自治州",
"861826538", "山东省泰安市",
"86181608", "安徽省蚌埠市",
"861572519", "山东省临沂市",
"861380319", "河北省邢台市",
"86181012", "北京市",
"861708425", "云南省怒江傈僳族自治州",
"861768134", "安徽省芜湖市",
"861340742", "湖南省湘潭市",
"861812768", "广东省韶关市",
"861823648", "河南省驻马店市",
"861533299", "内蒙古通辽市",
"86184652", "宁夏银川市",
"861331344", "山西省晋中市",
"861875120", "江苏省常州市",
"861572807", "浙江省丽水市",
"861896307", "山东省济南市",
"861817670", "广西柳州市",
"861323960", "甘肃省庆阳市",
"86134606", "河南省开封市",
"861330580", "浙江省舟山市",
"861367148", "广东省湛江市",
"861383405", "山西省长治市",
"86131995", "黑龙江省哈尔滨市",
"861365295", "广东省揭阳市",
"861336575", "安徽省安庆市",
"86135021", "天津市",
"86150169", "广东省东莞市",
"861558152", "湖南省邵阳市",
"861874295", "新疆乌鲁木齐市",
"861314420", "广东省江门市",
"86132735", "河北省唐山市",
"861303420", "浙江省杭州市",
"861816752", "新疆阿克苏地区",
"861768318", "四川省南充市",
"861333961", "贵州省贵阳市",
"861709487", "浙江省杭州市",
"861335255", "黑龙江省绥化市",
"861501800", "广东省中山市",
"861323470", "内蒙古呼伦贝尔市",
"861330907", "四川省南充市",
"861705318", "广东省深圳市",
"861320581", "浙江省杭州市",
"861507682", "河北省衡水市",
"861309336", "安徽省阜阳市",
"86152439", "湖南省邵阳市",
"861510326", "河北省廊坊市",
"861507171", "湖北省黄冈市",
"861585588", "安徽省亳州市",
"861837444", "湖南省张家界市",
"861705227", "山东省临沂市",
"861575173", "江苏省徐州市",
"861527121", "湖北省武汉市",
"861458795", "湖南省株洲市",
"86189437", "吉林省延边朝鲜族自治州",
"861537075", "江苏省苏州市",
"861500755", "广东省深圳市",
"861527546", "山东省东营市",
"861773788", "河南省郑州市",
"861895949", "福建省龙岩市",
"861587001", "江西省南昌市",
"861345872", "四川省泸州市",
"861338836", "四川省内江市",
"861576871", "广东省湛江市",
"861351147", "浙江省台州市",
"861318197", "山东省东营市",
"861559424", "陕西省渭南市",
"861814039", "四川省凉山彝族自治州",
"861889859", "广东省深圳市",
"86184514", "江苏省宿迁市",
"86152536", "山东省潍坊市",
"861550998", "新疆喀什地区",
"861570746", "湖南省永州市",
"86170821", "上海市",
"861827667", "广西南宁市",
"861313977", "新疆博尔塔拉蒙古自治州",
"861359322", "山西省忻州市",
"861876540", "山东省菏泽市",
"861707380", "河南省郑州市",
"861335040", "四川省南充市",
"861373313", "河南省南阳市",
"861800417", "辽宁省营口市",
"861459423", "云南省楚雄彝族自治州",
"861452633", "江苏省盐城市",
"861528078", "福建省南平市",
"861587510", "广东省韶关市",
"861565028", "山东省潍坊市",
"861555284", "山东省泰安市",
"861526627", "山东省枣庄市",
"861824893", "江苏省连云港市",
"861364389", "河南省洛阳市",
"861368783", "广西桂林市",
"861506677", "山东省烟台市",
"861479792", "江西省九江市",
"861888212", "四川省资阳市",
"861882442", "广东省东莞市",
"861539939", "陕西省商洛市",
"861879924", "新疆和田地区",
"861310700", "湖南省株洲市",
"861824089", "陕西省西安市",
"861318745", "云南省曲靖市",
"861351795", "江西省宜春市",
"861479460", "黑龙江省哈尔滨市",
"861709930", "浙江省台州市",
"861339273", "广东省东莞市",
"861770896", "西藏那曲地区",
"861870544", "山东省潍坊市",
"861380734", "湖南省衡阳市",
"861458147", "浙江省金华市",
"861386645", "安徽省池州市",
"861862469", "辽宁省辽阳市",
"86150852", "贵州省黔东南苗族侗族自治州",
"86137570", "浙江省衢州市",
"861311855", "贵州省黔东南苗族侗族自治州",
"86152857", "贵州省毕节地区",
"86186470", "内蒙古呼伦贝尔市",
"861880488", "内蒙古呼和浩特市",
"86156552", "安徽省蚌埠市",
"861454879", "四川省阿坝藏族羌族自治州",
"861452181", "吉林省吉林市",
"861855866", "福建省厦门市",
"861880321", "河北省石家庄市",
"861809499", "新疆克孜勒苏柯尔克孜自治州",
"861331049", "贵州省遵义市",
"86147911", "陕西省西安市",
"861394737", "内蒙古鄂尔多斯市",
"861572061", "江苏省南京市",
"86135065", "浙江省温州市",
"861500941", "甘肃省甘南藏族自治州",
"861333770", "江苏省南京市",
"861509146", "陕西省汉中市",
"861899591", "湖北省宜昌市",
"861323909", "新疆博尔塔拉蒙古自治州",
"861397355", "湖南省邵阳市",
"861836109", "江苏省盐城市",
"861572271", "江苏省苏州市",
"861811412", "江苏省泰州市",
"861551337", "山西省晋城市",
"861310531", "山东省济南市",
"86157509", "福建省泉州市",
"861855944", "福建省厦门市",
"861891940", "甘肃省临夏回族自治州",
"861889816", "河南省南阳市",
"86183709", "江西省赣州市",
"861519698", "四川省宜宾市",
"86170865", "山东省潍坊市",
"861301958", "内蒙古巴彦淖尔市",
"861839523", "宁夏吴忠市",
"861830943", "甘肃省白银市",
"861322974", "广东省汕尾市",
"861803756", "河南省洛阳市",
"861382489", "广东省茂名市",
"861862530", "河南省驻马店市",
"861302053", "山东省日照市",
"861769300", "甘肃省临夏回族自治州",
"861347190", "广西玉林市",
"861804325", "吉林省吉林市",
"861345833", "四川省巴中市",
"86151644", "吉林省松原市",
"861302924", "辽宁省抚顺市",
"861360468", "黑龙江省鸡西市",
"86186705", "湖南省郴州市",
"861379387", "山东省滨州市",
"861375418", "内蒙古巴彦淖尔市",
"861394981", "河南省许昌市",
"861537084", "江苏省南通市",
"861770578", "浙江省丽水市",
"86139298", "广东省肇庆市",
"86156614", "内蒙古包头市",
"861310168", "黑龙江省鹤岗市",
"86183175", "河南省洛阳市",
"861453221", "浙江省宁波市",
"861814334", "湖南省娄底市",
"861856861", "河南省三门峡市",
"861803334", "广东省湛江市",
"861322464", "黑龙江省佳木斯市",
"86182671", "浙江省杭州市",
"861891455", "江苏省镇江市",
"86186179", "河北省衡水市",
"861517414", "辽宁省本溪市",
"861787694", "广东省湛江市",
"861816588", "广东省云浮市",
"861321847", "江苏省常州市",
"861860655", "浙江省金华市",
"861890277", "广东省河源市",
"861323771", "广西南宁市",
"861354228", "广东省韶关市",
"861826192", "江苏省南京市",
"86183884", "云南省昆明市",
"861363952", "宁夏石嘴山市",
"861772229", "广东省茂名市",
"861334338", "河北省承德市",
"861333992", "湖北省黄石市",
"861557821", "广西柳州市",
"861314721", "湖北省荆州市",
"861585663", "安徽省池州市",
"861539570", "浙江省衢州市",
"861457102", "江苏省扬州市",
"861336584", "湖南省张家界市",
"861521742", "广东省汕头市",
"86180934", "甘肃省庆阳市",
"861346568", "山东省潍坊市",
"861367749", "湖南省长沙市",
"861862979", "吉林省辽源市",
"86134030", "湖北省恩施土家族苗族自治州",
"861399947", "新疆吐鲁番地区",
"86137234", "广东省深圳市",
"861890067", "江苏省南京市",
"86158992", "新疆乌鲁木齐市",
"861370154", "江苏省苏州市",
"861345136", "内蒙古赤峰市",
"86150723", "湖北省武汉市",
"861839841", "四川省绵阳市",
"861390527", "江苏省扬州市",
"861886827", "浙江省温州市",
"861338681", "辽宁省盘锦市",
"861589735", "湖南省郴州市",
"861707728", "江西省宜春市",
"861509843", "山东省聊城市",
"861479970", "新疆乌鲁木齐市",
"861538343", "山西省太原市",
"861863904", "河南省商丘市",
"86137176", "北京市",
"861534749", "广东省汕头市",
"861572556", "山东省聊城市",
"861342189", "广东省汕头市",
"861380356", "江西省九江市",
"861591717", "广东省潮州市",
"86134287", "广东省深圳市",
"861559613", "陕西省安康市",
"861587867", "广西河池市",
"861869248", "湖南省娄底市",
"861394809", "内蒙古呼伦贝尔市",
"861338355", "山西省长治市",
"861842004", "广东省汕尾市",
"861508915", "广东省珠海市",
"861811499", "江苏省徐州市",
"861802846", "广东省惠州市",
"861353633", "广东省惠州市",
"861553976", "河南省许昌市",
"861309855", "贵州省黔东南苗族侗族自治州",
"861570475", "内蒙古通辽市",
"861368395", "河南省漯河市",
"86711", "湖北省鄂州市",
"861356543", "新疆乌鲁木齐市",
"861369639", "山东省临沂市",
"861331549", "河北省石家庄市",
"861362429", "辽宁省葫芦岛市",
"861333880", "江苏省常州市",
"861572561", "山东省威海市",
"861380361", "黑龙江省齐齐哈尔市",
"861355826", "广西百色市",
"861700482", "广东省深圳市",
"861339902", "新疆哈密地区",
"86150802", "福建省龙岩市",
"861857145", "湖北省武汉市",
"861708327", "河北省沧州市",
"86183670", "浙江省衢州市",
"861518818", "云南省玉溪市",
"861780776", "广西百色市",
"861529071", "河南省漯河市",
"861568017", "四川省雅安市",
"861310711", "湖南省长沙市",
"861454789", "山东省临沂市",
"861568737", "云南省昆明市",
"861310031", "湖南省长沙市",
"861458383", "福建省漳州市",
"861509021", "河南省濮阳市",
"861321194", "云南省怒江傈僳族自治州",
"86157559", "安徽省黄山市",
"861479039", "安徽省池州市",
"861843269", "河北省邢台市",
"86152826", "四川省广安市",
"861539125", "内蒙古鄂尔多斯市",
"861479719", "山西省太原市",
"86131744", "吉林省长春市",
"861888299", "四川省甘孜藏族自治州",
"861321386", "河南省信阳市",
"861305832", "广东省佛山市",
"861510590", "福建省莆田市",
"861313365", "江西省九江市",
"861894378", "吉林省白城市",
"861350327", "河北省沧州市",
"8618423", "重庆市",
"861313686", "黑龙江省牡丹江市",
"861339563", "安徽省宣城市",
"861330237", "广东省云浮市",
"86186755", "广东省深圳市",
"861324542", "山东省青岛市",
"861809412", "福建省三明市",
"861558384", "四川省德阳市",
"861760826", "四川省广安市",
"861313289", "广西贵港市",
"86183759", "重庆市",
"861839954", "新疆阿克苏地区",
"861860428", "辽宁省大连市",
"86158558", "安徽省阜阳市",
"861304365", "江苏省无锡市",
"861821458", "云南省昆明市",
"86156998", "北京市",
"86185839", "四川省成都市",
"861532526", "浙江省嘉兴市",
"861800315", "河北省唐山市",
"861816088", "安徽省合肥市",
"861397172", "湖北省黄冈市",
"861785846", "浙江省台州市",
"861356821", "四川省德阳市",
"861563692", "黑龙江省绥化市",
"86134278", "广东省东莞市",
"861519869", "云南省西双版纳傣族自治州",
"861533763", "浙江省嘉兴市",
"861802143", "江苏省无锡市",
"861539070", "江西省赣州市",
"861803409", "河北省邢台市",
"861773052", "河北省唐山市",
"861590249", "辽宁省辽阳市",
"861800707", "江西省赣州市",
"861364584", "浙江省宁波市",
"861803761", "河南省信阳市",
"861814409", "福建省厦门市",
"861366338", "河北省衡水市",
"861774984", "河北省唐山市",
"861530678", "浙江省丽水市",
"861590646", "浙江省温州市",
"861871935", "广东省梅州市",
"861539260", "山西省忻州市",
"861709666", "浙江省宁波市",
"861390027", "辽宁省辽阳市",
"861562947", "湖北省咸宁市",
"861587993", "江西省新余市",
"861855298", "江苏省南通市",
"861558893", "山东省莱芜市",
"86188231", "广东省佛山市",
"861379143", "山东省枣庄市",
"861586490", "山东省聊城市",
"861780347", "山西省朔州市",
"861306908", "吉林省延边朝鲜族自治州",
"861893501", "山西省忻州市",
"861554595", "黑龙江省哈尔滨市",
"861345558", "山东省济宁市",
"861890567", "安徽省亳州市",
"861384953", "河南省焦作市",
"861566749", "陕西省汉中市",
"861572056", "安徽省安庆市",
"861576480", "内蒙古乌兰察布市",
"861333919", "安徽省合肥市",
"86189784", "广西贺州市",
"861379474", "广东省河源市",
"861500854", "贵州省黔南布依族苗族自治州",
"861855851", "福建省三明市",
"86187172", "陕西省咸阳市",
"861553466", "山西省长治市",
"861826119", "江苏省常州市",
"861859391", "广西桂林市",
"861884564", "黑龙江省哈尔滨市",
"86130623", "重庆市",
"861577983", "江西省九江市",
"861570965", "宁夏中卫市",
"86137777", "浙江省温州市",
"861472685", "四川省广元市",
"861803296", "河北省邢台市",
"861770917", "陕西省宝鸡市",
"861812892", "广东省韶关市",
"861559930", "贵州省安顺市",
"861308941", "吉林省长春市",
"861362379", "河南省洛阳市",
"861883080", "河北省衡水市",
"861518531", "贵州省遵义市",
"86180027", "广东省东莞市",
"861707543", "福建省漳州市",
"86182022", "天津市",
"861708477", "内蒙古包头市",
"861452093", "安徽省宣城市",
"861473660", "云南省红河哈尼族彝族自治州",
"861570325", "河北省唐山市",
"861880956", "宁夏石嘴山市",
"861471746", "江西省赣州市",
"861889151", "陕西省榆林市",
"861505468", "山东省菏泽市",
"861318090", "吉林省延边朝鲜族自治州",
"861302987", "黑龙江省哈尔滨市",
"86188815", "四川省泸州市",
"861510745", "湖南省怀化市",
"86183420", "辽宁省大连市",
"86189238", "广东省深圳市",
"861513498", "内蒙古巴彦淖尔市",
"861894381", "吉林省松原市",
"861389823", "辽宁省朝阳市",
"86150171", "广东省东莞市",
"861350477", "吉林省吉林市",
"861879987", "新疆喀什地区",
"861896943", "浙江省宁波市",
"861860378", "河南省开封市",
"861303934", "吉林省长春市",
"86150718", "湖北省恩施土家族苗族自治州",
"861335147", "黑龙江省大兴安岭地区",
"861806742", "浙江省宁波市",
"86151953", "江苏省淮安市",
"861843613", "河南省商丘市",
"861597237", "湖北省黄石市",
"861586600", "山东省泰安市",
"86158689", "浙江省金华市",
"861815266", "湖南省常德市",
"86130994", "云南省昆明市",
"861520680", "山东省临沂市",
"861516634", "山东省莱芜市",
"86155865", "湖北省黄石市",
"861323596", "福建省漳州市",
"861351255", "江苏省泰州市",
"861301486", "广西桂林市",
"86187873", "云南省红河哈尼族彝族自治州",
"86138854", "贵州省黔南布依族苗族自治州",
"861454908", "湖北省宜昌市",
"861529796", "江西省吉安市",
"86130473", "重庆市",
"861820804", "西藏林芝地区",
"86187801", "四川省成都市",
"861302731", "湖南省长沙市",
"861773239", "河北省沧州市",
"86130401", "江苏省泰州市",
"861839748", "湖南省常德市",
"861899776", "新疆博尔塔拉蒙古自治州",
"861530681", "浙江省杭州市",
"861355344", "广东省惠州市",
"861391340", "江苏省镇江市",
"861376057", "广东省揭阳市",
"861896695", "陕西省榆林市",
"861564249", "辽宁省鞍山市",
"861390584", "浙江省宁波市",
"861595139", "江苏省宿迁市",
"861816071", "江西省南昌市",
"861807665", "广西钦州市",
"861800683", "浙江省嘉兴市",
"86145423", "重庆市",
"861811206", "江苏省盐城市",
"861533158", "云南省曲靖市",
"861820415", "辽宁省丹东市",
"861452231", "浙江省衢州市",
"861879500", "宁夏银川市",
"861337249", "浙江省金华市",
"861319744", "湖北省鄂州市",
"861807194", "湖北省十堰市",
"861337646", "山东省潍坊市",
"861366946", "广西桂林市",
"861705065", "江苏省南京市",
"861330343", "山西省太原市",
"861520757", "广东省佛山市",
"86184845", "贵州省铜仁地区",
"861366864", "山东省淄博市",
"861760344", "山西省晋中市",
"861579422", "江苏省无锡市",
"861585292", "江苏省南京市",
"861371980", "广东省云浮市",
"861705275", "上海市",
"861572632", "山东省枣庄市",
"861856768", "河南省安阳市",
"861582944", "陕西省咸阳市",
"861320852", "贵州省遵义市",
"86147639", "山东省青岛市",
"861380921", "广东省佛山市",
"86159551", "安徽省合肥市",
"861569419", "辽宁省辽阳市",
"861777627", "广西桂林市",
"86185208", "广东省深圳市",
"861323878", "云南省楚雄彝族自治州",
"861517221", "湖北省孝感市",
"861317840", "广东省韶关市",
"861336527", "江苏省连云港市",
"861453414", "辽宁省大连市",
"861478437", "河南省开封市",
"861389541", "宁夏银川市",
"861788808", "西藏日喀则地区",
"861452178", "吉林省吉林市",
"861363439", "吉林省白山市",
"861775041", "福建省福州市",
"861360737", "湖南省益阳市",
"861880471", "内蒙古呼和浩特市",
"861459332", "四川省宜宾市",
"861707043", "浙江省台州市",
"861310818", "四川省达州市",
"861335383", "河南省开封市",
"861384911", "河南省郑州市",
"861856111", "山东省烟台市",
"86170099", "浙江省宁波市",
"86158936", "河南省周口市",
"861817999", "江西省南昌市",
"86138291", "广东省东莞市",
"861535641", "浙江省温州市",
"861558327", "四川省资阳市",
"861450641", "黑龙江省大庆市",
"861351540", "山东省潍坊市",
"861452593", "福建省宁德市",
"861882565", "广东省揭阳市",
"861550482", "内蒙古兴安盟",
"861359991", "福建省厦门市",
"861773960", "河南省漯河市",
"861519192", "陕西省汉中市",
"861319486", "四川省成都市",
"861502972", "陕西省榆林市",
"861300915", "吉林省吉林市",
"861588514", "贵州省铜仁地区",
"861530355", "山西省长治市",
"861889863", "广东省广州市",
"861813475", "河南省平顶山市",
"861560395", "河南省漯河市",
"86150153", "广东省东莞市",
"861814612", "福建省厦门市",
"861317634", "山东省莱芜市",
"861363560", "安徽省合肥市",
"861812819", "广东省阳江市",
"86186620", "江苏省盐城市",
"86155531", "山东省济南市",
"86138789", "广西北海市",
"861807847", "广西柳州市",
"861339736", "湖南省常德市",
"861571797", "江西省赣州市",
"861853842", "河南省郑州市",
"861708196", "福建省漳州市",
"861362585", "浙江省绍兴市",
"86137788", "四川省眉山市",
"861323096", "河北省邢台市",
"861822793", "四川省资阳市",
"861708384", "河南省焦作市",
"861772985", "四川省宜宾市",
"861359157", "辽宁省抚顺市",
"861315226", "陕西省商洛市",
"861306879", "河北省石家庄市",
"861572288", "江苏省徐州市",
"86130618", "上海市",
"86158485", "内蒙古通辽市",
"86151903", "江苏省无锡市",
"861812507", "广东省珠海市",
"861470617", "江苏省无锡市",
"861301744", "贵州省安顺市",
"861390084", "湖南省岳阳市",
"861323788", "广西河池市",
"861815898", "安徽省蚌埠市",
"861821986", "甘肃省张掖市",
"86182944", "甘肃省兰州市",
"86187851", "贵州省贵阳市",
"861350893", "山东省聊城市",
"861536646", "江苏省盐城市",
"86130451", "黑龙江省哈尔滨市",
"861596678", "山东省威海市",
"861369394", "河南省周口市",
"861773470", "河南省商丘市",
"861569760", "广东省中山市",
"861310662", "广东省湛江市",
"861770581", "浙江省杭州市",
"861334946", "黑龙江省黑河市",
"861394978", "河南省三门峡市",
"861365854", "贵州省黔南布依族苗族自治州",
"861705565", "辽宁省大连市",
"861539452", "福建省福州市",
"861327675", "浙江省绍兴市",
"861815251", "宁夏银川市",
"861533536", "山东省潍坊市",
"861559079", "吉林省白城市",
"861378965", "内蒙古通辽市",
"861569492", "河北省衡水市",
"86147986", "重庆市",
"861310753", "青海省海东地区",
"86177735", "湖南省郴州市",
"861339354", "山西省晋中市",
"861879000", "河南省焦作市",
"861890418", "辽宁省阜新市",
"861471484", "广东省广州市",
"861866824", "浙江省杭州市",
"861877435", "湖南省常德市",
"861818674", "湖北省襄樊市",
"86147435", "广东省广州市",
"861334864", "湖南省衡阳市",
"861581650", "广东省韶关市",
"861581931", "广东省肇庆市",
"861879511", "宁夏银川市",
"861880961", "宁夏银川市",
"861353910", "广东省河源市",
"861571483", "内蒙古阿拉善盟",
"861304139", "吉林省长春市",
"861364527", "江苏省扬州市",
"861336027", "广东省肇庆市",
"861389041", "四川省泸州市",
"861329506", "福建省三明市",
"86182421", "辽宁省朝阳市",
"861895154", "江苏省盐城市",
"861372206", "内蒙古赤峰市",
"861535435", "河北省唐山市",
"861398646", "湖北省孝感市",
"86159573", "浙江省嘉兴市",
"861340649", "山东省威海市",
"861814868", "广东省茂名市",
"861774927", "陕西省宝鸡市",
"861374802", "内蒙古包头市",
"861376806", "广西百色市",
"86152592", "福建省厦门市",
"86156897", "山东省济宁市",
"861855159", "江苏省镇江市",
"86150597", "福建省泉州市",
"86185676", "河南省洛阳市",
"861358244", "河北省张家口市",
"861860820", "四川省南充市",
"861391957", "甘肃省陇南市",
"861513349", "河北省石家庄市",
"861471965", "甘肃省庆阳市",
"861831851", "广东省广州市",
"86151816", "四川省绵阳市",
"861350375", "河南省平顶山市",
"861359962", "福建省龙岩市",
"861501853", "广东省深圳市",
"861867689", "广东省广州市",
"861539177", "安徽省马鞍山市",
"86131482", "河南省周口市",
"861521649", "山东省滨州市",
"861301667", "广东省潮州市",
"86155772", "广西柳州市",
"861831298", "浙江省宁波市",
"861518410", "辽宁省铁岭市",
"86130382", "四川省德阳市",
"861521246", "安徽省黄山市",
"861880770", "广西防城港市",
"86150140", "广东省深圳市",
"861363817", "贵州省毕节地区",
"861774042", "河南省洛阳市",
"861313018", "辽宁省鞍山市",
"861708375", "河南省平顶山市",
"861313738", "河南省信阳市",
"861787534", "广东省广州市",
"861812153", "江苏省无锡市",
"861333321", "河北省石家庄市",
"861829094", "新疆阿勒泰地区",
"86145490", "湖北省荆州市",
"861336942", "甘肃省庆阳市",
"861811936", "甘肃省张掖市",
"861388494", "山东省青岛市",
"861362574", "浙江省宁波市",
"861822651", "安徽省淮北市",
"861570427", "辽宁省盘锦市",
"861884929", "河北省邢台市",
"861581210", "云南省昆明市",
"861532849", "四川省资阳市",
"861529663", "山西省阳泉市",
"861329857", "湖南省衡阳市",
"86156319", "河北省邢台市",
"861510966", "宁夏石嘴山市",
"861363509", "广西梧州市",
"861830535", "山东省烟台市",
"861813484", "新疆吐鲁番地区",
"86180135", "江苏省苏州市",
"861393393", "河北省廊坊市",
"861528917", "西藏阿里地区",
"861329436", "吉林省白城市",
"861769929", "新疆阿克苏地区",
"86150449", "内蒙古包头市",
"861320193", "陕西省咸阳市",
"861323552", "湖北省武汉市",
"861585571", "安徽省宿州市",
"861322626", "广东省湛江市",
"861346315", "河北省唐山市",
"861502933", "陕西省渭南市",
"861450505", "吉林省吉林市",
"861310691", "广东省肇庆市",
"861510476", "内蒙古赤峰市",
"861458540", "河南省漯河市",
"861312543", "辽宁省沈阳市",
"861863396", "河北省唐山市",
"861899950", "新疆克拉玛依市",
"861576888", "广东省广州市",
"861327684", "浙江省宁波市",
"861302279", "山东省临沂市",
"86189442", "江苏省苏州市",
"861569709", "云南省曲靖市",
"861773771", "河南省郑州市",
"861569461", "云南省文山壮族苗族自治州",
"861760549", "山东省临沂市",
"861862690", "吉林省长春市",
"861309948", "云南省德宏傣族景颇族自治州",
"861369512", "广东省揭阳市",
"861816616", "湖南省怀化市",
"861800068", "河北省邢台市",
"86130745", "黑龙江省哈尔滨市",
"861320578", "浙江省丽水市",
"86183493", "四川省成都市",
"861864801", "内蒙古鄂尔多斯市",
"861390075", "海南省海口市",
"861855582", "安徽省马鞍山市",
"861300528", "广东省梅州市",
"861890342", "山西省大同市",
"86186280", "四川省成都市",
"861877505", "广西桂林市",
"86152908", "河南省郑州市",
"861832493", "安徽省宿州市",
"861452779", "广西北海市",
"861533406", "湖北省宜昌市",
"861528081", "福建省龙岩市",
"861886785", "浙江省宁波市",
"861381513", "江苏省无锡市",
"861355549", "黑龙江省大庆市",
"861459373", "贵州省铜仁地区",
"861390389", "河南省焦作市",
"861331826", "广东省中山市",
"861880992", "新疆伊犁哈萨克自治州",
"861505110", "江苏省常州市",
"861348386", "河北省承德市",
"861872948", "陕西省西安市",
"861560873", "云南省红河哈尼族彝族自治州",
"861390265", "广东省惠州市",
"861397283", "湖北省咸宁市",
"861820705", "江西省宜春市",
"861840908", "新疆克孜勒苏柯尔克孜自治州",
"86156846", "山东省滨州市",
"861356380", "山东省泰安市",
"861580723", "湖北省黄石市",
"86189863", "湖北省襄樊市",
"861319845", "四川省内江市",
"861814252", "四川省乐山市",
"861818366", "云南省曲靖市",
"861522047", "广东省河源市",
"861821850", "广东省江门市",
"861471475", "广东省茂名市",
"861302069", "山东省济宁市",
"861820317", "河北省沧州市",
"86139210", "江苏省常州市",
"861339059", "辽宁省沈阳市",
"86184023", "重庆市",
"861870982", "安徽省合肥市",
"861560497", "辽宁省营口市",
"861850542", "山东省聊城市",
"861378377", "河南省南阳市",
"86151940", "山东省临沂市",
"86135672", "浙江省湖州市",
"861360860", "河南省开封市",
"861473609", "广西柳州市",
"86157312", "河北省保定市",
"861459794", "新疆昌吉回族自治州",
"861319667", "江苏省盐城市",
"861859922", "新疆伊犁哈萨克自治州",
"861572673", "西藏山南地区",
"861533759", "福建省南平市",
"861835806", "浙江省舟山市",
"861530457", "黑龙江省大兴安岭地区",
"86133867", "辽宁省鞍山市",
"861595018", "江苏省苏州市",
"861839149", "陕西省铜川市",
"861373351", "湖北省孝感市",
"861818351", "云南省昆明市",
"861538580", "安徽省阜阳市",
"861559793", "贵州省毕节地区",
"861348847", "陕西省西安市",
"86180386", "广东省佛山市",
"861472674", "四川省自贡市",
"861375989", "陕西省西安市",
"86182795", "江西省宜春市",
"861569456", "黑龙江省黑河市",
"861364942", "广西柳州市",
"861362074", "吉林省吉林市",
"86159667", "山东省枣庄市",
"86181935", "甘肃省武威市",
"861843424", "山西省长治市",
"861313518", "湖南省衡阳市",
"86182669", "浙江省金华市",
"861339671", "浙江省杭州市",
"861880880", "云南省昆明市",
"861539496", "云南省普洱市",
"861396580", "安徽省安庆市",
"861771665", "贵州省黔东南苗族侗族自治州",
"861771386", "四川省广安市",
"861809936", "新疆昌吉回族自治州",
"861871821", "广东省湛江市",
"861566642", "山东省青岛市",
"861830715", "湖北省咸宁市",
"861537942", "甘肃省白银市",
"86187060", "福建省南平市",
"861350589", "浙江省金华市",
"861771194", "西藏林芝地区",
"861518401", "辽宁省大连市",
"861822666", "安徽省滁州市",
"861813746", "河南省许昌市",
"861505101", "江苏省宿迁市",
"861334765", "广西玉林市",
"861577103", "湖北省武汉市",
"86150645", "山东省烟台市",
"861568101", "四川省德阳市",
"861880919", "陕西省铜川市",
"861535005", "江西省宜春市",
"86157563", "四川省成都市",
"861378746", "湖南省永州市",
"86139446", "吉林省吉林市",
"861346839", "山东省聊城市",
"861358998", "山东省东营市",
"861311948", "甘肃省武威市",
"861519718", "湖南省湘潭市",
"861836801", "浙江省杭州市",
"86183763", "广西桂林市",
"861390575", "浙江省绍兴市",
"86186693", "山东省威海市",
"861300028", "江苏省南京市",
"861569837", "山西省晋中市",
"861477104", "湖北省荆州市",
"86152958", "广西桂林市",
"861780062", "内蒙古兴安盟",
"861560783", "广西桂林市",
"861510951", "宁夏银川市",
"861309620", "四川省宜宾市",
"861823360", "河北省廊坊市",
"861835103", "江苏省苏州市",
"861510630", "山东省菏泽市",
"861329670", "浙江省温州市",
"861535337", "陕西省汉中市",
"861831944", "广东省广州市",
"861800568", "安徽省阜阳市",
"861780272", "湖北省武汉市",
"861453623", "江苏省盐城市",
"861872620", "安徽省安庆市",
"86180630", "安徽省六安市",
"861350152", "广东省广州市",
"861353593", "广东省茂名市",
"86155821", "山西省晋中市",
"86155244", "辽宁省沈阳市",
"861890708", "江西省南昌市",
"861831866", "广东省中山市",
"861823004", "河北省承德市",
"861320268", "广东省东莞市",
"86856", "贵州省铜仁地区",
"861355049", "四川省巴中市",
"861871543", "安徽省阜阳市",
"86131081", "四川省绵阳市",
"861454171", "浙江省杭州市",
"861452889", "云南省曲靖市",
"861458255", "安徽省蚌埠市",
"861709424", "广东省江门市",
"861769135", "陕西省西安市",
"861454682", "广东省广州市",
"861522547", "河南省开封市",
"861553624", "山西省晋中市",
"861302569", "广东省珠海市",
"861318326", "河南省开封市",
"861335795", "江苏省徐州市",
"861339559", "安徽省黄山市",
"861705284", "广东省深圳市",
"86156910", "陕西省咸阳市",
"861576778", "广东省梅州市",
"861802029", "江苏省无锡市",
"861365755", "新疆喀什地区",
"86139549", "山东省临沂市",
"861530836", "四川省资阳市",
"861353178", "广东省中山市",
"861347097", "安徽省马鞍山市",
"861822079", "陕西省汉中市",
"86136650", "福建省福州市",
"861865635", "安徽省合肥市",
"861580732", "湖南省湘潭市",
"861808635", "湖北省荆州市",
"86135312", "广东省汕头市",
"861332001", "江西省南昌市",
"86177690", "河北省石家庄市",
"86153576", "安徽省阜阳市",
"861369604", "四川省内江市",
"861871480", "安徽省滁州市",
"861861749", "河北省保定市",
"861870398", "河南省三门峡市",
"861896537", "福建省南平市",
"861514706", "内蒙古呼伦贝尔市",
"861880421", "辽宁省朝阳市",
"86187776", "广西百色市",
"861816843", "江苏省连云港市",
"861553351", "河北省秦皇岛市",
"861880388", "河南省商丘市",
"861893647", "江苏省扬州市",
"861838899", "云南省红河哈尼族彝族自治州",
"861315066", "云南省丽江市",
"861842039", "广东省湛江市",
"861868859", "广东省湛江市",
"861394834", "内蒙古乌海市",
"861842719", "湖北省十堰市",
"861388906", "西藏那曲地区",
"861815141", "江苏省镇江市",
"861576935", "甘肃省金昌市",
"86138010", "北京市",
"861372399", "山东省淄博市",
"861580599", "福建省泉州市",
"861316556", "河北省秦皇岛市",
"861869763", "安徽省六安市",
"86130007", "广东省广州市",
"861332510", "山东省济南市",
"861315276", "山西省晋城市",
"861551437", "河南省郑州市",
"861522972", "陕西省榆林市",
"861320915", "陕西省安康市",
"861813425", "河北省唐山市",
"86156475", "内蒙古通辽市",
"861531418", "山东省聊城市",
"861850467", "黑龙江省鸡西市",
"861853401", "山西省朔州市",
"861517138", "湖北省十堰市",
"861512983", "陕西省榆林市",
"861524044", "江苏省苏州市",
"861361782", "广西柳州市",
"861532791", "湖北省襄樊市",
"861866446", "广东省汕头市",
"861511088", "山西省阳泉市",
"861570589", "浙江省金华市",
"86151634", "山东省莱芜市",
"861816146", "四川省南充市",
"861850977", "青海省海西蒙古族藏族自治州",
"861316061", "广东省潮州市",
"861317412", "江苏省扬州市",
"861773420", "河北省邯郸市",
"861803434", "河北省唐山市",
"861834784", "内蒙古包头市",
"861322364", "山西省太原市",
"86135563", "广东省汕头市",
"861533994", "山东省聊城市",
"86136105", "广东省清远市",
"861598077", "福建省厦门市",
"861588988", "广东省中山市",
"861321744", "湖南省张家界市",
"861599180", "陕西省西安市",
"861898549", "贵州省六盘水市",
"861379211", "山东省泰安市",
"861322511", "江苏省镇江市",
"861314788", "辽宁省鞍山市",
"861840546", "山东省东营市",
"861399766", "湖北省宜昌市",
"861828097", "四川省广安市",
"861517561", "河北省唐山市",
"861398582", "贵州省黔东南苗族侗族自治州",
"861364577", "浙江省温州市",
"861571615", "江苏省无锡市",
"861336077", "广东省珠海市",
"86137821", "河南省南阳市",
"86137244", "广东省东莞市",
"861309506", "新疆昌吉回族自治州",
"861876257", "江苏省连云港市",
"861857795", "广西南宁市",
"86147165", "广东省广州市",
"861470795", "江西省宜春市",
"861505640", "安徽省六安市",
"861885702", "浙江省衢州市",
"861775783", "浙江省宁波市",
"861595975", "福建省南平市",
"861322000", "陕西省咸阳市",
"861560605", "福建省漳州市",
"861587764", "陕西省渭南市",
"861802487", "广东省河源市",
"861532213", "广东省惠州市",
"861786619", "甘肃省临夏回族自治州",
"861818624", "湖北省武汉市",
"861338455", "黑龙江省绥化市",
"861361872", "云南省大理白族自治州",
"86185316", "河北省廊坊市",
"861858349", "四川省巴中市",
"861572414", "广东省茂名市",
"861305495", "山东省济宁市",
"861372312", "河南省信阳市",
"861580512", "江苏省连云港市",
"861377935", "新疆石河子市",
"86139875", "云南省保山市",
"861570375", "河南省平顶山市",
"861322987", "广东省珠海市",
"861332501", "山东省青岛市",
"861362329", "河北省邢台市",
"86159029", "陕西省西安市",
"861775176", "江苏省南京市",
"861453632", "江苏省南京市",
"861315566", "安徽省池州市",
"861896305", "山东省菏泽市",
"86156750", "湖南省岳阳市",
"861328941", "陕西省咸阳市",
"861853410", "山西省长治市",
"861383407", "山西省临汾市",
"861380461", "黑龙江省哈尔滨市",
"861700382", "河南省洛阳市",
"86137772", "浙江省宁波市",
"86182027", "湖北省武汉市",
"861708427", "云南省普洱市",
"861593276", "河北省邯郸市",
"861326789", "广东省湛江市",
"86180022", "广东省广州市",
"861337159", "山东省淄博市",
"86158366", "河南省驻马店市",
"861877169", "湖北省孝感市",
"86130057", "广东省惠州市",
"861332010", "江西省鹰潭市",
"861568834", "新疆昌吉回族自治州",
"861332730", "湖南省岳阳市",
"86132052", "江苏省无锡市",
"861458483", "山东省青岛市",
"861509088", "湖北省宜昌市",
"861850831", "四川省宜宾市",
"861303596", "云南省德宏傣族景颇族自治州",
"861316056", "广东省清远市",
"861369723", "湖北省荆州市",
"861500680", "山东省莱芜市",
"861321486", "内蒙古赤峰市",
"861770743", "湖南省湘西土家族苗族自治州",
"861327458", "黑龙江省鸡西市",
"861477831", "广东省惠州市",
"861834446", "广东省汕尾市",
"861350427", "辽宁省盘锦市",
"861576129", "贵州省黔东南苗族侗族自治州",
"861313465", "山西省长治市",
"861389873", "辽宁省盘锦市",
"861399751", "湖北省咸宁市",
"861809312", "甘肃省武威市",
"861558484", "吉林省通化市",
"861705160", "江西省南昌市",
"861524498", "四川省凉山彝族自治州",
"861390918", "陕西省西安市",
"86152718", "湖北省武汉市",
"861323934", "甘肃省庆阳市",
"861860328", "河北省石家庄市",
"861479504", "宁夏固原市",
"861476890", "山东省青岛市",
"861507829", "广西柳州市",
"861860481", "内蒙古呼伦贝尔市",
"861340538", "山东省泰安市",
"861894968", "安徽省淮南市",
"861707871", "云南省红河哈尼族彝族自治州",
"86185849", "四川省成都市",
"861827386", "湖南省怀化市",
"861827665", "广西百色市",
"861313975", "新疆喀什地区",
"861337582", "浙江省湖州市",
"861816021", "新疆乌鲁木齐市",
"861800415", "辽宁省丹东市",
"861550949", "甘肃省兰州市",
"861802374", "广东省清远市",
"861316561", "湖北省宜昌市",
"861333654", "广东省深圳市",
"86177195", "陕西省西安市",
"86132473", "广东省广州市",
"861872006", "江西省南昌市",
"861516412", "辽宁省铁岭市",
"861506675", "山东省烟台市",
"861556103", "内蒙古呼和浩特市",
"861517061", "江西省赣州市",
"861803309", "广东省深圳市",
"861818703", "云南省红河哈尼族彝族自治州",
"861366438", "吉林省松原市",
"861813658", "江苏省常州市",
"861564582", "黑龙江省鸡西市",
"861597443", "湖南省张家界市",
"861517271", "湖北省鄂州市",
"861833602", "河南省商丘市",
"861323828", "辽宁省铁岭市",
"861552660", "吉林省通化市",
"861330905", "四川省内江市",
"861890284", "广东省深圳市",
"861338940", "甘肃省兰州市",
"861709485", "浙江省杭州市",
"861335257", "黑龙江省大兴安岭地区",
"861380971", "广东省汕头市",
"861365297", "广东省揭阳市",
"861573093", "甘肃省天水市",
"86188241", "广东省广州市",
"861557778", "广西柳州市",
"861336577", "安徽省宿州市",
"861874297", "新疆乌鲁木齐市",
"861537077", "江苏省苏州市",
"861500757", "广东省佛山市",
"861768708", "云南省楚雄彝族自治州",
"861379374", "山东省枣庄市",
"861705708", "北京市",
"861315051", "云南省玉溪市",
"861318195", "山东省东营市",
"861351145", "浙江省台州市",
"861505928", "福建省宁德市",
"861311506", "江苏省无锡市",
"861705225", "浙江省杭州市",
"861837549", "山东省临沂市",
"861859933", "新疆昌吉回族自治州",
"861318664", "江苏省淮安市",
"861458797", "湖南省长沙市",
"861300852", "陕西省渭南市",
"861379200", "山东省日照市",
"861322500", "福建省泉州市",
"861813218", "河北省石家庄市",
"861801677", "福建省宁德市",
"861586026", "福建省福州市",
"861589981", "广东省佛山市",
"861380492", "辽宁省鞍山市",
"86133862", "上海市",
"861709964", "浙江省舟山市",
"861580394", "河南省周口市",
"861340408", "四川省南充市",
"861760638", "山东省烟台市",
"86182386", "河南省新乡市",
"861853031", "河南省濮阳市",
"861397357", "湖南省邵阳市",
"861804218", "浙江省台州市",
"861519246", "山东省菏泽市",
"861333214", "辽宁省本溪市",
"86157317", "河北省沧州市",
"86135677", "浙江省温州市",
"86184579", "浙江省金华市",
"861571540", "山东省菏泽市",
"861344129", "江苏省泰州市",
"861519649", "四川省眉山市",
"861850686", "浙江省嘉兴市",
"861370482", "黑龙江省齐齐哈尔市",
"861337813", "四川省德阳市",
"86147344", "重庆市",
"861843143", "河北省保定市",
"861871871", "广东省佛山市",
"861810633", "山东省日照市",
"86184476", "内蒙古呼和浩特市",
"861383537", "山西省临汾市",
"861518842", "河南省漯河市",
"861551892", "河南省信阳市",
"861534086", "山西省晋城市",
"861584947", "内蒙古包头市",
"861860780", "广西崇左市",
"861887276", "湖北省黄石市",
"86156743", "湖南省湘西土家族苗族自治州",
"861458145", "浙江省温州市",
"86139492", "河南省洛阳市",
"861350242", "广东省惠州市",
"861705109", "浙江省宁波市",
"86137531", "山西省太原市",
"861351797", "江西省赣州市",
"861768109", "安徽省阜阳市",
"861318747", "云南省临沧市",
"86186431", "吉林省长春市",
"861399450", "山西省阳泉市",
"861709846", "浙江省台州市",
"861809594", "新疆阿勒泰地区",
"861362024", "广东省河源市",
"86180795", "江西省宜春市",
"86159662", "山东省聊城市",
"861394735", "内蒙古通辽市",
"86155788", "广西南宁市",
"861557179", "湖北省恩施土家族苗族自治州",
"861331098", "陕西省西安市",
"861809448", "江苏省镇江市",
"861362953", "宁夏中卫市",
"861324518", "内蒙古乌兰察布市",
"861332431", "吉林省长春市",
"861862564", "河南省濮阳市",
"861386647", "安徽省池州市",
"861332993", "湖北省黄石市",
"861339621", "山东省菏泽市",
"861311857", "贵州省毕节地区",
"861310310", "河北省邯郸市",
"86180669", "陕西省西安市",
"86130378", "贵州省贵阳市",
"86133443", "天津市",
"861343553", "广东省河源市",
"861331786", "广西南宁市",
"861786661", "山东省济南市",
"8615311", "北京市",
"861337758", "广东省肇庆市",
"86150958", "重庆市",
"861390525", "江苏省扬州市",
"861814360", "吉林省长春市",
"861857894", "广西河池市",
"861886825", "浙江省温州市",
"861322430", "吉林省长春市",
"861399945", "新疆阿勒泰地区",
"861820568", "安徽省阜阳市",
"861890065", "江苏省常州市",
"861833988", "河南省三门峡市",
"861367798", "江西省景德镇市",
"861521538", "山东省泰安市",
"86151108", "山西省朔州市",
"861817754", "广西玉林市",
"861534798", "江西省景德镇市",
"86136036", "黑龙江省哈尔滨市",
"861591715", "广东省云浮市",
"861314052", "河南省南阳市",
"861389832", "辽宁省抚顺市",
"861347441", "陕西省延安市",
"86152645", "山东省烟台市",
"861379079", "广东省惠州市",
"861839656", "福建省南平市",
"861580883", "云南省临沧市",
"861526803", "浙江省舟山市",
"861316592", "浙江省宁波市",
"861589737", "湖南省益阳市",
"861303052", "江西省吉安市",
"86134071", "湖北省武汉市",
"86134003", "河北省保定市",
"861313984", "新疆巴音郭楞蒙古自治州",
"861322569", "安徽省合肥市",
"861838583", "贵州省黔东南苗族侗族自治州",
"861883443", "山西省忻州市",
"861318376", "四川省南充市",
"861891457", "江苏省镇江市",
"861379385", "山东省滨州市",
"861334008", "江西省上饶市",
"861859462", "福建省漳州市",
"861388639", "湖北省孝感市",
"861576728", "广东省江门市",
"861802079", "福建省三明市",
"861567008", "河南省鹤壁市",
"861815390", "甘肃省酒泉市",
"86182630", "山东省德州市",
"861300268", "浙江省温州市",
"861351483", "内蒙古阿拉善盟",
"861453673", "陕西省安康市",
"861454546", "新疆伊犁哈萨克自治州",
"861336489", "新疆和田地区",
"861843846", "河南省平顶山市",
"861890275", "广东省揭阳市",
"861860657", "浙江省金华市",
"861321845", "江苏省苏州市",
"861454121", "河北省石家庄市",
"861508581", "贵州省毕节地区",
"861317702", "湖北省荆州市",
"86145212", "河北省保定市",
"861316019", "江苏省盐城市",
"861888248", "四川省绵阳市",
"861761443", "吉林省延边朝鲜族自治州",
"861372094", "山西省长治市",
"86131487", "广东省深圳市",
"861521853", "广东省潮州市",
"861539127", "内蒙古鄂尔多斯市",
"861379651", "黑龙江省伊春市",
"86183866", "贵州省黔东南苗族侗族自治州",
"861501649", "广东省云浮市",
"861880720", "湖北省宜昌市",
"861586526", "山东省济南市",
"861303189", "河北省沧州市",
"861568015", "四川省南充市",
"861501246", "广东省深圳市",
"86152140", "甘肃省兰州市",
"86130387", "甘肃省兰州市",
"861769530", "宁夏吴忠市",
"861860870", "云南省昭通市",
"861524349", "河北省秦皇岛市",
"86156892", "山东省潍坊市",
"861304367", "湖南省娄底市",
"86152597", "福建省泉州市",
"861313367", "江西省吉安市",
"861310301", "河北省石家庄市",
"861350325", "河北省唐山市",
"861330235", "广东省清远市",
"861863209", "河北省邢台市",
"861805113", "江苏省苏州市",
"86189599", "福建省泉州市",
"861571040", "陕西省西安市",
"861819677", "安徽省马鞍山市",
"86135688", "四川省成都市",
"861532653", "黑龙江省牡丹江市",
"86188534", "山东省德州市",
"861769701", "青海省西宁市",
"86183631", "山东省威海市",
"861368397", "河南省信阳市",
"861309857", "贵州省毕节地区",
"861570477", "内蒙古鄂尔多斯市",
"861356179", "山东省泰安市",
"861560541", "山东省济南市",
"861569921", "新疆乌鲁木齐市",
"86182135", "云南省昆明市",
"861566086", "河南省新乡市",
"861534586", "浙江省台州市",
"861338357", "山西省临汾市",
"861811448", "江苏省南京市",
"861858544", "贵州省黔南布依族苗族自治州",
"861380419", "辽宁省辽阳市",
"861508917", "广东省珠海市",
"861472703", "浙江省宁波市",
"861857147", "湖北省武汉市",
"861361558", "安徽省阜阳市",
"861772924", "陕西省安康市",
"861362524", "江苏省宿迁市",
"86180465", "北京市",
"861331444", "贵州省黔南布依族苗族自治州",
"86137865", "湖南省郴州市",
"861331598", "河北省石家庄市",
"861333371", "河南省郑州市",
"861329948", "广西河池市",
"861375442", "河北省保定市",
"861893764", "河南省郑州市",
"861780345", "山西省朔州市",
"861820068", "广东省茂名市",
"861323204", "广东省阳江市",
"861890565", "安徽省巢湖市",
"861554597", "黑龙江省哈尔滨市",
"861317348", "山东省泰安市",
"861881213", "河北省张家口市",
"861452729", "湖北省武汉市",
"861855249", "江苏省徐州市",
"861871937", "广东省广州市",
"861300578", "广东省珠海市",
"861562945", "湖北省荆州市",
"861390025", "广东省广州市",
"861868816", "广东省珠海市",
"861510426", "辽宁省铁岭市",
"861536758", "湖南省怀化市",
"861302626", "江西省宜春市",
"861309436", "云南省保山市",
"861512150", "贵州省毕节地区",
"861303552", "贵州省遵义市",
"86188270", "湖北省武汉市",
"861322676", "广东省河源市",
"861522491", "河南省驻马店市",
"861570967", "宁夏银川市",
"86151158", "湖南省娄底市",
"861773721", "河南省周口市",
"86189447", "广东省东莞市",
"861892471", "广东省珠海市",
"861566798", "陕西省铜川市",
"861314552", "安徽省蚌埠市",
"861521718", "广东省珠海市",
"861379579", "四川省阿坝藏族羌族自治州",
"861334508", "山东省临沂市",
"861818413", "贵州省安顺市",
"861537489", "内蒙古锡林郭勒盟",
"861700154", "江苏省无锡市",
"861590851", "贵州省贵阳市",
"861580773", "广西桂林市",
"861539234", "福建省宁德市",
"86152546", "山东省东营市",
"861802579", "广东省汕尾市",
"861354839", "四川省阿坝藏族羌族自治州",
"861322069", "山东省淄博市",
"861872436", "黑龙江省绥化市",
"861595984", "福建省三明市",
"861352632", "河南省商丘市",
"861517739", "广西河池市",
"861800317", "河北省沧州市",
"861517019", "江西省赣州市",
"861772838", "广东省中山市",
"861373413", "山西省临汾市",
"861516702", "浙江省绍兴市",
"861508081", "湖南省娄底市",
"861459323", "四川省广安市",
"86153324", "陕西省西安市",
"861565081", "安徽省宿州市",
"861316519", "山东省济宁市",
"861560823", "四川省成都市",
"861364489", "内蒙古兴安盟",
"861800705", "江西省宜春市",
"861365411", "辽宁省大连市",
"86187824", "四川省成都市",
"861324406", "吉林省四平市",
"861362637", "山东省德州市",
"86139813", "四川省乐山市",
"861773749", "河南省郑州市",
"861760571", "浙江省杭州市",
"861521559", "安徽省黄山市",
"861318185", "山东省东营市",
"861585549", "安徽省阜阳市",
"861839238", "陕西省西安市",
"861787677", "广东省梅州市",
"86189260", "广东省深圳市",
"861859328", "广西桂林市",
"861335724", "湖南省衡阳市",
"861345309", "山西省朔州市",
"861458787", "湖南省衡阳市",
"861336702", "江西省九江市",
"861810957", "宁夏银川市",
"861709495", "浙江省台州市",
"861337739", "广西北海市",
"861452741", "湖南省长沙市",
"861869831", "福建省漳州市",
"861586380", "山东省烟台市",
"8618721", "上海市",
"861350723", "湖北省黄石市",
"861874287", "新疆巴音郭楞蒙古自治州",
"861308287", "浙江省舟山市",
"861508562", "贵州省遵义市",
"861367320", "河北省邯郸市",
"861566052", "河南省周口市",
"861534552", "安徽省蚌埠市",
"861817442", "湖南省长沙市",
"861847530", "广东省阳江市",
"86180583", "浙江省温州市",
"861364348", "山西省晋中市",
"86133158", "河北省衡水市",
"861838901", "西藏拉萨市",
"861309160", "黑龙江省伊春市",
"861332150", "吉林省吉林市",
"861330426", "辽宁省大连市",
"86185848", "四川省成都市",
"861866794", "浙江省杭州市",
"861820450", "黑龙江省哈尔滨市",
"861820693", "云南省西双版纳傣族自治州",
"861470875", "云南省保山市",
"861363684", "陕西省榆林市",
"86153613", "广东省中山市",
"861802176", "江苏省徐州市",
"861337592", "福建省厦门市",
"86796", "江西省吉安市",
"861811120", "四川省泸州市",
"861819996", "新疆巴音郭楞蒙古自治州",
"861388658", "湖北省荆州市",
"861537348", "河北省唐山市",
"861390936", "甘肃省张掖市",
"861367552", "安徽省蚌埠市",
"861534320", "湖南省岳阳市",
"861590673", "浙江省嘉兴市",
"86182454", "黑龙江省佳木斯市",
"861565903", "福建省福州市",
"861472717", "浙江省湖州市",
"861771125", "四川省达州市",
"861831623", "广东省肇庆市",
"861558548", "吉林省白山市",
"861570099", "新疆克孜勒苏柯尔克孜自治州",
"861700835", "浙江省嘉兴市",
"861830451", "黑龙江省哈尔滨市",
"861844566", "黑龙江省哈尔滨市",
"861524488", "四川省内江市",
"861832540", "山东省菏泽市",
"861860933", "甘肃省平凉市",
"861476880", "山东省德州市",
"861327509", "福建省南平市",
"861860491", "辽宁省朝阳市",
"861311342", "广东省珠海市",
"861329065", "河北省唐山市",
"861323642", "江苏省徐州市",
"861458650", "湖北省荆州市",
"861458493", "山东省淄博市",
"86150080", "海南省海口市",
"861838779", "云南省玉溪市",
"861518357", "四川省达州市",
"861820945", "甘肃省金昌市",
"861509098", "湖北省鄂州市",
"861828900", "西藏拉萨市",
"861760256", "江苏省徐州市",
"861303586", "广东省阳江市",
"861501621", "广东省河源市",
"861327817", "吉林省白城市",
"861829525", "宁夏中卫市",
"861511173", "青海省海东地区",
"861881207", "河北省沧州市",
"861500690", "山东省日照市",
"861500453", "黑龙江省牡丹江市",
"861809575", "青海省果洛藏族自治州",
"861760659", "浙江省宁波市",
"861512867", "河北省廊坊市",
"86159028", "四川省成都市",
"861775200", "甘肃省定西市",
"861348570", "安徽省合肥市",
"861801167", "四川省乐山市",
"861580375", "河南省平顶山市",
"861570512", "江苏省连云港市",
"861530301", "广东省清远市",
"86136787", "云南省昆明市",
"861533367", "山西省临汾市",
"861309708", "江西省上饶市",
"861361719", "湖北省十堰市",
"861593100", "河北省邯郸市",
"861823689", "河南省焦作市",
"861326799", "广东省珠海市",
"861346947", "湖南省娄底市",
"861354533", "湖北省襄樊市",
"861361039", "广东省湛江市",
"86178283", "四川省成都市",
"861705006", "北京市",
"861561502", "山东省聊城市",
"861316813", "广东省湛江市",
"861806232", "湖北省咸宁市",
"861597747", "广西南宁市",
"861356576", "新疆巴音郭楞蒙古自治州",
"861371722", "广东省肇庆市",
"861569949", "新疆伊犁哈萨克自治州",
"861811389", "四川省雅安市",
"861305485", "山东省淄博市",
"861560529", "江苏省镇江市",
"861571827", "广东省汕尾市",
"861315111", "江苏省扬州市",
"861532871", "四川省内江市",
"861319127", "山西省临汾市",
"861368485", "江西省萍乡市",
"861370709", "江西省南昌市",
"861370461", "黑龙江省齐齐哈尔市",
"86138772", "广西柳州市",
"861453944", "广东省江门市",
"861373407", "山西省临汾市",
"861477763", "广西玉林市",
"861470785", "广西玉林市",
"861585049", "江苏省南通市",
"861536739", "湖南省邵阳市",
"861347429", "陕西省西安市",
"861853678", "山西省晋中市",
"861802497", "广东省肇庆市",
"861337807", "湖南省益阳市",
"86138821", "四川省成都市",
"861552918", "陕西省宝鸡市",
"86138244", "广东省广州市",
"861359368", "湖北省黄冈市",
"861532937", "贵州省毕节地区",
"861370456", "黑龙江省黑河市",
"861398592", "贵州省六盘水市",
"861776619", "江苏省无锡市",
"861565062", "安徽省宿州市",
"861372120", "安徽省芜湖市",
"861529826", "四川省泸州市",
"861353955", "广东省珠海市",
"861364702", "江西省九江市",
"861850763", "广东省清远市",
"861337519", "江苏省苏州市",
"861538376", "河北省廊坊市",
"861598348", "四川省广安市",
"861875702", "浙江省衢州市",
"861512645", "云南省临沧市",
"861308400", "安徽省宿州市",
"861508272", "四川省巴中市",
"861300445", "江苏省泰州市",
"861355071", "四川省宜宾市",
"861520564", "安徽省六安市",
"861454149", "吉林省白山市",
"861303798", "宁夏银川市",
"861536592", "江苏省淮安市",
"861599190", "陕西省咸阳市",
"861453851", "甘肃省临夏回族自治州",
"861566552", "安徽省蚌埠市",
"861336348", "山西省运城市",
"861314798", "辽宁省盘锦市",
"861830466", "黑龙江省七台河市",
"861828087", "四川省遂宁市",
"861531436", "山东省滨州市",
"861367052", "广东省汕头市",
"861385227", "江苏省宿迁市",
"86182404", "辽宁省沈阳市",
"861340736", "湖南省常德市",
"861394333", "吉林省松原市",
"861520311", "河北省石家庄市",
"861340016", "河北省保定市",
"861822041", "陕西省延安市",
"861771570", "四川省泸州市",
"861398019", "四川省达州市",
"86159524", "江苏省苏州市",
"861772859", "广东省肇庆市",
"861816344", "广东省东莞市",
"86156413", "辽宁省抚顺市",
"861337092", "山东省烟台市",
"861361970", "青海省海北藏族自治州",
"861811575", "江苏省无锡市",
"86151443", "吉林省吉林市",
"861356669", "浙江省台州市",
"861373280", "吉林省辽源市",
"861530310", "河北省邯郸市",
"861340354", "山西省晋中市",
"861300950", "内蒙古呼和浩特市",
"861519621", "四川省阿坝藏族羌族自治州",
"861512993", "陕西省西安市",
"861832040", "广东省广州市",
"861343859", "四川省泸州市",
"861515617", "安徽省淮北市",
"861509173", "陕西省汉中市",
"861361792", "江西省九江市",
"86137010", "北京市",
"861700319", "河北省邢台市",
"861532781", "湖北省咸宁市",
"86181731", "湖南省长沙市",
"861331752", "湖北省荆门市",
"86182991", "新疆乌鲁木齐市",
"861818280", "黑龙江省哈尔滨市",
"86134214", "广东省中山市",
"86153478", "广西玉林市",
"86150343", "山西省临汾市",
"861361460", "黑龙江省牡丹江市",
"861303086", "福建省莆田市",
"861538747", "湖南省衡阳市",
"861372389", "湖南省长沙市",
"861580589", "浙江省金华市",
"861385134", "江苏省盐城市",
"861309342", "安徽省六安市",
"86183399", "河南省郑州市",
"861390660", "浙江省宁波市",
"861334416", "吉林省长春市",
"8613482", "上海市",
"861527532", "山东省青岛市",
"86186395", "河南省漯河市",
"861329565", "安徽省芜湖市",
"86136111", "北京市",
"861830976", "青海省玉树藏族自治州",
"861338842", "浙江省杭州市",
"861315100", "江苏省无锡市",
"86183817", "四川省南充市",
"861846233", "山东省临沂市",
"861354713", "四川省绵阳市",
"861339649", "山东省滨州市",
"861880398", "河南省三门峡市",
"861838889", "云南省临沧市",
"861361539", "山东省临沂市",
"861570732", "湖南省长沙市",
"861372075", "陕西省西安市",
"86158672", "浙江省宁波市",
"861328353", "山西省阳泉市",
"861840302", "河北省保定市",
"861555999", "云南省曲靖市",
"861339246", "广东省广州市",
"861828911", "西藏拉萨市",
"861311708", "湖北省黄冈市",
"861378906", "湖南省株洲市",
"861705506", "河南省郑州市",
"861819167", "陕西省西安市",
"86151862", "贵州省六盘水市",
"861813906", "新疆巴音郭楞蒙古自治州",
"861870421", "辽宁省朝阳市",
"86188776", "广西百色市",
"861871490", "安徽省宿州市",
"861508091", "湖南省邵阳市",
"861882436", "广东省东莞市",
"86156227", "广东省广州市",
"861383413", "山西省太原市",
"861531506", "山东省东营市",
"861565091", "青海省海南藏族自治州",
"861535051", "河北省邯郸市",
"861570773", "广西桂林市",
"861898021", "四川省内江市",
"861317077", "云南省丽江市",
"861364499", "辽宁省沈阳市",
"86145920", "四川省成都市",
"861896703", "浙江省衢州市",
"861365530", "山东省菏泽市",
"861534878", "云南省楚雄彝族自治州",
"861559541", "宁夏银川市",
"861707762", "云南省昆明市",
"861308530", "云南省西双版纳傣族自治州",
"861816049", "新疆昌吉回族自治州",
"861550921", "陕西省榆林市",
"861518940", "江苏省南通市",
"861595994", "福建省南平市",
"861515257", "江苏省淮安市",
"861510905", "新疆喀什地区",
"861470774", "广西梧州市",
"861387205", "湖北省黄石市",
"861598412", "四川省宜宾市",
"861821815", "广东省湛江市",
"861592242", "安徽省合肥市",
"861871213", "安徽省宿州市",
"861509132", "陕西省西安市",
"861837521", "贵州省黔南布依族苗族自治州",
"861300183", "河北省廊坊市",
"861522481", "河南省平顶山市",
"861306954", "河南省许昌市",
"861345504", "山东省日照市",
"861321452", "黑龙江省齐齐哈尔市",
"861527198", "湖北省襄樊市",
"86151159", "湖南省邵阳市",
"861336412", "辽宁省鞍山市",
"861337061", "山东省泰安市",
"861579809", "江西省萍乡市",
"861566788", "陕西省安康市",
"861770345", "山西省长治市",
"861897178", "湖北省黄石市",
"861837146", "湖北省武汉市",
"861458201", "安徽省淮北市",
"861828230", "四川省自贡市",
"86189902", "四川省德阳市",
"861575146", "江苏省盐城市",
"861513654", "河南省安阳市",
"861847411", "湖南省益阳市",
"861536561", "江苏省泰州市",
"861396664", "安徽省安庆市",
"861365701", "江西省鹰潭市",
"861317267", "河北省邢台市",
"86187270", "湖北省襄樊市",
"861346522", "山东省威海市",
"86139956", "湖北省武汉市",
"861308701", "河南省信阳市",
"86150909", "湖北省宜昌市",
"86184074", "湖南省长沙市",
"861533975", "甘肃省武威市",
"861528447", "云南省丽江市",
"861768857", "广东省云浮市",
"861308469", "浙江省丽水市",
"861580967", "宁夏中卫市",
"86159376", "河南省信阳市",
"861820766", "广东省云浮市",
"861373037", "河北省廊坊市",
"861315169", "江苏省镇江市",
"861358014", "广东省韶关市",
"861841953", "甘肃省平凉市",
"861370419", "辽宁省辽阳市",
"861556117", "内蒙古乌海市",
"861554900", "湖北省荆州市",
"86131675", "北京市",
"861508233", "四川省眉山市",
"861573812", "河南省商丘市",
"861818717", "云南省文山壮族苗族自治州",
"861390609", "福建省泉州市",
"861842058", "广东省清远市",
"86187534", "山东省德州市",
"861868838", "广东省广州市",
"861331588", "河北省承德市",
"861308979", "黑龙江省鸡西市",
"861337556", "山东省青岛市",
"861362341", "山西省太原市",
"861580477", "内蒙古鄂尔多斯市",
"861818037", "四川省阿坝藏族羌族自治州",
"861874979", "河南省焦作市",
"861361409", "辽宁省大连市",
"86135689", "四川省成都市",
"861309418", "湖北省宜昌市",
"861373305", "安徽省黄山市",
"861824494", "广东省广州市",
"861368387", "河南省驻马店市",
"861807570", "湖南省岳阳市",
"86184587", "浙江省温州市",
"861360422", "辽宁省鞍山市",
"861858321", "四川省内江市",
"861525245", "江苏省南京市",
"861534596", "福建省南平市",
"861327060", "江苏省连云港市",
"861566096", "河南省南阳市",
"861810340", "山西省晋城市",
"861811584", "江苏省苏州市",
"861521736", "广东省东莞市",
"861886617", "山东省潍坊市",
"861870720", "湖北省宜昌市",
"861507841", "广西玉林市",
"861517159", "湖北省咸宁市",
"861551772", "河南省南阳市",
"861327304", "河南省开封市",
"861313248", "河北省邢台市",
"861575843", "云南省临沧市",
"861366706", "江西省赣州市",
"861304248", "辽宁省大连市",
"861872418", "江苏省宿迁市",
"861345142", "河北省邯郸市",
"861700014", "广东省广州市",
"861351877", "云南省玉溪市",
"861700734", "湖南省衡阳市",
"86189598", "福建省泉州市",
"861389930", "新疆吐鲁番地区",
"861372084", "福建省泉州市",
"861887111", "湖北省鄂州市",
"861839908", "新疆喀什地区",
"861314199", "江苏省泰州市",
"86181572", "浙江省湖州市",
"86151450", "黑龙江省哈尔滨市",
"86150350", "山西省运城市",
"861303199", "河北省邯郸市",
"861454748", "浙江省丽水市",
"861527263", "湖北省荆州市",
"861813236", "河北省唐山市",
"861815380", "湖南省岳阳市",
"861777167", "湖北省宜昌市",
"86139927", "陕西省宝鸡市",
"861351493", "安徽省阜阳市",
"861318443", "浙江省嘉兴市",
"861552170", "广东省广州市",
"861336499", "新疆克拉玛依市",
"861317577", "浙江省丽水市",
"861351931", "甘肃省兰州市",
"861813639", "江苏省常州市",
"861898146", "四川省达州市",
"861458210", "安徽省铜陵市",
"861786908", "云南省保山市",
"861452440", "黑龙江省齐齐哈尔市",
"861366459", "黑龙江省大庆市",
"861300347", "江苏省连云港市",
"861804236", "浙江省衢州市",
"861536271", "广东省中山市",
"861345360", "山西省晋城市",
"861847400", "湖南省常德市",
"86187038", "河南省郑州市",
"86178623", "山东省日照市",
"861874710", "内蒙古包头市",
"861379395", "山东省东营市",
"861308710", "内蒙古呼和浩特市",
"861318174", "山东省济南市",
"861516077", "福建省泉州市",
"861365710", "湖北省襄樊市",
"861874030", "陕西省西安市",
"861566878", "辽宁省葫芦岛市",
"861868553", "贵州省遵义市",
"861308030", "山西省忻州市",
"861882670", "广东省阳江市",
"861802395", "广东省茂名市",
"861807125", "湖北省咸宁市",
"861867434", "湖南省湘西土家族苗族自治州",
"86151109", "青海省西宁市",
"86155804", "湖南省湘西土家族苗族自治州",
"861337561", "山东省聊城市",
"861364412", "辽宁省鞍山市",
"861475630", "河北省张家口市",
"861478722", "云南省大理白族自治州",
"861827175", "湖北省孝感市",
"861306523", "辽宁省铁岭市",
"861869365", "甘肃省武威市",
"861316582", "浙江省嘉兴市",
"861860972", "青海省海东地区",
"861597195", "湖北省荆门市",
"861305846", "广东省潮州市",
"861820751", "广东省韶关市",
"861381243", "江苏省连云港市",
"861470884", "云南省昆明市",
"861363675", "陕西省宝鸡市",
"861313994", "新疆昌吉回族自治州",
"861598499", "四川省凉山彝族自治州",
"861331796", "江西省吉安市",
"861337314", "河北省承德市",
"861579737", "湖北省黄冈市",
"86139906", "四川省乐山市",
"86150959", "重庆市",
"861324536", "山东省日照市",
"86177931", "甘肃省兰州市",
"861896624", "浙江省宁波市",
"86189094", "甘肃省兰州市",
"861309109", "河北省石家庄市",
"861865429", "安徽省六安市",
"86189952", "宁夏石嘴山市",
"861828479", "四川省遂宁市",
"861564561", "黑龙江省大庆市",
"861808429", "贵州省黔西南布依族苗族自治州",
"86156256", "广东省揭阳市",
"861570883", "云南省临沧市",
"861554087", "内蒙古包头市",
"861367788", "广西南宁市",
"861809584", "新疆博尔塔拉蒙古自治州",
"861454302", "黑龙江省齐齐哈尔市",
"86138531", "山东省济南市",
"861774696", "河南省郑州市",
"86155789", "广西南宁市",
"861815129", "江苏省徐州市",
"861320726", "湖北省十堰市",
"861331088", "广东省广州市",
"861300776", "青海省西宁市",
"861818537", "贵州省黔西南布依族苗族自治州",
"861599341", "河南省商丘市",
"861859657", "福建省厦门市",
"861337138", "山东省烟台市",
"861367096", "广东省湛江市",
"861332983", "湖北省恩施土家族苗族自治州",
"861831805", "广东省深圳市",
"861877276", "湖北省十堰市",
"861361334", "河北省秦皇岛市",
"86158899", "广东省广州市",
"861311418", "云南省西双版纳傣族自治州",
"86180668", "陕西省西安市",
"861376647", "江西省上饶市",
"861801952", "安徽省芜湖市",
"861534096", "山西省运城市",
"861327560", "安徽省合肥市",
"861589157", "陕西省延安市",
"861860790", "江西省新余市",
"861535276", "新疆巴音郭楞蒙古自治州",
"861595248", "江苏省无锡市",
"861705670", "辽宁省沈阳市",
"86135485", "湖南省长沙市",
"861450276", "内蒙古赤峰市",
"86151775", "广西玉林市",
"861357117", "陕西省宝鸡市",
"861535679", "浙江省金华市",
"861773148", "河北省唐山市",
"861860462", "黑龙江省齐齐哈尔市",
"861894545", "黑龙江省伊春市",
"86145329", "山西省太原市",
"861590632", "山东省枣庄市",
"861351787", "广西南宁市",
"861807070", "广西南宁市",
"861830750", "广东省江门市",
"861368474", "内蒙古呼和浩特市",
"861570394", "河南省周口市",
"861370760", "河南省许昌市",
"86185367", "山西省临汾市",
"861700514", "江苏省扬州市",
"861535066", "河北省唐山市",
"86184578", "浙江省丽水市",
"861328135", "四川省德阳市",
"861573899", "河南省平顶山市",
"861340559", "江苏省镇江市",
"861807260", "浙江省湖州市",
"861370492", "辽宁省鞍山市",
"861334706", "内蒙古鄂尔多斯市",
"861452955", "广东省珠海市",
"86150300", "河北省邯郸市",
"861525550", "安徽省马鞍山市",
"861700361", "广东省深圳市",
"861380482", "黑龙江省牡丹江市",
"861589991", "广东省东莞市",
"861567706", "广西桂林市",
"86131576", "浙江省台州市",
"861593169", "河北省石家庄市",
"861526304", "山东省青岛市",
"861327439", "吉林省白山市",
"86158317", "河北省沧州市",
"861552025", "四川省雅安市",
"861775269", "湖南省娄底市",
"861301904", "黑龙江省双鸭山市",
"86151400", "辽宁省沈阳市",
"861348175", "广西柳州市",
"861528062", "福建省漳州市",
"861310836", "四川省甘孜藏族自治州",
"86134225", "广东省江门市",
"861571650", "河南省许昌市",
"861571493", "新疆和田地区",
"861558639", "湖北省襄樊市",
"861571931", "甘肃省兰州市",
"861846447", "山东省莱芜市",
"861519559", "江苏省扬州市",
"861590704", "江西省抚州市",
"861360157", "江苏省苏州市",
"861899896", "广东省汕头市",
"861538326", "河北省廊坊市",
"861558236", "山西省临汾市",
"861471548", "广东省东莞市",
"861471494", "广东省佛山市",
"861384802", "内蒙古包头市",
"861559395", "甘肃省白银市",
"861889511", "宁夏银川市",
"861584707", "内蒙古鄂尔多斯市",
"861873907", "河南省洛阳市",
"861870961", "宁夏银川市",
"861347479", "内蒙古锡林郭勒盟",
"861302166", "山东省青岛市",
"861771520", "江苏省盐城市",
"861369384", "河南省南阳市",
"861500311", "河北省石家庄市",
"861315337", "山东省淄博市",
"861770591", "福建省福州市",
"861330630", "山东省威海市",
"861330951", "宁夏银川市",
"861802041", "江苏省常州市",
"86188851", "贵州省贵阳市",
"861335884", "辽宁省葫芦岛市",
"861890857", "贵州省毕节地区",
"861339038", "辽宁省盘锦市",
"861595406", "山东省威海市",
"861569482", "河北省沧州市",
"861386557", "安徽省宿州市",
"861500564", "安徽省六安市",
"861840692", "云南省德宏傣族景颇族自治州",
"861328400", "黑龙江省哈尔滨市",
"861359737", "广西玉林市",
"861390094", "甘肃省兰州市",
"861323798", "江西省景德镇市",
"861315005", "甘肃省甘南藏族自治州",
"861508222", "四川省乐山市",
"861884854", "贵州省铜仁地区",
"861771352", "四川省攀枝花市",
"861830313", "河北省张家口市",
"861821996", "甘肃省张掖市",
"861815888", "安徽省合肥市",
"861780581", "浙江省杭州市",
"861866916", "云南省昆明市",
"861554429", "河南省新乡市",
"861819714", "青海省西宁市",
"861350883", "云南省红河哈尼族彝族自治州",
"861388475", "山东省泰安市",
"861362595", "福建省泉州市",
"861338769", "湖北省恩施土家族苗族自治州",
"86137789", "四川省宜宾市",
"861338401", "河南省郑州市",
"861822783", "四川省眉山市",
"861847135", "湖北省咸宁市",
"861334363", "河南省濮阳市",
"861809025", "四川省广元市",
"861899578", "湖北省黄石市",
"861839546", "陕西省榆林市",
"861829075", "新疆石河子市",
"861317942", "江苏省泰州市",
"861772995", "安徽省宣城市",
"861835117", "江苏省泰州市",
"861708394", "河南省周口市",
"861309565", "浙江省绍兴市",
"861553537", "山西省太原市",
"861769854", "河南省洛阳市",
"861346533", "山东省淄博市",
"86130619", "上海市",
"861572298", "江苏省无锡市",
"861879863", "贵州省贵阳市",
"861585638", "安徽省合肥市",
"861560269", "广东省东莞市",
"861556647", "辽宁省葫芦岛市",
"861306032", "陕西省渭南市",
"861519182", "陕西省榆林市",
"861509123", "陕西省渭南市",
"861572851", "广东省韶关市",
"861319496", "四川省成都市",
"861519671", "四川省内江市",
"861320631", "山东省威海市",
"861307009", "新疆石河子市",
"86135898", "山东省烟台市",
"861320950", "宁夏银川市",
"861577117", "湖北省宜昌市",
"861811525", "江苏省徐州市",
"861776748", "新疆哈密地区",
"861560385", "河南省许昌市",
"861560666", "浙江省温州市",
"861478513", "贵州省安顺市",
"86138788", "广西南宁市",
"861311065", "福建省漳州市",
"861890436", "吉林省白城市",
"86180991", "新疆乌鲁木齐市",
"861571787", "湖北省黄冈市",
"861592967", "陕西省渭南市",
"861350394", "河南省周口市",
"861374911", "河南省郑州市",
"86156682", "山东省菏泽市",
"861454656", "云南省丽江市",
"861869927", "新疆哈密地区",
"86137291", "广东省湛江市",
"861318580", "浙江省舟山市",
"861887641", "福建省厦门市",
"861779067", "黑龙江省佳木斯市",
"861452583", "福建省宁德市",
"861871849", "广东省中山市",
"861507799", "安徽省淮北市",
"861870471", "内蒙古呼和浩特市",
"861860547", "山东省济宁市",
"861550492", "辽宁省鞍山市",
"861359981", "福建省宁德市",
"861381335", "江苏省南京市",
"86151867", "贵州省遵义市",
"861301177", "山东省泰安市",
"861310457", "黑龙江省大兴安岭地区",
"861339853", "贵州省安顺市",
"86186786", "山东省东营市",
"861313759", "河南省开封市",
"861524214", "辽宁省鞍山市",
"861596401", "山东省济南市",
"861321127", "广东省江门市",
"861335393", "河南省濮阳市",
"86183812", "四川省攀枝花市",
"861538913", "陕西省渭南市",
"861552584", "山西省吕梁市",
"86158677", "浙江省温州市",
"861576611", "广东省梅州市",
"861365353", "山西省阳泉市",
"86177325", "河北省唐山市",
"861777404", "浙江省湖州市",
"861557141", "湖北省十堰市",
"861304759", "江苏省宿迁市",
"861308353", "江苏省徐州市",
"861519059", "江苏省苏州市",
"861584839", "内蒙古呼和浩特市",
"861523508", "山西省朔州市",
"861593005", "河北省邢台市",
"86185209", "广东省佛山市",
"861508345", "河南省信阳市",
"861572944", "河南省郑州市",
"861347230", "河北省保定市",
"861454661", "广东省广州市",
"861891301", "江苏省南京市",
"861528562", "贵州省贵阳市",
"861350773", "广西桂林市",
"861328287", "浙江省温州市",
"861760521", "江苏省镇江市",
"861304406", "山东省临沂市",
"861889011", "湖南省郴州市",
"861867252", "湖北省黄冈市",
"861892449", "广东省汕尾市",
"861328411", "辽宁省大连市",
"861322241", "江苏省镇江市",
"861593337", "河北省邢台市",
"861889731", "青海省海北藏族自治州",
"861369477", "内蒙古赤峰市",
"861585282", "江苏省无锡市",
"861346858", "陕西省延安市",
"861335774", "江苏省镇江市",
"861371990", "广东省汕头市",
"861787627", "广东省梅州市",
"86147638", "山东省潍坊市",
"861313406", "江西省吉安市",
"861811170", "四川省成都市",
"861800450", "黑龙江省哈尔滨市",
"861800693", "福建省福州市",
"861339538", "山东省泰安市",
"861361648", "山东省青岛市",
"861876884", "河南省许昌市",
"86180454", "黑龙江省佳木斯市",
"86132941", "湖北省武汉市",
"86188873", "云南省红河哈尼族彝族自治州",
"861845828", "浙江省湖州市",
"861807184", "湖北省黄冈市",
"861534370", "河南省商丘市",
"861528903", "西藏山南地区",
"861591451", "广东省广州市",
"861597326", "湖南省郴州市",
"86182583", "浙江省嘉兴市",
"861363803", "贵州省黔南布依族苗族自治州",
"861560651", "浙江省杭州市",
"861367370", "河南省商丘市",
"861561423", "河北省保定市",
"861532543", "浙江省舟山市",
"861560930", "甘肃省临夏回族自治州",
"861330476", "内蒙古赤峰市",
"861390448", "吉林省延边朝鲜族自治州",
"861785823", "浙江省衢州市",
"861530691", "福建省福州市",
"861889500", "宁夏银川市",
"861786546", "山东省东营市",
"861572866", "广东省中山市",
"861390594", "福建省莆田市",
"86181663", "重庆市",
"861896366", "江苏省苏州市",
"861890670", "浙江省衢州市",
"861303642", "四川省泸州市",
"861838729", "云南省楚雄彝族自治州",
"86181191", "新疆乌鲁木齐市",
"861357647", "江西省新余市",
"86159616", "江苏省无锡市",
"861800945", "甘肃省金昌市",
"861550419", "辽宁省辽阳市",
"861808900", "西藏拉萨市",
"861332055", "云南省大理白族自治州",
"86131315", "河北省唐山市",
"86158688", "浙江省杭州市",
"86130415", "江苏省常州市",
"861330966", "安徽省安庆市",
"861520453", "黑龙江省牡丹江市",
"86187815", "四川省凉山彝族自治州",
"861323586", "浙江省台州市",
"861521621", "江西省宜春市",
"861366363", "山西省阳泉市",
"861839046", "湖南省郴州市",
"861301496", "广西玉林市",
"861889987", "广东省佛山市",
"861833382", "河北省衡水市",
"861302151", "山东省淄博市",
"861501671", "广东省深圳市",
"861596410", "山东省济宁市",
"86157689", "广东省广州市",
"861855556", "安徽省安庆市",
"86189239", "广东省汕头市",
"861311565", "黑龙江省绥化市",
"861831673", "广东省揭阳市",
"861879997", "新疆伊犁哈萨克自治州",
"861771175", "湖南省怀化市",
"861306532", "辽宁省阜新市",
"861533738", "湖北省黄石市",
"861344076", "上海市",
"861861470", "内蒙古呼伦贝尔市",
"861811025", "安徽省芜湖市",
"861576600", "广东省深圳市",
"86150719", "湖北省荆门市",
"861452083", "安徽省芜湖市",
"861826232", "江苏省泰州市",
"861776302", "湖北省恩施土家族苗族自治州",
"861363106", "广东省清远市",
"861827209", "湖北省孝感市",
"861342862", "广东省东莞市",
"861459775", "新疆昌吉回族自治州",
"861355843", "广西桂林市",
"861369967", "四川省南充市",
"861338410", "辽宁省铁岭市",
"86138777", "广西钦州市",
"861572163", "山西省阳泉市",
"861344266", "安徽省阜阳市",
"861573741", "河南省濮阳市",
"861532821", "四川省绵阳市",
"861319177", "河北省唐山市",
"861571877", "云南省玉溪市",
"861780917", "陕西省宝鸡市",
"861560579", "浙江省金华市",
"861356141", "山东省潍坊市",
"861884941", "河北省石家庄市",
"861302997", "黑龙江省佳木斯市",
"861552084", "四川省成都市",
"861853455", "山西省忻州市",
"861580325", "河北省唐山市",
"86133816", "上海市",
"861870956", "宁夏中卫市",
"8618480", "福建省福州市",
"861814689", "陕西省西安市",
"861309275", "湖北省黄石市",
"861333349", "山西省朔州市",
"861879151", "陕西省咸阳市",
"861803689", "江苏省无锡市",
"861557026", "江西省宜春市",
"861876393", "山东省德州市",
"861473025", "河北省承德市",
"861806223", "湖北省襄樊市",
"861816282", "湖北省孝感市",
"861855519", "安徽省滁州市",
"861341137", "广东省珠海市",
"861893557", "青海省海西蒙古族藏族自治州",
"861762518", "江苏省连云港市",
"861881543", "广西玉林市",
"861533139", "四川省成都市",
"861826273", "江苏省淮安市",
"861335785", "江苏省宿迁市",
"861518678", "贵州省黔东南苗族侗族自治州",
"861325964", "宁夏固原市",
"861882620", "广东省珠海市",
"861328710", "山东省莱芜市",
"86139548", "山东省泰安市",
"861889430", "甘肃省白银市",
"861318124", "山东省临沂市",
"861317527", "浙江省绍兴市",
"861550456", "黑龙江省黑河市",
"861898571", "贵州省安顺市",
"86139922", "陕西省榆林市",
"861824639", "黑龙江省佳木斯市",
"861595036", "江苏省淮安市",
"861339408", "福建省南平市",
"861595158", "江苏省无锡市",
"861320347", "山西省临汾市",
"861589247", "四川省德阳市",
"861817067", "江西省赣州市",
"861556331", "山东省日照市",
"861452899", "云南省昆明市",
"861454692", "广东省深圳市",
"861870919", "陕西省铜川市",
"861340621", "山东省泰安市",
"861530753", "广东省梅州市",
"861329109", "江苏省苏州市",
"86158563", "安徽省宣城市",
"86152959", "广西桂林市",
"861590805", "山东省潍坊市",
"861304536", "黑龙江省鸡西市",
"861313536", "湖南省常德市",
"86134180", "广东省广州市",
"861377898", "四川省资阳市",
"861319452", "黑龙江省齐齐哈尔市",
"861560793", "江西省上饶市",
"861477306", "湖南省常德市",
"861865479", "山东省济宁市",
"86189957", "湖北省黄冈市",
"861826063", "江苏省镇江市",
"861590414", "辽宁省本溪市",
"861869542", "宁夏固原市",
"861591750", "广东省清远市",
"861555754", "浙江省绍兴市",
"861478772", "云南省文山壮族苗族自治州",
"861523438", "山西省吕梁市",
"861377251", "陕西省西安市",
"861338293", "江苏省连云港市",
"861390312", "河北省保定市",
"861800751", "广东省韶关市",
"861860922", "陕西省榆林市",
"861570604", "陕西省西安市",
"86153351", "江苏省南京市",
"861306573", "浙江省杭州市",
"86185513", "江苏省常州市",
"861325846", "四川省德阳市",
"861768620", "山东省德州市",
"861576669", "广东省茂名市",
"861450226", "河北省保定市",
"861821952", "广东省深圳市",
"861771396", "四川省甘孜藏族自治州",
"861555336", "山东省滨州市",
"86134586", "四川省成都市",
"861813048", "安徽省阜阳市",
"861870880", "云南省临沧市",
"861705620", "福建省厦门市",
"861535226", "甘肃省临夏回族自治州",
"86133971", "湖北省武汉市",
"861863847", "河南省洛阳市",
"861861771", "河北省沧州市",
"861807020", "江西省九江市",
"861450629", "黑龙江省牡丹江市",
"86155010", "北京市",
"861596031", "福建省龙岩市",
"861804048", "四川省巴中市",
"861898659", "湖北省黄石市",
"861882294", "广东省揭阳市",
"861378048", "河北省衡水市",
"861364634", "山东省莱芜市",
"861300726", "江西省九江市",
"86188060", "福建省三明市",
"861320776", "广西百色市",
"861815179", "江苏省泰州市",
"861333044", "云南省昆明市",
"861537634", "山东省临沂市",
"861506060", "福建省泉州市",
"861877226", "湖北省黄石市",
"86153194", "陕西省西安市",
"861310355", "山西省长治市",
"86182668", "山东省济宁市",
"861396590", "安徽省池州市",
"86152300", "河北省邯郸市",
"861568550", "贵州省贵阳市",
"861550837", "四川省德阳市",
"861350732", "湖南省湘潭市",
"861864999", "福建省厦门市",
"861309284", "四川省广安市",
"861350012", "广东省梅州市",
"86158312", "河北省保定市",
"861315641", "山东省济南市",
"861899852", "广东省汕尾市",
"861560487", "黑龙江省鸡西市",
"861474714", "内蒙古乌兰察布市",
"861305424", "黑龙江省齐齐哈尔市",
"861895392", "山东省聊城市",
"861474034", "辽宁省鞍山市",
"861308135", "辽宁省本溪市",
"861368424", "四川省达州市",
"861530818", "四川省成都市",
"861459784", "新疆巴音郭楞蒙古自治州",
"861587806", "广西梧州市",
"861338711", "湖北省黄冈市",
"861825053", "福建省莆田市",
"861805974", "福建省莆田市",
"861534828", "四川省广安市",
"861882948", "陕西省西安市",
"861537840", "四川省凉山彝族自治州",
"861369089", "广东省梅州市",
"861328530", "山东省菏泽市",
"861818695", "湖北省孝感市",
"861776149", "四川省阿坝藏族羌族自治州",
"861337221", "江苏省徐州市",
"861707849", "云南省文山壮族苗族自治州",
"861470724", "湖北省咸宁市",
"86181084", "湖南省长沙市",
"861550971", "青海省西宁市",
"861870992", "新疆伊犁哈萨克自治州",
"86132970", "湖北省武汉市",
"861846222", "山东省潍坊市",
"86189926", "陕西省汉中市",
"861857724", "广西来宾市",
"861393894", "河南省商丘市",
"86156222", "广东省广州市",
"861390399", "河南省许昌市",
"861317027", "安徽省合肥市",
"861367828", "四川省南充市",
"861570723", "湖北省襄樊市",
"861801404", "江苏省苏州市",
"861397293", "湖北省武汉市",
"861889279", "四川省内江市",
"861854562", "黑龙江省哈尔滨市",
"861510343", "山西省太原市",
"861862680", "浙江省温州市",
"86177361", "河北省邯郸市",
"861313716", "河南省焦作市",
"861840661", "广东省广州市",
"861539744", "浙江省绍兴市",
"861843607", "河南省洛阳市",
"86189907", "四川省南充市",
"861304716", "湖北省宜昌市",
"861889069", "湖南省张家界市",
"861328469", "黑龙江省双鸭山市",
"861346572", "山东省潍坊市",
"861520808", "西藏昌都地区",
"86152909", "河南省许昌市",
"861304036", "吉林省白城市",
"86150448", "内蒙古巴彦淖尔市",
"861479286", "安徽省池州市",
"861452812", "四川省攀枝花市",
"861335875", "辽宁省锦州市",
"861310172", "河南省安阳市",
"861310681", "广东省珠海市",
"86153301", "北京市",
"861306073", "广东省梅州市",
"861859820", "广东省潮州市",
"861770562", "安徽省铜陵市",
"861326954", "甘肃省庆阳市",
"861331914", "陕西省商洛市",
"861869042", "陕西省汉中市",
"861454216", "河南省焦作市",
"861327694", "福建省泉州市",
"861808230", "江苏省宿迁市",
"861369375", "河南省平顶山市",
"861360962", "广东省深圳市",
"86151348", "内蒙古鄂尔多斯市",
"861807520", "安徽省亳州市",
"861325387", "河南省焦作市",
"861596531", "山东省济南市",
"861350099", "吉林省吉林市",
"861563879", "河南省许昌市",
"861378548", "河北省沧州市",
"861560374", "河南省许昌市",
"861378494", "河北省邢台市",
"861367934", "甘肃省庆阳市",
"86156318", "河北省衡水市",
"861813494", "山西省太原市",
"861768948", "福建省泉州市",
"861505245", "江苏省淮安市",
"861813548", "山西省晋中市",
"861568245", "四川省乐山市",
"861501736", "广东省湛江市",
"861360472", "内蒙古包头市",
"861778137", "四川省德阳市",
"861800766", "广东省云浮市",
"861363458", "黑龙江省伊春市",
"861308929", "吉林省通化市",
"861562804", "贵州省铜仁地区",
"861580427", "辽宁省盘锦市",
"861764069", "辽宁省鞍山市",
"861593641", "河南省南阳市",
"86134261", "北京市",
"861388484", "山东省聊城市",
"861333544", "陕西省汉中市",
"861534934", "甘肃省庆阳市",
"861338700", "江西省南昌市",
"861330745", "湖南省怀化市",
"861818943", "甘肃省白银市",
"86181577", "浙江省温州市",
"861350512", "江苏省泰州市",
"861552575", "山西省吕梁市",
"861763543", "山西省晋中市",
"861452668", "江西省南昌市",
"861320886", "云南省怒江傈僳族自治州",
"861831288", "广东省茂名市",
"861505050", "江苏省泰州市",
"861708099", "广东省佛山市",
"861890506", "福建省泉州市",
"861373943", "四川省资阳市",
"861347900", "江西省新余市",
"86185937", "甘肃省酒泉市",
"86134685", "陕西省咸阳市",
"861338531", "山东省济南市",
"861870770", "广西防城港市",
"86135366", "广东省佛山市",
"861327220", "湖南省邵阳市",
"861324248", "广东省江门市",
"861351827", "四川省德阳市",
"861346403", "辽宁省沈阳市",
"861806044", "福建省莆田市",
"86182334", "河北省保定市",
"861530378", "河南省洛阳市",
"861590346", "山西省太原市",
"861533520", "江苏省无锡市",
"861337938", "陕西省宝鸡市",
"861366638", "山东省聊城市",
"861813458", "安徽省淮北市",
"861325037", "广东省佛山市",
"861309771", "广西南宁市",
"861562201", "广东省阳江市",
"861815929", "福建省厦门市",
"86156420", "辽宁省抚顺市",
"861325717", "湖北省黄冈市",
"861477845", "广东省广州市",
"861329721", "湖北省黄石市",
"86145806", "浙江省嘉兴市",
"861773948", "河南省驻马店市",
"861314912", "陕西省榆林市",
"86185869", "贵州省贵阳市",
"86181164", "上海市",
"861357917", "新疆伊犁哈萨克自治州",
"86188685", "浙江省金华市",
"861303912", "吉林省长春市",
"861363494", "辽宁省锦州市",
"861820483", "内蒙古阿拉善盟",
"861589957", "广东省佛山市",
"861533352", "山西省大同市",
"861800615", "江苏省无锡市",
"861564938", "河南省南阳市",
"861810472", "内蒙古包头市",
"861588032", "福建省莆田市",
"861351568", "安徽省阜阳市",
"861318464", "江西省上饶市",
"861512852", "河北省秦皇岛市",
"86145827", "福建省厦门市",
"86155211", "广东省广州市",
"86138582", "浙江省宁波市",
"861503659", "河南省洛阳市",
"861348738", "湖南省娄底市",
"861518362", "四川省甘孜藏族自治州",
"861523843", "河南省三门峡市",
"861459061", "广东省肇庆市",
"86132872", "山东省济宁市",
"861368943", "甘肃省白银市",
"861831727", "河南省焦作市",
"861317699", "山东省临沂市",
"86187477", "内蒙古鄂尔多斯市",
"861767126", "湖北省宜昌市",
"86158397", "河南省信阳市",
"861317296", "广东省韶关市",
"861777477", "广西钦州市",
"861589191", "云南省文山壮族苗族自治州",
"861476038", "福建省南平市",
"861774845", "四川省绵阳市",
"861316959", "广东省惠州市",
"861580996", "新疆巴音郭楞蒙古自治州",
"861820797", "江西省赣州市",
"861708627", "山东省临沂市",
"861367567", "安徽省阜阳市",
"861335839", "福建省厦门市",
"861769611", "山西省太原市",
"861898946", "浙江省杭州市",
"861840949", "甘肃省兰州市",
"861390872", "云南省大理白族自治州",
"86158346", "吉林省白城市",
"861459556", "青海省玉树藏族自治州",
"861355508", "黑龙江省大兴安岭地区",
"861867027", "湖南省郴州市",
"861590777", "广西钦州市",
"861453432", "辽宁省鞍山市",
"861814840", "四川省绵阳市",
"861472613", "四川省眉山市",
"861380661", "浙江省温州市",
"861592404", "浙江省舟山市",
"86152621", "江苏省徐州市",
"861332886", "福建省福州市",
"861550046", "吉林省白山市",
"86156129", "河北省邢台市",
"861525668", "安徽省滁州市",
"861584774", "内蒙古呼伦贝尔市",
"861534567", "安徽省亳州市",
"861839419", "甘肃省定西市",
"861337824", "四川省南充市",
"861873974", "河南省安阳市",
"861392302", "广东省梅州市",
"861556581", "河南省濮阳市",
"861347505", "山东省滨州市",
"86153125", "江苏省常州市",
"861524698", "黑龙江省黑河市",
"861829756", "安徽省宣城市",
"861891217", "江苏省连云港市",
"861760508", "福建省厦门市",
"861304386", "辽宁省盘锦市",
"861569748", "湖南省长沙市",
"861860681", "浙江省衢州市",
"8618426", "重庆市",
"861315230", "陕西省咸阳市",
"861313386", "江西省萍乡市",
"861834646", "黑龙江省牡丹江市",
"861350627", "江苏省南通市",
"861887587", "浙江省嘉兴市",
"861342948", "浙江省绍兴市",
"861319042", "辽宁省锦州市",
"861450597", "辽宁省盘锦市",
"861558684", "湖北省襄樊市",
"861810962", "安徽省蚌埠市",
"861362733", "湖南省株洲市",
"861501398", "广东省惠州市",
"861394955", "河南省驻马店市",
"86180773", "广西桂林市",
"861321686", "浙江省丽水市",
"861892354", "广东省揭阳市",
"861576854", "广东省深圳市",
"861599513", "江苏省扬州市",
"86151257", "云南省楚雄彝族自治州",
"861787773", "湖南省怀化市",
"861361918", "陕西省咸阳市",
"86176861", "山东省济宁市",
"861346795", "湖南省怀化市",
"861458683", "湖南省常德市",
"861321289", "黑龙江省大庆市",
"861339720", "湖北省宜昌市",
"86137023", "广东省中山市",
"861301542", "山西省临汾市",
"861325537", "山东省济宁市",
"861308179", "辽宁省铁岭市",
"861596381", "山东省日照市",
"86136588", "云南省昆明市",
"861819152", "陕西省渭南市",
"861777196", "湖北省黄冈市",
"86153620", "广东省东莞市",
"861830395", "河南省漯河市",
"86130888", "广东省深圳市",
"86187488", "贵州省黔西南布依族苗族自治州",
"861554100", "辽宁省铁岭市",
"861860355", "山西省长治市",
"861806498", "四川省雅安市",
"861829761", "安徽省淮南市",
"861871757", "陕西省安康市",
"86185981", "广东省广州市",
"861334638", "山东省烟台市",
"861594943", "内蒙古赤峰市",
"861829409", "甘肃省庆阳市",
"861315969", "吉林省白山市",
"861354617", "山西省临汾市",
"861803634", "江苏省盐城市",
"861781716", "广东省惠州市",
"861396643", "安徽省安庆市",
"861504742", "内蒙古乌兰察布市",
"861311771", "广西南宁市",
"861536938", "河北省石家庄市",
"861313847", "广东省广州市",
"861327425", "辽宁省沈阳市",
"861522662", "河北省沧州市",
"861882891", "四川省雅安市",
"861552039", "四川省眉山市",
"861814634", "青海省果洛藏族自治州",
"861317612", "山东省泰安市",
"861380656", "浙江省台州市",
"861576941", "甘肃省兰州市",
"86189518", "江苏省南京市",
"861830832", "四川省泸州市",
"861815135", "江苏省徐州市",
"861352963", "云南省大理白族自治州",
"861818424", "贵州省遵义市",
"861459561", "陕西省渭南市",
"861373424", "山西省长治市",
"861529359", "甘肃省天水市",
"861380259", "广东省深圳市",
"86188586", "浙江省台州市",
"861473648", "云南省昆明市",
"861841437", "内蒙古呼和浩特市",
"861331767", "广西钦州市",
"86182876", "云南省文山壮族苗族自治州",
"86139820", "四川省成都市",
"861303999", "黑龙江省哈尔滨市",
"861588799", "云南省临沧市",
"861459314", "四川省达州市",
"861338428", "辽宁省阜新市",
"861805237", "江苏省淮安市",
"861560814", "四川省攀枝花市",
"86134060", "山东省菏泽市",
"861571415", "辽宁省丹东市",
"86137264", "广东省东莞市",
"861471803", "广东省梅州市",
"861563319", "河北省邢台市",
"861459056", "广东省佛山市",
"86188180", "上海市",
"861807139", "湖北省荆门市",
"861369815", "四川省泸州市",
"861825443", "山东省临沂市",
"861347337", "河北省石家庄市",
"861810003", "北京市",
"861538995", "新疆吐鲁番地区",
"861335315", "吉林省通化市",
"861705258", "北京市",
"861459138", "广西贵港市",
"861522818", "四川省乐山市",
"861890749", "湖南省长沙市",
"861801089", "安徽省马鞍山市",
"861500207", "广东省深圳市",
"861893447", "贵州省铜仁地区",
"861876839", "浙江省湖州市",
"861881453", "黑龙江省牡丹江市",
"861709351", "河南省南阳市",
"861534067", "山西省太原市",
"861566567", "安徽省亳州市",
"861556081", "内蒙古呼和浩特市",
"861323855", "贵州省黔东南苗族侗族自治州",
"861775130", "江苏省南通市",
"861518140", "四川省泸州市",
"861856740", "河南省安阳市",
"861805124", "江苏省苏州市",
"861550546", "山东省东营市",
"861335707", "浙江省丽水市",
"861808435", "贵州省贵阳市",
"861593230", "河北省衡水市",
"861595386", "山东省威海市",
"861569302", "甘肃省甘南藏族自治州",
"861868124", "四川省绵阳市",
"861595665", "安徽省淮南市",
"861332776", "江苏省镇江市",
"86157122", "天津市",
"861319542", "安徽省蚌埠市",
"861311909", "新疆博尔塔拉蒙古自治州",
"861535097", "辽宁省丹东市",
"861534277", "湖北省武汉市",
"861527998", "江西省景德镇市",
"861565057", "山东省济南市",
"861813625", "江苏省扬州市",
"861373253", "浙江省舟山市",
"861850667", "广东省茂名市",
"861300983", "黑龙江省大庆市",
"861341543", "广东省中山市",
"861508057", "福建省三明市",
"86170835", "山西省太原市",
"86151207", "海南省海口市",
"861390782", "广西柳州市",
"861839492", "甘肃省定西市",
"861515291", "江苏省镇江市",
"861775697", "安徽省合肥市",
"861551637", "河南省洛阳市",
"861772913", "陕西省渭南市",
"861301042", "浙江省嘉兴市",
"861869452", "浙江省嘉兴市",
"86180751", "湖南省长沙市",
"861590887", "云南省迪庆藏族自治州",
"861877097", "江西省赣州市",
"861362513", "江苏省盐城市",
"861315479", "内蒙古锡林郭勒盟",
"861344755", "山东省菏泽市",
"861575946", "福建省泉州市",
"861309239", "江苏省连云港市",
"86184777", "广西南宁市",
"86189467", "吉林省长春市",
"86182911", "陕西省延安市",
"861520543", "山东省滨州市",
"861892671", "广东省茂名市",
"861833032", "河北省唐山市",
"86137090", "四川省成都市",
"861302426", "浙江省湖州市",
"861553387", "河北省唐山市",
"861512193", "宁夏吴忠市",
"861311470", "广西防城港市",
"861346383", "河北省保定市",
"861300150", "山东省淄博市",
"861322476", "内蒙古通辽市",
"861839971", "新疆阿克苏地区",
"861787512", "广东省湛江市",
"861890148", "江苏省南通市",
"861889905", "新疆乌鲁木齐市",
"861459739", "湖南省长沙市",
"86189132", "江苏省苏州市",
"861705618", "辽宁省大连市",
"861554169", "辽宁省朝阳市",
"86186315", "河北省唐山市",
"861560535", "山东省烟台市",
"861807018", "江西省鹰潭市",
"86150139", "广东省汕头市",
"86177151", "江苏省苏州市",
"86183319", "河北省邢台市",
"861855446", "山东省济南市",
"861862849", "陕西省宝鸡市",
"8613880", "四川省成都市",
"86132765", "江苏省扬州市",
"861588402", "四川省凉山彝族自治州",
"86181782", "广西柳州市",
"861477744", "广西梧州市",
"861330241", "广东省佛山市",
"861318330", "河南省南阳市",
"861364689", "浙江省金华市",
"861452333", "河南省南阳市",
"861301927", "吉林省吉林市",
"861530820", "四川省成都市",
"861886033", "河南省周口市",
"861381585", "江苏省南京市",
"861321977", "陕西省汉中市",
"861879426", "甘肃省定西市",
"861360848", "河南省许昌市",
"86151686", "浙江省台州市",
"861310047", "广西贵港市",
"86139385", "河南省郑州市",
"861471625", "广东省广州市",
"861819967", "新疆石河子市",
"861829539", "宁夏银川市",
"861850744", "湖南省张家界市",
"861378106", "河南省平顶山市",
"861393403", "山西省阳泉市",
"861804106", "辽宁省沈阳市",
"861537689", "山东省青岛市",
"861392149", "江苏省南通市",
"861781759", "广东省惠州市",
"861317252", "广东省汕头市",
"861580952", "宁夏石嘴山市",
"861830873", "云南省红河哈尼族彝族自治州",
"861322844", "陕西省榆林市",
"861819477", "青海省海南藏族自治州",
"86134801", "广东省深圳市",
"86150430", "吉林省长春市",
"861453897", "云南省曲靖市",
"86151330", "河北省邯郸市",
"861838110", "四川省广安市",
"861863406", "河北省沧州市",
"861525083", "江苏省无锡市",
"861328205", "浙江省衢州市",
"861898765", "云南省红河哈尼族彝族自治州",
"86152160", "江西省上饶市",
"861346894", "陕西省渭南市",
"861762520", "江苏省南通市",
"861893222", "江苏省南通市",
"861882618", "广东省江门市",
"861576755", "广东省惠州市",
"861894283", "四川省甘孜藏族自治州",
"861365778", "广西河池市",
"861521890", "广东省佛山市",
"861321467", "黑龙江省鸡西市",
"861512896", "河北省保定市",
"86183846", "四川省乐山市",
"861501449", "广东省云浮市",
"861308778", "广西河池市",
"861593087", "河北省衡水市",
"861839461", "甘肃省庆阳市",
"861887230", "湖北省黄石市",
"861896607", "浙江省绍兴市",
"861369534", "山东省德州市",
"861829970", "新疆克孜勒苏柯尔克孜自治州",
"861315587", "江西省抚州市",
"861839709", "青海省海西蒙古族藏族自治州",
"86137845", "河北省张家口市",
"861564208", "辽宁省铁岭市",
"861533396", "河南省驻马店市",
"861779934", "新疆和田地区",
"861588198", "四川省泸州市",
"861591126", "云南省普洱市",
"861808505", "贵州省黔东南苗族侗族自治州",
"861800540", "山东省菏泽市",
"861841980", "甘肃省临夏回族自治州",
"861454949", "福建省宁德市",
"861804803", "四川省成都市",
"861378803", "广西桂林市",
"861707757", "江西省景德镇市",
"861865505", "安徽省合肥市",
"861533184", "黑龙江省齐齐哈尔市",
"861390558", "安徽省阜阳市",
"861562931", "湖北省襄樊市",
"86153280", "四川省成都市",
"861337725", "广西玉林市",
"861534801", "甘肃省兰州市",
"861380619", "江苏省无锡市",
"861584875", "内蒙古通辽市",
"861786456", "山东省临沂市",
"86136354", "重庆市",
"861876281", "江苏省无锡市",
"86139742", "湖南省常德市",
"861780331", "河北省石家庄市",
"861532690", "内蒙古包头市",
"861532453", "安徽省芜湖市",
"861337208", "江苏省南通市",
"861824684", "黑龙江省大庆市",
"861570677", "浙江省温州市",
"86151585", "浙江省温州市",
"861571705", "江西省宜春市",
"86152799", "江西省萍乡市",
"861869496", "江苏省常州市",
"86151939", "甘肃省陇南市",
"861563361", "河北省唐山市",
"861560307", "广东省广州市",
"861361525", "江苏省扬州市",
"861332445", "吉林省通化市",
"861802466", "广东省广州市",
"86139274", "广东省深圳市",
"86189797", "江西省赣州市",
"86152665", "山东省烟台市",
"861347641", "湖北省襄樊市",
"861839456", "甘肃省武威市",
"861515403", "山东省威海市",
"861812595", "广东省揭阳市",
"861521982", "广东省韶关市",
"861322630", "广东省惠州市",
"861571317", "河北省沧州市",
"861329420", "湖北省荆州市",
"86177173", "上海市",
"86155579", "浙江省金华市",
"861511973", "广东省茂名市",
"86132495", "广东省汕头市",
"861570850", "贵州省贵阳市",
"861867942", "江西省南昌市",
"861309470", "浙江省温州市",
"861311636", "贵州省六盘水市",
"86139136", "江苏省苏州市",
"861362772", "广西柳州市",
"861586929", "浙江省金华市",
"861474589", "黑龙江省齐齐哈尔市",
"861598689", "广东省汕头市",
"861562877", "山东省济南市",
"861786461", "山东省滨州市",
"861459519", "云南省德宏傣族景颇族自治州",
"861860457", "黑龙江省大兴安岭地区",
"86155476", "内蒙古赤峰市",
"86131786", "广东省中山市",
"861886533", "山东省淄博市",
"861593900", "河南省郑州市",
"86152281", "四川省南充市",
"861508806", "广东省广州市",
"861327218", "湖南省益阳市",
"861589162", "陕西省汉中市",
"861539306", "甘肃省天水市",
"86135500", "四川省成都市",
"861801967", "江苏省常州市",
"861399787", "湖北省随州市",
"861350358", "山西省吕梁市",
"861351683", "浙江省嘉兴市",
"861453473", "黑龙江省哈尔滨市",
"861379466", "广东省韶关市",
"861859662", "福建省厦门市",
"861853045", "河南省焦作市",
"861534989", "安徽省芜湖市",
"861319927", "黑龙江省伊春市",
"861847179", "湖北省黄冈市",
"861500937", "甘肃省酒泉市",
"861518391", "四川省宜宾市",
"861310547", "山东省济宁市",
"861459092", "广东省茂名市",
"861787599", "广东省阳江市",
"861850486", "内蒙古赤峰市",
"861519449", "河南省信阳市",
"861370682", "浙江省湖州市",
"861572423", "浙江省温州市",
"861868907", "西藏阿里地区",
"86883", "云南省临沧市",
"861321831", "江苏省淮安市",
"861318985", "广东省江门市",
"861377755", "浙江省杭州市",
"86139893", "浙江省宁波市",
"86134851", "江苏省南通市",
"861340608", "山东省东营市",
"861344854", "山东省济南市",
"861534810", "四川省德阳市",
"861760438", "吉林省松原市",
"861860836", "四川省甘孜藏族自治州",
"86183910", "陕西省咸阳市",
"861471458", "广东省深圳市",
"861801477", "江苏省无锡市",
"861810157", "江苏省苏州市",
"861332631", "山东省威海市",
"861339388", "河南省焦作市",
"861332950", "黑龙江省大庆市",
"861335417", "辽宁省营口市",
"861800040", "河北省邯郸市",
"861339421", "辽宁省朝阳市",
"861780764", "广东省广州市",
"861893345", "广东省梅州市",
"861865005", "福建省福州市",
"861536725", "湖南省郴州市",
"861309960", "云南省临沧市",
"861347435", "陕西省西安市",
"86159642", "山东省青岛市",
"861315087", "内蒙古鄂尔多斯市",
"861316916", "广东省茂名市",
"861809648", "安徽省阜阳市",
"861362990", "新疆乌鲁木齐市",
"861369714", "湖北省黄冈市",
"861500781", "广西南宁市",
"861458568", "山东省滨州市",
"861884898", "河南省洛阳市",
"861399931", "新疆克拉玛依市",
"861827984", "江西省景德镇市",
"861830783", "广西南宁市",
"861399493", "山西省朔州市",
"86135127", "广东省广州市",
"861811920", "新疆伊犁哈萨克自治州",
"861320555", "安徽省马鞍山市",
"861810433", "吉林省延边朝鲜族自治州",
"86189746", "湖南省永州市",
"861390058", "浙江省温州市",
"861839837", "四川省广元市",
"861870649", "山东省滨州市",
"861323754", "江西省新余市",
"861810991", "新疆乌鲁木齐市",
"86156763", "广西桂林市",
"86139530", "山东省菏泽市",
"861453502", "山东省青岛市",
"86136304", "广东省江门市",
"861777152", "湖北省咸宁市",
"861880559", "安徽省黄山市",
"861823634", "河南省周口市",
"861311721", "湖北省襄樊市",
"861310790", "福建省三明市",
"861351705", "江西省宜春市",
"861479702", "青海省西宁市",
"861361084", "辽宁省大连市",
"861539763", "四川省成都市",
"861890618", "江苏省无锡市",
"861513869", "河南省郑州市",
"86156398", "河南省三门峡市",
"861324847", "浙江省金华市",
"86138578", "浙江省宁波市",
"861899730", "青海省海东地区",
"861331338", "河北省承德市",
"861327475", "内蒙古通辽市",
"86186479", "内蒙古锡林郭勒盟",
"861351317", "河北省沧州市",
"861510511", "江苏省盐城市",
"861894455", "黑龙江省绥化市",
"861328179", "四川省遂宁市",
"86137579", "浙江省金华市",
"86182964", "江西省抚州市",
"861831887", "广东省深圳市",
"861368537", "山东省济宁市",
"861308129", "辽宁省锦州市",
"861350850", "贵州省黔南布依族苗族自治州",
"861536446", "湖南省永州市",
"861596478", "山东省聊城市",
"861826544", "山东省德州市",
"86189850", "贵州省贵阳市",
"861840482", "内蒙古乌兰察布市",
"861592952", "陕西省安康市",
"861779052", "四川省南充市",
"86183475", "内蒙古通辽市",
"861809409", "福建省泉州市",
"861518250", "四川省泸州市",
"861778937", "甘肃省张掖市",
"861515947", "福建省南平市",
"861338478", "内蒙古巴彦淖尔市",
"861398446", "贵州省铜仁地区",
"861373143", "河北省承德市",
"861306244", "福建省厦门市",
"86180876", "云南省文山壮族苗族自治州",
"86137476", "内蒙古赤峰市",
"861340449", "吉林省松原市",
"86186576", "浙江省台州市",
"861372761", "广东省梅州市",
"861381524", "江苏省南通市",
"861893233", "江苏省淮安市",
"861323999", "新疆伊犁哈萨克自治州",
"861594717", "内蒙古鄂尔多斯市",
"861394812", "内蒙古呼和浩特市",
"861450635", "黑龙江省绥化市",
"861329881", "吉林省白山市",
"86184531", "山东省济南市",
"86157500", "云南省红河哈尼族彝族自治州",
"861571683", "河北省邯郸市",
"861533260", "陕西省榆林市",
"861570358", "山西省吕梁市",
"861822687", "安徽省阜阳市",
"861519608", "四川省泸州市",
"861583515", "山西省长治市",
"861853391", "河北省张家口市",
"86183700", "江西省上饶市",
"861538859", "山西省运城市",
"861851578", "四川省乐山市",
"861525440", "山东省菏泽市",
"861775035", "福建省莆田市",
"861532369", "广东省汕头市",
"861373474", "内蒙古乌兰察布市",
"861339919", "陕西省铜川市",
"86157106", "福建省厦门市",
"861452550", "山东省聊城市",
"861818964", "甘肃省张掖市",
"861366549", "山东省临沂市",
"861334049", "福建省莆田市",
"861771367", "四川省绵阳市",
"861550682", "广西柳州市",
"861760765", "广东省东莞市",
"861303855", "陕西省咸阳市",
"861535441", "河北省石家庄市",
"861314855", "广东省东莞市",
"861787604", "广东省湛江市",
"861815030", "福建省南平市",
"861557755", "广西贵港市",
"861825124", "江苏省常州市",
"861586411", "山东省济宁市",
"86186170", "广东省深圳市",
"861389715", "青海省果洛藏族自治州",
"86130721", "上海市",
"861386562", "安徽省铜陵市",
"861890862", "湖北省武汉市",
"861586287", "江苏省扬州市",
"861827139", "湖北省武汉市",
"861867577", "广东省惠州市",
"861877441", "湖南省益阳市",
"861826102", "江苏省苏州市",
"861763311", "河北省石家庄市",
"861308380", "河南省新乡市",
"861457192", "浙江省嘉兴市",
"861452322", "河南省郑州市",
"861816459", "浙江省金华市",
"861339880", "云南省昆明市",
"861880671", "浙江省杭州市",
"86187071", "湖北省武汉市",
"861886022", "河南省南阳市",
"861333902", "安徽省蚌埠市",
"86187003", "陕西省渭南市",
"861536874", "云南省曲靖市",
"861380149", "江苏省常州市",
"861554005", "内蒙古通辽市",
"861313958", "宁夏银川市",
"861533125", "河南省新乡市",
"861470417", "辽宁省营口市",
"861321042", "山东省临沂市",
"861596968", "山东省济南市",
"86151202", "贵州省遵义市",
"861811118", "四川省泸州市",
"861355765", "广西玉林市",
"86182751", "贵州省贵阳市",
"861315429", "辽宁省葫芦岛市",
"861534318", "河北省衡水市",
"861822750", "四川省内江市",
"861367227", "江西省宜春市",
"861304958", "贵州省六盘水市",
"861817788", "广西河池市",
"861804675", "江西省宜春市",
"861319289", "广东省韶关市",
"861367318", "河北省石家庄市",
"861833954", "河南省新乡市",
"861894940", "安徽省芜湖市",
"86157127", "山东省青岛市",
"861332726", "湖南省永州市",
"861818846", "四川省攀枝花市",
"861319365", "河南省南阳市",
"861319686", "江苏省镇江市",
"861512915", "陕西省安康市",
"861529932", "新疆伊犁哈萨克自治州",
"861333563", "安徽省宣城市",
"861803412", "河北省保定市",
"861863994", "河南省濮阳市",
"861320983", "山西省大同市",
"861813675", "江苏省苏州市",
"861337784", "湖北省咸宁市",
"861528057", "福建省三明市",
"861885142", "江苏省南通市",
"861809334", "甘肃省张掖市",
"861811409", "江苏省无锡市",
"861394899", "内蒙古兴安盟",
"861323912", "陕西省榆林市",
"861810422", "辽宁省鞍山市",
"861800483", "内蒙古阿拉善盟",
"861360340", "河南省三门峡市",
"861820615", "江苏省无锡市",
"861821152", "广东省珠海市",
"861361584", "浙江省丽水市",
"861305305", "安徽省合肥市",
"861826044", "江苏省苏州市",
"861383397", "河北省沧州市",
"861339992", "新疆伊犁哈萨克自治州",
"861530481", "黑龙江省哈尔滨市",
"861817596", "湖南省长沙市",
"861530328", "河北省秦皇岛市",
"861533570", "湖北省宜昌市",
"86186675", "浙江省绍兴市",
"861808169", "四川省成都市",
"861348367", "河北省石家庄市",
"861368717", "湖北省宜昌市",
"86183679", "浙江省金华市",
"86181434", "浙江省杭州市",
"861329771", "广西南宁市",
"861555642", "安徽省六安市",
"861824458", "河北省衡水市",
"861318838", "辽宁省丹东市",
"861309721", "江西省南昌市",
"861510731", "湖南省长沙市",
"861812341", "四川省巴中市",
"861375199", "广东省梅州市",
"86158392", "河南省鹤壁市",
"86187472", "内蒙古包头市",
"86157550", "安徽省滁州市",
"861321104", "广东省肇庆市",
"861511359", "广东省湛江市",
"861453614", "江苏省南通市",
"861881564", "安徽省六安市",
"86132877", "山东省济南市",
"86136572", "湖北省武汉市",
"861709413", "广东省深圳市",
"861888209", "四川省凉山彝族自治州",
"86145822", "安徽省合肥市",
"861869904", "新疆克拉玛依市",
"861572432", "辽宁省朝阳市",
"861518545", "贵州省黔南布依族苗族自治州",
"861816706", "浙江省台州市",
"861346617", "云南省普洱市",
"861580534", "山东省德州市",
"861372334", "宁夏中卫市",
"861308935", "吉林省松原市",
"86184865", "贵州省毕节地区",
"861365935", "甘肃省武威市",
"86183750", "贵州省黔南布依族苗族自治州",
"86138587", "浙江省温州市",
"861387287", "湖北省随州市",
"861389535", "宁夏吴忠市",
"861879745", "湖南省湘西土家族苗族自治州",
"861372118", "安徽省蚌埠市",
"861845442", "山东省淄博市",
"86150621", "江苏省徐州市",
"861505668", "安徽省黄山市",
"86185830", "四川省泸州市",
"861318053", "河北省邯郸市",
"861325164", "黑龙江省七台河市",
"861334549", "新疆博尔塔拉蒙古自治州",
"861533939", "甘肃省陇南市",
"861341937", "四川省遂宁市",
"861337874", "云南省曲靖市",
"861390822", "四川省成都市",
"861800797", "江西省赣州市",
"861801242", "江苏省南通市",
"861823840", "河南省南阳市",
"861700188", "北京市",
"861377297", "陕西省安康市",
"861573155", "四川省内江市",
"861817878", "广西钦州市",
"861593429", "山西省忻州市",
"861590727", "湖北省襄樊市",
"86182701", "江西省上饶市",
"861520480", "内蒙古鄂尔多斯市",
"86155845", "吉林省松原市",
"861514146", "辽宁省铁岭市",
"86182773", "广西桂林市",
"861339770", "广西南宁市",
"861867267", "湖北省武汉市",
"861306998", "黑龙江省齐齐哈尔市",
"861831346", "云南省德宏傣族景颇族自治州",
"861554505", "黑龙江省哈尔滨市",
"861452245", "浙江省宁波市",
"861503146", "河北省秦皇岛市",
"861815469", "广西贵港市",
"861317309", "山东省临沂市",
"861843413", "山西省太原市",
"861321542", "广东省东莞市",
"861586400", "山东省济南市",
"86151252", "云南省大理白族自治州",
"861809756", "新疆哈密地区",
"861504698", "黑龙江省黑河市",
"861333063", "四川省遂宁市",
"861457119", "湖北省武汉市",
"861566227", "吉林省延边朝鲜族自治州",
"861859301", "甘肃省金昌市",
"861302745", "湖南省株洲市",
"861809118", "陕西省西安市",
"861476246", "江苏省无锡市",
"861350677", "浙江省温州市",
"861844740", "内蒙古通辽市",
"861302951", "内蒙古呼和浩特市",
"861586979", "湖南省益阳市",
"861309420", "湖北省荆州市",
"861897015", "江西省鹰潭市",
"861889187", "陕西省商洛市",
"861501982", "广东省惠州市",
"861511923", "广东省河源市",
"861775405", "安徽省滁州市",
"861510430", "吉林省长春市",
"861529202", "湖南省岳阳市",
"861329470", "内蒙古呼伦贝尔市",
"861572502", "山东省枣庄市",
"861339961", "安徽省淮北市",
"86183743", "湖南省湘西土家族苗族自治州",
"861899867", "广东省湛江市",
"861800145", "江苏省扬州市",
"861326382", "广西柳州市",
"861381329", "江苏省徐州市",
"861341480", "广东省揭阳市",
"861865100", "江苏省无锡市",
"861340398", "河南省三门峡市",
"861562827", "新疆伊犁哈萨克自治州",
"86150799", "江西省萍乡市",
"861361575", "浙江省绍兴市",
"861509554", "甘肃省平凉市",
"86157543", "吉林省长春市",
"86134776", "湖北省黄冈市",
"861811792", "四川省达州市",
"861858742", "广西贺州市",
"86139466", "黑龙江省双鸭山市",
"861580815", "四川省雅安市",
"861879197", "陕西省宝鸡市",
"861771975", "陕西省渭南市",
"861516142", "江苏省扬州市",
"86189792", "江西省九江市",
"86150665", "山东省德州市",
"861368280", "广东省揭阳市",
"861811460", "江苏省苏州市",
"861802313", "广东省河源市",
"861356941", "河南省新乡市",
"861847129", "湖北省荆门市",
"86139569", "安徽省合肥市",
"861319977", "新疆博尔塔拉蒙古自治州",
"861333232", "辽宁省阜新市",
"861809719", "青海省海西蒙古族藏族自治州",
"861520937", "甘肃省酒泉市",
"861327377", "河南省南阳市",
"861572963", "四川省绵阳市",
"861880354", "山西省晋中市",
"861510569", "安徽省合肥市",
"861883859", "河南省商丘市",
"861354383", "广东省中山市",
"861457038", "广东省汕头市",
"861843290", "河北省邯郸市",
"861504811", "内蒙古呼伦贝尔市",
"86150281", "河北省石家庄市",
"861888260", "四川省内江市",
"861454482", "湖北省武汉市",
"861821967", "甘肃省酒泉市",
"861872420", "黑龙江省哈尔滨市",
"861351415", "辽宁省丹东市",
"86133896", "重庆市",
"861894357", "吉林省通化市",
"86155264", "湖南省长沙市",
"861513811", "河南省驻马店市",
"861591497", "广东省清远市",
"861857707", "广西南宁市",
"86138255", "广东省佛山市",
"861803702", "河南省焦作市",
"861821477", "安徽省宣城市",
"861564885", "内蒙古巴彦淖尔市",
"8613918", "上海市",
"861317004", "安徽省阜阳市",
"861470315", "河北省唐山市",
"861337885", "云南省昆明市",
"861330863", "湖北省武汉市",
"861760946", "甘肃省金昌市",
"861379926", "福建省厦门市",
"861586530", "山东省菏泽市",
"861560697", "福建省厦门市",
"861880736", "湖南省常德市",
"861370546", "山东省东营市",
"861470707", "江西省赣州市",
"861837008", "江西省吉安市",
"861566442", "山东省德州市",
"86135122", "天津市",
"86187040", "辽宁省沈阳市",
"86184821", "四川省成都市",
"86184244", "辽宁省本溪市",
"861518601", "贵州省铜仁地区",
"861345577", "山东省滨州市",
"861779096", "辽宁省辽阳市",
"861366344", "山西省晋中市",
"861870853", "贵州省安顺市",
"861811970", "安徽省蚌埠市",
"861517794", "广西南宁市",
"861843624", "河南省三门峡市",
"861354894", "湖南省长沙市",
"861898508", "贵州省黔南布依族苗族自治州",
"86182649", "山东省临沂市",
"861339471", "内蒙古呼和浩特市",
"861329960", "广西柳州市",
"861815400", "安徽省淮南市",
"8617622", "天津市",
"861864798", "内蒙古包头市",
"861888125", "四川省广元市",
"861520781", "广西南宁市",
"861328888", "广东省东莞市",
"861355946", "福建省福州市",
"861893562", "青海省海东地区",
"861786921", "云南省德宏傣族景颇族自治州",
"861539299", "湖北省宜昌市",
"86158984", "湖南省益阳市",
"861809460", "浙江省嘉兴市",
"861862762", "湖南省娄底市",
"86189137", "江苏省苏州市",
"861886947", "云南省红河哈尼族彝族自治州",
"861354147", "四川省甘孜藏族自治州",
"861839921", "新疆阿克苏地区",
"861836086", "江苏省南京市",
"861832450", "黑龙江省哈尔滨市",
"861772195", "四川省成都市",
"86185520", "江苏省无锡市",
"86156631", "黑龙江省齐齐哈尔市",
"861317142", "内蒙古呼和浩特市",
"861830541", "山东省济南市",
"861809792", "新疆哈密地区",
"86152139", "甘肃省定西市",
"861881369", "广东省云浮市",
"86130765", "广东省揭阳市",
"861816416", "湖北省黄石市",
"861500543", "山东省滨州市",
"86180911", "陕西省延安市",
"861580339", "河北省邢台市",
"861882749", "湖北省襄樊市",
"861327484", "内蒙古通辽市",
"861479499", "内蒙古鄂尔多斯市",
"86189462", "黑龙江省齐齐哈尔市",
"86151369", "河南省平顶山市",
"86184772", "广西柳州市",
"861329636", "山东省潍坊市",
"861361075", "吉林省吉林市",
"861577917", "江西省吉安市",
"86135818", "北京市",
"861855938", "福建省莆田市",
"861587233", "湖北省襄樊市",
"861322426", "辽宁省沈阳市",
"861529973", "新疆博尔塔拉蒙古自治州",
"861302476", "浙江省台州市",
"861509923", "新疆巴音郭楞蒙古自治州",
"861310491", "广东省湛江市",
"86139796", "江西省吉安市",
"861821893", "广东省珠海市",
"861571568", "安徽省阜阳市",
"861373485", "内蒙古赤峰市",
"861532300", "广东省汕尾市",
"861359181", "辽宁省大连市",
"861582887", "四川省遂宁市",
"861884026", "陕西省汉中市",
"861305407", "湖南省岳阳市",
"861879476", "甘肃省兰州市",
"861350986", "广东省韶关市",
"861361389", "河南省洛阳市",
"86156866", "陕西省榆林市",
"861889343", "甘肃省庆阳市",
"861865111", "江苏省苏州市",
"86150566", "安徽省安庆市",
"861858308", "四川省遂宁市",
"86189843", "贵州省贵阳市",
"861361265", "广东省东莞市",
"861557941", "江西省上饶市",
"861533606", "甘肃省定西市",
"861473118", "河北省保定市",
"861321927", "四川省广安市",
"861383495", "山西省运城市",
"86159595", "福建省泉州市",
"861348465", "陕西省延安市",
"861572897", "西藏阿里地区",
"861811039", "安徽省六安市",
"861301977", "黑龙江省大庆市",
"861380748", "湖南省长沙市",
"861870538", "山东省泰安市",
"861530870", "云南省昭通市",
"861458317", "江西省宜春市",
"861893272", "河北省石家庄市",
"861505083", "江苏省徐州市",
"861890891", "西藏拉萨市",
"86150160", "广东省惠州市",
"861319831", "四川省达州市",
"861330997", "新疆阿克苏地区",
"861308728", "湖南省邵阳市",
"861869234", "湖南省衡阳市",
"861770557", "安徽省宿州市",
"861520871", "云南省昆明市",
"861815411", "安徽省合肥市",
"86152430", "吉林省松原市",
"86147934", "甘肃省庆阳市",
"861879966", "新疆哈密地区",
"861302844", "陕西省咸阳市",
"861890258", "广东省江门市",
"861768749", "广西玉林市",
"861318107", "山东省聊城市",
"861376581", "贵州省贵阳市",
"86186324", "河北省承德市",
"861832945", "陕西省安康市",
"86185126", "广东省中山市",
"861369996", "新疆乌鲁木齐市",
"861570627", "江苏省南通市",
"861534442", "湖南省衡阳市",
"861330151", "江苏省无锡市",
"861339956", "安徽省安庆市",
"861529463", "河南省郑州市",
"861478341", "河南省安阳市",
"861550908", "新疆克孜勒苏柯尔克孜自治州",
"861804684", "江西省景德镇市",
"86139747", "湖南省衡阳市",
"861345077", "广东省佛山市",
"861302966", "新疆乌鲁木齐市",
"861779596", "陕西省榆林市",
"861879844", "贵州省黔南布依族苗族自治州",
"861812190", "四川省南充市",
"861809970", "新疆克拉玛依市",
"861333688", "浙江省宁波市",
"861367442", "吉林省吉林市",
"861388694", "湖北省荆门市",
"861392259", "广东省韶关市",
"861356854", "四川省资阳市",
"861822451", "河南省郑州市",
"861343195", "广东省清远市",
"861820540", "山东省菏泽市",
"86187383", "河南省新乡市",
"861803348", "广东省东莞市",
"86155023", "重庆市",
"861388165", "四川省巴中市",
"861591176", "云南省玉溪市",
"861709717", "广东省佛山市",
"861504688", "黑龙江省大庆市",
"861850904", "新疆和田地区",
"861324396", "辽宁省辽阳市",
"86150933", "河南省郑州市",
"861376272", "湖南省益阳市",
"861375552", "江西省萍乡市",
"861505901", "福建省三明市",
"861831473", "湖北省黄石市",
"861503344", "河北省石家庄市",
"861394910", "河南省郑州市",
"86152604", "福建省泉州市",
"861835903", "福建省莆田市",
"861519956", "新疆哈密地区",
"861773418", "河北省邢台市",
"861320867", "吉林省辽源市",
"861867348", "湖南省娄底市",
"861501471", "广东省佛山市",
"861890470", "内蒙古呼伦贝尔市",
"861303442", "湖北省黄石市",
"861520762", "广东省河源市",
"861306988", "黑龙江省哈尔滨市",
"861893581", "新疆石河子市",
"861301299", "山东省济南市",
"86186613", "山东省泰安市",
"861318816", "辽宁省朝阳市",
"861834739", "内蒙古通辽市",
"861803489", "新疆阿克苏地区",
"86158156", "广东省佛山市",
"861769935", "新疆昌吉回族自治州",
"861800787", "广西桂林市",
"861336004", "广东省广州市",
"861454971", "浙江省嘉兴市",
"861569238", "山东省青岛市",
"861700198", "广东省广州市",
"861889745", "湖南省怀化市",
"861853655", "山西省朔州市",
"861377287", "陕西省延安市",
"861774904", "陕西省西安市",
"861350952", "福建省南平市",
"861319212", "广东省潮州市",
"861387297", "湖北省武汉市",
"861700573", "浙江省嘉兴市",
"861377411", "湖北省随州市",
"861816008", "四川省广元市",
"861368413", "四川省资阳市",
"861362243", "广东省清远市",
"861478329", "河南省焦作市",
"861590254", "贵州省安顺市",
"861510997", "新疆阿克苏地区",
"86180724", "浙江省金华市",
"861305413", "湖南省株洲市",
"861539831", "云南省文山壮族苗族自治州",
"861537504", "安徽省巢湖市",
"86134270", "广东省中山市",
"861359340", "山西省吕梁市",
"86139683", "浙江省宁波市",
"861335022", "四川省广安市",
"861470533", "山东省淄博市",
"861310870", "云南省昆明市",
"861558304", "四川省南充市",
"861840419", "辽宁省辽阳市",
"861529830", "江苏省宿迁市",
"861558270", "山西省临汾市",
"861318113", "山东省威海市",
"86157392", "新疆阿克苏地区",
"861863367", "河北省沧州市",
"861304606", "山东省淄博市",
"86158550", "安徽省滁州市",
"86188472", "内蒙古包头市",
"86134534", "山西省太原市",
"861871564", "安徽省六安市",
"861882721", "湖北省黄冈市",
"861369677", "安徽省合肥市",
"861894842", "广东省江门市",
"861884935", "河北省秦皇岛市",
"861454709", "浙江省绍兴市",
"861570534", "山东省德州市",
"86186487", "内蒙古巴彦淖尔市",
"861458303", "江西省鹰潭市",
"861454461", "陕西省西安市",
"86145246", "黑龙江省哈尔滨市",
"861862871", "吉林省松原市",
"86137587", "浙江省温州市",
"861830529", "江苏省镇江市",
"861839949", "新疆和田地区",
"861312300", "福建省泉州市",
"861390648", "山东省青岛市",
"861330676", "浙江省台州市",
"861811558", "江苏省镇江市",
"861700402", "广东省广州市",
"861870059", "陕西省西安市",
"861530491", "辽宁省鞍山市",
"861337373", "河南省新乡市",
"861341791", "广东省珠海市",
"861530933", "甘肃省平凉市",
"861527014", "江西省鹰潭市",
"86136365", "上海市",
"86183678", "浙江省温州市",
"861342418", "广东省深圳市",
"861875142", "江苏省盐城市",
"86133369", "浙江省温州市",
"861890960", "安徽省滁州市",
"861330279", "广东省潮州市",
"861812524", "广东省中山市",
"861399040", "四川省阿坝藏族羌族自治州",
"861560451", "黑龙江省哈尔滨市",
"86182715", "湖北省黄冈市",
"86139417", "辽宁省营口市",
"86132961", "上海市",
"861347566", "山东省潍坊市",
"861555934", "新疆伊犁哈萨克自治州",
"861771994", "河南省郑州市",
"861591930", "广东省广州市",
"861590423", "辽宁省阜新市",
"861591651", "广东省梅州市",
"861392171", "江苏省泰州市",
"861394889", "内蒙古兴安盟",
"861537142", "江苏省连云港市",
"861818397", "云南省丽江市",
"861373397", "河南省漯河市",
"861457059", "新疆伊犁哈萨克自治州",
"861800493", "辽宁省抚顺市",
"861525729", "浙江省嘉兴市",
"861332528", "山东省泰安市",
"861800931", "甘肃省兰州市",
"861361448", "吉林省松原市",
"861568779", "云南省昆明市",
"861856969", "湖南省娄底市",
"861558060", "湖南省张家界市",
"861831963", "广东省惠州市",
"861326356", "黑龙江省七台河市",
"861560466", "黑龙江省哈尔滨市",
"861367754", "新疆石河子市",
"861890636", "山东省潍坊市",
"86152363", "河南省驻马店市",
"861899150", "陕西省商洛市",
"86181036", "黑龙江省哈尔滨市",
"861707369", "河南省南阳市",
"861556447", "山东省淄博市",
"861370149", "江苏省常州市",
"861319696", "江苏省淮安市",
"861857858", "广东省汕尾市",
"861537360", "河北省秦皇岛市",
"861320431", "吉林省长春市",
"861700263", "广东省江门市",
"861890239", "广东省广州市",
"861331316", "河北省廊坊市",
"861316775", "安徽省宣城市",
"861769129", "陕西省铜川市",
"861337794", "湖北省武汉市",
"861342109", "广东省潮州市",
"861800877", "云南省玉溪市",
"861779112", "陕西省榆林市",
"861591269", "云南省昭通市",
"861470858", "贵州省六盘水市",
"86183413", "辽宁省抚顺市",
"861364360", "山西省太原市",
"86151133", "广东省中山市",
"861388675", "湖北省恩施土家族苗族自治州",
"861376903", "云南省丽江市",
"861534754", "广东省清远市",
"861591385", "广东省惠州市",
"861309148", "黑龙江省伊春市",
"861344030", "江苏省泰州市",
"86158127", "广东省珠海市",
"861365390", "河南省新乡市",
"861777604", "广西南宁市",
"86133960", "湖北省武汉市",
"861369850", "贵州省安顺市",
"861358263", "河北省张家口市",
"861308390", "浙江省湖州市",
"861457182", "浙江省温州市",
"861310657", "广东省佛山市",
"861336504", "福建省厦门市",
"861475105", "江苏省常州市",
"861568910", "山东省青岛市",
"861596601", "山东省泰安市",
"861539467", "江苏省盐城市",
"861867702", "广西防城港市",
"861510863", "云南省德宏傣族景颇族自治州",
"861346825", "山东省莱芜市",
"861335350", "山西省忻州市",
"86139290", "广东省江门市",
"861301212", "河北省邢台市",
"861323810", "辽宁省抚顺市",
"861868376", "四川省德阳市",
"86188071", "湖北省武汉市",
"861876022", "福建省宁德市",
"861550692", "福建省厦门市",
"86188003", "上海市",
"86151847", "内蒙古呼和浩特市",
"861379307", "山东省聊城市",
"861778791", "云南省玉溪市",
"861816508", "陕西省商洛市",
"861454456", "江西省吉安市",
"861771248", "江苏省苏州市",
"861822697", "安徽省池州市",
"861359162", "辽宁省铁岭市",
"861333811", "江苏省无锡市",
"86158500", "江苏省苏州市",
"861580358", "山西省吕梁市",
"86151896", "江苏省淮安市",
"861581683", "广东省东莞市",
"861347679", "湖北省武汉市",
"86138476", "内蒙古赤峰市",
"861454837", "广东省阳江市",
"861562255", "广东省清远市",
"86150517", "江苏省苏州市",
"861363327", "河北省沧州市",
"86156817", "四川省宜宾市",
"86152512", "江苏省连云港市",
"861381341", "江苏省盐城市",
"861330569", "安徽省合肥市",
"861504232", "辽宁省鞍山市",
"861857713", "广西崇左市",
"861383474", "山西省吕梁市",
"861323989", "新疆昌吉回族自治州",
"861887635", "福建省泉州市",
"861570034", "四川省广安市",
"86183687", "浙江省温州市",
"861583372", "河北省邢台市",
"861571450", "黑龙江省哈尔滨市",
"861539977", "湖南省常德市",
"861571693", "河北省张家口市",
"861836189", "江苏省宿迁市",
"86186478", "内蒙古巴彦淖尔市",
"861840760", "广东省中山市",
"861837416", "湖南省永州市",
"861336142", "山东省枣庄市",
"861811136", "四川省广元市",
"861399540", "宁夏银川市",
"86137578", "浙江省丽水市",
"861831897", "广东省汕尾市",
"861312564", "辽宁省营口市",
"861870559", "安徽省黄山市",
"861534336", "湖南省常德市",
"861840492", "山西省大同市",
"861391433", "江苏省常州市",
"861772174", "江苏省盐城市",
"861860310", "河北省邯郸市",
"861360633", "山东省日照市",
"861847526", "广东省肇庆市",
"861595606", "安徽省合肥市",
"861367336", "河南省郑州市",
"861560976", "青海省玉树藏族自治州",
"861551379", "山西省晋中市",
"861558560", "吉林省松原市",
"861326014", "内蒙古赤峰市",
"861312311", "福建省泉州市",
"861331054", "湖北省恩施土家族苗族自治州",
"861871300", "河北省廊坊市",
"861519961", "新疆博尔塔拉蒙古自治州",
"861847141", "湖北省黄冈市",
"861330430", "吉林省长春市",
"86138579", "浙江省金华市",
"861812180", "四川省南充市",
"861580627", "江苏省南通市",
"861857262", "湖北省荆州市",
"861803267", "河北省石家庄市",
"861593441", "山西省晋中市",
"861504063", "辽宁省大连市",
"861388684", "湖北省十堰市",
"861364309", "广东省梅州市",
"861343185", "广东省惠州市",
"861368703", "江西省上饶市",
"86181155", "江苏省苏州市",
"861377469", "福建省厦门市",
"861814267", "湖南省常德市",
"861816438", "安徽省蚌埠市",
"861840971", "青海省西宁市",
"861320730", "湖南省岳阳市",
"86188383", "河南省周口市",
"861813694", "江苏省泰州市",
"861863975", "河南省商丘市",
"861509114", "陕西省宝鸡市",
"861536332", "广东省肇庆市",
"861334521", "山东省淄博市",
"861360672", "浙江省台州市",
"86183206", "广东省茂名市",
"861344287", "云南省昭通市",
"861336434", "吉林省四平市",
"86180905", "四川省南充市",
"861478524", "贵州省黔东南苗族侗族自治州",
"861808051", "四川省巴中市",
"861506639", "山东省青岛市",
"861805195", "江苏省无锡市",
"861780557", "安徽省宿州市",
"86137205", "陕西省西安市",
"861345348", "山西省临汾市",
"861868195", "陕西省宝鸡市",
"861550661", "山东省菏泽市",
"861575459", "黑龙江省大庆市",
"861598434", "四川省眉山市",
"861838155", "四川省资阳市",
"861595125", "江苏省连云港市",
"861773708", "河南省平顶山市",
"86135346", "广东省潮州市",
"861823027", "河北省秦皇岛市",
"861536895", "云南省德宏傣族景颇族自治州",
"861504273", "辽宁省营口市",
"861386581", "安徽省滁州市",
"861313939", "甘肃省陇南市",
"861890881", "云南省西双版纳傣族自治州",
"861473058", "河北省保定市",
"861815297", "新疆阿克苏地区",
"861501880", "广东省汕头市",
"861330987", "辽宁省盘锦市",
"861380046", "黑龙江省七台河市",
"861323567", "湖北省十堰市",
"861320501", "福建省福州市",
"861583333", "河北省保定市",
"861353110", "广东省湛江市",
"861452468", "黑龙江省鹤岗市",
"861889966", "新疆昌吉回族自治州",
"861576710", "广东省湛江市",
"861571751", "湖南省长沙市",
"861817199", "湖北省荆门市",
"86155582", "浙江省宁波市",
"861372782", "广东省茂名市",
"861309749", "云南省大理白族自治州",
"861397250", "湖北省十堰市",
"861338545", "山东省烟台市",
"861330500", "福建省福州市",
"861308026", "内蒙古赤峰市",
"861334843", "福建省三明市",
"861572887", "广东省潮州市",
"861874026", "辽宁省大连市",
"861329862", "湖南省益阳市",
"861452978", "广东省揭阳市",
"861896387", "新疆伊犁哈萨克自治州",
"861459249", "四川省攀枝花市",
"861821883", "广东省河源市",
"861813220", "河北省邯郸市",
"861382460", "广东省肇庆市",
"861582897", "四川省遂宁市",
"861359191", "辽宁省辽阳市",
"861370748", "湖南省长沙市",
"861880538", "山东省泰安市",
"861350996", "广东省佛山市",
"861361399", "河南省南阳市",
"861567843", "广西崇左市",
"861825090", "福建省宁德市",
"861459646", "甘肃省白银市",
"861331359", "山西省运城市",
"861818495", "西藏昌都地区",
"861569908", "新疆克孜勒苏柯尔克孜自治州",
"86135397", "广东省广州市",
"861804220", "浙江省金华市",
"861330731", "湖南省长沙市",
"861304570", "浙江省衢州市",
"861538838", "四川省达州市",
"861479489", "内蒙古鄂尔多斯市",
"861782664", "江苏省常州市",
"861582002", "山东省青岛市",
"861301763", "河南省洛阳市",
"861327548", "山东省泰安市",
"861397045", "江西省吉安市",
"86151368", "河南省许昌市",
"861330011", "北京市",
"861551264", "河北省廊坊市",
"861454419", "福建省莆田市",
"86135819", "北京市",
"86131114", "河北省唐山市",
"861824060", "河南省安阳市",
"861310328", "河北省衡水市",
"861313570", "湖北省十堰市",
"861876947", "山东省德州市",
"861519992", "新疆巴音郭楞蒙古自治州",
"861310481", "广东省云浮市",
"861475626", "河北省邢台市",
"861358712", "浙江省衢州市",
"861568231", "四川省泸州市",
"861359957", "福建省漳州市",
"861328669", "广东省深圳市",
"861772185", "四川省德阳市",
"861866138", "山东省东营市",
"861302343", "江苏省镇江市",
"86152138", "甘肃省庆阳市",
"861809782", "新疆昌吉回族自治州",
"861872749", "湖北省孝感市",
"861862480", "河南省南阳市",
"861596545", "山东省东营市",
"861830324", "河北省邯郸市",
"861840461", "黑龙江省双鸭山市",
"861898706", "云南省昆明市",
"861843407", "山西省临汾市",
"861351303", "河北省沧州市",
"861354884", "湖南省常德市",
"86181105", "安徽省阜阳市",
"861323277", "广东省河源市",
"861890771", "广西南宁市",
"861530972", "青海省海东地区",
"86182648", "山东省泰安市",
"861337332", "河北省保定市",
"861880853", "贵州省安顺市",
"861332915", "安徽省巢湖市",
"861539686", "江苏省盐城市",
"861396553", "安徽省黄山市",
"861877429", "湖南省郴州市",
"86188040", "辽宁省沈阳市",
"861520791", "江西省南昌市",
"861537434", "江西省抚州市",
"861328898", "广东省茂名市",
"861521720", "广东省广州市",
"861375788", "浙江省温州市",
"861454108", "安徽省阜阳市",
"861563998", "河南省平顶山市",
"861592986", "陕西省咸阳市",
"861450429", "辽宁省葫芦岛市",
"861328251", "浙江省金华市",
"861840456", "黑龙江省黑河市",
"861898459", "贵州省贵阳市",
"86183256", "安徽省安庆市",
"861773342", "河北省秦皇岛市",
"861867412", "湖北省襄樊市",
"861314318", "广东省佛山市",
"861364434", "吉林省四平市",
"86180955", "宁夏中卫市",
"861776921", "湖南省张家界市",
"861535429", "河北省邢台市",
"861779086", "辽宁省沈阳市",
"861576469", "黑龙江省鹤岗市",
"86133202", "重庆市",
"861303318", "安徽省安庆市",
"861576701", "广东省湛江市",
"861533958", "贵州省六盘水市",
"861320510", "江苏省常州市",
"861835591", "安徽省亳州市",
"861337895", "湖南省怀化市",
"861866271", "江苏省南京市",
"861556345", "山东省青岛市",
"861470572", "浙江省湖州市",
"861587581", "广东省肇庆市",
"861560687", "浙江省温州市",
"861377030", "江苏省南京市",
"861707564", "安徽省六安市",
"86185342", "山西省晋中市",
"861457016", "山东省威海市",
"861367855", "贵州省黔东南苗族侗族自治州",
"86137255", "广东省深圳市",
"86132925", "河北省唐山市",
"861571766", "河北省廊坊市",
"861503049", "河北省邢台市",
"861538553", "安徽省芜湖市",
"861814577", "广东省佛山市",
"861870736", "湖南省常德市",
"861323067", "河北省廊坊市",
"861380546", "山东省东营市",
"861594703", "内蒙古呼和浩特市",
"861534855", "贵州省黔东南苗族侗族自治州",
"861306602", "山东省济南市",
"861598309", "四川省遂宁市",
"861315441", "四川省甘孜藏族自治州",
"861505593", "安徽省淮南市",
"86136321", "广东省广州市",
"861707311", "河北省石家庄市",
"861473558", "山西省长治市",
"861365526", "江苏省泰州市",
"861328576", "浙江省台州市",
"861843280", "河北省邯郸市",
"861312369", "贵州省黔西南布依族苗族自治州",
"861338045", "广东省中山市",
"861870354", "山西省晋中市",
"861330000", "广西南宁市",
"861308526", "湖北省十堰市",
"861575706", "浙江省衢州市",
"861454492", "湖北省恩施土家族苗族自治州",
"861597838", "河南省信阳市",
"861308141", "山东省东营市",
"861550656", "山东省菏泽市",
"861809872", "安徽省宿州市",
"86139223", "广东省广州市",
"861318859", "辽宁省盘锦市",
"861783506", "山西省临汾市",
"861824439", "四川省绵阳市",
"861829822", "安徽省马鞍山市",
"861454760", "山东省菏泽市",
"861302187", "河北省保定市",
"861882420", "广东省东莞市",
"861315635", "山东省聊城市",
"861889951", "新疆乌鲁木齐市",
"861313260", "广西南宁市",
"861880156", "江苏省苏州市",
"86139568", "安徽省宿州市",
"861700532", "山东省青岛市",
"861304260", "辽宁省鞍山市",
"861311749", "湖南省邵阳市",
"861358799", "浙江省温州市",
"861338250", "江苏省苏州市",
"861303134", "新疆博尔塔拉蒙古自治州",
"86150798", "江西省景德镇市",
"861856900", "湖南省株洲市",
"861840837", "四川省阿坝藏族羌族自治州",
"861305290", "江苏省镇江市",
"861879187", "陕西省宝鸡市",
"861590614", "江苏省常州市",
"861355363", "广东省韶关市",
"861591793", "广东省梅州市",
"861327048", "江苏省徐州市",
"861370302", "广东省佛山市",
"861330511", "江苏省盐城市",
"861570815", "四川省遂宁市",
"861501992", "广东省珠海市",
"861834056", "辽宁省朝阳市",
"861866556", "广东省广州市",
"86181779", "广西北海市",
"861596045", "福建省宁德市",
"861530462", "黑龙江省齐齐哈尔市",
"861526548", "山东省泰安市",
"861890909", "四川省宜宾市",
"861700799", "江西省南昌市",
"861584617", "黑龙江省大庆市",
"861319763", "广西桂林市",
"861361312", "河北省保定市",
"861326392", "江西省九江市",
"861340421", "江苏省苏州市",
"861865276", "江苏省扬州市",
"861530790", "江西省新余市",
"86158543", "山东省滨州市",
"861330364", "黑龙江省哈尔滨市",
"861891922", "甘肃省天水市",
"861572777", "江西省赣州市",
"861340388", "河南省周口市",
"861836204", "江苏省镇江市",
"861571303", "河北省张家口市",
"861391247", "江苏省无锡市",
"861334219", "辽宁省锦州市",
"861871137", "湖南省株洲市",
"861839482", "甘肃省张掖市",
"861390792", "江西省九江市",
"861515281", "江苏省徐州市",
"861800827", "四川省巴中市",
"861819732", "青海省海东地区",
"861877087", "江西省赣州市",
"861819012", "四川省巴中市",
"861858563", "贵州省毕节地区",
"861555788", "浙江省宁波市",
"861329148", "浙江省杭州市",
"861334616", "浙江省杭州市",
"861363746", "湖南省永州市",
"861306356", "江苏省南通市",
"861887097", "江西省赣州市",
"861478585", "贵州省黔南布依族苗族自治州",
"86130704", "新疆乌鲁木齐市",
"861535087", "河北省秦皇岛市",
"861585946", "福建省泉州市",
"86150363", "河南省洛阳市",
"861560313", "河北省张家口市",
"861781738", "广东省湛江市",
"861527988", "江西省宜春市",
"861584894", "内蒙古呼和浩特市",
"861521956", "广东省江门市",
"861331463", "黑龙江省牡丹江市",
"861300993", "黑龙江省黑河市",
"861512950", "陕西省宝鸡市",
"861559405", "甘肃省陇南市",
"86139011", "北京市",
"861303810", "四川省自贡市",
"861335572", "浙江省湖州市",
"861761464", "黑龙江省七台河市",
"861768881", "广东省东莞市",
"861398916", "四川省达州市",
"861376345", "黑龙江省齐齐哈尔市",
"861390539", "山东省临沂市",
"8614710", "四川省成都市",
"861871453", "黑龙江省牡丹江市",
"861452515", "山东省烟台市",
"861554551", "黑龙江省绥化市",
"861389750", "青海省海北藏族自治州",
"861353640", "广东省湛江市",
"861557710", "广西崇左市",
"861351766", "广西南宁市",
"861328390", "河南省焦作市",
"861528764", "云南省丽江市",
"861522457", "广西钦州市",
"861859355", "福建省龙岩市",
"861339449", "吉林省长春市",
"861801099", "安徽省阜阳市",
"861881680", "广东省广州市",
"861383424", "山西省太原市",
"861370259", "广东省江门市",
"86187586", "浙江省台州市",
"861530547", "山东省济宁市",
"861338391", "河南省焦作市",
"861355706", "广西百色市",
"861303989", "黑龙江省鸡西市",
"86136486", "海南省海口市",
"861588789", "云南省玉溪市",
"861850452", "黑龙江省齐齐哈尔市",
"861370656", "浙江省台州市",
"861314989", "辽宁省大连市",
"861583322", "河北省保定市",
"861539927", "陕西省延安市",
"86183682", "浙江省宁波市",
"861459116", "广西桂林市",
"86189519", "江苏省南京市",
"861853478", "山西省吕梁市",
"861342284", "广东省中山市",
"861332268", "广东省汕尾市",
"861327906", "新疆阿克苏地区",
"86138264", "广东省广州市",
"861868913", "西藏山南地区",
"86152517", "江苏省南京市",
"861844969", "新疆巴音郭楞蒙古自治州",
"86150512", "江苏省南通市",
"861363377", "河南省南阳市",
"86132331", "山西省大同市",
"861531239", "江苏省常州市",
"861551329", "山西省太原市",
"86189416", "辽宁省锦州市",
"861306014", "四川省泸州市",
"861332078", "四川省泸州市",
"861565117", "江苏省泰州市",
"861847576", "广东省中山市",
"861470947", "甘肃省兰州市",
"861882881", "四川省阿坝藏族羌族自治州",
"861760706", "江西省吉安市",
"861825747", "浙江省金华市",
"861379697", "黑龙江省绥化市",
"861331973", "新疆伊犁哈萨克自治州",
"861829558", "宁夏银川市",
"86188488", "河南省郑州市",
"861350815", "四川省乐山市",
"861802130", "江苏省苏州市",
"861888847", "广西钦州市",
"861552872", "四川省宜宾市",
"861554679", "广东省潮州市",
"861830666", "广东省深圳市",
"861894410", "江苏省南京市",
"861830385", "河南省开封市",
"86187489", "贵州省黔西南布依族苗族自治州",
"861518215", "四川省成都市",
"861300645", "四川省德阳市",
"861554276", "辽宁省盘锦市",
"861803942", "河南省商丘市",
"861365600", "福建省厦门市",
"861390970", "青海省海北藏族自治州",
"861771716", "河北省邯郸市",
"86133585", "福建省泉州市",
"861806321", "山东省枣庄市",
"86131161", "天津市",
"861857947", "广西南宁市",
"861833188", "河北省邯郸市",
"861312453", "黑龙江省牡丹江市",
"861500653", "山东省淄博市",
"861300867", "云南省昆明市",
"861380908", "江苏省南通市",
"861760459", "黑龙江省大庆市",
"861303801", "山西省运城市",
"861521471", "浙江省金华市",
"861337916", "陕西省汉中市",
"861892718", "广东省云浮市",
"861354825", "四川省德阳市",
"861557701", "广西柳州市",
"861500762", "广东省河源市",
"861888665", "四川省广元市",
"86131280", "广东省东莞市",
"861892156", "江苏省镇江市",
"861891933", "甘肃省平凉市",
"861321299", "黑龙江省佳木斯市",
"861358523", "江苏省扬州市",
"861890420", "辽宁省鞍山市",
"861376222", "湖南省湘潭市",
"86151793", "江西省上饶市",
"861524688", "黑龙江省双鸭山市",
"861590963", "宁夏吴忠市",
"861304396", "河南省驻马店市",
"861705771", "福建省厦门市",
"861860691", "福建省福州市",
"861831423", "云南省普洱市",
"861313396", "江西省吉安市",
"861862543", "河南省鹤壁市",
"861830930", "甘肃省临夏回族自治州",
"861450587", "辽宁省铁岭市",
"861564916", "河南省信阳市",
"861345840", "四川省南充市",
"861535587", "浙江省温州市",
"86130754", "重庆市",
"861525901", "福建省龙岩市",
"861332896", "福建省泉州市",
"861478379", "河南省洛阳市",
"861875252", "江苏省扬州市",
"861353928", "广东省揭阳市",
"861807406", "浙江省嘉兴市",
"861364252", "广东省清远市",
"86155205", "四川省绵阳市",
"861700523", "江苏省泰州市",
"861471560", "广东省东莞市",
"861393417", "山西省临汾市",
"861818607", "湖北省武汉市",
"861709943", "浙江省丽水市",
"861335072", "四川省乐山市",
"861355459", "湖北省荆州市",
"861452735", "湖南省郴州市",
"861776108", "四川省泸州市",
"861556591", "河南省漯河市",
"861390039", "辽宁省辽阳市",
"861362856", "贵州省贵阳市",
"861348036", "广东省云浮市",
"861820787", "广西钦州市",
"861567292", "湖北省十堰市",
"86145292", "广东省深圳市",
"861858273", "四川省眉山市",
"861801599", "江苏省镇江市",
"861591529", "广东省茂名市",
"861476016", "福建省泉州市",
"86137582", "浙江省杭州市",
"861830579", "浙江省金华市",
"861351751", "广西南宁市",
"861317689", "山东省青岛市",
"861848548", "贵州省黔东南苗族侗族自治州",
"861317286", "广东省汕尾市",
"861301306", "安徽省合肥市",
"861580986", "辽宁省葫芦岛市",
"861894769", "内蒙古兴安盟",
"861708339", "河北省石家庄市",
"861847669", "广东省深圳市",
"86189240", "广东省广州市",
"861859172", "陕西省宝鸡市",
"861859681", "福建省三明市",
"861570996", "新疆巴音郭楞蒙古自治州",
"861310820", "四川省眉山市",
"861550748", "湖南省长沙市",
"861538330", "河北省邯郸市",
"861369627", "四川省绵阳市",
"861365611", "江苏省常州市",
"86187261", "安徽省安庆市",
"861362437", "吉林省辽源市",
"861831254", "广东省惠州市",
"861510241", "辽宁省丹东市",
"86188477", "内蒙古鄂尔多斯市",
"861308611", "江西省上饶市",
"861770647", "浙江省宁波市",
"861768909", "西藏拉萨市",
"861590473", "内蒙古乌海市",
"861569046", "河北省廊坊市",
"86139412", "辽宁省鞍山市",
"861475731", "浙江省宁波市",
"861813509", "山西省忻州市",
"861378509", "河北省唐山市",
"86185868", "贵州省贵阳市",
"861458945", "广东省中山市",
"861820931", "甘肃省兰州市",
"861820650", "山东省枣庄市",
"861363484", "黑龙江省齐齐哈尔市",
"861820493", "内蒙古鄂尔多斯市",
"861776760", "新疆伊犁哈萨克自治州",
"861568729", "云南省迪庆藏族自治州",
"861332578", "浙江省丽水市",
"861396330", "山东省日照市",
"861535900", "福建省福州市",
"861877900", "江西省新余市",
"86158818", "四川省达州市",
"861896613", "浙江省台州市",
"86187685", "浙江省宁波市",
"861555596", "安徽省阜阳市",
"861771536", "江苏省苏州市",
"861521961", "广东省揭阳市",
"861337323", "河北省沧州市",
"861531470", "浙江省台州市",
"861507014", "江西省新余市",
"861340770", "广西南宁市",
"861362153", "江苏省无锡市",
"861561673", "湖南省湘潭市",
"86159886", "浙江省宁波市",
"861583245", "河北省保定市",
"861817642", "广西桂林市",
"861350339", "河北省邢台市",
"861700841", "贵州省贵阳市",
"86180715", "湖北省武汉市",
"861804817", "四川省绵阳市",
"861378817", "广西钦州市",
"861478074", "四川省南充市",
"861776971", "浙江省绍兴市",
"861535479", "吉林省白山市",
"861308251", "江苏省常州市",
"861860662", "浙江省宁波市",
"861831614", "广东省肇庆市",
"861815854", "浙江省绍兴市",
"861590432", "吉林省吉林市",
"861363965", "河南省驻马店市",
"861830793", "江西省上饶市",
"861399483", "山西省吕梁市",
"861550149", "江苏省苏州市",
"861819186", "陕西省西安市",
"861366571", "浙江省湖州市",
"861334071", "四川省攀枝花市",
"861810981", "辽宁省朝阳市",
"861860753", "广东省梅州市",
"861770764", "广东省阳江市",
"861390334", "河北省秦皇岛市",
"861855794", "浙江省绍兴市",
"86186351", "山西省太原市",
"861859457", "福建省龙岩市",
"861458751", "广东省韶关市",
"861339398", "河南省驻马店市",
"861880649", "山东省滨州市",
"861890721", "湖北省荆州市",
"861567071", "河南省洛阳市",
"861357272", "陕西省渭南市",
"861303277", "湖北省荆门市",
"86180648", "云南省昆明市",
"861346774", "湖南省衡阳市",
"861365898", "西藏拉萨市",
"861521770", "广东省广州市",
"861556903", "新疆和田地区",
"861531909", "陕西省渭南市",
"861340961", "湖北省荆门市",
"861308898", "陕西省西安市",
"861561632", "湖南省衡阳市",
"861524563", "黑龙江省佳木斯市",
"861362980", "河南省洛阳市",
"861500791", "江西省南昌市",
"861303067", "安徽省阜阳市",
"861300001", "江苏省常州市",
"861327639", "山东省青岛市",
"861470350", "山西省忻州市",
"861589633", "江苏省宿迁市",
"861327236", "湖南省郴州市",
"861314067", "河南省驻马店市",
"861471817", "广东省梅州市",
"861470522", "江苏省徐州市",
"861370692", "福建省宁德市",
"861850496", "内蒙古呼和浩特市",
"861568128", "四川省攀枝花市",
"861559307", "甘肃省甘南藏族自治州",
"861316824", "广东省汕头市",
"861882960", "陕西省西安市",
"861537868", "四川省雅安市",
"861873995", "河南省开封市",
"861471509", "广东省深圳市",
"861351945", "甘肃省武威市",
"861556562", "河南省焦作市",
"86130925", "江苏省常州市",
"861524902", "陕西省榆林市",
"861479942", "新疆阿克苏地区",
"861311862", "广东省潮州市",
"861871808", "广东省佛山市",
"861322187", "浙江省宁波市",
"861897245", "湖北省十堰市",
"861534999", "新疆乌鲁木齐市",
"861771406", "江苏省苏州市",
"861552558", "山西省晋中市",
"861882470", "广东省广州市",
"861518428", "辽宁省盘锦市",
"861564959", "河南省驻马店市",
"861876533", "山东省淄博市",
"86185396", "河南省驻马店市",
"861324260", "广东省肇庆市",
"861787589", "广东省东莞市",
"861894700", "内蒙古呼伦贝尔市",
"861813439", "河北省邢台市",
"861760416", "辽宁省锦州市",
"861873643", "河南省漯河市",
"861810737", "湖南省益阳市",
"861539104", "内蒙古赤峰市",
"861452640", "江苏省连云港市",
"861366659", "浙江省舟山市",
"861475569", "安徽省安庆市",
"861337959", "陕西省安康市",
"861308576", "广东省汕头市",
"861810017", "浙江省杭州市",
"861860818", "四川省达州市",
"861777599", "湖南省长沙市",
"861365576", "浙江省台州市",
"861366256", "广东省深圳市",
"861328141", "陕西省渭南市",
"861399797", "湖北省武汉市",
"861830487", "内蒙古赤峰市",
"861318643", "江苏省南京市",
"861819883", "广东省东莞市",
"861367999", "新疆塔城地区",
"861521992", "广东省中山市",
"861865629", "安徽省亳州市",
"861537612", "山东省菏泽市",
"861581228", "云南省文山壮族苗族自治州",
"861598296", "四川省绵阳市",
"86189253", "广东省中山市",
"861808629", "湖北省武汉市",
"861506548", "山东省泰安市",
"861894531", "黑龙江省牡丹江市",
"861772907", "陕西省西安市",
"861474599", "黑龙江省大庆市",
"861572727", "湖北省襄樊市",
"861533847", "广东省茂名市",
"861598699", "广东省惠州市",
"861316938", "广东省云浮市",
"861341849", "广东省深圳市",
"861476059", "宁夏银川市",
"861777012", "江西省赣州市",
"861535969", "福建省漳州市",
"861514638", "黑龙江省哈尔滨市",
"861776709", "浙江省杭州市",
"861895402", "山东省东营市",
"86151938", "甘肃省天水市",
"861804560", "黑龙江省黑河市",
"861450969", "新疆乌鲁木齐市",
"861363475", "内蒙古通辽市",
"861813560", "河南省驻马店市",
"861867634", "广东省深圳市",
"861364612", "江苏省常州市",
"861362819", "四川省乐山市",
"861842025", "广东省梅州市",
"861348759", "湖南省长沙市",
"861768960", "福建省福州市",
"861576929", "陕西省西安市",
"861580850", "贵州省贵阳市",
"861307048", "新疆哈密地区",
"861359848", "河南省洛阳市",
"861334571", "浙江省杭州市",
"861562483", "内蒙古阿拉善盟",
"861300730", "湖南省岳阳市",
"861300010", "北京市",
"861452834", "四川省乐山市",
"861361609", "福建省宁德市",
"861869744", "内蒙古锡林郭勒盟",
"861309618", "四川省宜宾市",
"861357903", "新疆巴音郭楞蒙古自治州",
"86138845", "甘肃省武威市",
"86182905", "重庆市",
"861331932", "江西省上饶市",
"861816946", "湖南省永州市",
"861532680", "内蒙古呼伦贝尔市",
"861824694", "黑龙江省大庆市",
"861823267", "河北省廊坊市",
"861348406", "浙江省金华市",
"861555320", "山东省青岛市",
"861450230", "河北省张家口市",
"861315597", "江西省萍乡市",
"861770331", "河北省石家庄市",
"861390409", "辽宁省大连市",
"861768636", "山东省潍坊市",
"861539042", "四川省成都市",
"861477177", "湖北省恩施土家族苗族自治州",
"861524063", "广西玉林市",
"861535230", "甘肃省兰州市",
"86178394", "河南省周口市",
"861533386", "河南省郑州市",
"861807158", "湖北省十堰市",
"86186301", "河北省石家庄市",
"861840921", "陕西省延安市",
"861768239", "浙江省宁波市",
"861459159", "广西北海市",
"861841990", "甘肃省临夏回族自治州",
"861807036", "江西省赣州市",
"861325703", "江西省上饶市",
"861370619", "江苏省无锡市",
"86186373", "河南省新乡市",
"861772080", "福建省福州市",
"861533194", "黑龙江省哈尔滨市",
"86131125", "广东省汕头市",
"861857022", "湖南省湘潭市",
"861524273", "辽宁省抚顺市",
"861525093", "江苏省徐州市",
"861336868", "贵州省六盘水市",
"861314567", "安徽省亳州市",
"861823077", "贵州省毕节地区",
"861354724", "四川省达州市",
"861894293", "湖北省武汉市",
"861324939", "广东省深圳市",
"861357562", "浙江省舟山市",
"861538974", "内蒙古乌兰察布市",
"861814027", "四川省南充市",
"861570952", "宁夏石嘴山市",
"861864828", "内蒙古通辽市",
"861593097", "河北省邢台市",
"861526639", "山东省临沂市",
"861816864", "江苏省连云港市",
"861573978", "新疆克孜勒苏柯尔克孜自治州",
"861844587", "黑龙江省哈尔滨市",
"861453887", "云南省丽江市",
"861470022", "安徽省六安市",
"861476182", "江苏省宿迁市",
"861567659", "广西来宾市",
"861378304", "河南省鹤壁市",
"861302905", "吉林省松原市",
"861551953", "贵州省六盘水市",
"861371585", "广东省汕头市",
"861573468", "黑龙江省鹤岗市",
"861335533", "山东省淄博市",
"86170780", "四川省成都市",
"861561288", "河北省唐山市",
"86134815", "广西玉林市",
"861567256", "湖北省咸宁市",
"861537699", "山东省烟台市",
"861827248", "湖北省武汉市",
"861350534", "山东省德州市",
"861338362", "河北省保定市",
"861334256", "湖南省常德市",
"861555189", "安徽省阜阳市",
"861815941", "福建省莆田市",
"861509767", "河北省邯郸市",
"861362892", "西藏日喀则地区",
"861532757", "湖北省孝感市",
"86155587", "浙江省温州市",
"861364699", "福建省莆田市",
"861889426", "甘肃省张掖市",
"861875296", "江苏省镇江市",
"861587743", "陕西省渭南市",
"861874076", "陕西省汉中市",
"861538464", "陕西省西安市",
"861562797", "广东省汕尾市",
"861334659", "广东省云浮市",
"861333308", "河北省衡水市",
"861476559", "湖北省武汉市",
"861528647", "贵州省六盘水市",
"861874669", "黑龙江省哈尔滨市",
"86150138", "广东省深圳市",
"861829782", "安徽省池州市",
"86151720", "湖北省黄石市",
"861830374", "河南省许昌市",
"861534912", "陕西省榆林市",
"861776837", "江苏省常州市",
"861506048", "福建省泉州市",
"861874266", "新疆阿勒泰地区",
"861377929", "新疆和田地区",
"861308266", "山东省临沂市",
"861324570", "江苏省淮安市",
"861864934", "山西省晋中市",
"861813060", "安徽省芜湖市",
"861307494", "河南省信阳市",
"861362335", "河北省秦皇岛市",
"861340956", "宁夏石嘴山市",
"861892192", "江苏省扬州市",
"861891203", "江苏省徐州市",
"861321763", "广东省清远市",
"861708534", "山东省烟台市",
"861346393", "河北省邢台市",
"861879905", "新疆昌吉回族自治州",
"861512183", "宁夏吴忠市",
"861313520", "湖南省湘西土家族苗族自治州",
"861310378", "河南省开封市",
"861380238", "广东省东莞市",
"861529338", "甘肃省陇南市",
"861320115", "新疆巴音郭楞蒙古自治州",
"861804060", "湖北省襄樊市",
"861458766", "广东省云浮市",
"861370263", "广东省佛山市",
"861853657", "山西省阳泉市",
"861524016", "安徽省六安市",
"86134231", "广东省东莞市",
"861377285", "陕西省延安市",
"861593341", "河北省唐山市",
"861889747", "湖南省怀化市",
"86181714", "湖北省武汉市",
"861700149", "江苏省常州市",
"861769937", "新疆伊犁哈萨克自治州",
"861364409", "辽宁省大连市",
"861800785", "广西贵港市",
"861768052", "湖南省郴州市",
"861530140", "江苏省淮安市",
"861561556", "山东省潍坊市",
"86136276", "重庆市",
"86136134", "山西省太原市",
"861871979", "甘肃省兰州市",
"86145929", "重庆市",
"861536432", "湖南省益阳市",
"861334588", "浙江省温州市",
"861858182", "四川省达州市",
"861387295", "湖北省武汉市",
"861356224", "山东省枣庄市",
"861309112", "河北省邯郸市",
"861336334", "河北省衡水市",
"861510995", "新疆吐鲁番地区",
"861560674", "浙江省宁波市",
"861598334", "四川省眉山市",
"861855254", "江苏省镇江市",
"861508510", "贵州省遵义市",
"86151150", "湖南省岳阳市",
"861358149", "湖北省宜昌市",
"86158917", "陕西省西安市",
"861323284", "广东省清远市",
"861517777", "广西南宁市",
"861370073", "河南省新乡市",
"861890828", "四川省广安市",
"861589889", "山东省滨州市",
"861583433", "山西省晋城市",
"861308791", "广西南宁市",
"861317872", "广东省梅州市",
"861365791", "江西省南昌市",
"86187279", "湖北省随州市",
"861327883", "湖南省常德市",
"861320865", "吉林省辽源市",
"861325750", "广东省江门市",
"861554990", "湖北省咸宁市",
"861879443", "甘肃省白银市",
"861882052", "广东省肇庆市",
"861824815", "内蒙古包头市",
"861529864", "江苏省连云港市",
"861348299", "河北省秦皇岛市",
"86151556", "安徽省安庆市",
"86139327", "河北省沧州市",
"861889376", "甘肃省张掖市",
"861871530", "安徽省芜湖市",
"861390699", "福建省泉州市",
"861570560", "安徽省合肥市",
"861373395", "河南省漯河市",
"861361499", "辽宁省辽阳市",
"86135680", "四川省内江市",
"861357950", "新疆克拉玛依市",
"861598756", "云南省德宏傣族景颇族自治州",
"861331459", "黑龙江省大庆市",
"8613823", "广东省深圳市",
"861472783", "陕西省渭南市",
"861835726", "浙江省湖州市",
"861534506", "福建省漳州市",
"861818395", "云南省保山市",
"861327394", "河南省周口市",
"861322124", "浙江省湖州市",
"861863365", "河北省邯郸市",
"861321716", "湖北省荆州市",
"861366796", "江西省吉安市",
"861527760", "广西玉林市",
"861302174", "山东省济南市",
"861871469", "黑龙江省双鸭山市",
"861369675", "安徽省滁州市",
"861319994", "新疆昌吉回族自治州",
"861890934", "甘肃省庆阳市",
"861855423", "山东省泰安市",
"861561061", "山东省潍坊市",
"861454319", "黑龙江省黑河市",
"861321158", "广西来宾市",
"861840514", "江苏省苏州市",
"861509438", "江苏省无锡市",
"861502628", "新疆阿克苏地区",
"861336756", "广西百色市",
"861310428", "辽宁省阜新市",
"861788129", "新疆阿克苏地区",
"861520526", "江苏省泰州市",
"86189352", "山西省大同市",
"86151459", "黑龙江省大庆市",
"861500576", "浙江省台州市",
"861816114", "四川省广安市",
"861806770", "浙江省台州市",
"861862380", "河南省许昌市",
"861570439", "吉林省白山市",
"861884937", "河北省秦皇岛市",
"861818832", "四川省广安市",
"861510643", "山东省淄博市",
"86139306", "河北省廊坊市",
"861302443", "江苏省常州市",
"861869958", "新疆哈密地区",
"86150359", "山西省运城市",
"861830424", "辽宁省葫芦岛市",
"861529946", "新疆乌鲁木齐市",
"86177331", "海南省海口市",
"861558034", "湖南省衡阳市",
"86186744", "湖南省张家界市",
"861336761", "广西南宁市",
"861351403", "福建省漳州市",
"861781686", "浙江省杭州市",
"861311112", "山西省大同市",
"861885136", "江苏省宿迁市",
"861787658", "广东省河源市",
"861539465", "江苏省连云港市",
"861813952", "新疆伊犁哈萨克自治州",
"861589779", "湖北省黄石市",
"861475107", "江苏省南京市",
"861567088", "河南省焦作市",
"861834414", "广东省深圳市",
"861705552", "山东省青岛市",
"86182638", "山东省泰安市",
"861346827", "山东省东营市",
"86159976", "湖北省宜昌市",
"861378952", "内蒙古包头市",
"86186272", "湖北省荆州市",
"861330974", "青海省海南藏族自治州",
"861822943", "湖南省邵阳市",
"861814084", "新疆哈密地区",
"861884871", "云南省文山壮族苗族自治州",
"861882189", "湖南省岳阳市",
"861840356", "山西省晋城市",
"861894753", "内蒙古通辽市",
"861535329", "陕西省延安市",
"861453824", "四川省雅安市",
"861364334", "河北省张家口市",
"861314418", "广东省肇庆市",
"861773442", "河北省石家庄市",
"861555636", "安徽省阜阳市",
"861303418", "甘肃省平凉市",
"86135874", "浙江省温州市",
"861768320", "四川省达州市",
"861846993", "云南省文山壮族苗族自治州",
"861379305", "山东省聊城市",
"861569829", "山东省聊城市",
"861810978", "青海省西宁市",
"861334088", "四川省绵阳市",
"861846431", "山东省淄博市",
"861705320", "湖南省长沙市",
"861344064", "上海市",
"861556445", "山东省淄博市",
"861515683", "安徽省阜阳市",
"861505622", "安徽省合肥市",
"86151100", "北京市",
"861316777", "安徽省宿州市",
"861525672", "安徽省淮南市",
"861565010", "山东省威海市",
"86183323", "河北省石家庄市",
"861856074", "山东省淄博市",
"861526883", "浙江省杭州市",
"86185332", "河北省石家庄市",
"861319248", "广东省惠州市",
"86150950", "山东省聊城市",
"861388677", "湖北省恩施土家族苗族自治州",
"861817749", "广西贺州市",
"861572446", "辽宁省营口市",
"861591387", "广东省惠州市",
"86170074", "湖南省长沙市",
"861331706", "江西省吉安市",
"861598409", "四川省广元市",
"861315341", "山东省东营市",
"861390868", "湖北省鄂州市",
"861598761", "云南省大理白族自治州",
"861760973", "青海省黄南藏族自治州",
"861775413", "安徽省宿州市",
"861800875", "云南省保山市",
"861370573", "浙江省嘉兴市",
"861870454", "黑龙江省佳木斯市",
"861312469", "贵州省黔东南苗族侗族自治州",
"861454392", "贵州省遵义市",
"861806880", "江苏省南京市",
"861556950", "新疆吐鲁番地区",
"86131470", "广东省深圳市",
"861760463", "黑龙江省佳木斯市",
"861556631", "辽宁省抚顺市",
"861774606", "福建省南平市",
"861453938", "广东省湛江市",
"861894818", "广东省深圳市",
"861831895", "广东省中山市",
"86151506", "江苏省南京市",
"861590959", "宁夏中卫市",
"861351572", "浙江省湖州市",
"861450180", "山西省吕梁市",
"861882320", "广东省深圳市",
"861860700", "江西省南昌市",
"861801236", "江苏省无锡市",
"861570060", "四川省成都市",
"86145320", "浙江省杭州市",
"86170587", "上海市",
"86135293", "云南省昆明市",
"86176887", "广东省深圳市",
"861354650", "山西省长治市",
"861354493", "广东省珠海市",
"861562257", "广东省韶关市",
"861454835", "广东省东莞市",
"861390612", "江苏省常州市",
"861561561", "山东省济南市",
"861875756", "浙江省杭州市",
"861769871", "河南省焦作市",
"861840734", "湖南省衡阳市",
"861573809", "河南省南阳市",
"861363325", "河北省唐山市",
"861502940", "陕西省榆林市",
"861458533", "河南省濮阳市",
"861342442", "广东省深圳市",
"861822695", "安徽省池州市",
"861472873", "贵州省铜仁地区",
"861312530", "江西省上饶市",
"861316346", "黑龙江省鹤岗市",
"861334796", "江苏省淮安市",
"861810468", "黑龙江省鹤岗市",
"861326760", "广东省中山市",
"861887637", "福建省泉州市",
"86139356", "山西省晋城市",
"861470303", "河北省唐山市",
"86150309", "河北省邢台市",
"861539975", "湖南省邵阳市",
"861530362", "黑龙江省齐齐哈尔市",
"86151655", "山东省临沂市",
"861589901", "新疆巴音郭楞蒙古自治州",
"861326492", "湖北省恩施土家族苗族自治州",
"861572874", "广东省深圳市",
"86151527", "江苏省扬州市",
"861519654", "四川省巴中市",
"861301994", "辽宁省盘锦市",
"861896374", "安徽省池州市",
"861361412", "辽宁省鞍山市",
"86151409", "辽宁省辽阳市",
"861860531", "山东省济南市",
"861340488", "内蒙古赤峰市",
"861340321", "河北省石家庄市",
"86158533", "山东省淄博市",
"861458572", "山东省济宁市",
"86152267", "河北省沧州市",
"861838157", "四川省资阳市",
"861524182", "辽宁省沈阳市",
"86182391", "河南省焦作市",
"861590916", "陕西省汉中市",
"861599111", "陕西省延安市",
"861324496", "广东省东莞市",
"861595127", "江苏省镇江市",
"86189269", "广东省珠海市",
"861564963", "河南省新乡市",
"861805197", "江苏省南京市",
"861780555", "安徽省马鞍山市",
"861317558", "浙江省嘉兴市",
"86133611", "山东省威海市",
"861894691", "广东省汕尾市",
"861868197", "陕西省咸阳市",
"861337963", "贵州省黔东南苗族侗族自治州",
"861475553", "安徽省池州市",
"861330985", "辽宁省大连市",
"861815295", "新疆吐鲁番地区",
"861520390", "河南省焦作市",
"861375420", "浙江省湖州市",
"861867594", "广东省广州市",
"861521488", "新疆伊犁哈萨克自治州",
"861323565", "湖北省十堰市",
"861336792", "江西省九江市",
"861516058", "福建省宁德市",
"861867448", "湖南省长沙市",
"861833171", "河北省廊坊市",
"861306921", "吉林省长春市",
"861823025", "河北省唐山市",
"861303342", "山西省临汾市",
"861536897", "云南省保山市",
"861890370", "河南省商丘市",
"861893528", "山西省晋城市",
"86183999", "新疆昌吉回族自治州",
"861476273", "江苏省连云港市",
"861550023", "吉林省白山市",
"861876450", "山东省菏泽市",
"861343187", "广东省惠州市",
"861377564", "江苏省常州市",
"861598792", "云南省昭通市",
"861550954", "宁夏固原市",
"861800884", "云南省昆明市",
"86153187", "山东省青岛市",
"861846501", "宁夏银川市",
"861537719", "湖北省咸宁市",
"861803265", "河北省石家庄市",
"861868630", "吉林省吉林市",
"861814389", "西藏日喀则地区",
"861808722", "云南省昭通市",
"861337502", "福建省南平市",
"861364719", "湖北省荆州市",
"861802280", "广东省茂名市",
"861819906", "新疆阿勒泰地区",
"861364039", "广东省梅州市",
"861305313", "安徽省合肥市",
"861336539", "山东省临沂市",
"861450953", "江苏省连云港市",
"861351533", "山东省淄博市",
"861478429", "河南省周口市",
"861866704", "浙江省杭州市",
"861898923", "四川省凉山彝族自治州",
"861535024", "江西省九江市",
"861820603", "福建省莆田市",
"86159811", "吉林省吉林市",
"861776602", "江苏省泰州市",
"861576064", "四川省广安市",
"861863977", "河南省开封市",
"861777639", "广西玉林市",
"861390252", "广东省阳江市",
"861356808", "四川省宜宾市",
"861565993", "福建省福州市",
"861348763", "湖南省邵阳市",
"861859678", "福建省福州市",
"861454514", "湖南省岳阳市",
"86158702", "贵州省黔东南苗族侗族自治州",
"861876945", "山东省德州市",
"861778141", "四川省德阳市",
"861840319", "河北省邢台市",
"861570009", "浙江省杭州市",
"861860769", "广东省东莞市",
"86152710", "湖北省襄樊市",
"861327599", "福建省南平市",
"861863467", "山西省临汾市",
"861882788", "江西省赣州市",
"86134544", "浙江省杭州市",
"861454361", "山东省济南市",
"861760932", "甘肃省定西市",
"86150089", "海南省海口市",
"861458403", "河南省商丘市",
"861509008", "河南省新乡市",
"861561019", "山东省潍坊市",
"861596547", "山东省济宁市",
"86188606", "山东省东营市",
"861477070", "江西省南昌市",
"861843405", "山西省临汾市",
"86145236", "重庆市",
"86130124", "山东省青岛市",
"861370532", "山东省青岛市",
"861598970", "广东省汕头市",
"861359955", "福建省莆田市",
"861312400", "福建省福州市",
"861772187", "四川省成都市",
"86138652", "安徽省合肥市",
"861380789", "广西北海市",
"86182154", "甘肃省庆阳市",
"861566436", "河南省驻马店市",
"86188627", "江苏省南通市",
"861383487", "山西省临汾市",
"861530391", "河南省濮阳市",
"861338547", "山东省济宁市",
"861700302", "广东省深圳市",
"861774070", "西藏日喀则地区",
"861572885", "广东省肇庆市",
"86181633", "湖北省武汉市",
"861896385", "新疆巴音郭楞蒙古自治州",
"86156758", "湖南省长沙市",
"861539984", "湖南省永州市",
"8614772", "四川省成都市",
"86188555", "安徽省马鞍山市",
"861309798", "广西河池市",
"861336970", "青海省海北藏族自治州",
"861593190", "河北省唐山市",
"861560351", "山西省太原市",
"861769207", "河北省衡水市",
"861597626", "广东省韶关市",
"861818497", "西藏林芝地区",
"861561592", "山东省东营市",
"861534670", "甘肃省临夏回族自治州",
"861590323", "河北省保定市",
"861807696", "西藏那曲地区",
"861322907", "河北省邢台市",
"861370799", "江西省萍乡市",
"861531552", "山东省青岛市",
"861800393", "河南省濮阳市",
"861332581", "浙江省杭州市",
"861573860", "河南省周口市",
"861355932", "福建省南平市",
"861582895", "四川省遂宁市",
"86136012", "北京市",
"861337144", "山东省潍坊市",
"861775703", "浙江省宁波市",
"861885782", "浙江省丽水市",
"861560366", "黑龙江省哈尔滨市",
"861551969", "贵州省六盘水市",
"86187511", "江苏省苏州市",
"861322080", "山东省济宁市",
"861560685", "浙江省绍兴市",
"861367857", "贵州省毕节地区",
"861317058", "云南省昭通市",
"861537792", "福建省福州市",
"86136411", "北京市",
"861337897", "湖南省张家界市",
"861896930", "浙江省嘉兴市",
"861556347", "山东省济宁市",
"861317136", "内蒙古赤峰市",
"861598039", "福建省宁德市",
"861896651", "陕西省宝鸡市",
"861846510", "宁夏银川市",
"861331416", "辽宁省锦州市",
"861537460", "内蒙古呼伦贝尔市",
"861583503", "山西省晋中市",
"861589231", "四川省资阳市",
"861334752", "广西柳州市",
"861309586", "浙江省湖州市",
"861820724", "湖北省咸宁市",
"861866623", "广东省阳江市",
"861364460", "黑龙江省哈尔滨市",
"861800774", "广西梧州市",
"861334663", "河南省安阳市",
"861828882", "云南省迪庆藏族自治州",
"861329642", "山东省青岛市",
"86151143", "吉林省通化市",
"861806961", "浙江省绍兴市",
"861323065", "河北省廊坊市",
"861364792", "江西省九江市",
"86153711", "江苏省盐城市",
"861850939", "甘肃省陇南市",
"861818873", "广东省佛山市",
"861534857", "贵州省毕节地区",
"861476563", "湖北省武汉市",
"861365490", "辽宁省沈阳市",
"861365653", "浙江省温州市",
"861303708", "山西省吕梁市",
"861328849", "广东省广州市",
"861588908", "西藏拉萨市",
"861829689", "江西省赣州市",
"861308490", "广西百色市",
"861308653", "四川省阿坝藏族羌族自治州",
"861874490", "贵州省毕节地区",
"861559943", "贵州省黔南布依族苗族自治州",
"861550523", "江苏省苏州市",
"861332917", "安徽省宿州市",
"861335450", "黑龙江省哈尔滨市",
"861308762", "陕西省渭南市",
"861323275", "广东省河源市",
"861557808", "广西崇左市",
"861707530", "山东省济南市",
"86158823", "四川省成都市",
"861321759", "广东省湛江市",
"86151837", "四川省资阳市",
"861395621", "安徽省芜湖市",
"861450524", "吉林省白城市",
"861501214", "云南省西双版纳傣族自治州",
"861336719", "湖北省十堰市",
"861364539", "山东省临沂市",
"861336039", "广东省揭阳市",
"861535524", "浙江省衢州市",
"861458262", "安徽省马鞍山市",
"861454356", "山东省枣庄市",
"861778026", "四川省广安市",
"861327099", "江苏省苏州市",
"861361702", "江西省九江市",
"861373176", "河北省秦皇岛市",
"861850570", "浙江省衢州市",
"861853481", "山西省晋中市",
"861580458", "黑龙江省伊春市",
"861571522", "江苏省徐州市",
"861360729", "湖北省孝感市",
"86137019", "上海市",
"86158752", "广东省惠州市",
"861779749", "青海省海西蒙古族藏族自治州",
"861840835", "四川省甘孜藏族自治州",
"861863831", "河南省新乡市",
"861538626", "湖南省怀化市",
"86183390", "河南省许昌市",
"861381441", "江苏省徐州市",
"861370032", "河北省保定市",
"861889664", "江苏省常州市",
"86138018", "上海市",
"861572775", "江西省赣州市",
"86138602", "福建省龙岩市",
"861570817", "四川省南充市",
"861700748", "湖北省武汉市",
"861459163", "广西崇左市",
"861398144", "四川省内江市",
"861561519", "山东省日照市",
"861596047", "福建省宁德市",
"86188656", "山东省烟台市",
"861558339", "四川省德阳市",
"861317833", "福建省南平市",
"861571350", "山西省太原市",
"861554733", "内蒙古包头市",
"861875970", "福建省三明市",
"861831794", "江西省抚州市",
"861830613", "江苏省苏州市",
"861880308", "河北省衡水市",
"86188505", "福建省厦门市",
"861327512", "江苏省镇江市",
"861364970", "青海省海北藏族自治州",
"861351858", "贵州省六盘水市",
"861840392", "河南省鹤壁市",
"861806471", "浙江省台州市",
"861534436", "吉林省长春市",
"861338047", "广东省潮州市",
"861861754", "河北省唐山市",
"861860410", "辽宁省铁岭市",
"861314160", "湖南省湘西土家族苗族自治州",
"861585114", "江苏省盐城市",
"861518820", "河南省南阳市",
"861311798", "江西省景德镇市",
"861367436", "吉林省白城市",
"861536473", "山西省阳泉市",
"861332081", "四川省自贡市",
"861393131", "河北省张家口市",
"861550841", "四川省宜宾市",
"861389703", "青海省黄南藏族自治州",
"86136658", "浙江省金华市",
"861855614", "江苏省扬州市",
"861772343", "四川省广元市",
"861302185", "河北省邢台市",
"861315637", "山东省青岛市",
"861500611", "江苏省常州市",
"861318241", "江苏省无锡市",
"861312411", "辽宁省大连市",
"861805844", "浙江省杭州市",
"86186016", "上海市",
"861566670", "山东省淄博市",
"861813996", "甘肃省陇南市",
"861330330", "河北省邯郸市",
"861882878", "四川省泸州市",
"86188282", "四川省成都市",
"861535379", "陕西省宝鸡市",
"861819494", "新疆伊犁哈萨克自治州",
"861705204", "江苏省盐城市",
"861532941", "贵州省贵阳市",
"861590332", "河北省保定市",
"861768204", "安徽省合肥市",
"861705370", "陕西省西安市",
"861323418", "辽宁省阜新市",
"861376347", "黑龙江省齐齐哈尔市",
"861569879", "辽宁省葫芦岛市",
"861768370", "湖北省宜昌市",
"86156918", "陕西省西安市",
"861390434", "吉林省四平市",
"861452517", "山东省潍坊市",
"861859357", "福建省龙岩市",
"861890788", "广西河池市",
"861339498", "新疆阿克苏地区",
"861339544", "山东省德州市",
"86180638", "广东省珠海市",
"861361634", "山东省莱芜市",
"86353", "山西省阳泉市",
"86138561", "安徽省淮北市",
"861824952", "黑龙江省齐齐哈尔市",
"861327723", "湖北省宜昌市",
"86136794", "甘肃省兰州市",
"86186277", "湖北省武汉市",
"861454602", "青海省海东地区",
"861386268", "江苏省常州市",
"861802943", "广东省江门市",
"861369458", "黑龙江省伊春市",
"861760923", "陕西省渭南市",
"861477184", "湖北省黄石市",
"861761430", "吉林省长春市",
"86147454", "广东省广州市",
"861877085", "江西省宜春市",
"86157220", "天津市",
"861306108", "山东省聊城市",
"86152950", "江苏省常州市",
"861379943", "福建省福州市",
"861471714", "甘肃省天水市",
"861700661", "山东省青岛市",
"861370523", "江苏省淮安市",
"861477396", "湖南省常德市",
"861587193", "湖北省武汉市",
"861391245", "江苏省无锡市",
"861470450", "黑龙江省哈尔滨市",
"86134189", "广东省深圳市",
"861871135", "湖南省株洲市",
"861560703", "江西省上饶市",
"861800825", "四川省遂宁市",
"861577183", "陕西省渭南市",
"861356564", "新疆昌吉回族自治州",
"861572938", "河南省郑州市",
"861850396", "河南省驻马店市",
"861568181", "四川省甘孜藏族自治州",
"861826919", "广西河池市",
"861505672", "安徽省宿州市",
"861559407", "甘肃省张掖市",
"861324904", "广东省中山市",
"86185337", "河北省廊坊市",
"861570694", "云南省玉溪市",
"861856024", "山东省济南市",
"861887095", "江西省宜春市",
"861535085", "河北省邢台市",
"861831959", "广东省惠州市",
"861478587", "贵州省黔南布依族苗族自治州",
"86135966", "吉林省四平市",
"861825745", "浙江省金华市",
"861848512", "贵州省贵阳市",
"861379695", "黑龙江省黑河市",
"861351522", "江苏省南通市",
"861538731", "湖南省长沙市",
"86176882", "广东省佛山市",
"861363089", "河北省邢台市",
"861518328", "四川省内江市",
"861453446", "辽宁省葫芦岛市",
"86155019", "海南省海口市",
"86187068", "陕西省西安市",
"861470945", "甘肃省武威市",
"861565115", "江苏省泰州市",
"861478900", "西藏拉萨市",
"861300647", "四川省广元市",
"861518217", "四川省成都市",
"861520669", "山东省淄博市",
"861778611", "湖北省武汉市",
"861760316", "河北省廊坊市",
"861857945", "广西南宁市",
"861550712", "湖北省鄂州市",
"861507419", "湖南省郴州市",
"86189326", "河北省保定市",
"861374013", "北京市",
"861888845", "广西玉林市",
"861520266", "宁夏石嘴山市",
"861350817", "四川省自贡市",
"861815680", "安徽省六安市",
"861582916", "陕西省商洛市",
"861351350", "山西省忻州市",
"861374733", "内蒙古乌海市",
"861808733", "云南省丽江市",
"861830387", "河南省开封市",
"861539925", "陕西省咸阳市",
"861883069", "河北省石家庄市",
"861571858", "贵州省六盘水市",
"861319158", "内蒙古乌兰察布市",
"86152309", "河北省唐山市",
"861890096", "辽宁省大连市",
"861384856", "内蒙古赤峰市",
"861340371", "河南省郑州市",
"861319036", "辽宁省葫芦岛市",
"861594750", "内蒙古鄂尔多斯市",
"861306492", "江苏省淮安市",
"861366914", "陕西省榆林市",
"861375909", "云南省玉溪市",
"861530545", "山东省烟台市",
"861520076", "湖南省湘西土家族苗族自治州",
"86151522", "江苏省无锡市",
"861572824", "广东省深圳市",
"861869386", "甘肃省庆阳市",
"861511946", "广东省阳江市",
"861802164", "江苏省苏州市",
"861473689", "云南省怒江傈僳族自治州",
"861769821", "河南省新乡市",
"861363375", "河南省平顶山市",
"861522940", "陕西省咸阳市",
"861869194", "陕西省铜川市",
"86153973", "浙江省温州市",
"861783912", "河南省许昌市",
"861301536", "山西省长治市",
"861344690", "陕西省安康市",
"861587896", "广西钦州市",
"861355316", "山东省济南市",
"861452737", "湖南省益阳市",
"861818605", "湖北省武汉市",
"861393415", "山西省太原市",
"86138286", "广东省茂名市",
"861871929", "广东省阳江市",
"861356300", "山东省聊城市",
"861384861", "内蒙古呼和浩特市",
"86156694", "浙江省杭州市",
"861310968", "陕西省榆林市",
"86133303", "重庆市",
"86139218", "江苏省盐城市",
"861870902", "新疆哈密地区",
"861347772", "湖北省孝感市",
"861329112", "江苏省南通市",
"861869847", "内蒙古呼伦贝尔市",
"861587268", "湖北省十堰市",
"861770431", "吉林省长春市",
"861390309", "广东省潮州市",
"861770993", "新疆石河子市",
"861533486", "内蒙古兴安盟",
"861596972", "山东省临沂市",
"86132979", "湖北省武汉市",
"861362641", "山东省济南市",
"861330553", "安徽省芜湖市",
"86187564", "安徽省六安市",
"861592458", "内蒙古鄂尔多斯市",
"861830964", "宁夏固原市",
"861397203", "湖北省宜昌市",
"861820785", "广西玉林市",
"861588121", "四川省雅安市",
"861840988", "新疆昌吉回族自治州",
"861360593", "福建省龙岩市",
"86177704", "江西省抚州市",
"861339044", "辽宁省本溪市",
"861801494", "江苏省无锡市",
"861354827", "四川省达州市",
"861890878", "云南省楚雄彝族自治州",
"861830846", "四川省绵阳市",
"861346787", "湖南省益阳市",
"861338972", "青海省海东地区",
"861888667", "四川省广元市",
"861370954", "宁夏固原市",
"861471534", "广东省东莞市",
"86158912", "陕西省榆林市",
"86186288", "四川省资阳市",
"861328791", "山东省菏泽市",
"861870563", "安徽省宣城市",
"86152900", "河南省周口市",
"861760554", "安徽省淮南市",
"861317822", "福建省龙岩市",
"861314284", "江苏省南京市",
"861300865", "云南省昆明市",
"861864881", "广西南宁市",
"861855502", "安徽省蚌埠市",
"861450585", "辽宁省辽阳市",
"861816767", "新疆阿勒泰地区",
"861535585", "浙江省绍兴市",
"861571533", "山东省淄博市",
"861587078", "江西省抚州市",
"861569789", "江西省赣州市",
"861597987", "江西省新余市",
"861892308", "广东省江门市",
"861558167", "湖南省邵阳市",
"861576808", "广东省湛江市",
"861327604", "福建省福州市",
"861458947", "广东省中山市",
"861378404", "河北省邢台市",
"861883430", "山西省长治市",
"861361840", "湖南省岳阳市",
"861306419", "江西省九江市",
"861350009", "广东省东莞市",
"861700656", "山东省烟台市",
"861573368", "河北省廊坊市",
"861538511", "安徽省马鞍山市",
"861539139", "云南省普洱市",
"861813404", "河北省承德市",
"86181725", "广西玉林市",
"861583247", "河北省石家庄市",
"861342810", "广东省湛江市",
"861532854", "四川省广安市",
"861338462", "黑龙江省齐齐哈尔市",
"861378815", "广西玉林市",
"861884043", "陕西省渭南市",
"861804815", "四川省泸州市",
"861550532", "山东省青岛市",
"861538364", "山西省晋中市",
"861338790", "江西省新余市",
"861889326", "甘肃省天水市",
"86139322", "河北省保定市",
"86145498", "浙江省湖州市",
"861313452", "黑龙江省齐齐哈尔市",
"861855144", "江苏省连云港市",
"86178888", "北京市",
"861319536", "安徽省宣城市",
"861334914", "安徽省池州市",
"861500526", "江苏省泰州市",
"861866632", "广东省揭阳市",
"861520576", "浙江省台州市",
"861867609", "广东省潮州市",
"861830474", "内蒙古乌兰察布市",
"861322443", "吉林省延边朝鲜族自治州",
"86150148", "广东省东莞市",
"861776014", "四川省凉山彝族自治州",
"861509946", "新疆巴音郭楞蒙古自治州",
"861510859", "贵州省黔西南布依族苗族自治州",
"861776734", "浙江省宁波市",
"861304452", "福建省漳州市",
"86152359", "山西省运城市",
"861890596", "福建省漳州市",
"861369625", "四川省绵阳市",
"861362435", "吉林省通化市",
"861814918", "陕西省西安市",
"861301716", "湖南省衡阳市",
"861376886", "广西柳州市",
"861301036", "浙江省杭州市",
"861322174", "浙江省舟山市",
"861770645", "浙江省宁波市",
"86153951", "安徽省合肥市",
"861310478", "广东省东莞市",
"861550799", "江西省萍乡市",
"861301158", "河北省石家庄市",
"861346931", "湖南省湘潭市",
"861522628", "宁夏银川市",
"861880811", "四川省绵阳市",
"861803918", "河南省焦作市",
"861575932", "福建省宁德市",
"861396511", "安徽省合肥市",
"861529438", "甘肃省天水市",
"861571403", "辽宁省铁岭市",
"861800724", "湖北省咸宁市",
"861359812", "河南省安阳市",
"861329586", "浙江省台州市",
"861333161", "吉林省吉林市",
"861837973", "江西省上饶市",
"861866673", "广东省湛江市",
"861373823", "浙江省湖州市",
"861820774", "广西梧州市",
"861332743", "山西省太原市",
"861314065", "河南省周口市",
"861839382", "甘肃省庆阳市",
"861309642", "四川省乐山市",
"861303065", "安徽省亳州市",
"86185250", "辽宁省沈阳市",
"861341576", "广东省肇庆市",
"861818823", "贵州省黔西南布依族苗族自治州",
"861808882", "广东省珠海市",
"861377224", "陕西省安康市",
"861374882", "黑龙江省牡丹江市",
"861475974", "福建省福州市",
"861770730", "湖南省岳阳市",
"861590794", "江西省抚州市",
"861854501", "黑龙江省哈尔滨市",
"861390360", "黑龙江省哈尔滨市",
"86181761", "广西河池市",
"861302080", "河北省保定市",
"861351947", "甘肃省酒泉市",
"861700619", "江苏省苏州市",
"861384892", "内蒙古包头市",
"861560413", "辽宁省抚顺市",
"861895149", "江苏省连云港市",
"861539018", "四川省广元市",
"861530610", "江苏省镇江市",
"861890052", "安徽省蚌埠市",
"861519488", "河北省保定市",
"861873997", "河南省开封市",
"861705828", "浙江省杭州市",
"861579741", "湖北省襄樊市",
"861301759", "河南省许昌市",
"861536254", "广东省江门市",
"861868426", "吉林省四平市",
"861770501", "福建省福州市",
"861535574", "浙江省宁波市",
"86184594", "福建省莆田市",
"86421", "辽宁省朝阳市",
"861848773", "云南省玉溪市",
"861595496", "山东省烟台市",
"86133083", "重庆市",
"861363967", "河南省南阳市",
"861872642", "安徽省安庆市",
"861889090", "新疆塔城地区",
"861318151", "山东省烟台市",
"861809689", "新疆博尔塔拉蒙古自治州",
"861390004", "内蒙古呼和浩特市",
"861874849", "内蒙古呼和浩特市",
"861323708", "江西省南昌市",
"861308849", "内蒙古巴彦淖尔市",
"861328490", "黑龙江省大庆市",
"861328653", "广东省肇庆市",
"861882934", "陕西省西安市",
"861859455", "福建省莆田市",
"861510816", "四川省阿坝藏族羌族自治州",
"861812900", "新疆克拉玛依市",
"861880698", "云南省怒江傈僳族自治州",
"861821906", "广东省汕尾市",
"861339349", "山西省朔州市",
"861328762", "山东省泰安市",
"861303275", "湖北省荆门市",
"861550573", "浙江省嘉兴市",
"86138607", "福建省泉州市",
"861533845", "广东省云浮市",
"861572725", "湖北省黄冈市",
"861338933", "甘肃省兰州市",
"861380829", "四川省宜宾市",
"86137780", "四川省绵阳市",
"861598648", "广东省梅州市",
"861538676", "山西省晋城市",
"86130610", "山东省滨州市",
"861583422", "山西省吕梁市",
"861850352", "山西省晋中市",
"861368451", "黑龙江省哈尔滨市",
"861772905", "陕西省汉中市",
"861827212", "湖北省黄冈市",
"861324234", "广东省广州市",
"861556726", "吉林省松原市",
"861842027", "广东省茂名市",
"861850520", "江苏省常州市",
"861319406", "福建省泉州市",
"861597569", "广东省阳江市",
"861350060", "内蒙古呼伦贝尔市",
"86158757", "广东省佛山市",
"861360779", "广西北海市",
"861859940", "新疆昌吉回族自治州",
"86186628", "江苏省南通市",
"861363477", "内蒙古鄂尔多斯市",
"86181092", "陕西省西安市",
"861707929", "浙江省舟山市",
"861536423", "湖南省长沙市",
"861520611", "江苏省常州市",
"861333538", "陕西省西安市",
"861537920", "甘肃省平凉市",
"861778669", "湖北省十堰市",
"861566620", "山东省青岛市",
"861575463", "黑龙江省牡丹江市",
"861322185", "浙江省温州市",
"861347733", "湖北省随州市",
"861594976", "山东省潍坊市",
"861534948", "甘肃省陇南市",
"861897247", "湖北省十堰市",
"86181954", "宁夏固原市",
"861596933", "云南省楚雄彝族自治州",
"861399795", "湖北省武汉市",
"861813534", "山西省运城市",
"861867660", "广东省云浮市",
"861369803", "江西省上饶市",
"861810735", "湖南省郴州市",
"861538069", "江苏省连云港市",
"86180104", "北京市",
"861810015", "浙江省温州市",
"861806421", "湖北省荆州市",
"861597430", "湖南省湘西土家族苗族自治州",
"861768934", "福建省南平市",
"861500390", "河南省平顶山市",
"861312353", "广西桂林市",
"861550263", "辽宁省大连市",
"861770510", "江苏省盐城市",
"861300764", "河南省开封市",
"861814025", "四川省内江市",
"861575202", "云南省昆明市",
"861375470", "山东省临沂市",
"861760359", "山西省运城市",
"861452860", "青海省海北藏族自治州",
"861593095", "河北省唐山市",
"861323342", "山西省大同市",
"861318863", "辽宁省辽阳市",
"861329086", "福建省泉州市",
"861360910", "陕西省咸阳市",
"861890320", "河北省邯郸市",
"861893578", "新疆博尔塔拉蒙古自治州",
"861458350", "山东省东营市",
"861314565", "安徽省合肥市",
"861306971", "黑龙江省哈尔滨市",
"861582959", "陕西省延安市",
"861823075", "贵州省毕节地区",
"861524621", "黑龙江省绥化市",
"861890552", "安徽省蚌埠市",
"861878496", "四川省自贡市",
"861358692", "浙江省宁波市",
"861311642", "贵州省黔南布依族苗族自治州",
"861304496", "江西省吉安市",
"861535264", "新疆和田地区",
"861458522", "河南省焦作市",
"861576224", "山东省烟台市",
"861831323", "云南省西双版纳傣族自治州",
"86411", "辽宁省大连市",
"861844585", "黑龙江省哈尔滨市",
"861535074", "河北省张家口市",
"861478479", "内蒙古鄂尔多斯市",
"86189574", "浙江省宁波市",
"861800603", "福建省泉州市",
"861885822", "浙江省宁波市",
"861811286", "江苏省常州市",
"861528431", "河北省石家庄市",
"861863927", "河南省洛阳市",
"861811689", "新疆伊犁哈萨克自治州",
"861359899", "河南省许昌市",
"861857751", "广西贵港市",
"86153182", "山东省威海市",
"861816830", "江苏省扬州市",
"861363893", "西藏山南地区",
"861889590", "云南省保山市",
"861886804", "浙江省嘉兴市",
"861808772", "云南省普洱市",
"861823265", "河北省廊坊市",
"861390504", "福建省莆田市",
"861817891", "江西省南昌市",
"861319759", "广西北海市",
"861315595", "江西省萍乡市",
"861333853", "福建省南平市",
"861700692", "广东省广州市",
"861530601", "福建省龙岩市",
"861477175", "湖北省黄冈市",
"861479918", "新疆克拉玛依市",
"861474048", "辽宁省葫芦岛市",
"861808990", "西藏拉萨市",
"861514826", "内蒙古兴安盟",
"86152089", "海南省海口市",
"861776835", "江苏省常州市",
"861396569", "安徽省合肥市",
"861865990", "福建省泉州市",
"861766050", "山东省日照市",
"86138525", "江苏省扬州市",
"861880869", "湖北省荆门市",
"86138657", "安徽省六安市",
"861502283", "新疆博尔塔拉蒙古自治州",
"861523876", "河南省周口市",
"861301406", "安徽省阜阳市",
"86132124", "重庆市",
"861528645", "贵州省六盘水市",
"861898463", "贵州省黔南布依族苗族自治州",
"861350560", "安徽省合肥市",
"861505633", "安徽省宣城市",
"861879907", "新疆石河子市",
"861368976", "吉林省辽源市",
"861852438", "辽宁省丹东市",
"861325926", "陕西省汉中市",
"86183428", "辽宁省阜新市",
"861373041", "河北省邯郸市",
"861568633", "陕西省渭南市",
"861860842", "湖南省郴州市",
"861320117", "新疆阿克苏地区",
"861859628", "山东省烟台市",
"861571072", "广东省广州市",
"861362337", "河北省衡水市",
"861384980", "河南省三门峡市",
"86150710", "湖北省武汉市",
"861538430", "广东省阳江市",
"861576453", "黑龙江省牡丹江市",
"861318166", "山东省潍坊市",
"861534620", "河南省信阳市",
"861590373", "河南省新乡市",
"861537648", "山东省青岛市",
"861597676", "广东省汕尾市",
"861347513", "山东省威海市",
"86158726", "湖北省宜昌市",
"861333718", "内蒙古包头市",
"86181904", "四川省德阳市",
"861831916", "广东省茂名市",
"861820393", "河南省濮阳市",
"861597279", "湖北省黄冈市",
"86136017", "上海市",
"861302907", "吉林省白山市",
"861333156", "吉林省辽源市",
"861371587", "广东省汕头市",
"861571262", "浙江省嘉兴市",
"861360889", "云南省玉溪市",
"861538569", "安徽省蚌埠市",
"861774020", "四川省成都市",
"861562795", "广东省潮州市",
"86180154", "江苏省苏州市",
"861390142", "江苏省泰州市",
"861375960", "陕西省铜川市",
"861364648", "山东省青岛市",
"861708560", "安徽省六安市",
"861350439", "吉林省长春市",
"861509765", "河北省邯郸市",
"861336920", "陕西省宝鸡市",
"861329052", "河北省保定市",
"861476308", "山东省滨州市",
"861475643", "河北省张家口市",
"861873569", "山西省运城市",
"861376896", "广西玉林市",
"861347980", "江西省景德镇市",
"861818029", "四川省泸州市",
"861550789", "广西南宁市",
"861819746", "青海省玉树藏族自治州",
"861311370", "河北省廊坊市",
"86186062", "江苏省苏州市",
"861381230", "江苏省宿迁市",
"861322376", "河南省新乡市",
"861778179", "四川省雅安市",
"861303620", "江西省南昌市",
"861320806", "浙江省宁波市",
"861363732", "湖南省湘潭市",
"861777475", "广西玉林市",
"861831208", "广东省揭阳市",
"861323670", "辽宁省阜新市",
"861504718", "内蒙古锡林郭勒盟",
"86189142", "江苏省无锡市",
"861774847", "四川省达州市",
"861399774", "湖北省宜昌市",
"861816463", "云南省普洱市",
"861831725", "河南省焦作市",
"861848589", "贵州省六盘水市",
"861317648", "山东省青岛市",
"861890586", "浙江省台州市",
"86152358", "山西省吕梁市",
"861325035", "广东省佛山市",
"861318430", "浙江省宁波市",
"861348542", "山西省吕梁市",
"861567826", "广西柳州市",
"861477847", "广东省中山市",
"86185756", "广东省珠海市",
"861325715", "湖北省咸宁市",
"861388404", "甘肃省临夏回族自治州",
"861338780", "辽宁省辽阳市",
"861873430", "山西省阳泉市",
"86145499", "广东省深圳市",
"861352332", "河南省安阳市",
"861357915", "新疆伊犁哈萨克自治州",
"86156310", "河北省邯郸市",
"861363599", "江西省鹰潭市",
"861589955", "广东省佛山市",
"861800617", "江苏省无锡市",
"86155652", "河南省新乡市",
"861333559", "安徽省黄山市",
"861308043", "河北省张家口市",
"861453794", "新疆阿克苏地区",
"861450595", "辽宁省盘锦市",
"861887585", "浙江省丽水市",
"861880563", "安徽省宣城市",
"86150440", "吉林省长春市",
"861513853", "河南省濮阳市",
"861342999", "湖北省武汉市",
"861320103", "新疆昌吉回族自治州",
"861853922", "河南省鹤壁市",
"861380023", "重庆市",
"861569799", "江西省萍乡市",
"861517254", "湖北省武汉市",
"86151340", "辽宁省阜新市",
"861376578", "贵州省黔南布依族苗族自治州",
"861891215", "江苏省连云港市",
"861479609", "广西玉林市",
"861589440", "云南省德宏傣族景颇族自治州",
"861346797", "湖南省永州市",
"861862600", "江苏省徐州市",
"86186289", "四川省眉山市",
"861520888", "云南省丽江市",
"861832403", "新疆和田地区",
"86183836", "四川省甘孜藏族自治州",
"861394957", "河南省驻马店市",
"861581533", "广东省汕头市",
"861833149", "河北省衡水市",
"861315074", "云南省昆明市",
"861590775", "广西玉林市",
"861867025", "湖南省邵阳市",
"86137835", "河南省郑州市",
"861319518", "贵州省六盘水市",
"861880902", "新疆哈密地区",
"86155514", "安徽省阜阳市",
"861333671", "浙江省绍兴市",
"861563456", "山东省潍坊市",
"861816973", "广西贵港市",
"86137286", "广东省深圳市",
"861840998", "新疆喀什地区",
"861334123", "山东省青岛市",
"861820795", "江西省宜春市",
"861569532", "青海省海东地区",
"861597151", "湖北省黄石市",
"861367565", "安徽省合肥市",
"861360583", "浙江省嘉兴市",
"86134177", "广东省珠海市",
"861534565", "安徽省巢湖市",
"861301738", "湖南省长沙市",
"861567123", "湖北省黄石市",
"86182165", "贵州省六盘水市",
"861839514", "宁夏固原市",
"861301018", "河北省石家庄市",
"861347507", "山东省滨州市",
"861835268", "江苏省南通市",
"861780431", "吉林省长春市",
"861302913", "吉林省长春市",
"861592509", "云南省昭通市",
"86139732", "湖南省湘潭市",
"861780993", "新疆石河子市",
"861898830", "云南省临沧市",
"86183661", "山东省济南市",
"86186791", "江西省南昌市",
"86188564", "安徽省六安市",
"861532353", "广东省东莞市",
"861869396", "甘肃省酒泉市",
"861893631", "江苏省盐城市",
"86147027", "湖北省武汉市",
"861852459", "辽宁省营口市",
"861893950", "河南省郑州市",
"861832072", "广东省广州市",
"861779771", "河南省许昌市",
"861560407", "辽宁省营口市",
"861841435", "内蒙古赤峰市",
"861329552", "安徽省蚌埠市",
"861372252", "河北省唐山市",
"861802366", "广东省韶关市",
"861323436", "吉林省白城市",
"861815137", "江苏省宿迁市",
"861459704", "宁夏吴忠市",
"861822413", "四川省巴中市",
"861587886", "广西河池市",
"861516648", "山东省泰安市",
"861805235", "江苏省淮安市",
"861571417", "辽宁省营口市",
"86139146", "江苏省盐城市",
"861773912", "河南省安阳市",
"861317920", "吉林省松原市",
"861890086", "广东省佛山市",
"86152308", "河北省石家庄市",
"861338870", "云南省昭通市",
"861381479", "江苏省常州市",
"861321984", "四川省阿坝藏族羌族自治州",
"861331765", "广西玉林市",
"861896541", "福建省福州市",
"861306482", "江苏省宿迁市",
"861814660", "江西省九江市",
"861860357", "山西省临汾市",
"861871755", "陕西省安康市",
"86135752", "湖南省衡阳市",
"861829504", "宁夏固原市",
"861826890", "浙江省丽水市",
"861395156", "江苏省无锡市",
"86181580", "浙江省舟山市",
"86182660", "山东省枣庄市",
"861539406", "甘肃省天水市",
"861898644", "湖北省随州市",
"861325535", "山东省烟台市",
"861350458", "黑龙江省鹤岗市",
"861830397", "河南省焦作市",
"861870800", "西藏拉萨市",
"861327427", "辽宁省盘锦市",
"861365543", "山东省滨州市",
"861572916", "河南省南阳市",
"861333059", "云南省保山市",
"861308543", "湖南省永州市",
"861318676", "浙江省丽水市",
"861354615", "山西省长治市",
"861550879", "云南省普洱市",
"861707941", "河南省洛阳市",
"86155018", "海南省海口市",
"861313845", "广东省广州市",
"861528150", "四川省阿坝藏族羌族自治州",
"86155602", "河南省新乡市",
"861565055", "山东省济宁市",
"861380523", "江苏省淮安市",
"861813627", "江苏省泰州市",
"861519349", "甘肃省酒泉市",
"861850665", "广东省汕尾市",
"861508055", "福建省三明市",
"861866298", "江苏省淮安市",
"861575830", "云南省楚雄彝族自治州",
"861330816", "四川省雅安市",
"861895121", "江苏省常州市",
"861535095", "辽宁省铁岭市",
"86181186", "江苏省南通市",
"861534275", "湖北省武汉市",
"861389943", "新疆博尔塔拉蒙古自治州",
"861760338", "河北省秦皇岛市",
"86151083", "四川省成都市",
"861477194", "湖北省荆州市",
"861865153", "江苏省盐城市",
"861590885", "云南省昆明市",
"861877095", "江西省宜春市",
"86130982", "陕西省榆林市",
"861580694", "山东省临沂市",
"861775164", "江苏省泰州市",
"861344757", "山东省日照市",
"861836891", "甘肃省兰州市",
"861808153", "四川省达州市",
"861315574", "江西省景德镇市",
"86135823", "河北省石家庄市",
"861866851", "浙江省绍兴市",
"861533177", "云南省西双版纳傣族自治州",
"86134188", "广东省深圳市",
"861821327", "云南省丽江市",
"861593264", "河北省廊坊市",
"861775695", "安徽省宣城市",
"861551635", "河南省洛阳市",
"861339321", "河北省石家庄市",
"861335317", "吉林省松原市",
"861890798", "江西省景德镇市",
"861568957", "山东省临沂市",
"861339488", "内蒙古兴安盟",
"86180639", "广东省珠海市",
"861893445", "贵州省黔南布依族苗族自治州",
"861508240", "四川省达州市",
"861500205", "广东省深圳市",
"861569712", "湖北省孝感市",
"861369817", "四川省阿坝藏族羌族自治州",
"861328871", "河北省石家庄市",
"86159632", "山东省青岛市",
"861347335", "河北省石家庄市",
"861815224", "甘肃省平凉市",
"861520778", "广西河池市",
"86183374", "河南省许昌市",
"861319738", "湖北省孝感市",
"861874821", "内蒙古兴安盟",
"861308821", "四川省巴中市",
"861500728", "湖北省十堰市",
"861538997", "新疆克孜勒苏柯尔克孜自治州",
"86153915", "湖北省武汉市",
"86170023", "重庆市",
"861771542", "江苏省无锡市",
"861335705", "浙江省金华市",
"861819484", "新疆克孜勒苏柯尔克孜自治州",
"861808437", "贵州省毕节地区",
"86186461", "黑龙江省哈尔滨市",
"861779909", "新疆博尔塔拉蒙古自治州",
"861595667", "安徽省淮南市",
"861816202", "山东省德州市",
"861534065", "山西省太原市",
"861817636", "广西桂林市",
"861566565", "安徽省芜湖市",
"861361942", "云南省大理白族自治州",
"86189736", "湖南省常德市",
"861810333", "河北省秦皇岛市",
"861579729", "湖北省武汉市",
"861523663", "河南省新乡市",
"861323857", "贵州省毕节地区",
"86156919", "陕西省西安市",
"861355338", "广东省汕头市",
"861301518", "内蒙古赤峰市",
"86139540", "山东省菏泽市",
"861369509", "福建省南平市",
"861812802", "广东省东莞市",
"861301925", "吉林省吉林市",
"861381587", "江苏省南京市",
"861321975", "四川省眉山市",
"861813358", "河北省张家口市",
"861569073", "河南省濮阳市",
"86182344", "山西省晋中市",
"861581262", "广东省珠海市",
"861530478", "内蒙古巴彦淖尔市",
"861814206", "浙江省温州市",
"861397217", "湖北省武汉市",
"861804358", "吉林省长春市",
"861803609", "江苏省苏州市",
"86157726", "贵州省铜仁地区",
"861329788", "广西河池市",
"861555148", "安徽省宿州市",
"861392198", "江苏省苏州市",
"861807542", "安徽省黄山市",
"861330859", "贵州省黔西南布依族苗族自治州",
"861394340", "吉林省通化市",
"861333354", "山西省晋中市",
"861561249", "河北省承德市",
"861802674", "广东省揭阳市",
"861886303", "山东省潍坊市",
"861363394", "河南省周口市",
"861310045", "广西玉林市",
"861318000", "河北省衡水市",
"861561646", "湖南省长沙市",
"86187622", "江苏省徐州市",
"861810372", "河南省安阳市",
"861360899", "山东省临沂市",
"861819965", "新疆石河子市",
"861471627", "广东省佛山市",
"861513408", "辽宁省辽阳市",
"861553385", "河北省唐山市",
"861832291", "江西省宜春市",
"86183507", "福建省泉州市",
"861311828", "四川省南充市",
"86183429", "辽宁省葫芦岛市",
"861857131", "湖北省恩施土家族苗族自治州",
"861318364", "四川省眉山市",
"86186425", "辽宁省丹东市",
"861576680", "广东省汕头市",
"861518462", "黑龙江省鸡西市",
"861870869", "贵州省六盘水市",
"861374980", "河南省三门峡市",
"861569263", "西藏昌都地区",
"861560537", "山东省济宁市",
"8615523", "重庆市",
"861571839", "广东省云浮市",
"861586453", "山东省济南市",
"861319139", "内蒙古巴彦淖尔市",
"86152088", "云南省德宏傣族景颇族自治州",
"861831824", "广东省阳江市",
"861865980", "福建省泉州市",
"861310250", "河北省秦皇岛市",
"86157707", "江西省赣州市",
"861889907", "新疆乌鲁木齐市",
"861809868", "安徽省淮南市",
"86158680", "浙江省温州市",
"861323506", "福建省宁德市",
"861836862", "浙江省衢州市",
"86158336", "河北省邢台市",
"861529706", "青海省玉树藏族自治州",
"861588149", "四川省南充市",
"861369439", "吉林省四平市",
"86139553", "安徽省芜湖市",
"861453332", "浙江省杭州市",
"861817881", "广西柳州市",
"861362629", "江苏省南通市",
"861315585", "江西省吉安市",
"861857568", "广东省深圳市",
"86134591", "福建省福州市",
"861590874", "云南省曲靖市",
"861537822", "四川省绵阳市",
"861808819", "云南省德宏傣族景颇族自治州",
"861470568", "安徽省阜阳市",
"861568162", "四川省雅安市",
"861570675", "浙江省温州市",
"861372612", "广东省中山市",
"861858246", "四川省成都市",
"861852416", "辽宁省锦州市",
"86135917", "辽宁省大连市",
"861839319", "甘肃省庆阳市",
"861871941", "广东省广州市",
"861811699", "新疆石河子市",
"861858649", "贵州省黔东南苗族侗族自治州",
"861337727", "广西钦州市",
"861584877", "内蒙古通辽市",
"861369560", "安徽省合肥市",
"861887264", "湖北省孝感市",
"861519044", "江苏省扬州市",
"8615920", "广东省广州市",
"861893183", "河北省衡水市",
"861304486", "湖北省恩施土家族苗族自治州",
"861333736", "湖南省常德市",
"861572959", "宁夏银川市",
"861510553", "安徽省芜湖市",
"861302590", "广西南宁市",
"861831938", "广东省深圳市",
"861313486", "内蒙古鄂尔多斯市",
"861869020", "新疆哈密地区",
"86776", "广西百色市",
"861453895", "云南省曲靖市",
"861819475", "青海省玉树藏族自治州",
"861576757", "广东省广州市",
"861501498", "广东省河源市",
"861395119", "江苏省宿迁市",
"86151371", "河南省郑州市",
"861321465", "黑龙江省绥化市",
"86151303", "河北省保定市",
"861381900", "浙江省衢州市",
"861593085", "河北省唐山市",
"861530968", "安徽省阜阳市",
"861898767", "云南省昆明市",
"861311934", "甘肃省庆阳市",
"86150403", "辽宁省沈阳市",
"861843466", "山西省朔州市",
"861328207", "浙江省衢州市",
"861329096", "河南省郑州市",
"861862576", "河南省鹤壁市",
"861376852", "广西柳州市",
"86131901", "辽宁省大连市",
"861872828", "四川省资阳市",
"861801965", "江苏省南通市",
"861585463", "山东省日照市",
"861770150", "江苏省常州市",
"861399785", "湖北省随州市",
"861860455", "黑龙江省绥化市",
"86170090", "天津市",
"861817909", "江西省赣州市",
"861871854", "广东省茂名市",
"861829309", "甘肃省庆阳市",
"861569573", "浙江省嘉兴市",
"861331946", "江西省赣州市",
"861816932", "湖南省长沙市",
"861313744", "河南省周口市",
"861787548", "广东省广州市",
"86133522", "辽宁省大连市",
"861768642", "山东省济南市",
"861310545", "山东省烟台市",
"861824986", "黑龙江省鹤岗市",
"861843451", "山西省阳泉市",
"861539036", "四川省资阳市",
"861807042", "江西省九江市",
"861539158", "湖北省襄樊市",
"861853047", "河南省焦作市",
"861452503", "山东省济南市",
"861319925", "黑龙江省伊春市",
"861304744", "山东省东营市",
"86137626", "湖南省常德市",
"861359901", "福建省莆田市",
"861500935", "甘肃省金昌市",
"86135890", "山东省济南市",
"86183625", "江苏省苏州市",
"861811868", "江苏省盐城市",
"86137607", "广东省广州市",
"861373324", "河北省承德市",
"861571707", "江西省赣州市",
"86182121", "贵州省遵义市",
"861560305", "广东省广州市",
"86183557", "安徽省宿州市",
"861370829", "四川省宜宾市",
"861332447", "吉林省长春市",
"86138780", "广西玉林市",
"861386631", "安徽省淮南市",
"861361527", "江苏省镇江市",
"861360812", "四川省绵阳市",
"86157757", "四川省巴中市",
"861358238", "河北省保定市",
"86158293", "陕西省西安市",
"861459414", "云南省西双版纳傣族自治州",
"861338328", "河北省秦皇岛市",
"861584931", "内蒙古乌海市",
"861392263", "广东省肇庆市",
"861338481", "内蒙古赤峰市",
"861331864", "广东省江门市",
"861318731", "湖南省长沙市",
"861571315", "河北省唐山市",
"861812597", "广东省揭阳市",
"861581572", "广东省中山市",
"861506589", "山东省淄博市",
"861329878", "黑龙江省哈尔滨市",
"861318011", "河北省承德市",
"861347437", "陕西省西安市",
"861889080", "新疆伊犁哈萨克自治州",
"86139503", "福建省福州市",
"861518203", "四川省广安市",
"861315085", "内蒙古鄂尔多斯市",
"861328480", "内蒙古包头市",
"86139571", "浙江省杭州市",
"861864862", "内蒙古包头市",
"861335415", "辽宁省丹东市",
"861350803", "四川省泸州市",
"861893347", "广东省惠州市",
"861452472", "黑龙江省大庆市",
"861589741", "湖南省怀化市",
"861354540", "湖北省鄂州市",
"861881353", "广东省茂名市",
"861880688", "浙江省丽水市",
"861536727", "湖南省郴州市",
"861780501", "江苏省镇江市",
"861865007", "福建省福州市",
"861320557", "安徽省宿州市",
"861479660", "江西省景德镇市",
"861839835", "四川省攀枝花市",
"861870698", "甘肃省白银市",
"861352373", "河南省新乡市",
"861532929", "贵州省黔西南布依族苗族自治州",
"861879090", "河南省漯河市",
"861847821", "湖南省娄底市",
"861569402", "四川省雅安市",
"861887574", "河北省邢台市",
"861318987", "广东省江门市",
"861302090", "浙江省温州市",
"8613690", "广东省佛山市",
"861384882", "内蒙古包头市",
"861377757", "浙江省杭州市",
"861708803", "四川省成都市",
"861869520", "宁夏石嘴山市",
"861780730", "湖南省岳阳市",
"861360668", "浙江省台州市",
"861309934", "甘肃省陇南市",
"86158185", "广东省深圳市",
"86152584", "浙江省温州市",
"861519544", "江苏省镇江市",
"861860940", "甘肃省兰州市",
"861519498", "河北省保定市",
"861868905", "西藏昌都地区",
"861359779", "湖北省恩施土家族苗族自治州",
"86170845", "黑龙江省大庆市",
"86130394", "新疆乌鲁木齐市",
"86158874", "云南省曲靖市",
"861810155", "江苏省苏州市",
"861372296", "河北省保定市",
"861801475", "江苏省无锡市",
"861857278", "湖北省孝感市",
"861329596", "福建省漳州市",
"861839392", "甘肃省定西市",
"861817771", "广西南宁市",
"861372699", "广东省清远市",
"861808892", "云南省玉溪市",
"861869352", "甘肃省武威市",
"861374892", "黑龙江省牡丹江市",
"861590784", "广西桂林市",
"86151353", "山西省临汾市",
"861523088", "河北省承德市",
"86131494", "河北省石家庄市",
"861450637", "黑龙江省绥化市",
"861510330", "河北省邯郸市",
"861812740", "广东省广州市",
"861317970", "江苏省徐州市",
"861836148", "江苏省连云港市",
"861309320", "湖北省荆门市",
"86153441", "内蒙古赤峰市",
"861532411", "河北省邯郸市",
"861538241", "浙江省宁波市",
"86150308", "河北省衡水市",
"861329370", "山西省长治市",
"861323948", "甘肃省张掖市",
"861326482", "湖北省黄冈市",
"86183733", "湖南省株洲市",
"861301984", "辽宁省营口市",
"861340544", "山东省德州市",
"86151408", "辽宁省鞍山市",
"861340498", "云南省大理白族自治州",
"861899764", "新疆喀什地区",
"861594715", "内蒙古通辽市",
"861311052", "福建省福州市",
"86185722", "湖北省襄樊市",
"861338820", "四川省达州市",
"861582874", "四川省内江市",
"86184570", "浙江省衢州市",
"861775037", "福建省龙岩市",
"861360741", "湖南省怀化市",
"861314436", "吉林省白城市",
"86147022", "天津市",
"86157533", "山东省淄博市",
"861818579", "贵州省黔西南布依族苗族自治州",
"861865243", "江苏省苏州市",
"861822685", "安徽省阜阳市",
"861894133", "辽宁省大连市",
"861309552", "安徽省蚌埠市",
"861334786", "江苏省连云港市",
"861555618", "安徽省蚌埠市",
"861811360", "四川省德阳市",
"861583517", "山西省吕梁市",
"86155626", "山东省济南市",
"861332562", "新疆乌鲁木齐市",
"861873626", "河南省洛阳市",
"861872552", "安徽省蚌埠市",
"861537833", "四川省眉山市",
"861450190", "山西省运城市",
"861887180", "湖北省恩施土家族苗族自治州",
"861379413", "广东省汕头市",
"861328543", "山东省滨州市",
"861327477", "内蒙古鄂尔多斯市",
"861859168", "陕西省延安市",
"861897860", "广西百色市",
"861565150", "江苏省无锡市",
"861880454", "黑龙江省佳木斯市",
"861351707", "江西省赣州市",
"861768199", "浙江省宁波市",
"861550829", "四川省雅安市",
"861318626", "陕西省咸阳市",
"86135757", "浙江省杭州市",
"861809504", "四川省自贡市",
"861806890", "江苏省泰州市",
"861454382", "贵州省遵义市",
"861778935", "甘肃省武威市",
"861515945", "福建省南平市",
"861894457", "黑龙江省大庆市",
"861557680", "湖南省益阳市",
"861351315", "河北省唐山市",
"86180660", "江苏省南京市",
"861877190", "湖北省鄂州市",
"8615800", "上海市",
"861332903", "安徽省芜湖市",
"861831885", "广东省揭阳市",
"861368535", "山东省烟台市",
"861355767", "广西玉林市",
"861818930", "甘肃省临夏回族自治州",
"86132982", "河南省许昌市",
"861372142", "河南省郑州市",
"861367225", "江西省九江市",
"861818651", "湖北省武汉市",
"861309189", "黑龙江省哈尔滨市",
"861857804", "广东省韶关市",
"86130987", "重庆市",
"861763530", "山西省阳泉市",
"861453916", "广东省惠州市",
"861570803", "西藏山南地区",
"861815064", "福建省福州市",
"861554007", "内蒙古呼伦贝尔市",
"861367708", "江西省南昌市",
"861470415", "辽宁省丹东市",
"861859531", "河南省驻马店市",
"861888904", "西藏林芝地区",
"861894836", "广东省揭阳市",
"861533127", "山东省济南市",
"861373930", "甘肃省临夏回族自治州",
"861534708", "湖北省宜昌市",
"861319367", "河南省南阳市",
"861512917", "陕西省宝鸡市",
"861886751", "浙江省杭州市",
"861801218", "江苏省宿迁市",
"861598558", "贵州省六盘水市",
"861528055", "福建省三明市",
"861813677", "江苏省苏州市",
"861572373", "广西桂林市",
"861804677", "江西省赣州市",
"861335068", "四川省自贡市",
"861869606", "湖北省黄冈市",
"861766640", "广东省东莞市",
"861314857", "广东省东莞市",
"861563921", "河南省鹤壁市",
"861882199", "湖南省永州市",
"861336558", "安徽省阜阳市",
"861771289", "江苏省南京市",
"86131711", "内蒙古呼伦贝尔市",
"861859700", "青海省海北藏族自治州",
"861395649", "安徽省安庆市",
"861389717", "青海省海西蒙古族藏族自治州",
"861514663", "黑龙江省哈尔滨市",
"861385721", "浙江省舟山市",
"861366444", "吉林省吉林市",
"861503663", "河南省新乡市",
"861771365", "四川省绵阳市",
"861777658", "广西河池市",
"861395246", "江苏省无锡市",
"861335278", "广东省惠州市",
"861846983", "云南省玉溪市",
"861760767", "广东省深圳市",
"861303857", "陕西省延安市",
"861334098", "四川省成都市",
"861514752", "内蒙古鄂尔多斯市",
"86185853", "贵州省遵义市",
"861528240", "四川省达州市",
"86186131", "广东省广州市",
"861537136", "江苏省宿迁市",
"861815300", "河南省商丘市",
"86182639", "山东省临沂市",
"861339371", "河南省郑州市",
"861317792", "江西省九江市",
"861552699", "吉林省松原市",
"861500778", "广西河池市",
"861520728", "湖北省十堰市",
"86187287", "四川省巴中市",
"86181965", "安徽省芜湖市",
"861815274", "湖南省衡阳市",
"861365871", "云南省昆明市",
"86159637", "山东省济宁市",
"861786988", "云南省西双版纳傣族自治州",
"86189147", "江苏省南京市",
"861300806", "山西省长治市",
"861340044", "河北省保定市",
"861524038", "江苏省宿迁市",
"861552868", "四川省资阳市",
"861890642", "山东省青岛市",
"861311552", "黑龙江省黑河市",
"861303670", "湖南省邵阳市",
"861862390", "河南省南阳市",
"86156641", "河南省郑州市",
"861558358", "四川省乐山市",
"861881469", "黑龙江省佳木斯市",
"861816316", "湖北省孝感市",
"86135726", "陕西省榆林市",
"86150358", "山西省吕梁市",
"861524156", "辽宁省丹东市",
"861881701", "湖南省岳阳市",
"861327384", "河南省商丘市",
"861308937", "吉林省白城市",
"86554", "安徽省淮南市",
"861580439", "吉林省白山市",
"861516970", "山东省济宁市",
"861366786", "广西桂林市",
"861365937", "甘肃省酒泉市",
"861332062", "四川省广安市",
"861322326", "河北省邢台市",
"861778129", "四川省南充市",
"86189590", "福建省龙岩市",
"861518547", "贵州省黔南布依族苗族自治州",
"861310391", "河南省焦作市",
"861517473", "内蒙古乌海市",
"861346615", "云南省大理白族自治州",
"861373079", "四川省达州市",
"861532400", "河北省邯郸市",
"861371740", "广东省东莞市",
"861881530", "山东省菏泽市",
"861361489", "内蒙古锡林郭勒盟",
"861820617", "江苏省无锡市",
"861359128", "辽宁省锦州市",
"861305307", "安徽省淮南市",
"861373269", "江苏省宿迁市",
"861394848", "内蒙古乌兰察布市",
"861334876", "湖南省永州市",
"861872052", "江西省宜春市",
"861889443", "甘肃省平凉市",
"861472793", "陕西省渭南市",
"861328043", "山东省临沂市",
"861858408", "四川省成都市",
"86155525", "山东省济南市",
"861554980", "湖北省鄂州市",
"861368715", "湖北省荆州市",
"861378850", "广西南宁市",
"861351839", "四川省广安市",
"861390286", "广东省珠海市",
"861335131", "黑龙江省哈尔滨市",
"861580560", "安徽省合肥市",
"861886766", "浙江省嘉兴市",
"861813850", "广东省佛山市",
"861390689", "浙江省金华市",
"861323294", "广东省江门市",
"861867265", "湖北省宜昌市",
"861452247", "浙江省丽水市",
"861554507", "黑龙江省大兴安岭地区",
"861526967", "山东省淄博市",
"861589899", "山东省日照市",
"861577028", "云南省保山市",
"861315024", "新疆巴音郭楞蒙古自治州",
"861874781", "内蒙古巴彦淖尔市",
"861850958", "宁夏银川市",
"861500888", "云南省玉溪市",
"861516539", "山东省临沂市",
"861315953", "吉林省长春市",
"861365781", "广西南宁市",
"86187278", "湖北省咸宁市",
"861317039", "湖南省邵阳市",
"861302747", "湖南省岳阳市",
"861471986", "新疆乌鲁木齐市",
"861566225", "吉林省延边朝鲜族自治州",
"861477958", "江西省宜春市",
"861335568", "安徽省亳州市",
"861345584", "山东省威海市",
"861815311", "贵州省贵阳市",
"861554819", "内蒙古鄂尔多斯市",
"861317719", "湖北省随州市",
"86147944", "吉林省吉林市",
"861350675", "浙江省绍兴市",
"861339214", "广东省广州市",
"861458281", "福建省宁德市",
"861502842", "河北省保定市",
"861311189", "四川省成都市",
"861380073", "湖南省岳阳市",
"861334444", "北京市",
"861876278", "江苏省扬州市",
"86180165", "福建省泉州市",
"861341935", "四川省雅安市",
"861321738", "湖南省娄底市",
"861567173", "湖北省黄冈市",
"86145928", "重庆市",
"861858192", "四川省自贡市",
"861334598", "浙江省宁波市",
"861811142", "四川省自贡市",
"861352959", "云南省曲靖市",
"861389537", "宁夏银川市",
"861879747", "湖南省湘西土家族苗族自治州",
"861380263", "广东省佛山市",
"861387285", "湖北省随州市",
"861529363", "甘肃省张掖市",
"861336058", "广东省广州市",
"861364558", "安徽省阜阳市",
"861322913", "广东省江门市",
"861534342", "山西省太原市",
"86159093", "重庆市",
"86139737", "湖南省益阳市",
"86151611", "江苏省常州市",
"861367342", "河南省周口市",
"86189196", "安徽省合肥市",
"861537558", "安徽省阜阳市",
"861814448", "广东省惠州市",
"861333621", "山东省菏泽市",
"861817420", "湖南省邵阳市",
"861573157", "四川省泸州市",
"86182435", "吉林省通化市",
"861590725", "湖北省黄冈市",
"86134172", "广东省清远市",
"861800795", "江西省宜春市",
"861588692", "新疆昌吉回族自治州",
"861881979", "广东省韶关市",
"861821484", "安徽省蚌埠市",
"861803448", "河北省衡水市",
"861816923", "湖南省邵阳市",
"861311788", "江西省赣州市",
"861378986", "山东省青岛市",
"861567132", "湖北省襄樊市",
"861781763", "广东省清远市",
"861317756", "江西省宜春市",
"861332091", "四川省乐山市",
"86136659", "福建省泉州市",
"86132151", "广东省东莞市",
"861575114", "江苏省泰州市",
"86136405", "重庆市",
"861310362", "河南省安阳市",
"861319975", "新疆克孜勒苏柯尔克孜自治州",
"861870308", "新疆石河子市",
"861327375", "河南省平顶山市",
"86187505", "福建省泉州市",
"861520935", "甘肃省金昌市",
"861331438", "吉林省延边朝鲜族自治州",
"861813986", "甘肃省平凉市",
"861348831", "陕西省西安市",
"861821965", "甘肃省武威市",
"861881400", "广东省湛江市",
"861351417", "辽宁省营口市",
"86153705", "江苏省宿迁市",
"861536346", "广东省惠州市",
"861560943", "甘肃省白银市",
"861388996", "广东省汕头市",
"861334132", "湖南省湘潭市",
"861569523", "江苏省泰州市",
"861840382", "黑龙江省双鸭山市",
"861810050", "安徽省合肥市",
"861811434", "江苏省宿迁市",
"86156709", "河南省焦作市",
"861340349", "山西省朔州市",
"861800147", "江苏省南通市",
"861338378", "河南省开封市",
"861899865", "广东省韶关市",
"86138019", "上海市",
"86157752", "四川省泸州市",
"861562825", "新疆伊犁哈萨克自治州",
"861372309", "河南省驻马店市",
"86184541", "山东省济南市",
"861889185", "陕西省安康市",
"861897017", "江西省鹰潭市",
"861526589", "山东省临沂市",
"861329828", "河南省三门峡市",
"861775407", "安徽省六安市",
"861315180", "江苏省宿迁市",
"861869939", "新疆伊犁哈萨克自治州",
"861570458", "黑龙江省伊春市",
"861879195", "陕西省渭南市",
"861580817", "四川省南充市",
"861771977", "陕西省渭南市",
"861479094", "安徽省六安市",
"861818374", "云南省曲靖市",
"861888234", "四川省南充市",
"86187656", "山东省潍坊市",
"861573472", "内蒙古包头市",
"861472651", "四川省乐山市",
"861361577", "浙江省温州市",
"861380032", "山西省忻州市",
"861818200", "湖南省岳阳市",
"861589083", "河南省驻马店市",
"861509459", "黑龙江省伊春市",
"86183552", "安徽省蚌埠市",
"86137018", "上海市",
"861373374", "河南省许昌市",
"86137602", "广东省深圳市",
"86159855", "贵州省黔东南苗族侗族自治州",
"861352323", "河南省新乡市",
"861300557", "广东省肇庆市",
"861556078", "内蒙古巴彦淖尔市",
"861569841", "山西省太原市",
"861332233", "辽宁省辽阳市",
"861355830", "广西防城港市",
"861573962", "新疆昌吉回族自治州",
"861586311", "山东省青岛市",
"861833619", "河南省驻马店市",
"861350684", "浙江省宁波市",
"861535341", "陕西省延安市",
"861558627", "湖北省武汉市",
"861532979", "贵州省黔西南布依族苗族自治州",
"861345575", "山东省枣庄市",
"861539248", "福建省福州市",
"861365480", "内蒙古兴安盟",
"861829699", "江西省赣州市",
"861888127", "四川省广元市",
"861308480", "陕西省安康市",
"861874480", "贵州省黔东南苗族侗族自治州",
"86158966", "河南省洛阳市",
"861336872", "云南省大理白族自治州",
"861868343", "四川省成都市",
"861586564", "山东省烟台市",
"861816359", "湖北省咸宁市",
"861772844", "广东省汕头市",
"861452422", "辽宁省鞍山市",
"86133100", "上海市",
"861335683", "山东省东营市",
"86954", "宁夏固原市",
"861821475", "安徽省合肥市",
"861471850", "广东省揭阳市",
"861514088", "辽宁省阜新市",
"86152453", "黑龙江省牡丹江市",
"861363723", "安徽省宣城市",
"861346040", "河南省郑州市",
"861564887", "内蒙古巴彦淖尔市",
"861470317", "河北省沧州市",
"861362566", "安徽省安庆市",
"861591495", "广东省汕尾市",
"86156175", "河南省郑州市",
"861534418", "内蒙古锡林郭勒盟",
"861760830", "四川省泸州市",
"861364782", "广西柳州市",
"861857705", "广西防城港市",
"861503088", "河北省沧州市",
"861367418", "辽宁省沈阳市",
"861858161", "四川省成都市",
"861317334", "山东省德州市",
"861560695", "福建省厦门市",
"861322090", "山东省威海市",
"861510974", "青海省海南藏族自治州",
"861814312", "吉林省吉林市",
"861554437", "河南省南阳市",
"861329934", "甘肃省嘉峪关市",
"861478740", "云南省曲靖市",
"861387274", "湖北省恩施土家族苗族自治州",
"861470705", "江西省宜春市",
"86150584", "浙江省宁波市",
"861337887", "云南省迪庆藏族自治州",
"861359729", "广西南宁市",
"86156884", "山东省济南市",
"861803312", "广东省江门市",
"861809434", "江苏省盐城市",
"861561582", "山东省东营市",
"86187555", "安徽省马鞍山市",
"861330643", "山东省淄博市",
"861361267", "广东省东莞市",
"861337346", "河北省廊坊市",
"861362551", "安徽省合肥市",
"861360440", "吉林省长春市",
"861370789", "广西北海市",
"861810322", "河北省保定市",
"861373487", "内蒙古鄂尔多斯市",
"861332591", "浙江省杭州市",
"86136609", "广东省肇庆市",
"861305405", "湖南省衡阳市",
"861588259", "四川省广安市",
"861582885", "四川省遂宁市",
"86132101", "山东省青岛市",
"861772951", "陕西省西安市",
"861380799", "江西省萍乡市",
"861530428", "辽宁省本溪市",
"861530381", "河南省郑州市",
"861810550", "安徽省滁州市",
"861383497", "山西省朔州市",
"861321925", "四川省广安市",
"861572895", "西藏昌都地区",
"86159020", "广东省广州市",
"861569954", "吉林省通化市",
"861301975", "黑龙江省佳木斯市",
"861858718", "云南省丽江市",
"86156759", "湖南省邵阳市",
"861309788", "广西梧州市",
"861812441", "广东省阳江市",
"861818211", "湖南省长沙市",
"861788526", "贵州省黔南布依族苗族自治州",
"861831874", "广东省肇庆市",
"861872788", "湖北省鄂州市",
"861829868", "甘肃省白银市",
"861522293", "安徽省芜湖市",
"861303506", "安徽省合肥市",
"861354145", "四川省广元市",
"861886945", "云南省红河哈尼族彝族自治州",
"861772197", "四川省泸州市",
"861580009", "广东省佛山市",
"861361077", "吉林省延边朝鲜族自治州",
"861870742", "湖南省永州市",
"861380532", "山东省青岛市",
"861577915", "江西省上饶市",
"86156670", "陕西省西安市",
"861311878", "云南省楚雄彝族自治州",
"86183502", "福建省厦门市",
"861881411", "广东省广州市",
"86137652", "贵州省遵义市",
"86159805", "福建省福州市",
"861345120", "湖北省荆门市",
"861327589", "安徽省合肥市",
"861524408", "山东省日照市",
"861882798", "江西省景德镇市",
"86187606", "福建省漳州市",
"861760644", "山东省济南市",
"861345075", "广东省佛山市",
"861886450", "河南省信阳市",
"8614733", "四川省成都市",
"861556578", "河南省南阳市",
"861832947", "陕西省宝鸡市",
"861508983", "广东省江门市",
"861565983", "福建省厦门市",
"861586064", "福建省漳州市",
"861373793", "广西南宁市",
"861343197", "广东省清远市",
"861357078", "广东省韶关市",
"861556193", "黑龙江省牡丹江市",
"86133150", "河北省邯郸市",
"861787639", "广东省云浮市",
"861800894", "西藏林芝地区",
"861700546", "山东省潍坊市",
"861362276", "广东省广州市",
"861388167", "四川省巴中市",
"861509706", "甘肃省平凉市",
"861472666", "四川省达州市",
"861885039", "福建省福州市",
"861590824", "四川省绵阳市",
"861362679", "浙江省金华市",
"861814399", "河南省许昌市",
"861364872", "云南省大理白族自治州",
"861818793", "云南省丽江市",
"861593329", "河北省沧州市",
"861362066", "山西省晋中市",
"861330995", "新疆吐鲁番地区",
"86186414", "辽宁省本溪市",
"86189523", "江苏省淮安市",
"861327152", "河南省洛阳市",
"861521498", "新疆喀什地区",
"861336782", "广西柳州市",
"86137514", "广东省东莞市",
"861770555", "安徽省马鞍山市",
"861521544", "山东省德州市",
"861773754", "河南省平顶山市",
"861585554", "安徽省阜阳市",
"861458315", "江西省宜春市",
"861514588", "黑龙江省双鸭山市",
"861346540", "山东省济南市",
"861317761", "江西省吉安市",
"86183998", "新疆哈密地区",
"861317409", "江苏省南京市",
"86152471", "内蒙古呼和浩特市",
"861860678", "浙江省丽水市",
"861358121", "湖北省恩施土家族苗族自治州",
"861310140", "福建省福州市",
"861318105", "山东省聊城市",
"861524192", "辽宁省本溪市",
"861768798", "江西省景德镇市",
"861324486", "广东省深圳市",
"86189268", "广东省东莞市",
"861859769", "福建省三明市",
"861322590", "福建省南平市",
"861379290", "山东省青岛市",
"861869070", "贵州省黔南布依族苗族自治州",
"861311596", "福建省漳州市",
"861358546", "江苏省徐州市",
"861894681", "青海省海东地区",
"861473004", "河北省邯郸市",
"86186820", "广东省深圳市",
"861810006", "上海市",
"86135765", "江西省宜春市",
"86180520", "江苏省南京市",
"861760407", "辽宁省营口市",
"861825446", "山东省枣庄市",
"861782824", "四川省成都市",
"861459053", "广东省深圳市",
"86184597", "福建省龙岩市",
"861881456", "黑龙江省黑河市",
"861882191", "湖南省衡阳市",
"861771281", "江苏省淮安市",
"861450498", "辽宁省锦州市",
"861563929", "河南省郑州市",
"861535498", "内蒙古鄂尔多斯市",
"86188419", "辽宁省辽阳市",
"861859460", "福建省漳州市",
"861453745", "湖南省怀化市",
"86135699", "河南省许昌市",
"861771417", "江苏省徐州市",
"86136518", "上海市",
"861552691", "吉林省辽源市",
"861314245", "内蒙古巴彦淖尔市",
"861884032", "陕西省榆林市",
"86155469", "广东省深圳市",
"861365879", "云南省普洱市",
"861815392", "甘肃省定西市",
"86187418", "辽宁省阜新市",
"861317700", "湖北省荆州市",
"861339379", "河南省平顶山市",
"861550543", "山东省滨州市",
"86185911", "陕西省延安市",
"861814362", "吉林省吉林市",
"861556218", "山东省临沂市",
"861859539", "河南省商丘市",
"861517090", "江西省新余市",
"861820744", "湖南省张家界市",
"861332773", "江苏省南京市",
"861818659", "湖北省武汉市",
"861309181", "黑龙江省牡丹江市",
"861319415", "辽宁省丹东市",
"861341546", "广东省佛山市",
"861300986", "黑龙江省哈尔滨市",
"861322432", "吉林省吉林市",
"861373256", "浙江省嘉兴市",
"86183009", "贵州省遵义市",
"861772916", "陕西省汉中市",
"86189588", "浙江省温州市",
"861389830", "辽宁省抚顺市",
"861314050", "河南省漯河市",
"861815835", "浙江省金华市",
"861575943", "福建省福州市",
"861362516", "江苏省淮安市",
"861390355", "山西省长治市",
"861826635", "山东省聊城市",
"861316590", "浙江省宁波市",
"861319804", "四川省资阳市",
"861886759", "浙江省金华市",
"861303050", "江西省景德镇市",
"861821915", "广东省揭阳市",
"861768191", "浙江省金华市",
"861777193", "湖北省十堰市",
"861551890", "河南省信阳市",
"861518840", "河南省漯河市",
"861550821", "四川省达州市",
"861860782", "广西来宾市",
"861847188", "湖北省孝感市",
"861770684", "浙江省金华市",
"861534978", "青海省海南藏族自治州",
"861594946", "内蒙古呼伦贝尔市",
"86155160", "河南省平顶山市",
"861399452", "山西省阳泉市",
"861358205", "河北省保定市",
"861350240", "广东省广州市",
"861861368", "山东省济宁市",
"861897277", "湖北省黄石市",
"861324257", "广东省潮州市",
"861396646", "安徽省淮南市",
"861510414", "辽宁省本溪市",
"861862748", "湖南省怀化市",
"861781713", "广东省汕尾市",
"861838567", "贵州省黔东南苗族侗族自治州",
"861310312", "河北省保定市",
"861317168", "河北省保定市",
"86180107", "安徽省芜湖市",
"861536124", "广东省揭阳市",
"861575695", "四川省攀枝花市",
"861500908", "新疆阿克苏地区",
"861580867", "云南省红河哈尼族彝族自治州",
"861768957", "西藏阿里地区",
"86138604", "福建省厦门市",
"861352966", "云南省红河哈尼族彝族自治州",
"861769712", "青海省海东地区",
"86187651", "山东省潍坊市",
"861813557", "山西省长治市",
"861380653", "浙江省温州市",
"861380490", "辽宁省沈阳市",
"861700728", "山东省临沂市",
"86180126", "江苏省苏州市",
"861350055", "安徽省安庆市",
"861538249", "浙江省金华市",
"861532419", "河北省张家口市",
"86131922", "广东省珠海市",
"861571542", "山东省青岛市",
"861376965", "云南省曲靖市",
"86150023", "重庆市",
"861899815", "广东省江门市",
"86158754", "广东省汕头市",
"86184546", "山东省东营市",
"861306854", "广东省阳江市",
"861471806", "广东省梅州市",
"861363447", "吉林省辽源市",
"861881837", "广东省潮州市",
"861370480", "黑龙江省哈尔滨市",
"861360749", "湖南省长沙市",
"861898943", "浙江省金华市",
"861535044", "江西省赣州市",
"86189577", "浙江省温州市",
"861850145", "江苏省常州市",
"861810506", "福建省泉州市",
"861472616", "四川省成都市",
"86152579", "浙江省金华市",
"86188615", "江苏省无锡市",
"86135495", "湖南省郴州市",
"861516700", "浙江省绍兴市",
"861352951", "云南省楚雄彝族自治州",
"861352630", "河南省商丘市",
"861459553", "青海省黄南藏族自治州",
"861518634", "贵州省六盘水市",
"861577475", "内蒙古通辽市",
"86155665", "辽宁省锦州市",
"86158889", "浙江省金华市",
"861391284", "江苏省镇江市",
"861332883", "福建省莆田市",
"861550043", "吉林省四平市",
"861509687", "云南省红河哈尼族彝族自治州",
"861333629", "山东省滨州市",
"861808742", "云南省昆明市",
"86155799", "江西省萍乡市",
"861877044", "江西省宜春市",
"861580645", "山东省烟台市",
"861559554", "宁夏固原市",
"861867428", "湖北省武汉市",
"861516531", "山东省济南市",
"861523474", "山西省运城市",
"861304383", "辽宁省铁岭市",
"861874789", "内蒙古乌海市",
"861308789", "贵州省遵义市",
"861829753", "安徽省芜湖市",
"861503424", "山西省大同市",
"861365789", "广西北海市",
"86183059", "福建省福州市",
"861375440", "河北省邯郸市",
"861893494", "广西河池市",
"861339585", "浙江省绍兴市",
"861337237", "浙江省台州市",
"861589891", "山东省济南市",
"861823045", "河北省秦皇岛市",
"861893548", "山西省朔州市",
"861313383", "江西省南昌市",
"861452855", "甘肃省兰州市",
"86131044", "吉林省长春市",
"861458289", "福建省莆田市",
"861589258", "四川省攀枝花市",
"861595147", "江苏省淮安市",
"861320358", "山西省吕梁市",
"861321683", "浙江省宁波市",
"861311181", "四川省甘孜藏族自治州",
"861579881", "云南省曲靖市",
"861301415", "甘肃省武威市",
"861896638", "浙江省宁波市",
"861504641", "黑龙江省七台河市",
"861512152", "贵州省毕节地区",
"861362736", "湖南省常德市",
"861303550", "贵州省遵义市",
"86155281", "四川省成都市",
"861815319", "贵州省黔西南布依族苗族自治州",
"861314550", "安徽省滁州市",
"86138512", "江苏省连云港市",
"861773247", "河北省沧州市",
"861458686", "湖南省湘潭市",
"861317031", "湖南省长沙市",
"861317711", "湖北省恩施土家族苗族自治州",
"86152476", "内蒙古赤峰市",
"861599516", "江苏省盐城市",
"861787776", "湖南省张家界市",
"861554811", "内蒙古包头市",
"861590343", "山西省太原市",
"86181907", "四川省成都市",
"861342247", "广东省汕头市",
"861362354", "山西省晋中市",
"861858768", "广西南宁市",
"861864955", "山西省长治市",
"861332394", "河南省周口市",
"861834995", "四川省自贡市",
"861597249", "湖北省咸宁市",
"861361328", "河北省石家庄市",
"861368864", "山东省济南市",
"861708555", "安徽省合肥市",
"861361481", "内蒙古呼和浩特市",
"861845101", "江苏省苏州市",
"861533785", "广西南宁市",
"861335139", "黑龙江省大庆市",
"861530584", "浙江省宁波市",
"861390681", "浙江省杭州市",
"86182152", "甘肃省定西市",
"861338527", "湖北省鄂州市",
"861351831", "四川省绵阳市",
"861364678", "浙江省丽水市",
"86159348", "陕西省西安市",
"861820486", "内蒙古赤峰市",
"861378057", "河北省沧州市",
"861596527", "山东省东营市",
"861881709", "湖南省常德市",
"861777268", "河北省沧州市",
"861898695", "湖北省武汉市",
"861881461", "黑龙江省大庆市",
"861350555", "安徽省滁州市",
"861523846", "河南省周口市",
"861857984", "广西玉林市",
"86132127", "湖北省武汉市",
"861507854", "广西柳州市",
"86133551", "山东省济宁市",
"861769532", "宁夏石嘴山市",
"86187673", "浙江省嘉兴市",
"861508625", "贵州省毕节地区",
"86130122", "天津市",
"861880722", "湖北省武汉市",
"86187601", "福建省龙岩市",
"861898164", "四川省雅安市",
"861806597", "福建省龙岩市",
"86158704", "重庆市",
"861897567", "湖南省娄底市",
"861767123", "湖北省黄石市",
"86138363", "黑龙江省牡丹江市",
"861778121", "四川省乐山市",
"861373071", "四川省绵阳市",
"861860872", "云南省大理白族自治州",
"861310399", "河南省焦作市",
"861368946", "甘肃省平凉市",
"861899339", "甘肃省白银市",
"861580993", "新疆石河子市",
"861571042", "陕西省榆林市",
"861580431", "吉林省长春市",
"861317293", "广东省清远市",
"86147457", "黑龙江省哈尔滨市",
"861512967", "陕西省渭南市",
"861315488", "内蒙古呼和浩特市",
"861572426", "浙江省宁波市",
"861850483", "内蒙古阿拉善盟",
"861398580", "贵州省黔东南苗族侗族自治州",
"861327917", "陕西省宝鸡市",
"86182869", "贵州省黔西南布依族苗族自治州",
"861361657", "浙江省宁波市",
"861335018", "四川省宜宾市",
"86138138", "江苏省南京市",
"861335738", "湖南省娄底市",
"86159867", "广东省深圳市",
"861355717", "广西钦州市",
"861885700", "浙江省衢州市",
"86151515", "江苏省苏州市",
"861860833", "四川省乐山市",
"861322002", "陕西省榆林市",
"861319705", "湖北省黄冈市",
"861390457", "黑龙江省大兴安岭地区",
"86137139", "广东省深圳市",
"861347308", "河北省邢台市",
"861505642", "安徽省六安市",
"861815014", "福建省漳州市",
"861459107", "广西柳州市",
"86185334", "河北省唐山市",
"861700935", "江苏省徐州市",
"861470465", "黑龙江省齐齐哈尔市",
"861869787", "青海省海西蒙古族藏族自治州",
"861453844", "四川省巴中市",
"861535349", "陕西省西安市",
"861317410", "江苏省苏州市",
"861773422", "河北省邯郸市",
"861322897", "西藏阿里地区",
"861532971", "贵州省遵义市",
"861571927", "陕西省宝鸡市",
"861819578", "青海省西宁市",
"861569849", "山西省临汾市",
"861316913", "广东省湛江市",
"86135872", "浙江省湖州市",
"861830786", "广西河池市",
"861399496", "山西省运城市",
"861346847", "山东省潍坊市",
"861599182", "陕西省榆林市",
"861565106", "江苏省宿迁市",
"861339574", "浙江省宁波市",
"861829691", "江西省萍乡市",
"86136797", "广东省佛山市",
"86156033", "河北省秦皇岛市",
"861321568", "安徽省阜阳市",
"861810436", "吉林省白城市",
"861557244", "湖北省恩施土家族苗族自治州",
"861819193", "陕西省渭南市",
"861526581", "山东省潍坊市",
"861869493", "江苏省苏州市",
"86183980", "四川省成都市",
"861869931", "新疆石河子市",
"861515406", "山东省枣庄市",
"861839453", "甘肃省兰州市",
"86136746", "黑龙江省哈尔滨市",
"861555668", "安徽省芜湖市",
"86137430", "吉林省长春市",
"861340341", "山西省太原市",
"86180830", "重庆市",
"861810857", "贵州省毕节地区",
"861583567", "山西省忻州市",
"861323333", "山西省晋城市",
"861533774", "江苏省南京市",
"861372301", "河南省南阳市",
"861332512", "山东省济南市",
"86186530", "山东省菏泽市",
"861530575", "浙江省绍兴市",
"86155621", "山东省威海市",
"861311633", "贵州省遵义市",
"861511976", "广东省清远市",
"861361780", "广西柳州市",
"861310094", "黑龙江省黑河市",
"861522970", "陕西省咸阳市",
"861325508", "福建省南平市",
"861363345", "山西省太原市",
"861532709", "湖北省孝感市",
"861334607", "浙江省丽水市",
"861472659", "四川省德阳市",
"861850797", "江西省赣州市",
"861594765", "内蒙古鄂尔多斯市",
"861508803", "广东省佛山市",
"861476507", "上海市",
"861886536", "山东省潍坊市",
"861348839", "陕西省汉中市",
"861580730", "湖南省岳阳市",
"861513505", "山西省运城市",
"861332099", "四川省成都市",
"861351365", "山西省临汾市",
"861453476", "黑龙江省双鸭山市",
"861510704", "江西省抚州市",
"861351686", "浙江省台州市",
"861871482", "安徽省合肥市",
"861470975", "青海省西宁市",
"861539303", "甘肃省临夏回族自治州",
"861589618", "江苏省淮安市",
"86150845", "黑龙江省齐齐哈尔市",
"8618817", "上海市",
"861528684", "河南省郑州市",
"861379463", "广东省佛山市",
"861398907", "西藏阿里地区",
"86187749", "湖南省长沙市",
"86186893", "广东省中山市",
"86180593", "福建省宁德市",
"861308188", "河北省秦皇岛市",
"861884573", "黑龙江省大兴安岭地区",
"861386548", "安徽省宣城市",
"861338942", "甘肃省定西市",
"861830876", "云南省文山壮族苗族自治州",
"861890848", "湖南省长沙市",
"861317401", "江苏省淮安市",
"861833600", "河南省郑州市",
"861317769", "江西省鹰潭市",
"861552662", "吉林省通化市",
"86186385", "河南省郑州市",
"86147407", "辽宁省营口市",
"861863403", "河北省唐山市",
"86147529", "江苏省盐城市",
"86183389", "河南省新乡市",
"861399177", "陕西省延安市",
"861301705", "贵州省黔西南布依族苗族自治州",
"861345428", "浙江省湖州市",
"861867215", "湖北省襄樊市",
"86182981", "安徽省阜阳市",
"861894689", "青海省海西蒙古族藏族自治州",
"861525086", "江苏省淮安市",
"861561997", "陕西省安康市",
"861358129", "湖北省黄石市",
"861512893", "河北省承德市",
"861322502", "福建省三明市",
"861300850", "陕西省铜川市",
"861379202", "山东省日照市",
"861301317", "安徽省安庆市",
"861452754", "湖南省衡阳市",
"861894286", "四川省宜宾市",
"86189191", "甘肃省兰州市",
"861533393", "河南省濮阳市",
"86151616", "江苏省无锡市",
"861360148", "江苏省无锡市",
"861337580", "浙江省舟山市",
"861846458", "山东省威海市",
"86139315", "河北省唐山市",
"861378806", "广西百色市",
"86156697", "浙江省温州市",
"861804806", "四川省达州市",
"86153767", "山东省青岛市",
"861356244", "山东省日照市",
"861869877", "辽宁省铁岭市",
"861591123", "云南省大理白族自治州",
"861478398", "河南省三门峡市",
"86181239", "广东省深圳市",
"86181712", "湖北省武汉市",
"861786453", "山东省临沂市",
"861760537", "山东省济宁市",
"861516410", "辽宁省铁岭市",
"861885031", "福建省厦门市",
"861889727", "青海省玉树藏族自治州",
"861593321", "河北省石家庄市",
"861559359", "甘肃省金昌市",
"861822554", "安徽省淮南市",
"86187567", "安徽省亳州市",
"861321068", "山东省潍坊市",
"861814391", "河南省焦作市",
"861362671", "浙江省杭州市",
"861471557", "广东省佛山市",
"861532456", "安徽省六安市",
"861564580", "黑龙江省鸡西市",
"861801578", "四川省甘孜藏族自治州",
"861339074", "江苏省盐城市",
"861787631", "广东省潮州市",
"861332732", "湖南省湘潭市",
"861860558", "安徽省阜阳市",
"861454295", "辽宁省本溪市",
"861520546", "山东省东营市",
"861580001", "广东省广州市",
"861332012", "江西省九江市",
"861322473", "内蒙古乌海市",
"861512196", "宁夏石嘴山市",
"861302423", "浙江省嘉兴市",
"861500682", "山东省莱芜市",
"861532837", "四川省自贡市",
"861304795", "江西省宜春市",
"861705162", "江苏省南京市",
"861770675", "浙江省绍兴市",
"861322144", "浙江省宁波市",
"861453197", "山西省晋城市",
"86158925", "四川省宜宾市",
"86156646", "陕西省西安市",
"861310594", "福建省龙岩市",
"86189663", "浙江省嘉兴市",
"861855443", "山东省济南市",
"861881419", "广东省汕头市",
"861325008", "广东省中山市",
"861313795", "河南省漯河市",
"861513005", "河北省石家庄市",
"8615799", "海南省海口市",
"861332599", "浙江省金华市",
"861361870", "云南省昭通市",
"861370781", "广西南宁市",
"861588251", "四川省遂宁市",
"861372310", "河南省信阳市",
"861580510", "江苏省盐城市",
"861521637", "山东省枣庄市",
"861886716", "浙江省金华市",
"861476007", "福建省宁德市",
"861831235", "广东省揭阳市",
"861362559", "安徽省六安市",
"861886036", "河南省郑州市",
"861452336", "河南省南阳市",
"86756", "广东省珠海市",
"861853412", "山西省长治市",
"861700380", "河南省洛阳市",
"861776757", "新疆伊犁哈萨克自治州",
"861820667", "广东省惠州市",
"861453630", "江苏省南京市",
"861879423", "甘肃省兰州市",
"861812449", "广东省惠州市",
"861530389", "河南省洛阳市",
"861380791", "江西省南昌市",
"861348707", "湖北省武汉市",
"861378103", "河南省三门峡市",
"861393406", "山西省晋城市",
"861476335", "山东省东营市",
"861839285", "陕西省西安市",
"861318056", "河北省邢台市",
"861399904", "新疆吐鲁番地区",
"86136025", "广东省深圳市",
"861597159", "湖北省荆州市",
"861837537", "安徽省安庆市",
"861880990", "新疆克拉玛依市",
"861505112", "江苏省镇江市",
"861333276", "广东省河源市",
"861529687", "广西河池市",
"86181598", "福建省龙岩市",
"861318138", "山东省德州市",
"86133029", "广东省深圳市",
"86153875", "湖南省长沙市",
"86574", "浙江省宁波市",
"861780439", "吉林省白山市",
"861814250", "四川省德阳市",
"86189572", "浙江省湖州市",
"861356382", "山东省泰安市",
"86159450", "黑龙江省哈尔滨市",
"86150579", "浙江省金华市",
"861870980", "安徽省宿州市",
"86134596", "福建省漳州市",
"861821852", "广东省韶关市",
"861598455", "四川省攀枝花市",
"861556484", "山东省泰安市",
"861301683", "江苏省镇江市",
"861569791", "江西省南昌市",
"86151376", "河南省信阳市",
"861514143", "辽宁省本溪市",
"86152264", "湖南省怀化市",
"861458542", "河南省驻马店市",
"861321415", "辽宁省丹东市",
"861524641", "黑龙江省七台河市",
"861323550", "湖北省随州市",
"86130500", "辽宁省鞍山市",
"861366495", "广东省阳江市",
"86139675", "浙江省绍兴市",
"861530918", "陕西省商洛市",
"861310609", "浙江省衢州市",
"861843416", "山西省吕梁市",
"861336455", "吉林省四平市",
"86150476", "内蒙古赤峰市",
"861898037", "四川省眉山市",
"861503143", "河北省张家口市",
"861831343", "云南省玉溪市",
"861899952", "新疆克拉玛依市",
"861342991", "湖北省黄冈市",
"861887214", "湖北省恩施土家族苗族自治州",
"861328789", "山东省淄博市",
"861814045", "四川省眉山市",
"861369510", "广东省揭阳市",
"861333066", "四川省宜宾市",
"861864899", "广西桂林市",
"861833141", "河北省承德市",
"861809753", "新疆石河子市",
"861523424", "山西省太原市",
"861862692", "吉林省长春市",
"861890340", "山西省太原市",
"861550937", "甘肃省酒泉市",
"861357377", "山东省济南市",
"861476243", "江苏省泰州市",
"861514474", "内蒙古乌兰察布市",
"861855580", "安徽省马鞍山市",
"861338577", "浙江省温州市",
"861452999", "内蒙古鄂尔多斯市",
"86183521", "江苏省连云港市",
"861836668", "山东省枣庄市",
"861774040", "河南省郑州市",
"861343794", "江西省抚州市",
"861306297", "江苏省泰州市",
"861700888", "广东省深圳市",
"861783981", "河南省三门峡市",
"86159159", "广东省广州市",
"861855907", "福建省南平市",
"861382457", "广东省梅州市",
"861364628", "江苏省南通市",
"861336940", "甘肃省武威市",
"861773433", "河北省邯郸市",
"861333551", "安徽省合肥市",
"861581212", "云南省昆明市",
"861537628", "山东省滨州市",
"861325864", "黑龙江省大庆市",
"861361378", "河南省开封市",
"86157721", "贵州省遵义市",
"861860822", "四川省眉山市",
"861859648", "福建省泉州市",
"861550781", "广西南宁市",
"861778171", "四川省遂宁市",
"861774255", "湖南省郴州市",
"861873561", "山西省晋城市",
"861359960", "福建省龙岩市",
"861809818", "广东省佛山市",
"86134547", "浙江省宁波市",
"861709416", "广东省珠海市",
"861458104", "安徽省亳州市",
"861816703", "浙江省金华市",
"861305438", "黑龙江省鹤岗市",
"861824057", "河南省南阳市",
"861596577", "山东省济南市",
"861848581", "贵州省毕节地区",
"861368438", "四川省凉山彝族自治州",
"861318314", "河南省驻马店市",
"861589148", "陕西省西安市",
"861590905", "新疆昌吉回族自治州",
"861858337", "四川省成都市",
"861880772", "广西柳州市",
"861518412", "辽宁省铁岭市",
"861861517", "山东省济南市",
"86132122", "天津市",
"861534834", "湖南省衡阳市",
"861479610", "广西玉林市",
"861845015", "福建省莆田市",
"861328879", "河北省邯郸市",
"861825938", "福建省宁德市",
"861780270", "湖北省武汉市",
"86132818", "四川省成都市",
"861503387", "河北省邯郸市",
"861308829", "四川省自贡市",
"861874829", "内蒙古赤峰市",
"861350150", "广东省广州市",
"861470738", "湖南省娄底市",
"861339329", "河北省邢台市",
"861454680", "广东省广州市",
"861470018", "江苏省徐州市",
"861323245", "广东省清远市",
"861579721", "湖北省孝感市",
"861782874", "四川省成都市",
"86177533", "山东省淄博市",
"86151834", "四川省凉山彝族自治州",
"861369501", "福建省厦门市",
"861528458", "云南省保山市",
"86182520", "江苏省南京市",
"861513169", "河北省承德市",
"86139576", "浙江省台州市",
"861367834", "四川省凉山彝族自治州",
"861779901", "新疆塔城地区",
"86184592", "福建省厦门市",
"86134769", "湖北省咸宁市",
"861848917", "西藏阿里地区",
"861895129", "江苏省宿迁市",
"861364455", "黑龙江省绥化市",
"86139479", "内蒙古锡林郭勒盟",
"861351927", "宁夏吴忠市",
"861898537", "贵州省六盘水市",
"861332723", "湖南省湘西土家族苗族自治州",
"861515248", "江苏省泰州市",
"861780060", "内蒙古阿拉善盟",
"861360618", "江苏省无锡市",
"86159775", "广西玉林市",
"861800744", "湖南省张家界市",
"861537455", "湖北省黄冈市",
"861320986", "山西省临汾市",
"861333566", "安徽省池州市",
"861309622", "四川省宜宾市",
"861319683", "江苏省连云港市",
"861836899", "甘肃省酒泉市",
"861823362", "河北省廊坊市",
"861510632", "山东省枣庄市",
"861818843", "四川省南充市",
"861369730", "湖北省荆州市",
"861322614", "广东省潮州市",
"861539766", "四川省乐山市",
"86130156", "福建省漳州市",
"861364940", "广西南宁市",
"861880882", "云南省昭通市",
"861338077", "广东省梅州市",
"861396582", "安徽省安庆市",
"861777528", "安徽省芜湖市",
"861393994", "河南省洛阳市",
"86137621", "湖南省湘西土家族苗族自治州",
"861536174", "广东省肇庆市",
"861864668", "黑龙江省大庆市",
"86180102", "北京市",
"861536443", "湖南省怀化市",
"861550871", "云南省昆明市",
"861551449", "河南省驻马店市",
"861518499", "云南省迪庆藏族自治州",
"861816624", "湖南省怀化市",
"86181094", "甘肃省兰州市",
"861707949", "河南省安阳市",
"861314155", "湖南省益阳市",
"861537940", "甘肃省甘南藏族自治州",
"861566640", "山东省济南市",
"861333051", "云南省昆明市",
"861882848", "四川省南充市",
"86138933", "甘肃省兰州市",
"861893236", "江苏省扬州市",
"86152023", "重庆市",
"861360862", "河南省安阳市",
"861576998", "云南省保山市",
"861459464", "陕西省延安市",
"861331814", "广东省梅州市",
"861373146", "河北省石家庄市",
"861398443", "贵州省安顺市",
"861850540", "山东省菏泽市",
"861842047", "广东省湛江市",
"861859920", "新疆克拉玛依市",
"861571365", "河南省驻马店市",
"861893639", "江苏省淮安市",
"861571686", "河北省沧州市",
"861335975", "黑龙江省齐齐哈尔市",
"861318061", "吉林省白城市",
"861779779", "河南省周口市",
"861331405", "辽宁省辽阳市",
"861520908", "新疆克孜勒苏柯尔克孜自治州",
"861896549", "福建省南平市",
"861598628", "广东省阳江市",
"861381471", "江苏省南通市",
"861870335", "河北省秦皇岛市",
"861533825", "广东省中山市",
"861572745", "湖南省衡阳市",
"861383344", "河北省廊坊市",
"861835658", "安徽省芜湖市",
"861581299", "广东省韶关市",
"861457007", "山东省烟台市",
"861700778", "广东省肇庆市",
"861538582", "安徽省阜阳市",
"861586988", "湖南省邵阳市",
"86182126", "贵州省毕节地区",
"861808698", "四川省广安市",
"861338267", "江苏省徐州市",
"861336357", "山西省临汾市",
"86151028", "四川省成都市",
"86138798", "江西省景德镇市",
"861505086", "江苏省镇江市",
"86188375", "河南省平顶山市",
"861320850", "贵州省安顺市",
"861585290", "江苏省南京市",
"86183831", "四川省宜宾市",
"861579420", "江苏省南通市",
"861366397", "河南省信阳市",
"861572951", "宁夏银川市",
"861782885", "四川省达州市",
"861572630", "山东省威海市",
"861371982", "广东省云浮市",
"861879963", "新疆博尔塔拉蒙古自治州",
"861502719", "湖北省恩施土家族苗族自治州",
"861301278", "山东省聊城市",
"861357475", "湖南省岳阳市",
"86137665", "黑龙江省齐齐哈尔市",
"861880513", "江苏省连云港市",
"861354847", "四川省广元市",
"861772895", "广东省韶关市",
"861517747", "广西南宁市",
"861317842", "广东省韶关市",
"861395111", "江苏省苏州市",
"861304617", "广东省韶关市",
"861878617", "贵州省遵义市",
"86137799", "福建省厦门市",
"861321705", "江西省宜春市",
"861341908", "四川省达州市",
"861379554", "四川省眉山市",
"86147402", "辽宁省鞍山市",
"861322254", "湖南省邵阳市",
"861362621", "江苏省盐城市",
"861534515", "江苏省盐城市",
"861566015", "河南省南阳市",
"861817889", "广西河池市",
"861369993", "新疆阿勒泰地区",
"86187562", "安徽省铜陵市",
"861839564", "河北省石家庄市",
"861889777", "广西钦州市",
"861369431", "吉林省长春市",
"861593371", "河北省邢台市",
"86181717", "湖北省黄冈市",
"861301068", "广东省东莞市",
"861302963", "新疆喀什地区",
"861779593", "陕西省西安市",
"861339024", "辽宁省沈阳市",
"86183666", "山东省泰安市",
"861801528", "江苏省常州市",
"86186796", "江西省吉安市",
"861588141", "四川省泸州市",
"861391342", "江苏省镇江市",
"861339953", "安徽省芜湖市",
"861529466", "河南省安阳市",
"86177702", "江西省九江市",
"861879502", "宁夏石嘴山市",
"861839311", "甘肃省白银市",
"861319568", "安徽省亳州市",
"861871949", "广东省惠州市",
"861858641", "贵州省遵义市",
"861598357", "四川省攀枝花市",
"861819028", "四川省资阳市",
"861591173", "云南省昆明市",
"86137281", "广东省东莞市",
"861869827", "辽宁省辽阳市",
"86156692", "浙江省宁波市",
"861560644", "山东省济南市",
"861808811", "云南省西双版纳傣族自治州",
"861836083", "江苏省常州市",
"861324795", "江西省宜春市",
"861550207", "广东省中山市",
"861870861", "贵州省铜仁地区",
"861331535", "河北省秦皇岛市",
"861302144", "河北省沧州市",
"861816413", "湖北省孝感市",
"861368008", "广东省韶关市",
"861832299", "江西省抚州市",
"86130035", "江苏省南通市",
"861857139", "湖北省荆州市",
"861586602", "山东省泰安市",
"861806740", "浙江省宁波市",
"861500546", "山东省东营市",
"861587639", "广东省湛江市",
"861319131", "内蒙古呼伦贝尔市",
"861571831", "广东省茂名市",
"861509926", "新疆巴音郭楞蒙古自治州",
"861322423", "辽宁省沈阳市",
"861529976", "新疆哈密地区",
"861520682", "山东省临沂市",
"861587236", "湖北省武汉市",
"86186747", "湖南省衡阳市",
"861329633", "山东省日照市",
"861350983", "广东省东莞市",
"861812890", "广东省韶关市",
"861357965", "新疆哈密地区",
"861879473", "甘肃省酒泉市",
"861827417", "湖南省株洲市",
"861884023", "陕西省渭南市",
"861800667", "浙江省绍兴市",
"861815988", "福建省厦门市",
"861570555", "安徽省马鞍山市",
"861821896", "广东省惠州市",
"86187313", "河北省张家口市",
"861524337", "河北省承德市",
"861883082", "河北省衡水市",
"861889346", "甘肃省兰州市",
"86181260", "广东省深圳市",
"86147051", "江苏省南京市",
"86139324", "河北省承德市",
"861531848", "山东省菏泽市",
"861478608", "贵州省黔西南布依族苗族自治州",
"861360891", "山东省济宁市",
"86185751", "广东省东莞市",
"861325765", "广东省阳江市",
"861568798", "云南省普洱市",
"861335984", "黑龙江省哈尔滨市",
"861330851", "贵州省贵阳市",
"861318092", "吉林省延边朝鲜族自治州",
"861501637", "广东省肇庆市",
"861524005", "安徽省安庆市",
"861561241", "河北省廊坊市",
"861473662", "云南省大理白族自治州",
"861879144", "陕西省榆林市",
"861533603", "甘肃省平凉市",
"861583318", "河北省衡水市",
"86157765", "黑龙江省大庆市",
"861316747", "江苏省南通市",
"861334397", "河南省信阳市",
"861359771", "湖北省黄石市",
"861364357", "山西省临汾市",
"861879897", "西藏那曲地区",
"86138468", "黑龙江省鹤岗市",
"861593214", "河北省石家庄市",
"861319278", "广东省清远市",
"86157699", "云南省临沧市",
"86186569", "安徽省合肥市",
"861889887", "广东省肇庆市",
"861372691", "广东省湛江市",
"861379923", "福建省泉州市",
"861817779", "广西钦州市",
"861388647", "湖北省黄石市",
"86137469", "黑龙江省佳木斯市",
"861760943", "甘肃省白银市",
"861330866", "湖北省随州市",
"86147452", "广东省广州市",
"861353912", "广东省河源市",
"861808800", "云南省丽江市",
"861374800", "内蒙古包头市",
"861370543", "山东省滨州市",
"861880733", "湖南省株洲市",
"86181181", "江苏省苏州市",
"861779093", "辽宁省盘锦市",
"861554308", "吉林省松原市",
"86159443", "吉林省延边朝鲜族自治州",
"861376218", "湖南省张家界市",
"861780509", "江苏省淮安市",
"861589749", "湖南省永州市",
"86189731", "湖南省长沙市",
"861566515", "江苏省盐城市",
"861845834", "浙江省杭州市",
"861870856", "贵州省铜仁地区",
"861770458", "黑龙江省伊春市",
"861534735", "湖南省郴州市",
"861327743", "湖北省黄冈市",
"861301568", "福建省三明市",
"86136792", "陕西省西安市",
"861335367", "河南省新乡市",
"861819528", "宁夏石嘴山市",
"861571977", "青海省海西蒙古族藏族自治州",
"861847829", "湖南省邵阳市",
"861539450", "福建省南平市",
"861532921", "贵州省遵义市",
"86153492", "陕西省西安市",
"861773472", "河南省许昌市",
"861310660", "广东省湛江市",
"861569762", "广东省河源市",
"86135877", "浙江省温州市",
"861369867", "山东省青岛市",
"861879002", "河南省焦作市",
"861355943", "福建省福州市",
"861319068", "内蒙古乌海市",
"861569490", "河北省承德市",
"861368508", "福建省宁德市",
"861769841", "河南省南阳市",
"861571467", "黑龙江省大兴安岭地区",
"861305508", "湖南省岳阳市",
"861773962", "河南省信阳市",
"861386639", "安徽省芜湖市",
"86139141", "江苏省无锡市",
"861511926", "广东省河源市",
"861519190", "陕西省西安市",
"861502970", "陕西省安康市",
"861346958", "宁夏银川市",
"861370821", "四川省成都市",
"861778908", "西藏林芝地区",
"861347698", "湖北省荆州市",
"861853840", "河南省郑州市",
"861814610", "福建省宁德市",
"861363562", "安徽省铜陵市",
"861563287", "河北省衡水市",
"861331035", "内蒙古通辽市",
"861506581", "山东省泰安市",
"861318739", "湖南省邵阳市",
"861318019", "河北省唐山市",
"861355164", "四川省广元市",
"861802316", "广东省汕尾市",
"861530525", "江苏省扬州市",
"86182830", "四川省泸州市",
"861572844", "广东省东莞市",
"86177823", "重庆市",
"861331307", "河北省沧州市",
"8613911", "北京市",
"86974", "青海省海南藏族自治州",
"861338489", "内蒙古呼和浩特市",
"861870437", "吉林省辽源市",
"861320677", "黑龙江省双鸭山市",
"861572966", "四川省泸州市",
"861886994", "浙江省金华市",
"861512427", "辽宁省盘锦市",
"861300627", "江西省宜春市",
"861459330", "四川省宜宾市",
"861829301", "甘肃省临夏回族自治州",
"861354665", "山西省长治市",
"861558557", "吉林省延边朝鲜族自治州",
"861354386", "广东省珠海市",
"861888825", "山东省泰安市",
"861570055", "四川省广元市",
"861760695", "云南省德宏傣族景颇族自治州",
"861556965", "甘肃省定西市",
"861351542", "山东省青岛市",
"861479545", "广西北海市",
"86185773", "广西桂林市",
"861840757", "广东省佛山市",
"861551398", "山西省吕梁市",
"86176884", "广东省广州市",
"861550480", "内蒙古呼伦贝尔市",
"861568552", "贵州省遵义市",
"861375901", "云南省普洱市",
"861811457", "江苏省镇江市",
"861338348", "山西省运城市",
"86186290", "陕西省西安市",
"861581686", "广东省深圳市",
"861340379", "河南省洛阳市",
"861343874", "四川省乐山市",
"86183483", "河南省周口市",
"861350010", "广东省潮州市",
"861883061", "河北省廊坊市",
"861865688", "安徽省阜阳市",
"861309848", "湖北省孝感市",
"861586998", "湖南省永州市",
"861350730", "湖南省岳阳市",
"861808688", "四川省乐山市",
"861895390", "山东省聊城市",
"861597807", "广西百色市",
"861899850", "广东省汕尾市",
"861339637", "山东省枣庄市",
"861473681", "云南省楚雄彝族自治州",
"861361547", "山东省济宁市",
"861332427", "辽宁省盘锦市",
"861571696", "河北省廊坊市",
"861880335", "河北省秦皇岛市",
"861769829", "河南省濮阳市",
"861705622", "黑龙江省哈尔滨市",
"861870882", "云南省临沧市",
"861363081", "河北省石家庄市",
"861518489", "云南省楚雄彝族自治州",
"861811133", "四川省巴中市",
"86133524", "辽宁省沈阳市",
"861837413", "湖南省娄底市",
"861768622", "山东省德州市",
"861511307", "广东省汕头市",
"861787528", "广东省茂名市",
"861821950", "广东省茂名市",
"861888257", "四川省遂宁市",
"861304724", "湖南省衡阳市",
"861391436", "江苏省南通市",
"861810065", "江苏省无锡市",
"861538739", "湖南省邵阳市",
"861807022", "江西省九江市",
"861327345", "河北省邢台市",
"861324774", "江西省抚州市",
"861534333", "湖南省株洲市",
"861853027", "河南省商丘市",
"86896", "西藏那曲地区\、嘉黎县\、聂荣县\、申扎县\、双湖\、班戈县\、尼玛县",
"86170950", "江苏省苏州市",
"861560973", "青海省黄南藏族自治州",
"861595603", "安徽省六安市",
"861367333", "河南省安阳市",
"861804331", "吉林省延边朝鲜族自治州",
"861596348", "山东省临沂市",
"861847523", "广东省梅州市",
"861360636", "山东省潍坊市",
"861778619", "湖北省黄冈市",
"861520661", "山东省淄博市",
"861396592", "安徽省池州市",
"861506062", "福建省泉州市",
"861507411", "湖南省长沙市",
"86159713", "湖北省黄冈市",
"86181766", "广西玉林市",
"861502058", "山东省滨州市",
"861890633", "山东省日照市",
"861700669", "浙江省杭州市",
"861539068", "甘肃省张掖市",
"861560463", "黑龙江省牡丹江市",
"86158872", "云南省昆明市",
"861326353", "黑龙江省牡丹江市",
"861331313", "河北省张家口市",
"861700266", "广东省深圳市",
"86183617", "江苏省徐州市",
"86131492", "陕西省西安市",
"861319450", "黑龙江省哈尔滨市",
"861854304", "吉林省白城市",
"86151662", "山东省东营市",
"86134768", "湖北省武汉市",
"861510944", "甘肃省甘南藏族自治州",
"8617700", "北京市",
"86139478", "内蒙古巴彦淖尔市",
"861831630", "广东省云浮市",
"861869540", "宁夏固原市",
"861831951", "广东省河源市",
"861591752", "广东省肇庆市",
"861478770", "云南省文山壮族苗族自治州",
"861387244", "湖北省荆州市",
"861303015", "广东省湛江市",
"861860920", "陕西省咸阳市",
"861454137", "河北省沧州市",
"861568189", "四川省达州市",
"86150587", "浙江省温州市",
"861300534", "广东省汕头市",
"861303735", "湖南省郴州市",
"861390310", "河北省邯郸市",
"86152582", "浙江省宁波市",
"861559767", "青海省西宁市",
"861376906", "云南省保山市",
"861569871", "辽宁省营口市",
"861358266", "河北省廊坊市",
"861893218", "湖南省永州市",
"86155138", "山西省太原市",
"861770304", "广东省江门市",
"861816280", "湖北省襄樊市",
"861535371", "陕西省西安市",
"861510866", "云南省曲靖市",
"861329957", "宁夏中卫市",
"861532949", "贵州省黔西南布依族苗族自治州",
"861345545", "山东省菏泽市",
"861889432", "甘肃省兰州市",
"861539278", "湖北省襄樊市",
"86132819", "四川省南充市",
"86184350", "山西省忻州市",
"861868373", "四川省阿坝藏族羌族自治州",
"861357548", "浙江省杭州市",
"861536747", "湖南省衡阳市",
"861772874", "广东省云浮市",
"861454690", "广东省广州市",
"861454453", "江西省上饶市",
"86178533", "山东省淄博市",
"861363917", "贵州省六盘水市",
"861880507", "福建省厦门市",
"861350510", "江苏省盐城市",
"861831844", "广东省深圳市",
"861500149", "新疆喀什地区",
"861318758", "云南省临沧市",
"861510851", "贵州省贵阳市",
"861470536", "山东省潍坊市",
"861377988", "新疆喀什地区",
"861569937", "新疆伊犁哈萨克自治州",
"861867601", "广东省中山市",
"86186683", "浙江省嘉兴市",
"861354175", "四川省绵阳市",
"861304603", "山东省济南市",
"861318116", "山东省日照市",
"861346939", "湖南省永州市",
"861311848", "四川省宜宾市",
"861361047", "广东省中山市",
"861870772", "广西柳州市",
"861386658", "安徽省宿州市",
"861550791", "江西省南昌市",
"861396519", "安徽省芜湖市",
"861347902", "江西省上饶市",
"861458306", "江西省新余市",
"861880819", "四川省攀枝花市",
"861868794", "云南省普洱市",
"861832467", "黑龙江省牡丹江市",
"861327222", "湖南省张家界市",
"861760674", "浙江省宁波市",
"861479478", "内蒙古巴彦淖尔市",
"861810565", "安徽省合肥市",
"861530936", "甘肃省张掖市",
"861807522", "安徽省黄山市",
"861337376", "河南省新乡市",
"861397348", "湖南省永州市",
"861813764", "河南省驻马店市",
"861822644", "安徽省亳州市",
"861330673", "浙江省嘉兴市",
"861539131", "云南省红河哈尼族彝族自治州",
"861363581", "湖北省孝感市",
"861471647", "广东省深圳市",
"861360470", "内蒙古呼伦贝尔市",
"861509715", "甘肃省白银市",
"861350001", "广东省广州市",
"86139613", "江苏省连云港市",
"861306411", "江西省南昌市",
"861310025", "湖南省长沙市",
"86135925", "河南省郑州市",
"86182342", "山西省大同市",
"861590426", "辽宁省大连市",
"86158721", "湖北省荆州市",
"861347563", "山东省日照市",
"861343784", "广东省广州市",
"861509307", "河南省郑州市",
"861700898", "海南省海口市",
"861831966", "广东省梅州市",
"86181447", "广东省佛山市",
"861338702", "江西省九江市",
"86159158", "广东省广州市",
"86170900", "北京市",
"861555128", "安徽省淮南市",
"861564376", "吉林省辽源市",
"861800496", "辽宁省锦州市",
"861356835", "四川省达州市",
"861328799", "山东省烟台市",
"86186417", "辽宁省营口市",
"861324393", "辽宁省营口市",
"861864889", "广西柳州市",
"86180396", "河南省驻马店市",
"861862682", "浙江省温州市",
"86137517", "广东省广州市",
"861535214", "甘肃省武威市",
"861831476", "湖北省恩施土家族苗族自治州",
"861891448", "江苏省南京市",
"86181496", "福建省泉州市",
"861346570", "山东省潍坊市",
"861539568", "安徽省马鞍山市",
"861310170", "河南省商丘市",
"861303515", "湖北省孝感市",
"861569781", "江西省南昌市",
"861835906", "福建省三明市",
"861519953", "新疆阿勒泰地区",
"861859822", "广东省江门市",
"861770560", "安徽省合肥市",
"861860648", "山东省日照市",
"861366485", "内蒙古乌海市",
"86189365", "江苏省淮安市",
"861452810", "四川省成都市",
"861318813", "辽宁省锦州市",
"861808232", "江苏省淮安市",
"861360960", "广东省广州市",
"861869040", "陕西省宝鸡市",
"861328532", "山东省青岛市",
"861537842", "四川省巴中市",
"861871921", "广东省佛山市",
"861556548", "河南省南阳市",
"861337747", "广西百色市",
"861870990", "新疆克拉玛依市",
"861533617", "陕西省宝鸡市",
"861384869", "内蒙古兴安盟",
"861553638", "山西省晋中市",
"861839295", "陕西省西安市",
"861305416", "湖南省长沙市",
"861588129", "四川省攀枝花市",
"861368416", "四川省宜宾市",
"861846220", "山东省潍坊市",
"861362246", "广东省云浮市",
"861529697", "宁夏银川市",
"861700576", "浙江省台州市",
"861773737", "河南省焦作市",
"861854560", "黑龙江省齐齐哈尔市",
"861770439", "吉林省白山市",
"861390301", "广东省广州市",
"86181599", "福建省南平市",
"86157331", "河北省石家庄市",
"86133028", "广东省佛山市",
"861362649", "山东省滨州市",
"86182785", "广西玉林市",
"861518267", "四川省广安市",
"861324875", "浙江省温州市",
"861575703", "浙江省杭州市",
"861520619", "江苏省无锡市",
"861308523", "湖北省鄂州市",
"861878825", "云南省红河哈尼族彝族自治州",
"861304825", "广东省梅州市",
"861328573", "浙江省嘉兴市",
"861365523", "江苏省淮安市",
"861707921", "浙江省丽水市",
"861350867", "湖北省十堰市",
"86155604", "内蒙古赤峰市",
"861783503", "山西省忻州市",
"861775923", "福建省福州市",
"861550490", "辽宁省铁岭市",
"861550653", "山东省菏泽市",
"861354184", "四川省广元市",
"861475704", "浙江省嘉兴市",
"861880153", "江苏省无锡市",
"861806429", "湖北省武汉市",
"861379114", "山东省济南市",
"861508165", "河北省唐山市",
"861820904", "新疆哈密地区",
"861328198", "四川省宜宾市",
"861450654", "黑龙江省黑河市",
"861395551", "安徽省池州市",
"861454808", "广东省珠海市",
"861802114", "江苏省南京市",
"861788908", "西藏日喀则地区",
"861368459", "黑龙江省大庆市",
"861812770", "广东省茂名市",
"861317940", "江苏省苏州市",
"861340574", "江苏省南通市",
"861323978", "新疆伊犁哈萨克自治州",
"86150205", "山东省菏泽市",
"861591796", "广东省揭阳市",
"861355366", "广东省茂名市",
"861380821", "四川省成都市",
"861303928", "吉林省辽源市",
"861332325", "河北省唐山市",
"861533257", "陕西省延安市",
"861776564", "广东省佛山市",
"861320952", "宁夏石嘴山市",
"861306710", "福建省福州市",
"861834053", "辽宁省葫芦岛市",
"861866553", "广东省佛山市",
"861568878", "山东省滨州市",
"861306030", "陕西省渭南市",
"861519180", "陕西省咸阳市",
"861518077", "贵州省黔南布依族苗族自治州",
"861360771", "广西南宁市",
"861880437", "吉林省辽源市",
"861347688", "湖北省咸宁市",
"861865273", "江苏省镇江市",
"861337664", "广东省汕尾市",
"861366964", "广西梧州市",
"861597561", "广东省广州市",
"861319766", "广西贵港市",
"861330632", "山东省枣庄市",
"861396556", "安徽省阜阳市",
"861539683", "江苏省徐州市",
"861880856", "贵州省铜仁地区",
"861771522", "江苏省镇江市",
"861351306", "河北省唐山市",
"861317455", "福建省莆田市",
"86138566", "安徽省池州市",
"861366474", "内蒙古呼和浩特市",
"861770509", "福建省南平市",
"861301751", "河南省焦作市",
"861569480", "河北省秦皇岛市",
"861579749", "湖北省宜昌市",
"861779083", "辽宁省营口市",
"861514495", "内蒙古通辽市",
"861508220", "四川省乐山市",
"861893425", "广东省茂名市",
"861339341", "山西省太原市",
"861772775", "广东省广州市",
"861840690", "云南省德宏傣族景颇族自治州",
"861840453", "黑龙江省牡丹江市",
"861328402", "黑龙江省齐齐哈尔市",
"861592983", "陕西省榆林市",
"86184080", "上海市",
"861308841", "内蒙古赤峰市",
"861874841", "内蒙古乌兰察布市",
"861318159", "山东省菏泽市",
"861809681", "新疆昌吉回族自治州",
"861500748", "湖南省邵阳市",
"861802338", "广东省云浮市",
"861323468", "黑龙江省鹤岗市",
"861521585", "浙江省金华市",
"861771350", "四川省巴中市",
"86159634", "山东省潍坊市",
"86183372", "河南省安阳市",
"86187284", "四川省成都市",
"861815244", "宁夏固原市",
"861452567", "贵州省毕节地区",
"861571652", "河南省焦作市",
"861528060", "福建省漳州市",
"861379338", "山东省威海市",
"86180868", "四川省成都市",
"861854509", "黑龙江省佳木斯市",
"86137468", "黑龙江省佳木斯市",
"861571763", "河北省廊坊市",
"86158765", "广东省广州市",
"861457013", "山东省临沂市",
"86135961", "吉林省长春市",
"86185715", "湖北省武汉市",
"861594706", "内蒙古赤峰市",
"861384800", "内蒙古包头市",
"861334387", "河南省洛阳市",
"861870733", "湖南省株洲市",
"861392207", "广东省湛江市",
"861813647", "江苏省扬州市",
"861380543", "山东省滨州市",
"861538556", "安徽省安庆市",
"861700611", "江苏省南京市",
"861557014", "江西省南昌市",
"861804647", "福建省龙岩市",
"86138469", "黑龙江省双鸭山市",
"86157698", "云南省文山壮族苗族自治州",
"861505596", "安徽省六安市",
"861895141", "江苏省南通市",
"86188313", "河北省张家口市",
"861342860", "广东省东莞市",
"861374563", "北京市",
"861505788", "浙江省丽水市",
"861597271", "湖北省宜昌市",
"861338412", "辽宁省鞍山市",
"86170943", "吉林省长春市",
"861826230", "江苏省泰州市",
"86147996", "新疆巴音郭楞蒙古自治州",
"861568788", "云南省昆明市",
"861810284", "广东省广州市",
"861804865", "四川省乐山市",
"861776300", "湖北省武汉市",
"861335994", "黑龙江省黑河市",
"861378865", "广西玉林市",
"861813865", "广东省江门市",
"861538314", "河北省承德市",
"861874023", "辽宁省辽阳市",
"861850827", "四川省巴中市",
"861365954", "西藏拉萨市",
"861394878", "内蒙古巴彦淖尔市",
"861308023", "内蒙古兴安盟",
"861334846", "福建省漳州市",
"861559644", "陕西省西安市",
"861874954", "河南省商丘市",
"861308954", "黑龙江省七台河市",
"861580555", "安徽省马鞍山市",
"861350993", "广东省湛江市",
"861567846", "广西贵港市",
"861350431", "吉林省长春市",
"861477827", "广东省梅州市",
"861889144", "陕西省西安市",
"861821886", "广东省湛江市",
"861306701", "福建省三明市",
"861815998", "福建省泉州市",
"861526447", "山东省临沂市",
"861330288", "广东省江门市",
"861538561", "安徽省淮北市",
"861459643", "甘肃省陇南市",
"861808902", "西藏日喀则地区",
"861301766", "河南省郑州市",
"861536195", "广东省梅州市",
"86150255", "重庆市",
"861890672", "浙江省湖州市",
"861303640", "四川省自贡市",
"861536664", "江苏省淮安市",
"861317628", "山东省滨州市",
"861833380", "河北省衡水市",
"861803968", "河南省南阳市",
"861880861", "湖北省荆州市",
"861396561", "安徽省马鞍山市",
"861324785", "江西省九江市",
"861334964", "湖南省张家界市",
"861596412", "山东省济宁市",
"861475623", "河北省保定市",
"861866924", "云南省怒江傈僳族自治州",
"861898703", "云南省昭通市",
"861576602", "广东省肇庆市",
"861893658", "江苏省连云港市",
"861306530", "辽宁省阜新市",
"861373049", "河北省唐山市",
"861302346", "江苏省连云港市",
"861861472", "内蒙古包头市",
"861528439", "河北省邯郸市",
"86184343", "山西省太原市",
"861876248", "江苏省南通市",
"861504066", "辽宁省鞍山市",
"861359891", "河南省驻马店市",
"861811172", "四川省泸州市",
"861800452", "黑龙江省齐齐哈尔市",
"861811681", "新疆博尔塔拉蒙古自治州",
"861830914", "陕西省商洛市",
"861534372", "河南省安阳市",
"861879777", "湖南省常德市",
"861478471", "内蒙古呼和浩特市",
"86188562", "安徽省铜陵市",
"861368706", "江西省吉安市",
"86139734", "湖南省衡阳市",
"86138281", "广东省揭阳市",
"86155512", "安徽省芜湖市",
"861817899", "江西省赣州市",
"861319751", "广西南宁市",
"861367372", "河南省安阳市",
"861560932", "甘肃省定西市",
"861867045", "湖南省怀化市",
"86483", "内蒙古阿拉善盟",
"861530609", "福建省厦门市",
"861889502", "宁夏石嘴山市",
"861310918", "陕西省汉中市",
"861527135", "湖北省随州市",
"861572187", "云南省昆明市",
"86133376", "海南省海口市",
"861587218", "湖北省荆门市",
"86187375", "河南省平顶山市",
"861452277", "山西省临汾市",
"86158495", "内蒙古通辽市",
"861582951", "陕西省咸阳市",
"861306979", "黑龙江省牡丹江市",
"861816037", "新疆伊犁哈萨克自治州",
"861528560", "贵州省贵阳市",
"861300404", "安徽省芜湖市",
"861760351", "山西省太原市",
"861347232", "河北省保定市",
"861816305", "湖北省荆门市",
"86151029", "陕西省西安市",
"861538138", "浙江省宁波市",
"861569207", "广东省阳江市",
"861888617", "贵州省安顺市",
"86138799", "江西省萍乡市",
"861836231", "江苏省泰州市",
"861812919", "新疆博尔塔拉蒙古自治州",
"861350645", "山东省烟台市",
"861504276", "辽宁省盘锦市",
"861867250", "湖北省黄冈市",
"861322727", "湖北省宜昌市",
"861889963", "新疆克拉玛依市",
"86135889", "浙江省温州市",
"861870513", "江苏省连云港市",
"861366387", "河南省洛阳市",
"861585280", "江苏省无锡市",
"861583336", "河北省沧州市",
"861380043", "吉林省长春市",
"861782895", "四川省攀枝花市",
"861371992", "广东省汕头市",
"861313884", "广东省东莞市",
"861470994", "新疆昌吉回族自治州",
"861454311", "黑龙江省七台河市",
"861561069", "山东省泰安市",
"86188673", "湖南省长沙市",
"86137654", "贵州省黔南布依族苗族自治州",
"861870722", "湖北省武汉市",
"86188601", "福建省福州市",
"861310389", "河南省焦作市",
"86145231", "河南省郑州市",
"861551770", "河南省南阳市",
"861333337", "河北省石家庄市",
"861389932", "新疆吐鲁番地区",
"861760624", "山东省威海市",
"861345140", "河北省衡水市",
"861871461", "黑龙江省哈尔滨市",
"861317283", "广东省揭阳市",
"861301303", "安徽省合肥市",
"861475288", "江苏省常州市",
"861570993", "新疆石河子市",
"861454564", "四川省绵阳市",
"861570431", "吉林省长春市",
"861300167", "山东省青岛市",
"86181863", "湖北省黄冈市",
"861898685", "湖北省恩施土家族苗族自治州",
"861886925", "云南省文山壮族苗族自治州",
"86157704", "云南省丽江市",
"861857994", "广西柳州市",
"861788121", "新疆克孜勒苏柯尔克孜自治州",
"86185955", "河南省郑州市",
"86137363", "浙江省温州市",
"861863417", "河北省唐山市",
"861333005", "江西省南昌市",
"861533795", "陕西省宝鸡市",
"861554902", "湖北省荆州市",
"861530594", "福建省莆田市",
"861390691", "福建省福州市",
"861569043", "河北省保定市",
"86182347", "山西省临汾市",
"861590476", "内蒙古赤峰市",
"861321945", "四川省眉山市",
"861529307", "甘肃省张掖市",
"861852405", "辽宁省朝阳市",
"861555178", "安徽省马鞍山市",
"861820496", "内蒙古通辽市",
"861517907", "江西省赣州市",
"861348291", "河北省沧州市",
"861573810", "河南省商丘市",
"861560554", "安徽省淮南市",
"861337326", "河北省廊坊市",
"861362038", "广东省中山市",
"861348858", "内蒙古通辽市",
"861807572", "湖南省岳阳市",
"861331451", "黑龙江省哈尔滨市",
"861362718", "湖北省黄冈市",
"861771533", "江苏省常州市",
"861555593", "安徽省宿州市",
"861896616", "浙江省杭州市",
"861802644", "广东省广州市",
"86147838", "河南省开封市",
"861869145", "陕西省西安市",
"861310075", "湖北省随州市",
"861360420", "辽宁省鞍山市",
"861362156", "江苏省苏州市",
"861561676", "湖南省益阳市",
"861361491", "辽宁省朝阳市",
"861810342", "山西省太原市",
"861337913", "陕西省渭南市",
"861321450", "黑龙江省哈尔滨市",
"861500656", "山东省潍坊市",
"861358141", "湖北省襄樊市",
"861509130", "陕西省渭南市",
"861312456", "黑龙江省黑河市",
"861358526", "江苏省宿迁市",
"861891936", "甘肃省张掖市",
"861458696", "山东省莱芜市",
"861892153", "江苏省无锡市",
"861819445", "甘肃省陇南市",
"861336410", "辽宁省铁岭市",
"86137512", "广东省东莞市",
"861304393", "河南省濮阳市",
"861874799", "内蒙古呼和浩特市",
"861308799", "广西南宁市",
"86182396", "河南省驻马店市",
"861590966", "宁夏石嘴山市",
"86186412", "辽宁省鞍山市",
"861369555", "安徽省蚌埠市",
"861365799", "江西省萍乡市",
"861893484", "广西梧州市",
"861564913", "河南省郑州市",
"861339595", "福建省泉州市",
"861346520", "山东省威海市",
"861862546", "河南省开封市",
"861831426", "云南省大理白族自治州",
"861313393", "江西省上饶市",
"861779955", "新疆喀什地区",
"86158888", "浙江省杭州市",
"86187615", "江苏省无锡市",
"861807403", "浙江省绍兴市",
"861332893", "福建省宁德市",
"86136240", "辽宁省沈阳市",
"861892437", "广东省东莞市",
"861576014", "四川省乐山市",
"861846304", "山东省日照市",
"861348033", "广东省揭阳市",
"861565009", "山东省泰安市",
"861362853", "贵州省遵义市",
"861590844", "四川省巴中市",
"861700141", "江苏省盐城市",
"86180785", "广西玉林市",
"861576734", "广东省惠州市",
"861709946", "浙江省嘉兴市",
"861707760", "云南省昆明市",
"861308532", "云南省普洱市",
"861570645", "山东省烟台市",
"861858276", "四川省眉山市",
"86139482", "内蒙古兴安盟",
"861365532", "山东省青岛市",
"861476013", "福建省莆田市",
"861598410", "四川省宜宾市",
"861592240", "安徽省合肥市",
"86135914", "辽宁省沈阳市",
"86152578", "浙江省宁波市",
"861518942", "江苏省南通市",
"861584665", "黑龙江省绥化市",
"861355703", "广西桂林市",
"861810708", "江西省南昌市",
"861370762", "河南省周口市",
"861769879", "河南省漯河市",
"861459113", "广西来宾市",
"861573801", "河南省濮阳市",
"861570867", "贵州省毕节地区",
"861561569", "山东省临沂市",
"86137604", "广东省深圳市",
"861332477", "广西钦州市",
"861807262", "浙江省湖州市",
"86188651", "山东省聊城市",
"861370653", "浙江省湖州市",
"861853267", "河北省保定市",
"86183554", "安徽省淮南市",
"861370490", "辽宁省铁岭市",
"861868916", "西藏那曲地区",
"86373", "河南省新乡市",
"861327903", "新疆和田地区",
"861871837", "广东省茂名市",
"861340329", "河北省邢台市",
"861330704", "江西省抚州市",
"861525552", "安徽省马鞍山市",
"861380480", "黑龙江省牡丹江市",
"861860539", "山东省临沂市",
"861589909", "新疆昌吉回族自治州",
"861329848", "河南省三门峡市",
"861847573", "广东省中山市",
"86177220", "广东省珠海市",
"86130346", "浙江省宁波市",
"861454300", "黑龙江省哈尔滨市",
"861312709", "山东省日照市",
"861312461", "贵州省贵阳市",
"861556639", "辽宁省铁岭市",
"861331976", "新疆阿勒泰地区",
"8618916", "上海市",
"861760703", "江西省上饶市",
"861310575", "浙江省绍兴市",
"861313774", "河南省平顶山市",
"861599718", "湖北省襄樊市",
"861787578", "广东省湛江市",
"861830663", "广东省揭阳市",
"861772938", "陕西省西安市",
"861801950", "安徽省芜湖市",
"861327562", "安徽省铜陵市",
"861705181", "海南省海口市",
"861527287", "湖北省随州市",
"861705672", "山东省济南市",
"861860792", "江西省九江市",
"861572235", "青海省果洛藏族自治州",
"861853077", "河南省商丘市",
"86187110", "湖南省长沙市",
"861590630", "山东省威海市",
"861770694", "福建省莆田市",
"861324724", "湖北省咸宁市",
"861362538", "山东省泰安市",
"861771713", "河北省张家口市",
"861590951", "宁夏银川市",
"861830752", "广东省惠州市",
"861807072", "广西南宁市",
"861554273", "辽宁省鞍山市",
"861860460", "黑龙江省哈尔滨市",
"86189589", "浙江省温州市",
"861478720", "云南省大理白族自治州",
"861571306", "河北省廊坊市",
"86189935", "甘肃省武威市",
"861364410", "辽宁省铁岭市",
"861845245", "江苏省镇江市",
"86151667", "山东省济宁市",
"861475632", "河北省张家口市",
"86152587", "浙江省温州市",
"861334613", "浙江省台州市",
"861519574", "江苏省连云港市",
"861470248", "辽宁省大连市",
"861858566", "贵州省黔南布依族苗族自治州",
"861323735", "湖南省郴州市",
"86150582", "浙江省宁波市",
"861316580", "浙江省金华市",
"861860970", "青海省海北藏族自治州",
"861320534", "山东省德州市",
"861359749", "湖北省襄樊市",
"861560316", "河北省廊坊市",
"861592555", "云南省怒江傈僳族自治州",
"861801445", "江苏省南京市",
"861585943", "福建省福州市",
"86187516", "江苏省徐州市",
"861522058", "广东省惠州市",
"861306353", "江苏省徐州市",
"86136416", "上海市",
"86132392", "陕西省榆林市",
"861363743", "湖南省湘西土家族苗族自治州",
"861817741", "广西梧州市",
"861300996", "黑龙江省七台河市",
"861331466", "黑龙江省齐齐哈尔市",
"861521953", "广东省清远市",
"861598769", "云南省文山壮族苗族自治州",
"86183612", "江苏省徐州市",
"86134320", "广东省广州市",
"861347454", "陕西省咸阳市",
"861598401", "四川省泸州市",
"86183008", "贵州省贵阳市",
"861315349", "山东省德州市",
"861864729", "内蒙古乌海市",
"861576514", "黑龙江省佳木斯市",
"861888147", "四川省成都市",
"861871456", "黑龙江省黑河市",
"861559338", "甘肃省天水市",
"86136519", "上海市",
"86155468", "广东省深圳市",
"861398913", "四川省泸州市",
"861815382", "湖南省长沙市",
"86130819", "浙江省宁波市",
"86187419", "辽宁省辽阳市",
"861351763", "广西桂林市",
"861336769", "广西北海市",
"861452442", "黑龙江省齐齐哈尔市",
"861893377", "广东省湛江市",
"861589771", "湖北省孝感市",
"861458212", "安徽省铜陵市",
"861847402", "湖南省常德市",
"861476513", "广东省广州市",
"861508817", "广东省云浮市",
"861846439", "山东省滨州市",
"861345362", "山西省晋城市",
"861569821", "山东省威海市",
"861309957", "宁夏银川市",
"861771291", "江苏省南京市",
"861365712", "湖北省孝感市",
"861882181", "湖南省衡阳市",
"861450488", "辽宁省抚顺市",
"861874032", "陕西省榆林市",
"861882672", "广东省阳江市",
"861558647", "湖北省荆州市",
"861308032", "山西省大同市",
"861874712", "内蒙古包头市",
"861332967", "贵州省毕节地区",
"861377734", "浙江省绍兴市",
"861308712", "内蒙古呼和浩特市",
"86188418", "辽宁省阜新市",
"861535321", "陕西省铜川市",
"86135698", "河南省新乡市",
"861529405", "甘肃省平凉市",
"861335536", "山东省潍坊市",
"861570510", "江苏省盐城市",
"861598168", "吉林省四平市",
"861477877", "广东省广州市",
"861560359", "山西省运城市",
"861557988", "江西省赣州市",
"861775202", "甘肃省定西市",
"861348572", "安徽省合肥市",
"861530399", "河南省许昌市",
"861380781", "广西南宁市",
"861362408", "辽宁省大连市",
"861567253", "湖北省宜昌市",
"861593102", "河北省邯郸市",
"861332589", "浙江省金华市",
"861371720", "广东省肇庆市",
"861370791", "江西省南昌市",
"861824865", "浙江省台州市",
"861561500", "山东省菏泽市",
"861334253", "湖南省株洲市",
"86151551", "安徽省合肥市",
"861529814", "四川省达州市",
"861452134", "河北省沧州市",
"861806230", "湖北省鄂州市",
"861850877", "云南省玉溪市",
"861328954", "宁夏固原市",
"861874073", "陕西省渭南市",
"861587746", "陕西省榆林市",
"861875293", "江苏省镇江市",
"861889423", "甘肃省酒泉市",
"861304785", "广西玉林市",
"861860409", "辽宁省大连市",
"861327591", "福建省福州市",
"861860761", "广东省阳江市",
"861552457", "辽宁省大连市",
"861832542", "山东省青岛市",
"861308263", "山东省济宁市",
"861476882", "山东省德州市",
"861311340", "广东省惠州市",
"861874263", "新疆阿克苏地区",
"86139301", "河北省石家庄市",
"861840311", "河北省石家庄市",
"861570001", "浙江省衢州市",
"861310584", "浙江省衢州市",
"86139373", "河南省新乡市",
"86177336", "河北省廊坊市",
"861313785", "河南省驻马店市",
"861321766", "广东省云浮市",
"861891206", "江苏省淮安市",
"86152255", "河南省洛阳市",
"861458652", "湖北省荆州市",
"861828902", "西藏日喀则地区",
"861454285", "辽宁省鞍山市",
"861340953", "宁夏吴忠市",
"861336168", "江西省抚州市",
"861323640", "江苏省南京市",
"861458763", "广东省清远市",
"861454369", "山东省聊城市",
"861399744", "青海省海南藏族自治州",
"861780675", "广东省湛江市",
"861840564", "安徽省六安市",
"861830588", "浙江省丽水市",
"861346396", "河北省石家庄市",
"861512186", "宁夏石嘴山市",
"861317678", "山东省济宁市",
"861500692", "山东省日照市",
"861576835", "广东省湛江市",
"86181238", "广东省深圳市",
"861590745", "湖南省怀化市",
"861892335", "广东省江门市",
"861846509", "宁夏吴忠市",
"861537711", "湖北省黄冈市",
"861814428", "四川省宜宾市",
"861367322", "河北省保定市",
"861534550", "安徽省滁州市",
"861814381", "西藏拉萨市",
"861593498", "内蒙古鄂尔多斯市",
"861562486", "内蒙古赤峰市",
"861566050", "河南省驻马店市",
"861847532", "广东省汕尾市",
"861332152", "吉林省松原市",
"861803428", "河北省衡水市",
"861816943", "湖南省长沙市",
"861309162", "黑龙江省佳木斯市",
"86134174", "广东省深圳市",
"861357906", "新疆喀什地区",
"86153044", "吉林省长春市",
"861533383", "河南省郑州市",
"861705633", "贵州省贵阳市",
"861524066", "广西南宁市",
"861337590", "福建省三明市",
"86134236", "广东省广州市",
"861380937", "甘肃省酒泉市",
"861587377", "湖南省邵阳市",
"861768633", "山东省日照市",
"861777631", "广西柳州市",
"86177680", "江苏省苏州市",
"86159953", "江苏省无锡市",
"861820452", "黑龙江省齐齐哈尔市",
"861348403", "浙江省杭州市",
"861596634", "山东省济南市",
"86170710", "北京市",
"861364711", "湖北省鄂州市",
"861325706", "江西省新余市",
"86188567", "安徽省阜阳市",
"861889254", "贵州省安顺市",
"861807033", "江西省上饶市",
"861367550", "安徽省滁州市",
"861879727", "青海省海西蒙古族藏族自治州",
"861478421", "河南省郑州市",
"861534322", "湖南省湘潭市",
"861364031", "广东省广州市",
"861336531", "山东省济南市",
"86147942", "广东省广州市",
"861894699", "广东省汕头市",
"861525096", "江苏省南京市",
"861302727", "江西省九江市",
"861561987", "陕西省延安市",
"861524276", "辽宁省盘锦市",
"861598531", "贵州省安顺市",
"861835048", "福建省龙岩市",
"861599119", "陕西省安康市",
"861894296", "湖北省咸宁市",
"861320815", "四川省资阳市",
"861338634", "山东省莱芜市",
"861306929", "吉林省通化市",
"861336700", "江西省南昌市",
"861707837", "云南省大理白族自治州",
"861320404", "辽宁省沈阳市",
"86147528", "江苏省镇江市",
"861776137", "四川省自贡市",
"861508560", "贵州省遵义市",
"86183388", "河南省洛阳市",
"861833179", "河北省沧州市",
"861315044", "新疆喀什地区",
"861586382", "山东省烟台市",
"861818638", "湖北省黄石市",
"861806479", "浙江省温州市",
"861528694", "河南省濮阳市",
"861771403", "江苏省盐城市",
"861335158", "吉林省四平市",
"86187748", "湖南省长沙市",
"861840300", "河北省邯郸市",
"861898674", "湖北省黄冈市",
"861599408", "河南省许昌市",
"861876536", "山东省潍坊市",
"861800904", "四川省凉山彝族自治州",
"861570730", "湖南省岳阳市",
"86153922", "福建省泉州市",
"861365573", "浙江省嘉兴市",
"861318249", "江苏省南通市",
"861312419", "辽宁省辽阳市",
"861500619", "江苏省无锡市",
"861308573", "广东省潮州市",
"861873646", "河南省三门峡市",
"86153548", "内蒙古呼和浩特市",
"861760413", "辽宁省抚顺市",
"861332089", "四川省绵阳市",
"861819886", "广东省广州市",
"86151573", "浙江省嘉兴市",
"861775973", "福建省宁德市",
"861871492", "安徽省阜阳市",
"861318646", "江苏省连云港市",
"861595785", "浙江省宁波市",
"861366253", "广东省广州市",
"861553344", "河北省廊坊市",
"86151501", "江苏省苏州市",
"861707971", "浙江省丽水市",
"861894868", "广东省中山市",
"861360721", "湖北省荆州市",
"861300952", "内蒙古呼和浩特市",
"861832042", "广东省湛江市",
"861361790", "江西省新余市",
"86147024", "辽宁省沈阳市",
"86138430", "吉林省长春市",
"86139351", "山西省太原市",
"861568828", "湖南省怀化市",
"861570501", "内蒙古兴安盟",
"861573567", "山西省晋城市",
"861598293", "四川省德阳市",
"861332375", "河南省平顶山市",
"861373282", "吉林省辽源市",
"861779741", "青海省果洛藏族自治州",
"861537168", "江苏省连云港市",
"861530312", "河北省保定市",
"861818282", "黑龙江省齐齐哈尔市",
"861361462", "黑龙江省齐齐哈尔市",
"861853489", "山西省吕梁市",
"861330414", "辽宁省本溪市",
"861850787", "广西钦州市",
"861331750", "湖北省黄冈市",
"861390662", "浙江省宁波市",
"861561511", "山东省威海市",
"861558331", "四川省乐山市",
"861314978", "辽宁省锦州市",
"861309340", "安徽省合肥市",
"861303978", "黑龙江省黑河市",
"86152205", "广东省珠海市",
"861588778", "云南省楚雄彝族自治州",
"861338840", "浙江省衢州市",
"861381449", "江苏省泰州市",
"861315102", "江苏省无锡市",
"861863839", "河南省郑州市",
"86185724", "湖北省武汉市",
"861527530", "山东省菏泽市",
"861860334", "河北省承德市",
"861343725", "湖北省武汉市",
"861810418", "辽宁省阜新市",
"861524051", "江苏省常州市",
"861830796", "江西省吉安市",
"861399486", "山西省运城市",
"861781707", "广东省阳江市",
"861536590", "江苏省淮安市",
"861599192", "陕西省榆林市",
"861893475", "广西崇左市",
"861508270", "四川省巴中市",
"861308402", "安徽省阜阳市",
"861314468", "黑龙江省鹤岗市",
"861593044", "河北省唐山市",
"861829681", "江西省景德镇市",
"861520748", "湖南省长沙市",
"86183377", "河南省南阳市",
"861328841", "广东省佛山市",
"861856214", "山东省德州市",
"861860756", "广东省珠海市",
"861581927", "广东省河源市",
"861566550", "安徽省滁州市",
"861344014", "四川省德阳市",
"861819183", "陕西省渭南市",
"861572905", "河南省焦作市",
"861336711", "湖北省鄂州市",
"86184719", "湖北省武汉市",
"861395629", "安徽省滁州市",
"861771572", "四川省泸州市",
"861367050", "广东省汕头市",
"861539415", "陕西省安康市",
"861834464", "江苏省徐州市",
"861364531", "山东省济南市",
"86177293", "陕西省宝鸡市",
"861337090", "山东省威海市",
"861361972", "青海省海东地区",
"86159903", "浙江省嘉兴市",
"861321751", "广东省韶关市",
"861598031", "福建省泉州市",
"861896659", "陕西省延安市",
"861320339", "湖南省郴州市",
"861589239", "四川省广安市",
"861390818", "四川省成都市",
"86137138", "广东省深圳市",
"861802767", "广东省佛山市",
"861327233", "湖南省衡阳市",
"861589636", "江苏省镇江市",
"861806969", "浙江省嘉兴市",
"861315498", "四川省乐山市",
"861398590", "贵州省六盘水市",
"861850493", "内蒙古阿拉善盟",
"861565060", "安徽省滁州市",
"86182868", "贵州省六盘水市",
"861372122", "安徽省马鞍山市",
"861850931", "甘肃省兰州市",
"861533147", "云南省红河哈尼族彝族自治州",
"861875700", "浙江省衢州市",
"861577548", "四川省南充市",
"861801347", "江苏省苏州市",
"861364700", "江西省南昌市",
"86138139", "江苏省南京市",
"861884682", "黑龙江省哈尔滨市",
"861774603", "福建省宁德市",
"861760466", "黑龙江省哈尔滨市",
"861882889", "四川省自贡市",
"861888255", "四川省遂宁市",
"86188217", "陕西省西安市",
"861810067", "江苏省苏州市",
"861853025", "河南省商丘市",
"861327347", "河北省邢台市",
"861860868", "湖北省咸宁市",
"861531231", "江苏省淮安市",
"86157979", "江西省南昌市",
"861550390", "河南省焦作市",
"86180200", "天津市",
"861511305", "广东省汕头市",
"861350764", "河南省驻马店市",
"861551321", "山西省忻州市",
"861801233", "江苏省扬州市",
"861335652", "广东省湛江市",
"861311812", "四川省德阳市",
"86158978", "湖北省十堰市",
"861352580", "河南省安阳市",
"861308692", "贵州省黔南布依族苗族自治州",
"861874692", "黑龙江省绥化市",
"861354496", "广东省江门市",
"861554182", "辽宁省阜新市",
"86185391", "河南省焦作市",
"861365692", "福建省龙岩市",
"86135115", "江苏省淮安市",
"86155267", "吉林省延边朝鲜族自治州",
"861324210", "广东省佛山市",
"861577604", "黑龙江省绥化市",
"861776411", "湖北省黄冈市",
"861458536", "河南省周口市",
"861875753", "浙江省绍兴市",
"86131298", "广东省东莞市",
"861811455", "江苏省镇江市",
"861370251", "广东省中山市",
"861316343", "黑龙江省哈尔滨市",
"861334793", "江苏省徐州市",
"861896588", "福建省莆田市",
"861338399", "河南省平顶山市",
"861472876", "贵州省黔西南布依族苗族自治州",
"861315608", "山东省威海市",
"861768910", "西藏拉萨市",
"861339635", "山东省聊城市",
"861332425", "辽宁省盘锦市",
"861470306", "河北省保定市",
"861361545", "山东省烟台市",
"861537662", "山东省烟台市",
"861880337", "河北省沧州市",
"86137900", "广东省佛山市",
"861370898", "山东省青岛市",
"861520954", "宁夏固原市",
"861516681", "山东省滨州市",
"86139272", "广东省佛山市",
"86186356", "山西省晋城市",
"861532998", "贵州省黔东南苗族侗族自治州",
"861887890", "广西柳州市",
"861554559", "黑龙江省哈尔滨市",
"861329955", "宁夏中卫市",
"861345547", "山东省济宁市",
"861885133", "江苏省南通市",
"861351406", "福建省福州市",
"86184247", "辽宁省葫芦岛市",
"861781683", "浙江省温州市",
"861871602", "河北省秦皇岛市",
"861780358", "山西省吕梁市",
"861530634", "山东省莱芜市",
"861366374", "河南省许昌市",
"861340911", "陕西省延安市",
"861768889", "广东省深圳市",
"861822946", "湖南省永州市",
"861858990", "广西崇左市",
"86176817", "浙江省温州市",
"861870629", "江苏省南通市",
"861390531", "山东省济南市",
"861536745", "湖南省怀化市",
"861860612", "江苏省南通市",
"861820070", "广东省深圳市",
"861806180", "江苏省南通市",
"861894756", "内蒙古呼伦贝尔市",
"861452284", "山西省晋中市",
"861831664", "广东省汕头市",
"861840353", "山西省阳泉市",
"861328302", "河南省濮阳市",
"861801091", "安徽省滁州市",
"861800020", "江西省南昌市",
"861339441", "吉林省吉林市",
"861363915", "贵州省六盘水市",
"86155710", "湖北省襄樊市",
"861877880", "广西防城港市",
"861846996", "云南省德宏傣族景颇族自治州",
"861809628", "四川省凉山彝族自治州",
"861770714", "湖北省黄石市",
"861300560", "广东省湛江市",
"861528404", "四川省绵阳市",
"861555633", "安徽省滁州市",
"861325932", "陕西省延安市",
"861515686", "安徽省安庆市",
"861390700", "江西省南昌市",
"861537818", "四川省成都市",
"861889794", "江西省抚州市",
"861882910", "陕西省西安市",
"861572174", "贵州省毕节地区",
"86138358", "山西省吕梁市",
"861556512", "河南省开封市",
"861526886", "浙江省台州市",
"861515289", "江苏省南通市",
"861334211", "辽宁省鞍山市",
"861454135", "河北省唐山市",
"861760976", "青海省玉树藏族自治州",
"86137359", "浙江省丽水市",
"861303017", "广东省湛江市",
"861356709", "浙江省丽水市",
"86147362", "广西河池市",
"861331703", "江西省上饶市",
"861357732", "云南省红河哈尼族彝族自治州",
"861567211", "湖北省十堰市",
"861559765", "青海省海南藏族自治州",
"861572443", "辽宁省丹东市",
"861303737", "湖南省益阳市",
"861521230", "安徽省黄山市",
"861853170", "河北省沧州市",
"861370576", "浙江省台州市",
"861364818", "四川省乐山市",
"861775416", "安徽省阜阳市",
"861879784", "江西省抚州市",
"86181859", "贵州省黔西南布依族苗族自治州",
"861338312", "河北省保定市",
"861509717", "甘肃省陇南市",
"861820939", "甘肃省陇南市",
"861565952", "福建省漳州市",
"86187198", "甘肃省天水市",
"861471645", "广东省深圳市",
"861879446", "甘肃省天水市",
"861360828", "四川省泸州市",
"861310027", "湖南省湘西土家族苗族自治州",
"86170933", "河北省唐山市",
"861508952", "广东省汕尾市",
"861450992", "新疆伊犁哈萨克自治州",
"861768901", "西藏拉萨市",
"861889373", "甘肃省庆阳市",
"861348450", "陕西省宝鸡市",
"861538414", "浙江省绍兴市",
"861850724", "湖北省咸宁市",
"861475739", "浙江省嘉兴市",
"861813501", "山西省忻州市",
"861810567", "安徽省阜阳市",
"861309812", "陕西省渭南市",
"861535992", "福建省龙岩市",
"861877992", "江西省萍乡市",
"861509305", "河南省郑州市",
"861868432", "吉林省吉林市",
"861350331", "河北省石家庄市",
"86181784", "广西梧州市",
"861700849", "浙江省杭州市",
"861534503", "福建省宁德市",
"861835723", "浙江省嘉兴市",
"861472786", "陕西省汉中市",
"861380778", "广西河池市",
"861521969", "广东省江门市",
"861598753", "云南省文山壮族苗族自治州",
"86158987", "山东省淄博市",
"861367962", "四川省乐山市",
"861569935", "新疆阿克苏地区",
"861366793", "江西省上饶市",
"861320694", "黑龙江省黑河市",
"861321713", "湖北省黄冈市",
"861589189", "云南省曲靖市",
"861354177", "四川省巴中市",
"861813730", "河南省南阳市",
"861336753", "广西桂林市",
"861378730", "湖南省岳阳市",
"861317681", "山东省威海市",
"861880505", "福建省厦门市",
"861351759", "广西北海市",
"861317172", "河北省秦皇岛市",
"861830571", "浙江省杭州市",
"861855426", "山东省威海市",
"861322938", "广东省韶关市",
"861804010", "辽宁省大连市",
"861882779", "江西省吉安市",
"861832465", "黑龙江省伊春市",
"861365619", "江苏省无锡市",
"861500573", "浙江省嘉兴市",
"86134292", "浙江省宁波市",
"861872812", "四川省内江市",
"861308619", "江西省萍乡市",
"861520523", "江苏省淮安市",
"861510249", "辽宁省辽阳市",
"861596312", "山东省济南市",
"861847661", "广东省湛江市",
"861529943", "新疆石河子市",
"861361045", "广东省中山市",
"861308216", "河北省沧州市",
"861302446", "江苏省泰州市",
"861861372", "河南省安阳市",
"86189276", "广东省湛江市",
"861859689", "福建省泉州市",
"86137950", "辽宁省阜新市",
"861510646", "山东省烟台市",
"86132220", "江苏省南京市",
"861334374", "河南省许昌市",
"861337745", "广西玉林市",
"86136352", "福建省福州市",
"86135610", "山东省东营市",
"861533615", "陕西省渭南市",
"86188490", "河北省邯郸市",
"861800352", "山西省大同市",
"86157370", "河南省商丘市",
"861370266", "广东省茂名市",
"861524013", "安徽省宣城市",
"861390031", "河北省邯郸市",
"861399958", "新疆伊犁哈萨克自治州",
"86186306", "河北省廊坊市",
"861561553", "山东省淄博市",
"861478371", "河南省郑州市",
"861534472", "广东省广州市",
"861554059", "内蒙古呼伦贝尔市",
"86139744", "湖南省张家界市",
"861812654", "广东省深圳市",
"861773735", "河南省新乡市",
"861814378", "甘肃省兰州市",
"861591521", "广东省佛山市",
"861567200", "湖北省黄石市",
"861367472", "内蒙古包头市",
"861809940", "新疆伊犁哈萨克自治州",
"861362698", "福建省宁德市",
"861770534", "山东省德州市",
"861309668", "山西省大同市",
"861839297", "陕西省西安市",
"861820570", "浙江省衢州市",
"861529695", "宁夏中卫市",
"861801591", "江苏省南通市",
"861332658", "广东省阳江市",
"861800520", "江苏省徐州市",
"861872668", "安徽省亳州市",
"861762540", "江苏省无锡市",
"86138308", "甘肃省天水市",
"861557709", "广西玉林市",
"861300270", "山东省淄博市",
"861816814", "江苏省连云港市",
"861373132", "河北省张家口市",
"861321291", "黑龙江省哈尔滨市",
"861320220", "广东省揭阳市",
"861356837", "四川省广元市",
"861300304", "安徽省芜湖市",
"861818132", "四川省凉山彝族自治州",
"86719", "湖北省十堰市",
"861303809", "山西省大同市",
"861760451", "黑龙江省哈尔滨市",
"861581984", "广东省珠海市",
"861328748", "山东省潍坊市",
"861521479", "浙江省台州市",
"861322824", "四川省绵阳市",
"861370076", "河南省信阳市",
"861525909", "福建省宁德市",
"861302874", "甘肃省白银市",
"861535770", "安徽省巢湖市",
"861571994", "新疆乌鲁木齐市",
"86137309", "山东省青岛市",
"861303517", "湖北省孝感市",
"861854534", "黑龙江省大庆市",
"861705779", "陕西省西安市",
"861860699", "福建省福州市",
"861366487", "内蒙古包头市",
"86186327", "河北省沧州市",
"861476051", "宁夏银川市",
"861521900", "广东省江门市",
"861778954", "甘肃省平凉市",
"861332218", "辽宁省锦州市",
"861338448", "吉林省长春市",
"861341841", "广东省佛山市",
"861383588", "山西省运城市",
"861598691", "广东省揭阳市",
"861338594", "福建省莆田市",
"861778023", "四川省德阳市",
"861368554", "安徽省淮南市",
"861306300", "福建省漳州市",
"86137262", "广东省珠海市",
"86137943", "广东省广州市",
"861865621", "安徽省铜陵市",
"861305554", "福建省三明市",
"861346904", "湖南省长沙市",
"861808621", "湖北省恩施土家族苗族自治州",
"861894539", "黑龙江省大兴安岭地区",
"861362811", "四川省绵阳市",
"86187581", "浙江省杭州市",
"861818444", "贵州省毕节地区",
"861576921", "陕西省宝鸡市",
"861597704", "广西玉林市",
"861348751", "湖南省郴州市",
"861538623", "湖南省株洲市",
"861776701", "浙江省舟山市",
"861332327", "河北省沧州市",
"861554736", "内蒙古乌海市",
"861317836", "福建省泉州市",
"861533255", "陕西省延安市",
"861450961", "新疆博尔塔拉蒙古自治州",
"861459166", "广西崇左市",
"861880435", "吉林省通化市",
"861518075", "贵州省遵义市",
"861363028", "陕西省西安市",
"861396623", "安徽省宣城市",
"861846952", "云南省文山壮族苗族自治州",
"861350865", "湖北省黄冈市",
"861705178", "浙江省杭州市",
"861504722", "内蒙古包头市",
"861564951", "河南省鹤壁市",
"861787581", "广东省广州市",
"86156295", "湖北省孝感市",
"861830616", "江苏省无锡市",
"861894460", "黑龙江省哈尔滨市",
"861475314", "山东省济南市",
"861518265", "四川省广安市",
"861324877", "浙江省温州市",
"861847692", "广东省湛江市",
"861304827", "广东省梅州市",
"861878827", "云南省红河哈尼族彝族自治州",
"861534433", "吉林省延边朝鲜族自治州",
"86131166", "浙江省宁波市",
"861894792", "内蒙古呼和浩特市",
"861534991", "新疆乌鲁木齐市",
"861328149", "四川省成都市",
"861772346", "四川省攀枝花市",
"86132336", "山西省太原市",
"86180243", "广东省东莞市",
"861389706", "青海省海西蒙古族藏族自治州",
"861508167", "河北省廊坊市",
"86189411", "辽宁省大连市",
"86182967", "江西省赣州市",
"861825254", "江苏省扬州市",
"861536476", "山西省晋城市",
"861596448", "山东省淄博市",
"861367433", "吉林省延边朝鲜族自治州",
"861366651", "浙江省湖州市",
"861475561", "安徽省合肥市",
"861337951", "陕西省西安市",
"861845003", "福建省厦门市",
"861813993", "甘肃省庆阳市",
"861337630", "山东省威海市",
"861813431", "河北省保定市",
"861777591", "湖南省怀化市",
"86159969", "江苏省徐州市",
"861326690", "河北省石家庄市",
"86138088", "广东省广州市",
"861361610", "江苏省常州市",
"861560363", "黑龙江省牡丹江市",
"86189658", "福建省厦门市",
"861775706", "浙江省宁波市",
"861321072", "山东省滨州市",
"861327631", "山东省威海市",
"86132680", "广东省广州市",
"861331413", "辽宁省抚顺市",
"861317133", "内蒙古巴彦淖尔市",
"86139016", "上海市",
"861319350", "河南省安阳市",
"861804645", "福建省泉州市",
"861370600", "福建省南平市",
"861475138", "江苏省徐州市",
"861500532", "山东省青岛市",
"86157124", "辽宁省沈阳市",
"861866626", "广东省阳江市",
"861309583", "浙江省丽水市",
"861319522", "贵州省遵义市",
"861818876", "广东省惠州市",
"861832984", "陕西省榆林市",
"861392205", "广东省茂名市",
"861813645", "江苏省南通市",
"861390410", "辽宁省铁岭市",
"861355750", "广西柳州市",
"861334666", "河南省新乡市",
"861524990", "安徽省池州市",
"861587242", "湖北省武汉市",
"861559946", "贵州省铜仁地区",
"861810989", "辽宁省葫芦岛市",
"861518120", "四川省雅安市",
"861579798", "江西省九江市",
"861528034", "福建省宁德市",
"861366579", "浙江省台州市",
"861550141", "江苏省连云港市",
"861393831", "河南省濮阳市",
"861308656", "四川省宜宾市",
"86170798", "浙江省绍兴市",
"861334079", "四川省资阳市",
"86155148", "河南省安阳市",
"861308259", "江苏省盐城市",
"861776979", "浙江省舟山市",
"861535471", "吉林省延边朝鲜族自治州",
"861805144", "江苏省扬州市",
"861889332", "甘肃省平凉市",
"861856720", "河南省鹤壁市",
"861317457", "福建省宁德市",
"861550526", "江苏省盐城市",
"861340969", "湖北省黄冈市",
"861303860", "云南省迪庆藏族自治州",
"861321262", "湖南省长沙市",
"861761414", "辽宁省本溪市",
"861760750", "广东省江门市",
"861521587", "浙江省金华市",
"861500799", "江西省萍乡市",
"861867547", "广东省肇庆市",
"861351158", "江苏省南通市",
"861452565", "贵州省黔东南苗族侗族自治州",
"861514497", "内蒙古通辽市",
"861890729", "湖北省孝感市",
"861454353", "山东省滨州市",
"861567079", "河南省安阳市",
"861880641", "山东省济南市",
"861458759", "广东省湛江市",
"861893427", "广东省阳江市",
"861772777", "广东省韶关市",
"86178543", "山东省滨州市",
"861314860", "广东省河源市",
"861315982", "黑龙江省大庆市",
"861342834", "广东省汕头市",
"861826264", "江苏省南京市",
"861368923", "陕西省渭南市",
"861377921", "新疆石河子市",
"861525636", "安徽省亳州市",
"861831747", "河南省濮阳市",
"861365661", "浙江省嘉兴市",
"861476551", "江苏省南京市",
"86187266", "安徽省滁州市",
"861536197", "广东省梅州市",
"861338094", "广东省河源市",
"86132185", "江苏省徐州市",
"861524882", "内蒙古阿拉善盟",
"861458406", "河南省郑州市",
"861340230", "四川省自贡市",
"861395722", "浙江省舟山市",
"86185638", "山东省烟台市",
"861324787", "江西省赣州市",
"86138584", "浙江省绍兴市",
"861479378", "甘肃省白银市",
"86133681", "重庆市",
"861773928", "河南省平顶山市",
"861813867", "广东省江门市",
"861850825", "四川省遂宁市",
"861844992", "新疆哈密地区",
"861566433", "河南省周口市",
"861580557", "安徽省宿州市",
"861537691", "山东省临沂市",
"861360370", "河南省商丘市",
"86159881", "浙江省杭州市",
"861536630", "江苏省连云港市",
"861567651", "广西百色市",
"86181162", "上海市",
"861378867", "广西柳州市",
"861868002", "广东省佛山市",
"861804867", "四川省南充市",
"861884908", "河北省衡水市",
"861334651", "广东省韶关市",
"861531889", "山东省青岛市",
"86182332", "河北省保定市",
"861590326", "河北省廊坊市",
"861533540", "山东省菏泽市",
"861334930", "黑龙江省哈尔滨市",
"861597623", "广东省惠州市",
"86180337", "河北省石家庄市",
"861815949", "福建省福州市",
"861477825", "广东省肇庆市",
"861596094", "福建省龙岩市",
"861364691", "福建省三明市",
"861800396", "河南省驻马店市",
"86188423", "辽宁省沈阳市",
"861526445", "山东省潍坊市",
"861807693", "西藏山南地区",
"861324650", "广东省湛江市",
"861324493", "广东省江门市",
"86150019", "上海市",
"861324931", "广东省惠州市",
"861590913", "陕西省渭南市",
"861452275", "山西省长治市",
"861339740", "湖南省岳阳市",
"861589878", "山东省济宁市",
"861301522", "内蒙古呼和浩特市",
"861891348", "江苏省徐州市",
"861564966", "河南省郑州市",
"861816035", "新疆伊犁哈萨克自治州",
"86176923", "河北省保定市",
"86189012", "北京市",
"861335212", "辽宁省抚顺市",
"86189608", "福建省福州市",
"86145815", "浙江省绍兴市",
"861569728", "湖北省武汉市",
"861819562", "青海省海东地区",
"861527690", "新疆哈密地区",
"861337966", "贵州省黔西南布依族苗族自治州",
"861475556", "安徽省马鞍山市",
"861782897", "四川省自贡市",
"861816307", "湖北省宜昌市",
"861526631", "山东省威海市",
"861476276", "江苏省镇江市",
"86152780", "广西南宁市",
"861569205", "广东省佛山市",
"861350647", "山东省潍坊市",
"861888615", "贵州省安顺市",
"861769908", "新疆克孜勒苏柯尔克孜自治州",
"861319022", "辽宁省丹东市",
"861322725", "湖北省宜昌市",
"861782002", "广东省中山市",
"861453080", "安徽省合肥市",
"861550026", "吉林省白城市",
"861334579", "浙江省金华市",
"861356760", "浙江省丽水市",
"861802508", "广东省珠海市",
"861337844", "广东省广州市",
"861881998", "广东省惠州市",
"861898926", "四川省凉山彝族自治州",
"86159360", "河南省周口市",
"861820606", "福建省厦门市",
"861351536", "山东省潍坊市",
"861459151", "广西河池市",
"861768231", "浙江省杭州市",
"861450956", "江苏省宿迁市",
"861840929", "陕西省榆林市",
"861305316", "安徽省芜湖市",
"861819903", "新疆和田地区",
"861572185", "云南省玉溪市",
"861708647", "江苏省盐城市",
"861564844", "内蒙古巴彦淖尔市",
"861527137", "湖北省十堰市",
"861705231", "四川省成都市",
"861471510", "广东省深圳市",
"861370611", "江苏省常州市",
"861823870", "河南省商丘市",
"861770339", "河北省邢台市",
"861565996", "福建省宁德市",
"861348766", "湖南省常德市",
"861393467", "山西省临汾市",
"861841902", "甘肃省天水市",
"861867047", "湖南省衡阳市",
"86157341", "辽宁省大连市",
"861700653", "江苏省南京市",
"861700490", "上海市",
"861852407", "辽宁省营口市",
"861388240", "四川省巴中市",
"861529305", "甘肃省白银市",
"861517905", "江西省赣州市",
"861560459", "黑龙江省大庆市",
"861557921", "江西省九江市",
"861333892", "江苏省盐城市",
"861533797", "新疆喀什地区",
"861700762", "广东省中山市",
"861341799", "广东省云浮市",
"861380728", "湖北省十堰市",
"861530499", "辽宁省葫芦岛市",
"861363852", "贵州省遵义市",
"861362308", "广东省潮州市",
"861321947", "四川省德阳市",
"861800939", "甘肃省陇南市",
"861568771", "云南省玉溪市",
"861310077", "湖北省襄樊市",
"861884046", "陕西省西安市",
"861457051", "新疆乌鲁木齐市",
"861360878", "云南省西双版纳傣族自治州",
"861528952", "广西百色市",
"86182250", "重庆市",
"86187920", "安徽省六安市",
"861856961", "湖南省长沙市",
"86139288", "广东省广州市",
"861850774", "广西梧州市",
"861889323", "甘肃省定西市",
"861392179", "江苏省徐州市",
"861394881", "内蒙古呼和浩特市",
"861591659", "广东省佛山市",
"861869147", "陕西省延安市",
"86176128", "四川省成都市",
"861520573", "浙江省嘉兴市",
"86189464", "黑龙江省佳木斯市",
"861507808", "广西河池市",
"86184774", "广西梧州市",
"861860309", "广东省佛山市",
"861510582", "浙江省湖州市",
"861500523", "江苏省淮安市",
"861863804", "河南省商丘市",
"861319533", "安徽省芜湖市",
"861311440", "湖北省随州市",
"861890593", "福建省宁德市",
"861861322", "四川省成都市",
"861509943", "新疆伊犁哈萨克自治州",
"861322446", "吉林省白城市",
"861840411", "辽宁省大连市",
"861576108", "贵州省遵义市",
"86130220", "广东省广州市",
"861863415", "河北省唐山市",
"861301033", "江苏省无锡市",
"861839941", "新疆阿克苏地区",
"861301713", "湖南省株洲市",
"861333007", "江西省南昌市",
"86158982", "辽宁省葫芦岛市",
"861300694", "广西梧州市",
"861454469", "陕西省榆林市",
"861454701", "浙江省杭州市",
"86145270", "湖北省武汉市",
"861830521", "江苏省徐州市",
"861302938", "辽宁省鞍山市",
"861300165", "山东省威海市",
"861862879", "吉林省长春市",
"861898687", "湖北省十堰市",
"861892435", "广东省东莞市",
"861509164", "陕西省渭南市",
"861367422", "辽宁省鞍山市",
"861814328", "西藏拉萨市",
"861800570", "浙江省衢州市",
"861803328", "广东省潮州市",
"86183201", "广东省广州市",
"861803481", "新疆喀什地区",
"861834731", "内蒙古鄂尔多斯市",
"861820520", "江苏省徐州市",
"86183273", "湖北省武汉市",
"861562194", "内蒙古呼伦贝尔市",
"8613200", "上海市",
"861330556", "安徽省安庆市",
"861811678", "四川省广元市",
"861857212", "湖北省孝感市",
"86134246", "广东省佛山市",
"861846714", "青海省玉树藏族自治州",
"861533483", "内蒙古阿拉善盟",
"861820352", "山西省大同市",
"861770996", "新疆巴音郭楞蒙古自治州",
"861334324", "河北省石家庄市",
"861377419", "湖北省宜昌市",
"861360596", "福建省三明市",
"86177397", "河南省郑州市",
"861539839", "云南省昆明市",
"861570647", "山东省济宁市",
"861534422", "内蒙古包头市",
"861478321", "河南省漯河市",
"861563680", "黑龙江省哈尔滨市",
"861397206", "湖北省襄樊市",
"861302824", "辽宁省朝阳市",
"861819447", "甘肃省陇南市",
"861898750", "云南省保山市",
"861505909", "福建省龙岩市",
"861370026", "陕西省汉中市",
"861830843", "四川省德阳市",
"861538632", "湖南省湘潭市",
"86186322", "河北省保定市",
"861301858", "广东省湛江市",
"861323517", "江苏省常州市",
"861870566", "安徽省池州市",
"861452418", "辽宁省阜新市",
"861576760", "广东省汕尾市",
"861571536", "山东省潍坊市",
"861893589", "新疆阿勒泰地区",
"861320270", "广东省东莞市",
"861339597", "福建省龙岩市",
"861778032", "四川省内江市",
"861550611", "江苏省宿迁市",
"861779957", "新疆喀什地区",
"861301291", "山东省东营市",
"861589204", "福建省漳州市",
"861308748", "云南省昭通市",
"861501479", "广东省东莞市",
"861874748", "内蒙古乌兰察布市",
"86135341", "广东省深圳市",
"861369557", "安徽省宿州市",
"861881382", "广东省汕头市",
"861870551", "安徽省合肥市",
"861806379", "福建省龙岩市",
"861709644", "山东省青岛市",
"861855197", "江苏省南京市",
"86155262", "湖南省郴州市",
"861880768", "广东省潮州市",
"861452109", "河北省邢台市",
"861328692", "广东省中山市",
"86155943", "陕西省延安市",
"86187738", "湖南省娄底市",
"861453443", "辽宁省营口市",
"861554621", "黑龙江省哈尔滨市",
"861853075", "河南省商丘市",
"86188739", "湖南省邵阳市",
"86188212", "上海市",
"86145038", "辽宁省沈阳市",
"861312319", "福建省福州市",
"861479780", "江西省新余市",
"861760313", "河北省张家口市",
"861316905", "广东省潮州市",
"861847149", "湖北省武汉市",
"861551371", "山西省阳泉市",
"861808736", "云南省昆明市",
"861310577", "浙江省温州市",
"861374736", "内蒙古乌海市",
"861553444", "山西省晋中市",
"861582913", "陕西省商洛市",
"861454710", "浙江省衢州市",
"861572237", "青海省海西蒙古族藏族自治州",
"86182200", "陕西省咸阳市",
"861527285", "湖北省随州市",
"861520263", "宁夏吴忠市",
"861570865", "贵州省黔东南苗族侗族自治州",
"861890093", "辽宁省沈阳市",
"86138440", "吉林省长春市",
"861577883", "广西河池市",
"861360788", "广西南宁市",
"861568881", "山东省日照市",
"861858722", "云南省红河哈尼族彝族自治州",
"861530412", "辽宁省鞍山市",
"861332475", "广西贵港市",
"861855630", "安徽省芜湖市",
"861853265", "河北省唐山市",
"861319713", "湖北省荆门市",
"861500954", "宁夏固原市",
"86139277", "广东省佛山市",
"86189794", "江西省抚州市",
"861520073", "湖南省衡阳市",
"861584667", "黑龙江省绥化市",
"861333819", "江苏省常州市",
"861899458", "江苏省淮安市",
"861319033", "辽宁省盘锦市",
"861384853", "内蒙古包头市",
"861330314", "河北省承德市",
"861477884", "广东省惠州市",
"861306808", "山西省太原市",
"861362742", "湖南省长沙市",
"861836181", "江苏省镇江市",
"861869383", "甘肃省天水市",
"861511943", "广东省汕尾市",
"861512048", "甘肃省临夏回族自治州",
"861355313", "山东省烟台市",
"861587893", "广西钦州市",
"861381349", "江苏省徐州市",
"861301533", "山西省晋中市",
"86134119", "广东省汕头市",
"861323981", "新疆和田地区",
"861871835", "广东省茂名市",
"861810318", "河北省衡水市",
"861860434", "吉林省四平市",
"861330561", "安徽省淮北市",
"861800070", "江西省南昌市",
"86183251", "重庆市",
"861365302", "广东省韶关市",
"86188328", "河北省衡水市",
"861314368", "广东省广州市",
"861596609", "山东省潍坊市",
"861893375", "广东省河源市",
"861308302", "安徽省宿州市",
"861888145", "四川省成都市",
"861822438", "四川省广安市",
"861303368", "浙江省丽水市",
"861339802", "西藏日喀则地区",
"861333980", "湖北省襄樊市",
"861320560", "安徽省合肥市",
"86184242", "辽宁省朝阳市",
"861309955", "宁夏吴忠市",
"861558645", "湖北省十堰市",
"861550600", "吉林省长春市",
"861332965", "贵州省黔东南苗族侗族自治州",
"861566422", "河南省平顶山市",
"86135124", "天津市",
"86131829", "江苏省南京市",
"861802946", "广东省汕尾市",
"86187329", "河北省邢台市",
"861508815", "广东省东莞市",
"86155089", "海南省海口市",
"861327726", "湖北省十堰市",
"861559008", "吉林省吉林市",
"861366324", "河北省保定市",
"861575750", "浙江省杭州市",
"861519479", "河北省保定市",
"861379946", "福建省泉州市",
"861370141", "江苏省苏州市",
"861769121", "陕西省西安市",
"861342101", "广东省梅州市",
"861890231", "广东省深圳市",
"861323737", "湖南省益阳市",
"861320439", "吉林省白山市",
"861760926", "陕西省汉中市",
"861560706", "江西省吉安市",
"86136326", "广东省深圳市",
"861707361", "河南省郑州市",
"861845247", "江苏省泰州市",
"861370526", "江苏省泰州市",
"861587196", "湖北省襄樊市",
"861477393", "湖南省邵阳市",
"861305932", "广东省云浮市",
"861377492", "山东省日照市",
"861368932", "甘肃省张掖市",
"861850393", "河南省濮阳市",
"861577186", "陕西省汉中市",
"861801447", "江苏省南京市",
"861592557", "云南省保山市",
"861515542", "安徽省淮南市",
"861857299", "湖北省武汉市",
"86138149", "江苏省苏州市",
"861454411", "福建省福州市",
"861778198", "四川省绵阳市",
"86130185", "广东省佛山市",
"861527274", "湖北省咸宁市",
"861310489", "广东省广州市",
"86145824", "安徽省合肥市",
"861386152", "江苏省无锡市",
"861514823", "内蒙古包头市",
"861313787", "河南省驻马店市",
"861479481", "内蒙古呼和浩特市",
"861304787", "广西钦州市",
"861860504", "福建省泉州市",
"861897294", "湖北省武汉市",
"861330739", "湖南省邵阳市",
"861523873", "河南省焦作市",
"861552455", "辽宁省大连市",
"861301403", "安徽省六安市",
"861330019", "上海市",
"861502286", "新疆吐鲁番地区",
"861872741", "湖北省荆州市",
"861377971", "新疆喀什地区",
"86136574", "湖南省长沙市",
"861325923", "陕西省宝鸡市",
"861368973", "吉林省四平市",
"86158394", "河南省周口市",
"861505636", "安徽省蚌埠市",
"861780677", "广东省阳江市",
"861840469", "黑龙江省双鸭山市",
"861840701", "江西省鹰潭市",
"861898466", "贵州省铜仁地区",
"861452160", "河北省廊坊市",
"86138453", "黑龙江省牡丹江市",
"861318163", "山东省烟台市",
"861568239", "四川省资阳市",
"861778573", "贵州省贵阳市",
"861454287", "辽宁省营口市",
"861572080", "江苏省南京市",
"861576456", "黑龙江省黑河市",
"861328661", "广东省江门市",
"86132966", "湖北省武汉市",
"861347516", "山东省德州市",
"861597673", "广东省河源市",
"86182337", "河北省沧州市",
"861590376", "河南省信阳市",
"861530348", "山西省吕梁市",
"861360552", "安徽省蚌埠市",
"861812488", "广东省阳江市",
"861309741", "云南省玉溪市",
"861354904", "西藏林芝地区",
"861558730", "山东省济宁市",
"861529407", "甘肃省陇南市",
"861817191", "湖北省宜昌市",
"861330592", "福建省福州市",
"861571759", "湖南省邵阳市",
"861333153", "吉林省通化市",
"861477875", "广东省广州市",
"861856919", "湖南省张家界市",
"861770952", "宁夏石嘴山市",
"861831913", "广东省湛江市",
"861558010", "湖南省岳阳市",
"861820396", "河南省驻马店市",
"86159339", "河北省保定市",
"861331351", "山西省太原市",
"861850875", "云南省保山市",
"861885122", "江苏省常州市",
"86147848", "广东省广州市",
"861890910", "陕西省咸阳市",
"861332484", "广西梧州市",
"861459241", "四川省眉山市",
"86155950", "宁夏银川市",
"861361391", "河南省焦作市",
"861810442", "吉林省吉林市",
"861840530", "山东省菏泽市",
"861824867", "浙江省台州市",
"861363578", "湖北省襄樊市",
"861360320", "河北省邯郸市",
"861359199", "辽宁省葫芦岛市",
"861394960", "河南省新乡市",
"861575451", "黑龙江省哈尔滨市",
"861569778", "广西河池市",
"86157610", "贵州省贵阳市",
"861550266", "辽宁省锦州市",
"861312356", "广西百色市",
"861773468", "陕西省渭南市",
"86135370", "广东省东莞市",
"861860142", "江苏省苏州市",
"861342978", "陕西省宝鸡市",
"861844720", "内蒙古锡林郭勒盟",
"861808059", "四川省雅安市",
"861506631", "山东省威海市",
"86150780", "广西玉林市",
"861550669", "山东省聊城市",
"861329083", "福建省莆田市",
"861302725", "江西省九江市",
"861566247", "山东省潍坊市",
"861318866", "辽宁省铁岭市",
"861561985", "陕西省延安市",
"861336310", "河北省邯郸市",
"861865059", "福建省泉州市",
"861320509", "福建省泉州市",
"861304493", "江西省上饶市",
"861776135", "四川省遂宁市",
"861878493", "四川省广元市",
"86152019", "上海市",
"86189017", "上海市",
"86151254", "云南省昭通市",
"861893384", "广东省揭阳市",
"861831326", "云南省普洱市",
"861313650", "浙江省湖州市",
"861890889", "云南省昆明市",
"861707835", "云南省大理白族自治州",
"861514541", "黑龙江省齐齐哈尔市",
"861313931", "甘肃省兰州市",
"861377461", "福建省福州市",
"861823820", "河南省开封市",
"861811283", "江苏省镇江市",
"861800606", "福建省漳州市",
"86136230", "广东省汕头市",
"861840979", "青海省海西蒙古族藏族自治州",
"861390842", "湖南省邵阳市",
"861886542", "山东省青岛市",
"861576837", "广东省湛江市",
"861593449", "山西省朔州市",
"861892337", "广东省珠海市",
"861590747", "湖南省永州市",
"861846404", "山东省菏泽市",
"861591292", "云南省楚雄彝族自治州",
"86187993", "新疆和田地区",
"861363896", "西藏那曲地区",
"86158151", "广东省汕头市",
"861318944", "广东省江门市",
"861351994", "新疆伊犁哈萨克自治州",
"861598310", "四川省宜宾市",
"861707392", "河南省鹤壁市",
"86155309", "河北省邢台市",
"861587375", "湖南省邵阳市",
"861380935", "甘肃省武威市",
"861333856", "福建省泉州市",
"861334529", "山东省泰安市",
"86159728", "湖北省黄冈市",
"861319262", "广东省云浮市",
"861538673", "山西省阳泉市",
"861338936", "甘肃省兰州市",
"861857763", "广西柳州市",
"861850785", "广西贵港市",
"86135979", "湖北省荆门市",
"861573565", "山西省太原市",
"861803657", "江苏省连云港市",
"861570764", "广东省清远市",
"861332377", "河南省南阳市",
"861473678", "云南省西双版纳傣族自治州",
"861319403", "福建省宁德市",
"861333861", "江苏省南京市",
"861381544", "江苏省南京市",
"861572580", "山东省淄博市",
"861380380", "河南省新乡市",
"861343727", "湖北省武汉市",
"861529280", "新疆和田地区",
"861587152", "湖北省鄂州市",
"86151891", "江苏省镇江市",
"861340429", "江苏省南通市",
"861808671", "江苏省苏州市",
"86138471", "内蒙古呼和浩特市",
"86131539", "山东省临沂市",
"861326300", "江西省南昌市",
"861700791", "江西省南昌市",
"861890901", "四川省绵阳市",
"861530702", "江西省九江市",
"86137267", "广东省广州市",
"861325554", "山东省烟台市",
"86157115", "福建省厦门市",
"861899106", "陕西省榆林市",
"86131985", "四川省成都市",
"861318851", "辽宁省葫芦岛市",
"861868254", "四川省遂宁市",
"861510758", "广东省肇庆市",
"861536426", "湖南省衡阳市",
"861308149", "山东省威海市",
"86182962", "江西省九江市",
"86180967", "安徽省阜阳市",
"861805254", "江苏省常州市",
"861824431", "四川省眉山市",
"861454400", "福建省福州市",
"861312361", "贵州省贵阳市",
"861347736", "湖北省荆门市",
"861594973", "山东省淄博市",
"861575466", "黑龙江省黑河市",
"861360052", "浙江省杭州市",
"861768128", "安徽省淮南市",
"861595787", "浙江省宁波市",
"861840710", "湖北省襄樊市",
"861358791", "浙江省湖州市",
"861311741", "湖南省长沙市",
"86155900", "吉林省长春市",
"861596936", "云南省丽江市",
"861335306", "广东省汕头市",
"861363078", "吉林省松原市",
"861889959", "新疆石河子市",
"861860360", "黑龙江省哈尔滨市",
"861369806", "江西省赣州市",
"86133013", "北京市",
"86184438", "吉林省松原市",
"8613976", "海南省海口市",
"861319572", "青海省海西蒙古族藏族自治州",
"861894920", "安徽省巢湖市",
"861332746", "山西省太原市",
"861373826", "浙江省嘉兴市",
"861866676", "广东省云浮市",
"861329583", "浙江省嘉兴市",
"861372283", "河北省衡水市",
"861364310", "河北省邯郸市",
"861520532", "山东省青岛市",
"861571406", "辽宁省大连市",
"861835599", "安徽省黄山市",
"861587589", "广东省茂名市",
"861818826", "贵州省六盘水市",
"861341573", "广东省佛山市",
"861802765", "广东省深圳市",
"861533145", "云南省红河哈尼族彝族自治州",
"861801345", "江苏省泰州市",
"86151204", "甘肃省平凉市",
"861560416", "辽宁省锦州市",
"861301072", "江西省南昌市",
"861707319", "河北省石家庄市",
"861834430", "广东省广州市",
"861814780", "内蒙古巴彦淖尔市",
"86153828", "广东省东莞市",
"861307950", "宁夏银川市",
"861503041", "河北省邯郸市",
"861598301", "四川省泸州市",
"861315449", "四川省德阳市",
"861537310", "河北省邯郸市",
"861868423", "吉林省吉林市",
"86159930", "河南省新乡市",
"861323860", "云南省昭通市",
"861877421", "湖南省衡阳市",
"861539281", "湖北省仙桃市",
"861815482", "新疆乌鲁木齐市",
"861581925", "广东省河源市",
"861572907", "河南省焦作市",
"861520799", "江西省萍乡市",
"861781705", "广东省广州市",
"861595493", "山东省聊城市",
"861595931", "福建省宁德市",
"861452342", "河南省洛阳市",
"861893477", "广西桂林市",
"86139628", "江苏省南通市",
"861890779", "广西北海市",
"861576709", "广东省惠州市",
"861328656", "广东省清远市",
"86155359", "山西省运城市",
"861508034", "福建省厦门市",
"861576461", "黑龙江省哈尔滨市",
"861569888", "辽宁省大连市",
"861565034", "山东省淄博市",
"861550576", "浙江省台州市",
"861898451", "贵州省黔东南苗族侗族自治州",
"861821903", "广东省河源市",
"861450421", "辽宁省朝阳市",
"861539417", "陕西省宝鸡市",
"861780850", "贵州省贵阳市",
"861776929", "湖南省永州市",
"861535421", "河北省石家庄市",
"861568960", "山东省临沂市",
"86158173", "广东省深圳市",
"861825144", "江苏省盐城市",
"861535388", "陕西省榆林市",
"861510813", "四川省资阳市",
"861330813", "四川省乐山市",
"861315421", "辽宁省朝阳市",
"861319417", "辽宁省营口市",
"861380526", "江苏省泰州市",
"861389946", "新疆和田地区",
"861380141", "江苏省盐城市",
"861880066", "江苏省淮安市",
"86138148", "江苏省苏州市",
"861390357", "山西省临汾市",
"861359788", "湖北省十堰市",
"861525148", "江苏省徐州市",
"861826637", "山东省枣庄市",
"861865156", "江苏省无锡市",
"861347408", "陕西省咸阳市",
"861355814", "广西南宁市",
"861319281", "广东省惠州市",
"861815837", "浙江省金华市",
"861522004", "广东省广州市",
"861374038", "河南省郑州市",
"861808038", "四川省眉山市",
"861479972", "新疆乌鲁木齐市",
"861305644", "四川省达州市",
"861586419", "山东省德州市",
"861478044", "四川省成都市",
"861535449", "河北省石家庄市",
"86131828", "江苏省南京市",
"861322794", "陕西省咸阳市",
"861453747", "湖南省衡阳市",
"861366541", "山东省济南市",
"86187328", "河北省衡水市",
"861334041", "福建省福州市",
"8615223", "重庆市",
"861880679", "浙江省金华市",
"861363950", "宁夏银川市",
"861816451", "浙江省舟山市",
"86188329", "河北省邢台市",
"86184826", "四川省广安市",
"861346744", "湖南省张家界市",
"861826190", "江苏省盐城市",
"861457100", "江苏省盐城市",
"861314247", "内蒙古巴彦淖尔市",
"861760814", "四川省达州市",
"861521740", "广东省佛山市",
"861523666", "河南省洛阳市",
"861333990", "湖北省黄石市",
"861877449", "湖南省邵阳市",
"861763319", "河北省邢台市",
"861810336", "河北省廊坊市",
"861539572", "浙江省湖州市",
"861817633", "广西桂林市",
"861538298", "广东省清远市",
"861329889", "吉林省四平市",
"86130912", "河北省保定市",
"86134703", "辽宁省阜新市",
"86134771", "湖北省宜昌市",
"861333772", "江苏省南京市",
"86132917", "浙江省温州市",
"86139461", "黑龙江省哈尔滨市",
"861350057", "安徽省淮南市",
"861869393", "甘肃省兰州市",
"861768955", "西藏昌都地区",
"861340441", "吉林省白城市",
"86180840", "重庆市",
"861580865", "云南省玉溪市",
"861822416", "四川省雅安市",
"86137440", "吉林省长春市",
"861587883", "广西河池市",
"86136736", "河南省郑州市",
"861891942", "甘肃省酒泉市",
"861323991", "新疆乌鲁木齐市",
"861810754", "广东省汕头市",
"861568258", "四川省凉山彝族自治州",
"861372769", "广东省汕头市",
"861323433", "吉林省延边朝鲜族自治州",
"861802363", "广东省肇庆市",
"861813555", "山西省长治市",
"861811410", "江苏省无锡市",
"861890083", "广东省湛江市",
"861360798", "江西省景德镇市",
"861339911", "陕西省延安市",
"861881835", "广东省潮州市",
"861363445", "吉林省通化市",
"861532361", "广东省珠海市",
"861376967", "云南省曲靖市",
"861899817", "广东省珠海市",
"861862532", "河南省驻马店市",
"86181116", "四川省成都市",
"861769302", "甘肃省定西市",
"861347192", "广西玉林市",
"861538851", "山西省太原市",
"861853399", "河北省唐山市",
"861870768", "广东省揭阳市",
"86153985", "云南省昆明市",
"861395153", "江苏省宿迁市",
"86177122", "江苏省南通市",
"861310702", "湖南省株洲市",
"86188738", "湖南省娄底市",
"86145039", "辽宁省沈阳市",
"861479790", "江西省新余市",
"86150286", "河北省沧州市",
"861358207", "河北省保定市",
"861888210", "四川省资阳市",
"861882440", "广东省湛江市",
"861472914", "陕西省西安市",
"861821917", "广东省深圳市",
"86156535", "山东省烟台市",
"861311729", "湖北省宜昌市",
"861880551", "安徽省合肥市",
"861513861", "河南省南阳市",
"861479462", "黑龙江省齐齐哈尔市",
"86150835", "江西省南昌市",
"861709932", "浙江省温州市",
"861539403", "甘肃省甘南藏族自治州",
"861308546", "湖南省湘西土家族苗族自治州",
"861575697", "四川省甘孜藏族自治州",
"861572913", "河南省鹤壁市",
"861365546", "山东省东营市",
"861809401", "福建省福州市",
"86187739", "湖南省邵阳市",
"861571738", "湖南省娄底市",
"861308121", "辽宁省鞍山市",
"861318673", "浙江省衢州市",
"861539262", "山西省太原市",
"861815461", "广西南宁市",
"861337235", "浙江省台州市",
"861320106", "新疆哈密地区",
"861513856", "河南省商丘市",
"861339587", "浙江省温州市",
"861823047", "河北省沧州市",
"861880566", "安徽省池州市",
"86132533", "河南省郑州市",
"86184857", "贵州省毕节地区",
"861586492", "山东省聊城市",
"861380026", "湖北省武汉市",
"861859309", "甘肃省兰州市",
"861522504", "河南省平顶山市",
"861576482", "内蒙古兴安盟",
"861573948", "新疆喀什地区",
"861581536", "广东省惠州市",
"861452857", "甘肃省兰州市",
"861595145", "江苏省宿迁市",
"861457111", "湖北省武汉市",
"861301417", "甘肃省武威市",
"86156380", "河南省周口市",
"861533931", "甘肃省兰州市",
"861359878", "河南省开封市",
"861334541", "新疆昌吉回族自治州",
"861594644", "黑龙江省七台河市",
"861869774", "河南省信阳市",
"861397170", "湖北省黄冈市",
"861360586", "浙江省台州市",
"861328238", "浙江省温州市",
"861334126", "山东省淄博市",
"861850147", "江苏省南通市",
"861563453", "山东省济宁市",
"861816976", "广西北海市",
"861563690", "黑龙江省绥化市",
"861773050", "河北省唐山市",
"86185121", "上海市",
"861580647", "山东省潍坊市",
"86178397", "河南省信阳市",
"861593388", "河北省邯郸市",
"861567126", "湖北省襄樊市",
"861539072", "江西省赣州市",
"861559459", "陕西省榆林市",
"861532356", "广东省肇庆市",
"861803933", "河南省郑州市",
"861577477", "内蒙古鄂尔多斯市",
"861780996", "新疆巴音郭楞蒙古自治州",
"861831907", "广东省广州市",
"861562184", "山东省枣庄市",
"861302916", "吉林省吉林市",
"861509685", "云南省红河哈尼族彝族自治州",
"86139062", "江苏省苏州市",
"86180916", "陕西省汉中市",
"861888201", "四川省自贡市",
"861508627", "贵州省铜仁地区",
"861376893", "广西柳州市",
"861806595", "福建省泉州市",
"861475646", "河北省廊坊市",
"861840297", "陕西省渭南市",
"861322373", "河南省新乡市",
"861830344", "山西省晋中市",
"861596525", "山东省聊城市",
"861378055", "河北省唐山市",
"86186732", "湖南省湘潭市",
"861305830", "广东省佛山市",
"861375191", "广东省汕尾市",
"861526028", "福建省莆田市",
"86139791", "江西省南昌市",
"861898697", "湖北省荆门市",
"861833849", "河南省濮阳市",
"861350557", "安徽省宿州市",
"861819743", "青海省黄南藏族自治州",
"861475249", "江苏省宿迁市",
"861511351", "广东省汕尾市",
"861327528", "江苏省南通市",
"861324540", "山东省济南市",
"861809410", "福建省泉州市",
"861510592", "福建省莆田市",
"861320803", "浙江省杭州市",
"861890583", "浙江省嘉兴市",
"86156636", "黑龙江省哈尔滨市",
"861310348", "山西省运城市",
"861827068", "江西省九江市",
"861772614", "湖南省衡阳市",
"861816466", "云南省保山市",
"861834997", "四川省自贡市",
"861567823", "广西来宾市",
"861370728", "湖北省十堰市",
"861708557", "安徽省阜阳市",
"861560508", "福建省福州市",
"861811401", "江苏省南京市",
"86139289", "广东省广州市",
"861889938", "新疆克拉玛依市",
"861342245", "广东省珠海市",
"861827278", "河南省南阳市",
"861394891", "内蒙古呼和浩特市",
"861864957", "山西省临汾市",
"861700480", "福建省泉州市",
"861339900", "新疆克拉玛依市",
"861329779", "广西柳州市",
"861776854", "江苏省扬州市",
"861812349", "四川省成都市",
"861510739", "湖南省邵阳市",
"861309729", "江西省九江市",
"861333882", "江苏省南通市",
"86137216", "河南省洛阳市",
"861533787", "湖南省怀化市",
"86156861", "陕西省咸阳市",
"861308046", "河北省石家庄市",
"861530489", "黑龙江省大庆市",
"861348804", "陕西省榆林市",
"861808161", "四川省凉山彝族自治州",
"86188920", "陕西省西安市",
"861338525", "湖北省荆门市",
"861338918", "陕西省西安市",
"86130726", "河南省新乡市",
"86155358", "山西省吕梁市",
"861335542", "山东省青岛市",
"861890812", "四川省广元市",
"861518206", "四川省巴中市",
"861569898", "辽宁省丹东市",
"861508358", "江西省赣州市",
"861876042", "福建省福州市",
"861771228", "江苏省扬州市",
"861353670", "广东省梅州市",
"861881356", "广东省清远市",
"861322895", "西藏昌都地区",
"861350806", "四川省广元市",
"861571925", "陕西省渭南市",
"861859360", "福建省漳州市",
"861518609", "贵州省毕节地区",
"861535398", "陕西省延安市",
"86157101", "上海市",
"861352376", "河南省信阳市",
"861786929", "云南省迪庆藏族自治州",
"861815492", "新疆乌鲁木齐市",
"861770850", "贵州省贵阳市",
"861520789", "广西北海市",
"861587012", "贵州省遵义市",
"861346845", "山东省烟台市",
"861587732", "陕西省西安市",
"86139629", "江苏省南通市",
"861373914", "江苏省南通市",
"861339479", "内蒙古锡林郭勒盟",
"86150525", "江苏省扬州市",
"861865408", "安徽省宿州市",
"861341188", "广东省深圳市",
"86152652", "山东省青岛市",
"861309128", "河北省邢台市",
"861814790", "内蒙古锡林郭勒盟",
"861347038", "辽宁省辽阳市",
"861510138", "甘肃省金昌市",
"861512965", "陕西省西安市",
"86150657", "山东省烟台市",
"861327915", "陕西省渭南市",
"861803462", "甘肃省平凉市",
"861859004", "陕西省宝鸡市",
"86132702", "江苏省徐州市",
"861459105", "广西柳州市",
"861372293", "河北省邢台市",
"861329593", "福建省莆田市",
"861470467", "黑龙江省鸡西市",
"861700937", "江苏省徐州市",
"861811168", "四川省甘孜藏族自治州",
"861869785", "青海省果洛藏族自治州",
"86133075", "海南省海口市",
"86130707", "山东省潍坊市",
"861596918", "云南省西双版纳傣族自治州",
"861355715", "广西玉林市",
"86182756", "贵州省遵义市",
"861390455", "黑龙江省绥化市",
"861319707", "湖北省黄冈市",
"861534368", "甘肃省天水市",
"861504980", "内蒙古巴彦淖尔市",
"861510561", "安徽省淮北市",
"861513507", "山西省朔州市",
"861351367", "山西省大同市",
"861470977", "青海省海西蒙古族藏族自治州",
"861585466", "山东省滨州市",
"861800958", "宁夏银川市",
"861550888", "云南省丽江市",
"861332048", "云南省西双版纳傣族自治州",
"861331943", "江西省南昌市",
"861809031", "四川省内江市",
"861569576", "浙江省台州市",
"861356949", "河南省许昌市",
"861476505", "北京市",
"861591638", "广东省惠州市",
"861335104", "黑龙江省双鸭山市",
"86184439", "吉林省白山市",
"861809711", "青海省西宁市",
"861510314", "河北省承德市",
"861560438", "吉林省松原市",
"861399520", "宁夏银川市",
"861539033", "四川省雅安市",
"861879959", "新疆和田地区",
"861824983", "黑龙江省佳木斯市",
"861890668", "浙江省宁波市",
"861812044", "湖北省武汉市",
"861513819", "河南省三门峡市",
"861504819", "内蒙古包头市",
"861883298", "河北省唐山市",
"861502612", "新疆克拉玛依市",
"861452506", "山东省日照市",
"861310412", "辽宁省鞍山市",
"861815108", "江苏省苏州市",
"861811531", "江苏省南通市",
"861398905", "西藏昌都地区",
"861375162", "广东省阳江市",
"861810855", "贵州省黔东南苗族侗族自治州",
"861835152", "江苏省宿迁市",
"861529290", "新疆喀什地区",
"861572590", "山东省济宁市",
"861380390", "河南省平顶山市",
"861583565", "山西省大同市",
"861530577", "浙江省温州市",
"861580764", "广东省清远市",
"861381321", "江苏省盐城市",
"86131538", "山东省泰安市",
"861302959", "内蒙古乌海市",
"861586971", "湖南省株洲市",
"861700781", "广东省汕头市",
"861339969", "安徽省合肥市",
"861865192", "江苏省镇江市",
"86137471", "内蒙古呼和浩特市",
"861392266", "广东省云浮市",
"86180871", "云南省昆明市",
"861334605", "浙江省绍兴市",
"861856982", "河南省焦作市",
"86186503", "福建省福州市",
"861853448", "山西省吕梁市",
"86186571", "浙江省杭州市",
"861594767", "内蒙古赤峰市",
"86137403", "广东省清远市",
"86138267", "广东省云浮市",
"861850795", "江西省宜春市",
"86180803", "四川省南充市",
"861394862", "内蒙古兴安盟",
"86184536", "山东省潍坊市",
"86134740", "陕西省西安市",
"861370380", "河南省驻马店市",
"861582580", "甘肃省天水市",
"861363347", "山西省太原市",
"861478349", "河南省南阳市",
"86180722", "浙江省绍兴市",
"861330159", "江苏省南京市",
"861529703", "青海省黄南藏族自治州",
"861869875", "辽宁省阜新市",
"86155308", "河北省唐山市",
"861707382", "河南省洛阳市",
"861335042", "四川省雅安市",
"861359320", "山西省忻州市",
"86159729", "湖北省武汉市",
"861876542", "山东省青岛市",
"861858243", "四川省乐山市",
"861852413", "辽宁省抚顺市",
"861471555", "广东省江门市",
"861587512", "广东省韶关市",
"86150626", "江苏省苏州市",
"861505618", "安徽省淮北市",
"86157151", "江苏省南京市",
"86139425", "辽宁省丹东市",
"861760535", "山东省烟台市",
"861822459", "河南省新乡市",
"861889725", "青海省果洛藏族自治州",
"861555848", "浙江省台州市",
"861392251", "广东省东莞市",
"861558150", "湖南省邵阳市",
"861347538", "山东省泰安市",
"861314422", "广东省江门市",
"861304483", "湖北省恩施土家族苗族自治州",
"861333733", "湖南省株洲市",
"861319839", "四川省攀枝花市",
"86152018", "上海市",
"86150607", "福建省厦门市",
"861520879", "云南省普洱市",
"861301707", "贵州省六盘水市",
"861323472", "内蒙古包头市",
"861501802", "广东省中山市",
"861809168", "陕西省渭南市",
"861303422", "浙江省温州市",
"861313483", "内蒙古阿拉善盟",
"86158610", "江苏省泰州市",
"861816750", "新疆阿克苏地区",
"861890899", "西藏拉萨市",
"861510556", "安徽省安庆市",
"861768741", "广西南宁市",
"861320458", "黑龙江省伊春市",
"861301315", "安徽省铜陵市",
"861311128", "山西省大同市",
"861507680", "河北省沧州市",
"861376589", "贵州省毕节地区",
"86185660", "广东省佛山市",
"861859504", "宁夏固原市",
"861867217", "湖北省荆门市",
"861761298", "陕西省榆林市",
"861862573", "河南省周口市",
"861815419", "安徽省六安市",
"861843463", "山西省晋城市",
"861329093", "福建省福州市",
"861345870", "四川省泸州市",
"86130757", "浙江省温州市",
"861865119", "江苏省宿迁市",
"861521635", "山东省聊城市",
"861569076", "河南省商丘市",
"861505862", "浙江省台州市",
"861476005", "福建省宁德市",
"861537122", "江苏省盐城市",
"861831237", "广东省河源市",
"861362454", "黑龙江省佳木斯市",
"86147849", "广东省广州市",
"861780952", "宁夏石嘴山市",
"861332494", "云南省大理白族自治州",
"861513007", "河北省石家庄市",
"861347161", "广西河池市",
"86184635", "山东省聊城市",
"861361428", "辽宁省大连市",
"861814203", "浙江省宁波市",
"861332548", "陕西省西安市",
"861886306", "山东省威海市",
"861340740", "湖南省郴州市",
"861348705", "湖北省黄冈市",
"861811031", "安徽省马鞍山市",
"861390628", "江苏省南通市",
"861328908", "新疆克孜勒苏柯尔克孜自治州",
"861812498", "广东省中山市",
"861817672", "广西柳州市",
"861557949", "江西省赣州市",
"861776755", "新疆喀什地区",
"861330582", "浙江省湖州市",
"861561643", "湖南省常德市",
"861875122", "江苏省连云港市",
"861820665", "广东省汕头市",
"86159338", "河北省衡水市",
"861830549", "山东省临沂市",
"861881361", "广东省湛江市",
"861532835", "四川省自贡市",
"861454297", "辽宁省阜新市",
"861809700", "青海省海北藏族自治州",
"861589642", "江苏省徐州市",
"861572090", "江西省抚州市",
"861839929", "新疆喀什地区",
"861778188", "四川省宜宾市",
"861586456", "山东省潍坊市",
"861310499", "广东省茂名市",
"861550778", "广西河池市",
"861569266", "西藏那曲地区",
"861313797", "河南省三门峡市",
"861479491", "内蒙古呼和浩特市",
"86134532", "山西省晋中市",
"861323503", "福建省漳州市",
"861304797", "江西省赣州市",
"861882741", "湖北省武汉市",
"861580331", "河北省石家庄市",
"861897284", "湖北省咸宁市",
"86186553", "安徽省芜湖市",
"861770677", "浙江省温州市",
"861453195", "山西省晋城市",
"86137453", "黑龙江省牡丹江市",
"86188474", "内蒙古乌兰察布市",
"86180853", "贵州省安顺市",
"861336457", "吉林省白城市",
"861898035", "四川省攀枝花市",
"86137308", "四川省成都市",
"861882668", "广东省湛江市",
"861315956", "吉林省长春市",
"861860689", "浙江省金华市",
"861321417", "辽宁省营口市",
"86183841", "四川省成都市",
"861366497", "广东省阳江市",
"861705812", "陕西省西安市",
"86138309", "甘肃省陇南市",
"861354744", "四川省南充市",
"861357375", "山东省济南市",
"861550935", "甘肃省武威市",
"861309901", "山西省运城市",
"861768812", "广东省中山市",
"861514579", "黑龙江省鸡西市",
"861857042", "湖南省常德市",
"861321281", "黑龙江省哈尔滨市",
"861471983", "新疆石河子市",
"86134806", "广东省深圳市",
"861814047", "四川省资阳市",
"861867820", "山东省淄博市",
"861380076", "广东省中山市",
"86130533", "山东省淄博市",
"861864848", "内蒙古包头市",
"86184852", "贵州省遵义市",
"861581994", "广东省江门市",
"86177550", "安徽省滁州市",
"861804150", "辽宁省丹东市",
"861539022", "四川省泸州市",
"861362688", "浙江省绍兴市",
"86178392", "河南省郑州市",
"861590580", "浙江省舟山市",
"861567176", "湖北省黄石市",
"861380669", "浙江省温州市",
"861555340", "山东省德州市",
"861837535", "安徽省安庆市",
"861335831", "福建省漳州市",
"861839287", "陕西省西安市",
"861322916", "广东省惠州市",
"861529685", "广西玉林市",
"86187490", "河南省南阳市",
"861840941", "甘肃省甘南藏族自治州",
"86130890", "黑龙江省大庆市",
"861380266", "广东省中山市",
"861391442", "江苏省泰州市",
"861529366", "甘肃省甘南藏族自治州",
"861769619", "山西省大同市",
"86158370", "河南省商丘市",
"861772432", "广东省东莞市",
"861839411", "甘肃省甘南藏族自治州",
"861598457", "四川省攀枝花市",
"861360642", "山东省青岛市",
"861556589", "河南省漯河市",
"861816926", "湖南省常德市",
"861780534", "山东省德州市",
"861869724", "青海省西宁市",
"861304540", "黑龙江省佳木斯市",
"861787562", "广东省茂名市",
"861503651", "河南省焦作市",
"86136196", "云南省昆明市",
"861459069", "广东省潮州市",
"861705668", "北京市",
"861300803", "山西省临汾市",
"861524153", "辽宁省锦州市",
"86151265", "云南省临沧市",
"86131117", "河北省沧州市",
"86130045", "江苏省苏州市",
"86177156", "江苏省淮安市",
"861816313", "湖北省荆州市",
"861774257", "湖南省益阳市",
"861859699", "福建省南平市",
"861313540", "安徽省合肥市",
"861590907", "新疆阿克苏地区",
"86182916", "陕西省汉中市",
"861316951", "广东省东莞市",
"861366783", "广西桂林市",
"861863450", "山西省忻州市",
"861377949", "新疆喀什地区",
"861317691", "山东省烟台市",
"861517476", "内蒙古兴安盟",
"861894558", "黑龙江省七台河市",
"861872779", "湖北省咸宁市",
"861824055", "河南省南阳市",
"86186737", "湖南省益阳市",
"861596575", "山东省聊城市",
"861322323", "河北省保定市",
"86151681", "浙江省宁波市",
"861562209", "广东省湛江市",
"861877982", "江西省景德镇市",
"861309779", "广西北海市",
"861818752", "云南省昆明市",
"861850257", "江苏省常州市",
"861329729", "湖北省襄樊市",
"861855905", "福建省泉州市",
"861382455", "广东省梅州市",
"861338575", "浙江省绍兴市",
"861359934", "福建省龙岩市",
"861328046", "山东省聊城市",
"861472796", "陕西省汉中市",
"861889446", "甘肃省白银市",
"861452948", "广东省梅州市",
"861306295", "江苏省泰州市",
"861556152", "黑龙江省七台河市",
"861334873", "湖南省湘西土家族苗族自治州",
"86152561", "安徽省阜阳市",
"861847908", "江西省九江市",
"861595040", "江苏省无锡市",
"861370778", "广西河池市",
"861567873", "广西柳州市",
"861858892", "广东省广州市",
"861459676", "新疆阿克苏地区",
"861450982", "新疆塔城地区",
"861827228", "湖北省宜昌市",
"861886763", "浙江省宁波市",
"86135394", "广东省广州市",
"861535982", "福建省泉州市",
"86137358", "浙江省杭州市",
"861470542", "山东省青岛市",
"861568148", "四川省达州市",
"861848915", "西藏昌都地区",
"86176398", "河南省三门峡市",
"861853206", "河北省邯郸市",
"861479922", "新疆阿克苏地区",
"861364457", "黑龙江省哈尔滨市",
"861325644", "山东省济南市",
"861898535", "贵州省毕节地区",
"861351925", "宁夏中卫市",
"861570806", "西藏昌都地区",
"861453913", "广东省广州市",
"861872910", "陕西省西安市",
"861311901", "新疆塔城地区",
"861879794", "江西省抚州市",
"86181858", "贵州省六盘水市",
"861537457", "湖北省咸宁市",
"861572376", "广西百色市",
"861839400", "甘肃省兰州市",
"861315471", "内蒙古呼和浩特市",
"861889784", "广西柳州市",
"861869603", "湖北省十堰市",
"86138359", "山西省运城市",
"861367860", "山东省菏泽市",
"861515299", "江苏省泰州市",
"861514666", "黑龙江省齐齐哈尔市",
"86159433", "吉林省延边朝鲜族自治州",
"861554408", "河南省郑州市",
"861458518", "河南省洛阳市",
"861452294", "山西省晋中市",
"86187760", "广西南宁市",
"861876831", "浙江省嘉兴市",
"861806190", "江苏省无锡市",
"861801081", "安徽省宣城市",
"861323247", "广东省清远市",
"861890741", "湖南省株洲市",
"861530942", "甘肃省酒泉市",
"861599688", "江苏省徐州市",
"861880629", "江苏省南通市",
"86177500", "福建省泉州市",
"861501740", "广东省佛山市",
"861807131", "湖北省宜昌市",
"861877890", "广西玉林市",
"86189741", "湖南省株洲市",
"861845017", "福建省莆田市",
"861503385", "河北省邯郸市",
"861770358", "山西省吕梁市",
"861503666", "河南省商丘市",
"861539350", "甘肃省武威市",
"8618971", "湖北省武汉市",
"861532988", "贵州省遵义市",
"861537133", "江苏省扬州市",
"861335467", "云南省玉溪市",
"861780034", "河北省唐山市",
"861535890", "江苏省盐城市",
"86153560", "浙江省宁波市",
"861508850", "浙江省绍兴市",
"861858980", "广西南宁市",
"861369764", "山东省烟台市",
"8615023", "重庆市",
"861556089", "内蒙古包头市",
"861571367", "河南省郑州市",
"861529351", "甘肃省金昌市",
"861380251", "广东省广州市",
"861807568", "湖南省娄底市",
"861335977", "黑龙江省鹤岗市",
"86139131", "江苏省苏州市",
"861304040", "浙江省宁波市",
"861576949", "甘肃省陇南市",
"861459569", "陕西省延安市",
"861842045", "广东省深圳市",
"861327078", "江苏省泰州市",
"861457005", "山东省烟台市",
"861314433", "吉林省延边朝鲜族自治州",
"861333722", "湖南省湘潭市",
"861563311", "河北省石家庄市",
"861338265", "江苏省徐州市",
"86131299", "湖北省武汉市",
"861331407", "辽宁省营口市",
"86182840", "四川省广元市",
"861334783", "江苏省南京市",
"86138900", "四川省自贡市",
"861533827", "广东省中山市",
"861870337", "河北省沧州市",
"861572747", "湖南省株洲市",
"861896598", "福建省三明市",
"861303991", "黑龙江省大兴安岭地区",
"861338389", "河南省洛阳市",
"861865246", "江苏省无锡市",
"861380898", "山东省青岛市",
"861338075", "广东省肇庆市",
"861379416", "广东省中山市",
"861328546", "山东省东营市",
"861315961", "吉林省长春市",
"861829401", "甘肃省临夏回族自治州",
"861459430", "西藏日喀则地区",
"861537836", "四川省攀枝花市",
"861873623", "河南省周口市",
"861829769", "安徽省黄山市",
"861452620", "江苏省苏州市",
"861318623", "陕西省咸阳市",
"861596389", "山东省东营市",
"861308171", "辽宁省营口市",
"861809842", "安徽省淮北市",
"861365682", "浙江省舟山市",
"861314157", "江苏省宿迁市",
"861884692", "黑龙江省哈尔滨市",
"86155471", "内蒙古呼和浩特市",
"86155403", "内蒙古鄂尔多斯市",
"861897708", "广西南宁市",
"861707998", "浙江省嘉兴市",
"861332906", "安徽省安庆市",
"861589112", "陕西省榆林市",
"861840854", "贵州省黔南布依族苗族自治州",
"861551544", "河南省开封市",
"86157978", "江西省南昌市",
"861311779", "广西北海市",
"861357152", "陕西省渭南市",
"86152835", "四川省宜宾市",
"861386723", "浙江省舟山市",
"861454941", "福建省福州市",
"861881988", "广东省阳江市",
"86152626", "江苏省苏州市",
"861366832", "四川省绵阳市",
"861534517", "江苏省淮安市",
"861839701", "青海省西宁市",
"861599902", "新疆巴音郭楞蒙古自治州",
"861565986", "福建省泉州市",
"861566017", "河南省南阳市",
"861889775", "广西玉林市",
"861839469", "甘肃省天水市",
"861508986", "广东省韶关市",
"861882083", "广东省湛江市",
"861509703", "甘肃省金昌市",
"861780339", "河北省邢台市",
"861362273", "广东省揭阳市",
"861700543", "山东省烟台市",
"861869825", "辽宁省铁岭市",
"861556196", "黑龙江省牡丹江市",
"86180727", "浙江省杭州市",
"861554538", "黑龙江省鹤岗市",
"861453090", "山西省阳泉市",
"86158341", "山西省太原市",
"861373796", "广西河池市",
"861562939", "湖北省黄石市",
"861871998", "新疆和田地区",
"861876289", "江苏省苏州市",
"861709923", "浙江省嘉兴市",
"861598355", "四川省攀枝花市",
"861380611", "江苏省常州市",
"861472663", "四川省凉山彝族自治州",
"861534809", "甘肃省陇南市",
"861771568", "江苏省无锡市",
"861579878", "云南省楚雄彝族自治州",
"86180706", "广西梧州市",
"861366395", "河南省漯河市",
"861782887", "四川省达州市",
"861362063", "山西省阳泉市",
"861527680", "新疆克孜勒苏柯尔克孜自治州",
"86130752", "广东省惠州市",
"861336355", "山西省长治市",
"861781751", "广东省韶关市",
"86176866", "山东省济南市",
"86132757", "安徽省安庆市",
"861324483", "广东省广州市",
"86150018", "上海市",
"86150602", "福建省宁德市",
"86189455", "黑龙江省绥化市",
"861878615", "贵州省遵义市",
"861321707", "江西省赣州市",
"861304615", "广东省清远市",
"861523324", "河北省承德市",
"861501441", "广东省湛江市",
"86183870", "云南省昭通市",
"86152607", "福建省泉州市",
"861500879", "云南省丽江市",
"861357477", "湖南省衡阳市",
"861311593", "福建省宁德市",
"861890440", "吉林省长春市",
"861303472", "内蒙古通辽市",
"861521802", "广东省河源市",
"861503200", "河北省邯郸市",
"861354845", "四川省巴中市",
"861323422", "辽宁省朝阳市",
"861389508", "宁夏银川市",
"861772897", "广东省茂名市",
"861810912", "陕西省榆林市",
"86189609", "福建省福州市",
"861588490", "四川省广安市",
"861337343", "河北省张家口市",
"861524335", "河北省承德市",
"86145801", "江苏省苏州市",
"861330646", "山东省潍坊市",
"861390678", "浙江省丽水市",
"861705083", "福建省泉州市",
"861365908", "四川省南充市",
"861314962", "黑龙江省齐齐哈尔市",
"86145873", "广东省广州市",
"861588762", "云南省西双版纳傣族自治州",
"861330249", "广东省广州市",
"861700821", "贵州省贵阳市",
"861357967", "新疆哈密地区",
"861555191", "安徽省蚌埠市",
"861596084", "福建省厦门市",
"861800665", "浙江省宁波市",
"861570557", "安徽省宿州市",
"86136523", "广东省深圳市",
"8628", "四川省成都市\、资阳市\、眉山市",
"861501635", "广东省阳江市",
"86139414", "辽宁省本溪市",
"861829531", "宁夏银川市",
"861392141", "江苏省南京市",
"86187423", "辽宁省盘锦市",
"86130823", "河北省保定市",
"861524007", "安徽省宿州市",
"861569026", "河北省沧州市",
"861537681", "山东省淄博市",
"861361478", "内蒙古巴彦淖尔市",
"86135982", "河南省南阳市",
"861325767", "广东省茂名市",
"861890955", "宁夏中卫市",
"861310840", "四川省广元市",
"861550728", "湖北省十堰市",
"861788523", "贵州省黔南布依族苗族自治州",
"861841811", "甘肃省陇南市",
"86185639", "山东省青岛市",
"861558240", "山西省晋中市",
"861770627", "江苏省南通市",
"861303503", "安徽省滁州市",
"861324797", "江西省赣州市",
"861550205", "广东省中山市",
"861522296", "安徽省安庆市",
"86182853", "贵州省安顺市",
"86134537", "山西省临汾市",
"861892679", "广东省深圳市",
"861331537", "河北省秦皇岛市",
"861315992", "黑龙江省鹤岗市",
"861351518", "江苏省宿迁市",
"861327852", "吉林省四平市",
"861318414", "山东省青岛市",
"861893604", "江苏省南京市",
"86137584", "浙江省温州市",
"861862841", "陕西省渭南市",
"861459731", "湖南省长沙市",
"861829700", "青海省西宁市",
"86155216", "广东省湛江市",
"861839979", "新疆巴音郭楞蒙古自治州",
"861767344", "湖南省怀化市",
"861338084", "广东省汕尾市",
"861554161", "辽宁省锦州市",
"861566517", "江苏省宿迁市",
"861332236", "辽宁省朝阳市",
"861500789", "广西北海市",
"861534737", "湖南省益阳市",
"861352326", "河南省平顶山市",
"861339429", "辽宁省葫芦岛市",
"861589798", "湖北省襄樊市",
"861334832", "福建省莆田市",
"861332639", "山东省青岛市",
"861362902", "四川省自贡市",
"861870641", "山东省济南市",
"861369865", "山东省青岛市",
"861810999", "新疆伊犁哈萨克自治州",
"861868346", "四川省德阳市",
"86189770", "广西防城港市",
"86170799", "浙江省湖州市",
"86132726", "重庆市",
"86155149", "河南省商丘市",
"86177543", "山东省滨州市",
"86151844", "四川省成都市",
"861335365", "河南省安阳市",
"861317818", "福建省龙岩市",
"861335686", "山东省青岛市",
"861571975", "青海省西宁市",
"861353620", "广东省江门市",
"861522868", "四川省遂宁市",
"861399939", "新疆伊犁哈萨克自治州",
"861771278", "江苏省常州市",
"86130702", "广东省广州市",
"861364355", "山西省长治市",
"861879895", "西藏昌都地区",
"861363726", "安徽省六安市",
"86132707", "江苏省南京市",
"861830638", "山东省烟台市",
"861519441", "河南省洛阳市",
"861556477", "山东省莱芜市",
"86180756", "湖南省常德市",
"861832994", "陕西省西安市",
"86137088", "云南省昆明市",
"861334395", "河南省漯河市",
"861839710", "青海省西宁市",
"861316745", "江苏省南通市",
"861362563", "安徽省合肥市",
"86152525", "江苏省扬州市",
"861311093", "福建省厦门市",
"861889885", "广东省汕头市",
"861388645", "湖北省黄石市",
"86189405", "辽宁省朝阳市",
"861315880", "四川省自贡市",
"86150652", "山东省滨州市",
"861329128", "江苏省南京市",
"86158124", "广东省广州市",
"86152657", "山东省济宁市",
"861309178", "黑龙江省双鸭山市",
"861558555", "吉林省延边朝鲜族自治州",
"861841800", "甘肃省临夏回族自治州",
"861354667", "山西省长治市",
"861317753", "江西省新余市",
"861888827", "山东省泰安市",
"861781766", "广东省云浮市",
"861336172", "江西省九江市",
"861378983", "山东省东营市",
"861570057", "四川省广元市",
"861320675", "黑龙江省哈尔滨市",
"861705583", "广东省广州市",
"861806341", "山东省济南市",
"861300625", "江西省上饶市",
"861317662", "山东省东营市",
"861512425", "辽宁省葫芦岛市",
"861871244", "安徽省六安市",
"861551349", "山西省运城市",
"861560946", "甘肃省庆阳市",
"861536343", "广东省佛山市",
"861514793", "内蒙古巴彦淖尔市",
"861840755", "广东省深圳市",
"861787591", "广东省深圳市",
"861820958", "宁夏银川市",
"861450608", "吉林省白山市",
"861760697", "云南省昆明市",
"861556967", "甘肃省平凉市",
"861786530", "山东省菏泽市",
"861475758", "浙江省绍兴市",
"86185986", "重庆市",
"861847682", "广东省湛江市",
"861388431", "浙江省舟山市",
"861479547", "广西南宁市",
"861847171", "湖北省宜昌市",
"861569526", "江苏省南通市",
"861894782", "内蒙古兴安盟",
"861388993", "广东省佛山市",
"861534981", "安徽省安庆市",
"86138262", "广东省广州市",
"86138943", "吉林省延边朝鲜族自治州",
"861895480", "山东省枣庄市",
"86182871", "云南省昆明市",
"861347649", "湖北省孝感市",
"86182803", "四川省成都市",
"861459364", "贵州省黔南布依族苗族自治州",
"861394749", "内蒙古阿拉善盟",
"861331037", "内蒙古通辽市",
"861563285", "河北省衡水市",
"86150514", "江苏省苏州市",
"861560864", "湖北省武汉市",
"861571465", "黑龙江省伊春市",
"86185435", "吉林省通化市",
"861563369", "河北省石家庄市",
"861530527", "江苏省扬州市",
"861598172", "新疆伊犁哈萨克自治州",
"861786469", "山东省威海市",
"861331305", "河北省唐山市",
"861598681", "广东省深圳市",
"861338584", "浙江省宁波市",
"861383444", "山西省朔州市",
"861348568", "安徽省阜阳市",
"861459511", "云南省临沧市",
"861870435", "吉林省通化市",
"86183684", "浙江省宁波市",
"861322959", "广东省惠州市",
"86188581", "浙江省杭州市",
"861351738", "湖南省娄底市",
"861586921", "浙江省丽水市",
"861474581", "黑龙江省哈尔滨市",
"861589086", "河南省南阳市",
"861583342", "河北省保定市",
"861562260", "广东省清远市",
"861358245", "河北省秦皇岛市",
"861550472", "内蒙古包头市",
"861870933", "甘肃省平凉市",
"861594906", "江苏省扬州市",
"86155164", "河南省新乡市",
"861845026", "福建省厦门市",
"861535142", "四川省巴中市",
"861350374", "河南省许昌市",
"86135318", "广东省中山市",
"861471964", "甘肃省武威市",
"861572068", "江苏省无锡市",
"86158679", "浙江省金华市",
"861770659", "浙江省台州市",
"861877142", "湖北省随州市",
"861806842", "江苏省苏州市",
"861770256", "江苏省连云港市",
"861301197", "河北省秦皇岛市",
"861452188", "吉林省松原市",
"861880328", "河北省衡水市",
"861335373", "河南省新乡市",
"861396606", "安徽省蚌埠市",
"861571963", "甘肃省平凉市",
"861310538", "山东省泰安市",
"861821466", "云南省保山市",
"861708374", "河南省许昌市",
"861538209", "辽宁省沈阳市",
"861787535", "广东省汕尾市",
"86130617", "上海市",
"861371719", "广东省东莞市",
"861533113", "辽宁省鞍山市",
"86183392", "河南省郑州市",
"861388495", "山东省青岛市",
"861560512", "江苏省连云港市",
"861324330", "河南省信阳市",
"861362575", "浙江省绍兴市",
"861500948", "甘肃省酒泉市",
"861829095", "新疆吐鲁番地区",
"86138600", "福建省南平市",
"861899598", "湖北省武汉市",
"861830534", "山东省德州市",
"861360461", "黑龙江省齐齐哈尔市",
"861360709", "江西省南昌市",
"86158750", "广东省江门市",
"861471846", "广东省揭阳市",
"861387199", "湖北省黄冈市",
"861570529", "江苏省镇江市",
"86181211", "上海市",
"861502982", "陕西省榆林市",
"861319476", "四川省眉山市",
"861519691", "四川省遂宁市",
"861361722", "湖北省随州市",
"861301951", "内蒙古呼伦贝尔市",
"861854659", "黑龙江省大庆市",
"861853308", "河北省石家庄市",
"861529193", "陕西省渭南市",
"861571502", "福建省宁德市",
"86189343", "广东省佛山市",
"861520436", "吉林省白城市",
"861450504", "吉林省延边朝鲜族自治州",
"861346314", "河北省承德市",
"861856868", "河南省开封市",
"861306910", "吉林省长春市",
"861479169", "陕西省咸阳市",
"86180524", "江苏省苏州市",
"861760447", "吉林省辽源市",
"861770571", "浙江省杭州市",
"861520857", "贵州省毕节地区",
"861310161", "黑龙江省哈尔滨市",
"861453228", "浙江省金华市",
"861773480", "河南省郑州市",
"86186824", "广东省深圳市",
"861810046", "内蒙古呼和浩特市",
"861559089", "黑龙江省哈尔滨市",
"861320663", "黑龙江省齐齐哈尔市",
"861327685", "浙江省绍兴市",
"861375411", "内蒙古呼和浩特市",
"861394988", "河南省漯河市",
"861327366", "河北省邢台市",
"861550503", "安徽省六安市",
"861821976", "甘肃省白银市",
"861346561", "山东省烟台市",
"861557828", "广西南宁市",
"861317740", "湖北省咸宁市",
"8618621", "上海市",
"861314728", "湖北省十堰市",
"861840672", "广西梧州市",
"861877504", "广西梧州市",
"861334331", "河北省石家庄市",
"861599120", "陕西省榆林市",
"861390074", "湖南省岳阳市",
"86133233", "天津市",
"861323778", "广西河池市",
"861354221", "广东省揭阳市",
"861854571", "黑龙江省七台河市",
"861899876", "广东省河源市",
"861839848", "四川省凉山彝族自治州",
"861886784", "浙江省丽水市",
"86131383", "广东省惠州市",
"86187883", "云南省临沧市",
"86130483", "重庆市",
"861866603", "广东省汕尾市",
"861390264", "广东省东莞市",
"861837903", "江西省新余市",
"861345051", "广东省阳江市",
"861820704", "江西省宜春市",
"861576052", "四川省绵阳市",
"861372190", "山东省济宁市",
"861571473", "内蒙古乌海市",
"861550962", "宁夏石嘴山市",
"861533816", "广东省珠海市",
"861319844", "四川省达州市",
"861869241", "湖南省株洲市",
"861575903", "福建省龙岩市",
"861809637", "四川省成都市",
"861347499", "内蒙古包头市",
"861583523", "山西省阳泉市",
"86797", "江西省赣州市",
"86138155", "江苏省盐城市",
"861471474", "广东省湛江市",
"861812719", "广东省云浮市",
"86138779", "广西北海市",
"861812039", "湖北省潜江市",
"861560599", "福建省南平市",
"861339836", "四川省绵阳市",
"861302977", "黑龙江省双鸭山市",
"861319197", "河北省廊坊市",
"861853742", "河南省三门峡市",
"86136010", "北京市",
"861530559", "安徽省黄山市",
"861308336", "安徽省亳州市",
"8613714", "广东省深圳市",
"861365336", "河北省秦皇岛市",
"861889763", "广西柳州市",
"861370247", "广东省湛江市",
"861459795", "新疆巴音郭楞蒙古自治州",
"86180028", "广东省东莞市",
"861454633", "宁夏石嘴山市",
"86151981", "四川省成都市",
"861883070", "河北省沧州市",
"861815086", "福建省宁德市",
"861816917", "宁夏固原市",
"86158475", "内蒙古通辽市",
"861708487", "河南省信阳市",
"861326729", "广东省东莞市",
"86187395", "河南省漯河市",
"86131895", "广东省茂名市",
"861572568", "山东省枣庄市",
"861380368", "黑龙江省鹤岗市",
"861529268", "新疆和田地区",
"861700322", "河北省保定市",
"86137778", "浙江省杭州市",
"861822893", "四川省遂宁市",
"861472675", "四川省资阳市",
"861362389", "河南省洛阳市",
"86182616", "江苏省苏州市",
"861321426", "辽宁省沈阳市",
"861362075", "吉林省吉林市",
"861848290", "四川省成都市",
"861319630", "陕西省咸阳市",
"86189080", "四川省成都市",
"861560732", "湖南省湘潭市",
"861310156", "黑龙江省哈尔滨市",
"86138650", "安徽省蚌埠市",
"861369783", "山东省东营市",
"861458423", "河南省安阳市",
"861310038", "湖南省郴州市",
"861890453", "黑龙江省牡丹江市",
"861890690", "福建省福州市",
"861509028", "河南省许昌市",
"861518811", "云南省曲靖市",
"861529078", "河南省平顶山市",
"861843425", "山西省长治市",
"861310718", "湖南省娄底市",
"861860388", "河南省周口市",
"86152712", "湖北省咸宁市",
"861861490", "河南省平顶山市",
"86170921", "上海市",
"861860421", "辽宁省朝阳市",
"861778506", "贵州省铜仁地区",
"861882369", "广东省河源市",
"861338232", "江苏省淮安市",
"86150717", "湖北省宜昌市",
"861771664", "贵州省遵义市",
"86189237", "广东省深圳市",
"861350487", "黑龙江省鹤岗市",
"861771195", "西藏昌都地区",
"861879977", "新疆伊犁哈萨克自治州",
"861831693", "广东省佛山市",
"861830714", "湖北省黄石市",
"861334764", "广西梧州市",
"861810546", "山东省东营市",
"861534390", "河南省信阳市",
"861356828", "四川省甘孜藏族自治州",
"861337522", "江苏省淮安市",
"861819926", "新疆昌吉回族自治州",
"861800673", "浙江省嘉兴市",
"861879467", "甘肃省天水市",
"861821451", "云南省临沧市",
"861898903", "西藏山南地区",
"861535004", "江西省抚州市",
"861478409", "河南省濮阳市",
"861337350", "河北省邯郸市",
"861899786", "新疆阿克苏地区",
"86159583", "浙江省嘉兴市",
"861330496", "辽宁省锦州市",
"861366331", "河北省保定市",
"861536022", "广东省汕尾市",
"861477105", "湖北省荆州市",
"861530671", "浙江省杭州市",
"861390574", "浙江省宁波市",
"861301966", "辽宁省抚顺市",
"861831945", "广东省深圳市",
"86133347", "云南省普洱市",
"861803768", "河南省郑州市",
"861836287", "江苏省淮安市",
"861367390", "河南省洛阳市",
"861575062", "内蒙古乌兰察布市",
"861766619", "广东省佛山市",
"861360456", "黑龙江省黑河市",
"861823005", "河北省秦皇岛市",
"861306901", "吉林省长春市",
"861893508", "山西省运城市",
"861398022", "四川省自贡市",
"861395610", "安徽省六安市",
"861350793", "江西省上饶市",
"861709425", "广东省江门市",
"861769134", "陕西省西安市",
"861375400", "内蒙古呼伦贝尔市",
"861458254", "安徽省合肥市",
"861864400", "黑龙江省佳木斯市",
"861335794", "江苏省徐州市",
"861339457", "黑龙江省佳木斯市",
"861859398", "广西南宁市",
"861310853", "云南省昆明市",
"861502890", "河北省邢台市",
"861302467", "浙江省金华市",
"861855858", "福建省泉州市",
"86184321", "河北省石家庄市",
"861553625", "山西省运城市",
"861522449", "山东省临沂市",
"861705369", "四川省成都市",
"861895333", "山东省日照市",
"861569860", "山西省长治市",
"861365754", "新疆喀什地区",
"86150260", "新疆乌鲁木齐市",
"861520006", "河北省保定市",
"861580541", "山东省济南市",
"86186534", "山东省德州市",
"861515446", "山东省潍坊市",
"86137434", "吉林省四平市",
"861472684", "四川省广安市",
"86180834", "贵州省黔西南布依族苗族自治州",
"861708579", "江苏省淮安市",
"86133868", "辽宁省沈阳市",
"861363717", "安徽省宿州市",
"861360419", "辽宁省辽阳市",
"861567647", "广西百色市",
"861536947", "河北省廊坊市",
"861852578", "辽宁省鞍山市",
"861470323", "河北省张家口市",
"861586086", "福建省三明市",
"861582693", "湖北省武汉市",
"86138643", "山东省淄博市",
"861529852", "江苏省泰州市",
"861572683", "浙江省宁波市",
"861813387", "河北省廊坊市",
"861576096", "陕西省汉中市",
"861370422", "辽宁省鞍山市",
"861328912", "陕西省榆林市",
"861391216", "江苏省连云港市",
"861532749", "湖北省荆门市",
"861573829", "河南省信阳市",
"861325548", "山东省泰安市",
"861570324", "河北省邯郸市",
"861329757", "湖北省黄冈市",
"861350579", "浙江省金华市",
"861566141", "内蒙古赤峰市",
"861539343", "甘肃省庆阳市",
"861805248", "江苏省无锡市",
"861558613", "湖北省荆州市",
"861510744", "湖南省张家界市",
"861862418", "辽宁省阜新市",
"861827090", "江西省新余市",
"861303935", "吉林省松原市",
"861771376", "四川省泸州市",
"861826031", "江苏省盐城市",
"861882300", "广东省梅州市",
"861352317", "河南省商丘市",
"861800632", "山东省枣庄市",
"861860720", "湖北省宜昌市",
"861476547", "福建省福州市",
"86158892", "广东省汕头市",
"86130372", "江西省南昌市",
"861396570", "安徽省阜阳市",
"861339681", "浙江省杭州市",
"861880870", "云南省昭通市",
"861473637", "广西梧州市",
"861312721", "山东省枣庄市",
"861351254", "江苏省南京市",
"861398947", "浙江省杭州市",
"861516635", "山东省聊城市",
"861867566", "广东省汕头市",
"861320796", "江西省吉安市",
"861815199", "江苏省常州市",
"86159668", "山东省青岛市",
"861808499", "四川省达州市",
"861377878", "四川省巴中市",
"86147811", "四川省乐山市",
"861560773", "广西桂林市",
"861820805", "西藏昌都地区",
"861865499", "山东省临沂市",
"861329680", "浙江省绍兴市",
"861817297", "江西省宜春市",
"861855072", "江苏省宿迁市",
"861390585", "浙江省绍兴市",
"86150952", "山东省潍坊市",
"861896694", "陕西省西安市",
"86152957", "江苏省南京市",
"86157227", "江苏省常州市",
"861598429", "四川省内江市",
"861331726", "湖北省恩施土家族苗族自治州",
"861355345", "广东省湛江市",
"861478460", "黑龙江省哈尔滨市",
"861585081", "江苏省苏州市",
"861708930", "广东省湛江市",
"86134613", "河南省周口市",
"861820414", "辽宁省本溪市",
"861563668", "黑龙江省双鸭山市",
"861459147", "广西钦州市",
"86185330", "河北省唐山市",
"861313053", "辽宁省丹东市",
"861807664", "广西南宁市",
"861577459", "黑龙江省大庆市",
"861837091", "江西省萍乡市",
"861304053", "新疆伊犁哈萨克自治州",
"861347348", "河北省石家庄市",
"861889212", "陕西省榆林市",
"861836030", "江苏省扬州市",
"861580823", "四川省自贡市",
"861538939", "陕西省汉中市",
"861807195", "湖北省十堰市",
"86151102", "北京市",
"861319745", "湖北省武汉市",
"861322042", "甘肃省平凉市",
"861366865", "山东省烟台市",
"861768300", "四川省泸州市",
"861457203", "四川省成都市",
"861576788", "广东省汕头市",
"861760345", "山西省长治市",
"861501818", "广东省珠海市",
"861338063", "广东省珠海市",
"861569809", "山东省济宁市",
"861822089", "陕西省商洛市",
"861705300", "广东省深圳市",
"861888816", "江苏省苏州市",
"861346519", "山东省德州市",
"861582945", "陕西省安康市",
"861450309", "河北省衡水市",
"861595553", "安徽省马鞍山市",
"861535309", "陕西省渭南市",
"861826293", "江苏省宿迁市",
"861705274", "北京市",
"861518698", "贵州省贵阳市",
"86170965", "云南省昆明市",
"861569517", "江苏省淮安市",
"86155345", "山西省长治市",
"861375469", "山东省滨州市",
"861592832", "四川省宜宾市",
"861454672", "广东省深圳市",
"86186270", "湖北省武汉市",
"861825036", "福建省龙岩市",
"861594639", "黑龙江省哈尔滨市",
"861452879", "宁夏银川市",
"861454181", "山西省太原市",
"861478539", "贵州省黔西南布依族苗族自治州",
"861336429", "辽宁省葫芦岛市",
"861825158", "江苏省徐州市",
"861453415", "辽宁省丹东市",
"861898591", "贵州省六盘水市",
"861508146", "河北省廊坊市",
"861848413", "贵州省贵阳市",
"861470916", "陕西省汉中市",
"861565146", "江苏省徐州市",
"861708079", "湖南省衡阳市",
"8613962", "江苏省苏州市",
"861867276", "湖北省武汉市",
"86158743", "湖南省湘西土家族苗族自治州",
"861564947", "河南省平顶山市",
"86132388", "辽宁省沈阳市",
"861880780", "广西防城港市",
"861303129", "新疆喀什地区",
"86188431", "吉林省长春市",
"861539187", "安徽省宿州市",
"861571432", "吉林省吉林市",
"861538070", "江苏省泰州市",
"86181579", "浙江省金华市",
"861773937", "河南省濮阳市",
"861325048", "广东省中山市",
"861310408", "黑龙江省哈尔滨市",
"861479768", "青海省果洛藏族自治州",
"861778670", "湖北省随州市",
"86156898", "山东省潍坊市",
"861870790", "江西省新余市",
"861576596", "黑龙江省大庆市",
"861337947", "陕西省宝鸡市",
"86150598", "福建省泉州市",
"861882564", "广东省珠海市",
"861813474", "河南省郑州市",
"861826531", "山东省济南市",
"861530354", "山西省晋中市",
"861340310", "河北省邯郸市",
"861534526", "江苏省扬州市",
"861566026", "湖南省邵阳市",
"861533859", "贵州省黔西南布依族苗族自治州",
"861588515", "贵州省铜仁地区",
"861835706", "浙江省衢州市",
"861300914", "吉林省长春市",
"861360492", "辽宁省沈阳市",
"861811341", "四川省绵阳市",
"861563899", "河南省南阳市",
"861330452", "黑龙江省齐齐哈尔市",
"861780638", "山东省泰安市",
"861360760", "河南省信阳市",
"861560394", "河南省周口市",
"861317635", "山东省聊城市",
"861804143", "辽宁省本溪市",
"861348747", "湖南省永州市",
"861559893", "内蒙古呼伦贝尔市",
"861393446", "山西省阳泉市",
"861367141", "广东省潮州市",
"861328999", "新疆伊犁哈萨克自治州",
"861708269", "湖北省武汉市",
"861362584", "浙江省宁波市",
"861812761", "广东省云浮市",
"861823641", "河南省郑州市",
"861577706", "广西玉林市",
"861772984", "四川省成都市",
"861708385", "河南省安阳市",
"86181476", "内蒙古赤峰市",
"861840633", "山东省日照市",
"861333968", "贵州省六盘水市",
"861390085", "北京市",
"861320588", "浙江省丽水市",
"861705311", "广东省深圳市",
"861301745", "贵州省贵阳市",
"861452789", "新疆博尔塔拉蒙古自治州",
"861863443", "山西省太原市",
"861770616", "江苏省无锡市",
"861768311", "四川省广安市",
"861346592", "山东省济南市",
"861368639", "山东省临沂市",
"861833640", "河南省安阳市",
"86189909", "四川省宜宾市",
"861304553", "安徽省池州市",
"861327674", "浙江省宁波市",
"861576878", "广东省惠州市",
"861365855", "贵州省黔东南苗族侗族自治州",
"861530736", "湖南省常德市",
"861705564", "辽宁省沈阳市",
"86151152", "湖南省怀化市",
"861773781", "河南省安阳市",
"861587008", "江西省萍乡市",
"861369395", "河南省漯河市",
"861322542", "山东省青岛市",
"861524140", "辽宁省本溪市",
"861479100", "陕西省咸阳市",
"86186038", "河南省郑州市",
"861596563", "山东省济南市",
"861339355", "山西省长治市",
"861302686", "广东省广州市",
"861859449", "福建省泉州市",
"861510486", "内蒙古乌兰察布市",
"861378964", "内蒙古乌兰察布市",
"861310192", "江苏省镇江市",
"861313553", "安徽省芜湖市",
"861866825", "浙江省宁波市",
"861506703", "浙江省衢州市",
"861471485", "广东省广州市",
"861707420", "浙江省杭州市",
"861550991", "新疆乌鲁木齐市",
"861870972", "青海省海东地区",
"861550433", "吉林省延边朝鲜族自治州",
"861378846", "广西柳州市",
"861559196", "陕西省商洛市",
"861346739", "湖南省邵阳市",
"861804846", "四川省宜宾市",
"861813846", "广东省佛山市",
"861537429", "江西省南昌市",
"861334865", "湖南省郴州市",
"861338563", "安徽省宣城市",
"861877434", "湖南省常德市",
"861818675", "湖北省襄樊市",
"861560883", "云南省临沧市",
"861895155", "江苏省盐城市",
"861535434", "河北省秦皇岛市",
"86157256", "山东省潍坊市",
"861364429", "辽宁省葫芦岛市",
"86152926", "新疆昌吉回族自治州",
"861369832", "四川省资阳市",
"861474313", "吉林省延边朝鲜族自治州",
"861478719", "云南省昆明市",
"861889299", "新疆石河子市",
"86176931", "甘肃省兰州市",
"861528071", "福建省三明市",
"861596902", "云南省昭通市",
"861569017", "河北省廊坊市",
"861565021", "山东省临沂市",
"861569737", "湖南省益阳市",
"861348376", "河北省保定市",
"861390379", "河南省洛阳市",
"861459383", "贵州省六盘水市",
"861858250", "四川省遂宁市",
"861855947", "福建省泉州市",
"861326779", "广东省汕头市",
"861336900", "新疆昌吉回族自治州",
"861593286", "江西省萍乡市",
"86182028", "四川省成都市",
"861592823", "四川省广元市",
"861351432", "吉林省吉林市",
"861348590", "安徽省阜阳市",
"861593689", "河南省三门峡市",
"86188620", "江苏省盐城市",
"86136789", "广东省广州市",
"861709965", "浙江省台州市",
"861850511", "江苏省镇江市",
"861580395", "河南省漯河市",
"861532258", "广东省汕头市",
"861302927", "辽宁省铁岭市",
"861333215", "辽宁省本溪市",
"861322977", "广东省珠海市",
"861853869", "河南省平顶山市",
"861534600", "河南省漯河市",
"861340818", "四川省达州市",
"86156485", "内蒙古通辽市",
"861328336", "河北省承德市",
"861562851", "西藏拉萨市",
"861886938", "云南省昆明市",
"861361882", "云南省德宏傣族景颇族自治州",
"861458144", "浙江省温州市",
"861806410", "湖北省武汉市",
"86150712", "湖北省武汉市",
"86145086", "江苏省徐州市",
"861860471", "内蒙古呼和浩特市",
"861870547", "山东省济宁市",
"861380737", "湖南省益阳市",
"861383439", "山西省运城市",
"86152717", "湖北省荆门市",
"861879927", "新疆石河子市",
"861580832", "四川省内江市",
"861894488", "江苏省宿迁市",
"861325906", "陕西省渭南市",
"861859608", "山东省济南市",
"86189232", "广东省佛山市",
"861364911", "陕西省延安市",
"861379893", "广东省东莞市",
"86180616", "江苏省南京市",
"861301426", "宁夏银川市",
"861868759", "云南省保山市",
"861362025", "广东省云浮市",
"861589108", "陕西省渭南市",
"861394734", "内蒙古乌海市",
"861566611", "山东省威海市",
"861321476", "内蒙古赤峰市",
"861809595", "新疆乌鲁木齐市",
"861521691", "广东省河源市",
"86130058", "广东省江门市",
"86187786", "广西百色市",
"861816743", "新疆克拉玛依市",
"861886824", "浙江省湖州市",
"861459617", "甘肃省庆阳市",
"861390524", "江苏省宿迁市",
"861340753", "江苏省徐州市",
"861536072", "广东省湛江市",
"861564572", "黑龙江省黑河市",
"861785893", "浙江省宁波市",
"861370157", "江苏省苏州市",
"861556459", "山东省威海市",
"861321966", "四川省自贡市",
"861890064", "江苏省南通市",
"86153180", "山东省枣庄市",
"861845251", "江苏省宿迁市",
"861399944", "新疆哈密地区",
"861458963", "广东省阳江市",
"861356878", "四川省阿坝藏族羌族自治州",
"861590450", "黑龙江省哈尔滨市",
"861591714", "广东省汕尾市",
"861860961", "安徽省马鞍山市",
"861817755", "广西贵港市",
"861863907", "河南省安阳市",
"861555030", "山东省淄博市",
"861776672", "四川省绵阳市",
"861845898", "浙江省绍兴市",
"861313985", "新疆巴音郭楞蒙古自治州",
"86139393", "河南省濮阳市",
"861775883", "黑龙江省佳木斯市",
"861819976", "新疆哈密地区",
"861592541", "云南省西双版纳傣族自治州",
"861802196", "江苏省连云港市",
"861801451", "江苏省泰州市",
"861337572", "浙江省湖州市",
"861856309", "山东省滨州市",
"861787697", "广东省湛江市",
"861517417", "辽宁省丹东市",
"861831303", "云南省大理白族自治州",
"861508219", "四川省绵阳市",
"861370991", "新疆乌鲁木齐市",
"861310649", "浙江省台州市",
"861803337", "广东省云浮市",
"861322467", "黑龙江省鸡西市",
"861370433", "吉林省延边朝鲜族自治州",
"861558846", "山东省枣庄市",
"861479641", "江西省吉安市",
"861814337", "湖南省衡阳市",
"861587946", "江西省鹰潭市",
"861537087", "江苏省无锡市",
"86130504", "辽宁省锦州市",
"861760591", "福建省福州市",
"86136804", "广东省江门市",
"861379384", "山东省泰安市",
"861458502", "河南省信阳市",
"86152260", "河南省开封市",
"861310246", "河北省廊坊市",
"861336587", "湖南省益阳市",
"861354561", "湖北省咸宁市",
"861890300", "广东省广州市",
"861575222", "云南省曲靖市",
"861380981", "广东省佛山市",
"861470332", "河北省保定市",
"861890274", "广东省汕头市",
"861321844", "江苏省南通市",
"861850731", "湖南省长沙市",
"86180515", "江苏省无锡市",
"861369823", "四川省宜宾市",
"861376363", "黑龙江省佳木斯市",
"86186815", "广东省深圳市",
"861372095", "山西省长治市",
"861806769", "浙江省舟山市",
"861321197", "云南省迪庆藏族自治州",
"861335323", "吉林省白城市",
"86183819", "四川省达州市",
"861364900", "四川省内江市",
"861880378", "河南省开封市",
"861332830", "福建省厦门市",
"861568014", "四川省绵阳市",
"861566600", "山东省德州市",
"861527779", "广西桂林市",
"861839957", "新疆阿克苏地区",
"861871470", "黑龙江省哈尔滨市",
"861550422", "辽宁省朝阳市",
"861356096", "广东省梅州市",
"861477731", "广西南宁市",
"861558387", "四川省自贡市",
"86181090", "四川省成都市",
"861330234", "广东省韶关市",
"861897799", "广西玉林市",
"861350324", "河北省廊坊市",
"861551761", "河南省信阳市",
"86156689", "辽宁省葫芦岛市",
"861551409", "河南省开封市",
"861570579", "浙江省金华市",
"861818106", "四川省南充市",
"861804613", "福建省三明市",
"86139885", "云南省大理白族自治州",
"861385941", "福建省三明市",
"861845266", "江苏省扬州市",
"861336911", "陕西省咸阳市",
"861367611", "广东省汕头市",
"86177201", "天津市",
"861321951", "四川省宜宾市",
"861767339", "湖南省邵阳市",
"861858545", "贵州省黔东南苗族侗族自治州",
"861522982", "陕西省榆林市",
"861850500", "福建省莆田市",
"861842007", "广东省惠州市",
"861373106", "河北省邢台市",
"86139236", "广东省惠州市",
"861361772", "广西柳州市",
"861500436", "吉林省白城市",
"86177273", "广东省佛山市",
"861512973", "陕西省渭南市",
"861774011", "四川省广安市",
"861319426", "辽宁省大连市",
"86159991", "新疆乌鲁木齐市",
"861801466", "江苏省盐城市",
"86130612", "山东省青岛市",
"86130008", "广东省广州市",
"861509578", "甘肃省白银市",
"861772925", "陕西省安康市",
"861457047", "广东省佛山市",
"861313330", "山西省晋中市",
"861315286", "山西省晋城市",
"861821313", "云南省怒江傈僳族自治州",
"861830996", "新疆巴音郭楞蒙古自治州",
"861304330", "吉林省长春市",
"861860956", "宁夏吴忠市",
"861315689", "山东省青岛市",
"861362525", "江苏省宿迁市",
"861331445", "贵州省黔东南苗族侗族自治州",
"861534611", "河南省三门峡市",
"86183397", "河南省焦作市",
"861520948", "甘肃省天水市",
"86137782", "四川省德阳市",
"861890564", "安徽省六安市",
"861314778", "吉林省辽源市",
"861535252", "新疆巴音郭楞蒙古自治州",
"861893765", "河南省郑州市",
"861780344", "山西省晋城市",
"861557878", "广西北海市",
"861323205", "广东省韶关市",
"861821926", "广东省河源市",
"861562944", "湖北省荆州市",
"861323728", "湖北省荆门市",
"861390024", "广东省广州市",
"861840622", "辽宁省本溪市",
"86183346", "山西省晋城市",
"861390953", "宁夏吴忠市",
"861890311", "河北省石家庄市",
"861779941", "新疆昌吉回族自治州",
"861770146", "江苏省南通市",
"861361990", "新疆乌鲁木齐市",
"861357459", "湖南省怀化市",
"861300752", "河南省郑州市",
"86134301", "广东省梅州市",
"86188125", "天津市",
"861360921", "陕西省咸阳市",
"861369541", "山东省济南市",
"861379477", "广东省阳江市",
"861500857", "贵州省毕节地区",
"86151830", "四川省泸州市",
"861768808", "广东省湛江市",
"861327413", "辽宁省抚顺市",
"861331631", "广东省佛山市",
"861805406", "安徽省阜阳市",
"861453278", "山西省临汾市",
"861771590", "江苏省盐城市",
"861705808", "上海市",
"861770521", "江苏省徐州市",
"861868406", "四川省南充市",
"861584646", "黑龙江省牡丹江市",
"861700155", "江苏省苏州市",
"861853698", "山西省忻州市",
"861539235", "福建省宁德市",
"861871960", "甘肃省平凉市",
"861595985", "福建省泉州市",
"86151593", "福建省宁德市",
"861476972", "山东省济南市",
"86185252", "辽宁省沈阳市",
"861774987", "河北省衡水市",
"861818803", "贵州省安顺市",
"861538396", "河北省廊坊市",
"861899826", "广东省揭阳市",
"861570930", "甘肃省临夏回族自治州",
"861335916", "陕西省汉中市",
"861800704", "江西省抚州市",
"861364587", "浙江省温州市",
"861571423", "辽宁省抚顺市",
"861564262", "辽宁省朝阳市",
"861398572", "贵州省安顺市",
"86132483", "上海市",
"861322831", "四川省宜宾市",
"86181845", "贵州省黔东南苗族侗族自治州",
"861551460", "河南省周口市",
"861808634", "湖北省黄石市",
"861819687", "新疆阿克苏地区",
"861318847", "辽宁省辽阳市",
"861848351", "四川省泸州市",
"861369605", "四川省内江市",
"86188161", "山东省淄博市",
"86145356", "贵州省贵阳市",
"861476933", "云南省楚雄彝族自治州",
"861873847", "河南省驻马店市",
"861860880", "云南省昆明市",
"86152598", "福建省三明市",
"861566669", "山东省青岛市",
"861537969", "宁夏中卫市",
"861778620", "湖北省黄冈市",
"861303179", "山东省淄博市",
"86155111", "河北省石家庄市",
"861311757", "湖南省益阳市",
"861364969", "云南省普洱市",
"86130388", "广东省东莞市",
"861709746", "广东省东莞市",
"861352568", "河南省南阳市",
"86131488", "广东省深圳市",
"861576934", "甘肃省兰州市",
"861394835", "内蒙古通辽市",
"86155778", "广西河池市",
"861850430", "吉林省长春市",
"861398533", "贵州省铜仁地区",
"861538020", "江苏省镇江市",
"861586642", "山东省临沂市",
"861314179", "内蒙古锡林郭勒盟",
"861867629", "广东省中山市",
"861773043", "安徽省马鞍山市",
"86139320", "河北省邯郸市",
"861889306", "甘肃省天水市",
"86181264", "广东省深圳市",
"861590766", "广东省云浮市",
"86182376", "河南省信阳市",
"861308999", "黑龙江省哈尔滨市",
"861580497", "辽宁省辽阳市",
"861874999", "河南省驻马店市",
"861814641", "新疆乌鲁木齐市",
"861802152", "江苏省南京市",
"861479337", "甘肃省平凉市",
"861803641", "江苏省宿迁市",
"86432", "吉林省吉林市",
"861335959", "黑龙江省大庆市",
"861785589", "浙江省金华市",
"861524045", "江苏省无锡市",
"861597520", "广东省揭阳市",
"861594548", "黑龙江省牡丹江市",
"861534576", "浙江省台州市",
"861533643", "山东省淄博市",
"861850569", "安徽省合肥市",
"861343518", "广东省江门市",
"861774430", "四川省泸州市",
"861320914", "陕西省商洛市",
"861813424", "河北省唐山市",
"861478648", "湖南省永州市",
"861570487", "内蒙古鄂尔多斯市",
"861350029", "广东省清远市",
"861563440", "山东省威海市",
"861569368", "甘肃省张掖市",
"86151157", "湖南省常德市",
"861362918", "陕西省咸阳市",
"861897198", "湖北省鄂州市",
"861379589", "四川省广元市",
"86185960", "山东省威海市",
"861576828", "广东省梅州市",
"861535868", "江苏省淮安市",
"861512932", "陕西省榆林市",
"861311680", "浙江省舟山市",
"861361733", "湖南省株洲市",
"861834785", "内蒙古巴彦淖尔市",
"861803435", "河北省唐山市",
"861322365", "山西省长治市",
"86858", "贵州省六盘水市",
"861322686", "广东省深圳市",
"861341948", "四川省内江市",
"861321745", "湖南省怀化市",
"8618416", "山东省济南市",
"86152902", "河南省信阳市",
"861323380", "河南省新乡市",
"861317802", "福建省漳州市",
"86150907", "湖北省荆州市",
"861533995", "山东省济南市",
"861855522", "安徽省铜陵市",
"861884810", "内蒙古呼伦贝尔市",
"861897573", "湖南省郴州市",
"861389599", "黑龙江省齐齐哈尔市",
"861898447", "贵州省毕节地区",
"861325639", "山东省青岛市",
"861508261", "四川省宜宾市",
"86150926", "山东省济宁市",
"861391302", "江苏省南京市",
"861356552", "新疆和田地区",
"861317097", "江西省赣州市",
"861571614", "江苏省常州市",
"861364479", "内蒙古锡林郭勒盟",
"861570793", "江西省上饶市",
"861354092", "四川省乐山市",
"861508071", "湖南省益阳市",
"86156229", "广东省东莞市",
"861390329", "河北省邢台市",
"861337858", "贵州省六盘水市",
"861860919", "陕西省铜川市",
"861595974", "福建省南平市",
"861560604", "福建省漳州市",
"86188693", "云南省红河哈尼族彝族自治州",
"861337291", "辽宁省盘锦市",
"86135413", "四川省成都市",
"861470794", "江西省抚州市",
"861818625", "湖北省襄樊市",
"861871909", "广东省湛江市",
"861804253", "浙江省宁波市",
"861534898", "西藏拉萨市",
"861802589", "广东省汕头市",
"861879542", "江苏省徐州市",
"861389732", "青海省海东地区",
"861537479", "内蒙古锡林郭勒盟",
"861587765", "陕西省西安市",
"861580783", "广西桂林市",
"861370472", "内蒙古包头市",
"86145306", "上海市",
"861572415", "广东省梅州市",
"861857373", "湖南省益阳市",
"861778948", "甘肃省天水市",
"861338454", "黑龙江省佳木斯市",
"86135678", "浙江省宁波市",
"861305548", "福建省宁德市",
"86185369", "山西省晋中市",
"861377934", "新疆巴音郭楞蒙古自治州",
"861308912", "吉林省长春市",
"86157318", "河北省衡水市",
"861570374", "河南省许昌市",
"861368548", "山东省泰安市",
"861538352", "山西省大同市",
"861573879", "河南省漯河市",
"861342821", "广东省汕尾市",
"861769801", "河南省许昌市",
"861305494", "山东省临沂市",
"861365912", "陕西省榆林市",
"861309757", "山西省吕梁市",
"861375929", "云南省西双版纳傣族自治州",
"86158319", "河北省石家庄市",
"861896304", "山东省日照市",
"861398033", "四川省广安市",
"86182834", "四川省凉山彝族自治州",
"861367266", "广东省珠海市",
"861331347", "山西省临汾市",
"86151520", "江苏省徐州市",
"861373458", "黑龙江省大庆市",
"861589971", "广东省江门市",
"861768137", "安徽省阜阳市",
"861880820", "四川省眉山市",
"861363943", "山东省济宁市",
"861396520", "安徽省铜陵市",
"861536033", "广东省阳江市",
"861881891", "广东省广州市",
"861568835", "新疆昌吉回族自治州",
"86130377", "四川省凉山彝族自治州",
"86158897", "广东省深圳市",
"861782036", "广东省梅州市",
"861838402", "四川省泸州市",
"86155787", "广西钦州市",
"861521753", "广东省东莞市",
"861300796", "宁夏银川市",
"861825248", "江苏省南通市",
"861558485", "吉林省白城市",
"861313464", "山西省吕梁市",
"861807090", "广西南宁市",
"861841936", "甘肃省庆阳市",
"861872757", "湖北省荆门市",
"861350529", "江苏省镇江市",
"861337533", "山东省淄博市",
"861479505", "宁夏中卫市",
"861359949", "福建省莆田市",
"861597020", "江西省吉安市",
"861860770", "广西防城港市",
"861535296", "青海省海西蒙古族藏族自治州",
"861871881", "广东省梅州市",
"861534076", "山西省阳泉市",
"861323935", "甘肃省金昌市",
"861343738", "广东省东莞市",
"861820632", "山东省枣庄市",
"861887286", "湖北省荆门市",
"861351502", "福建省福州市",
"861800414", "辽宁省本溪市",
"861354739", "四川省自贡市",
"861860992", "新疆伊犁哈萨克自治州",
"861846219", "山东省烟台市",
"861361513", "江苏省徐州市",
"861827664", "广西百色市",
"861313974", "新疆阿克苏地区",
"861392368", "广东省河源市",
"861516802", "浙江省丽水市",
"861333655", "广东省茂名市",
"861802375", "广东省云浮市",
"86151107", "山西省大同市",
"861830952", "宁夏石嘴山市",
"861590751", "广东省韶关市",
"861580873", "云南省红河哈尼族彝族自治州",
"861771913", "河南省漯河市",
"861302042", "内蒙古赤峰市",
"861559427", "陕西省安康市",
"861532618", "辽宁省鞍山市",
"861506674", "山东省泰安市",
"861309680", "贵州省黔西南布依族苗族自治州",
"861560723", "湖北省黄石市",
"86158846", "四川省绵阳市",
"861555287", "山东省济南市",
"861458432", "河南省许昌市",
"861340691", "山东省枣庄市",
"861760903", "新疆和田地区",
"861331776", "广西百色市",
"861598479", "四川省达州市",
"86152952", "江苏省泰州市",
"861839340", "甘肃省临夏回族自治州",
"86157222", "天津市",
"861354592", "湖北省荆州市",
"861452829", "四川省泸州市",
"86181023", "重庆市",
"861897263", "湖北省武汉市",
"861890285", "广东省深圳市",
"861330904", "四川省阿坝藏族羌族自治州",
"861709484", "浙江省宁波市",
"861805036", "福建省宁德市",
"861528521", "贵州省遵义市",
"861780549", "山东省临沂市",
"861528146", "四川省德阳市",
"861890369", "黑龙江省大庆市",
"861589709", "青海省海西蒙古族藏族自治州",
"861872680", "安徽省亳州市",
"861453683", "陕西省西安市",
"861356052", "广东省湛江市",
"861336479", "新疆乌鲁木齐市",
"861554348", "吉林省松原市",
"86139929", "陕西省铜川市",
"861883396", "河北省廊坊市",
"861351473", "内蒙古乌海市",
"861552190", "广东省广州市",
"861370962", "广东省茂名市",
"861395140", "江苏省镇江市",
"861351144", "浙江省台州市",
"861318194", "山东省淄博市",
"861379375", "山东省济宁市",
"861364230", "广东省广州市",
"861389512", "宁夏石嘴山市",
"861802089", "福建省龙岩市",
"861882690", "广东省珠海市",
"861521818", "广东省阳江市",
"861760562", "安徽省铜陵市",
"861536858", "云南省普洱市",
"861837447", "湖南省长沙市",
"861705224", "内蒙古包头市",
"86188280", "四川省成都市",
"861318665", "江苏省淮安市",
"86151126", "广东省深圳市",
"861884801", "内蒙古通辽市",
"861806293", "湖北省黄石市",
"861398707", "云南省楚雄彝族自治州",
"86170761", "山东省济南市",
"861810619", "江苏省无锡市",
"861334557", "安徽省宿州市",
"861538386", "河北省廊坊市",
"861583188", "河北省沧州市",
"861336097", "广东省深圳市",
"861859956", "福建省漳州市",
"86180573", "浙江省嘉兴市",
"861881960", "广东省茂名市",
"86180501", "福建省福州市",
"86186873", "云南省红河哈尼族彝族自治州",
"861580930", "甘肃省临夏回族自治州",
"861537597", "福建省莆田市",
"861356798", "浙江省湖州市",
"861821814", "广东省深圳市",
"861473574", "山西省朔州市",
"861766546", "广东省深圳市",
"861470775", "广西玉林市",
"861387204", "湖北省黄冈市",
"86138345", "山西省太原市",
"861595995", "福建省泉州市",
"861510904", "新疆喀什地区",
"861567557", "安徽省宿州市",
"861847801", "湖南省衡阳市",
"861345505", "山东省枣庄市",
"861532909", "贵州省黔西南布依族苗族自治州",
"861306955", "河南省漯河市",
"861361980", "河南省驻马店市",
"861511776", "贵州省安顺市",
"861502720", "湖北省恩施土家族苗族自治州",
"861564839", "内蒙古呼伦贝尔市",
"861569422", "辽宁省鞍山市",
"86177215", "江苏省南京市",
"861850997", "新疆阿克苏地区",
"861770344", "山西省晋中市",
"861771580", "江苏省无锡市",
"861500418", "辽宁省阜新市",
"861869731", "河南省郑州市",
"861389477", "吉林省长春市",
"861477997", "江西省萍乡市",
"861350823", "四川省攀枝花市",
"861808027", "四川省广安市",
"861396665", "安徽省合肥市",
"861887252", "湖北省宜昌市",
"861513655", "河南省驻马店市",
"861869011", "新疆塔城地区",
"861536707", "湖南省衡阳市",
"861828077", "四川省绵阳市",
"86184354", "山西省晋中市",
"861874567", "黑龙江省哈尔滨市",
"86145484", "广东省广州市",
"861308567", "浙江省金华市",
"861508282", "四川省广元市",
"861518223", "四川省眉山市",
"861533974", "甘肃省庆阳市",
"861528549", "贵州省黔西南布依族苗族自治州",
"861365567", "安徽省阜阳市",
"861337839", "四川省攀枝花市",
"86187125", "安徽省阜阳市",
"861452841", "甘肃省甘南藏族自治州",
"861361819", "四川省眉山市",
"861839181", "陕西省咸阳市",
"861358015", "广东省揭阳市",
"861306440", "河南省安阳市",
"861315296", "山西省晋城市",
"861580579", "浙江省金华市",
"861864941", "广西南宁市",
"861303076", "辽宁省盘锦市",
"861802773", "广东省韶关市",
"861760917", "陕西省宝鸡市",
"861315699", "山东省日照市",
"861338308", "河北省邯郸市",
"86186294", "陕西省西安市",
"861824495", "广东省茂名市",
"861571727", "湖北省襄樊市",
"861373304", "安徽省六安市",
"86153477", "广西柳州市",
"861361507", "福建省漳州市",
"86138782", "广西柳州市",
"861818270", "黑龙江省佳木斯市",
"86135892", "山东省青岛市",
"86189153", "江苏省无锡市",
"861811585", "江苏省宿迁市",
"861522992", "陕西省榆林市",
"861316033", "江苏省宿迁市",
"861509183", "陕西省西安市",
"861597847", "河南省驻马店市",
"861525244", "江苏省连云港市",
"861771907", "河南省平顶山市",
"861327305", "河南省漯河市",
"861870378", "河南省开封市",
"861452523", "山东省临沂市",
"861511347", "广东省梅州市",
"861558397", "四川省眉山市",
"86133520", "天津市",
"861350541", "山东省济南市",
"8618180", "四川省成都市",
"861815934", "福建省漳州市",
"861526537", "山东省济宁市",
"861700015", "广东省广州市",
"86156688", "辽宁省沈阳市",
"861453766", "广西北海市",
"861327717", "湖北省宜昌市",
"861318352", "四川省巴中市",
"861314266", "江苏省南通市",
"861523647", "河南省新乡市",
"861303669", "四川省成都市",
"861372085", "福建省泉州市",
"861327037", "江苏省常州市",
"861321187", "云南省曲靖市",
"86155643", "山东省滨州市",
"861596308", "山东省东营市",
"861335938", "甘肃省天水市",
"86183818", "四川省达州市",
"86150070", "江西省赣州市",
"861881470", "黑龙江省伊春市",
"861772406", "广东省惠州市",
"861840848", "宁夏中卫市",
"861577946", "江西省萍乡市",
"86186851", "贵州省贵阳市",
"861336597", "福建省泉州市",
"861317479", "浙江省台州市",
"861365277", "广东省惠州市",
"861875097", "福建省南平市",
"861847810", "湖南省常德市",
"86180551", "安徽省合肥市",
"861874277", "新疆喀什地区",
"861308277", "山东省泰安市",
"861871618", "四川省宜宾市",
"861380991", "新疆乌鲁木齐市",
"861589482", "内蒙古呼伦贝尔市",
"861334057", "福建省龙岩市",
"861366557", "安徽省宿州市",
"861787687", "广东省茂名市",
"861766046", "山东省烟台市",
"861869000", "陕西省宝鸡市",
"86147632", "山东省枣庄市",
"861303251", "江苏省常州市",
"861458777", "湖南省怀化市",
"861579492", "福建省福州市",
"861816447", "安徽省合肥市",
"861379186", "山东省潍坊市",
"861354758", "四川省南充市",
"861511886", "广东省广州市",
"86155036", "山西省太原市",
"861340836", "四川省凉山彝族自治州",
"861474130", "辽宁省沈阳市",
"861760581", "浙江省杭州市",
"861318175", "山东省莱芜市",
"861579760", "江西省新余市",
"861379394", "山东省临沂市",
"861860608", "福建省泉州市",
"861590683", "浙江省嘉兴市",
"861827174", "湖北省孝感市",
"861524968", "河南省郑州市",
"861776191", "江苏省苏州市",
"861556508", "河南省郑州市",
"861337707", "广西柳州市",
"861802394", "广东省潮州市",
"861807124", "湖北省黄石市",
"861867435", "湖南省湘潭市",
"861845888", "浙江省杭州市",
"861477863", "广东省清远市",
"861363674", "陕西省咸阳市",
"861470885", "云南省曲靖市",
"861313995", "新疆吐鲁番地区",
"86185847", "重庆市",
"861597194", "湖北省随州市",
"861537802", "甘肃省临夏回族自治州",
"861380157", "江苏省苏州市",
"861810692", "福建省福州市",
"861536839", "云南省曲靖市",
"861869364", "甘肃省张掖市",
"861896625", "浙江省温州市",
"861874067", "陕西省宝鸡市",
"861850863", "湖北省武汉市",
"861362609", "福建省泉州市",
"861528049", "福建省泉州市",
"861785883", "浙江省杭州市",
"861365067", "广东省河源市",
"861337315", "河北省唐山市",
"861315868", "四川省德阳市",
"861332932", "黑龙江省七台河市",
"861390341", "山西省太原市",
"861333140", "吉林省白城市",
"861345337", "山西省运城市",
"86132521", "浙江省绍兴市",
"86133157", "河北省沧州市",
"861805139", "江苏省盐城市",
"861867641", "广东省中山市",
"861818439", "贵州省六盘水市",
"861304643", "山东省威海市",
"861878643", "贵州省黔东南苗族侗族自治州",
"861889927", "新疆和田地区",
"861570832", "四川省内江市",
"861853232", "河北省廊坊市",
"86158682", "浙江省湖州市",
"861322652", "广东省韶关市",
"861809585", "新疆巴音郭楞蒙古自治州",
"861370017", "辽宁省鞍山市",
"861361335", "河北省秦皇岛市",
"861370737", "湖南省益阳市",
"861880547", "山东省济宁市",
"861313643", "浙江省舟山市",
"861831804", "广东省揭阳市",
"861373439", "山东省临沂市",
"861517033", "江西省萍乡市",
"861321343", "河南省驻马店市",
"861524478", "黑龙江省佳木斯市",
"861316533", "山东省淄博市",
"861347942", "江西省抚州市",
"861458346", "江西省景德镇市",
"861513428", "辽宁省葫芦岛市",
"861897879", "广西贵港市",
"861894498", "湖南省衡阳市",
"86185896", "海南省海口市",
"861311808", "四川省自贡市",
"86156677", "陕西省榆林市",
"861894544", "黑龙江省佳木斯市",
"861871862", "广东省揭阳市",
"861847989", "江西省景德镇市",
"861881636", "山东省东营市",
"861350041", "辽宁省朝阳市",
"861532881", "四川省宜宾市",
"861331852", "广东省茂名市",
"861328134", "四川省乐山市",
"86187620", "江苏省淮安市",
"861700515", "江苏省盐城市",
"861471607", "广东省东莞市",
"86153488", "海南省海口市",
"861368475", "内蒙古呼和浩特市",
"861560242", "广东省佛山市",
"861570395", "河南省漯河市",
"861397308", "湖南省怀化市",
"861452954", "广东省珠海市",
"86135743", "湖南省湘西土家族苗族自治州",
"861811379", "四川省宜宾市",
"861343759", "广东省茂名市",
"861361892", "西藏日喀则地区",
"861340457", "吉林省松原市",
"861823679", "河南省郑州市",
"861317969", "江苏省无锡市",
"861526305", "山东省青岛市",
"86182029", "陕西省西安市",
"861593296", "江西省抚州市",
"861557086", "湖南省长沙市",
"861522919", "陕西省铜川市",
"861803629", "江苏省盐城市",
"861329369", "山西省朔州市",
"861338742", "湖南省常德市",
"86170904", "北京市",
"861301905", "黑龙江省牡丹江市",
"861538847", "四川省达州市",
"861348580", "安徽省淮南市",
"86159027", "湖北省武汉市",
"861552024", "四川省雅安市",
"86136788", "山东省青岛市",
"861327537", "山东省济宁市",
"861521457", "黑龙江省佳木斯市",
"861770549", "山东省临沂市",
"861318184", "山东省泰安市",
"861516087", "新疆乌鲁木齐市",
"861309137", "河北省秦皇岛市",
"86139542", "山东省青岛市",
"861351346", "河北省张家口市",
"861318396", "四川省宜宾市",
"861335725", "湖南省怀化市",
"861869069", "新疆巴音郭楞蒙古自治州",
"861847567", "广东省茂名市",
"861816222", "江西省宜春市",
"861536417", "湖南省常德市",
"861354582", "湖北省荆州市",
"86187280", "四川省德阳市",
"861705757", "广东省佛山市",
"861556438", "山东省淄博市",
"861709494", "浙江省金华市",
"861769912", "新疆伊犁哈萨克自治州",
"86155155", "河南省郑州市",
"861853063", "河南省安阳市",
"861709548", "江苏省无锡市",
"861768757", "广西柳州市",
"861815370", "湖南省益阳市",
"861380962", "广东省东莞市",
"861339301", "河北省石家庄市",
"861700928", "山东省青岛市",
"861453450", "安徽省合肥市",
"861872453", "黑龙江省牡丹江市",
"861889042", "湖南省岳阳市",
"861872690", "安徽省淮北市",
"861317587", "浙江省台州市",
"861552180", "广东省广州市",
"8614720", "四川省成都市",
"86139928", "陕西省西安市",
"861332463", "陕西省安康市",
"861522956", "陕西省汉中市",
"861521133", "湖南省常德市",
"861570873", "云南省红河哈尼族彝族自治州",
"861309453", "四川省宜宾市",
"861367778", "广西河池市",
"861554077", "内蒙古鄂尔多斯市",
"861771237", "江苏省无锡市",
"861340681", "山东省青岛市",
"861854549", "黑龙江省鸡西市",
"861300098", "黑龙江省哈尔滨市",
"86130980", "陕西省延安市",
"861782018", "广东省佛山市",
"861590568", "安徽省阜阳市",
"861860982", "辽宁省沈阳市",
"861776162", "河南省南阳市",
"861343158", "广东省珠海市",
"861866795", "浙江省金华市",
"861470874", "云南省曲靖市",
"861363685", "陕西省渭南市",
"861841918", "甘肃省陇南市",
"861813607", "江苏省苏州市",
"861842013", "广东省深圳市",
"861869279", "湖南省邵阳市",
"861379099", "广东省湛江市",
"861315252", "广西柳州市",
"861384840", "内蒙古呼伦贝尔市",
"861594746", "内蒙古赤峰市",
"861783543", "山西省晋中市",
"861772036", "湖北省荆门市",
"86152766", "新疆乌鲁木齐市",
"861535689", "浙江省金华市",
"861893363", "广东省江门市",
"861351777", "广西钦州市",
"86131261", "河北省石家庄市",
"861700834", "浙江省台州市",
"86155600", "河南省商丘市",
"861771124", "四川省达州市",
"861599936", "新疆昌吉回族自治州",
"861772716", "广东省东莞市",
"861354159", "四川省泸州市",
"861705680", "湖北省孝感市",
"861535286", "内蒙古乌兰察布市",
"861533330", "河北省邯郸市",
"861871891", "广东省广州市",
"861887296", "湖北省荆州市",
"861332973", "湖北省武汉市",
"861820944", "甘肃省庆阳市",
"86182662", "山东省枣庄市",
"861532636", "吉林省白城市",
"861454848", "广东省深圳市",
"86180667", "陕西省西安市",
"861329064", "河北省唐山市",
"861500160", "新疆伊犁哈萨克自治州",
"86312", "河北省保定市",
"861809574", "青海省海南藏族自治州",
"861877689", "广西南宁市",
"86135750", "湖南省岳阳市",
"86181582", "浙江省宁波市",
"861882757", "湖北省随州市",
"861829524", "宁夏固原市",
"861331078", "贵州省六盘水市",
"861818817", "贵州省毕节地区",
"861580374", "河南省许昌市",
"86132565", "山东省临沂市",
"86158318", "河北省邯郸市",
"861868018", "广东省中山市",
"861377642", "江苏省扬州市",
"861857446", "湖南省永州市",
"86159386", "河南省周口市",
"861331268", "云南省昭通市",
"861380472", "内蒙古包头市",
"861580200", "广东省广州市",
"861764042", "辽宁省大连市",
"86131685", "广东省佛山市",
"861317900", "吉林省长春市",
"861859992", "四川省巴中市",
"861570176", "甘肃省甘南藏族自治州",
"86185368", "山西省太原市",
"861453945", "广东省江门市",
"861373509", "浙江省衢州市",
"861368484", "江西省抚州市",
"86157319", "河北省邢台市",
"861305484", "山东省莱芜市",
"861560427", "辽宁省盘锦市",
"86184577", "浙江省温州市",
"861775152", "江苏省无锡市",
"861368746", "广东省揭阳市",
"86156563", "安徽省宣城市",
"86139730", "湖南省岳阳市",
"86189546", "山东省东营市",
"861869569", "福建省厦门市",
"861337281", "辽宁省盘锦市",
"861820851", "贵州省贵阳市",
"86150863", "贵州省毕节地区",
"861470784", "广西梧州市",
"861802599", "广东省佛山市",
"861516587", "山东省枣庄市",
"861347527", "山东省东营市",
"861580793", "江西省上饶市",
"861700640", "山东省青岛市",
"861530246", "广东省广州市",
"861353954", "广东省汕尾市",
"861881909", "广东省东莞市",
"861361856", "贵州省铜仁地区",
"861889542", "安徽省阜阳市",
"861317087", "江西省南昌市",
"861895110", "江苏省苏州市",
"8614725", "四川省成都市",
"861331896", "广东省珠海市",
"86156228", "广东省深圳市",
"861530649", "山东省滨州市",
"86187693", "山东省日照市",
"861517572", "河北省沧州市",
"861300598", "广西梧州市",
"861861543", "山东省滨州市",
"861520565", "安徽省合肥市",
"861512644", "云南省红河哈尼族彝族自治州",
"861300444", "江苏省泰州市",
"86857", "贵州省毕节地区",
"861500342", "山西省大同市",
"861869430", "甘肃省白银市",
"861389589", "黑龙江省双鸭山市",
"861554577", "黑龙江省双鸭山市",
"861308810", "四川省绵阳市",
"86151342", "辽宁省营口市",
"861322299", "江苏省苏州市",
"861897188", "湖北省恩施土家族苗族自治州",
"861379599", "四川省南充市",
"861365810", "四川省德阳市",
"861479629", "广西北海市",
"861311690", "云南省迪庆藏族自治州",
"861311453", "黑龙江省牡丹江市",
"86152447", "黑龙江省哈尔滨市",
"861300173", "山东省济南市",
"861339310", "河北省邯郸市",
"861816345", "广东省东莞市",
"86150442", "吉林省吉林市",
"861532960", "贵州省贵阳市",
"861322696", "广东省佛山市",
"861569247", "广东省佛山市",
"861522471", "河南省信阳市",
"861362936", "甘肃省张掖市",
"861588550", "贵州省贵阳市",
"861361153", "江苏省盐城市",
"861562673", "广东省茂名市",
"861340355", "山西省长治市",
"861811574", "江苏省徐州市",
"861334806", "江苏省南通市",
"86156312", "河北省保定市",
"861370860", "云南省昭通市",
"861317911", "吉林省长春市",
"86159135", "广东省湛江市",
"861884999", "云南省临沧市",
"861329311", "河北省邢台市",
"861368377", "河南省南阳市",
"861807580", "湖南省永州市",
"861522961", "陕西省延安市",
"861532470", "河南省洛阳市",
"861459603", "宁夏石嘴山市",
"86132666", "广东省深圳市",
"861829953", "新疆昌吉回族自治州",
"861333391", "河南省焦作市",
"861385135", "江苏省宿迁市",
"861363351", "山西省太原市",
"861588322", "四川省资阳市",
"861329564", "安徽省六安市",
"86170725", "江苏省南京市",
"861883847", "河南省许昌市",
"861361437", "吉林省辽源市",
"861764542", "黑龙江省佳木斯市",
"86130389", "陕西省榆林市",
"86131489", "广东省广州市",
"861865942", "福建省南平市",
"861831228", "广东省佛山市",
"861372074", "陕西省渭南市",
"861320826", "四川省绵阳市",
"86155779", "广西北海市",
"861808942", "甘肃省白银市",
"86189140", "江苏省苏州市",
"861831317", "云南省大理白族自治州",
"861517403", "辽宁省本溪市",
"861373009", "河北省邢台市",
"86132831", "河北省邯郸市",
"861302306", "安徽省合肥市",
"86189597", "福建省泉州市",
"861898743", "云南省曲靖市",
"861894349", "吉林省白山市",
"861576642", "广东省惠州市",
"861830850", "贵州省贵阳市",
"861551782", "河南省开封市",
"861390637", "山东省枣庄市",
"86152599", "福建省南平市",
"86151785", "安徽省芜湖市",
"861335784", "江苏省宿迁市",
"861325965", "宁夏中卫市",
"861345768", "广西桂林市",
"861323251", "广东省珠海市",
"861855417", "山东省泰安市",
"861502880", "河北省衡水市",
"861893459", "江苏省苏州市",
"86147637", "山东省济宁市",
"861505998", "福建省南平市",
"861473024", "河北省沧州市",
"86185463", "黑龙江省牡丹江市",
"861339818", "四川省成都市",
"861358101", "山东省淄博市",
"861308318", "安徽省安庆市",
"861318125", "山东省枣庄市",
"861369487", "江西省赣州市",
"861538958", "陕西省榆林市",
"861315434", "吉林省四平市",
"861365318", "河北省衡水市",
"861308227", "辽宁省抚顺市",
"861454162", "浙江省湖州市",
"861559012", "吉林省松原市",
"861586320", "山东省枣庄市",
"861365227", "广东省佛山市",
"861559732", "青海省玉树藏族自治州",
"861317429", "湖南省邵阳市",
"861350783", "广西桂林市",
"86182551", "安徽省合肥市",
"86158413", "辽宁省抚顺市",
"861780261", "江苏省苏州市",
"861323898", "辽宁省鞍山市",
"86979", "青海省海西蒙古族藏族自治州",
"861590804", "山东省菏泽市",
"861508049", "福建省福州市",
"861533553", "内蒙古鄂尔多斯市",
"861330486", "黑龙江省大庆市",
"861806940", "浙江省杭州市",
"861593309", "河北省邢台市",
"86835", "四川省雅安市",
"861584519", "黑龙江省佳木斯市",
"861786622", "湖北省十堰市",
"861780071", "青海省西宁市",
"861310016", "山西省晋城市",
"86133152", "河北省保定市",
"86136821", "天津市",
"861310736", "湖南省常德市",
"861367380", "河南省安阳市",
"861364441", "吉林省长春市",
"861560152", "江苏省无锡市",
"861509726", "甘肃省天水市",
"86181255", "广东省梅州市",
"861584807", "内蒙古乌兰察布市",
"861518902", "江苏省连云港市",
"861555755", "浙江省温州市",
"861392472", "广东省潮州市",
"86135910", "辽宁省铁岭市",
"861534380", "河南省郑州市",
"861537441", "甘肃省白银市",
"861590415", "辽宁省丹东市",
"861570605", "陕西省渭南市",
"86153071", "湖北省武汉市",
"86153003", "北京市",
"861860398", "河南省三门峡市",
"861345100", "湖北省鄂州市",
"861861480", "内蒙古呼伦贝尔市",
"861871749", "陕西省铜川市",
"861301343", "云南省楚雄彝族自治州",
"86183500", "福建省福州市",
"861364635", "山东省聊城市",
"86156672", "陕西省咸阳市",
"861830358", "山西省吕梁市",
"861576199", "贵州省遵义市",
"861882295", "广东省东莞市",
"861771185", "宁夏中卫市",
"861831683", "广东省东莞市",
"861353799", "广东省阳江市",
"861897829", "广西河池市",
"86137650", "贵州省贵阳市",
"861814066", "湖北省武汉市",
"861537635", "山东省聊城市",
"861323576", "浙江省台州市",
"86158687", "浙江省温州市",
"861848280", "四川省遂宁市",
"861333045", "云南省德宏傣族景颇族自治州",
"861889977", "广东省深圳市",
"86184731", "湖南省长沙市",
"86157700", "新疆阿克苏地区",
"861827237", "湖北省荆门市",
"861304859", "贵州省遵义市",
"861303526", "湖北省十堰市",
"861369793", "江西省上饶市",
"861302652", "山东省青岛市",
"861303141", "河北省承德市",
"861890680", "浙江省舟山市",
"861339753", "湖南省株洲市",
"861314526", "内蒙古包头市",
"86186776", "广西百色市",
"861313859", "广东省汕头市",
"861310354", "山西省晋中市",
"861302763", "河南省洛阳市",
"86180029", "广东省东莞市",
"861332359", "宁夏银川市",
"861803679", "江苏省泰州市",
"861309369", "安徽省池州市",
"861380247", "广东省惠州市",
"861502919", "陕西省咸阳市",
"861529347", "甘肃省酒泉市",
"861823629", "河南省信阳市",
"861879763", "湖南省怀化市",
"861803276", "河北省石家庄市",
"861569003", "河北省邯郸市",
"861530408", "辽宁省阜新市",
"861338869", "浙江省湖州市",
"86137779", "浙江省宁波市",
"861822883", "四川省广元市",
"861814679", "江西省赣州市",
"861309285", "四川省达州市",
"86159022", "天津市",
"861362399", "河南省南阳市",
"861581897", "广东省珠海市",
"861776848", "江苏省连云港市",
"861308134", "辽宁省抚顺市",
"861333250", "湖南省岳阳市",
"861368425", "四川省攀枝花市",
"861474035", "辽宁省朝阳市",
"86138778", "广西河池市",
"861560589", "浙江省金华市",
"861305425", "黑龙江省绥化市",
"861474715", "内蒙古通辽市",
"861318070", "吉林省白山市",
"861319187", "河北省石家庄市",
"861572751", "江西省景德镇市",
"86188395", "河南省漯河市",
"861459785", "新疆乌鲁木齐市",
"86188883", "山东省济南市",
"861359709", "广西柳州市",
"861818694", "湖北省孝感市",
"861516429", "辽宁省葫芦岛市",
"861347489", "内蒙古鄂尔多斯市",
"861805975", "福建省莆田市",
"861840957", "宁夏中卫市",
"861470725", "湖北省黄冈市",
"861708873", "广东省江门市",
"86798", "江西省景德镇市",
"86134324", "广东省肇庆市",
"861338698", "福建省南平市",
"861315309", "山东省菏泽市",
"861598441", "四川省绵阳市",
"861857725", "广西来宾市",
"861393895", "河南省南阳市",
"86159421", "辽宁省朝阳市",
"86182573", "浙江省嘉兴市",
"861305658", "四川省雅安市",
"861363703", "安徽省滁州市",
"861857208", "湖北省荆州市",
"861801405", "江苏省扬州市",
"861372180", "河南省南阳市",
"861573523", "山西省太原市",
"861539745", "浙江省绍兴市",
"861780571", "浙江省杭州市",
"86133102", "重庆市",
"861815878", "浙江省丽水市",
"861336441", "吉林省吉林市",
"861374077", "广西南宁市",
"861350873", "云南省红河哈尼族彝族自治州",
"861596698", "山东省淄博市",
"861808077", "四川省攀枝花市",
"861806628", "浙江省温州市",
"861597958", "江西省抚州市",
"86183156", "山东省临沂市",
"861588333", "四川省眉山市",
"861328567", "安徽省亳州市",
"861826678", "山东省济宁市",
"861518273", "四川省攀枝花市",
"861358110", "山东省枣庄市",
"86159944", "广西南宁市",
"861569472", "内蒙古包头市",
"861335874", "辽宁省营口市",
"861773762", "河南省安阳市",
"861522720", "河北省沧州市",
"861369374", "河南省许昌市",
"861520418", "辽宁省营口市",
"861327695", "福建省宁德市",
"861559099", "黑龙江省绥化市",
"861394998", "河南省周口市",
"86135846", "江苏省南通市",
"861331915", "陕西省安康市",
"861889831", "广东省湛江市",
"861569962", "黑龙江省齐齐哈尔市",
"86138787", "广西南宁市",
"861560375", "河南省平顶山市",
"86183550", "安徽省滁州市",
"861378495", "河北省保定市",
"861362312", "河北省保定市",
"861850241", "辽宁省沈阳市",
"861367935", "甘肃省武威市",
"861573841", "河南省郑州市",
"861342653", "江西省抚州市",
"861571777", "广西钦州市",
"861387189", "湖北省孝感市",
"86137600", "广东省肇庆市",
"861568244", "四川省南充市",
"861810748", "湖南省长沙市",
"861519681", "四川省资阳市",
"861505244", "江苏省无锡市",
"861813495", "山西省太原市",
"861355743", "广西桂林市",
"861341342", "广东省汕头市",
"861839622", "福建省泉州市",
"861534935", "甘肃省武威市",
"861822773", "四川省自贡市",
"861330744", "湖南省张家界市",
"861388485", "山东省滨州市",
"861333545", "陕西省汉中市",
"861319343", "河南省许昌市",
"861899588", "湖北省宜昌市",
"861562805", "贵州省毕节地区",
"861580529", "江苏省镇江市",
"861569503", "宁夏吴忠市",
"86158678", "浙江省宁波市",
"861760743", "湖南省湘西土家族苗族自治州",
"861829379", "甘肃省甘南藏族自治州",
"861552574", "山西省运城市",
"861345111", "湖北省咸宁市",
"861323669", "辽宁省本溪市",
"861379723", "湖北省咸宁市",
"861307037", "新疆克拉玛依市",
"861503647", "河南省三门峡市",
"861454340", "山东省济南市",
"861880491", "内蒙古呼和浩特市",
"861774241", "陕西省西安市",
"861881420", "广东省云浮市",
"861880933", "甘肃省平凉市",
"86177224", "广东省深圳市",
"86177841", "贵州省贵阳市",
"861323266", "广东省湛江市",
"861867169", "湖北省恩施土家族苗族自治州",
"861780256", "江苏省宿迁市",
"861870328", "河北省衡水市",
"861533838", "广东省东莞市",
"861452573", "福建省福州市",
"861316947", "广东省汕尾市",
"86187114", "湖南省衡阳市",
"86151868", "贵州省黔东南苗族侗族自治州",
"861335446", "山东省聊城市",
"861780659", "广东省肇庆市",
"86135319", "广东省揭阳市",
"861318570", "浙江省衢州市",
"861506537", "山东省济宁市",
"861778160", "四川省雅安市",
"86134170", "广东省汕头市",
"861560893", "西藏山南地区",
"861357946", "新疆昌吉回族自治州",
"861348174", "广西防城港市",
"861816903", "宁夏吴忠市",
"861361243", "广东省揭阳市",
"861817400", "江西省南昌市",
"861880972", "青海省海东地区",
"861530853", "贵州省安顺市",
"861590705", "江西省宜春市",
"861889365", "甘肃省庆阳市",
"861471495", "广东省汕头市",
"86170714", "北京市",
"861550981", "辽宁省沈阳市",
"861800851", "贵州省贵阳市",
"86152863", "贵州省黔东南苗族侗族自治州",
"861452532", "山东省青岛市",
"861325746", "湖南省永州市",
"861810149", "江苏省常州市",
"861347577", "山东省济宁市",
"86158256", "浙江省温州市",
"861348443", "陕西省渭南市",
"86137036", "黑龙江省哈尔滨市",
"861843236", "河北省廊坊市",
"861359760", "湖北省黄冈市",
"861590317", "河北省沧州市",
"861822599", "安徽省宿州市",
"861559394", "甘肃省兰州市",
"861328810", "广东省揭阳市",
"861863376", "河北省廊坊市",
"86151347", "内蒙古通辽市",
"861369666", "安徽省淮北市",
"861816562", "广东省中山市",
"861369385", "河南省南阳市",
"861529950", "新疆克拉玛依市",
"86150447", "内蒙古鄂尔多斯市",
"861302696", "广西百色市",
"861316022", "江苏省镇江市",
"861335885", "辽宁省沈阳市",
"861310182", "江苏省徐州市",
"86152442", "山东省青岛市",
"861390095", "宁夏银川市",
"861315004", "甘肃省临夏回族自治州",
"861320598", "福建省三明市",
"861832473", "安徽省合肥市",
"861452799", "新疆伊犁哈萨克自治州",
"861500565", "安徽省合肥市",
"861336740", "湖南省岳阳市",
"861819715", "青海省海东地区",
"861862670", "吉林省长春市",
"861554527", "黑龙江省鸡西市",
"86189908", "四川省南充市",
"861884855", "贵州省黔东南苗族侗族自治州",
"861520342", "山西省大同市",
"861559883", "内蒙古鄂尔多斯市",
"86130666", "辽宁省沈阳市",
"861829074", "新疆石河子市",
"861362448", "吉林省松原市",
"861809953", "新疆喀什地区",
"861593142", "河北省石家庄市",
"861770638", "山东省淄博市",
"86147855", "贵州省贵阳市",
"861847134", "湖北省荆州市",
"861809024", "四川省阿坝藏族羌族自治州",
"861388474", "山东省聊城市",
"861362594", "福建省漳州市",
"861779030", "四川省达州市",
"86159465", "黑龙江省佳木斯市",
"861588372", "四川省达州市",
"861550737", "湖南省益阳市",
"861772994", "安徽省宣城市",
"861708395", "河南省漯河市",
"861592930", "陕西省西安市",
"861309564", "浙江省嘉兴市",
"861769855", "河南省商丘市",
"86139695", "山东省聊城市",
"861811524", "江苏省镇江市",
"861587706", "广西玉林市",
"861341418", "广东省江门市",
"861338811", "四川省绵阳市",
"861360482", "黑龙江省齐齐哈尔市",
"86151396", "河南省驻马店市",
"861393373", "河北省邢台市",
"861569433", "吉林省延边朝鲜族自治州",
"861858428", "四川省攀枝花市",
"861388143", "四川省自贡市",
"861532420", "河北省邯郸市",
"861899752", "新疆阿勒泰地区",
"861561540", "山东省菏泽市",
"861848537", "贵州省黔南布依族苗族自治州",
"861325377", "河南省周口市",
"861311064", "福建省福州市",
"861530156", "江苏省苏州市",
"86150496", "内蒙古赤峰市",
"861898917", "四川省达州市",
"861502961", "陕西省西安市",
"861309311", "江苏省无锡市",
"861560384", "河南省安阳市",
"86156317", "河北省沧州市",
"861305327", "安徽省安庆市",
"861570041", "四川省遂宁市",
"86187431", "吉林省长春市",
"861778109", "四川省凉山彝族自治州",
"86189592", "福建省厦门市",
"861350395", "河南省漯河市",
"861783937", "河南省洛阳市",
"861311300", "广东省深圳市",
"86185938", "贵州省贵阳市",
"861381334", "江苏省淮安市",
"86156899", "山东省青岛市",
"86157743", "吉林省松原市",
"861870780", "广西防城港市",
"861860449", "吉林省吉林市",
"861595113", "江苏省苏州市",
"861880790", "江西省新余市",
"86183543", "山东省滨州市",
"861569157", "陕西省安康市",
"861524215", "辽宁省朝阳市",
"861586596", "山东省临沂市",
"861310559", "浙江省金华市",
"861300826", "辽宁省锦州市",
"861539197", "安徽省巢湖市",
"86181578", "浙江省丽水市",
"861320876", "云南省文山壮族苗族自治州",
"861891246", "江苏省无锡市",
"861831278", "广东省梅州市",
"861777405", "浙江省绍兴市",
"861552585", "山西省运城市",
"86145219", "吉林省长春市",
"861354249", "广东省清远市",
"861508344", "河南省南阳市",
"861572945", "河南省洛阳市",
"861593004", "河北省保定市",
"861520708", "江西省景德镇市",
"861846049", "江西省宜春市",
"861454191", "山西省太原市",
"861812833", "广东省揭阳市",
"861830627", "江苏省南通市",
"861780292", "陕西省西安市",
"861898581", "贵州省黔东南苗族侗族自治州",
"861365442", "吉林省吉林市",
"861700978", "浙江省绍兴市",
"861781747", "广东省惠州市",
"861313816", "广东省深圳市",
"86139547", "山东省济宁市",
"861369579", "浙江省丽水市",
"861347077", "安徽省阜阳市",
"861501457", "广东省潮州市",
"861510177", "甘肃省定西市",
"861576798", "广东省汕头市",
"86158206", "广东省佛山市",
"861329137", "江苏省扬州市",
"861822099", "陕西省商洛市",
"861560967", "安徽省亳州市",
"861391238", "江苏省无锡市",
"861452712", "湖北省孝感市",
"861335775", "江苏省镇江市",
"861826283", "江苏省连云港市",
"861385701", "浙江省衢州市",
"861859720", "青海省海北藏族自治州",
"861876885", "河南省郑州市",
"861592666", "湖北省荆门市",
"861316522", "山东省枣庄市",
"861862436", "辽宁省大连市",
"861358978", "山东省烟台市",
"861869626", "湖北省鄂州市",
"861454957", "江苏省盐城市",
"861534728", "湖北省襄樊市",
"861537740", "湖南省岳阳市",
"861807185", "湖北省黄石市",
"861817411", "广西南宁市",
"861879212", "安徽省阜阳市",
"861364740", "湖南省岳阳市",
"861808489", "四川省绵阳市",
"861367728", "湖北省武汉市",
"861570823", "四川省德阳市",
"861502956", "陕西省汉中市",
"861332316", "河北省廊坊市",
"861533107", "山西省大同市",
"861853223", "河北省保定市",
"861865489", "山东省烟台市",
"861341109", "广东省汕尾市",
"861329690", "内蒙古呼和浩特市",
"861329453", "山西省阳泉市",
"861577508", "广东省惠州市",
"861539966", "安徽省阜阳市",
"861801307", "江苏省苏州市",
"86132980", "内蒙古通辽市",
"861390595", "福建省泉州市",
"861593360", "河北省石家庄市",
"861316350", "黑龙江省佳木斯市",
"861340122", "江苏省泰州市",
"861517022", "江西省南昌市",
"861800944", "甘肃省兰州市",
"861332054", "云南省昆明市",
"861550517", "江苏省徐州市",
"861339691", "浙江省台州市",
"86182667", "山东省临沂市",
"861332923", "安徽省六安市",
"861539476", "内蒙古赤峰市",
"861369930", "新疆和田地区",
"861369651", "安徽省合肥市",
"86310", "河北省邯郸市",
"86147805", "四川省泸州市",
"861555941", "新疆和田地区",
"861320786", "广西百色市",
"861771443", "江苏省苏州市",
"8615201", "北京市",
"861862857", "陕西省咸阳市",
"861392433", "广东省东莞市",
"861771174", "湖南省张家界市",
"861561040", "山东省泰安市",
"861311564", "黑龙江省鹤岗市",
"861812058", "湖北省武汉市",
"86150766", "河北省廊坊市",
"861550809", "四川省广元市",
"861867111", "湖北省鄂州市",
"861893416", "广东省汕头市",
"86152041", "辽宁省锦州市",
"861868367", "四川省绵阳市",
"861821130", "广东省深圳市",
"861811024", "安徽省蚌埠市",
"86134675", "湖南省长沙市",
"861318209", "江苏省无锡市",
"861811953", "安徽省淮南市",
"861861781", "河北省秦皇岛市",
"861870870", "云南省昭通市",
"861323611", "江苏省盐城市",
"861530538", "山东省泰安市",
"86139596", "福建省漳州市",
"861459774", "新疆喀什地区",
"861575917", "福建省南平市",
"861572693", "浙江省嘉兴市",
"861501836", "广东省汕头市",
"861560477", "内蒙古鄂尔多斯市",
"861570541", "山东省济南市",
"86184572", "浙江省湖州市",
"861378397", "河南省信阳市",
"861779701", "青海省西宁市",
"861888838", "山东省菏泽市",
"86579", "浙江省金华市",
"86138434", "吉林省四平市",
"861309274", "湖北省黄冈市",
"861559773", "贵州省遵义市",
"861392157", "江苏省镇江市",
"86136865", "广东省佛山市",
"861825018", "福建省福州市",
"861580324", "河北省承德市",
"861853454", "山西省忻州市",
"861552085", "四川省南充市",
"861315142", "江苏省南京市",
"861866617", "广东省中山市",
"861800866", "湖北省随州市",
"861700468", "北京市",
"861470938", "甘肃省天水市",
"861371558", "广东省中山市",
"861380422", "辽宁省鞍山市",
"861586096", "福建省南平市",
"861310059", "广西桂林市",
"861850995", "新疆吐鲁番地区",
"861811900", "新疆哈密地区",
"86186591", "福建省福州市",
"86139532", "山东省青岛市",
"861353692", "广东省汕头市",
"861452656", "江西省吉安市",
"86180891", "陕西省西安市",
"861345507", "山东省聊城市",
"861454583", "甘肃省白银市",
"861762511", "江苏省镇江市",
"861306957", "河南省漯河市",
"861318496", "河北省衡水市",
"861565123", "江苏省常州市",
"86176451", "黑龙江省哈尔滨市",
"861452259", "浙江省金华市",
"861556338", "山东省临沂市",
"861308565", "浙江省金华市",
"861580964", "宁夏固原市",
"861768854", "广东省深圳市",
"861528444", "云南省玉溪市",
"861365565", "安徽省阜阳市",
"861595151", "江苏省无锡市",
"861867861", "山东省青岛市",
"861304863", "江苏省淮安市",
"861317264", "广东省肇庆市",
"861878863", "贵州省遵义市",
"861389475", "吉林省长春市",
"861477995", "江西省赣州市",
"861328342", "河北省邯郸市",
"861339769", "湖南省邵阳市",
"861396667", "安徽省合肥市",
"861339401", "福建省三明市",
"861815470", "广西南宁市",
"861808025", "四川省绵阳市",
"861302759", "河南省安阳市",
"861775965", "福建省泉州市",
"861898578", "贵州省黔南布依族苗族自治州",
"861838546", "贵州省黔南布依族苗族自治州",
"861828075", "四川省绵阳市",
"861536705", "湖南省衡阳市",
"861453350", "辽宁省大连市",
"861513657", "河南省驻马店市",
"861345819", "四川省达州市",
"861317074", "云南省普洱市",
"861336095", "广东省汕尾市",
"861539913", "陕西省渭南市",
"861332363", "河南省濮阳市",
"861305893", "浙江省湖州市",
"861309353", "安徽省淮北市",
"861390740", "湖南省岳阳市",
"861580846", "四川省宜宾市",
"861398705", "云南省保山市",
"861340628", "山东省济宁市",
"861803772", "河南省商丘市",
"861376830", "广西南宁市",
"861857777", "广西南宁市",
"861352947", "云南省红河哈尼族彝族自治州",
"861334555", "安徽省马鞍山市",
"861538667", "四川省德阳市",
"86183912", "陕西省榆林市",
"861800758", "广东省肇庆市",
"861897046", "江西省吉安市",
"861470777", "广西钦州市",
"861363466", "黑龙江省大庆市",
"861595997", "福建省泉州市",
"861515254", "江苏省连云港市",
"861592613", "湖北省恩施土家族苗族自治州",
"86189635", "山东省聊城市",
"861567555", "安徽省马鞍山市",
"861523993", "河南省商丘市",
"861572403", "广东省佛山市",
"861523431", "山西省阳泉市",
"861377258", "陕西省咸阳市",
"861537595", "福建省福州市",
"861319580", "甘肃省陇南市",
"861331743", "湖南省湘西土家族苗族自治州",
"861893463", "湖北省黄冈市",
"861558395", "四川省资阳市",
"861511345", "广东省河源市",
"861700017", "广东省广州市",
"861526535", "山东省烟台市",
"861363976", "青海省西宁市",
"861563633", "黑龙江省哈尔滨市",
"861596038", "福建省厦门市",
"861804041", "四川省遂宁市",
"861378041", "河北省石家庄市",
"861813041", "安徽省阜阳市",
"861533430", "云南省西双版纳傣族自治州",
"861861778", "河北省保定市",
"861327307", "河南省漯河市",
"86136099", "新疆乌鲁木齐市",
"861880250", "广东省湛江市",
"861518559", "贵州省黔东南苗族侗族自治州",
"861803990", "河南省许昌市",
"861321185", "云南省昭通市",
"861840899", "西藏昌都地区",
"86135502", "四川省成都市",
"861539326", "甘肃省酒泉市",
"86185556", "安徽省安庆市",
"861327715", "湖北省咸宁市",
"861528876", "山东省烟台市",
"861523645", "河南省新乡市",
"861814990", "新疆乌鲁木齐市",
"861559639", "陕西省商洛市",
"861327035", "江苏省徐州市",
"861372087", "福建省厦门市",
"861865170", "江苏省连云港市",
"861818034", "四川省凉山彝族自治州",
"86185605", "山东省临沂市",
"861580474", "内蒙古乌兰察布市",
"861533569", "内蒙古锡林郭勒盟",
"861760915", "陕西省安康市",
"861315648", "山东省青岛市",
"861808170", "四川省攀枝花市",
"861850643", "山东省淄博市",
"861818714", "云南省丽江市",
"861572572", "山东省淄博市",
"861380372", "河南省安阳市",
"861529272", "新疆吐鲁番地区",
"861556114", "内蒙古鄂尔多斯市",
"861358017", "广东省揭阳市",
"86185459", "黑龙江省大庆市",
"861800813", "四川省自贡市",
"861586909", "浙江省衢州市",
"861373034", "河北省承德市",
"861886614", "山东省潍坊市",
"861568482", "新疆巴音郭楞蒙古自治州",
"861811587", "江苏省泰州市",
"861530811", "四川省绵阳市",
"861597845", "河南省驻马店市",
"861505482", "山东省青岛市",
"861771905", "河南省三门峡市",
"861338718", "湖北省荆州市",
"861368384", "河南省洛阳市",
"861824497", "广东省深圳市",
"861571725", "湖北省黄冈市",
"861470346", "山西省晋城市",
"861470887", "云南省迪庆藏族自治州",
"86139740", "湖南省岳阳市",
"861313997", "新疆阿克苏地区",
"861550978", "青海省西宁市",
"861380155", "江苏省苏州市",
"86189536", "山东省潍坊市",
"86176401", "辽宁省沈阳市",
"861342669", "江西省萍乡市",
"86157374", "河南省许昌市",
"861479013", "安徽省滁州市",
"861479733", "山西省长治市",
"861534821", "四川省泸州市",
"861815239", "宁夏中卫市",
"861882941", "陕西省延安市",
"86137761", "江苏省苏州市",
"861867437", "湖南省湘潭市",
"861554084", "内蒙古乌海市",
"861824873", "江苏省泰州市",
"861378823", "广西桂林市",
"861814882", "广东省珠海市",
"861367821", "四川省眉山市",
"861896627", "浙江省温州市",
"861594893", "吉林省白城市",
"861874065", "陕西省安康市",
"861821280", "贵州省毕节地区",
"861365065", "广东省河源市",
"861579734", "湖北省黄冈市",
"861809900", "新疆昌吉回族自治州",
"861567240", "湖北省荆州市",
"861337317", "河北省沧州市",
"861564228", "辽宁省朝阳市",
"861520801", "西藏日喀则地区",
"861303849", "陕西省宝鸡市",
"861340940", "河南省商丘市",
"861301580", "福建省宁德市",
"861300344", "江苏省镇江市",
"861334055", "福建省三明市",
"861366555", "安徽省马鞍山市",
"861323490", "黑龙江省大庆市",
"861317574", "浙江省衢州市",
"861336595", "福建省泉州市",
"861840668", "广东省湛江市",
"861395657", "安徽省宣城市",
"861365275", "广东省惠州市",
"861777164", "湖北省荆州市",
"86133916", "北京市",
"861762500", "江苏省无锡市",
"861875095", "福建省南平市",
"861308275", "山东省济南市",
"861893202", "贵州省黔南布依族苗族自治州",
"861874275", "新疆喀什地区",
"861323762", "江西省九江市",
"86151332", "河北省保定市",
"861345892", "四川省乐山市",
"86189439", "吉林省长春市",
"861516074", "福建省厦门市",
"861369613", "四川省乐山市",
"861318177", "山东省泰安市",
"861856872", "河南省新乡市",
"861319080", "内蒙古鄂尔多斯市",
"861780663", "广东省揭阳市",
"861787685", "广东省深圳市",
"861310688", "广东省东莞市",
"861502488", "内蒙古巴彦淖尔市",
"861311353", "内蒙古鄂尔多斯市",
"86152437", "湖南省益阳市",
"861458775", "湖南省湘西土家族苗族自治州",
"861368967", "四川省绵阳市",
"86150432", "吉林省吉林市",
"861816445", "安徽省安庆市",
"861575193", "甘肃省白银市",
"861339410", "辽宁省铁岭市",
"861813541", "山西省晋中市",
"861393423", "山西省太原市",
"861773076", "陕西省汉中市",
"861768941", "福建省福州市",
"861340455", "吉林省松原市",
"861879406", "甘肃省临夏回族自治州",
"86180254", "广东省深圳市",
"861700517", "江苏省淮安市",
"861367543", "山东省滨州市",
"861596538", "山东省泰安市",
"861570397", "河南省商丘市",
"861471605", "广东省湛江市",
"861378541", "河北省石家庄市",
"861368477", "内蒙古赤峰市",
"861538845", "四川省阿坝藏族羌族自治州",
"861301907", "黑龙江省大庆市",
"86156065", "浙江省台州市",
"861333933", "黑龙江省双鸭山市",
"861534543", "山东省滨州市",
"861566043", "山东省济宁市",
"861593648", "河南省安阳市",
"861327535", "山东省烟台市",
"861526307", "山东省泰安市",
"86181780", "广西玉林市",
"861588422", "四川省资阳市",
"861816950", "宁夏银川市",
"861700809", "江苏省盐城市",
"861363451", "黑龙江省哈尔滨市",
"86135552", "黑龙江省黑河市",
"861533279", "内蒙古锡林郭勒盟",
"86134629", "河南省商丘市",
"861572072", "江苏省南通市",
"861361337", "河北省秦皇岛市",
"861370015", "辽宁省丹东市",
"861880545", "山东省烟台市",
"861370735", "湖南省郴州市",
"861859654", "福建省三明市",
"86185527", "江苏省宿迁市",
"861452661", "江西省南昌市",
"861889925", "新疆和田地区",
"861533069", "吉林省通化市",
"861831281", "广东省揭阳市",
"861809587", "新疆阿克苏地区",
"861302406", "安徽省芜湖市",
"861351784", "广西梧州市",
"86137954", "上海市",
"861773266", "河北省保定市",
"861511222", "广东省广州市",
"861550468", "黑龙江省鹤岗市",
"861894449", "江苏省扬州市",
"861529903", "新疆伊犁哈萨克自治州",
"861324241", "广东省深圳市",
"861773669", "广西桂林市",
"861338538", "山东省泰安市",
"861811087", "安徽省芜湖市",
"861589154", "陕西省渭南市",
"86137092", "陕西省西安市",
"861376644", "江西省宜春市",
"861761486", "内蒙古赤峰市",
"861840812", "四川省攀枝花市",
"861572713", "湖北省黄冈市",
"861584673", "黑龙江省哈尔滨市",
"861538486", "内蒙古包头市",
"861300049", "北京市",
"861832959", "陕西省铜川市",
"861571938", "甘肃省天水市",
"86156021", "天津市",
"861771235", "江苏省扬州市",
"861813605", "江苏省苏州市",
"861472714", "浙江省杭州市",
"861310902", "新疆昌吉回族自治州",
"861889518", "宁夏银川市",
"86134289", "广东省深圳市",
"861870968", "宁夏银川市",
"86157120", "广东省深圳市",
"861769620", "山西省吕梁市",
"86138335", "河北省秦皇岛市",
"86133803", "广东省深圳市",
"861363687", "陕西省延安市",
"861586636", "山东省烟台市",
"861866797", "浙江省金华市",
"861311929", "陕西省榆林市",
"861370640", "山东省济南市",
"861471541", "广东省肇庆市",
"861805104", "江苏省苏州市",
"861458784", "湖南省永州市",
"861335727", "湖南省郴州市",
"861576862", "广东省湛江市",
"861787674", "广东省深圳市",
"861840583", "浙江省嘉兴市",
"861847565", "广东省阳江市",
"861339031", "辽宁省鞍山市",
"861536415", "湖南省长沙市",
"861521455", "黑龙江省绥化市",
"861898852", "广东省佛山市",
"86159671", "浙江省杭州市",
"861330958", "宁夏银川市",
"861802048", "江苏省镇江市",
"861362634", "山东省莱芜市",
"861507162", "湖北省十堰市",
"861500318", "河北省衡水市",
"861516085", "新疆吐鲁番地区",
"861309135", "河北省承德市",
"861770598", "福建省三明市",
"861539590", "福建省福州市",
"86134791", "江西省南昌市",
"861855568", "安徽省合肥市",
"861333972", "湖北省武汉市",
"861874284", "新疆伊犁哈萨克自治州",
"861317585", "浙江省台州市",
"861815881", "安徽省芜湖市",
"861780588", "浙江省丽水市",
"86139753", "湖南省株洲市",
"86188182", "上海市",
"861705755", "广东省深圳市",
"861810954", "宁夏固原市",
"861323791", "江西省南昌市",
"861569550", "安徽省滁州市",
"861810023", "广东省东莞市",
"861768755", "广西玉林市",
"861572291", "江苏省南京市",
"861346944", "湖南省长沙市",
"861471823", "广东省河源市",
"86157507", "福建省厦门市",
"861306340", "安徽省宿州市",
"861302536", "广东省韶关市",
"861818815", "贵州省黔东南苗族侗族自治州",
"861512946", "陕西省汉中市",
"86139822", "四川省成都市",
"861333790", "江苏省无锡市",
"861801164", "四川省泸州市",
"861521940", "广东省肇庆市",
"861530869", "湖北省荆门市",
"861338408", "河南省南阳市",
"861453947", "广东省惠州市",
"861373404", "山西省太原市",
"861510070", "河北省廊坊市",
"861329710", "湖北省恩施土家族苗族自治州",
"861831839", "广东省河源市",
"861319124", "山西省运城市",
"861776741", "新疆乌鲁木齐市",
"861329030", "山东省济宁市",
"861571824", "广东省深圳市",
"861325242", "浙江省宁波市",
"861560425", "辽宁省丹东市",
"861305589", "福建省漳州市",
"861533511", "江苏省徐州市",
"861320638", "山东省青岛市",
"861855131", "江苏省南通市",
"861597744", "广西桂林市",
"86183707", "江西省赣州市",
"86158428", "湖南省岳阳市",
"861572858", "广东省韶关市",
"861519678", "四川省南充市",
"861339293", "广东省中山市",
"861770876", "云南省文山壮族苗族自治州",
"8613588", "浙江省杭州市",
"861870478", "内蒙古巴彦淖尔市",
"861359988", "福建省莆田市",
"861884620", "黑龙江省齐齐哈尔市",
"861868542", "贵州省遵义市",
"861479772", "广西柳州市",
"861558497", "吉林省辽源市",
"861887648", "福建省泉州市",
"86183726", "湖北省十堰市",
"861374918", "河南省郑州市",
"861351775", "广西玉林市",
"861557148", "湖北省黄石市",
"861318452", "江西省赣州市",
"861512864", "河北省承德市",
"861809479", "浙江省金华市",
"86157526", "云南省红河哈尼族彝族自治州",
"861881204", "河北省承德市",
"861327814", "吉林省四平市",
"861576618", "广东省梅州市",
"861323213", "广东省云浮市",
"861596408", "山东省临沂市",
"861811230", "江苏省常州市",
"861518354", "四川省南充市",
"861352522", "河南省三门峡市",
"86153622", "广东省江门市",
"86152859", "贵州省贵阳市",
"861452692", "陕西省榆林市",
"861873452", "山西省长治市",
"861881370", "广东省惠州市",
"861879536", "宁夏吴忠市",
"861586470", "山东省青岛市",
"861309929", "甘肃省临夏回族自治州",
"861828084", "四川省南充市",
"861510939", "甘肃省陇南市",
"861329979", "青海省海东地区",
"861554575", "黑龙江省佳木斯市",
"86185143", "吉林省长春市",
"861339700", "江西省南昌市",
"861454668", "广东省深圳市",
"861891308", "江苏省苏州市",
"861310273", "河北省沧州市",
"861583046", "河北省廊坊市",
"861520567", "安徽省阜阳市",
"861855278", "江苏省南京市",
"861572533", "山东省淄博市",
"861380333", "河北省石家庄市",
"861523501", "山西省忻州市",
"861341989", "河南省新乡市",
"861533987", "甘肃省嘉峪关市",
"861880610", "江苏省镇江市",
"861709512", "江苏省无锡市",
"86152784", "广西梧州市",
"861816347", "广东省清远市",
"861569245", "广东省深圳市",
"86155046", "黑龙江省哈尔滨市",
"861322248", "江苏省泰州市",
"861328418", "辽宁省阜新市",
"861889738", "青海省玉树藏族自治州",
"861760528", "江苏省扬州市",
"861385224", "江苏省淮安市",
"861889018", "湖南省邵阳市",
"861597486", "云南省昭通市",
"861397192", "湖北省十堰市",
"861591458", "广东省佛山市",
"861337804", "湖南省衡阳市",
"861802494", "广东省佛山市",
"861862912", "陕西省榆林市",
"861845821", "浙江省杭州市",
"861516585", "山东省枣庄市",
"861347525", "山东省东营市",
"86185837", "四川省成都市",
"861782042", "广东省湛江市",
"861339531", "山东省济南市",
"861361641", "山东省济南市",
"861390441", "吉林省吉林市",
"861530698", "福建省厦门市",
"861800582", "浙江省湖州市",
"861841942", "甘肃省定西市",
"861810523", "江苏省淮安市",
"86139771", "广西南宁市",
"861855068", "江苏省盐城市",
"861820646", "山东省潍坊市",
"861317085", "江西省宜春市",
"861532934", "贵州省黔南布依族苗族自治州",
"86139703", "江西省上饶市",
"861814733", "内蒙古乌海市",
"861818339", "四川省泸州市",
"86157625", "山东省潍坊市",
"861501678", "广东省东莞市",
"861302158", "山东省日照市",
"861888279", "四川省巴中市",
"861521628", "江西省吉安市",
"86132870", "山东省淄博市",
"861361435", "吉林省通化市",
"86189826", "四川省广安市",
"861883845", "河南省商丘市",
"861780796", "江西省吉安市",
"86157557", "安徽省宿州市",
"861373339", "河北省保定市",
"861834483", "江苏省泰州市",
"861302036", "辽宁省锦州市",
"861452619", "江苏省苏州市",
"86138580", "浙江省杭州市",
"86150248", "内蒙古兴安盟",
"861770786", "广西百色市",
"861454812", "广东省广州市",
"861390635", "山东省聊城市",
"86183757", "重庆市",
"861558176", "山西省晋中市",
"861533731", "湖北省黄冈市",
"861831315", "云南省大理白族自治州",
"861510570", "浙江省衢州市",
"861892140", "江苏省南京市",
"861329530", "山东省菏泽市",
"861372230", "河北省张家口市",
"861305089", "辽宁省盘锦市",
"861532828", "四川省广安市",
"861868042", "广东省东莞市",
"861356148", "山东省聊城市",
"861884948", "河北省衡水市",
"861368375", "河南省平顶山市",
"861805042", "福建省福州市",
"86135733", "山东省淄博市",
"861515614", "安徽省马鞍山市",
"861707642", "山东省济南市",
"861340357", "山西省临汾市",
"861594589", "黑龙江省佳木斯市",
"861788912", "西藏日喀则地区",
"86133722", "江苏省常州市",
"861800159", "江苏省南京市",
"861811479", "江苏省徐州市",
"861815909", "福建省福州市",
"861329469", "山西省朔州市",
"86156422", "辽宁省鞍山市",
"86152809", "四川省绵阳市",
"861879158", "陕西省安康市",
"861385137", "江苏省宿迁市",
"861533500", "江苏省常州市",
"861538744", "湖南省张家界市",
"861865575", "安徽省合肥市",
"86153030", "广东省韶关市",
"861898028", "四川省凉山彝族自治州",
"861804873", "四川省达州市",
"861378873", "广西桂林市",
"861801280", "江苏省镇江市",
"861565098", "青海省西宁市",
"861535136", "四川省宜宾市",
"861352533", "河南省驻马店市",
"861459650", "青海省海北藏族自治州",
"861508098", "湖南省岳阳市",
"861829900", "新疆喀什地区",
"861315460", "四川省泸州市",
"861570607", "陕西省渭南市",
"861355852", "四川省达州市",
"861397246", "湖北省十堰市",
"861775658", "安徽省合肥市",
"861550928", "陕西省安康市",
"861348343", "河北省石家庄市",
"861584805", "内蒙古乌兰察布市",
"861534871", "云南省昆明市",
"861593039", "河北省衡水市",
"861559548", "宁夏中卫市",
"861555757", "浙江省温州市",
"861590417", "辽宁省营口市",
"861845480", "山东省泰安市",
"861566781", "陕西省榆林市",
"86158323", "河北省张家口市",
"861863476", "山西省吕梁市",
"861897171", "湖北省黄冈市",
"861458208", "安徽省黄山市",
"861786910", "云南省保山市",
"861318127", "山东省枣庄市",
"861369485", "江西省上饶市",
"861337068", "山东省淄博市",
"861315539", "安徽省六安市",
"86151337", "河北省沧州市",
"861325967", "宁夏中卫市",
"861522488", "河南省南阳市",
"86150437", "吉林省辽源市",
"861893554", "青海省玉树藏族自治州",
"861341134", "广东省阳江市",
"861830803", "西藏山南地区",
"861855415", "山东省潍坊市",
"861527191", "湖北省武汉市",
"861834540", "黑龙江省大庆市",
"86152432", "吉林省吉林市",
"861866040", "山东省济南市",
"861568949", "山东省威海市",
"861837528", "贵州省黔东南苗族侗族自治州",
"861308708", "河南省驻马店市",
"861323849", "内蒙古锡林郭勒盟",
"86145893", "广东省珠海市",
"861314762", "吉林省白城市",
"861471832", "广东省揭阳市",
"861365708", "江西省南昌市",
"861303653", "四川省宜宾市",
"861320344", "山西省晋中市",
"861589244", "四川省南充市",
"861312586", "吉林省白城市",
"861308225", "辽宁省鞍山市",
"86132215", "浙江省绍兴市",
"86152167", "上海市",
"861847418", "湖南省娄底市",
"861365225", "广东省珠海市",
"861536568", "江苏省盐城市",
"86150162", "广东省梅州市",
"861760852", "贵州省遵义市",
"861317524", "浙江省湖州市",
"861842051", "广东省汕尾市",
"861868831", "广东省惠州市",
"861533626", "陕西省安康市",
"86135625", "山东省烟台市",
"861362348", "山西省朔州市",
"861532552", "浙江省温州市",
"861309287", "四川省内江市",
"861509562", "甘肃省金昌市",
"861786889", "陕西省商洛市",
"86184405", "新疆乌鲁木齐市",
"861581895", "广东省珠海市",
"861810712", "湖北省孝感市",
"861550834", "四川省凉山彝族自治州",
"86184659", "江西省南昌市",
"861533229", "陕西省宝鸡市",
"861553339", "河北省石家庄市",
"86135557", "辽宁省沈阳市",
"861334150", "吉林省吉林市",
"861588472", "四川省达州市",
"861810032", "河南省郑州市",
"861380245", "广东省东莞市",
"86181019", "上海市",
"861378176", "河南省南阳市",
"861569333", "甘肃省兰州市",
"861459787", "新疆乌鲁木齐市",
"861360382", "河南省郑州市",
"861567150", "湖北省恩施土家族苗族自治州",
"861368427", "四川省攀枝花市",
"861474037", "辽宁省朝阳市",
"861532320", "广东省揭阳市",
"86182254", "重庆市",
"861813176", "河北省唐山市",
"861474717", "内蒙古鄂尔多斯市",
"86139913", "陕西省西安市",
"861305427", "黑龙江省哈尔滨市",
"861309411", "湖北省襄樊市",
"861560484", "黑龙江省牡丹江市",
"861319185", "河北省石家庄市",
"861776899", "江苏省连云港市",
"861373996", "内蒙古呼伦贝尔市",
"86187441", "吉林省长春市",
"861364637", "山东省枣庄市",
"86130841", "辽宁省大连市",
"861894890", "广东省河源市",
"86130224", "辽宁省沈阳市",
"861576148", "贵州省六盘水市",
"861882297", "广东省东莞市",
"861304241", "辽宁省沈阳市",
"861872411", "江苏省徐州市",
"861350495", "辽宁省大连市",
"861867243", "湖北省荆门市",
"861399519", "宁夏银川市",
"86185948", "重庆市",
"86157733", "湖南省株洲市",
"861863844", "河南省南阳市",
"86137097", "青海省西宁市",
"861313241", "河北省衡水市",
"861507848", "广西柳州市",
"861380050", "内蒙古兴安盟",
"86189460", "黑龙江省哈尔滨市",
"86184770", "广西玉林市",
"861818996", "西藏那曲地区",
"861860349", "山西省朔州市",
"861308160", "山东省烟台市",
"86185522", "江苏省连云港市",
"86183533", "山东省淄博市",
"861454741", "浙江省温州市",
"861537637", "山东省枣庄市",
"861333047", "云南省普洱市",
"861827235", "湖北省随州市",
"861889975", "广东省广州市",
"861887118", "湖北省武汉市",
"861315970", "吉林省吉林市",
"861880362", "河南省开封市",
"86186983", "福建省泉州市",
"861839901", "新疆和田地区",
"861599702", "青海省海东地区",
"861536278", "广东省珠海市",
"861328565", "安徽省合肥市",
"861853016", "河南省焦作市",
"861853736", "河南省南阳市",
"861786901", "云南省大理白族自治州",
"861339842", "四川省南充市",
"861539747", "浙江省台州市",
"861898528", "贵州省黔东南苗族侗族自治州",
"861881596", "福建省泉州市",
"861351938", "甘肃省天水市",
"861815420", "安徽省六安市",
"861808075", "四川省广元市",
"861374075", "辽宁省营口市",
"861535558", "浙江省丽水市",
"861365342", "山西省大同市",
"861515963", "福建省福州市",
"861453572", "福建省福州市",
"861394949", "河南省平顶山市",
"86139537", "山东省济宁市",
"861593539", "山西省阳泉市",
"861566871", "辽宁省盘锦市",
"861559048", "吉林省松原市",
"861327697", "福建省漳州市",
"861331917", "陕西省宝鸡市",
"861500810", "四川省自贡市",
"86135120", "天津市",
"861528123", "四川省攀枝花市",
"861550640", "山东省菏泽市",
"86130063", "湖北省武汉市",
"86151243", "吉林省吉林市",
"861363313", "河北省张家口市",
"86151962", "四川省绵阳市",
"861356862", "四川省泸州市",
"861820758", "广东省肇庆市",
"861840955", "宁夏中卫市",
"861769506", "宁夏吴忠市",
"861470727", "湖北省襄樊市",
"861893923", "河南省鹤壁市",
"861560746", "湖南省永州市",
"861388793", "云南省西双版纳傣族自治州",
"86159311", "河北省石家庄市",
"861503993", "河南省周口市",
"861337568", "山东省临沂市",
"861379906", "福建省漳州市",
"861805977", "福建省福州市",
"861315039", "新疆博尔塔拉蒙古自治州",
"861325893", "山东省菏泽市",
"861378783", "湖南省株洲市",
"861317953", "江苏省常州市",
"861367781", "广西南宁市",
"861801407", "江苏省镇江市",
"861329353", "山西省阳泉市",
"861338246", "江苏省泰州市",
"861317024", "安徽省安庆市",
"861332416", "辽宁省锦州市",
"86183917", "陕西省宝鸡市",
"861575028", "云南省普洱市",
"861338649", "山东省滨州市",
"861393897", "河南省南阳市",
"861340678", "山东省德州市",
"861803722", "河南省洛阳市",
"861872400", "江苏省南京市",
"861311411", "云南省曲靖市",
"86184609", "江西省南昌市",
"861539376", "河南省安阳市",
"861599348", "河南省驻马店市",
"861452149", "河北省邢台市",
"861881878", "广东省深圳市",
"861337131", "山东省滨州市",
"86135429", "广东省肇庆市",
"861810532", "山东省青岛市",
"861331081", "广东省东莞市",
"861399592", "湖北省黄冈市",
"861771343", "四川省自贡市",
"861307035", "新疆伊犁哈萨克自治州",
"86184455", "黑龙江省伊春市",
"861503645", "河南省三门峡市",
"86155725", "湖北省孝感市",
"861351824", "四川省达州市",
"86138921", "陕西省延安市",
"861773141", "河北省石家庄市",
"861506535", "山东省烟台市",
"861524780", "内蒙古巴彦淖尔市",
"861772652", "四川省德阳市",
"86156213", "山东省泰安市",
"861316945", "广东省河源市",
"861839910", "新疆喀什地区",
"86176026", "天津市",
"861562519", "广东省揭阳市",
"86170779", "浙江省宁波市",
"861380550", "安徽省滁州市",
"86189790", "江西省新余市",
"861813497", "山西省运城市",
"861325196", "浙江省宁波市",
"861810799", "江西省萍乡市",
"861399739", "青海省海西蒙古族藏族自治州",
"861378497", "河北省保定市",
"861367937", "甘肃省酒泉市",
"861477859", "广东省深圳市",
"861560377", "河南省南阳市",
"861571775", "广西玉林市",
"86138444", "吉林省四平市",
"861776812", "江苏省南京市",
"861534937", "甘肃省酒泉市",
"861850859", "贵州省黔西南布依族苗族自治州",
"861333547", "陕西省宝鸡市",
"861500989", "辽宁省锦州市",
"861388487", "山东省临沂市",
"861562807", "贵州省毕节地区",
"861580424", "辽宁省大连市",
"861865120", "江苏省常州市",
"861309400", "新疆阿勒泰地区",
"861362702", "江西省九江市",
"86137633", "广东省广州市",
"861380322", "河北省廊坊市",
"861529222", "湖南省株洲市",
"861778134", "四川省宜宾市",
"861700368", "广东省东莞市",
"861589998", "广东省梅州市",
"861859321", "广西玉林市",
"861386554", "安徽省淮南市",
"86187179", "上海市",
"861890854", "贵州省黔南布依族苗族自治州",
"861335887", "辽宁省沈阳市",
"861839231", "陕西省渭南市",
"861535782", "安徽省铜陵市",
"86157614", "贵州省毕节地区",
"861760578", "浙江省丽水市",
"861354163", "四川省内江市",
"86135374", "广东省东莞市",
"8618874", "湖南省长沙市",
"861315334", "山东省日照市",
"861365418", "辽宁省沈阳市",
"861369387", "河南省南阳市",
"86155761", "湖南省常德市",
"861774816", "四川省绵阳市",
"861892250", "广东省东莞市",
"861819717", "青海省海东地区",
"861329929", "广西柳州市",
"861554525", "黑龙江省哈尔滨市",
"861317329", "山东省滨州市",
"86151250", "云南省大理白族自治州",
"861884857", "贵州省黔东南苗族侗族自治州",
"861390097", "北京市",
"861452748", "湖南省长沙市",
"861855228", "江苏省南京市",
"861472996", "陕西省西安市",
"861320549", "山东省东营市",
"861359734", "广西南宁市",
"861300282", "四川省南充市",
"861500567", "安徽省阜阳市",
"861503501", "山西省忻州市",
"861810573", "浙江省嘉兴市",
"861337683", "浙江省杭州市",
"861360154", "江苏省苏州市",
"861820582", "浙江省湖州市",
"861593409", "山西省运城市",
"861846444", "山东省聊城市",
"861850816", "四川省绵阳市",
"861590707", "江西省赣州市",
"861838908", "西藏日喀则地区",
"861800646", "山东省潍坊市",
"861872979", "陕西省铜川市",
"861367480", "内蒙古赤峰市",
"861364341", "山西省太原市",
"861347575", "山东省济宁市",
"861388651", "湖北省咸宁市",
"861537341", "河北省石家庄市",
"861590315", "河北省唐山市",
"86136176", "重庆市",
"861873904", "河南省南阳市",
"861584704", "内蒙古呼伦贝尔市",
"861357830", "云南省临沧市",
"86183823", "四川省成都市",
"86134131", "广东省惠州市",
"861471497", "广东省惠州市",
"861355193", "四川省广元市",
"86185832", "四川省成都市",
"861477816", "广东省惠州市",
"861301443", "江西省上饶市",
"861519940", "新疆阿克苏地区",
"861860498", "辽宁省阜新市",
"861524481", "四川省眉山市",
"861847160", "湖北省随州市",
"861860544", "山东省菏泽市",
"861599412", "河南省安阳市",
"861779064", "黑龙江省牡丹江市",
"861869924", "新疆伊犁哈萨克自治州",
"861510520", "江苏省徐州市",
"861325089", "浙江省温州市",
"861869053", "陕西省延安市",
"861558541", "吉林省通化市",
"861816726", "浙江省湖州市",
"861350397", "河南省安阳市",
"861830458", "黑龙江省伊春市",
"861592964", "陕西省榆林市",
"861539195", "安徽省马鞍山市",
"861888229", "四川省成都市",
"861777407", "浙江省金华市",
"86156406", "辽宁省锦州市",
"861317180", "河北省石家庄市",
"861510352", "山西省大同市",
"861552587", "山西省运城市",
"86158390", "河南省商丘市",
"86157552", "安徽省蚌埠市",
"861823013", "河北省张家口市",
"86187470", "内蒙古呼伦贝尔市",
"861458938", "广东省清远市",
"861524217", "辽宁省朝阳市",
"861569155", "陕西省安康市",
"861311710", "湖北省十堰市",
"861310454", "黑龙江省佳木斯市",
"861872469", "黑龙江省双鸭山市",
"861301174", "山东省济南市",
"861471783", "山西省大同市",
"86156427", "辽宁省盘锦市",
"86139856", "贵州省遵义市",
"861309701", "江西省抚州市",
"861550735", "湖南省郴州市",
"861553534", "山西省阳泉市",
"861769857", "河南省商丘市",
"861309469", "浙江省丽水市",
"861835114", "江苏省泰州市",
"861708397", "河南省信阳市",
"861355896", "四川省宜宾市",
"861580613", "江苏省苏州市",
"861381360", "江苏省南通市",
"861359356", "山西省运城市",
"86153505", "河北省石家庄市",
"861362499", "辽宁省辽阳市",
"861810402", "辽宁省沈阳市",
"861571784", "湖北省荆州市",
"861848535", "贵州省黔南布依族苗族自治州",
"861370468", "黑龙江省鸡西市",
"86187705", "江西省宜春市",
"861325375", "河南省周口市",
"861825042", "福建省泉州市",
"861898915", "四川省巴中市",
"861305325", "安徽省铜陵市",
"861315118", "江苏省苏州市",
"861532878", "四川省眉山市",
"861453533", "山东省威海市",
"86147696", "云南省文山壮族苗族自治州",
"861811429", "江苏省淮安市",
"86133727", "重庆市",
"861577114", "湖北省荆州市",
"861886473", "河南省安阳市",
"861565132", "江苏省南通市",
"861556644", "辽宁省朝阳市",
"86177565", "安徽省芜湖市",
"861552911", "陕西省延安市",
"861359361", "湖北省恩施土家族苗族自治州",
"861581373", "广东省深圳市",
"861807187", "湖北省咸宁市",
"86155491", "湖北省恩施土家族苗族自治州",
"861347389", "河北省唐山市",
"861853182", "河北省廊坊市",
"861398683", "湖北省宜昌市",
"861876887", "河南省郑州市",
"861311979", "青海省海西蒙古族藏族自治州",
"861571446", "吉林省白城市",
"861332706", "内蒙古鄂尔多斯市",
"861454955", "江苏省徐州市",
"861315409", "陕西省铜川市",
"861598341", "四川省凉山彝族自治州",
"861390597", "福建省泉州市",
"86130684", "广东省深圳市",
"861374584", "黑龙江省绥化市",
"861325152", "黑龙江省齐齐哈尔市",
"86189723", "湖北省荆州市",
"861533105", "河北省保定市",
"86135661", "浙江省温州市",
"86151200", "北京市",
"861801305", "江苏省苏州市",
"86131279", "上海市",
"861328284", "浙江省杭州市",
"861452302", "河南省商丘市",
"861776083", "安徽省蚌埠市",
"861453858", "甘肃省平凉市",
"861781745", "广东省珠海市",
"861333922", "安徽省阜阳市",
"861336341", "山西省太原市",
"861314791", "辽宁省锦州市",
"861887039", "江西省景德镇市",
"861810073", "湖南省长沙市",
"861772299", "广东省河源市",
"861881189", "广东省揭阳市",
"861303791", "宁夏石嘴山市",
"861588433", "四川省眉山市",
"861572947", "河南省商丘市",
"861820082", "广东省河源市",
"861355078", "四川省遂宁市",
"86188187", "广东省佛山市",
"861536683", "江苏省常州市",
"861560965", "安徽省安庆市",
"861782289", "贵州省六盘水市",
"861354851", "湖南省衡阳市",
"861393432", "山西省晋城市",
"861787624", "广东省云浮市",
"861335777", "江苏省镇江市",
"86135285", "广东省东莞市",
"861821943", "广东省湛江市",
"86186172", "广东省东莞市",
"861369474", "内蒙古乌兰察布市",
"861347075", "安徽省芜湖市",
"861593334", "河北省邢台市",
"861822048", "陕西省西安市",
"861501455", "广东省梅州市",
"861557258", "湖北省荆门市",
"861576749", "广东省湛江市",
"861329135", "江苏省盐城市",
"86135836", "山东省潍坊市",
"861590839", "四川省宜宾市",
"861353149", "广东省韶关市",
"861527162", "湖北省黄冈市",
"861520318", "河北省衡水市",
"861302994", "黑龙江省黑河市",
"861378395", "河南省漯河市",
"861362412", "辽宁省鞍山市",
"861560475", "内蒙古通辽市",
"861804395", "吉林省白山市",
"861309710", "江西省景德镇市",
"861571874", "云南省曲靖市",
"861780914", "陕西省商洛市",
"861319174", "河北省唐山市",
"861325589", "浙江省金华市",
"861532788", "湖北省黄石市",
"861558041", "湖南省郴州市",
"861869553", "宁夏银川市",
"86147595", "福建省泉州市",
"861347120", "广西柳州市",
"861369964", "四川省广安市",
"861858780", "广西河池市",
"861316766", "安徽省阜阳市",
"86183702", "江西省九江市",
"86177666", "陕西省西安市",
"861575915", "福建省南平市",
"861530742", "湖南省常德市",
"861890941", "甘肃省甘南藏族自治州",
"861866615", "广东省中山市",
"86157502", "云南省大理白族自治州",
"861341442", "广东省东莞市",
"861311530", "黑龙江省哈尔滨市",
"86134067", "山东省威海市",
"861322536", "山东省潍坊市",
"861531297", "江苏省南京市",
"861392155", "江苏省镇江市",
"861388666", "湖北省宜昌市",
"86153606", "广东省广州市",
"86156456", "黑龙江省哈尔滨市",
"86139827", "四川省泸州市",
"861319443", "福建省莆田市",
"861552087", "四川省南充市",
"86478", "内蒙古巴彦淖尔市",
"861379639", "黑龙江省双鸭山市",
"86189852", "贵州省遵义市",
"861829479", "甘肃省甘南藏族自治州",
"861889984", "广东省揭阳市",
"86145055", "黑龙江省哈尔滨市",
"861809429", "江苏省无锡市",
"861378832", "广西柳州市",
"86153555", "浙江省绍兴市",
"861599499", "广东省潮州市",
"86156559", "安徽省黄山市",
"861881320", "广东省阳江市",
"861880391", "河南省焦作市",
"861550515", "江苏省徐州市",
"861454440", "江西省新余市",
"86150859", "贵州省贵阳市",
"861357644", "江西省萍乡市",
"861870428", "辽宁省大连市",
"861881552", "安徽省蚌埠市",
"861369846", "江西省吉安市",
"861868365", "四川省绵阳市",
"861805686", "安徽省合肥市",
"861770826", "广东省中山市",
"861335346", "山西省晋城市",
"861311701", "湖北省黄石市",
"86155904", "吉林省四平市",
"861862855", "陕西省渭南市",
"86187755", "广西玉林市",
"861311469", "黑龙江省双鸭山市",
"861479722", "山西省太原市",
"861828918", "西藏拉萨市",
"86176378", "河南省郑州市",
"861884670", "黑龙江省鸡西市",
"861853038", "河南省三门峡市",
"861899549", "宁夏中卫市",
"86186544", "上海市",
"861362577", "浙江省温州市",
"861804211", "浙江省温州市",
"861388497", "山东省青岛市",
"861500999", "新疆喀什地区",
"86180221", "广东省中山市",
"86180844", "贵州省黔南布依族苗族自治州",
"861340401", "四川省绵阳市",
"86137444", "吉林省吉林市",
"861760950", "宁夏银川市",
"861829097", "新疆伊犁哈萨克自治州",
"861556463", "山东省潍坊市",
"861760631", "山东省威海市",
"861360319", "河北省邢台市",
"861787537", "广东省汕头市",
"861848926", "西藏那曲地区",
"861370550", "安徽省滁州市",
"861458959", "广东省汕头市",
"861813211", "河北省石家庄市",
"861363814", "贵州省铜仁地区",
"861470423", "辽宁省抚顺市",
"861589988", "广东省深圳市",
"861528914", "西藏林芝地区",
"86138633", "山东省日照市",
"86170778", "浙江省宁波市",
"861582522", "云南省红河哈尼族彝族自治州",
"861370322", "河北省保定市",
"861857423", "河南省郑州市",
"861810789", "广西北海市",
"861325186", "吉林省白城市",
"861830439", "吉林省白山市",
"861856920", "湖南省张家界市",
"861329854", "湖南省株洲市",
"86131555", "安徽省马鞍山市",
"861895472", "山东省烟台市",
"861539443", "福建省泉州市",
"861847670", "广东省河源市",
"86131606", "广东省珠海市",
"86159305", "河北省唐山市",
"86181652", "陕西省西安市",
"861391954", "甘肃省平凉市",
"861358247", "河北省沧州市",
"861531530", "山东省菏泽市",
"861871878", "广东省深圳市",
"861310742", "湖南省长沙市",
"861830560", "安徽省亳州市",
"861783526", "山西省吕梁市",
"86184608", "江西省南昌市",
"861301195", "河北省邢台市",
"861536766", "湖南省张家界市",
"861332438", "吉林省松原市",
"861829802", "安徽省合肥市",
"86135428", "广东省汕头市",
"861339628", "山东省滨州市",
"861399582", "湖北省鄂州市",
"861301664", "广东省东莞市",
"861331091", "陕西省延安市",
"861809441", "江苏省常州市",
"861590533", "山东省淄博市",
"861324511", "内蒙古呼和浩特市",
"861308506", "安徽省合肥市",
"861325883", "吉林省延边朝鲜族自治州",
"861378793", "湖南省湘西土家族苗族自治州",
"861820561", "安徽省淮北市",
"861808399", "新疆巴音郭楞蒙古自治州",
"861833981", "河南省郑州市",
"861367791", "江西省南昌市",
"861315872", "四川省广安市",
"861321090", "山东省威海市",
"861334510", "山东省济南市",
"861594723", "内蒙古包头市",
"861786668", "山东省临沂市",
"861598329", "四川省内江市",
"861337751", "广东省韶关市",
"861300071", "湖北省武汉市",
"861820314", "河北省承德市",
"861524972", "河南省新乡市",
"861361566", "安徽省池州市",
"86156275", "广东省茂名市",
"86185340", "山西省长治市",
"861471579", "广东省深圳市",
"861522044", "广东省汕头市",
"861388783", "云南省保山市",
"861534791", "江西省南昌市",
"861347448", "陕西省榆林市",
"861771966", "陕西省西安市",
"861521531", "山东省济南市",
"861809635", "四川省巴中市",
"86153279", "湖北省十堰市",
"861399159", "陕西省铜川市",
"861760445", "吉林省通化市",
"861576721", "广东省茂名市",
"861348630", "浙江省嘉兴市",
"861520855", "贵州省黔东南苗族侗族自治州",
"861871596", "河北省张家口市",
"861327687", "浙江省温州市",
"861334001", "江西省南昌市",
"861450409", "辽宁省大连市",
"861390230", "广东省广州市",
"861354673", "山西省晋中市",
"861535409", "河北省邢台市",
"861868763", "云南省迪庆藏族自治州",
"861454128", "河北省衡水市",
"861508588", "贵州省六盘水市",
"861556973", "甘肃省庆阳市",
"861868652", "吉林省长春市",
"861300261", "浙江省湖州市",
"861351323", "河北省张家口市",
"861805652", "安徽省芜湖市",
"861567001", "河南省安阳市",
"861844719", "内蒙古兴安盟",
"861356239", "山东省日照市",
"86158733", "湖南省株洲市",
"861370050", "山西省太原市",
"861840729", "湖北省武汉市",
"861843427", "山西省运城市",
"861898726", "云南省昆明市",
"861853538", "山西省朔州市",
"861899049", "四川省甘孜藏族自治州",
"861475606", "河北省廊坊市",
"861383996", "河南省开封市",
"861379658", "黑龙江省绥化市",
"861362077", "吉林省四平市",
"861571332", "河北省保定市",
"86188441", "吉林省长春市",
"861888241", "四川省宜宾市",
"861390969", "安徽省合肥市",
"861558529", "贵州省贵阳市",
"861894880", "广东省梅州市",
"861771197", "西藏日喀则地区",
"861879975", "新疆石河子市",
"861310308", "河北省衡水市",
"861350485", "黑龙江省双鸭山市",
"86185949", "广东省广州市",
"861356960", "河南省三门峡市",
"861320843", "黑龙江省牡丹江市",
"86668", "广东省茂名市",
"861300659", "山东省济南市",
"861324500", "湖南省常德市",
"861337766", "广东省云浮市",
"861530454", "黑龙江省佳木斯市",
"86181018", "上海市",
"861569928", "新疆巴音郭楞蒙古自治州",
"861858933", "云南省曲靖市",
"861810879", "云南省普洱市",
"861319664", "江苏省盐城市",
"861804200", "浙江省杭州市",
"861370245", "广东省中山市",
"861811441", "江苏省泰州市",
"861360392", "河南省鹤壁市",
"861459797", "新疆巴音郭楞蒙古自治州",
"861478142", "四川省宜宾市",
"861769708", "青海省西宁市",
"861844970", "新疆巴音郭楞蒙古自治州",
"861330352", "山西省大同市",
"861560548", "山东省泰安市",
"861302975", "黑龙江省齐齐哈尔市",
"861378374", "河南省许昌市",
"861560494", "辽宁省本溪市",
"861500912", "陕西省榆林市",
"861820556", "安徽省安庆市",
"86159355", "山西省长治市",
"861319195", "河北省廊坊市",
"861331591", "河北省邢台市",
"86134016", "江苏省常州市",
"86188924", "贵州省遵义市",
"861333378", "河南省开封市",
"861330520", "江苏省徐州市",
"86132273", "湖北省黄冈市",
"861472677", "四川省宜宾市",
"86132201", "北京市",
"861308006", "吉林省白城市",
"861786899", "云南省大理白族自治州",
"861348844", "陕西省榆林市",
"86155580", "浙江省杭州市",
"861830060", "河南省焦作市",
"86184658", "江西省南昌市",
"861361551", "安徽省合肥市",
"861816915", "宁夏吴忠市",
"861339940", "甘肃省酒泉市",
"861708485", "河南省漯河市",
"861321590", "福建省三明市",
"861709427", "广东省江门市",
"861334010", "江西省鹰潭市",
"861334730", "湖南省岳阳市",
"861303480", "湖南省娄底市",
"861863343", "河北省唐山市",
"861312596", "黑龙江省绥化市",
"861823007", "河北省沧州市",
"86157323", "河北省张家口市",
"861820061", "广东省佛山市",
"861314480", "广东省深圳市",
"861317341", "山东省淄博市",
"861329941", "广西南宁市",
"861892478", "广东省汕头市",
"861566791", "陕西省商洛市",
"861521711", "广东省东莞市",
"86155186", "河南省商丘市",
"861347094", "安徽省宿州市",
"861773728", "河南省许昌市",
"861595105", "江苏省扬州市",
"861339455", "黑龙江省绥化市",
"861522498", "河南省周口市",
"861361066", "山西省晋城市",
"861573908", "新疆博尔塔拉蒙古自治州",
"861346623", "云南省昭通市",
"861536751", "湖南省永州市",
"861507622", "河北省唐山市",
"861302465", "浙江省金华市",
"861859349", "湖南省邵阳市",
"861553627", "山西省运城市",
"861522544", "河南省洛阳市",
"861772831", "广东省佛山市",
"861357973", "新疆伊犁哈萨克自治州",
"861879465", "甘肃省天水市",
"861361679", "浙江省金华市",
"86177483", "内蒙古阿拉善盟",
"861590858", "贵州省六盘水市",
"861808312", "贵州省黔南布依族苗族自治州",
"86156384", "河南省郑州市",
"861334501", "山东省青岛市",
"861831947", "广东省广州市",
"861887058", "江西省萍乡市",
"86138046", "黑龙江省大庆市",
"861364329", "河北省邢台市",
"861836285", "江苏省连云港市",
"861535334", "陕西省宝鸡市",
"861453839", "四川省广元市",
"861368723", "湖北省武汉市",
"861591220", "云南省丽江市",
"861894919", "安徽省宿州市",
"861707552", "安徽省芜湖市",
"861335432", "吉林省吉林市",
"861477107", "湖北省恩施土家族苗族自治州",
"861565088", "安徽省阜阳市",
"861569834", "山西省太原市",
"861390479", "内蒙古锡林郭勒盟",
"861348476", "内蒙古赤峰市",
"861508088", "湖南省湘西土家族苗族自治州",
"861303937", "吉林省白城市",
"861335144", "黑龙江省佳木斯市",
"861550372", "河南省安阳市",
"861870391", "河南省焦作市",
"861357932", "新疆喀什地区",
"861352315", "河南省商丘市",
"861331903", "新疆和田地区",
"861476545", "安徽省合肥市",
"861805696", "安徽省滁州市",
"861760776", "广西百色市",
"861847506", "广东省梅州市",
"861350474", "吉林省四平市",
"861332008", "江西省景德镇市",
"861595626", "安徽省宣城市",
"861378079", "山东省东营市",
"861804079", "新疆乌鲁木齐市",
"86714", "湖北省黄石市",
"861815148", "江苏省无锡市",
"861398945", "浙江省杭州市",
"861365670", "浙江省衢州市",
"861390900", "四川省自贡市",
"861325012", "广东省佛山市",
"861516637", "山东省济宁市",
"861325732", "湖南省湘潭市",
"861882030", "广东省东莞市",
"861308670", "广西防城港市",
"861776231", "湖北省恩施土家族苗族自治州",
"861554206", "辽宁省铁岭市",
"861452546", "山东省东营市",
"861350143", "广东省揭阳市",
"861599489", "广东省江门市",
"861880428", "辽宁省大连市",
"861871552", "安徽省蚌埠市",
"86156558", "安徽省阜阳市",
"861597234", "湖北省孝感市",
"861880381", "河南省许昌市",
"861553358", "河北省唐山市",
"861335473", "内蒙古乌海市",
"861843242", "河北省邯郸市",
"861473635", "广西玉林市",
"861780826", "四川省广安市",
"861363715", "安徽省安庆市",
"861708474", "内蒙古呼和浩特市",
"861567645", "广西百色市",
"861536945", "河北省沧州市",
"861331562", "河北省廊坊市",
"861531287", "江苏省盐城市",
"861830009", "广东省东莞市",
"861801413", "江苏省盐城市",
"861324430", "吉林省长春市",
"861770914", "陕西省商洛市",
"861355776", "广西百色市",
"861818850", "贵州省贵阳市",
"861302984", "黑龙江省哈尔滨市",
"861804385", "吉林省松原市",
"861804666", "江西省赣州市",
"861329755", "湖北省孝感市",
"861325599", "福建省福州市",
"86152510", "江苏省盐城市",
"86477", "内蒙古鄂尔多斯市",
"861517131", "湖北省孝感市",
"86158502", "江苏省苏州市",
"861340031", "河北省石家庄市",
"861319376", "河南省开封市",
"86189333", "广东省中山市",
"861520336", "河北省廊坊市",
"861822746", "四川省甘孜藏族自治州",
"861327976", "新疆阿克苏地区",
"861813666", "江苏省南京市",
"861531411", "山东省济南市",
"861813385", "河北省秦皇岛市",
"861350846", "湖南省常德市",
"861536450", "山西省忻州市",
"861593136", "河北省衡水市",
"861582947", "陕西省西安市",
"861551296", "河北省衡水市",
"86139292", "广东省东莞市",
"861453281", "山西省晋中市",
"861760347", "山西省临汾市",
"861366867", "山东省济宁市",
"861537953", "宁夏吴忠市",
"861327466", "黑龙江省齐齐哈尔市",
"861566653", "山东省淄博市",
"861520754", "广东省汕头市",
"861535039", "江西省新余市",
"86131278", "上海市",
"861478434", "河南省许昌市",
"861453417", "辽宁省沈阳市",
"861776093", "四川省绵阳市",
"861517568", "河北省廊坊市",
"861336524", "江苏省泰州市",
"861379218", "山东省淄博市",
"861535719", "安徽省六安市",
"861322518", "江苏省连云港市",
"861364953", "宁夏固原市",
"861314781", "辽宁省沈阳市",
"861881199", "江苏省无锡市",
"861768710", "云南省昆明市",
"861772289", "广东省广州市",
"861705030", "陕西省西安市",
"861588981", "广东省潮州市",
"861569515", "江苏省盐城市",
"86152116", "湖南省永州市",
"861820092", "广东省云浮市",
"861768030", "湖南省岳阳市",
"861390587", "浙江省温州市",
"861376923", "云南省大理白族自治州",
"861590262", "贵州省遵义市",
"861376054", "广东省江门市",
"861355347", "广东省湛江市",
"861708846", "江西省新余市",
"861511917", "广东省韶关市",
"86185371", "河南省郑州市",
"861820807", "西藏日喀则地区",
"861571373", "河南省新乡市",
"861817295", "江西省宜春市",
"861335963", "黑龙江省佳木斯市",
"861315558", "安徽省阜阳市",
"861807197", "湖北省武汉市",
"861573682", "河南省许昌市",
"861319747", "湖北省荆州市",
"861398693", "湖北省武汉市",
"861398450", "贵州省遵义市",
"861850553", "安徽省芜湖市",
"861340293", "陕西省咸阳市",
"861891232", "江苏省常州市",
"861459145", "广西钦州市",
"861571794", "江西省抚州市",
"861535970", "福建省宁德市",
"861332508", "山东省临沂市",
"861814243", "陕西省榆林市",
"861570613", "江苏省苏州市",
"861525709", "浙江省嘉兴市",
"861707596", "福建省福州市",
"861317637", "山东省枣庄市",
"861804579", "黑龙江省鸡西市",
"861450970", "新疆哈密地区",
"861813579", "河南省郑州市",
"861308436", "四川省凉山彝族自治州",
"861588517", "贵州省铜仁地区",
"861365436", "吉林省长春市",
"861871052", "陕西省榆林市",
"861556932", "新疆吐鲁番地区",
"861471793", "山西省吕梁市",
"861812504", "广东省云浮市",
"861470614", "江苏省常州市",
"861359154", "辽宁省抚顺市",
"861708387", "河南省鹤壁市",
"861561603", "湖南省长沙市",
"861340700", "江西省南昌市",
"861700422", "辽宁省鞍山市",
"861328948", "陕西省榆林市",
"861348745", "湖南省怀化市",
"86188705", "江西省宜春市",
"861331272", "云南省德宏傣族景颇族自治州",
"861531400", "山东省日照市",
"861333820", "福建省宁德市",
"861362489", "内蒙古兴安盟",
"861539185", "安徽省宿州市",
"86724", "湖北省荆门市",
"861321326", "河南省安阳市",
"861315833", "贵州省安顺市",
"861327451", "黑龙江省哈尔滨市",
"861317190", "河北省保定市",
"861850838", "四川省德阳市",
"861312320", "福建省南平市",
"861809740", "青海省西宁市",
"861773935", "河南省濮阳市",
"861301376", "江苏省苏州市",
"861862442", "辽宁省大连市",
"861454729", "浙江省宁波市",
"861890353", "山西省阳泉市",
"861509081", "湖北省荆州市",
"861458323", "江西省九江市",
"861360734", "湖南省衡阳市",
"861476250", "江苏省淮安市",
"861564945", "河南省平顶山市",
"861331062", "山东省聊城市",
"861830509", "浙江省湖州市",
"861304626", "广东省茂名市",
"86157390", "新疆伊犁哈萨克自治州",
"861860321", "河北省石家庄市",
"861358422", "江苏省无锡市",
"861861390", "湖南省岳阳市",
"86188470", "内蒙古呼伦贝尔市",
"861860488", "内蒙古呼和浩特市",
"86158552", "安徽省六安市",
"861340531", "山东省济南市",
"861524491", "四川省遂宁市",
"861760886", "云南省怒江傈僳族自治州",
"861323543", "湖北省黄冈市",
"861882469", "广东省汕尾市",
"861337945", "陕西省安康市",
"861390911", "陕西省延安市",
"861558324", "四川省内江市",
"861477838", "广东省广州市",
"861312552", "辽宁省抚顺市",
"861325099", "浙江省金华市",
"861313626", "浙江省舟山市",
"861399758", "湖北省荆州市",
"861350387", "河南省南阳市",
"861316568", "湖北省黄石市",
"86134272", "广东省江门市",
"861334867", "湖南省长沙市",
"861534490", "甘肃省酒泉市",
"861534653", "河南省驻马店市",
"861593558", "山西省运城市",
"861335002", "四川省绵阳市",
"861818677", "湖北省神农架林区",
"861882979", "陕西省铜川市",
"861564693", "新疆塔城地区",
"861866827", "浙江省宁波市",
"861532586", "浙江省台州市",
"861816028", "新疆巴音郭楞蒙古自治州",
"861471487", "广东省深圳市",
"861807476", "广西百色市",
"86189296", "广东省汕头市",
"861894961", "安徽省马鞍山市",
"861534762", "广东省汕尾市",
"861707878", "云南省丽江市",
"861813930", "新疆吐鲁番地区",
"861330396", "河南省驻马店市",
"861366431", "吉林省长春市",
"861774924", "陕西省汉中市",
"861813651", "江苏省南通市",
"861705530", "河南省南阳市",
"861337693", "福建省宁德市",
"861569015", "河北省廊坊市",
"861569735", "湖南省郴州市",
"861774053", "湖北省武汉市",
"861768530", "贵州省贵阳市",
"861347312", "河北省保定市",
"861895157", "江苏省无锡市",
"861517068", "江西省吉安市",
"861364524", "江苏省宿迁市",
"86180265", "广东省惠州市",
"861336024", "广东省肇庆市",
"861858203", "四川省自贡市",
"861590572", "浙江省湖州市",
"861360356", "山西省太原市",
"861351959", "宁夏银川市",
"86183966", "山东省烟台市",
"861336953", "宁夏吴忠市",
"861378930", "湖南省湘潭市",
"861766023", "山东省青岛市",
"86158614", "江苏省无锡市",
"86185353", "山西省阳泉市",
"86131287", "广东省深圳市",
"86153511", "辽宁省沈阳市",
"861557771", "广西来宾市",
"861390087", "云南省昆明市",
"861380978", "广东省茂名市",
"861301747", "贵州省贵阳市",
"861472986", "陕西省西安市",
"861517278", "湖北省随州市",
"861551612", "河南省濮阳市",
"861864300", "吉林省四平市",
"861323821", "辽宁省阜新市",
"861535460", "吉林省吉林市",
"861339357", "山西省临汾市",
"86180681", "江苏省南通市",
"86187178", "上海市",
"861505921", "福建省漳州市",
"861315136", "江苏省盐城市",
"861820739", "湖南省邵阳市",
"861823437", "山西省阳泉市",
"861705701", "广东省深圳市",
"861315058", "云南省楚雄彝族自治州",
"86185664", "广东省佛山市",
"861365857", "贵州省毕节地区",
"86187711", "湖北省武汉市",
"861768701", "云南省昭通市",
"861369397", "河南省信阳市",
"861777703", "广西钦州市",
"861308857", "内蒙古乌兰察布市",
"861318744", "云南省昆明市",
"861351794", "江西省抚州市",
"86181626", "湖北省武汉市",
"861313500", "湖南省岳阳市",
"861350613", "江苏省苏州市",
"861879925", "新疆和田地区",
"861320256", "广东省揭阳市",
"861831858", "广东省河源市",
"861837886", "广西河池市",
"861477330", "湖南省株洲市",
"861572839", "广东省汕头市",
"861582072", "广东省惠州市",
"861300843", "陕西省渭南市",
"861870545", "山东省烟台市",
"861380735", "湖南省郴州市",
"861898776", "云南省昆明市",
"86151722", "湖北省十堰市",
"86134628", "河南省焦作市",
"861840779", "广西北海市",
"861311854", "贵州省黔南布依族苗族自治州",
"861377909", "新疆伊犁哈萨克自治州",
"861386644", "安徽省安庆市",
"86187973", "青海省西宁市",
"861831291", "浙江省温州市",
"861362027", "广东省揭阳市",
"86187901", "河南省信阳市",
"861809597", "新疆昌吉回族自治州",
"861397354", "湖南省郴州市",
"861889406", "甘肃省张掖市",
"861822658", "安徽省蚌埠市",
"861330570", "浙江省衢州市",
"861333328", "河北省秦皇岛市",
"86130201", "上海市",
"861817680", "广西钦州市",
"861709967", "浙江省金华市",
"861580397", "河南省信阳市",
"861313731", "河南省新乡市",
"861855945", "福建省龙岩市",
"861313011", "辽宁省本溪市",
"86135390", "广东省东莞市",
"86170782", "海南省海口市",
"861519168", "陕西省西安市",
"861811802", "江苏省常州市",
"861302925", "辽宁省抚顺市",
"861800556", "安徽省安庆市",
"861322975", "广东省珠海市",
"861333217", "辽宁省丹东市",
"86177612", "四川省成都市",
"861520912", "陕西省榆林市",
"861345882", "四川省宜宾市",
"861814335", "湖南省娄底市",
"861773778", "河南省郑州市",
"861470002", "福建省福州市",
"861569468", "云南省普洱市",
"861537085", "江苏省无锡市",
"861576881", "广东省河源市",
"861319090", "内蒙古赤峰市",
"861787695", "广东省惠州市",
"861507181", "湖北省宜昌市",
"861310698", "广东省江门市",
"861517415", "辽宁省丹东市",
"861891454", "江苏省泰州市",
"861855450", "山东省威海市",
"861803335", "广东省河源市",
"861322465", "黑龙江省绥化市",
"861300521", "广东省汕头市",
"861815862", "浙江省台州市",
"861770663", "浙江省温州市",
"861375808", "浙江省嘉兴市",
"861301590", "福建省莆田市",
"861320571", "浙江省杭州市",
"861397016", "江西省鹰潭市",
"861864808", "内蒙古锡林郭勒盟",
"861323480", "内蒙古包头市",
"861860654", "浙江省金华市",
"861336585", "湖南省郴州市",
"861770752", "广东省惠州市",
"861856719", "河南省南阳市",
"861800061", "河北省石家庄市",
"861300146", "河北省邯郸市",
"861571959", "宁夏银川市",
"861558651", "湖北省黄冈市",
"8615910", "北京市",
"861826662", "山东省青岛市",
"86187494", "河南省郑州市",
"861840901", "新疆博尔塔拉蒙古自治州",
"861591270", "云南省保山市",
"86155965", "陕西省榆林市",
"86158374", "河南省许昌市",
"861368773", "广西桂林市",
"86136594", "甘肃省兰州市",
"861325723", "湖北省荆门市",
"861364379", "河南省洛阳市",
"861872941", "陕西省延安市",
"861812699", "广东省梅州市",
"861857897", "广西防城港市",
"861390429", "辽宁省葫芦岛市",
"861803892", "广东省韶关市",
"86177554", "安徽省淮南市",
"861528088", "福建省泉州市",
"861370155", "江苏省苏州市",
"861313987", "新疆乌鲁木齐市",
"861361629", "江苏省扬州市",
"861589734", "湖南省衡阳市",
"861707370", "河南省商丘市",
"861854663", "黑龙江省哈尔滨市",
"861845849", "浙江省温州市",
"861338516", "贵州省六盘水市",
"861361226", "广东省江门市",
"861863905", "河南省商丘市",
"861330939", "甘肃省陇南市",
"861817757", "广西贵港市",
"861537379", "河北省邯郸市",
"861857473", "湖南省衡阳市",
"86147886", "河南省南阳市",
"861842005", "广东省梅州市",
"861568492", "湖南省邵阳市",
"861508914", "广东省汕头市",
"861858547", "贵州省毕节地区",
"861582572", "浙江省嘉兴市",
"861370372", "河南省安阳市",
"861338354", "山西省晋中市",
"861576909", "新疆伊犁哈萨克自治州",
"861309854", "贵州省黔南布依族苗族自治州",
"861570474", "内蒙古乌兰察布市",
"86158193", "广东省中山市",
"861368394", "河南省周口市",
"861313000", "辽宁省大连市",
"861776729", "浙江省丽水市",
"861856970", "湖南省湘西土家族苗族自治州",
"861538452", "陕西省榆林市",
"861558079", "湖南省邵阳市",
"861766032", "山东省菏泽市",
"861520999", "新疆伊犁哈萨克自治州",
"861331447", "贵州省毕节地区",
"861818358", "云南省曲靖市",
"861362527", "江苏省苏州市",
"861808206", "江苏省泰州市",
"861890979", "青海省海西蒙古族藏族自治州",
"861595011", "江苏省无锡市",
"861330260", "广东省东莞市",
"861772927", "陕西省铜川市",
"861835932", "福建省龙岩市",
"86185458", "黑龙江省哈尔滨市",
"861857144", "湖北省襄樊市",
"861339678", "浙江省丽水市",
"861321195", "云南省玉溪市",
"861313511", "湖南省长沙市",
"861867513", "广东省佛山市",
"861575776", "浙江省温州市",
"861539124", "内蒙古赤峰市",
"86178059", "福建省福州市",
"86130251", "广东省广州市",
"861814980", "新疆乌鲁木齐市",
"861328506", "福建省南平市",
"861372097", "山西省阳泉市",
"86181525", "宁夏固原市",
"861310869", "云南省昆明市",
"861558385", "四川省自贡市",
"861332946", "黑龙江省黑河市",
"861847620", "广东省广州市",
"861313364", "江西省九江市",
"861304364", "湖南省娄底市",
"861558269", "山西省临汾市",
"861705353", "辽宁省沈阳市",
"861871828", "广东省揭阳市",
"86136098", "辽宁省沈阳市",
"861839955", "新疆阿克苏地区",
"86181657", "广东省深圳市",
"861709893", "广东省东莞市",
"861471529", "广东省中山市",
"861890530", "山东省菏泽市",
"861800314", "河北省承德市",
"861311941", "甘肃省兰州市",
"861358991", "山东省德州市",
"861392468", "广东省江门市",
"861840910", "陕西省西安市",
"861595987", "福建省泉州市",
"861539237", "福建省龙岩市",
"861530563", "安徽省宣城市",
"861814819", "四川省攀枝花市",
"861700157", "江苏省苏州市",
"861513972", "河南省商丘市",
"861505108", "江苏省盐城市",
"861319590", "甘肃省嘉峪关市",
"861364585", "浙江省绍兴市",
"861315822", "贵州省遵义市",
"861800561", "安徽省淮北市",
"861869643", "湖北省襄樊市",
"861510958", "宁夏银川市",
"86158836", "四川省德阳市",
"861368883", "广东省深圳市",
"861839440", "甘肃省定西市",
"861300021", "上海市",
"861598379", "四川省南充市",
"861774985", "河北省张家口市",
"861594773", "内蒙古鄂尔多斯市",
"861458332", "江西省上饶市",
"861519711", "湖南省岳阳市",
"861515727", "浙江省台州市",
"861836808", "浙江省舟山市",
"861454178", "浙江省丽水市",
"861816852", "江苏省苏州市",
"86151871", "云南省文山壮族苗族自治州",
"861531929", "陕西省汉中市",
"861881642", "江西省九江市",
"861871934", "广东省梅州市",
"86151803", "江西省上饶市",
"861560236", "广东省肇庆市",
"86187764", "广西玉林市",
"861470963", "宁夏吴忠市",
"861554594", "黑龙江省鹤岗市",
"861890469", "黑龙江省双鸭山市",
"861530902", "四川省德阳市",
"861890701", "江西省鹰潭市",
"861323207", "广东省韶关市",
"861320261", "广东省肇庆市",
"861700991", "新疆乌鲁木齐市",
"861893767", "河南省郑州市",
"861351373", "河南省新乡市",
"861560639", "山东省青岛市",
"86185611", "山东省德州市",
"861857963", "江西省吉安市",
"861379475", "广东省阳江市",
"861500855", "贵州省黔东南苗族侗族自治州",
"861856792", "福建省莆田市",
"861338736", "湖南省常德市",
"861576771", "广东省汕头市",
"86158661", "山东省潍坊市",
"86153564", "浙江省宁波市",
"861882353", "广东省揭阳市",
"861353171", "广东省惠州市",
"861518192", "四川省遂宁市",
"861570964", "宁夏固原市",
"861318486", "广东省汕尾市",
"861354623", "山西省晋中市",
"861551434", "河南省周口市",
"861518538", "贵州省安顺市",
"861333870", "江苏省苏州市",
"861305512", "湖南省株洲市",
"861308948", "吉林省吉林市",
"861351332", "河北省保定市",
"861337303", "河北省张家口市",
"861700472", "内蒙古包头市",
"861330606", "福建省漳州市",
"861803856", "广东省梅州市",
"861596059", "福建省泉州市",
"861378529", "河北省张家口市",
"861895247", "江苏省无锡市",
"861345013", "广东省茂名市",
"861889158", "陕西省咸阳市",
"861505461", "山东省临沂市",
"861570485", "内蒙古兴安盟",
"861577463", "黑龙江省牡丹江市",
"861568709", "云南省昆明市",
"861313069", "辽宁省阜新市",
"861568461", "山东省临沂市",
"861812252", "广东省河源市",
"861576960", "宁夏银川市",
"861768929", "福建省龙岩市",
"861524047", "江苏省徐州市",
"861850464", "黑龙江省七台河市",
"861813529", "山西省大同市",
"861823243", "河北省承德市",
"861459540", "青海省海北藏族自治州",
"86139410", "辽宁省铁岭市",
"861873845", "河南省驻马店市",
"861896534", "福建省三明市",
"861369607", "四川省眉山市",
"86150249", "内蒙古呼和浩特市",
"861770796", "江西省吉安市",
"861806310", "山东省威海市",
"861313279", "广西北海市",
"861383339", "河北省石家庄市",
"86158557", "安徽省蚌埠市",
"861504491", "内蒙古鄂尔多斯市",
"861860371", "河南省郑州市",
"861358472", "江苏省南通市",
"861338059", "广东省揭阳市",
"861303543", "安徽省黄山市",
"861595569", "安徽省安庆市",
"861324229", "广东省揭阳市",
"861513491", "内蒙古鄂尔多斯市",
"861894388", "吉林省白山市",
"861314543", "山东省滨州市",
"861313676", "黑龙江省哈尔滨市",
"86158625", "江苏省苏州市",
"86189242", "广东省广州市",
"861304279", "湖北省襄樊市",
"861819685", "新疆阿克苏地区",
"861310800", "四川省宜宾市",
"861318845", "辽宁省辽阳市",
"861351895", "西藏昌都地区",
"861305099", "辽宁省葫芦岛市",
"861301326", "河北省秦皇岛市",
"861394837", "内蒙古鄂尔多斯市",
"861829740", "安徽省安庆市",
"861475520", "安徽省阜阳市",
"861375453", "河北省沧州市",
"861893644", "江苏省南通市",
"86137580", "浙江省舟山市",
"861311755", "湖南省郴州市",
"861780786", "广西河池市",
"86183293", "陕西省渭南市",
"861594732", "内蒙古包头市",
"861454779", "山东省青岛市",
"861301913", "吉林省长春市",
"861772042", "湖北省恩施土家族苗族自治州",
"861599942", "新疆阿克苏地区",
"861839741", "湖南省衡阳市",
"861530688", "浙江省温州市",
"861886727", "湖南省张家界市",
"861800592", "福建省厦门市",
"861876254", "江苏省淮安市",
"861302738", "湖南省娄底市",
"861590522", "江苏省徐州市",
"86145290", "广东省广州市",
"861317095", "江西省宜春市",
"861364574", "浙江省宁波市",
"861336074", "广东省茂名市",
"861597496", "云南省保山市",
"861818627", "湖北省襄樊市",
"861532642", "吉林省长春市",
"861397182", "湖北省咸宁市",
"861534849", "湖南省张家界市",
"86151916", "陕西省汉中市",
"861590350", "山西省忻州市",
"86134277", "广东省珠海市",
"86184794", "江西省抚州市",
"861802484", "广东省清远市",
"861587767", "陕西省延安市",
"861358962", "山东省枣庄市",
"86156997", "北京市",
"861452238", "浙江省嘉兴市",
"861816078", "江西省抚州市",
"861807426", "浙江省湖州市",
"861533151", "云南省保山市",
"86182681", "浙江省杭州市",
"861800019", "江苏省连云港市",
"861370333", "河北省沧州市",
"861582533", "宁夏吴忠市",
"861803437", "河北省沧州市",
"861834787", "内蒙古巴彦淖尔市",
"861322367", "山西省晋城市",
"861568971", "山东省济南市",
"861800739", "湖南省邵阳市",
"861576470", "内蒙古呼伦贝尔市",
"861528663", "贵州省黔东南苗族侗族自治州",
"861850974", "青海省海南藏族自治州",
"86181561", "安徽省淮北市",
"861389548", "宁夏银川市",
"861828094", "四川省内江市",
"861788801", "西藏拉萨市",
"861761452", "黑龙江省齐齐哈尔市",
"86131282", "广东省广州市",
"861503240", "河北省邯郸市",
"861898445", "贵州省毕节地区",
"861321747", "湖南省怀化市",
"861870610", "江苏省镇江市",
"861323871", "云南省昆明市",
"86183874", "云南省曲靖市",
"861598074", "福建省福州市",
"861835973", "福建省厦门市",
"861303821", "四川省南充市",
"861380928", "广东省广州市",
"861341999", "河南省信阳市",
"861470432", "吉林省吉林市",
"861700962", "安徽省合肥市",
"861533997", "山东省临沂市",
"861308620", "青海省海西蒙古族藏族自治州",
"861558211", "山西省太原市",
"861397059", "江西省萍乡市",
"861384918", "河南省郑州市",
"86155444", "河南省驻马店市",
"861328670", "广东省河源市",
"861335423", "辽宁省沈阳市",
"861571916", "陕西省汉中市",
"861377960", "新疆克孜勒苏柯尔克孜自治州",
"861454889", "四川省绵阳市",
"861452171", "吉林省四平市",
"861568837", "新疆喀什地区",
"861550550", "安徽省滁州市",
"86152858", "贵州省六盘水市",
"861775048", "福建省泉州市",
"861452682", "陕西省延安市",
"861880478", "内蒙古巴彦淖尔市",
"861831262", "广东省茂名市",
"861760726", "湖北省恩施土家族苗族自治州",
"861479507", "宁夏银川市",
"861323937", "甘肃省酒泉市",
"861530232", "广东省佛山市",
"861813029", "安徽省宣城市",
"861359998", "福建省泉州市",
"861804029", "辽宁省朝阳市",
"861596559", "山东省威海市",
"861378029", "河北省邢台市",
"861816896", "江苏省苏州市",
"861450648", "黑龙江省伊春市",
"86158526", "江苏省无锡市",
"861558487", "吉林省白城市",
"861313569", "湖北省武汉市",
"861824079", "河南省商丘市",
"861560906", "四川省遂宁市",
"861350424", "辽宁省大连市",
"861825299", "江苏省苏州市",
"861595069", "江苏省徐州市",
"86156810", "四川省南充市",
"861824666", "黑龙江省鹤岗市",
"861314043", "河南省焦作市",
"861322984", "广东省清远市",
"861368599", "福建省龙岩市",
"861347206", "河北省承德市",
"861309755", "山西省晋城市",
"861305599", "福建省南平市",
"861572417", "广东省汕头市",
"861778999", "西藏拉萨市",
"861824269", "辽宁省营口市",
"86158507", "江苏省南京市",
"861507633", "河北省石家庄市",
"86139246", "广东省深圳市",
"86158429", "湖南省邵阳市",
"861500336", "河北省廊坊市",
"861338559", "贵州省黔西南布依族苗族自治州",
"861303043", "内蒙古兴安盟",
"861572281", "江苏省泰州市",
"861533166", "云南省普洱市",
"861866931", "山东省临沂市",
"861313430", "吉林省长春市",
"861708424", "云南省怒江傈僳族自治州",
"861837950", "江西省抚州市",
"861768135", "安徽省阜阳市",
"86138725", "湖北省宜昌市",
"861383404", "山西省太原市",
"861878430", "四川省内江市",
"861304430", "吉林省长春市",
"861333780", "江苏省南京市",
"861355726", "广西百色市",
"86155921", "陕西省咸阳市",
"861331345", "山西省长治市",
"861539580", "浙江省舟山市",
"861874294", "新疆乌鲁木齐市",
"861336574", "安徽省合肥市",
"861815891", "安徽省淮北市",
"861365294", "广东省肇庆市",
"861335254", "黑龙江省佳木斯市",
"861323781", "广西南宁市",
"861890287", "广东省珠海市",
"861591009", "山东省济南市",
"86183336", "河北省廊坊市",
"861838149", "四川省达州市",
"86150116", "广东省佛山市",
"861800092", "广东省茂名市",
"861341912", "四川省南充市",
"861458794", "湖南省株洲市",
"86180013", "北京市",
"861318667", "江苏省常州市",
"861890411", "辽宁省大连市",
"861837445", "湖南省长沙市",
"861518853", "河南省许昌市",
"861700003", "北京市",
"861394971", "河南省濮阳市",
"861379377", "山东省济宁市",
"86151840", "辽宁省葫芦岛市",
"861501410", "广东省深圳市",
"861350253", "广东省梅州市",
"86189774", "广西梧州市",
"861537074", "江苏省泰州市",
"861770588", "浙江省嘉兴市",
"86139297", "广东省茂名市",
"861500754", "广东省汕头市",
"861333657", "广东省阳江市",
"861342179", "广东省云浮市",
"861356721", "浙江省绍兴市",
"861802377", "广东省云浮市",
"861519401", "山东省聊城市",
"861473802", "河南省安阳市",
"86134288", "广东省广州市",
"861764536", "黑龙江省鸡西市",
"861533863", "贵州省安顺市",
"861559425", "陕西省渭南市",
"861865936", "福建省宁德市",
"861582033", "广东省清远市",
"861893830", "广东省肇庆市",
"861573546", "山西省晋中市",
"861808936", "甘肃省酒泉市",
"861814861", "广东省广州市",
"86158120", "云南省昆明市",
"86137335", "湖北省十堰市",
"861338671", "辽宁省营口市",
"861576636", "广东省梅州市",
"861538496", "新疆阿克苏地区",
"86181286", "广东省东莞市",
"861555369", "山东省烟台市",
"861380640", "山东省济南市",
"861389048", "四川省内江市",
"861377470", "福建省三明市",
"861571323", "河北省张家口市",
"861879518", "宁夏银川市",
"861880968", "宁夏银川市",
"861555285", "山东省济南市",
"861390421", "辽宁省朝阳市",
"861841922", "甘肃省兰州市",
"86151911", "陕西省延安市",
"861810543", "山东省滨州市",
"861390388", "河南省洛阳市",
"86130678", "浙江省杭州市",
"861355548", "黑龙江省大兴安岭地区",
"861814800", "四川省绵阳市",
"861846474", "山东省济宁市",
"86180369", "江苏省宿迁市",
"861358912", "山东省济南市",
"861771332", "黑龙江省齐齐哈尔市",
"86159362", "河南省郑州市",
"861898906", "西藏那曲地区",
"861840909", "新疆博尔塔拉蒙古自治州",
"861821202", "贵州省贵阳市",
"86181469", "新疆乌鲁木齐市",
"861872949", "陕西省渭南市",
"861800676", "浙江省台州市",
"861559852", "内蒙古兴安盟",
"861812691", "广东省云浮市",
"861819923", "新疆巴音郭楞蒙古自治州",
"861809982", "新疆伊犁哈萨克自治州",
"861364371", "河南省郑州市",
"861581187", "广东省广州市",
"861519460", "河南省开封市",
"861301963", "辽宁省鞍山市",
"861347545", "山东省烟台市",
"861315357", "山东省威海市",
"861845841", "浙江省杭州市",
"861899783", "新疆伊犁哈萨克自治州",
"861330650", "浙江省杭州市",
"861330493", "辽宁省抚顺市",
"861537371", "河北省衡水市",
"861330931", "甘肃省兰州市",
"86136080", "四川省成都市",
"861571197", "广东省深圳市",
"861339058", "辽宁省沈阳市",
"861360453", "黑龙江省牡丹江市",
"861360690", "福建省厦门市",
"861522095", "广东省河源市",
"861876747", "浙江省温州市",
"861506416", "山东省泰安市",
"861592444", "内蒙古包头市",
"861302068", "山东省济宁市",
"861782022", "广东省河源市",
"861350796", "江西省吉安市",
"86152782", "广西玉林市",
"86150787", "广西南宁市",
"861892265", "广东省云浮市",
"861769928", "新疆阿克苏地区",
"861760548", "山东省泰安市",
"861870660", "山东省滨州市",
"86135377", "广东省深圳市",
"861569708", "云南省楚雄彝族自治州",
"861302278", "山东省潍坊市",
"86157617", "贵州省贵阳市",
"861576889", "广东省深圳市",
"861700912", "陕西省榆林市",
"86134568", "浙江省杭州市",
"861800069", "河北省秦皇岛市",
"86182686", "浙江省宁波市",
"861856711", "河南省漯河市",
"861344231", "江苏省苏州市",
"861301502", "内蒙古呼和浩特市",
"861322317", "河北省唐山市",
"861309949", "云南省德宏傣族景颇族自治州",
"86189010", "北京市",
"86134223", "广东省广州市",
"861571630", "河南省安阳市",
"861310856", "云南省大理白族自治州",
"861571951", "宁夏银川市",
"861558659", "湖北省鄂州市",
"861452778", "广西河池市",
"861857090", "湖南省衡阳市",
"861300529", "广东省梅州市",
"861762582", "江苏省无锡市",
"861893280", "河北省衡水市",
"861320579", "浙江省金华市",
"86181566", "安徽省池州市",
"861310437", "吉林省辽源市",
"861502637", "新疆阿克苏地区",
"861530882", "云南省德宏傣族景颇族自治州",
"861313739", "河南省信阳市",
"861509427", "云南省昭通市",
"861339833", "四川省达州市",
"861477805", "广东省云浮市",
"861313019", "辽宁省鞍山市",
"861529477", "河南省周口市",
"86182330", "河北省邢台市",
"861576910", "陕西省西安市",
"861889766", "广西钦州市",
"861365333", "河北省邢台市",
"861304019", "江苏省淮安市",
"861538724", "湖北省黄石市",
"861850414", "辽宁省本溪市",
"861308333", "安徽省滁州市",
"861899497", "江苏省宿迁市",
"861330787", "广西钦州市",
"861363508", "广西梧州市",
"86155957", "海南省海口市",
"861815083", "福建省福州市",
"861808610", "湖北省武汉市",
"86181160", "上海市",
"861532848", "四川省宜宾市",
"861454636", "宁夏吴忠市",
"861811890", "江苏省无锡市",
"861360224", "广东省韶关市",
"861368562", "安徽省铜陵市",
"861822896", "四川省泸州市",
"861306052", "广东省潮州市",
"861395702", "浙江省衢州市",
"861310153", "黑龙江省牡丹江市",
"861313592", "湖北省黄石市",
"861572831", "广东省揭阳市",
"861316984", "广东省江门市",
"861855158", "江苏省苏州市",
"861320651", "黑龙江省齐齐哈尔市",
"861321423", "辽宁省沈阳市",
"861860574", "浙江省宁波市",
"861320930", "甘肃省临夏回族自治州",
"861304592", "福建省厦门市",
"86152345", "山西省长治市",
"861527204", "湖北省黄石市",
"861890456", "黑龙江省黑河市",
"861595807", "浙江省舟山市",
"861458426", "河南省新乡市",
"861513348", "河北省石家庄市",
"861831299", "浙江省宁波市",
"861503684", "河南省周口市",
"861774805", "四川省绵阳市",
"861847155", "湖北省武汉市",
"861521648", "山东省青岛市",
"861778503", "贵州省贵阳市",
"861867688", "广东省广州市",
"861344093", "西藏拉萨市",
"861769834", "河南省安阳市",
"861840771", "广西南宁市",
"861305903", "黑龙江省哈尔滨市",
"861831696", "广东省佛山市",
"861332535", "陕西省安康市",
"861301144", "河北省唐山市",
"861377901", "新疆博尔塔拉蒙古自治州",
"861514684", "黑龙江省哈尔滨市",
"861320269", "广东省东莞市",
"86182585", "浙江省绍兴市",
"861890709", "江西省南昌市",
"861890461", "黑龙江省哈尔滨市",
"861893407", "广东省茂名市",
"86181799", "江西省萍乡市",
"861560631", "山东省威海市",
"86182939", "甘肃省陇南市",
"861560950", "宁夏银川市",
"861781775", "广东省惠州市",
"861589285", "四川省德阳市",
"861327363", "河北省廊坊市",
"861572977", "四川省阿坝藏族羌族自治州",
"861587537", "广东省汕头市",
"861530990", "新疆博尔塔拉蒙古自治州",
"861810043", "辽宁省大连市",
"861452888", "云南省丽江市",
"861355048", "四川省巴中市",
"86159937", "河南省焦作市",
"861501460", "广东省湛江市",
"86188184", "广东省肇庆市",
"86181665", "重庆市",
"861339558", "安徽省阜阳市",
"861800430", "吉林省长春市",
"861811982", "安徽省淮北市",
"861569342", "甘肃省兰州市",
"861856700", "河南省开封市",
"861821973", "甘肃省平凉市",
"861588134", "四川省自贡市",
"861302568", "广东省茂名市",
"86150778", "江苏省南京市",
"86188875", "云南省保山市",
"861369444", "吉林省四平市",
"86135388", "广东省广州市",
"861822078", "陕西省汉中市",
"861353179", "广东省中山市",
"86183331", "河北省石家庄市",
"861576779", "广东省湛江市",
"861814811", "四川省南充市",
"861316367", "黑龙江省哈尔滨市",
"861899873", "广东省潮州市",
"861311949", "甘肃省庆阳市",
"861346838", "山东省聊城市",
"861358999", "山东省东营市",
"861571476", "内蒙古赤峰市",
"861471521", "广东省佛山市",
"861866606", "广东省汕尾市",
"861837906", "江西省宜春市",
"861880918", "陕西省西安市",
"861319502", "宁夏石嘴山市",
"861583526", "山西省运城市",
"861598371", "四川省阿坝藏族羌族自治州",
"861575906", "福建省三明市",
"861300029", "江苏省南京市",
"861846387", "山东省临沂市",
"86132682", "广东省广州市",
"861533813", "广东省江门市",
"86130687", "广东省深圳市",
"861519719", "湖南省湘潭市",
"86137717", "江苏省苏州市",
"861454960", "黑龙江省鸡西市",
"861800569", "安徽省合肥市",
"86131562", "山东省青岛市",
"861853435", "山西省临汾市",
"861594903", "江苏省徐州市",
"861870936", "甘肃省张掖市",
"861554140", "辽宁省本溪市",
"86180960", "贵州省贵阳市",
"86153624", "广东省东莞市",
"861454470", "陕西省咸阳市",
"86158521", "江苏省徐州市",
"861313519", "湖南省邵阳市",
"861862860", "陕西省宝鸡市",
"861826252", "江苏省南通市",
"861571966", "甘肃省张掖市",
"861396603", "安徽省芜湖市",
"861310861", "云南省红河哈尼族彝族自治州",
"861335376", "河南省信阳市",
"861504702", "内蒙古呼伦贝尔市",
"861884640", "黑龙江省七台河市",
"861348332", "河北省张家口市",
"861350588", "浙江省宁波市",
"861831212", "广东省肇庆市",
"861511427", "辽宁省葫芦岛市",
"861770253", "江苏省淮安市",
"861571844", "广东省广州市",
"861533116", "辽宁省锦州市",
"861332307", "河北省沧州市",
"861304092", "湖北省荆州市",
"861821463", "云南省昆明市",
"861370294", "广东省珠海市",
"861313092", "辽宁省盘锦市",
"861345902", "福建省厦门市",
"861533758", "福建省三明市",
"86155926", "陕西省宝鸡市",
"861839148", "陕西省西安市",
"861306320", "安徽省马鞍山市",
"86137260", "广东省中山市",
"861595019", "江苏省苏州市",
"861471843", "广东省梅州市",
"861380284", "广东省广州市",
"861332715", "内蒙古赤峰市",
"861890971", "青海省西宁市",
"861530772", "广西柳州市",
"861326370", "广西南宁市",
"861346924", "湖南省岳阳市",
"86131313", "河北省张家口市",
"86187813", "四川省乐山市",
"861520433", "吉林省延边朝鲜族自治州",
"861375988", "陕西省西安市",
"861591645", "广东省潮州市",
"86130413", "吉林省吉林市",
"861572467", "辽宁省朝阳市",
"861529196", "陕西省西安市",
"861520991", "新疆乌鲁木齐市",
"861329482", "内蒙古兴安盟",
"861888082", "四川省绵阳市",
"861330877", "云南省玉溪市",
"86139241", "广东省广州市",
"86139824", "四川省泸州市",
"861319473", "四川省广元市",
"861770613", "江苏省苏州市",
"861831652", "广东省中山市",
"861863446", "山西省晋城市",
"861591730", "广东省江门市",
"861591010", "山东省济南市",
"861800011", "江苏省徐州市",
"861856769", "河南省安阳市",
"86150434", "吉林省四平市",
"861800731", "湖南省长沙市",
"86185515", "江苏省盐城市",
"861501761", "广东省深圳市",
"861323879", "云南省普洱市",
"861569418", "辽宁省阜新市",
"861508387", "江西省宜春市",
"861530733", "湖南省株洲市",
"861320374", "河南省郑州市",
"86158565", "安徽省安庆市",
"861589274", "四川省眉山市",
"861341991", "河南省南阳市",
"86132318", "河北省衡水市",
"861890492", "辽宁省鞍山市",
"861339782", "广西柳州市",
"861340920", "河南省新乡市",
"861304556", "安徽省安庆市",
"86170808", "上海市",
"861788809", "西藏日喀则地区",
"861319432", "吉林省吉林市",
"861313556", "安徽省安庆市",
"861781784", "广东省惠州市",
"861500422", "辽宁省锦州市",
"861510483", "内蒙古阿拉善盟",
"861596566", "山东省菏泽市",
"861852967", "广东省揭阳市",
"861322415", "辽宁省丹东市",
"86186768", "广东省潮州市",
"86183698", "山东省济宁市",
"861520472", "内蒙古包头市",
"861773238", "河北省承德市",
"861559193", "陕西省渭南市",
"861817244", "广西柳州市",
"861804843", "四川省攀枝花市",
"861550436", "吉林省白城市",
"861378843", "广西桂林市",
"861865545", "安徽省合肥市",
"861573935", "新疆巴音郭楞蒙古自治州",
"861454909", "湖北省宜昌市",
"861800500", "福建省福州市",
"861595138", "江苏省南通市",
"861564248", "辽宁省鞍山市",
"861338566", "安徽省池州市",
"861896647", "浙江省湖州市",
"861813843", "广东省深圳市",
"861839749", "湖南省永州市",
"861337248", "浙江省丽水市",
"861397276", "湖北省黄石市",
"861859095", "陕西省安康市",
"8618662", "江苏省苏州市",
"86177390", "河南省洛阳市",
"861354330", "广东省深圳市",
"861533159", "云南省曲靖市",
"861893537", "山西省临汾市",
"861560886", "云南省怒江傈僳族自治州",
"861534841", "湖南省郴州市",
"861315455", "黑龙江省绥化市",
"861459386", "贵州省黔西南布依族苗族自治州",
"861348373", "河北省沧州市",
"861889450", "甘肃省金昌市",
"861459665", "新疆昌吉回族自治州",
"86136350", "广西玉林市",
"86188492", "河北省保定市",
"86135612", "山东省聊城市",
"86157372", "河南省安阳市",
"86135008", "吉林省长春市",
"861510797", "江西省赣州市",
"861365155", "江苏省淮安市",
"861595561", "安徽省安庆市",
"861513499", "内蒙古巴彦淖尔市",
"861324221", "广东省中山市",
"86132222", "江苏省苏州市",
"861335664", "山东省东营市",
"861305091", "辽宁省朝阳市",
"86137952", "上海市",
"861867273", "湖北省随州市",
"861304271", "湖北省黄冈市",
"86147969", "江西省九江市",
"861308155", "内蒙古鄂尔多斯市",
"861862517", "江苏省南京市",
"861479800", "黑龙江省哈尔滨市",
"861476594", "重庆市",
"861313271", "广西南宁市",
"86137094", "重庆市",
"861338051", "广东省佛山市",
"86134290", "浙江省金华市",
"861860379", "河南省洛阳市",
"861335195", "黑龙江省鹤岗市",
"86187906", "河南省新乡市",
"86181621", "江西省赣州市",
"861880525", "江苏省扬州市",
"861505530", "安徽省芜湖市",
"861551310", "山西省长治市",
"861550857", "贵州省毕节地区",
"861568530", "贵州省贵阳市",
"861454771", "山东省枣庄市",
"861800987", "辽宁省葫芦岛市",
"861333077", "四川省南充市",
"861350752", "福建省龙岩市",
"861315940", "福建省福州市",
"861398994", "西藏林芝地区",
"861889945", "新疆塔城地区",
"861362378", "河南省开封市",
"861835703", "浙江省杭州市",
"861534523", "江苏省泰州市",
"861566023", "湖南省长沙市",
"861899395", "甘肃省白银市",
"86139038", "河南省郑州市",
"861310335", "河北省秦皇岛市",
"861477704", "广西梧州市",
"861520962", "宁夏石嘴山市",
"86159259", "浙江省金华市",
"861334694", "河南省郑州市",
"861866125", "江苏省连云港市",
"861708752", "江西省抚州市",
"861821932", "广东省肇庆市",
"861768921", "福建省厦门市",
"861813521", "山西省晋城市",
"861850704", "江西省南昌市",
"861393443", "山西省忻州市",
"861381457", "江苏省苏州市",
"861594591", "黑龙江省大庆市",
"861804146", "辽宁省沈阳市",
"861840636", "山东省潍坊市",
"861505469", "山东省菏泽市",
"86182257", "安徽省滁州市",
"861596051", "福建省莆田市",
"86180252", "广东省东莞市",
"86136909", "广东省河源市",
"861568701", "云南省昭通市",
"861310007", "山西省临汾市",
"861800511", "江苏省盐城市",
"861301432", "河北省唐山市",
"86158831", "四川省宜宾市",
"861560776", "广西百色市",
"861310980", "辽宁省大连市",
"861326934", "甘肃省张掖市",
"861866570", "广东省广州市",
"861868947", "广东省深圳市",
"861342171", "广东省湛江市",
"861331723", "湖北省黄石市",
"86147360", "广西百色市",
"86138599", "福建省厦门市",
"861805947", "福建省三明市",
"86156379", "河南省洛阳市",
"861313056", "辽宁省营口市",
"861800364", "黑龙江省哈尔滨市",
"861304138", "吉林省长春市",
"861338276", "江苏省南京市",
"861840960", "宁夏银川市",
"86186498", "福建省福州市",
"861814869", "广东省云浮市",
"861530513", "江苏省连云港市",
"861340648", "山东省青岛市",
"861390720", "湖北省宜昌市",
"861580826", "四川省广安市",
"861304056", "新疆伊犁哈萨克自治州",
"86170858", "福建省厦门市",
"861323789", "广西来宾市",
"861591001", "山东省济宁市",
"861320487", "内蒙古鄂尔多斯市",
"861338066", "广东省惠州市",
"861838141", "四川省资阳市",
"861339872", "云南省大理白族自治州",
"86158666", "山东省济南市",
"861457206", "四川省绵阳市",
"861528424", "河北省唐山市",
"861596679", "山东省威海市",
"861570914", "陕西省商洛市",
"861308372", "河南省安阳市",
"861893305", "广东省潮州市",
"861865045", "福建省福州市",
"861826296", "江苏省常州市",
"861539777", "四川省绵阳市",
"861595556", "安徽省安庆市",
"861365372", "河南省安阳市",
"86155712", "湖北省孝感市",
"861815899", "安徽省宣城市",
"861888813", "江苏省连云港市",
"86139534", "山东省德州市",
"861559078", "吉林省白城市",
"861825033", "福建省福州市",
"861453542", "江苏省常州市",
"861394979", "河南省三门峡市",
"86151876", "云南省文山壮族苗族自治州",
"86136300", "广东省佛山市",
"86457", "黑龙江省大兴安岭地区",
"86188762", "福建省泉州市",
"861328550", "安徽省滁州市",
"861890419", "辽宁省辽阳市",
"861565143", "江苏省扬州市",
"861470913", "陕西省渭南市",
"861848416", "贵州省安顺市",
"861508143", "河北省张家口市",
"861870206", "广东省湛江市",
"861550670", "广西来宾市",
"86138496", "河南省商丘市",
"861824261", "辽宁省铁岭市",
"861778991", "西藏日喀则地区",
"86134683", "山东省日照市",
"861515443", "山东省青岛市",
"861338551", "贵州省贵阳市",
"86139270", "广东省揭阳市",
"861835624", "安徽省池州市",
"861520003", "河北省石家庄市",
"86187956", "江苏省无锡市",
"861368591", "福建省泉州市",
"861582696", "湖北省黄石市",
"861586083", "福建省福州市",
"861876664", "山东省泰安市",
"861862737", "湖南省益阳市",
"861560347", "山西省临汾市",
"861470326", "河北省廊坊市",
"861595061", "江苏省宿迁市",
"861573380", "河北省保定市",
"861305591", "福建省福州市",
"861812818", "广东省韶关市",
"86138447", "吉林省延边朝鲜族自治州",
"861571745", "湖南省怀化市",
"861333577", "浙江省温州市",
"861576093", "陕西省宝鸡市",
"861572686", "浙江省温州市",
"861379915", "福建省三明市",
"86147881", "河南省驻马店市",
"861380565", "安徽省合肥市",
"861508964", "广东省茂名市",
"861565964", "福建省南平市",
"861348794", "湖南省衡阳市",
"861769515", "宁夏中卫市",
"861867902", "江西省九江市",
"861572289", "江苏省徐州市",
"861332814", "江苏省扬州市",
"861391213", "江苏省扬州市",
"861568030", "四川省南充市",
"861778157", "四川省巴中市",
"861558616", "湖北省荆门市",
"861564994", "河南省商丘市",
"861840470", "内蒙古呼伦贝尔市",
"861533082", "辽宁省大连市",
"86135504", "四川省凉山彝族自治州",
"861313314", "山西省运城市",
"861539346", "甘肃省酒泉市",
"861363438", "吉林省松原市",
"861452179", "吉林省白山市",
"861304314", "河北省唐山市",
"861807332", "湖南省株洲市",
"861817998", "江西省宜春市",
"861513412", "辽宁省抚顺市",
"861771373", "四川省遂宁市",
"861534954", "宁夏固原市",
"86182207", "陕西省宝鸡市",
"861378021", "河北省石家庄市",
"861596551", "山东省聊城市",
"861367954", "广东省清远市",
"861825291", "江苏省盐城市",
"86180202", "江苏省苏州市",
"861313561", "湖北省孝感市",
"86136959", "福建省漳州市",
"861824071", "河南省周口市",
"861310507", "福建省泉州市",
"861316975", "广东省清远市",
"861366694", "福建省莆田市",
"861320793", "江西省上饶市",
"861867563", "广东省珠海市",
"861860585", "浙江省绍兴市",
"861813021", "安徽省淮北市",
"861777554", "四川省绵阳市",
"86153615", "广东省深圳市",
"861820430", "吉林省长春市",
"861821923", "广东省惠州市",
"861453467", "黑龙江省七台河市",
"861502595", "甘肃省武威市",
"861535401", "河北省石家庄市",
"86152778", "广西河池市",
"861787644", "广东省湛江市",
"861322568", "安徽省阜阳市",
"861367532", "山东省青岛市",
"861390956", "宁夏石嘴山市",
"861388638", "湖北省孝感市",
"861576729", "广东省清远市",
"861802078", "福建省三明市",
"861569565", "安徽省合肥市",
"861770474", "内蒙古乌兰察布市",
"861399151", "陕西省安康市",
"86152111", "湖南省长沙市",
"861334009", "江西省宜春市",
"861705760", "辽宁省沈阳市",
"86156619", "内蒙古鄂尔多斯市",
"861333942", "黑龙江省齐齐哈尔市",
"861336488", "新疆喀什地区",
"861781725", "广东省惠州市",
"86180585", "浙江省宁波市",
"861300269", "浙江省温州市",
"861847550", "广东省汕尾市",
"861534532", "山东省青岛市",
"861566032", "新疆阿克苏地区",
"86155598", "云南省昆明市",
"861838600", "贵州省铜仁地区",
"861830645", "山东省烟台市",
"861770143", "江苏省泰州市",
"861356231", "山东省滨州市",
"861567009", "河南省鹤壁市",
"861844711", "内蒙古呼和浩特市",
"861521792", "广东省广州市",
"86180939", "甘肃省陇南市",
"861316018", "江苏省盐城市",
"861868403", "四川省成都市",
"86183889", "云南省临沧市",
"861300385", "福建省莆田市",
"86159932", "河南省周口市",
"861805403", "安徽省宿州市",
"861332130", "甘肃省平凉市",
"861327416", "辽宁省锦州市",
"861521460", "黑龙江省大庆市",
"861572927", "河南省濮阳市",
"86130682", "广东省惠州市",
"861337759", "广东省湛江市",
"861598321", "四川省资阳市",
"861810937", "甘肃省酒泉市",
"861584643", "黑龙江省鸡西市",
"861367799", "江西省萍乡市",
"861869851", "浙江省嘉兴市",
"861808391", "新疆阿克苏地区",
"861833989", "河南省三门峡市",
"861350914", "陕西省商洛市",
"861820569", "安徽省合肥市",
"861319254", "广东省汕尾市",
"86131567", "安徽省亳州市",
"861554045", "内蒙古鄂尔多斯市",
"861899823", "广东省汕头市",
"861379078", "广东省惠州市",
"861538393", "河北省石家庄市",
"861534799", "江西省萍乡市",
"861818806", "贵州省铜仁地区",
"86435", "吉林省通化市\、梅河口市",
"86139815", "四川省凉山彝族自治州",
"86138238", "广东省梅州市",
"861521539", "山东省临沂市",
"861370670", "浙江省衢州市",
"861471571", "广东省惠州市",
"86185376", "河南省信阳市",
"861335913", "陕西省渭南市",
"861571426", "辽宁省锦州市",
"861325062", "广东省惠州市",
"861870594", "福建省莆田市",
"861376366", "黑龙江省鸡西市",
"861369826", "四川省凉山彝族自治州",
"861500157", "新疆巴音郭楞蒙古自治州",
"861479742", "山西省吕梁市",
"861768108", "安徽省阜阳市",
"861882492", "广东省广州市",
"861894587", "黑龙江省伊春市",
"861335326", "吉林省长春市",
"861705108", "浙江省温州市",
"86155902", "吉林省四平市",
"861318795", "云南省红河哈尼族彝族自治州",
"861351745", "湖南省怀化市",
"861356093", "广东省肇庆市",
"861872482", "云南省怒江傈僳族自治州",
"861324519", "内蒙古锡林郭勒盟",
"861809449", "江苏省镇江市",
"861352365", "河南省南阳市",
"861331099", "陕西省榆林市",
"861557178", "湖北省恩施土家族苗族自治州",
"861829890", "甘肃省庆阳市",
"861386695", "安徽省宣城市",
"861357624", "江西省九江市",
"86182960", "贵州省黔西南布依族苗族自治州",
"861880584", "浙江省宁波市",
"861881340", "广东省汕头市",
"861599870", "山东省聊城市",
"861389776", "青海省海西蒙古族藏族自治州",
"86178285", "四川省凉山彝族自治州",
"861454420", "江苏省南京市",
"861346974", "湖北省恩施土家族苗族自治州",
"861845263", "江苏省南通市",
"861527052", "江西省上饶市",
"861360311", "河北省石家庄市",
"861858412", "四川省内江市",
"861588277", "四川省绵阳市",
"861530722", "湖北省武汉市",
"861518337", "四川省乐山市",
"861458630", "湖北省襄樊市",
"861458951", "广东省中山市",
"861813219", "河北省邢台市",
"86157504", "内蒙古通辽市",
"861804219", "浙江省台州市",
"861512976", "陕西省汉中市",
"861500991", "新疆乌鲁木齐市",
"861319423", "辽宁省沈阳市",
"861309482", "浙江省宁波市",
"861362780", "广西柳州市",
"861500433", "吉林省延边朝鲜族自治州",
"861899541", "宁夏固原市",
"861330827", "重庆市",
"861373103", "河北省邯郸市",
"861760639", "山东省青岛市",
"861340761", "山东省日照市",
"861343707", "江西省赣州市",
"861521970", "广东省梅州市",
"861538884", "云南省昆明市",
"86516", "江苏省徐州市",
"861340409", "四川省泸州市",
"861344128", "江苏省南京市",
"861830993", "新疆石河子市",
"861315283", "山西省阳泉市",
"861700855", "贵州省黔东南苗族侗族自治州",
"861830431", "吉林省长春市",
"861360564", "安徽省六安市",
"861325272", "辽宁省沈阳市",
"86151649", "内蒙古锡林郭勒盟",
"861801463", "江苏省连云港市",
"86183704", "江西省赣州市",
"861770964", "安徽省淮南市",
"861860953", "宁夏吴忠市",
"861810781", "广西南宁市",
"861519648", "四川省眉山市",
"861321963", "四川省自贡市",
"861537321", "河北省邢台市",
"861802578", "广东省汕尾市",
"861785896", "浙江省金华市",
"861569065", "河南省鹤壁市",
"861340756", "江苏省常州市",
"861537488", "内蒙古包头市",
"861563642", "黑龙江省伊春市",
"861334509", "山东省临沂市",
"861557231", "湖北省武汉市",
"861367712", "湖北省孝感市",
"861782072", "广东省广州市",
"861458966", "广东省汕尾市",
"861567817", "广西崇左市",
"86156415", "辽宁省丹东市",
"861517018", "江西省赣州市",
"86181139", "四川省乐山市",
"861772839", "广东省揭阳市",
"861879705", "青海省海东地区",
"861562151", "山东省日照市",
"861517738", "广西河池市",
"861361671", "浙江省杭州市",
"86183961", "福建省福州市",
"861354838", "四川省阿坝藏族羌族自治州",
"861322068", "山东省淄博市",
"861316518", "山东省济宁市",
"861869163", "陕西省西安市",
"86133715", "山东省东营市",
"861846424", "山东省青岛市",
"861334817", "江苏省常州市",
"861841972", "甘肃省定西市",
"861390471", "内蒙古呼和浩特市",
"86182369", "河南省郑州市",
"861364488", "内蒙古呼和浩特市",
"86138070", "江西省南昌市",
"861802193", "江苏省连云港市",
"861453831", "四川省德阳市",
"861801202", "江苏省徐州市",
"86189291", "广东省东莞市",
"861364321", "河北省石家庄市",
"861819973", "新疆乌鲁木齐市",
"861775886", "黑龙江省齐齐哈尔市",
"861566532", "安徽省安庆市",
"861894911", "安徽省滁州市",
"861534712", "湖北省恩施土家族苗族自治州",
"86136719", "上海市",
"86159367", "河南省濮阳市",
"861829982", "新疆巴音郭楞蒙古自治州",
"861370436", "吉林省长春市",
"861317349", "山东省菏泽市",
"861850632", "山东省枣庄市",
"861558843", "山东省威海市",
"861535410", "河北省邯郸市",
"861532957", "贵州省毕节地区",
"861321502", "福建省厦门市",
"861586440", "山东省潍坊市",
"861820069", "广东省江门市",
"86180686", "江苏省南通市",
"861353935", "广东省潮州市",
"861329949", "广西柳州市",
"861450410", "辽宁省铁岭市",
"861310243", "河北省沧州市",
"86187716", "湖北省黄冈市",
"861528485", "四川省广元市",
"861300579", "广东省珠海市",
"861587943", "江西省赣州市",
"861855248", "江苏省徐州市",
"861452728", "湖北省武汉市",
"86153516", "江苏省徐州市",
"861767115", "湖北省襄樊市",
"861844700", "内蒙古呼伦贝尔市",
"861569275", "贵州省黔东南苗族侗族自治州",
"86145016", "山西省太原市",
"861302705", "山西省晋中市",
"86152787", "广西钦州市",
"861536759", "湖南省怀化市",
"861521719", "广东省广州市",
"861379578", "四川省甘孜藏族自治州",
"861566799", "陕西省铜川市",
"861551662", "河南省新乡市",
"861770387", "河南省周口市",
"86135372", "广东省东莞市",
"86157008", "湖南省岳阳市",
"86189789", "广西南宁市",
"861877410", "湖南省岳阳市",
"861356178", "山东省泰安市",
"861825022", "福建省漳州市",
"861592826", "四川省广安市",
"861593283", "江西省宜春市",
"86155952", "宁夏银川市",
"861813292", "河北省邢台市",
"861525287", "江苏省宿迁市",
"861380418", "辽宁省阜新市",
"861325562", "山东省东营市",
"861556624", "辽宁省沈阳市",
"861811449", "江苏省南京市",
"861810871", "云南省昆明市",
"861529427", "甘肃省定西市",
"861857195", "湖北省荆门市",
"861570663", "广东省揭阳市",
"861457094", "江苏省连云港市",
"861787830", "广西河池市",
"861812301", "四川省成都市",
"86181430", "吉林省长春市",
"861370857", "贵州省毕节地区",
"861509477", "山东省泰安市",
"861361559", "安徽省黄山市",
"861331599", "河北省石家庄市",
"861570752", "广东省惠州市",
"861362870", "云南省昭通市",
"861538774", "江西省九江市",
"861328333", "河北省张家口市",
"861384655", "黑龙江省大兴安岭地区",
"861786891", "云南省玉溪市",
"861899041", "四川省阿坝藏族羌族自治州",
"86131749", "浙江省金华市",
"861390961", "安徽省淮北市",
"861888249", "四川省绵阳市",
"861830867", "贵州省毕节地区",
"861833801", "河南省安阳市",
"86186393", "河南省濮阳市",
"861303188", "河北省秦皇岛市",
"86157554", "安徽省淮南市",
"861321144", "广西贺州市",
"861599780", "湖北省十堰市",
"861840721", "湖北省随州市",
"861860524", "江苏省镇江市",
"861321473", "内蒙古乌海市",
"86151445", "吉林省通化市",
"861340334", "河北省承德市",
"861524348", "河北省秦皇岛市",
"861301423", "宁夏吴忠市",
"861300930", "辽宁省营口市",
"861379896", "广东省珠海市",
"861519920", "新疆阿克苏地区",
"861300651", "山东省青岛市",
"861510540", "山东省菏泽市",
"861892170", "江苏省泰州市",
"861331732", "湖南省湘潭市",
"861863208", "河北省邢台市",
"861360064", "浙江省温州市",
"861558521", "贵州省遵义市",
"861324592", "内蒙古巴彦淖尔市",
"86150345", "山西省运城市",
"861317044", "湖南省张家界市",
"861478310", "河南省三门峡市",
"861361516", "江苏省盐城市",
"86158389", "河南省焦作市",
"861857747", "广西钦州市",
"861352977", "云南省玉溪市",
"861390770", "广西防城港市",
"861580876", "云南省昆明市",
"861803742", "河南省驻马店市",
"861768837", "广东省广州市",
"861509152", "陕西省西安市",
"861470747", "湖南省永州市",
"8613660", "广东省广州市",
"861359295", "广东省茂名市",
"861820511", "江苏省盐城市",
"861346330", "河北省张家口市",
"861560726", "湖北省恩施土家族苗族自治州",
"861306934", "河南省开封市",
"861321432", "吉林省吉林市",
"861516544", "山东省潍坊市",
"861334560", "安徽省淮北市",
"86134412", "广东省深圳市",
"86157388", "河南省郑州市",
"861786618", "甘肃省临夏回族自治州",
"861347391", "河北省唐山市",
"86185028", "四川省成都市",
"861331773", "广西桂林市",
"861760906", "新疆阿勒泰地区",
"861365550", "安徽省滁州市",
"861805033", "福建省福州市",
"861308550", "安徽省滁州市",
"861366304", "河南省周口市",
"861883393", "河北省保定市",
"861351476", "内蒙古赤峰市",
"86184240", "辽宁省朝阳市",
"8614766", "上海市",
"861569284", "四川省宜宾市",
"861772417", "广东省云浮市",
"861453686", "陕西省渭南市",
"861566402", "河南省郑州市",
"861700336", "河北省唐山市",
"86187044", "吉林省长春市",
"861528143", "四川省宜宾市",
"861707633", "山东省济宁市",
"861588989", "广东省中山市",
"861505135", "江苏省淮安市",
"861886080", "江苏省宿迁市",
"861772281", "广东省深圳市",
"861339822", "四川省遂宁市",
"861508424", "辽宁省朝阳市",
"861806296", "湖北省荆州市",
"861815440", "湖北省武汉市",
"86155717", "湖北省宜昌市",
"861365322", "河北省保定市",
"861328372", "河南省新乡市",
"861535031", "江西省宜春市",
"861539727", "浙江省嘉兴市",
"861314789", "辽宁省锦州市",
"861535711", "安徽省滁州市",
"861308322", "安徽省黄山市",
"861898548", "贵州省六盘水市",
"861538785", "江西省赣州市",
"861865140", "江苏省镇江市",
"861372398", "山东省烟台市",
"861580598", "福建省泉州市",
"861857376", "湖南省衡阳市",
"861808140", "四川省成都市",
"861333527", "山东省泰安市",
"861882837", "四川省乐山市",
"861572542", "山东省青岛市",
"861380342", "山西省大同市",
"86159848", "四川省南充市",
"861830001", "广东省梅州市",
"86183925", "陕西省西安市",
"861367263", "广东省云浮市",
"861517139", "湖北省十堰市",
"861398036", "四川省眉山市",
"86180226", "广东省湛江市",
"861531419", "山东省聊城市",
"86138442", "吉林省吉林市",
"861360369", "黑龙江省佳木斯市",
"861858702", "云南省西双版纳傣族自治州",
"861700754", "广东省汕头市",
"861815955", "福建省漳州市",
"861570588", "浙江省丽水市",
"86186929", "湖南省邵阳市",
"861511089", "山西省阳泉市",
"861325591", "福建省福州市",
"861389950", "新疆石河子市",
"861830510", "江苏省盐城市",
"861318894", "山东省济南市",
"861351844", "四川省甘孜藏族自治州",
"861511375", "广东省揭阳市",
"86180207", "福建省厦门市",
"861536036", "广东省云浮市",
"861804071", "新疆和田地区",
"861378071", "山东省聊城市",
"86182202", "陕西省榆林市",
"861363946", "山东省德州市",
"861870399", "河南省郑州市",
"861301614", "湖南省益阳市",
"861861748", "河北省保定市",
"86151751", "河北省石家庄市",
"86188210", "上海市",
"861300793", "宁夏吴忠市",
"861521756", "广东省惠州市",
"86137926", "山东省潍坊市",
"861873894", "河南省平顶山市",
"861316925", "广东省揭阳市",
"861782033", "广东省湛江市",
"861452129", "河北省邢台市",
"861373057", "河北省沧州市",
"861524412", "山东省泰安市",
"861880389", "河南省新乡市",
"86155260", "湖南省邵阳市",
"861841933", "甘肃省白银市",
"86131601", "江苏省苏州市",
"861390992", "新疆乌鲁木齐市",
"861599481", "广东省深圳市",
"861514625", "黑龙江省哈尔滨市",
"86131673", "北京市",
"861880265", "广东省惠州市",
"861777202", "广西柳州市",
"861887283", "湖北省咸宁市",
"861324314", "河南省南阳市",
"861842718", "湖北省恩施土家族苗族自治州",
"861534073", "山西省大同市",
"861893164", "河北省廊坊市",
"861868858", "广东省肇庆市",
"861819932", "新疆乌鲁木齐市",
"861842038", "广东省揭阳市",
"861535293", "青海省黄南藏族自治州",
"861552890", "四川省雅安市",
"861337536", "山东省潍坊市",
"86155181", "河南省周口市",
"861589224", "四川省自贡市",
"861323829", "辽宁省铁岭市",
"861365245", "广东省东莞市",
"861520422", "辽宁省朝阳市",
"861567060", "河南省郑州市",
"86131418", "江苏省苏州市",
"861322683", "广东省汕头市",
"861317544", "浙江省金华市",
"86150164", "广东省湛江市",
"861557779", "广西来宾市",
"861361736", "湖南省常德市",
"861510615", "江苏省无锡市",
"861500472", "内蒙古包头市",
"86186320", "河北省邯郸市",
"861516044", "福建省泉州市",
"861334060", "四川省雅安市",
"861705709", "广东省广州市",
"861475650", "河北省唐山市",
"861366560", "安徽省合肥市",
"861768709", "云南省普洱市",
"861318147", "山东省济宁市",
"861770485", "内蒙古鄂尔多斯市",
"861535700", "安徽省芜湖市",
"861302804", "山西省大同市",
"861568929", "山东省淄博市",
"861897576", "湖南省邵阳市",
"861776960", "浙江省嘉兴市",
"861837548", "山东省泰安市",
"861837494", "湖南省岳阳市",
"861816475", "云南省保山市",
"861820731", "湖南省长沙市",
"861370006", "辽宁省锦州市",
"861505929", "福建省宁德市",
"861550948", "甘肃省兰州市",
"861570796", "江西省吉安市",
"86916", "陕西省汉中市",
"861534402", "内蒙古鄂尔多斯市",
"861335090", "四川省广安市",
"861894969", "安徽省淮南市",
"86157377", "河南省南阳市",
"861864835", "内蒙古赤峰市",
"86178625", "山东省聊城市",
"86188497", "云南省玉溪市",
"861882971", "陕西省延安市",
"86184519", "江苏省镇江市",
"861868533", "贵州省毕节地区",
"861334304", "河北省石家庄市",
"861874050", "陕西省西安市",
"861839862", "四川省乐山市",
"861803308", "广东省深圳市",
"861813256", "河北省保定市",
"861471616", "广东省清远市",
"861351630", "山东省德州市",
"861820500", "江苏省徐州市",
"861450531", "辽宁省营口市",
"861351951", "宁夏银川市",
"861390880", "云南省昆明市",
"861580786", "广西百色市",
"861813659", "江苏省常州市",
"861366439", "吉林省白山市",
"861808362", "贵州省贵阳市",
"861804256", "浙江省金华市",
"861509089", "湖北省宜昌市",
"861454721", "浙江省杭州市",
"861830501", "浙江省衢州市",
"861877168", "湖北省孝感市",
"861870312", "河北省石家庄市",
"861880575", "浙江省绍兴市",
"861327459", "黑龙江省大庆市",
"861475787", "浙江省金华市",
"86158980", "辽宁省铁岭市",
"861476936", "云南省普洱市",
"86132227", "江苏省南京市",
"861513840", "河南省南阳市",
"86130222", "天津市",
"861325091", "浙江省嘉兴市",
"861576128", "贵州省黔东南苗族侗族自治州",
"861507828", "广西柳州市",
"861340539", "山东省临沂市",
"86188446", "吉林省白城市",
"861859190", "陕西省铜川市",
"861860329", "河北省石家庄市",
"861398536", "贵州省毕节地区",
"861376674", "黑龙江省伊春市",
"861390919", "陕西省铜川市",
"861709743", "广东省深圳市",
"861524499", "四川省凉山彝族自治州",
"861810480", "内蒙古兴安盟",
"861858348", "四川省遂宁市",
"861813571", "河南省焦作市",
"861589137", "陕西省商洛市",
"86134011", "北京市",
"861590763", "广东省清远市",
"861889303", "甘肃省白银市",
"86631", "山东省威海市",
"86151773", "广西桂林市",
"861830010", "广东省中山市",
"861817154", "湖北省孝感市",
"861816965", "广西桂林市",
"861804571", "黑龙江省鸡西市",
"861368447", "四川省巴中市",
"86188549", "山东省临沂市",
"86187922", "安徽省宣城市",
"861830730", "湖南省岳阳市",
"86182252", "重庆市",
"861331394", "福建省福州市",
"861340460", "吉林省四平市",
"861538875", "云南省曲靖市",
"861534573", "浙江省嘉兴市",
"861533646", "山东省潍坊市",
"861319614", "吉林省通化市",
"861362481", "内蒙古呼和浩特市",
"86187548", "山东省泰安市",
"861362328", "河北省衡水市",
"861859637", "山东省济宁市",
"861340792", "江西省九江市",
"861785852", "浙江省绍兴市",
"8615317", "上海市",
"861337158", "山东省淄博市",
"861852427", "辽宁省盘锦市",
"861531492", "浙江省嘉兴市",
"861326788", "广东省湛江市",
"861361354", "山西省晋中市",
"861500962", "宁夏石嘴山市",
"861557901", "江西省新余市",
"861509375", "河南省平顶山市",
"86134530", "山西省忻州市",
"861313249", "河北省邢台市",
"861894802", "广东省汕头市",
"86156473", "内蒙古乌海市",
"861878646", "贵州省毕节地区",
"861517158", "湖北省宜昌市",
"861550275", "湖北省恩施土家族苗族自治州",
"861304646", "山东省潍坊市",
"86153651", "江苏省南京市",
"861303573", "广东省河源市",
"86184746", "湖南省永州市",
"86158554", "安徽省淮南市",
"861517036", "江西省上饶市",
"861892206", "广东省湛江市",
"861313646", "浙江省台州市",
"861375154", "广东省佛山市",
"861539614", "福建省厦门市",
"861311760", "广西南宁市",
"861399511", "宁夏银川市",
"861318875", "山东省聊城市",
"861872419", "江苏省宿迁市",
"861304249", "辽宁省大连市",
"861511394", "广东省汕头市",
"861558344", "四川省成都市",
"861312340", "广西防城港市",
"861862422", "辽宁省鞍山市",
"861316536", "山东省潍坊市",
"861831542", "山东省青岛市",
"861314198", "江苏省泰州市",
"861839909", "新疆吐鲁番地区",
"861847110", "湖北省十堰市",
"86131748", "天津市",
"861321346", "河南省驻马店市",
"861779014", "四川省凉山彝族自治州",
"861893674", "江苏省淮安市",
"861454749", "浙江省金华市",
"861303198", "河北省邯郸市",
"861458343", "江西省抚州市",
"861592914", "陕西省榆林市",
"86133701", "北京市",
"861506946", "山东省枣庄市",
"861599790", "湖北省随州市",
"861779734", "青海省海西蒙古族藏族自治州",
"861533221", "陕西省咸阳市",
"861457084", "江苏省南京市",
"861370418", "辽宁省阜新市",
"861880094", "四川省遂宁市",
"861881633", "山东省日照市",
"86147691", "云南省昭通市",
"861553331", "河北省邯郸市",
"861315168", "江苏省镇江市",
"861874978", "河南省焦作市",
"861577164", "陕西省渭南市",
"861308978", "黑龙江省双鸭山市",
"861331589", "河北省承德市",
"861868839", "广东省广州市",
"861842059", "广东省阳江市",
"861333840", "福建省福州市",
"861390608", "福建省三明市",
"861394854", "内蒙古通辽市",
"861786881", "陕西省延安市",
"861576955", "宁夏中卫市",
"86139851", "贵州省贵阳市",
"861557083", "湖南省娄底市",
"861580752", "广东省惠州市",
"861808655", "湖北省黄冈市",
"861776891", "江苏省宿迁市",
"861593293", "江西省上饶市",
"861309419", "湖北省咸宁市",
"861361408", "辽宁省大连市",
"861524077", "广西钦州市",
"861476025", "福建省龙岩市",
"861537102", "江苏省南京市",
"861380857", "福建省莆田市",
"861835695", "安徽省合肥市",
"861459570", "陕西省延安市",
"861896557", "福建省莆田市",
"861527199", "湖北省襄樊市",
"861859524", "山东省济南市",
"86188716", "湖北省荆州市",
"861568941", "山东省济南市",
"86315", "河北省唐山市",
"861577943", "江西省鹰潭市",
"861380436", "吉林省白城市",
"861897179", "湖北省随州市",
"861566789", "陕西省安康市",
"861315531", "安徽省芜湖市",
"861770397", "河南省驻马店市",
"861579808", "江西省萍乡市",
"86189788", "广西南宁市",
"861850944", "甘肃省平凉市",
"86185662", "广东省深圳市",
"861511883", "广东省深圳市",
"861379183", "山东省青岛市",
"861521872", "广东省深圳市",
"861766043", "山东省青岛市",
"86158612", "江苏省连云港市",
"861303402", "安徽省六安市",
"861357407", "湖南省湘潭市",
"861308468", "浙江省台州市",
"86183877", "云南省普洱市",
"86152600", "福建省漳州市",
"861876237", "江苏省泰州市",
"86147163", "广东省深圳市",
"861321777", "广西钦州市",
"861314402", "广东省中山市",
"861323841", "内蒙古呼和浩特市",
"861340833", "四川省乐山市",
"861709345", "广东省佛山市",
"86155766", "湖南省长沙市",
"861301727", "湖南省常德市",
"86136103", "广东省广州市",
"861889705", "青海省西宁市",
"861590686", "浙江省台州市",
"861774944", "河南省焦作市",
"861802183", "江苏省徐州市",
"86134136", "广东省湛江市",
"86136718", "上海市",
"861364544", "山东省烟台市",
"861477866", "广东省湛江市",
"861336044", "广东省江门市",
"861829992", "新疆哈密地区",
"861534879", "云南省普洱市",
"861330615", "江苏省无锡市",
"861785886", "浙江省杭州市",
"861532672", "内蒙古包头市",
"861537498", "内蒙古锡林郭勒盟",
"861850866", "湖北省武汉市",
"86134274", "广东省江门市",
"86184797", "江西省赣州市",
"861556280", "山东省菏泽市",
"86181138", "四川省宜宾市",
"86180720", "浙江省温州市",
"861502085", "山东省莱芜市",
"86135565", "广东省肇庆市",
"861816048", "新疆昌吉回族自治州",
"861573898", "河南省洛阳市",
"861837965", "江西省抚州市",
"861866665", "广东省河源市",
"861477851", "广东省汕尾市",
"861315293", "山西省朔州市",
"861399731", "青海省西宁市",
"86151648", "内蒙古巴彦淖尔市",
"861596435", "山东省聊城市",
"861561744", "河南省郑州市",
"861334625", "山东省聊城市",
"861810791", "江西省南昌市",
"861802776", "广东省茂名市",
"861323954", "宁夏固原市",
"86153601", "广东省惠州市",
"861303073", "辽宁省本溪市",
"86156451", "黑龙江省哈尔滨市",
"861340558", "江苏省镇江市",
"861567625", "广西柳州市",
"861309760", "山西省阳泉市",
"861362462", "黑龙江省齐齐哈尔市",
"861593168", "河北省石家庄市",
"861332750", "山西省忻州市",
"861855984", "福建省三明市",
"861309492", "江苏省淮安市",
"861500981", "辽宁省锦州市",
"861362790", "江西省新余市",
"861850851", "贵州省贵阳市",
"861775268", "湖南省娄底市",
"861316036", "江苏省南通市",
"861509186", "陕西省西安市",
"861331375", "福建省福州市",
"861327438", "吉林省松原市",
"861453652", "江苏省扬州市",
"861331089", "广东省广州市",
"861452526", "山东省滨州市",
"86155447", "河北省邯郸市",
"861398925", "四川省凉山彝族自治州",
"861386685", "安徽省铜陵市",
"861453763", "广西柳州市",
"861399500", "宁夏银川市",
"861311419", "云南省保山市",
"861780846", "贵州省毕节地区",
"861880594", "福建省莆田市",
"861337139", "山东省烟台市",
"861452141", "河北省承德市",
"861338435", "吉林省通化市",
"861870584", "浙江省宁波市",
"861476525", "河南省郑州市",
"861868707", "云南省昭通市",
"861595249", "江苏省无锡市",
"861335124", "黑龙江省七台河市",
"861459070", "广东省潮州市",
"861314263", "内蒙古包头市",
"861458187", "浙江省丽水市",
"861513527", "山西省吕梁市",
"861772403", "广东省广州市",
"861550565", "安徽省芜湖市",
"861773149", "河北省唐山市",
"86139873", "云南省红河哈尼族彝族自治州",
"861535678", "浙江省丽水市",
"861802347", "广东省广州市",
"861538383", "河北省石家庄市",
"861500737", "湖南省益阳市",
"861315031", "新疆乌鲁木齐市",
"861556407", "山东省滨州市",
"86138239", "广东省中山市",
"86157059", "福建省福州市",
"861459125", "广西贺州市",
"86132700", "江苏省盐城市",
"861859953", "福建省福州市",
"861332687", "广东省东莞市",
"861309108", "河北省唐山市",
"86152650", "山东省菏泽市",
"861359311", "山西省晋中市",
"861335237", "辽宁省盘锦市",
"861380670", "浙江省嘉兴市",
"861338641", "山东省济南市",
"86155496", "湖北省黄冈市",
"861598498", "四川省凉山彝族自治州",
"861367789", "广西玉林市",
"861808428", "贵州省六盘水市",
"861828478", "四川省遂宁市",
"861336498", "新疆石河子市",
"861867742", "广西梧州市",
"861560915", "陕西省安康市",
"861596641", "山东省临沂市",
"861780474", "内蒙古乌兰察布市",
"86132475", "广东省广州市",
"861511773", "贵州省铜仁地区",
"861514560", "黑龙江省黑河市",
"861336544", "山东省德州市",
"86180938", "甘肃省天水市",
"861521782", "广东省惠州市",
"861321887", "江苏省常州市",
"861300395", "福建省漳州市",
"861366458", "黑龙江省伊春市",
"86135831", "山东省济南市",
"861786909", "云南省保山市",
"861527112", "湖北省襄樊市",
"861777644", "广西柳州市",
"861813638", "江苏省常州市",
"861575475", "内蒙古通辽市",
"861502585", "甘肃省定西市",
"861350826", "四川省达州市",
"861571905", "新疆和田地区",
"86152779", "广西玉林市",
"861593531", "山西省大同市",
"861379347", "山东省德州市",
"861566879", "辽宁省葫芦岛市",
"861394941", "河南省开封市",
"86189777", "广西钦州市",
"86139294", "广东省东莞市",
"861518226", "四川省乐山市",
"861537044", "江苏省无锡市",
"861333634", "山东省莱芜市",
"86156618", "内蒙古鄂尔多斯市",
"861331384", "福建省厦门市",
"86136449", "辽宁省大连市",
"861348824", "陕西省延安市",
"86180793", "江西省上饶市",
"861562676", "广东省汕头市",
"861362491", "辽宁省大连市",
"86188922", "天津市",
"86187549", "山东省临沂市",
"861330540", "山东省菏泽市",
"861362933", "甘肃省平凉市",
"861361038", "广东省湛江市",
"861339920", "陕西省咸阳市",
"861311837", "四川省乐山市",
"861855975", "福建省厦门市",
"861346995", "湖北省武汉市",
"861309461", "浙江省绍兴市",
"861326798", "广东省珠海市",
"861823688", "河南省焦作市",
"861361718", "湖北省恩施土家族苗族自治州",
"861309709", "江西省萍乡市",
"861810490", "辽宁省沈阳市",
"861569948", "新疆伊犁哈萨克自治州",
"861811388", "四川省雅安市",
"861370225", "广东省佛山市",
"861811421", "江苏省南通市",
"861829956", "新疆阿克苏地区",
"86156745", "湖南省怀化市",
"861769245", "河北省唐山市",
"861459606", "宁夏中卫市",
"861810762", "广东省河源市",
"86153749", "内蒙古鄂尔多斯市",
"861370708", "江西省南昌市",
"861567803", "广西来宾市",
"861478122", "四川省雅安市",
"861560528", "江苏省镇江市",
"86188548", "山东省泰安市",
"861858267", "四川省绵阳市",
"861308110", "河北省石家庄市",
"861318774", "云南省玉溪市",
"861570098", "新疆石河子市",
"861558549", "吉林省白山市",
"86131110", "山西省太原市",
"861325081", "浙江省杭州市",
"861327508", "福建省泉州市",
"861859180", "陕西省榆林市",
"861320823", "四川省南充市",
"861870575", "浙江省绍兴市",
"861524489", "四川省内江市",
"861880312", "河北省保定市",
"86186730", "湖南省岳阳市",
"861509099", "湖北省鄂州市",
"861838778", "云南省玉溪市",
"861898746", "云南省昆明市",
"86187446", "吉林省松原市",
"861872461", "黑龙江省哈尔滨市",
"861302303", "安徽省芜湖市",
"861551355", "山西省长治市",
"86136546", "黑龙江省哈尔滨市",
"861820997", "新疆阿克苏地区",
"861517406", "辽宁省锦州市",
"861479454", "黑龙江省佳木斯市",
"861888221", "四川省乐山市",
"861760658", "浙江省宁波市",
"86138957", "黑龙江省哈尔滨市",
"861508607", "贵州省遵义市",
"861590977", "青海省海西蒙古族藏族自治州",
"861555244", "山东省烟台市",
"86158377", "河南省南阳市",
"861831927", "广东省湛江市",
"861364349", "山西省朔州市",
"86132892", "陕西省西安市",
"861368743", "广东省佛山市",
"86139060", "福建省厦门市",
"86136597", "广东省湛江市",
"861390890", "西藏拉萨市",
"861580796", "江西省吉安市",
"861860637", "山东省枣庄市",
"861889804", "西藏日喀则地区",
"861593401", "山西省吕梁市",
"86177557", "安徽省宿州市",
"861590467", "黑龙江省鸡西市",
"861852723", "湖北省荆门市",
"861891437", "江苏省南通市",
"861361853", "贵州省安顺市",
"861561667", "湖南省衡阳市",
"861335080", "四川省德阳市",
"861530243", "广东省佛山市",
"86156382", "河南省郑州市",
"861395942", "福建省宁德市",
"861889415", "甘肃省白银市",
"86136140", "辽宁省沈阳市",
"86184518", "江苏省宿迁市",
"861315410", "辽宁省铁岭市",
"861331893", "广东省潮州市",
"861388659", "湖北省荆州市",
"861537349", "河北省唐山市",
"861521558", "安徽省阜阳市",
"861773748", "河南省郑州市",
"861861546", "山东省东营市",
"861389852", "辽宁省丹东市",
"861817014", "江西省赣州市",
"86152643", "山东省淄博市",
"861507642", "河北省保定市",
"861345308", "山西省朔州市",
"861303032", "河南省濮阳市",
"861859329", "广西桂林市",
"861839239", "陕西省西安市",
"86134005", "福建省福州市",
"861585548", "安徽省阜阳市",
"86151715", "湖北省武汉市",
"861887700", "广西防城港市",
"861337738", "广西河池市",
"861380006", "辽宁省沈阳市",
"861320541", "山东省济南市",
"861329921", "广西南宁市",
"861322450", "黑龙江省哈尔滨市",
"861325917", "陕西省宝鸡市",
"861309971", "青海省果洛藏族自治州",
"861300176", "山东省德州市",
"861317321", "山东省青岛市",
"861311456", "黑龙江省黑河市",
"861838888", "云南省昆明市",
"861361538", "山东省泰安市",
"861772713", "广东省佛山市",
"861880399", "河南省许昌市",
"861599933", "新疆哈密地区",
"861339648", "山东省青岛市",
"861390982", "辽宁省沈阳市",
"861599491", "广东省汕头市",
"86138926", "陕西省汉中市",
"861893366", "广东省汕头市",
"86152036", "海南省海口市",
"861893685", "江苏省南京市",
"861772033", "湖北省咸宁市",
"861783546", "山西省长治市",
"861450283", "内蒙古鄂尔多斯市",
"861344955", "山东省菏泽市",
"861555998", "云南省曲靖市",
"861887293", "湖北省荆州市",
"86137863", "湖南省株洲市",
"861829471", "甘肃省陇南市",
"86180463", "福建省泉州市",
"861571235", "辽宁省大连市",
"861535283", "内蒙古阿拉善盟",
"861805417", "甘肃省兰州市",
"861809421", "江苏省南京市",
"86176021", "上海市",
"861870265", "江西省抚州市",
"861311461", "黑龙江省哈尔滨市",
"861318884", "山东省潍坊市",
"861311709", "湖北省黄冈市",
"861532633", "吉林省延边朝鲜族自治州",
"861897778", "广西南宁市",
"861309837", "湖北省黄冈市",
"861332976", "湖北省荆州市",
"861562430", "山东省日照市",
"86182133", "云南省大理白族自治州",
"861550284", "四川省宜宾市",
"861310722", "湖南省湘潭市",
"861338337", "河北省沧州市",
"86177120", "江苏省徐州市",
"86181654", "陕西省西安市",
"861509012", "河南省南阳市",
"861776862", "江苏省泰州市",
"861582542", "浙江省温州市",
"861370342", "河南省商丘市",
"861360295", "广东省肇庆市",
"861343858", "四川省泸州市",
"861857443", "湖南省岳阳市",
"861356668", "浙江省台州市",
"861587674", "广东省汕尾市",
"86830", "四川省泸州市",
"86186928", "湖南省娄底市",
"861596337", "山东省德州市",
"861335907", "安徽省宿州市",
"861558049", "湖南省永州市",
"861330255", "广东省江门市",
"861700318", "河北省唐山市",
"861325581", "浙江省杭州市",
"861707162", "河南省周口市",
"861538795", "江西省宜春市",
"86137442", "吉林省吉林市",
"86138907", "四川省南充市",
"861379631", "黑龙江省齐齐哈尔市",
"861570173", "甘肃省陇南市",
"86186542", "安徽省阜阳市",
"861580588", "浙江省丽水市",
"861372388", "湖南省长沙市",
"861331477", "内蒙古鄂尔多斯市",
"861300497", "福建省龙岩市",
"861881672", "广东省梅州市",
"861452390", "西藏拉萨市",
"861457120", "黑龙江省鸡西市",
"861886090", "江苏省苏州市",
"861303799", "宁夏银川市",
"861454148", "吉林省松原市",
"861881181", "广东省云浮市",
"86177429", "辽宁省葫芦岛市",
"86177507", "福建省泉州市",
"861331967", "湖南省郴州市",
"86188044", "吉林省松原市",
"861500860", "宁夏银川市",
"86187767", "广西南宁市",
"861336349", "山西省朔州市",
"861314799", "辽宁省葫芦岛市",
"861884550", "黑龙江省绥化市",
"861351343", "河北省保定市",
"86181512", "江苏省常州市",
"861318393", "四川省自贡市",
"861398018", "四川省遂宁市",
"86145067", "上海市",
"861853066", "河南省南阳市",
"861379445", "广东省深圳市",
"861539254", "山西省晋中市",
"861590831", "四川省资阳市",
"861700134", "天津市",
"861353141", "广东省佛山市",
"861760425", "辽宁省丹东市",
"861576741", "广东省广州市",
"861569294", "四川省绵阳市",
"861823232", "河北省张家口市",
"861782281", "贵州省黔东南苗族侗族自治州",
"861453696", "陕西省咸阳市",
"861872456", "黑龙江省黑河市",
"861772858", "广东省汕尾市",
"861335580", "浙江省舟山市",
"861536738", "湖南省娄底市",
"861357537", "浙江省丽水市",
"861311971", "青海省西宁市",
"861303532", "湖北省荆州市",
"861570876", "云南省文山壮族苗族自治州",
"861309456", "四川省攀枝花市",
"861512130", "贵州省安顺市",
"861585048", "江苏省南通市",
"861521136", "湖南省衡阳市",
"861522953", "陕西省渭南市",
"861332466", "陕西省商洛市",
"861359369", "湖北省黄冈市",
"861552919", "陕西省铜川市",
"86157389", "河南省驻马店市",
"861808215", "江苏省盐城市",
"861314532", "山东省青岛市",
"86185029", "陕西省西安市",
"861347381", "河北省衡水市",
"861853679", "山西省晋中市",
"861347428", "陕西省渭南市",
"861818117", "四川省泸州市",
"861356812", "四川省泸州市",
"86158388", "河南省洛阳市",
"861776618", "江苏省无锡市",
"86159316", "河北省廊坊市",
"861594743", "内蒙古通辽市",
"861306642", "广东省江门市",
"861871957", "甘肃省张掖市",
"861556037", "内蒙古赤峰市",
"861839470", "甘肃省酒泉市",
"861315401", "陕西省榆林市",
"861598349", "四川省广安市",
"861337518", "江苏省苏州市",
"861358134", "湖北省荆门市",
"861842016", "广东省河源市",
"861343522", "广东省湛江市",
"861329760", "湖北省荆门市",
"861342656", "江西省吉安市",
"861586901", "浙江省杭州市",
"861597257", "湖北省十堰市",
"861536975", "河北省沧州市",
"861530507", "福建省漳州市",
"861533561", "内蒙古巴彦淖尔市",
"861355746", "广西百色市",
"861329492", "云南省昭通市",
"861520981", "安徽省安庆市",
"861331325", "河北省唐山市",
"861888092", "四川省泸州市",
"861864998", "福建省厦门市",
"861344583", "广西玉林市",
"861314954", "黑龙江省佳木斯市",
"86188813", "四川省乐山市",
"861700810", "江苏省盐城市",
"861370284", "广东省江门市",
"861319346", "河南省许昌市",
"861533314", "河北省承德市",
"86138260", "广东省广州市",
"861801114", "四川省绵阳市",
"861334675", "河南省信阳市",
"861588754", "云南省德宏傣族景颇族自治州",
"861822776", "四川省自贡市",
"861303954", "内蒙古通辽市",
"861530819", "四川省成都市",
"861550342", "山西省运城市",
"861852732", "湖北省荆州市",
"861504577", "黑龙江省鸡西市",
"861335174", "黑龙江省大庆市",
"86157521", "云南省曲靖市",
"861813049", "安徽省阜阳市",
"861379726", "湖北省荆州市",
"861476575", "贵州省贵阳市",
"861760746", "湖南省永州市",
"861569506", "宁夏石嘴山市",
"861863895", "河南省南阳市",
"861576668", "广东省惠州市",
"861323263", "广东省河源市",
"861470907", "新疆博尔塔拉蒙古自治州",
"861350444", "吉林省四平市",
"861880936", "甘肃省张掖市",
"861378049", "河北省邢台市",
"861898658", "湖北省黄石市",
"861804049", "四川省广元市",
"861450628", "黑龙江省牡丹江市",
"861365640", "山东省济南市",
"861857907", "江西省赣州市",
"861815178", "江苏省苏州市",
"861308640", "四川省绵阳市",
"861512405", "辽宁省朝阳市",
"861559631", "陕西省渭南市",
"861452576", "福建省泉州市",
"861874640", "黑龙江省七台河市",
"861780253", "江苏省泰州市",
"861840891", "西藏拉萨市",
"861518551", "贵州省黔南布依族苗族自治州",
"86183721", "湖北省武汉市",
"861843272", "河北省保定市",
"861335443", "山东省德州市",
"861888807", "江苏省扬州市",
"861857580", "广东省肇庆市",
"861398465", "贵州省黔西南布依族苗族自治州",
"86150650", "山东省菏泽市",
"861329108", "江苏省苏州市",
"861870918", "陕西省西安市",
"861865478", "山东省济宁市",
"861708876", "广东省茂名市",
"861836244", "江苏省连云港市",
"86133876", "湖北省武汉市",
"861478457", "黑龙江省大兴安岭地区",
"861879751", "湖南省张家界市",
"861391207", "江苏省淮安市",
"861377899", "四川省资阳市",
"86138717", "湖北省襄樊市",
"861523439", "山西省吕梁市",
"86184843", "贵州省黔南布依族苗族自治州",
"861520737", "湖南省益阳市",
"861319777", "广西钦州市",
"861520017", "河北省邢台市",
"861470580", "浙江省舟山市",
"861572652", "山东省聊城市",
"861363706", "安徽省合肥市",
"861320832", "四川省内江市",
"861459175", "内蒙古包头市",
"861577537", "四川省遂宁市",
"861518679", "贵州省黔东南苗族侗族自治州",
"861858942", "西藏阿里地区",
"861811992", "安徽省宣城市",
"861350876", "云南省文山壮族苗族自治州",
"861762519", "江苏省常州市",
"861533138", "四川省成都市",
"861855518", "安徽省亳州市",
"86134796", "江西省吉安市",
"86145425", "海南省海口市",
"861452251", "浙江省绍兴市",
"861837425", "湖南省娄底市",
"861760377", "河南省南阳市",
"861518276", "四川省巴中市",
"861554215", "辽宁省沈阳市",
"86135389", "广东省广州市",
"86189772", "广西柳州市",
"861588336", "四川省乐山市",
"861771775", "河北省唐山市",
"861887842", "广西桂林市",
"86130475", "江苏省南京市",
"86187875", "云南省保山市",
"861339409", "福建省龙岩市",
"861576812", "广东省湛江市",
"861339761", "湖南省长沙市",
"861824638", "黑龙江省佳木斯市",
"86181798", "江西省景德镇市",
"861345811", "四川省攀枝花市",
"861780424", "辽宁省丹东市",
"861847515", "广东省阳江市",
"861501782", "广东省汕头市",
"86182938", "甘肃省天水市",
"861536465", "山西省长治市",
"861302751", "河南省郑州市",
"861362922", "陕西省榆林市",
"861589295", "四川省达州市",
"861523560", "山西省晋城市",
"861452898", "云南省昆明市",
"861530980", "辽宁省大连市",
"86159676", "浙江省台州市",
"861595159", "江苏省宿迁市",
"86184137", "浙江省杭州市",
"861831289", "广东省中山市",
"861829720", "青海省海北藏族自治州",
"861452669", "江西省赣州市",
"861533061", "吉林省长春市",
"861503694", "河南省驻马店市",
"861454862", "河南省信阳市",
"861809770", "新疆伊犁哈萨克自治州",
"861301346", "云南省曲靖市",
"861862472", "河南省新乡市",
"861819114", "陕西省西安市",
"861344083", "广西南宁市",
"861831686", "广东省汕头市",
"86158483", "内蒙古乌海市",
"861708098", "广东省佛山市",
"861564975", "河南省三门峡市",
"86184061", "辽宁省丹东市",
"861369796", "江西省吉安市",
"861303523", "湖北省襄樊市",
"861770607", "福建省泉州市",
"861313582", "湖北省宜昌市",
"861773661", "广西南宁市",
"861337975", "新疆喀什地区",
"861316994", "广东省深圳市",
"861530335", "河北省秦皇岛市",
"861832745", "湖北省黄冈市",
"861814063", "湖北省黄石市",
"861323573", "浙江省嘉兴市",
"86189821", "四川省成都市",
"861317654", "山东省泰安市",
"861302766", "河南省新乡市",
"86150155", "广东省佛山市",
"861318825", "辽宁省抚顺市",
"861314523", "湖南省湘潭市",
"861339756", "湖南省常德市",
"861324249", "广东省江门市",
"861894441", "江苏省南通市",
"861378549", "河北省沧州市",
"861824282", "辽宁省辽阳市",
"861350098", "吉林省吉林市",
"861563878", "河南省许昌市",
"86135980", "河南省郑州市",
"861459520", "云南省德宏傣族景颇族自治州",
"861813549", "山西省晋中市",
"861822886", "四川省巴中市",
"861524027", "江苏省镇江市",
"861768949", "福建省泉州市",
"861803273", "河北省沧州市",
"861568297", "甘肃省定西市",
"861569006", "河北省秦皇岛市",
"861363459", "黑龙江省大庆市",
"861459352", "贵州省遵义市",
"861360757", "福建省漳州市",
"861817602", "广西钦州市",
"861533271", "内蒙古呼和浩特市",
"861331242", "贵州省黔东南苗族侗族自治州",
"861816236", "湖北省襄樊市",
"861515664", "安徽省淮南市",
"861348775", "湖南省株洲市",
"861764068", "辽宁省鞍山市",
"861560852", "贵州省遵义市",
"861308928", "吉林省四平市",
"861899487", "江苏省扬州市",
"861330797", "江西省赣州市",
"86131284", "广东省汕头市",
"861880660", "广东省汕尾市",
"86158617", "江苏省淮安市",
"861864244", "辽宁省阜新市",
"861895134", "江苏省徐州市",
"861535455", "吉林省延边朝鲜族自治州",
"861323402", "辽宁省沈阳市",
"861301777", "浙江省嘉兴市",
"861303841", "陕西省渭南市",
"861328468", "黑龙江省鹤岗市",
"861520809", "西藏日喀则地区",
"86150600", "福建省福州市",
"86159575", "浙江省绍兴市",
"861523304", "河北省秦皇岛市",
"861514220", "辽宁省鞍山市",
"861889068", "湖南省怀化市",
"861321727", "湖北省宜昌市",
"861893290", "河北省石家庄市",
"86183872", "云南省大理白族自治州",
"861350786", "广西南宁市",
"86130750", "安徽省阜阳市",
"86185667", "广东省深圳市",
"861877455", "湖南省怀化市",
"86147433", "广东省广州市",
"861771885", "广东省湛江市",
"861581951", "广东省云浮市",
"861760484", "内蒙古呼和浩特市",
"86134569", "浙江省杭州市",
"86184792", "江西省九江市",
"861776148", "四川省巴中市",
"861308834", "四川省德阳市",
"861532622", "辽宁省锦州市",
"861369088", "广东省梅州市",
"861882949", "陕西省西安市",
"861330483", "黑龙江省牡丹江市",
"861534829", "四川省巴中市",
"861815231", "宁夏银川市",
"861533556", "内蒙古呼和浩特市",
"861319887", "四川省广元市",
"861539432", "浙江省宁波市",
"86139776", "广西百色市",
"861509723", "甘肃省酒泉市",
"861360680", "浙江省杭州市",
"86177733", "湖南省长沙市",
"861310733", "湖南省株洲市",
"861342661", "江西省九江市",
"861339334", "河北省秦皇岛市",
"861310013", "山西省晋中市",
"861707848", "云南省文山壮族苗族自治州",
"861599922", "新疆阿克苏地区",
"861390398", "河南省三门峡市",
"861886747", "湖南省衡阳市",
"86130679", "浙江省杭州市",
"861772022", "湖北省武汉市",
"861555382", "山东省东营市",
"861889278", "四川省内江市",
"861367829", "四川省达州市",
"861809992", "新疆伊犁哈萨克自治州",
"861847015", "江西省上饶市",
"861590542", "山东省青岛市",
"861812172", "江苏省泰州市",
"861332926", "安徽省安庆市",
"861539473", "内蒙古乌海市",
"861847640", "广东省茂名市",
"861894740", "内蒙古乌兰察布市",
"861329837", "河南省焦作市",
"861386703", "浙江省衢州市",
"86136958", "浙江省温州市",
"861773692", "河北省石家庄市",
"861830555", "安徽省马鞍山市",
"861771446", "江苏省盐城市",
"861897205", "湖北省襄樊市",
"861320783", "广西桂林市",
"861327765", "湖北省荆门市",
"861529732", "河北省张家口市",
"861860595", "福建省泉州市",
"86180133", "江苏省南京市",
"861358277", "河北省廊坊市",
"861310772", "浙江省杭州市",
"861507798", "安徽省淮北市",
"861871848", "广东省深圳市",
"861893413", "广东省东莞市",
"861564984", "河南省许昌市",
"861787554", "广东省韶关市",
"861313758", "河南省开封市",
"861533092", "辽宁省营口市",
"861392436", "广东省东莞市",
"86150036", "青海省西宁市",
"861809471", "浙江省杭州市",
"86182463", "黑龙江省牡丹江市",
"861811956", "安徽省宿州市",
"861304758", "江苏省宿迁市",
"861822950", "湖南省湘西土家族苗族自治州",
"861539144", "云南省昭通市",
"861355965", "福建省漳州市",
"861886664", "山东省潍坊市",
"861362547", "山东省济宁市",
"861501833", "广东省珠海市",
"861331427", "辽宁省盘锦市",
"861572696", "浙江省台州市",
"861583380", "河北省邯郸市",
"861899579", "湖北省黄石市",
"86182842", "四川省德阳市",
"861533807", "广东省广州市",
"861530861", "湖北省荆州市",
"86138902", "四川省德阳市",
"86180847", "福建省福州市",
"861338768", "湖北省荆州市",
"861348784", "湖南省张家界市",
"86137447", "吉林省延边朝鲜族自治州",
"861585639", "安徽省合肥市",
"861457025", "江西省宜春市",
"861333702", "内蒙古兴安盟",
"861572299", "江苏省无锡市",
"861354995", "广东省佛山市",
"861340822", "四川省资阳市",
"86188956", "安徽省蚌埠市",
"861587624", "广东省河源市",
"861476084", "江苏省南京市",
"861307008", "新疆和田地区",
"861559776", "贵州省遵义市",
"861560268", "广东省汕尾市",
"861586093", "福建省泉州市",
"86832", "四川省内江市\、资阳市",
"861831831", "广东省东莞市",
"861370565", "安徽省合肥市",
"861815910", "福建省莆田市",
"861573390", "河北省邢台市",
"861305581", "福建省泉州市",
"861358067", "广东省云浮市",
"861800863", "湖北省武汉市",
"861895442", "山东省淄博市",
"861776749", "新疆阿克苏地区",
"861308515", "湖北省宜昌市",
"861580914", "陕西省商洛市",
"861760475", "内蒙古通辽市",
"86153562", "浙江省温州市",
"861365515", "江苏省淮安市",
"861814232", "陕西省渭南市",
"86135059", "福建省泉州市",
"86189865", "湖北省黄冈市",
"861821830", "广东省清远市",
"861313813", "广东省珠海市",
"861396617", "安徽省宣城市",
"861857237", "湖北省宜昌市",
"861812836", "广东省茂名市",
"861339039", "辽宁省朝阳市",
"86184025", "江苏省南京市",
"861323799", "江西省萍乡市",
"861594917", "江苏省淮安市",
"86177502", "福建省福州市",
"861320497", "湖南省永州市",
"86186596", "福建省漳州市",
"861881622", "江苏省淮安市",
"86137496", "河南省商丘市",
"86180896", "贵州省遵义市",
"861554428", "河南省新乡市",
"861826286", "江苏省盐城市",
"86187762", "广西柳州市",
"86458", "黑龙江省伊春市",
"861815889", "安徽省淮南市",
"861558638", "湖北省襄樊市",
"861869623", "湖北省襄樊市",
"86137599", "陕西省西安市",
"861862433", "辽宁省沈阳市",
"861592663", "湖北省荆州市",
"861478355", "河南省许昌市",
"86130743", "吉林省长春市",
"861315842", "四川省达州市",
"861330145", "江苏省扬州市",
"861326642", "广东省湛江市",
"861846495", "山东省日照市",
"86183495", "四川省绵阳市",
"861300041", "广东省广州市",
"861839420", "甘肃省临夏回族自治州",
"861778017", "四川省南充市",
"861519558", "江苏省扬州市",
"86170859", "福建省泉州市",
"861323532", "山东省青岛市",
"861539963", "安徽省安庆市",
"861329456", "山西省晋城市",
"861332313", "河北省张家口市",
"861479902", "新疆哈密地区",
"861853226", "河北省张家口市",
"861471549", "广东省东莞市",
"861835280", "江苏省连云港市",
"861351905", "甘肃省武威市",
"861502953", "陕西省渭南市",
"861570826", "四川省广安市",
"861522074", "广东省惠州市",
"861342692", "广东省潮州市",
"861347478", "内蒙古鄂尔多斯市",
"861828215", "四川省攀枝花市",
"861344899", "新疆乌鲁木齐市",
"86138598", "福建省莆田市",
"861899930", "新疆克拉玛依市",
"86156378", "河南省开封市",
"861334684", "河南省周口市",
"86159258", "浙江省绍兴市",
"861813344", "安徽省马鞍山市",
"861827208", "湖北省鄂州市",
"861370275", "广东省佛山市",
"861811471", "江苏省南京市",
"861572212", "贵州省贵阳市",
"861800151", "江苏省无锡市",
"861809956", "新疆喀什地区",
"861559886", "内蒙古巴彦淖尔市",
"861594581", "黑龙江省鹤岗市",
"861478681", "湖南省常德市",
"861844940", "新疆阿勒泰地区",
"861560578", "浙江省丽水市",
"861392670", "广东省茂名市",
"861807775", "广西钦州市",
"861393376", "河北省张家口市",
"861569436", "吉林省白城市",
"861333348", "山西省运城市",
"86182793", "江西省上饶市",
"861814688", "陕西省西安市",
"861587703", "广西桂林市",
"86181933", "甘肃省平凉市",
"861536984", "河北省沧州市",
"861821644", "湖南省长沙市",
"861533592", "湖北省襄樊市",
"861530153", "江苏省无锡市",
"861700567", "浙江省金华市",
"861329461", "山西省忻州市",
"861388146", "四川省凉山彝族自治州",
"861803688", "江苏省无锡市",
"861339970", "新疆昌吉回族自治州",
"86138094", "贵州省贵阳市",
"861550418", "辽宁省阜新市",
"86151724", "湖北省武汉市",
"861800997", "新疆阿克苏地区",
"861373331", "河北省石家庄市",
"861362047", "广东省珠海市",
"861590927", "陕西省咸阳市",
"861595116", "江苏省泰州市",
"86138952", "宁夏吴忠市",
"861888271", "四川省自贡市",
"861840862", "宁夏石嘴山市",
"861356955", "河南省平顶山市",
"861510787", "广西钦州市",
"861305081", "辽宁省铁岭市",
"861318724", "湖南省衡阳市",
"861554655", "黑龙江省绥化市",
"86147968", "江西省上饶市",
"861879945", "新疆阿克苏地区",
"861558282", "山西省晋城市",
"861870525", "江苏省扬州市",
"861891243", "江苏省南通市",
"861452611", "江苏省无锡市",
"861320873", "云南省红河哈尼族彝族自治州",
"861533739", "湖北省鄂州市",
"861310882", "云南省德宏傣族景颇族自治州",
"861335185", "黑龙江省大庆市",
"861300823", "辽宁省盘锦市",
"861530437", "吉林省辽源市",
"861816906", "宁夏中卫市",
"861361649", "山东省临沂市",
"861339539", "山东省临沂市",
"861560896", "西藏那曲地区",
"861357943", "新疆乌鲁木齐市",
"861874015", "辽宁省阜新市",
"861308015", "河南省许昌市",
"861530856", "贵州省铜仁地区",
"861365735", "湖南省长沙市",
"861845829", "浙江省湖州市",
"861361246", "广东省佛山市",
"861337367", "江苏省扬州市",
"861308735", "湖南省郴州市",
"86136592", "陕西省西安市",
"861325743", "湖南省湘西土家族苗族自治州",
"86132897", "陕西省榆林市",
"861831977", "广东省佛山市",
"861879450", "甘肃省临夏回族自治州",
"861564367", "吉林省白城市",
"86187492", "河南省周口市",
"861847834", "湖南省岳阳市",
"86158372", "河南省安阳市",
"86189531", "山东省济南市",
"86177552", "安徽省蚌埠市",
"861843233", "河北省张家口市",
"86178390", "河南省商丘市",
"861348446", "陕西省西安市",
"861458235", "安徽省滁州市",
"86137766", "江苏省南京市",
"861390449", "吉林省白山市",
"861369663", "安徽省池州市",
"86186695", "山东省临沂市",
"86183765", "广西玉林市",
"861508397", "江西省新余市",
"861863373", "河北省沧州市",
"86184850", "贵州省贵阳市",
"86132319", "河北省邢台市",
"861569857", "山西省太原市",
"861341981", "河南省三门峡市",
"861890482", "内蒙古兴安盟",
"861778517", "贵州省毕节地区",
"861523509", "山西省朔州市",
"861339792", "江西省九江市",
"861584838", "内蒙古呼和浩特市",
"861519058", "江苏省苏州市",
"86170809", "广东省深圳市",
"861510931", "甘肃省兰州市",
"861781794", "广东省广州市",
"861302693", "广西桂林市",
"861339460", "黑龙江省哈尔滨市",
"861329971", "青海省西宁市",
"86183699", "山东省淄博市",
"861368917", "陕西省宝鸡市",
"86186769", "广东省东莞市",
"86155070", "江西省赣州市",
"861832476", "安徽省阜阳市",
"861892448", "广东省梅州市",
"86150643", "山东省淄博市",
"861475615", "河北省沧州市",
"861376280", "湖南省娄底市",
"861777114", "湖北省襄樊市",
"861527642", "新疆昌吉回族自治州",
"86157565", "四川省成都市",
"86133911", "上海市",
"861346859", "陕西省延安市",
"86181267", "广东省广州市",
"861530768", "广东省潮州市",
"86187985", "贵州省黔东南苗族侗族自治州",
"861338861", "浙江省杭州市",
"861331484", "内蒙古包头市",
"861773073", "陕西省渭南市",
"86151391", "河南省焦作市",
"86187539", "山东省临沂市",
"861393426", "山西省大同市",
"861362391", "河南省焦作市",
"861576957", "宁夏银川市",
"861814671", "江西省南昌市",
"861803671", "江苏省连云港市",
"861367546", "山东省东营市",
"86150491", "内蒙古呼和浩特市",
"861332351", "宁夏银川市",
"861803182", "河北省石家庄市",
"861823621", "河南省漯河市",
"861311734", "湖南省衡阳市",
"861502911", "陕西省延安市",
"861309361", "安徽省宣城市",
"861879403", "甘肃省甘南藏族自治州",
"861594578", "黑龙江省哈尔滨市",
"861534546", "山东省东营市",
"86130661", "广东省东莞市",
"861572759", "江西省抚州市",
"861533673", "浙江省衢州市",
"861566046", "山东省泰安市",
"861811488", "江苏省无锡市",
"861333936", "黑龙江省黑河市",
"861524075", "广西百色市",
"861476027", "福建省龙岩市",
"861810390", "河南省平顶山市",
"861305268", "辽宁省葫芦岛市",
"861344162", "河北省石家庄市",
"861835697", "安徽省芜湖市",
"86991", "新疆乌鲁木齐市",
"861865657", "安徽省芜湖市",
"86153739", "河北省石家庄市",
"861550067", "青海省海东地区",
"861363202", "广东省潮州市",
"86188538", "山东省泰安市",
"861808657", "湖北省黄冈市",
"861824444", "四川省达州市",
"861560581", "浙江省杭州市",
"861309514", "新疆塔城地区",
"861304298", "甘肃省天水市",
"861345192", "江苏省南京市",
"861305078", "辽宁省辽阳市",
"861318877", "山东省烟台市",
"861353791", "广东省云浮市",
"861571080", "广东省深圳市",
"861384972", "河南省信阳市",
"861576191", "贵州省贵阳市",
"861577130", "内蒙古乌海市",
"861507891", "广西钦州市",
"861871741", "陕西省延安市",
"861550277", "湖北省恩施土家族苗族自治州",
"861880412", "辽宁省鞍山市",
"861313298", "广西河池市",
"86187436", "吉林省白城市",
"861523167", "河北省沧州市",
"861313851", "广东省肇庆市",
"861837893", "广西北海市",
"861529906", "新疆乌鲁木齐市",
"861303149", "河北省廊坊市",
"86186740", "湖北省武汉市",
"861773263", "河北省廊坊市",
"861507258", "湖北省孝感市",
"861835130", "江苏省南通市",
"861302403", "安徽省阜阳市",
"861761483", "内蒙古呼和浩特市",
"861888288", "四川省凉山彝族自治州",
"86134571", "广西南宁市",
"861586181", "江苏省南京市",
"861304851", "贵州省遵义市",
"861780079", "青海省海西蒙古族藏族自治州",
"861808780", "云南省楚雄彝族自治州",
"861350638", "山东省济宁市",
"861364449", "吉林省白山市",
"86181710", "湖北省武汉市",
"861587750", "陕西省宝鸡市",
"861479736", "山西省临汾市",
"861508041", "福建省泉州市",
"861479016", "安徽省黄山市",
"861352994", "云南省红河哈尼族彝族自治州",
"861889707", "青海省海西蒙古族藏族自治州",
"861593301", "河北省石家庄市",
"861584511", "黑龙江省哈尔滨市",
"861359710", "广西南宁市",
"861595944", "福建省厦门市",
"861502087", "山东省莱芜市",
"861378826", "广西百色市",
"861707440", "浙江省温州市",
"861824876", "江苏省盐城市",
"861330617", "江苏省无锡市",
"861537449", "甘肃省陇南市",
"86136130", "广东省深圳市",
"861384790", "内蒙古锡林郭勒盟",
"861594896", "吉林省辽源市",
"861779108", "陕西省汉中市",
"86155859", "贵州省黔西南布依族苗族自治州",
"86151154", "湖南省衡阳市",
"861379222", "山东省德州市",
"861358109", "山东省临沂市",
"861770395", "河南省漯河市",
"86152633", "山东省日照市",
"861893451", "江苏省南通市",
"861854832", "内蒙古巴彦淖尔市",
"861345408", "浙江省舟山市",
"861822062", "陕西省榆林市",
"86130193", "辽宁省沈阳市",
"861527148", "湖北省宜昌市",
"861876235", "江苏省泰州市",
"861341978", "河南省开封市",
"861321775", "广西玉林市",
"86150904", "河南省新乡市",
"861369616", "四川省乐山市",
"861780269", "江苏省盐城市",
"861528497", "四川省资阳市",
"861816512", "陕西省榆林市",
"861301725", "湖南省常德市",
"861709347", "广东省深圳市",
"861575196", "甘肃省张掖市",
"861329988", "青海省西宁市",
"861322350", "山西省忻州市",
"861311356", "内蒙古赤峰市",
"861833620", "河南省驻马店市",
"861317421", "湖南省张家界市",
"861357405", "湖南省湘潭市",
"861780666", "广东省梅州市",
"861301208", "河北省廊坊市",
"861774249", "陕西省西安市",
"861563636", "黑龙江省牡丹江市",
"861386687", "安徽省宿州市",
"861459234", "四川省成都市",
"861880499", "内蒙古呼伦贝尔市",
"86150761", "河北省石家庄市",
"861363973", "青海省黄南藏族自治州",
"861311514", "江苏省连云港市",
"86158894", "广东省深圳市",
"861867161", "湖北省荆门市",
"861893466", "湖北省黄石市",
"86152046", "黑龙江省哈尔滨市",
"86131474", "河北省石家庄市",
"86133639", "陕西省西安市",
"861590984", "辽宁省大连市",
"861398927", "四川省绵阳市",
"861809488", "新疆和田地区",
"861345119", "湖北省荆门市",
"861780651", "广东省惠州市",
"861824098", "新疆乌鲁木齐市",
"861309734", "江西省赣州市",
"861513525", "山西省吕梁市",
"861550567", "安徽省亳州市",
"861780930", "甘肃省临夏回族自治州",
"861510724", "湖北省咸宁市",
"86145324", "浙江省杭州市",
"861539323", "甘肃省定西市",
"861338437", "吉林省辽源市",
"861566546", "安徽省安庆市",
"861476527", "河南省郑州市",
"86182143", "云南省红河哈尼族彝族自治州",
"861868705", "云南省昭通市",
"861860740", "湖南省岳阳市",
"861528873", "山东省聊城市",
"861504525", "黑龙江省七台河市",
"861458185", "浙江省丽水市",
"861334627", "山东省德州市",
"861370442", "吉林省吉林市",
"861519689", "四川省达州市",
"861850646", "山东省东营市",
"861825068", "福建省漳州市",
"86147348", "广东省广州市",
"861850249", "辽宁省辽阳市",
"861837967", "江西省吉安市",
"861570344", "山西省晋中市",
"861866667", "广东省梅州市",
"861800816", "四川省绵阳市",
"861387181", "湖北省鄂州市",
"861571580", "浙江省杭州市",
"861382498", "广东省阳江市",
"861573849", "河南省平顶山市",
"861325528", "江苏省南京市",
"861596437", "山东省聊城市",
"86139591", "福建省福州市",
"86137432", "吉林省吉林市",
"861580521", "江苏省徐州市",
"86134553", "山东省淄博市",
"861331377", "福建省福州市",
"86186532", "山东省青岛市",
"86182837", "四川省阿坝藏族羌族自治州",
"861581590", "广东省江门市",
"861470343", "山西省阳泉市",
"861567627", "广西柳州市",
"86183982", "四川省巴中市",
"861321885", "江苏省无锡市",
"861452653", "江西省上饶市",
"861452490", "内蒙古包头市",
"861584731", "内蒙古鄂尔多斯市",
"861575477", "内蒙古鄂尔多斯市",
"861560917", "陕西省宝鸡市",
"861475147", "江苏省无锡市",
"861565126", "江苏省淮安市",
"861452762", "广西来宾市",
"861780579", "浙江省金华市",
"861351443", "吉林省延边朝鲜族自治州",
"861318493", "河北省沧州市",
"861454586", "甘肃省酒泉市",
"861336449", "吉林省白山市",
"861379345", "山东省德州市",
"861878866", "贵州省安顺市",
"861304866", "江苏省连云港市",
"861889839", "广东省中山市",
"86135870", "浙江省舟山市",
"861879072", "河南省三门峡市",
"861302262", "浙江省舟山市",
"861502587", "甘肃省张掖市",
"861773402", "河北省保定市",
"861571907", "新疆克拉玛依市",
"861339252", "广东省珠海市",
"861309356", "安徽省宿州市",
"861822562", "安徽省铜陵市",
"861459127", "广西贺州市",
"861332366", "河南省三门峡市",
"861305896", "浙江省金华市",
"861332685", "广东省东莞市",
"861539916", "陕西省汉中市",
"861313944", "甘肃省天水市",
"861802345", "广东省广州市",
"861500735", "湖南省郴州市",
"861593310", "河北省邯郸市",
"861584500", "黑龙江省哈尔滨市",
"861359701", "广西南宁市",
"86151104", "山西省运城市",
"86155809", "湖南省长沙市",
"861556405", "山东省滨州市",
"861867538", "广东省东莞市",
"861347481", "内蒙古呼和浩特市",
"861580843", "四川省南充市",
"86131993", "黑龙江省牡丹江市",
"861592616", "湖北省十堰市",
"861363463", "黑龙江省牡丹江市",
"86150092", "陕西省西安市",
"861808870", "黑龙江省哈尔滨市",
"861816732", "浙江省嘉兴市",
"861315301", "山东省济南市",
"861598449", "四川省达州市",
"861331746", "湖南省永州市",
"861839370", "甘肃省临夏回族自治州",
"861556814", "吉林省白山市",
"861335235", "辽宁省铁岭市",
"861572406", "广东省广州市",
"86170070", "江西省南昌市",
"861816012", "四川省广安市",
"861523996", "河南省濮阳市",
"861339612", "湖北省襄樊市",
"86170863", "山东省临沂市",
"86184736", "湖南省常德市",
"861346151", "河南省信阳市",
"861524584", "黑龙江省齐齐哈尔市",
"861814736", "内蒙古包头市",
"861311392", "广东省中山市",
"861870577", "浙江省温州市",
"861767103", "湖北省武汉市",
"861302033", "辽宁省鞍山市",
"861803736", "河南省洛阳市",
"861834486", "江苏省盐城市",
"86186771", "广西南宁市",
"861570049", "四川省自贡市",
"861511494", "陕西省榆林市",
"86186703", "湖南省长沙市",
"861780793", "江西省上饶市",
"861508605", "贵州省遵义市",
"861558173", "山西省晋中市",
"861312440", "河南省开封市",
"861500640", "山东省济南市",
"861342532", "广东省汕头市",
"861770783", "广西桂林市",
"861880702", "江西省九江市",
"86131738", "浙江省金华市",
"861590975", "青海省果洛藏族自治州",
"861852906", "广东省深圳市",
"861323692", "辽宁省大连市",
"861310551", "浙江省嘉兴市",
"861551357", "山西省临汾市",
"861837152", "湖北省咸宁市",
"861820995", "新疆吐鲁番地区",
"861840798", "江西省景德镇市",
"861370318", "河北省衡水市",
"861582518", "云南省红河哈尼族彝族自治州",
"861533288", "内蒙古巴彦淖尔市",
"861855977", "福建省厦门市",
"861311835", "四川省眉山市",
"86877", "云南省玉溪市",
"861346997", "湖北省武汉市",
"861347657", "湖北省黄冈市",
"86182150", "甘肃省临夏回族自治州",
"861700342", "海南省海口市",
"861338507", "福建省三明市",
"861309319", "江苏省常州市",
"861858265", "四川省绵阳市",
"861502969", "陕西省榆林市",
"861338819", "四川省成都市",
"861769247", "河北省沧州市",
"861858389", "四川省攀枝花市",
"86138510", "江苏省盐城市",
"861454112", "安徽省蚌埠市",
"861585599", "安徽省芜湖市",
"86182556", "安徽省安庆市",
"861819864", "贵州省贵阳市",
"861310679", "广东省阳江市",
"861479182", "陕西省西安市",
"861572536", "山东省潍坊市",
"861380336", "河北省石家庄市",
"86187829", "四川省成都市",
"861583043", "河北省保定市",
"86136807", "广东省惠州市",
"861310276", "河北省衡水市",
"86132502", "广东省广州市",
"861325915", "陕西省安康市",
"861302858", "陕西省延安市",
"861345038", "广东省广州市",
"861339868", "河北省承德市",
"861303302", "安徽省蚌埠市",
"861314302", "河北省石家庄市",
"86145479", "浙江省宁波市",
"861308368", "河南省焦作市",
"86150725", "湖北省宜昌市",
"861452791", "新疆塔城地区",
"861365368", "山西省太原市",
"861860635", "山东省聊城市",
"861597483", "云南省昆明市",
"861590465", "黑龙江省鸡西市",
"861334358", "湖北省武汉市",
"86134146", "广东省惠州市",
"861817492", "广西河池市",
"861364398", "河南省三门峡市",
"861831925", "广东省梅州市",
"861399974", "新疆塔城地区",
"861810526", "江苏省泰州市",
"861356848", "四川省巴中市",
"861347780", "湖北省荆州市",
"86182459", "黑龙江省大庆市",
"861786934", "云南省临沧市",
"861889417", "甘肃省武威市",
"86147867", "湖南省娄底市",
"861822591", "安徽省宣城市",
"861814354", "贵州省黔南布依族苗族自治州",
"86183173", "河南省安阳市",
"86136826", "广东省深圳市",
"861891435", "江苏省南通市",
"861820643", "山东省淄博市",
"861341110", "广东省韶关市",
"861810141", "江苏省盐城市",
"861567358", "湖南省邵阳市",
"861843631", "河南省平顶山市",
"861561665", "湖南省衡阳市",
"861337542", "山东省青岛市",
"861800859", "贵州省黔西南布依族苗族自治州",
"86182605", "江苏省南通市",
"861843950", "河南省新乡市",
"861550989", "辽宁省葫芦岛市",
"861302533", "广东省汕头市",
"861779709", "青海省海北藏族自治州",
"861471826", "广东省揭阳市",
"861570549", "山东省临沂市",
"861330257", "广东省湛江市",
"861596335", "山东省临沂市",
"861335905", "安徽省马鞍山市",
"86134732", "河北省保定市",
"86134219", "广东省东莞市",
"86151638", "山东省泰安市",
"861360297", "广东省肇庆市",
"86131920", "广东省东莞市",
"861839934", "新疆喀什地区",
"861512943", "陕西省渭南市",
"861361742", "湖南省常德市",
"861310051", "广西南宁市",
"861568757", "云南省德宏傣族景颇族自治州",
"861890998", "新疆喀什地区",
"861509548", "甘肃省定西市",
"861457077", "江苏省泰州市",
"861538797", "江西省赣州市",
"861368852", "贵州省遵义市",
"861309392", "陕西省汉中市",
"86183394", "河南省周口市",
"861520978", "青海省西宁市",
"861327338", "河北省秦皇岛市",
"861331475", "内蒙古通辽市",
"861369659", "安徽省阜阳市",
"861344957", "山东省青岛市",
"861877122", "湖北省恩施土家族苗族自治州",
"861571237", "辽宁省大连市",
"86155437", "吉林省长春市",
"861555949", "新疆阿克苏地区",
"861805415", "甘肃省武威市",
"861339296", "广东省珠海市",
"861770873", "云南省红河哈尼族彝族自治州",
"861582018", "广东省茂名市",
"861826872", "浙江省舟山市",
"861339699", "浙江省温州市",
"861806822", "江苏省宿迁市",
"861880348", "山西省吕梁市",
"861893687", "江苏省南京市",
"86178222", "天津市",
"86155162", "河南省三门峡市",
"861338335", "河北省秦皇岛市",
"861868804", "广东省揭阳市",
"861871440", "黑龙江省牡丹江市",
"861861789", "河北省唐山市",
"861879533", "宁夏吴忠市",
"861870267", "江西省抚州市",
"861353490", "广东省汕头市",
"86177846", "海南省海口市",
"861346863", "陕西省宝鸡市",
"861535122", "四川省成都市",
"861323216", "广东省茂名市",
"861309835", "湖北省咸宁市",
"861867119", "湖北省十堰市",
"861384933", "河南省濮阳市",
"86130557", "福建省福州市",
"861808217", "江苏省盐城市",
"861538483", "内蒙古阿拉善盟",
"861319824", "四川省广元市",
"86136857", "浙江省杭州市",
"861572716", "湖北省荆州市",
"861817419", "广西桂林市",
"86159426", "辽宁省大连市",
"86170041", "辽宁省沈阳市",
"861505680", "安徽省铜陵市",
"86177897", "海南省海口市",
"86130625", "江苏省南京市",
"861871955", "甘肃省陇南市",
"861556035", "内蒙古赤峰市",
"861598398", "四川省巴中市",
"861839828", "四川省阿坝藏族羌族自治州",
"86591", "福建省福州市",
"861808328", "贵州省黔西南布依族苗族自治州",
"861818115", "四川省泸州市",
"861586633", "山东省日照市",
"86137248", "广东省广州市",
"861865481", "山东省烟台市",
"861341101", "广东省佛山市",
"861345538", "山东省泰安市",
"861898589", "贵州省毕节地区",
"861317720", "湖北省襄樊市",
"861557848", "广西南宁市",
"861554820", "内蒙古鄂尔多斯市",
"861840586", "浙江省台州市",
"861773032", "安徽省芜湖市",
"861327114", "河南省开封市",
"861354241", "广东省云浮市",
"861300495", "福建省南平市",
"861780200", "广东省广州市",
"861454199", "山西省运城市",
"861520468", "黑龙江省鹤岗市",
"861846041", "江西省萍乡市",
"861303748", "湖南省永州市",
"861331965", "湖南省怀化市",
"861536542", "江苏省徐州市",
"861366358", "山西省吕梁市",
"861321784", "广西贺州市",
"861599140", "陕西省商洛市",
"86135841", "江苏省无锡市",
"86159529", "江苏省镇江市",
"861768382", "湖北省黄冈市",
"86159407", "辽宁省营口市",
"861592071", "广东省佛山市",
"86182655", "山东省聊城市",
"861533632", "山东省枣庄市",
"861705382", "重庆市",
"86182527", "江苏省扬州市",
"861810026", "广东省佛山市",
"86183151", "重庆市",
"86177319", "河北省邢台市",
"86186822", "广东省深圳市",
"861379447", "广东省深圳市",
"861760427", "辽宁省盘锦市",
"86180522", "江苏省徐州市",
"861822091", "陕西省渭南市",
"861805278", "江苏省宿迁市",
"861537982", "甘肃省酒泉市",
"861566682", "山东省青岛市",
"861350549", "山东省临沂市",
"861470905", "新疆阿勒泰地区",
"861804098", "新疆喀什地区",
"861539373", "河南省洛阳市",
"861329734", "湖南省衡阳市",
"861510774", "广西梧州市",
"861329014", "山东省莱芜市",
"861504575", "黑龙江省双鸭山市",
"861771346", "四川省广元市",
"861813098", "新疆伊犁哈萨克自治州",
"861476577", "云南省昆明市",
"861863897", "河南省南阳市",
"86152761", "新疆巴音郭楞蒙古自治州",
"861893313", "广东省肇庆市",
"86153199", "陕西省西安市",
"861888805", "江苏省南通市",
"86131266", "北京市",
"861880840", "四川省达州市",
"861392336", "广东省珠海市",
"86150046", "黑龙江省哈尔滨市",
"861396540", "安徽省宣城市",
"861857905", "江西省南昌市",
"861303661", "四川省眉山市",
"861333094", "四川省成都市",
"861512407", "辽宁省朝阳市",
"86156195", "陕西省咸阳市",
"861325193", "浙江省嘉兴市",
"86182832", "四川省内江市",
"861538540", "安徽省安庆市",
"86186537", "山东省济宁市",
"861530505", "福建省三明市",
"861331327", "河北省沧州市",
"861580571", "浙江省杭州市",
"861533704", "甘肃省酒泉市",
"86137437", "吉林省辽源市",
"861327830", "吉林省松原市",
"861811214", "江苏省扬州市",
"861361811", "四川省绵阳市",
"861393197", "河北省石家庄市",
"861597255", "湖北省鄂州市",
"861536977", "河北省沧州市",
"861839189", "陕西省宝鸡市",
"861778928", "陕西省宝鸡市",
"861868068", "广东省深圳市",
"861884962", "云南省西双版纳傣族自治州",
"861334677", "河南省开封市",
"861532779", "湖北省荆州市",
"861325578", "浙江省丽水市",
"86159381", "河南省焦作市",
"861850582", "浙江省湖州市",
"861305528", "福建省福州市",
"861879022", "河南省焦作市",
"861760375", "河南省平顶山市",
"861853733", "河南省新乡市",
"861554217", "辽宁省沈阳市",
"861853013", "河南省开封市",
"861395120", "江苏省常州市",
"861771777", "河北省唐山市",
"861380912", "陕西省榆林市",
"861577535", "四川省遂宁市",
"861819508", "宁夏银川市",
"861892702", "广东省河源市",
"861532901", "贵州省贵阳市",
"861847809", "湖南省郴州市",
"861768244", "浙江省杭州市",
"861881593", "福建省南平市",
"861564831", "内蒙古阿拉善盟",
"861837427", "湖南省娄底市",
"861528541", "贵州省铜仁地区",
"861579411", "浙江省宁波市",
"861589297", "四川省达州市",
"861355089", "四川省泸州市",
"861366850", "贵州省贵阳市",
"861452849", "甘肃省陇南市",
"86136790", "四川省成都市",
"861337831", "四川省资阳市",
"861515966", "福建省漳州市",
"861454642", "云南省普洱市",
"861339504", "福建省福州市",
"861554328", "吉林省长春市",
"861869739", "河南省许昌市",
"861847517", "广东省阳江市",
"861528126", "四川省雅安市",
"86155248", "辽宁省大连市",
"86145315", "天津市",
"861536467", "山西省临汾市",
"861534238", "湖北省黄冈市",
"861526644", "山东省枣庄市",
"861377848", "四川省资阳市",
"861893926", "河南省郑州市",
"861776112", "四川省宜宾市",
"861560743", "湖南省湘西土家族苗族自治州",
"86152092", "陕西省西安市",
"861808820", "云南省德宏傣族景颇族自治州",
"861769503", "宁夏吴忠市",
"86130733", "江苏省苏州市",
"861478455", "黑龙江省绥化市",
"861831984", "广东省东莞市",
"861363316", "河北省廊坊市",
"861391205", "江苏省淮安市",
"861841968", "甘肃省庆阳市",
"861398467", "贵州省黔西南布依族苗族自治州",
"861859230", "陕西省延安市",
"861810611", "江苏省常州市",
"861379903", "福建省三明市",
"861503996", "河南省安阳市",
"86147450", "四川省成都市",
"861338243", "江苏省扬州市",
"861332413", "辽宁省抚顺市",
"861329356", "山西省晋城市",
"861802562", "广东省汕头市",
"861459177", "内蒙古鄂尔多斯市",
"861317956", "江苏省宿迁市",
"861378786", "湖南省常德市",
"861839552", "安徽省宣城市",
"861311988", "广东省佛山市",
"861325896", "山东省枣庄市",
"861520735", "湖南省郴州市",
"861869592", "河南省新乡市",
"861782068", "广东省广州市",
"861324944", "广东省深圳市",
"861520015", "河北省邢台市",
"861362610", "江苏省南京市",
"861319775", "广西玉林市",
"861322072", "山东省滨州市",
"861881231", "云南省普洱市",
"861355152", "四川省内江市",
"861768998", "福建省福州市",
"861813444", "河南省濮阳市",
"86132661", "广东省东莞市",
"861524025", "江苏省淮安市",
"861343751", "广东省汕尾市",
"861594528", "黑龙江省鹤岗市",
"861325268", "吉林省辽源市",
"861533623", "陕西省榆林市",
"861811371", "四川省广元市",
"861534682", "甘肃省定西市",
"861350049", "辽宁省辽阳市",
"861532889", "四川省南充市",
"861378598", "河北省邢台市",
"861372214", "内蒙古赤峰市",
"861378444", "河北省唐山市",
"86133165", "广东省深圳市",
"861773954", "河南省漯河市",
"861378173", "河南省漯河市",
"861367682", "浙江省金华市",
"861336982", "新疆伊犁哈萨克自治州",
"86181943", "甘肃省白银市",
"861773023", "安徽省合肥市",
"861899485", "江苏省扬州市",
"86181262", "广东省深圳市",
"861330795", "江西省宜春市",
"861363554", "安徽省淮南市",
"861823671", "河南省三门峡市",
"861370810", "四川省德阳市",
"861360755", "福建省漳州市",
"861317961", "江苏省苏州市",
"861329361", "山西省忻州市",
"861803621", "江苏省南通市",
"861522911", "陕西省延安市",
"861867246", "湖北省荆门市",
"861550318", "河北省衡水市",
"861598982", "广东省汕头市",
"861373431", "山东省日照市",
"861564977", "河南省三门峡市",
"861373993", "内蒙古赤峰市",
"861818993", "西藏山南地区",
"861538040", "江苏省南京市",
"861818431", "贵州省毕节地区",
"861867649", "广东省珠海市",
"86132285", "重庆市",
"861477082", "江西省赣州市",
"861586622", "山东省枣庄市",
"861855104", "江苏省无锡市",
"861760152", "江苏省南通市",
"861384922", "河南省鹤壁市",
"861856122", "山东省东营市",
"861897871", "广西玉林市",
"861318827", "辽宁省抚顺市",
"861510884", "云南省文山壮族苗族自治州",
"861863502", "山西省忻州市",
"861515630", "安徽省芜湖市",
"861770605", "福建省泉州市",
"861832747", "湖北省宜昌市",
"861530337", "河北省沧州市",
"861337977", "新疆乌鲁木齐市",
"861358284", "河北省唐山市",
"861880634", "山东省莱芜市",
"861522087", "广东省中山市",
"861819008", "四川省德阳市",
"861842902", "陕西省榆林市",
"861378876", "广西柳州市",
"861536831", "云南省大理白族自治州",
"86153760", "山东省临沂市",
"86156690", "浙江省杭州市",
"861804876", "四川省宜宾市",
"861567850", "广西玉林市",
"861879522", "宁夏石嘴山市",
"861882998", "广东省东莞市",
"861352536", "河南省平顶山市",
"86139983", "辽宁省沈阳市",
"861535133", "四川省广安市",
"861776199", "江苏省扬州市",
"861319885", "四川省资阳市",
"86147775", "广西玉林市",
"861364890", "西藏拉萨市",
"861872988", "陕西省榆林市",
"861397243", "湖北省恩施土家族苗族自治州",
"86189541", "山东省济南市",
"861847017", "江西省抚州市",
"861875890", "浙江省金华市",
"861805131", "江苏省南通市",
"86177700", "江西省九江市",
"861528041", "福建省福州市",
"861362601", "福建省三明市",
"861886745", "湖南省长沙市",
"86187560", "安徽省合肥市",
"861390349", "山西省朔州市",
"86136460", "福建省漳州市",
"861348346", "河北省沧州市",
"861308860", "浙江省台州市",
"861858918", "西藏林芝地区",
"861399107", "陕西省榆林市",
"861301775", "浙江省嘉兴市",
"861569754", "广东省汕头市",
"861855542", "安徽省合肥市",
"861365860", "山东省济南市",
"861321725", "湖北省黄冈市",
"86147400", "辽宁省沈阳市",
"861380999", "新疆博尔塔拉蒙古自治州",
"861863473", "山西省临汾市",
"861302350", "江苏省徐州市",
"861510393", "甘肃省张掖市",
"861317471", "浙江省嘉兴市",
"861309988", "云南省玉溪市",
"861830806", "西藏那曲地区",
"861339360", "广西来宾市",
"861539794", "江西省抚州市",
"861535457", "吉林省白城市",
"861532910", "贵州省贵阳市",
"86186913", "陕西省渭南市",
"861302522", "广东省汕头市",
"861312583", "吉林省四平市",
"861590738", "湖南省娄底市",
"861877457", "湖南省怀化市",
"861869092", "新疆博尔塔拉蒙古自治州",
"861303656", "四川省南充市",
"861327644", "山东省济南市",
"861576848", "广东省茂名市",
"861771887", "广东省江门市",
"861579400", "广东省广州市",
"861314259", "江苏省扬州市",
"86150633", "山东省济南市",
"861760589", "浙江省金华市",
"861303259", "江苏省盐城市",
"861524170", "辽宁省铁岭市",
"861599610", "江苏省连云港市",
"861802062", "福建省龙岩市",
"86177475", "内蒙古通辽市",
"861370989", "辽宁省葫芦岛市",
"86132193", "四川省泸州市",
"861708344", "山西省大同市",
"861457027", "江西省赣州市",
"861869556", "宁夏中卫市",
"861529494", "河南省驻马店市",
"861354997", "广东省佛山市",
"861316652", "河北省廊坊市",
"861529548", "江苏省徐州市",
"86130614", "山东省青岛市",
"861572248", "江苏省盐城市",
"861593662", "河南省漯河市",
"861331425", "辽宁省鞍山市",
"861362545", "山东省烟台市",
"861329392", "山西省大同市",
"861598608", "广东省佛山市",
"861899474", "江苏省泰州市",
"861316763", "安徽省芜湖市",
"861325852", "黑龙江省鸡西市",
"861533805", "广东省广州市",
"861500978", "青海省西宁市",
"861317992", "新疆伊犁哈萨克自治州",
"861361869", "湖北省宜昌市",
"861776798", "吉林省松原市",
"86178206", "广东省深圳市",
"86134737", "河北省石家庄市",
"861333312", "河北省保定市",
"861373501", "浙江省舟山市",
"861322533", "山东省淄博市",
"861370567", "安徽省阜阳市",
"861358065", "广东省云浮市",
"861388752", "云南省文山壮族苗族自治州",
"86159051", "江苏省南京市",
"861533414", "湖北省黄冈市",
"861319446", "福建省福州市",
"861388663", "湖北省荆州市",
"861504084", "辽宁省抚顺市",
"861562838", "广东省东莞市",
"861327767", "湖北省武汉市",
"861886630", "山东省威海市",
"861897207", "湖北省襄樊市",
"861871899", "广东省揭阳市",
"861354151", "四川省内江市",
"861860597", "福建省龙岩市",
"86155167", "河南省周口市",
"861534908", "甘肃省白银市",
"861303619", "湖北省咸宁市",
"861535681", "浙江省杭州市",
"861350344", "河南省新乡市",
"861816604", "江西省南昌市",
"861830557", "安徽省宿州市",
"86136723", "广东省肇庆市",
"861351580", "浙江省舟山市",
"861770823", "广东省汕头市",
"861815622", "安徽省铜陵市",
"86155432", "吉林省吉林市",
"861877172", "湖北省孝感市",
"861777508", "安徽省宿州市",
"861369843", "江西省上饶市",
"861355967", "福建省漳州市",
"861818730", "云南省昆明市",
"86180100", "北京市",
"861806872", "江苏省徐州市",
"861556130", "内蒙古呼和浩特市",
"861373010", "河北省石家庄市",
"861335343", "山西省太原市",
"861846497", "山东省日照市",
"861398686", "湖北省恩施土家族苗族自治州",
"861839878", "四川省广元市",
"861340689", "山东省德州市",
"861581376", "广东省江门市",
"861309602", "四川省眉山市",
"86185254", "辽宁省大连市",
"861778015", "四川省绵阳市",
"861828481", "四川省乐山市",
"861332703", "内蒙古乌海市",
"861821864", "广东省湛江市",
"861478357", "河南省许昌市",
"861571443", "吉林省延边朝鲜族自治州",
"861330147", "江苏省南通市",
"861808378", "江苏省扬州市",
"86170766", "广东省广州市",
"861828217", "四川省攀枝花市",
"86184833", "四川省乐山市",
"86133121", "天津市",
"861372654", "广东省汕头市",
"861319874", "四川省达州市",
"86136852", "江苏省常州市",
"861379091", "广东省茂名市",
"86186806", "广东省东莞市",
"861895109", "江苏省宿迁市",
"861471598", "广东省深圳市",
"86180506", "福建省漳州市",
"861351907", "甘肃省酒泉市",
"861881910", "广东省东莞市",
"861801438", "江苏省南通市",
"861857235", "湖北省宜昌市",
"86180655", "福建省泉州市",
"861776086", "安徽省安庆市",
"861869061", "新疆阿勒泰地区",
"86184590", "福建省泉州市",
"861308517", "湖北省荆门市",
"86137809", "山东省烟台市",
"861760477", "内蒙古鄂尔多斯市",
"861770541", "山东省济南市",
"861365517", "江苏省南京市",
"86559", "安徽省黄山市",
"861588436", "四川省乐山市",
"86186827", "四川省巴中市",
"861810076", "广西南宁市",
"86182522", "江苏省盐城市",
"861821946", "广东省茂名市",
"861339309", "河北省邢台市",
"861845238", "江苏省南京市",
"861804132", "辽宁省抚顺市",
"861780324", "河北省承德市",
"861317770", "江西省九江市",
"86182948", "甘肃省白银市",
"861536686", "江苏省扬州市",
"861594915", "江苏省淮安市",
"861840642", "山西省临汾市",
"861899964", "新疆喀什地区",
"861376814", "广西梧州市",
"861320495", "湖南省永州市",
"861872602", "安徽省马鞍山市",
"861390044", "福建省福州市",
"861323748", "湖南省长沙市",
"861590925", "陕西省商洛市",
"861362045", "广东省茂名市",
"861520640", "山东省菏泽市",
"861356957", "河南省平顶山市",
"861301446", "江西省宜春市",
"861862372", "河南省安阳市",
"86132120", "天津市",
"861816723", "浙江省宁波市",
"861806782", "浙江省湖州市",
"861303692", "广西柳州市",
"861869056", "陕西省安康市",
"861800995", "新疆吐鲁番地区",
"861529048", "河南省安阳市",
"86134192", "四川省宜宾市",
"861871812", "广东省梅州市",
"861870527", "江苏省扬州市",
"861458124", "安徽省安庆市",
"861530435", "吉林省通化市",
"861890154", "江苏省苏州市",
"861335187", "黑龙江省鸡西市",
"86150714", "湖北省武汉市",
"861510785", "广西玉林市",
"861517763", "广西百色市",
"86189234", "广东省深圳市",
"861860802", "四川省成都市",
"861894341", "吉林省通化市",
"86159001", "广东省湛江市",
"861554657", "黑龙江省绥化市",
"861823016", "河北省廊坊市",
"861317919", "吉林省通化市",
"861362250", "广东省佛山市",
"861573791", "河南省商丘市",
"861522969", "陕西省延安市",
"861830057", "山东省菏泽市",
"861471786", "山西省晋中市",
"861807777", "广西南宁市",
"861884991", "云南省怒江傈僳族自治州",
"861329319", "河北省秦皇岛市",
"861810898", "西藏拉萨市",
"861359353", "山西省临汾市",
"861370277", "广东省珠海市",
"861580616", "江苏省无锡市",
"861355893", "四川省资阳市",
"861332290", "广东省中山市",
"861883040", "河北省承德市",
"861531244", "江苏省连云港市",
"861459452", "陕西省商洛市",
"861306749", "福建省泉州市",
"861363359", "山西省运城市",
"861700565", "浙江省金华市",
"861330894", "西藏林芝地区",
"861886476", "河南省焦作市",
"86156623", "山东省威海市",
"861850758", "广东省肇庆市",
"86180150", "江苏省常州市",
"861333399", "河南省许昌市",
"861308981", "黑龙江省双鸭山市",
"861389581", "黑龙江省哈尔滨市",
"861368915", "陕西省安康市",
"861570638", "山东省烟台市",
"861328368", "山西省大同市",
"861774813", "四川省自贡市",
"861569855", "山西省太原市",
"861579710", "湖北省十堰市",
"861508395", "江西省宜春市",
"861572994", "新疆吐鲁番地区",
"861354166", "四川省自贡市",
"86152725", "湖北省荆州市",
"861301874", "广东省中山市",
"86186856", "贵州省铜仁地区",
"861310629", "浙江省丽水市",
"861787706", "广西玉林市",
"861582984", "陕西省西安市",
"861522479", "河南省商丘市",
"86180556", "安徽省安庆市",
"86132429", "广东省深圳市",
"86132507", "广东省广州市",
"86136802", "广东省中山市",
"861475617", "河北省沧州市",
"861472993", "陕西省安康市",
"861760384", "河南省郑州市",
"8618478", "湖南省长沙市",
"861322291", "江苏省无锡市",
"86130502", "辽宁省本溪市",
"861379591", "四川省德阳市",
"861850813", "四川省自贡市",
"861308017", "河南省许昌市",
"86180459", "黑龙江省大庆市",
"861319784", "江西省新余市",
"861874017", "辽宁省阜新市",
"861365737", "湖南省益阳市",
"861781432", "内蒙古锡林郭勒盟",
"86147862", "贵州省六盘水市",
"861337686", "浙江省台州市",
"861539332", "甘肃省平凉市",
"861315818", "贵州省六盘水市",
"861308737", "湖南省益阳市",
"861810576", "浙江省台州市",
"861506114", "江苏省常州市",
"861802591", "广东省东莞市",
"861858170", "四川省南充市",
"86177743", "湖南省湘西土家族苗族自治州",
"861800643", "山东省淄博市",
"861592521", "云南省昆明市",
"861361698", "福建省南平市",
"861820859", "贵州省黔西南布依族苗族自治州",
"86180605", "福建省福州市",
"86159452", "黑龙江省齐齐哈尔市",
"861332624", "山东省威海市",
"86189570", "浙江省丽水市",
"86181359", "山西省运城市",
"861869561", "福建省福州市",
"861337289", "辽宁省本溪市",
"861339434", "吉林省四平市",
"861839788", "江西省景德镇市",
"861390498", "辽宁省阜新市",
"861530641", "山东省济南市",
"861524918", "陕西省西安市",
"861886844", "浙江省杭州市",
"861458237", "安徽省滁州市",
"861564289", "辽宁省锦州市",
"861811654", "四川省攀枝花市",
"861390544", "山东省德州市",
"86138858", "贵州省六盘水市",
"861477813", "广东省茂名市",
"861355196", "四川省广安市",
"861564365", "吉林省白城市",
"861312593", "黑龙江省牡丹江市",
"861500550", "安徽省滁州市",
"861863346", "河北省石家庄市",
"861869082", "新疆乌鲁木齐市",
"86151344", "吉林省四平市",
"861760599", "福建省南平市",
"861884860", "贵州省毕节地区",
"86150444", "吉林省四平市",
"861806118", "江苏省镇江市",
"861856301", "山东省滨州市",
"861355732", "广西柳州市",
"861370999", "新疆伊犁哈萨克自治州",
"861310641", "浙江省金华市",
"861892267", "广东省揭阳市",
"861458590", "山东省潍坊市",
"861508211", "四川省资阳市",
"861519434", "山东省德州市",
"861300424", "浙江省嘉兴市",
"861890392", "河南省鹤壁市",
"861320474", "内蒙古乌兰察布市",
"861380989", "广东省深圳市",
"861500322", "河北省保定市",
"861336770", "广西防城港市",
"861346626", "云南省红河哈尼族彝族自治州",
"861862640", "江苏省宿迁市",
"861520372", "河南省安阳市",
"861322315", "河北省唐山市",
"861361063", "山西省运城市",
"861539784", "江西省上饶市",
"861889522", "宁夏石嘴山市",
"861845259", "江苏省徐州市",
"86134086", "四川省成都市",
"861872998", "陕西省西安市",
"861357976", "新疆石河子市",
"861875880", "浙江省宁波市",
"861581185", "广东省广州市",
"861760732", "湖南省湘潭市",
"861870634", "山东省莱芜市",
"861598770", "云南省玉溪市",
"861530629", "江苏省南通市",
"861522097", "广东省佛山市",
"86150921", "山东省青岛市",
"86188560", "安徽省合肥市",
"861876745", "浙江省温州市",
"861368726", "湖北省武汉市",
"861801459", "江苏省镇江市",
"861592549", "云南省临沧市",
"861478842", "河南省洛阳市",
"861348473", "内蒙古鄂尔多斯市",
"861889350", "甘肃省武威市",
"861315355", "山东省东营市",
"861882988", "陕西省西安市",
"861347547", "山东省济宁市",
"861571195", "广东省深圳市",
"861860969", "安徽省阜阳市",
"861898723", "云南省大理白族自治州",
"861576622", "广东省肇庆市",
"86155116", "河北省石家庄市",
"861364919", "陕西省铜川市",
"86147713", "广东省广州市",
"861595805", "浙江省舟山市",
"861383431", "山西省晋城市",
"861535662", "浙江省嘉兴市",
"861383993", "河南省驻马店市",
"861860479", "内蒙古锡林郭勒盟",
"861317608", "山东省临沂市",
"861595414", "山东省日照市",
"861707910", "浙江省宁波市",
"861598992", "广东省东莞市",
"861332537", "陕西省宝鸡市",
"861374922", "河南省鹤壁市",
"86188166", "上海市",
"86145351", "山东省青岛市",
"861774807", "四川省宜宾市",
"861477092", "江西省赣州市",
"861847157", "湖北省武汉市",
"861521699", "广东省江门市",
"861566619", "山东省临沂市",
"861320846", "黑龙江省大庆市",
"861537919", "甘肃省平凉市",
"861831248", "广东省深圳市",
"861575604", "安徽省铜陵市",
"861593681", "河南省安阳市",
"861336992", "新疆伊犁哈萨克自治州",
"861858936", "云南省玉溪市",
"861362478", "内蒙古巴彦淖尔市",
"861850519", "江苏省常州市",
"861333584", "浙江省宁波市",
"861320964", "宁夏中卫市",
"861899495", "江苏省宿迁市",
"861330785", "广西玉林市",
"861337763", "广东省清远市",
"861775272", "湖南省常德市",
"861502635", "新疆阿克苏地区",
"861820553", "安徽省芜湖市",
"861310435", "吉林省通化市",
"861326771", "广东省汕尾市",
"861477807", "广东省湛江市",
"861509425", "云南省昭通市",
"861529475", "河南省周口市",
"861337652", "广东省揭阳市",
"861588342", "四川省德阳市",
"861380810", "四川省德阳市",
"861308003", "吉林省长春市",
"86182371", "河南省郑州市",
"86182303", "河北省秦皇岛市",
"861846930", "云南省玉溪市",
"861562859", "西藏拉萨市",
"86177413", "辽宁省沈阳市",
"861534692", "甘肃省定西市",
"861783954", "河南省南阳市",
"861532899", "四川省攀枝花市",
"861804588", "黑龙江省伊春市",
"861561570", "山东省菏泽市",
"86156314", "河北省邯郸市",
"861532668", "黑龙江省齐齐哈尔市",
"861378796", "湖南省张家界市",
"861325886", "吉林省白城市",
"861301332", "云南省昆明市",
"861311998", "新疆喀什地区",
"861358948", "山东省淄博市",
"861329154", "浙江省嘉兴市",
"861316365", "黑龙江省绥化市",
"861594726", "内蒙古鄂尔多斯市",
"861501434", "广东省江门市",
"861858660", "贵州省六盘水市",
"861800464", "黑龙江省七台河市",
"861862928", "陕西省西安市",
"861364770", "广西防城港市",
"861772068", "福建省南平市",
"861324632", "广东省佛山市",
"861361563", "安徽省宣城市",
"861831994", "广东省阳江市",
"861322839", "四川省绵阳市",
"861846385", "山东省淄博市",
"861771963", "陕西省榆林市",
"861388786", "云南省德宏傣族景颇族自治州",
"861370912", "陕西省西安市",
"861587535", "广东省汕头市",
"861589287", "四川省德阳市",
"861572975", "四川省巴中市",
"86184082", "四川省成都市",
"861355099", "四川省广安市",
"861871593", "河北省承德市",
"861528324", "四川省资阳市",
"86183370", "河南省商丘市",
"861819459", "青海省海东地区",
"861336880", "云南省昆明市",
"861760512", "江苏省苏州市",
"861889022", "湖南省长沙市",
"861308472", "内蒙古包头市",
"861508200", "四川省内江市",
"861893405", "广东省茂名市",
"861874472", "贵州省安顺市",
"861354676", "山西省忻州市",
"861539874", "云南省曲靖市",
"86155249", "辽宁省朝阳市",
"86151121", "广东省广州市",
"861365472", "内蒙古包头市",
"861328422", "辽宁省大连市",
"861700948", "重庆市",
"861781777", "广东省深圳市",
"861556976", "甘肃省酒泉市",
"861510147", "甘肃省甘南藏族自治州",
"86139544", "山东省临沂市",
"861369549", "山东省临沂市",
"861361902", "四川省自贡市",
"861770529", "江苏省镇江市",
"861868766", "云南省昆明市",
"861454934", "江苏省南通市",
"861779949", "新疆伊犁哈萨克自治州",
"861331236", "贵州省黔南布依族苗族自治州",
"861890319", "河北省邢台市",
"861816242", "湖北省武汉市",
"861351326", "河北省廊坊市",
"861771502", "江苏省南通市",
"861357451", "湖南省娄底市",
"861556466", "山东省枣庄市",
"861767331", "湖南省郴州市",
"861321959", "四川省资阳市",
"861516608", "山东省淄博市",
"86130323", "重庆市",
"861774019", "四川省成都市",
"861561260", "河北省廊坊市",
"861332305", "河北省唐山市",
"861470426", "辽宁省盘锦市",
"861570571", "浙江省杭州市",
"86131423", "湖南省衡阳市",
"861850592", "福建省厦门市",
"861848923", "西藏山南地区",
"86138437", "吉林省辽源市",
"861336919", "陕西省宝鸡市",
"861367619", "广东省江门市",
"861385949", "福建省南平市",
"861325183", "吉林省延边朝鲜族自治州",
"861572465", "辽宁省铁岭市",
"861857426", "河南省郑州市",
"86145301", "北京市",
"861591647", "广东省潮州市",
"861309244", "江苏省泰州市",
"861532812", "四川省广元市",
"861330875", "云南省保山市",
"861303908", "吉林省延边朝鲜族自治州",
"861315681", "山东省东营市",
"861314908", "广东省韶关市",
"861308962", "黑龙江省伊春市",
"861332717", "内蒙古包头市",
"861839199", "陕西省铜川市",
"861365962", "广西柳州市",
"861800974", "青海省海南藏族自治州",
"86153198", "陕西省安康市",
"861363338", "河北省保定市",
"861539446", "福建省厦门市",
"861313414", "辽宁省本溪市",
"861454828", "广东省韶关市",
"861334952", "黑龙江省齐齐哈尔市",
"861840370", "河南省商丘市",
"861853437", "山西省晋中市",
"861878414", "四川省宜宾市",
"861829544", "宁夏固原市",
"861475724", "浙江省金华市",
"861850739", "湖南省邵阳市",
"861364992", "新疆博尔塔拉蒙古自治州",
"861840204", "广东省佛山市",
"861333084", "四川省资阳市",
"861566692", "山东省济宁市",
"861537992", "甘肃省临夏回族自治州",
"861804088", "新疆喀什地区",
"861561070", "山东省泰安市",
"861771144", "四川省成都市",
"861477739", "广西河池市",
"861536763", "湖南省邵阳市",
"861833418", "贵州省毕节地区",
"861551401", "河南省安阳市",
"861551769", "河南省濮阳市",
"861775903", "福建省福州市",
"861527771", "广西南宁市",
"861308503", "安徽省六安市",
"861590536", "山东省潍坊市",
"861813088", "新疆乌鲁木齐市",
"86182353", "山西省阳泉市",
"861839798", "江西省景德镇市",
"861390488", "黑龙江省佳木斯市",
"861806970", "浙江省湖州市",
"861390321", "河北省石家庄市",
"861591764", "广东省清远市",
"861508079", "湖南省湘潭市",
"861534656", "河南省郑州市",
"861359854", "河南省焦作市",
"861896645", "浙江省舟山市",
"861860911", "陕西省延安市",
"86138859", "贵州省黔西南布依族苗族自治州",
"861534259", "湖北省鄂州市",
"861869758", "安徽省宿州市",
"861807473", "广西桂林市",
"861846200", "山东省青岛市",
"861573937", "新疆巴音郭楞蒙古自治州",
"861364471", "内蒙古呼和浩特市",
"86134356", "广东省广州市",
"861564696", "新疆阿克苏地区",
"861532583", "浙江省嘉兴市",
"861315457", "黑龙江省大兴安岭地区",
"861319794", "江西省抚州市",
"861774056", "湖北省襄樊市",
"86137858", "河北省衡水市",
"861871901", "广东省中山市",
"861459667", "新疆昌吉回族自治州",
"861392442", "广东省清远市",
"861337696", "福建省泉州市",
"861537471", "内蒙古呼和浩特市",
"861330393", "河南省濮阳市",
"861321916", "四川省达州市",
"861802581", "广东省江门市",
"86176898", "海南省海口市",
"861336956", "宁夏石嘴山市",
"861360353", "山西省太原市",
"861859097", "陕西省宝鸡市",
"861858206", "四川省广元市",
"861361688", "浙江省宁波市",
"861340612", "山东省东营市",
"861893535", "山西省长治市",
"861337299", "辽宁省丹东市",
"86181358", "山西省吕梁市",
"861823038", "河北省张家口市",
"861890734", "湖南省衡阳市",
"86135251", "河南省南阳市",
"861514850", "内蒙古锡林郭勒盟",
"861582994", "陕西省咸阳市",
"861766026", "山东省泰安市",
"86147634", "山东省潍坊市",
"86132428", "广东省广州市",
"861472983", "陕西省商洛市",
"861853980", "河南省三门峡市",
"861760394", "河南省周口市",
"861580638", "山东省烟台市",
"861379581", "四川省宜宾市",
"861315133", "江苏省淮安市",
"861517467", "黑龙江省牡丹江市",
"861325631", "山东省威海市",
"861508269", "四川省广安市",
"861554790", "内蒙古巴彦淖尔市",
"861389591", "黑龙江省黑河市",
"861322417", "辽宁省营口市",
"861325950", "宁夏银川市",
"861381940", "浙江省嘉兴市",
"861501504", "广东省江门市",
"861572984", "四川省自贡市",
"861508385", "江西省宜春市",
"861803649", "江苏省常州市",
"86170902", "广东省惠州市",
"861555108", "安徽省马鞍山市",
"861338722", "湖北省襄樊市",
"861310337", "河北省沧州市",
"861814246", "陕西省汉中市",
"861570616", "江苏省常州市",
"861707593", "福建省泉州市",
"861335630", "山东省威海市",
"861335951", "黑龙江省哈尔滨市",
"861330884", "云南省昆明市",
"861365433", "吉林省延边朝鲜族自治州",
"86182340", "山西省太原市",
"861827254", "河南省鹤壁市",
"861538827", "四川省自贡市",
"861899397", "甘肃省白银市",
"861308433", "四川省南充市",
"861874991", "河南省濮阳市",
"861814649", "新疆乌鲁木齐市",
"861308991", "黑龙江省大兴安岭地区",
"861554972", "湖北省黄石市",
"861850314", "河北省承德市",
"861333389", "河南省洛阳市",
"861561606", "湖南省衡阳市",
"861776878", "江苏省镇江市",
"861350021", "广东省阳江市",
"861876476", "山东省济宁市",
"861471796", "山西省运城市",
"861310005", "山西省长治市",
"861318040", "河北省唐山市",
"861884981", "云南省保山市",
"861866127", "江苏省无锡市",
"861810888", "云南省丽江市",
"861707178", "江西省鹰潭市",
"861332280", "广东省广州市",
"861850561", "安徽省淮北市",
"861381455", "江苏省苏州市",
"861301373", "江苏省扬州市",
"861566661", "山东省日照市",
"861537961", "宁夏石嘴山市",
"861315836", "贵州省铜仁地区",
"861321323", "河南省郑州市",
"861335197", "黑龙江省鸡西市",
"861510795", "江西省宜春市",
"861595704", "浙江省衢州市",
"861365157", "江苏省盐城市",
"861458326", "江西省吉安市",
"86187781", "广西南宁市",
"861848359", "四川省雅安市",
"86152335", "河北省秦皇岛市",
"861862515", "江苏省南京市",
"861890356", "山西省晋城市",
"861308157", "内蒙古赤峰市",
"86158684", "浙江省杭州市",
"86130999", "云南省昆明市",
"861333075", "四川省广元市",
"86151165", "湖南省永州市",
"861760883", "云南省临沧市",
"861323546", "湖北省恩施土家族苗族自治州",
"86153581", "江苏省南京市",
"861596722", "浙江省湖州市",
"861867621", "广东省东莞市",
"861314171", "湖南省郴州市",
"86145081", "江苏省南京市",
"861833342", "河北省沧州市",
"861889947", "新疆塔城地区",
"861304623", "广东省湛江市",
"86136296", "云南省昆明市",
"861303682", "广西柳州市",
"861880527", "江苏省扬州市",
"861313623", "浙江省嘉兴市",
"86156931", "甘肃省兰州市",
"861303171", "山东省济南市",
"861800985", "辽宁省盘锦市",
"861550855", "贵州省黔东南苗族侗族自治州",
"861364961", "云南省红河哈尼族彝族自治州",
"861893307", "广东省潮州市",
"861589701", "青海省西宁市",
"861890361", "黑龙江省哈尔滨市",
"861815848", "浙江省宁波市",
"861539775", "四川省雅安市",
"861780541", "山东省济南市",
"861865047", "福建省福州市",
"861336471", "新疆伊犁哈萨克自治州",
"86182949", "甘肃省白银市",
"861350843", "湖南省湘西土家族苗族自治州",
"861531988", "陕西省铜川市",
"861537956", "宁夏石嘴山市",
"861327463", "黑龙江省哈尔滨市",
"861320485", "内蒙古鄂尔多斯市",
"861452821", "四川省宜宾市",
"861566656", "山东省潍坊市",
"8613269", "北京市",
"86184352", "山西省大同市",
"861528529", "贵州省黔东南苗族侗族自治州",
"861826648", "山东省青岛市",
"86159947", "广东省深圳市",
"861364956", "宁夏固原市",
"861335844", "福建省南平市",
"861502740", "河北省石家庄市",
"861800330", "河北省邯郸市",
"861840934", "甘肃省庆阳市",
"861776096", "四川省成都市",
"861882602", "广东省中山市",
"86181308", "新疆喀什地区",
"861884809", "内蒙古兴安盟",
"86137808", "山东省潍坊市",
"861847472", "湖南省怀化市",
"861770324", "河北省承德市",
"861860900", "新疆乌鲁木齐市",
"861868945", "广东省东莞市",
"861895670", "安徽省阜阳市",
"861805945", "福建省莆田市",
"861376926", "云南省楚雄彝族自治州",
"86152580", "浙江省温州市",
"861590759", "广东省湛江市",
"861846211", "山东省济宁市",
"861335966", "黑龙江省伊春市",
"86151660", "山东省青岛市",
"861571376", "河南省信阳市",
"861354731", "四川省巴中市",
"861471588", "广东省阳江市",
"86135273", "重庆市",
"861708843", "江西省萍乡市",
"86134327", "广东省汕尾市",
"861398696", "湖北省荆门市",
"861850556", "安徽省安庆市",
"861834234", "辽宁省盘锦市",
"861598471", "四川省阿坝藏族羌族自治州",
"861871910", "广东省湛江市",
"861340296", "陕西省西安市",
"861581174", "广东省清远市",
"861453738", "湖南省长沙市",
"86158870", "云南省昆明市",
"861818150", "四川省乐山市",
"861805693", "安徽省安庆市",
"861805450", "山东省滨州市",
"861760773", "广西桂林市",
"861454204", "河南省郑州市",
"861331906", "新疆阿勒泰地区",
"861868450", "湖南省岳阳市",
"861557672", "湖南省衡阳市",
"861876630", "山东省威海市",
"861881899", "广东省深圳市",
"861778155", "四川省成都市",
"861454370", "山东省济南市",
"86170952", "江苏省无锡市",
"861595623", "安徽省池州市",
"86152186", "广东省揭阳市",
"861847503", "广东省广州市",
"86177227", "广东省佛山市",
"861873540", "山西省晋中市",
"86182083", "四川省泸州市",
"861452543", "山东省滨州市",
"861350146", "广东省清远市",
"861554203", "辽宁省锦州市",
"861871889", "广东省梅州市",
"861316977", "广东省茂名市",
"861508930", "广东省惠州市",
"861860587", "浙江省温州市",
"861359941", "福建省福州市",
"861383010", "甘肃省临夏回族自治州",
"86187117", "湖南省益阳市",
"861565930", "福建省宁德市",
"861505064", "江苏省南通市",
"861335476", "内蒙古赤峰市",
"861705602", "广东省广州市",
"861780823", "四川省遂宁市",
"861350521", "江苏省徐州市",
"861787508", "广东省汕尾市",
"861313704", "河南省洛阳市",
"861351590", "福建省龙岩市",
"861318540", "浙江省嘉兴市",
"861395594", "安徽省铜陵市",
"861560345", "山西省长治市",
"861862735", "湖南省郴州市",
"861776788", "吉林省白城市",
"861801416", "江苏省淮安市",
"86138784", "广西梧州市",
"861342829", "广东省江门市",
"861853892", "河南省郑州市",
"861571747", "湖南省永州市",
"861810778", "广西河池市",
"861355773", "广西桂林市",
"861534661", "湖北省十堰市",
"861588418", "四川省泸州市",
"86150965", "云南省昭通市",
"861529484", "河南省信阳市",
"861589979", "广东省深圳市",
"861804663", "江西省上饶市",
"861326470", "湖北省武汉市",
"861367661", "浙江省衢州市",
"861379917", "福建省三明市",
"861375921", "云南省德宏傣族景颇族自治州",
"861333575", "浙江省绍兴市",
"86177206", "福建省泉州市",
"861329382", "山西省大同市",
"861327973", "新疆喀什地区",
"861813663", "江苏省扬州市",
"861380567", "安徽省阜阳市",
"861822743", "四川省绵阳市",
"861520333", "河北省张家口市",
"861330774", "广西梧州市",
"86139231", "广东省佛山市",
"861319373", "河南省驻马店市",
"861774061", "湖北省荆门市",
"86159996", "广东省深圳市",
"861317982", "新疆乌鲁木齐市",
"861478410", "河南省商丘市",
"861820464", "黑龙江省七台河市",
"861364720", "湖北省武汉市",
"861878632", "贵州省遵义市",
"861862978", "吉林省白山市",
"861304632", "广东省中山市",
"861367748", "湖南省长沙市",
"861554047", "内蒙古呼伦贝尔市",
"861866452", "广东省广州市",
"861705014", "浙江省杭州市",
"861530566", "安徽省池州市",
"861810935", "甘肃省武威市",
"861836760", "浙江省嘉兴市",
"861857844", "广东省佛山市",
"861346430", "辽宁省锦州市",
"861316542", "山东省青岛市",
"861368886", "广东省广州市",
"86147816", "四川省绵阳市",
"861869646", "湖北省荆州市",
"861707729", "江西省宜春市",
"861321332", "河南省周口市",
"86181072", "湖北省武汉市",
"86155808", "湖南省长沙市",
"861309154", "黑龙江省绥化市",
"861869249", "湖南省邵阳市",
"861594776", "内蒙古呼伦贝尔市",
"861384870", "内蒙古呼伦贝尔市",
"861534748", "广东省汕头市",
"861342188", "广东省汕头市",
"861332164", "广西贺州市",
"861347491", "内蒙古呼和浩特市",
"861537720", "湖北省咸宁市",
"861310169", "黑龙江省双鸭山市",
"861560233", "广东省广州市",
"861770579", "浙江省金华市",
"861569567", "安徽省亳州市",
"861366404", "内蒙古乌兰察布市",
"861375419", "内蒙古锡林郭勒盟",
"861559081", "黑龙江省鸡西市",
"861816589", "广东省肇庆市",
"861453465", "黑龙江省七台河市",
"861502597", "甘肃省天水市",
"861859740", "福建省三明市",
"86157201", "河北省保定市",
"861351376", "河南省信阳市",
"86157273", "北京市",
"861470966", "宁夏固原市",
"861334339", "河北省承德市",
"861882356", "广东省揭阳市",
"861452480", "内蒙古呼伦贝尔市",
"861772228", "广东省广州市",
"861338733", "湖南省株洲市",
"861572925", "河南省濮阳市",
"861354229", "广东省韶关市",
"861328472", "内蒙古包头市",
"861346569", "山东省潍坊市",
"861781727", "广东省茂名市",
"861771254", "江苏省盐城市",
"861365422", "辽宁省鞍山市",
"861830647", "山东省东营市",
"861354626", "山西省吕梁市",
"861308422", "河南省鹤壁市",
"861318483", "广东省揭阳市",
"861580344", "山西省晋中市",
"861315122", "江苏省徐州市",
"861330825", "重庆市",
"861343705", "江西省宜春市",
"861323908", "新疆阿克苏地区",
"861377672", "江苏省淮安市",
"861857476", "湖南省邵阳市",
"861882014", "广东省广州市",
"861538201", "辽宁省葫芦岛市",
"861328962", "陕西省汉中市",
"861588275", "四川省凉山彝族自治州",
"861380442", "吉林省吉林市",
"861518335", "四川省乐山市",
"861371711", "广东省深圳市",
"861836108", "江苏省盐城市",
"861854651", "黑龙江省哈尔滨市",
"861808203", "江苏省连云港市",
"861301959", "内蒙古赤峰市",
"861519699", "四川省宜宾市",
"861386130", "江苏省苏州市",
"86132323", "广东省中山市",
"861563862", "河南省信阳市",
"86147349", "广东省广州市",
"861518007", "江西省鹰潭市",
"861360701", "江西省鹰潭市",
"861568808", "贵州省六盘水市",
"86138432", "吉林省吉林市",
"861360469", "黑龙江省佳木斯市",
"861700857", "贵州省毕节地区",
"861570521", "江苏省徐州市",
"861387191", "湖北省孝感市",
"86184574", "浙江省宁波市",
"861571590", "福建省福州市",
"861382488", "广东省茂名市",
"861824088", "陕西省西安市",
"861500155", "新疆喀什地区",
"861539938", "陕西省商洛市",
"861458664", "湖南省邵阳市",
"861351747", "湖南省长沙市",
"861318797", "云南省西双版纳傣族自治州",
"861840552", "安徽省蚌埠市",
"861328503", "福建省泉州市",
"861518892", "河北省邯郸市",
"861811044", "安徽省宿州市",
"861867516", "广东省佛山市",
"861575773", "浙江省杭州市",
"86180353", "山西省阳泉市",
"861840320", "河北省邯郸市",
"861386697", "安徽省马鞍山市",
"861816152", "宁夏石嘴山市",
"861454878", "四川省甘孜藏族自治州",
"861820974", "青海省海南藏族自治州",
"861332943", "黑龙江省牡丹江市",
"861360530", "山东省菏泽市",
"861880489", "内蒙古呼和浩特市",
"86180664", "浙江省温州市",
"861862468", "辽宁省阜新市",
"861709896", "广东省中山市",
"86133638", "河北省石家庄市",
"861770651", "浙江省杭州市",
"861770930", "甘肃省临夏回族自治州",
"861352367", "河南省南阳市",
"861590994", "新疆昌吉回族自治州",
"861331048", "贵州省遵义市",
"861705356", "河北省石家庄市",
"861809498", "新疆伊犁哈萨克自治州",
"86185681", "河南省洛阳市",
"861320424", "辽宁省抚顺市",
"861813914", "新疆阿克苏地区",
"861861573", "四川省泸州市",
"861855299", "江苏省南通市",
"861834452", "广东省肇庆市",
"861705514", "浙江省台州市",
"861517542", "河北省邯郸市",
"86184078", "江西省上饶市",
"861528487", "四川省广元市",
"861768514", "贵州省黔南布依族苗族自治州",
"861532955", "贵州省黔东南苗族侗族自治州",
"861345559", "山东省济宁市",
"861306909", "吉林省延边朝鲜族自治州",
"861375492", "山西省大同市",
"861520322", "河北省保定市",
"861353937", "广东省潮州市",
"861336720", "湖北省仙桃市",
"861804914", "陕西省商洛市",
"861500372", "河南省安阳市",
"861307932", "甘肃省嘉峪关市",
"86155858", "贵州省六盘水市",
"861333918", "安徽省淮南市",
"861397013", "江西省赣州市",
"861705361", "江苏省南京市",
"861520550", "安徽省滁州市",
"86131076", "福建省福州市",
"861566748", "陕西省汉中市",
"861770666", "浙江省温州市",
"861316042", "江苏省苏州市",
"861585384", "山东省临沂市",
"86147940", "广东省广州市",
"861767117", "湖北省襄樊市",
"86152444", "山东省潍坊市",
"861300143", "河北省廊坊市",
"861826118", "江苏省常州市",
"861770269", "广东省茂名市",
"861569277", "贵州省毕节地区",
"861522441", "山东省青岛市",
"861816089", "安徽省亳州市",
"86170712", "天津市",
"861518980", "江苏省南京市",
"861325726", "湖北省恩施土家族苗族自治州",
"861368776", "广西百色市",
"86157251", "山东省济南市",
"86152921", "湖南省株洲市",
"861879707", "青海省海东地区",
"861478401", "河南省驻马店市",
"861821459", "云南省昆明市",
"861534302", "湖南省湘潭市",
"861519868", "云南省西双版纳傣族自治州",
"861780832", "四川省内江市",
"861811102", "四川省南充市",
"861569067", "河南省开封市",
"861590248", "辽宁省营口市",
"861700670", "浙江省温州市",
"861803408", "河北省衡水市",
"861808790", "云南省普洱市",
"861766611", "广东省深圳市",
"861374790", "内蒙古锡林郭勒盟",
"86156325", "河北省唐山市",
"861567404", "湖南省怀化市",
"861530679", "浙江省金华市",
"861366339", "河北省保定市",
"861598720", "云南省楚雄彝族自治州",
"861334815", "江苏省无锡市",
"861367302", "河南省濮阳市",
"861352984", "云南省红河哈尼族彝族自治州",
"861361223", "广东省珠海市",
"861814408", "福建省厦门市",
"861338513", "贵州省安顺市",
"861587130", "湖北省孝感市",
"861830865", "贵州省黔东南苗族侗族自治州",
"861470630", "山东省济南市",
"861883877", "河南省商丘市",
"861454788", "山东省济宁市",
"861479156", "陕西省西安市",
"861320253", "广东省广州市",
"861870412", "辽宁省鞍山市",
"861350616", "江苏省无锡市",
"861518819", "云南省玉溪市",
"861888298", "四川省甘孜藏族自治州",
"861372044", "陕西省榆林市",
"861479718", "山西省太原市",
"861865972", "福建省泉州市",
"861300846", "陕西省汉中市",
"861319959", "黑龙江省鹤岗市",
"861374972", "河南省信阳市",
"861843268", "河北省衡水市",
"861340004", "江苏省无锡市",
"861479038", "安徽省芜湖市",
"861894379", "吉林省白城市",
"861576672", "广东省茂名市",
"861898773", "云南省玉溪市",
"86188436", "吉林省白城市",
"861860429", "辽宁省葫芦岛市",
"861857630", "广东省清远市",
"861313288", "广西贵港市",
"861525285", "江苏省宿迁市",
"86180371", "河南省郑州市",
"861811498", "江苏省徐州市",
"861530551", "安徽省合肥市",
"861810380", "河南省商丘市",
"861811544", "江苏省扬州市",
"861394808", "内蒙古呼伦贝尔市",
"861867016", "江西省萍乡市",
"86180303", "福建省莆田市",
"861889403", "甘肃省兰州市",
"861824588", "黑龙江省大庆市",
"861812711", "广东省江门市",
"86153738", "河北省石家庄市",
"861561520", "山东省菏泽市",
"861538210", "辽宁省沈阳市",
"86188539", "山东省临沂市",
"861532440", "安徽省巢湖市",
"86181471", "内蒙古呼和浩特市",
"861812031", "湖北省黄冈市",
"861560591", "福建省福州市",
"861809044", "四川省巴中市",
"86136438", "河南省郑州市",
"861340360", "山西省大同市",
"86187538", "山东省泰安市",
"861362428", "辽宁省大连市",
"861384657", "黑龙江省大兴安岭地区",
"861331548", "河北省石家庄市",
"861369638", "山东省烟台市",
"861857197", "湖北省荆门市",
"861529425", "甘肃省定西市",
"861360030", "广东省佛山市",
"861800553", "安徽省芜湖市",
"861803192", "河北省石家庄市",
"861519612", "四川省广元市",
"861370855", "贵州省黔东南苗族侗族自治州",
"861326721", "广东省深圳市",
"861361454", "黑龙江省佳木斯市",
"861513660", "河南省商丘市",
"86159528", "江苏省镇江市",
"861820330", "河北省沧州市",
"861450301", "河北省廊坊市",
"861772415", "广东省江门市",
"861346511", "山东省威海市",
"861768392", "湖北省襄樊市",
"861396650", "安徽省亳州市",
"861770374", "河南省许昌市",
"86177318", "河北省保定市",
"861814538", "黑龙江省双鸭山市",
"861504660", "黑龙江省绥化市",
"861569801", "山东省济南市",
"861350659", "浙江省金华市",
"861898599", "贵州省黔西南布依族苗族自治州",
"861336421", "辽宁省朝阳市",
"861700006", "上海市",
"861346364", "河北省廊坊市",
"861518856", "河南省信阳市",
"861478531", "贵州省毕节地区",
"861856818", "河南省濮阳市",
"8615213", "重庆市",
"861533944", "甘肃省兰州市",
"861505137", "江苏省淮安市",
"86159942", "湖北省武汉市",
"861319916", "黑龙江省鸡西市",
"861350256", "广东省揭阳市",
"86184357", "山西省临汾市",
"86159263", "湖北省武汉市",
"861334534", "新疆喀什地区",
"861375709", "浙江省丽水市",
"861539208", "福建省泉州市",
"861454189", "山西省运城市",
"861452871", "宁夏银川市",
"86186246", "辽宁省鞍山市",
"861375461", "山东省威海市",
"861321794", "江西省抚州市",
"861764533", "黑龙江省牡丹江市",
"861533866", "贵州省黔南布依族苗族自治州",
"861352975", "云南省玉溪市",
"861550912", "陕西省榆林市",
"861857745", "广西南宁市",
"861598388", "四川省达州市",
"86183610", "江苏省苏州市",
"861768835", "广东省阳江市",
"861598421", "四川省资阳市",
"86134322", "广东省江门市",
"861808933", "甘肃省平凉市",
"861374933", "河南省濮阳市",
"861573543", "山西省吕梁市",
"861808491", "四川省广安市",
"861582036", "广东省阳江市",
"86137249", "广东省佛山市",
"861865933", "福建省漳州市",
"86147953", "广西梧州市",
"861865491", "山东省烟台市",
"86156880", "贵州省铜仁地区",
"861538931", "陕西省宝鸡市",
"861538493", "新疆阿克苏地区",
"861576633", "广东省湛江市",
"86150580", "浙江省宁波市",
"861898012", "四川省绵阳市",
"861708659", "山东省烟台市",
"861470745", "湖南省怀化市",
"861359297", "广东省茂名市",
"861585089", "江苏省泰州市",
"861577451", "黑龙江省哈尔滨市",
"861571326", "河北省廊坊市",
"861528930", "陕西省咸阳市",
"861324704", "江西省抚州市",
"86187112", "湖南省岳阳市",
"861894264", "河北省石家庄市",
"861826039", "江苏省连云港市",
"86180083", "重庆市",
"861843852", "河南省安阳市",
"861454552", "新疆克孜勒苏柯尔克孜自治州",
"861861799", "河北省石家庄市",
"861316927", "广东省揭阳市",
"861870348", "山西省吕梁市",
"861353480", "广东省江门市",
"861511377", "广东省揭阳市",
"861831759", "河南省新乡市",
"861350571", "浙江省杭州市",
"861335426", "辽宁省大连市",
"861571913", "陕西省渭南市",
"861880267", "广东省深圳市",
"861312729", "山东省临沂市",
"861815191", "江苏省镇江市",
"861523677", "河南省焦作市",
"861760723", "湖北省黄石市",
"861373055", "河北省邢台市",
"861560903", "四川省眉山市",
"861840878", "云南省楚雄彝族自治州",
"861816893", "江苏省无锡市",
"861514627", "黑龙江省哈尔滨市",
"861454320", "内蒙古呼和浩特市",
"86170957", "安徽省合肥市",
"861339689", "浙江省金华市",
"86150186", "广东省惠州市",
"861881440", "广东省梅州市",
"861509484", "山东省日照市",
"861360411", "辽宁省大连市",
"861858312", "四川省宜宾市",
"861839642", "福建省宁德市",
"861347203", "河北省邯郸市",
"861890988", "辽宁省沈阳市",
"861589929", "新疆石河子市",
"861861532", "山东省青岛市",
"861338882", "云南省德宏傣族景颇族自治州",
"861314046", "河南省开封市",
"86181216", "江苏省淮安市",
"86156361", "黑龙江省哈尔滨市",
"861303046", "内蒙古包头市",
"861500333", "河北省张家口市",
"861538787", "江西省赣州市",
"861580549", "山东省临沂市",
"861507636", "河北省承德市",
"861330724", "湖北省咸宁市",
"861375971", "陕西省咸阳市",
"861333525", "山东省潍坊市",
"861882835", "四川省乐山市",
"861573821", "河南省商丘市",
"861344672", "湖北省襄樊市",
"861815957", "福建省漳州市",
"861818240", "陕西省西安市",
"86151639", "山东省临沂市",
"861533163", "云南省丽江市",
"861373240", "浙江省金华市",
"861355723", "广西桂林市",
"861560562", "安徽省铜陵市",
"86152965", "广西南宁市",
"861531514", "山东省烟台市",
"861893130", "河北省张家口市",
"861524094", "云南省临沧市",
"861864837", "内蒙古鄂尔多斯市",
"861889858", "广东省深圳市",
"86182458", "黑龙江省绥化市",
"861814038", "四川省凉山彝族自治州",
"861537421", "江西省九江市",
"861301916", "吉林省吉林市",
"861822581", "安徽省滁州市",
"861783532", "山西省阳泉市",
"86185844", "贵州省遵义市",
"861347462", "陕西省咸阳市",
"861346731", "湖南省长沙市",
"86139480", "内蒙古阿拉善盟",
"861550999", "新疆伊犁哈萨克自治州",
"861565029", "山东省潍坊市",
"861528079", "福建省南平市",
"861837012", "江西省九江市",
"861366534", "山东省德州市",
"861826970", "安徽省安庆市",
"861390371", "河南省郑州市",
"861597493", "云南省西双版纳傣族自治州",
"861700506", "福建省厦门市",
"861364421", "辽宁省朝阳市",
"861333170", "吉林省吉林市",
"861807423", "浙江省宁波市",
"861596990", "山东省日照市",
"861776934", "湖南省衡阳市",
"861364388", "河南省洛阳市",
"861509746", "河北省石家庄市",
"861889291", "新疆阿勒泰地区",
"861478711", "云南省昆明市",
"861586340", "山东省莱芜市",
"861365247", "广东省东莞市",
"861535310", "陕西省渭南市",
"861582536", "宁夏石嘴山市",
"861370336", "河北省保定市",
"861368631", "山东省威海市",
"861510617", "江苏省无锡市",
"861450310", "河北省邯郸市",
"861346500", "山东省菏泽市",
"861705319", "湖南省长沙市",
"861778550", "贵州省黔东南苗族侗族自治州",
"86137510", "广东省深圳市",
"861569810", "山东省莱芜市",
"86186410", "辽宁省铁岭市",
"861768319", "四川省达州市",
"861528666", "贵州省六盘水市",
"861452781", "新疆乌鲁木齐市",
"861585589", "安徽省亳州市",
"861816477", "云南省文山壮族苗族自治州",
"861395660", "安徽省宣城市",
"861351664", "广东省佛山市",
"861859441", "福建省南平市",
"86130428", "湖北省武汉市",
"86187828", "四川省达州市",
"861895948", "福建省龙岩市",
"861835976", "福建省福州市",
"861773789", "河南省南阳市",
"861770487", "内蒙古鄂尔多斯市",
"861318145", "山东省日照市",
"861563891", "河南省郑州市",
"861368445", "四川省雅安市",
"861776828", "江苏省徐州市",
"861816967", "广西桂林市",
"861453984", "广东省肇庆市",
"861572518", "山东省东营市",
"861380318", "河北省衡水市",
"861826539", "山东省临沂市",
"861589135", "陕西省咸阳市",
"861337306", "河北省廊坊市",
"861854793", "内蒙古锡林郭勒盟",
"86878", "云南省楚雄彝族自治州",
"861811349", "四川省广安市",
"861533851", "贵州省贵阳市",
"861859635", "山东省聊城市",
"861533298", "内蒙古通辽市",
"861823649", "河南省驻马店市",
"861852425", "辽宁省丹东市",
"861812769", "广东省韶关市",
"861529327", "甘肃省酒泉市",
"861577466", "黑龙江省鹤岗市",
"861338772", "广西柳州市",
"861345016", "广东省肇庆市",
"861509377", "河南省平顶山市",
"861803853", "广东省河源市",
"86181440", "福建省福州市",
"861823246", "河北省廊坊市",
"861367149", "广东省湛江市",
"861538877", "云南省大理白族自治州",
"861328991", "新疆乌鲁木齐市",
"861818555", "贵州省贵阳市",
"861475785", "浙江省金华市",
"861303546", "安徽省淮北市",
"861327554", "安徽省淮南市",
"86170926", "湖北省武汉市",
"86132999", "天津市",
"861882319", "广东省深圳市",
"86131739", "浙江省绍兴市",
"861770793", "江西省上饶市",
"861771614", "四川省成都市",
"861323682", "辽宁省鞍山市",
"861708071", "湖南省长沙市",
"861303121", "新疆哈密地区",
"861840788", "江西省萍乡市",
"861314546", "山东省东营市",
"861880577", "浙江省温州市",
"861313673", "黑龙江省齐齐哈尔市",
"861830764", "广东省深圳市",
"861375456", "河北省廊坊市",
"861340434", "吉林省四平市",
"861760604", "福建省宁德市",
"86151435", "吉林省通化市",
"861350261", "广东省潮州市",
"861476840", "山东省临沂市",
"861301323", "河北省石家庄市",
"861897849", "广西梧州市",
"861780783", "广西河池市",
"861870702", "江西省九江市",
"86150335", "河北省秦皇岛市",
"86183115", "贵州省遵义市",
"861894574", "黑龙江省黑河市",
"861338595", "福建省泉州市",
"86903", "新疆和田地区",
"86187540", "山东省菏泽市",
"86137736", "江苏省南通市",
"86136440", "辽宁省沈阳市",
"861380788", "广西南宁市",
"861340577", "江苏省无锡市",
"861778955", "甘肃省武威市",
"861364853", "贵州省安顺市",
"861346905", "湖南省长沙市",
"861305555", "福建省三明市",
"861557981", "江西省上饶市",
"861309799", "广西北海市",
"86189561", "安徽省淮北市",
"861875853", "浙江省绍兴市",
"861381362", "江苏省南通市",
"861368555", "安徽省马鞍山市",
"861802117", "江苏省无锡市",
"861598161", "吉林省通化市",
"861825040", "福建省泉州市",
"861597705", "广西玉林市",
"861889383", "甘肃省甘南藏族自治州",
"861537853", "四川省广元市",
"861337667", "广东省清远市",
"861366967", "广西南宁市",
"861810400", "辽宁省沈阳市",
"861818445", "贵州省遵义市",
"86139282", "广东省佛山市",
"861880434", "吉林省四平市",
"86187197", "甘肃省庆阳市",
"861565130", "江苏省南通市",
"861518074", "贵州省贵阳市",
"861525781", "浙江省丽水市",
"86153740", "广东省广州市",
"861533254", "陕西省汉中市",
"861776567", "广东省茂名市",
"861370798", "江西省景德镇市",
"861361349", "山西省朔州市",
"861847162", "湖北省宜昌市",
"861840318", "河北省衡水市",
"861570008", "浙江省杭州市",
"861599410", "河南省安阳市",
"86131119", "海南省海口市",
"86157989", "海南省海口市",
"861314456", "黑龙江省黑河市",
"86157535", "山东省烟台市",
"861519942", "新疆昌吉回族自治州",
"861350864", "湖北省咸宁市",
"861859679", "福建省福州市",
"861510522", "江苏省徐州市",
"861500583", "浙江省嘉兴市",
"861882789", "江西省萍乡市",
"861303456", "山东省威海市",
"861327598", "福建省三明市",
"86176122", "天津市",
"861475315", "山东省青岛市",
"861860768", "广东省潮州市",
"861518264", "四川省自贡市",
"861787616", "广东省阳江市",
"861317182", "河北省秦皇岛市",
"861510350", "山西省忻州市",
"861830581", "浙江省杭州市",
"86159916", "陕西省西安市",
"861450657", "黑龙江省鹤岗市",
"861780313", "河北省张家口市",
"861317671", "山东省潍坊市",
"861825255", "江苏省扬州市",
"861820907", "新疆阿勒泰地区",
"86186739", "湖南省邵阳市",
"861509009", "河南省新乡市",
"861379117", "山东省烟台市",
"861336161", "江西省南昌市",
"86183735", "湖南省郴州市",
"861311712", "湖北省武汉市",
"86158988", "山东省青岛市",
"8613522", "北京市",
"861885016", "福建省厦门市",
"861354187", "四川省广安市",
"861475707", "浙江省绍兴市",
"861376823", "广西桂林市",
"861836046", "江苏省南京市",
"861780926", "陕西省汉中市",
"861820580", "浙江省舟山市",
"8613261", "北京市",
"86185855", "贵州省黔东南苗族侗族自治州",
"861537156", "江苏省泰州市",
"861803421", "河北省石家庄市",
"861567196", "湖北省孝感市",
"861814421", "四川省成都市",
"861814388", "西藏拉萨市",
"861593491", "内蒙古呼和浩特市",
"861580706", "江西省吉安市",
"86181963", "新疆阿克苏地区",
"86138326", "河北省廊坊市",
"861537718", "湖北省咸宁市",
"861356517", "新疆阿勒泰地区",
"86181242", "广东省广州市",
"861478428", "河南省周口市",
"861364038", "广东省揭阳市",
"861336538", "山东省泰安市",
"861804644", "福建省莆田市",
"861364718", "湖北省恩施土家族苗族自治州",
"861557017", "江西省新余市",
"861356809", "四川省宜宾市",
"861777638", "广西玉林市",
"861875156", "江苏省无锡市",
"861813644", "江苏省苏州市",
"861832985", "陕西省榆林市",
"861392204", "广东省茂名市",
"861331803", "广东省湛江市",
"861357832", "云南省临沧市",
"861533423", "湖北省襄樊市",
"861364156", "江苏省泰州市",
"861835041", "福建省莆田市",
"86186328", "河北省衡水市",
"861366477", "内蒙古包头市",
"861528035", "福建省龙岩市",
"861335166", "黑龙江省佳木斯市",
"861317559", "浙江省嘉兴市",
"861805145", "江苏省宿迁市",
"861370086", "河南省郑州市",
"861535780", "安徽省淮北市",
"86147938", "广西柳州市",
"861452564", "贵州省贵阳市",
"861815247", "宁夏中卫市",
"861516059", "福建省宁德市",
"861867449", "湖南省长沙市",
"861380096", "青海省西宁市",
"86130310", "北京市",
"861521489", "新疆伊犁哈萨克自治州",
"861892252", "广东省东莞市",
"861761415", "辽宁省丹东市",
"861300280", "四川省凉山彝族自治州",
"86138307", "甘肃省酒泉市",
"861894856", "广东省惠州市",
"861893529", "山西省晋城市",
"86131410", "北京市",
"861378830", "广西南宁市",
"861336853", "贵州省安顺市",
"861804830", "内蒙古阿拉善盟",
"861826265", "江苏省苏州市",
"861351859", "贵州省黔西南布依族苗族自治州",
"86155268", "吉林省长春市",
"861880309", "河北省邢台市",
"86187732", "湖南省湘潭市",
"861599401", "河南省平顶山市",
"861342835", "广东省佛山市",
"861536667", "江苏省连云港市",
"861335151", "吉林省吉林市",
"861338095", "广东省江门市",
"861881322", "广东省广州市",
"86133640", "重庆市",
"861454442", "江西省九江市",
"861894861", "广东省东莞市",
"86189286", "广东省佛山市",
"861881550", "安徽省滁州市",
"86157636", "山东省潍坊市",
"861311799", "江西省萍乡市",
"861866927", "云南省昆明市",
"861882879", "四川省泸州市",
"861479720", "山西省太原市",
"861884672", "黑龙江省鸡西市",
"861334967", "湖南省郴州市",
"86145032", "辽宁省鞍山市",
"86155523", "山东省菏泽市",
"86177129", "江苏省徐州市",
"861580459", "黑龙江省大庆市",
"861316496", "浙江省宁波市",
"861308957", "黑龙江省鸡西市",
"861874957", "河南省许昌市",
"861347122", "广西柳州市",
"861559647", "陕西省咸阳市",
"861365957", "西藏日喀则地区",
"861362410", "辽宁省铁岭市",
"861327098", "江苏省苏州市",
"861309712", "江西省景德镇市",
"861538317", "河北省沧州市",
"861332613", "浙江省杭州市",
"861335997", "黑龙江省鹤岗市",
"861810287", "广东省汕尾市",
"861509817", "山东省潍坊市",
"861779748", "青海省海西蒙古族藏族自治州",
"861537161", "江苏省徐州市",
"86180691", "浙江省宁波市",
"861360728", "湖北省随州市",
"861858782", "广西河池市",
"861568821", "湖南省邵阳市",
"861323921", "陕西省延安市",
"861810411", "辽宁省大连市",
"861807163", "江苏省盐城市",
"861303971", "黑龙江省牡丹江市",
"861380878", "云南省德宏傣族景颇族自治州",
"861530740", "湖南省岳阳市",
"861588771", "云南省红河哈尼族彝族自治州",
"861341440", "广东省东莞市",
"861311532", "黑龙江省齐齐哈尔市",
"86136216", "上海市",
"861836546", "江西省上饶市",
"861526444", "山东省潍坊市",
"861889147", "陕西省宝鸡市",
"861558338", "四川省德阳市",
"861869323", "甘肃省定西市",
"861314971", "辽宁省营口市",
"861477824", "广东省深圳市",
"861561518", "山东省德州市",
"861596095", "福建省三明市",
"861509509", "山东省潍坊市",
"86131297", "广东省肇庆市",
"86130919", "浙江省温州市",
"861524136", "辽宁省锦州市",
"861700749", "湖北省武汉市",
"861333920", "安徽省滁州市",
"86182433", "吉林省延边朝鲜族自治州",
"861588909", "西藏拉萨市",
"861300407", "安徽省蚌埠市",
"861829688", "江西省赣州市",
"861520741", "湖南省株洲市",
"861452300", "河南省商丘市",
"861512607", "云南省丽江市",
"861355986", "福建省南平市",
"861303709", "山西省吕梁市",
"861328848", "广东省广州市",
"861772201", "广东省梅州市",
"86152741", "湖南省郴州市",
"861820080", "广东省肇庆市",
"861557809", "广西南宁市",
"861816034", "新疆伊犁哈萨克自治州",
"861318303", "河南省许昌市",
"861314461", "黑龙江省哈尔滨市",
"86150066", "山东省潍坊市",
"861452274", "山西省晋中市",
"86188322", "河北省保定市",
"86180163", "上海市",
"861458113", "安徽省宿州市",
"861321758", "广东省肇庆市",
"86176818", "浙江省杭州市",
"861336156", "山东省潍坊市",
"861393430", "山西省长治市",
"861322724", "湖北省十堰市",
"861888614", "贵州省贵阳市",
"861527160", "湖北省黄冈市",
"861364538", "山东省泰安市",
"861336038", "广东省揭阳市",
"86184248", "辽宁省沈阳市",
"861569204", "广东省珠海市",
"861336718", "湖北省恩施土家族苗族自治州",
"861453606", "江苏省无锡市",
"861573453", "黑龙江省牡丹江市",
"861317059", "云南省文山壮族苗族自治州",
"861370586", "浙江省台州市",
"861853180", "河北省衡水市",
"861835126", "江苏省苏州市",
"861830917", "陕西省宝鸡市",
"861551968", "贵州省六盘水市",
"86185020", "广东省广州市",
"861337845", "广东省广州市",
"861390811", "四川省绵阳市",
"861552063", "四川省宜宾市",
"861598038", "福建省宁德市",
"861505543", "安徽省淮南市",
"861526876", "浙江省丽水市",
"861572184", "云南省红河哈尼族彝族自治州",
"861564845", "内蒙古赤峰市",
"86138357", "山西省临汾市",
"861568543", "贵州省安顺市",
"861577541", "四川省凉山彝族自治州",
"861325150", "黑龙江省哈尔滨市",
"861572396", "广西柳州市",
"861850938", "甘肃省天水市",
"861315933", "福建省莆田市",
"861315491", "四川省攀枝花市",
"861853024", "河南省新乡市",
"861351113", "湖南省益阳市",
"861324777", "江西省赣州市",
"861871468", "黑龙江省鹤岗市",
"86185637", "山东省济南市",
"86134539", "山西省运城市",
"861888254", "四川省成都市",
"861304727", "湖南省益阳市",
"861894892", "广东省河源市",
"861310429", "辽宁省葫芦岛市",
"861380052", "江苏省泰州市",
"861350765", "河南省漯河市",
"861502629", "新疆伊犁哈萨克自治州",
"861357783", "云南省楚雄彝族自治州",
"861509439", "江苏省无锡市",
"861511304", "广东省佛山市",
"861321159", "广西桂林市",
"861454318", "黑龙江省鹤岗市",
"86159853", "贵州省黔西南布依族苗族自治州",
"861308162", "山东省烟台市",
"861788128", "新疆阿克苏地区",
"861315972", "吉林省通化市",
"861880360", "河南省濮阳市",
"861599700", "青海省海北藏族自治州",
"861869959", "新疆石河子市",
"861570438", "吉林省松原市",
"861555171", "安徽省芜湖市",
"86133364", "广东省佛山市",
"861348298", "河北省秦皇岛市",
"86153703", "江苏省苏州市",
"861509560", "甘肃省金昌市",
"861577605", "黑龙江省绥化市",
"861532550", "浙江省温州市",
"861390698", "福建省三明市",
"861334152", "吉林省延边朝鲜族自治州",
"861588470", "四川省南充市",
"861810030", "河北省石家庄市",
"861343877", "四川省南充市",
"861810710", "湖北省襄樊市",
"86180338", "河北省石家庄市",
"861593203", "河北省邯郸市",
"861554836", "内蒙古呼和浩特市",
"861317736", "湖北省黄冈市",
"861360380", "河南省驻马店市",
"861567152", "湖北省恩施土家族苗族自治州",
"861361498", "辽宁省阜新市",
"861317016", "安徽省池州市",
"861332424", "辽宁省本溪市",
"861361544", "山东省烟台市",
"861339634", "山东省莱芜市",
"861362711", "湖北省武汉市",
"861775103", "江苏省南京市",
"86187571", "浙江省杭州市",
"861520955", "宁夏中卫市",
"86187503", "福建省宁德市",
"861362031", "广东省佛山市",
"861348851", "内蒙古呼和浩特市",
"861331458", "黑龙江省伊春市",
"861532322", "广东省揭阳市",
"861329023", "山东省德州市",
"861476286", "江苏省连云港市",
"861329954", "宁夏固原市",
"861786912", "云南省文山壮族苗族自治州",
"861866042", "山东省济南市",
"861358148", "湖北省宜昌市",
"861834542", "黑龙江省大庆市",
"861770307", "广东省清远市",
"861829563", "宁夏吴忠市",
"861324346", "河南省周口市",
"861530635", "山东省聊城市",
"861366375", "河南省平顶山市",
"861311573", "浙江省嘉兴市",
"861471830", "广东省揭阳市",
"861890829", "四川省巴中市",
"86152455", "黑龙江省绥化市",
"861363914", "贵州省贵阳市",
"861503186", "河北省唐山市",
"861452285", "山西省长治市",
"861771163", "湖南省长沙市",
"861831665", "广东省揭阳市",
"861536744", "湖南省张家界市",
"861772877", "广东省阳江市",
"86189607", "福建省福州市",
"861521267", "安徽省淮南市",
"861314760", "吉林省白城市",
"861528405", "四川省泸州市",
"86156173", "河南省平顶山市",
"861760850", "贵州省贵阳市",
"861770715", "湖北省咸宁市",
"86152609", "福建省莆田市",
"861514186", "辽宁省铁岭市",
"86156101", "山东省济南市",
"861854307", "吉林省辽源市",
"861700148", "江苏省无锡市",
"861889795", "江西省宜春市",
"86132670", "广东省深圳市",
"861554133", "辽宁省盘锦市",
"861459652", "青海省海东地区",
"861829902", "新疆喀什地区",
"861315462", "四川省资阳市",
"861364408", "辽宁省大连市",
"861801282", "江苏省镇江市",
"861572175", "贵州省毕节地区",
"861559764", "青海省海南藏族自治州",
"861334589", "浙江省金华市",
"861871978", "甘肃省兰州市",
"861300537", "广东省韶关市",
"86159722", "湖北省武汉市",
"861779149", "陕西省铜川市",
"861580416", "辽宁省锦州市",
"861355850", "四川省甘孜藏族自治州",
"861454134", "河北省承德市",
"861332253", "西藏山南地区",
"861387247", "湖北省宜昌市",
"861879785", "江西省宜春市",
"861845482", "山东省泰安市",
"861362293", "广东省清远市",
"861373776", "广西钦州市",
"861510947", "甘肃省庆阳市",
"86180729", "浙江省杭州市",
"86159871", "云南省昆明市",
"861380552", "安徽省蚌埠市",
"861573808", "河南省南阳市",
"861471644", "广东省广州市",
"86170746", "黑龙江省哈尔滨市",
"861822647", "安徽省安庆市",
"861810701", "江西省鹰潭市",
"861813767", "河南省郑州市",
"86147793", "广东省广州市",
"861850725", "湖北省黄冈市",
"861810469", "黑龙江省双鸭山市",
"86155196", "贵州省遵义市",
"861538415", "浙江省绍兴市",
"861329841", "河南省郑州市",
"861865122", "江苏省常州市",
"861571643", "河南省洛阳市",
"861776810", "江苏省南京市",
"861509304", "河南省南阳市",
"861373183", "安徽省阜阳市",
"861529220", "湖南省株洲市",
"861343787", "广东省湛江市",
"861380320", "河北省邯郸市",
"861340489", "内蒙古赤峰市",
"861309402", "新疆哈密地区",
"861362700", "江西省南昌市",
"861320695", "黑龙江省鸡西市",
"861810530", "山东省菏泽市",
"861569934", "新疆巴音郭楞蒙古自治州",
"861872402", "江苏省南京市",
"861312468", "贵州省六盘水市",
"861894819", "广东省深圳市",
"86153753", "安徽省合肥市",
"861453939", "广东省湛江市",
"861399590", "湖北省黄冈市",
"861831847", "广东省肇庆市",
"861880504", "福建省莆田市",
"861536486", "山西省晋城市",
"86133603", "广东省佛山市",
"86156394", "河南省周口市",
"86184432", "吉林省吉林市",
"861760677", "浙江省温州市",
"86187553", "安徽省芜湖市",
"86138574", "浙江省宁波市",
"861362531", "山东省济南市",
"861590958", "宁夏银川市",
"861868797", "云南省丽江市",
"861832464", "黑龙江省佳木斯市",
"86177493", "陕西省西安市",
"861317516", "浙江省宁波市",
"861524782", "内蒙古巴彦淖尔市",
"861361044", "广东省惠州市",
"861772650", "四川省德阳市",
"861839912", "新疆喀什地区",
"861599711", "湖北省黄石市",
"861787571", "广东省广州市",
"861818886", "广东省佛山市",
"861533614", "陕西省渭南市",
"861829063", "新疆乌鲁木齐市",
"86138230", "广东省珠海市",
"861319646", "江苏省扬州市",
"86157050", "内蒙古呼伦贝尔市",
"861388463", "山东省青岛市",
"861320943", "甘肃省白银市",
"861356860", "四川省南充市",
"861334375", "河南省平顶山市",
"861337744", "广西梧州市",
"861319249", "广东省惠州市",
"861329523", "江苏省泰州市",
"861812655", "广东省肇庆市",
"861309573", "浙江省嘉兴市",
"86132709", "江苏省常州市",
"861598408", "四川省广元市",
"86189525", "江苏省扬州市",
"861390869", "湖北省荆门市",
"86152659", "山东省临沂市",
"861770535", "山东省烟台市",
"861817748", "广西贺州市",
"861383896", "河南省南阳市",
"861773734", "河南省新乡市",
"86153822", "辽宁省大连市",
"861311073", "福建省泉州市",
"86152405", "江苏省南通市",
"861803720", "河南省安阳市",
"861529694", "宁夏固原市",
"86189657", "福建省泉州市",
"86138087", "云南省昆明市",
"861567089", "河南省周口市",
"861816815", "江苏省连云港市",
"861589778", "湖北省黄石市",
"861339840", "四川省雅安市",
"861787659", "广东省茂名市",
"86155590", "福建省泉州市",
"861581985", "广东省惠州市",
"861535217", "甘肃省嘉峪关市",
"861815422", "安徽省合肥市",
"861805483", "福建省宁德市",
"861365340", "山西省太原市",
"861559331", "甘肃省平凉市",
"861300305", "安徽省合肥市",
"86152770", "广西南宁市",
"861571995", "新疆伊犁哈萨克自治州",
"861314419", "广东省肇庆市",
"861500812", "四川省自贡市",
"861535328", "陕西省延安市",
"861302875", "甘肃省酒泉市",
"861453570", "福建省漳州市",
"861882188", "湖南省岳阳市",
"861450481", "辽宁省大连市",
"861322825", "四川省南充市",
"86170797", "浙江省衢州市",
"861334089", "四川省绵阳市",
"861810979", "青海省海西蒙古族藏族自治州",
"861550642", "山东省菏泽市",
"861569828", "山东省临沂市",
"86155147", "河南省焦作市",
"861599293", "广东省东莞市",
"861778741", "云南省曲靖市",
"861303419", "甘肃省庆阳市",
"861453396", "内蒙古乌兰察布市",
"861310587", "浙江省舟山市",
"861707928", "浙江省舟山市",
"861527275", "湖北省孝感市",
"86145037", "辽宁省沈阳市",
"861552454", "辽宁省沈阳市",
"861897295", "湖北省鄂州市",
"861534949", "甘肃省陇南市",
"861884622", "黑龙江省七台河市",
"86137196", "广东省惠州市",
"861778668", "湖北省十堰市",
"861868540", "贵州省黔南布依族苗族自治州",
"861479770", "广西防城港市",
"861333539", "陕西省西安市",
"861860505", "福建省宁德市",
"86187737", "湖南省益阳市",
"861454801", "广东省深圳市",
"861473063", "河北省唐山市",
"861840567", "安徽省阜阳市",
"86145280", "四川省成都市",
"861399747", "青海省海西蒙古族藏族自治州",
"861318450", "江西省景德镇市",
"861318693", "浙江省台州市",
"861351643", "安徽省淮南市",
"861352520", "河南省三门峡市",
"8618520", "广东省广州市",
"861873450", "山西省长治市",
"861881372", "广东省中山市",
"861452690", "陕西省咸阳市",
"861452453", "黑龙江省牡丹江市",
"861538068", "江苏省连云港市",
"861301813", "四川省绵阳市",
"861811232", "江苏省常州市",
"861385216", "江苏省扬州市",
"86158972", "青海省海东地区",
"861598649", "广东省梅州市",
"861306342", "安徽省六安市",
"861380828", "四川省泸州市",
"861303921", "吉林省长春市",
"861572606", "山东省潍坊市",
"861323971", "新疆吐鲁番地区",
"86131292", "广东省中山市",
"861477874", "广东省中山市",
"86132919", "浙江省宁波市",
"861788901", "西藏拉萨市",
"861869373", "甘肃省酒泉市",
"861867982", "江西省南昌市",
"861354905", "西藏昌都地区",
"861333792", "江苏省无锡市",
"861597568", "广东省阳江市",
"861329032", "山东省济南市",
"86139278", "广东省韶关市",
"861325240", "浙江省宁波市",
"861328957", "宁夏中卫市",
"861850874", "云南省曲靖市",
"86133311", "北京市",
"861510072", "河北省廊坊市",
"861329712", "湖北省荆门市",
"861452137", "河北省沧州市",
"861529817", "四川省宜宾市",
"861568871", "山东省威海市",
"861360778", "广西河池市",
"86182691", "广西南宁市",
"861332485", "广西玉林市",
"861338637", "山东省枣庄市",
"861301758", "河南省开封市",
"861814956", "福建省福州市",
"86182163", "湖南省岳阳市",
"86135050", "福建省泉州市",
"861576860", "广东省茂名市",
"861561984", "陕西省汉中市",
"861507160", "湖北省十堰市",
"861898850", "广东省佛山市",
"861830743", "湖南省湘西土家族苗族自治州",
"861803956", "河南省洛阳市",
"86137833", "河南省驻马店市",
"861315047", "新疆乌鲁木齐市",
"861323709", "江西省宜春市",
"861539592", "福建省厦门市",
"861308848", "内蒙古巴彦淖尔市",
"861776134", "四川省内江市",
"861874848", "内蒙古呼伦贝尔市",
"861333970", "湖北省仙桃市",
"861809688", "新疆巴音郭楞蒙古自治州",
"861320407", "辽宁省大连市",
"861802331", "广东省清远市",
"861323461", "黑龙江省齐齐哈尔市",
"861500741", "湖南省湘西土家族苗族自治州",
"861569552", "安徽省蚌埠市",
"861339348", "山西省运城市",
"86188327", "河北省沧州市",
"861880699", "云南省德宏傣族景颇族自治州",
"861707834", "云南省昭通市",
"861800080", "广东省潮州市",
"861597131", "湖北省孝感市",
"861893385", "广东省揭阳市",
"86181333", "安徽省阜阳市",
"861525543", "安徽省淮南市",
"86186490", "天津市",
"861834831", "河南省商丘市",
"86138352", "山西省大同市",
"86170850", "江苏省苏州市",
"861846405", "山东省日照市",
"861379331", "山东省淄博市",
"861318945", "广东省湛江市",
"861351995", "新疆伊犁哈萨克自治州",
"861310900", "新疆昌吉回族自治州",
"861539019", "四川省眉山市",
"861895148", "江苏省盐城市",
"861889257", "贵州省黔南布依族苗族自治州",
"861700618", "江苏省苏州市",
"861596637", "山东省滨州市",
"861370642", "山东省青岛市",
"861519489", "河北省保定市",
"861850446", "吉林省白城市",
"861504833", "内蒙古乌海市",
"861587374", "湖南省益阳市",
"861769622", "山西省运城市",
"861380934", "甘肃省庆阳市",
"861319813", "四川省巴中市",
"86139287", "广东省广州市",
"861850784", "广西贺州市",
"861333719", "内蒙古包头市",
"861805040", "福建省福州市",
"861330417", "辽宁省营口市",
"861537649", "山东省滨州市",
"861868040", "广东省东莞市",
"861394871", "内蒙古呼和浩特市",
"861570765", "广东省佛山市",
"861788910", "西藏拉萨市",
"861573564", "山西省太原市",
"861568781", "云南省楚雄彝族自治州",
"861505781", "浙江省金华市",
"861707640", "山东省济南市",
"861537246", "浙江省湖州市",
"861597278", "湖北省随州市",
"861875246", "江苏省南通市",
"861860337", "河北省秦皇岛市",
"861538568", "安徽省蚌埠市",
"861381545", "江苏省淮安市",
"861364246", "广东省揭阳市",
"861835783", "浙江省温州市",
"861395136", "江苏省宿迁市",
"861325555", "山东省青岛市",
"861815433", "湖北省武汉市",
"861533502", "江苏省常州市",
"861350438", "吉林省吉林市",
"861364649", "山东省临沂市",
"861805255", "江苏省扬州市",
"861800907", "四川省绵阳市",
"861880868", "湖北省鄂州市",
"861322393", "河南省濮阳市",
"861396568", "安徽省合肥市",
"861868255", "四川省成都市",
"861898677", "湖北省宜昌市",
"861317621", "山东省菏泽市",
"861474049", "辽宁省葫芦岛市",
"861376873", "广西桂林市",
"86181296", "广东省惠州市",
"861369416", "辽宁省丹东市",
"861528697", "河南省安阳市",
"861387003", "江西省鹰潭市",
"861859629", "山东省烟台市",
"861553347", "河北省唐山市",
"861346343", "河北省廊坊市",
"861852439", "辽宁省丹东市",
"861865836", "浙江省温州市",
"861454810", "广东省广州市",
"861323456", "黑龙江省黑河市",
"861372232", "河北省张家口市",
"861329532", "山东省青岛市",
"86134298", "湖北省武汉市",
"861815157", "江苏省苏州市",
"86176127", "湖北省武汉市",
"861520583", "浙江省嘉兴市",
"861892142", "江苏省南京市",
"861510572", "浙江省湖州市",
"86170025", "江苏省南京市",
"861862910", "陕西省咸阳市",
"861563670", "黑龙江省哈尔滨市",
"86177398", "甘肃省兰州市",
"861397190", "湖北省十堰市",
"861478478", "内蒙古巴彦淖尔市",
"861359898", "河南省许昌市",
"861802764", "广东省江门市",
"861533473", "内蒙古乌海市",
"861811688", "新疆伊犁哈萨克自治州",
"861810353", "山西省阳泉市",
"861459306", "四川省绵阳市",
"861782040", "广东省肇庆市",
"861876241", "江苏省苏州市",
"86136358", "湖北省黄冈市",
"861800580", "浙江省舟山市",
"861841940", "甘肃省临夏回族自治州",
"861801344", "江苏省镇江市",
"861310911", "陕西省渭南市",
"861780976", "青海省玉树藏族自治州",
"861571816", "广东省汕头市",
"861533144", "云南省怒江傈僳族自治州",
"861319116", "山西省晋城市",
"861899413", "江苏省南京市",
"86181247", "广东省深圳市",
"861479919", "新疆克拉玛依市",
"861319758", "广西梧州市",
"86178399", "河南省郑州市",
"861760358", "山西省吕梁市",
"86184859", "贵州省黔西南布依族苗族自治州",
"86132310", "河北省邯郸市",
"861344017", "四川省阿坝藏族羌族自治州",
"861339702", "江西省抚州市",
"86170800", "北京市",
"861581924", "广东省韶关市",
"861586472", "山东省青岛市",
"861856217", "山东省烟台市",
"861374133", "河北省石家庄市",
"861593047", "河北省保定市",
"86188356", "山西省晋城市",
"861582958", "陕西省西安市",
"86135825", "河北省唐山市",
"86183690", "山东省菏泽市",
"861893579", "新疆和田地区",
"86138302", "甘肃省定西市",
"861781704", "广东省茂名市",
"861510403", "辽宁省沈阳市",
"861302603", "安徽省滁州市",
"861709510", "江苏省无锡市",
"861565035", "山东省滨州市",
"861880612", "江苏省常州市",
"861508035", "福建省莆田市",
"861327826", "吉林省白城市",
"861825145", "江苏省盐城市",
"861834467", "江苏省苏州市",
"861538131", "浙江省衢州市",
"861808172", "四川省攀枝花市",
"861560557", "安徽省宿州市",
"861309841", "湖北省宜昌市",
"861586991", "湖南省怀化市",
"861319159", "内蒙古兴安盟",
"861571859", "贵州省黔西南布依族苗族自治州",
"861517904", "江西省上饶市",
"861586433", "山东省潍坊市",
"861865172", "江苏省连云港市",
"86137268", "广东省广州市",
"861529304", "甘肃省白银市",
"861883068", "河北省石家庄市",
"861865681", "安徽省宿州市",
"861778083", "四川省内江市",
"861530597", "福建省龙岩市",
"861479956", "新疆博尔塔拉蒙古自治州",
"861375908", "云南省玉溪市",
"861338341", "山西省太原市",
"861529270", "新疆和田地区",
"861380370", "河南省商丘市",
"861572570", "山东省菏泽市",
"861505480", "山东省泰安市",
"861473688", "云南省迪庆藏族自治州",
"861332387", "河南省周口市",
"861568480", "新疆塔城地区",
"86135636", "山东省潍坊市",
"861538683", "山西省阳泉市",
"861802647", "广东省惠州市",
"86186423", "辽宁省抚顺市",
"861850775", "广西玉林市",
"86138269", "广东省东莞市",
"861763333", "河北省保定市",
"861379647", "黑龙江省鹤岗市",
"861569596", "福建省漳州市",
"861863805", "河南省周口市",
"86184437", "吉林省辽源市",
"861760627", "山东省威海市",
"861787521", "广东省梅州市",
"861880252", "广东省阳江市",
"861518329", "四川省内江市",
"861363088", "河北省张家口市",
"861396683", "安徽省阜阳市",
"861533432", "云南省楚雄彝族自治州",
"861313887", "广东省深圳市",
"861539556", "安徽省安庆市",
"861470997", "新疆乌鲁木齐市",
"861507418", "湖南省郴州市",
"861300695", "广西玉林市",
"861803992", "河南省三门峡市",
"861863414", "河北省邯郸市",
"861520668", "山东省淄博市",
"861594983", "山东省淄博市",
"86135861", "浙江省台州市",
"861857997", "广西北海市",
"86136584", "重庆市",
"861814992", "新疆伊犁哈萨克自治州",
"861300164", "山东省威海市",
"861454567", "四川省宜宾市",
"86153827", "广东省中山市",
"861576737", "广东省湛江市",
"86139606", "福建省南平市",
"861509165", "陕西省汉中市",
"861590847", "四川省南充市",
"86177631", "山东省威海市",
"861811563", "江苏省盐城市",
"86151305", "河北省唐山市",
"861306109", "山东省聊城市",
"86150659", "山东省临沂市",
"861892434", "广东省东莞市",
"861576017", "四川省巴中市",
"861846307", "山东省潍坊市",
"861539061", "甘肃省临夏回族自治州",
"86189652", "福建省漳州市",
"86150405", "辽宁省大连市",
"861562195", "内蒙古呼伦贝尔市",
"861390742", "湖南省常德市",
"861803770", "河南省南阳市",
"861376832", "广西柳州市",
"861301082", "辽宁省辽阳市",
"861334325", "河北省唐山市",
"861809063", "四川省成都市",
"861341583", "广东省茂名市",
"861846715", "青海省果洛藏族自治州",
"861572939", "河南省郑州市",
"861866686", "广东省东莞市",
"861510533", "山东省淄博市",
"861887047", "江西省南昌市",
"861831958", "广东省汕尾市",
"861309523", "云南省丽江市",
"861319582", "甘肃省定西市",
"86130709", "广东省东莞市",
"861329573", "浙江省嘉兴市",
"861353453", "广东省揭阳市",
"861353690", "广东省汕头市",
"861550586", "浙江省台州市",
"86150770", "广西南宁市",
"86177866", "湖北省黄冈市",
"861302825", "辽宁省盘锦市",
"861811902", "新疆哈密地区",
"861595346", "山东省济宁市",
"861535378", "陕西省咸阳市",
"861318766", "云南省楚雄彝族自治州",
"861372063", "陕西省西安市",
"86155142", "河南省信阳市",
"861569878", "辽宁省盘锦市",
"861323419", "辽宁省辽阳市",
"861893211", "湖南省衡阳市",
"86135380", "广东省深圳市",
"861386666", "安徽省合肥市",
"861787843", "广西南宁市",
"861890789", "广西北海市",
"861339499", "新疆伊犁哈萨克自治州",
"86153806", "江苏省淮安市",
"86139627", "江苏省南通市",
"861357541", "浙江省温州市",
"861893487", "广西玉林市",
"86139555", "安徽省马鞍山市",
"861369459", "黑龙江省大庆市",
"861386269", "江苏省常州市",
"861453352", "辽宁省大连市",
"861352396", "河南省驻马店市",
"861589205", "福建省莆田市",
"861328340", "河北省邯郸市",
"861539271", "湖北省黄冈市",
"861815472", "广西南宁市",
"861778583", "贵州省黔西南布依族苗族自治州",
"861867608", "广东省惠州市",
"86155736", "湖南省常德市",
"861709645", "山东省青岛市",
"861572070", "江苏省南通市",
"861318751", "云南省保山市",
"861510858", "贵州省六盘水市",
"861377981", "新疆阿克苏地区",
"861387433", "湖南省益阳市",
"861316904", "广东省潮州市",
"861479471", "内蒙古呼和浩特市",
"86183623", "江苏省无锡市",
"86185632", "山东省枣庄市",
"861814919", "陕西省西安市",
"861369706", "江西省吉安市",
"861770697", "福建省龙岩市",
"861324727", "湖北省襄樊市",
"861853074", "河南省新乡市",
"861511220", "广东省广州市",
"861529439", "甘肃省天水市",
"861527284", "湖北省孝感市",
"861803919", "河南省焦作市",
"861840810", "四川省成都市",
"861553445", "山西省太原市",
"861522629", "宁夏吴忠市",
"861311841", "四川省资阳市",
"861313777", "河南省南阳市",
"861570946", "甘肃省临夏回族自治州",
"861301159", "河北省石家庄市",
"861386651", "安徽省铜陵市",
"861310479", "广东省东莞市",
"861550798", "江西省景德镇市",
"861573369", "河北省张家口市",
"861853264", "河北省张家口市",
"861350008", "广东省汕尾市",
"861332474", "广西贺州市",
"861306418", "江西省九江市",
"861570864", "贵州省黔南布依族苗族自治州",
"86135535", "广东省湛江市",
"861539056", "甘肃省庆阳市",
"861330315", "河北省唐山市",
"861569096", "内蒙古赤峰市",
"861539138", "云南省普洱市",
"861500955", "宁夏中卫市",
"86134166", "广东省东莞市",
"86138481", "内蒙古呼和浩特市",
"861700891", "北京市",
"861477885", "广东省汕头市",
"861860435", "吉林省通化市",
"861330707", "江西省赣州市",
"861871834", "广东省湛江市",
"861590386", "河南省新乡市",
"86182338", "河北省承德市",
"861588420", "四川省资阳市",
"861332143", "吉林省四平市",
"861816952", "宁夏石嘴山市",
"861597683", "广东省湛江市",
"861539561", "安徽省淮北市",
"86189018", "上海市",
"861893374", "广东省河源市",
"86189602", "福建省泉州市",
"86150455", "黑龙江省绥化市",
"861323492", "黑龙江省大庆市",
"861891441", "江苏省泰州市",
"861311523", "江苏省淮安市",
"861340942", "河南省商丘市",
"861890879", "云南省普洱市",
"861762502", "江苏省无锡市",
"861893200", "贵州省贵阳市",
"861323760", "江西省景德镇市",
"861321646", "浙江省绍兴市",
"86151355", "山西省长治市",
"86150609", "福建省泉州市",
"861888144", "四川省内江市",
"861313346", "山西省晋城市",
"861510033", "河北省张家口市",
"861332964", "贵州省黔南布依族苗族自治州",
"86159706", "江西省南昌市",
"861377737", "浙江省杭州市",
"861856870", "河南省新乡市",
"861319082", "内蒙古鄂尔多斯市",
"861558644", "湖北省十堰市",
"861345890", "四川省广安市",
"86130759", "福建省福州市",
"86158183", "广东省东莞市",
"861329073", "福建省福州市",
"861309954", "宁夏固原市",
"861366325", "河北省唐山市",
"861809563", "安徽省宣城市",
"861576809", "广东省云浮市",
"861892309", "广东省广州市",
"861339412", "辽宁省鞍山市",
"86134560", "浙江省温州市",
"86170843", "吉林省长春市",
"861508814", "广东省湛江市",
"86147896", "湖南省岳阳市",
"861569788", "江西省抚州市",
"861587079", "江西省抚州市",
"861878346", "四川省广元市",
"861860641", "山东省威海市",
"861709993", "广东省珠海市",
"861372563", "广东省阳江市",
"861320537", "山东省济宁市",
"86136088", "云南省昆明市",
"861871928", "广东省深圳市",
"861556541", "河南省安阳市",
"861818726", "云南省德宏傣族景颇族自治州",
"861519577", "江苏省南京市",
"861556126", "内蒙古包头市",
"861587269", "湖北省十堰市",
"861550086", "宁夏吴忠市",
"861332846", "福建省福州市",
"861865355", "山东省临沂市",
"86182729", "河南省驻马店市",
"861310969", "陕西省榆林市",
"86130670", "福建省泉州市",
"861814880", "广东省中山市",
"86139505", "福建省宁德市",
"861347457", "陕西省延安市",
"861390308", "广东省揭阳市",
"861567242", "湖北省荆州市",
"861809902", "新疆哈密地区",
"861553631", "山西省太原市",
"861881333", "广东省广州市",
"861840989", "新疆昌吉回族自治州",
"861592459", "内蒙古通辽市",
"861821282", "贵州省毕节地区",
"861572958", "宁夏银川市",
"86131856", "浙江省台州市",
"86137302", "河北省保定市",
"861571924", "陕西省商洛市",
"861831939", "广东省肇庆市",
"861322894", "西藏林芝地区",
"861576472", "内蒙古包头市",
"861856933", "湖南省娄底市",
"861453847", "四川省巴中市",
"861557247", "湖北省荆门市",
"861761450", "黑龙江省哈尔滨市",
"861341901", "四川省德阳市",
"861530969", "安徽省合肥市",
"861503242", "河北省唐山市",
"861521840", "广东省茂名市",
"861395118", "江苏省苏州市",
"861501499", "广东省阳江市",
"861373915", "江苏省南通市",
"861339577", "浙江省温州市",
"861470430", "吉林省长春市",
"861700960", "安徽省合肥市",
"861870612", "江苏省常州市",
"861301271", "山东省淄博市",
"861350416", "辽宁省锦州市",
"861346844", "山东省烟台市",
"861599940", "新疆阿克苏地区",
"861588148", "四川省南充市",
"861801521", "江苏省南通市",
"861800590", "福建省福州市",
"861346966", "宁夏石嘴山市",
"861772040", "湖北省宜昌市",
"861327914", "陕西省渭南市",
"861857569", "广东省深圳市",
"861362628", "江苏省南通市",
"861512964", "陕西省安康市",
"86178398", "河南省新乡市",
"861369438", "吉林省松原市",
"861533346", "山西省晋城市",
"861590520", "江苏省徐州市",
"861869784", "青海省海南藏族自治州",
"861470569", "安徽省合肥市",
"861358960", "山东省枣庄市",
"861808818", "云南省德宏傣族景颇族自治州",
"861819021", "四川省甘孜藏族自治州",
"861532640", "吉林省长春市",
"861459104", "广西防城港市",
"86177399", "甘肃省兰州市",
"861397180", "湖北省咸宁市",
"861360576", "浙江省台州市",
"861590352", "山西省大同市",
"861531523", "山东省淄博市",
"861568213", "四川省成都市",
"861562443", "山东省德州市",
"861556529", "河南省许昌市",
"861858648", "贵州省六盘水市",
"861390454", "黑龙江省佳木斯市",
"861597766", "广西南宁市",
"861839318", "甘肃省天水市",
"861770976", "青海省玉树藏族自治州",
"861355714", "广西梧州市",
"86136359", "江西省萍乡市",
"861319561", "安徽省淮北市",
"861358470", "江苏省南通市",
"86147960", "广西桂林市",
"861311829", "四川省南充市",
"86152464", "黑龙江省佳木斯市",
"861890573", "浙江省嘉兴市",
"861368001", "广东省清远市",
"861510707", "江西省赣州市",
"861806312", "山东省威海市",
"861513409", "辽宁省辽阳市",
"861870868", "贵州省六盘水市",
"86153975", "浙江省金华市",
"861310802", "陕西省延安市",
"861335105", "黑龙江省双鸭山市",
"861301556", "河南省洛阳市",
"861476504", "北京市",
"86150276", "河北省唐山市",
"861770466", "福建省泉州市",
"861812045", "湖北省襄樊市",
"86150134", "广东省深圳市",
"861829742", "安徽省安庆市",
"861319138", "内蒙古巴彦淖尔市",
"861571838", "广东省广州市",
"861510315", "河北省唐山市",
"861398904", "西藏林芝地区",
"861384836", "内蒙古赤峰市",
"861319056", "内蒙古通辽市",
"861594730", "内蒙古呼伦贝尔市",
"861528687", "河南省驻马店市",
"861809869", "安徽省淮南市",
"861576503", "黑龙江省牡丹江市",
"861530479", "内蒙古锡林郭勒盟",
"861580765", "广东省清远市",
"861813359", "河北省张家口市",
"861533777", "安徽省黄山市",
"861583564", "山西省大同市",
"861531841", "山东省济宁市",
"861810854", "贵州省黔南布依族苗族自治州",
"861374662", "黑龙江省绥化市",
"86188192", "广东省广州市",
"861555149", "安徽省宿州市",
"861329789", "广西柳州市",
"861803608", "江苏省苏州市",
"861804359", "吉林省长春市",
"861305510", "湖南省益阳市",
"86134781", "辽宁省沈阳市",
"861333872", "江苏省苏州市",
"861808753", "云南省昆明市",
"861344157", "山东省日照市",
"861351330", "河北省邯郸市",
"861850794", "江西省抚州市",
"861561248", "河北省承德市",
"861812250", "广东省云浮市",
"861895721", "浙江省舟山市",
"861583311", "河北省石家庄市",
"86159250", "云南省保山市",
"861821256", "贵州省毕节地区",
"861334604", "浙江省绍兴市",
"861330858", "贵州省六盘水市",
"861392199", "江苏省苏州市",
"861885246", "江苏省无锡市",
"861360898", "山东省青岛市",
"86136900", "广东省潮州市",
"861568791", "云南省西双版纳傣族自治州",
"861801843", "江苏省南通市",
"861459542", "青海省海东地区",
"861478601", "贵州省铜仁地区",
"861576962", "宁夏石嘴山市",
"861473800", "河南省南阳市",
"861319271", "广东省河源市",
"861869874", "辽宁省大连市",
"86181852", "贵州省遵义市",
"861360669", "浙江省丽水市",
"861356247", "山东省枣庄市",
"86176392", "河南省鹤壁市",
"861571553", "安徽省芜湖市",
"86187306", "河北省廊坊市",
"86131806", "吉林省通化市",
"86156370", "河南省商丘市",
"861893832", "广东省肇庆市",
"861519499", "河北省保定市",
"861359778", "湖北省恩施土家族苗族自治州",
"86137352", "浙江省绍兴市",
"86185245", "辽宁省锦州市",
"86147369", "四川省成都市",
"86138590", "福建省福州市",
"861339077", "江苏省南京市",
"861380642", "山东省青岛市",
"861857279", "湖北省武汉市",
"861471554", "广东省佛山市",
"861538766", "四川省甘孜藏族自治州",
"861822557", "安徽省宿州市",
"861523089", "河北省承德市",
"861889724", "青海省西宁市",
"861850373", "河南省新乡市",
"861760534", "山东省德州市",
"861372698", "广东省清远市",
"861377472", "福建省三明市",
"861770451", "黑龙江省哈尔滨市",
"861539582", "浙江省杭州市",
"861330533", "山东省淄博市",
"861880689", "浙江省金华市",
"861800090", "广东省茂名市",
"861554301", "吉林省长春市",
"86180644", "福建省厦门市",
"86187327", "河北省沧州市",
"861452757", "湖南省益阳市",
"861870699", "甘肃省白银市",
"861301314", "安徽省宣城市",
"861810941", "甘肃省甘南藏族自治州",
"861341910", "四川省南充市",
"861319061", "内蒙古阿拉善盟",
"86136309", "吉林省四平市",
"861501412", "广东省深圳市",
"861819521", "宁夏银川市",
"861532928", "贵州省六盘水市",
"86131827", "江苏省无锡市",
"861811869", "江苏省盐城市",
"86139279", "广东省汕尾市",
"861362455", "黑龙江省绥化市",
"861520093", "湖南省长沙市",
"861301056", "广东省湛江市",
"861476004", "福建省厦门市",
"861778901", "西藏山南地区",
"861521634", "山东省莱芜市",
"861767903", "江西省上饶市",
"861305501", "湖南省郴州市",
"86152794", "江西省抚州市",
"861346951", "宁夏银川市",
"861869446", "陕西省延安市",
"861370828", "四川省泸州市",
"86151934", "甘肃省张掖市",
"861368501", "福建省福州市",
"861332495", "云南省大理白族自治州",
"861319556", "安徽省安庆市",
"861313432", "吉林省吉林市",
"861334723", "湖南省株洲市",
"861338329", "河北省石家庄市",
"861348704", "湖北省黄冈市",
"861358239", "河北省保定市",
"861576003", "四川省成都市",
"86134117", "广东省云浮市",
"861820664", "广东省茂名市",
"861329879", "黑龙江省牡丹江市",
"861776754", "新疆喀什地区",
"86132918", "浙江省杭州市",
"861506588", "山东省淄博市",
"86155574", "浙江省宁波市",
"861878432", "四川省内江市",
"861304432", "吉林省吉林市",
"861333782", "江苏省南京市",
"861532834", "四川省泸州市",
"861328672", "广东省河源市",
"86138196", "浙江省台州市",
"861318683", "浙江省温州市",
"861308622", "青海省海西蒙古族藏族自治州",
"861872829", "四川省资阳市",
"861550552", "安徽省蚌埠市",
"861452680", "陕西省咸阳市",
"861831260", "广东省茂名市",
"861829308", "甘肃省庆阳市",
"861376793", "江西省景德镇市",
"861817908", "江西省赣州市",
"861377962", "新疆喀什地区",
"861453386", "内蒙古通辽市",
"861551391", "山西省朔州市",
"861310597", "福建省宁德市",
"861700636", "山东省烟台市",
"861530230", "广东省佛山市",
"861787549", "广东省汕尾市",
"86188737", "湖南省益阳市",
"861453194", "山西省晋中市",
"861322147", "浙江省温州市",
"861890263", "广东省河源市",
"86159200", "广东省深圳市",
"861897285", "湖北省咸宁市",
"861539159", "湖北省襄樊市",
"861320703", "江西省上饶市",
"86181723", "广西南宁市",
"861318131", "山东省济宁市",
"86180360", "江苏省无锡市",
"861319519", "贵州省黔西南布依族苗族自治州",
"861565926", "福建省厦门市",
"861591272", "云南省文山壮族苗族自治州",
"861470511", "江苏省盐城市",
"861898996", "西藏那曲地区",
"861840999", "新疆伊犁哈萨克自治州",
"86181460", "福建省泉州市",
"861803890", "广东省韶关市",
"861857511", "广东省茂名市",
"861355815", "广西玉林市",
"861301019", "北京市",
"861319807", "四川省绵阳市",
"861707372", "河南省安阳市",
"86155307", "河北省沧州市",
"861301739", "湖南省长沙市",
"861305645", "四川省甘孜藏族自治州",
"86182728", "河南省周口市",
"861522005", "广东省深圳市",
"861592508", "云南省昭通市",
"861835269", "江苏省南通市",
"861306436", "四川省资阳市",
"861319092", "内蒙古赤峰市",
"861342998", "湖北省武汉市",
"861322795", "陕西省咸阳市",
"861478045", "四川省绵阳市",
"861350706", "江西省九江市",
"861470000", "福建省福州市",
"86130758