package Venus::False;

use 5.018;

use strict;
use warnings;

use Scalar::Util ();

state $false = Scalar::Util::dualvar(0, "0");

use overload (
  '!' => sub{!$false},
  'bool' => sub{$false},
  fallback => 1,
);

# METHODS

sub new {
  return bless({});
}

sub value {
  return $false;
}

1;



=head1 NAME

Venus::False - False Class

=cut

=head1 ABSTRACT

False Class for Perl 5

=cut

=head1 SYNOPSIS

  package main;

  use Venus::False;

  my $false = Venus::False->new;

  # $false->value;

=cut

=head1 DESCRIPTION

This package provides the global C<false> value used in L<Venus::Boolean> and
the L<Venus/false> function.

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 value

  value() (boolean)

The value method returns value representing the global C<false> value.

I<Since C<1.23>>

=over 4

=item value example 1

  # given: synopsis;

  my $value = $false->value;

  # 0

=back

=cut

=head1 AUTHORS

Awncorp, C<awncorp@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2000, Awncorp, C<awncorp@cpan.org>.

This program is free software, you can redistribute it and/or modify it under
the terms of the Apache license version 2.0.

=cut