package Lingua::RU::Antimat;
use strict;
use 5.004;
use FileHandle;

$Lingua::RU::Antimat::VERSION = '0.20';

use locale;

sub new
{
	my $that = shift;
	my $class = ref($that)||$that;
	my $self= {};
	
	my $codepage=shift;
	if (defined($codepage)&&($codepage eq 'koi8'))
	{ 
		$self->{'word'}='a[\W_]*s[\W_]*s(?:[\W_]*e[\W_]*s)?|f[\W_]*u[\W_]*c[\W_]*k(?:[\W_]*i[\W_]*n[\W_]*g)?|[\W_]*(?:[iu][\W_]*[d](?:[\W_]*[yiau]|[\W_]*[o][\W_]*[bv])?|[o][\W_]*[np][\W_]*(?:[a](?:[\W_]*[xh])?|[eyiu]|[o][\W_]*[j]))|[d][\W_]*[e][\W_]*[pr][\W_]*(?:[b][\W_]*)?[m][\W_]*[eoyau](?:[\W_]*[m])?|[c][\W_]*[m][\W_]*(?:[o]|[i][\W_]*[pr][\W_]*[eibu])|[sc][\W_]*[uy][\W_]*(?:(?:[c][\W_]*)?[k][\W_]*[iyau](?:[\W_]*[hn](?:[\W_]*[o][\W_]*[j]|[\W_]*[yiau])?)?|[c][\W_]*(?:(?:[b][\W_]*)?(?:[ţeiu]|[eiu][\W_]*[j])|[a][\W_]*[pr][\W_]*[eyiau]))|[rg][\W_]*(?:[oa][\W_]*(?:[hn][\W_]*[d][\W_]*[oa][\W_]*[hn](?:[\W_]*[yiu])?|[bv][\W_]*[hn][\W_]*[oa](?:[\W_]*(?:[m]|[e][\W_]*[d](?:[\W_]*[eyiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?)?))?)|[hn][\W_]*(?:[iu][\W_]*[d][\W_]*(?:[eyiau]|[o][\W_]*[j])|[yu][sc](?:[\W_]*[yiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?)?))|(?:[hn][\W_]*[e][\W_]*)?(?:(?:[3z][\W_]*[a]|[o][t]|[np][\W_]*[o]|[np][\W_]*(?:[e][\W_]*[pr][\W_]*[e]|[pr][\W_]*[eiou]|[iu][\W_]*[3z][\W_]*[d][\W_]*[o])|[hn][\W_]*[a]|[iu][\W_]*[3z]|[d][\W_]*[o]|[bv][\W_]*[i]|[yu]|[pr][\W_]*[a][\W_]*[3z]|[3z][\W_]*[l][\W_]*[o]|[t][\W_]*[pr][\W_]*[o]|[yu])[\W_]*)?(?:[bv][\W_]*[i][\W_]*)?(?:[b][\W_]*)?(?:[ţe][\W_]*[b](?:(?:[\W_]*[ţeioyau])?(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:[\W_]*[bv][\W_]*[a])?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:(?:[b][\W_]*)?[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))?)|[\W_]*[i](?:(?:[\W_]*[bv][\W_]*[a]|[\W_]*[hn](?:[\W_]*[hn])?)(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[l][\W_]*(?:(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|(?:[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?))))|[pr][\W_]*[b]))|[\W_]*[b](?:[\W_]*[ţeioyau])?(?:(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))|(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?))))|[e][\W_]*(?:[b][\W_]*(?:[yu][\W_]*[k][\W_]*[e][\W_]*[hn][\W_]*[t][\W_]*[iu][\W_]*[j]|[e][\W_]*[hn][\W_]*(?:[b]|(?:[\W_]*[m])?)|[iu][\W_]*(?:[c][\W_]*[k][\W_]*[a][\W_]*|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[a][\W_]*)|[l][\W_]*[iu][\W_]*[\W_]*[e]|[a][\W_]*(?:[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iau])?|[t][\W_]*[o][\W_]*[pr][\W_]*[iu][\W_]*[j]|[hn][\W_]*(?:[t][\W_]*[pr][\W_]*[o][\W_]*[np]|[a][\W_]*[t][\W_]*[iu][\W_]*(?:[k]|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*[j]))))|[d][\W_]*[pr][\W_]*[iu][\W_]*[t])|[hn][\W_]*[e][\W_]*[bv][\W_]*[pr][\W_]*[o][\W_]*[t][\W_]*[\W_]*[e][\W_]*[b][\W_]*[a][\W_]*[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[yu][\W_]*(?:[e][\W_]*[b][\W_]*(?:[iu][\W_]*[\W_]*[ea]|[a][\W_]*[hn](?:[\W_]*[t][\W_]*[yu][\W_]*[sc])?(?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eyiau])?)|[pr][\W_]*[o][\W_]*[d](?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eyiau])?|[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o][\W_]*[k]|[k][\W_]*(?:[oa][\W_]*[bmv](?:[\W_]*[iu])?|[eiyau])?))|[m][\W_]*(?:[yu][\W_]*[d][\W_]*(?:[o][\W_]*[xh][\W_]*[a][\W_]*(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[\W_]*[sc][\W_]*[b]|[e][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[k](?:[\W_]*[iau]|[o][bmv])?|[c][\W_]*(?:[b][\W_]*[ţe]|[iu][\W_]*[hn][\W_]*[yiau]|[k][\W_]*(?:[eiyau]|[o][\W_]*[j])))|[e][\W_]*[hn][\W_]*[b]|[iu][\W_]*[l](?:[\W_]*[eoia]?))|[a][\W_]*[hn][\W_]*[d][\W_]*[yau]|[l][\W_]*(?:[iu][\W_]*[hn]|))|(?:[m][\W_]*(?:[o][\W_]*[3z][\W_]*[rg]|[yu][\W_]*[d])|[d][\W_]*(?:[o][\W_]*[l][\W_]*[b]|[yu][\W_]*[pr])|[sc][\W_]*[k][\W_]*[o][\W_]*[t]|[\W_]*[iu][\W_]*[d])[\W_]*[oa][\W_]*[e][\W_]*[b](?:[\W_]*[eo][\W_]*[bv]|[\W_]*[ia])?|(?:[hn][\W_]*[e][\W_]*|[3z][\W_]*[a][\W_]*|[o][\W_]*[t][\W_]*|[np][\W_]*[o][\W_]*|[hn][\W_]*[a][\W_]*|[pr][\W_]*[a][\W_]*[3szc][\W_]*)?(?:[np][\W_]*[iu][\W_]*[3z][\W_]*[d][\W_]*[eiu]|(?:)?[ţe][\W_]*[b][\W_]*[a])[\W_]*(?:(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*[b]|[l][\W_]*[iu]|[a][\W_]*[l]|[l]|c[\W_]*[b]|[iu][\W_]*[t]|[iu]|[t][\W_]*[e]|[c][\W_]*[yu]|[\W_]*[b])|(?:[iju]|[eiu][\W_]*[m](?:[\W_]*[iu])?|[j][\W_]*[sc][\W_]*(?:[k][\W_]*(?:[iu][\W_]*[ej]|[a][\W_]*|[o][\W_]*[e]|[i][\W_]*[xh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[t][\W_]*[bv][\W_]*[oyau](?:[\W_]*[m])?)))|[np][\W_]*[eiu][\W_]*[d][\W_]*[eoa][\W_]*[pr](?:(?:[\W_]*[a][\W_]*[3szc](?:(?:[\W_]*[t])?(?:[\W_]*[i]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[k][\W_]*[iau])?|(?:[\W_]*[eyiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[o][\W_]*[bv])))|[\W_]*(?:[eyiau]|[oa][\W_]*[m](?:[\W_]*[iu])?|[o][\W_]*[bv]|[hn][\W_]*))?|[np][\W_]*[iu][\W_]*[3z][\W_]*(?:[b][\W_]*)?[d][\W_]*(?:[e][\W_]*(?:[hn][\W_]*[i][\W_]*(?:[\W_]*[b])?|[hn](?:[\W_]*[b])?)|[yu][\W_]*(?:[j](?:[\W_]*[t][\W_]*[e])?|[hn](?:[\W_]*[i])?)|[\W_]*(?:[k](?:[\W_]*(?:[eiyau]|[o][\W_]*[bv]|[a][\W_]*[m](?:[\W_]*[iu])?))?|[l](?:[ibu]|[e][\W_]*[j]|[\W_]*[mxh]))|[e][\W_]*[c]|[oa][\W_]*(?:[hn][\W_]*[yu][\W_]*)?[t][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o](?:[\W_]*[ej])?|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu]|[e][\W_]*[e]|[eyibau])|[a][\W_]*[hn][\W_]*[yu][\W_]*[l](?:[\W_]*[iau])?|[eiyau]|[oa][\W_]*(?:[j]|[xh][\W_]*[yu][\W_]*[j]|[ţe][\W_]*[b]|(?:[pr][\W_]*[o][\W_]*[t]|[rg][\W_]*[o][\W_]*[l][\W_]*[o][\W_]*[bv])[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[b][\W_]*(?:[pr][\W_]*[a][\W_]*[t][\W_]*[iu][\W_]*|[o][\W_]*[l](?:[\W_]*[yiau])?)))|[np][\W_]*(?:[a][\W_]*[d][\W_]*[l][\W_]*[oia]|[oa][\W_]*[sc][\W_]*[k][\W_]*[yu][\W_]*[d][\W_]*(?:[eyiau]|[oa][\W_]*[m](?:[\W_]*[iu])?)|[eiu][\W_]*[d][\W_]*(?:[iu][\W_]*[k]|[pr][\W_]*[iu][\W_]*[l](?:[\W_]*[l])?)(?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eioyau])?|[pr][\W_]*[o][\W_]*[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*[o][\W_]*[m])|(?:[3z][\W_]*[a][\W_]*|[o][\W_]*[t][\W_]*|[hn][\W_]*[a][\W_]*)?[sc][\W_]*[pr][\W_]*(?:[a][\W_]*[t][\W_]*[b]|[a][\W_]*[l](?:[\W_]*[iu])?|[eiyu])|[sc][\W_]*[pr][\W_]*[a][\W_]*(?:[k][\W_]*(?:[eiyau]|[o][\W_]*[j])|[hn][\W_]*(?:[hn][\W_]*)?(?:[b]|(?:[i][\W_]*[ej]|[a][\W_]*|[o][\W_]*[e])))|(?:[3z][\W_]*[a][\W_]*)?[t][\W_]*[pr][\W_]*[a][\W_]*[xh][\W_]*(?:[hn][\W_]*(?:[yu](?:[\W_]*[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[\W_]*[sc][\W_]*[b]|[\W_]*[l](?:[\W_]*[iau])?)?|[eiu][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[l](?:[\W_]*[ioau])?|[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[hn][\W_]*(?:[hn][\W_]*)?(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])))|(?:[hn][\W_]*[eiu][\W_]*|[np][\W_]*[o][\W_]*|[hn][\W_]*[a][\W_]*|[oa][\W_]*(?:[t][\W_]*)?|[d][\W_]*[oa][\W_]*|[3z][\W_]*[a][\W_]*)?(?:(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu](?:[\W_]*[j])?))(?:[\W_]*[ϣeo][\W_]*[bv](?:[\W_]*[a][\W_]*[\W_]*|[\W_]*)?)?(?:[\W_]*[eiau][\W_]*[lhn])?(?:[hn])?(?:[\W_]*(?:[ϣeioau][beijmvu]|[\W_]*(?:[m](?:[\W_]*[iu])?|[pr][\W_]*(?:|[iu][\W_]*[l](?:[\W_]*[ioau])?)|[c][\W_]*(?:[a][\W_]*[t]|[iu][\W_]*[l](?:[\W_]*[ioau])?)|[c](?:[\W_]*[b])?)|[e][\W_]*(?:[t][\W_]*(?:[o][\W_]*[j]|[ybau])|[e][\W_]*(?:[t][\W_]*[e]|[\W_]*[b]))|[ijoyau]|[l][\W_]*[iou]|[c][\W_]*[yu])))|(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[j]))|[xh][\W_]*[yu][\W_]*(?:[eiu][\W_]*(?:[sc][\W_]*[o][\W_]*[sc]|[np][\W_]*[l][\W_]*[e][\W_]*[t])(?:[\W_]*[yiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[hn][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu]))?|[d][\W_]*[o][\W_]*[\W_]*[b][\W_]*[iu][\W_]*[hn][\W_]*(?:[o][\W_]*[j]|[eyiau]))|[b][\W_]*[l][\W_]*(?:[\W_]*[dt][\W_]*(?:[b]|[iu]|[k][\W_]*[iu]|[sc][\W_]*[t][\W_]*[bv][\W_]*[o]|[sc][\W_]*[k][\W_]*(?:[o][\W_]*[ej]|[iu][\W_]*[e]|[a][\W_]*|[iu][\W_]*[j]|[o][\W_]*[rg][\W_]*[o])))?|[bv][\W_]*[i][\W_]*[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o][\W_]*[k]|[k][\W_]*(?:[eiyau]|[a][\W_]*[m](?:[\W_]*[iu])?))|(?:[3z][\W_]*[oa][\W_]*)(?:[np][\W_]*[oa][\W_]*[d][\W_]*[l][\W_]*[oia]|[l][\W_]*[yu][\W_]*[np][\W_]*(?:[o][\W_]*[j]|[eyiau]))|[\W_]*[l][\W_]*[\W_]*[xh][\W_]*(?:[eiyau]|[o][\W_]*[j])|[a][\W_]*[hn][\W_]*[yu][\W_]*[sc](?:[\W_]*[eyiau]|[\W_]*[o][\W_]*[m])?|(?:\w*(?:[xh](?:[pr][e][hn]|[yu][eiu])|[np][eiu](?:[3z][d]|[d](?:[eoa][pr]|[pr]))|[b][l][d]|[o][xh][yu][e]|[m][yu][d][eioau]|[d][e][pr][b]|[rg][oa][bv][hn]|[yu][e][b])|[xh][\W_]*(?:[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[eiju])|[np][\W_]*[eiu][\W_]*(?:[3z][\W_]*[d]|[d][\W_]*(?:[eoa][\W_]*[pr]|[pr]))|[b][\W_]*[l][\W_]*[\W_]*[d]|[o][\W_]*[xh][\W_]*[yu][\W_]*[e]|[m][\W_]*[yu][\W_]*[d][\W_]*[eioau]|[d][\W_]*[e][\W_]*[pr][\W_]*[b]|[rg][\W_]*[oa][\W_]*[bv][\W_]*[hn]|[yu][\W_]*[e][\W_]*[b]|[e][b])\w+';
		$self->{'bip'}='';
	}	
	
	
	else 
	{
		$self->{'word'}='a[\W_]*s[\W_]*s(?:[\W_]*e[\W_]*s)?|f[\W_]*u[\W_]*c[\W_]*k(?:[\W_]*i[\W_]*n[\W_]*g)?|[\W_]*(?:[iu][\W_]*[d](?:[\W_]*[yiau]|[\W_]*[o][\W_]*[bv])?|[o][\W_]*[np][\W_]*(?:[a](?:[\W_]*[xh])?|[eyiu]|[o][\W_]*[j]))|[d][\W_]*[e][\W_]*[pr][\W_]*(?:[b][\W_]*)?[m][\W_]*[eoyau](?:[\W_]*[m])?|[c][\W_]*[m][\W_]*(?:[o]|[i][\W_]*[pr][\W_]*[eibu])|[sc][\W_]*[uy][\W_]*(?:(?:[c][\W_]*)?[k][\W_]*[iyau](?:[\W_]*[hn](?:[\W_]*[o][\W_]*[j]|[\W_]*[yiau])?)?|[c][\W_]*(?:(?:[b][\W_]*)?(?:[eiu]|[eiu][\W_]*[j])|[a][\W_]*[pr][\W_]*[eyiau]))|[rg][\W_]*(?:[oa][\W_]*(?:[hn][\W_]*[d][\W_]*[oa][\W_]*[hn](?:[\W_]*[yiu])?|[bv][\W_]*[hn][\W_]*[oa](?:[\W_]*(?:[m]|[e][\W_]*[d](?:[\W_]*[eyiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?)?))?)|[hn][\W_]*(?:[iu][\W_]*[d][\W_]*(?:[eyiau]|[o][\W_]*[j])|[yu][sc](?:[\W_]*[yiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?)?))|(?:[hn][\W_]*[e][\W_]*)?(?:(?:[3z][\W_]*[a]|[o][t]|[np][\W_]*[o]|[np][\W_]*(?:[e][\W_]*[pr][\W_]*[e]|[pr][\W_]*[eiou]|[iu][\W_]*[3z][\W_]*[d][\W_]*[o])|[hn][\W_]*[a]|[iu][\W_]*[3z]|[d][\W_]*[o]|[bv][\W_]*[i]|[yu]|[pr][\W_]*[a][\W_]*[3z]|[3z][\W_]*[l][\W_]*[o]|[t][\W_]*[pr][\W_]*[o]|[yu])[\W_]*)?(?:[bv][\W_]*[i][\W_]*)?(?:[b][\W_]*)?(?:[e][\W_]*[b](?:(?:[\W_]*[eioyau])?(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:[\W_]*[bv][\W_]*[a])?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:(?:[b][\W_]*)?[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))?)|[\W_]*[i](?:(?:[\W_]*[bv][\W_]*[a]|[\W_]*[hn](?:[\W_]*[hn])?)(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[l][\W_]*(?:(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|(?:[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?))))|[pr][\W_]*[b]))|[\W_]*[b](?:[\W_]*[eioyau])?(?:(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))|(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?))))|[e][\W_]*(?:[b][\W_]*(?:[yu][\W_]*[k][\W_]*[e][\W_]*[hn][\W_]*[t][\W_]*[iu][\W_]*[j]|[e][\W_]*[hn][\W_]*(?:[b]|(?:[\W_]*[m])?)|[iu][\W_]*(?:[c][\W_]*[k][\W_]*[a][\W_]*|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[a][\W_]*)|[l][\W_]*[iu][\W_]*[\W_]*[e]|[a][\W_]*(?:[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iau])?|[t][\W_]*[o][\W_]*[pr][\W_]*[iu][\W_]*[j]|[hn][\W_]*(?:[t][\W_]*[pr][\W_]*[o][\W_]*[np]|[a][\W_]*[t][\W_]*[iu][\W_]*(?:[k]|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*[j]))))|[d][\W_]*[pr][\W_]*[iu][\W_]*[t])|[hn][\W_]*[e][\W_]*[bv][\W_]*[pr][\W_]*[o][\W_]*[t][\W_]*[\W_]*[e][\W_]*[b][\W_]*[a][\W_]*[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[yu][\W_]*(?:[e][\W_]*[b][\W_]*(?:[iu][\W_]*[\W_]*[ea]|[a][\W_]*[hn](?:[\W_]*[t][\W_]*[yu][\W_]*[sc])?(?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eyiau])?)|[pr][\W_]*[o][\W_]*[d](?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eyiau])?|[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o][\W_]*[k]|[k][\W_]*(?:[oa][\W_]*[bmv](?:[\W_]*[iu])?|[eiyau])?))|[m][\W_]*(?:[yu][\W_]*[d][\W_]*(?:[o][\W_]*[xh][\W_]*[a][\W_]*(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[\W_]*[sc][\W_]*[b]|[e][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[k](?:[\W_]*[iau]|[o][bmv])?|[c][\W_]*(?:[b][\W_]*[e]|[iu][\W_]*[hn][\W_]*[yiau]|[k][\W_]*(?:[eiyau]|[o][\W_]*[j])))|[e][\W_]*[hn][\W_]*[b]|[iu][\W_]*[l](?:[\W_]*[eoia]?))|[a][\W_]*[hn][\W_]*[d][\W_]*[yau]|[l][\W_]*(?:[iu][\W_]*[hn]|))|(?:[m][\W_]*(?:[o][\W_]*[3z][\W_]*[rg]|[yu][\W_]*[d])|[d][\W_]*(?:[o][\W_]*[l][\W_]*[b]|[yu][\W_]*[pr])|[sc][\W_]*[k][\W_]*[o][\W_]*[t]|[\W_]*[iu][\W_]*[d])[\W_]*[oa][\W_]*[e][\W_]*[b](?:[\W_]*[eo][\W_]*[bv]|[\W_]*[ia])?|(?:[hn][\W_]*[e][\W_]*|[3z][\W_]*[a][\W_]*|[o][\W_]*[t][\W_]*|[np][\W_]*[o][\W_]*|[hn][\W_]*[a][\W_]*|[pr][\W_]*[a][\W_]*[3szc][\W_]*)?(?:[np][\W_]*[iu][\W_]*[3z][\W_]*[d][\W_]*[eiu]|(?:)?[e][\W_]*[b][\W_]*[a])[\W_]*(?:(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*[b]|[l][\W_]*[iu]|[a][\W_]*[l]|[l]|c[\W_]*[b]|[iu][\W_]*[t]|[iu]|[t][\W_]*[e]|[c][\W_]*[yu]|[\W_]*[b])|(?:[iju]|[eiu][\W_]*[m](?:[\W_]*[iu])?|[j][\W_]*[sc][\W_]*(?:[k][\W_]*(?:[iu][\W_]*[ej]|[a][\W_]*|[o][\W_]*[e]|[i][\W_]*[xh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[t][\W_]*[bv][\W_]*[oyau](?:[\W_]*[m])?)))|[np][\W_]*[eiu][\W_]*[d][\W_]*[eoa][\W_]*[pr](?:(?:[\W_]*[a][\W_]*[3szc](?:(?:[\W_]*[t])?(?:[\W_]*[i]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[k][\W_]*[iau])?|(?:[\W_]*[eyiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[o][\W_]*[bv])))|[\W_]*(?:[eyiau]|[oa][\W_]*[m](?:[\W_]*[iu])?|[o][\W_]*[bv]|[hn][\W_]*))?|[np][\W_]*[iu][\W_]*[3z][\W_]*(?:[b][\W_]*)?[d][\W_]*(?:[e][\W_]*(?:[hn][\W_]*[i][\W_]*(?:[\W_]*[b])?|[hn](?:[\W_]*[b])?)|[yu][\W_]*(?:[j](?:[\W_]*[t][\W_]*[e])?|[hn](?:[\W_]*[i])?)|[\W_]*(?:[k](?:[\W_]*(?:[eiyau]|[o][\W_]*[bv]|[a][\W_]*[m](?:[\W_]*[iu])?))?|[l](?:[ibu]|[e][\W_]*[j]|[\W_]*[mxh]))|[e][\W_]*[c]|[oa][\W_]*(?:[hn][\W_]*[yu][\W_]*)?[t][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o](?:[\W_]*[ej])?|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu]|[e][\W_]*[e]|[eyibau])|[a][\W_]*[hn][\W_]*[yu][\W_]*[l](?:[\W_]*[iau])?|[eiyau]|[oa][\W_]*(?:[j]|[xh][\W_]*[yu][\W_]*[j]|[e][\W_]*[b]|(?:[pr][\W_]*[o][\W_]*[t]|[rg][\W_]*[o][\W_]*[l][\W_]*[o][\W_]*[bv])[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])|[b][\W_]*(?:[pr][\W_]*[a][\W_]*[t][\W_]*[iu][\W_]*|[o][\W_]*[l](?:[\W_]*[yiau])?)))|[np][\W_]*(?:[a][\W_]*[d][\W_]*[l][\W_]*[oia]|[oa][\W_]*[sc][\W_]*[k][\W_]*[yu][\W_]*[d][\W_]*(?:[eyiau]|[oa][\W_]*[m](?:[\W_]*[iu])?)|[eiu][\W_]*[d][\W_]*(?:[iu][\W_]*[k]|[pr][\W_]*[iu][\W_]*[l](?:[\W_]*[l])?)(?:[\W_]*[oa][\W_]*[bmv]|[\W_]*[eioyau])?|[pr][\W_]*[o][\W_]*[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*[o][\W_]*[m])|(?:[3z][\W_]*[a][\W_]*|[o][\W_]*[t][\W_]*|[hn][\W_]*[a][\W_]*)?[sc][\W_]*[pr][\W_]*(?:[a][\W_]*[t][\W_]*[b]|[a][\W_]*[l](?:[\W_]*[iu])?|[eiyu])|[sc][\W_]*[pr][\W_]*[a][\W_]*(?:[k][\W_]*(?:[eiyau]|[o][\W_]*[j])|[hn][\W_]*(?:[hn][\W_]*)?(?:[b]|(?:[i][\W_]*[ej]|[a][\W_]*|[o][\W_]*[e])))|(?:[3z][\W_]*[a][\W_]*)?[t][\W_]*[pr][\W_]*[a][\W_]*[xh][\W_]*(?:[hn][\W_]*(?:[yu](?:[\W_]*[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[\W_]*[sc][\W_]*[b]|[\W_]*[l](?:[\W_]*[iau])?)?|[eiu][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[l](?:[\W_]*[ioau])?|[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[hn][\W_]*(?:[hn][\W_]*)?(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu])))|(?:[hn][\W_]*[eiu][\W_]*|[np][\W_]*[o][\W_]*|[hn][\W_]*[a][\W_]*|[oa][\W_]*(?:[t][\W_]*)?|[d][\W_]*[oa][\W_]*|[3z][\W_]*[a][\W_]*)?(?:(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu](?:[\W_]*[j])?))(?:[\W_]*[eo][\W_]*[bv](?:[\W_]*[a][\W_]*[\W_]*|[\W_]*)?)?(?:[\W_]*[eiau][\W_]*[lhn])?(?:[hn])?(?:[\W_]*(?:[eioau][beijmvu]|[\W_]*(?:[m](?:[\W_]*[iu])?|[pr][\W_]*(?:|[iu][\W_]*[l](?:[\W_]*[ioau])?)|[c][\W_]*(?:[a][\W_]*[t]|[iu][\W_]*[l](?:[\W_]*[ioau])?)|[c](?:[\W_]*[b])?)|[e][\W_]*(?:[t][\W_]*(?:[o][\W_]*[j]|[ybau])|[e][\W_]*(?:[t][\W_]*[e]|[\W_]*[b]))|[ijoyau]|[l][\W_]*[iou]|[c][\W_]*[yu])))|(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[j]))|[xh][\W_]*[yu][\W_]*(?:[eiu][\W_]*(?:[sc][\W_]*[o][\W_]*[sc]|[np][\W_]*[l][\W_]*[e][\W_]*[t])(?:[\W_]*[yiau]|[\W_]*[oa][\W_]*[m](?:[\W_]*[iu])?|[hn][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o][\W_]*[m][\W_]*[yu]))?|[d][\W_]*[o][\W_]*[\W_]*[b][\W_]*[iu][\W_]*[hn][\W_]*(?:[o][\W_]*[j]|[eyiau]))|[b][\W_]*[l][\W_]*(?:[\W_]*[dt][\W_]*(?:[b]|[iu]|[k][\W_]*[iu]|[sc][\W_]*[t][\W_]*[bv][\W_]*[o]|[sc][\W_]*[k][\W_]*(?:[o][\W_]*[ej]|[iu][\W_]*[e]|[a][\W_]*|[iu][\W_]*[j]|[o][\W_]*[rg][\W_]*[o])))?|[bv][\W_]*[i][\W_]*[b][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o][\W_]*[k]|[k][\W_]*(?:[eiyau]|[a][\W_]*[m](?:[\W_]*[iu])?))|(?:[3z][\W_]*[oa][\W_]*)(?:[np][\W_]*[oa][\W_]*[d][\W_]*[l][\W_]*[oia]|[l][\W_]*[yu][\W_]*[np][\W_]*(?:[o][\W_]*[j]|[eyiau]))|[\W_]*[l][\W_]*[\W_]*[xh][\W_]*(?:[eiyau]|[o][\W_]*[j])|[a][\W_]*[hn][\W_]*[yu][\W_]*[sc](?:[\W_]*[eyiau]|[\W_]*[o][\W_]*[m])?|(?:\w*(?:[xh](?:[pr][e][hn]|[yu][eiu])|[np][eiu](?:[3z][d]|[d](?:[eoa][pr]|[pr]))|[b][l][d]|[o][xh][yu][e]|[m][yu][d][eioau]|[d][e][pr][b]|[rg][oa][bv][hn]|[yu][e][b])|[xh][\W_]*(?:[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[eiju])|[np][\W_]*[eiu][\W_]*(?:[3z][\W_]*[d]|[d][\W_]*(?:[eoa][\W_]*[pr]|[pr]))|[b][\W_]*[l][\W_]*[\W_]*[d]|[o][\W_]*[xh][\W_]*[yu][\W_]*[e]|[m][\W_]*[yu][\W_]*[d][\W_]*[eioau]|[d][\W_]*[e][\W_]*[pr][\W_]*[b]|[rg][\W_]*[oa][\W_]*[bv][\W_]*[hn]|[yu][\W_]*[e][\W_]*[b]|[e][b])\w+';
		$self->{'bip'}='';
	}

	bless $self,$class;
	return $self;
		
}


sub remove_slang
{
	
	my ($self,$slang)=@_;

	
	eval
	{
		#$slang =~s/(?<=[\W_])($self->{'word'})(?=[\W_])/$self->{'bip'}/gi;
		#$slang =~s/(\b|_)(?:$self->{'word'})(\b|_)/$1bip$2/gi;	
		#$slang =~s/(?:\b|_)(?:$self->{'word'})(?:\b|_)//gi;

		$slang =~s/(?:\b|(?<=_))(?:$self->{'word'})(?:\b|(?=_))/$self->{'bip'}/gi;
  	
	};
	
	die "Fatal error: bad regular expression!" if $@;

	return $slang; 
}


sub detect_slang
{
	
	my ($self,$slang)=@_;
	my $match;
	
	eval 
	{
		$match=($slang =~m/(?:\b|(?<=_))(?:$self->{'word'})(?:\b|(?=_))/i);	
		
     };
	
	 die "Fatal error: bad regular expression!" if $@;

	return $match; 
}

sub set_bip
{
	my ($self,$bip)=@_;
	$self->{'bip'}=$bip;
}

sub load_dict
{
	my ($self,$file)=@_;
	
	local($/) = undef;
	my $FH = new FileHandle("$file")||die "Can't open $file!";
	my $dict=<$FH>;
	close($FH);
  	$dict=~ s/\015?\012/|/g;
  	
  	eval { '1'=~m/$dict/; };
	die "Bad regular expression in dictionary $file!" if $@;
	
	$self->{'word'}=$self->{'word'}.'|'.$dict;

}



1;

__END__


=head1 NAME

Lingua::RU::Antimat - Perl Module for removal Russian slang from chat, guestbooks, etc.

=head1 SYNOPSIS

use POSIX qw(locale_h);

use Lingua::RU::Antimat;

use locale;

setlocale(LC_CTYPE,"ru_RU.CP1251"); 

$dirty_text='text with slang';

$mat= Lingua::RU::Antimat->new;

#load dictionary with additional words

$mat->load_dict('/home/www/badwords');

$mat->set_bip('Sorry!');

$clean_text=$mat->remove_slang($dirty_text);


=head1 RUSSIAN DOCUMENTATION

Detailed Russian documentation and tutorial available on http://www.tcen.ru/antimat

=head1 DESCRIPTION

This module will remove Russian slang from a string. 'Mat' is Russian name for such bad words and  that is why this module is called Antimat. 

=over

=item $mat=Lingua::RU::Antimat->new($codepage);

This method creates a new object and returns it.
If new() is called without any arguments, the module will use templates for text in encoding win-1251.
If your text in encoding KOI8-R set $codepage equal 'koi8'.

Examples:

$mat=Lingua::RU::Antimat->new; #for text in win-1251

$mat=Lingua::RU::Antimat->new('koi8'); #for text in KOI8-R 

=item $clean_text=$mat->remove_slang($dirty_text);

Method remove_slang takes string and returns string where all 
bad words replaced on Russian analog 'bip' or string you set in method set_bip
which is described later.

=item $badwords=$mat->detect_slang($dirty_text);

Method detect_slang takes string and returns boolean value. This value equal 1
if there is bad word in the string and 0 if there is no such words in the string. 

=item $mat->set_bip($bip);

Set the string (usually word) which will replace bad words in method remove_slang.

Examples:

$mat->set_bip(''); #let strip out slang

$mat->set_bip('I am sorry!'); #long but also correct

=item $mat->load_dict($file);

This method loads dictionary with additional bad words. Each string in the dictionary should be a word or regular expression. $file could be relative or absolute path to the dictionary.

=back

=head1 SEE ALSO

Detailed Russian documentation on http://www.tcen.ru/antimat

perllocale manpage

=head1 CREDITS

Andrey Skorohod, marlenus@marlenus.com for his bug reports.

Thanks!

=head1 AUTHOR

Ilya Soldatkin, arc@tcen.ru

Drop me a line if you deploy this module on your site. Think about this as a small contribution to my efforts for writing and supporting this module. I can not improve this module if I will know that no one uses it. 

=head1 COPYRIGHT

Copyright 2001 Ilya Soldatkin. All rights reserved.

This library is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
