/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.FeatureCollectionConfig;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class InvDatasetFeatureCollection
extends InvCatalogRef {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFeatureCollection.class);
    private static final String FMRC = "fmrc.ncd";
    private static final String BEST = "best.ncd";
    private static final String SCAN = "files";
    private static final String RUNS = "runs";
    private static final String RUN_NAME = "RUN_";
    private static final String RUN_TITLE = "Forecast Model Run";
    private static final String FORECAST = "forecast";
    private static final String FORECAST_NAME = "ConstantForecast_";
    private static final String FORECAST_TITLE = "Constant Forecast Date";
    private static final String OFFSET = "offset";
    private static final String OFFSET_NAME = "Offset_";
    private static final String OFFSET_TITLE = "Constant Forecast Offset";
    private static final String Virtual_Services = "VirtualServices";
    private final String path;
    private final FeatureType featureType;
    private final FeatureCollectionConfig.Config config;
    private final Fmrc fmrc;
    private final Set<FeatureCollectionConfig.FmrcDatasetType> wantDatasets;
    private final String topDirectory;
    private final Pattern filter;
    private InvService orgService;
    private InvService virtualService;
    @GuardedBy(value="lock")
    private State state;
    private Object lock = new Object();

    public InvDatasetFeatureCollection(InvDatasetImpl parent, String name, String path, String featureType, FeatureCollectionConfig.Config config) {
        super(parent, name, "/thredds/catalog/" + path + "/catalog.xml");
        this.path = path;
        this.featureType = FeatureType.getType(featureType);
        if (featureType.equalsIgnoreCase("FMRC")) {
            this.getLocalMetadataInheritable().setDataType(FeatureType.GRID);
        }
        this.config = config;
        this.wantDatasets = config.fmrcConfig.datasets;
        Formatter errlog = new Formatter();
        try {
            this.fmrc = Fmrc.open(config, errlog);
        }
        catch (Exception e) {
            throw new RuntimeException(errlog.toString());
        }
        CollectionManager cm = this.fmrc.getManager();
        if (cm instanceof DatasetCollectionManager) {
            CollectionSpecParser sp = ((DatasetCollectionManager)cm).getCollectionSpecParser();
            this.topDirectory = sp.getTopDir();
            this.filter = sp.getFilter();
        } else {
            this.topDirectory = null;
            this.filter = null;
        }
    }

    private InvService makeVirtualService(InvService org) {
        if (org.getServiceType() != ServiceType.COMPOUND) {
            return org;
        }
        InvService result = new InvService(Virtual_Services, ServiceType.COMPOUND.toString(), null, null, null);
        for (InvService service : org.getServices()) {
            if (service.getServiceType() == ServiceType.HTTPServer) continue;
            result.addService(service);
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public String getTopDirectoryLocation() {
        return this.topDirectory;
    }

    public FeatureCollectionConfig.Config getConfig() {
        return this.config;
    }

    public InvDatasetScan getRawFileScan() {
        try {
            this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
        }
        return this.state.scan;
    }

    @Override
    public List<InvDataset> getDatasets() {
        try {
            this.checkState();
        }
        catch (Exception e) {
            logger.error("Error in checkState", e);
        }
        return this.state.datasets;
    }

    public void triggerRescan() throws IOException {
        this.fmrc.triggerRescan();
    }

    public void triggerProto() throws IOException {
        this.fmrc.triggerProto();
    }

    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        logger.debug("FMRC make catalog for " + match + " " + baseURI);
        State localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(baseURI, localState);
            }
            if (match.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                return this.makeCatalogRuns(baseURI, localState);
            }
            if (match.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                return this.makeCatalogOffsets(baseURI, localState);
            }
            if (match.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                return this.makeCatalogForecasts(baseURI, localState);
            }
            if (match.startsWith(SCAN) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files)) {
                return localState.scan.makeCatalogForDirectory(orgPath, baseURI);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    private InvCatalogImpl makeCatalogTop(URI baseURI, State localState) throws IOException, URISyntaxException {
        String id;
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getXlinkHref());
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        if ((id = this.getID()) == null) {
            id = this.getPath();
        }
        top.setID(id);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        mainCatalog.addDataset(top);
        mainCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDataset ds : this.getDatasets()) {
            top.addDataset((InvDatasetImpl)ds);
        }
        mainCatalog.finish();
        return mainCatalog;
    }

    private InvCatalogImpl makeCatalogRuns(URI baseURI, State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(RUNS));
        InvCatalogImpl runCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(RUN_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        runCatalog.addDataset(top);
        runCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeRunDatasets()) {
            top.addDataset(ds);
        }
        runCatalog.finish();
        return runCatalog;
    }

    private InvCatalogImpl makeCatalogOffsets(URI baseURI, State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(OFFSET));
        InvCatalogImpl offCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        top.setName(OFFSET_TITLE);
        offCatalog.addDataset(top);
        offCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeOffsetDatasets()) {
            top.addDataset(ds);
        }
        offCatalog.finish();
        return offCatalog;
    }

    private InvCatalogImpl makeCatalogForecasts(URI baseURI, State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(FORECAST));
        InvCatalogImpl foreCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(FORECAST_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        foreCatalog.addDataset(top);
        foreCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeForecastDatasets()) {
            top.addDataset(ds);
        }
        foreCatalog.finish();
        return foreCatalog;
    }

    private List<InvDatasetImpl> makeRunDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date runDate : this.fmrc.getRunDates()) {
            String name = this.getName() + "_" + RUN_NAME + formatter.toDateTimeStringISO(runDate);
            name = StringUtil.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + RUNS + "/" + name);
            nested.setID(id + "/" + RUNS + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from Run " + name);
            datasets.add(nested);
        }
        Collections.reverse(datasets);
        return datasets;
    }

    private List<InvDatasetImpl> makeOffsetDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (double offset : this.fmrc.getForecastOffsets()) {
            String name = this.getName() + "_" + OFFSET_NAME + offset + "hr";
            name = StringUtil.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + OFFSET + "/" + name);
            nested.setID(id + "/" + OFFSET + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from the " + offset + " hour forecasts, across different model runs.");
            datasets.add(nested);
        }
        return datasets;
    }

    private List<InvDatasetImpl> makeForecastDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date forecastDate : this.fmrc.getForecastDates()) {
            String name = this.getName() + "_" + FORECAST_NAME + formatter.toDateTimeStringISO(forecastDate);
            name = StringUtil.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + FORECAST + "/" + name);
            nested.setID(id + "/" + FORECAST + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data with the same forecast date, " + name + ", across different model runs.");
            datasets.add(nested);
        }
        return datasets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean checkInv = true;
            boolean checkProto = true;
            if (this.state == null) {
                this.orgService = this.getServiceDefault();
                this.virtualService = this.makeVirtualService(this.orgService);
            } else {
                checkInv = this.fmrc.checkInvState(this.state.lastInvChange);
                checkProto = this.fmrc.checkProtoState(this.state.lastProtoChange);
                if (!checkInv && !checkProto) {
                    return this.state;
                }
            }
            State localState = new State(this.state);
            if (checkProto) {
                ucar.nc2.dt.GridDataset gds = this.getGridDataset(FMRC);
                if (null != gds) {
                    localState.vars = MetadataExtractor.extractVariables(this, gds);
                    localState.gc = MetadataExtractor.extractGeospatial(gds);
                    localState.dateRange = MetadataExtractor.extractDateRange(gds);
                }
                localState.lastProtoChange = new Date();
            }
            if (checkInv) {
                this.makeDatasets(localState);
                localState.lastInvChange = new Date();
            }
            this.state = localState;
            return this.state;
        }
    }

    private void makeDatasets(State localState) {
        ThreddsMetadata tm;
        String name;
        InvDatasetImpl ds;
        ArrayList<InvDataset> datasets = new ArrayList<InvDataset>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
            ds = new InvDatasetImpl(this, "Forecast Model Run Collection (2D time coordinates)");
            name = this.getName() + "_" + FMRC;
            name = StringUtil.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Forecast Model Run Collection (2D time coordinates).");
            ds.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
            ds = new InvDatasetImpl(this, "Best Time Series");
            name = this.getName() + "_" + BEST;
            name = StringUtil.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Best time series, taking the data from the most recent run available.");
            ds.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
            ds.finish();
            datasets.add(ds);
        }
        if (this.config.fmrcConfig.getBestDatasets() != null) {
            for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                InvDatasetImpl ds2 = new InvDatasetImpl(this, bd.name);
                String name2 = this.getName() + "_" + bd.name;
                name2 = StringUtil.replace(name2, ' ', "_");
                ds2.setUrlPath(this.path + "/" + name2);
                ds2.setID(id + "/" + name2);
                ThreddsMetadata tm2 = ds2.getLocalMetadata();
                tm2.addDocumentation("summary", "Best time series, excluding offset hours less than " + bd.greaterThan);
                ds2.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                ds2.finish();
                datasets.add(ds2);
            }
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
            ds = new InvCatalogRef(this, RUN_TITLE, this.getCatalogHref(RUNS));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
            ds = new InvCatalogRef(this, FORECAST_TITLE, this.getCatalogHref(FORECAST));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
            ds = new InvCatalogRef(this, OFFSET_TITLE, this.getCatalogHref(OFFSET));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files) && this.topDirectory != null) {
            long olderThan = (long)(1000.0 * this.fmrc.getOlderThanFilterInSecs());
            ScanFilter scanFilter = new ScanFilter(this.filter, olderThan);
            InvDatasetScan scanDataset = new InvDatasetScan((InvCatalogImpl)this.getParentCatalog(), (InvDatasetImpl)this, "File_Access", this.path + "/" + SCAN, this.topDirectory, scanFilter, true, "true", false, null, null, null);
            scanDataset.addService(this.orgService);
            ThreddsMetadata tmi = scanDataset.getLocalMetadataInheritable();
            tmi.setServiceName(this.orgService.getName());
            tmi.addDocumentation("summary", "Individual data file, which comprise the Forecast Model Run Collection.");
            tmi.setGeospatialCoverage(null);
            tmi.setTimeCoverage(null);
            scanDataset.setServiceName(this.orgService.getName());
            scanDataset.finish();
            datasets.add(scanDataset);
            localState.scan = scanDataset;
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    private String getCatalogHref(String what) {
        return "/thredds/catalog/" + this.path + "/" + what + "/catalog.xml";
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf("/");
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(SCAN)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            return NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
        }
        ucar.nc2.dt.GridDataset gds = this.getGridDataset(matchPath);
        return gds == null ? null : (NetcdfDataset)gds.getNetcdfFile();
    }

    public ucar.nc2.dt.GridDataset getGridDataset(String matchPath) throws IOException {
        int pos = matchPath.indexOf("/");
        String wantType = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String wantName = pos > -1 ? matchPath.substring(pos + 1) : matchPath;
        String hasName = StringUtil.replace(this.name, ' ', "_") + "_";
        try {
            if (wantType.equals(SCAN)) {
                NetcdfDataset ncd = this.getNetcdfDataset(matchPath);
                return ncd == null ? null : new GridDataset(ncd);
            }
            if (wantName.equals(hasName + FMRC) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
                return this.fmrc.getDataset2D(null);
            }
            if (wantName.equals(hasName + BEST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
                return this.fmrc.getDatasetBest();
            }
            if (wantType.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                int pos1 = wantName.indexOf(OFFSET_NAME);
                int pos2 = wantName.indexOf("hr");
                if (pos1 < 0 || pos2 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + OFFSET_NAME.length(), pos2);
                double hour = Double.parseDouble(id);
                return this.fmrc.getConstantOffsetDataset(hour);
            }
            if (wantType.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                int pos1 = wantName.indexOf(RUN_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + RUN_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                return this.fmrc.getRunTimeDataset(date);
            }
            if (wantType.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                int pos1 = wantName.indexOf(FORECAST_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + FORECAST_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                return this.fmrc.getConstantForecastDataset(date);
            }
            if (this.config.fmrcConfig.getBestDatasets() != null) {
                for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                    if (!wantName.endsWith(bd.name)) continue;
                    return this.fmrc.getDatasetBest(bd);
                }
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }

    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        int pos = remaining.indexOf(SCAN);
        StringBuilder fname = new StringBuilder(this.topDirectory);
        if (!this.topDirectory.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + SCAN.length() + 1) : remaining);
        return new File(fname.toString());
    }

    public static class ScanFilter
    implements CrawlableDatasetFilter {
        private Pattern p;
        private long olderThan;

        public ScanFilter(Pattern p, long olderThan) {
            this.p = p;
            this.olderThan = olderThan;
        }

        public boolean accept(CrawlableDataset dataset) {
            long now;
            Date lastModDate;
            Matcher matcher;
            if (dataset.isCollection()) {
                return true;
            }
            if (this.p != null && !(matcher = this.p.matcher(dataset.getName())).matches()) {
                return false;
            }
            return this.olderThan <= 0L || (lastModDate = dataset.lastModified()) == null || (now = System.currentTimeMillis()) - lastModDate.getTime() > this.olderThan;
        }

        public Object getConfigObject() {
            return null;
        }
    }

    private class State {
        ThreddsMetadata.Variables vars;
        ThreddsMetadata.GeospatialCoverage gc;
        DateRange dateRange;
        Date lastProtoChange;
        InvDatasetScan scan;
        List<InvDataset> datasets;
        Date lastInvChange;

        State(State from) {
            if (from != null) {
                this.vars = from.vars;
                this.gc = from.gc;
                this.dateRange = from.dateRange;
                this.lastProtoChange = from.lastProtoChange;
                this.scan = from.scan;
                this.datasets = from.datasets;
                this.lastInvChange = from.lastInvChange;
            }
        }
    }
}

