use Test;
BEGIN { plan tests => 2 }
use XML::SAX::Base;
use strict;
use vars qw/%events $meth_count/;
require "t/events.pl";

# Tests for EntityResolver classes using a filter

my $sax_it = SAXAutoload->new();
my $filter = Filter->new(EntityResolver => $sax_it);
my $driver = Driver->new(EntityResolver => $filter);
$driver->parse();

ok($meth_count == 1);

# end main

package Filter;
BEGIN {
    if ($] < 5.6) {
        use XML::SAX::Base;
        use vars qw/@ISA/;
        @ISA =  qw/XML::SAX::Base/;
    }
    else {
        use base qw/XML::SAX::Base/;
    }
}

# this space intentionally blank

1;

package Driver;
BEGIN {
    if ($] < 5.6) {
        use XML::SAX::Base;
        use vars qw/@ISA/;
        @ISA =  qw/XML::SAX::Base/;
    }
    else {
        use base qw/XML::SAX::Base/;
    }
}

sub parse {
    my $self = shift;
    my %events = %main::events;
 
    $self->SUPER::resolve_entity($events{resolve_entity});

}
1;

# basic single class SAX Handler
package SAXAutoload;
use vars qw($AUTOLOAD);
use strict;

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my %options = @_;
    $options{methods} = {};
    return bless \%options, $class;
}

sub AUTOLOAD {
    my $self = shift;
    my $data = shift;
    my $name = $AUTOLOAD;
    $name =~ s/.*://;   # strip fully-qualified portion
    return if $name eq 'DESTROY';
    #warn "name is $name \ndata is $data\n";
    my $okay_count = 0;
    foreach my $key (keys (%{$data})) {
       $okay_count++ if defined $main::events{$name}->{$key};
    }
    #warn "count $okay_count \n";
    main::ok($okay_count == scalar (keys (%{$data})));
    $main::meth_count++;
}
1;
