# Generated by default/object.tt
package Paws::Macie2::BucketCountByEncryptionType;
  use Moose;
  has KmsManaged => (is => 'ro', isa => 'Int', request_name => 'kmsManaged', traits => ['NameInRequest']);
  has S3Managed => (is => 'ro', isa => 'Int', request_name => 's3Managed', traits => ['NameInRequest']);
  has Unencrypted => (is => 'ro', isa => 'Int', request_name => 'unencrypted', traits => ['NameInRequest']);
  has Unknown => (is => 'ro', isa => 'Int', request_name => 'unknown', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BucketCountByEncryptionType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BucketCountByEncryptionType object:

  $service_obj->Method(Att1 => { KmsManaged => $value, ..., Unknown => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BucketCountByEncryptionType object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsManaged

=head1 DESCRIPTION

Provides information about the number of S3 buckets that use certain
types of server-side encryption by default or don't encrypt new objects
by default. For detailed information about these settings, see Setting
default server-side encryption behavior for Amazon S3 buckets
(https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html)
in the I<Amazon Simple Storage Service User Guide>.

=head1 ATTRIBUTES


=head2 KmsManaged => Int

The total number of buckets that use an Key Management Service (KMS)
customer master key (CMK) to encrypt new objects by default. These
buckets use Amazon Web Services managed KMS encryption (AWS-KMS) or
customer managed KMS encryption (SSE-KMS) by default.


=head2 S3Managed => Int

The total number of buckets that use an Amazon S3 managed key to
encrypt new objects by default. These buckets use Amazon S3 managed
encryption (SSE-S3) by default.


=head2 Unencrypted => Int

The total number of buckets that don't encrypt new objects by default.
Default encryption is disabled for these buckets.


=head2 Unknown => Int

The total number of buckets that Amazon Macie doesn't have current
encryption metadata for. Macie can't provide current data about the
default encryption settings for these buckets.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

