# Generated by default/object.tt
package Paws::MediaConvert::MxfSettings;
  use Moose;
  has AfdSignaling => (is => 'ro', isa => 'Str', request_name => 'afdSignaling', traits => ['NameInRequest']);
  has Profile => (is => 'ro', isa => 'Str', request_name => 'profile', traits => ['NameInRequest']);
  has XavcProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::MxfXavcProfileSettings', request_name => 'xavcProfileSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::MxfSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::MxfSettings object:

  $service_obj->Method(Att1 => { AfdSignaling => $value, ..., XavcProfileSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::MxfSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AfdSignaling

=head1 DESCRIPTION

These settings relate to your MXF output container.

=head1 ATTRIBUTES


=head2 AfdSignaling => Str

Optional. When you have AFD signaling set up in your output video
stream, use this setting to choose whether to also include it in the
MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from
the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to
copy the AFD values from the video stream for this output to the MXF
wrapper. Regardless of which option you choose, the AFD values remain
in the video stream. Related settings: To set up your output to include
or exclude AFD values, see AfdSignaling, under VideoDescription. On the
console, find AFD signaling under the output's video encoding settings.


=head2 Profile => Str

Specify the MXF profile, also called shim, for this output. When you
choose Auto, MediaConvert chooses a profile based on the video codec
and resolution. For a list of codecs supported with each MXF profile,
see
https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html.
For more information about the automatic selection behavior, see
https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.


=head2 XavcProfileSettings => L<Paws::MediaConvert::MxfXavcProfileSettings>

Specify the XAVC profile settings for MXF outputs when you set your MXF
profile to XAVC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

