/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.png;

import com.drew.imaging.png.PngColorType;
import com.drew.lang.KeyValuePair;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.png.PngDirectory;
import java.io.IOException;
import java.util.List;

public class PngDescriptor
extends TagDescriptor<PngDirectory> {
    public PngDescriptor(@NotNull PngDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 4: {
                return this.getColorTypeDescription();
            }
            case 5: {
                return this.getCompressionTypeDescription();
            }
            case 6: {
                return this.getFilterMethodDescription();
            }
            case 7: {
                return this.getInterlaceMethodDescription();
            }
            case 9: {
                return this.getPaletteHasTransparencyDescription();
            }
            case 10: {
                return this.getIsSrgbColorSpaceDescription();
            }
            case 13: {
                return this.getTextualDataDescription();
            }
            case 15: {
                return this.getBackgroundColorDescription();
            }
            case 18: {
                return this.getUnitSpecifierDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getColorTypeDescription() {
        Integer value = ((PngDirectory)this._directory).getInteger(4);
        if (value == null) {
            return null;
        }
        PngColorType colorType = PngColorType.fromNumericValue(value);
        if (colorType == null) {
            return null;
        }
        return colorType.getDescription();
    }

    @Nullable
    public String getCompressionTypeDescription() {
        return this.getIndexedDescription(5, "Deflate");
    }

    @Nullable
    public String getFilterMethodDescription() {
        return this.getIndexedDescription(6, "Adaptive");
    }

    @Nullable
    public String getInterlaceMethodDescription() {
        return this.getIndexedDescription(7, "No Interlace", "Adam7 Interlace");
    }

    @Nullable
    public String getPaletteHasTransparencyDescription() {
        return this.getIndexedDescription(9, null, "Yes");
    }

    @Nullable
    public String getIsSrgbColorSpaceDescription() {
        return this.getIndexedDescription(10, "Perceptual", "Relative Colorimetric", "Saturation", "Absolute Colorimetric");
    }

    @Nullable
    public String getUnitSpecifierDescription() {
        return this.getIndexedDescription(18, "Unspecified", "Metres");
    }

    @Nullable
    public String getTextualDataDescription() {
        Object object = ((PngDirectory)this._directory).getObject(13);
        if (object == null) {
            return null;
        }
        List keyValues = (List)object;
        StringBuilder sb = new StringBuilder();
        for (KeyValuePair keyValue : keyValues) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(String.format("%s: %s", keyValue.getKey(), keyValue.getValue()));
        }
        return sb.toString();
    }

    @Nullable
    public String getBackgroundColorDescription() {
        byte[] bytes = ((PngDirectory)this._directory).getByteArray(15);
        Integer colorType = ((PngDirectory)this._directory).getInteger(4);
        if (bytes == null || colorType == null) {
            return null;
        }
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
        try {
            switch (colorType) {
                case 0: 
                case 4: {
                    return String.format("Greyscale Level %d", reader.getUInt16());
                }
                case 2: 
                case 6: {
                    return String.format("R %d, G %d, B %d", reader.getUInt16(), reader.getUInt16(), reader.getUInt16());
                }
                case 3: {
                    return String.format("Palette Index %d", reader.getUInt8());
                }
            }
        }
        catch (IOException ex) {
            return null;
        }
        return null;
    }
}

