/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import org.apache.sis.measure.Angle;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.cs.AxisDirection;

public final class Longitude
extends Angle {
    private static final long serialVersionUID = -3203511772374891877L;
    public static final double MIN_VALUE = -180.0;
    public static final double MAX_VALUE = 180.0;

    public Longitude(double d) {
        super(d);
    }

    public Longitude(String string) throws NumberFormatException {
        super(string);
    }

    public Longitude(DirectPosition directPosition) throws IllegalArgumentException {
        super(Longitude.valueOf(directPosition, AxisDirection.EAST, AxisDirection.WEST));
    }

    @Override
    final char hemisphere(boolean bl) {
        return bl ? (char)'W' : 'E';
    }

    public static double normalize(double d) {
        return d - Math.floor((d - -180.0) / 360.0) * 360.0;
    }
}

