/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.speex.SpeexFile;
import org.gagravarr.speex.SpeexInfo;
import org.gagravarr.tika.OggAudioParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeexParser
extends OggAudioParser {
    private static final long serialVersionUID = 5904981674814527529L;
    protected static final MediaType SPEEX_AUDIO = MediaType.parse(OggStreamIdentifier.SPEEX_AUDIO.mimetype);
    protected static final MediaType SPEEX_AUDIO_ALT = MediaType.parse(OggStreamIdentifier.SPEEX_AUDIO_ALT.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(SPEEX_AUDIO, SPEEX_AUDIO_ALT);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", SPEEX_AUDIO.toString());
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "Speex");
        OggFile ogg = new OggFile(stream);
        SpeexFile speex = new SpeexFile(ogg);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, speex.getInfo());
        SpeexParser.extractComments(metadata, xhtml, speex.getTags());
        SpeexParser.extractDuration(metadata, xhtml, speex, speex);
        xhtml.endDocument();
        speex.close();
    }

    protected void extractInfo(Metadata metadata, SpeexInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)info.getRate());
        metadata.add("version", "Speex " + info.getVersionId() + " - " + info.getVersionString());
        SpeexParser.extractChannelInfo(metadata, info);
    }
}

