#!/usr/bin/perl

package eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetPromotionalSaleRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleRequestType

=head1 DESCRIPTION

Creates or modifies a promotional sale. This call is part of the Promotional 
Price Display feature, which enables sellers to apply discounts and/or free 
shipping across many listings. 
Promotional sales apply to single and multi-quantity Store Inventory format, 
regular fixed-price format, auction, and auction/BIN formats. 
Auction and auction/BIN format listings can be added to free shipping sales only.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PromotionalSaleType;
use eBay::API::XML::DataType::Enum::ModifyActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:ModifyActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ModifyActionCodeType', '' ]
	, [ 'PromotionalSaleDetails', 'ns:PromotionalSaleType', ''
	     ,'eBay::API::XML::DataType::PromotionalSaleType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

Specifies adding, removing, or modifying promotional sales.

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:ModifyActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setPromotionalSaleDetails()

Specifies details about the promotional sale.

  RequiredInput: Yes
#    Argument: 'ns:PromotionalSaleType'

=cut

sub setPromotionalSaleDetails {
  my $self = shift;
  $self->{'PromotionalSaleDetails'} = shift
}

=head2 getPromotionalSaleDetails()

#    Returns: 'ns:PromotionalSaleType'

=cut

sub getPromotionalSaleDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalSaleDetails'
		,'eBay::API::XML::DataType::PromotionalSaleType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
