/*  -*- buffer-read-only: t -*-
 *
 *    proto.h
 *
 *    Copyright (C) 1993, 1994, 1995, 1996, 1997, 1998, 1999,
 *    2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by embed.pl from data in embed.fnc, embed.pl,
 * pp.sym, intrpvar.h, and perlvars.h.
 * Any changes made here will be lost!
 *
 * Edit those files and run 'make regen_headers' to effect changes.
 */

START_EXTERN_C

#if defined(PERL_IMPLICIT_SYS)
PERL_CALLCONV PerlInterpreter*	perl_alloc_using(struct IPerlMem *ipM, struct IPerlMem *ipMS, struct IPerlMem *ipMP, struct IPerlEnv *ipE, struct IPerlStdIO *ipStd, struct IPerlLIO *ipLIO, struct IPerlDir *ipD, struct IPerlSock *ipS, struct IPerlProc *ipP)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4)
			__attribute__nonnull__(5)
			__attribute__nonnull__(6)
			__attribute__nonnull__(7)
			__attribute__nonnull__(8)
			__attribute__nonnull__(9);
#define PERL_ARGS_ASSERT_PERL_ALLOC_USING	\
	assert(ipM); assert(ipMS); assert(ipMP); assert(ipE); assert(ipStd); assert(ipLIO); assert(ipD); assert(ipS); assert(ipP)

#endif
PERL_CALLCONV PerlInterpreter*	perl_alloc(void);
PERL_CALLCONV void	perl_construct(PerlInterpreter *my_perl)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_CONSTRUCT	\
	assert(my_perl)

PERL_CALLCONV int	perl_destruct(PerlInterpreter *my_perl)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_DESTRUCT	\
	assert(my_perl)

PERL_CALLCONV void	perl_free(PerlInterpreter *my_perl)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_FREE	\
	assert(my_perl)

PERL_CALLCONV int	perl_run(PerlInterpreter *my_perl)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_RUN	\
	assert(my_perl)

PERL_CALLCONV int	perl_parse(PerlInterpreter *my_perl, XSINIT_t xsinit, int argc, char** argv, char** env)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_PARSE	\
	assert(my_perl)

PERL_CALLCONV bool	Perl_doing_taint(int argc, char** argv, char** env)
			__attribute__warn_unused_result__;

#if defined(USE_ITHREADS)
PERL_CALLCONV PerlInterpreter*	perl_clone(PerlInterpreter *proto_perl, UV flags)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PERL_CLONE	\
	assert(proto_perl)

#  if defined(PERL_IMPLICIT_SYS)
PERL_CALLCONV PerlInterpreter*	perl_clone_using(PerlInterpreter *proto_perl, UV flags, struct IPerlMem* ipM, struct IPerlMem* ipMS, struct IPerlMem* ipMP, struct IPerlEnv* ipE, struct IPerlStdIO* ipStd, struct IPerlLIO* ipLIO, struct IPerlDir* ipD, struct IPerlSock* ipS, struct IPerlProc* ipP)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4)
			__attribute__nonnull__(5)
			__attribute__nonnull__(6)
			__attribute__nonnull__(7)
			__attribute__nonnull__(8)
			__attribute__nonnull__(9)
			__attribute__nonnull__(10)
			__attribute__nonnull__(11);
#define PERL_ARGS_ASSERT_PERL_CLONE_USING	\
	assert(proto_perl); assert(ipM); assert(ipMS); assert(ipMP); assert(ipE); assert(ipStd); assert(ipLIO); assert(ipD); assert(ipS); assert(ipP)

#  endif
#endif

PERL_CALLCONV Malloc_t	Perl_malloc(MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_calloc(MEM_SIZE elements, MEM_SIZE size)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_realloc(Malloc_t where, MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Free_t	Perl_mfree(Malloc_t where);
#if defined(MYMALLOC)
PERL_CALLCONV MEM_SIZE	Perl_malloced_size(void *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_MALLOCED_SIZE	\
	assert(p)

PERL_CALLCONV MEM_SIZE	Perl_malloc_good_size(size_t nbytes)
			__attribute__warn_unused_result__;

#endif

PERL_CALLCONV void*	Perl_get_context(void)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_set_context(void *t)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_SET_CONTEXT	\
	assert(t)

PERL_CALLCONV I32	Perl_regcurly(const char *s)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_REGCURLY	\
	assert(s)


END_EXTERN_C

/* functions with flag 'n' should come before here */
START_EXTERN_C
#  include "pp_proto.h"
PERL_CALLCONV bool	Perl_try_amagic_bin(pTHX_ int method, int flags);
PERL_CALLCONV bool	Perl_try_amagic_un(pTHX_ int method, int flags);
PERL_CALLCONV SV*	Perl_amagic_call(pTHX_ SV* left, SV* right, int method, int dir)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AMAGIC_CALL	\
	assert(left); assert(right)

PERL_CALLCONV int	Perl_Gv_AMupdate(pTHX_ HV* stash, bool destructing)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_AMUPDATE	\
	assert(stash)

PERL_CALLCONV CV*	Perl_gv_handler(pTHX_ HV* stash, I32 id)
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_append_elem(pTHX_ I32 optype, OP* first, OP* last);
PERL_CALLCONV OP*	Perl_append_list(pTHX_ I32 optype, LISTOP* first, LISTOP* last);
PERL_CALLCONV I32	Perl_apply(pTHX_ I32 type, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_APPLY	\
	assert(mark); assert(sp)

PERL_CALLCONV void	Perl_apply_attrs_string(pTHX_ const char *stashpv, CV *cv, const char *attrstr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_APPLY_ATTRS_STRING	\
	assert(stashpv); assert(cv); assert(attrstr)

PERL_CALLCONV void	Perl_av_clear(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_CLEAR	\
	assert(av)

PERL_CALLCONV SV*	Perl_av_delete(pTHX_ AV *av, I32 key, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_DELETE	\
	assert(av)

PERL_CALLCONV bool	Perl_av_exists(pTHX_ AV *av, I32 key)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_EXISTS	\
	assert(av)

PERL_CALLCONV void	Perl_av_extend(pTHX_ AV *av, I32 key)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_EXTEND	\
	assert(av)

PERL_CALLCONV SV**	Perl_av_fetch(pTHX_ AV *av, I32 key, I32 lval)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_FETCH	\
	assert(av)

PERL_CALLCONV void	Perl_av_fill(pTHX_ AV *av, I32 fill)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_FILL	\
	assert(av)

PERL_CALLCONV I32	Perl_av_len(pTHX_ AV *av)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_LEN	\
	assert(av)

PERL_CALLCONV AV*	Perl_av_make(pTHX_ I32 size, SV **strp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AV_MAKE	\
	assert(strp)

PERL_CALLCONV SV*	Perl_av_pop(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_POP	\
	assert(av)

PERL_CALLCONV void	Perl_av_create_and_push(pTHX_ AV **const avp, SV *const val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AV_CREATE_AND_PUSH	\
	assert(avp); assert(val)

PERL_CALLCONV void	Perl_av_push(pTHX_ AV *av, SV *val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AV_PUSH	\
	assert(av); assert(val)

PERL_CALLCONV void	Perl_av_reify(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_REIFY	\
	assert(av)

PERL_CALLCONV SV*	Perl_av_shift(pTHX_ AV *av)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_SHIFT	\
	assert(av)

PERL_CALLCONV SV**	Perl_av_store(pTHX_ AV *av, I32 key, SV *val)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_STORE	\
	assert(av)

PERL_CALLCONV void	Perl_av_undef(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_UNDEF	\
	assert(av)

PERL_CALLCONV SV**	Perl_av_create_and_unshift_one(pTHX_ AV **const avp, SV *const val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AV_CREATE_AND_UNSHIFT_ONE	\
	assert(avp); assert(val)

PERL_CALLCONV void	Perl_av_unshift(pTHX_ AV *av, I32 num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_UNSHIFT	\
	assert(av)

PERL_CALLCONV SV**	Perl_av_arylen_p(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_ARYLEN_P	\
	assert(av)

PERL_CALLCONV IV*	Perl_av_iter_p(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_AV_ITER_P	\
	assert(av)

#if defined(PERL_IN_AV_C) || defined(PERL_DECL_PROT)
STATIC MAGIC*	S_get_aux_mg(pTHX_ AV *av)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_AUX_MG	\
	assert(av)

#endif
PERL_CALLCONV OP*	Perl_bind_match(pTHX_ I32 type, OP *left, OP *right)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_BIND_MATCH	\
	assert(left); assert(right)

PERL_CALLCONV OP*	Perl_block_end(pTHX_ I32 floor, OP* seq)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_block_gimme(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_block_start(pTHX_ int full)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_boot_core_UNIVERSAL(pTHX);
PERL_CALLCONV void	Perl_boot_core_PerlIO(pTHX);
PERL_CALLCONV void	Perl_call_list(pTHX_ I32 oldscope, AV *paramList)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_CALL_LIST	\
	assert(paramList)

PERL_CALLCONV bool	Perl_cando(pTHX_ Mode_t mode, bool effective, const Stat_t* statbufp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_CANDO	\
	assert(statbufp)

PERL_CALLCONV U32	Perl_cast_ulong(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_cast_i32(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV IV	Perl_cast_iv(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV UV	Perl_cast_uv(pTHX_ NV f)
			__attribute__warn_unused_result__;

#if !defined(HAS_TRUNCATE) && !defined(HAS_CHSIZE) && defined(F_FREESP)
PERL_CALLCONV I32	Perl_my_chsize(pTHX_ int fd, Off_t length)
			__attribute__warn_unused_result__;

#endif
PERL_CALLCONV OP*	Perl_convert(pTHX_ I32 optype, I32 flags, OP* o)
			__attribute__warn_unused_result__;

PERL_CALLCONV PERL_CONTEXT*	Perl_create_eval_scope(pTHX_ U32 flags);
PERL_CALLCONV void	Perl_croak_sv(pTHX_ SV *baseex)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CROAK_SV	\
	assert(baseex)

PERL_CALLCONV void	Perl_croak(pTHX_ const char* pat, ...)
			__attribute__noreturn__
			__attribute__format__null_ok__(__printf__,pTHX_1,pTHX_2);

PERL_CALLCONV void	Perl_vcroak(pTHX_ const char* pat, va_list* args)
			__attribute__noreturn__;

PERL_CALLCONV void	Perl_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE	\
	assert(cv); assert(params)


#if defined(PERL_IMPLICIT_CONTEXT)
PERL_CALLCONV void	Perl_croak_nocontext(const char* pat, ...)
			__attribute__noreturn__
			__attribute__format__null_ok__(__printf__,1,2);

PERL_CALLCONV OP*	Perl_die_nocontext(const char* pat, ...)
			__attribute__format__null_ok__(__printf__,1,2);

PERL_CALLCONV void	Perl_deb_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_DEB_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV char*	Perl_form_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_FORM_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV void	Perl_load_module_nocontext(U32 flags, SV* name, SV* ver, ...)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_LOAD_MODULE_NOCONTEXT	\
	assert(name)

PERL_CALLCONV SV*	Perl_mess_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_MESS_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV void	Perl_warn_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_WARN_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV void	Perl_warner_nocontext(U32 err, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_WARNER_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV SV*	Perl_newSVpvf_nocontext(const char *const pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_NEWSVPVF_NOCONTEXT	\
	assert(pat)

PERL_CALLCONV void	Perl_sv_catpvf_nocontext(SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_CATPVF_NOCONTEXT	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_setpvf_nocontext(SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_SETPVF_NOCONTEXT	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_catpvf_mg_nocontext(SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_CATPVF_MG_NOCONTEXT	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_setpvf_mg_nocontext(SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_SETPVF_MG_NOCONTEXT	\
	assert(sv); assert(pat)

PERL_CALLCONV int	Perl_fprintf_nocontext(PerlIO *stream, const char *format, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_FPRINTF_NOCONTEXT	\
	assert(stream); assert(format)

PERL_CALLCONV int	Perl_printf_nocontext(const char *format, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PRINTF_NOCONTEXT	\
	assert(format)

#endif
PERL_CALLCONV void	Perl_cv_ckproto_len(pTHX_ const CV* cv, const GV* gv, const char* p, const STRLEN len)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CV_CKPROTO_LEN	\
	assert(cv)

PERL_CALLCONV CV*	Perl_cv_clone(pTHX_ CV* proto)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CV_CLONE	\
	assert(proto)

PERL_CALLCONV SV*	Perl_gv_const_sv(pTHX_ GV* gv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_CONST_SV	\
	assert(gv)

PERL_CALLCONV SV*	Perl_cv_const_sv(pTHX_ const CV *const cv)
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_op_const_sv(pTHX_ const OP* o, CV* cv)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_cv_undef(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CV_UNDEF	\
	assert(cv)

PERL_CALLCONV void	Perl_cx_dump(pTHX_ PERL_CONTEXT* cx)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CX_DUMP	\
	assert(cx)

PERL_CALLCONV SV*	Perl_filter_add(pTHX_ filter_t funcp, SV* datasv);
PERL_CALLCONV void	Perl_filter_del(pTHX_ filter_t funcp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FILTER_DEL	\
	assert(funcp)

PERL_CALLCONV I32	Perl_filter_read(pTHX_ int idx, SV *buf_sv, int maxlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_FILTER_READ	\
	assert(buf_sv)

PERL_CALLCONV char**	Perl_get_op_descs(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV char**	Perl_get_op_names(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV const char*	Perl_get_no_modify(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32*	Perl_get_opargs(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV PPADDR_t*	Perl_get_ppaddr(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV I32	Perl_cxinc(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_deb(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DEB	\
	assert(pat)

PERL_CALLCONV void	Perl_vdeb(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VDEB	\
	assert(pat)

PERL_CALLCONV void	Perl_debprofdump(pTHX);
PERL_CALLCONV I32	Perl_debop(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DEBOP	\
	assert(o)

PERL_CALLCONV I32	Perl_debstack(pTHX);
PERL_CALLCONV I32	Perl_debstackptrs(pTHX);
PERL_CALLCONV char*	Perl_delimcpy(char* to, const char* toend, const char* from, const char* fromend, int delim, I32* retlen)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4)
			__attribute__nonnull__(6);
#define PERL_ARGS_ASSERT_DELIMCPY	\
	assert(to); assert(toend); assert(from); assert(fromend); assert(retlen)

PERL_CALLCONV void	Perl_delete_eval_scope(pTHX);
PERL_CALLCONV OP*	Perl_die_sv(pTHX_ SV *baseex)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DIE_SV	\
	assert(baseex)

PERL_CALLCONV OP*	Perl_die(pTHX_ const char* pat, ...)
			__attribute__format__null_ok__(__printf__,pTHX_1,pTHX_2);

PERL_CALLCONV void	Perl_die_unwind(pTHX_ SV* msv)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DIE_UNWIND	\
	assert(msv)

PERL_CALLCONV void	Perl_dounwind(pTHX_ I32 cxix);
/* PERL_CALLCONV bool	Perl_do_aexec(pTHX_ SV* really, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3); */
#define PERL_ARGS_ASSERT_DO_AEXEC	\
	assert(mark); assert(sp)

PERL_CALLCONV bool	Perl_do_aexec5(pTHX_ SV* really, SV** mark, SV** sp, int fd, int do_report)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_AEXEC5	\
	assert(mark); assert(sp)

PERL_CALLCONV int	Perl_do_binmode(pTHX_ PerlIO *fp, int iotype, int mode)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_BINMODE	\
	assert(fp)

PERL_CALLCONV void	Perl_do_chop(pTHX_ SV *astr, SV *sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_CHOP	\
	assert(astr); assert(sv)

PERL_CALLCONV bool	Perl_do_close(pTHX_ GV* gv, bool not_implicit);
PERL_CALLCONV bool	Perl_do_eof(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_EOF	\
	assert(gv)


#ifdef PERL_DEFAULT_DO_EXEC3_IMPLEMENTATION
/* PERL_CALLCONV bool	Perl_do_exec(pTHX_ const char* cmd)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_DO_EXEC	\
	assert(cmd)

#else
PERL_CALLCONV bool	Perl_do_exec(pTHX_ const char* cmd)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_EXEC	\
	assert(cmd)

#endif

#if defined(WIN32) || defined(__SYMBIAN32__) || defined(VMS)
PERL_CALLCONV int	Perl_do_aspawn(pTHX_ SV* really, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_ASPAWN	\
	assert(mark); assert(sp)

PERL_CALLCONV int	Perl_do_spawn(pTHX_ char* cmd)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_SPAWN	\
	assert(cmd)

PERL_CALLCONV int	Perl_do_spawn_nowait(pTHX_ char* cmd)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_SPAWN_NOWAIT	\
	assert(cmd)

#endif
#if !defined(WIN32)
PERL_CALLCONV bool	Perl_do_exec3(pTHX_ const char *incmd, int fd, int do_report)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_EXEC3	\
	assert(incmd)

#endif
PERL_CALLCONV void	Perl_do_execfree(pTHX);
#if defined(PERL_IN_DOIO_C) || defined(PERL_DECL_PROT)
STATIC void	S_exec_failed(pTHX_ const char *cmd, int fd, int do_report)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_EXEC_FAILED	\
	assert(cmd)

#endif
#if defined(HAS_MSG) || defined(HAS_SEM) || defined(HAS_SHM)
PERL_CALLCONV I32	Perl_do_ipcctl(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_IPCCTL	\
	assert(mark); assert(sp)

PERL_CALLCONV I32	Perl_do_ipcget(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_IPCGET	\
	assert(mark); assert(sp)

PERL_CALLCONV I32	Perl_do_msgrcv(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_MSGRCV	\
	assert(mark); assert(sp)

PERL_CALLCONV I32	Perl_do_msgsnd(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_MSGSND	\
	assert(mark); assert(sp)

PERL_CALLCONV I32	Perl_do_semop(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_SEMOP	\
	assert(mark); assert(sp)

PERL_CALLCONV I32	Perl_do_shmio(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_SHMIO	\
	assert(mark); assert(sp)

#endif
PERL_CALLCONV void	Perl_do_join(pTHX_ SV *sv, SV *delim, SV **mark, SV **sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_DO_JOIN	\
	assert(sv); assert(delim); assert(mark); assert(sp)

PERL_CALLCONV OP*	Perl_do_kv(pTHX);
/* PERL_CALLCONV bool	Perl_do_open(pTHX_ GV* gv, const char* name, I32 len, int as_raw, int rawmode, int rawperm, PerlIO* supplied_fp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_DO_OPEN	\
	assert(gv); assert(name)

PERL_CALLCONV bool	Perl_do_open9(pTHX_ GV *gv, const char *name, I32 len, int as_raw, int rawmode, int rawperm, PerlIO *supplied_fp, SV *svs, I32 num)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_8);
#define PERL_ARGS_ASSERT_DO_OPEN9	\
	assert(gv); assert(name); assert(svs)

PERL_CALLCONV bool	Perl_do_openn(pTHX_ GV *gv, const char *oname, I32 len, int as_raw, int rawmode, int rawperm, PerlIO *supplied_fp, SV **svp, I32 num)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_OPENN	\
	assert(gv); assert(oname)

PERL_CALLCONV bool	Perl_do_print(pTHX_ SV* sv, PerlIO* fp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_PRINT	\
	assert(fp)

PERL_CALLCONV OP*	Perl_do_readline(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_do_chomp(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_CHOMP	\
	assert(sv)

PERL_CALLCONV bool	Perl_do_seek(pTHX_ GV* gv, Off_t pos, int whence);
PERL_CALLCONV void	Perl_do_sprintf(pTHX_ SV* sv, I32 len, SV** sarg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_SPRINTF	\
	assert(sv); assert(sarg)

PERL_CALLCONV Off_t	Perl_do_sysseek(pTHX_ GV* gv, Off_t pos, int whence)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_SYSSEEK	\
	assert(gv)

PERL_CALLCONV Off_t	Perl_do_tell(pTHX_ GV* gv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TELL	\
	assert(gv)

PERL_CALLCONV I32	Perl_do_trans(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS	\
	assert(sv)

PERL_CALLCONV UV	Perl_do_vecget(pTHX_ SV* sv, I32 offset, I32 size)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_VECGET	\
	assert(sv)

PERL_CALLCONV void	Perl_do_vecset(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_VECSET	\
	assert(sv)

PERL_CALLCONV void	Perl_do_vop(pTHX_ I32 optype, SV* sv, SV* left, SV* right)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_DO_VOP	\
	assert(sv); assert(left); assert(right)

PERL_CALLCONV OP*	Perl_dofile(pTHX_ OP* term, I32 force_builtin)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOFILE	\
	assert(term)

PERL_CALLCONV I32	Perl_dowantarray(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_dump_all(pTHX);
PERL_CALLCONV void	Perl_dump_all_perl(pTHX_ bool justperl);
PERL_CALLCONV void	Perl_dump_eval(pTHX);
#if defined(DUMP_FDS)
PERL_CALLCONV void	Perl_dump_fds(pTHX_ char* s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_FDS	\
	assert(s)

#endif
PERL_CALLCONV void	Perl_dump_form(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_FORM	\
	assert(gv)

PERL_CALLCONV void	Perl_gv_dump(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_DUMP	\
	assert(gv)

PERL_CALLCONV void	Perl_op_dump(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OP_DUMP	\
	assert(o)

PERL_CALLCONV void	Perl_pmop_dump(pTHX_ PMOP* pm);
PERL_CALLCONV void	Perl_dump_packsubs(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_PACKSUBS	\
	assert(stash)

PERL_CALLCONV void	Perl_dump_packsubs_perl(pTHX_ const HV* stash, bool justperl)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_PACKSUBS_PERL	\
	assert(stash)

PERL_CALLCONV void	Perl_dump_sub(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_SUB	\
	assert(gv)

PERL_CALLCONV void	Perl_dump_sub_perl(pTHX_ const GV* gv, bool justperl)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_SUB_PERL	\
	assert(gv)

PERL_CALLCONV void	Perl_fbm_compile(pTHX_ SV* sv, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FBM_COMPILE	\
	assert(sv)

PERL_CALLCONV char*	Perl_fbm_instr(pTHX_ unsigned char* big, unsigned char* bigend, SV* littlestr, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_FBM_INSTR	\
	assert(big); assert(bigend); assert(littlestr)

PERL_CALLCONV char*	Perl_find_script(pTHX_ const char *scriptname, bool dosearch, const char *const *const search_ext, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FIND_SCRIPT	\
	assert(scriptname)

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_force_list(pTHX_ OP* arg);
STATIC OP*	S_fold_constants(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FOLD_CONSTANTS	\
	assert(o)

#endif
PERL_CALLCONV char*	Perl_form(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORM	\
	assert(pat)

PERL_CALLCONV char*	Perl_vform(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VFORM	\
	assert(pat)

PERL_CALLCONV void	Perl_free_tmps(pTHX);
#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_gen_constant_list(pTHX_ OP* o);
#endif
#if !defined(HAS_GETENV_LEN)
PERL_CALLCONV char*	Perl_getenv_len(pTHX_ const char *env_elem, unsigned long *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GETENV_LEN	\
	assert(env_elem); assert(len)

#endif
PERL_CALLCONV void	Perl_get_db_sub(pTHX_ SV **svp, CV *cv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GET_DB_SUB	\
	assert(cv)

PERL_CALLCONV void	Perl_gp_free(pTHX_ GV* gv);
PERL_CALLCONV GP*	Perl_gp_ref(pTHX_ GP* gp);
PERL_CALLCONV GV*	Perl_gv_add_by_type(pTHX_ GV *gv, svtype type);
/* PERL_CALLCONV GV*	Perl_gv_AVadd(pTHX_ GV *gv); */
/* PERL_CALLCONV GV*	Perl_gv_HVadd(pTHX_ GV *gv); */
/* PERL_CALLCONV GV*	Perl_gv_IOadd(pTHX_ GV* gv); */
PERL_CALLCONV GV*	Perl_gv_autoload4(pTHX_ HV* stash, const char* name, STRLEN len, I32 method)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_AUTOLOAD4	\
	assert(name)

PERL_CALLCONV void	Perl_gv_check(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_CHECK	\
	assert(stash)

PERL_CALLCONV void	Perl_gv_efullname(pTHX_ SV* sv, const GV* gv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_EFULLNAME	\
	assert(sv); assert(gv)

/* PERL_CALLCONV void	Perl_gv_efullname3(pTHX_ SV* sv, const GV* gv, const char* prefix)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_GV_EFULLNAME3	\
	assert(sv); assert(gv)

PERL_CALLCONV void	Perl_gv_efullname4(pTHX_ SV* sv, const GV* gv, const char* prefix, bool keepmain)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_EFULLNAME4	\
	assert(sv); assert(gv)

PERL_CALLCONV GV*	Perl_gv_fetchfile(pTHX_ const char* name)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_FETCHFILE	\
	assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchfile_flags(pTHX_ const char *const name, const STRLEN len, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_FETCHFILE_FLAGS	\
	assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchmeth(pTHX_ HV* stash, const char* name, STRLEN len, I32 level)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FETCHMETH	\
	assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchmeth_autoload(pTHX_ HV* stash, const char* name, STRLEN len, I32 level)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FETCHMETH_AUTOLOAD	\
	assert(name)

/* PERL_CALLCONV GV*	Perl_gv_fetchmethod(pTHX_ HV* stash, const char* name)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_GV_FETCHMETHOD	\
	assert(stash); assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchmethod_autoload(pTHX_ HV* stash, const char* name, I32 autoload)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FETCHMETHOD_AUTOLOAD	\
	assert(stash); assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchmethod_flags(pTHX_ HV* stash, const char* name, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FETCHMETHOD_FLAGS	\
	assert(stash); assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchpv(pTHX_ const char *nambeg, I32 add, const svtype sv_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_FETCHPV	\
	assert(nambeg)

PERL_CALLCONV void	Perl_gv_fullname(pTHX_ SV* sv, const GV* gv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FULLNAME	\
	assert(sv); assert(gv)

/* PERL_CALLCONV void	Perl_gv_fullname3(pTHX_ SV* sv, const GV* gv, const char* prefix)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_GV_FULLNAME3	\
	assert(sv); assert(gv)

PERL_CALLCONV void	Perl_gv_fullname4(pTHX_ SV* sv, const GV* gv, const char* prefix, bool keepmain)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_FULLNAME4	\
	assert(sv); assert(gv)

PERL_CALLCONV GP *	Perl_newGP(pTHX_ GV *const gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWGP	\
	assert(gv)

PERL_CALLCONV void	Perl_gv_init(pTHX_ GV* gv, HV* stash, const char* name, STRLEN len, int multi)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_GV_INIT	\
	assert(gv); assert(name)

PERL_CALLCONV void	Perl_gv_name_set(pTHX_ GV* gv, const char *name, U32 len, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GV_NAME_SET	\
	assert(gv); assert(name)

PERL_CALLCONV void	Perl_gv_try_downgrade(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_TRY_DOWNGRADE	\
	assert(gv)

PERL_CALLCONV HV*	Perl_gv_stashpv(pTHX_ const char* name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_STASHPV	\
	assert(name)

PERL_CALLCONV HV*	Perl_gv_stashpvn(pTHX_ const char* name, U32 namelen, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_STASHPVN	\
	assert(name)

PERL_CALLCONV HV*	Perl_gv_stashsv(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_STASHSV	\
	assert(sv)

PERL_CALLCONV void	Perl_hv_clear(pTHX_ HV *hv);
PERL_CALLCONV HV *	Perl_hv_copy_hints_hv(pTHX_ HV *const ohv);
PERL_CALLCONV void	Perl_hv_delayfree_ent(pTHX_ HV *hv, HE *entry)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_DELAYFREE_ENT	\
	assert(hv)

/* PERL_CALLCONV SV*	Perl_hv_delete(pTHX_ HV *hv, const char *key, I32 klen, I32 flags)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_DELETE	\
	assert(key)

/* PERL_CALLCONV SV*	Perl_hv_delete_ent(pTHX_ HV *hv, SV *keysv, I32 flags, U32 hash)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_DELETE_ENT	\
	assert(keysv)

/* PERL_CALLCONV bool	Perl_hv_exists(pTHX_ HV *hv, const char *key, I32 klen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_EXISTS	\
	assert(key)

/* PERL_CALLCONV bool	Perl_hv_exists_ent(pTHX_ HV *hv, SV *keysv, U32 hash)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_EXISTS_ENT	\
	assert(keysv)

/* PERL_CALLCONV SV**	Perl_hv_fetch(pTHX_ HV *hv, const char *key, I32 klen, I32 lval)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_FETCH	\
	assert(key)

/* PERL_CALLCONV HE*	Perl_hv_fetch_ent(pTHX_ HV *hv, SV *keysv, I32 lval, U32 hash)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_HV_FETCH_ENT	\
	assert(keysv)

PERL_CALLCONV void*	Perl_hv_common(pTHX_ HV *hv, SV *keysv, const char* key, STRLEN klen, int flags, int action, SV *val, U32 hash);
PERL_CALLCONV void*	Perl_hv_common_key_len(pTHX_ HV *hv, const char *key, I32 klen_i32, const int action, SV *val, const U32 hash)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_HV_COMMON_KEY_LEN	\
	assert(key)

PERL_CALLCONV STRLEN	Perl_hv_fill(pTHX_ HV const *const hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_FILL	\
	assert(hv)

PERL_CALLCONV void	Perl_hv_free_ent(pTHX_ HV *hv, HE *entryK)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_FREE_ENT	\
	assert(hv)

PERL_CALLCONV I32	Perl_hv_iterinit(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_ITERINIT	\
	assert(hv)

PERL_CALLCONV char*	Perl_hv_iterkey(pTHX_ HE* entry, I32* retlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_HV_ITERKEY	\
	assert(entry); assert(retlen)

PERL_CALLCONV SV*	Perl_hv_iterkeysv(pTHX_ HE* entry)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_ITERKEYSV	\
	assert(entry)

/* PERL_CALLCONV HE*	Perl_hv_iternext(pTHX_ HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_HV_ITERNEXT	\
	assert(hv)

PERL_CALLCONV SV*	Perl_hv_iternextsv(pTHX_ HV *hv, char **key, I32 *retlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_HV_ITERNEXTSV	\
	assert(hv); assert(key); assert(retlen)

PERL_CALLCONV HE*	Perl_hv_iternext_flags(pTHX_ HV *hv, I32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_ITERNEXT_FLAGS	\
	assert(hv)

PERL_CALLCONV SV*	Perl_hv_iterval(pTHX_ HV *hv, HE *entry)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_HV_ITERVAL	\
	assert(hv); assert(entry)

PERL_CALLCONV void	Perl_hv_ksplit(pTHX_ HV *hv, IV newmax)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_KSPLIT	\
	assert(hv)

/* PERL_CALLCONV void	Perl_hv_magic(pTHX_ HV *hv, GV *gv, int how)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_HV_MAGIC	\
	assert(hv)

PERL_CALLCONV HV *	Perl_refcounted_he_chain_2hv(pTHX_ const struct refcounted_he *c);
PERL_CALLCONV SV *	Perl_refcounted_he_fetch(pTHX_ const struct refcounted_he *chain, SV *keysv, const char *key, STRLEN klen, int flags, U32 hash);
PERL_CALLCONV void	Perl_refcounted_he_free(pTHX_ struct refcounted_he *he);
PERL_CALLCONV struct refcounted_he *	Perl_refcounted_he_new(pTHX_ struct refcounted_he *const parent, SV *const key, SV *const value);
#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
STATIC struct refcounted_he *	S_refcounted_he_new_common(pTHX_ struct refcounted_he *const parent, const char *const key_p, const STRLEN key_len, const char flags, char value_type, const void *value, const STRLEN value_len)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_REFCOUNTED_HE_NEW_COMMON	\
	assert(key_p); assert(value)

#endif
/* PERL_CALLCONV SV**	Perl_hv_store(pTHX_ HV *hv, const char *key, I32 klen, SV *val, U32 hash); */
/* PERL_CALLCONV HE*	Perl_hv_store_ent(pTHX_ HV *hv, SV *key, SV *val, U32 hash); */
/* PERL_CALLCONV SV**	Perl_hv_store_flags(pTHX_ HV *hv, const char *key, I32 klen, SV *val, U32 hash, int flags); */
PERL_CALLCONV void	Perl_hv_undef(pTHX_ HV *hv);
/* PERL_CALLCONV I32	ibcmp(pTHX_ const char* a, const char* b, I32 len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

PERL_CALLCONV I32	Perl_foldEQ(const char* a, const char* b, I32 len)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_FOLDEQ	\
	assert(a); assert(b)

/* PERL_CALLCONV I32	ibcmp_locale(pTHX_ const char* a, const char* b, I32 len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

PERL_CALLCONV I32	Perl_foldEQ_locale(const char* a, const char* b, I32 len)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_FOLDEQ_LOCALE	\
	assert(a); assert(b)

/* PERL_CALLCONV I32	ibcmp_utf8(pTHX_ const char *s1, char **pe1, UV l1, bool u1, const char *s2, char **pe2, UV l2, bool u2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_5); */

PERL_CALLCONV I32	Perl_foldEQ_utf8(pTHX_ const char *s1, char **pe1, UV l1, bool u1, const char *s2, char **pe2, UV l2, bool u2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_FOLDEQ_UTF8	\
	assert(s1); assert(s2)

#if defined(PERL_IN_DOIO_C) || defined(PERL_DECL_PROT)
STATIC bool	S_ingroup(pTHX_ Gid_t testgid, bool effective)
			__attribute__warn_unused_result__;

#endif
PERL_CALLCONV void	Perl_init_argv_symbols(pTHX_ int argc, char **argv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_INIT_ARGV_SYMBOLS	\
	assert(argv)

PERL_CALLCONV void	Perl_init_debugger(pTHX);
PERL_CALLCONV void	Perl_init_stacks(pTHX);
PERL_CALLCONV void	Perl_init_tm(pTHX_ struct tm *ptm)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INIT_TM	\
	assert(ptm)

PERL_CALLCONV U32	Perl_intro_my(pTHX);
PERL_CALLCONV char*	Perl_instr(const char* big, const char* little)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_INSTR	\
	assert(big); assert(little)

PERL_CALLCONV bool	Perl_io_close(pTHX_ IO* io, bool not_implicit)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IO_CLOSE	\
	assert(io)

PERL_CALLCONV OP*	Perl_invert(pTHX_ OP* cmd)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_is_lvalue_sub(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV U32	Perl_to_uni_upper_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32	Perl_to_uni_title_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32	Perl_to_uni_lower_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alnum(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_idfirst(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alpha(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_ascii(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_space(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_cntrl(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_graph(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_digit(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_upper(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_lower(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_print(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_punct(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_xdigit(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV UV	Perl_to_uni_upper(pTHX_ UV c, U8 *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_TO_UNI_UPPER	\
	assert(p); assert(lenp)

PERL_CALLCONV UV	Perl_to_uni_title(pTHX_ UV c, U8 *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_TO_UNI_TITLE	\
	assert(p); assert(lenp)

PERL_CALLCONV UV	Perl_to_uni_lower(pTHX_ UV c, U8 *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_TO_UNI_LOWER	\
	assert(p); assert(lenp)

PERL_CALLCONV UV	Perl_to_uni_fold(pTHX_ UV c, U8 *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_TO_UNI_FOLD	\
	assert(p); assert(lenp)

PERL_CALLCONV bool	Perl_is_uni_alnum_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_idfirst_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alpha_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_ascii_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_space_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_cntrl_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_graph_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_digit_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_upper_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_lower_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_print_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_punct_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_xdigit_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_ascii_string(const U8 *s, STRLEN len)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_ASCII_STRING	\
	assert(s)

PERL_CALLCONV STRLEN	Perl_is_utf8_char(const U8 *s)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_UTF8_CHAR	\
	assert(s)

PERL_CALLCONV bool	Perl_is_utf8_string(const U8 *s, STRLEN len)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_UTF8_STRING	\
	assert(s)

/* PERL_CALLCONV bool	Perl_is_utf8_string_loc(const U8 *s, STRLEN len, const U8 **p)
			__attribute__nonnull__(1); */
#define PERL_ARGS_ASSERT_IS_UTF8_STRING_LOC	\
	assert(s)

PERL_CALLCONV bool	Perl_is_utf8_string_loclen(const U8 *s, STRLEN len, const U8 **ep, STRLEN *el)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_UTF8_STRING_LOCLEN	\
	assert(s)

PERL_CALLCONV bool	Perl_is_utf8_alnum(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_ALNUM	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_idfirst(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_IDFIRST	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_idcont(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_IDCONT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_alpha(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_ALPHA	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_ascii(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_ASCII	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_space(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_SPACE	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_perl_space(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_PERL_SPACE	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_perl_word(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_PERL_WORD	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_cntrl(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_CNTRL	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_digit(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_DIGIT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_posix_digit(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_POSIX_DIGIT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_graph(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_GRAPH	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_upper(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_UPPER	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_lower(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_LOWER	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_print(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_PRINT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_punct(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_PUNCT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_xdigit(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_XDIGIT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_mark(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_MARK	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_begin(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_BEGIN	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_extend(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_EXTEND	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_prepend(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_PREPEND	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_non_hangul(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_NON_HANGUL	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_L(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_L	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_LV(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_LV	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_LVT(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_LVT	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_LV_LVT_V(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_LV_LVT_V	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_T(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_T	\
	assert(p)

PERL_CALLCONV bool	Perl_is_utf8_X_V(pTHX_ const U8 *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_UTF8_X_V	\
	assert(p)

PERL_CALLCONV OP*	Perl_jmaybe(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_JMAYBE	\
	assert(o)

PERL_CALLCONV I32	Perl_keyword(pTHX_ const char *name, I32 len, bool all_keywords)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_KEYWORD	\
	assert(name)

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_opt_scalarhv(pTHX_ OP* rep_op)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OPT_SCALARHV	\
	assert(rep_op)

STATIC OP*	S_is_inplace_av(pTHX_ OP* o, OP* oright)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_INPLACE_AV	\
	assert(o)

#endif
PERL_CALLCONV void	Perl_leave_scope(pTHX_ I32 base);
PERL_CALLCONV void	Perl_lex_end(pTHX);
PERL_CALLCONV void	Perl_lex_start(pTHX_ SV* line, PerlIO *rsfp, bool new_filter);
PERL_CALLCONV bool	Perl_lex_bufutf8(pTHX);
PERL_CALLCONV char*	Perl_lex_grow_linestr(pTHX_ STRLEN len);
PERL_CALLCONV void	Perl_lex_stuff_pvn(pTHX_ const char* pv, STRLEN len, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LEX_STUFF_PVN	\
	assert(pv)

PERL_CALLCONV void	Perl_lex_stuff_sv(pTHX_ SV* sv, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LEX_STUFF_SV	\
	assert(sv)

PERL_CALLCONV void	Perl_lex_unstuff(pTHX_ char* ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LEX_UNSTUFF	\
	assert(ptr)

PERL_CALLCONV void	Perl_lex_read_to(pTHX_ char* ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LEX_READ_TO	\
	assert(ptr)

PERL_CALLCONV void	Perl_lex_discard_to(pTHX_ char* ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LEX_DISCARD_TO	\
	assert(ptr)

PERL_CALLCONV bool	Perl_lex_next_chunk(pTHX_ U32 flags);
PERL_CALLCONV I32	Perl_lex_peek_unichar(pTHX_ U32 flags);
PERL_CALLCONV I32	Perl_lex_read_unichar(pTHX_ U32 flags);
PERL_CALLCONV void	Perl_lex_read_space(pTHX_ U32 flags);
PERL_CALLCONV void	Perl_op_null(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OP_NULL	\
	assert(o)

PERL_CALLCONV void	Perl_op_clear(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OP_CLEAR	\
	assert(o)

PERL_CALLCONV void	Perl_op_refcnt_lock(pTHX);
PERL_CALLCONV void	Perl_op_refcnt_unlock(pTHX);
#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_linklist(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LINKLIST	\
	assert(o)

STATIC OP*	S_listkids(pTHX_ OP* o);
#endif
PERL_CALLCONV OP*	Perl_list(pTHX_ OP* o);
PERL_CALLCONV void	Perl_load_module(pTHX_ U32 flags, SV* name, SV* ver, ...)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_LOAD_MODULE	\
	assert(name)

PERL_CALLCONV void	Perl_vload_module(pTHX_ U32 flags, SV* name, SV* ver, va_list* args)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_VLOAD_MODULE	\
	assert(name)

PERL_CALLCONV OP*	Perl_localize(pTHX_ OP *o, I32 lex)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LOCALIZE	\
	assert(o)

PERL_CALLCONV I32	Perl_looks_like_number(pTHX_ SV *const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LOOKS_LIKE_NUMBER	\
	assert(sv)

PERL_CALLCONV UV	Perl_grok_bin(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_GROK_BIN	\
	assert(start); assert(len_p); assert(flags)

PERL_CALLCONV char	Perl_grok_bslash_c(pTHX_ const char source, const bool output_warning)
			__attribute__warn_unused_result__;

PERL_CALLCONV UV	Perl_grok_hex(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_GROK_HEX	\
	assert(start); assert(len_p); assert(flags)

PERL_CALLCONV int	Perl_grok_number(pTHX_ const char *pv, STRLEN len, UV *valuep)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GROK_NUMBER	\
	assert(pv)

PERL_CALLCONV bool	Perl_grok_numeric_radix(pTHX_ const char **sp, const char *send)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GROK_NUMERIC_RADIX	\
	assert(sp); assert(send)

PERL_CALLCONV UV	Perl_grok_oct(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_GROK_OCT	\
	assert(start); assert(len_p); assert(flags)

PERL_CALLCONV int	Perl_magic_clearenv(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARENV	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_clear_all_env(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEAR_ALL_ENV	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_clearhint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARHINT	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_clearhints(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARHINTS	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_clearisa(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARISA	\
	assert(mg)

PERL_CALLCONV int	Perl_magic_clearpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_clearsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_CLEARSIG	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_existspack(pTHX_ SV* sv, const MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_EXISTSPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_freeovrld(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_FREEOVRLD	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_get(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GET	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getarylen(pTHX_ SV* sv, const MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETARYLEN	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getdefelem(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETDEFELEM	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getnkeys(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETNKEYS	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getpos(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETPOS	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETSIG	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getsubstr(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETSUBSTR	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_gettaint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETTAINT	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getuvar(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETUVAR	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_getvec(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_GETVEC	\
	assert(sv); assert(mg)

PERL_CALLCONV U32	Perl_magic_len(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_LEN	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_nextpack(pTHX_ SV *sv, MAGIC *mg, SV *key)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MAGIC_NEXTPACK	\
	assert(sv); assert(mg); assert(key)

PERL_CALLCONV U32	Perl_magic_regdata_cnt(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_REGDATA_CNT	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_regdatum_get(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_REGDATUM_GET	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_regdatum_set(pTHX_ SV* sv, MAGIC* mg)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_REGDATUM_SET	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_set(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SET	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setamagic(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETAMAGIC	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setarylen(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETARYLEN	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_freearylen_p(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_FREEARYLEN_P	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setdbline(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETDBLINE	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setdefelem(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETDEFELEM	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setenv(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETENV	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_sethint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETHINT	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setisa(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETISA	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setmglob(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETMGLOB	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setnkeys(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETNKEYS	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setpos(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETPOS	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setregexp(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETREGEXP	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETSIG	\
	assert(mg)

PERL_CALLCONV int	Perl_magic_setsubstr(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETSUBSTR	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_settaint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETTAINT	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setuvar(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETUVAR	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setvec(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETVEC	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_setutf8(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETUTF8	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_set_all_env(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SET_ALL_ENV	\
	assert(sv); assert(mg)

PERL_CALLCONV U32	Perl_magic_sizepack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SIZEPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV int	Perl_magic_wipepack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_WIPEPACK	\
	assert(sv); assert(mg)

PERL_CALLCONV SV*	Perl_magic_methcall(pTHX_ SV *sv, const MAGIC *mg, const char *meth, U32 flags, U32 argc, ...)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MAGIC_METHCALL	\
	assert(sv); assert(mg); assert(meth)

PERL_CALLCONV void	Perl_markstack_grow(pTHX);
#if defined(USE_LOCALE_COLLATE)
PERL_CALLCONV int	Perl_magic_setcollxfrm(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SETCOLLXFRM	\
	assert(sv); assert(mg)

PERL_CALLCONV char*	Perl_mem_collxfrm(pTHX_ const char* s, STRLEN len, STRLEN* xlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MEM_COLLXFRM	\
	assert(s); assert(xlen)

#endif
PERL_CALLCONV SV*	Perl_mess(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MESS	\
	assert(pat)

PERL_CALLCONV SV*	Perl_mess_sv(pTHX_ SV* basemsg, bool consume)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MESS_SV	\
	assert(basemsg)

PERL_CALLCONV SV*	Perl_vmess(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VMESS	\
	assert(pat)

PERL_CALLCONV void	Perl_qerror(pTHX_ SV* err)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_QERROR	\
	assert(err)

PERL_CALLCONV void	Perl_sortsv(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t cmp)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SORTSV	\
	assert(cmp)

PERL_CALLCONV void	Perl_sortsv_flags(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t cmp, U32 flags)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SORTSV_FLAGS	\
	assert(cmp)

PERL_CALLCONV int	Perl_mg_clear(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_CLEAR	\
	assert(sv)

PERL_CALLCONV int	Perl_mg_copy(pTHX_ SV *sv, SV *nsv, const char *key, I32 klen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MG_COPY	\
	assert(sv); assert(nsv)

PERL_CALLCONV void	Perl_mg_localize(pTHX_ SV* sv, SV* nsv, bool setmagic)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MG_LOCALIZE	\
	assert(sv); assert(nsv)

PERL_CALLCONV MAGIC*	Perl_mg_find(pTHX_ const SV* sv, int type)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_mg_free(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_FREE	\
	assert(sv)

PERL_CALLCONV int	Perl_mg_get(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_GET	\
	assert(sv)

PERL_CALLCONV U32	Perl_mg_length(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_LENGTH	\
	assert(sv)

PERL_CALLCONV void	Perl_mg_magical(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_MAGICAL	\
	assert(sv)

PERL_CALLCONV int	Perl_mg_set(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_SET	\
	assert(sv)

PERL_CALLCONV I32	Perl_mg_size(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MG_SIZE	\
	assert(sv)

PERL_CALLCONV void	Perl_mini_mktime(pTHX_ struct tm *ptm)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MINI_MKTIME	\
	assert(ptm)

PERL_CALLCONV OP*	Perl_mod(pTHX_ OP* o, I32 type);
PERL_CALLCONV int	Perl_mode_from_discipline(pTHX_ const char* s, STRLEN len);
PERL_CALLCONV const char*	Perl_moreswitches(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MORESWITCHES	\
	assert(s)

PERL_CALLCONV NV	Perl_my_atof(pTHX_ const char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_ATOF	\
	assert(s)

#if (!defined(HAS_MEMCPY) && !defined(HAS_BCOPY)) || (!defined(HAS_MEMMOVE) && !defined(HAS_SAFE_MEMCPY) && !defined(HAS_SAFE_BCOPY))
PERL_CALLCONV char*	Perl_my_bcopy(const char* from, char* to, I32 len)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_MY_BCOPY	\
	assert(from); assert(to)

#endif
#if !defined(HAS_BZERO) && !defined(HAS_MEMSET)
PERL_CALLCONV char*	Perl_my_bzero(char* loc, I32 len)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_MY_BZERO	\
	assert(loc)

#endif
PERL_CALLCONV void	Perl_my_exit(pTHX_ U32 status)
			__attribute__noreturn__;

PERL_CALLCONV void	Perl_my_failure_exit(pTHX)
			__attribute__noreturn__;

PERL_CALLCONV I32	Perl_my_fflush_all(pTHX);
PERL_CALLCONV Pid_t	Perl_my_fork(void);
PERL_CALLCONV void	Perl_atfork_lock(void);
PERL_CALLCONV void	Perl_atfork_unlock(void);
PERL_CALLCONV I32	Perl_my_lstat(pTHX);
#if !defined(HAS_MEMCMP) || !defined(HAS_SANE_MEMCMP)
PERL_CALLCONV I32	Perl_my_memcmp(const char* s1, const char* s2, I32 len)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_MY_MEMCMP	\
	assert(s1); assert(s2)

#endif
#if !defined(HAS_MEMSET)
PERL_CALLCONV void*	Perl_my_memset(char* loc, I32 ch, I32 len)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_MY_MEMSET	\
	assert(loc)

#endif
PERL_CALLCONV I32	Perl_my_pclose(pTHX_ PerlIO* ptr);
PERL_CALLCONV PerlIO*	Perl_my_popen(pTHX_ const char* cmd, const char* mode)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MY_POPEN	\
	assert(cmd); assert(mode)

PERL_CALLCONV PerlIO*	Perl_my_popen_list(pTHX_ const char* mode, int n, SV ** args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MY_POPEN_LIST	\
	assert(mode); assert(args)

PERL_CALLCONV void	Perl_my_setenv(pTHX_ const char* nam, const char* val);
PERL_CALLCONV I32	Perl_my_stat(pTHX);
PERL_CALLCONV char *	Perl_my_strftime(pTHX_ const char *fmt, int sec, int min, int hour, int mday, int mon, int year, int wday, int yday, int isdst)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_STRFTIME	\
	assert(fmt)

#if defined(MYSWAP)
PERL_CALLCONV short	Perl_my_swap(pTHX_ short s)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV long	Perl_my_htonl(pTHX_ long l)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV long	Perl_my_ntohl(pTHX_ long l)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

#endif
PERL_CALLCONV void	Perl_my_unexec(pTHX);
PERL_CALLCONV OP*	Perl_newANONLIST(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newANONHASH(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newANONSUB(pTHX_ I32 floor, OP* proto, OP* block);
PERL_CALLCONV OP*	Perl_newASSIGNOP(pTHX_ I32 flags, OP* left, I32 optype, OP* right)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newCONDOP(pTHX_ I32 flags, OP* first, OP* trueop, OP* falseop)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWCONDOP	\
	assert(first)

PERL_CALLCONV CV*	Perl_newCONSTSUB(pTHX_ HV* stash, const char* name, SV* sv);
#ifdef PERL_MAD
PERL_CALLCONV OP*	Perl_newFORM(pTHX_ I32 floor, OP* o, OP* block);
#else
PERL_CALLCONV void	Perl_newFORM(pTHX_ I32 floor, OP* o, OP* block);
#endif
PERL_CALLCONV OP*	Perl_newFOROP(pTHX_ I32 flags, char* label, line_t forline, OP* sv, OP* expr, OP* block, OP* cont)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_NEWFOROP	\
	assert(expr)

PERL_CALLCONV OP*	Perl_newGIVENOP(pTHX_ OP* cond, OP* block, PADOFFSET defsv_off)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWGIVENOP	\
	assert(cond); assert(block)

PERL_CALLCONV OP*	Perl_newLOGOP(pTHX_ I32 optype, I32 flags, OP *first, OP *other)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_NEWLOGOP	\
	assert(first); assert(other)

PERL_CALLCONV OP*	Perl_newLOOPEX(pTHX_ I32 type, OP* label)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWLOOPEX	\
	assert(label)

PERL_CALLCONV OP*	Perl_newLOOPOP(pTHX_ I32 flags, I32 debuggable, OP* expr, OP* block)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newNULLLIST(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newOP(pTHX_ I32 optype, I32 flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_newPROG(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWPROG	\
	assert(o)

PERL_CALLCONV OP*	Perl_newRANGE(pTHX_ I32 flags, OP* left, OP* right)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWRANGE	\
	assert(left); assert(right)

PERL_CALLCONV OP*	Perl_newSLICEOP(pTHX_ I32 flags, OP* subscript, OP* listop)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newSTATEOP(pTHX_ I32 flags, char* label, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV CV*	Perl_newSUB(pTHX_ I32 floor, OP* o, OP* proto, OP* block);
PERL_CALLCONV CV *	Perl_newXS_flags(pTHX_ const char *name, XSUBADDR_t subaddr, const char *const filename, const char *const proto, U32 flags)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWXS_FLAGS	\
	assert(subaddr); assert(filename)

PERL_CALLCONV CV*	Perl_newXS(pTHX_ const char *name, XSUBADDR_t subaddr, const char *filename)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWXS	\
	assert(subaddr); assert(filename)

/* PERL_CALLCONV AV*	Perl_newAV(pTHX)
			__attribute__warn_unused_result__; */

PERL_CALLCONV OP*	Perl_newAVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWAVREF	\
	assert(o)

PERL_CALLCONV OP*	Perl_newBINOP(pTHX_ I32 type, I32 flags, OP* first, OP* last)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newCVREF(pTHX_ I32 flags, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newGVOP(pTHX_ I32 type, I32 flags, GV* gv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWGVOP	\
	assert(gv)

PERL_CALLCONV GV*	Perl_newGVgen(pTHX_ const char* pack)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWGVGEN	\
	assert(pack)

PERL_CALLCONV OP*	Perl_newGVREF(pTHX_ I32 type, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newHVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWHVREF	\
	assert(o)

/* PERL_CALLCONV HV*	Perl_newHV(pTHX)
			__attribute__warn_unused_result__; */

PERL_CALLCONV HV*	Perl_newHVhv(pTHX_ HV *hv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

/* PERL_CALLCONV IO*	Perl_newIO(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__; */

PERL_CALLCONV OP*	Perl_newLISTOP(pTHX_ I32 type, I32 flags, OP* first, OP* last)
			__attribute__malloc__
			__attribute__warn_unused_result__;

#ifdef USE_ITHREADS
PERL_CALLCONV OP*	Perl_newPADOP(pTHX_ I32 type, I32 flags, SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWPADOP	\
	assert(sv)

#endif
PERL_CALLCONV OP*	Perl_newPMOP(pTHX_ I32 type, I32 flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newPVOP(pTHX_ I32 type, I32 flags, char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newRV(pTHX_ SV *const sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWRV	\
	assert(sv)

PERL_CALLCONV SV*	Perl_newRV_noinc(pTHX_ SV *const sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWRV_NOINC	\
	assert(sv)

PERL_CALLCONV SV*	Perl_newSV(pTHX_ const STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newSVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWSVREF	\
	assert(o)

PERL_CALLCONV OP*	Perl_newSVOP(pTHX_ I32 type, I32 flags, SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_NEWSVOP	\
	assert(sv)

PERL_CALLCONV SV*	Perl_newSViv(pTHX_ const IV i)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVuv(pTHX_ const UV u)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVnv(pTHX_ const NV n)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpv(pTHX_ const char *const s, const STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvn(pTHX_ const char *const s, const STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvn_flags(pTHX_ const char *const s, const STRLEN len, const U32 flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVhek(pTHX_ const HEK *const hek)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvn_share(pTHX_ const char* s, I32 len, U32 hash)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvf(pTHX_ const char *const pat, ...)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWSVPVF	\
	assert(pat)

PERL_CALLCONV SV*	Perl_vnewSVpvf(pTHX_ const char *const pat, va_list *const args)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VNEWSVPVF	\
	assert(pat)

PERL_CALLCONV SV*	Perl_newSVrv(pTHX_ SV *const rv, const char *const classname)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEWSVRV	\
	assert(rv)

PERL_CALLCONV SV*	Perl_newSVsv(pTHX_ SV *const old)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSV_type(pTHX_ const svtype type)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newUNOP(pTHX_ I32 type, I32 flags, OP* first)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newWHENOP(pTHX_ OP* cond, OP* block)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWWHENOP	\
	assert(block)

PERL_CALLCONV OP*	Perl_newWHILEOP(pTHX_ I32 flags, I32 debuggable, LOOP* loop, I32 whileline, OP* expr, OP* block, OP* cont, I32 has_my)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV PERL_SI*	Perl_new_stackinfo(pTHX_ I32 stitems, I32 cxitems)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_scan_vstring(pTHX_ const char *s, const char *const e, SV *sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_VSTRING	\
	assert(s); assert(e); assert(sv)

PERL_CALLCONV const char*	Perl_scan_version(pTHX_ const char *s, SV *rv, bool qv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SCAN_VERSION	\
	assert(s); assert(rv)

PERL_CALLCONV const char*	Perl_prescan_version(pTHX_ const char *s, bool strict, const char** errstr, bool *sqv, int *ssaw_decimal, int *swidth, bool *salpha)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PRESCAN_VERSION	\
	assert(s)

PERL_CALLCONV SV*	Perl_new_version(pTHX_ SV *ver)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEW_VERSION	\
	assert(ver)

PERL_CALLCONV SV*	Perl_upg_version(pTHX_ SV *ver, bool qv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UPG_VERSION	\
	assert(ver)

PERL_CALLCONV bool	Perl_vverify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VVERIFY	\
	assert(vs)

PERL_CALLCONV SV*	Perl_vnumify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VNUMIFY	\
	assert(vs)

PERL_CALLCONV SV*	Perl_vnormal(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VNORMAL	\
	assert(vs)

PERL_CALLCONV SV*	Perl_vstringify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VSTRINGIFY	\
	assert(vs)

PERL_CALLCONV int	Perl_vcmp(pTHX_ SV *lhv, SV *rhv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_VCMP	\
	assert(lhv); assert(rhv)

PERL_CALLCONV PerlIO*	Perl_nextargv(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEXTARGV	\
	assert(gv)

PERL_CALLCONV char*	Perl_ninstr(const char* big, const char* bigend, const char* little, const char* lend)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4);
#define PERL_ARGS_ASSERT_NINSTR	\
	assert(big); assert(bigend); assert(little); assert(lend)

PERL_CALLCONV void	Perl_op_free(pTHX_ OP* arg);
#ifdef PERL_MAD
PERL_CALLCONV OP*	Perl_package(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PACKAGE	\
	assert(o)

#else
PERL_CALLCONV void	Perl_package(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PACKAGE	\
	assert(o)

#endif
PERL_CALLCONV void	Perl_package_version(pTHX_ OP* v)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PACKAGE_VERSION	\
	assert(v)

PERL_CALLCONV PADOFFSET	Perl_pad_alloc(pTHX_ I32 optype, U32 tmptype);
PERL_CALLCONV PADOFFSET	Perl_allocmy(pTHX_ const char *const name, const STRLEN len, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_ALLOCMY	\
	assert(name)

PERL_CALLCONV PADOFFSET	Perl_pad_findmy(pTHX_ const char* name, STRLEN len, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_FINDMY	\
	assert(name)

PERL_CALLCONV PADOFFSET	Perl_find_rundefsvoffset(pTHX)
			__attribute__deprecated__;

PERL_CALLCONV SV*	Perl_find_rundefsv(pTHX);
PERL_CALLCONV OP*	Perl_oopsAV(pTHX_ OP* o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OOPSAV	\
	assert(o)

PERL_CALLCONV OP*	Perl_oopsHV(pTHX_ OP* o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OOPSHV	\
	assert(o)

PERL_CALLCONV void	Perl_pad_leavemy(pTHX);
#ifdef DEBUGGING
PERL_CALLCONV SV*	Perl_pad_sv(pTHX_ PADOFFSET po);
#endif
PERL_CALLCONV void	Perl_pad_free(pTHX_ PADOFFSET po);
#if defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
STATIC void	S_pad_reset(pTHX);
#endif
PERL_CALLCONV void	Perl_pad_swipe(pTHX_ PADOFFSET po, bool refadjust);
PERL_CALLCONV void	Perl_peep(pTHX_ OP* o);
PERL_CALLCONV PerlIO*	Perl_start_glob(pTHX_ SV *tmpglob, IO *io)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_START_GLOB	\
	assert(tmpglob); assert(io)

#if defined(USE_REENTRANT_API)
PERL_CALLCONV void	Perl_reentrant_size(pTHX);
PERL_CALLCONV void	Perl_reentrant_init(pTHX);
PERL_CALLCONV void	Perl_reentrant_free(pTHX);
PERL_CALLCONV void*	Perl_reentrant_retry(const char *f, ...)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_REENTRANT_RETRY	\
	assert(f)

#endif
PERL_CALLCONV void	Perl_call_atexit(pTHX_ ATEXIT_t fn, void *ptr);
PERL_CALLCONV I32	Perl_call_argv(pTHX_ const char* sub_name, I32 flags, char** argv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_CALL_ARGV	\
	assert(sub_name); assert(argv)

PERL_CALLCONV I32	Perl_call_method(pTHX_ const char* methname, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CALL_METHOD	\
	assert(methname)

PERL_CALLCONV I32	Perl_call_pv(pTHX_ const char* sub_name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CALL_PV	\
	assert(sub_name)

PERL_CALLCONV I32	Perl_call_sv(pTHX_ SV* sv, VOL I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CALL_SV	\
	assert(sv)

PERL_CALLCONV void	Perl_despatch_signals(pTHX);
PERL_CALLCONV OP *	Perl_doref(pTHX_ OP *o, I32 type, bool set_op_ref)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOREF	\
	assert(o)

PERL_CALLCONV SV*	Perl_eval_pv(pTHX_ const char* p, I32 croak_on_error)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_EVAL_PV	\
	assert(p)

PERL_CALLCONV I32	Perl_eval_sv(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_EVAL_SV	\
	assert(sv)

PERL_CALLCONV SV*	Perl_get_sv(pTHX_ const char *name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_SV	\
	assert(name)

PERL_CALLCONV AV*	Perl_get_av(pTHX_ const char *name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_AV	\
	assert(name)

PERL_CALLCONV HV*	Perl_get_hv(pTHX_ const char *name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_HV	\
	assert(name)

PERL_CALLCONV CV*	Perl_get_cv(pTHX_ const char* name, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_CV	\
	assert(name)

PERL_CALLCONV CV*	Perl_get_cvn_flags(pTHX_ const char* name, STRLEN len, I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_CVN_FLAGS	\
	assert(name)

PERL_CALLCONV int	Perl_init_i18nl10n(pTHX_ int printwarn);
PERL_CALLCONV int	Perl_init_i18nl14n(pTHX_ int printwarn);
PERL_CALLCONV void	Perl_new_collate(pTHX_ const char* newcoll);
PERL_CALLCONV void	Perl_new_ctype(pTHX_ const char* newctype)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEW_CTYPE	\
	assert(newctype)

PERL_CALLCONV void	Perl_new_numeric(pTHX_ const char* newcoll);
PERL_CALLCONV void	Perl_set_numeric_local(pTHX);
PERL_CALLCONV void	Perl_set_numeric_radix(pTHX);
PERL_CALLCONV void	Perl_set_numeric_standard(pTHX);
PERL_CALLCONV void	Perl_require_pv(pTHX_ const char* pv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REQUIRE_PV	\
	assert(pv)

PERL_CALLCONV void	Perl_pack_cat(pTHX_ SV *cat, const char *pat, const char *patend, SV **beglist, SV **endlist, SV ***next_in_list, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_PACK_CAT	\
	assert(cat); assert(pat); assert(patend); assert(beglist); assert(endlist); assert(next_in_list)

PERL_CALLCONV void	Perl_packlist(pTHX_ SV *cat, const char *pat, const char *patend, SV **beglist, SV **endlist)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_PACKLIST	\
	assert(cat); assert(pat); assert(patend); assert(beglist); assert(endlist)

#if defined(PERL_USES_PL_PIDSTATUS) && defined(PERL_IN_UTIL_C)
STATIC void	S_pidgone(pTHX_ Pid_t pid, int status);
#endif
PERL_CALLCONV OP*	Perl_pmruntime(pTHX_ OP *o, OP *expr, bool isreg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PMRUNTIME	\
	assert(o); assert(expr)

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_pmtrans(pTHX_ OP* o, OP* expr, OP* repl)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_PMTRANS	\
	assert(o); assert(expr); assert(repl)

#endif
PERL_CALLCONV void	Perl_pop_scope(pTHX);
PERL_CALLCONV OP*	Perl_prepend_elem(pTHX_ I32 optype, OP* head, OP* tail);
PERL_CALLCONV void	Perl_push_scope(pTHX);
/* PERL_CALLCONV OP*	Perl_ref(pTHX_ OP* o, I32 type); */
#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_refkids(pTHX_ OP* o, I32 type);
#endif
PERL_CALLCONV void	Perl_regdump(pTHX_ const regexp* r)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGDUMP	\
	assert(r)

PERL_CALLCONV void	Perl_regdump(pTHX_ const regexp* r)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGDUMP	\
	assert(r)

PERL_CALLCONV SV*	Perl_regclass_swash(pTHX_ const regexp *prog, const struct regnode *node, bool doinit, SV **listsvp, SV **altsvp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGCLASS_SWASH	\
	assert(node)

PERL_CALLCONV I32	Perl_pregexec(pTHX_ REGEXP * const prog, char* stringarg, char* strend, char* strbeg, I32 minend, SV* screamer, U32 nosave)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_PREGEXEC	\
	assert(prog); assert(stringarg); assert(strend); assert(strbeg); assert(screamer)

PERL_CALLCONV void	Perl_pregfree(pTHX_ REGEXP* r);
PERL_CALLCONV void	Perl_pregfree2(pTHX_ REGEXP *rx)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PREGFREE2	\
	assert(rx)

PERL_CALLCONV REGEXP*	Perl_reg_temp_copy(pTHX_ REGEXP* ret_x, REGEXP* rx)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_TEMP_COPY	\
	assert(rx)

PERL_CALLCONV void	Perl_regfree_internal(pTHX_ REGEXP *const rx)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGFREE_INTERNAL	\
	assert(rx)

#if defined(USE_ITHREADS)
PERL_CALLCONV void*	Perl_regdupe_internal(pTHX_ REGEXP * const r, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGDUPE_INTERNAL	\
	assert(r); assert(param)

#endif
PERL_CALLCONV REGEXP*	Perl_pregcomp(pTHX_ SV * const pattern, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PREGCOMP	\
	assert(pattern)

PERL_CALLCONV REGEXP*	Perl_re_compile(pTHX_ SV * const pattern, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_RE_COMPILE	\
	assert(pattern)

PERL_CALLCONV char*	Perl_re_intuit_start(pTHX_ REGEXP * const rx, SV* sv, char* strpos, char* strend, const U32 flags, re_scream_pos_data *data)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_RE_INTUIT_START	\
	assert(rx); assert(strpos); assert(strend)

PERL_CALLCONV SV*	Perl_re_intuit_string(pTHX_ REGEXP  *const r)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_RE_INTUIT_STRING	\
	assert(r)

PERL_CALLCONV I32	Perl_regexec_flags(pTHX_ REGEXP *const rx, char *stringarg, char *strend, char *strbeg, I32 minend, SV *sv, void *data, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_REGEXEC_FLAGS	\
	assert(rx); assert(stringarg); assert(strend); assert(strbeg); assert(sv)

PERL_CALLCONV regnode*	Perl_regnext(pTHX_ regnode* p)
			__attribute__warn_unused_result__;


PERL_CALLCONV SV*	Perl_reg_named_buff(pTHX_ REGEXP * const rx, SV * const key, SV * const value, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF	\
	assert(rx)

PERL_CALLCONV SV*	Perl_reg_named_buff_iter(pTHX_ REGEXP * const rx, const SV * const lastkey, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_ITER	\
	assert(rx)

PERL_CALLCONV SV*	Perl_reg_named_buff_fetch(pTHX_ REGEXP * const rx, SV * const namesv, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_FETCH	\
	assert(rx); assert(namesv)

PERL_CALLCONV bool	Perl_reg_named_buff_exists(pTHX_ REGEXP * const rx, SV * const key, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_EXISTS	\
	assert(rx); assert(key)

PERL_CALLCONV SV*	Perl_reg_named_buff_firstkey(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_FIRSTKEY	\
	assert(rx)

PERL_CALLCONV SV*	Perl_reg_named_buff_nextkey(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_NEXTKEY	\
	assert(rx)

PERL_CALLCONV SV*	Perl_reg_named_buff_scalar(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_SCALAR	\
	assert(rx)

PERL_CALLCONV SV*	Perl_reg_named_buff_all(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMED_BUFF_ALL	\
	assert(rx)


PERL_CALLCONV void	Perl_reg_numbered_buff_fetch(pTHX_ REGEXP * const rx, const I32 paren, SV * const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_FETCH	\
	assert(rx)

PERL_CALLCONV void	Perl_reg_numbered_buff_store(pTHX_ REGEXP * const rx, const I32 paren, SV const * const value)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_STORE	\
	assert(rx)

PERL_CALLCONV I32	Perl_reg_numbered_buff_length(pTHX_ REGEXP * const rx, const SV * const sv, const I32 paren)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_LENGTH	\
	assert(rx); assert(sv)


PERL_CALLCONV SV*	Perl_reg_qr_package(pTHX_ REGEXP * const rx)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_QR_PACKAGE	\
	assert(rx)


PERL_CALLCONV void	Perl_regprop(pTHX_ const regexp *prog, SV* sv, const regnode* o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGPROP	\
	assert(sv); assert(o)

PERL_CALLCONV void	Perl_repeatcpy(char* to, const char* from, I32 len, I32 count)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_REPEATCPY	\
	assert(to); assert(from)

PERL_CALLCONV char*	Perl_rninstr(const char* big, const char* bigend, const char* little, const char* lend)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4);
#define PERL_ARGS_ASSERT_RNINSTR	\
	assert(big); assert(bigend); assert(little); assert(lend)

PERL_CALLCONV Sighandler_t	Perl_rsignal(pTHX_ int i, Sighandler_t t);
PERL_CALLCONV int	Perl_rsignal_restore(pTHX_ int i, Sigsave_t* t);
PERL_CALLCONV int	Perl_rsignal_save(pTHX_ int i, Sighandler_t t1, Sigsave_t* save)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_RSIGNAL_SAVE	\
	assert(save)

PERL_CALLCONV Sighandler_t	Perl_rsignal_state(pTHX_ int i);
#if defined(PERL_IN_PP_CTL_C) || defined(PERL_DECL_PROT)
STATIC void	S_rxres_free(pTHX_ void** rsp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_RXRES_FREE	\
	assert(rsp)

STATIC void	S_rxres_restore(pTHX_ void **rsp, REGEXP *rx)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_RXRES_RESTORE	\
	assert(rsp); assert(rx)

#endif
PERL_CALLCONV void	Perl_rxres_save(pTHX_ void **rsp, REGEXP *rx)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_RXRES_SAVE	\
	assert(rsp); assert(rx)

#if !defined(HAS_RENAME)
PERL_CALLCONV I32	Perl_same_dirent(pTHX_ const char* a, const char* b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAME_DIRENT	\
	assert(a); assert(b)

#endif
PERL_CALLCONV char*	Perl_savepv(pTHX_ const char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savepvn(pTHX_ const char* pv, I32 len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savesharedpv(pTHX_ const char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savesharedpvn(pTHX_ const char *const pv, const STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVESHAREDPVN	\
	assert(pv)

PERL_CALLCONV char*	Perl_savesvpv(pTHX_ SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVESVPV	\
	assert(sv)

PERL_CALLCONV void	Perl_savestack_grow(pTHX);
PERL_CALLCONV void	Perl_savestack_grow_cnt(pTHX_ I32 need);
/* PERL_CALLCONV void	Perl_save_aelem(pTHX_ AV* av, I32 idx, SV **sptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3); */

PERL_CALLCONV void	Perl_save_aelem_flags(pTHX_ AV* av, I32 idx, SV **sptr, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SAVE_AELEM_FLAGS	\
	assert(av); assert(sptr)

PERL_CALLCONV I32	Perl_save_alloc(pTHX_ I32 size, I32 pad);
PERL_CALLCONV void	Perl_save_aptr(pTHX_ AV** aptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_APTR	\
	assert(aptr)

PERL_CALLCONV AV*	Perl_save_ary(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_ARY	\
	assert(gv)

PERL_CALLCONV void	Perl_save_bool(pTHX_ bool* boolp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_BOOL	\
	assert(boolp)

PERL_CALLCONV void	Perl_save_clearsv(pTHX_ SV** svp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_CLEARSV	\
	assert(svp)

PERL_CALLCONV void	Perl_save_delete(pTHX_ HV *hv, char *key, I32 klen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAVE_DELETE	\
	assert(hv); assert(key)

PERL_CALLCONV void	Perl_save_hdelete(pTHX_ HV *hv, SV *keysv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAVE_HDELETE	\
	assert(hv); assert(keysv)

PERL_CALLCONV void	Perl_save_adelete(pTHX_ AV *av, I32 key)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_ADELETE	\
	assert(av)

PERL_CALLCONV void	Perl_save_destructor(pTHX_ DESTRUCTORFUNC_NOCONTEXT_t f, void* p)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAVE_DESTRUCTOR	\
	assert(p)

PERL_CALLCONV void	Perl_save_destructor_x(pTHX_ DESTRUCTORFUNC_t f, void* p);
/* PERL_CALLCONV void	Perl_save_freesv(pTHX_ SV* sv); */
/* PERL_CALLCONV void	Perl_save_freeop(pTHX_ OP* o); */
/* PERL_CALLCONV void	Perl_save_freepv(pTHX_ char* pv); */
PERL_CALLCONV void	Perl_save_generic_svref(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_GENERIC_SVREF	\
	assert(sptr)

PERL_CALLCONV void	Perl_save_generic_pvref(pTHX_ char** str)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_GENERIC_PVREF	\
	assert(str)

PERL_CALLCONV void	Perl_save_shared_pvref(pTHX_ char** str)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SHARED_PVREF	\
	assert(str)

PERL_CALLCONV void	Perl_save_gp(pTHX_ GV* gv, I32 empty)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_GP	\
	assert(gv)

PERL_CALLCONV HV*	Perl_save_hash(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_HASH	\
	assert(gv)

PERL_CALLCONV void	Perl_save_hints(pTHX);
/* PERL_CALLCONV void	Perl_save_helem(pTHX_ HV *hv, SV *key, SV **sptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3); */

PERL_CALLCONV void	Perl_save_helem_flags(pTHX_ HV *hv, SV *key, SV **sptr, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SAVE_HELEM_FLAGS	\
	assert(hv); assert(key); assert(sptr)

PERL_CALLCONV void	Perl_save_hptr(pTHX_ HV** hptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_HPTR	\
	assert(hptr)

PERL_CALLCONV void	Perl_save_I16(pTHX_ I16* intp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_I16	\
	assert(intp)

PERL_CALLCONV void	Perl_save_I32(pTHX_ I32* intp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_I32	\
	assert(intp)

PERL_CALLCONV void	Perl_save_I8(pTHX_ I8* bytep)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_I8	\
	assert(bytep)

PERL_CALLCONV void	Perl_save_int(pTHX_ int* intp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_INT	\
	assert(intp)

PERL_CALLCONV void	Perl_save_item(pTHX_ SV* item)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_ITEM	\
	assert(item)

PERL_CALLCONV void	Perl_save_iv(pTHX_ IV *ivp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_IV	\
	assert(ivp)

PERL_CALLCONV void	Perl_save_list(pTHX_ SV** sarg, I32 maxsarg)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_LIST	\
	assert(sarg)

PERL_CALLCONV void	Perl_save_long(pTHX_ long* longp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_LONG	\
	assert(longp)

/* PERL_CALLCONV void	Perl_save_mortalizesv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SAVE_MORTALIZESV	\
	assert(sv)

PERL_CALLCONV void	Perl_save_nogv(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_NOGV	\
	assert(gv)

/* PERL_CALLCONV void	Perl_save_op(pTHX); */
PERL_CALLCONV SV*	Perl_save_scalar(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SCALAR	\
	assert(gv)

PERL_CALLCONV void	Perl_save_pptr(pTHX_ char** pptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_PPTR	\
	assert(pptr)

PERL_CALLCONV void	Perl_save_vptr(pTHX_ void *ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_VPTR	\
	assert(ptr)

PERL_CALLCONV void	Perl_save_re_context(pTHX);
PERL_CALLCONV void	Perl_save_padsv_and_mortalize(pTHX_ PADOFFSET off);
PERL_CALLCONV void	Perl_save_sptr(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SPTR	\
	assert(sptr)

PERL_CALLCONV SV*	Perl_save_svref(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SVREF	\
	assert(sptr)

PERL_CALLCONV void	Perl_save_pushptr(pTHX_ void *const ptr, const int type);
PERL_CALLCONV void	Perl_save_pushi32ptr(pTHX_ const I32 i, void *const ptr, const int type);
PERL_CALLCONV void	Perl_save_pushptrptr(pTHX_ void *const ptr1, void *const ptr2, const int type);
#if defined(PERL_IN_SCOPE_C) || defined(PERL_DECL_PROT)
STATIC void	S_save_pushptri32ptr(pTHX_ void *const ptr1, const I32 i, void *const ptr2, const int type);
#endif
PERL_CALLCONV OP*	Perl_sawparens(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_scalar(pTHX_ OP* o);
#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_scalarkids(pTHX_ OP* o);
STATIC OP*	S_scalarseq(pTHX_ OP* o);
#endif
PERL_CALLCONV OP*	Perl_scalarvoid(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCALARVOID	\
	assert(o)

PERL_CALLCONV NV	Perl_scan_bin(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_BIN	\
	assert(start); assert(retlen)

PERL_CALLCONV NV	Perl_scan_hex(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_HEX	\
	assert(start); assert(retlen)

PERL_CALLCONV char*	Perl_scan_num(pTHX_ const char* s, YYSTYPE *lvalp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SCAN_NUM	\
	assert(s); assert(lvalp)

PERL_CALLCONV NV	Perl_scan_oct(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_OCT	\
	assert(start); assert(retlen)

PERL_CALLCONV OP*	Perl_scope(pTHX_ OP* o);
PERL_CALLCONV char*	Perl_screaminstr(pTHX_ SV *bigstr, SV *littlestr, I32 start_shift, I32 end_shift, I32 *old_posp, I32 last)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_SCREAMINSTR	\
	assert(bigstr); assert(littlestr); assert(old_posp)

PERL_CALLCONV void	Perl_setdefout(pTHX_ GV* gv);
PERL_CALLCONV HEK*	Perl_share_hek(pTHX_ const char* str, I32 len, U32 hash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SHARE_HEK	\
	assert(str)

#if defined(HAS_SIGACTION) && defined(SA_SIGINFO)
PERL_CALLCONV Signal_t	Perl_sighandler(int sig, siginfo_t *info, void *uap);
PERL_CALLCONV Signal_t	Perl_csighandler(int sig, siginfo_t *info, void *uap);
#else
PERL_CALLCONV Signal_t	Perl_sighandler(int sig);
PERL_CALLCONV Signal_t	Perl_csighandler(int sig);
#endif
PERL_CALLCONV SV**	Perl_stack_grow(pTHX_ SV** sp, SV** p, int n)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_STACK_GROW	\
	assert(sp); assert(p)

PERL_CALLCONV I32	Perl_start_subparse(pTHX_ I32 is_format, U32 flags);
PERL_CALLCONV void	Perl_sub_crush_depth(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SUB_CRUSH_DEPTH	\
	assert(cv)

PERL_CALLCONV bool	Perl_sv_2bool(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2BOOL	\
	assert(sv)

PERL_CALLCONV CV*	Perl_sv_2cv(pTHX_ SV* sv, HV **const st, GV **const gvp, const I32 lref)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SV_2CV	\
	assert(st); assert(gvp)

PERL_CALLCONV IO*	Perl_sv_2io(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2IO	\
	assert(sv)

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC bool	S_glob_2number(pTHX_ GV* const gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GLOB_2NUMBER	\
	assert(gv)

#endif
/* PERL_CALLCONV IV	Perl_sv_2iv(pTHX_ SV *sv); */
PERL_CALLCONV IV	Perl_sv_2iv_flags(pTHX_ SV *const sv, const I32 flags);
PERL_CALLCONV SV*	Perl_sv_2mortal(pTHX_ SV *const sv);
PERL_CALLCONV NV	Perl_sv_2nv_flags(pTHX_ SV *const sv, const I32 flags);
PERL_CALLCONV SV*	Perl_sv_2num(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2NUM	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_2pv(pTHX_ SV *sv, STRLEN *lp); */
PERL_CALLCONV char*	Perl_sv_2pv_flags(pTHX_ SV *const sv, STRLEN *const lp, const I32 flags);
PERL_CALLCONV char*	Perl_sv_2pvutf8(pTHX_ SV *const sv, STRLEN *const lp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2PVUTF8	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_2pvbyte(pTHX_ SV *const sv, STRLEN *const lp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2PVBYTE	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_pvn_nomg(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_PVN_NOMG	\
	assert(sv)

/* PERL_CALLCONV UV	Perl_sv_2uv(pTHX_ SV *sv); */
PERL_CALLCONV UV	Perl_sv_2uv_flags(pTHX_ SV *const sv, const I32 flags);
PERL_CALLCONV IV	Perl_sv_iv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_IV	\
	assert(sv)

PERL_CALLCONV UV	Perl_sv_uv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UV	\
	assert(sv)

PERL_CALLCONV NV	Perl_sv_nv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_NV	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_pvn(pTHX_ SV *sv, STRLEN *lp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_PVN	\
	assert(sv); assert(lp)

PERL_CALLCONV char*	Perl_sv_pvutf8n(pTHX_ SV *sv, STRLEN *lp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_PVUTF8N	\
	assert(sv); assert(lp)

PERL_CALLCONV char*	Perl_sv_pvbyten(pTHX_ SV *sv, STRLEN *lp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_PVBYTEN	\
	assert(sv); assert(lp)

PERL_CALLCONV I32	Perl_sv_true(pTHX_ SV *const sv);
#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC void	S_sv_add_arena(pTHX_ char *const ptr, const U32 size, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_ADD_ARENA	\
	assert(ptr)

#endif
PERL_CALLCONV int	Perl_sv_backoff(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_BACKOFF	\
	assert(sv)

PERL_CALLCONV SV*	Perl_sv_bless(pTHX_ SV *const sv, HV *const stash)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_BLESS	\
	assert(sv); assert(stash)

PERL_CALLCONV void	Perl_sv_catpvf(pTHX_ SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_CATPVF	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_vcatpvf(pTHX_ SV *const sv, const char *const pat, va_list *const args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VCATPVF	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_catpv(pTHX_ SV *const sv, const char* ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_CATPV	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_catpvn(pTHX_ SV *dsv, const char *sstr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_SV_CATPVN	\
	assert(dsv); assert(sstr)

/* PERL_CALLCONV void	Perl_sv_catsv(pTHX_ SV *dstr, SV *sstr)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_CATSV	\
	assert(dstr)

PERL_CALLCONV void	Perl_sv_chop(pTHX_ SV *const sv, const char *const ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_CHOP	\
	assert(sv)

PERL_CALLCONV I32	Perl_sv_clean_all(pTHX);
PERL_CALLCONV void	Perl_sv_clean_objs(pTHX);
PERL_CALLCONV void	Perl_sv_clear(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_CLEAR	\
	assert(sv)

PERL_CALLCONV I32	Perl_sv_cmp(pTHX_ SV *const sv1, SV *const sv2);
PERL_CALLCONV I32	Perl_sv_cmp_locale(pTHX_ SV *const sv1, SV *const sv2);
#if defined(USE_LOCALE_COLLATE)
PERL_CALLCONV char*	Perl_sv_collxfrm(pTHX_ SV *const sv, STRLEN *const nxp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_COLLXFRM	\
	assert(sv); assert(nxp)

#endif
PERL_CALLCONV OP*	Perl_sv_compile_2op(pTHX_ SV *sv, OP **startop, const char *code, PAD **padp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_SV_COMPILE_2OP	\
	assert(sv); assert(startop); assert(code); assert(padp)

PERL_CALLCONV int	Perl_getcwd_sv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GETCWD_SV	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_dec(pTHX_ SV *const sv);
PERL_CALLCONV void	Perl_sv_dec_nomg(pTHX_ SV *const sv);
PERL_CALLCONV void	Perl_sv_dump(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_DUMP	\
	assert(sv)

PERL_CALLCONV bool	Perl_sv_derived_from(pTHX_ SV* sv, const char *const name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DERIVED_FROM	\
	assert(sv); assert(name)

PERL_CALLCONV bool	Perl_sv_does(pTHX_ SV* sv, const char *const name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DOES	\
	assert(sv); assert(name)

PERL_CALLCONV I32	Perl_sv_eq(pTHX_ SV* sv1, SV* sv2);
PERL_CALLCONV void	Perl_sv_free(pTHX_ SV *const sv);
PERL_CALLCONV void	Perl_sv_free2(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_FREE2	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_free_arenas(pTHX);
PERL_CALLCONV char*	Perl_sv_gets(pTHX_ SV *const sv, PerlIO *const fp, I32 append)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_GETS	\
	assert(sv); assert(fp)

PERL_CALLCONV char*	Perl_sv_grow(pTHX_ SV *const sv, STRLEN newlen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_GROW	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_inc(pTHX_ SV *const sv);
PERL_CALLCONV void	Perl_sv_inc_nomg(pTHX_ SV *const sv);
/* PERL_CALLCONV void	Perl_sv_insert(pTHX_ SV *const bigstr, const STRLEN offset, const STRLEN len, const char *const little, const STRLEN littlelen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_4); */
#define PERL_ARGS_ASSERT_SV_INSERT	\
	assert(bigstr); assert(little)

PERL_CALLCONV void	Perl_sv_insert_flags(pTHX_ SV *const bigstr, const STRLEN offset, const STRLEN len, const char *const little, const STRLEN littlelen, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_SV_INSERT_FLAGS	\
	assert(bigstr); assert(little)

PERL_CALLCONV int	Perl_sv_isa(pTHX_ SV* sv, const char *const name)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_ISA	\
	assert(name)

PERL_CALLCONV int	Perl_sv_isobject(pTHX_ SV* sv);
PERL_CALLCONV STRLEN	Perl_sv_len(pTHX_ SV *const sv);
PERL_CALLCONV STRLEN	Perl_sv_len_utf8(pTHX_ SV *const sv);
PERL_CALLCONV void	Perl_sv_magic(pTHX_ SV *const sv, SV *const obj, const int how, const char *const name, const I32 namlen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_MAGIC	\
	assert(sv)

PERL_CALLCONV MAGIC *	Perl_sv_magicext(pTHX_ SV *const sv, SV *const obj, const int how, const MGVTBL *const vtbl, const char *const name, const I32 namlen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_MAGICEXT	\
	assert(sv)

PERL_CALLCONV SV*	Perl_sv_mortalcopy(pTHX_ SV *const oldsv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_sv_newmortal(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_sv_newref(pTHX_ SV *const sv);
PERL_CALLCONV char*	Perl_sv_peek(pTHX_ SV* sv);
PERL_CALLCONV void	Perl_sv_pos_u2b(pTHX_ SV *const sv, I32 *const offsetp, I32 *const lenp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_POS_U2B	\
	assert(offsetp)

PERL_CALLCONV STRLEN	Perl_sv_pos_u2b_flags(pTHX_ SV *const sv, STRLEN uoffset, STRLEN *const lenp, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_POS_U2B_FLAGS	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_pos_b2u(pTHX_ SV *const sv, I32 *const offsetp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_POS_B2U	\
	assert(offsetp)

/* PERL_CALLCONV char*	Perl_sv_pvn_force(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_PVN_FORCE	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_pvutf8n_force(pTHX_ SV *const sv, STRLEN *const lp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_PVUTF8N_FORCE	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_pvbyten_force(pTHX_ SV *const sv, STRLEN *const lp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_PVBYTEN_FORCE	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_recode_to_utf8(pTHX_ SV* sv, SV *encoding)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_RECODE_TO_UTF8	\
	assert(sv); assert(encoding)

PERL_CALLCONV bool	Perl_sv_cat_decode(pTHX_ SV* dsv, SV *encoding, SV *ssv, int *offset, char* tstr, int tlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_SV_CAT_DECODE	\
	assert(dsv); assert(encoding); assert(ssv); assert(offset); assert(tstr)

PERL_CALLCONV const char*	Perl_sv_reftype(pTHX_ const SV *const sv, const int ob)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_REFTYPE	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_replace(pTHX_ SV *const sv, SV *const nsv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_REPLACE	\
	assert(sv); assert(nsv)

PERL_CALLCONV void	Perl_sv_report_used(pTHX);
PERL_CALLCONV void	Perl_sv_reset(pTHX_ const char* s, HV *const stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_RESET	\
	assert(s)

PERL_CALLCONV void	Perl_sv_setpvf(pTHX_ SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_SETPVF	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_vsetpvf(pTHX_ SV *const sv, const char *const pat, va_list *const args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VSETPVF	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_setiv(pTHX_ SV *const sv, const IV num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETIV	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setpviv(pTHX_ SV *const sv, const IV num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETPVIV	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setuv(pTHX_ SV *const sv, const UV num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETUV	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setnv(pTHX_ SV *const sv, const NV num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETNV	\
	assert(sv)

PERL_CALLCONV SV*	Perl_sv_setref_iv(pTHX_ SV *const rv, const char *const classname, const IV iv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETREF_IV	\
	assert(rv)

PERL_CALLCONV SV*	Perl_sv_setref_uv(pTHX_ SV *const rv, const char *const classname, const UV uv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETREF_UV	\
	assert(rv)

PERL_CALLCONV SV*	Perl_sv_setref_nv(pTHX_ SV *const rv, const char *const classname, const NV nv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETREF_NV	\
	assert(rv)

PERL_CALLCONV SV*	Perl_sv_setref_pv(pTHX_ SV *const rv, const char *const classname, void *const pv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETREF_PV	\
	assert(rv)

PERL_CALLCONV SV*	Perl_sv_setref_pvn(pTHX_ SV *const rv, const char *const classname, const char *const pv, const STRLEN n)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SV_SETREF_PVN	\
	assert(rv); assert(pv)

PERL_CALLCONV void	Perl_sv_setpv(pTHX_ SV *const sv, const char *const ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETPV	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setpvn(pTHX_ SV *const sv, const char *const ptr, const STRLEN len)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETPVN	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_setsv(pTHX_ SV *dstr, SV *sstr)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_SETSV	\
	assert(dstr)

/* PERL_CALLCONV void	Perl_sv_taint(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_TAINT	\
	assert(sv)

PERL_CALLCONV bool	Perl_sv_tainted(pTHX_ SV *const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_TAINTED	\
	assert(sv)

PERL_CALLCONV int	Perl_sv_unmagic(pTHX_ SV *const sv, const int type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UNMAGIC	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_unref(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_UNREF	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_unref_flags(pTHX_ SV *const ref, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UNREF_FLAGS	\
	assert(ref)

PERL_CALLCONV void	Perl_sv_untaint(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UNTAINT	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_upgrade(pTHX_ SV *const sv, svtype new_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UPGRADE	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_usepvn(pTHX_ SV* sv, char* ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_USEPVN	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_usepvn_flags(pTHX_ SV *const sv, char* ptr, const STRLEN len, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_USEPVN_FLAGS	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_vcatpvfn(pTHX_ SV *const sv, const char *const pat, const STRLEN patlen, va_list *const args, SV **const svargs, const I32 svmax, bool *const maybe_tainted)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VCATPVFN	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_vsetpvfn(pTHX_ SV *const sv, const char *const pat, const STRLEN patlen, va_list *const args, SV **const svargs, const I32 svmax, bool *const maybe_tainted)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VSETPVFN	\
	assert(sv); assert(pat)

PERL_CALLCONV NV	Perl_str_to_version(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_STR_TO_VERSION	\
	assert(sv)

PERL_CALLCONV SV*	Perl_swash_init(pTHX_ const char* pkg, const char* name, SV* listsv, I32 minbits, I32 none)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SWASH_INIT	\
	assert(pkg); assert(name); assert(listsv)

PERL_CALLCONV UV	Perl_swash_fetch(pTHX_ SV *swash, const U8 *ptr, bool do_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SWASH_FETCH	\
	assert(swash); assert(ptr)

PERL_CALLCONV void	Perl_taint_env(pTHX);
PERL_CALLCONV void	Perl_taint_proper(pTHX_ const char* f, const char *const s)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TAINT_PROPER	\
	assert(s)

PERL_CALLCONV UV	Perl_to_utf8_case(pTHX_ const U8 *p, U8* ustrp, STRLEN *lenp, SV **swashp, const char *normal, const char *special)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_TO_UTF8_CASE	\
	assert(p); assert(ustrp); assert(swashp); assert(normal); assert(special)

PERL_CALLCONV UV	Perl_to_utf8_lower(pTHX_ const U8 *p, U8* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TO_UTF8_LOWER	\
	assert(p); assert(ustrp)

PERL_CALLCONV UV	Perl_to_utf8_upper(pTHX_ const U8 *p, U8* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TO_UTF8_UPPER	\
	assert(p); assert(ustrp)

PERL_CALLCONV UV	Perl_to_utf8_title(pTHX_ const U8 *p, U8* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TO_UTF8_TITLE	\
	assert(p); assert(ustrp)

PERL_CALLCONV UV	Perl_to_utf8_fold(pTHX_ const U8 *p, U8* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TO_UTF8_FOLD	\
	assert(p); assert(ustrp)

#if defined(UNLINK_ALL_VERSIONS)
PERL_CALLCONV I32	Perl_unlnk(pTHX_ const char* f)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UNLNK	\
	assert(f)

#endif
PERL_CALLCONV I32	Perl_unpack_str(pTHX_ const char *pat, const char *patend, const char *s, const char *strbeg, const char *strend, char **new_s, I32 ocnt, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_UNPACK_STR	\
	assert(pat); assert(patend); assert(s); assert(strend)

PERL_CALLCONV I32	Perl_unpackstring(pTHX_ const char *pat, const char *patend, const char *s, const char *strend, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UNPACKSTRING	\
	assert(pat); assert(patend); assert(s); assert(strend)

PERL_CALLCONV void	Perl_unsharepvn(pTHX_ const char* sv, I32 len, U32 hash);
PERL_CALLCONV void	Perl_unshare_hek(pTHX_ HEK* hek);
#ifdef PERL_MAD
PERL_CALLCONV OP *	Perl_utilize(pTHX_ int aver, I32 floor, OP* version, OP* idop, OP* arg)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UTILIZE	\
	assert(idop)

#else
PERL_CALLCONV void	Perl_utilize(pTHX_ int aver, I32 floor, OP* version, OP* idop, OP* arg)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UTILIZE	\
	assert(idop)

#endif
PERL_CALLCONV U8*	Perl_utf16_to_utf8(pTHX_ U8* p, U8 *d, I32 bytelen, I32 *newlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UTF16_TO_UTF8	\
	assert(p); assert(d); assert(newlen)

PERL_CALLCONV U8*	Perl_utf16_to_utf8_reversed(pTHX_ U8* p, U8 *d, I32 bytelen, I32 *newlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UTF16_TO_UTF8_REVERSED	\
	assert(p); assert(d); assert(newlen)

PERL_CALLCONV STRLEN	Perl_utf8_length(pTHX_ const U8* s, const U8 *e)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_UTF8_LENGTH	\
	assert(s); assert(e)

PERL_CALLCONV IV	Perl_utf8_distance(pTHX_ const U8 *a, const U8 *b)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_UTF8_DISTANCE	\
	assert(a); assert(b)

PERL_CALLCONV U8*	Perl_utf8_hop(pTHX_ const U8 *s, I32 off)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UTF8_HOP	\
	assert(s)

PERL_CALLCONV U8*	Perl_utf8_to_bytes(pTHX_ U8 *s, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_UTF8_TO_BYTES	\
	assert(s); assert(len)

PERL_CALLCONV U8*	Perl_bytes_from_utf8(pTHX_ const U8 *s, STRLEN *len, bool *is_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_BYTES_FROM_UTF8	\
	assert(s); assert(len)

PERL_CALLCONV U8*	Perl_bytes_to_utf8(pTHX_ const U8 *s, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_BYTES_TO_UTF8	\
	assert(s); assert(len)

PERL_CALLCONV UV	Perl_utf8_to_uvchr(pTHX_ const U8 *s, STRLEN *retlen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UTF8_TO_UVCHR	\
	assert(s)

PERL_CALLCONV UV	Perl_utf8_to_uvuni(pTHX_ const U8 *s, STRLEN *retlen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UTF8_TO_UVUNI	\
	assert(s)


#ifdef EBCDIC
PERL_CALLCONV UV	Perl_utf8n_to_uvchr(pTHX_ const U8 *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UTF8N_TO_UVCHR	\
	assert(s)

#else
/* PERL_CALLCONV UV	Perl_utf8n_to_uvchr(pTHX_ const U8 *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_UTF8N_TO_UVCHR	\
	assert(s)

#endif

PERL_CALLCONV UV	Perl_utf8n_to_uvuni(pTHX_ const U8 *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UTF8N_TO_UVUNI	\
	assert(s)


#ifdef EBCDIC
PERL_CALLCONV U8*	Perl_uvchr_to_utf8(pTHX_ U8 *d, UV uv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UVCHR_TO_UTF8	\
	assert(d)

#else
/* PERL_CALLCONV U8*	Perl_uvchr_to_utf8(pTHX_ U8 *d, UV uv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_UVCHR_TO_UTF8	\
	assert(d)

#endif

/* PERL_CALLCONV U8*	Perl_uvuni_to_utf8(pTHX_ U8 *d, UV uv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_UVUNI_TO_UTF8	\
	assert(d)

PERL_CALLCONV U8*	Perl_uvchr_to_utf8_flags(pTHX_ U8 *d, UV uv, UV flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UVCHR_TO_UTF8_FLAGS	\
	assert(d)

PERL_CALLCONV U8*	Perl_uvuni_to_utf8_flags(pTHX_ U8 *d, UV uv, UV flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UVUNI_TO_UTF8_FLAGS	\
	assert(d)

PERL_CALLCONV char*	Perl_pv_uni_display(pTHX_ SV *dsv, const U8 *spv, STRLEN len, STRLEN pvlim, UV flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PV_UNI_DISPLAY	\
	assert(dsv); assert(spv)

PERL_CALLCONV char*	Perl_sv_uni_display(pTHX_ SV *dsv, SV *ssv, STRLEN pvlim, UV flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_UNI_DISPLAY	\
	assert(dsv); assert(ssv)

PERL_CALLCONV void	Perl_vivify_defelem(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VIVIFY_DEFELEM	\
	assert(sv)

PERL_CALLCONV void	Perl_vivify_ref(pTHX_ SV* sv, U32 to_what)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VIVIFY_REF	\
	assert(sv)

PERL_CALLCONV I32	Perl_wait4pid(pTHX_ Pid_t pid, int* statusp, int flags)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_WAIT4PID	\
	assert(statusp)

PERL_CALLCONV U32	Perl_parse_unicode_opts(pTHX_ const char **popt)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PARSE_UNICODE_OPTS	\
	assert(popt)

PERL_CALLCONV U32	Perl_seed(pTHX);
PERL_CALLCONV UV	Perl_get_hash_seed(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_report_evil_fh(pTHX_ const GV *gv, const IO *io, I32 op);
PERL_CALLCONV void	Perl_report_uninit(pTHX_ const SV *uninit_sv);
PERL_CALLCONV void	Perl_warn_sv(pTHX_ SV *baseex)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WARN_SV	\
	assert(baseex)

PERL_CALLCONV void	Perl_warn(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WARN	\
	assert(pat)

PERL_CALLCONV void	Perl_vwarn(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VWARN	\
	assert(pat)

PERL_CALLCONV void	Perl_warner(pTHX_ U32 err, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_WARNER	\
	assert(pat)

PERL_CALLCONV void	Perl_ck_warner(pTHX_ U32 err, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_CK_WARNER	\
	assert(pat)

PERL_CALLCONV void	Perl_ck_warner_d(pTHX_ U32 err, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_CK_WARNER_D	\
	assert(pat)

PERL_CALLCONV void	Perl_vwarner(pTHX_ U32 err, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_VWARNER	\
	assert(pat)

PERL_CALLCONV void	Perl_watch(pTHX_ char** addr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WATCH	\
	assert(addr)

PERL_CALLCONV I32	Perl_whichsig(pTHX_ const char* sig)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WHICHSIG	\
	assert(sig)

PERL_CALLCONV void	Perl_write_to_stderr(pTHX_ SV* msv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WRITE_TO_STDERR	\
	assert(msv)

PERL_CALLCONV int	Perl_yyerror(pTHX_ const char *const s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_YYERROR	\
	assert(s)

PERL_CALLCONV int	Perl_yylex(pTHX);
PERL_CALLCONV int	Perl_yyparse(pTHX);
PERL_CALLCONV void	Perl_parser_free(pTHX_ const yy_parser *parser)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PARSER_FREE	\
	assert(parser)

#if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
STATIC int	S_yywarn(pTHX_ const char *const s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_YYWARN	\
	assert(s)

#endif
#if defined(MYMALLOC)
PERL_CALLCONV void	Perl_dump_mstats(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_MSTATS	\
	assert(s)

PERL_CALLCONV int	Perl_get_mstats(pTHX_ perl_mstats_t *buf, int buflen, int level)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_MSTATS	\
	assert(buf)

#endif
PERL_CALLCONV Malloc_t	Perl_safesysmalloc(MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_safesyscalloc(MEM_SIZE elements, MEM_SIZE size)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_safesysrealloc(Malloc_t where, MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Free_t	Perl_safesysfree(Malloc_t where);
#if defined(PERL_GLOBAL_STRUCT)
PERL_CALLCONV struct perl_vars *	Perl_GetVars(pTHX);
PERL_CALLCONV struct perl_vars*	Perl_init_global_struct(pTHX);
PERL_CALLCONV void	Perl_free_global_struct(pTHX_ struct perl_vars *plvarsp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FREE_GLOBAL_STRUCT	\
	assert(plvarsp)

#endif
PERL_CALLCONV int	Perl_runops_standard(pTHX);
PERL_CALLCONV int	Perl_runops_debug(pTHX);
PERL_CALLCONV void	Perl_sv_catpvf_mg(pTHX_ SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_CATPVF_MG	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_vcatpvf_mg(pTHX_ SV *const sv, const char *const pat, va_list *const args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VCATPVF_MG	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_catpv_mg(pTHX_ SV *const sv, const char *const ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_CATPV_MG	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_catpvn_mg(pTHX_ SV *sv, const char *ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */
#define PERL_ARGS_ASSERT_SV_CATPVN_MG	\
	assert(sv); assert(ptr)

/* PERL_CALLCONV void	Perl_sv_catsv_mg(pTHX_ SV *dsv, SV *ssv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_CATSV_MG	\
	assert(dsv)

PERL_CALLCONV void	Perl_sv_setpvf_mg(pTHX_ SV *const sv, const char *const pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_SETPVF_MG	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_vsetpvf_mg(pTHX_ SV *const sv, const char *const pat, va_list *const args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_VSETPVF_MG	\
	assert(sv); assert(pat)

PERL_CALLCONV void	Perl_sv_setiv_mg(pTHX_ SV *const sv, const IV i)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETIV_MG	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setpviv_mg(pTHX_ SV *const sv, const IV iv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETPVIV_MG	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setuv_mg(pTHX_ SV *const sv, const UV u)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETUV_MG	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setnv_mg(pTHX_ SV *const sv, const NV num)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETNV_MG	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setpv_mg(pTHX_ SV *const sv, const char *const ptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETPV_MG	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_setpvn_mg(pTHX_ SV *const sv, const char *const ptr, const STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_SETPVN_MG	\
	assert(sv); assert(ptr)

PERL_CALLCONV void	Perl_sv_setsv_mg(pTHX_ SV *const dstr, SV *const sstr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETSV_MG	\
	assert(dstr)

/* PERL_CALLCONV void	Perl_sv_usepvn_mg(pTHX_ SV *sv, char *ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_USEPVN_MG	\
	assert(sv)

PERL_CALLCONV MGVTBL*	Perl_get_vtbl(pTHX_ int vtbl_id)
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_pv_display(pTHX_ SV *dsv, const char *pv, STRLEN cur, STRLEN len, STRLEN pvlim)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PV_DISPLAY	\
	assert(dsv); assert(pv)

PERL_CALLCONV char*	Perl_pv_escape(pTHX_ SV *dsv, char const * const str, const STRLEN count, const STRLEN max, STRLEN * const escaped, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PV_ESCAPE	\
	assert(dsv); assert(str)

PERL_CALLCONV char*	Perl_pv_pretty(pTHX_ SV *dsv, char const * const str, const STRLEN count, const STRLEN max, char const * const start_color, char const * const end_color, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PV_PRETTY	\
	assert(dsv); assert(str)

PERL_CALLCONV void	Perl_dump_indent(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DUMP_INDENT	\
	assert(file); assert(pat)

PERL_CALLCONV void	Perl_dump_vindent(pTHX_ I32 level, PerlIO *file, const char* pat, va_list *args)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DUMP_VINDENT	\
	assert(file); assert(pat)

PERL_CALLCONV void	Perl_do_gv_dump(pTHX_ I32 level, PerlIO *file, const char *name, GV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_GV_DUMP	\
	assert(file); assert(name)

PERL_CALLCONV void	Perl_do_gvgv_dump(pTHX_ I32 level, PerlIO *file, const char *name, GV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_GVGV_DUMP	\
	assert(file); assert(name)

PERL_CALLCONV void	Perl_do_hv_dump(pTHX_ I32 level, PerlIO *file, const char *name, HV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_HV_DUMP	\
	assert(file); assert(name)

PERL_CALLCONV void	Perl_do_magic_dump(pTHX_ I32 level, PerlIO *file, const MAGIC *mg, I32 nest, I32 maxnest, bool dumpops, STRLEN pvlim)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_MAGIC_DUMP	\
	assert(file); assert(mg)

PERL_CALLCONV void	Perl_do_op_dump(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_OP_DUMP	\
	assert(file)

PERL_CALLCONV void	Perl_do_pmop_dump(pTHX_ I32 level, PerlIO *file, const PMOP *pm)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_PMOP_DUMP	\
	assert(file)

PERL_CALLCONV void	Perl_do_sv_dump(pTHX_ I32 level, PerlIO *file, SV *sv, I32 nest, I32 maxnest, bool dumpops, STRLEN pvlim)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_SV_DUMP	\
	assert(file)

PERL_CALLCONV void	Perl_magic_dump(pTHX_ const MAGIC *mg);
PERL_CALLCONV void	Perl_reginitcolors(pTHX);
/* PERL_CALLCONV char*	Perl_sv_2pv_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_2PV_NOLEN	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_2pvutf8_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_2PVUTF8_NOLEN	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_2pvbyte_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_2PVBYTE_NOLEN	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_pv(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_PV	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_pvutf8(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_PVUTF8	\
	assert(sv)

/* PERL_CALLCONV char*	Perl_sv_pvbyte(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_PVBYTE	\
	assert(sv)

/* PERL_CALLCONV STRLEN	Perl_sv_utf8_upgrade(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_UTF8_UPGRADE	\
	assert(sv)

/* PERL_CALLCONV STRLEN	sv_utf8_upgrade_nomg(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV bool	Perl_sv_utf8_downgrade(pTHX_ SV *const sv, const bool fail_ok)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UTF8_DOWNGRADE	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_utf8_encode(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UTF8_ENCODE	\
	assert(sv)

PERL_CALLCONV bool	Perl_sv_utf8_decode(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UTF8_DECODE	\
	assert(sv)

/* PERL_CALLCONV void	Perl_sv_force_normal(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1); */
#define PERL_ARGS_ASSERT_SV_FORCE_NORMAL	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_force_normal_flags(pTHX_ SV *const sv, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_FORCE_NORMAL_FLAGS	\
	assert(sv)

PERL_CALLCONV void	Perl_tmps_grow(pTHX_ I32 n);
PERL_CALLCONV SV*	Perl_sv_rvweaken(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_RVWEAKEN	\
	assert(sv)

PERL_CALLCONV int	Perl_magic_killbackrefs(pTHX_ SV *sv, MAGIC *mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_KILLBACKREFS	\
	assert(sv); assert(mg)

PERL_CALLCONV OP*	Perl_newANONATTRSUB(pTHX_ I32 floor, OP *proto, OP *attrs, OP *block);
PERL_CALLCONV CV*	Perl_newATTRSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block);
#ifdef PERL_MAD
PERL_CALLCONV OP *	Perl_newMYSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block)
			__attribute__noreturn__;

#else
PERL_CALLCONV void	Perl_newMYSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block)
			__attribute__noreturn__;

#endif
PERL_CALLCONV OP *	Perl_my_attrs(pTHX_ OP *o, OP *attrs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_ATTRS	\
	assert(o)

#if defined(USE_ITHREADS)
PERL_CALLCONV PERL_CONTEXT*	Perl_cx_dup(pTHX_ PERL_CONTEXT* cx, I32 ix, I32 max, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_CX_DUP	\
	assert(param)

PERL_CALLCONV PERL_SI*	Perl_si_dup(pTHX_ PERL_SI* si, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SI_DUP	\
	assert(param)

PERL_CALLCONV ANY*	Perl_ss_dup(pTHX_ PerlInterpreter* proto_perl, CLONE_PARAMS* param)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SS_DUP	\
	assert(proto_perl); assert(param)

PERL_CALLCONV void*	Perl_any_dup(pTHX_ void* v, const PerlInterpreter* proto_perl)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_ANY_DUP	\
	assert(proto_perl)

PERL_CALLCONV HE*	Perl_he_dup(pTHX_ const HE* e, bool shared, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_HE_DUP	\
	assert(param)

PERL_CALLCONV HEK*	Perl_hek_dup(pTHX_ HEK* e, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_HEK_DUP	\
	assert(param)

PERL_CALLCONV void	Perl_re_dup_guts(pTHX_ const REGEXP *sstr, REGEXP *dstr, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_RE_DUP_GUTS	\
	assert(sstr); assert(dstr); assert(param)

PERL_CALLCONV PerlIO*	Perl_fp_dup(pTHX_ PerlIO *const fp, const char type, CLONE_PARAMS *const param)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_FP_DUP	\
	assert(param)

PERL_CALLCONV DIR*	Perl_dirp_dup(pTHX_ DIR *const dp)
			__attribute__warn_unused_result__;

PERL_CALLCONV GP*	Perl_gp_dup(pTHX_ GP *const gp, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GP_DUP	\
	assert(param)

PERL_CALLCONV MAGIC*	Perl_mg_dup(pTHX_ MAGIC *mg, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MG_DUP	\
	assert(param)

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC SV **	S_sv_dup_inc_multiple(pTHX_ SV *const *source, SV **dest, SSize_t items, CLONE_PARAMS *const param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_SV_DUP_INC_MULTIPLE	\
	assert(source); assert(dest); assert(param)

#endif
#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC SV*	S_sv_dup_common(pTHX_ const SV *const sstr, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DUP_COMMON	\
	assert(sstr); assert(param)

#endif
PERL_CALLCONV SV*	Perl_sv_dup(pTHX_ const SV *const sstr, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DUP	\
	assert(param)

PERL_CALLCONV SV*	Perl_sv_dup_inc(pTHX_ const SV *const sstr, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DUP_INC	\
	assert(param)

PERL_CALLCONV void	Perl_rvpv_dup(pTHX_ SV *const dstr, const SV *const sstr, CLONE_PARAMS *const param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_RVPV_DUP	\
	assert(dstr); assert(sstr); assert(param)

PERL_CALLCONV yy_parser*	Perl_parser_dup(pTHX_ const yy_parser *const proto, CLONE_PARAMS *const param)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PARSER_DUP	\
	assert(param)

#endif
PERL_CALLCONV PTR_TBL_t*	Perl_ptr_table_new(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void*	Perl_ptr_table_fetch(pTHX_ PTR_TBL_t *const tbl, const void *const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PTR_TABLE_FETCH	\
	assert(tbl)

PERL_CALLCONV void	Perl_ptr_table_store(pTHX_ PTR_TBL_t *const tbl, const void *const oldsv, void *const newsv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_PTR_TABLE_STORE	\
	assert(tbl); assert(newsv)

PERL_CALLCONV void	Perl_ptr_table_split(pTHX_ PTR_TBL_t *const tbl)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PTR_TABLE_SPLIT	\
	assert(tbl)

PERL_CALLCONV void	Perl_ptr_table_clear(pTHX_ PTR_TBL_t *const tbl)
			__attribute__deprecated__;

PERL_CALLCONV void	Perl_ptr_table_free(pTHX_ PTR_TBL_t *const tbl);
#if defined(USE_ITHREADS)
#  if defined(HAVE_INTERP_INTERN)
PERL_CALLCONV void	Perl_sys_intern_dup(pTHX_ struct interp_intern* src, struct interp_intern* dst)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SYS_INTERN_DUP	\
	assert(src); assert(dst)

#  endif
#endif
#if defined(HAVE_INTERP_INTERN)
PERL_CALLCONV void	Perl_sys_intern_clear(pTHX);
PERL_CALLCONV void	Perl_sys_intern_init(pTHX);
#endif

PERL_CALLCONV const char *	Perl_custom_op_name(pTHX_ const OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CUSTOM_OP_NAME	\
	assert(o)

PERL_CALLCONV const char *	Perl_custom_op_desc(pTHX_ const OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CUSTOM_OP_DESC	\
	assert(o)


PERL_CALLCONV void	Perl_sv_nosharing(pTHX_ SV *sv);
/* PERL_CALLCONV void	Perl_sv_nolocking(pTHX_ SV *sv); */
PERL_CALLCONV bool	Perl_sv_destroyable(pTHX_ SV *sv);
#ifdef NO_MATHOMS
/* PERL_CALLCONV void	Perl_sv_nounlocking(pTHX_ SV *sv); */
#else
PERL_CALLCONV void	Perl_sv_nounlocking(pTHX_ SV *sv);
#endif
PERL_CALLCONV int	Perl_nothreadhook(pTHX);

END_EXTERN_C

#if defined(PERL_IN_DOOP_C) || defined(PERL_DECL_PROT)
STATIC I32	S_do_trans_simple(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_SIMPLE	\
	assert(sv)

STATIC I32	S_do_trans_count(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_COUNT	\
	assert(sv)

STATIC I32	S_do_trans_complex(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_COMPLEX	\
	assert(sv)

STATIC I32	S_do_trans_simple_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_SIMPLE_UTF8	\
	assert(sv)

STATIC I32	S_do_trans_count_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_COUNT_UTF8	\
	assert(sv)

STATIC I32	S_do_trans_complex_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DO_TRANS_COMPLEX_UTF8	\
	assert(sv)

#endif

#if defined(PERL_IN_GV_C) || defined(PERL_DECL_PROT)
STATIC void	S_gv_init_sv(pTHX_ GV *gv, const svtype sv_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_INIT_SV	\
	assert(gv)

STATIC HV*	S_gv_get_super_pkg(pTHX_ const char* name, I32 namelen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_GET_SUPER_PKG	\
	assert(name)

STATIC HV*	S_require_tie_mod(pTHX_ GV *gv, const char *varpv, SV* namesv, const char *methpv, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_REQUIRE_TIE_MOD	\
	assert(gv); assert(varpv); assert(namesv); assert(methpv)

#endif

PERL_CALLCONV void*	Perl_get_arena(pTHX_ const size_t arenasize, const svtype bodytype)
			__attribute__malloc__
			__attribute__warn_unused_result__;


#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
STATIC void	S_hsplit(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HSPLIT	\
	assert(hv)

STATIC void	S_hfreeentries(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HFREEENTRIES	\
	assert(hv)

STATIC I32	S_anonymise_cv(pTHX_ HEK *stash, SV *val)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_ANONYMISE_CV	\
	assert(val)

STATIC HE*	S_new_he(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

STATIC HEK*	S_save_hek_flags(const char *str, I32 len, U32 hash, int flags)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_SAVE_HEK_FLAGS	\
	assert(str)

STATIC void	S_hv_magic_check(HV *hv, bool *needs_copy, bool *needs_store)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_HV_MAGIC_CHECK	\
	assert(hv); assert(needs_copy); assert(needs_store)

STATIC void	S_unshare_hek_or_pvn(pTHX_ const HEK* hek, const char* str, I32 len, U32 hash);
STATIC HEK*	S_share_hek_flags(pTHX_ const char *str, I32 len, U32 hash, int flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SHARE_HEK_FLAGS	\
	assert(str)

STATIC void	S_hv_notallowed(pTHX_ int flags, const char *key, I32 klen, const char *msg)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_HV_NOTALLOWED	\
	assert(key); assert(msg)

STATIC struct xpvhv_aux*	S_hv_auxinit(HV *hv)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_HV_AUXINIT	\
	assert(hv)

STATIC SV*	S_hv_delete_common(pTHX_ HV *hv, SV *keysv, const char *key, STRLEN klen, int k_flags, I32 d_flags, U32 hash);
STATIC void	S_clear_placeholders(pTHX_ HV *hv, U32 items)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CLEAR_PLACEHOLDERS	\
	assert(hv)

STATIC SV *	S_refcounted_he_value(pTHX_ const struct refcounted_he *he)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REFCOUNTED_HE_VALUE	\
	assert(he)

#endif

#if defined(PERL_IN_MG_C) || defined(PERL_DECL_PROT)
STATIC void	S_save_magic(pTHX_ I32 mgs_ix, SV *sv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAVE_MAGIC	\
	assert(sv)

STATIC int	S_magic_methpack(pTHX_ SV *sv, const MAGIC *mg, const char *meth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MAGIC_METHPACK	\
	assert(sv); assert(mg); assert(meth)

STATIC SV*	S_magic_methcall1(pTHX_ SV *sv, const MAGIC *mg, const char *meth, U32 flags, int n, SV *val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MAGIC_METHCALL1	\
	assert(sv); assert(mg); assert(meth)

STATIC void	S_restore_magic(pTHX_ const void *p);
STATIC void	S_unwind_handler_stack(pTHX_ const void *p)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UNWIND_HANDLER_STACK	\
	assert(p)


#endif

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV OP*	Perl_ck_anoncode(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_ANONCODE	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_bitop(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_BITOP	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_concat(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_CONCAT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_defined(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_DEFINED	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_delete(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_DELETE	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_die(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_DIE	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_eof(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EOF	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_eval(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EVAL	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_exec(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EXEC	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_exists(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EXISTS	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_exit(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EXIT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_ftst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_FTST	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_fun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_FUN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_glob(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_GLOB	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_grep(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_GREP	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_index(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_INDEX	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_join(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_JOIN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_lfun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_LFUN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_listiob(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_LISTIOB	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_match(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_MATCH	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_method(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_METHOD	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_null(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_NULL	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_open(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_OPEN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_readline(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_READLINE	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_repeat(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_REPEAT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_require(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_REQUIRE	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_return(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_RETURN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_rfun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_RFUN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_rvconst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_RVCONST	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_sassign(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SASSIGN	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_select(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SELECT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_shift(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SHIFT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_sort(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SORT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_spair(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SPAIR	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_split(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SPLIT	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_subr(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SUBR	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_substr(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SUBSTR	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_svconst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_SVCONST	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_trunc(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_TRUNC	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_unpack(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_UNPACK	\
	assert(o)

PERL_CALLCONV OP*	Perl_ck_each(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CK_EACH	\
	assert(o)

STATIC bool	S_is_handle_constructor(const OP *o, I32 numargs)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_HANDLE_CONSTRUCTOR	\
	assert(o)

STATIC I32	S_is_list_assignment(pTHX_ const OP *o)
			__attribute__warn_unused_result__;

#  ifdef USE_ITHREADS
STATIC void	S_forget_pmop(pTHX_ PMOP *const o, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORGET_PMOP	\
	assert(o)

#  else
STATIC void	S_forget_pmop(pTHX_ PMOP *const o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORGET_PMOP	\
	assert(o)

#  endif
STATIC void	S_find_and_forget_pmops(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FIND_AND_FORGET_PMOPS	\
	assert(o)

STATIC void	S_cop_free(pTHX_ COP *cop)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_COP_FREE	\
	assert(cop)

STATIC OP*	S_modkids(pTHX_ OP *o, I32 type);
STATIC OP*	S_scalarboolean(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCALARBOOLEAN	\
	assert(o)

STATIC OP*	S_newDEFSVOP(pTHX)
			__attribute__warn_unused_result__;

STATIC OP*	S_search_const(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SEARCH_CONST	\
	assert(o)

STATIC OP*	S_new_logop(pTHX_ I32 type, I32 flags, OP **firstp, OP **otherp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_NEW_LOGOP	\
	assert(firstp); assert(otherp)

STATIC void	S_simplify_sort(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SIMPLIFY_SORT	\
	assert(o)

STATIC const char*	S_gv_ename(pTHX_ GV *gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_ENAME	\
	assert(gv)

STATIC bool	S_scalar_mod_type(const OP *o, I32 type)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_SCALAR_MOD_TYPE	\
	assert(o)

STATIC OP *	S_my_kid(pTHX_ OP *o, OP *attrs, OP **imopsp)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MY_KID	\
	assert(imopsp)

STATIC OP *	S_dup_attrlist(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUP_ATTRLIST	\
	assert(o)

STATIC void	S_apply_attrs(pTHX_ HV *stash, SV *target, OP *attrs, bool for_my)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_APPLY_ATTRS	\
	assert(stash); assert(target)

STATIC void	S_apply_attrs_my(pTHX_ HV *stash, OP *target, OP *attrs, OP **imopsp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_APPLY_ATTRS_MY	\
	assert(stash); assert(target); assert(imopsp)

STATIC void	S_bad_type(pTHX_ I32 n, const char *t, const char *name, const OP *kid)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_BAD_TYPE	\
	assert(t); assert(name); assert(kid)

STATIC void	S_no_bareword_allowed(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NO_BAREWORD_ALLOWED	\
	assert(o)

STATIC OP*	S_no_fh_allowed(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NO_FH_ALLOWED	\
	assert(o)

STATIC OP*	S_too_few_arguments(pTHX_ OP *o, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TOO_FEW_ARGUMENTS	\
	assert(o); assert(name)

STATIC OP*	S_too_many_arguments(pTHX_ OP *o, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TOO_MANY_ARGUMENTS	\
	assert(o); assert(name)

STATIC bool	S_looks_like_bool(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_LOOKS_LIKE_BOOL	\
	assert(o)

STATIC OP*	S_newGIVWHENOP(pTHX_ OP* cond, OP *block, I32 enter_opcode, I32 leave_opcode, PADOFFSET entertarg)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWGIVWHENOP	\
	assert(block)

STATIC OP*	S_ref_array_or_hash(pTHX_ OP* cond);
STATIC void	S_process_special_blocks(pTHX_ const char *const fullname, GV *const gv, CV *const cv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_PROCESS_SPECIAL_BLOCKS	\
	assert(fullname); assert(gv); assert(cv)

#endif
#if defined(PL_OP_SLAB_ALLOC)
PERL_CALLCONV void*	Perl_Slab_Alloc(pTHX_ size_t sz)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_Slab_Free(pTHX_ void *op)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SLAB_FREE	\
	assert(op)

#  if defined(PERL_DEBUG_READONLY_OPS)
PERL_CALLCONV void	Perl_pending_Slabs_to_ro(pTHX);
PERL_CALLCONV OP *	Perl_op_refcnt_inc(pTHX_ OP *o);
PERL_CALLCONV PADOFFSET	Perl_op_refcnt_dec(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OP_REFCNT_DEC	\
	assert(o)

#    if defined(PERL_IN_OP_C)
STATIC void	S_Slab_to_rw(pTHX_ void *op)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SLAB_TO_RW	\
	assert(op)

#    endif
#  endif
#endif

#if defined(PERL_IN_PERL_C) || defined(PERL_DECL_PROT)
STATIC void	S_find_beginning(pTHX_ SV* linestr_sv, PerlIO *rsfp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_FIND_BEGINNING	\
	assert(linestr_sv); assert(rsfp)

STATIC void	S_forbid_setid(pTHX_ const char flag, const bool suidscript);
STATIC void	S_incpush(pTHX_ const char *const dir, STRLEN len, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INCPUSH	\
	assert(dir)

STATIC void	S_incpush_use_sep(pTHX_ const char *p, STRLEN len, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INCPUSH_USE_SEP	\
	assert(p)

STATIC void	S_init_interp(pTHX);
STATIC void	S_init_ids(pTHX);
STATIC void	S_init_main_stash(pTHX);
STATIC void	S_init_perllib(pTHX);
STATIC void	S_init_postdump_symbols(pTHX_ int argc, char **argv, char **env)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_INIT_POSTDUMP_SYMBOLS	\
	assert(argv)

STATIC void	S_init_predump_symbols(pTHX);
STATIC void	S_my_exit_jump(pTHX)
			__attribute__noreturn__;

STATIC void	S_nuke_stacks(pTHX);
STATIC int	S_open_script(pTHX_ const char *scriptname, bool dosearch, bool *suidscript, PerlIO **rsfpp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_OPEN_SCRIPT	\
	assert(scriptname); assert(suidscript); assert(rsfpp)

STATIC void	S_usage(pTHX_ const char *name)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_USAGE	\
	assert(name)

#ifndef SETUID_SCRIPTS_ARE_SECURE_NOW
STATIC void	S_validate_suid(pTHX_ PerlIO *rsfp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VALIDATE_SUID	\
	assert(rsfp)

#endif

STATIC void*	S_parse_body(pTHX_ char **env, XSINIT_t xsinit);
STATIC void	S_run_body(pTHX_ I32 oldscope)
			__attribute__noreturn__;

STATIC SV *	S_incpush_if_exists(pTHX_ AV *const av, SV *dir, SV *const stem)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_INCPUSH_IF_EXISTS	\
	assert(av); assert(dir); assert(stem)

#endif

#if defined(PERL_IN_PP_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_do_delete_local(pTHX);
STATIC SV*	S_refto(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REFTO	\
	assert(sv)

#endif
#if defined(PERL_IN_PP_C) || defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV GV*	Perl_softref2xv(pTHX_ SV *const sv, const char *const what, const svtype type, SV ***spp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_SOFTREF2XV	\
	assert(sv); assert(what); assert(spp)

#endif

#if defined(PERL_IN_PP_PACK_C) || defined(PERL_DECL_PROT)
STATIC I32	S_unpack_rec(pTHX_ struct tempsym* symptr, const char *s, const char *strbeg, const char *strend, const char **new_s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_UNPACK_REC	\
	assert(symptr); assert(s); assert(strbeg); assert(strend)

STATIC SV **	S_pack_rec(pTHX_ SV *cat, struct tempsym* symptr, SV **beglist, SV **endlist)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_PACK_REC	\
	assert(cat); assert(symptr); assert(beglist); assert(endlist)

STATIC SV*	S_mul128(pTHX_ SV *sv, U8 m)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MUL128	\
	assert(sv)

STATIC I32	S_measure_struct(pTHX_ struct tempsym* symptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MEASURE_STRUCT	\
	assert(symptr)

STATIC bool	S_next_symbol(pTHX_ struct tempsym* symptr)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEXT_SYMBOL	\
	assert(symptr)

STATIC SV*	S_is_an_int(pTHX_ const char *s, STRLEN l)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_AN_INT	\
	assert(s)

STATIC int	S_div128(pTHX_ SV *pnum, bool *done)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DIV128	\
	assert(pnum); assert(done)

STATIC const char *	S_group_end(pTHX_ const char *patptr, const char *patend, char ender)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GROUP_END	\
	assert(patptr); assert(patend)

STATIC const char *	S_get_num(pTHX_ const char *patptr, I32 *lenptr)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GET_NUM	\
	assert(patptr); assert(lenptr)

STATIC bool	S_need_utf8(const char *pat, const char *patend)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_NEED_UTF8	\
	assert(pat); assert(patend)

STATIC char	S_first_symbol(const char *pat, const char *patend)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_FIRST_SYMBOL	\
	assert(pat); assert(patend)

STATIC char *	S_sv_exp_grow(pTHX_ SV *sv, STRLEN needed)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_EXP_GROW	\
	assert(sv)

STATIC char *	S_bytes_to_uni(const U8 *start, STRLEN len, char *dest)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_BYTES_TO_UNI	\
	assert(start); assert(dest)

#endif

#if defined(PERL_IN_PP_CTL_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_docatch(pTHX_ OP *o)
			__attribute__warn_unused_result__;

STATIC OP*	S_dofindlabel(pTHX_ OP *o, const char *label, OP **opstack, OP **oplimit)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_DOFINDLABEL	\
	assert(o); assert(label); assert(opstack); assert(oplimit)

STATIC OP*	S_doparseform(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOPARSEFORM	\
	assert(sv)

STATIC bool	S_num_overflow(NV value, I32 fldsize, I32 frcsize)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptoeval(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptogiven(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptolabel(pTHX_ const char *label)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOPOPTOLABEL	\
	assert(label)

STATIC I32	S_dopoptoloop(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptosub_at(pTHX_ const PERL_CONTEXT* cxstk, I32 startingblock)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOPOPTOSUB_AT	\
	assert(cxstk)

STATIC I32	S_dopoptowhen(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC void	S_save_lines(pTHX_ AV *array, SV *sv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SAVE_LINES	\
	assert(sv)

STATIC bool	S_doeval(pTHX_ int gimme, OP** startop, CV* outside, U32 seq);
STATIC PerlIO *	S_check_type_and_open(pTHX_ const char *name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CHECK_TYPE_AND_OPEN	\
	assert(name)

#ifndef PERL_DISABLE_PMC
STATIC PerlIO *	S_doopen_pm(pTHX_ const char *name, const STRLEN namelen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DOOPEN_PM	\
	assert(name)

#endif
STATIC bool	S_path_is_absolute(const char *name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PATH_IS_ABSOLUTE	\
	assert(name)

STATIC I32	S_run_user_filter(pTHX_ int idx, SV *buf_sv, int maxlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_RUN_USER_FILTER	\
	assert(buf_sv)

STATIC PMOP*	S_make_matcher(pTHX_ REGEXP* re)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MAKE_MATCHER	\
	assert(re)

STATIC bool	S_matcher_matches_sv(pTHX_ PMOP* matcher, SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MATCHER_MATCHES_SV	\
	assert(matcher); assert(sv)

STATIC void	S_destroy_matcher(pTHX_ PMOP* matcher)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DESTROY_MATCHER	\
	assert(matcher)

STATIC OP*	S_do_smartmatch(pTHX_ HV* seen_this, HV* seen_other);
#endif

#if defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
STATIC void	S_do_oddball(pTHX_ HV *hash, SV **relem, SV **firstrelem)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DO_ODDBALL	\
	assert(hash); assert(relem); assert(firstrelem)

STATIC SV*	S_method_common(pTHX_ SV* meth, U32* hashp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_METHOD_COMMON	\
	assert(meth)

#endif

#if defined(PERL_IN_PP_SORT_C) || defined(PERL_DECL_PROT)
STATIC I32	S_sv_ncmp(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_NCMP	\
	assert(a); assert(b)

STATIC I32	S_sv_i_ncmp(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_I_NCMP	\
	assert(a); assert(b)

STATIC I32	S_amagic_ncmp(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AMAGIC_NCMP	\
	assert(a); assert(b)

STATIC I32	S_amagic_i_ncmp(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AMAGIC_I_NCMP	\
	assert(a); assert(b)

STATIC I32	S_amagic_cmp(pTHX_ SV *const str1, SV *const str2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AMAGIC_CMP	\
	assert(str1); assert(str2)

STATIC I32	S_amagic_cmp_locale(pTHX_ SV *const str1, SV *const str2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_AMAGIC_CMP_LOCALE	\
	assert(str1); assert(str2)

STATIC I32	S_sortcv(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SORTCV	\
	assert(a); assert(b)

STATIC I32	S_sortcv_xsub(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SORTCV_XSUB	\
	assert(a); assert(b)

STATIC I32	S_sortcv_stacked(pTHX_ SV *const a, SV *const b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SORTCV_STACKED	\
	assert(a); assert(b)

STATIC void	S_qsortsvu(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t compare)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_QSORTSVU	\
	assert(compare)

#endif

#if defined(PERL_IN_PP_SYS_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_doform(pTHX_ CV *cv, GV *gv, OP *retop)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DOFORM	\
	assert(cv); assert(gv); assert(retop)

#  if !defined(HAS_MKDIR) || !defined(HAS_RMDIR)
STATIC int	S_dooneliner(pTHX_ const char *cmd, const char *filename)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DOONELINER	\
	assert(cmd); assert(filename)

#  endif
STATIC SV *	S_space_join_names_mortal(pTHX_ char *const *array)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SPACE_JOIN_NAMES_MORTAL	\
	assert(array)

STATIC OP *	S_tied_handle_method(pTHX_ const char *const methname, SV **sp, IO *const io, MAGIC *const mg, const U32 flags, ...)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_TIED_HANDLE_METHOD	\
	assert(methname); assert(sp); assert(io); assert(mg)

#endif

#if defined(PERL_IN_REGCOMP_C) || defined(PERL_DECL_PROT)
STATIC regnode*	S_reg(pTHX_ struct RExC_state_t *pRExC_state, I32 paren, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REG	\
	assert(pRExC_state); assert(flagp)

STATIC regnode*	S_reganode(pTHX_ struct RExC_state_t *pRExC_state, U8 op, U32 arg)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGANODE	\
	assert(pRExC_state)

STATIC regnode*	S_regatom(pTHX_ struct RExC_state_t *pRExC_state, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGATOM	\
	assert(pRExC_state); assert(flagp)

STATIC regnode*	S_regbranch(pTHX_ struct RExC_state_t *pRExC_state, I32 *flagp, I32 first, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGBRANCH	\
	assert(pRExC_state); assert(flagp)

STATIC STRLEN	S_reguni(pTHX_ const struct RExC_state_t *pRExC_state, UV uv, char *s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGUNI	\
	assert(pRExC_state); assert(s)

STATIC regnode*	S_regclass(pTHX_ struct RExC_state_t *pRExC_state, U32 depth)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGCLASS	\
	assert(pRExC_state)

STATIC regnode*	S_reg_node(pTHX_ struct RExC_state_t *pRExC_state, U8 op)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NODE	\
	assert(pRExC_state)

STATIC UV	S_reg_recode(pTHX_ const char value, SV **encp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_RECODE	\
	assert(encp)

STATIC regnode*	S_regpiece(pTHX_ struct RExC_state_t *pRExC_state, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGPIECE	\
	assert(pRExC_state); assert(flagp)

STATIC regnode*	S_reg_namedseq(pTHX_ struct RExC_state_t *pRExC_state, UV *valuep, I32 *flagp)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_NAMEDSEQ	\
	assert(pRExC_state)

STATIC void	S_reginsert(pTHX_ struct RExC_state_t *pRExC_state, U8 op, regnode *opnd, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGINSERT	\
	assert(pRExC_state); assert(opnd)

STATIC void	S_regtail(pTHX_ struct RExC_state_t *pRExC_state, regnode *p, const regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGTAIL	\
	assert(pRExC_state); assert(p); assert(val)

STATIC SV *	S_reg_scan_name(pTHX_ struct RExC_state_t *pRExC_state, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_SCAN_NAME	\
	assert(pRExC_state)

STATIC U32	S_join_exact(pTHX_ struct RExC_state_t *pRExC_state, regnode *scan, I32 *min, U32 flags, regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_JOIN_EXACT	\
	assert(pRExC_state); assert(scan); assert(min)

STATIC char *	S_regwhite(struct RExC_state_t *pRExC_state, char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_REGWHITE	\
	assert(pRExC_state); assert(p)

STATIC char *	S_nextchar(pTHX_ struct RExC_state_t *pRExC_state)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NEXTCHAR	\
	assert(pRExC_state)

STATIC bool	S_reg_skipcomment(pTHX_ struct RExC_state_t *pRExC_state)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REG_SKIPCOMMENT	\
	assert(pRExC_state)

STATIC void	S_scan_commit(pTHX_ const struct RExC_state_t *pRExC_state, struct scan_data_t *data, I32 *minlenp, int is_inf)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_COMMIT	\
	assert(pRExC_state); assert(data); assert(minlenp)

STATIC void	S_cl_anything(const struct RExC_state_t *pRExC_state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_CL_ANYTHING	\
	assert(pRExC_state); assert(cl)

STATIC int	S_cl_is_anything(const struct regnode_charclass_class *cl)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_CL_IS_ANYTHING	\
	assert(cl)

STATIC void	S_cl_init(const struct RExC_state_t *pRExC_state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_CL_INIT	\
	assert(pRExC_state); assert(cl)

STATIC void	S_cl_init_zero(const struct RExC_state_t *pRExC_state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_CL_INIT_ZERO	\
	assert(pRExC_state); assert(cl)

STATIC void	S_cl_and(struct regnode_charclass_class *cl, const struct regnode_charclass_class *and_with)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_CL_AND	\
	assert(cl); assert(and_with)

STATIC void	S_cl_or(const struct RExC_state_t *pRExC_state, struct regnode_charclass_class *cl, const struct regnode_charclass_class *or_with)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_CL_OR	\
	assert(pRExC_state); assert(cl); assert(or_with)

STATIC I32	S_study_chunk(pTHX_ struct RExC_state_t *pRExC_state, regnode **scanp, I32 *minlenp, I32 *deltap, regnode *last, struct scan_data_t *data, I32 stopparen, U8* recursed, struct regnode_charclass_class *and_withp, U32 flags, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_STUDY_CHUNK	\
	assert(pRExC_state); assert(scanp); assert(minlenp); assert(deltap); assert(last)

STATIC U32	S_add_data(struct RExC_state_t *pRExC_state, U32 n, const char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_ADD_DATA	\
	assert(pRExC_state); assert(s)

STATIC void	S_re_croak2(pTHX_ const char* pat1, const char* pat2, ...)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_RE_CROAK2	\
	assert(pat1); assert(pat2)

STATIC I32	S_regpposixcc(pTHX_ struct RExC_state_t *pRExC_state, I32 value)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGPPOSIXCC	\
	assert(pRExC_state)

STATIC void	S_checkposixcc(pTHX_ struct RExC_state_t *pRExC_state)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CHECKPOSIXCC	\
	assert(pRExC_state)

STATIC I32	S_make_trie(pTHX_ struct RExC_state_t *pRExC_state, regnode *startbranch, regnode *first, regnode *last, regnode *tail, U32 word_count, U32 flags, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_MAKE_TRIE	\
	assert(pRExC_state); assert(startbranch); assert(first); assert(last); assert(tail)

STATIC void	S_make_trie_failtable(pTHX_ struct RExC_state_t *pRExC_state, regnode *source, regnode *stclass, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MAKE_TRIE_FAILTABLE	\
	assert(pRExC_state); assert(source); assert(stclass)

#  ifdef DEBUGGING
STATIC void	S_regdump_extflags(pTHX_ const char *lead, const U32 flags);
STATIC const regnode*	S_dumpuntil(pTHX_ const regexp *r, const regnode *start, const regnode *node, const regnode *last, const regnode *plast, SV* sv, I32 indent, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_6);
#define PERL_ARGS_ASSERT_DUMPUNTIL	\
	assert(r); assert(start); assert(node); assert(sv)

STATIC void	S_put_byte(pTHX_ SV* sv, int c)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PUT_BYTE	\
	assert(sv)

STATIC void	S_dump_trie(pTHX_ const struct _reg_trie_data *trie, HV* widecharmap, AV *revcharmap, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DUMP_TRIE	\
	assert(trie); assert(revcharmap)

STATIC void	S_dump_trie_interim_list(pTHX_ const struct _reg_trie_data *trie, HV* widecharmap, AV *revcharmap, U32 next_alloc, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DUMP_TRIE_INTERIM_LIST	\
	assert(trie); assert(revcharmap)

STATIC void	S_dump_trie_interim_table(pTHX_ const struct _reg_trie_data *trie, HV* widecharmap, AV *revcharmap, U32 next_alloc, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_DUMP_TRIE_INTERIM_TABLE	\
	assert(trie); assert(revcharmap)

STATIC U8	S_regtail_study(pTHX_ struct RExC_state_t *pRExC_state, regnode *p, const regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGTAIL_STUDY	\
	assert(pRExC_state); assert(p); assert(val)

#  endif
#endif

#if defined(PERL_IN_REGEXEC_C) || defined(PERL_DECL_PROT)
STATIC I32	S_regmatch(pTHX_ regmatch_info *reginfo, regnode *prog)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGMATCH	\
	assert(reginfo); assert(prog)

STATIC I32	S_regrepeat(pTHX_ const regexp *prog, const regnode *p, I32 max, int depth)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGREPEAT	\
	assert(prog); assert(p)

STATIC I32	S_regtry(pTHX_ regmatch_info *reginfo, char **startpos)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REGTRY	\
	assert(reginfo); assert(startpos)

STATIC bool	S_reginclass(pTHX_ const regexp *prog, const regnode *n, const U8 *p, STRLEN *lenp, bool do_utf8sv_is_utf8)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_REGINCLASS	\
	assert(n); assert(p)

STATIC CHECKPOINT	S_regcppush(pTHX_ I32 parenfloor);
STATIC char*	S_regcppop(pTHX_ const regexp *rex)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_REGCPPOP	\
	assert(rex)

STATIC U8*	S_reghop3(U8 *s, I32 off, const U8 *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_REGHOP3	\
	assert(s); assert(lim)

#ifdef XXX_dmq
STATIC U8*	S_reghop4(U8 *s, I32 off, const U8 *llim, const U8 *rlim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4);
#define PERL_ARGS_ASSERT_REGHOP4	\
	assert(s); assert(llim); assert(rlim)

#endif
STATIC U8*	S_reghopmaybe3(U8 *s, I32 off, const U8 *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_REGHOPMAYBE3	\
	assert(s); assert(lim)

STATIC char*	S_find_byclass(pTHX_ regexp * prog, const regnode *c, char *s, const char *strend, regmatch_info *reginfo)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_FIND_BYCLASS	\
	assert(prog); assert(c); assert(s); assert(strend)

STATIC void	S_to_utf8_substr(pTHX_ regexp * prog)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_TO_UTF8_SUBSTR	\
	assert(prog)

STATIC void	S_to_byte_substr(pTHX_ regexp * prog)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_TO_BYTE_SUBSTR	\
	assert(prog)

STATIC I32	S_reg_check_named_buff_matched(pTHX_ const regexp *rex, const regnode *scan)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_REG_CHECK_NAMED_BUFF_MATCHED	\
	assert(rex); assert(scan)

#  ifdef DEBUGGING
STATIC void	S_dump_exec_pos(pTHX_ const char *locinput, const regnode *scan, const char *loc_regeol, const char *loc_bostr, const char *loc_reg_starttry, const bool do_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_DUMP_EXEC_POS	\
	assert(locinput); assert(scan); assert(loc_regeol); assert(loc_bostr); assert(loc_reg_starttry)

STATIC void	S_debug_start_match(pTHX_ const REGEXP *prog, const bool do_utf8, const char *start, const char *end, const char *blurb)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_DEBUG_START_MATCH	\
	assert(prog); assert(start); assert(end); assert(blurb)

#  endif
#endif

#if defined(PERL_IN_DUMP_C) || defined(PERL_DECL_PROT)
STATIC CV*	S_deb_curcv(pTHX_ const I32 ix);
STATIC void	S_debprof(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DEBPROF	\
	assert(o)

STATIC void	S_sequence(pTHX_ const OP *o);
STATIC void	S_sequence_tail(pTHX_ const OP *o);
STATIC UV	S_sequence_num(pTHX_ const OP *o);
STATIC SV*	S_pm_description(pTHX_ const PMOP *pm)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PM_DESCRIPTION	\
	assert(pm)

#endif

#if defined(PERL_IN_SCOPE_C) || defined(PERL_DECL_PROT)
STATIC SV*	S_save_scalar_at(pTHX_ SV **sptr, const U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SCALAR_AT	\
	assert(sptr)

#endif

#if defined(PERL_IN_GV_C) || defined(PERL_IN_SV_C) || defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV void	Perl_sv_add_backref(pTHX_ SV *const tsv, SV *const sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_ADD_BACKREF	\
	assert(tsv); assert(sv)

#endif

#if defined(PERL_IN_HV_C) || defined(PERL_IN_MG_C) || defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV int	Perl_sv_kill_backrefs(pTHX_ SV *const sv, AV *const av)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_KILL_BACKREFS	\
	assert(sv); assert(av)

#endif

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC char *	S_uiv_2buf(char *const buf, const IV iv, UV uv, const int is_uv, char **const peob)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(5);
#define PERL_ARGS_ASSERT_UIV_2BUF	\
	assert(buf); assert(peob)

STATIC void	S_sv_unglob(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UNGLOB	\
	assert(sv)

STATIC void	S_not_a_number(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NOT_A_NUMBER	\
	assert(sv)

STATIC I32	S_visit(pTHX_ SVFUNC_t f, const U32 flags, const U32 mask)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_VISIT	\
	assert(f)

STATIC void	S_sv_del_backref(pTHX_ SV *const tsv, SV *const sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_DEL_BACKREF	\
	assert(tsv); assert(sv)

STATIC SV *	S_varname(pTHX_ const GV *const gv, const char gvtype, PADOFFSET targ, const SV *const keyname, I32 aindex, int subscript_type)
			__attribute__warn_unused_result__;

#  ifdef DEBUGGING
STATIC void	S_del_sv(pTHX_ SV *p)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DEL_SV	\
	assert(p)

#  endif
#  if !defined(NV_PRESERVES_UV)
#    ifdef DEBUGGING
STATIC int	S_sv_2iuv_non_preserve(pTHX_ SV *const sv, I32 numtype)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2IUV_NON_PRESERVE	\
	assert(sv)

#    else
STATIC int	S_sv_2iuv_non_preserve(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2IUV_NON_PRESERVE	\
	assert(sv)

#    endif
#  endif
STATIC I32	S_expect_number(pTHX_ char **const pattern)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_EXPECT_NUMBER	\
	assert(pattern)

#
STATIC STRLEN	S_sv_pos_u2b_forwards(const U8 *const start, const U8 *const send, STRLEN uoffset)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_POS_U2B_FORWARDS	\
	assert(start); assert(send)

STATIC STRLEN	S_sv_pos_u2b_midway(const U8 *const start, const U8 *send, const STRLEN uoffset, const STRLEN uend)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SV_POS_U2B_MIDWAY	\
	assert(start); assert(send)

STATIC STRLEN	S_sv_pos_u2b_cached(pTHX_ SV *const sv, MAGIC **const mgp, const U8 *const start, const U8 *const send, const STRLEN uoffset, STRLEN uoffset0, STRLEN boffset0)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);
#define PERL_ARGS_ASSERT_SV_POS_U2B_CACHED	\
	assert(sv); assert(mgp); assert(start); assert(send)

STATIC void	S_utf8_mg_pos_cache_update(pTHX_ SV *const sv, MAGIC **const mgp, const STRLEN byte, const STRLEN utf8, const STRLEN blen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_UTF8_MG_POS_CACHE_UPDATE	\
	assert(sv); assert(mgp)

STATIC STRLEN	S_sv_pos_b2u_midway(pTHX_ const U8 *const s, const U8 *const target, const U8 *end, STRLEN endu)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SV_POS_B2U_MIDWAY	\
	assert(s); assert(target); assert(end)

STATIC char *	S_F0convert(NV nv, char *const endbuf, STRLEN *const len)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_F0CONVERT	\
	assert(endbuf); assert(len)

#  if defined(PERL_OLD_COPY_ON_WRITE)
STATIC void	S_sv_release_COW(pTHX_ SV *sv, const char *pvx, SV *after)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SV_RELEASE_COW	\
	assert(sv); assert(pvx); assert(after)

#  endif
STATIC SV *	S_more_sv(pTHX);
STATIC void *	S_more_bodies(pTHX_ const svtype sv_type);
STATIC bool	S_sv_2iuv_common(pTHX_ SV *const sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_2IUV_COMMON	\
	assert(sv)

STATIC void	S_glob_assign_glob(pTHX_ SV *const dstr, SV *const sstr, const int dtype)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GLOB_ASSIGN_GLOB	\
	assert(dstr); assert(sstr)

STATIC void	S_glob_assign_ref(pTHX_ SV *const dstr, SV *const sstr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_GLOB_ASSIGN_REF	\
	assert(dstr); assert(sstr)

STATIC PTR_TBL_ENT_t *	S_ptr_table_find(PTR_TBL_t *const tbl, const void *const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PTR_TABLE_FIND	\
	assert(tbl)

#endif

#if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
STATIC void	S_check_uni(pTHX);
STATIC void	S_force_next(pTHX_ I32 type);
STATIC char*	S_force_version(pTHX_ char *s, int guessing)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORCE_VERSION	\
	assert(s)

STATIC char*	S_force_strict_version(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORCE_STRICT_VERSION	\
	assert(s)

STATIC char*	S_force_word(pTHX_ char *start, int token, int check_keyword, int allow_pack, int allow_tick)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORCE_WORD	\
	assert(start)

STATIC SV*	S_tokeq(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_TOKEQ	\
	assert(sv)

STATIC void	S_readpipe_override(pTHX);
STATIC char*	S_scan_const(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_CONST	\
	assert(start)

STATIC char*	S_scan_formline(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_FORMLINE	\
	assert(s)

STATIC char*	S_scan_heredoc(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_HEREDOC	\
	assert(s)

STATIC char*	S_scan_ident(pTHX_ char *s, const char *send, char *dest, STRLEN destlen, I32 ck_uni)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_SCAN_IDENT	\
	assert(s); assert(send); assert(dest)

STATIC char*	S_scan_inputsymbol(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_INPUTSYMBOL	\
	assert(start)

STATIC char*	S_scan_pat(pTHX_ char *start, I32 type)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_PAT	\
	assert(start)

STATIC char*	S_scan_str(pTHX_ char *start, int keep_quoted, int keep_delims)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_STR	\
	assert(start)

STATIC char*	S_scan_subst(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_SUBST	\
	assert(start)

STATIC char*	S_scan_trans(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SCAN_TRANS	\
	assert(start)

STATIC char*	S_scan_word(pTHX_ char *s, char *dest, STRLEN destlen, int allow_package, STRLEN *slp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_SCAN_WORD	\
	assert(s); assert(dest); assert(slp)

STATIC void	S_update_debugger_info(pTHX_ SV *orig_sv, const char *const buf, STRLEN len);
STATIC char*	S_skipspace(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SKIPSPACE	\
	assert(s)

STATIC char*	S_swallow_bom(pTHX_ U8 *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SWALLOW_BOM	\
	assert(s)

#ifndef PERL_NO_UTF16_FILTER
STATIC I32	S_utf16_textfilter(pTHX_ int idx, SV *sv, int maxlen)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_UTF16_TEXTFILTER	\
	assert(sv)

STATIC U8*	S_add_utf16_textfilter(pTHX_ U8 *const s, bool reversed)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_ADD_UTF16_TEXTFILTER	\
	assert(s)

#endif
STATIC void	S_checkcomma(pTHX_ const char *s, const char *name, const char *what)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_CHECKCOMMA	\
	assert(s); assert(name); assert(what)

STATIC bool	S_feature_is_enabled(pTHX_ const char *const name, STRLEN namelen)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FEATURE_IS_ENABLED	\
	assert(name)

STATIC void	S_force_ident(pTHX_ const char *s, int kind)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FORCE_IDENT	\
	assert(s)

STATIC void	S_incline(pTHX_ const char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INCLINE	\
	assert(s)

STATIC int	S_intuit_method(pTHX_ char *s, GV *gv, CV *cv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INTUIT_METHOD	\
	assert(s)

STATIC int	S_intuit_more(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_INTUIT_MORE	\
	assert(s)

STATIC I32	S_lop(pTHX_ I32 f, int x, char *s)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_LOP	\
	assert(s)

STATIC void	S_missingterm(pTHX_ char *s)
			__attribute__noreturn__;

STATIC void	S_no_op(pTHX_ const char *const what, char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_NO_OP	\
	assert(what)

STATIC I32	S_sublex_done(pTHX)
			__attribute__warn_unused_result__;

STATIC I32	S_sublex_push(pTHX)
			__attribute__warn_unused_result__;

STATIC I32	S_sublex_start(pTHX)
			__attribute__warn_unused_result__;

STATIC char *	S_filter_gets(pTHX_ SV *sv, STRLEN append)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FILTER_GETS	\
	assert(sv)

STATIC HV *	S_find_in_my_stash(pTHX_ const char *pkgname, STRLEN len)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_FIND_IN_MY_STASH	\
	assert(pkgname)

STATIC char *	S_tokenize_use(pTHX_ int is_use, char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TOKENIZE_USE	\
	assert(s)

STATIC SV*	S_new_constant(pTHX_ const char *s, STRLEN len, const char *key, STRLEN keylen, SV *sv, SV *pv, const char *type, STRLEN typelen)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_5);
#define PERL_ARGS_ASSERT_NEW_CONSTANT	\
	assert(key); assert(sv)

STATIC int	S_deprecate_commaless_var_list(pTHX);
STATIC int	S_ao(pTHX_ int toketype);
#  if defined(PERL_CR_FILTER)
STATIC I32	S_cr_textfilter(pTHX_ int idx, SV *sv, int maxlen);
STATIC void	S_strip_return(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_STRIP_RETURN	\
	assert(sv)

#  endif
#  if defined(DEBUGGING)
STATIC int	S_tokereport(pTHX_ I32 rv, const YYSTYPE* lvalp)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_TOKEREPORT	\
	assert(lvalp)

STATIC void	S_printbuf(pTHX_ const char *const fmt, const char *const s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PRINTBUF	\
	assert(fmt); assert(s)

#  endif
#endif

#if defined(PERL_IN_UNIVERSAL_C) || defined(PERL_DECL_PROT)
STATIC bool	S_isa_lookup(pTHX_ HV *stash, const char * const name)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_ISA_LOOKUP	\
	assert(stash); assert(name)

STATIC HV *	S_get_isa_hash(pTHX_ HV *const stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_ISA_HASH	\
	assert(stash)

#endif

#if defined(PERL_IN_LOCALE_C) || defined(PERL_DECL_PROT)
#if defined(USE_LOCALE_NUMERIC) || defined(USE_LOCALE_COLLATE)
STATIC char*	S_stdize_locale(pTHX_ char* locs)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_STDIZE_LOCALE	\
	assert(locs)

#endif
#endif

#if defined(PERL_IN_UTIL_C) || defined(PERL_DECL_PROT)
STATIC const COP*	S_closest_cop(pTHX_ const COP *cop, const OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_CLOSEST_COP	\
	assert(cop)

STATIC SV*	S_mess_alloc(pTHX);
STATIC SV *	S_with_queued_errors(pTHX_ SV *ex)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_WITH_QUEUED_ERRORS	\
	assert(ex)

STATIC bool	S_invoke_exception_hook(pTHX_ SV *ex, bool warn);
STATIC char *	S_write_no_mem(pTHX)
			__attribute__noreturn__;

#if defined(PERL_MEM_LOG) && !defined(PERL_MEM_LOG_NOIMPL)
STATIC void	S_mem_log_common(enum mem_log_type mlt, const UV n, const UV typesize, const char *type_name, const SV *sv, Malloc_t oldalloc, Malloc_t newalloc, const char *filename, const int linenumber, const char *funcname)
			__attribute__nonnull__(4)
			__attribute__nonnull__(8)
			__attribute__nonnull__(10);
#define PERL_ARGS_ASSERT_MEM_LOG_COMMON	\
	assert(type_name); assert(filename); assert(funcname)

#endif
#endif

#if defined(PERL_IN_NUMERIC_C) || defined(PERL_DECL_PROT)
STATIC NV	S_mulexp10(NV value, I32 exponent);
#endif

#if defined(PERL_IN_UTF8_C) || defined(PERL_DECL_PROT)
STATIC STRLEN	S_is_utf8_char_slow(const U8 *s, const STRLEN len)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_IS_UTF8_CHAR_SLOW	\
	assert(s)

STATIC bool	S_is_utf8_common(pTHX_ const U8 *const p, SV **swash, const char * const swashname)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_IS_UTF8_COMMON	\
	assert(p); assert(swash); assert(swashname)

STATIC SV*	S_swash_get(pTHX_ SV* swash, UV start, UV span)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SWASH_GET	\
	assert(swash)

#endif

START_EXTERN_C

PERL_CALLCONV void	Perl_sv_setsv_flags(pTHX_ SV *dstr, SV *sstr, const I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_SETSV_FLAGS	\
	assert(dstr)

PERL_CALLCONV void	Perl_sv_catpvn_flags(pTHX_ SV *const dstr, const char *sstr, const STRLEN len, const I32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_CATPVN_FLAGS	\
	assert(dstr); assert(sstr)

PERL_CALLCONV void	Perl_sv_catsv_flags(pTHX_ SV *const dsv, SV *const ssv, const I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_CATSV_FLAGS	\
	assert(dsv)

/* PERL_CALLCONV STRLEN	Perl_sv_utf8_upgrade_flags(pTHX_ SV *const sv, const I32 flags)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV STRLEN	Perl_sv_utf8_upgrade_flags_grow(pTHX_ SV *const sv, const I32 flags, STRLEN extra)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_UTF8_UPGRADE_FLAGS_GROW	\
	assert(sv)

PERL_CALLCONV char*	Perl_sv_pvn_force_flags(pTHX_ SV *const sv, STRLEN *const lp, const I32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_PVN_FORCE_FLAGS	\
	assert(sv)

PERL_CALLCONV void	Perl_sv_copypv(pTHX_ SV *const dsv, SV *const ssv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_COPYPV	\
	assert(dsv); assert(ssv)

PERL_CALLCONV char*	Perl_my_atof2(pTHX_ const char *s, NV* value)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MY_ATOF2	\
	assert(s); assert(value)

PERL_CALLCONV int	Perl_my_socketpair(int family, int type, int protocol, int fd[2]);
PERL_CALLCONV int	Perl_my_dirfd(pTHX_ DIR* dir);
#ifdef PERL_OLD_COPY_ON_WRITE
PERL_CALLCONV SV*	Perl_sv_setsv_cow(pTHX_ SV* dstr, SV* sstr)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_SETSV_COW	\
	assert(sstr)

#endif

PERL_CALLCONV const char *	Perl_PerlIO_context_layers(pTHX_ const char *mode);

#if defined(USE_PERLIO) && !defined(USE_SFIO)
PERL_CALLCONV int	Perl_PerlIO_close(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_fill(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_fileno(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_eof(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_error(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_flush(pTHX_ PerlIO *f);
PERL_CALLCONV void	Perl_PerlIO_clearerr(pTHX_ PerlIO *f);
PERL_CALLCONV void	Perl_PerlIO_set_cnt(pTHX_ PerlIO *f, int cnt);
PERL_CALLCONV void	Perl_PerlIO_set_ptrcnt(pTHX_ PerlIO *f, STDCHAR *ptr, int cnt);
PERL_CALLCONV void	Perl_PerlIO_setlinebuf(pTHX_ PerlIO *f);
PERL_CALLCONV SSize_t	Perl_PerlIO_read(pTHX_ PerlIO *f, void *vbuf, Size_t count)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PERLIO_READ	\
	assert(vbuf)

PERL_CALLCONV SSize_t	Perl_PerlIO_write(pTHX_ PerlIO *f, const void *vbuf, Size_t count)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PERLIO_WRITE	\
	assert(vbuf)

PERL_CALLCONV SSize_t	Perl_PerlIO_unread(pTHX_ PerlIO *f, const void *vbuf, Size_t count)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PERLIO_UNREAD	\
	assert(vbuf)

PERL_CALLCONV Off_t	Perl_PerlIO_tell(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_seek(pTHX_ PerlIO *f, Off_t offset, int whence);

PERL_CALLCONV STDCHAR *	Perl_PerlIO_get_base(pTHX_ PerlIO *f);
PERL_CALLCONV STDCHAR *	Perl_PerlIO_get_ptr(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_get_bufsiz(pTHX_ PerlIO *f)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_PerlIO_get_cnt(pTHX_ PerlIO *f)
			__attribute__warn_unused_result__;


PERL_CALLCONV PerlIO *	Perl_PerlIO_stdin(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV PerlIO *	Perl_PerlIO_stdout(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV PerlIO *	Perl_PerlIO_stderr(pTHX)
			__attribute__warn_unused_result__;

#endif /* PERLIO_LAYERS */

PERL_CALLCONV void	Perl_deb_stack_all(pTHX);
#if defined(PERL_IN_DEB_C) || defined(PERL_DECL_PROT)
STATIC void	S_deb_stack_n(pTHX_ SV** stack_base, I32 stack_min, I32 stack_max, I32 mark_min, I32 mark_max)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DEB_STACK_N	\
	assert(stack_base)

#endif

PERL_CALLCONV PADLIST*	Perl_pad_new(pTHX_ int flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_pad_undef(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_UNDEF	\
	assert(cv)

PERL_CALLCONV PADOFFSET	Perl_pad_add_name(pTHX_ const char *name, const STRLEN len, const U32 flags, HV *typestash, HV *ourstash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_ADD_NAME	\
	assert(name)

PERL_CALLCONV PADOFFSET	Perl_pad_add_anon(pTHX_ SV* sv, OPCODE op_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_ADD_ANON	\
	assert(sv)

#if defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
STATIC void	S_pad_check_dup(pTHX_ SV *name, const U32 flags, const HV *ourstash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_CHECK_DUP	\
	assert(name)

#endif
#ifdef DEBUGGING
PERL_CALLCONV void	Perl_pad_setsv(pTHX_ PADOFFSET po, SV* sv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PAD_SETSV	\
	assert(sv)

#endif
PERL_CALLCONV void	Perl_pad_block_start(pTHX_ int full);
PERL_CALLCONV void	Perl_pad_tidy(pTHX_ padtidy_type type);
PERL_CALLCONV void	Perl_do_dump_pad(pTHX_ I32 level, PerlIO *file, PADLIST *padlist, int full)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_DUMP_PAD	\
	assert(file)

PERL_CALLCONV void	Perl_pad_fixup_inner_anons(pTHX_ PADLIST *padlist, CV *old_cv, CV *new_cv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_PAD_FIXUP_INNER_ANONS	\
	assert(padlist); assert(old_cv); assert(new_cv)


PERL_CALLCONV void	Perl_pad_push(pTHX_ PADLIST *padlist, int depth)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_PUSH	\
	assert(padlist)

PERL_CALLCONV HV*	Perl_pad_compname_type(pTHX_ const PADOFFSET po)
			__attribute__warn_unused_result__;

#if defined(USE_ITHREADS)
PERL_CALLCONV AV*	Perl_padlist_dup(pTHX_ AV *const srcpad, CLONE_PARAMS *const param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_PADLIST_DUP	\
	assert(param)

#endif

#if defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
STATIC PADOFFSET	S_pad_findlex(pTHX_ const char *name, const CV* cv, U32 seq, int warn, SV** out_capture, SV** out_name_sv, int *out_flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_6)
			__attribute__nonnull__(pTHX_7);
#define PERL_ARGS_ASSERT_PAD_FINDLEX	\
	assert(name); assert(cv); assert(out_name_sv); assert(out_flags)

STATIC PADOFFSET	S_pad_add_name_sv(pTHX_ SV *namesv, const U32 flags, HV *typestash, HV *ourstash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_PAD_ADD_NAME_SV	\
	assert(namesv)

#  if defined(DEBUGGING)
STATIC void	S_cv_dump(pTHX_ const CV *cv, const char *title)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_CV_DUMP	\
	assert(cv); assert(title)

#  endif
#endif
PERL_CALLCONV CV*	Perl_find_runcv(pTHX_ U32 *db_seqp)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_free_tied_hv_pool(pTHX);
#if defined(DEBUGGING)
PERL_CALLCONV int	Perl_get_debug_opts(pTHX_ const char **s, bool givehelp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GET_DEBUG_OPTS	\
	assert(s)

#endif
PERL_CALLCONV void	Perl_save_set_svflags(pTHX_ SV *sv, U32 mask, U32 val)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SAVE_SET_SVFLAGS	\
	assert(sv)

#ifdef DEBUGGING
PERL_CALLCONV void	Perl_hv_assert(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_ASSERT	\
	assert(hv)

#endif

PERL_CALLCONV SV*	Perl_hv_scalar(pTHX_ HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_SCALAR	\
	assert(hv)

PERL_CALLCONV I32*	Perl_hv_riter_p(pTHX_ HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_RITER_P	\
	assert(hv)

PERL_CALLCONV HE**	Perl_hv_eiter_p(pTHX_ HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_EITER_P	\
	assert(hv)

PERL_CALLCONV void	Perl_hv_riter_set(pTHX_ HV *hv, I32 riter)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_RITER_SET	\
	assert(hv)

PERL_CALLCONV void	Perl_hv_eiter_set(pTHX_ HV *hv, HE *eiter)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_EITER_SET	\
	assert(hv)

PERL_CALLCONV void	Perl_hv_name_set(pTHX_ HV *hv, const char *name, U32 len, U32 flags)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_NAME_SET	\
	assert(hv)

PERL_CALLCONV AV**	Perl_hv_backreferences_p(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_BACKREFERENCES_P	\
	assert(hv)

#if defined(PERL_IN_DUMP_C) || defined(PERL_IN_HV_C) || defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV void	Perl_hv_kill_backrefs(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_KILL_BACKREFS	\
	assert(hv)

#endif
PERL_CALLCONV void	Perl_hv_clear_placeholders(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_CLEAR_PLACEHOLDERS	\
	assert(hv)

PERL_CALLCONV I32*	Perl_hv_placeholders_p(pTHX_ HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_PLACEHOLDERS_P	\
	assert(hv)

PERL_CALLCONV I32	Perl_hv_placeholders_get(pTHX_ const HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_PLACEHOLDERS_GET	\
	assert(hv)

PERL_CALLCONV void	Perl_hv_placeholders_set(pTHX_ HV *hv, I32 ph)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_HV_PLACEHOLDERS_SET	\
	assert(hv)


PERL_CALLCONV SV*	Perl_magic_scalarpack(pTHX_ HV *hv, MAGIC *mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MAGIC_SCALARPACK	\
	assert(hv); assert(mg)


#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC SV *	S_find_hash_subscript(pTHX_ const HV *const hv, const SV *const val)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_FIND_HASH_SUBSCRIPT	\
	assert(val)

STATIC I32	S_find_array_subscript(pTHX_ const AV *const av, const SV *const val)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_FIND_ARRAY_SUBSCRIPT	\
	assert(val)

STATIC SV*	S_find_uninit_var(pTHX_ const OP *const obase, const SV *const uninit_sv, bool top);
#endif

#ifdef PERL_NEED_MY_HTOLE16
PERL_CALLCONV U16	Perl_my_htole16(U16 n);
#endif
#ifdef PERL_NEED_MY_LETOH16
PERL_CALLCONV U16	Perl_my_letoh16(U16 n);
#endif
#ifdef PERL_NEED_MY_HTOBE16
PERL_CALLCONV U16	Perl_my_htobe16(U16 n);
#endif
#ifdef PERL_NEED_MY_BETOH16
PERL_CALLCONV U16	Perl_my_betoh16(U16 n);
#endif
#ifdef PERL_NEED_MY_HTOLE32
PERL_CALLCONV U32	Perl_my_htole32(U32 n);
#endif
#ifdef PERL_NEED_MY_LETOH32
PERL_CALLCONV U32	Perl_my_letoh32(U32 n);
#endif
#ifdef PERL_NEED_MY_HTOBE32
PERL_CALLCONV U32	Perl_my_htobe32(U32 n);
#endif
#ifdef PERL_NEED_MY_BETOH32
PERL_CALLCONV U32	Perl_my_betoh32(U32 n);
#endif
#ifdef PERL_NEED_MY_HTOLE64
PERL_CALLCONV U64	Perl_my_htole64(U64 n);
#endif
#ifdef PERL_NEED_MY_LETOH64
PERL_CALLCONV U64	Perl_my_letoh64(U64 n);
#endif
#ifdef PERL_NEED_MY_HTOBE64
PERL_CALLCONV U64	Perl_my_htobe64(U64 n);
#endif
#ifdef PERL_NEED_MY_BETOH64
PERL_CALLCONV U64	Perl_my_betoh64(U64 n);
#endif

#ifdef PERL_NEED_MY_HTOLES
PERL_CALLCONV short	Perl_my_htoles(short n);
#endif
#ifdef PERL_NEED_MY_LETOHS
PERL_CALLCONV short	Perl_my_letohs(short n);
#endif
#ifdef PERL_NEED_MY_HTOBES
PERL_CALLCONV short	Perl_my_htobes(short n);
#endif
#ifdef PERL_NEED_MY_BETOHS
PERL_CALLCONV short	Perl_my_betohs(short n);
#endif
#ifdef PERL_NEED_MY_HTOLEI
PERL_CALLCONV int	Perl_my_htolei(int n);
#endif
#ifdef PERL_NEED_MY_LETOHI
PERL_CALLCONV int	Perl_my_letohi(int n);
#endif
#ifdef PERL_NEED_MY_HTOBEI
PERL_CALLCONV int	Perl_my_htobei(int n);
#endif
#ifdef PERL_NEED_MY_BETOHI
PERL_CALLCONV int	Perl_my_betohi(int n);
#endif
#ifdef PERL_NEED_MY_HTOLEL
PERL_CALLCONV long	Perl_my_htolel(long n);
#endif
#ifdef PERL_NEED_MY_LETOHL
PERL_CALLCONV long	Perl_my_letohl(long n);
#endif
#ifdef PERL_NEED_MY_HTOBEL
PERL_CALLCONV long	Perl_my_htobel(long n);
#endif
#ifdef PERL_NEED_MY_BETOHL
PERL_CALLCONV long	Perl_my_betohl(long n);
#endif

PERL_CALLCONV void	Perl_my_swabn(void* ptr, int n)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_MY_SWABN	\
	assert(ptr)


PERL_CALLCONV GV*	Perl_gv_fetchpvn_flags(pTHX_ const char* name, STRLEN len, I32 flags, const svtype sv_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_FETCHPVN_FLAGS	\
	assert(name)

PERL_CALLCONV GV*	Perl_gv_fetchsv(pTHX_ SV *name, I32 flags, const svtype sv_type)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_GV_FETCHSV	\
	assert(name)

PERL_CALLCONV bool	Perl_is_gv_magical_sv(pTHX_ SV *const name_sv, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_IS_GV_MAGICAL_SV	\
	assert(name_sv)


PERL_CALLCONV bool	Perl_stashpv_hvname_match(pTHX_ const COP *c, const HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_STASHPV_HVNAME_MATCH	\
	assert(c); assert(hv)


#ifdef DEBUG_LEAKING_SCALARS_FORK_DUMP
PERL_CALLCONV void	Perl_dump_sv_child(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_DUMP_SV_CHILD	\
	assert(sv)

#endif

#ifdef PERL_DONT_CREATE_GVSV
/* PERL_CALLCONV GV*	Perl_gv_SVadd(pTHX_ GV *gv); */
#endif
#if defined(PERL_IN_UTIL_C) || defined(PERL_DECL_PROT)
STATIC bool	S_ckwarn_common(pTHX_ U32 w);
#endif
PERL_CALLCONV bool	Perl_ckwarn(pTHX_ U32 w);
PERL_CALLCONV bool	Perl_ckwarn_d(pTHX_ U32 w);
PERL_CALLCONV STRLEN *	Perl_new_warnings_bitfield(pTHX_ STRLEN *buffer, const char *const bits, STRLEN size)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEW_WARNINGS_BITFIELD	\
	assert(bits)


PERL_CALLCONV void	Perl_offer_nice_chunk(pTHX_ void *const chunk, const U32 chunk_size)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OFFER_NICE_CHUNK	\
	assert(chunk)


#ifndef SPRINTF_RETURNS_STRLEN
PERL_CALLCONV int	Perl_my_sprintf(char *buffer, const char *pat, ...)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_MY_SPRINTF	\
	assert(buffer); assert(pat)

#endif

PERL_CALLCONV int	Perl_my_snprintf(char *buffer, const Size_t len, const char *format, ...)
			__attribute__format__(__printf__,3,4)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_MY_SNPRINTF	\
	assert(buffer); assert(format)

PERL_CALLCONV int	Perl_my_vsnprintf(char *buffer, const Size_t len, const char *format, va_list ap)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_MY_VSNPRINTF	\
	assert(buffer); assert(format)


PERL_CALLCONV void	Perl_my_clearenv(pTHX);

#ifdef PERL_IMPLICIT_CONTEXT
#ifdef PERL_GLOBAL_STRUCT_PRIVATE
PERL_CALLCONV void*	Perl_my_cxt_init(pTHX_ const char *my_cxt_key, size_t size)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_CXT_INIT	\
	assert(my_cxt_key)

PERL_CALLCONV int	Perl_my_cxt_index(pTHX_ const char *my_cxt_key)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_CXT_INDEX	\
	assert(my_cxt_key)

#else
PERL_CALLCONV void*	Perl_my_cxt_init(pTHX_ int *index, size_t size)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MY_CXT_INIT	\
	assert(index)

#endif
#endif

#ifndef HAS_STRLCAT
PERL_CALLCONV Size_t	Perl_my_strlcat(char *dst, const char *src, Size_t size);
#endif

#ifndef HAS_STRLCPY
PERL_CALLCONV Size_t	Perl_my_strlcpy(char *dst, const char *src, Size_t size);
#endif

#ifdef PERL_MAD
PERL_CALLCONV void	Perl_pad_peg(const char* s)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_PAD_PEG	\
	assert(s)

#if defined(PERL_IN_DUMP_C) || defined(PERL_DECL_PROT)
STATIC void	S_xmldump_attr(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_XMLDUMP_ATTR	\
	assert(file); assert(pat)

#endif
PERL_CALLCONV void	Perl_xmldump_indent(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_XMLDUMP_INDENT	\
	assert(file); assert(pat)

PERL_CALLCONV void	Perl_xmldump_vindent(pTHX_ I32 level, PerlIO *file, const char* pat, va_list *args)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_XMLDUMP_VINDENT	\
	assert(file); assert(pat)

PERL_CALLCONV void	Perl_xmldump_all(pTHX);
PERL_CALLCONV void	Perl_xmldump_all_perl(pTHX_ bool justperl);
PERL_CALLCONV void	Perl_xmldump_packsubs(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_XMLDUMP_PACKSUBS	\
	assert(stash)

PERL_CALLCONV void	Perl_xmldump_packsubs_perl(pTHX_ const HV* stash, bool justperl)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_XMLDUMP_PACKSUBS_PERL	\
	assert(stash)

PERL_CALLCONV void	Perl_xmldump_sub(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_XMLDUMP_SUB	\
	assert(gv)

PERL_CALLCONV void	Perl_xmldump_sub_perl(pTHX_ const GV* gv, bool justperl)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_XMLDUMP_SUB_PERL	\
	assert(gv)

PERL_CALLCONV void	Perl_xmldump_form(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_XMLDUMP_FORM	\
	assert(gv)

PERL_CALLCONV void	Perl_xmldump_eval(pTHX);
PERL_CALLCONV char*	Perl_sv_catxmlsv(pTHX_ SV *dsv, SV *ssv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_CATXMLSV	\
	assert(dsv); assert(ssv)

PERL_CALLCONV char*	Perl_sv_catxmlpvn(pTHX_ SV *dsv, const char *pv, STRLEN len, int utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_SV_CATXMLPVN	\
	assert(dsv); assert(pv)

PERL_CALLCONV char*	Perl_sv_xmlpeek(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SV_XMLPEEK	\
	assert(sv)

PERL_CALLCONV void	Perl_do_pmop_xmldump(pTHX_ I32 level, PerlIO *file, const PMOP *pm)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_PMOP_XMLDUMP	\
	assert(file)

PERL_CALLCONV void	Perl_pmop_xmldump(pTHX_ const PMOP* pm);
PERL_CALLCONV void	Perl_do_op_xmldump(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_DO_OP_XMLDUMP	\
	assert(file)

PERL_CALLCONV void	Perl_op_xmldump(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_OP_XMLDUMP	\
	assert(o)


PERL_CALLCONV TOKEN*	Perl_newTOKEN(pTHX_ I32 optype, YYSTYPE lval, MADPROP* madprop);
PERL_CALLCONV void	Perl_token_free(pTHX_ TOKEN *tk)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_TOKEN_FREE	\
	assert(tk)

PERL_CALLCONV void	Perl_token_getmad(pTHX_ TOKEN *tk, OP *o, char slot)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_TOKEN_GETMAD	\
	assert(tk)

PERL_CALLCONV void	Perl_op_getmad_weak(pTHX_ OP* from, OP* o, char slot);
PERL_CALLCONV void	Perl_op_getmad(pTHX_ OP* from, OP* o, char slot);
PERL_CALLCONV void	Perl_prepend_madprops(pTHX_ MADPROP* mp, OP* o, char slot);
PERL_CALLCONV void	Perl_append_madprops(pTHX_ MADPROP* tm, OP* o, char slot);
PERL_CALLCONV void	Perl_addmad(pTHX_ MADPROP* tm, MADPROP** root, char slot);
PERL_CALLCONV MADPROP*	Perl_newMADsv(pTHX_ char key, SV* sv)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_NEWMADSV	\
	assert(sv)

PERL_CALLCONV MADPROP*	Perl_newMADPROP(pTHX_ char key, char type, void* val, I32 vlen);
PERL_CALLCONV void	Perl_mad_free(pTHX_ MADPROP* mp);

#  if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
STATIC char*	S_skipspace0(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SKIPSPACE0	\
	assert(s)

STATIC char*	S_skipspace1(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SKIPSPACE1	\
	assert(s)

STATIC char*	S_skipspace2(pTHX_ char *s, SV **sv)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_SKIPSPACE2	\
	assert(s)

STATIC void	S_start_force(pTHX_ int where);
STATIC void	S_curmad(pTHX_ char slot, SV *sv);
#  endif
PERL_CALLCONV int	Perl_madlex(pTHX);
PERL_CALLCONV int	Perl_madparse(pTHX);
#endif
#if !defined(HAS_SIGNBIT)
PERL_CALLCONV int	Perl_signbit(NV f)
			__attribute__pure__;

#endif

PERL_CALLCONV void	Perl_emulate_cop_io(pTHX_ const COP *const c, SV *const sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_EMULATE_COP_IO	\
	assert(c); assert(sv)

PERL_CALLCONV REGEXP *	Perl_get_re_arg(pTHX_ SV *sv);

PERL_CALLCONV SV*	Perl_mro_get_private_data(pTHX_ struct mro_meta *const smeta, const struct mro_alg *const which)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MRO_GET_PRIVATE_DATA	\
	assert(smeta); assert(which)

PERL_CALLCONV SV*	Perl_mro_set_private_data(pTHX_ struct mro_meta *const smeta, const struct mro_alg *const which, SV *const data)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_MRO_SET_PRIVATE_DATA	\
	assert(smeta); assert(which); assert(data)

PERL_CALLCONV const struct mro_alg *	Perl_mro_get_from_name(pTHX_ SV *name)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_GET_FROM_NAME	\
	assert(name)

PERL_CALLCONV void	Perl_mro_register(pTHX_ const struct mro_alg *mro)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_REGISTER	\
	assert(mro)

PERL_CALLCONV void	Perl_mro_set_mro(pTHX_ struct mro_meta *const meta, SV *const name)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MRO_SET_MRO	\
	assert(meta); assert(name)

PERL_CALLCONV struct mro_meta*	Perl_mro_meta_init(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_META_INIT	\
	assert(stash)

#if defined(USE_ITHREADS)
PERL_CALLCONV struct mro_meta*	Perl_mro_meta_dup(pTHX_ struct mro_meta* smeta, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_MRO_META_DUP	\
	assert(smeta); assert(param)

#endif
PERL_CALLCONV AV*	Perl_mro_get_linear_isa(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_GET_LINEAR_ISA	\
	assert(stash)

#if defined(PERL_IN_MRO_C) || defined(PERL_DECL_PROT)
STATIC AV*	S_mro_get_linear_isa_dfs(pTHX_ HV* stash, U32 level)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_GET_LINEAR_ISA_DFS	\
	assert(stash)

#endif
PERL_CALLCONV void	Perl_mro_isa_changed_in(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_ISA_CHANGED_IN	\
	assert(stash)

PERL_CALLCONV void	Perl_mro_method_changed_in(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_MRO_METHOD_CHANGED_IN	\
	assert(stash)

PERL_CALLCONV void	Perl_boot_core_mro(pTHX);
PERL_CALLCONV void	Perl_sys_init(int* argc, char*** argv)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_SYS_INIT	\
	assert(argc); assert(argv)

PERL_CALLCONV void	Perl_sys_init3(int* argc, char*** argv, char*** env)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);
#define PERL_ARGS_ASSERT_SYS_INIT3	\
	assert(argc); assert(argv); assert(env)

PERL_CALLCONV void	Perl_sys_term(void);
PERL_CALLCONV const char *	Perl_fetch_cop_label(pTHX_ struct refcounted_he *const chain, STRLEN *len, U32 *flags);
PERL_CALLCONV struct refcounted_he *	Perl_store_cop_label(pTHX_ struct refcounted_he *const chain, const char *label)
			__attribute__nonnull__(pTHX_2);
#define PERL_ARGS_ASSERT_STORE_COP_LABEL	\
	assert(label)


PERL_CALLCONV int	Perl_keyword_plugin_standard(pTHX_ char* keyword_ptr, STRLEN keyword_len, OP** op_ptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);
#define PERL_ARGS_ASSERT_KEYWORD_PLUGIN_STANDARD	\
	assert(keyword_ptr); assert(op_ptr)


#if defined(USE_ITHREADS)
#  if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC void	S_unreferenced_to_tmp_stack(pTHX_ AV *const unreferenced)
			__attribute__nonnull__(pTHX_1);
#define PERL_ARGS_ASSERT_UNREFERENCED_TO_TMP_STACK	\
	assert(unreferenced)

#  endif
PERL_CALLCONV CLONE_PARAMS *	Perl_clone_params_new(PerlInterpreter *const from, PerlInterpreter *const to)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);
#define PERL_ARGS_ASSERT_CLONE_PARAMS_NEW	\
	assert(from); assert(to)

PERL_CALLCONV void	Perl_clone_params_del(CLONE_PARAMS *param)
			__attribute__nonnull__(1);
#define PERL_ARGS_ASSERT_CLONE_PARAMS_DEL	\
	assert(param)

#endif
END_EXTERN_C
/*
 * ex: set ts=8 sts=4 sw=4 noet:
 */
/* ex: set ro: */
