# Generated by default/object.tt
package Paws::FSX::LustreFileSystemConfiguration;
  use Moose;
  has AutomaticBackupRetentionDays => (is => 'ro', isa => 'Int');
  has CopyTagsToBackups => (is => 'ro', isa => 'Bool');
  has DailyAutomaticBackupStartTime => (is => 'ro', isa => 'Str');
  has DataCompressionType => (is => 'ro', isa => 'Str');
  has DataRepositoryConfiguration => (is => 'ro', isa => 'Paws::FSX::DataRepositoryConfiguration');
  has DeploymentType => (is => 'ro', isa => 'Str');
  has DriveCacheType => (is => 'ro', isa => 'Str');
  has MountName => (is => 'ro', isa => 'Str');
  has PerUnitStorageThroughput => (is => 'ro', isa => 'Int');
  has WeeklyMaintenanceStartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::LustreFileSystemConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::LustreFileSystemConfiguration object:

  $service_obj->Method(Att1 => { AutomaticBackupRetentionDays => $value, ..., WeeklyMaintenanceStartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::LustreFileSystemConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AutomaticBackupRetentionDays

=head1 DESCRIPTION

The configuration for the Amazon FSx for Lustre file system.

=head1 ATTRIBUTES


=head2 AutomaticBackupRetentionDays => Int




=head2 CopyTagsToBackups => Bool

A boolean flag indicating whether tags on the file system should be
copied to backups. If it's set to true, all tags on the file system are
copied to all automatic backups and any user-initiated backups where
the user doesn't specify any tags. If this value is true, and you
specify one or more tags, only the specified tags are copied to
backups. If you specify one or more tags when creating a user-initiated
backup, no tags are copied from the file system, regardless of this
value. (Default = false)


=head2 DailyAutomaticBackupStartTime => Str




=head2 DataCompressionType => Str

The data compression configuration for the file system.
C<DataCompressionType> can have the following values:

=over

=item *

C<NONE> - Data compression is turned off for the file system.

=item *

C<LZ4> - Data compression is turned on with the LZ4 algorithm.

=back

For more information, see Lustre data compression
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).


=head2 DataRepositoryConfiguration => L<Paws::FSX::DataRepositoryConfiguration>




=head2 DeploymentType => Str

The deployment type of the FSX for Lustre file system. I<Scratch
deployment type> is designed for temporary storage and shorter-term
processing of data.

C<SCRATCH_1> and C<SCRATCH_2> deployment types are best suited for when
you need temporary storage and shorter-term processing of data. The
C<SCRATCH_2> deployment type provides in-transit encryption of data and
higher burst throughput capacity than C<SCRATCH_1>.

The C<PERSISTENT_1> deployment type is used for longer-term storage and
workloads and encryption of data in transit. To learn more about
deployment types, see FSx for Lustre Deployment Options
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
(Default = C<SCRATCH_1>)


=head2 DriveCacheType => Str

The type of drive cache used by PERSISTENT_1 file systems that are
provisioned with HDD storage devices. This parameter is required when
storage type is HDD. Set to C<READ>, improve the performance for
frequently accessed files and allows 20% of the total storage capacity
of the file system to be cached.

This parameter is required when C<StorageType> is set to HDD.


=head2 MountName => Str

You use the C<MountName> value when mounting the file system.

For the C<SCRATCH_1> deployment type, this value is always "C<fsx>".
For C<SCRATCH_2> and C<PERSISTENT_1> deployment types, this value is a
string that is unique within an AWS Region.


=head2 PerUnitStorageThroughput => Int

Per unit storage throughput represents the megabytes per second of read
or write throughput per 1 tebibyte of storage provisioned. File system
throughput capacity is equal to Storage capacity (TiB) *
PerUnitStorageThroughput (MB/s/TiB). This option is only valid for
C<PERSISTENT_1> deployment types.

Valid values for SSD storage: 50, 100, 200. Valid values for HDD
storage: 12, 40.


=head2 WeeklyMaintenanceStartTime => Str

The preferred start time to perform weekly maintenance, formatted
d:HH:MM in the UTC time zone. d is the weekday number, from 1 through
7, beginning with Monday and ending with Sunday.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

