use utf8;

package SemanticWeb::Schema::SubscribeAction;

# ABSTRACT: The act of forming a personal connection with someone/something (object) unidirectionally/asymmetrically to get updates pushed to

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::InteractAction /;


use MooX::JSON_LD 'SubscribeAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v23.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::SubscribeAction - The act of forming a personal connection with someone/something (object) unidirectionally/asymmetrically to get updates pushed to

=head1 VERSION

version v23.0.0

=head1 DESCRIPTION

The act of forming a personal connection with someone/something (object) unidirectionally/asymmetrically to get updates pushed to.

Related actions:

=over

=item *

L<SemanticWeb::Schema::FollowAction>: Unlike FollowAction, SubscribeAction implies that the subscriber acts as a passive agent being constantly/actively pushed for updates.

=item *

L<SemanticWeb::Schema::RegisterAction>: Unlike RegisterAction, SubscribeAction implies that the agent is interested in continuing receiving updates from the object.

=item *

L<SemanticWeb::Schema::JoinAction>: Unlike JoinAction, SubscribeAction implies that the agent is interested in continuing receiving updates from the object.

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::InteractAction>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
