#
# This file is part of App-SpreadRevolutionaryDate
#
# This software is Copyright (c) 2019-2025 by Gérald Sédrati.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#
use 5.014;
use utf8;
package App::SpreadRevolutionaryDate::MsgMaker::Telechat;
$App::SpreadRevolutionaryDate::MsgMaker::Telechat::VERSION = '0.49';
# ABSTRACT: MsgMaker class for L<App::SpreadRevolutionaryDate> to build message with Téléchat date

use Moose;
with 'App::SpreadRevolutionaryDate::MsgMaker';

use DateTime;
use File::ShareDir ':ALL';
use App::SpreadRevolutionaryDate;

use Locale::TextDomain 'App-SpreadRevolutionaryDate';
use namespace::autoclean;

has '+locale' => (
  default => 'fr',
);

around BUILDARGS => sub {
  my ($orig, $class, %args) = @_;

  $args{locale} = 'fr';
  return $class->$orig(%args);
};


sub compute {
  my $self = shift;

  my %telechat_calendars = (
    '0tvtime' => {
      '0101' => ['flaque d\'eau', 'flaques d\'eau', 'f'],
      '0102' => ['cadre', 'cadres', 'm'],
      '0103' => ['compte-gouttes', 'compte-gouttes', 'm'],
      '0104' => ['laisse de chien', 'laisses de chien', 'f'],
      '0105' => ['bocal', 'bocaux', 'm'],
      '0106' => ['gibier', 'gibiers', 'm'],
      '0107' => ['pare-chocs', 'pare-chocs', 'f'],
      '0108' => ['tranche de jambon', 'tranches de jambon', 'f'],
      '0109' => ['patate', 'patates', 'f'],
      '0110' => ['appareil de photo', 'appareils de photo', 'm'],
      '0111' => ['raisin sec', 'raisins secs', 'm'],
      '0112' => ['trognon de pomme', 'trognons de pomme', 'm'],
      '0113' => ['fil à couper le beurre', 'fils à couper le beurre', 'm'],
      '0114' => ['casse-noisettes', 'casse-noisettes', 'm'],
      '0115' => ['machine à faire des trous dans les spaguettis', 'machines à faire des trous dans les spaguettis', 'm'],
      '0116' => ['cure-dents', 'cure-dents', 'm'],
      '0117' => ['stylo-feutre', 'stylos-feutres', 'm'],
      '0118' => ['parcmètre', 'parcmètres', 'm'],
      '0119' => ['journal', 'journaux', 'm'],
      '0120' => ['toast', 'toasts', 'm'],
      '0121' => ['colis', 'colis', 'm'],
      '0122' => ['sèche-cheveux', 'sèche-cheveux', 'm'],
      '0123' => ['papier carbone', 'papiers carbone', 'm'],
      '0124' => ['savonnette', 'savonnettes', 'f'],
      '0125' => ['épluchure', 'épluchures', 'f'],
      '0126' => ['cactus', 'cactus', 'm'],
      '0127' => ['sac de dame', 'sacs de dame', 'm'],
      '0128' => ['jus de fruits', 'jus de fruits', 'm'],
      '0129' => ['mot d\'excuse', 'mots d\'excuse', 'm'],
      '0130' => ['sent-bon', 'sent-bon', 'm'],
      '0131' => ['machine à coudre', 'machines à coudre', 'f'],
      '0201' => ['pique-nique', 'pique-niques', 'm'],
      '0202' => ['bonbon à la menthe', 'bonbons à la menthe', 'm'],
      '0203' => ['sabre', 'sabres', 'm'],
      '0204' => ['uniforme', 'uniformes', 'm'],
      '0205' => ['bulle de savon', 'bulles de savon', 'f'],
      '0207' => ['pince à linge', 'pinces à linge', 'f'],
      '0208' => ['peau de banane', 'peaux de banane', 'f'],
      '0209' => ['marguerite', 'marguerites', 'f'],
      '0210' => ['avion en papier', 'avions en papier', 'm'],
      '0211' => ['brosse à cheveux', 'brosses à cheveux', 'f'],
      '0212' => ['équilibre', 'équilibres', 'm'],
      '0213' => ['théière', 'théière', 'f'],
      '0214' => ['porte-monnaie', 'porte-monnaie', 'm'],
      '0215' => ['pince à épiler', 'pinces à épiler', 'f'],
      '0216' => ['essuie-glace', 'essuie-glaces', 'm'],
      '0217' => ['cheminée d\'usine', 'cheminées d\'usine', 'f'],
      '0218' => ['farces et attrapes', 'farces et attrapes', 'f'],
      '0219' => ['gant de boxe', 'gants de boxe', 'm'],
      '0220' => ['cible', 'cibles', 'f'],
      '0221' => ['carte de crédit', 'cartes de crédit', 'f'],
      '0222' => ['ciseaux', 'ciseaux', 'm'],
      '0223' => ['boule de glace', 'boules de glace', 'f'],
      '0224' => ['chanson', 'chansons', 'f'],
      '0225' => ['gant de toilette', 'gants de toilette', 'm'],
      '0226' => ['machine à écrire', 'machines à écrire', 'f'],
      '0227' => ['cravate', 'cravates', 'f'],
      '0228' => ['cruche', 'cruches', 'f'],
      '0229' => ['bande dessinée', 'bandes dessinées', 'f'],
      '0301' => ['morceau de bois', 'morceaux de bois', 'm'],
      '0302' => ['couche-culotte', 'couches-culottes', 'f'],
      '0303' => ['pare-chocs', 'pare-chocs', 'm'],
      '0304' => ['fromage', 'fromages', 'm'],
      '0312' => ['plâtre', 'plâtres', 'm'],
      '0313' => ['tapis', 'tapis', 'm'],
      '0314' => ['poids', 'poids', 'm'],
      '0315' => ['biberon', 'biberons', 'm'],
      '0316' => ['médicament', 'médicaments', 'm'],
      '0317' => ['écran de télévision', 'écrans de télévision', 'm'],
      '0318' => ['gadget', 'gadgets', 'm'],
      '0401' => ['retour', 'retours', 'm'],
      '0402' => ['caramel mou', 'caramels mous', 'm'],
      '0403' => ['bronzage', 'bronzages', 'm'],
      '0404' => ['chèque', 'chèques', 'm'],
      '0405' => ['sent-bon', 'sent-bon', 'm'],
      '0406' => ['tuile', 'tuiles', 'f'],
      '0408' => ['motte de terre', 'mottes de terre', 'f'],
      '0410' => ['petit bateau', 'petits bateaux', 'm'],
      '0411' => ['foie', 'foies', 'm'],
      '0415' => ['vieille boîte', 'vieilles boîtes', 'f'],
      '0416' => ['abcès', 'abcès', 'm'],
      '0417' => ['t-shirt', 't-shirts', 'm'],
      '0418' => ['plafond', 'plafonds', 'm'],
      '0420' => ['jet d\'eau', 'jets d\'eau', 'm'],
      '0421' => ['téléphone', 'téléphones', 'm'],
      '0422' => ['chapeau', 'chapeaux', 'm'],
      '0423' => ['flash', 'flashs', 'm'],
      '0424' => ['croûte de fromage', 'croûtes de fromage', 'f'],
      '0426' => ['coquetier', 'coquetiers', 'm'],
      '0427' => ['bon petit plat mijoté', 'bons petits plats mijotés', 'm'],
      '0428' => ['bouchon de champagne', 'bouchons de champagne', 'm'],
      '0429' => ['couvercle', 'couvercles', 'm'],
      '0430' => ['aiguille', 'aiguilles', 'f'],
      '0501' => ['bon cœur', 'bons cœurs', 'm'],
      '0503' => ['nœud dans les mouchoirs', 'nœuds dans les mouchoirs', 'm'],
      '0504' => ['passeport', 'passeports', 'm'],
      '0506' => ['symptôme', 'symptômes', 'm'],
      '0507' => ['addition de restaurant', 'additions de restaurant', 'f'],
      '0508' => ['pavé', 'pavés', 'm'],
      '0509' => ['flûte à bec', 'flûtes à bec', 'f'],
      '0510' => ['mégaphone', 'mégaphones', 'm'],
      '0512' => ['aiguille à tricoter', 'aiguilles à tricoter', 'f'],
      '0513' => ['épingle à cheveux', 'épingles à cheveux', 'f'],
      '0515' => ['mot d\'excuse', 'mots d\'excuse', 'm'],
      '0517' => ['trombone', 'trombones', 'm'],
      '0518' => ['portrait', 'portraits', 'm'],
      '0520' => ['puce électronique', 'puces électroniques', 'f'],
      '0521' => ['nougat', 'nougats', 'm'],
      '0522' => ['jouet cassé', 'jouets cassés', 'm'],
      '0523' => ['boîte à maquillage', 'boîtes à maquillage', 'f'],
      '0524' => ['linge sale', 'linge sales', 'm'],
      '0525' => ['diapositive', 'diapositives', 'f'],
      '0529' => ['clé de cadenas', 'clés de cadenas', 'f'],
      '0530' => ['niche', 'niches', 'f'],
      '0601' => ['marque déposée', 'marques déposées', 'f'],
      '0603' => ['ruban adhésif transparent', 'rubans adhésifs transparents', 'm'],
      '0604' => ['faute d\'orthographe', 'fautes d\'orthographe', 'f'],
      '0606' => ['gant', 'gants', 'm'],
      '0607' => ['ballon ovale', 'ballons ovales', 'm'],
      '0609' => ['rasoir', 'rasoirs', 'm'],
      '0616' => ['cabane', 'cabanes', 'f'],
      '0617' => ['surprise', 'surprises', 'f'],
      '0919' => ['clé', 'clés', 'f'],
      '0920' => ['épingle', 'épingles', 'f'],
      '0921' => ['fer à repasser', 'fers à repasser', 'm'],
      '0922' => ['socquette', 'socquettes', 'f'],
      '0923' => ['poupée', 'poupées', 'f'],
      '0924' => ['pot de colle', 'pots de colle', 'm'],
      '0925' => ['marteau', 'marteaux', 'm'],
      '0926' => ['coucou', 'coucous', 'm'],
      '0927' => ['chewing-gum', 'chewing-gums', 'm'],
      '0928' => ['dictionnaire', 'dictionnaires', 'm'],
      '0929' => ['brique', 'briques', 'f'],
      '0930' => ['cendrier', 'cendriers', 'm'],
      '1001' => ['robinet qui goutte', 'robinets qui goutte', 'm'],
      '1002' => ['morceau de sucre', 'morceaux de sucre', 'm'],
      '1003' => ['sifflet', 'sifflets', 'm'],
      '1004' => ['machine à calculer', 'machines à calculer', 'f'],
      '1005' => ['maison de campagne', 'maisons de campagne', 'f'],
      '1006' => ['cornichon', 'cornichons', 'm'],
      '1007' => ['os', 'os', 'm'],
      '1008' => ['souvenir', 'souvenirs', 'm'],
      '1009' => ['petit pot de lait', 'petits pots de lait', 'm'],
      '1010' => ['fer-à-cheval', 'fers-à-cheval', 'm'],
      '1011' => ['paquet-cadeau', 'paquets-cadeaux', 'm'],
      '1012' => ['enveloppe', 'enveloppes', 'f'],
      '1013' => ['rouge à lèvres', 'rouges à lèvres', 'm'],
      '1014' => ['rouge vermillon', 'rouges vermillon', 'm'],
      '1015' => ['thermomètre', 'thermomètres', 'm'],
      '1016' => ['lunettes de soleil', 'lunettes de soleil', 'f'],
      '1017' => ['boussole', 'boussoles', 'f'],
      '1018' => ['élastique', 'élastiques', 'm'],
      '1019' => ['calendrier', 'calendriers', 'm'],
      '1020' => ['jeton', 'jetons', 'm'],
      '1021' => ['menottes', 'menottes', 'f'],
      '1022' => ['petit carnet', 'petits carnets', 'm'],
      '1023' => ['personne', 'personnes', 'f'],
      '1024' => ['gomme', 'gommes', 'f'],
      '1025' => ['coquillette', 'coquillettes', 'f'],
      '1026' => ['mode d\'emploi', 'modes d\'emploi', 'm'],
      '1027' => ['coton-tige', 'cotons-tiges', 'm'],
      '1028' => ['cacahuète', 'cacahuètes', 'f'],
      '1029' => ['disque', 'disques', 'm'],
      '1030' => ['harmonica', 'harmonicas', 'm'],
      '1031' => ['bigoudi', 'bigoudis', 'm'],
      '1101' => ['peigne', 'peignes', 'm'],
      '1102' => ['fleur artificielle', 'fleurs artificielles', 'f'],
      '1103' => ['numéro', 'numéros', 'm'],
      '1104' => ['blague', 'blagues', 'f'],
      '1105' => ['tire-bouchon', 'tire-bouchons', 'm'],
      '1106' => ['dent de lait', 'dents de lait', 'f'],
      '1107' => ['stylo', 'stylos', 'm'],
      '1108' => ['bonhomme de neige', 'bonshommes de neige', 'm'],
      '1109' => ['poignée de porte', 'poignées de porte', 'f'],
      '1110' => ['marteau picoreur', 'marteaux picoreurs', 'm'],
      '1111' => ['marionette', 'marionettes', 'f'],
      '1112' => ['timbre', 'timbres', 'm'],
      '1113' => ['masque', 'masques', 'm'],
      '1114' => ['bande magnétique', 'bandes magnétiques', 'f'],
      '1115' => ['livre', 'livres', 'm'],
      '1116' => ['interrupteur', 'interrupteurs', 'm'],
      '1117' => ['roue', 'roues', 'f'],
      '1118' => ['pinceau', 'pinceaux', 'm'],
      '1119' => ['punaise', 'punaises', 'f'],
      '1120' => ['ouvre-boîte', 'ouvre-boîtes', 'm'],
      '1121' => ['ombre', 'ombres', 'f'],
      '1122' => ['ceinture', 'ceintures', 'f'],
      '1123' => ['courant d\'air', 'courants d\'air', 'm'],
      '1124' => ['carte de vœux', 'cartes de vœux', 'f'],
      '1125' => ['moins-que-rien', 'moins-que-rien', 'm'],
      '1126' => ['tour Eiffel', 'tours Eiffel', 'f'],
      '1127' => ['rétroviseur', 'rétroviseurs', 'm'],
      '1128' => ['triangle', 'triangles', 'm'],
      '1129' => ['ding-dong', 'ding-dongs', 'm'],
      '1130' => ['buldozer', 'buldozers', 'm'],
      '1201' => ['paille', 'pailles', 'f'],
      '1202' => ['petite trompette', 'petites trompettes', 'f'],
      '1203' => ['poil', 'poils', 'm'],
      '1204' => ['plume', 'plumes', 'f'],
      '1205' => ['mouchoir', 'mouchoirs', 'm'],
    },
    'SaintoObjetBot_20231109' => {
      '0101' => ['veisalgie', 'veisalgies', 'f'],
      '0102' => ['ankylostome', 'ankylostomes', 'm'],
      '0103' => ['apex', 'apexes', 'm'],
      '0104' => ['arlequin', 'arlequins', 'm'],
      '0105' => ['bengali', 'bengalis', 'm'],
      '0106' => ['bouquetin', 'bouquetins', 'm'],
      '0107' => ['cancrelat', 'cancrelats', 'm'],
      '0108' => ['cerf-volant', 'cerfs-volants', 'm'],
      '0109' => ['colibri', 'colibris', 'm'],
      '0110' => ['dromadaire', 'dromadaires', 'm'],
      '0111' => ['embrouillamini', 'embrouillaminis', 'm'],
      '0112' => ['fauconneau', 'fauconeaux', 'm'],
      '0113' => ['gambette', 'gambettes', 'f'],
      '0114' => ['hérisson', ' hérissons', 'm'],
      '0115' => ['javelot', 'javelots', 'm'],
      '0116' => ['kangourou', 'kangourous', 'm'],
      '0117' => ['lampion', 'lampions', 'm'],
      '0118' => ['manuscrit', 'manuscrits', 'm'],
      '0119' => ['quignon', 'quignons', 'm'],
      '0120' => ['tablier', 'tabliers', 'm'],
      '0121' => ['zorglub', 'zorglubs', 'm'],
      '0122' => ['pataquès', 'pataquès', 'm'],
      '0123' => ['bobèche', 'bobèches', 'f'],
      '0124' => ['zézaiement', 'zézaiements', 'm'],
      '0125' => ['flibustier', 'flibustiers', 'm'],
      '0126' => ['mirliton', 'mirlitons', 'm'],
      '0127' => ['craspouille', 'craspouilles', 'f'],
      '0128' => ['zigouigoui', 'zigouigouis', 'm'],
      '0129' => ['faribole', 'fariboles', 'f'],
      '0130' => ['pantouflette', 'pantouflettes', 'f'],
      '0131' => ['zinzin', 'zinzins', 'm'],
      '0201' => ['bibelot', 'bibelots', 'm'],
      '0202' => ['ukulélé', 'ukulélés', 'm'],
      '0203' => ['grigris', 'grigris', 'm'],
      '0204' => ['crinoline', 'crinolines', 'f'],
      '0205' => ['turlutaine', 'turlutaines', 'f'],
      '0206' => ['boudeuse', 'boudeuses', 'f'],
      '0207' => ['tralala', 'tralalas', 'm'],
      '0208' => ['carambolage', 'carambolages', 'm'],
      '0209' => ['frimousse', 'frimousses', 'f'],
      '0210' => ['catafalque', 'catafalques', 'm'],
      '0211' => ['chicane', 'chicanes', 'f'],
      '0212' => ['barbichette', 'barbichettes', 'f'],
      '0213' => ['croquignole', 'croquignoles', 'm'],
      '0214' => ['rouleau de sopalin', 'rouleaux de sopalin', 'm'],
      '0215' => ['clavicule', 'clavicules', 'f'],
      '0216' => ['bambinette', 'bambinettes', 'f'],
      '0217' => ['sporange', 'sporanges', 'm'],
      '0218' => ['fléole', 'fléoles', 'f'],
      '0219' => ['goubelin', 'goubelins', 'm'],
      '0220' => ['bélin', 'bélins', 'm'],
      '0221' => ['grébiche', 'grébiches', 'f'],
      '0222' => ['pipistrelle', 'pipistrelles', 'f'],
      '0223' => ['badine', 'badines', 'f'],
      '0224' => ['guttule', 'guttules', 'f'],
      '0225' => ['sautoir', 'sautoirs', 'm'],
      '0226' => ['tourniquet', 'tourniquets', 'm'],
      '0227' => ['grenouillère', 'grenouillères', 'f'],
      '0228' => ['torsade', 'torsades', 'f'],
      '0229' => ['calicot', 'calicots', 'm'],
      '0301' => ['gousset', 'goussets', 'm'],
      '0302' => ['tournebille', 'tournebilles', 'f'],
      '0303' => ['gibelotte', 'gibelottes', 'f'],
      '0304' => ['cabestan', 'cabestans', 'm'],
      '0305' => ['mélopée', 'mélopées', 'f'],
      '0306' => ['galurin', 'galurins', 'm'],
      '0307' => ['joug', 'jougs', 'm'],
      '0308' => ['cabriole', 'cabrioles', 'f'],
      '0309' => ['attache parisienne', 'attaches parisiennes', 'f'],
      '0310' => ['bac à charbon', 'bacs à charbon', 'm'],
      '0311' => ['béquille', 'béquilles', 'f'],
      '0312' => ['boussole', 'boussoles', 'f'],
      '0313' => ['caméra argentique', 'caméras argentiques', 'f'],
      '0314' => ['canne', 'cannes', 'f'],
      '0315' => ['cloche', 'cloches', 'f'],
      '0316' => ['clou', 'clous', 'm'],
      '0317' => ['coton-tige', 'cotons-tiges', 'm'],
      '0318' => ['disque vinyle', 'disques vinyles', 'm'],
      '0319' => ['encrier', 'encriers', 'm'],
      '0320' => ['fer à repasser', 'fers à repasser', 'm'],
      '0321' => ['fusil à pompe', 'fusils à pompe', 'm'],
      '0322' => ['gourde', 'gourdes', 'f'],
      '0323' => ['imprimante à marguerite', 'imprimantes à marguerite', 'f'],
      '0324' => ['tendu-de-majeur', 'doigts d\'honneur', 'm'],
      '0325' => ['machine à écrire', 'machines à écrire', 'f'],
      '0326' => ['poignée de porte', 'poignées de porte', 'f'],
      '0327' => ['savon de marseille', 'savons de marseille', 'm'],
      '0328' => ['stylo à plume', 'stylos à plume', 'm'],
      '0329' => ['téléviseur cathodique', 'téléviseurs cathodiques', 'm'],
      '0330' => ['urne funéraire', 'urnes funéraires', 'f'],
      '0331' => ['balai', 'balais', 'm'],
      '0401' => ['microplastique', 'microplastiques', 'm'],
      '0402' => ['bougie', 'bougies', 'f'],
      '0403' => ['cabine téléphonique', 'cabines téléphoniques', 'f'],
      '0404' => ['canapé', 'canapés', 'm'],
      '0405' => ['carte postale', 'cartes postales', 'f'],
      '0406' => ['ceinture', 'ceintures', 'f'],
      '0407' => ['engrenage', 'engrenages', 'm'],
      '0408' => ['escalier', 'escaliers', 'm'],
      '0409' => ['monogramme', 'monogrammes', 'm'],
      '0410' => ['acanthe', 'acanthes', 'f'],
      '0411' => ['humus', 'humus', 'm'],
      '0412' => ['entroque', 'entroque', 'f'],
      '0413' => ['fourneau', 'fourneaux', 'm'],
      '0414' => ['ampoule, multiprise et rallonge', 'ampoules, multiprises et rallonges', 'f'],
      '0415' => ['alésoir à cliquet', 'alésoirs à cliquets', 'm'],
      '0416' => ['clapier', 'clapiers', 'm'],
      '0417' => ['taloche', 'taloches', 'f'],
      '0418' => ['occiput', 'occiputs', 'm'],
      '0419' => ['diodon', 'diodons', 'm'],
      '0420' => ['tricorne', 'tricornes', 'm'],
      '0421' => ['spume', 'spumes', 'f'],
      '0422' => ['manchon', 'manchons', 'm'],
      '0423' => ['limaçon', 'limaçons', 'm'],
      '0424' => ['levraut', 'levrauts', 'm'],
      '0425' => ['gymkhana', 'gymkhanas', 'm'],
      '0426' => ['dosimètre', 'dosimètres', 'm'],
      '0427' => ['queue-de-pie', 'queues-de-pie', 'f'],
      '0428' => ['clé à pipe débouchée', 'clés à pipe débouchées', 'f'],
      '0429' => ['perruque', 'perruques', 'f'],
      '0430' => ['traille', 'trailles', 'f'],
      '0501' => ['tripalium', 'tripaliums', 'm'],
      '0502' => ['pastille', 'pastilles', 'f'],
      '0503' => ['francisque', 'francisques', 'f'],
      '0504' => ['pirouette', 'pirouettes', 'f'],
      '0505' => ['marmouset', 'marmousets', 'm'],
      '0506' => ['pédicelle', 'pédicelles', 'm'],
      '0507' => ['hypsomètre', 'hypsomètres', 'm'],
      '0508' => ['lambrequin', 'lambrequins', 'm'],
      '0509' => ['cribellum', 'cribellums', 'm'],
      '0510' => ['hélicoïde', 'hélicoïdes', 'f'],
      '0511' => ['quenouille', 'quenouilles', 'f'],
      '0512' => ['zythum', 'zytha', 'm'],
      '0513' => ['sarbacane', 'sarbacanes', 'f'],
      '0514' => ['turion', 'turions', 'm'],
      '0515' => ['blaireau', 'blaireaux', 'm'],
      '0516' => ['sémaphore', 'sémaphores', 'f'],
      '0517' => ['crispatule', 'crispatules', 'f'],
      '0518' => ['zist', 'zists', 'm'],
      '0519' => ['chiquenaude', 'chiquenaudes', 'f'],
      '0520' => ['sagouin', 'sagouins', 'm'],
      '0521' => ['borborygme', 'borborygmes', 'm'],
      '0522' => ['zéphyr', 'zéphyrs', 'm'],
      '0523' => ['schnock', 'schnocks', 'm'],
      '0524' => ['pendeloque', 'pendeloques', 'f'],
      '0525' => ['falbala', 'falbalas', 'm'],
      '0526' => ['nycthémère', 'nycthémères', 'm'],
      '0527' => ['houppier', 'houppiers', 'm'],
      '0528' => ['suaire', 'suaires', 'm'],
      '0529' => ['jable', 'jables', 'm'],
      '0530' => ['goulot', 'goulots', 'm'],
      '0531' => ['bourdalou', 'bourdalous', 'm'],
      '0601' => ['zibeline', 'zibelines', 'f'],
      '0602' => ['turpitude', 'turpitudes', 'f'],
      '0603' => ['carafon', 'carafons', 'm'],
      '0604' => ['roubignole', 'roubignoles', 'f'],
      '0605' => ['cantharide', 'cantharides', 'f'],
      '0606' => ['pédoncule', 'pédoncules', 'm'],
      '0607' => ['élytre', 'élytres', 'm'],
      '0608' => ['cressonnière', 'cressonnières', 'f'],
      '0609' => ['araignée', 'araignées', 'f'],
      '0610' => ['sarment', 'sarments', 'm'],
      '0611' => ['argousin', 'argousins', 'm'],
      '0612' => ['poudingue', 'poudingues', 'm'],
      '0613' => ['pandiculation', 'pandiculations', 'f'],
      '0614' => ['gaudriole', 'gaudrioles', 'f'],
      '0615' => ['chenapan', 'chenapans', 'm'],
      '0616' => ['carabistouille', 'carabistouilles', 'f'],
      '0617' => ['baliverne', 'balivernes', 'f'],
      '0618' => ['histrion', 'histrions', 'm'],
      '0619' => ['babiole', 'babioles', 'f'],
      '0620' => ['pétouille', 'pétouilles', 'f'],
      '0621' => ['baragouin', 'baragouins', 'm'],
      '0622' => ['patatras', 'patatras', 'm'],
      '0623' => ['alambic', 'alambics', 'm'],
      '0624' => ['billevesée', 'billevesées', 'f'],
      '0625' => ['rigolboche', 'rigolboches', 'f'],
      '0626' => ['turlupin', 'turlupins', 'm'],
      '0627' => ['turlurette', 'turlurettes', 'f'],
      '0628' => ['guignol', 'guignols', 'm'],
      '0629' => ['bille-molle', 'billes-molles', 'f'],
      '0630' => ['brimborion', 'brimborions', 'm'],
      '0701' => ['mirliflore', 'mirliflores', 'f'],
      '0702' => ['clapiotte', 'clapiottes', 'f'],
      '0703' => ['gaffophone', 'gaffophones', 'm'],
      '0704' => ['légumineur', 'légumineurs', 'm'],
      '0705' => ['micro-onduleur', 'micro-onduleurs', 'm'],
      '0706' => ['frite-magique', 'frites-magiques', 'f'],
      '0707' => ['extracteur du potentiel de point zéro', 'extracteurs du potentiel de point zéro', 'm'],
      '0708' => ['réveil-tartine', 'réveils-tartines', 'm'],
      '0709' => ['horloge-moussante', 'horloges-moussantes', 'f'],
      '0710' => ['canapélicoptère', 'canapélicoptères', 'm'],
      '0711' => ['éponge-lumineuse', 'éponges-lumineuses', 'f'],
      '0712' => ['spatulon', 'spatulons', 'm'],
      '0713' => ['vaissellier-volant', 'vaisselliers-volants', 'm'],
      '0714' => ['boîte-à-bêtises', 'boîtes-à-bêtises', 'f'],
      '0715' => ['télé-poubelle', 'télé-poubelles', 'f'],
      '0716' => ['baignoire-parlante', 'baignoires-parlantes', 'f'],
      '0717' => ['armoire-à-glissade', 'armoires-à-glissade', 'f'],
      '0718' => ['pierre manale', 'pierres manales', 'f'],
      '0719' => ['grille-pain de l\'espace', 'grilles-pains de l\'espace', 'm'],
      '0720' => ['robot-raccommodeur', 'robots-raccommodeurs', 'm'],
      '0721' => ['fourchette-à-comptine', 'fourchettes-à-comptines', 'f'],
      '0722' => ['pantoufle-réactive', 'pantoufles-réactives', 'f'],
      '0723' => ['coussin-péteur', 'coussins-péteurs', 'm'],
      '0724' => ['télé-orbitale', 'télés-orbitales', 'f'],
      '0725' => ['brosse-à-dent sonique', 'brosses-à-dent soniques', 'f'],
      '0726' => ['couette-intelligente', 'couettes-intelligentes', 'f'],
      '0727' => ['pyjama-à-histoires', 'pyjamas-à-histoires', 'm'],
      '0728' => ['bol-à-mystère', 'bols-à-mystère', 'm'],
      '0729' => ['tabouret-téléphone', 'tabourets-téléphone', 'm'],
      '0730' => ['miroir-savant', 'miroirs-savants', 'm'],
      '0731' => ['tapis-volant d\'intérieur', 'tapis-volants d\'intérieur', 'm'],
      '0801' => ['oreiller-à-musique', 'oreillers-à-musique', 'm'],
      '0802' => ['papier-peint interactif', 'papiers-peints interactifs', 'm'],
      '0803' => ['xylophone', 'xylophones', 'm'],
      '0804' => ['guilloché', 'guillochés', 'm'],
      '0805' => ['djembé', 'djembés', 'm'],
      '0806' => ['caipirinha', 'caipirinhas', 'f'],
      '0807' => ['tzatziki', 'tzatzikis', 'm'],
      '0808' => ['karaoke', 'karaokes', 'm'],
      '0809' => ['kantele', 'kanteles', 'f'],
      '0810' => ['haiku', 'haikus', 'm'],
      '0811' => ['colchique', 'colchiques', 'f'],
      '0812' => ['molinillo', 'molinillos', 'm'],
      '0813' => ['quokka', 'quokkas', 'f'],
      '0814' => ['duduk', 'duduks', 'm'],
      '0815' => ['balalaïka', 'balalaïkas', 'f'],
      '0816' => ['fajitas', 'fajitas', 'f'],
      '0817' => ['bobineau', 'bobineaux', 'm'],
      '0818' => ['fjord', 'fjords', 'm'],
      '0819' => ['tsampa', 'tsampas', 'f'],
      '0820' => ['qipao', 'qipaos', 'f'],
      '0821' => ['boomerang', 'boomerangs', 'm'],
      '0822' => ['cachou', 'cachous', 'm'],
      '0823' => ['sac à dos', 'sacs à dos', 'm'],
      '0824' => ['brosse à dents', 'brosses à dents', 'f'],
      '0825' => ['lampe de bureau', 'lampes de bureau', 'f'],
      '0826' => ['tapis de souris', 'tapis de souris', 'm'],
      '0827' => ['pot de fleurs', 'pots de fleurs', 'm'],
      '0828' => ['brosse à cheveux', 'brosses à cheveux', 'f'],
      '0829' => ['boucle d\'oreille', 'boucles d\'oreilles', 'f'],
      '0830' => ['manette de jeu', 'manettes de jeu', 'f'],
      '0831' => ['tapis de yoga', 'tapis de yoga', 'm'],
      '0901' => ['corde à sauter', 'cordes à sauter', 'f'],
      '0902' => ['haltère', 'haltères', 'm'],
      '0903' => ['trottinette', 'trottinettes', 'f'],
      '0904' => ['sac de couchage', 'sacs de couchage', 'm'],
      '0905' => ['réchaud de camping', 'réchauds de camping', 'm'],
      '0906' => ['chaussure de randonnée', 'chaussures de randonnée', 'f'],
      '0907' => ['taille-crayon', 'taille-crayons', 'm'],
      '0908' => ['agrafeuse', 'agrafeuses', 'f'],
      '0909' => ['aspirateur', 'aspirateurs', 'm'],
      '0910' => ['lave-linge', 'lave-linges', 'm'],
      '0911' => ['sèche-linge', 'sèche-linges', 'm'],
      '0912' => ['machine à coudre', 'machines à coudre', 'f'],
      '0913' => ['serpillère', 'serpillères', 'f'],
      '0914' => ['tronçonneuse', 'tronçonneuses', 'f'],
      '0915' => ['débroussailleuse', 'débroussailleuses', 'f'],
      '0916' => ['motoculteur', 'motoculteurs', 'm'],
      '0917' => ['râteau', 'râteaux', 'm'],
      '0918' => ['clé à molette', 'clés à molette', 'f'],
      '0919' => ['scie circulaire', 'scies circulaires', 'f'],
      '0920' => ['détecteur de fumée', 'détecteurs de fumée', 'm'],
      '0921' => ['caméra de surveillance', 'caméras de surveillance', 'f'],
      '0922' => ['moustiquaire', 'moustiquaires', 'f'],
      '0923' => ['brise-vent', 'brise-vent', 'm'],
      '0924' => ['balcon', 'balcons', 'm'],
      '0925' => ['jardinière', 'jardinières', 'f'],
      '0926' => ['buisson', 'buissons', 'm'],
      '0927' => ['haie', 'haies', 'f'],
      '0928' => ['système d\'irrigation', 'systèmes d\'irrigation', 'm'],
      '0929' => ['thermomètre', 'thermomètres', 'm'],
      '0930' => ['hygromètre', 'hygromètres', 'm'],
      '1001' => ['luxmètre', 'luxmètres', 'm'],
      '1002' => ['anémomètre', 'anémomètres', 'm'],
      '1003' => ['pluviomètre', 'pluviomètres', 'm'],
      '1004' => ['baromètre', 'baromètres', 'm'],
      '1005' => ['chronomètre', 'chronomètres', 'm'],
      '1006' => ['microscope', 'microscopes', 'm'],
      '1007' => ['télescope', 'télescopes', 'm'],
      '1008' => ['spectroscope', 'spectroscopes', 'm'],
      '1009' => ['sac à bière', 'sacs à bière', 'm'],
      '1010' => ['ohmmètre', 'ohmmètres', 'm'],
      '1011' => ['ampermètre', 'ampermètres', 'm'],
      '1012' => ['voltmètre', 'voltmètres', 'm'],
      '1013' => ['oscilloscope', 'oscilloscopes', 'm'],
      '1014' => ['fréquencemètre', 'fréquencemètres', 'm'],
      '1015' => ['analyseur de spectre', 'analyseurs de spectre', 'm'],
      '1016' => ['circuit imprimé' ,'circuits imprimés', 'm'],
      '1017' => ['disjoncteur', 'disjoncteurs', 'm'],
      '1018' => ['machine-à-faire-des-trous-dans-les-spaghetti', 'machines-à-faire-des-trous-dans-les-spaghetti', 'f'],
      '1019' => ['morceau de bois', 'morceaux de bois', 'm'],
      '1020' => ['pot de colle', 'pots de colle', 'm'],
      '1021' => ['paquet cadeau', 'paquets cadeaux', 'm'],
      '1022' => ['cacatoès', 'cacatoès', 'f'],
      '1023' => ['harmonica', 'harmonicas', 'm'],
      '1024' => ['bigoudi', 'bigoudis', 'm'],
      '1025' => ['dent de lait', 'dents de lait', 'f'],
      '1026' => ['bonhomme de neige', 'bonhommes de neige', 'm'],
      '1027' => ['marteau picoreur', 'marteaux picoreurs', 'm'],
      '1028' => ['bande magnétique', 'bandes magnétiques', 'f'],
      '1029' => ['punaise de lit', 'punaises de lit', 'f'],
      '1030' => ['carte de voeux', 'cartes de voeux', 'f'],
      '1031' => ['moins que rien', 'moins que rien', 'm'],
      '1101' => ['tour eiffel', 'tours eiffel', 'f'],
      '1102' => ['symptôme', 'symptômes', 'm'],
      '1103' => ['mamanite', 'amanites', 'f'],
      '1104' => ['cornichon', 'cornichons', 'm'],
      '1105' => ['zinzolin', 'zinzolins', 'm'],
      '1106' => ['jouet à bascule', 'jouets à bascule', 'm'],
      '1107' => ['bloc-notes', 'blocs-notes', 'm'],
      '1108' => ['routoir', 'routoirs', 'm'],
      '1109' => ['guenille', 'guenilles', 'f'],
      '1110' => ['lunette de soleil', 'lunettes de soleil', 'f'],
      '1111' => ['octavin', 'octavins', 'm'],
      '1112' => ['toque à trois cornes', 'toques à trois cornes', 'f'],
      '1113' => ['navire-hôpital', 'navires-hôpitaux', 'm'],
      '1114' => ['sesquiplan', 'sesquiplans', 'm'],
      '1115' => ['baldaquin', 'baldaquins', 'm'],
      '1116' => ['anémoscope', 'anémoscopes', 'm'],
      '1117' => ['clavicythérium', 'clavicythériums', 'm'],
      '1118' => ['certificat de conformité' ,'certificats de conformité', 'm'],
      '1119' => ['bonnet de nuit', ' bonnets de nuit', 'm'],
      '1120' => ['atmomètre', 'atmomètres', 'm'],
      '1121' => ['pnéomètre', 'pnéomètres', 'm'],
      '1122' => ['marie-salope', 'marie-salopes', 'f'],
      '1123' => ['lettre de crédit', 'lettres de crédit', 'f'],
      '1124' => ['cithare', 'cithares', 'f'],
      '1125' => ['tramezzino', 'tramezzinos', 'm'],
      '1126' => ['ichcahuipilli', 'ichcahuipillis', 'f'],
      '1127' => ['journal intime', 'journaux intimes', 'm'],
      '1128' => ['harpe celtique', 'harpes celtiques', 'f'],
      '1129' => ['nœud d’agui', 'nœuds d’agui', 'm'],
      '1130' => ['cabotière', 'cabotières', 'f'],
      '1201' => ['pique-œuf', 'pique-œufs', 'm'],
      '1202' => ['revue de contrat', 'revues de contrats', 'f'],
      '1203' => ['grande surface', 'grandes surfaces', 'f'],
      '1204' => ['manteau de cheminée', 'manteaux de cheminées', 'm'],
      '1205' => ['charentaise', 'charentaises', 'f'],
      '1206' => ['chasse-goupille', 'chasse-goupilles', 'm'],
      '1207' => ['chaussure à orteils', 'chaussures à orteils', 'f'],
      '1208' => ['giroflée à cinq pétales', 'giroflées a cinq pétales', 'f'],
      '1209' => ['salade de phalanges', 'salades de phalanges', 'f'],
      '1210' => ['rogntudju', 'rogntudju', 'm'],
      '1211' => ['lixiviateuse', 'lixiviateuses', 'f'],
      '1212' => ['chaise berçante', 'chaises berçantes', 'f'],
      '1213' => ['chebec', 'chebec', 'm'],
      '1214' => ['boulevard circulaire', 'boulevards circulaires', 'm'],
      '1215' => ['bande cyclable', 'bandes cyclables', 'f'],
      '1216' => ['coupe-boulons', 'coupe-boulons', 'm'],
      '1217' => ['clé à pipe', 'clés à pipes', 'f'],
      '1218' => ['ensacheuse', 'ensacheuses', 'f'],
      '1219' => ['fulguromètre', 'fulguromètre', 'm'],
      '1220' => ['diptyque', 'diptyques', 'm'],
      '1221' => ['cucurbitacée', 'cucurbitacées', 'm'],
      '1222' => ['glassophone', 'glassophones', 'm'],
      '1223' => ['métaphore', 'métaphores', 'f'],
      '1224' => ['pentécontère', 'pentécontères', 'm'],
      '1225' => ['prépuce', 'prépuces', 'm'],
      '1226' => ['cumulus bourgeonnant', 'cumulus bourgeonnants', 'm'],
      '1227' => ['pyréolophore', 'pyréolophores', 'm'],
      '1228' => ['soubassophone', 'soubassophones', 'm'],
      '1229' => ['béret basque', 'bérets basques', 'm'],
      '1230' => ['vocifération sportive', 'vociférations sportives', 'm'],
      '1231' => ['armoire à glace', 'armoires à glace', 'f'],
    },
    'SaintoObjetBot_20250308' => {
      '0101' => ['raboteuse', 'raboteuses', 'f'],
      '0102' => ['ankylostome', 'ankylostomes', 'm'],
      '0103' => ['vermifuge', 'vermifuges', 'm'],
      '0104' => ['arlequin', 'arlequins', 'm'],
      '0105' => ['palpeur de mirette', 'palpeurs de mirettes', 'm'],
      '0106' => ['bouquetin', 'bouquetins', 'm'],
      '0107' => ['cancrelat', 'cancrelats', 'm'],
      '0108' => ['cerf-volant', 'cerfs-volants', 'm'],
      '0109' => ['colibri', 'colibris', 'm'],
      '0110' => ['dromadaire', 'dromadaires', 'm'],
      '0111' => ['embrouillamini', 'embrouillaminis', 'm'],
      '0112' => ['fauconneau', 'fauconeaux', 'm'],
      '0113' => ['gambette', 'gambettes', 'f'],
      '0114' => ['hérisson', ' hérissons', 'm'],
      '0115' => ['javelot', 'javelots', 'm'],
      '0116' => ['kangourou', 'kangourous', 'm'],
      '0117' => ['lampion', 'lampions', 'm'],
      '0118' => ['manuscrit', 'manuscrits', 'm'],
      '0119' => ['quignon', 'quignons', 'm'],
      '0120' => ['tablier', 'tabliers', 'm'],
      '0121' => ['zorglub', 'zorglubs', 'm'],
      '0122' => ['pataquès', 'pataquès', 'm'],
      '0123' => ['bobèche', 'bobèches', 'f'],
      '0124' => ['zézaiement', 'zézaiements', 'm'],
      '0125' => ['flibustier', 'flibustiers', 'm'],
      '0126' => ['mirliton', 'mirlitons', 'm'],
      '0127' => ['craspouille', 'craspouilles', 'f'],
      '0128' => ['zigouigoui', 'zigouigouis', 'm'],
      '0129' => ['faribole', 'fariboles', 'f'],
      '0130' => ['pantouflette', 'pantouflettes', 'f'],
      '0131' => ['zinzin', 'zinzins', 'm'],
      '0201' => ['bibelot', 'bibelots', 'm'],
      '0202' => ['ukulélé', 'ukulélés', 'm'],
      '0203' => ['grigris', 'grigris', 'm'],
      '0204' => ['crinoline', 'crinolines', 'f'],
      '0205' => ['turlutaine', 'turlutaines', 'f'],
      '0206' => ['boudeuse', 'boudeuses', 'f'],
      '0207' => ['tralala', 'tralalas', 'm'],
      '0208' => ['carambolage', 'carambolages', 'm'],
      '0209' => ['frimousse', 'frimousses', 'f'],
      '0210' => ['catafalque', 'catafalques', 'm'],
      '0211' => ['chicane', 'chicanes', 'f'],
      '0212' => ['barbichette', 'barbichettes', 'f'],
      '0213' => ['croquignole', 'croquignoles', 'm'],
      '0214' => ['rouleau de sopalin', 'rouleaux de sopalin', 'm'],
      '0215' => ['clavicule', 'clavicules', 'f'],
      '0216' => ['bambinette', 'bambinettes', 'f'],
      '0217' => ['sporange', 'sporanges', 'm'],
      '0218' => ['fléole', 'fléoles', 'f'],
      '0219' => ['goubelin', 'goubelins', 'm'],
      '0220' => ['bélin', 'bélins', 'm'],
      '0221' => ['grébiche', 'grébiches', 'f'],
      '0222' => ['pipistrelle', 'pipistrelles', 'f'],
      '0223' => ['badine', 'badines', 'f'],
      '0224' => ['guttule', 'guttules', 'f'],
      '0225' => ['sautoir', 'sautoirs', 'm'],
      '0226' => ['tourniquet', 'tourniquets', 'm'],
      '0227' => ['grenouillère', 'grenouillères', 'f'],
      '0228' => ['torsade', 'torsades', 'f'],
      '0229' => ['calicot', 'calicots', 'm'],
      '0301' => ['gousset', 'goussets', 'm'],
      '0302' => ['tournebille', 'tournebilles', 'f'],
      '0303' => ['gibelotte', 'gibelottes', 'f'],
      '0304' => ['cabestan', 'cabestans', 'm'],
      '0305' => ['mélopée', 'mélopées', 'f'],
      '0306' => ['galurin', 'galurins', 'm'],
      '0307' => ['compte-goutte', 'compte-gouttes', 'm'],
      '0308' => ['tabouret de piano', 'tabourets de piano', 'm'],
      '0309' => ['pot de moutarde', 'pots de moutarde', 'm'],
      '0310' => ['laisse de chien', 'laisses de chien', 'f'],
      '0311' => ['pare-choc', 'pare-chocs', 'm'],
      '0312' => ['papier-carbone', 'papiers carbone', 'm'],
      '0313' => ['bulle de savon', 'bulles de savon', 'f'],
      '0314' => ['équilibre', 'équilibres', 'm'],
      '0315' => ['essuie-glace', 'essuie-glaces', 'm'],
      '0316' => ['clou', 'clous', 'm'],
      '0317' => ['coton-tige', 'cotons-tiges', 'm'],
      '0318' => ['disque vinyle', 'disques vinyles', 'm'],
      '0319' => ['encrier', 'encriers', 'm'],
      '0320' => ['fer à repasser', 'fers à repasser', 'm'],
      '0321' => ['fusil à pompe', 'fusils à pompe', 'm'],
      '0322' => ['gourde', 'gourdes', 'f'],
      '0323' => ['imprimante à marguerite', 'imprimantes à marguerite', 'f'],
      '0324' => ['tendu-de-majeur', 'doigts d\'honneur', 'm'],
      '0325' => ['machine à écrire', 'machines à écrire', 'f'],
      '0326' => ['poignée de porte', 'poignées de porte', 'f'],
      '0327' => ['savonnette', 'savonnettes', 'f'],
      '0328' => ['stylo à plume', 'stylos à plume', 'm'],
      '0329' => ['téléviseur cathodique', 'téléviseurs cathodiques', 'm'],
      '0330' => ['urne funéraire', 'urnes funéraires', 'f'],
      '0331' => ['balai', 'balais', 'm'],
      '0401' => ['microplastique', 'microplastiques', 'm'],
      '0402' => ['bougie', 'bougies', 'f'],
      '0403' => ['cabine téléphonique', 'cabines téléphoniques', 'f'],
      '0404' => ['canapé', 'canapés', 'm'],
      '0405' => ['carte postale', 'cartes postales', 'f'],
      '0406' => ['ceinture', 'ceintures', 'f'],
      '0407' => ['engrenage', 'engrenages', 'm'],
      '0408' => ['escalier', 'escaliers', 'm'],
      '0409' => ['monogramme', 'monogrammes', 'm'],
      '0410' => ['acanthe', 'acanthes', 'f'],
      '0411' => ['humus', 'humus', 'm'],
      '0412' => ['entroque', 'entroque', 'f'],
      '0413' => ['fourneau', 'fourneaux', 'm'],
      '0414' => ['ampoule multiprise et rallonge', 'ampoules multiprises et rallonges', 'f'],
      '0415' => ['alésoir à cliquet', 'Alésoirs à cliquets', 'm'],
      '0416' => ['clapier', 'clapiers', 'm'],
      '0417' => ['taloche', 'taloches', 'f'],
      '0418' => ['occiput', 'occiputs', 'm'],
      '0419' => ['diodon', 'diodons', 'm'],
      '0420' => ['tricorne', 'tricornes', 'm'],
      '0421' => ['spume', 'spumes', 'f'],
      '0422' => ['manchon', 'manchons', 'm'],
      '0423' => ['limaçon', 'limaçons', 'm'],
      '0424' => ['levraut', 'levrauts', 'm'],
      '0425' => ['gymkhana', 'gymkhanas', 'm'],
      '0426' => ['dosimètre', 'dosimètres', 'm'],
      '0427' => ['queue-de-pie', 'queues-de-pie', 'f'],
      '0428' => ['clé à pipe débouchée', 'Clés à pipe débouchées', 'f'],
      '0429' => ['perruque', 'perruques', 'f'],
      '0430' => ['traille', 'trailles', 'f'],
      '0501' => ['tripalium', 'tripaliums', 'm'],
      '0502' => ['pastille', 'pastilles', 'f'],
      '0503' => ['francisque', 'francisques', 'f'],
      '0504' => ['pirouette', 'pirouettes', 'f'],
      '0505' => ['marmouset', 'marmousets', 'm'],
      '0506' => ['pédicelle', 'pédicelles', 'm'],
      '0507' => ['hypsomètre', 'hypsomètres', 'm'],
      '0508' => ['lambrequin', 'lambrequins', 'm'],
      '0509' => ['cribellum', 'cribellums', 'm'],
      '0510' => ['hélicoïde', 'hélicoïdes', 'f'],
      '0511' => ['quenouille', 'quenouilles', 'f'],
      '0512' => ['zythum', 'zytha', 'm'],
      '0513' => ['sarbacane', 'sarbacanes', 'f'],
      '0514' => ['turion', 'turions', 'm'],
      '0515' => ['blaireau', 'blaireaux', 'm'],
      '0516' => ['sémaphore', 'sémaphores', 'f'],
      '0517' => ['crispatule', 'crispatules', 'f'],
      '0518' => ['zist', 'zists', 'm'],
      '0519' => ['chiquenaude', 'chiquenaudes', 'f'],
      '0520' => ['sagouin', 'sagouins', 'm'],
      '0521' => ['borborygme', 'borborygmes', 'm'],
      '0522' => ['zéphyr', 'zéphyrs', 'm'],
      '0523' => ['schnock', 'schnocks', 'm'],
      '0524' => ['pendeloque', 'pendeloques', 'f'],
      '0525' => ['falbala', 'falbalas', 'm'],
      '0526' => ['nycthémère', 'nycthémères', 'm'],
      '0527' => ['houppier', 'houppiers', 'm'],
      '0528' => ['suaire', 'suaires', 'm'],
      '0529' => ['jable', 'jables', 'm'],
      '0530' => ['goulot', 'goulots', 'm'],
      '0531' => ['bourdalou', 'bourdalous', 'm'],
      '0601' => ['zibeline', 'zibelines', 'f'],
      '0602' => ['turpitude', 'turpitudes', 'f'],
      '0603' => ['carafon', 'carafons', 'm'],
      '0604' => ['roubignole', 'roubignoles', 'f'],
      '0605' => ['cantharide', 'cantharides', 'f'],
      '0606' => ['pédoncule', 'pédoncules', 'm'],
      '0607' => ['élytre', 'élytres', 'm'],
      '0608' => ['cressonnière', 'cressonnières', 'f'],
      '0609' => ['araignée', 'araignées', 'f'],
      '0610' => ['sarment', 'sarments', 'm'],
      '0611' => ['argousin', 'argousins', 'm'],
      '0612' => ['poudingue', 'poudingues', 'm'],
      '0613' => ['pandiculation', 'pandiculations', 'f'],
      '0614' => ['gaudriole', 'gaudrioles', 'f'],
      '0615' => ['chenapan', 'chenapans', 'm'],
      '0616' => ['carabistouille', 'carabistouilles', 'f'],
      '0617' => ['baliverne', 'balivernes', 'f'],
      '0618' => ['histrion', 'histrions', 'm'],
      '0619' => ['babiole', 'babioles', 'f'],
      '0620' => ['pétouille', 'pétouilles', 'f'],
      '0621' => ['baragouin', 'baragouins', 'm'],
      '0622' => ['patatras', 'patatras', 'm'],
      '0623' => ['alambic', 'alambics', 'm'],
      '0624' => ['billevesée', 'billevesées', 'f'],
      '0625' => ['rigolboche', 'rigolboches', 'f'],
      '0626' => ['turlupin', 'turlupins', 'm'],
      '0627' => ['turlurette', 'turlurettes', 'f'],
      '0628' => ['guignol', 'guignols', 'm'],
      '0629' => ['bille-molle', 'billes-molles', 'f'],
      '0630' => ['brimborion', 'brimborions', 'm'],
      '0701' => ['mirliflore', 'mirliflores', 'f'],
      '0702' => ['clapiotte', 'clapiottes', 'f'],
      '0703' => ['gaffophone', 'gaffophones', 'm'],
      '0704' => ['légumineur', 'légumineurs', 'm'],
      '0705' => ['micro-onduleur', 'micro-onduleurs', 'm'],
      '0706' => ['frite-magique', 'frites-magiques', 'f'],
      '0707' => ['extracteur du potentiel de point zéro', 'extracteurs du potentiel de point zéro', 'm'],
      '0708' => ['réveil-tartine', 'réveils-tartines', 'm'],
      '0709' => ['horloge-moussante', 'horloges-moussantes', 'f'],
      '0710' => ['canapélicoptère', 'canapélicoptères', 'm'],
      '0711' => ['éponge-lumineuse', 'éponges-lumineuses', 'f'],
      '0712' => ['spatulon', 'spatulons', 'm'],
      '0713' => ['vaissellier-volant', 'vaisselliers-volants', 'm'],
      '0714' => ['boîte-à-bêtises', 'boîtes-à-bêtises', 'f'],
      '0715' => ['télé-poubelle', 'télé-poubelles', 'f'],
      '0716' => ['baignoire-parlante', 'baignoires-parlantes', 'f'],
      '0717' => ['armoire-à-glissade', 'armoires-à-glissade', 'f'],
      '0718' => ['pierre manale', 'pierres manales', 'f'],
      '0719' => ['grille-pain de l\'espace', 'grilles-pains de l\'espace', 'm'],
      '0720' => ['robot-raccommodeur', 'robots-raccommodeurs', 'm'],
      '0721' => ['fourchette-à-comptine', 'fourchettes-à-comptines', 'f'],
      '0722' => ['pantoufle-réactive', 'pantoufles-réactives', 'f'],
      '0723' => ['coussin-péteur', 'coussins-péteurs', 'm'],
      '0724' => ['télé-orbitale', 'télés-orbitales', 'f'],
      '0725' => ['brosse-à-dent sonique', 'brosses-à-dent soniques', 'f'],
      '0726' => ['couette-intelligente', 'couettes-intelligentes', 'f'],
      '0727' => ['pyjama-à-histoires', 'pyjamas-à-histoires', 'm'],
      '0728' => ['bol-à-mystère', 'bols-à-mystère', 'm'],
      '0729' => ['tabouret-téléphone', 'tabourets-téléphone', 'm'],
      '0730' => ['miroir-savant', 'miroirs-savants', 'm'],
      '0731' => ['tapis-volant d\'intérieur', 'tapis-volants d\'intérieur', 'm'],
      '0801' => ['oreiller-à-musique', 'oreillers-à-musique', 'm'],
      '0802' => ['papier-peint interactif', 'papiers-peints interactifs', 'm'],
      '0803' => ['xylophone', 'xylophones', 'm'],
      '0804' => ['guilloché', 'guillochés', 'm'],
      '0805' => ['djembé', 'djembés', 'm'],
      '0806' => ['caipirinha', 'caipirinhas', 'f'],
      '0807' => ['tzatziki', 'tzatzikis', 'm'],
      '0808' => ['karaoke', 'karaokes', 'm'],
      '0809' => ['kantele', 'kanteles', 'f'],
      '0810' => ['haiku', 'haikus', 'm'],
      '0811' => ['colchique', 'colchiques', 'f'],
      '0812' => ['molinillo', 'molinillos', 'm'],
      '0813' => ['quokka', 'quokkas', 'f'],
      '0814' => ['duduk', 'duduks', 'm'],
      '0815' => ['balalaïka', 'balalaïkas', 'f'],
      '0816' => ['fajitas', 'fajitas', 'f'],
      '0817' => ['bobineau', 'bobineaux', 'm'],
      '0818' => ['fjord', 'fjords', 'm'],
      '0819' => ['tsampa', 'tsampas', 'f'],
      '0820' => ['qipao', 'qipaos', 'f'],
      '0821' => ['boomerang', 'boomerangs', 'm'],
      '0822' => ['cachou', 'cachous', 'm'],
      '0823' => ['sac à dos', 'sacs à dos', 'm'],
      '0824' => ['brosse à dents', 'brosses à dents', 'f'],
      '0825' => ['lampe de bureau', 'lampes de bureau', 'f'],
      '0826' => ['tapis de souris', 'tapis de souris', 'm'],
      '0827' => ['pot de fleurs', 'pots de fleurs', 'm'],
      '0828' => ['brosse à cheveux', 'brosses à cheveux', 'f'],
      '0829' => ['boucle d\'oreille', 'boucles d\'oreilles', 'f'],
      '0830' => ['manette de jeu', 'manettes de jeu', 'f'],
      '0831' => ['tapis de yoga', 'tapis de yoga', 'm'],
      '0901' => ['corde à sauter', 'cordes à sauter', 'f'],
      '0902' => ['haltère', 'haltères', 'm'],
      '0903' => ['trottinette', 'trottinettes', 'f'],
      '0904' => ['sac de couchage', 'sacs de couchage', 'm'],
      '0905' => ['réchaud de camping', 'réchauds de camping', 'm'],
      '0906' => ['chaussure de randonnée', 'chaussures de randonnée', 'f'],
      '0907' => ['taille-crayon', 'taille-crayons', 'm'],
      '0908' => ['agrafeuse', 'agrafeuses', 'f'],
      '0909' => ['aspirateur', 'aspirateurs', 'm'],
      '0910' => ['lave-linge', 'lave-linges', 'm'],
      '0911' => ['sèche-linge', 'sèche-linges', 'm'],
      '0912' => ['machine à coudre', 'machines à coudre', 'f'],
      '0913' => ['serpillère', 'serpillères', 'f'],
      '0914' => ['tronçonneuse', 'tronçonneuses', 'f'],
      '0915' => ['débroussailleuse', 'débroussailleuses', 'f'],
      '0916' => ['motoculteur', 'motoculteurs', 'm'],
      '0917' => ['râteau', 'râteaux', 'm'],
      '0918' => ['clé à molette', 'clés à molette', 'f'],
      '0919' => ['scie circulaire', 'scies circulaires', 'f'],
      '0920' => ['détecteur de fumée', 'détecteurs de fumée', 'm'],
      '0921' => ['caméra de surveillance', 'caméras de surveillance', 'f'],
      '0922' => ['moustiquaire', 'moustiquaires', 'f'],
      '0923' => ['brise-vent', 'brise-vent', 'm'],
      '0924' => ['balcon', 'balcons', 'm'],
      '0925' => ['jardinière', 'jardinières', 'f'],
      '0926' => ['buisson', 'buissons', 'm'],
      '0927' => ['haie', 'haies', 'f'],
      '0928' => ['système d\'irrigation', 'systèmes d\'irrigation', 'm'],
      '0929' => ['thermomètre', 'thermomètres', 'm'],
      '0930' => ['hygromètre', 'hygromètres', 'm'],
      '1001' => ['luxmètre', 'luxmètres', 'm'],
      '1002' => ['anémomètre', 'anémomètres', 'm'],
      '1003' => ['pluviomètre', 'pluviomètres', 'm'],
      '1004' => ['baromètre', 'baromètres', 'm'],
      '1005' => ['chronomètre', 'chronomètres', 'm'],
      '1006' => ['microscope', 'microscopes', 'm'],
      '1007' => ['télescope', 'télescopes', 'm'],
      '1008' => ['spectroscope', 'spectroscopes', 'm'],
      '1009' => ['sac à bière', 'sacs à bière', 'm'],
      '1010' => ['ohmmètre', 'ohmmètres', 'm'],
      '1011' => ['ampèremètre', 'ampèremètres', 'm'],
      '1012' => ['voltmètre', 'voltmètres', 'm'],
      '1013' => ['oscilloscope', 'oscilloscopes', 'm'],
      '1014' => ['fréquencemètre', 'fréquencemètres', 'm'],
      '1015' => ['analyseur de spectre', 'analyseurs de spectre', 'm'],
      '1016' => ['circuit imprimé', 'circuits imprimés', 'm'],
      '1017' => ['disjoncteur', 'disjoncteurs', 'm'],
      '1018' => ['machine-à-faire-des-trous-dans-les-spaghetti', 'machines-à-faire-des-trous-dans-les-spaghetti', 'f'],
      '1019' => ['morceau de bois', 'morceaux de bois', 'm'],
      '1020' => ['pot de colle', 'pots de colle', 'm'],
      '1021' => ['paquet cadeau', 'paquets cadeaux', 'm'],
      '1022' => ['cacatoès', 'cacatoès', 'f'],
      '1023' => ['harmonica', 'harmonicas', 'm'],
      '1024' => ['bigoudi', 'bigoudis', 'm'],
      '1025' => ['dent de lait', 'dents de lait', 'f'],
      '1026' => ['bonhomme de neige', 'bonhommes de neige', 'm'],
      '1027' => ['marteau picoreur', 'marteaux picoreurs', 'm'],
      '1028' => ['bande magnétique', 'bandes magnétiques', 'f'],
      '1029' => ['punaise de lit', 'punaises de lit', 'f'],
      '1030' => ['carte de voeux', 'cartes de voeux', 'f'],
      '1031' => ['moins que rien', 'moins que rien', 'm'],
      '1101' => ['tour eiffel', 'tours eiffel', 'f'],
      '1102' => ['symptôme', 'symptômes', 'm'],
      '1103' => ['amanite', 'amanites', 'f'],
      '1104' => ['cornichon', 'cornichons', 'm'],
      '1105' => ['escarpolette', 'escarpolettes', 'f'],
      '1106' => ['jouet à bascule', 'jouets à bascule', 'm'],
      '1107' => ['bloc-notes', 'blocs-notes', 'm'],
      '1108' => ['routoir', 'routoirs', 'm'],
      '1109' => ['guenille', 'guenilles', 'f'],
      '1110' => ['lunette de soleil', 'lunettes de soleil', 'f'],
      '1111' => ['octavin', 'octavins', 'm'],
      '1112' => ['toque à trois cornes', 'toques à trois cornes', 'f'],
      '1113' => ['navire-hôpital', 'navires-hôpitaux', 'm'],
      '1114' => ['sesquiplan', 'sesquiplans', 'm'],
      '1115' => ['baldaquin', 'baldaquins', 'm'],
      '1116' => ['anémoscope', 'anémoscopes', 'm'],
      '1117' => ['clavicythérium', 'clavicythériums', 'm'],
      '1118' => ['certificat de conformité', 'certificats de conformité', 'm'],
      '1119' => ['bonnet de nuit', ' bonnets de nuit', 'm'],
      '1120' => ['atmomètre', 'atmomètres', 'm'],
      '1121' => ['pnéomètre', 'pnéomètres', 'm'],
      '1122' => ['marie-salope', 'marie-salopes', 'f'],
      '1123' => ['lettre de crédit', 'lettres de crédit', 'f'],
      '1124' => ['cithare', 'cithares', 'f'],
      '1125' => ['tramezzino', 'tramezzinos', 'm'],
      '1126' => ['ichcahuipilli', 'ichcahuipillis', 'f'],
      '1127' => ['journal intime', 'journaux intimes', 'm'],
      '1128' => ['harpe celtique', 'harpes celtiques', 'f'],
      '1129' => ['noeud d’agui', 'noeuds d’agui', 'm'],
      '1130' => ['cabotière', 'cabotières', 'f'],
      '1201' => ['pique-oeuf', 'pique-oeufs', 'm'],
      '1202' => ['revue de contrat', 'revues de contrats', 'f'],
      '1203' => ['grande surface', 'grandes surfaces', 'f'],
      '1204' => ['manteau de cheminée', 'manteaux de cheminées', 'm'],
      '1205' => ['charentaise', 'charentaises', 'f'],
      '1206' => ['chasse-goupille', 'chasse-goupilles', 'm'],
      '1207' => ['chaussure à orteils', 'chaussures à orteils', 'f'],
      '1208' => ['giroflée à cinq pétales', 'giroflées a cinq pétales', 'f'],
      '1209' => ['salade de phalanges', 'salades de phalanges', 'f'],
      '1210' => ['rogntudju', 'rogntudju', 'm'],
      '1211' => ['lixiviateuse', 'lixiviateuses', 'f'],
      '1212' => ['chaise berçante', 'chaises berçantes', 'f'],
      '1213' => ['chebec', 'chebec', 'm'],
      '1214' => ['boulevard circulaire', 'boulevards circulaires', 'm'],
      '1215' => ['bande cyclable', 'bandes cyclables', 'f'],
      '1216' => ['coupe-boulons', 'coupe-boulons', 'm'],
      '1217' => ['clé à pipe', 'clés à pipe', 'f'],
      '1218' => ['zeugme', 'zeugmes', 'm'],
      '1219' => ['tricordeur à ampoules sous vide', 'tricordeurs à ampoules sous vide', 'm'],
      '1220' => ['diptyque', 'diptyques', 'm'],
      '1221' => ['clavette basculante', 'clavettes basculantes', 'f'],
      '1222' => ['glassophone', 'glassophones', 'm'],
      '1223' => ['métaphore', 'métaphores', 'f'],
      '1224' => ['pentécontère', 'pentécontères', 'm'],
      '1225' => ['sapin à trois roues', 'sapins à trois roues', 'm'],
      '1226' => ['cumulus bourgeonnant', 'cumulus bourgeonnants', 'm'],
      '1227' => ['pyréolophore', 'pyréolophores', 'm'],
      '1228' => ['soubassophone', 'soubassophones', 'm'],
      '1229' => ['vastringue', 'vastringues', 'm'],
      '1230' => ['vocifération sportive', 'vociférations sportives', 'f'],
      '1231' => ['connotation de proximité temporelle', 'connotations de proximité temporelle', 'f'],
    },
  );

  my @telechat_days = ('Lourdi', 'Pardi', 'Morquidi', 'Jourdi', 'Dendrevi', 'Sordi', 'Mitanche');

  my $today = DateTime->now(locale => $self->locale);
  my $day_name = $telechat_days[$today->day_of_week_0];

  my @calendars = sort keys %telechat_calendars;
  my $calendar_key = sprintf("%02d", $today->month).sprintf("%02d", $today->day);
  shift @calendars unless $telechat_calendars{'0tvtime'}->{$calendar_key};
  my $chosen_calendar = @calendars[rand @calendars];
  my $feast = $telechat_calendars{$chosen_calendar}->{$calendar_key};
  my $feast_gender = $feast->[2] eq 'm' ? 'Saint' : 'Sainte';
  my $feast_singular = $feast->[0];
  $feast_singular =~ s/\b(\w)/\U$1/g;
  my $feast_plural = $feast->[1];
  my $every_gender = $feast->[2] eq 'm' ? 'tous' : 'toutes';

  if ($self->special_birthday_day && $self->special_birthday_month && $self->special_birthday_name && $today->day == $self->special_birthday_day && $today->month == $self->special_birthday_month) {
      $feast_gender = $self->special_birthday_gender eq 'm' ? 'Saint' : 'Sainte';
      $feast_singular = $self->special_birthday_name;
      $feast_plural = $self->special_birthday_plural;
      $every_gender = $self->special_birthday_gender eq 'm' ? 'tous' : 'toutes';
  }

  my $msg = sprintf("Chalut ! Aujourd'hui, %s %d, c'est la %s-%s.\nBonne fête à %s les %s !", $day_name, $today->day, $feast_gender, $feast_singular, $every_gender, $feast_plural);

  my $img_path = dist_file('App-SpreadRevolutionaryDate', 'images/groucha.png');
  my $img_alt = "Grouchat de Téléchat : « $msg »";
  $img_alt =~ s/\n+/ /g;
  my $img = {path => $img_path, alt => $img_alt};

  return ($msg, $img);
}


no Moose;
__PACKAGE__->meta->make_immutable;

# A module must return a true value. Traditionally, a module returns 1.
# But this module is a revolutionary one, so it discards all old traditions.
# Idea borrowed from Jean Forget's DateTime::Calendar::FrenchRevolutionary.
"Quand le gouvernement viole les droits du peuple,
l'insurrection est pour le peuple le plus sacré
et le plus indispensable des devoirs";

__END__

=pod

=encoding UTF-8

=head1 NAME

App::SpreadRevolutionaryDate::MsgMaker::Telechat - MsgMaker class for L<App::SpreadRevolutionaryDate> to build message with Téléchat date

=head1 VERSION

version 0.49

=head1 METHODS

=head2 compute

Computes date of the day similar to the Belgian-French TV show 'Téléchat" on the 1980's. Takes no argument. Returns message as string and hash with the path to an image file of Groucha, the presenter of Téléchat, and its alt text, with 'path' and 'alt' keys respectively.

This message maker is greatly based on I<SaintObjetBot> a bot spreading, in "Téléchat style", the date and the feast of the day, see L<https://github.com/tobozo/SaintObjetBot>.

There is no really offical Téléchat calendar (named calendar of holly objects, calendrier des objet saints in French), the principle is to use new inventions of objects instead of outdated objects.

We have found three sources for calendar names: what has actually been broadcasted on tv show, see L<https://www.tvtime.com/fr/show/257185>, and two versions computed by I<SaintObjetBot>, see L<https://github.com/tobozo/SaintObjetBot/blob/main/data/saint-objet-bot-2023-11-09.csv>. We pickup randomly among theses three calendars, and when there is nothing for the current day in the first calendar (because, nothing was broadcasted this day), only among the two last ones.

=head1 SEE ALSO

=over

=item L<spread-revolutionary-date>

=item L<App::SpreadRevolutionaryDate>

=item L<App::SpreadRevolutionaryDate::Config>

=item L<App::SpreadRevolutionaryDate::BlueskyLite>

=item L<App::SpreadRevolutionaryDate::Target>

=item L<App::SpreadRevolutionaryDate::Target::Bluesky>

=item L<App::SpreadRevolutionaryDate::Target::Twitter>

=item L<App::SpreadRevolutionaryDate::Target::Mastodon>

=item L<App::SpreadRevolutionaryDate::Target::Freenode>

=item L<App::SpreadRevolutionaryDate::Target::Freenode::Bot>

=item L<App::SpreadRevolutionaryDate::Target::Liberachat>

=item L<App::SpreadRevolutionaryDate::Target::Liberachat::Bot>

=item L<App::SpreadRevolutionaryDate::MsgMaker>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Calendar>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Locale>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Locale::fr>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Locale::en>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Locale::it>

=item L<App::SpreadRevolutionaryDate::MsgMaker::RevolutionaryDate::Locale::es>

=item L<App::SpreadRevolutionaryDate::MsgMaker::PromptUser>

=item L<App::SpreadRevolutionaryDate::MsgMaker::Gemini>

=back

=head1 AUTHOR

Gérald Sédrati <gibus@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019-2025 by Gérald Sédrati.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
