# NAME

cat-v - 인쇄되지 않는 문자 시각화

# SYNOPSIS

cat-v \[ 옵션 \] args ...

    OPTIONS
       -n   --reset         Disable all character conversion
       -c   --visible=#     Specify visualize characters
            --repeat=#      Specify repeat characters
       -t   --expand        Expand tabs
       -T   --no-expand     Do not expand tabs
      --ts  --tabstyle=#    Set tab style
            --tabstop=#     Set tab width
            --tabhead=#     Set tab-head character
            --tabspace=#    Set tab-space character
       -h   --help          Print this message
       -v   --version       Print version

    OPTIONS FOR EACH CHARACTERS
      --esc                 Enable escape
      --esc=c               Show escape in control format
      --esc=+c              Show escape in control format and reproduce
      --nl=0                Disable newline
      --sp=~                Convert spaces to tilde
      --sp='OPEN BOX'       Unicode name
      --esc=+U+035B         Unicode code point

# VERSION

Version 0.99

# DESCRIPTION

`cat -v` 명령은 표시할 수 없는 문자를 표시하는 데 자주 사용되지만, ASCII가 아닌 모든 문자를 변환하기 때문에 최신 응용 프로그램의 출력을 보는 데 항상 적합하지는 않습니다.

`cat-v` 명령은 표시 가능한 그래픽 문자의 표시를 유지하면서 공백과 제어 문자를 시각화합니다.

<div>
    <p><img width="750" src="https://raw.githubusercontent.com/tecolicom/App-cat-v/main/images/tree.png">
</div>

또한 기본적으로 이스케이프 문자는 변환되지 않으므로 ANSI 이스케이프 시퀀스에 의한 장식이 유지됩니다.

<div>
    <p><img width="750" src="https://raw.githubusercontent.com/tecolicom/App-cat-v/main/images/visualized.png">
</div>

때로는 공백 문자를 시각화하는 것이 바람직할 때가 있습니다. `cat -t` 명령은 탭 문자를 시각화할 수 있지만 시각적 형식을 깨뜨린다는 문제가 있습니다. 형식을 유지하면서 어떤 부분이 탭 문자이고 어떤 부분이 공백 문자인지 확인하고 싶을 수 있습니다. 줄 끝에 있는 여분의 공백 문자도 시각화하여 알아볼 수 있습니다.

`cat-v`를 사용하면 탭 문자가 디스플레이의 공백이 변하지 않는 방식으로 시각화됩니다.

<div>
    <p><img width="750" src="https://raw.githubusercontent.com/tecolicom/App-cat-v/main/images/tabstyle-pin.png">
</div>

제어 문자는 제어 형식과 유니코드 기호 문자로 표시할 수 있습니다. 기본적으로 개행 및 이스케이프 문자를 제외한 제어 문자는 해당 유니코드 기호로 표시됩니다.

두 번째 필드는 기본 동작입니다. `s`는 기호, `m`은 유니코드 마크, `0`은 변환하지 않음을 나타냅니다.

    nul   s  \000  \x{2400}  ␀  SYMBOL FOR NULL
    soh   s  \001  \x{2401}  ␁  SYMBOL FOR START OF HEADING
    stx   s  \002  \x{2402}  ␂  SYMBOL FOR START OF TEXT
    etx   s  \003  \x{2403}  ␃  SYMBOL FOR END OF TEXT
    eot   s  \004  \x{2404}  ␄  SYMBOL FOR END OF TRANSMISSION
    enq   s  \005  \x{2405}  ␅  SYMBOL FOR ENQUIRY
    ack   s  \006  \x{2406}  ␆  SYMBOL FOR ACKNOWLEDGE
    bel   s  \007  \x{2407}  ␇  SYMBOL FOR BELL
    bs    s  \010  \x{2408}  ␈  SYMBOL FOR BACKSPACE
    ht    s  \011  \x{2409}  ␉  SYMBOL FOR HORIZONTAL TABULATION
    nl    m  \012  \x{240A}  ␊  SYMBOL FOR LINE FEED
    vt    s  \013  \x{240B}  ␋  SYMBOL FOR VERTICAL TABULATION
    np    m  \014  \x{240C}  ␌  SYMBOL FOR FORM FEED
    cr    s  \015  \x{240D}  ␍  SYMBOL FOR CARRIAGE RETURN
    so    s  \016  \x{240E}  ␎  SYMBOL FOR SHIFT OUT
    si    s  \017  \x{240F}  ␏  SYMBOL FOR SHIFT IN
    dle   s  \020  \x{2410}  ␐  SYMBOL FOR DATA LINK ESCAPE
    dc1   s  \021  \x{2411}  ␑  SYMBOL FOR DEVICE CONTROL ONE
    dc2   s  \022  \x{2412}  ␒  SYMBOL FOR DEVICE CONTROL TWO
    dc3   s  \023  \x{2413}  ␓  SYMBOL FOR DEVICE CONTROL THREE
    dc4   s  \024  \x{2414}  ␔  SYMBOL FOR DEVICE CONTROL FOUR
    nak   s  \025  \x{2415}  ␕  SYMBOL FOR NEGATIVE ACKNOWLEDGE
    syn   s  \026  \x{2416}  ␖  SYMBOL FOR SYNCHRONOUS IDLE
    etb   s  \027  \x{2417}  ␗  SYMBOL FOR END OF TRANSMISSION BLOCK
    can   s  \030  \x{2418}  ␘  SYMBOL FOR CANCEL
    em    s  \031  \x{2419}  ␙  SYMBOL FOR END OF MEDIUM
    sub   s  \032  \x{241A}  ␚  SYMBOL FOR SUBSTITUTE
    esc   0  \033  \x{241B}  ␛  SYMBOL FOR ESCAPE
    fs    s  \034  \x{241C}  ␜  SYMBOL FOR FILE SEPARATOR
    gs    s  \035  \x{241D}  ␝  SYMBOL FOR GROUP SEPARATOR
    rs    s  \036  \x{241E}  ␞  SYMBOL FOR RECORD SEPARATOR
    us    s  \037  \x{241F}  ␟  SYMBOL FOR UNIT SEPARATOR
    sp    m  \040  \x{2420}  ␠  SYMBOL FOR SPACE
    del   s  \177  \x{2421}  ␡  SYMBOL FOR DELETE
    nbsp  s  \240  \x{2423}  ␣  OPEN BOX

현재 다음 문자에 대해 유니코드 표시를 사용할 수 있습니다.

    nul   \x{2205}  ∅  EMPTY SET
    bel   \x{237E}  ⍾  BELL SYMBOL
    nl    \x{23CE}  ⏎  RETURN SYMBOL
    np    \x{2398}  ⎘  NEXT PAGE
    sp    \x{00B7}  ·  MIDDLE DOT

# OPTIONS

- **-n**, **--reset**

    모든 문자 변환을 비활성화하고 반복 문자를 재설정합니다.

- **-c**, **--visible** _name_=_flag_,...

    문자 유형과 플래그를 매개변수로 지정하여 시각화할 문자와 변환 형식을 지정합니다.

        c  control style
        s  symbol style
        m  Unicode mark (if exists)
        0  do not convert
        *  non-alphanumeric char is used as a replacement

    옵션 `-c nl=1`을 사용하여 개행 문자를 시각화할 수도 있습니다. 개행 문자의 경우에만 변환 결과를 표시한 후 원래 문자가 동시에 출력됩니다.

    위 목록의 이름을 사용하여 문자 유형별로 지정할 수 있습니다. 탭을 변환하지 않고 이스케이프 문자를 변환하려면 다음을 사용하세요.

        cat-v -c tab=0 -c esc=s

    여러 항목을 동시에 지정할 수 있습니다. 다음 예에서는 `tab` 및 `bel`을 0으로, `esc`를 `s`로 설정합니다.

        cat-v -c tab=bel=0,esc=s

    이름에 `all`을 지정하면 이 값은 모든 문자 유형에 적용됩니다. 다음 명령은 모든 문자를 `s`로 설정한 다음 `nl`, `nl`, `np` 및 `sp`를 `m`으로 설정하고 `esc`를 비활성화합니다. 이것이 기본 상태입니다.

        cat-v -c all=s,nul=nl=np=sp=m,esc=0

- **--**_name_\[=_replacement_\]

    모든 제어 문자는 이름과 함께 옵션으로 액세스할 수도 있습니다. 예를 들어, 옵션 `--nl`은 개행 문자에 대해 정의됩니다.

    단독으로 사용하면 문자의 표시 여부가 활성화됩니다.

        cat-v --nl

    비활성화하려면 값을 0으로 지정합니다.

        cat-v --nl=0

    알파벳이나 숫자가 아닌 다른 문자를 입력하면 해당 문자로 대체됩니다.

        cat-v --nl='$'

    두 개 이상의 문자로 구성된 문자열을 지정하면 유니코드 문자 이름으로 해석됩니다.

        cat-v --nl='RETURN SYMBOL' --sp='MIDDLE DOT'

    플래그가 `+`로 시작하면 해당 문자가 반복 목록에 추가됩니다.

        cat -v --esc=+s

    따라서 위의 명령은 다음과 같이 작성했을 때와 같은 의미를 갖습니다.

        cat -v --esc=s --repeat +esc

- **--repeat**=_name_\[,_name_...\]

    변환된 문자와 동시에 원본 문자를 출력하기 위한 문자 유형을 지정합니다. 기본 설정은 `nl,np`입니다. 다음은 이스케이프 문자가 시각화된 원본 ANSI 시퀀스를 올바르게 출력합니다.

        cat-v -c esc --repeat esc,nl

    _이름_이 `+`로 시작하는 경우 기존 구성에 해당 문자를 추가합니다.

        cat-v -c esc --repeat +esc

- **-t**, **--expand**
- **-T**, **--no-expand**

    탭 문자는 기본적으로 확장됩니다. 명시적으로 비활성화하려면 **-T** 또는 **--확장 안 함** 옵션을 사용합니다.

    기본적으로 `핀` 스타일이 적용되며, `--탭 스타일`로 변경할 수 있습니다. `--탭스타일` 옵션을 인자 없이 지정하면 사용 가능한 스타일 목록이 표시됩니다.

    `~/.cat-vrc` 파일에 다음 설정을 넣어 탭 확장을 기본적으로 비활성화할 수 있습니다.

        option default --no-expand

    이러한 경우 `-t` 옵션으로 탭 확장을 일시적으로 활성화할 수 있습니다.

- **--tabstop**=# (DEFAULT: 8)

    탭 너비를 설정합니다.

- **--tabhead**=#
- **--tabspace**=#

    탭 머리글과 그 뒤에 오는 공백 문자를 설정합니다. 옵션 값이 한 글자보다 길면 유니코드 이름으로 평가됩니다.

- **--tabstyle**, **--ts**
- **--tabstyle**=_style_, **--ts**=...
- **--tabstyle**=_head-style_,_space-style_ **--ts**=...

    탭이 펼쳐지는 스타일을 설정합니다. 예를 들어 `기호` 또는 `음영`을 선택합니다. `스쿼트 화살표, 가운데 점`과 같이 두 가지 스타일 이름이 결합된 경우 탭헤드에는 `스쿼트 화살표`, 탭스페이스에는 `가운데 점`을 사용합니다.

    매개변수 없이 호출하면 사용 가능한 스타일 목록을 표시합니다. 스타일은 [Text::ANSI::Fold](https://metacpan.org/pod/Text%3A%3AANSI%3A%3AFold) 라이브러리에 정의되어 있습니다.

# INSTALL

## CPANMINUS

CPAN 아카이브에서:

    cpanm App::cat::v

GIT 리포지토리에서:

    cpanm https://github.com/tecolicom/App-cat-v.git

# SEE ALSO

- [https://github.com/tecolicom/App-cat-v.git](https://github.com/tecolicom/App-cat-v.git)

    Git 리포지토리.

- [App::optex::util::filter](https://metacpan.org/pod/App%3A%3Aoptex%3A%3Autil%3A%3Afilter)

    `cat-v` 명령의 이전 버전은 원래 [App::optex](https://metacpan.org/pod/App%3A%3Aoptex) 명령의 필터 모듈로 만들어졌습니다.

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2024 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
