package Amazon::API::Pod::Simple::Text;

use strict;
use warnings;

use parent qw{Pod::Simple::Text};
use IO::Scalar;
use ReadonlyX;

our @EXPORT = qw{ $SECTION };

Readonly::Scalar my $TRUE  => 1;
Readonly::Scalar my $FALSE => 0;
Readonly::Scalar my $EMPTY => q{};

our $VERSION = '0.01';

my $PROCESS_HEAD2   = $FALSE;
my $PROCESS_ELEMENT = $FALSE;

our $SECTION;

caller or __PACKAGE__->main(@ARGV);

########################################################################
sub _handle_text {
########################################################################
  my ( $self, @args ) = @_;

  if ( $SECTION && $PROCESS_HEAD2 && $args[0] eq $SECTION ) {
    $PROCESS_ELEMENT = $TRUE;
    $PROCESS_HEAD2   = $FALSE;
  }
  else {
    $PROCESS_HEAD2 = $FALSE;
  }

  return $PROCESS_ELEMENT
    || !$SECTION ? $self->SUPER::_handle_text(@args) : undef;
}

########################################################################
sub start_head2 {
########################################################################
  my ( $self, @args ) = @_;

  $PROCESS_HEAD2   = $TRUE;
  $PROCESS_ELEMENT = $FALSE;

  return $self->SUPER::start_head2(@args);
}

1;
