package HTML::Lint::Pluggable::HTML5;
use 5.008_001;
use strict;
use warnings;

our $VERSION = '0.08';

use parent qw/ HTML::Lint::Pluggable::WhiteList /;
use List::MoreUtils qw/any/;

my %html5_tag = map { $_ => 1 } qw/article aside audio bdi canvas command datalist details dialog embed figcaption figure footer header hgroup keygen main mark menu menuitem meter nav output progress section source summary template time track video rb rp rt rtc ruby wbr/;

my %html5_global_attr = map { $_ => 1 } qw/contenteditable contextmenu draggable dropzone hidden role spellcheck tabindex translate/;
my @html5_global_user_attr = (qr/^aria-/, qr/^data-/);
my %html5_attr = (
    a        => +{ map { $_ => 1 } qw/media/ },
    area     => +{ map { $_ => 1 } qw/media hreflang rel/ },
    base     => +{ map { $_ => 1 } qw/target/ },
    meta     => +{ map { $_ => 1 } qw/charset/ },
    input    => +{ map { $_ => 1 } qw/autofocus placeholder form required autocomplete min max multiple pattern step dirname formaction formenctype formmethod formnovalidate formtarget/ },
    select   => +{ map { $_ => 1 } qw/autofocus form required/ },
    textarea => +{ map { $_ => 1 } qw/autofocus placeholder form required dirname maxlength wrap/ },
    button   => +{ map { $_ => 1 } qw/form autofocus formaction formenctype formmethod formnovalidate formtarget/ },
    output   => +{ map { $_ => 1 } qw/form/ },
    label    => +{ map { $_ => 1 } qw/form/ },
    object   => +{ map { $_ => 1 } qw/form/ },
    fieldset => +{ map { $_ => 1 } qw/form disabled/ },
    form     => +{ map { $_ => 1 } qw/novalidate/ },
    menu     => +{ map { $_ => 1 } qw/type label/ },
    style    => +{ map { $_ => 1 } qw/scoped/ },
    script   => +{ map { $_ => 1 } qw/async/ },
    html     => +{ map { $_ => 1 } qw/manifest/ },
    link     => +{ map { $_ => 1 } qw/sizes/ },
    ol       => +{ map { $_ => 1 } qw/reversed/ },
    iframe   => +{ map { $_ => 1 } qw/sandbox seamless srcdoc allowfullscreen/ },
);

# Generated by html5_entities.pl
my %html5_entity = map { "&" . $_ . ";" => 1 } qw/ frac13 supE gtcc filig boxdr
    DownLeftTeeVector Rscr ggg larrfs simg SHcy Verbar dfisht qopf boxvl lat
    VDash dfr rdquor boxDl vsubne isindot Rsh Ofr suphsub Ncy bcy timesb prnE
    starf TildeEqual zfr cire supset ShortUpArrow EqualTilde acy NotTildeEqual
    Breve gnE wreath supdot nbump lrarr NotNestedGreaterGreater Zopf CirclePlus
    lotimes circledast eqslantgtr nprcue Hfr gtreqless LeftRightArrow
    upharpoonleft escr ThickSpace Updownarrow khcy nearr DiacriticalAcute equest
    nsupset npolint curarrm lrhar suplarr gesdot gtrdot dopf triplus ngt Hopf
    bsime ominus SquareUnion boxHU Uscr xrArr nvlArr CircleTimes pluse homtht
    triminus complement LeftTee midcir boxvR IEcy Wscr Qopf nsupe gnap iiiint
    circeq olcir LeftDownVectorBar supsup mscr ncap triangleq nleftarrow Mcy
    nsucc varr Equal urcorner RightVector NestedGreaterGreater LeftDownTeeVector
    Downarrow LowerLeftArrow nrArr TildeFullEqual setminus Integral pre vsubnE
    forkv nle Conint boxh odash LessTilde twoheadleftarrow HARDcy Escr tridot
    srarr ohm NotGreaterFullEqual oscr ell Ccaron emptyset Lscr rscr rBarr
    DiacriticalTilde twixt gneqq lhblk Emacr LessLess block Sfr Tcaron
    PrecedesTilde IOcy backepsilon precneqq Uogon gel boxdR nvge cirE divonx rcy
    Abreve Assign UnionPlus frac45 Ncedil zopf complexes
    CounterClockwiseContourIntegral quatint larrlp zhcy ngeqq sdote jopf cupdot
    Lt boxur boxuL naturals DD vrtri gtcir blacktriangleright circledR swArr
    lesdot nbumpe searrow updownarrow ltquest Fouriertrf check nsube Lcy
    DoubleContourIntegral gopf dashv Wopf rtriltri boxvH lobrk boxdl yscr
    PlusMinus curvearrowleft Square shortmid subseteqq nsup planckh circledS
    tritime NotLessTilde nltri natural gcirc el boxhd iopf Leftrightarrow mcy
    thetav capbrcup SucceedsTilde DownRightVectorBar lharu Colon Rcaron dollar
    uogon LeftArrowBar bcong olarr triangle smashp blacktriangle
    LeftUpDownVector les nfr SquareSubsetEqual prec xoplus preccurlyeq solbar
    rnmid odsold Pscr Equilibrium rx larrtl Star eqvparsl egsdot Lopf pcy lharul
    dharl lesg lAtail UnderBar ufr bigtriangleup RightUpDownVector profalar
    cirscir nvDash gla QUOT eqsim simrarr gdot capdot upsi NotLess wscr epar
    sqcups succcurlyeq Succeeds supseteq nrarrc NegativeThickSpace ratail ncup
    nlE notinvc leqq leg comp andslope oint DoubleLongLeftArrow rharul mfr
    SquareSubset Omacr leftleftarrows curlyvee duarr LeftFloor llhard zdot
    longleftarrow LeftArrowRightArrow mho ntgl xuplus LT ncy sc centerdot
    Congruent larrsim smid NotLessGreater gvertneqq cupbrcap leftrightsquigarrow
    trpezium colon LeftTeeArrow varnothing vprop gtreqqless plusdo nsce xutri
    Upsi sqsube between Gt ncongdot CloseCurlyDoubleQuote sqcup nsubseteq Ncaron
    RightTeeArrow csup ngeqslant ultri ord LeftDownVector Rfr DoubleLeftArrow
    nwarr imath nVDash larrpl Gdot infintie nlarr sscr DScy Kfr curlyeqsucc
    DiacriticalGrave GJcy gtrarr DownArrow UpArrow plussim Implies ntriangleleft
    NotSucceeds dzigrarr urcrop DoubleLongRightArrow RightTriangleBar backsimeq
    nap rightarrow xlarr SuchThat Hacek nsime DownTee larrb PrecedesSlantEqual
    gjcy bigoplus ac pluscir rarrb eogon NotSquareSubsetEqual prnsim andd hairsp
    ffilig RightDownVectorBar And doteqdot rcub sopf nlArr ltri bigcirc Bcy sext
    angle frac16 boxvh scpolint Aogon DownBreve zeetrf kopf Re nearhk rmoustache
    Nfr lvnE NotSquareSupersetEqual racute Lang nwnear NotEqualTilde subsetneq
    imacr curlywedge DoubleUpArrow dot imof leftarrowtail eDot sqsub hybull tosa
    odiv Mellintrf ddagger frac56 VeryThinSpace ltrif lsquor clubsuit nges
    expectation Bfr realine dharr xodot NotNestedLessLess ffr Ascr ldsh Map
    nltrie simgE period NotSuperset DoubleLongLeftRightArrow pfr supne Nscr
    marker Topf blacktriangledown dsol subset bsol Gopf bsim DoubleVerticalBar
    Cacute andand aopf NewLine veebar CHcy angsph bopf ShortDownArrow eng
    dotsquare inodot boxvr half frac35 NotRightTriangleEqual notnivb puncsp
    dlcrop subplus flat straightphi rbrace VerticalTilde gesles bkarow Ll scnsim
    Wfr Ucy ogt div Barwed ntrianglelefteq ssmile tcy RightArrowBar Rarr lessgtr
    timesbar swarrow UpArrowBar Cconint curvearrowright olcross iprod cacute
    Otimes tstrok nsccue strns CenterDot ohbar lrcorner plus gesl fopf npreceq
    hscr LeftVector Rrightarrow multimap sccue Idot Jscr ovbar vopf xopf Acy lcy
    nvgt Hstrok Vee Ufr NotRightTriangleBar boxUr nLtv Ycy kjcy jcirc geqslant
    backsim rtri RightArrow csube glE Gscr sigmav TSHcy Rang UnderBrace
    varsupsetneqq tshcy cwint late Wedge mid dotminus angmsdaf phiv mldr ecir
    FilledSmallSquare cups boxDL TRADE DoubleRightArrow vartheta topf
    GreaterEqual aogon Gg ijlig erDot rfr NegativeVeryThinSpace lE
    NotLeftTriangleEqual YUcy doteq RoundImplies Mscr digamma Vcy shchcy
    ContourIntegral Qscr angmsdac hopf subsup smallsetminus Wcirc triangleright
    yucy gE boxDr blacklozenge succeq notniva nleftrightarrow RightDownTeeVector
    ofcir lsh rhard lozf uscr subE copf Coproduct square bNot DownRightVector
    amacr KJcy equals supsub yfr hardcy Ffr Zcy succnapprox simeq rationals
    mnplus fork GreaterSlantEqual xdtri odot jmath vsupne awconint nleqq Lcaron
    Dopf epsi acd xvee eparsl csub lnsim ncedil quaternions nldr rarrlp excl
    Bernoullis lbarr ring rightarrowtail boxUl rightrightarrows lcaron notinva
    LeftTriangle emsp14 Cup Lleftarrow Esim boxuR phone Lsh emptyv ccaps
    mapstoup barwed larrbfs vsupnE vzigzag vcy ycirc Kcedil pertenk Xfr bigwedge
    cirmid boxul Zdot veeeq bbrk NotGreaterTilde boxplus ddotseq RightTee hbar
    profsurf lbrkslu angmsd esdot lfr scirc LeftTriangleEqual lhard leftarrow
    lEg NotPrecedes Yscr leftrightarrow xcup ltrPar rlhar risingdotseq comma
    roang dblac submult cross rhov NotEqual fpartint rangd gnsim sqcap zcaron
    frac25 lgE larrhk star succsim Nopf Vbar NotLessLess Copf subseteq bumpE
    diamondsuit wedgeq nsubseteqq lmidot commat DoubleLeftTee LeftTriangleBar
    Cdot cir DifferentialD suphsol subdot iukcy gnapprox lrtri uharl vBarv harrw
    Tab CloseCurlyQuote topcir elsdot ropar Rcedil gammad xwedge bigstar orv
    Edot Fopf UpDownArrow thksim bowtie YAcy NotGreaterLess cdot iogon zacute
    RightCeiling amalg xharr gtrapprox Cscr target Rcy caron mapstodown lurdshar
    notinE npr lneqq kfr CircleMinus gescc ltcir Because Tilde succneqq
    RightTriangleEqual Kscr lacute DotDot olt nLt lesdoto bot wedge precsim
    luruhar Longleftarrow NegativeThinSpace semi ClockwiseContourIntegral range
    lrhard angmsdag Iogon fltns boxdL abreve OverParenthesis iecy
    DoubleUpDownArrow bscr conint boxhD ZHcy cupor bprime iiint NotGreaterEqual
    Vscr sdotb rrarr Ubrcy mapstoleft Sup LJcy ZeroWidthSpace lthree
    longleftrightarrow Rarrtl UpEquilibrium Diamond hstrok uparrow Vfr angzarr
    gtlPar approxeq smtes downharpoonleft hcirc ssetmn bigcap npre
    NotTildeFullEqual die UpTee nsupseteq simlE sacute Jsercy uwangle cuwed
    napprox NotDoubleVerticalBar angrtvbd Dfr operp cularr scE roarr jsercy
    rightharpoondown varepsilon rpargt wcirc nsim boxVL loplus Darr ll Iscr
    angrtvb geq xlArr smeparsl fllig nrtrie gimel lopar dcaron ldrdhar Sub
    InvisibleComma chcy angmsdaa backcong intlarhk GreaterEqualLess bnequiv
    NotSucceedsEqual gtquest solb boxUR nscr lagran LeftArrow Subset urtri
    nrightarrow parsim Cfr roplus boxvL ApplyFunction varpi DownTeeArrow
    InvisibleTimes circlearrowleft gfr circledcirc ocir parallel verbar mapsto
    Imacr iff approx frac18 leftrightharpoons wr lessdot wopf iocy uhblk numero
    male trisb rsh NotVerticalBar Tcy ocy cuepr nsmid EmptySmallSquare
    NotSupersetEqual DJcy lessapprox rarrap reals simne cudarrr subsetneqq GT
    bemptyv sqsupset egs nparsl rAtail opar MinusPlus nleqslant ngE ddarr ffllig
    NotSubset incare uuarr Dstrok Rightarrow downarrow LessFullEqual Sopf slarr
    oS NotPrecedesSlantEqual boxH lsimg barwedge longmapsto Itilde
    SucceedsSlantEqual nharr SucceedsEqual Oopf UnderBracket spar lates because
    NotLessEqual plankv iinfin NotLeftTriangle coprod rtrie mp yacy caps
    trianglelefteq supdsub natur nexists apid bsemi rarrw Jcy squ dstrok rbrkslu
    becaus beth nLeftarrow efDot prap nleq ofr bump ulcorn top supnE ubreve
    NotHumpDownHump Del wfr vfr ifr Gbreve swarhk nesim quest Tfr neArr
    LeftVectorBar Icy Ifr dtrif nopf ii eDDot boxVR Element swnwar Jfr
    ntrianglerighteq Intersection COPY nesear Lfr gcy kcy Zacute Ecaron rbarr
    ImaginaryI cupcap LT NotCongruent Dcaron vltri nvltrie cscr Uarr Exists
    HorizontalLine mcomma bernou Ropf leqslant xmap lnE nvdash boxminus rbrack
    caret upharpoonright dscy ldrushar lne utilde nsc gsiml notindot scap
    backprime nvrtrie minusdu topfork ForAll LeftCeiling langle ecy models
    rarrtl vee djcy NotTilde icy dotplus SquareSupersetEqual ShortLeftArrow
    llarr prurel isins Vert lcedil nsubset geqq ThinSpace robrk nrarrw pointint
    Umacr ee boxVh nLeftrightarrow rarrbfs Fcy Xscr OverBracket gsime REG
    circleddash ic varsupsetneq GreaterFullEqual Longrightarrow npar vArr mopf
    oopf Scirc hslash napos hercon barvee LeftDoubleBracket blank lHar Dashv
    eplus nvrArr Laplacetrf longrightarrow uopf origof capand boxV LeftUpVector
    ltdot rarrsim rthree downdownarrows disin varpropto gap sqsupe pscr Lcedil
    lmoust esim acE SmallCircle rsquor Proportion Eogon vDash tdot capcap rsqb
    dscr VerticalLine Supset lbrack kgreen Scy zscr NJcy scy NotExists csupe
    hkswarow boxHD Ecy gsim dzcy vellip Mopf LeftUpTeeVector lfisht andv Gammad
    OpenCurlyQuote blk12 rdsh lopf tfr emsp13 cemptyv erarr boxVl boxhu Efr nvle
    thicksim imped SOFTcy bepsi Barv drbkarow ruluhar ogon imagpart drcorn
    laemptyv zigrarr ascr nearrow cylcty Ocy prE cuesc UnderParenthesis it ast
    Gcirc profline OverBrace RightUpVector blacktriangleleft vartriangleleft Hat
    bigodot rbbrk Jcirc Sqrt Jukcy nrtri looparrowleft nge eqcolon AMP Product
    sqsubseteq compfn HumpEqual RightUpTeeVector bumpe NotPrecedesEqual
    curlyeqprec demptyv odblac Dot rdca Afr xsqcup rightleftharpoons
    OpenCurlyDoubleQuote sfrown varsubsetneqq rharu circlearrowright breve
    wedbar kscr TildeTilde GreaterLess niv scedil Jopf oast RightFloor Vdash
    ljcy SubsetEqual Bumpeq qint therefore simdot bigsqcup utri MediumSpace
    looparrowright vBar timesd fflig par vnsub ntlg squarf Iopf LeftUpVectorBar
    LessGreater Tcedil umacr Hscr dtri LongRightArrow midast ycy ENG Dscr ltcc
    nrarr SupersetEqual RightArrowLeftArrow scnE ntriangleright nwarhk kcedil
    dtdot daleth udblac GreaterGreater NotElement Or leftrightarrows boxUL
    vangrt lcub tbrk ucy otimesas wp sung sqcaps succapprox ropf nlsim Yopf
    boxHd udarr frac78 blacksquare rightsquigarrow Scedil xnis smt squf Popf GT
    rmoust NotGreater xfr hyphen LeftTeeVector ltimes Lacute nsubE lvertneqq
    rlarr lsime gtrless rfisht ape iscr nspar Superset subnE UpperRightArrow
    questeq hamilt LowerRightArrow sqsupseteq rcaron VerticalBar nGtv tscy
    Odblac DownLeftVectorBar pm llcorner notnivc emacr VerticalSeparator Udblac
    DownRightTeeVector isinE notni omid vartriangleright NotTildeTilde topbot
    rightharpoonup subne itilde tprime EmptyVerySmallSquare Vopf
    ReverseEquilibrium edot latail xrarr iiota afr af rppolint qfr Poincareplane
    gacute Colone Kopf dwangle gneq nvap vdash Cross subsim epsiv nis ncaron
    Uring Sc qscr rotimes nhArr Leftarrow Aopf SHCHcy LeftAngleBracket rarrfs
    Zcaron xhArr horbar DownLeftRightVector supplus gEl Ubreve hookrightarrow
    sqsup copysr intcal LongLeftRightArrow prsim DiacriticalDoubleAcute rpar
    fscr lAarr nVdash bsolhsub tcaron spadesuit utrif sharp bullet Bscr AMP
    maltese num xotime pitchfork bigotimes ReverseElement bne cwconint
    leftharpoondown ccupssm plustwo FilledVerySmallSquare lesseqgtr IJlig
    nwarrow Kcy orslope bbrktbrk setmn leq frac38 Ccirc NotLeftTriangleBar
    ulcorner succnsim glj Sscr cuvee fallingdotseq TripleDot Tstrok CircleDot
    Dcy boxHu nGt vert Uarrocir uplus ReverseUpEquilibrium parsl cirfnint
    plusacir bigcup Pr boxVr curarr rHar ngtr langd preceq RightUpVectorBar jscr
    nsucceq lesges gbreve SquareSuperset sstarf bsolb ldquor NotSucceedsTilde
    angmsdae RightDownVector rangle lap isinsv eqslantless lltri
    NotGreaterGreater boxtimes utdot varkappa upuparrows bigvee capcup
    NotReverseElement Union telrec angmsdah lesdotor ratio nless lneq
    precnapprox NonBreakingSpace easter lozenge ltrie gne urcorn nlt harrcir
    rcedil NotCupCap nacute vscr Backslash grave supsetneq LeftRightVector
    NotSquareSubset ccirc frac15 Int nRightarrow ufisht frac58 loang Ycirc
    nsimeq RightTriangle DoubleDownArrow orderof numsp supsim duhar ctdot lparlt
    lnap order boxDR tint minusd female Cedilla DoubleDot bnot Fscr DotEqual
    ubrcy nshortparallel PartialD nsqsupe gtdot Amacr xscr UpperLeftArrow Gfr
    apE race NotHumpEqual Hcirc popf elinters lBarr planck gl eopf toea
    straightepsilon dbkarow ecolon shortparallel scsim LongLeftArrow uring sfr
    bumpeq eqcirc Precedes precapprox nles simplus RBarr yicy Cap HumpDownHump
    nparallel softcy sqsubset Lstrok rightthreetimes xcap Utilde seswar
    NegativeMediumSpace dHar supmult Oscr nang tscr doublebarwedge lbrace ccaron
    NotSquareSuperset scnap hoarr lesseqqgtr ulcrop map kappav prcue TScy Racute
    intprod dd awint lscr Mfr aleph CapitalDifferentialD searr Gcy lowbar in
    LessSlantEqual colone nvlt Larr twoheadrightarrow supseteqq subsub
    trianglerighteq drcrop els ltlarr rarrc nvsim napE cularrp thkap
    varsubsetneq percnt DownLeftVector njcy mumap malt intercal plusb
    HilbertSpace Zfr phmmat sce lsqb lesssim integers NestedLessLess ange udhar
    PrecedesEqual gscr gesdoto angmsdab propto angst nequiv RightVectorBar KHcy
    Pfr OverBar DoubleLeftRightArrow CupCap Uopf Im REG frown subrarr YIcy
    varrho nsqsube lsim COPY nsupE Pcy ccups Therefore measuredangle UpTeeArrow
    nprec lescc raemptyv NotSucceedsSlantEqual bottom lstrok cupcup
    UpArrowDownArrow RightAngleBracket diam tcedil blk34 loarr lg DDotrahd
    rarrhk Qfr ges nvinfin fcy efr GreaterTilde hfr DownArrowUpArrow rbrke
    Vvdash downharpoonright SquareIntersection divideontimes Tscr DownArrowBar
    Longleftrightarrow boxv boxhU zcy apacir lnapprox DZcy RightTeeVector isinv
    heartsuit QUOT leftthreetimes nhpar jcy sol Not siml dash jukcy lpar ap
    supedot oror yopf bigtriangledown jfr triangleleft shcy thickapprox succ
    rdldhar blk14 xcirc minusb subedot ngeq Xopf NotSubsetEqual Cayleys cudarrl
    congdot Gcedil rightleftarrows trie realpart nvHarr nwArr Uparrow npart nGg
    dlcorn asympeq Vdashl Lmidot qprime Eopf Yfr equivDD hksearow primes mlcp
    uharr rAarr sime rect LessEqualGreater Bopf seArr ngsim ncong DoubleRightTee
    swarr omacr Sum coloneq nsupseteqq Zscr smile vnsup diamond angrt lbrke
    rtrif angmsdad notinvb biguplus varsigma fjlig hookleftarrow searhk pr eg
    ShortRightArrow exponentiale imagline bfr frac23 RuleDelayed triangledown
    dcy prnap osol orarr nmid cfr mDDot precnsim leftharpoonup nexist gesdotol
    lbrksld RightDoubleBracket Proportional varphi uHar smte NoBreak
    NotLessSlantEqual mstpos supsetneqq Nacute plusdu boxbox ldca nisd rarrpl
    boxVH nedot rbrksld gtrsim lbbrk NotGreaterSlantEqual NotRightTriangle
    ecaron lmoustache Iukcy napid gvnE ExponentialE Sacute rtimes DiacriticalDot
    checkmark gg nshortmid nLl/;

sub init {
    my($class, $lint) = @_;
    $class->SUPER::init($lint => +{
        rule => +{
            'elem-unknown' => sub {
                my $param = shift;
                return 1 if $html5_tag{$param->{tag}};
                return 0;
            },
            'attr-unknown' => sub {
                my $param = shift;
                return 1 if $html5_global_attr{$param->{attr}};
                return 1 if $html5_attr{$param->{tag}}{$param->{attr}};
                return 1 if any { $param->{attr} =~ $_ } @html5_global_user_attr;
                return 0;
            },
            'text-unknown-entity' => sub {
                my $param = shift;
                return 1 if $html5_entity{$param->{entity}};
                return 0;
            },
        }
    });
}

1;
__END__

=head1 NAME

HTML::Lint::Pluggable::HTML5 - allow HTML5 tags and attributes.

=head1 VERSION

This document describes HTML::Lint::Pluggable::HTML5 version 0.08.

=head1 DEPENDENCIES

Perl 5.8.1 or later.

=head1 BUGS

All complex software has bugs lurking in it, and this module is no
exception. If you find a bug please either email me, or add the bug
to cpan-RT.

=head1 SEE ALSO

L<perl>

=head1 AUTHOR

Kenta Sato E<lt>karupa@cpan.orgE<gt>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2012, Kenta Sato. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
