# NAME

Bash::Completion::Plugins::VimTag - Bash completion plugin for vim tags

# DESCRIPTION

This is a [Bash::Completion](http://search.cpan.org/perldoc?Bash::Completion) plugin that can complete on tags
generated by `ctags`. My setup places all `tags` files from
different projects in a `~/.ctagsdir` directory so vim can know about
them regardless of the current directory:

    ~/.ctagsdir
    ├── project1
    │   └── tags
    ├── project2
    │   └── tags
    └── perlbrew
        └── tags

My <.vimrc> then contains:

    set tags+=~/.ctagsdir/*/tags

And <.bashrc> contains:

    alias vit='vi -t'

If you keep your tags in a different directory - for example, your
main repository directory -, you can set the `CTAGSDIR` environment
variable to that directory and this plugin will scan the `tags` files
in that directory.

The reason for the `perlbrew/tags` file shown in the tree above is
that I want to have tags for all installed modules, so I generate them
with:

    find $PERLBREW_ROOT/perls/$PERLBREW_PERL/lib -name \*.pm | \
        ctags -f ~/.ctagsdir/perlbrew/tags --recurse --languages=Perl -L -;
