
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'Template::Toolkit with automatic filtering',
  'AUTHOR' => 'Christian Walde <walde.christian@googlemail.com>',
  'BUILD_REQUIRES' => {
    'Test::More' => '0',
    'Test::Most' => '0',
    'Test::Simple' => '0.96'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'Template-AutoFilter',
  'EXE_FILES' => [],
  'LICENSE' => 'unrestricted',
  'NAME' => 'Template::AutoFilter',
  'PREREQ_PM' => {
    'Template' => '0',
    'Template::Parser' => '0'
  },
  'VERSION' => '0.110030',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



