# Generated by default/object.tt
package Paws::Lightsail::CacheBehaviorPerPath;
  use Moose;
  has Behavior => (is => 'ro', isa => 'Str', request_name => 'behavior', traits => ['NameInRequest']);
  has Path => (is => 'ro', isa => 'Str', request_name => 'path', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::CacheBehaviorPerPath

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::CacheBehaviorPerPath object:

  $service_obj->Method(Att1 => { Behavior => $value, ..., Path => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::CacheBehaviorPerPath object:

  $result = $service_obj->Method(...);
  $result->Att1->Behavior

=head1 DESCRIPTION

Describes the per-path cache behavior of an Amazon Lightsail content
delivery network (CDN) distribution.

A per-path cache behavior is used to override, or add an exception to,
the default cache behavior of a distribution. For example, if the
C<cacheBehavior> is set to C<cache>, then a per-path cache behavior can
be used to specify a directory, file, or file type that your
distribution will cache. Alternately, if the distribution's
C<cacheBehavior> is C<dont-cache>, then a per-path cache behavior can
be used to specify a directory, file, or file type that your
distribution will not cache.

if the cacheBehavior's behavior is set to 'cache', then

=head1 ATTRIBUTES


=head2 Behavior => Str

The cache behavior for the specified path.

You can specify one of the following per-path cache behaviors:

=over

=item *

B<C<cache> > - This behavior caches the specified path.

=item *

B<C<dont-cache> > - This behavior doesn't cache the specified path.

=back



=head2 Path => Str

The path to a directory or file to cached, or not cache. Use an
asterisk symbol to specify wildcard directories (C<path/to/assets/*>),
and file types (C<*.html, *jpg, *js>). Directories and file paths are
case-sensitive.

Examples:

=over

=item *

Specify the following to cache all files in the document root of an
Apache web server running on a Lightsail instance.

C<var/www/html/>

=item *

Specify the following file to cache only the index page in the document
root of an Apache web server.

C<var/www/html/index.html>

=item *

Specify the following to cache only the .html files in the document
root of an Apache web server.

C<var/www/html/*.html>

=item *

Specify the following to cache only the .jpg, .png, and .gif files in
the images sub-directory of the document root of an Apache web server.

C<var/www/html/images/*.jpg>

C<var/www/html/images/*.png>

C<var/www/html/images/*.gif>

Specify the following to cache all files in the images sub-directory of
the document root of an Apache web server.

C<var/www/html/images/>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

