# Generated by default/object.tt
package Paws::MediaConvert::MxfXavcProfileSettings;
  use Moose;
  has DurationMode => (is => 'ro', isa => 'Str', request_name => 'durationMode', traits => ['NameInRequest']);
  has MaxAncDataSize => (is => 'ro', isa => 'Int', request_name => 'maxAncDataSize', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::MxfXavcProfileSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::MxfXavcProfileSettings object:

  $service_obj->Method(Att1 => { DurationMode => $value, ..., MaxAncDataSize => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::MxfXavcProfileSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->DurationMode

=head1 DESCRIPTION

Specify the XAVC profile settings for MXF outputs when you set your MXF
profile to XAVC.

=head1 ATTRIBUTES


=head2 DurationMode => Str

To create an output that complies with the XAVC file format guidelines
for interoperability, keep the default value, Drop frames for
compliance (DROP_FRAMES_FOR_COMPLIANCE). To include all frames from
your input in this output, keep the default setting, Allow any duration
(ALLOW_ANY_DURATION). The number of frames that MediaConvert excludes
when you set this to Drop frames for compliance depends on the output
frame rate and duration.


=head2 MaxAncDataSize => Int

Specify a value for this setting only for outputs that you set up with
one of these two XAVC profiles: XAVC HD Intra CBG (XAVC_HD_INTRA_CBG)
or XAVC 4K Intra CBG (XAVC_4K_INTRA_CBG). Specify the amount of space
in each frame that the service reserves for ancillary data, such as
teletext captions. The default value for this setting is 1492 bytes per
frame. This should be sufficient to prevent overflow unless you have
multiple pages of teletext captions data. If you have a large amount of
teletext data, specify a larger number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

