/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.Transferable;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class Attachment
implements Transferable {
    private DataHandler handler;
    private MultivaluedMap<String, String> headers = new MetadataMap<String, String>(false, true);
    private Object object;
    private Providers providers;

    public Attachment(org.apache.cxf.message.Attachment a, Providers providers) {
        this.handler = a.getDataHandler();
        Iterator<String> i = a.getHeaderNames();
        while (i.hasNext()) {
            String name = i.next();
            if ("Content-ID".equalsIgnoreCase(name)) continue;
            this.headers.add(name, a.getHeader(name));
        }
        this.headers.putSingle("Content-ID", a.getId());
        this.providers = providers;
    }

    public Attachment(String id, DataHandler dh, MultivaluedMap<String, String> headers) {
        this.handler = dh;
        this.headers = new MetadataMap<String, String>(headers, false, true);
        this.headers.putSingle("Content-ID", id);
    }

    public Attachment(String id, DataSource ds, MultivaluedMap<String, String> headers) {
        this(id, new DataHandler(ds), headers);
    }

    public Attachment(MultivaluedMap<String, String> headers, Object object) {
        this.headers = headers;
        this.object = object;
    }

    public Attachment(InputStream is, MultivaluedMap<String, String> headers) {
        this(headers.getFirst("Content-ID"), new DataHandler(new InputStreamDataSource(is, headers.getFirst("Content-Type"))), headers);
    }

    public Attachment(String mediaType, Object object) {
        this(UUID.randomUUID().toString(), mediaType, object);
    }

    public Attachment(String id, String mediaType, Object object) {
        this.object = object;
        if (id != null) {
            this.headers.putSingle("Content-ID", id);
        }
        this.headers.putSingle("Content-Type", mediaType);
    }

    public Attachment(String id, InputStream is, ContentDisposition cd) {
        this.handler = new DataHandler(new InputStreamDataSource(is, "application/octet-stream"));
        if (cd != null) {
            this.headers.putSingle("Content-Disposition", cd.toString());
        }
        this.headers.putSingle("Content-ID", id);
        this.headers.putSingle("Content-Type", "application/octet-stream");
    }

    public Attachment(MultivaluedMap<String, String> headers, DataHandler handler, Object object) {
        this.headers = headers;
        this.handler = handler;
        this.object = object;
    }

    public ContentDisposition getContentDisposition() {
        String header = this.getHeader("Content-Disposition");
        return header == null ? null : new ContentDisposition(header);
    }

    public String getContentId() {
        return this.headers.getFirst("Content-ID");
    }

    public MediaType getContentType() {
        String value = this.handler != null && this.handler.getContentType() != null ? this.handler.getContentType() : this.headers.getFirst("Content-Type");
        return value == null ? MediaType.TEXT_PLAIN_TYPE : JAXRSUtils.toMediaType(value);
    }

    public DataHandler getDataHandler() {
        return this.handler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    public Object getObject() {
        return this.object;
    }

    public <T> T getObject(Class<T> cls) {
        MessageBodyReader<T> mbr;
        if (this.providers != null && (mbr = this.providers.getMessageBodyReader(cls, cls, new Annotation[0], this.getContentType())) != null) {
            try {
                return mbr.readFrom(cls, cls, new Annotation[0], this.getContentType(), this.headers, this.getDataHandler().getInputStream());
            }
            catch (Exception ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
        }
        return null;
    }

    public String getHeader(String name) {
        List header = (List)this.headers.get(name);
        if (header == null || header.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < header.size(); ++i) {
            sb.append((String)header.get(i));
            if (i + 1 >= header.size()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public List<String> getHeaderAsList(String name) {
        return (List)this.headers.get(name);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return new MetadataMap<String, String>(this.headers, false, true);
    }

    @Override
    public void transferTo(File destinationFile) throws IOException {
        IOUtils.transferTo(this.handler.getInputStream(), destinationFile);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        return this.headers.equals(other.headers);
    }
}

