/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector.charsets;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ReplacementCharset
extends Charset {
    public ReplacementCharset() {
        super("replacement", null);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.equals(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoder(this, Float.MIN_VALUE, 1.0f){
            private boolean replacementErrorReturned;
            {
                this.replacementErrorReturned = false;
            }

            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                if (in.hasRemaining() && !this.replacementErrorReturned) {
                    this.replacementErrorReturned = true;
                    return CoderResult.malformedForLength(in.remaining());
                }
                in.position(in.limit());
                return CoderResult.UNDERFLOW;
            }

            @Override
            protected void implReset() {
                this.replacementErrorReturned = false;
            }
        };
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException("This charset does not support encoding");
    }
}

