/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.server.ServerStatus;
import org.apache.tika.server.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/detect")
public class DetectorResource {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorResource.class);
    private final ServerStatus serverStatus;

    public DetectorResource(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @PUT
    @Path(value="stream")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String detect(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata met = new Metadata();
        TikaInputStream tis = TikaInputStream.get(TikaResource.getInputStream(is, httpHeaders));
        String filename = TikaResource.detectFilename(httpHeaders.getRequestHeaders());
        LOG.info("Detecting media type for Filename: {}", (Object)filename);
        met.add("resourceName", filename);
        TikaResource.checkIsOperating();
        long taskId = this.serverStatus.start(ServerStatus.TASK.DETECT, filename);
        try {
            String string = TikaResource.getConfig().getDetector().detect(tis, met).toString();
            return string;
        }
        catch (IOException e) {
            LOG.warn("Unable to detect MIME type for file. Reason: {}", (Object)e.getMessage(), (Object)e);
            String string = MediaType.OCTET_STREAM.toString();
            return string;
        }
        catch (OutOfMemoryError e) {
            this.serverStatus.setStatus(ServerStatus.STATUS.ERROR);
            throw e;
        }
        finally {
            this.serverStatus.complete(taskId);
        }
    }
}

