/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.langdetect.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.server.ServerStatus;
import org.apache.tika.server.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/translate")
public class TranslateResource {
    private Translator defaultTranslator;
    private ServiceLoader loader = new ServiceLoader(ServiceLoader.class.getClassLoader(), LoadErrorHandler.WARN);
    private static final Logger LOG = LoggerFactory.getLogger(TranslateResource.class);
    private final ServerStatus serverStatus;

    public TranslateResource(ServerStatus serverStatus) {
        this.defaultTranslator = TikaResource.getConfig().getTranslator();
        this.serverStatus = serverStatus;
    }

    @PUT
    @POST
    @Path(value="/all/{translator}/{src}/{dest}")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String translate(InputStream is, @PathParam(value="translator") String translator, @PathParam(value="src") String sLang, @PathParam(value="dest") String dLang) throws TikaException, IOException {
        return this.doTranslate(IOUtils.toString(is, StandardCharsets.UTF_8), translator, sLang, dLang);
    }

    @PUT
    @POST
    @Path(value="/all/{translator}/{dest}")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String autoTranslate(InputStream is, @PathParam(value="translator") String translator, @PathParam(value="dest") String dLang) throws TikaException, IOException {
        String content = IOUtils.toString(is, StandardCharsets.UTF_8);
        LanguageResult language = new OptimaizeLangDetector().loadModels().detect(content);
        if (language.isUnknown()) {
            throw new TikaException("Unable to detect language to use for translation of text");
        }
        String sLang = language.getLanguage();
        LOG.info("LanguageIdentifier: detected source lang: [{}]", (Object)sLang);
        return this.doTranslate(content, translator, sLang, dLang);
    }

    private String doTranslate(String content, String translator, String sLang, String dLang) throws TikaException, IOException {
        LOG.info("Using translator: [{}]: src: [{}]: dest: [{}]", translator, sLang, dLang);
        Translator translate = this.byClassName(translator);
        if (translate == null) {
            translate = this.defaultTranslator;
            LOG.info("Using default translator");
        }
        TikaResource.checkIsOperating();
        long taskId = this.serverStatus.start(ServerStatus.TASK.TRANSLATE, null);
        try {
            String string = translate.translate(content, sLang, dLang);
            return string;
        }
        catch (OutOfMemoryError e) {
            this.serverStatus.setStatus(ServerStatus.STATUS.ERROR);
            throw e;
        }
        finally {
            this.serverStatus.complete(taskId);
        }
    }

    private Translator byClassName(String className) {
        List<Translator> translators = this.loader.loadStaticServiceProviders(Translator.class);
        for (Translator t : translators) {
            if (!t.getClass().getName().equals(className)) continue;
            return t;
        }
        return null;
    }
}

