/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeLeaf;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.SimpleTreeFactory;
import edu.stanford.nlp.trees.Tree;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledScoredTreeFactory
extends SimpleTreeFactory {
    private LabelFactory lf;

    public LabeledScoredTreeFactory() {
        this(StringLabel.factory());
    }

    public LabeledScoredTreeFactory(LabelFactory lf) {
        this.lf = lf;
    }

    @Override
    public Tree newLeaf(String word) {
        return this.newLeaf(this.lf.newLabel(word));
    }

    @Override
    public Tree newLeaf(Label label) {
        return new LabeledScoredTreeLeaf(label);
    }

    @Override
    public Tree newTreeNode(String parent, List<Tree> children) {
        return this.newTreeNode(this.lf.newLabel(parent), children);
    }

    @Override
    public Tree newTreeNode(Label parentLabel, List<Tree> children) {
        return new LabeledScoredTreeNode(parentLabel, children);
    }
}

