# Generated by default/object.tt
package Paws::Honeycode::UpdateRowData;
  use Moose;
  has CellsToUpdate => (is => 'ro', isa => 'Paws::Honeycode::RowDataInput', request_name => 'cellsToUpdate', traits => ['NameInRequest'], required => 1);
  has RowId => (is => 'ro', isa => 'Str', request_name => 'rowId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::UpdateRowData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::UpdateRowData object:

  $service_obj->Method(Att1 => { CellsToUpdate => $value, ..., RowId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::UpdateRowData object:

  $result = $service_obj->Method(...);
  $result->Att1->CellsToUpdate

=head1 DESCRIPTION

Data needed to create a single row in a table as part of the
BatchCreateTableRows request.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CellsToUpdate => L<Paws::Honeycode::RowDataInput>

A map representing the cells to update in the given row. The key is the
column id of the cell and the value is the CellInput object that
represents the data to set in that cell.


=head2 B<REQUIRED> RowId => Str

The id of the row that needs to be updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

