# Generated by default/object.tt
package Paws::Kafka::ClusterOperationStep;
  use Moose;
  has StepInfo => (is => 'ro', isa => 'Paws::Kafka::ClusterOperationStepInfo', request_name => 'stepInfo', traits => ['NameInRequest']);
  has StepName => (is => 'ro', isa => 'Str', request_name => 'stepName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kafka::ClusterOperationStep

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kafka::ClusterOperationStep object:

  $service_obj->Method(Att1 => { StepInfo => $value, ..., StepName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kafka::ClusterOperationStep object:

  $result = $service_obj->Method(...);
  $result->Att1->StepInfo

=head1 DESCRIPTION

Step taken during a cluster operation.

=head1 ATTRIBUTES


=head2 StepInfo => L<Paws::Kafka::ClusterOperationStepInfo>

Information about the step and its status.


=head2 StepName => Str

The name of the step.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kafka>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

