/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomEmbededSystem;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleStripeSimpleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeTable;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CreoleParser {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = iSkinSimple;
        this.horizontalAlignment = horizontalAlignment;
    }

    private Stripe createStripe(String string, CreoleContext creoleContext, Stripe stripe) {
        if (stripe instanceof StripeTable && string.startsWith("|") && string.endsWith("|")) {
            StripeTable stripeTable = (StripeTable)stripe;
            stripeTable.analyzeAndAddNormal(string);
            return null;
        }
        if (string.startsWith("|=") && string.endsWith("|")) {
            return new StripeTable(this.fontConfiguration, this.skinParam, string);
        }
        return new CreoleStripeSimpleParser(string, creoleContext, this.fontConfiguration, this.skinParam).createStripe(creoleContext);
    }

    public Sheet createSheet(Display display) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (display != null) {
            CreoleContext creoleContext = new CreoleContext();
            for (CharSequence charSequence : display) {
                Stripe stripe;
                if (charSequence instanceof EmbededDiagram) {
                    final AtomEmbededSystem atomEmbededSystem = new AtomEmbededSystem((EmbededDiagram)charSequence);
                    stripe = new Stripe(){

                        @Override
                        public List<Atom> getAtoms() {
                            return Arrays.asList(atomEmbededSystem);
                        }
                    };
                } else {
                    stripe = this.createStripe(((Object)charSequence).toString(), creoleContext, sheet.getLastStripe());
                }
                if (stripe == null) continue;
                sheet.add(stripe);
            }
        }
        return sheet;
    }
}

