package Number::MuPhone::Parser::EG;
use Moo;

extends 'Number::MuPhone::Parser';

has '+country'                    => ( default => 'EG'    );
has '+country_code'               => ( default => '20'    );
has '+country_name'               => ( default => 'Egypt' );
has '+_national_dial_prefix'      => ( default => '0'     );
has '+_international_dial_prefix' => ( default => '00'    );

# format the number for display
# also used as a core validator - if it can't be formatted,
# set an error here
sub _format_number {
  my $self = shift;
  my $num = $self->_cleaned_number;

  # cribbed from:
  #   https://en.wikipedia.org/wiki/Telephone_numbers_in_Egypt

     # 2 (Cairo) 3 (Alexandria)
     $num =~ s/^[23](\d{3})(\d{4})$/$1 $2 $3/

     
  or $num =~ s/

}

1;

List of area codes
Area/City	Area Code	Area/City	Area Code
Greater Cairo (Cairo, Giza, and part of Qalyubia)	2	Alexandria	3
Arish	68
Assiut	88
Aswan	97
Banha	13
Beni Suef	82
Damanhur	45
Damiette	57
Fayoum	842
Ismailia	64
Kafr El Sheikh	47
Luxor	95
Marsa Matruh	46
Mansoura	50
Minya	86
Monufia	48
New Valley	92
Port Said	66
Qena	96
Red Sea	65
Sohag	93
Suez	62
Tanta	40
El Tor	69
Zagazig	55
10th of Ramadan	554
Qalyubia	13


Mobile - 10 / 11 / 12 / 15
